// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/legacy-fine-tuning/hyperparameters) for more details.
    /// </summary>
    internal class FineTune_hyperparams : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The batch size to use for training. The batch size is the number oftraining examples used to train a single forward and backward pass.</summary>
        public int? BatchSize { get; set; }
        /// <summary>The number of classes to use for computing classification metrics.</summary>
        public int? ClassificationNClasses { get; set; }
        /// <summary>The positive class to use for computing classification metrics.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? ClassificationPositiveClass { get; set; }
#nullable restore
#else
        public string ClassificationPositiveClass { get; set; }
#endif
        /// <summary>The classification metrics to compute using the validation dataset at the end of every epoch.</summary>
        public bool? ComputeClassificationMetrics { get; set; }
        /// <summary>The learning rate multiplier to use for training.</summary>
        public double? LearningRateMultiplier { get; set; }
        /// <summary>The number of epochs to train the model for. An epoch refers to onefull cycle through the training dataset.</summary>
        public int? NEpochs { get; set; }
        /// <summary>The weight to use for loss on the prompt tokens.</summary>
        public double? PromptLossWeight { get; set; }
        /// <summary>
        /// Instantiates a new FineTune_hyperparams and sets the default values.
        /// </summary>
        public FineTune_hyperparams() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static FineTune_hyperparams CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new FineTune_hyperparams();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"batch_size", n => { BatchSize = n.GetIntValue(); } },
                {"classification_n_classes", n => { ClassificationNClasses = n.GetIntValue(); } },
                {"classification_positive_class", n => { ClassificationPositiveClass = n.GetStringValue(); } },
                {"compute_classification_metrics", n => { ComputeClassificationMetrics = n.GetBoolValue(); } },
                {"learning_rate_multiplier", n => { LearningRateMultiplier = n.GetDoubleValue(); } },
                {"n_epochs", n => { NEpochs = n.GetIntValue(); } },
                {"prompt_loss_weight", n => { PromptLossWeight = n.GetDoubleValue(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteIntValue("batch_size", BatchSize);
            writer.WriteIntValue("classification_n_classes", ClassificationNClasses);
            writer.WriteStringValue("classification_positive_class", ClassificationPositiveClass);
            writer.WriteBoolValue("compute_classification_metrics", ComputeClassificationMetrics);
            writer.WriteDoubleValue("learning_rate_multiplier", LearningRateMultiplier);
            writer.WriteIntValue("n_epochs", NEpochs);
            writer.WriteDoubleValue("prompt_loss_weight", PromptLossWeight);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

