// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// The `FineTune` object represents a legacy fine-tune job that has been created through the API.
    /// </summary>
    [Obsolete("")]
    internal class FineTune : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The Unix timestamp (in seconds) for when the fine-tuning job was created.</summary>
        public int? CreatedAt { get; set; }
        /// <summary>The list of events that have been observed in the lifecycle of the FineTune job.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<FineTuneEvent>? Events { get; set; }
#nullable restore
#else
        public List<FineTuneEvent> Events { get; set; }
#endif
        /// <summary>The name of the fine-tuned model that is being created.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? FineTunedModel { get; set; }
#nullable restore
#else
        public string FineTunedModel { get; set; }
#endif
        /// <summary>The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/legacy-fine-tuning/hyperparameters) for more details.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public FineTune_hyperparams? Hyperparams { get; set; }
#nullable restore
#else
        public FineTune_hyperparams Hyperparams { get; set; }
#endif
        /// <summary>The object identifier, which can be referenced in the API endpoints.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Id { get; set; }
#nullable restore
#else
        public string Id { get; set; }
#endif
        /// <summary>The base model that is being fine-tuned.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Model { get; set; }
#nullable restore
#else
        public string Model { get; set; }
#endif
        /// <summary>The object type, which is always &quot;fine-tune&quot;.</summary>
        public FineTune_object? Object { get; set; }
        /// <summary>The organization that owns the fine-tuning job.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? OrganizationId { get; set; }
#nullable restore
#else
        public string OrganizationId { get; set; }
#endif
        /// <summary>The compiled results files for the fine-tuning job.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<OpenAIFile>? ResultFiles { get; set; }
#nullable restore
#else
        public List<OpenAIFile> ResultFiles { get; set; }
#endif
        /// <summary>The current status of the fine-tuning job, which can be either `created`, `running`, `succeeded`, `failed`, or `cancelled`.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Status { get; set; }
#nullable restore
#else
        public string Status { get; set; }
#endif
        /// <summary>The list of files used for training.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<OpenAIFile>? TrainingFiles { get; set; }
#nullable restore
#else
        public List<OpenAIFile> TrainingFiles { get; set; }
#endif
        /// <summary>The Unix timestamp (in seconds) for when the fine-tuning job was last updated.</summary>
        public int? UpdatedAt { get; set; }
        /// <summary>The list of files used for validation.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<OpenAIFile>? ValidationFiles { get; set; }
#nullable restore
#else
        public List<OpenAIFile> ValidationFiles { get; set; }
#endif
        /// <summary>
        /// Instantiates a new FineTune and sets the default values.
        /// </summary>
        public FineTune() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static FineTune CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new FineTune();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"created_at", n => { CreatedAt = n.GetIntValue(); } },
                {"events", n => { Events = n.GetCollectionOfObjectValues<FineTuneEvent>(FineTuneEvent.CreateFromDiscriminatorValue)?.ToList(); } },
                {"fine_tuned_model", n => { FineTunedModel = n.GetStringValue(); } },
                {"hyperparams", n => { Hyperparams = n.GetObjectValue<FineTune_hyperparams>(FineTune_hyperparams.CreateFromDiscriminatorValue); } },
                {"id", n => { Id = n.GetStringValue(); } },
                {"model", n => { Model = n.GetStringValue(); } },
                {"object", n => { Object = n.GetEnumValue<FineTune_object>(); } },
                {"organization_id", n => { OrganizationId = n.GetStringValue(); } },
                {"result_files", n => { ResultFiles = n.GetCollectionOfObjectValues<OpenAIFile>(OpenAIFile.CreateFromDiscriminatorValue)?.ToList(); } },
                {"status", n => { Status = n.GetStringValue(); } },
                {"training_files", n => { TrainingFiles = n.GetCollectionOfObjectValues<OpenAIFile>(OpenAIFile.CreateFromDiscriminatorValue)?.ToList(); } },
                {"updated_at", n => { UpdatedAt = n.GetIntValue(); } },
                {"validation_files", n => { ValidationFiles = n.GetCollectionOfObjectValues<OpenAIFile>(OpenAIFile.CreateFromDiscriminatorValue)?.ToList(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteIntValue("created_at", CreatedAt);
            writer.WriteCollectionOfObjectValues<FineTuneEvent>("events", Events);
            writer.WriteStringValue("fine_tuned_model", FineTunedModel);
            writer.WriteObjectValue<FineTune_hyperparams>("hyperparams", Hyperparams);
            writer.WriteStringValue("id", Id);
            writer.WriteStringValue("model", Model);
            writer.WriteEnumValue<FineTune_object>("object", Object);
            writer.WriteStringValue("organization_id", OrganizationId);
            writer.WriteCollectionOfObjectValues<OpenAIFile>("result_files", ResultFiles);
            writer.WriteStringValue("status", Status);
            writer.WriteCollectionOfObjectValues<OpenAIFile>("training_files", TrainingFiles);
            writer.WriteIntValue("updated_at", UpdatedAt);
            writer.WriteCollectionOfObjectValues<OpenAIFile>("validation_files", ValidationFiles);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

