// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// Represents an embedding vector returned by embedding endpoint.
    /// </summary>
    internal class Embedding : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The embedding vector, which is a list of floats. The length of vector depends on the model as listed in the [embedding guide](/docs/guides/embeddings).</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<double?>? EmbeddingProp { get; set; }
#nullable restore
#else
        public List<double?> EmbeddingProp { get; set; }
#endif
        /// <summary>The index of the embedding in the list of embeddings.</summary>
        public int? Index { get; set; }
        /// <summary>The object type, which is always &quot;embedding&quot;.</summary>
        public Embedding_object? Object { get; set; }
        /// <summary>
        /// Instantiates a new Embedding and sets the default values.
        /// </summary>
        public Embedding() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static Embedding CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new Embedding();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"embedding", n => { EmbeddingProp = n.GetCollectionOfPrimitiveValues<double?>()?.ToList(); } },
                {"index", n => { Index = n.GetIntValue(); } },
                {"object", n => { Object = n.GetEnumValue<Embedding_object>(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteCollectionOfPrimitiveValues<double?>("embedding", EmbeddingProp);
            writer.WriteIntValue("index", Index);
            writer.WriteEnumValue<Embedding_object>("object", Object);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

