// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    internal class CreateThreadAndRunRequest : IParsable {
        /// <summary>The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? AssistantId { get; set; }
#nullable restore
#else
        public string AssistantId { get; set; }
#endif
        /// <summary>Override the default system message of the assistant. This is useful for modifying the behavior on a per-run basis.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Instructions { get; set; }
#nullable restore
#else
        public string Instructions { get; set; }
#endif
        /// <summary>Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CreateThreadAndRunRequest_metadata? Metadata { get; set; }
#nullable restore
#else
        public CreateThreadAndRunRequest_metadata Metadata { get; set; }
#endif
        /// <summary>The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Model { get; set; }
#nullable restore
#else
        public string Model { get; set; }
#endif
        /// <summary>The thread property</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CreateThreadRequest? Thread { get; set; }
#nullable restore
#else
        public CreateThreadRequest Thread { get; set; }
#endif
        /// <summary>Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<CreateThreadAndRunRequest_tools>? Tools { get; set; }
#nullable restore
#else
        public List<CreateThreadAndRunRequest_tools> Tools { get; set; }
#endif
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static CreateThreadAndRunRequest CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new CreateThreadAndRunRequest();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"assistant_id", n => { AssistantId = n.GetStringValue(); } },
                {"instructions", n => { Instructions = n.GetStringValue(); } },
                {"metadata", n => { Metadata = n.GetObjectValue<CreateThreadAndRunRequest_metadata>(CreateThreadAndRunRequest_metadata.CreateFromDiscriminatorValue); } },
                {"model", n => { Model = n.GetStringValue(); } },
                {"thread", n => { Thread = n.GetObjectValue<CreateThreadRequest>(CreateThreadRequest.CreateFromDiscriminatorValue); } },
                {"tools", n => { Tools = n.GetCollectionOfObjectValues<CreateThreadAndRunRequest_tools>(CreateThreadAndRunRequest_tools.CreateFromDiscriminatorValue)?.ToList(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteStringValue("assistant_id", AssistantId);
            writer.WriteStringValue("instructions", Instructions);
            writer.WriteObjectValue<CreateThreadAndRunRequest_metadata>("metadata", Metadata);
            writer.WriteStringValue("model", Model);
            writer.WriteObjectValue<CreateThreadRequest>("thread", Thread);
            writer.WriteCollectionOfObjectValues<CreateThreadAndRunRequest_tools>("tools", Tools);
        }
        /// <summary>
        /// Composed type wrapper for classes AssistantToolsCode, AssistantToolsFunction, AssistantToolsRetrieval
        /// </summary>
        internal class CreateThreadAndRunRequest_tools : IComposedTypeWrapper, IParsable {
            /// <summary>Composed type representation for type AssistantToolsCode</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode? AssistantToolsCode { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode AssistantToolsCode { get; set; }
#endif
            /// <summary>Composed type representation for type AssistantToolsFunction</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction? AssistantToolsFunction { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction AssistantToolsFunction { get; set; }
#endif
            /// <summary>Composed type representation for type AssistantToolsRetrieval</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval? AssistantToolsRetrieval { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval AssistantToolsRetrieval { get; set; }
#endif
            /// <summary>
            /// Creates a new instance of the appropriate class based on discriminator value
            /// </summary>
            /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
            public static CreateThreadAndRunRequest_tools CreateFromDiscriminatorValue(IParseNode parseNode) {
                _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
                var mappingValue = parseNode.GetChildNode("")?.GetStringValue();
                var result = new CreateThreadAndRunRequest_tools();
                if("AssistantToolsCode".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.AssistantToolsCode = new OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode();
                }
                else if("AssistantToolsFunction".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.AssistantToolsFunction = new OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction();
                }
                else if("AssistantToolsRetrieval".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.AssistantToolsRetrieval = new OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval();
                }
                return result;
            }
            /// <summary>
            /// The deserialization information for the current model
            /// </summary>
            public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
                if(AssistantToolsCode != null) {
                    return AssistantToolsCode.GetFieldDeserializers();
                }
                else if(AssistantToolsFunction != null) {
                    return AssistantToolsFunction.GetFieldDeserializers();
                }
                else if(AssistantToolsRetrieval != null) {
                    return AssistantToolsRetrieval.GetFieldDeserializers();
                }
                return new Dictionary<string, Action<IParseNode>>();
            }
            /// <summary>
            /// Serializes information the current object
            /// </summary>
            /// <param name="writer">Serialization writer to use to serialize this model</param>
            public virtual void Serialize(ISerializationWriter writer) {
                _ = writer ?? throw new ArgumentNullException(nameof(writer));
                if(AssistantToolsCode != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode>(null, AssistantToolsCode);
                }
                else if(AssistantToolsFunction != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction>(null, AssistantToolsFunction);
                }
                else if(AssistantToolsRetrieval != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval>(null, AssistantToolsRetrieval);
                }
            }
        }
    }
}

