// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// A list of the categories, and whether they are flagged or not.
    /// </summary>
    internal class CreateModerationResponse_results_categories : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>Content that expresses, incites, or promotes harassing language towards any target.</summary>
        public bool? Harassment { get; set; }
        /// <summary>Harassment content that also includes violence or serious harm towards any target.</summary>
        public bool? HarassmentThreatening { get; set; }
        /// <summary>Content that expresses, incites, or promotes hate based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste. Hateful content aimed at non-protected groups (e.g., chess players) is harrassment.</summary>
        public bool? Hate { get; set; }
        /// <summary>Hateful content that also includes violence or serious harm towards the targeted group based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste.</summary>
        public bool? HateThreatening { get; set; }
        /// <summary>Content that promotes, encourages, or depicts acts of self-harm, such as suicide, cutting, and eating disorders.</summary>
        public bool? SelfHarm { get; set; }
        /// <summary>Content that encourages performing acts of self-harm, such as suicide, cutting, and eating disorders, or that gives instructions or advice on how to commit such acts.</summary>
        public bool? SelfHarmInstructions { get; set; }
        /// <summary>Content where the speaker expresses that they are engaging or intend to engage in acts of self-harm, such as suicide, cutting, and eating disorders.</summary>
        public bool? SelfHarmIntent { get; set; }
        /// <summary>Content meant to arouse sexual excitement, such as the description of sexual activity, or that promotes sexual services (excluding sex education and wellness).</summary>
        public bool? Sexual { get; set; }
        /// <summary>Sexual content that includes an individual who is under 18 years old.</summary>
        public bool? SexualMinors { get; set; }
        /// <summary>Content that depicts death, violence, or physical injury.</summary>
        public bool? Violence { get; set; }
        /// <summary>Content that depicts death, violence, or physical injury in graphic detail.</summary>
        public bool? ViolenceGraphic { get; set; }
        /// <summary>
        /// Instantiates a new CreateModerationResponse_results_categories and sets the default values.
        /// </summary>
        public CreateModerationResponse_results_categories() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static CreateModerationResponse_results_categories CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new CreateModerationResponse_results_categories();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"harassment", n => { Harassment = n.GetBoolValue(); } },
                {"harassment/threatening", n => { HarassmentThreatening = n.GetBoolValue(); } },
                {"hate", n => { Hate = n.GetBoolValue(); } },
                {"hate/threatening", n => { HateThreatening = n.GetBoolValue(); } },
                {"self-harm", n => { SelfHarm = n.GetBoolValue(); } },
                {"self-harm/instructions", n => { SelfHarmInstructions = n.GetBoolValue(); } },
                {"self-harm/intent", n => { SelfHarmIntent = n.GetBoolValue(); } },
                {"sexual", n => { Sexual = n.GetBoolValue(); } },
                {"sexual/minors", n => { SexualMinors = n.GetBoolValue(); } },
                {"violence", n => { Violence = n.GetBoolValue(); } },
                {"violence/graphic", n => { ViolenceGraphic = n.GetBoolValue(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteBoolValue("harassment", Harassment);
            writer.WriteBoolValue("harassment/threatening", HarassmentThreatening);
            writer.WriteBoolValue("hate", Hate);
            writer.WriteBoolValue("hate/threatening", HateThreatening);
            writer.WriteBoolValue("self-harm", SelfHarm);
            writer.WriteBoolValue("self-harm/instructions", SelfHarmInstructions);
            writer.WriteBoolValue("self-harm/intent", SelfHarmIntent);
            writer.WriteBoolValue("sexual", Sexual);
            writer.WriteBoolValue("sexual/minors", SexualMinors);
            writer.WriteBoolValue("violence", Violence);
            writer.WriteBoolValue("violence/graphic", ViolenceGraphic);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

