// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    internal class CreateImageRequest : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The model to use for image generation.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CreateImageRequest_model? Model { get; set; }
#nullable restore
#else
        public CreateImageRequest_model Model { get; set; }
#endif
        /// <summary>The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.</summary>
        public int? N { get; set; }
        /// <summary>A text description of the desired image(s). The maximum length is 1000 characters for `dall-e-2` and 4000 characters for `dall-e-3`.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Prompt { get; set; }
#nullable restore
#else
        public string Prompt { get; set; }
#endif
        /// <summary>The quality of the image that will be generated. `hd` creates images with finer details and greater consistency across the image. This param is only supported for `dall-e-3`.</summary>
        public CreateImageRequest_quality? Quality { get; set; }
        /// <summary>The format in which the generated images are returned. Must be one of `url` or `b64_json`.</summary>
        public CreateImageRequest_response_format? ResponseFormat { get; set; }
        /// <summary>The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`. Must be one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3` models.</summary>
        public CreateImageRequest_size? Size { get; set; }
        /// <summary>The style of the generated images. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for `dall-e-3`.</summary>
        public CreateImageRequest_style? Style { get; set; }
        /// <summary>A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? User { get; set; }
#nullable restore
#else
        public string User { get; set; }
#endif
        /// <summary>
        /// Instantiates a new CreateImageRequest and sets the default values.
        /// </summary>
        public CreateImageRequest() {
            AdditionalData = new Dictionary<string, object>();
            Quality = CreateImageRequest_quality.Standard;
            ResponseFormat = CreateImageRequest_response_format.Url;
            Size = CreateImageRequest_size.OneZeroTwoFourx1024;
            Style = CreateImageRequest_style.Vivid;
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static CreateImageRequest CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new CreateImageRequest();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"model", n => { Model = n.GetObjectValue<CreateImageRequest_model>(CreateImageRequest_model.CreateFromDiscriminatorValue); } },
                {"n", n => { N = n.GetIntValue(); } },
                {"prompt", n => { Prompt = n.GetStringValue(); } },
                {"quality", n => { Quality = n.GetEnumValue<CreateImageRequest_quality>(); } },
                {"response_format", n => { ResponseFormat = n.GetEnumValue<CreateImageRequest_response_format>(); } },
                {"size", n => { Size = n.GetEnumValue<CreateImageRequest_size>(); } },
                {"style", n => { Style = n.GetEnumValue<CreateImageRequest_style>(); } },
                {"user", n => { User = n.GetStringValue(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteObjectValue<CreateImageRequest_model>("model", Model);
            writer.WriteIntValue("n", N);
            writer.WriteStringValue("prompt", Prompt);
            writer.WriteEnumValue<CreateImageRequest_quality>("quality", Quality);
            writer.WriteEnumValue<CreateImageRequest_response_format>("response_format", ResponseFormat);
            writer.WriteEnumValue<CreateImageRequest_size>("size", Size);
            writer.WriteEnumValue<CreateImageRequest_style>("style", Style);
            writer.WriteStringValue("user", User);
            writer.WriteAdditionalData(AdditionalData);
        }
        /// <summary>
        /// Composed type wrapper for classes string
        /// </summary>
        internal class CreateImageRequest_model : IComposedTypeWrapper, IParsable {
            /// <summary>Composed type representation for type string</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public string? String { get; set; }
#nullable restore
#else
            public string String { get; set; }
#endif
            /// <summary>
            /// Creates a new instance of the appropriate class based on discriminator value
            /// </summary>
            /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
            public static CreateImageRequest_model CreateFromDiscriminatorValue(IParseNode parseNode) {
                _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
                var result = new CreateImageRequest_model();
                if(parseNode.GetStringValue() is string stringValue) {
                    result.String = stringValue;
                }
                return result;
            }
            /// <summary>
            /// The deserialization information for the current model
            /// </summary>
            public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
                return new Dictionary<string, Action<IParseNode>>();
            }
            /// <summary>
            /// Serializes information the current object
            /// </summary>
            /// <param name="writer">Serialization writer to use to serialize this model</param>
            public virtual void Serialize(ISerializationWriter writer) {
                _ = writer ?? throw new ArgumentNullException(nameof(writer));
                if(String != null) {
                    writer.WriteStringValue(null, String);
                }
            }
        }
    }
}

