// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    internal class CreateFineTuningJobRequest : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The hyperparameters used for the fine-tuning job.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CreateFineTuningJobRequest_hyperparameters? Hyperparameters { get; set; }
#nullable restore
#else
        public CreateFineTuningJobRequest_hyperparameters Hyperparameters { get; set; }
#endif
        /// <summary>The name of the model to fine-tune. You can select one of the[supported models](/docs/guides/fine-tuning/what-models-can-be-fine-tuned).</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CreateFineTuningJobRequest_model? Model { get; set; }
#nullable restore
#else
        public CreateFineTuningJobRequest_model Model { get; set; }
#endif
        /// <summary>A string of up to 18 characters that will be added to your fine-tuned model name.For example, a `suffix` of &quot;custom-model-name&quot; would produce a model name like `ft:gpt-3.5-turbo:openai:custom-model-name:7p4lURel`.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Suffix { get; set; }
#nullable restore
#else
        public string Suffix { get; set; }
#endif
        /// <summary>The ID of an uploaded file that contains training data.See [upload file](/docs/api-reference/files/upload) for how to upload a file.Your dataset must be formatted as a JSONL file. Additionally, you must upload your file with the purpose `fine-tune`.See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? TrainingFile { get; set; }
#nullable restore
#else
        public string TrainingFile { get; set; }
#endif
        /// <summary>The ID of an uploaded file that contains validation data.If you provide this file, the data is used to generate validationmetrics periodically during fine-tuning. These metrics can be viewed inthe fine-tuning results file.The same data should not be present in both train and validation files.Your dataset must be formatted as a JSONL file. You must upload your file with the purpose `fine-tune`.See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? ValidationFile { get; set; }
#nullable restore
#else
        public string ValidationFile { get; set; }
#endif
        /// <summary>
        /// Instantiates a new CreateFineTuningJobRequest and sets the default values.
        /// </summary>
        public CreateFineTuningJobRequest() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static CreateFineTuningJobRequest CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new CreateFineTuningJobRequest();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"hyperparameters", n => { Hyperparameters = n.GetObjectValue<CreateFineTuningJobRequest_hyperparameters>(CreateFineTuningJobRequest_hyperparameters.CreateFromDiscriminatorValue); } },
                {"model", n => { Model = n.GetObjectValue<CreateFineTuningJobRequest_model>(CreateFineTuningJobRequest_model.CreateFromDiscriminatorValue); } },
                {"suffix", n => { Suffix = n.GetStringValue(); } },
                {"training_file", n => { TrainingFile = n.GetStringValue(); } },
                {"validation_file", n => { ValidationFile = n.GetStringValue(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteObjectValue<CreateFineTuningJobRequest_hyperparameters>("hyperparameters", Hyperparameters);
            writer.WriteObjectValue<CreateFineTuningJobRequest_model>("model", Model);
            writer.WriteStringValue("suffix", Suffix);
            writer.WriteStringValue("training_file", TrainingFile);
            writer.WriteStringValue("validation_file", ValidationFile);
            writer.WriteAdditionalData(AdditionalData);
        }
        /// <summary>
        /// Composed type wrapper for classes string
        /// </summary>
        internal class CreateFineTuningJobRequest_model : IComposedTypeWrapper, IParsable {
            /// <summary>Composed type representation for type string</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public string? String { get; set; }
#nullable restore
#else
            public string String { get; set; }
#endif
            /// <summary>
            /// Creates a new instance of the appropriate class based on discriminator value
            /// </summary>
            /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
            public static CreateFineTuningJobRequest_model CreateFromDiscriminatorValue(IParseNode parseNode) {
                _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
                var result = new CreateFineTuningJobRequest_model();
                if(parseNode.GetStringValue() is string stringValue) {
                    result.String = stringValue;
                }
                return result;
            }
            /// <summary>
            /// The deserialization information for the current model
            /// </summary>
            public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
                return new Dictionary<string, Action<IParseNode>>();
            }
            /// <summary>
            /// Serializes information the current object
            /// </summary>
            /// <param name="writer">Serialization writer to use to serialize this model</param>
            public virtual void Serialize(ISerializationWriter writer) {
                _ = writer ?? throw new ArgumentNullException(nameof(writer));
                if(String != null) {
                    writer.WriteStringValue(null, String);
                }
            }
        }
    }
}

