// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// Represents a completion response from the API. Note: both the streamed and non-streamed response objects share the same shape (unlike the chat endpoint).
    /// </summary>
    internal class CreateCompletionResponse : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The list of completion choices the model generated for the input prompt.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<CreateCompletionResponse_choices>? Choices { get; set; }
#nullable restore
#else
        public List<CreateCompletionResponse_choices> Choices { get; set; }
#endif
        /// <summary>The Unix timestamp (in seconds) of when the completion was created.</summary>
        public int? Created { get; set; }
        /// <summary>A unique identifier for the completion.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Id { get; set; }
#nullable restore
#else
        public string Id { get; set; }
#endif
        /// <summary>The model used for completion.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Model { get; set; }
#nullable restore
#else
        public string Model { get; set; }
#endif
        /// <summary>The object type, which is always &quot;text_completion&quot;</summary>
        public CreateCompletionResponse_object? Object { get; set; }
        /// <summary>This fingerprint represents the backend configuration that the model runs with.Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? SystemFingerprint { get; set; }
#nullable restore
#else
        public string SystemFingerprint { get; set; }
#endif
        /// <summary>Usage statistics for the completion request.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CompletionUsage? Usage { get; set; }
#nullable restore
#else
        public CompletionUsage Usage { get; set; }
#endif
        /// <summary>
        /// Instantiates a new CreateCompletionResponse and sets the default values.
        /// </summary>
        public CreateCompletionResponse() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static CreateCompletionResponse CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new CreateCompletionResponse();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"choices", n => { Choices = n.GetCollectionOfObjectValues<CreateCompletionResponse_choices>(CreateCompletionResponse_choices.CreateFromDiscriminatorValue)?.ToList(); } },
                {"created", n => { Created = n.GetIntValue(); } },
                {"id", n => { Id = n.GetStringValue(); } },
                {"model", n => { Model = n.GetStringValue(); } },
                {"object", n => { Object = n.GetEnumValue<CreateCompletionResponse_object>(); } },
                {"system_fingerprint", n => { SystemFingerprint = n.GetStringValue(); } },
                {"usage", n => { Usage = n.GetObjectValue<CompletionUsage>(CompletionUsage.CreateFromDiscriminatorValue); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteCollectionOfObjectValues<CreateCompletionResponse_choices>("choices", Choices);
            writer.WriteIntValue("created", Created);
            writer.WriteStringValue("id", Id);
            writer.WriteStringValue("model", Model);
            writer.WriteEnumValue<CreateCompletionResponse_object>("object", Object);
            writer.WriteStringValue("system_fingerprint", SystemFingerprint);
            writer.WriteObjectValue<CompletionUsage>("usage", Usage);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

