// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    internal class CreateChatCompletionRequest : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model&apos;s likelihood to repeat the same line verbatim.[See more information about frequency and presence penalties.](/docs/guides/gpt/parameter-details)</summary>
        public double? FrequencyPenalty { get; set; }
        /// <summary>Deprecated in favor of `tool_choice`.Controls which (if any) function is called by the model.`none` means the model will not call a function and instead generates a message.`auto` means the model can pick between generating a message or calling a function.Specifying a particular function via `{&quot;name&quot;: &quot;my_function&quot;}` forces the model to call that function.`none` is the default when no functions are present. `auto`` is the default if functions are present.</summary>
        [Obsolete("")]
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CreateChatCompletionRequest_function_call? FunctionCall { get; set; }
#nullable restore
#else
        public CreateChatCompletionRequest_function_call FunctionCall { get; set; }
#endif
        /// <summary>Deprecated in favor of `tools`.A list of functions the model may generate JSON inputs for.</summary>
        [Obsolete("")]
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<ChatCompletionFunctions>? Functions { get; set; }
#nullable restore
#else
        public List<ChatCompletionFunctions> Functions { get; set; }
#endif
        /// <summary>Modify the likelihood of specified tokens appearing in the completion.Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CreateChatCompletionRequest_logit_bias? LogitBias { get; set; }
#nullable restore
#else
        public CreateChatCompletionRequest_logit_bias LogitBias { get; set; }
#endif
        /// <summary>The maximum number of [tokens](/tokenizer) to generate in the chat completion.The total length of input tokens and generated tokens is limited by the model&apos;s context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.</summary>
        public int? MaxTokens { get; set; }
        /// <summary>A list of messages comprising the conversation so far. [Example Python code](https://cookbook.openai.com/examples/how_to_format_inputs_to_chatgpt_models).</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<ChatCompletionRequestMessage>? Messages { get; set; }
#nullable restore
#else
        public List<ChatCompletionRequestMessage> Messages { get; set; }
#endif
        /// <summary>ID of the model to use. See the [model endpoint compatibility](/docs/models/model-endpoint-compatibility) table for details on which models work with the Chat API.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CreateChatCompletionRequest_model? Model { get; set; }
#nullable restore
#else
        public CreateChatCompletionRequest_model Model { get; set; }
#endif
        /// <summary>How many chat completion choices to generate for each input message.</summary>
        public int? N { get; set; }
        /// <summary>Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model&apos;s likelihood to talk about new topics.[See more information about frequency and presence penalties.](/docs/guides/gpt/parameter-details)</summary>
        public double? PresencePenalty { get; set; }
        /// <summary>An object specifying the format that the model must output. Setting to `{ &quot;type&quot;: &quot;json_object&quot; }` enables JSON mode, which guarantees the message the model generates is valid JSON.**Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in increased latency and appearance of a &quot;stuck&quot; request. Also note that the message content may be partially cut off if `finish_reason=&quot;length&quot;`, which indicates the generation exceeded `max_tokens` or the conversation exceeded the max context length.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CreateChatCompletionRequest_response_format? ResponseFormat { get; set; }
#nullable restore
#else
        public CreateChatCompletionRequest_response_format ResponseFormat { get; set; }
#endif
        /// <summary>This feature is in Beta. If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.Determinism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.</summary>
        public int? Seed { get; set; }
        /// <summary>Up to 4 sequences where the API will stop generating further tokens.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CreateChatCompletionRequest_stop? Stop { get; set; }
#nullable restore
#else
        public CreateChatCompletionRequest_stop Stop { get; set; }
#endif
        /// <summary>If set, partial message deltas will be sent, like in ChatGPT. Tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).</summary>
        public bool? Stream { get; set; }
        /// <summary>What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.We generally recommend altering this or `top_p` but not both.</summary>
        public double? Temperature { get; set; }
        /// <summary>Controls which (if any) function is called by the model.`none` means the model will not call a function and instead generates a message.`auto` means the model can pick between generating a message or calling a function.Specifying a particular function via `{&quot;type: &quot;function&quot;, &quot;function&quot;: {&quot;name&quot;: &quot;my_function&quot;}}` forces the model to call that function.`none` is the default when no functions are present. `auto` is the default if functions are present.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public ChatCompletionToolChoiceOption? ToolChoice { get; set; }
#nullable restore
#else
        public ChatCompletionToolChoiceOption ToolChoice { get; set; }
#endif
        /// <summary>A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<ChatCompletionTool>? Tools { get; set; }
#nullable restore
#else
        public List<ChatCompletionTool> Tools { get; set; }
#endif
        /// <summary>An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.We generally recommend altering this or `temperature` but not both.</summary>
        public double? TopP { get; set; }
        /// <summary>A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? User { get; set; }
#nullable restore
#else
        public string User { get; set; }
#endif
        /// <summary>
        /// Instantiates a new CreateChatCompletionRequest and sets the default values.
        /// </summary>
        public CreateChatCompletionRequest() {
            AdditionalData = new Dictionary<string, object>();
            MaxTokens = 128;
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static CreateChatCompletionRequest CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new CreateChatCompletionRequest();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"frequency_penalty", n => { FrequencyPenalty = n.GetDoubleValue(); } },
                {"function_call", n => { FunctionCall = n.GetObjectValue<CreateChatCompletionRequest_function_call>(CreateChatCompletionRequest_function_call.CreateFromDiscriminatorValue); } },
                {"functions", n => { Functions = n.GetCollectionOfObjectValues<ChatCompletionFunctions>(ChatCompletionFunctions.CreateFromDiscriminatorValue)?.ToList(); } },
                {"logit_bias", n => { LogitBias = n.GetObjectValue<CreateChatCompletionRequest_logit_bias>(CreateChatCompletionRequest_logit_bias.CreateFromDiscriminatorValue); } },
                {"max_tokens", n => { MaxTokens = n.GetIntValue(); } },
                {"messages", n => { Messages = n.GetCollectionOfObjectValues<ChatCompletionRequestMessage>(ChatCompletionRequestMessage.CreateFromDiscriminatorValue)?.ToList(); } },
                {"model", n => { Model = n.GetObjectValue<CreateChatCompletionRequest_model>(CreateChatCompletionRequest_model.CreateFromDiscriminatorValue); } },
                {"n", n => { N = n.GetIntValue(); } },
                {"presence_penalty", n => { PresencePenalty = n.GetDoubleValue(); } },
                {"response_format", n => { ResponseFormat = n.GetObjectValue<CreateChatCompletionRequest_response_format>(CreateChatCompletionRequest_response_format.CreateFromDiscriminatorValue); } },
                {"seed", n => { Seed = n.GetIntValue(); } },
                {"stop", n => { Stop = n.GetObjectValue<CreateChatCompletionRequest_stop>(CreateChatCompletionRequest_stop.CreateFromDiscriminatorValue); } },
                {"stream", n => { Stream = n.GetBoolValue(); } },
                {"temperature", n => { Temperature = n.GetDoubleValue(); } },
                {"tool_choice", n => { ToolChoice = n.GetObjectValue<ChatCompletionToolChoiceOption>(ChatCompletionToolChoiceOption.CreateFromDiscriminatorValue); } },
                {"tools", n => { Tools = n.GetCollectionOfObjectValues<ChatCompletionTool>(ChatCompletionTool.CreateFromDiscriminatorValue)?.ToList(); } },
                {"top_p", n => { TopP = n.GetDoubleValue(); } },
                {"user", n => { User = n.GetStringValue(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteDoubleValue("frequency_penalty", FrequencyPenalty);
            writer.WriteObjectValue<CreateChatCompletionRequest_function_call>("function_call", FunctionCall);
            writer.WriteCollectionOfObjectValues<ChatCompletionFunctions>("functions", Functions);
            writer.WriteObjectValue<CreateChatCompletionRequest_logit_bias>("logit_bias", LogitBias);
            writer.WriteIntValue("max_tokens", MaxTokens);
            writer.WriteCollectionOfObjectValues<ChatCompletionRequestMessage>("messages", Messages);
            writer.WriteObjectValue<CreateChatCompletionRequest_model>("model", Model);
            writer.WriteIntValue("n", N);
            writer.WriteDoubleValue("presence_penalty", PresencePenalty);
            writer.WriteObjectValue<CreateChatCompletionRequest_response_format>("response_format", ResponseFormat);
            writer.WriteIntValue("seed", Seed);
            writer.WriteObjectValue<CreateChatCompletionRequest_stop>("stop", Stop);
            writer.WriteBoolValue("stream", Stream);
            writer.WriteDoubleValue("temperature", Temperature);
            writer.WriteObjectValue<ChatCompletionToolChoiceOption>("tool_choice", ToolChoice);
            writer.WriteCollectionOfObjectValues<ChatCompletionTool>("tools", Tools);
            writer.WriteDoubleValue("top_p", TopP);
            writer.WriteStringValue("user", User);
            writer.WriteAdditionalData(AdditionalData);
        }
        /// <summary>
        /// Composed type wrapper for classes ChatCompletionFunctionCallOption, string
        /// </summary>
        internal class CreateChatCompletionRequest_function_call : IComposedTypeWrapper, IParsable {
            /// <summary>Composed type representation for type ChatCompletionFunctionCallOption</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.ChatCompletionFunctionCallOption? ChatCompletionFunctionCallOption { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.ChatCompletionFunctionCallOption ChatCompletionFunctionCallOption { get; set; }
#endif
            /// <summary>Composed type representation for type string</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public string? String { get; set; }
#nullable restore
#else
            public string String { get; set; }
#endif
            /// <summary>
            /// Creates a new instance of the appropriate class based on discriminator value
            /// </summary>
            /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
            public static CreateChatCompletionRequest_function_call CreateFromDiscriminatorValue(IParseNode parseNode) {
                _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
                var mappingValue = parseNode.GetChildNode("")?.GetStringValue();
                var result = new CreateChatCompletionRequest_function_call();
                if("ChatCompletionFunctionCallOption".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.ChatCompletionFunctionCallOption = new OpenAI.GeneratedKiotaClient.Models.ChatCompletionFunctionCallOption();
                }
                else if(parseNode.GetStringValue() is string stringValue) {
                    result.String = stringValue;
                }
                return result;
            }
            /// <summary>
            /// The deserialization information for the current model
            /// </summary>
            public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
                if(ChatCompletionFunctionCallOption != null) {
                    return ChatCompletionFunctionCallOption.GetFieldDeserializers();
                }
                return new Dictionary<string, Action<IParseNode>>();
            }
            /// <summary>
            /// Serializes information the current object
            /// </summary>
            /// <param name="writer">Serialization writer to use to serialize this model</param>
            public virtual void Serialize(ISerializationWriter writer) {
                _ = writer ?? throw new ArgumentNullException(nameof(writer));
                if(ChatCompletionFunctionCallOption != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.ChatCompletionFunctionCallOption>(null, ChatCompletionFunctionCallOption);
                }
                else if(String != null) {
                    writer.WriteStringValue(null, String);
                }
            }
        }
        /// <summary>
        /// Composed type wrapper for classes string
        /// </summary>
        internal class CreateChatCompletionRequest_model : IComposedTypeWrapper, IParsable {
            /// <summary>Composed type representation for type string</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public string? String { get; set; }
#nullable restore
#else
            public string String { get; set; }
#endif
            /// <summary>
            /// Creates a new instance of the appropriate class based on discriminator value
            /// </summary>
            /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
            public static CreateChatCompletionRequest_model CreateFromDiscriminatorValue(IParseNode parseNode) {
                _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
                var result = new CreateChatCompletionRequest_model();
                if(parseNode.GetStringValue() is string stringValue) {
                    result.String = stringValue;
                }
                return result;
            }
            /// <summary>
            /// The deserialization information for the current model
            /// </summary>
            public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
                return new Dictionary<string, Action<IParseNode>>();
            }
            /// <summary>
            /// Serializes information the current object
            /// </summary>
            /// <param name="writer">Serialization writer to use to serialize this model</param>
            public virtual void Serialize(ISerializationWriter writer) {
                _ = writer ?? throw new ArgumentNullException(nameof(writer));
                if(String != null) {
                    writer.WriteStringValue(null, String);
                }
            }
        }
        /// <summary>
        /// Composed type wrapper for classes string
        /// </summary>
        internal class CreateChatCompletionRequest_stop : IComposedTypeWrapper, IParsable {
            /// <summary>Composed type representation for type string</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public string? String { get; set; }
#nullable restore
#else
            public string String { get; set; }
#endif
            /// <summary>
            /// Creates a new instance of the appropriate class based on discriminator value
            /// </summary>
            /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
            public static CreateChatCompletionRequest_stop CreateFromDiscriminatorValue(IParseNode parseNode) {
                _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
                var mappingValue = parseNode.GetChildNode("")?.GetStringValue();
                var result = new CreateChatCompletionRequest_stop();
                if(parseNode.GetStringValue() is string stringValue) {
                    result.String = stringValue;
                }
                return result;
            }
            /// <summary>
            /// The deserialization information for the current model
            /// </summary>
            public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
                return new Dictionary<string, Action<IParseNode>>();
            }
            /// <summary>
            /// Serializes information the current object
            /// </summary>
            /// <param name="writer">Serialization writer to use to serialize this model</param>
            public virtual void Serialize(ISerializationWriter writer) {
                _ = writer ?? throw new ArgumentNullException(nameof(writer));
                if(String != null) {
                    writer.WriteStringValue(null, String);
                }
            }
        }
    }
}

