// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    internal class CreateAssistantRequest : IParsable {
        /// <summary>The description of the assistant. The maximum length is 512 characters.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Description { get; set; }
#nullable restore
#else
        public string Description { get; set; }
#endif
        /// <summary>A list of [file](/docs/api-reference/files) IDs attached to this assistant. There can be a maximum of 20 files attached to the assistant. Files are ordered by their creation date in ascending order.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<string>? FileIds { get; set; }
#nullable restore
#else
        public List<string> FileIds { get; set; }
#endif
        /// <summary>The system instructions that the assistant uses. The maximum length is 32768 characters.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Instructions { get; set; }
#nullable restore
#else
        public string Instructions { get; set; }
#endif
        /// <summary>Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public CreateAssistantRequest_metadata? Metadata { get; set; }
#nullable restore
#else
        public CreateAssistantRequest_metadata Metadata { get; set; }
#endif
        /// <summary>ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Model { get; set; }
#nullable restore
#else
        public string Model { get; set; }
#endif
        /// <summary>The name of the assistant. The maximum length is 256 characters.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Name { get; set; }
#nullable restore
#else
        public string Name { get; set; }
#endif
        /// <summary>A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<CreateAssistantRequest_tools>? Tools { get; set; }
#nullable restore
#else
        public List<CreateAssistantRequest_tools> Tools { get; set; }
#endif
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static CreateAssistantRequest CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new CreateAssistantRequest();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"description", n => { Description = n.GetStringValue(); } },
                {"file_ids", n => { FileIds = n.GetCollectionOfPrimitiveValues<string>()?.ToList(); } },
                {"instructions", n => { Instructions = n.GetStringValue(); } },
                {"metadata", n => { Metadata = n.GetObjectValue<CreateAssistantRequest_metadata>(CreateAssistantRequest_metadata.CreateFromDiscriminatorValue); } },
                {"model", n => { Model = n.GetStringValue(); } },
                {"name", n => { Name = n.GetStringValue(); } },
                {"tools", n => { Tools = n.GetCollectionOfObjectValues<CreateAssistantRequest_tools>(CreateAssistantRequest_tools.CreateFromDiscriminatorValue)?.ToList(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteStringValue("description", Description);
            writer.WriteCollectionOfPrimitiveValues<string>("file_ids", FileIds);
            writer.WriteStringValue("instructions", Instructions);
            writer.WriteObjectValue<CreateAssistantRequest_metadata>("metadata", Metadata);
            writer.WriteStringValue("model", Model);
            writer.WriteStringValue("name", Name);
            writer.WriteCollectionOfObjectValues<CreateAssistantRequest_tools>("tools", Tools);
        }
        /// <summary>
        /// Composed type wrapper for classes AssistantToolsCode, AssistantToolsFunction, AssistantToolsRetrieval
        /// </summary>
        internal class CreateAssistantRequest_tools : IComposedTypeWrapper, IParsable {
            /// <summary>Composed type representation for type AssistantToolsCode</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode? AssistantToolsCode { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode AssistantToolsCode { get; set; }
#endif
            /// <summary>Composed type representation for type AssistantToolsFunction</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction? AssistantToolsFunction { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction AssistantToolsFunction { get; set; }
#endif
            /// <summary>Composed type representation for type AssistantToolsRetrieval</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval? AssistantToolsRetrieval { get; set; }
#nullable restore
#else
            public OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval AssistantToolsRetrieval { get; set; }
#endif
            /// <summary>
            /// Creates a new instance of the appropriate class based on discriminator value
            /// </summary>
            /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
            public static CreateAssistantRequest_tools CreateFromDiscriminatorValue(IParseNode parseNode) {
                _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
                var mappingValue = parseNode.GetChildNode("")?.GetStringValue();
                var result = new CreateAssistantRequest_tools();
                if("AssistantToolsCode".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.AssistantToolsCode = new OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode();
                }
                else if("AssistantToolsFunction".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.AssistantToolsFunction = new OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction();
                }
                else if("AssistantToolsRetrieval".Equals(mappingValue, StringComparison.OrdinalIgnoreCase)) {
                    result.AssistantToolsRetrieval = new OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval();
                }
                return result;
            }
            /// <summary>
            /// The deserialization information for the current model
            /// </summary>
            public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
                if(AssistantToolsCode != null) {
                    return AssistantToolsCode.GetFieldDeserializers();
                }
                else if(AssistantToolsFunction != null) {
                    return AssistantToolsFunction.GetFieldDeserializers();
                }
                else if(AssistantToolsRetrieval != null) {
                    return AssistantToolsRetrieval.GetFieldDeserializers();
                }
                return new Dictionary<string, Action<IParseNode>>();
            }
            /// <summary>
            /// Serializes information the current object
            /// </summary>
            /// <param name="writer">Serialization writer to use to serialize this model</param>
            public virtual void Serialize(ISerializationWriter writer) {
                _ = writer ?? throw new ArgumentNullException(nameof(writer));
                if(AssistantToolsCode != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.AssistantToolsCode>(null, AssistantToolsCode);
                }
                else if(AssistantToolsFunction != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.AssistantToolsFunction>(null, AssistantToolsFunction);
                }
                else if(AssistantToolsRetrieval != null) {
                    writer.WriteObjectValue<OpenAI.GeneratedKiotaClient.Models.AssistantToolsRetrieval>(null, AssistantToolsRetrieval);
                }
            }
        }
    }
}

