// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// A chat completion message generated by the model.
    /// </summary>
    internal class ChatCompletionResponseMessage : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The contents of the message.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Content { get; set; }
#nullable restore
#else
        public string Content { get; set; }
#endif
        /// <summary>Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.</summary>
        [Obsolete("")]
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public ChatCompletionResponseMessage_function_call? FunctionCall { get; set; }
#nullable restore
#else
        public ChatCompletionResponseMessage_function_call FunctionCall { get; set; }
#endif
        /// <summary>The role of the author of this message.</summary>
        public ChatCompletionResponseMessage_role? Role { get; set; }
        /// <summary>The tool calls generated by the model, such as function calls.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public List<ChatCompletionMessageToolCall>? ToolCalls { get; set; }
#nullable restore
#else
        public List<ChatCompletionMessageToolCall> ToolCalls { get; set; }
#endif
        /// <summary>
        /// Instantiates a new ChatCompletionResponseMessage and sets the default values.
        /// </summary>
        public ChatCompletionResponseMessage() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static ChatCompletionResponseMessage CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new ChatCompletionResponseMessage();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"content", n => { Content = n.GetStringValue(); } },
                {"function_call", n => { FunctionCall = n.GetObjectValue<ChatCompletionResponseMessage_function_call>(ChatCompletionResponseMessage_function_call.CreateFromDiscriminatorValue); } },
                {"role", n => { Role = n.GetEnumValue<ChatCompletionResponseMessage_role>(); } },
                {"tool_calls", n => { ToolCalls = n.GetCollectionOfObjectValues<ChatCompletionMessageToolCall>(ChatCompletionMessageToolCall.CreateFromDiscriminatorValue)?.ToList(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteStringValue("content", Content);
            writer.WriteObjectValue<ChatCompletionResponseMessage_function_call>("function_call", FunctionCall);
            writer.WriteEnumValue<ChatCompletionResponseMessage_role>("role", Role);
            writer.WriteCollectionOfObjectValues<ChatCompletionMessageToolCall>("tool_calls", ToolCalls);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

