// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.GeneratedKiotaClient.Models {
    /// <summary>
    /// A list of [Files](/docs/api-reference/files) attached to an `assistant`.
    /// </summary>
    internal class AssistantFileObject : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The assistant ID that the file is attached to.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? AssistantId { get; set; }
#nullable restore
#else
        public string AssistantId { get; set; }
#endif
        /// <summary>The Unix timestamp (in seconds) for when the assistant file was created.</summary>
        public int? CreatedAt { get; set; }
        /// <summary>The identifier, which can be referenced in API endpoints.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Id { get; set; }
#nullable restore
#else
        public string Id { get; set; }
#endif
        /// <summary>The object type, which is always `assistant.file`.</summary>
        public AssistantFileObject_object? Object { get; set; }
        /// <summary>
        /// Instantiates a new AssistantFileObject and sets the default values.
        /// </summary>
        public AssistantFileObject() {
            AdditionalData = new Dictionary<string, object>();
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static AssistantFileObject CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new AssistantFileObject();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"assistant_id", n => { AssistantId = n.GetStringValue(); } },
                {"created_at", n => { CreatedAt = n.GetIntValue(); } },
                {"id", n => { Id = n.GetStringValue(); } },
                {"object", n => { Object = n.GetEnumValue<AssistantFileObject_object>(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteStringValue("assistant_id", AssistantId);
            writer.WriteIntValue("created_at", CreatedAt);
            writer.WriteStringValue("id", Id);
            writer.WriteEnumValue<AssistantFileObject_object>("object", Object);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

