// <auto-generated/>
using Microsoft.Kiota.Abstractions.Serialization;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System;
namespace OpenAI.Azure.GeneratedKiotaClient.Models {
    internal class ImageGenerationsRequest : IAdditionalDataHolder, IParsable {
        /// <summary>Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.</summary>
        public IDictionary<string, object> AdditionalData { get; set; }
        /// <summary>The number of images to generate.</summary>
        public int? N { get; set; }
        /// <summary>A text description of the desired image(s). The maximum length is 4000 characters.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? Prompt { get; set; }
#nullable restore
#else
        public string Prompt { get; set; }
#endif
        /// <summary>The quality of the image that will be generated.</summary>
        public ImageQuality? Quality { get; set; }
        /// <summary>The format in which the generated images are returned.</summary>
        public ImagesResponseFormat? ResponseFormat { get; set; }
        /// <summary>The size of the generated images.</summary>
        public ImageSize? Size { get; set; }
        /// <summary>The style of the generated images.</summary>
        public ImageStyle? Style { get; set; }
        /// <summary>A unique identifier representing your end-user, which can help to monitor and detect abuse.</summary>
#if NETSTANDARD2_1_OR_GREATER || NETCOREAPP3_1_OR_GREATER
#nullable enable
        public string? User { get; set; }
#nullable restore
#else
        public string User { get; set; }
#endif
        /// <summary>
        /// Instantiates a new imageGenerationsRequest and sets the default values.
        /// </summary>
        public ImageGenerationsRequest() {
            AdditionalData = new Dictionary<string, object>();
            Quality = ImageQuality.Standard;
            ResponseFormat = ImagesResponseFormat.Url;
            Size = ImageSize.Size1024x1024;
            Style = ImageStyle.Vivid;
        }
        /// <summary>
        /// Creates a new instance of the appropriate class based on discriminator value
        /// </summary>
        /// <param name="parseNode">The parse node to use to read the discriminator value and create the object</param>
        public static ImageGenerationsRequest CreateFromDiscriminatorValue(IParseNode parseNode) {
            _ = parseNode ?? throw new ArgumentNullException(nameof(parseNode));
            return new ImageGenerationsRequest();
        }
        /// <summary>
        /// The deserialization information for the current model
        /// </summary>
        public virtual IDictionary<string, Action<IParseNode>> GetFieldDeserializers() {
            return new Dictionary<string, Action<IParseNode>> {
                {"n", n => { N = n.GetIntValue(); } },
                {"prompt", n => { Prompt = n.GetStringValue(); } },
                {"quality", n => { Quality = n.GetEnumValue<ImageQuality>(); } },
                {"response_format", n => { ResponseFormat = n.GetEnumValue<ImagesResponseFormat>(); } },
                {"size", n => { Size = n.GetEnumValue<ImageSize>(); } },
                {"style", n => { Style = n.GetEnumValue<ImageStyle>(); } },
                {"user", n => { User = n.GetStringValue(); } },
            };
        }
        /// <summary>
        /// Serializes information the current object
        /// </summary>
        /// <param name="writer">Serialization writer to use to serialize this model</param>
        public virtual void Serialize(ISerializationWriter writer) {
            _ = writer ?? throw new ArgumentNullException(nameof(writer));
            writer.WriteIntValue("n", N);
            writer.WriteStringValue("prompt", Prompt);
            writer.WriteEnumValue<ImageQuality>("quality", Quality);
            writer.WriteEnumValue<ImagesResponseFormat>("response_format", ResponseFormat);
            writer.WriteEnumValue<ImageSize>("size", Size);
            writer.WriteEnumValue<ImageStyle>("style", Style);
            writer.WriteStringValue("user", User);
            writer.WriteAdditionalData(AdditionalData);
        }
    }
}

