﻿namespace OpenAI.ChatGpt.Models.ChatCompletion.Messaging;

/// <summary>
/// A message from the user.
/// The recommended way to create it using method <see cref="Dialog"/>.<see cref="Dialog.StartAsUser(string)"/>
/// </summary>
/// <remarks>
/// The user messages help instruct the assistant.
/// They can be generated by the end users of an application, or set by a developer as an instruction.
/// </remarks>
public class UserMessage : UserOrSystemMessage
{
    /// <summary>
    /// A message from the user
    /// </summary>
    /// <remarks>
    /// The user messages help instruct the assistant.
    /// They can be generated by the end users of an application, or set by a developer as an instruction.
    /// </remarks>
    /// <param name="content">The message text</param>
    public UserMessage(string content) : base(ChatCompletionRoles.User, content)
    {
    }
    
    internal UserMessage(List<ChatCompletionMessage> messages, string content) 
        : base(messages, ChatCompletionRoles.User, content)
    {
    }

    public AssistantMessage ThenAssistant(string assistantMessage)
    {
        if (string.IsNullOrWhiteSpace(assistantMessage))
            throw new ArgumentException("Value cannot be null or whitespace.",
                nameof(assistantMessage));
        return new AssistantMessage(Messages, assistantMessage);
    }
    
    public static explicit operator UserMessage(string message)
    {
        return new UserMessage(message);
    }
}