/// Link the stubbed app shared library file with the roc_host_bin exectuable
fn main() {
    // The path to the platform directory within the workspace
    // where the libapp.so file is generated by the build.roc script
    let platform_path = workspace_dir().join("platform");

    println!("cargo:rustc-link-search={}", platform_path.display());

    #[cfg(not(windows))]
    println!("cargo:rustc-link-lib=dylib=app");

    #[cfg(windows)]
    println!("cargo:rustc-link-lib=dylib=libapp");
}

/// Gets the path to the workspace root.
fn workspace_dir() -> std::path::PathBuf {
    let output = std::process::Command::new(env!("CARGO"))
        .arg("locate-project")
        .arg("--workspace")
        .arg("--message-format=plain")
        .output()
        .unwrap()
        .stdout;
    let cargo_path = std::path::Path::new(std::str::from_utf8(&output).unwrap().trim());
    cargo_path.parent().unwrap().to_path_buf()
}
