
![Logo](https://ik.imagekit.io/vu5t8xb15vzcx/tr:h-100/android-chrome-512x512_EiumvYoXeA.png?ik-sdk-version=javascript-1.4.3&updatedAt=1669548997842)

# Daisy UI Admin Dashboard Template - DashWind 
[![MIT License](https://img.shields.io/badge/License-MIT-green.svg)](https://choosealicense.com/licenses/mit/)

This is a free admin dashboard template that uses **Daisy UI** and React js. It has **fully customizable and themable CSS**  CSS and is powered by Tailwind CSS utility classes. Additionally, it comes with **redux toolkit** and other libraries already set up.


## Preview

🚀 [Live preview](https://tailwind-dashboard-template-dashwind.vercel.app/)


![App Screenshot](https://ik.imagekit.io/vu5t8xb15vzcx/tr:h-600/Screenshot_2023-05-09_at_12.57.37_PM_z94SiShUDS.png?updatedAt=1683617550144)



## Features

- **Light/dark** mode toggle
- Token based user **authentication**
- **Submenu support** in sidebar
- Store management using **redux toolkit**
- **Daisy UI** components and **Tailwind** support
- **Right and left sidebar**, Universal loader, notifications
- **Calendar**, global modal, **chart js 2**  and other components

## Typescript Nest Js Version

[Link](https://github.com/robbins23/admin-dashboard-nextjs-typescript-daisyui)


## Installation

Go to project directory and run (make sure you have node installed first)

```bash
  npm install
  npm start
```
    
## Core Libraries Used

- [React JS v18.2.0](https://reactjs.org/)
- [React Router v6.4.3](https://reactrouter.com/en/main)
- [Tailwind CSS v3.3.6](https://tailwindcss.com/)
- [Daisy UI v4.4.19](https://daisyui.com/)
- [HeroIcons](https://heroicons.com/)
- [Redux toolkit v1.9](https://redux-toolkit.js.org/)
- [React ChartJS 2 v5](https://react-chartjs-2.js.org/)

## Documentation

[Documentation](https://tailwind-dashboard-template-dashwind.vercel.app/documentation)

## Page Examples

|                          |                               |
:-------------------------:|:-------------------------:
![Dark Mode](https://ik.imagekit.io/vu5t8xb15vzcx/tr:h-600/Screenshot_2023-05-09_at_12.57.37_PM_z94SiShUDS.png?updatedAt=1683617550144) | ![Transations Screenshot](https://ik.imagekit.io/vu5t8xb15vzcx/Screenshot_2023-05-09_at_1.01.54_PM_YiG__JTFu.png?updatedAt=1683619541458) 
![Leads Screenshot](https://ik.imagekit.io/vu5t8xb15vzcx/Screenshot_2023-05-09_at_1.34.56_PM_cdSamaaCmA.png?updatedAt=1683619597855) | ![Setting Screenshot](https://ik.imagekit.io/vu5t8xb15vzcx/Screenshot_2023-01-20_at_12.43.25_PM_xZBThuZdU.png?ik-sdk-version=javascript-1.4.3&updatedAt=1674198832089) 
![Calendar Screenshot](https://ik.imagekit.io/vu5t8xb15vzcx/Screenshot_2023-05-09_at_1.02.03_PM_pObZm43gl.png?updatedAt=1683617549958) | ![Register Screenshot](https://ik.imagekit.io/vu5t8xb15vzcx/Screenshot_2023-01-20_at_12.43.00_PM_1fkpMRG90.png?ik-sdk-version=javascript-1.4.3&updatedAt=1674198831908)





## Preview

🚀 [Live preview](https://tailwind-dashboard-template-dashwind.vercel.app/)


## Roadmap

- Addition of users, chat/ inbox page
- Calendar improments
- Seperate templates based on business functions like CRM, Sales, Project Management


## Contributing

Contributions are always welcome!

## License

[![MIT License](https://img.shields.io/badge/License-MIT-green.svg)](https://choosealicense.com/licenses/mit/)


## Feedback

If you have any feedback, please reach out [here](https://forms.gle/8G7PsvQp8X1Swcf29)



