# Deep Learning Lecture Notes and Experiments

## 2023-2024 Version

Revised and expanded

### Theory

| **Topic** | **Note** | **Video** | **Code** |
| :--- | :---: | :---: | :--- |
| Overview | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/overview/Overview.pdf) | - | - |
| Supervised Learning | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/supervised/Supervised.pdf) | - | - |
| Multilayer Perceptron (MLP) | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/mlp/MLP.pdf) | - | [Notebook](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/mlp/demo/mlp_mnist.ipynb) |
| Convolutional Neural Network (CNN) | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/cnn/CNN.pdf) | - | [Notebook](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/cnn/demo/cnn_mnist.ipynb) |
| Recurrent Neural Network (RNN) | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/rnn/RNN.pdf) | - | [Notebook](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/rnn/demo/rnn_mnist.ipynb) |
| Transformer | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/transformer/Transformer.pdf) | - | [Notebook](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/transformer/demo/transformer_mnist.ipynb) |
| Mamba | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2024/mamba/SSM.pdf) | - |  [SimpleMamba](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2024/mamba/demo/mamba_simple_mnist.ipynb) <br> [Mamba2](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2024/mamba/demo/mamba2_mnist.ipynb)
| Optimization | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/optimizer/Optimizer.pdf) | - | - |
| Regularization | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/regularizer/Regularization.pdf) | - | - |
| Detection | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2024/detection/Detection.pdf) | - | - |
| Segmentation | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2024/segmentation/Segmentation.pdf) | - | [SAM2](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2024/segmentation/python/sam2_demo.ipynb) |
| Autoencoder (AE)| [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/autoencoder/AutoEncoders.pdf) | - | [AE & Denoising AE](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/autoencoder/demo/autoencoder.ipynb) <br> [Colorization AE](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/autoencoder/demo/colorization_ae.ipynb)  |
| Variational Autoencoder (VAE)| [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/vae/VAE.pdf) | - | [VAE](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/vae/demo/vae_mnist.ipynb) and [CVAE](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/vae/demo/cvae_mnist.ipynb) |
| Generative Adversarial Network (GAN)| [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/gan/GAN.pdf) | - | [DCGAN](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/gan/demo/dcgan_mnist.ipynb) and [CGAN](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/gan/demo/cgan_mnist.ipynb) |
| Intro to Large Language Models (LLMs) | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/llm/LLM_Intro.pdf) | - | [GPT2-TS-train](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2024/llm/python/gpt2_tinystories_fr_scratch.py), [GPT2-TS-val](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2024/llm/python/gpt2_val_tinystories_fr_scratch.ipynb)  |
| LLM Data and Model | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/llm/LLM_Data_Model.pdf) | - | [GPT2-TS-ft](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2024/llm/python/gpt2_tinystories.py), [GPT2-TS-ft-val](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2024/llm/python/gpt2_val_tinystories.ipynb) |

### Practice
| **Topic** | **Note** | **Video** | **Code** |
| :--- | :---: | :---: | :--- |
| Development Environment | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/Env_Editor.pdf) | - | - |
| Python | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/Python.pdf) | - | - |
| Numpy | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/Numpy.pdf) | - | - |
| Einsum | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/Einsum.pdf) | - | [Notebook](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/demo/einsum_demo.ipynb) |
| Einops | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/Einops.pdf) | - | [Notebook](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/demo/einops_demo.ipynb) |
| PyTorch | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/PyTorch.pdf) | - | - |
| Gradio | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/Gradio.pdf) | - | [Notebook](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/demo/gradio.ipynb) <br> [Llama Chat](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/demo/chat_gradio.ipynb)|
| Efficiency | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/efficiency/Efficiency.pdf) | - | [Code](https://github.com/roatienza/benchmark) |
| PyTorch Lightning | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/PyTorch_Lightning.pdf) | - | [Notebook](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/toolkit/demo/lightning_mnist.ipynb) |
| Model Packaging & Serving | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/model_serving/Model_Serving.pdf) | - | [ONNX Export](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/model_serving/demo/torch2onnx.py) <br> [ONNX Runtime](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/model_serving/demo/onnx_infer.py) <br> [TorchScript & TensorRT](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/model_serving/demo/tensorrt_infer.py) <br> [PyTriton Yolo Client](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/model_serving/demo/triton/yolo/client.ipynb) <br> [PyTriton Yolo Server](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/model_serving/demo/triton/yolo/server.py) |
| Docker | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/docker/Docker.pdf) | = | - | 
| HuggingFcae | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2023/llm/HuggingFace.pdf) | - | - |


### Install
Assuming you already have  `anaconda` or `venv`, install the required python packages to run the experiments in this version.

`pip install -r requirements.txt --upgrade`

## 2022

### Coverage:

| **AI, ML and Deep Learning** | **Note** | **Video** | **Code** |
| :--- | :---: | :---: | :--- |
| &nbsp;&nbsp;&nbsp;&nbsp;Overview | [PDF](versions/2022/overview/Overview.pdf) | [YouTube](https://youtu.be/zU37kvvkz0o) | -  |
| **Toolkit**| | | |
| &nbsp;&nbsp;&nbsp;&nbsp;Development Environment<br> &nbsp;&nbsp;&nbsp;&nbsp;and Code Editor | [PDF](versions/2022/tools/Toolkit_Env_Editor.pdf) | [YouTube](https://youtu.be/LildU3tGGEo) | -  |
| &nbsp;&nbsp;&nbsp;&nbsp;Python | [PDF](versions/2022/tools/Toolkit_Python.pdf)| [YouTube](https://youtu.be/4Q1G5GuIXw8) | -  |
| &nbsp;&nbsp;&nbsp;&nbsp;Numpy | [PDF](versions/2022/tools/Toolkit_Numpy.pdf) | [YouTube](https://youtu.be/_E9dnUY1Ets) | [Jupyter](versions/2022/tools/python/np_demo.ipynb) |
| &nbsp;&nbsp;&nbsp;&nbsp;Einsum | [PDF](versions/2022/tools/Toolkit_Einsum.pdf) | [YouTube](https://youtu.be/IUs7aWs-axM) | [Jupyter](versions/2022/tools/python/einsum_demo.ipynb) |
| &nbsp;&nbsp;&nbsp;&nbsp;Einops | [PDF](versions/2022/tools/Toolkit_Einops.pdf) | [YouTube](https://youtu.be/ll1BlfYd4mU) | [Jupyter](versions/2022/tools/python/einops_demo.ipynb) & <br> [Jupyter (Audio)](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/tools/python/einops_audio.ipynb) |
| &nbsp;&nbsp;&nbsp;&nbsp;PyTorch & Timm | [PDF](versions/2022/tools/Toolkit_PyTorch.pdf) | [YouTube](https://youtu.be/mK0CHqLCoXA) | [PyTorch/Timm](versions/2022/tools/python/pytorch_demo.ipynb) & <br> [Input](versions/2022/tools/python/input_demo.ipynb) Jupyter|
| &nbsp;&nbsp;&nbsp;&nbsp;Gradio & Hugging Face | [PDF](versions/2022/tools/Toolkit_Gradio.pdf) | [YouTube](https://youtu.be/b1NgUiTIUMc) | [Jupyter](versions/2022/tools/python/gradio_demo.ipynb) |
| &nbsp;&nbsp;&nbsp;&nbsp;Weights and Biases| [PDF](versions/2022/tools/Toolkit_WandB_Accelerate.pdf) | [YouTube](https://youtu.be/vbxNFIqd2iw) | [Jupyter](versions/2022/tools/python/wandb_demo.ipynb) |
| &nbsp;&nbsp;&nbsp;&nbsp;Hugging Face Accelerator|  Same as W&B | Same as W&B | [Jupyter](versions/2022/tools/python/accelerate_demo.ipynb) & <br> [Python](versions/2022/tools/python/accelerate_demo.py) |
| **Datasets & Dataloaders** | [PDF](versions/2022/datasets/Datasets.pdf) | [YouTube](https://youtu.be/7_t_yyF15jM) | [Jupyter](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/datasets/python/dataloader_demo.ipynb) |
| **Supervised Learning** | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/supervised/Supervised.pdf) | [YouTube](https://youtu.be/mBjAaAU6CW0) | |
| &nbsp;&nbsp;&nbsp;&nbsp;PyTorch Lightning | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/supervised/PyTorch_Lightning.pdf) | [YouTube](https://youtu.be/VxvOupw92tU) | [MNIST](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/supervised/python/mnist_demo.ipynb) & [KWS](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/supervised/python/kws_demo.ipynb) |
|  &nbsp;&nbsp;&nbsp;&nbsp;[Keyword Spotting App](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/supervised/python/kws-infer.py) | | | `cd versions/2022/supervised/python &&`<br>`python3 kws-infer.py --gui` |
| **Building blocks:<br> MLPs, CNNs, RNNs, Transformers** | | | |
|  &nbsp;&nbsp;&nbsp;&nbsp;MLP | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/mlp/MLP.pdf) | [YouTube](https://youtu.be/Rolx9HVmRAc) | [MLP on CIFAR10](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/mlp/python/mlp_pytorch_demo.ipynb) |
|  &nbsp;&nbsp;&nbsp;&nbsp;CNN | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/cnn/CNN.pdf) | [YouTube](https://youtu.be/WZsaU-UV9KE) | [CNN on CIFAR10](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/cnn/python/cnn_pytorch_demo.ipynb) |
|  &nbsp;&nbsp;&nbsp;&nbsp;Transformer | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/transformer/Transformer.pdf) | [YouTube](https://youtu.be/6PmIoCnqcFU) | [Transformer on CIFAR10](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/transformer/python/transformer_demo.ipynb) |
| **Backpropagation** | [PDF](https://github.com/roatienza/ml/blob/master/vector_calculus/Vector_Calculus.pdf) | | |
| **Optimization** | [PDF](https://github.com/roatienza/ml/blob/master/optimization/Optimization.pdf) | | |
| **Regularization** | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/regularization/Regularization.pdf) | | |
| **Unsupervised Learning** | Soon | | |
| **AutoEncoders** | [PDF](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/autoencoder/AutoEncoders.pdf) | [YouTube](https://youtu.be/uBqnwpC1kPc) | [AE MNIST](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/autoencoder/python/ae_pytorch_demo.ipynb) <br> [Colorization CIFAR10](https://github.com/roatienza/Deep-Learning-Experiments/blob/master/versions/2022/autoencoder/python/colorize_pytorch_demo.ipynb)|



### Star, Fork, Cite
If you find this work useful, please give it a star, fork, or cite:

```
@misc{atienza2020dl,
  title={Deep Learning Lecture Notes},
  author={Atienza, Rowel},
  year={2020},
  publisher = {GitHub},
  journal = {GitHub repository},
  howpublished = {\url{https://github.com/roatienza/Deep-Learning-Experiments}},
}
```



