# Welcome to RoadRunner docs contributing guide <!-- omit in toc -->

Thank you for investing your time in contributing to our project! Any contribution you make will be reflected on [RR](https://github.com/roadrunner-server/roadrunner#contributors) :sparkles:. 

Read our [Code of Conduct](./CODE_OF_CONDUCT.md) to keep our community approachable and respectable.

In this guide you will get an overview of the contribution workflow from opening an issue, creating a PR, reviewing, and merging the PR.

### Issues

#### Create a new issue

If you spot a problem with the RR, [search if an issue already exists](https://github.com/roadrunner-server/roadrunner/issues). If a related issue doesn't exist, you can open a new issue using a relevant [issue form](https://github.com/roadrunner-server/roadrunner/issues/new/choose). 

#### Solve an issue

Scan through our [existing issues](https://github.com/roadrunner-server/roadrunner/issues) to find one that interests you. You can narrow down the search using `labels` as filters. If you find an issue to work on, you are welcome to open a PR with a fix.

### Pull Request

When you're finished with the changes, create a pull request, also known as a PR.
- Fill the "Ready for review" template so that we can review your PR. This template helps reviewers understand your changes as well as the purpose of your pull request. 
- Don't forget to update the docs if you are solving one.
- Make sure, that all checkboxes in the PR template are solved.
Once you submit your PR, a RR team member will review your proposal. We may ask questions or request for additional information.
- As you update your PR and apply changes, mark each conversation as [resolved](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/commenting-on-a-pull-request#resolving-conversations).
- If you run into any merge issues, checkout this [git tutorial](https://github.com/skills/resolve-merge-conflicts) to help you resolve merge conflicts and other issues.

### Your PR is merged!

Congratulations :tada::tada: The RoadRunner team thanks you :sparkles:. 

Once your PR is merged, your contributions will be publicly visible on the [RR page](https://github.com/roadrunner-server/roadrunner#contributors). 

Now that you are part of the RoadRunner server community, see how else you can [contribute to the RR](https://github.com/roadrunner-server/roadrunner/issues).
