# The Web, Web Applications & Browsers

--------------------------------------------------------------------------------------------------------------------------------
## Table of Contents
- [General](#general)
	- Purposely Vulnerable Web Apps -> See 'Building a Lab' page.
- [Standards & Technologies](#1stand)
- [Attacks & Techniques](#1attack)
--------------------------------------------------------------------------------------------------------------------------------


--------------------------------------------------------------------------------------------------------------------------------
### [Standards & Technologies](#standards)<a name="1stand"></a>
- [101](#101)
- [APIs](#api)
- [(Web) Browsers](#webbrowser)
	- [Browser Security](#browsersec)
	- [Browser Extensions](#be)
- [Backend X(Image/PDF/etc) Processing](#backend-process)
	- [ImageMagick](#bp-img)
	- [PDF/PostScript](#bp-pdf)
- [Cascading Style Sheets](#css)
- [Certificates & Cert Transparency](#ct)
- [CMS Specific](#cms)
	- [Cold Fusion](#coldfusion)
- [Cookies & Tokens](#cookies)
- [Content Security Policy(CSP)](#csp)
- [Common Origin Resource Sharing (CORS)](#cors)
- [Cookies](#cookies)
- [Document Object Model(DOM)](#dom)
- [Edge Side Include](#esi)
- [Electron](#electron)
- [Encoding](#encoding)
- [FIDO2](#fido2)
- [File System Access API](#fsapi)
- [Flash/SWF](#swf)
- [GhostScript](#ghosts)
- [GraphQL](#graphql)
- [HTML](#html)
- [Hyper Text Transport Protocol (HTTP)](#http)
- [Imagemagick](#magick)
- [Java & Associated](#java)
	- [Java Server Faces](#jsf)
	- [Java Server Pages](#jsp)
- [JavaScript](#javascript)
- [JavaScript Frameworks](#jsframeworks)
- [.NET-based Frameworks](#.netframeworks)
- [Python-baed Frameworks](#pythonframeworks)
- [JSON](#json)
- [JSON Web Tokens](#jwt)
- [MIME Sniffing](#mime)
- [NodeJS](#nodejs)
- [OAuth](#oauth)
- [Parsers](#parsers)
- [PASETO](#paseto)
- [PHP](#php)
- [Protocol Buffers](#protobuf)
- [Robots.txt](#robots)
- [RPC-related](#rpc)
- [Ruby](#ruby)
- [SAML](#saml)
- [Same-Origin-Policy](#sop)
- [Security Assertion Markup Language (SAML))](#saml)
- [Service Workers](#serviceworkers)
- [Site Isolation](#siteisolate)
- [SubResource Integrity](#sri)
- [Secure Sockets Layer/Transport Layer Security](#ssltls)
- [SSL/TLS](#ssltls)
- [Single Sign-On](#sso)
- [Streams](#streams)
- [Unicode](#unicode)
- [Uniform Resource Identifier/Locator(URIs/URLs)](#uri)
- [Web Application Firewalls(WAFs)](#waf)
- [Web Assembly](#webasm)
- [WebAuthentication](#webauthn)
- [WebBluetooth](#webbt)
- [Web Hooks](#webhook)
- [WebNFC](#webnfc)
- [Web Proxies & Middleware](#webproxy)
- [WebRTC](#webrtc)
- [Web Servers](#webservers)
- [WebSockets](#websockets)
- [Web Storage](#webstorage)
- [WebUSB](#webusb)

--------------------------------------------------------------------------------------------------------------------------------


--------------------------------------------------------------------------------------------------------------------------------
### [Attacks & Techniques](#attacks)<a name="1attack"></a>
- [Tactics](#ttt)
- [Guides & Methodologies](#ttgm)
- [General Reconnaissance](#genrecon) - Fix toc section
	- [Attack Surface Reconnaissance](#ttasr)
	- [Endpoint Discovery](#tted)
	- [Forced-Browsing](#ttfb)
	- [HTTP Enumeration](#tthe)
	- [JS-Based Scanning](#ttjs)
		- [Site/Tech ID](#tttid)
	- [Scraping](#scraping)
	- [(Sub)Domain Reconnaissance](#sdr)
	- [User Enumeration](#ttue)
	- [Virtual Hosts](#ttrvhost)
	- [Visual Reconnaissance](#ttvr)
	- [Vulnerability Scanners](#ttvs)
- [Attacks](#webattacks)
	- [Abuse of Functionality](#abuse)
	- [Backend File Parsing/Processing](#backfile) - fix
		- [Images](#backimage) - fix
		- [PDFs](#backpdf) - fix
	- [Brute Force/Fuzzing/Directory Discovery](#brute)
	- [Cache-based Attacks](#cache-based) - Fix
		- [Cache Deception Attack](#cachedecept)
		- [Cache Poisoning Attack](#cachepoison)
	- [CSV injection](#csv)
	- [ClickJacking](#clickjack)
	- [Cross Protocl Sripting/Request Attack](#cpr)
	- [Cross Site Content Hijaacking](#xsch)
	- [Cross-Site History Manipulation (XHSM)](#xshm)
	- [Cross-Site-Request Forgery](#csrf)
	- [Cross-Site-Scripting (XSS)](#xss)
	- [Cascading StyleSheets Injection](#cssi)
	- [Cross Site WebSocket Hijacking](#cswsh))
	- [Data Structure Attacks](#dsa)
	- [Edge Side Include Injection](#esii)
	- [Embedded Malicious Code](#emc)
	- [Exploitation of Authentication](#eoa)
	- [Execution after Redirect](#ear)
	- [File Upload Testing](#file)
	- [(Attacking) Frameworks](#webframeworks)
	- [Fuzzing](#fuzzing)
	- [HTML Smuggling](#hsmug)
	- [HTTP Request Smuggling](#httprs)
	- [Image-based Exploitation AKA Exploiting Polyglot features of File standards](#ibe)
	- [IDN Homgraph Attacks - Font Deception](#idn)
	- [Insecure Direct Object Reference](#idor)
	- [Injection Based Attacks](#ija)
		- [Command Injection](#cmdinjection)
	- [LFI & RFI](#lrfi)
	- [Log4J](#log4j)
	- [Logic Flaws](#logic)
	- [OS Command Injection](#osci)
	- [JNDI](#jndi)
	- [Password Bruteforcing](#passbrute)
	- [Path Confusion Attacks](#pca)
	- [Path Traversal Attacks](#pta)
	- [Prototype Pollution Attack](#ppa)
	- [Reflected File Download](#rfd)
	- [Relative Path Overwrite](#rpo)
	- [Serialization Attacks](#serialization)
	- [Site Imaging](#simg)
	- [(NO)SQL Injection](#sql)
	- [Server Side Request Forgery](#ssrf)
	- [Server Side Include](#ssi)
	- [Server Side Template Injection](#ssti)
	- [Subdomain Hijack](#subtake)
	- [Tabnabbing](#tabnab)
	- [Timing-based Attacks/Data Race Attacks](#timing)
	- [TLS Redirection (and Virtual Host Confusion)](#tls-redirect)
	- [Typosquatting](#typosquat)
	- [Web Cache Poisoning Attack](#cachepoison)
	- [Web Shells](#shells)
	- [XML-based Attacks](#xml)
- [Miscellaneous](#misc)
	- [Burp Stuff/Plugins](#burpstuff)
	- [Testing writeups](#ttw)
	- [Wordlists & Payloads](#wordpay)
	- [BugBounty Writeups](#bugbounty)
	- [Cloudflare](#cloudflare)
- [Application Specific/Vendor Specific](#avspec)


-------------------------------------------------------------------------------------------------------------------------------


* **To Do**
	2. backlog
	3. TLS
	4. HTTP2/3
	5. XSS
	6. XSSI
	7. XXE


----------------------------------------------------------------------------------------------------------------
### <a name="general">General</a>
* **101**
	* **Things to Know**
		* [OWASP Application Security Verification Standard](https://owasp.org/www-project-application-security-verification-standard/)
			* "The primary aim of the OWASP Application Security Verification Standard (ASVS) Project is to normalize the range in the coverage and level of rigor available in the market when it comes to performing Web application security verification using a commercially-workable open standard. The standard provides a basis for testing application technical security controls, as well as any technical security controls in the environment, that are relied on to protect against vulnerabilities such as Cross-Site Scripting (XSS) and SQL injection. This standard can be used to establish a level of confidence in the security of Web applications."
		* [OWASP Top Ten Project](https://www.owasp.org/index.php/Category:OWASP_Top_Ten_Project)
			* The OWASP Top 10 is a powerful awareness document for web application security. It represents a broad consensus about the most critical security risks to web applications. Project members include a variety of security experts from around the world who have shared their expertise to produce this list.
		* [The Website Obesity Crisis](http://idlewords.com/talks/website_obesity.htm)
		* [XSS, CSRF, CSP, JWT, WTF? IDK `¯\_(ツ)_/¯` - Dominik Kundel(JSConf Iceland2018)](https://www.youtube.com/watch?v=c6mqdsfWdmE)
			* `Robert'); DROP TABLE Students;--` The little Bobby Tables is embodying the classical fear of SQL injections when building web applications. However, SQL injections are just one aspect of things we need to worry about when building web applications. With the recent popularity of Angular, React and other Single Page Application frameworks we got more logic executing on the front-end create new problems and make you forget about others. In this talk you will learn about XSS, CSRF, CORS, JWT, HTTPS, SPAs, REST APIs and other weird abbreviations, how to protect yourself and your users from the new generation of Bobby Tables.
	* **Articles**
		* [The Basics of Web Application Security - Cade Cairns, Daniel Somerfield(2017)](https://martinfowler.com/articles/web-security-basics.html)
		* [Don't Cross Me! Same Origin Policy and all the "cross" vulns: XSS, CSRF, and CORS - ropnop(2020)](https://speakerdeck.com/ropnop/dont-cross-me-same-origin-policy-and-all-the-cross-vulns-xss-csrf-and-cors?slide=58)
* **Browsers**
	* [Browser-2020](https://github.com/luruke/browser-2020)
		* Things you can do with a browser in 2020
		* It's like, did no one read 'The Tangled Web: A Guide to Securing Modern Web Applications'? Or did they, and their take away was, 'Man, what a bunch of great ideas! Blinking text with no user control? Woah. I'm so on this.'. 
		* My point is that it is 2020, and there is no equivalent to NoScript or UBlock Origin in any major browser. Despite this, I can have picture in picture video chats, while also connecting by bluetooth and USB, devices to the browser and having each tab color coded, along with the browser knowing my power level of my device, all according to standards.
		* It's 2020, still no equivalent of NoScript or UBlock Origin available by default in any of the major browsers. 
			* Yet, I can share files with others, using a contextual menu depending on installed applications, or I can give my browser access to my insecure USB and Bluetooth devices, while it makes sure my battery isn't dead from the power consumption while the containing tabs for each webapp are properly color coded. 🤔
		* Google released a paper the day after I made this comment. I stand by my comment.
		* [Oh, the Places You’ll Go! Finding Our Way Back from the Web Platform’sIll-conceived Jaunts - Artur Janc, Mike West(2020)](https://secweb.work/papers/janc2020places.pdf)
			* In this paper, we start from a scattered list of concrete grievances about the web platform based on informal discussions among browser and web security engineers. After reviewing the details of these issues, we work towards amodel of the root causes of the problems, categorizing them based on the type of risk they introduce to the platform. We then identify possible solutions for each class of issues, dividing them by the most effective approach to address it. In the end, we arrive at a general blueprint for backing out of these dead ends. We propose a three-pronged approach which includes changing web browser defaults, creating aslew of features for web authors to opt out of dangerous behaviors, and adding new security primitives. We then show how this approach can be practically applied to address each of the individual problems, providing a conceptual framework for solving unsafe legacy web platform behaviors.
	* [How Browsers Work: Behind the scenes of modern web browsers - Tali Garsiel, Paul Irish(2011)](https://www.html5rocks.com/en/tutorials/internals/howbrowserswork/)
- **Authentication**
	- **Articles**
			* [A Dive Into Web Application Authentication - James Chiapetta(2022)](https://betterappsec.com/a-medium-dive-into-web-application-authentication-342d1d002a61)
			* [Auth-Boss](https://github.com/teesloane/Auth-Boss)
				* 🔒 Become an Auth Boss. Learn about different authentication methodologies on the web.
		- **Talks/Presentations**
			* [Authentication fundamentals: The basics - Stuart Kwan](https://www.youtube.com/watch?v=fbSVgC8nGz4)
- **Authorization**
	- **Articles**
* **Session Management**
	* [Session Management Cheat Sheet - OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Session_Management_Cheat_Sheet.html)
* **Cheat Sheets**
	* See 'Cheats.md' for cheatsheets
* **Tools**
----------------------------------------------------------------------------------------------------------------------------------



----------------------------------------------------------------------------------------------------------------------------------
## <a name="standards"></a>Standards & Technologies
### <a name="api"></a>API Stuff
- **101**
	* [OWASP API Security Project](https://owasp.org/www-project-api-security/)
	* [WebSocket API Standards](https://www.w3.org/TR/2011/WD-websockets-20110929/)
	* [API Throwdown: RPC vs REST vs GraphQL - Nate Barbettini(Iterate 2018)](https://www.youtube.com/watch?v=IvsANO0qZEg)
		* Choosing an API design style can be downright daunting. The RPC vs. REST debate has raged for years, and now there's a new kid on the block: GraphQL. Which is right for your application? I'll demystify these API styles in clear terms and help you decide how to design your API.
	* [A brief look at the evolution of interface protocols leading to modern APIs - Luis Augusto Weir(2019)](https://www.soa4u.co.uk/2019/02/a-brief-look-at-evolution-of-interface.html)
- **Reference**
	* [White House Web API Standards](https://github.com/WhiteHouse/api-standards)
		* This document provides guidelines and examples for White House Web APIs, encouraging consistency, maintainability, and best practices across applications. White House APIs aim to balance a truly RESTful API interface with a positive developer experience (DX).

	- **OpenAPI**
		* [The OpenAPI Specification](https://github.com/OAI/OpenAPI-Specification)
			* The OpenAPI Specification (OAS) defines a standard, programming language-agnostic interface description for REST APIs, which allows both humans and computers to discover and understand the capabilities of a service without requiring access to source code, additional documentation, or inspection of network traffic. When properly defined via OpenAPI, a consumer can understand and interact with the remote service with a minimal amount of implementation logic. Similar to what interface descriptions have done for lower-level programming, the OpenAPI Specification removes guesswork in calling a service.
		* [What Is OpenAPI?](https://swagger.io/docs/specification/about/)
		* [Kiota](https://microsoft.github.io/kiota/)
			* "Kiota is a command line tool for generating an API client to call any OpenAPI described API you are interested in. The goal is to eliminate the need to take a dependency on a different API SDK for every API that you need to call. Kiota API clients provide a strongly typed experience with all the features you expect from a high quality API SDK, but without having to learn a new library for every HTTP API."
- **Building**
	* [Build Simple Restful Api With Python and Flask Part 1 - Mukhammad Ginanjar Azie](https://medium.com/python-pandemonium/build-simple-restful-api-with-python-and-flask-part-1-fae9ff66a706)
	* [Building beautiful REST APIs using Flask, Swagger UI and Flask-RESTPlus](http://michal.karzynski.pl/blog/2016/06/19/building-beautiful-restful-apis-using-flask-swagger-ui-flask-restplus/)
- **Securing**
	- **General**
		* [OWASP API Security Project](https://www.owasp.org/index.php/OWASP_API_Security_Project)
		* [OWASP API Security Top 10](https://github.com/OWASP/API-Security)
		* [API Security Checklist](https://github.com/shieldfy/API-Security-Checklist/)
			* Checklist of the most important security countermeasures when designing, testing, and releasing your API
		* [API Maturity model](https://github.com/wiresecurity/APIMaturity)
		* [Code Patterns for API Authorization: Designing for Security - Tanner Prynn(2020)](https://research.nccgroup.com/2020/04/21/code-patterns-for-api-authorization-designing-for-security/)
			* "This post describes some of the most common design patterns for authorization checking in web application code. Comparisons are made between the design patterns to help understand when each pattern makes sense as well as the drawbacks of the pattern. For developers and architects, this post helps you to understand what the different code patterns look like and how to choose between them. For security auditors, the most effective approaches to auditing authorization controls are explained based on which pattern the code uses."
		* [Code Patterns for API Authorization: Designing for Security - Tanner Prynn(2020](https://research.nccgroup.com/2020/04/21/code-patterns-for-api-authorization-designing-for-security/)
		* [Black and Blue APIs: Attacker's and Defender's View of API Vulnerabilities -  Matt Tesauro(2022)](https://www.slideshare.net/mtesauro/black-and-blue-apis-attackers-and-defenders-view-of-api-vulnerabilities)
	- **Talks & Presentations**
		* [BOLA, IDOR, MA, BFLA. Welcome to the OWASP API Top 10! - Adam Fisher(BSidesSLC 2020)](https://www.youtube.com/watch?v=6Nu1UU2ny2I&list=PLqVzh0_XpLfSJ2Okt38acDdO_xu2zKYmK&index=11&t=0s)
		* [API Security: Tokens, Flows and the Big Bad Wolf -  Ingy Youssef(BSidesColombus(2019))](https://www.irongeek.com/i.php?page=videos/bsidescolumbus2019/bsidescmh2019-3-04-api-security-tokens-flows-and-the-big-bad-wolf-ingy-youssef)
			* OAuth Flows, OpenID Connect, tokens, nonces, gateways & all the fun API stuff. Well, there's always a big bad wolf, and APIs have lots of targets. Digital Transformations are rolling out more and more APIs, yesterday is different than today, the security model is changing, but in what ways? We need to secure APIs and be enablers of change and lock out the big bad wolf.
- **Testing**
	* **General**
		* [Security testing guide for JSON / REST APIs #1/3 - Ivan Novikov](https://medium.com/@d0znpp/security-testing-guide-for-json-rest-apis-1-3-38eddba67098)
		* [Simplifying API Pentesting With Swagger Files - David Yesland](https://rhinosecuritylabs.com/application-security/simplifying-api-pentesting-swagger-files/)
		* [Exploring Service APIs Through Test Automation - Amber Race(2020)](https://testautomationu.applitools.com/exploring-service-apis-through-test-automation/)
		* [API-Security-Empire](https://github.com/Cyber-Guy1/API-SecurityEmpire)
		* [How to Hack APIs in 2021 - Hakluke, Farah Hawa(2021)](https://labs.detectify.com/2021/08/10/how-to-hack-apis-in-2021/)
		* [MindAPI](https://github.com/dsopas/MindAPI)
			* "Organize your API security assessment by using MindAPI. It's free and open for community collaboration."
		* [How to Detect the Programming Language of an API - Dana Epp(2022)](https://danaepp.com/how-to-detect-the-programming-language-of-an-api)
		* [An API Security Testing Checklist… with a twist - Dana Epp(2023)](https://danaepp.com/an-api-security-testing-checklist-with-a-twist)
		* [5 simple questions to make your API pentest more successful - Dana Epp(2023)](https://danaepp.com/5-simple-questions-to-make-your-api-pentest-more-successful)
		* [How I fuzz and hack APIs? - Inderjeet Singh(2023)](https://rashahacks.com/how-i-fuzz-and-hack-api/)
	Testing of
	- **Talks/Presentations**
		* [Fundamentals of Hacking Web API's - Charles Shirer](https://www.youtube.com/watch?v=v66phijsNEg)
			* Penetration testing Web API's can be difficult without an effective approach, so Charles Shirer is here to provide you with a few tips and tricks!  Charles breaks down the fundamentals of hacking Web API's and the methodology that he has used during his career to perform successful and effective Web API penetration tests over the years.
		* [API hacking for the Actually Pretty Inexperienced hacker with Katie Paxton-Fear(OWASP DevSlop)](https://www.youtube.com/watch?v=qqmyAxfGV9c)
		* [API Security: Tokens, Flows and the Big Bad Wolf -  Ingy Youssef(BSidesColombus(2019))](https://www.irongeek.com/i.php?page=videos/bsidescolumbus2019/bsidescmh2019-3-04-api-security-tokens-flows-and-the-big-bad-wolf-ingy-youssef)
			* OAuth Flows, OpenID Connect, tokens, nonces, gateways & all the fun API stuff. Well, there's always a big bad wolf, and APIs have lots of targets. Digital Transformations are rolling out more and more APIs, yesterday is different than today, the security model is changing, but in what ways? We need to secure APIs and be enablers of change and lock out the big bad wolf.
		* [Hacking APIs:Workshop - Corey Ball(2022)](https://sway.office.com/HVrL2AXUlWGNDHqy?accessible=true)
	- **Postman**
		* [Better API Penetration Testing with Postman – Part 1 - Mic Whitehorn-Gillam(2019)](https://blog.secureideas.com/2019/03/better-api-penetration-testing-with-postman-part-1.html)
			* [Part 2](https://blog.secureideas.com/2019/03/better-api-penetration-testing-with-postman-part-2.html)
			* [Part 3](https://blog.secureideas.com/2019/04/better-api-penetration-testing-with-postman-part-3.html)
			* [Part 4](https://blog.secureideas.com/2019/06/better-api-penetration-testing-with-postman-part-4.html)
	- **Insomnia**
		* [Insomnia - Kong](https://github.com/Kong/insomnia)
			* Insomnia is a cross-platform REST client, built on top of Electron.
		* [Getting Started API Penetration Testing with Insomnia - Mic Whitehorn-Gillam(2020)](https://blog.secureideas.com/2020/04/getting-started-api-penetration-testing-with-insomnia.html)
- **Fuzzing**<a name="apifuzz"></a>
	- **Talks/Presentations/Videos**
		* [Automating API Penetration Testing using fuzzapi - AppSecUSA 2016](https://www.youtube.com/watch?v=43G_nSTdxLk)
	- **Tools
		* [restler-fuzzer](https://github.com/microsoft/restler-fuzzer)
			* "RESTler is the first stateful REST API fuzzing tool for automatically testing cloud services through their REST APIs and finding security and reliability bugs in these services."
		* [Fuzzapi](https://github.com/lalithr95/Fuzzapi/)
			* Fuzzapi is rails application which uses API_Fuzzer and provide UI solution for gem.
		* [API-fuzzer](https://github.com/Fuzzapi/API-fuzzer)
			* API Fuzzer which allows to fuzz request attributes using common pentesting techniques and lists vulnerabilities
		* [Automatic API Attack Tool - Imperva](https://github.com/imperva/automatic-api-attack-tool)
			* "Imperva's customizable API attack tool takes an API specification as an input, and generates and runs attacks that are based on it as an output. The tool is able to parse an API specification and create fuzzing attack scenarios based on what is defined in the API specification. Each endpoint is injected with cleverly generated values within the boundaries defined by the specification, and outside of it, the appropriate requests are sent and their success or failure are reported in a detailed manner. You may also extend it to run various security attack vectors, such as illegal resource access, XSS, SQLi and RFI, that are targeted at the existing endpoints, or even at non-existing ones. No human intervention is needed. Simply run the tool and get the results."
- **GraphQL**
	* See [GraphQL](#graphql) section below.
- **REST**
	- **101**
		* [Representational State Transfer - Wikipedia](https://en.wikipedia.org/wiki/Representational_state_transfer)
		* [RESTful Services, The Web Security Blind Spot](https://www.youtube.com/watch?feature=player_embedded&v=pWq4qGLAZHI#!)
			* [Blogpost](https://xiom.com/2016/10/31/restful-services-web-security-blind-spot/)
			* [Presentation Slides -pdf](https://xiomcom.files.wordpress.com/2016/10/security-testing-for-rest-applications-v6-april-2013.pdf)
		* [Learn REST: A Tutorial](http://rest.elkstein.org/)
		* [REST and Stateless Session IDs](https://appsandsecurity.blogspot.com/2011/04/rest-and-stateless-session-ids.html)	
		* [Beginner’s Guide to API(REST) security](https://introvertmac.wordpress.com/2015/09/09/beginners-guide-to-apirest-security/)
	- **Talks/Presentations/Videos**
		* [Introduction to RESTful APIs with Chris Wahl](https://www.youtube.com/watch?v=k00sfolsmp0&index=1&list=PL2rC-8e38bUU7Xa5kBaw0Cceo2NoI4mK-)
		* [Cracking and fixing REST services - Bill Sempf - Converge 2015](https://www.irongeek.com/i.php?page=videos/converge2015/track109-cracking-and-fixing-rest-services-bill-sempf)
			* REST, or Representational State Transfer, just refers to the protocol with which the whole Web works. No big. We are used to using REST with a browser, but there is more to it - we can write programs with REST. The problem is that writing properties and functions using the web's transfer protocol open them up to all of the security weaknesses of the web, and we know there are a few of those. Finding those bugs is just half of the battle - fixing them is a whole other story. You'll need the details, and you'll get them here.
		* [Deconstructing REST Security by David Blevins(DevoxxUSA2017)](https://www.youtube.com/watch?v=9CJ_BAeOmW0)
			* With an aggressive distaste for fancy terminology, this session delves into OAuth 2.0 as it pertains to REST and shows how it falls into two camps: stateful and stateless. The presentation also details a competing Amazon-style approach called HTTP Signatures and digs into the architectural differences of all three, with a heavy focus on the wire, showing actual HTTP messages and enough detail to have you thinking, “I could write this myself.”
	- **Attacking**
		* [Exploiting CVE-2017-8759: SOAP WSDL Parser Code Injection](https://www.mdsec.co.uk/2017/09/exploiting-cve-2017-8759-soap-wsdl-parser-code-injection/)
		* [Cracking and Fixing REST APIs - Bill Sempf](http://www.sempf.net/post/Cracking-and-Fixing-REST-APIs)
		* [Cracking and fixing REST services - Bill Sempf](http://www.irongeek.com/i.php?page=videos/converge2015/track109-cracking-and-fixing-rest-services-bill-sempf)
	- **Tools**
		* [Astra](https://github.com/flipkart-incubator/Astra)
			* REST API penetration testing is complex due to continuous changes in existing APIs and newly added APIs. Astra can be used by security engineers or developers as an integral part of their process, so they can detect and patch vulnerabilities early during development cycle. Astra can automatically detect and test login & logout (Authentication API), so it's easy for anyone to integrate this into CICD pipeline. Astra can take API collection as an input so this can also be used for testing apis in standalone mode.
		* [Susanoo](https://github.com/ant4g0nist/Susanoo)
			* Susanoo is a REST API security testing framework. 
		* [restler-fuzzer](https://github.com/microsoft/restler-fuzzer)
			* "RESTler is the first stateful REST API fuzzing tool for automatically testing cloud services through their REST APIs and finding security and reliability bugs in these services."
- **SOAP & WSDL**<a name="wsdl"></a>
	- **Learning/Reference**
		- **101**
			* [Microservices](https://en.wikipedia.org/wiki/Microservices)
			* [Service-Oriented-Architecture](https://en.wikipedia.org/wiki/Service-oriented_architecture)
			* [The S stands for Simple](http://harmful.cat-v.org/software/xml/soap/simple)
				* Satire(Only it's not) of a conversation about SOAP
	- **Talks & Presentations**
	- **Tools**
		* [WS-Attacker](https://github.com/RUB-NDS/WS-Attacker)
			* WS-Attacker is a modular framework for web services penetration testing. It is developed by the Chair of Network and Data Security, Ruhr University Bochum (http://nds.rub.de/ ) and the Hackmanit GmbH (http://hackmanit.de/).
		* [Damn Vulnerable Web Services dvws](https://github.com/snoopysecurity/dvws)
			* Damn Vulnerable Web Services is an insecure web application with multiple vulnerable web service components that can be used to learn real world web service vulnerabilities.
		* [WS-Attacks.org](http://www.ws-attacks.org/Welcome_to_WS-Attacks)
			* WS-Attacks.org is not a new web service standard by the OASIS Group or W3C; instead it presents the flaws of today's web service standards and implementations in regard to web service security! WS-Attacks.org aims at delivering the most comprehensive enumeration of all known web service attacks.
* **Reference**
	* [REST_Assessment_Cheat_Sheet.md - OWASP](https://github.com/OWASP/CheatSheetSeries/blob/3a8134d792528a775142471b1cb14433b4fda3fb/cheatsheets/REST_Assessment_Cheat_Sheet.md)
	* [RESTful API Best Practices and Common Pitfalls - Spencer Schneidenbach](https://medium.com/@schneidenbach/restful-api-best-practices-and-common-pitfalls-7a83ba3763b5)
	* [REST API Testing Strategy: What Exactly Should You Test? - Roy Mor(2019)](https://www.sisense.com/blog/rest-api-testing-strategy-what-exactly-should-you-test/)
	* [RESTful web services penetation testing - ]()
	* [Penetration Testing RESTful Web Services - Prakash Dhatti(2017)](http://blog.isecurion.com/2017/10/10/penetration-testing-restful-web-services/)
- **Tools**
	* [Postman - chrome plugin](https://chrome.google.com/webstore/detail/postman/fhbjgbiflinjbdggehcddcbncdddomop)
	* [restclient - Firefox addon](https://addons.mozilla.org/de/firefox/addon/restclient/)
	* [Astra](https://github.com/flipkart-incubator/Astra)
		* REST API penetration testing is complex due to continuous changes in existing APIs and newly added APIs. Astra can be used by security engineers or developers as an integral part of their process, so they can detect and patch vulnerabilities early during development cycle. Astra can automatically detect and test login & logout (Authentication API), so it's easy for anyone to integrate this into CICD pipeline. Astra can take API collection as an input so this can also be used for testing apis in standalone mode.
	* [mitmproxy2swagger](https://github.com/alufers/mitmproxy2swagger)
		* A tool for automatically converting mitmproxy captures to OpenAPI 3.0 specifications. This means that you can automatically reverse-engineer REST APIs by just running the apps and capturing the traffic.
	* [REST-Attacker](https://github.com/RUB-NDS/REST-Attacker)
		* REST-Attacker is an automated penetration testing framework for APIs following the REST architecture style. The tool's focus is on streamlining the analysis of generic REST API implementations by completely automating the testing process - including test generation, access control handling, and report generation - with minimal configuration effort. Additionally, REST-Attacker is designed to be flexible and extensible with support for both large-scale testing and fine-grained analysis.

--------------------------------------------------------------------------------------------------------------------------------

### <a name="backend-process">Backend Processing Technologies</a>
- **Images**<a name="bp-img"></a>
	- **101**
		* [ImageMagick](https://imagemagick.org/index.php)
		* [ImagegMagick - Wikipedia](https://en.wikipedia.org/wiki/ImageMagick)
	- **Articles/Blogposts/Writeups**
		* [ImageTragick/ImageMagick Is On Fire: CVE-2016–3714](https://imagetragick.com/)
		* [Playing with ImageTragick like it's 2016 - Alexis Danizan, Clément Amic(2021)](https://www.synacktiv.com/en/publications/playing-with-imagetragick-like-its-2016.html)
		* [ImageTragick: A Tragick Image Conversion Tale - INE](https://ine.com/blog/imagetragick-a-tragick-image-conversion-tale)
		* [ImageMagick - Shell injection via PDF password - Alex Infuhr(2020)](https://insert-script.blogspot.com/2020/11/imagemagick-shell-injection-via-pdf.html)
		* [ImageMagick: The hidden vulnerability behind your online images - Bryan Gonzalez(2022)](https://www.metabaseq.com/imagemagick-zero-days/)
	- **Papers**
	- **Presentations/Talks/Videos**
	* **Tools**
		* [imagetragick](https://github.com/dorkerdevil/ImageTragick_exploit)
			* A tool to exploit imagetragick vulnerability to gain remote code execution.
		* [CVE-2022-44268 Arbitrary File Read PoC - PNG generator](https://github.com/voidz0r/CVE-2022-44268)
			* This is a proof of concept of the ImageMagick bug discovered by https://www.metabaseq.com/imagemagick-zero-days/
- **PDFs**<a name="bp-pdf"></a>
	- **101**
		* [GhostScript](https://www.ghostscript.com/)
	- **Articles/Blogposts/Writeups**
	- **Papers**
	- **Presentations/Talks/Videos**
	* **Tools**


--------------------------------------------------------------------------------------------------------------------------------


### <a name="browsersec">Browser Security</a>
- **Browsers**
	- **101**
		* [Browser Security White Paper - X41-dsec.de](https://browser-security.x41-dsec.de/X41-Browser-Security-White-Paper.pdf)
		* [Browser Security Whitepaper - Cure53](https://cure53.de/browser-security-whitepaper.pdf/)
	- **Articles/Blogposts/Writeups**
	- **Papers**
		* [Self-Exfiltration: The Dangers of Browser-Enforced Information Flow Control](http://ericchen.me/self_exfiltration.pdf)
			* Abstract: Since the early days of Netscape, browser vendors and web security researchers have restricted out-going data based on its destination. The security argument accompanying these mechanisms is that they prevent sensitive user data from being sent to the attacker’s domain. However, in this paper, we show that regulating web information flow based on its destination server is an inherently flawed security practice. It is vulnerable to self-exfiltration attacks, where an adversary stashes stolen information in the database of a whitelisted site, then later independently connects to the whitelisted site to retrieve the information. We describe eight existing browser security mechanisms that are vulnerable to these “self-exfiltration” attacks. Furthermore, we discovered at least one exfiltration channel for each of the Alexa top 100 websites. None of the existing information flow control mechanisms we surveyed are sufficient to protect data from being leaked to the attacker. Our goal is to prevent browser vendors and researchers from falling into this trap by designing more systems that are vulnerable to self-exfiltration.
		* [How do we Stop Spilling the Beans Across Origins? - A primer on web attacks via cross-origin information leaks and speculative execution - aaj@google.com, mkwst@google.com](https://www.arturjanc.com/cross-origin-infoleaks.pdf)
	- **Presentations/Talks/Videos**
		* [Browser as Botnet - Brannon Dorsey - Radical Networks 2017](https://www.youtube.com/watch?v=GcXfu-EAECo)
			* When surfing the web, browsers download and execute arbitrary JavaScript code they receive from websites they visit. What if high-traffic websites served obfuscated code that secretly borrowed clock cycles from their client’s web browser as a means of distributed computing? In this talk I present research on the topic of using web browsers as zero-configuration, trojan-less botnets. The presentation includes a brief history of botnets, followed by an overview of techniques to build and deploy command-and-control botnet clients that run in-browser.
	* **Tools**
		* [White Lightning Attack Platform](https://github.com/TweekFawkes/White_Lightning)
	* **Chrome Specific**
		* [Chromium Sandbox](https://chromium.googlesource.com/chromium/src/+/master/docs/design/sandbox.md)
			* Sandbox leverages the OS-provided security to allow code execution that cannot make persistent changes to the computer or access information that is confidential. The architecture and exact assurances that the sandbox provides are dependent on the operating system. This document covers the Windows implementation as well as the general design.
		* [Chromium Cross-Origin Read Blocking (CORB)](https://chromium.googlesource.com/chromium/src/+/master/services/network/cross_origin_read_blocking_explainer.md)
		* [Chromium Sidechannel Threat Model: Post-Spectre Threat Model Re-Think(2018)](https://chromium.googlesource.com/chromium/src/+/master/docs/security/side-channel-threat-model.md)
		* [Security analysis of `<portal>` element - Michal Bentkowski](https://research.securitum.com/security-analysis-of-portal-element/)
			* [Code](https://github.com/securitum/research/tree/master/r2019_security-analysis-of-portal-element)
	- **Firefox Specific**
	- **Safari Specific**
		* [The Good, The Bad and The Ugly of Safari in Client-Side Attacks - bo0om, Wallarm Research](https://lab.wallarm.com/the-good-the-bad-and-the-ugly-of-safari-in-client-side-attacks-56d0cb61275a)
- **Browser Extensions**<a name="be"></a>
	- **Articles/Blogposts/Writeups**
		* [Attacking Browser Extensions](https://github.com/qll/attacking-browser-extensions)
		* [Botnet in the Browser: Understanding Threats Caused by Malicious Browser Extensions](https://arxiv.org/pdf/1709.09577.pdf)
		* [An in-depth look into Malicious Browser Extensions(2014)](http://blog.trendmicro.com/trendlabs-security-intelligence/an-in-depth-look-into-malicious-browser-extensions/)
		* [Game of Chromes: Owning the Web with Zombie Chrome Extensions - DEF CON 25 - Tomer Cohen](https://www.youtube.com/watch?v=pR4HwDOFacY)
		* [Chrome-botnet](https://github.com/i-tsvetkov/chrome-botnet)
		* [Malware in the browser: how you might get hacked by a Chrome extension(2016) - Maxime Kjaer](https://kjaer.io/extension-malware/)
		* [I Sold a Chrome Extension but it was a bad decision - Amit Agarwal](https://www.labnol.org/internet/sold-chrome-extension/28377/)
		* [Detecting Installed Extensions (Edge)(2017) - brokenbrowser.com](https://www.brokenbrowser.com/microsoft-edge-detecting-installed-extensions/)
		* [Finding Browser Extensions To Hunt Evil!(2016) - Brad Antoniewicz](https://umbrella.cisco.com/blog/2016/06/16/finding-browser-extensions-find-evil/)
		* [Sparse Bruteforce Addon Detection(2011) - James Kettle](https://www.skeletonscribe.net/2011/07/sparse-bruteforce-addon-scanner.html)
		* [Intro to Chrome addons hacking: fingerprinting(2012) - kotowicz](http://blog.kotowicz.net/2012/02/intro-to-chrome-addons-hacking.html)
		* [No Place Like Chrome - xorrior](https://www.xorrior.com/No-Place-Like-Chrome/)
		* [Democratizing Chrome Extension Security - Duo Security(2018)](https://duo.com/blog/crxcavator)
		* [Kicking the Rims – A Guide for Securely Writing and Auditing Chrome Extensions - Matthew Bryant(2018)](https://thehackerblog.com/kicking-the-rims-a-guide-for-securely-writing-and-auditing-chrome-extensions/index.html)	
		* [Anatomy of a basic extension - Wladimir Palant(2022)](https://palant.info/2022/08/10/anatomy-of-a-basic-extension/)
			* [Attack surface of extension pages](https://palant.info/2022/08/24/attack-surface-of-extension-pages/)
		* [Yes, fun browser extensions can have vulnerabilities too! - Wladimir Palant(2021)](https://palant.info/2021/12/20/yes-fun-browser-extensions-can-have-vulnerabilities-too/)
		* [Hidden in plain sight: the risks of browser extensions - multilogin.com(2021)](https://multilogin.com/blog/the-risks-of-browser-extensions/)
			* [Part 2](https://multilogin.com/blog/mitigating-risks-of-browser-extensions/)	
	- **Talks & Presentations**
		* [Offensive Browser Extension Development - Michael Weber(Derbycon7](https://www.youtube.com/watch?v=mKesEr1g4j0)
			* For the past few years, malware authors have abused the extension development functionality of Chrome and Firefox. More often than not, these extensions are abused for standard crimeware activities, such as ad click fraud, cryptocurrency mining, or stealing banking credentials. But this is only scratching the surface of what is possible if the appropriate browser APIs are abused. Extensions can act as a foothold into a target's internal network, provided a single user can be convinced to click two buttons. As a post-exploitation mechanism, extensions can be side-loaded with the ability to read and write files to disk. These actions will all be performed from the browser process(es) and likely go undetected by conventional endpoint protection solutions. This talk will discuss the creation, deployment, and usage of malicious browser extensions so that other red teamers can add this attack vector to their toolkit.
	- **Chrome Specific**
		* [Cross-Origin XMLHttpRequest - dev.chrome](https://developer.chrome.com/extensions/xhr#security-considerations)
		* [Chrome CSP: Interacting with - dev.chrome](https://developer.chrome.com/extensions/contentSecurityPolicy#interactions)
		* [Testing Extensions in Chromium Browsers - Nordpass - Parsia(2021)](https://parsiya.net/blog/2021-04-30-testing-extensions-in-chromium-browsers-nordpass/)
	- **Firefox Specific**
	- **Papers**
		* [Malicious Browser Extensions at Scale: Bridging the Observability Gap between Web Site and Browser - Louis F. DeKoven, Stefan Savage, Geoffrey M. Voelker, Nektarios Leontiadis](https://www.usenix.org/node/205856)
			* We present a methodology whereby users exhibiting suspicious online behaviors are scanned (with permission) to identify the set of extensions in their browser, and those extensions are in turn labelled based on the threat indicators they contain. We have employed this methodology at Facebook for six weeks, identifying more than 1700 lexically distinct malicious extensions. We use this labelling to drive user device clean-up efforts as well to report to antimalware and browser vendors.
			* [Paper](https://www.usenix.org/system/files/conference/cset17/cset17-paper-dekoven.pdf)
	- **Tools**
		* [extension_finder](https://github.com/brad-anton/extension_finder)
			* Python and PowerShell utilities for finding installed browser extensions, plug-ins and add-ons
		* [CSS Keylogger](https://github.com/maxchehab/CSS-Keylogging)
			* Chrome extension and Express server that exploits keylogging abilities of CSS.
		* [tarnish](https://github.com/mandatoryprogrammer/tarnish/)
			* tarnish is a static-analysis tool to aid researchers in security reviews of Chrome extensions.
		* [CRXcavator](https://crxcavator.io/docs#/README)
			* CRXcavator automatically scans the entire Chrome Web Store every 3 hours and produces a quantified risk score for each Chrome Extension based on several factors. These factors include permissions, inclusion of vulnerable third party javascript libraries, weak content security policies, missing details from the Chrome Web Store description, and more. Organizations can use this tool to assess the Chrome Extensions they have installed and to move towards implementing explicit allow (whitelisting) for their organization.
* **Exploiting**
	* [Smashing The Browser: From Vulnerability Discovery To Exploit](https://github.com/demi6od/Smashing_The_Browser)
		* Goes from introducing a fuzzer to producing an IE11 0day
	* [The Birth of a Complete IE11 Exploit Under the New Exploit Mitigations](https://www.syscan.org/index.php/download/get/aef11ba81927bf9aa02530bab85e303a/SyScan15%20Yuki%20Chen%20-%20The%20Birth%20of%20a%20Complete%20IE11%20Exploit%20Under%20the%20New%20Exploit%20Mitigations.pdf)
	* [BeEF Browser Exploitation Framework](http://beefproject.com/)
	* [BeEF](https://github.com/beefproject/beef)
		* Amid growing concerns about web-borne attacks against clients, including mobile clients, BeEF allows the professional penetration tester to assess the actual security posture of a target environment by using client-side attack vectors. Unlike other security frameworks, BeEF looks past the hardened network perimeter and client system, and examines exploitability within the context of the one open door: the web browser. BeEF will hook one or more web browsers and use them as beachheads for launching directed command modules and further attacks against the system from within the browser context.
	* [Browsers Gone Wild - Angelo Prado & Xiaoran Wang - BHAsia2015](https://www.youtube.com/watch?v=nsjCQlEsgW8)
		* In this talk, we will demonstrate and unveil the latest developments on browser specific weaknesses including creative new mechanisms to compromise confidentiality, successfully perform login and history detection, serve mixed content, deliver malicious ghost binaries without a C&C server, exploit cache/timing side channels to extract secrets from third-party domains, and leverage new HTML5 features to carry out more stealthy attacks. This is a practical presentation with live demos that will challenge your knowledge of the Same Origin Policy and push the limits of what is possible with today's web clients.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="css"></a> Cascading StyleSheets
* **101**
	* [CSS - Wikipedia](https://en.wikipedia.org/wiki/CSS)
	* [Cascading Style Sheets - W3C](https://www.w3.org/Style/CSS/Overview.en.html)
	* [CSS: Cascading Style Sheets - MozillaDevNetwork](https://developer.mozilla.org/en-US/docs/Web/CSS)


----------------------------------------------------------------------------------------------------------------------------------


### <a name="ct">HTTPS Certificates & Certificate Transparency</a>
- **101**
	* [Secure website certificate - Mozilla](https://support.mozilla.org/en-US/kb/secure-website-certificate)
	* [Let's Encrypt](https://letsencrypt.org/)
- **Certificates**
	* [Reflections on certificates, Part 1 - Enno Rey(2023)](https://theinternetprotocolblog.wordpress.com/2023/01/17/reflections-on-certificates-part-1/)
		* [Part 2](https://theinternetprotocolblog.wordpress.com/2023/02/12/reflections-on-certificates-part-2/)
- **Certificate Revocation**
	- **Articles/Blogposts**
		* [On CRLs, OCSP, and a Short Review of Why Revocation Checking Doesn't Work (for Browsers) - bt3gl](https://github.com/bt3gl/Pentesting_Toolkit/blob/master/Web_Hacking/guide_to_certs_and_cas.md)
- **Certificate Pinning**
	- **101**
		* [Understanding Certificate Pinning - Scott Contini(2020)](https://littlemaninmyhead.wordpress.com/2020/06/08/understanding-certificate-pinning/)
		* [Certificate and Public Key Pinning - OWASP](https://owasp.org/www-community/controls/Certificate_and_Public_Key_Pinning)
- **Certificate Transparency**
	- **101**
	* [Certificate.transparency.dev](https://certificate.transparency.dev/)
	* [Certificate Transparency - Mozilla](https://developer.mozilla.org/en-US/docs/Web/Security/Certificate_Transparency)
		* "Certificate Transparency is an open framework designed to protect against and monitor for certificate mis-issuances. It's defined in RFC 9162. With certificate transparency, newly-issued certificates are 'logged' to publicly-run, often independent CT logs — which maintain an append-only, cryptographically-assured record of issued TLS certificates."
	* [Certificate Transparency- Digicert](https://www.digicert.com/faq/certificate-transparency/overview.htm)
		* [Certificate Transparency: a bird's-eye view - Emily M. Stark(2020)](https://emilymstark.com/2020/07/20/certificate-transparency-a-birds-eye-view.html)
	- **Talks/Presentations/Videos**
		* [Abusing Certificate Transparency Or How To Hack Web Applications BEfore Installation - Hanno Bock](https://media.defcon.org/DEF%20CON%2025/DEF%20CON%2025%20presentations/DEFCON-25-Hanno-Boeck-Abusing-Certificate-Transparency-Logs.pdf)
- **HTTP Strict Transport Security**
	* [RFC 6797: HTTP Strict Transport Security (HSTS) - IETF](https://tools.ietf.org/html/rfc6797)
	* [HTTP Strict Transport Security - Wikipedia](https://en.wikipedia.org/wiki/HTTP_Strict_Transport_Security)
- **Domain Validation**
	* [Let's Attack Let's Encrypt - Haya Shulman](https://www.youtube.com/watch?v=jPXQcSMnosQ)
		* [Slides](https://i.blackhat.com/USA21/Wednesday-Handouts/US-21-Shulman-Lets-Attack-Lets_Encrypt.pdf)
		* In this work we show that two central design issues of the distributed domain validation of Let’sEncrypt make it vulnerable to downgrade attacks...
- **Tools**
	* [CTFR](https://github.com/UnaPibaGeek/ctfr)
		* Do you miss AXFR technique? This tool allows to get the subdomains from a HTTPS website in a few seconds. How it works? CTFR does not use neither dictionary attack nor brute-force, it just abuses of Certificate Transparency logs.
	* [Certificate Transparency Subdomains](https://github.com/internetwache/CT_subdomains)
		* An hourly updated list of subdomains gathered from certificate transparency logs.
	* [CertSpotter](https://github.com/SSLMate/certspotter)
		* Cert Spotter is a Certificate Transparency log monitor from SSLMate that alerts you when a SSL/TLS certificate is issued for one of your domains. Cert Spotter is easier than other open source CT monitors, since it does not require a database.  It's also more robust, since it uses a special certificate parser that ensures it won't miss certificates.
	* [CRTScan](https://github.com/AnikHasibul/crtscan)
	 	* Scan subdomains from certificate transparency logs
	 * [ctexposer](https://github.com/chris408/ct-exposer)
	 	* An OSINT tool that discovers sub-domains by searching Certificate Transparency logs 


----------------------------------------------------------------------------------------------------------------------------------


### <a name="cms">Content Management Systems
- **Agnostic**
	- **101**
	- **Articles/Blogposts/Writeups**
	- **Papers**
	- **Tools**
		* [WhatWeb](https://github.com/urbanadventurer/WhatWeb)
			* WhatWeb identifies websites. Its goal is to answer the question, "What is that Website?". WhatWeb recognises web technologies including content management systems (CMS), blogging platforms, statistic/analytics packages, JavaScript libraries, web servers, and embedded devices. WhatWeb has over 1500 plugins, each to recognise something different. WhatWeb also identifies version numbers, email addresses, account IDs, web framework modules, SQL errors, and more.
		* [w3af](https://github.com/andresriancho/w3af)
			* w3af: web application attack and audit framework, the open source web vulnerability scanner.
- **Adobe Experience Manager**
	- **101**
	- **Articles/Blogposts/Writeups**
	- **Papers**
	- **Tools**
		* [aem-hacker](https://github.com/0ang3el/aem-hacker)
			* Tools to identify vulnerable Adobe Experience Manager (AEM) webapps.
- **ColdFusion**<a name="coldfusion"></a>
	- **101**
	- **Articles/Blogposts/Writeups**
		* [Attacking Adobe ColdFusion](http://jumpespjump.blogspot.com/2014/03/attacking-adobe-coldfusion.html)
		* [ColdFusion Security Resources](https://www.owasp.org/index.php/ColdFusion_Security_Resources)
		* [ColdFusion for Penetration Testers](http://www.slideshare.net/chrisgates/coldfusion-for-penetration-testers)
	- **Papers**
	- **Tools**
- **Drupal**<a name="drupal"></a>
	* **101**
		* [Drupal](https://www.drupal.org/)
		* [Official Documentation](https://www.drupal.org/documentation)
		* [Drupal - Wikipedia](https://en.wikipedia.org/wiki/Drupal)
	* **Articles/Blogposts/Writeups**
		* [Drupal Security Checklist](https://github.com/gfoss/attacking-drupal/blob/master/presentation/drupal-security-checklist.pdf)
		* [Uncovering Drupalgeddon 2 - Checkpoint](https://research.checkpoint.com/uncovering-drupalgeddon-2/)
	* **Papers**
		* [Drupal SA-CORE-2019-003 远程命令执行分析](https://paper.seebug.org/821/)
	* **Tools**
		* [Drupal Attack Scripts](https://github.com/gfoss/attacking-drupal)
			* Set of brute force scripts and Checklist	
		* [Droopescan](https://github.com/droope/droopescan)
			* A plugin-based scanner that aids security researchers in identifying issues with several CMSs, mainly Drupal & Silverstripe.
- **Joomla**<a name="joomla"></a>
	- **101**
	- **Articles/Blogposts/Writeups**
		* [Highly Effective Joomla Backdoor with Small Profile](http://blog.sucuri.net/2014/02/highly-effective-joomla-backdoor-with-small-profile.html)
	- **Papers**
	- **Tools**
		* [JoomScan](https://www.owasp.org/index.php/Category:OWASP_Joomla_Vulnerability_Scanner_Project)
			* Joomla! is probably the most widely-used CMS out there due to its flexibility, user-friendlinesss, extensibility to name a few.So, watching its vulnerabilities and adding such vulnerabilities as KB to Joomla scanner takes ongoing activity.It will help web developers and web masters to help identify possible security weaknesses on their deployed Joomla! sites. No web security scanner is dedicated only one CMS. 
		* [JScanner](https://github.com/tampe125/jscanner/blob/master/README.md)
			* Analyze target Joomla! installation using several different techniques.
		* [JoomlaVS](https://github.com/rastating/joomlavs)
			* JoomlaVS is a Ruby application that can help automate assessing how vulnerable a Joomla installation is to exploitation. It supports basic finger printing and can scan for vulnerabilities in components, modules and templates as well as vulnerabilities that exist within Joomla itself.
- **Sharepoint**<a name="sharepoint"></a>
	- **101**
	- **Articles/Blogposts/Writeups**
	- **Papers**
	- **Tools**
		* [Sparty - Sharepoint/Frontpage Auditing Tool](https://github.com/alias1/sparty)
			* Sparty is an open source tool written in python to audit web applications using sharepoint and frontpage architecture. The motivation behind this tool is to provide an easy and robust way to scrutinize the security configurations of sharepoint and frontpage based web applications. Due to the complex nature of these web administration software, it is required to have a simple and efficient tool that gathers information, check access permissions, dump critical information from default files and perform automated exploitation if security risks are identified. A number of automated scanners fall short of this and Sparty is a solution to that.
- **Wordpress**<a name="wordpress"></a>
	- **101**
	- **Articles/Blogposts/Writeups**
	- **Papers**
	- **Tools**
	* [WPScan](https://github.com/wpscanteam/wpscan)
		* WPScan is a black box WordPress vulnerability scanner. 
	* [WPSeku](https://github.com/m4ll0k/WPSeku)
		* Wordpress Security Scanner


----------------------------------------------------------------------------------------------------------------------------------


### <a name="cookies"></a>Cookies & Tokens
- **101**
	* [HTTP cookie - Wikipedia](https://en.wikipedia.org/wiki/HTTP_cookie)
	* [Using HTTP cookies - MDN(Mozilla)](https://developer.mozilla.org/en-US/docs/Web/HTTP/Cookies)
	* [All About Cookies.org](https://www.allaboutcookies.org/cookies/)
	* [Cookiedatabase](https://cookiedatabase.org/)
		* "On Cookiedatabase.org you can consult information about cookies, Local Storage, pixels and other tracking technologies. You can also read the Data Passports we created about the services and organizations that create or use these technologies."
- **Articles/Blogposts/Writeups**
	* [Pass the Cookie and Pivot to the Clouds - wunderwuzzi](https://embracethered.com/blog/posts/passthecookie/)
	* [Demystifying Cookies and Tokens Security - HolyBugX](https://web.archive.org/web/20211207221248/https://securityflow.io/demystifying-cookies-and-tokens-security/)
		* [Code & Slides](https://github.com/HolyBugx/Demystifying-Cookies-and-Tokens-Security)
	* [Firefox: How a website could steal all your cookies - Pedro Oliveira(2020)](https://infosecwriteups.com/firefox-and-how-a-website-could-steal-all-of-your-cookies-581fe4648e8d)
	* [Pass the Cloud with a Cookie](https://misconfig.io/pass-the-cloud-with-cookie/)
	* [API Tokens: A Tedious Survey - Thomas Ptacek(2021)](https://fly.io/blog/api-tokens-a-tedious-survey/)
* **Talks/Presentations/Videos**
	* [Baking Your Anomalous Cookies - Jim Allee(NolaCon2019)](https://www.irongeek.com/i.php?page=videos/nolacon2019/nolacon-2019-d-09-baking-your-anomalous-cookies-jim-allee)
		* I hacked Fortnite! Actually it was a vulnerable cookie found on several domains owned by Epic Games that allowed me to hijack traffic of users of their websites, steal session tokens and of course, BeEF hook em'. I will describe my journey from creating a custom cookie fuzzing tool (Anomalous Cookie) to help identify vulnerable cookies, to creating a framework for 'Cookie Baking'. Cookie Baking is the technique of creating or modifying a cookie in a users' local Cookie Jar (this includes stuffing with malicious payloads, affiliate tags, fuzz-strings and more). I will also provide insight into the Bug Bounty process, how Google responded to my request for them to protect local cookies at rest, and how I created WHID-Injected Cookies! ;)
	* [Got Cookies? Exploiting Vulnerabilities in Cookie Based Authentication - Harsh Bothra(Mayhem2021 RTV)](https://www.youtube.com/watch?v=CE4w8uUi0Mw&list=PLruly0ngXhPEOYACFCsUfoGehbjNflUfu&index=2)
		* Abstract: Cookies are a widely used way to enable authentication in many of the applications out there. Over time, there has been a lot of security implications in Cookie-Based Authentication and new methods such as token-based authentication has entered the picture. Although many modern applications are adapting Token-Based authentication, Cookie-Based Authentication is still alive and can be observed in the wild.  In this talk, we will look at various attack scenarios that can be exploited in the wild if the application is using cookies for authentication, tracking, personalization, or some value reflections.
- **Papers**
- **Tools**
	* [CookieMonster](https://github.com/iangcarroll/cookiemonster)
		* [Blogpost](https://ian.sh/cookiemonster)
		* 🍪 CookieMonster helps you detect and abuse vulnerable implementations of stateless sessions.
- **JWTs**<a name="cjwt"></a>
	- **101**
		* [RFC 7519: JSON Web Token (JWT)](https://www.rfc-editor.org/rfc/rfc7519)
		* [RFC 7515: JSON Web Signature (JWS)](https://www.rfc-editor.org/rfc/rfc7515)
		* [RFC 8725: JSON Web Token Best Current Practices(2020)](https://www.rfc-editor.org/rfc/rfc8725.html)
		* [RFC 7797: JSON Web Signature (JWS) Unencoded Payload Option](https://www.rfc-editor.org/rfc/rfc7797)
	- **Articles**
		* [JWTs? JWKs? ‘kid’s? ‘x5t’s? Oh my! - CallanHP(2017)](https://redthunder.blog/2017/06/08/jwts-jwks-kids-x5ts-oh-my/)
		* [Abusing JWT public keys without the public key - SilentSignal(2021)](https://blog.silentsignal.eu/2021/02/08/abusing-jwt-public-keys-without-the-public-key/)
		* [Forget SQL Injection Have you Heard of Jwt Injections? - Nikhil T Nair](https://medium.com/@BeepBoop0/forget-sql-injection-have-you-heard-of-jwt-injections-59562011c93c)
		* [How to test for JWT attacks? - Ahmed Elsherif(2022)](https://systemweakness.com/how-to-test-for-jwt-attacks-513da89abe94)
		* [JWT attacks - PortSwigger](https://portswigger.net/web-security/jwt)
	- **Talks**
	- **Tools**	
		* [MyJWT](https://github.com/tyki6/MyJWT)
			* A cli for cracking, testing vulnerabilities on Json Web Token(JWT) 
		* [jwt-fuzzer](https://github.com/andresriancho/jwt-fuzzer)
			* jwt-fuzzer is a simple command line tool that creates multiple, potentially invalid, strings from an initial JSON Web Token.
- **PASETO**
	- **101**
		* [A Thorough Introduction to PASETO - Randall Degges(2019)](https://developer.okta.com/blog/2019/10/17/a-thorough-introduction-to-paseto)
- **SameSite**
	* [The great SameSite confusion - Julien Cretel(2021)](https://jub0bs.com/posts/2021-01-29-great-samesite-confusion/)
	* [Bypassing SameSite cookie restrictions - PortSwigger](https://portswigger.net/web-security/csrf/bypassing-samesite-restrictions)
- **Strict-Transport-Security**
	* [Strict-Transport-Security - MDN](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security


----------------------------------------------------------------------------------------------------------------------------------


### <a name="csp"></a> Content Security Policy (CSP)
- **101**
	* [Intro to content Security Policy](http://www.html5rocks.com/en/tutorials/security/content-security-policy/)
	* [Content Security Policy Level 3 - w3c Feb2019](https://w3c.github.io/webappsec-csp/)
	* [Content Security Policy - Wikipedia](https://en.wikipedia.org/wiki/Content_Security_Policy)
	* [Content Security Policy - Google Web Fundamentals](https://developers.google.com/web/fundamentals/security/csp/)
	* [Content Security Policy Reference](https://content-security-policy.com/)
	* [CSP Cheat Sheet - Scott Helme](https://scotthelme.co.uk/csp-cheat-sheet/)
	* [Content Security Policy Cheat Sheet - OWASP](https://github.com/OWASP/CheatSheetSeries/blob/master/cheatsheets/Content_Security_Policy_Cheat_Sheet.md)
- **Articles/Papers/Talks/Writeups**
	* [Content Security Policy - An Introduction - Scott Helme(2014)](https://scotthelme.co.uk/content-security-policy-an-introduction/)
	* [GitHub's post-CSP journey - githubengineering](https://githubengineering.com/githubs-post-csp-journey/)
	* [CVE-2018-5175: Universal CSP strict-dynamic bypass in Firefox - Masato Kinugawa](https://mksben.l0.cm/2018/05/cve-2018-5175-firefox-csp-strict-dynamic-bypass.html)
	* [CSP and SVG - c0nrad](https://c0nradsc0rner.com/2016/08/30/csp-and-svg/)
		* "The tl;dr is make sure object-src is ‘none’ if you’re not using it. Using this “attack” you can reflect SVGs to get execution even in a CSP controlled environment. This is just another recipe to add to your books for bypassing CSP (insecure directives, JSONP, base offset, encoding)."
	* [Host a web app on Twitter in a single Tweet - @mikeptweet(2017)](https://hackernoon.com/host-a-web-app-on-twitter-in-a-single-tweet-9aed28bdb350)
	* [Content Security Policy (CSP) Bypasses - ghostlulz](http://ghostlulz.com/content-security-policy-csp-bypasses/)
	* [How To Bypass CSP By Hiding JavaScript In A PNG Image - @Menin_theMiddle](https://www.secjuice.com/hiding-javascript-in-png-csp-bypass/)
		* "TL;DR - Using HTML Canvas you can hide any JavaScript code (or an entire library) into a PNG image by converting each source code character into a pixel. The image can then be uploaded onto a trusted website like Twitter or Google (usually whitelisted by CSP) and then loaded as a remote image in a HTML document. Finally, by using the canvas getImageData method, it's possible to extract the "hidden JavaScript" from the image and execute it. Sometimes this could lead to a Content-Security-Policy bypass making an attacker able to include an entire and external JavaScript library."
	* [Content-Security-Policy (CSP) Bypass Techniques - Bhavesh Thakur(2020)](https://medium.com/@bhaveshthakur2015/content-security-policy-csp-bypass-techniques-e3fa475bfe5d)
	* [Hunting nonce-based CSP bypasses with dynamic analysis - Gareth Hayes(2021)](https://portswigger.net/research/hunting-nonce-based-csp-bypasses-with-dynamic-analysis)
	* [Bypass CSP? No problem - Okhonko Philipp(2021)](http://archive.volgactf.ru.s3.us-east-1.amazonaws.com/volgactf_2021/slides/VolgaCTF_2021_Ohonko.pdf)
- **Tools**
	* [JSONBee](https://github.com/zigoo0/JSONBee)
		* A ready to use JSONP endpoints to help bypass content security policy of different websites.
- **Miscellaneous**


----------------------------------------------------------------------------------------------------------------------------------


### <a name="cors"></a> Cross-Origin Resource Sharing (CORS)
- **101**
	* [Cross-Origin Resource Sharing (CORS) - Mozilla Dev Docs](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
	* [CORS Findings: Another Way to Comprehend - Ryan Leese](https://www.trustedsec.com/2018/04/cors-findings/)
	* [Same Origin Policy - dev.mozilla](https://developer.mozilla.org/en-US/docs/Web/Security/Same-origin_policy)
	* [Same Origin Policy - W3C](https://www.w3.org/Security/wiki/Same_Origin_Policy)
	* [Cross-Origin Resource Sharing (CORS) - dev.mozilla](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
	* [Cross-Origin Resource Sharing - w3.org](https://www.w3.org/TR/cors/)
		* This document defines a mechanism to enable client-side cross-origin requests. Specifications that enable an API to make cross-origin requests to resources can use the algorithms defined by this specification. If such an API is used on `http://example.org` resources, a resource on `http://hello-world.example` can opt in using the mechanism described by this specification (e.g., specifying `Access-Control-Allow-Origin: http://example.org` as response header), which would allow that resource to be fetched cross-origin from `http://example.org`.
	* [Private Network Access(aka CORS-RFC1918) - W3C(2022)](https://wicg.github.io/private-network-access/)
		* This document specifies modifications to Fetch and HTML which are intended to mitigate the risks associated with unintentional exposure of devices and servers on a client’s internal network to the web at large.
- **Articles/Blogposts/Writeups**
	* [JSON API's Are Automatically Protected Against CSRF, And Google Almost Took It Away.](https://github.com/dxa4481/CORS)
	* [Exploiting Misconfigured CORS (Cross Origin Resource Sharing) - Geekboy](https://www.geekboy.ninja/blog/exploiting-misconfigured-cors-cross-origin-resource-sharing/)
	* [Arbitrary Reflected Origin - Evan J(2016)](https://ejj.io/misconfigured-cors/)
	* [Do You Really Know CORS? - Grzegorz Mirek](https://dzone.com/articles/do-you-really-know-cors)
	* [3 Ways to Exploit Misconfigured Cross-Origin Resource Sharing (CORS) - Pavan Kumar J(2018)](https://www.we45.com/blog/3-ways-to-exploit-misconfigured-cross-origin-resource-sharing-cors)
	* [Three C-Words of Web App Security: Part 1 – CORS - Mic Whitehorn-Gillam(2018)](https://blog.secureideas.com/2018/07/three-c-words-of-web-app-security-part-1-cors.html)
	* [CORS Findings: Another Way to Comprehend - Ryan Leese(2018)
	* [Same-Origin Policy: From birth until today - Alex Nikolova(2019)](https://research.aurainfosec.io/same-origin-policy/)
		* "In this blog post I will talk about Cross-Origin Resource Sharing (CORS) between sites on different domains, and how the web browser’s Same Origin Policy is meant to facilitate CORS in a safe way. I will present data on cross-origin behaviour of various versions of four major browsers, dating back to 2004. I will also talk about recent security bugs (CVE-2018-18511, CVE-2019-5814 and CVE-2019-9797) I discovered in the latest versions of Firefox, Chrome and Opera which allows stealing sensitive images via Cross-Site Request Forgery (CSRF)."
	* [Cross-Origin Resource Sharing (CORS) - Ghostlulz](http://ghostlulz.com/cross-origin-resource-sharing-cors/)
	* [How do we Stop Spilling the Beans Across Origins? A primer on web attacks via cross-origin information leaks and speculative execution - aaj@google.com, mkwst@google.com(2022)](https://www.arturjanc.com/cross-origin-infoleaks.pdf)
	* [Exploiting CORS Misconfigurations - attack ships on fire(2022)](https://attackshipsonfi.re/p/exploiting-cors-misconfigurations)
	* [Cross-Origin Resource Sharing (CORS) | Complete Guide - Rana Khalil(2022)](https://www.youtube.com/watch?v=t5FBwq-kudw)
		* "In this video, we cover the theory behind Cross-Origin Resource Sharing (CORS) vulnerabilities, how to find these types of vulnerabilities from both a white box and black box perspective, how to exploit them and how to prevent them."
	* [Cross Origin Resource Sharing - CORS  - secure-cookie.io](https://secure-cookie.io/fundamental/cors/)
- **Presentations/Talks/Videos**
	* [Exploiting CORS Misconfigurations For Bitcoins And Bounties by James Kettle(AppSecEU 2017)](https://www.youtube.com/watch?v=wgkj4ZgxI4c)
		* Cross-Origin Resource Sharing (CORS) is a mechanism for relaxing the Same Origin Policy to enable communication between websites via browsers. It's already widely understood that certain CORS configurations are dangerous. In this presentation, I'll skim over the old knowledge then coax out and share with you an array of under-appreciated but dangerous subtleties and implications buried in the CORS specification. I'll illustrate each of these with recent attacks on real websites, showing how I could have used them to steal bitcoins from two different exchanges, partially bypass Google's use of HTTPS, and requisition API keys from numerous others. I'll also show how CORS blunders can provide an invaluable link in crafting exploit chains to pivot across protocols, exploit the unexploitable via server and client-side cache poisoning, and even escalate certain open redirects into vulnerabilities that are actually notable.
		* [Blogpost](http://blog.portswigger.net/2016/10/exploiting-cors-misconfigurations-for.html)
	* [To CORS! The cause of, and solution to, your SPA problems! - Tim Tomes, Kevin Cody](https://www.irongeek.com/i.php?page=videos/derbycon9/1-06-to-cors-the-cause-of-and-solution-to-your-spa-problems-tim-lanmaster53-tomes-kevin-cody)
		* Cross-Origin Resource Sharing (CORS) is a complex and commonly misunderstood concept that is often implemented wrong for the right reasons. In this talk we will explain the Same-Origin Policy (SOP) and CORS in an easy to understand way. We will then discuss poor implementations of CORS and the resulting issues. We'll continue by releasing research done on a number of development frameworks exposing poorly designed CORS libraries that default to the most dangerous behavior. We'll then demonstrate why all of this matters by conducting a distributed attack against the most common CORS configuration using audience participation and a new tool. Finally, we'll discuss the safest ways to implement CORS. The custom tools used during the talk will be released along with the presentation.
	* [Of CORS it's Exploitable! What's Possible with Cross-Origin Resource Sharing? - Rebecca Deck(CircleCityCon2019)](https://www.irongeek.com/i.php?page=videos/circlecitycon2019/track-1-05-of-cors-its-exploitable-whats-possible-with-cross-origin-resource-sharing-rebecca-deck)
		* Cross-origin resource sharing (CORS) is extremely common on modern web apps, but scanning tools are terrible at analyzing CORS policy. If testers really understand CORS policy, a damaging exploit is often not far away. Is it possible to force a user to do something significant? Does using a GUID offer any protection? Does the authentication mechanism really protect against cross-origin attacks? Is it really risky to allow all origins? Do pre-flight requests always help? CORS requests get tricky very quickly and scanning tools do not have a good understanding of the intricacies that surface during actual application testing. A quick and dirty JavaScript exploit will put the issue to rest and eliminate hours of theoretical debate. This presentation covers how CORS works and how to find misconfigurations. Dozens of actual applications are distilled into examples demonstrate CORS protections and JavaScript code to bypass them. A basic knowledge of CORS and JavaScript will be helpful to understand the exploit code, but no special background is necessary to grasp the basics of CORS configuration.
- **Papers**
	* [Request and Conquer: Exposing Cross-Origin Resource Size - Tom Van Goethem, Mathy Vanhoef, Frank Piessens, Wouter Joosen(2016)](https://www.usenix.org/conference/usenixsecurity16/technical-sessions/presentation/vangoethem)
		* In this paper, we explore various techniques that can be employed to reveal the size of resources. As a result of this in-depth analysis, we discover several design flaws in the storage mechanisms of browsers, which allows an adversary to expose the exact size of any resource in mere seconds. Furthermore, we report on a novel size-exposing technique against Wi-Fi networks. We evaluate the severity of our attacks, and show their worrying consequences in multiple real-world attack scenarios. Furthermore, we propose an improved design for browser storage, and explore other viable solutions that can thwart size-exposing attacks.
	* [Cross-Origin Read Blocking (CORB) - Google](https://chromium.googlesource.com/chromium/src/+/master/services/network/cross_origin_read_blocking_explainer.md)
		* This document outlines Cross-Origin Read Blocking (CORB), an algorithm by which dubious cross-origin resource loads may be identified and blocked by web browsers before they reach the web page. CORB reduces the risk of leaking sensitive data by keeping it further from cross-origin web pages. In most browsers, it keeps such data out of untrusted script execution contexts. In browsers with Site Isolation, it can keep such data out of untrusted renderer processes entirely, helping even against side channel attacks.
- **Tools**
	* [CORStest](https://github.com/RUB-NDS/CORStest/blob/master/README.md)
		* A simple CORS misconfiguration scanner
	* [CORS Exploitation Framework(CEF)](https://github.com/lanmaster53/cef)
		* A proof-of-concept tool for conducting distributed exploitation of permissive CORS configurations.
	* [Corsy](https://github.com/s0md3v/Corsy)
		* Corsy is a lightweight program that scans for all known misconfigurations in CORS implementations.
	* [CorsMe](https://github.com/Shivangx01b/CorsMe)
		* A cors misconfiguration scanner tool based on golang with speed and precision in mind!
- **Miscellaneous**
- **Arbitrary Reflected Origin**
	* ejj.io/misconfigured-Cors
	https://gist.github.com/ejcx/74c7d7727767ca3aafa6
- **Cross-Origin-Read-Blocking**
	* [Cross-Origin Read Blocking (CORB) - Google](https://chromium.googlesource.com/chromium/src/+/master/services/network/cross_origin_read_blocking_explainer.md)
		* This document outlines Cross-Origin Read Blocking (CORB), an algorithm by which dubious cross-origin resource loads may be identified and blocked by web browsers before they reach the web page. CORB reduces the risk of leaking sensitive data by keeping it further from cross-origin web pages. In most browsers, it keeps such data out of untrusted script execution contexts. In browsers with Site Isolation, it can keep such data out of untrusted renderer processes entirely, helping even against side channel attacks.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="dom"></a>Document Object Model(DOM)
- **101**
	* [DOM - Standard(spec.whatwg)](https://dom.spec.whatwg.org/)
- **Articles/Blogposts/Presentations/Talks/Writeups**
	* [How the Document Object Model Works in JavaScript – DOM Tutorial for Beginners - Dickson Boateng((2023)](https://www.freecodecamp.org/news/javascript-dom/)
- **Talks & Presentations**
	* [Securing the DOM from the Bottom Up - Mike Samuel(BSides Cleveland2019)](https://www.irongeek.com/i.php?page=videos/bsidescleveland2019/bsides-cleveland-c-01-securing-the-dom-from-the-bottom-up-mike-samuel)
		* 18 years have passed since Cross-Site Scripting (XSS) became the single most common security problem in web applications. Since then, numerous efforts have been proposed to detect, fix or mitigate it, but these piecemeal efforts have not combined to make it easy to produce XSS-free code. This talk explains how Google's security team has achieved a high-level of safety against XSS and related problems by integrating tools to make it easier for developers to produce secure software than vulnerable, and to bound the portion of a codebase that could contribute to a vulnerability. We will show how this works in practice and end with advice on how to achieve the same results on widely-used, open-source stacks and new browser mechanisms that will make it much easier to achieve high-levels of security with good developer experience.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="esi"></a>Edge Side Include(esi)
- **101**
	* [ESI Language Specification 1.0 - w3.org](https://www.w3.org/TR/esi-lang/)
	* [Edge Side Includes - Wikipedia](https://en.wikipedia.org/wiki/Edge_Side_Includes)
	* [What Is Edge Side Includes (ESI)? - keycdn](https://www.keycdn.com/support/edge-side-includes)
- **Articles/Blogposts/Presentations/Talks/Writeups**
	* [How the Document Object Model Works in JavaScript – DOM Tutorial for Beginners - Dickson Boateng((2023)](https://www.freecodecamp.org/news/javascript-dom/)
	* [Beyond XSS: Edge Side Include Injection - Louis Dion-Marcil(2018)](https://www.gosecure.net/blog/2018/04/03/beyond-xss-edge-side-include-injection/)
	* [ESI Injection Part 2: Abusing specific implementations - Philippe Arteau(2019)](https://www.gosecure.net/blog/2019/05/02/esi-injection-part-2-abusing-specific-implementations/)
	* [Exploring the World of ESI Injection - Sudhanshu Rajbhar(2022)](https://infosecwriteups.com/exploring-the-world-of-esi-injection-b86234e66f91)
- **Talks & Presentations**


--------------------------------------------------------------------------------------------------------------------------------


#### <a name="electron"></a>Electron
- **101**
	* [Electron.js](https://www.electronjs.org/)
	* [Electron (software framework) - Wikipedia](https://en.wikipedia.org/wiki/Electron_(software_framework))
	* [Electron(code)](https://github.com/electron/electron)
	* [Pentesting Electron Applications 101 - ](https://blog.yeswehack.com/yeswerhackers/exploitation/pentesting-electron-applications/)
	* [awesome-electronjs-hacking](https://github.com/doyensec/awesome-electronjs-hacking)
		* "A curated list of awesome resources about Electron.js (in)security"
- **Articles/Blogposts/Writeups**
	* [no-sandbox](https://github.com/sickcodes/no-sandbox)
		* No Sandbox - Applications That Run Chromium and Chrome Without The Sandbox. TL;DR exploits in these browser based applications are already sandboxed escaped: https://no-sandbox.io/
	* [From Markdown to RCE in Atom](https://statuscode.ch/2017/11/from-markdown-to-rce-in-atom/)
	* [As It Stands - Electron Security - 2016](http://blog.scottlogic.com/2016/03/09/As-It-Stands-Electron-Security.html)
	* [As It Stands - Update on Electorn Security - 2016](http://blog.scottlogic.com/2016/06/01/An-update-on-Electron-Security.html)
	* [Modern Alchemy: Turning XSS into RCE](https://blog.doyensec.com/2017/08/03/electron-framework-security.html)
	* [Build cross platform desktop XSS, it’s easier than you think by Yosuke Hasegawa - CodeBlue16](https://www.slideshare.net/codeblue_jp/cb16-hasegawa-en)
	* [Modern Alchemy: Turning XSS into RCE - doyensec](https://blog.doyensec.com/2017/08/03/electron-framework-security.html)
	* [From Markdown to RCE in Atom - statuscode.ch](https://statuscode.ch/2017/11/from-markdown-to-rce-in-atom/)
	* [Instrumenting Electron Apps for Security Testing - Paolo Stagno](https://blog.doyensec.com/2018/07/19/instrumenting-electron-app.html)
	* [Signature Validation Bypass Leading to RCE In Electron-Updater - Lorenzo Stella(2020)](https://blog.doyensec.com/2020/02/24/electron-updater-update-signature-bypass.html)
	* [The App Sandbox - Charlie Hess(Slack2020)](https://slack.engineering/the-app-sandbox/)
	* [Discord Desktop app RCE - Masato Kinugawa(2020)](https://mksben.l0.cm/2020/10/discord-desktop-rce.html)
	* [Electron APIs Misuse: An Attacker’s First Choice - Luca Carettoni, Lorenzo Stella(2021)](https://blog.doyensec.com/2021/02/16/electron-apis-misuse.html)
	* [Getting Started with Pentesting Electron Applications - cornerpirate(2021)](https://cornerpirate.com/2021/02/11/pentesting-electron-applications/)
	* [Attack Surface Analysis - Part 1 - Application Update: 'A Novel Way to Bypass Executable Signature Checks with Electron' - Parsia(2021)](https://parsiya.net/blog/2021-01-08-attack-surface-analysis-part-1-application-update-a-novel-way-to-bypass-executable-signature-checks-with-electron/)
	* [Discord Desktop - Remote Code Execution - s1r1us(2021)](https://blog.electrovolt.io/posts/discord-rce/)
	* [Visual Studio Code Jupyter Notebook RCE - Luca Carettoni(2022)](https://blog.doyensec.com/2022/10/27/jupytervscode.html)
	* [Quasar: Compromising Electron Apps - Michael Taggart(2022)](https://taggart-tech.com/quasar-electron/)
	* [1-click RCE in Electron Applications - sharbarkin](https://shabarkin.notion.site/1-click-RCE-in-Electron-Applications-501c2e96e7934610979cd3c72e844a22)
	* [Multiple ways to break Electron applications -Kevin(Mizu)(2022)](https://slides.com/kevin-mizu/electron-cve-2022-3133)
	* [Diving Into Electron Web API Permissions - Robert Dick(2022)](https://blog.doyensec.com/2022/09/27/electron-api-default-permissions.html)
	* [Security Review for Electron JS applications](https://github.com/shabarkin/CodeAllTheThings/tree/main/Electron%20JS)
		* "The CodeAllTheThings is a list of threat sinks used in the manual security source code review for application security."
	* [electron-research](https://github.com/msrkp/electron-research)
- **Documentation**
	* [Electron Documentation](https://electronjs.org/docs)
	* [Security, Native Capabilities, and Your Responsibility - Electron Documentation](https://electron.atom.io/docs/tutorial/security/)
- **Papers**
- **Talks & Presentations**
	* [MarkDoom: How I Hacked Every Major IDE in 2 Weeks - Matt Austin, LevelUp 2017](https://www.youtube.com/watch?v=nnEnwJbiO-A)
	* [Electron - Build cross platform desktop XSS, it’s easier than you think by Yosuke Hasegawa - [CB16] ](https://www.youtube.com/watch?v=-j1DPPf9Z4U)
	* [Electronegativity - A Study of Electron Security - Carettoni(2017)](https://www.blackhat.com/docs/us-17/thursday/us-17-Carettoni-Electronegativity-A-Study-Of-Electron-Security.pdf)
	* [Electron Security Checklist - A guide for developers and auditors - Luca Carettoni(2017)](https://www.blackhat.com/docs/us-17/thursday/us-17-Carettoni-Electronegativity-A-Study-Of-Electron-Security-wp.pdf)
	* [App.SetAsDefaultRCEClient - Juho Nurminen(Disobey2020)](https://www.youtube.com/watch?v=27sBPwN2bn8&list=PLLvAhAn5sGfiZKg9GTUzljNmuRupA8igX&index=17)
		* We detail three different approaches for exploiting Windows scheme handlers — two of them application-specific and one applicable to Electron apps more generally — and show how Windows Universal Naming Convention can present a significant risk for command injection. We also demonstrate a small tool for exploiting the Chrome DevTools protocol. While most of the issues discussed in this talk have already been mitigated on several levels, the Electron team has failed to publicly document which versions of the framework are vulnerable. And while Electron's new tightened release cycle means that vulnerable versions have already reached EOL, when developers are unaware that a vulnerability exists, there is little incentive to upgrade. With this talk, we aim to fix that lack of incentive. In addition to the technical details of the seven vulnerabilities, we provide insight into the disclosure process itself, the various types of programs intended to facilitate it, and their shortcomings. In particular we present our experiences with Zero Day Initiative, who acquire high-impact vulnerabilities, and Mattermost, one of the affected vendors running a responsible disclosure program.
- **Published Exploits**
	* [ CVE-2018-15685 - Electron WebPreferences Remote Code Execution Finding](https://www.contrastsecurity.com/security-influencers/cve-2018-15685)
- **Tools**
	* [electron-run-shell-example](https://github.com/martinjackson/electron-run-shell-example?files=1)
		* An HTML5 stand alone app using GitHub Electron (Chrome engine + Node.js) -- this is a GUI wrapper example that runs and process output of a bash shell command.
	* [Electronegativity](https://github.com/doyensec/electronegativity)
		* Electronegativity is a tool to identify misconfigurations and security anti-patterns in Electron-based applications.


--------------------------------------------------------------------------------------------------------------------------------


#### <a name="encoding"></a>Encoding
- **101**
- **Articles/Blogposts/Writeups**
	* [Charset Comparison Table](http://l0.cm/encodings/table/)


--------------------------------------------------------------------------------------------------------------------------------


#### <a name="fido2"></a>FIDO2/CTAP
- **101**
	* [FIDO Alliance - Wikipedia](https://en.wikipedia.org/wiki/FIDO_Alliance)
	* [FIDO2 - FIDO Alliance](https://fidoalliance.org/fido2/)
	* [How FIDO Works - FIDO Alliance](https://fidoalliance.org/how-fido-works/)
- **Articles/Blogposts/Writeups**
	* [FIDO2: Solving the Password Problem - Nils Amiet(2019)](https://research.kudelskisecurity.com/2019/10/08/fido2-solving-the-password-problem/)
	* [FIDO2 Deep Dive: Attestations, Trust model and Security - Nils Amiet(2020](https://research.kudelskisecurity.com/2020/02/12/fido2-deep-dive-attestations-trust-model-and-security/)
	* [Getting Rid of Passwords with FIDO2 and W3C WebAuthn - Michael Grafnetter(2020)](https://sector.ca/sessions/getting-rid-of-passwords-with-fido2-and-w3c-webauthn/)
- **Tools**


--------------------------------------------------------------------------------------------------------------------------------


#### <a name="fsapi"></a>
- **101**
	* [File System Access - W3C(2023)](https://wicg.github.io/file-system-access/)
	* [File System Access API - MDN](https://developer.mozilla.org/en-US/docs/Web/API/File_System_Access_API)
- **Articles/Blogposts/Writeups**
	* [The File System Access API: simplifying access to local files - Pete LePage, Thomas Steiner(2023)](https://developer.chrome.com/articles/file-system-access/)
- **Talks/Presentations**
	* [Internal Affairs: Hacking File System Access from the Web - Matthew Weeks(BHUSA2021)](https://www.youtube.com/watch?v=DI2Vw-QRl_k)
		* [Slides](https://i.blackhat.com/USA21/Wednesday-Handouts/us-21-Internal-Affairs-Hacking-File-System-Access-From-The-Web.pdf)
		* The File System Access API deployed to browsers this year is the current version of a W3C draft to give websites, with user approval, the ability to read, write, and edit files and folders the user selects on their devices, an outgrowth of an earlier proposal called Native File System. It has been released and deployed in many Chromium-based browsers. Despite a number of security features implemented in the API, this presentation will show several ways in which a hostile website may gain arbitrary code execution and slip malicious code past operating system and security product scans, or even detailed, manual inspection.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="swf"></a>Flash/SWF
- **Articles/Blogposts/Writeups**
	* [Testing for Cross-Site-Flashing - OWASP](https://www.owasp.org/index.php/Testing_for_Cross_site_flashing_(OTG-CLIENT-008)\)
	* [Security Domains, Application Domains, and More in ActionScript 3.0](http://www.senocular.com/flash/tutorials/contentdomains/)
	* [The old is new, again. CVE-2011-2461 is back!](https://www.slideshare.net/ikkisoft/the-old-is-new-again-cve20112461-is-back)
		* As a part of an ongoing investigation on Adobe Flash SOP bypass techniques, we identified a vulnerability affecting old releases of the Adobe Flex SDK compiler. Further investigation traced the issue back to a well known vulnerability (CVE20112461), already patched by Adobe. Old vulnerability, let's move on? Not this time. CVE20112461 is a very interesting bug. As long as the SWF file was compiled with a vulnerable Flex SDK, attackers can still use this vulnerability against the latest web browsers and Flash plugin. Even with the most recent updates, vulnerable Flex applications hosted on your domain can be exploited. In this presentation, we will disclose the details of this vulnerability (Adobe has never released all technicalities) and we will discuss how we conducted a large scale analysis on popular websites, resulting in the identification of numerous Alexa Top 50 sites vulnerable to this bug. Finally, we will also release a custom tool and a Burp plugin capable of detecting vulnerable SWF applications. 
	* Advanced Flash Vulnerabilities in Youtube Writeups Series
		* [Advanced Flash Vulnerabilities in Youtube – Part 1](https://opnsec.com/2017/08/advanced-flash-vulnerabilities-in-youtube-part-1/)
		* [Advanced Flash Vulnerabilities in Youtube – Part 2](https://opnsec.com/2017/08/advanced-flash-vulnerabilities-in-youtube-part-2/)
		* [Advanced Flash Vulnerabilities in Youtube – Part 3](https://opnsec.com/2017/08/advanced-flash-vulnerabilities-in-youtube-part-3/)
	* [Decode Adobe Flex AMF protocol](http://blog.dornea.nu/2015/06/22/decode-adobe-flex-amf-protocol/)	
	* [Finding XSS vulnerabilities in flash files.](https://olivierbeg.com/finding-xss-vulnerabilities-in-flash-files/)
	* [XSS and CSRF via SWF Applets (SWFUpload, Plupload)](https://nealpoole.com/blog/2012/05/xss-and-csrf-via-swf-applets-swfupload-plupload/)
	* [WordPress Flash XSS in flashmediaelement.swf - cure53](https://gist.github.com/cure53/df34ea68c26441f3ae98f821ba1feb9c)
	* [WordPress Flash XSS in flashmediaelement.swf - cure53](https://gist.github.com/cure53/df34ea68c26441f3ae98f821ba1feb9c)
	* [Security Domains, Application Domains, and More in ActionScript 3.0 - senocular](http://www.senocular.com/flash/tutorials/contentdomains/)
	* [Testing for Cross site flashing (OTG-CLIENT-008) - OWASP](https://www.owasp.org/index.php/Testing_for_Cross_site_flashing_(OTG-CLIENT-008))
	* [XSS and CSRF via SWF Applets (SWFUpload, Plupload) - Neal Poole](https://nealpoole.com/blog/2012/05/xss-and-csrf-via-swf-applets-swfupload-plupload/)
	* [Getting started with AMF Flash Application Penetration Testing ! - nerdint](https://nerdint.blogspot.com/2019/10/getting-started-with-amf-flash.html)
- **RIA**
	* [Analyzing the Crossdomain Policies of Flash Applications - Analyzing the Crossdomain Policies of Flash Applications - Dongseok Jang, Aishwarya Venkataraman, G. Michael Sawka, Hovav Shacham(2011)](https://hovav.net/ucsd/dist/crossdomain.pdf)
	* Adobe: “Cross-domain policy file usage recommendationsfor Flash Player” - http://www.adobe.com/devnet/flashplayer/articles/cross_domain_policy.html
	* Oracle: “Cross-Domain XML Support” - http://www.oracle.com/technetwork/java/javase/plugin2-142482.html#CROSSDOMAINXML
	* MSDN: “Making a Service Available Across Domain Boundaries” - http://msdn.microsoft.com/en-us/library/cc197955(v=vs.95).aspx
	* MSDN: “Network Security Access Restrictions in Silverlight” -http://msdn.microsoft.com/en-us/library/cc645032(v=vs.95).aspx
	* Stefan Esser: “Poking new holes with Flash Crossdomain PolicyFiles” http://www.hardened-php.net/library/poking_new_holes_with_flash_crossdomain_policy_files.html
	* Jeremiah Grossman: “Crossdomain.xml Invites Cross-siteMayhem” http://jeremiahgrossman.blogspot.com/2008/05/crossdomainxml-invites-cross-site.html
	* Google Doctype: “Introduction to Flash security “ - http://code.google.com/p/doctype-mirror/wiki/ArticleFlashSecurity
	https://www.youtube.com/watch?v=RNt_e0WR1sc
- **Securing**
	* [HardenFlash](https://github.com/HaifeiLi/HardenFlash)
		* Patching Flash binary to stop Flash exploits and zero-days
- **Tools**
	* [ParrotNG](https://github.com/ikkisoft/ParrotNG/releases)
		* ParrotNG is a Java-based tool for automatically identifying vulnerable SWF files, built on top of swfdump. One JAR, two flavors: command line tool and Burp Pro Passive Scanner Plugin.
	[deblaze](http://blog.dornea.nu/2015/06/22/decode-adobe-flex-amf-protocol/)
		* Performs method enumeration and interrogation against flash remoting end points.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="ghostscript"></a>GhostScript
- **101**
- **Articles/Blogposts/Writeups**
- **Papers**
- **Tools**



--------------------------------------------------------------------------------------------------------------------------------


### <a name="graphql"></a> GraphQL
- **101**
	* [Introduction to GraphQL - GraphQL.org](https://graphql.org/learn/)
	* [Queries and Mutations - GraphQL.org](https://graphql.org/learn/queries/)
	* [Introspection - GraphQL.org](https://graphql.org/learn/introspection/)
	* [HowToGraphQL.com](https://www.howtographql.com/)
	* [Security Points to Consider Before Implementing GraphQL - Kristopher Sandoval(2017)](https://nordicapis.com/security-points-to-consider-before-implementing-graphql/)
	* [Why and how to disable introspection query for GraphQL APIs - wallarm(2019)](https://lab.wallarm.com/why-and-how-to-disable-introspection-query-for-graphql-apis/)
	* [GraphQL Cheat Sheet - OWASP](https://cheatsheetseries.owasp.org/cheatsheets/GraphQL_Cheat_Sheet.html)
	* [A Facebook GraphQL crash course - PHWD](https://www.facebook.com/notes/phwd/a-facebook-graphql-crash-course/1189337427822946)
	* [Introducing the Apollo GraphQL data stack - ApolloGraphQL](https://www.apollographql.com/blog/introducing-the-apollo-graphql-data-stack-5d005312cbd0)
	* [The GraphQL stack: How everything fits together - Sashko Stubailo](https://www.apollographql.com/blog/the-graphql-stack-how-everything-fits-together-35f8bf34f841)
- **Articles/Blogposts/Writeups**
	* [GraphQL - Hacktricks](https://book.hacktricks.xyz/pentesting/pentesting-web/graphql#tools)
	* [poc-graphql](https://github.com/righettod/poc-graphql)
		* Research on GraphQL from an AppSec point of view.	
	* [GraphQL - Mahmoud M. Awali](https://docs.google.com/presentation/d/12CQH2XXlZKhU1g5fFWg6S2GBEktHnExe0F-K8sUgvOE/edit#slide=id.gb4b9ded4d4_1_317)
	* [ GraphQL Batching Attack  - wallarm(2019)](https://lab.wallarm.com/graphql-batching-attack/)
	* [Practical GraphQL attack vectors - jondow.eu](https://jondow.eu/practical-graphql-attack-vectors/)
	* [A Hacker’s Guide to the Shopify GraphQL API 🚀](https://github.com/Shopify/bugbounty-resources/blob/master/graphql/main_guide.md)
	* [Looting GraphQL Endpoints for Fun and Profit - @theRaz0r(2017)](https://raz0r.name/articles/looting-graphql-endpoints-for-fun-and-profit/)
	* [GraphQL - Security Overview and Testing Tips - Paolo Stagno(2018)](https://blog.doyensec.com/2018/05/17/graphql-security-overview.html)
	* [GraphQL vs REST API model, common security test cases for GraphQL endpoints - just_a_noob(2019)](https://medium.com/@apkash8/graphql-vs-rest-api-model-common-security-test-cases-for-graphql-endpoints-5b723b1468b4)
	* [How to exploit GraphQL endpoint: introspection, query, mutations & tools - YesWeHack](https://blog.yeswehack.com/yeswerhackers/how-exploit-graphql-endpoint-bug-bounty/)
	* [The 5 Most Common GraphQL Security Vulnerabilities - Aidan Noll(2020)](https://carvesystems.com/news/the-5-most-common-graphql-security-vulnerabilities/)
	* [GraphQL path enumeration for better permission testing - deesee.xyz(2020)](https://blog.deesee.xyz/graphql/security/2020/04/13/graphql-permission-testing.html)	
	* [That single GraphQL issue that you keep missing - Tomasz Swiadek, Andrea Brancaleoni(2021)](https://blog.doyensec.com/2021/05/20/graphql-csrf.html)
	* [Hacking GraphQL for Fun and Profit (1) - Understanding GraphQL Basics - busk3r(2021)](https://www.secjuice.com/hacking-graphql-for-fun-and-profit-part-1-understanding-graphql-basics/)
	* [Hacking GraphQL for Fun and Profit (2): Methodology & Examples - busk3r(2021)](https://www.secjuice.com/hacking-graphql-for-fun-and-profit-part-2-methodology-and-examples/)
	* [Exploiting GraphQL - Shubham Shah(2021)](https://blog.assetnote.io/2021/08/29/exploiting-graphql/)
	* [Practical GraphQL attack vectors - Sebastian Mihalache(2021)](https://securitycafe.ro/2021/10/01/practical-graphql-attack-vectors/)
	* [A Primer for Testing the Security of GraphQL APIs - Alex Leahu(2021)](https://blog.forcesunseen.com/a-primer-for-testing-the-security-of-graphql-apis)
	* [Lessons Learned While Pentesting GraphQL - Sean Verity(2022)](https://www.blackhillsinfosec.com/lessons-learned-while-pentesting-graphql/)
	* [GraphQL exploitation – All you need to know - Theodoros Danos(2023)](https://cybervelia.com/?p=736)
	- **Securing**
		* [Securing GraphQL. Part 1 - wallarm](https://lab.wallarm.com/securing-and-attacking-graphql-part-1-overview/)
- **Talks/Presentations/Videos**
	* [An Attackers View of Serverless and GraphQL Apps - Abhay Bhargav(AppSecCali2019)](https://www.youtube.com/watch?v=xr2YX5JbDbM)
		* This talk presents a red-team perspective of the various ways in which testers can discover and exploit serverless and/or GraphQL driven applications to compromise sensitive information, and gain a deeper foothold into database services, IAM services and other other cloud components. The talk will have some demos that will demonstrate practical attacks and attack possibilities against Serverless and GraphQL applications.
	* [REST in Peace: Abusing GraphQL to Attack Underlying Infrastructure - Matthew Szymanski(Derbycon2019)](https://www.irongeek.com/i.php?page=videos/derbycon9/2-09-rest-in-peace-abusing-graphql-to-attack-underlying-infrastructure-matthew-szymanski)
		* [BugCrowd LevelUp0x5 Version of the talk](https://www.bugcrowd.com/resources/webinars/rest-in-peace-abusing-graphql-to-attack-underlying-infrastructure/)
		* GraphQL is a query language for APIs set to replace RESTful architecture. The use of this technology has achieved rapid adoption and is now leveraged by companies such as GitHub, Credit Karma, and PayPal. Companies such as Hacker One and New Relic have suffered from critical vulnerabilities hidden within GraphQL endpoints. In this talk we will learn enough about GraphQL to be dangerous. Demonstrate how to use the technology?s intricacies against itself while taking advantage of implementation errors and misconfigurations. Examine GraphQL specific attacks as well as tried and true techniques adapted to fit into the GraphQL context. Then walk through how to carry out these attacks efficiently and effectively, introducing a tool to help automate and streamline the process.
	* [Introduction To GraphQL | Penetration Test - CyberSecurityTV(2020)](https://www.youtube.com/watch?v=iSZ0RrCrpf4)
		* "GraphQL is an API standard such as REST and SOAP. It is a modern query langauge which is being used by a number of applications. In this episode we have discussed different attacks on GraphQL such as Introspection query, Broken Access Control, DoS attack, Injection etc as well prevention. Hope this helps you to become a better testers."
	* [Finding Your Next Bug: GraphQL - InsiderPHD(2020)](https://www.youtube.com/watch?v=jyjGneKJynk)
		* GraphQL is becoming the next big API technology for developers, but with new technology comes new risk, and for us that means bounties! In this video, I cover everything GraphQL, from how it works to what kind of bugs are common. Next time we're going to expand on this and I'll show you how to do this live!
	* [Attacking GraphQL's Auto-Correct - Somdev Sangwan(Null Ahmedabad(2021)](https://www.youtube.com/watch?v=ElQmEn-6dpE&t=1980s)
	* [Damn GraphQL - Defending and Attacking APIs - Dolev Farhi(BSides Vancouver(2021)](https://www.youtube.com/watch?v=EVRf708-zq4&list=PLWHo0G0HmBgdwICgoEOdWHkDD6C9FJuhw&index=17)
		* With the uprising of GraphQL as a technology, a query language made by Facebook, security professionals must be ready for the day GraphQL hits their company’s networks. In this talk, we will walk through GraphQL basics, followed by a deep dive into the various GraphQL attack vectors, from Information Gathering to Denial of Service and Injections.   Additionally, we will discuss a recent security platform release - Damn Vulnerable GraphQL Application (DVGA), a platform made for security practitioners to learn GraphQL and its various weaknesses in a safe testing environment.
- **Tools**
	* [graphql-api-monitor](https://gitlab.com/dee-see/graphql-api-monitor)
	* [GraphQL - Demo Vulnerable API](https://github.com/CarveSystems/vulnerable-graphql-api)
		* A simple GraphQL API demonstrating several common vulnerabilities.
	* [GraphQL Voyager](https://github.com/APIs-guru/graphql-voyager)
		* Represent any GraphQL API as an interactive graph. It's time to finally see the graph behind GraphQL.
	* [inql](https://github.com/doyensec/inql)
		* A security testing tool to facilitate GraphQL technology security auditing efforts. Can be used as a script or burpsuite extension.
	* [graphql-path-enum](https://gitlab.com/dee-see/graphql-path-enum)
		* [Blogpost](https://blog.deesee.xyz/graphql/security/2020/04/13/graphql-permission-testing.html)
		* Tool that lists the different ways of reaching a given type in a GraphQL schema.
	* [Altair GraphQL Client](https://altair.sirmuel.design/)
	* [graphw00f](https://github.com/dolevf/graphw00f)
		* graphw00f (inspired by wafw00f) is the GraphQL fingerprinting tool for GQL endpoints, it sends a mix of benign and malformed queries to determine the GraphQL engine running behind the scenes. graphw00f will provide insights into what security defences each technology provides out of the box, and whether they are on or off by default.  Specially crafted queries cause different GraphQL server implementations to respond uniquely to queries, mutations and subscriptions, this makes it trivial to fingerprint the backend engine and distinguish between the various GraphQL implementations.
	* [BatchQL](https://github.com/assetnote/batchql)
		* GraphQL security auditing script with a focus on performing batch GraphQL queries and mutations 
	* [GraphQL IDE](https://github.com/andev-software/graphql-ide)
		* An extensive IDE for exploring GraphQL API's 
	* [GraphQL Cop](https://github.com/dolevf/graphql-cop)
		* GraphQL Cop is a small Python utility to run common security tests against GraphQL APIs. GraphQL Cop is perfect for running CI/CD checks in GraphQL. It is lightweight, and covers interesting security issues in GraphQL.
	* [GraphQL Threat Matrix](https://github.com/nicholasaleks/graphql-threat-matrix)
		* GraphQL threat framework used by security professionals to research security gaps in GraphQL implementations 
	* [inql](https://github.com/doyensec/inql)
		* A security testing tool to facilitate GraphQL technology security auditing efforts. InQL can be used as a stand-alone script or as a Burp Suite extension.
	* [CrackQL](https://github.com/nicholasaleks/CrackQL)
		* "CrackQL is a versatile GraphQL penetration testing tool that exploits poor rate-limit and cost analysis controls to brute-force credentials and fuzz operations."
	* [Graphicator](https://github.com/cybervelia/graphicator)
		* Graphicator is a GraphQL "scraper" / extractor. The tool iterates over the introspection document returned by the targeted GraphQL endpoint, and then re-structures the schema in an internal form so it can re-create the supported queries. When such queries are created is using them to send requests to the endpoint and saves the returned response to a file.Erroneous responses are not saved. By default the tool caches the correct responses and also caches the errors, thus when re-running the tool it won't go into the same queries again.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="html"></a>Hyper Text Markup Language HTML
* **101**
	* [HTML - spec.whatwg.org](https://html.spec.whatwg.org/multipage/)
	* [HTML 5 Standards](http://w3c.github.io/html/)
* **Articles/Blogposts/Presentations/Talks/Writeups**
	* [The HTML Handbook - Flavio Copes](https://www.freecodecamp.org/news/the-html-handbook/)
	* [HTML Punctuation Symbols, Punctuation Entities and ASCII Character Code Reference - toptotal.com](https://www.toptal.com/designers/htmlarrows/punctuation/)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="http"></a>Hyper Text Transport Protocol (HTTP)
- **Fetch Standard**
	* [Fetch Living Standard — 2019/7/16 - whatwg](https://fetch.spec.whatwg.org/#concept-fetch)
		* The Fetch standard defines requests, responses, and the process that binds them: fetching.
- **101**
	* [RFC 2068: Hypertext Transfer Protocol -- HTTP/1.1](https://www.ietf.org/rfc/rfc2068.txt)
	* [RFC 2616: Hypertext Transfer Protocol -- HTTP/1.1](https://www.ietf.org/rfc/rfc2616.txt)
	* [http-decision-diagram](https://github.com/for-GET/http-decision-diagram)
		* An activity diagram to describe the resolution of HTTP response status codes, given various headers, implemented via semantical callbacks.
	* [Basics of HTTP - MDN WebDocs](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP)
	* [An Overview of HTTP - MDN WebDocs](https://developer.mozilla.org/en-US/docs/Web/HTTP/Overview)
	* [Robots.txt](http://www.robotstxt.org/)
	* [The HTTP crash course nobody asked for - fasterthanlime(2022)](https://fasterthanli.me/articles/the-http-crash-course-nobody-asked-for)
- **HTTP Tools**
	* [curl](https://curl.se/)
		* command line tool and library for transferring data with URLs (since 1998)
		* [Everything curl - the book](https://curl.se/book.html)
	* [HTTPWTF - Tim Perry(2020)](https://httptoolkit.com/blog/http-wtf/)
	* [Hurl](https://github.com/Orange-OpenSource/hurl)
		* Hurl is a command line tool that runs HTTP requests defined in a simple plain text format. It can chain requests, capture values and evaluate queries on headers and body response. Hurl is very versatile: it can be used for fetching data, testing HTTP sessions and testing XML / JSON APIs.
- **Caching**
	* [RFC 7234: Hypertext Transfer Protocol (HTTP/1.1): Caching](https://httpwg.org/specs/rfc7234.html)
		* The Hypertext Transfer Protocol (HTTP) is a stateless application-level protocol for distributed, collaborative, hypertext information systems. This document defines HTTP caches and the associated header fields that control cache behavior or indicate cacheable response messages.
	* [Browser Caching Checker - GiftOfSpeed](https://www.giftofspeed.com/cache-checker/)
	* [Cache-Control Recommendations - April King(2021)](https://pokeinthe.io/2021/09/13/cache-control-recommendations/)
	* [Cache Me If You Can: Exposing your application using caching features - Philippe Arteau(2019)](https://gosecure.github.io/presentations/2019-02-26-confoo_mtl/Cache_Me_If_You_Can.pdf)
- **Certificates**
	* [Wildcard Certs, Not Quite The Star - Sean Wright(2017)](https://blog.sean-wright.com/wildcard-certs-not-quite-the-star/)
	* [Revocation is broken - Scott Helme(2017)](https://scotthelme.co.uk/revocation-is-broken/)
- **HTTP Headers**
	- **101**
		* [HTTP headers - MDN(Mozilla)](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers)
		* [List of HTTP header fields - Wikipedia](https://en.wikipedia.org/wiki/List_of_HTTP_header_fields)
	- **'Security' Headers**
		* [HTTP Strict Transport Security - cio.gov](https://https.cio.gov/hsts/)
		* [IETF RFC 7034: HTTP Header Field X-Frame-Options](https://tools.ietf.org/html/rfc7034)
		* [OWASP Secure Headers Project](https://www.owasp.org/index.php/OWASP_Secure_Headers_Project)
		* [Guidelines for Setting Security Headers - Isaac Dawson](https://www.veracode.com/blog/2014/03/guidelines-for-setting-security-headers)
		* [HTTP Security Headers - A Complete Guide - Charlie Belmer(2019)](https://nullsweep.com/http-security-headers-a-complete-guide/)
	- **User-Agents**
		- **101**
			* [User-Agent - Wikipedia](https://en.wikipedia.org/wiki/User_agent)
			* [User-Agent - MDN(Mozilla)](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/User-Agent)
		- **Tools**
			* [Security Analyser User Agents](https://developers.whatismybrowser.com/useragents/explore/software_type_specific/security-analyser/)
				* We've got 141 Security Analyser User Agents in our database. This is a listing of them.
	- **Injection of**
		* [Identifying & Escalating HTTP Host Header Injection attacks - goswamiijaya(2020)](https://infosecwriteups.com/identifying-escalating-http-host-header-injection-attacks-7586d0ff2c67)
	- **X-Forwarded-For**
			* [X-Forwarded-For Header - Chad Duffey(2020)](https://www.chadduffey.com/2020/04/proxyheaders.html)
			* [The perils of the “real” client IP - adam p(2022)](https://adam-p.ca/blog/2022/03/x-forwarded-for/)
- **HTTP Methods**
	* [Detecting and Exploiting the HTTP PUT Method](http://www.smeegesec.com/2014/10/detecting-and-exploiting-http-put-method.html)
- **HTTP Objects**
	* [Object MetaInformation](https://www.w3.org/Protocols/HTTP/Object_Headers.html#public)
- **HTTP Parameters**
* **HTTP Pipelining**
	- **101**
		* [HTTP pipelining - Wikipedia](https://en.wikipedia.org/wiki/HTTP_pipelining)
	- **Articles/Blogposts/Writeups**
		* [Using HTTP Pipelining to hide requests - digininja](https://digi.ninja/blog/pipelining.php)
- **HTTP Signatures**
	* [Ensuring Message Integrity with HTTP Signatures - Sathya Bandara(2019)](https://medium.com/@technospace/ensuring-message-integrity-with-http-signatures-86f121ac9823)
	* [Signing HTTP Messages - webconcepts.info](http://webconcepts.info/specs/IETF/I-D/cavage-http-signatures.html)
	* [Digitally Signed HTTP(S) Requests - Adobe Audience Manager](https://docs.adobe.com/content/help/en/audience-manager/user-guide/implementation-integration-guides/receiving-audience-data/real-time-outbound-transfers/digitally-signed-http-requests.html)
- **HTTP Verbs**
	* [RFC 7231: Hypertext Transfer Protocol (HTTP/1.1): Semantics and Content](https://tools.ietf.org/html/rfc7231)
	* [Exploiting HTTP Verbs - Osanda Malith Jayathissa(2015)](https://osandamalith.com/2015/06/14/exploiting-http-verbs/)
- **Syntax & Routing**
	* [RFC 7230: Hypertext Transfer Protocol (HTTP/1.1): Message Syntax and Routing](https://httpwg.org/specs/rfc7230.html)
		* The Hypertext Transfer Protocol (HTTP) is a stateless application-level protocol for distributed, collaborative, hypertext information systems. This document provides an overview of HTTP architecture and its associated terminology, defines the "http" and "https" Uniform Resource Identifier (URI) schemes, defines the HTTP/1.1 message syntax and parsing requirements, and describes related security concerns for implementations.
- **HTTP2**<a name="http2"></a>
	- **101**
		* [Introduction to HTTP/2 -  Ilya Grigorik, Surma(Google)](https://developers.google.com/web/fundamentals/performance/http2)
		* [http2 explained  - Daniel Stenberg](https://daniel.haxx.se/http2/)
	- **Articles/Blogposts/Writeups**
		* [HTTP/2: The Sequel is Always Worse - James Kettle(2022)](https://portswigger.net/research/http2)
	- **Talks/Presentations/Videos**
		* [HTTP/2 & QUIC - Teaching Good Protocols To Do Bad Things - Catherine (Kate) Pierce, Vyrus(PHV-Defcon2016)](https://www.youtube.com/watch?v=zoHjVrRUFQ4)
			* The meteoric rise of SPDY, HTTP/2, and QUIC has gone largely unremarked upon by most of the security field. QUIC is an application-layer UDP-based protocol that multiplexes connections between endpoints at the application level, rather than the kernel level. HTTP/2 (H2) is a successor to SPDY, and multiplexes different HTTP streams within a single connection. More than 10% of the top 1 Million websites are already using some of these technologies, including much of the 10 highest traffic sites. Whether you multiplex out across connections with QUIC, or multiplex into fewer connections with HTTP/2, the world has changed. We have a strong sensation of Déjà vu with this work and our 2014 Black Hat USA MPTCP research. We find ourselves discussing a similar situation in new protocols with technology stacks evolving faster than ever before, and Network Security is largely unaware of the peril already upon it. This talk briefly introduces QUIC and HTTP/2, covers multiplexing attacks beyond MPTCP, discusses how you can use these techniques over QUIC and within HTTP/2, and discusses how to make sense of and defend against H2/QUIC traffic on your network. We will also demonstrate, and release, some tools with these techniques incorporated.
- **HTTP3**<a name="http3"></a>
	- **101**
		* [HTTP/3 explained - Daniel Stenberg](https://http3-explained.haxx.se/en)
		* [HTTP/3: Everything you need to know about the next-generation web protocol - John Leyden(2020)](https://portswigger.net/daily-swig/http-3-everything-you-need-to-know-about-the-next-generation-web-protocol)
	- **Articles/Blogposts/Writeups**
		* [A story of leaking uninitialized memory from Fastly - Emil Lerner(2022)](https://medium.com/@emil.lerner/leaking-uninitialized-memory-from-fastly-83327bcbee1f)
		* [HTTP/3 Prioritization Demystified - Robin Marx(2022)](https://calendar.perfplanet.com/2022/http-3-prioritization-demystified/)
	- **Talks/Presentations/Videos**
		* [HTTP3 Security - Robin Marx(2021)](https://www.youtube.com/watch?v=Mx8hDbQmj7I)
			* [Slides](https://github.com/rmarx/http3-for-webdevs/blob/main/presentations/HTTP3andQUIC_OWASP_aug2021.pdf)
- **HTTP Parameter Pollution**
	- **101**
		* [HTTP Parameter Pollution - Imperva](https://www.imperva.com/learn/application-security/http-parameter-pollution/)
			* HTTP Parameter Pollution (HPP) is a Web attack evasion technique that allows an attacker to craft a HTTP request in order to manipulate or retrieve hidden information. This evasion technique is based on splitting an attack vector between multiple instances of a parameter with the same name. Since none of the relevant HTTP RFCs define the semantics of HTTP parameter manipulation, each web application delivery platform may deal with it differently. In particular, some environments process such requests by concatenating the values taken from all instances of a parameter name within the request. This behavior is abused by the attacker in order to bypass pattern-based security mechanisms.
	- **Articles/Blogposts/Writeups**	
		* [Client-side HTTP parameter pollution (reflected) - PortSwigger](https://portswigger.net/kb/issues/00501400_client-side-http-parameter-pollution-reflected)
		* [Client-side HTTP parameter pollution (stored) - PortSwigger](https://portswigger.net/kb/issues/00501401_client-side-http-parameter-pollution-stored)
		* [HTTP Parameter Pollution (English) - onehackman(2019)](https://medium.com/@onehackman/http-parameter-pollution-english-90fd5eec7a3b)
	- **Talks/Presentations/Videos**
		* [HTTP Parameter Pollution - Luca Carettoni, Stefano diPaola(OWASP EU09 Poland)](https://owasp.org/www-pdf-archive/AppsecEU09_CarettoniDiPaola_v0.8.pdf)
- **Articles/Blogposts/Presentations/Talks/Writeups**
	* [HTTP Made Really Easy: A Practical Guide to Writing Clients and Servers - James Marshall(2012)](https://www.jmarshall.com/easy/http/)
	* [HTTP Evasion](http://noxxi.de/research/http-evader-explained-8-borderline-robustness.html)	
- **Tools**
	* [curl](https://curl.haxx.se/)
	* [httpie](https://httpie.org/)
		* user-friendly command-line HTTP client for the API era. It comes with JSON support, syntax highlighting, persistent sessions, wget-like downloads, plugins, and more.
	* [wuzz](https://github.com/asciimoo/wuzz)
		* Interactive cli tool for HTTP inspection.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="imagemagick"></a>Imagemagick
- **101**
- **Articles/Blogposts/Writeups**
- **Papers**
- **Tools**


--------------------------------------------------------------------------------------------------------------------------------


### <a name="java"></a>Java & related
- **Apache Struts & OGNL**
	- **101**
		* [Exploiting OGNL Injection in Apache Struts  - Ionut Popescu(2022)](https://pentest-tools.com/blog/exploiting-ognl-injection-in-apache-struts)
	- **Articles/Blogposts/Presentations/Talks/Writeups**
		* [Apache Struts 2.3.5 < 2.3.31 / 2.5 < 2.5.10 - Remote Code Execution](https://www.exploit-db.com/exploits/41570/)
		* [OGNL Injection Decoded - SecOps Group](https://secops.group/ognl-injection-decoded/)
		* [OGNL Apache Struts exploit: Weaponizing a sandbox bypass (CVE-2018-11776) - Man Yue Mo(2018)](https://securitylab.github.com/research/ognl-apache-struts-exploit-CVE-2018-11776/)
		* [Exploiting Struts RCE on 2.5.26 - Chris McCown(2021)](https://mc0wn.blogspot.com/2021/04/exploiting-struts-rce-on-2526.html)
		* [Bypassing OGNL sandboxes for fun and charities - Alvaro Munoz(2023)](https://github.blog/2023-01-27-bypassing-ognl-sandboxes-for-fun-and-charities/)
- **JDBC**
	- **Presentations**
		* [Make JDBC Attacks Brilliant Again - Xu Yuanzhen & Chen Hongkun(HITBSI2021)](https://www.youtube.com/watch?v=MJWI8YXH1lg&list=PLmv8T5-GONwQhUlGN2UhOAi8YxPaiYCDQ&index=8)
			* [Slides](https://conference.hitb.org/hitbsecconf2021sin/materials/D1T2%20-%20Make%20JDBC%20Attacks%20Brilliant%20Again%20-%20Xu%20Yuanzhen%20&%20Chen%20Hongkun.pdf)
			* [Other Slides](https://raw.githubusercontent.com/pyn3rd/my-presentation-slide/master/Make_JDBC_Attack_Brilliant_Again.pdf)
			* In this presentation, we will share our latest research into attacking JDBC. We will start with the derivation of JDBC attacks including the JDBC concept and root cause of vulnerability. We will then give  a more in-depth analysis of occurred implementations including the 0day we found (Weblogic RCE). Finally we will share some new ways of exploiting JDBC including XXE and RCE issues – we will also disclose some 0day vulnerabilities in DB2, JBoss Wildfly, ModeShape.
- **<a name="jsf"></a>Java Server Faces (JSF)**
	- **101**
		* [Java Server Faces - Wikipedia](https://en.wikipedia.org/wiki/JavaServer_Faces)
	- **Articles/Blogposts/Presentations/Talks/Writeups**
		* [Misconfigured JSF ViewStates can lead to severe RCE vulnerabilities - alphabot](https://www.alphabot.com/security/blog/2017/java/Misconfigured-JSF-ViewStates-can-lead-to-severe-RCE-vulnerabilities.html)
- **JNDI**
	- **101**
		* [Overview of JNDI - Oracle](https://docs.oracle.com/javase/tutorial/jndi/overview/index.html)
		* [What is JNDI? What is its basic use? When is it used? - StackOverflow](https://stackoverflow.com/questions/4365621/what-is-jndi-what-is-its-basic-use-when-is-it-used)
		* [Java Naming and Directory Interface - Wikipedia](https://en.wikipedia.org/wiki/Java_Naming_and_Directory_Interface)
	- **Articles/Blogposts/Writeups**
		* https://github.com/iSafeBlue/presentation-slides/blob/main/BCS2022-%E6%8E%A2%E7%B4%A2JNDI%E6%94%BB%E5%87%BB.pdf
		* [The JNDI Strikes Back – Unauthenticated RCE in H2 Database Console - Andrey Polkovnychenko, Shachar Menashe(2022)](https://jfrog.com/blog/the-jndi-strikes-back-unauthenticated-rce-in-h2-database-console/)
		* [Exploiting JNDI Injections in Java - Michael Stepankin(2019)](https://www.veracode.com/blog/research/exploiting-jndi-injections-java)
	- **Talks/Presentations**
		* [A Journey From JNDI/LDAP Manipulation to Remote Code Execution Dream Land - Alvaro Muñoz, Oleksandr Mirosh(BHSUA2016)](https://www.blackhat.com/docs/us-16/materials/us-16-Munoz-A-Journey-From-JNDI-LDAP-Manipulation-To-RCE-wp.pdf)
	- **Tools**
		* [dnsAutoRebinding](https://github.com/Tr3jer/dnsAutoRebinding)
		* [Rogue JNDI](https://github.com/veracode-research/rogue-jndi)
			* A malicious LDAP server for JNDI injection attacks 
		* [JNDI-Injection-Exploit](https://github.com/welk1n/JNDI-Injection-Exploit)
			* JNDI注入测试工具（A tool which generates JNDI links can start several servers to exploit JNDI Injection vulnerability,like Jackson,Fastjson,etc） 
- **<a name="jsp"></a>Java Server Pages (JSP)**
	- **101**
		* [Java Server Pages - Wikipedia](https://en.wikipedia.org/wiki/JavaServer_Pages)
		* [JSP Tutorial - javapoint](https://www.javatpoint.com/jsp-tutorial)
		* [JSP Tutorial - some Examples of Java Servlet Pages - imperial.ac.uk](http://www.imperial.ac.uk/computing/csg/guides/java/jsp-tutorial---some-examples-of-java-servlet-pages/)
	- **Articles/Blogposts/Presentations/Talks/Writeups**
		* [Hacking with JSP Shells - NetSPI](https://blog.netspi.com/hacking-with-jsp-shells/)
		* [A Smaller, Better JSP Web Shell - securityriskadvisors](https://securityriskadvisors.com/blog/post/a-smaller-better-jsp-web-shell/)
			* [Code](https://github.com/SecurityRiskAdvisors/cmd.jsp)
- **Hibernate**
	* [Exploiting Hibernate Injections - Johannes Moritz(2020)](https://blog.ripstech.com/2020/exploiting-hibernate-injections/)
		* Hibernate is among one of the most commonly found database libraries used in Java web applications, shipping with its own query language. This technical post will teach you how to detect and exploit Hibernates very own vulnerability: The HQL Injection.
- **RMI**
	- **101**
		* [Java RMI - Oracle](https://docs.oracle.com/javase/tutorial/rmi/index.html)
	- **Articles/Blogposts/Writeups**
		* [Java RMI for pentesters: structure, recon and communication (non-JMX Registries). - AFINE(2020)](https://itnext.io/java-rmi-for-pentesters-structure-recon-and-communication-non-jmx-registries-a10d5c996a79?gi=74bdda3cafb9)
		* [Java RMI for pentesters part two — reconnaissance & attack against non-JMX registries - AFINE(2020)](https://medium.com/@afinepl/java-rmi-for-pentesters-part-two-reconnaissance-attack-against-non-jmx-registries-187a6561314d)
	- **Tools**
		* [BaRMIe](https://github.com/NickstaDB/BaRMIe)
			* BaRMIe is a tool for enumerating and attacking Java RMI (Remote Method Invocation) services.
		* [RmiTaste](https://github.com/STMSolutions/RmiTaste)
			* RmiTaste allows security professionals to detect, enumerate, interact and exploit RMI services by calling remote methods with gadgets from ysoserial. 


--------------------------------------------------------------------------------------------------------------------------------


### <a name="javascript">JavaScript</a>
- **General**
	* [DOM Clobbering Attack](http://www.thespanner.co.uk/2013/05/16/dom-clobbering/)
- **Training**
	* [Javascript for Pentesters - PentesterAcademy](https://www.pentesteracademy.com/course?id=11)
- **101**
	* [Javascript Introduction - MozillaDevNetwork](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Introduction)
	* [JavaScript: Crash Course - bt3gl](https://coderwall.com/p/skucrq/javascript-crash-course)
	* [JavaScript for Pentesters. - BitsPlease](https://www.youtube.com/watch?v=HptfL5WRYF8)
	* [How to perform static analysis of JavaScript files? - Rudra Sonkusare(2021)](https://medium.com/@rudrasonkusare0222/how-to-perform-static-analysis-of-javascript-files-37b3657d92e8)
- **Articles/Blogposts/Writeups**
	* [Static Analysis of Client-Side JavaScript for pen testers and bug bounty hunters - Bharath](https://blog.appsecco.com/static-analysis-of-client-side-javascript-for-pen-testers-and-bug-bounty-hunters-f1cb1a5d5288)
	* [A Brief History of JavaScript - Sebastian Peyrott(2017)](https://auth0.com/blog/a-brief-history-of-javascript/)
	* [Javascript for bug bounty hunters(part 1) — Ahmed Ezzat (BitTheByte)](https://medium.com/@bitthebyte/javascript-for-bug-bounty-hunters-part-1-dd08ed34b5a8)
		* [Part 2](https://medium.com/@bitthebyte/javascript-for-bug-bounty-hunters-part-2-f82164917e7)
		* [Part 3](https://medium.com/@bitthebyte/javascript-for-bug-bounty-hunters-part-3-3b987f24ab27)
	* [Hacker101: JavaScript for Hackers - @STOKfredrik, tomnomnom(2020))](https://www.youtube.com/watch?v=FTeE3OrTNoA
	* [Real World JavaScript Security by Amanvir Sangha(Devoxx2019)](https://www.youtube.com/watch?v=dO2zXhVEEKo)
		* This talk covers prevalent but not well known security issues in modern full stack JavaScript applications found in real-world assessments. We will also discuss strategies on avoiding security issues and secure design patterns that can be adopted to write robust and secure JavaScript applications.  We cover less well-known issues such as insecure object comparisons and prototype pollution along with how they can be used to exploit applications in Node.js.  In addition, the talk also covers new upcoming security standards and protections to protect client-side JavaScript code (TrustedTypes).
	* [JavaScript Code Review Guide for Bug Bounty Hunters - MikeChan(2021)](https://medium.com/techiepedia/javascript-code-review-guide-for-bug-bounty-hunters-c95a8aa7037a)
- **Talks/Presentations/Videos**
	* [An Infosec Timeline: Noteworthy Events From 1970 To 2050 - Mario Heiderich(OWASP AppSec AMS)(https://www.youtube.com/watch?v=u3x_0955_TU&feature=youtu.be)
	* [Free Tools! How to Use Developer Tools and Javascript in Webapp Pentests - BHIS(2020)](https://www.youtube.com/watch?v=3W65ji1gc8c)
		* I like webapps, don't you? Webapps have got to be the best way to learn about security. Why? Because they're self-contained and so very transparent. You don't need a big ol' lab before you can play with them. You can run them in a single tiny VM or even tiny-er Docker image on your laptop. And so long as you're attacking your own stuff, it's easy to stay out of trouble. You're up and running in the time it takes for a single download.  And the transparent part? Ever since "view source" in the earliest web browsers, it's been easy to see exactly what's going on in a webapp and in the browser. Every webapp you ever use has no choice but to give you the (client-side) source code! It's almost like there's no such thing as a "black box" webapp pentest, if you think about it... Anyhow - the Developer Tools in Firefox (and Chrome) are what happens when you take "view source" and add 25 years or so of creativity and power.  We'll look at the Developer Tools in the latest Firefox with a pentester's eye. Inspect and change the DOM (Document Object Model), take screenshots, find and extract key bits of data, use the console to run Javascript in the site's origin context and even pause script execution in the debugger if things go too fast... Maybe we'll convince you that you can realistically do a big chunk of a webapp pentest without ever leaving the browser.
	* [Offensive Javascript Techniques for Red Teamers - Dylan Ayrey, Christian Frichot(BSidesSF2021)](https://www.youtube.com/watch?v=hKdcDce3FW4)
		* AppSec is often very heavily focused on pre-exploitation. Frameworks like BeEF break this norm a little and can be used as tools to move laterally from the browser, to implant malware on adjacent machines. Unfortunately, performing network reconnaissance with JavaScript becomes tricky if the victim doesn't keep the tab open for long. This presentation will discuss relatively new techniques and features of JavaScript that have made it easier for sophisticated threat actors to craft JavaScript payloads that target internal network vulnerabilities, as fast as a person can think to close a tab. We'll also show new reconnaissance techniques traditionally used by red teams, post-malware implant, that can be used to get a foothold onto a network from a browser, pre-malware implant. We'll also show some real examples of this, crafting external payloads that target internal assets at large companies, and we'll show how responsible disclosure for intranet facing bugs typically gets resolved.
	* [JavaScript Obfuscation: It's All About the P-a-c-k-e-r-s — Or Katz(InfosecInTheCity2022)](https://www.youtube.com/watch?v=BKku1-ZCJKo)
		* In this presentation I will present a lazy, performance cost-effective approach, focusing on the detection of JavaScript packer templates. Once combined with threat intelligence heuristics, this approach can predict the maliciousness level of JavaScript with a high probability of accuracy.
- **Debugging**
	- **Articles/Blogposts/Writeups**
		* [Client Side Encryption Bypass Part-1 - Sameer Bhatt](https://bhattsameer.github.io/2021/01/01/client-side-encryption-bypass-part-1.html)
		* [A Complete Guide to Debugging JavaScript in Chrome - Boateng Dickson(2022)](https://dev.to/dboatengx/a-complete-guide-to-debugging-javascript-in-chrome-1a4m)
	- **Talks/Presentations/Videos**	
		* [Cold War with Javascript - Sameer Bhatt(2020)](https://www.youtube.com/watch?v=gk0hBvJEL0w)
			* "Now every financial sector applications i.e. mobile or web, use one more security layer which is encryption mechanism so the attacker who able to intercept the traffic through any MITM tools can not able to understand the request data. When we do pen-testing we follow some methodology, we have to test each and every parameter and request. well as we all know attackers don't follow any rules or regulations, when they want to attack they will find the way to do it. So as keeping the mindset of the attacker, we will understand this kind of encryption mechanism, what developer thinks when they implement this? also what kind of mistakes they do? why they feel putting encryption means the application is secure? what makes them think that no one can break there logic? so they hide sensitive information behind the encryption. So keeping all the above maybe some more cases in my mind, I prepared my own ""Debugging methodology"" for this, which I follow when I face this kind of scenario."
- **JS Polyglots**
	* [This Image Is Also a Valid Javascript File  - Sebastion Stamm](https://dev.to/sebastianstamm/this-image-is-also-a-valid-javascript-file-5fol)
- **Source Maps**
	* [Introduction to JavaScript Source Maps - Ryan Seddon(2021)](https://developer.chrome.com/blog/sourcemaps/)
	* [Use a source map - Firefox Docs](https://firefox-source-docs.mozilla.org/devtools-user/debugger/how_to/use_a_source_map/index.html)
- **Reverse-Engineering**
	* [Advanced JS Deobfuscation Via AST and Partial Evaluation (Google Talk WrapUp) - Stefano Di Paola(2015)](https://blog.mindedsecurity.com/2015/10/advanced-js-deobfuscation-via-ast-and.html)
	* [JavaScript AntiDebugging Tricks - x-c3ll(2020)](https://x-c3ll.github.io/posts/javascript-antidebugging/)
	* [Reverse engineering obfuscated JavaScript - PopUnder Chrome 59 - LiveOverflow](https://www.youtube.com/watch?v=8UqHCrGdxOM)
	* [Reverse engineering PopUnder trick for Chrome 60 - LiveOverflow](https://www.youtube.com/watch?v=PPzRcZLNCPY)
	* [Custom Chromium Build to Reverse Engineer Pop-Under Trick - LiveOverflow](https://www.youtube.com/watch?v=y6Uzinz3DRU)
	* [[Live] Reverse Engineering new PopUnder for Chrome 63 on Windows - LiveOverflow](https://www.youtube.com/watch?v=VcFQeimLH1c)
	* [Javascript Anti Debugging — Some Next Level Sh`*`t (Part 1 — Abusing SourceMappingURL) - Gal Weizman(2019)](https://medium.com/@weizmangal/javascript-anti-debugging-some-next-level-sh-t-part-1-abusing-sourcemappingurl-da91ff948e66)
	* [JavaScript tampering – detection and stealth - adtechmadness(2019)](https://adtechmadness.wordpress.com/2019/03/23/javascript-tampering-detection-and-stealth/)
- **Tools**
	* [JSFuck](http://www.jsfuck.com/)
		* JSFuck is an esoteric and educational programming style based on the atomic parts of JavaScript. It uses only six different characters to write and execute code.
	* [JSDetox](http://relentless-coding.org/projects/jsdetox/info)
		* JSDetox is a tool to support the manual analysis of malicious Javascript code. 
	* [Dom Flow - Untangling The DOM For More Easy-Juicy Bugs  - BH USA 2015](https://www.youtube.com/watch?v=kedmtrIEW1k&list=PLH15HpR5qRsXF78lrpWP2JKpPJs_AFnD7&index=111)
	* [Javascript Deobfuscator - kahusecurity](http://www.kahusecurity.com/tools/)
	* [Revelo - kahusecurity](http://www.kahusecurity.com/tools/)
	* [pwn.js](https://github.com/theori-io/pwnjs)
		* A Javascript library for browser exploitation
	* [Retire.js](https://retirejs.github.io/retire.js/)
		* There is a plethora of JavaScript libraries for use on the web and in node.js apps out there. This greatly simplifies, but we need to stay update on security fixes. "Using Components with Known Vulnerabilities" is now a part of the OWASP Top 10 and insecure libraries can pose a huge risk for your webapp. The goal of Retire.js is to help you detect use of version with known vulnerabilities.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="jsframeworks"></a>JS Frameworks
- **General**
	- **Articles/Blogposts/Writeups**
		* [JavaScript Template Attacks](https://github.com/IAIK/jstemplate)
		* [At Home Among Strangers: Bo0oM(2019)](https://speakerdeck.com/bo0om/at-home-among-strangers?slide=4)
			* Bypassing IP white sheets of some web applications due to incorrect parsing of HTTP request headers.
	- **Talks/Presentations/Videos**
		* [JSMVCOMFG - To sternly look at JavaScript MVC and Templating Frameworks - Mario Heiderich](https://www.youtube.com/watch?v=SLH_IgaQWjs)
			* [Slides](https://www.slideshare.net/x00mario/jsmvcomfg-to-sternly-look-at-javascript-mvc-and-templating-frameworks)
- **Angular**
	- **Articles/Blogposts/Writeups**
		* [AngularJS Security Documentation](https://docs.angularjs.org/guide/security)
		* [Adapting AngularJS payloads to exploit real world applications - Gareth Heyes](https://portswigger.net/research/adapting-angularjs-payloads-to-exploit-real-world-applications)
		* [Angular and AngularJS for Pentesters - Part 1 - Alex Useche(2019)](https://blog.nvisium.com/angular-for-pentesters-part-1)
			* [Part 2](https://blog.nvisium.com/angular-for-pentesters-part-2)
	- **Tools**
		* [ngrev](https://github.com/mgechev/ngrev)
			* Graphical tool for reverse engineering of Angular projects. It allows you to navigate in the structure of your application and observe the relationship between the different modules, providers, and directives. The tool performs static code analysis which means that you don't have to run your application in order to use it.
- **Backbone.js**
- **Django**
	* [Be careful what you request for: Injection using the HTTP verb in Django - Grayson Hardaway(2020)](https://semgrep.dev//blog/2020/be-careful-what-you-request-for-django-method)
	* [The Fall Of Mighty Django, Exploiting Unicode Case Transformations - 0xsha(2020)](https://0xsha.io/blog/the-fall-of-mighty-django-exploiting-unicode-case-transformations)
	* [Disclosing information with a side-channel in Django - Dennis Brinkrolf(2022)](https://www.sonarsource.com/blog/disclosing-information-with-a-side-channel-in-django/)
	* [The Fall Of Mighty Django, Exploiting Unicode Case Transformations - oxsha(2020)](https://0xsha.io/blog/the-fall-of-mighty-django-exploiting-unicode-case-transformations)
- **Ember.js**
- **Groovy**
	* [Groovy Template Engine Exploitation – Notes from a real case scenario - Gianluca Baldi(2022)](https://security.humanativaspa.it/groovy-template-engine-exploitation-notes-from-a-real-case-scenario/)
- **H2**
	* [Exploiting H2 Database with native libraries and JNI - Markus Wulftange(2019)](https://codewhitesec.blogspot.com/2019/08/exploit-h2-database-native-libraries-jni.html)
- **GWT**
	* [GWTMap - Reverse Engineering Google Web Toolkit Applications - Oliver Simmonnet(2020)](https://labs.withsecure.com/publications/gwtmap-reverse-engineering-google-web-toolkit-applications)
	* [GWTMap](https://github.com/FSecureLABS/GWTMap)
		* GWTMap is a tool to help map the attack surface of Google Web Toolkit (GWT) based applications. The purpose of this tool is to facilitate the extraction of any service method endpoints buried within a modern GWT application's obfuscated client-side code, and attempt to generate example GWT-RPC requests payloads to interact with them.
- **MeteorJS**
	* [Hacking Meteor Applications - Remi Testa(2017)](https://medium.com/@funkyremi/hacking-meteor-applications-1c4b326e6cdc)
	* [Pentesting Meteor Applications with Burp Suite - sean(2019)](https://www.gremwell.com/blog/pentesting-meteor-applications-with-burp-suite)
	* [Wekan Authentication Bypass – Exploiting Common Pitfalls of MeteorJS - Dejan Zelic(2020)](https://www.offensive-security.com/offsec/wekan-authentication-bypass/)
- **mustache.js**
	* [mustache-security(2013)](https://code.google.com/archive/p/mustache-security/)
		* This place will host a collection of security tips and tricks for JavaScript MVC frameworks and templating libraries.
	* [Wikis](https://code.google.com/archive/p/mustache-security/wikis)
- **NodeJS**<a name="nodejs"></a>
	- **101**
	- **Educational**
		* [A Roadmap for Node.js Security](https://nodesecroadmap.fyi/)	
		* [NodeGoat](https://github.com/OWASP/NodeGoat)
			* Being lightweight, fast, and scalable, Node.js is becoming a widely adopted platform for developing web applications. This project provides an environment to learn how OWASP Top 10 security risks apply to web applications developed using Node.js and how to effectively address them.
	- **Articles/Blogposts/Writeups**	
		* [Reverse shell on a Node.js application](https://wiremask.eu/writeups/reverse-shell-on-a-nodejs-application/)
		* [Pen Testing Node.js: Staying N Sync Can Make the Server Go Bye Bye Bye - Tim Medin](https://pen-testing.sans.org/blog/2015/12/20/pen-testing-node-js-staying-n-sync-can-make-the-server-go-bye-bye-bye)
		* [Debugging Node.js with Google Chrome - Jacopo Daeli](https://medium.com/the-node-js-collection/debugging-node-js-with-google-chrome-4965b5f910f4)
		* [Static Analysis of Client-Side JavaScript for pen testers and bug bounty hunters - Bharath(2018)](https://blog.appsecco.com/static-analysis-of-client-side-javascript-for-pen-testers-and-bug-bounty-hunters-f1cb1a5d5288)
	- **Presentations/Talks/Videos**
		* [NodeJS: Remote Code Execution as a Service - Peabnuts123 – Kiwicon 2016](https://www.youtube.com/watch?v=Qvtfagwlfwg)
			* [SLIDES](http://archivedchaos.com/post/153372061089/kiwicon-2016-slides-upload)
		* [It's Coming From Inside the House: An Inside-Out Approach to NodeJS Application Security - Yolonda Smith(CircleCityCon2019)](https://www.irongeek.com/i.php?page=videos/circlecitycon2019/track-3-05-its-coming-from-inside-the-house-an-inside-out-approach-to-nodejs-application-security-yolonda-smith)
			* Getting application security right often requires that developers have a deeper than average understanding of the security domain. In what other industry is this the case? We don't have to be M.D.s to get a medical diagnosis; we don't have to be auto mechanics to get our cars fixed, yet we in security wag our fingers at "iD10t errors" and build grand mousetraps to catch "so obvious" developer missteps, when they may not know what they need to add, change or remove from their applications to make it "secure" in the first place. Furthermore, patterns to address these issues don't always fit the requirements of the application short or long term, resulting in solutions that only address part of the problem, or worse, are omitted altogether because they are too cumbersome to implement. My answer to this is `_spartan`-a node application created for developers of node.js applications, not security people. `_spartan` allows developers to create security policies which address their node app's (whether it be Desktop, Web, Mobile, IoT or API) specific requirements; it installs & configures the modules to match the policy and; it generates the boilerplate code that developers can import directly into their applications.
	- **Tools**
		* [faker.js](https://github.com/Marak/faker.js)
			* generate massive amounts of fake data in Node.js and the browser
	- **Hidden Property Abuse**
		* [Discovering Hidden Properties to Attack Node js Ecosystem - Feng Xiao(DEFCON Safemode)](https://www.youtube.com/watch?v=oGeEoaplMWA)
			* [BlackHat Slides](https://i.blackhat.com/USA-20/Wednesday/us-20-Xiao-Discovering-Hidden-Properties-To-Attack-Nodejs-Ecosystem.pdf)
			* Node.js is widely used for developing both server-side and desktop applications. It provides a cross-platform execution environment for JavaScript programs. Due to the increasing popularity, the security of Node.js is critical to web servers and desktop clients. We present a novel attack method against the Node.js platform, called hidden property abusing (HPA). The new attack leverages the widely-used data exchanging feature of JavaScript to tamper critical program states of Node.js programs, like server-side applications. HPA entitles remote attackers to launch serious attacks, such as stealing confidential data, bypassing security checks, and launching denial of service attacks. To help developers detect the HPA issues of their Node.js applications, we develop a tool, named LYNX, that utilizes hybrid program analysis to automatically reveal HPA vulnerabilities and even synthesize exploits. We apply LYNX on a set of widely-used Node.js programs and identify 13 previously unknown vulnerabilities. LYNX successfully generates 10 severe exploits. We have reported all of our findings to the Node.js community. At the time of paper writing, we have received the confirmation of 12 vulnerabilities and got 12 CVEs assigned. Moreover, we collaborated with an authoritative public vulnerability database to help them use a new vulnerability notion and description in related security issues. The talk consists of four parts. First, we will introduce recent offensive research on Node.js. Second, we will introduce HPA by demonstrating an exploit on a widely-used web framework. Third, we will explain how to leverage program analysis techniques to automatically detect and exploit HPA. In the end, we will have a comprehensive evaluation which discusses how we identified 13 HPA 0days with the help of our detection method.
- **phpMyAdmin**
	* [Linux Hacking Case Studies Part 3: phpMyAdmin - Scott Sutherland(2020)](https://blog.netspi.com/linux-hacking-case-studies-part-3-phpmyadmin/)
- **React.JS**
	- **Articles/Blogposts/Writeups**
		* [Exploiting Script Injection Flaws in ReactJS Apps](https://medium.com/dailyjs/exploiting-script-injection-flaws-in-reactjs-883fb1fe36c1)
		* [Javascript for bug bounty hunters(part 1) — Ahmed Ezzat (BitTheByte)](https://medium.com/@bitthebyte/javascript-for-bug-bounty-hunters-part-1-dd08ed34b5a8)
			* [Part 2](https://medium.com/@bitthebyte/javascript-for-bug-bounty-hunters-part-2-f82164917e7)
		* [10 React security best practices - Ron Perris, Liran Tal(2022)](https://snyk.io/blog/10-react-security-best-practices/)
- **Ruby-on-Rails**
		* [Ruby on Rails Penetration Testing - 3SLabs(2014)](https://www.slideshare.net/labs3/ruby-on-rails-penetration-testing)
		* [Going AUTH the Rails on a Crazy Train - Tomek Rabczak Jeff Jarmoc(Derbycon2015)](https://www.irongeek.com/i.php?page=videos/derbycon5/the-3-way09-going-auth-the-rails-on-a-crazy-train-tomek-rabczak-jeff-jarmoc)
			* Rails has a strong foundation in convention over configuration. In this regard, Rails handles a lot of security related conventions for developers, keeping them safe from vulnerabilities such as SQL Injection, XSS, and CSRF out of the box. However, authentication and authorization logic is largely left up to the developer. It is here that the abilities of the framework hit the end of the track and it's up to the developers to keep themselves safe. In this talk, we take a look at patterns that we've seen across some of the largest Rails applications on the internet and cover common pitfalls that you as a security researcher and/or developer can watch out for. We will also be discussing and releasing a new dynamic analysis tool for Rails applications to help pentesters navigate through authentication and authorization solutions in Rails.
		* [Vulnerabilities Within Ruby on Rails - Arvind Doraiswamy(2015)](https://blog.securityinnovation.com/blog/2015/05/ruby-on-rails.html)
		* [Attacking Ruby on Rails Applications - joernchen(2016)](http://phrack.org/issues/69/12.html#article)
		* [Zen Rails Security Checklist](https://github.com/brunofacca/zen-rails-security-checklist)
			* This document provides a not necessarily comprehensive list of security measures to be implemented when developing a Ruby on Rails application. It is designed to serve as a quick reference and minimize vulnerabilities caused by developer forgetfulness. It does not replace developer training on secure coding principles and how they can be applied.
- **Salesforce**
	- **Articles**
		* [SFDC Secure Development Cheat Sheet -  Zach Julian(2019)](https://bishopfox.com/blog/sfdc-secure-development-cheat-sheet)
		* [Salesforce Lightning - Tinting the Windows - Aaron Costello(2020)](https://www.enumerated.de/index/salesforce-lightning-tinting-the-windows)
		* [Features of the Browser Fingerprint - Salesforce](https://developer.salesforce.com/docs/atlas.en-us.securityImplGuide.meta/securityImplGuide/real_time_em_threat_session_features.htm)
		* [Salesforce Lightning - An in-depth look at exploitation vectors for the everyday community - Aaron Costello(2020)](https://www.enumerated.de/index/salesforce)
		* [Lightning Components: A Treatise on Apex Security from an External Perspective - Aaron Costello(2021)](https://go.appomni.com/hubfs/Collateral/AppOmni_Labs_White_Paper_Apex_Security.pdf)
		* [in simple words: Pen-Testing Salesforce SAAS Application (Part 1 - The Essentials) - Praveen Kanniah(2021](https://praveen-kanniah.medium.com/in-simple-words-pen-testing-salesforce-saas-application-part-1-the-essentials-ffae632a00e5)
			* [Part 2](https://praveen-kanniah.medium.com/in-simple-words-pen-testing-salesforce-saas-application-part-2-fuzz-exploit-eefae11ba5ae)
		* [Are you oversharing (in Salesforce)? Our new tool could sniff it out! - Jerome Smith(2021)](https://research.nccgroup.com/2021/06/28/are-you-oversharing-in-salesforce/)
		* [How Salesforce Helps Protect You From Session Hijacking Threats - Regunathan Radhakrishnan(2022)](https://engineering.salesforce.com/how-salesforce-helps-protect-you-from-session-hijacking-threats-c39f4cf84cee/)
		* [Hacking Salesforce-backed WebApps - hypn.za.net(2022)](https://www.hypn.za.net/blog/2022/11/12/Hacking-Salesforce-backed-WebApps/)
		* [Understanding Salesforce Flows and Common Security Risks - Aaron Costello(2022)](https://appomni.com/resources/aolabs/understanding-salesforce-flows-and-common-security-risks/)
	- **Tools**
		* [Raccoon](https://github.com/nccgroup/raccoon)
			* Salesforce object auditor
		* [Salesforce Recon and Exploitation Toolkit](https://github.com/Ophion-Security/sret)
			* Salesforce Recon and Exploitation Toolkit
- **Spring**
	* [How Spring Web MVC Really Works - Stackify.com](https://stackify.com/spring-mvc/)
	* [Spring View Manipulation Vulnerability -  Michael Stepankin(2020)](https://github.com/veracode-research/spring-view-manipulation)
		* In this article, we explain how dangerous an unrestricted view name manipulation in Spring Framework could be.
- **Springboot**
	- **Articles/Blogposts**
		* [Critical Zero-Day RCE Vulnerability in Spring Core: Spring4shell (CVE-2022-22965) - Aarush Ahuja(2022)](https://fourcore.io/blogs/spring4shell-zero-day-rce-spring-framework)
		* [Introduction to Spring Boot Related Vulnerabilities - varma(2022)](https://tutorialboy24.blogspot.com/2022/02/introduction-to-spring-boot-related.html)
		* [Remote Code Execution in Three Acts: Chaining Exposed Actuators and H2 Database Aliases in Spring Boot 2 - spaceraccoon.dev(2020)](https://spaceraccoon.dev/remote-code-execution-in-three-acts-chaining-exposed-actuators-and-h2-database)
	- **Tools**
		* [Spring4Shell Exploit POC](https://github.com/FourCoreLabs/spring4shell-exploit-poc)
		* [CVE-2022-22965](https://github.com/alt3kx/CVE-2022-22965)
- **Symfony**
	* [Secret fragments: Remote code execution on Symfony based websites - Charles Fol(2020)](https://www.ambionics.io/blog/symfony-secret-fragment)
- **Vue.js**
- **Wordpress**
	* [Backdooring WordPress with Phpsploit - wpsec(2020)](https://blog.wpsec.com/backdooring-wordpress-with-phpsploit/)


--------------------------------------------------------------------------------------------------------------------------------


### <a name=".netframework"></a>.NET-based Frameworks
- **ASP.NET**
	- **101**
		* [Understanding ASP.NET View State - docs.ms](https://docs.microsoft.com/en-us/previous-versions/dotnet/articles/ms972976(v=msdn.10))
	- **Articles/Blogposts/Writeups**	
		* [Getting Shell with XAMLX Files - Soroush Dalili](https://www.nccgroup.trust/uk/about-us/newsroom-and-events/blogs/2019/august/getting-shell-with-xamlx-files/)
		* [ASP.NET resource files (.RESX) and deserialisation issues - Soroush Dalili(2018)](https://www.nccgroup.trust/uk/about-us/newsroom-and-events/blogs/2018/august/aspnet-resource-files-resx-and-deserialisation-issues/)
		* [Uploading web.config for Fun and Profit 2 - Soroush Dalili(2019)](https://soroush.secproject.com/blog/2019/08/uploading-web-config-for-fun-and-profit-2/)
		* [Technical Advisory: Bypassing Microsoft XOML Workflows Protection Mechanisms using Deserialisation of Untrusted Data - Soroush Dalili](https://www.nccgroup.trust/uk/our-research/technical-advisory-bypassing-microsoft-xoml-workflows-protection-mechanisms-using-deserialisation-of-untrusted-data/)
		* [XAML overview in WPF - docs.ms](https://docs.microsoft.com/en-us/dotnet/desktop-wpf/fundamentals/xaml)
		* [Rare ASP.NET request validation bypass using request encoding - nccgroup(2017)](https://www.nccgroup.trust/uk/about-us/newsroom-and-events/blogs/2017/september/rare-aspnet-request-validation-bypass-using-request-encoding/)
		* [Covert Web Shells in .NET with Read-Only Web Paths - Soroush Dalili(2020)](https://www.mdsec.co.uk/2020/10/covert-web-shells-in-net-with-read-only-web-paths/)
	- **Presentations/Talks/Videos**
	- **Tools**
		* [viewstate](https://github.com/yuvadm/viewstate)
			* A small Python 3.5+ library for decoding ASP.NET viewstate.
		* [viewgen](https://github.com/0xACB/viewgen)
			* viewgen is a ViewState tool capable of generating both signed and encrypted payloads with leaked validation keys
		* [RCEvil.NET](https://github.com/Illuminopi/RCEvil.NET)
			* RCEvil.NET is a tool for signing malicious ViewStates with a known validationKey. Any (even empty) ASPX page is a valid target. See http://illuminopi.com/ for full details on the attack vector.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="pythonframeworks"></a>Python-based Frameworks
- **General**
	* [the_storm/ Unexpected Execution: Wild Ways Code Execution can Occur in Python - Graham Bleaney(PyConUS2021](https://www.youtube.com/watch?v=R1KrPc1IOeE&list=PL2Uw4_HvXqvYk1Y5P8kryoyd83L_0Uk5K&index=54)
		* [Code](https://github.com/gbleaney/python_security)
		* Every Python user knows that you can execute code using eval or exec, but what about yaml or str.format? This talk will take you on a walk through all the weird and wild ways that you can achieve code execution on a Python server (and trust me, I didn’t spoil the surprise by putting the weirdest ones in the description). The talk should be equal parts practical and entertaining as we work through both real examples of code execution vulnerabilities found in running code as well as absurd remote code execution exploits. The talk will end on a practical note by explaining how Facebook detects and prevents the exploit vectors we discussed, using an open source Python Static Analyzer called Pysa.
- **Flask**
	* See [SSI/Template Injection](#ssti)
	- **Articles/Blogposts/Writeups**	
		* [Injecting Flask - Ryan Reid](https://nvisium.com/blog/2015/12/07/injecting-flask/)
			* In this adventure we will discuss some of the security features available and potential issues within the [Flask micro-framework](http://flask.pocoo.org/docs/0.10/) with respect to Server-Side Template Injection, Cross-Site Scripting, and HTML attribute injection attacks, a subset of XSS. If you’ve never had the pleasure of working with Flask, you’re in for a treat. Flask is a lightweight python framework that provides a simple yet powerful and extensible structure (it is [Python](https://xkcd.com/353/) after all).


--------------------------------------------------------------------------------------------------------------------------------


### <a name="json"></a>JSON
- **101**
	* [json.org](https://www.json.org/json-en.html)
		* "JSON (JavaScript Object Notation) is a lightweight data-interchange format. It is easy for humans to read and write. It is easy for machines to parse and generate. It is based on a subset of the JavaScript Programming Language Standard ECMA-262 3rd Edition - December 1999. JSON is a text format that is completely language independent but uses conventions that are familiar to programmers of the C-family of languages, including C, C++, C#, Java, JavaScript, Perl, Python, and many others. These properties make JSON an ideal data-interchange language."
	* [JSON Schema](https://json-schema.org/)
		* JSON Schema is a declarative language that allows you to annotate and validate JSON documents.
- **Articles/Blogposts/Writeups**
	* [Best Practices to Mitigate JSON Interoperability Vulnerabilities - Claudio Salazar(2021)](https://medium.com/swlh/best-practices-to-mitigate-json-interoperability-vulnerabilities-45dac573b625)
	* [An Exploration of JSON Interoperability Vulnerabilities - Jake Miller(2021)](https://bishopfox.com/blog/json-interoperability-vulnerabilities)
		* "TL;DR The same JSON document can be parsed with different values across microservices, leading to a variety of potential security risks."
- **Tools**
	* [JSON Interoperability Vulnerability Labs](https://github.com/BishopFox/json-interop-vuln-labs)
		* Companion labs to "An Exploration of JSON Interoperability Vulnerabilities"


--------------------------------------------------------------------------------------------------------------------------------



### <a name="jwt"></a>JSON Web Tokens
- **101**
	* [JSON Web Token - Wikipedia](https://en.wikipedia.org/wiki/JSON_Web_Token)
	* [RFC 7159: JSON Web Token (JWT)](https://tools.ietf.org/html/rfc7519)
	* [RFC 8725: JSON Web Token Best Current Practices](https://www.rfc-editor.org/rfc/rfc8725.html)\
		* JSON Web Tokens, also known as JWTs, are URL-safe JSON-based security tokens that contain a set of claims that can be signed and/or encrypted. JWTs are being widely used and deployed as a simple security token format in numerous protocols and applications, both in the area of digital identity and in other application areas. This Best Current Practices document updates RFC 7519 to provide actionable guidance leading to secure implementation and deployment of JWTs.
	* [The Anatomy of a JSON Web Token](https://scotch.io/tutorials/the-anatomy-of-a-json-web-token)
	* [Introduction to JSON Web Tokens](https://jwt.io/introduction/) 
	* [JSON Web Token Flowchart](http://cryto.net/%7Ejoepie91/blog/attachments/jwt-flowchart.png)
	* [JSON Web Token Security Cheat Sheet](https://assets.pentesterlab.com/jwt_security_cheatsheet/jwt_security_cheatsheet.pdf)
	* [Learn JSON Web Token(JWT) in 10 Minutes - tutorialdocs.com](https://www.tutorialdocs.com/article/jwt-learn.html)
- **Informational**
	- **Articles/Blogposts/Writeups**
		* [JWT Handbook - Auth0](https://auth0.com/resources/ebooks/jwt-handbook)
		* [Reference Tokens and Introspection - leastprivilege.com(2015)](https://leastprivilege.com/2015/11/25/reference-tokens-and-introspection/)
		* [Stop using JWT for sessions - joepie91(2016)](http://cryto.net/~joepie91/blog/2016/06/13/stop-using-jwt-for-sessions/)
		* [Stop using JWT for sessions, part 2: Why your solution doesn't work - joepie91(2016)](http://cryto.net/%7Ejoepie91/blog/2016/06/19/stop-using-jwt-for-sessions-part-2-why-your-solution-doesnt-work/)
		* [JSON Web Token Best Current Practices - draft-ietf-oauth-jwt-bcp-07](https://tools.ietf.org/html/draft-ietf-oauth-jwt-bcp-07)
		* [JWTs: Which Signing Algorithm Should I Use? - Scott Brady(2020)](https://www.scottbrady91.com/JOSE/JWTs-Which-Signing-Algorithm-Should-I-Use)
		* [The Hard Parts of JWT Security Nobody Talks About - Philippe De Ryck(2019)](https://www.pingidentity.com/en/company/blog/posts/2019/jwt-security-nobody-talks-about.html)
		* [Building a Secure Signed JWT - Dan Noore(2020)](https://fusionauth.io/learn/expert-advice/tokens/building-a-secure-jwt)
	- **Presentations/Talks/Videos**
		* [Jwt==insecurity? - Ruxcon2018](https://www.slideshare.net/snyff/jwt-insecurity)
		* [JSON Web Tokens Suck - Randall Degges (DevNet Create 2018)](https://www.youtube.com/watch?v=JdGOb7AxUo0)
			* JSON Web Tokens (JWTs) are all the rage in the security world. They're becoming more and more ubiquitous in web authentication libraries, and are commonly used to store a user's identity information. In this talk, you'll learn why JWTs suck, and why you should never use them.
		* [Attacking and Securing JWT - @airman604(OWAPS Vancouver)](https://owasp.org/www-chapter-vancouver/assets/presentations/2020-01_Attacking_and_Securing_JWT.pdf)
		* [JWTs in a Flash! - Evan Johnson(Defcon24)](https://www.slideshare.net/EvanJJohnson/jwts-and-jose-in-a-flash)
			* The new(ish) JOSE standard is growing rapidly in popularity. Many people are excited to adopt the new standard and use it to build interesting and new things with JWT! Let's get everyone up to speed on JWT's, talk about the do's and don't regarding JWTs, review some JWT uses, and use JWT's effectively.
		* [Are You Properly Using JWTs? - Dmitry Sotnikov(AppSec California2020)](https://www.youtube.com/watch?v=M3jA0bGDCso)
			* JSON Web tokens (JWTs) are used massively in API-based applications as access tokens or to transport information across services. Unfortunately, JWT are often mis-used and incorrectly handled. Massive data breaches have occurred in the last 18 months due to token leakage and lack of proper of validation. This session focuses on best practices and real world examples of JWT usage, where we cover: Typical scenarios where using JWT is a good idea; Typical scenarios where using JWT is a bad idea!; Principles of Zero trust architecture and why you should always validate; Best practices to thoroughly validate JWTs and potential vulnerabilities if you don’t.; Use cases when encryption may be required for JWT
		* [JWT Parkour - Louis Nyffenegger(AppSec California2020)](https://www.youtube.com/watch?v=zWVRHK3ykfo)
			* Nowadays, JSON Web Tokens are everywhere. They are used as session tokens or just to pass data between applications or µservices. By design, JWT contains a high number of security and cryptography pitfalls. In this talk, we are going to learn how to exploit (with demos) some of those issues. After covering the basics (None and Algorithm confusion), we are going to move to kid injection, embedded JWK (CVE-2018-0114). Finally, we will look at jku and x5u attributes and how they can be abused by chaining vulnerabilities.
		* [JWT: jku x5u - Louis Nyffenegger(2020)](https://www.slideshare.net/snyff/jwt-jku-x5u)
			* Talk on JWT jku and x5u and how to attack them
- **Attacking**
	- **101**
		* [JWT Attack Playbook](https://github.com/ticarpi/jwt_tool/wiki)
			* This wiki is a project to document the known attacks and potential security vulnerabilities and misconfigurations you may come across when testing JSON Web Tokens, and to provide a repeatable methodology for attacking them.
		* [JWT Hacking 101 - trustfoundry.net](https://trustfoundry.net/jwt-hacking-101/)
	- **Articles/Blogposts/Writeups**
		* [JWT Tool Attack Methods - ticarpi](https://www.ticarpi.com/jwt-tool-attack-methods/)
		* [JWT Vulnerabilities (Json Web Tokens) - HackTricks](https://book.hacktricks.xyz/pentesting-web/hacking-jwt-json-web-tokens)
		* [JWT Attack Walk-Through - Jerome Smith(2019)](https://www.nccgroup.com/uk/about-us/newsroom-and-events/blogs/2019/january/jwt-attack-walk-through/)
		* [Hacking JWT Tokens: The None Algorithm - Shivam Bathla](https://blog.pentesteracademy.com/hacking-jwt-tokens-the-none-algorithm-67c14bb15771)
		* [How to Hack a Weak JWT Implementation with a Timing Attack - Tamas Polgar(2017)](https://hackernoon.com/can-timing-attack-be-a-practical-security-threat-on-jwt-signature-ba3c8340dea9)
		* [Practicing JWT Attacks Against Juice-Shop - scomurr(2020)](https://sc.scomurr.com/jwt-and-juice-shop/)
		* [Hardcoded secrets, unverified tokens, and other common JWT mistakes - Vasilii Ermilov(2020)](https://r2c.dev/blog/2020/hardcoded-secrets-unverified-tokens-and-other-common-jwt-mistakes/)
	- **Talks/Presentations**
		* [Friday the 13th: JSON Attacks - Defcon25](https://media.defcon.org/DEF%20CON%2025/DEF%20CON%2025%20presentations/DEFCON-25-Alvaro-Munoz-JSON-attacks.pdf)
		* [Critical vulnerabilities in JSON Web Token libraries - 2015](https://auth0.com/blog/critical-vulnerabilities-in-json-web-token-libraries/)
		* [Cracking JWT tokens: a tale of magic, Node.JS and parallel computing - Luciano Mammino(Codemotion Milan2017)](https://www.youtube.com/watch?v=_wXQW-dIyL8)
			* Learn how you can use some JavaScript/Node.js black magic to crack JWT tokens and impersonate other users or escalate privileges. Just add a pinch of ZeroMQ, a dose of parallel computing, a 4 leaf clover, mix everything applying some brute force and you'll get a powerful JWT cracking potion!
		* [The Hacker's Guide to JWT Security by Patrycja Wegrzynowicz(2019)](https://www.youtube.com/watch?v=_wXQW-dIyL8)
			* JSON Web Token (JWT) is an open standard for creating tokens that assert some number of claims like a logged in user and his/her roles. JWT is widely used in modern applications as a stateless authentication mechanism. Therefore, it is important to understand JWT security risks, especially when broken authentication is among the most prominent security vulnerabilities according to the OWASP Top 10 list.  This talk guides you through various security risks of JWT, including confidentiality problems, vulnerabilities in algorithms and libraries, token cracking, token sidejacking, and more. In live demos, you’ll learn how to hijack a user account exploiting common security vulnerabilities on the client-side, on the server-side, and in transport.  You’ll also find out about common mistakes and vulnerabilities along with the best practices related to the implementation of JWT authentication and the usage of available JWT libraries.
		* ["JWAT.... Attacking JSON Web Tokens" - Louis Nyffenegger(BSides Canberra 2019)](https://www.youtube.com/watch?v=sGvF8wS76Dk)
		* [Modern Webapp Pentesting: How to Attack a JWT - BB King(2020)](https://www.youtube.com/watch?v=muYmiEtPL8U)
			* In this Black Hills Information Security webcast - an excerpt from his upcoming 16-hour Modern Webapp Pentesting course - BB King will talk about what JSON Web Tokens are, why they're so controversial, and how to test for their major weaknesses. Then, using OWSAP's Juice Shop as a target, he'll show you a straightforward method for exploiting them that you can use on your own next webapp pentest
- **Testing**
	* [Attacking JWT authentication](https://www.sjoerdlangkemper.nl/2016/09/28/attacking-jwt-authentication/)
	* [Fuzzing JSON Web Services - Simple guide how to fuzz JSON web services properly - secapps](https://secapps.com/blog/2018/03/fuzzing-json-web-services)
	* [JWT Attack Walk-Through - Jerome Smith](https://www.nccgroup.trust/uk/about-us/newsroom-and-events/blogs/2019/january/jwt-attack-walk-through/)
- **Tools**
	* [json token decode](http://jwt.calebb.net/)
	* [JWT Inspector - FF plugin](https://www.jwtinspector.io/)
		* JWT Inspector is a browser extension that lets you decode and inspect JSON Web Tokens in requests, cookies, and local storage. Also debug any JWT directly from the console or in the built-in UI.
	* [c-jwt-cracker ](https://github.com/brendan-rius/c-jwt-cracker)
	* [JWT4B](https://github.com/mvetsch/JWT4B)
		* JSON Web Tokens (JWT) support for the Burp Interception Proxy. JWT4B will let you manipulate a JWT on the fly, automate common attacks against JWT and decode it for you in the proxy history. JWT4B automagically detects JWTs in the form of 'Authorization Bearer' headers as well as customizable post body parameters.
	* [jwt_tool](https://github.com/ticarpi/jwt_tool)
		* a toolkit for validating, forging and cracking JWTs (JSON Web Tokens).
		* [Introducing JWT Tool  - ticarpi](https://www.ticarpi.com/introducing-jwt-tool/)
	* [jwt_secrets - BBhacKing](https://github.com/BBhacKing/jwt_secrets)
		* A list of "secrets" from JWT sample code and readme files based on the list of projects at https://jwt.io/
	* [jwt-secrets - wallarm](https://github.com/wallarm/jwt-secrets)
		* The goal for this project was to find as many public-available JWT secrets as possible to help developers and DevOpses identify it by traffic analysis at the Wallarm NGWAF level.
- **Writeups**
	* [How to configure Json.NET to create a vulnerable web API - alphabot](https://www.alphabot.com/security/blog/2017/net/How-to-configure-Json.NET-to-create-a-vulnerable-web-API.html)
	* [🔐 Learn how to use JSON Web Token (JWT) to secure your next Web App! (Tutorial/Example with Tests!!)](https://github.com/dwyl/learn-json-web-tokens)
	* [Critical vulnerabilities in JSON Web Token libraries](https://auth0.com/blog/critical-vulnerabilities-in-json-web-token-libraries/)
	* [Brute Forcing HS256 is Possible: The Importance of Using Strong Keys in Signing JWTs](https://auth0.com/blog/brute-forcing-hs256-is-possible-the-importance-of-using-strong-keys-to-sign-jwts/)
	* [Hacking JSON Web Token (JWT) - Hate_401](https://medium.com/101-writeups/hacking-json-web-token-jwt-233fe6c862e6)
	* [JWT (JSON Web Token) (in)security - Michal Sadjak(2019)](https://research.securitum.com/jwt-json-web-token-security/)
	* [Practical Approaches for Testing and Breaking JWT Authentication - Mazin Ahmed](https://mazinahmed.net/blog/breaking-jwt/)
	* [JSON Web Token Validation Bypass in Auth0 Authentication API - Ben Knight(2020)](https://insomniasec.com/blog/auth0-jwt-validation-bypass))


--------------------------------------------------------------------------------------------------------------------------------



### <a name="mime">MIME Sniffing</a>
* **101**
	* [What is MIME Sniffing? - keycdn.com](https://www.keycdn.com/support/what-is-mime-sniffing/)
	* [Content Sniffing - Wikipedia](https://en.wikipedia.org/wiki/Content_sniffing)
		* Content sniffing, also known as media type sniffing or MIME sniffing, is the practice of inspecting the content of a byte stream to attempt to deduce the file format of the data within it. 
	* [MIME Sniffing - whatwg.org](https://mimesniff.spec.whatwg.org/#matching-a-mime-type-pattern)
	* [Media Type Sniffing | draft-ietf-websec-mime-sniff-03](https://tools.ietf.org/html/draft-ietf-websec-mime-sniff-03)
		* Many web servers supply incorrect Content-Type header fields with their HTTP responses. In order to be compatible with these servers, user agents consider the content of HTTP responses as well as the Content-Type header fields when determining the effective media type of the response. This document describes an algorithm for determining the effective media type of HTTP responses that balances security and compatibility considerations
* **Articles/Blogposts/Writeups**
	* [Risky sniffing - MIME sniffing in Internet Explorer enables cross-site scripting attacks - h-online.com(2009)](http://www.h-online.com/security/features/Risky-MIME-sniffing-in-Internet-Explorer-746229.html)
	* [What is “X-Content-Type-Options=nosniff”?](https://stackoverflow.com/questions/18337630/what-is-x-content-type-options-nosniff)
	* [Content hosting for the modern web - Google](https://security.googleblog.com/2012/08/content-hosting-for-modern-web.html)
	* [Is it safe to serve any user uploaded file under only white-listed MIME content types? - StackOverflow](https://security.stackexchange.com/questions/11756/is-it-safe-to-serve-any-user-uploaded-file-under-only-white-listed-mime-content)
* **Exploitation of**
	* [MS07-034 - Yosuke Hasegawa](https://web.archive.org/web/20160609171311/http://openmya.hacker.jp/hasegawa/security/ms07-034.txt)
- **Tools**


--------------------------------------------------------------------------------------------------------------------------------


### <a name="oauth"></a>OAUTH
- **101**
	* [OAuth 2.0 Security Best Current Practice draft-ietf-oauth-security-topics-05 - Expires Sept19,2018](https://tools.ietf.org/html/draft-ietf-oauth-security-topics-05)
		* This document describes best current security practices for OAuth 2.0.. It updates and extends the OAuth 2.0 Security Threat Model to incorporate practical experiences gathered since OAuth 2.0 was published and cover new threats relevant due to the broader application of OAuth 2.0.
	* [OAuth 2.0 Dynamic Client Registration Protocol - rfc7591](https://tools.ietf.org/html/rfc7591)
		* This specification defines mechanisms for dynamically registering OAuth 2.0 clients with authorization servers. Registration requests send a set of desired client metadata values to the authorization server. The resulting registration responses return a client identifier to use at the authorization server and the client metadata values registered for the client. The client can then use this registration information to communicate with the authorization server using the OAuth 2.0 protocol. This specification also defines a set of common client metadata fields and values for clients to use during registration.
	* [The OAuth 2.0 Authorization Framework: JWT Secured Authorization Request - ietf.org](https://tools.ietf.org/html/draft-ietf-oauth-jwsreq-15)
		* The authorization request in OAuth 2.0 described in RFC 6749 utilizes query parameter serialization, which means that Authorization Request parameters are encoded in the URI of the request and sent through user agents such as web browsers. While it is easy to implement, it means that (a) the communication through the user agents are not integrity protected and thus the parameters can be tainted, and (b) the source of the communication is not authenticated. Because of these weaknesses, several attacks to the protocol have now been put forward. This document introduces the ability to send request parameters in a JSON Web Token (JWT) instead, which allows the request to be signed with JSON Web Signature (JWS) and encrypted with JSON Web Encryption (JWE) so that the integrity, source authentication and confidentiality property of the Authorization Request is attained. The request can be sent by value or by reference.
	* [OAuth 2.0 Mutual TLS Client Authentication and Certificate Bound Access Tokens - ietf](https://tools.ietf.org/html/draft-ietf-oauth-mtls-07)
		* This document describes Transport Layer Security (TLS) mutual authentication using X.509 certificates as a mechanism for OAuth client authentication to the authorization sever as well as for certificate bound sender constrained access tokens as a method for a protected resource to ensure that an access token presented to it by a given client was issued to that client by the authorization server.
	* [RFC 6819: OAuth 2.0 Threat Model and Security Considerations](https://tools.ietf.org/html/rfc6819)
	* [OAuth 2.0 Security Best Current Practice draft-ietf-oauth-security-topics-15](https://tools.ietf.org/html/draft-ietf-oauth-security-topics-15)
	* [The Modern Guide to OAuth - Brian Pontarelli, Dan Moore(2021)](https://fusionauth.io/learn/expert-advice/oauth/modern-guide-to-oauth)
	* [Signing in with Google - Okta](https://www.oauth.com/oauth2-servers/signing-in-with-google/)
	* [Multi-Factor Authentication: 4 Challenges Faced by Developers - Micah Silverman(2018)](https://developer.okta.com/blog/2018/05/16/multifactor-authentication-4-challenges-faced-by-developers)
- **Articles/Blogposts/Writeups**
	* [Dancing with OAuth: Understanding how Authorization Works - Ashish Mathur](https://medium.com/@imashishmathur/0auth-a142656859c6)
	* [Shining a Light on OAuth Abuse with PwnAuth - Douglas Bienstock](https://www.fireeye.com/blog/threat-research/2018/05/shining-a-light-on-oauth-abuse-with-pwnauth.html)
	* [OAUTH – Everything you wanted to know but not really! - Elaheh Samani, Kevin Watkins](https://sector.ca/sessions/oauth-everything-you-wanted-to-know-but-not-really/)
	* [An Illustrated Guide to OAuth and OpenID Connect - David Neal(2019)](https://developer.okta.com/blog/2019/10/21/illustrated-guide-to-oauth-and-oidc)
	* [Analysis of Common Federated Identity Protocols: OpenID Connect vs OAuth 2.0 vs SAML 2.0 - hackedu.io](https://blog.hackedu.io/analysis-of-common-federated-identity-protocols/)
	* [RFC 8693 OAuth 2.0 Token Exchange](https://www.rfc-editor.org/rfc/rfc8693.html)
	* [Introduction to OAuth 2.0 and OpenID Connect - PragmaticWebSecurity](https://courses.pragmaticwebsecurity.com/courses/introduction-to-oauth-2-0-and-openid-connect)
	* [Mastering OAuth 2.0 and OpenID Connect - PragmaticWebSecurity](https://courses.pragmaticwebsecurity.com/bundles/mastering-oauth-oidc)
	* [OAuth 2.0 : Explained - Milind Daftari(2019)](https://medium.com/@milinddaftari/oauth-2-0-explained-d001e5c98ee7)
	* [What's new in OAuth 2.1? - Dan Moore(2020)](https://fusionauth.io/blog/2020/04/15/whats-new-in-oauth-2-1/)
	* [Common Federated Identity Protocols: OpenID Connect vs OAuth vs SAML 2 - hackedu(2020)](https://web.archive.org/web/20201107230148/https://blog.hackedu.com/analysis-of-common-federated-identity-protocols-openid-connect-vs-oauth-2.0-vs-saml-2.0)
	* [Google Oauth2 API Explained - Pumudu Ruhunage(2020)](https://medium.com/@pumudu88/google-oauth2-api-explained-dbb84ff97079)
	* [Hidden OAuth attack vectors - Michael Stepankin(2021)](https://portswigger.net/research/hidden-oauth-attack-vectors)
	* [OAuth 2.0 authentication vulnerabilities - Portswigger](https://portswigger.net/web-security/oauth)
	* [Security Analysis in an OpenID Connect Lab Environment - Christian Fries(2021)](https://web-in-security.blogspot.com/2021/05/security-analysis-in-openid-connect-lab.html)
	* [OAuth by Sakurity](http://sakurity.com/oauth)
	* [Approaches for authenticating external applications in a machine-to-machine scenario - Patrick Sard and Jeremy Ware(2022)](https://aws.amazon.com/blogs/security/approaches-for-authenticating-external-applications-in-a-machine-to-machine-scenario/)
	* [Microsoft and GitHub OAuth Implementation Vulnerabilities Lead to Redirection Attacks - David Krispin, Nir Swartz(2021)](https://www.proofpoint.com/us/blog/cloud-security/microsoft-and-github-oauth-implementation-vulnerabilities-lead-redirection)
	* [OAuth 2.0 Hacking for Beginners with Farah Hawa - Farah Hawa](https://www.youtube.com/watch?app=desktop&v=ZOwwA07x6Iw)
		* An introduction to some authentication flows in OAuth 2.0 followed by a demo of some common bug types that can be found in them.
	* [alert(‘OAuth 2.0’); // The impact of XSS on OAuth 2.0 in SPAs - Philippe De Ryck](https://pragmaticwebsecurity.com/talks/xssoauth.html)
	* [OAuth Abuse: Think Solarwinds/Solorigate Campaign with Focus on Cloud Applications - Itir Clarke, Assaf Friedman(2021)](https://www.proofpoint.com/us/blog/cloud-security/oauth-abuse-think-solarwindssolorigate-campaign-focus-cloud-applications)
	* [2FA Bypass via Google Identity & OAuth Login - Sharat Kaikolamthuruthil(2022)](https://medium.com/@sharp488/2fa-bypass-via-google-identity-oauth-login-6c991ac837af)
	* [Account hijacking using "dirty dancing" in sign-in OAuth-flows - Frans Rosen(2022)](https://labs.detectify.com/2022/07/06/account-hijacking-using-dirty-dancing-in-sign-in-oauth-flows/)
	* [How can Hackers Analyze the Attacks on OAuth 2.0? - anubhav.singh(2022)](https://payatu.com/blog/oauth-vulnerabilities/)
- **Presentations/Talks/Videos**
	* [OAuth2: Beyond The Specs - Daniele Timo Second - BSides Lisbon2018](https://www.youtube.com/watch?v=qBxI0bjtJvU&t=0s&list=PLbuNP88_wbNxPkglG6zLUhvzvxvDimuEc&index=7)
		* What if you roll out OAuth, and realize there are a bunch of small things you didn’t consider? It’s what happened to us at Pipedrive, and although it’s likely not over just yet, we’re running smoothly. It’s a good time to share what we’ve learned and save others some time. While building Pipedrive’s marketplace for third-party apps, we transitioned from API token authentication to OAuth, and it’s been an interesting learning experience. In this talk, I will explain how the protocol works, discuss differences in how OAuth is implemented on different platforms, and explain how we managed the transition from API token to OAuth. I will explain how CSRF attacks work in OAuth, how the state parameter can prevent them, how to manage synchronization between server and clients, and what you can run into when you roll out OAuth for dozens of apps.
	* [OAuth 2.0 and OpenID Connect (in plain English) - Nate Barbettini(OktaDev)](https://www.youtube.com/watch?v=996OiexHze0)
	* [Discord Hangout: Practical OAuth Attacks - Scot Berner](https://www.youtube.com/watch?v=wf8apBA6CRc)
		* During this Discord Hangout, Scot Berner (@slobtresix0) provides some background on OAuth and how attackers can use it to gain access to an organization. Scot shows how Microsoft uses OAuth with Microsoft 365 along with how it can be used for social engineering and external attacks.
	* [OAuth: When Things Go Wrong - Aaron Parecki(2019)](https://www.youtube.com/watch?v=H6MxsFMAoP8)
		* [Slides](https://speakerdeck.com/aaronpk/oauth-when-things-go-wrong)
		* Aaron Parecki discusses common security threats when building microservices using OAuth and how to protect yourself. You'll learn about high-profile API security breaches related to OAuth; common implementation patterns for mobile apps, browser-based apps, and web server apps; and the latest best practices around OAuth security being developed by the IETF OAuth working group.
	* [How To Hack OAuth｜Øredev 2019 - Aaron Parecki(2019)](https://www.youtube.com/watch?v=p9hpqT5H3Lo)
		* OAuth is the foundation of most of modern online security, used everywhere from signing in to mobile apps, to protecting your bank accounts. Despite its ubiquity, it is still often difficult to implement safely and securely, especially in today's landscape, which is dramatically different from the world of online security as it existed when OAuth was initially created. This talk will explore several real-world OAuth hacks that affected major providers like Twitter, Facebook and Google. I'll share the details of how each specific attack happened, as well as what they could have done to prevent it. Some of these attacks exploited technical flaws in the system, and some exploited the easier to hack, squishier component in the middle: people.
	* [Implementation Pitfalls Of OAuth 2.0 - Samit Anwer(GreHack2019)](https://www.youtube.com/watch?v=HoSpCXg97Qc)
		* "Since the beginning of distributed personal computer networks, one of the toughest problem has been to provide a secure SSO and authorization experience between unrelated servers/services. The OAuth 2.0 authorization framework enables 3rd party apps to obtain discretionary access to a web service. Built on top of OAuth, OpenID Connect is a helpful “identity layer” that provides developers with a framework to build an authentication system. In this race of providing OAuth/Open ID Connect based access to assets, authorization service providers have been forced to release half-baked solutions in the wild because of which relying parties and users face myriad of issues ranging from authorization code compromise (unauthorized resource access) to account takeovers. In this talk we will discuss common malpractices that "relying party" and "authorization service provider" developers perform when implementing OAuth/OpenID based solutions. We will learn the attacks that can happen thereof and mitigation."
	* [Introduction to OAuth 2.0 and OpenID Connect - Philippe De Ryck](https://pragmaticwebsecurity.com/talks/introductionoauth.html)		
	* [OAuth Bypass Technique - Sheikh Rizan(BSides Singapore2021)](https://www.youtube.com/watch?app=desktop&v=2W3RlWxIBgw&list=PLUN2aSqQWw7XOPKThhTK38Q6vszsiDOcI&index=4)
		* OAuth is an open standard for access delegation, commonly used as a way for Internet users to grant websites or applications access to their information on other websites but without giving them the passwords. We often see websites with “Sign in with Facebook” option. This facility provides convenience to the users that do not wish to sign up using the traditional username and password option. However, there exist a small number of websites that have poorly implemented OAuth allowing an attacker to bypass the authentication and impersonate another user to gain access to websites’ protected resources. This technique is known in the Bug Bounty community and is regarded as an authentication bypass or an account take-over. While there are various write-ups with regards to OAuth authentication bypass, this technique is not widely covered. We would like to present the technical details of the vulnerability we had found.
	* [Hacking Oauth Applications - Pt. 1 - HackingSimplified(2021)](https://www.youtube.com/watch?v=gVqrf2uUdQ0)
		* In this part we discuss about Oauth - What, Why & How and then look at some of the flows like authorization code grant and implicit grant. We close today's session by doing a hands-on with Portswigger lab on Implicit grant flow.
- **Attacking**
	* [The most common OAuth 2.0 Hacks - Okhomiak](https://habr.com/en/post/449182/)
	* [Bypassing GitHub's OAuth flow - Teddy Katz](https://blog.teddykatz.com/2019/11/05/github-oauth-bypass.html)
	* [Practical OAuth Abuse for Offensive Operations – Part 1 - Scot Berner(2020)](https://www.trustedsec.com/blog/practical-oauth-abuse-for-offensive-operations-part-1/)
	* [An offensive guide to the Authorization Code grant - Rami McCarthy](https://research.nccgroup.com/2020/07/07/an-offensive-guide-to-the-authorization-code-grant/)
	* [Bypassing GitHub's OAuth flow - Teddy Katz](https://blog.teddykatz.com/2019/11/05/github-oauth-bypass.html)
	* [ Penetration Tester's Guide to Evaluating OAuth 2.0 — Authorization Code Grants - ](https://maxfieldchen.com/posts/2020-05-17-penetration-testers-guide-oauth-2.html)
	* [OAuth 2.0 Implementation and Security - Haboob](https://www.exploit-db.com/download/48495)
	* [The Wondeful World of OAuth: Bug Bounty Edition - A Bug’z Life(2020)](https://medium.com/a-bugz-life/the-wondeful-world-of-oauth-bug-bounty-edition-af3073b354c1)
	* [Account hijacking using "dirty dancing" in sign-in OAuth-flows - Frans Rosen(2022)](https://labs.detectify.com/2022/07/06/account-hijacking-using-dirty-dancing-in-sign-in-oauth-flows/)
- **Tools**
	* [OAuth 2.0 Playground - Okta](https://oauth.com/playground/)
	* [oauth2-proxy/oauth2-proxy](https://github.com/oauth2-proxy/oauth2-proxy)
		* A reverse proxy that provides authentication with Google, Azure, OpenID Connect and many more identity providers.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="parsers"></a> Parsers
- **Articles/Blogposts/Writeups**
	* [Path Building vs Path Verifying: The Chain of Pain - Ryan Sleevi(2020)](https://medium.com/@sleevi_/path-building-vs-path-verifying-the-chain-of-pain-9fbab861d7d6)
	* [How to exploit parser differentials - Joern Schneeweisz(2020)](https://about.gitlab.com/blog/2020/03/30/how-to-exploit-parser-differentials/)
	* [Breaking Parser Logic: Gain Access To NGINX Plus API — Read/Write Upstreams. - zoid(2022)](https://zoidsec.medium.com/breaking-parse-logic-gain-access-to-nginx-api-read-write-upstreams-1cb062aa44ca)
	* [Pwning a Server using Markdown: Escalating a bug in a vulnerable markdown parser to exploit LFI and get RCE - Aditya Dixit](https://blog.dixitaditya.com/pwning-a-server-using-markdown)
- **Talks/Presentations/Videos**
	* [Breaking Parser Logic: Take Your Path Normalization off and Pop 0days Out! - Orange Tsai(2020)](https://www.youtube.com/watch?v=CIhHpkybYsY)
		* [Slides](https://i.blackhat.com/us-18/Wed-August-8/us-18-Orange-Tsai-Breaking-Parser-Logic-Take-Your-Path-Normalization-Off-And-Pop-0days-Out-2.pdf)
		* "We propose a new exploit technique that brings a whole-new attack surface to defeat path normalization, which is complicated in implementation due to many implicit properties and edge cases. This complication, being under-estimated or ignored by developers for a long time, has made our proposed attack vector possible, lethal, and general. "
- **Tools**
	* [Bypass-Url-Parser](https://github.com/laluka/bypass-url-parser)
		* Tool that tests MANY url bypasses to reach a 40X protected page.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="paseto"></a> Platform Agnostic Security Token (PASETO)
* **101**
	* [PASETO.io](https://paseto.io)
	* [A Thorough Introduction to PASETO - Randall Degges](https://developer.okta.com/blog/2019/10/17/a-thorough-introduction-to-paseto)
* **Articles/Blogposts/Writeups**
	* [Paseto is a Secure Alternative to the JOSE Standards (JWT, etc.) - Scott Arciszewski](https://paragonie.com/blog/2018/03/paseto-platform-agnostic-security-tokens-is-secure-alternative-jose-standards-jwt-etc)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="php"></a>PHP
 **101**
-	* [PHP - Wikipedia](https://en.wikipedia.org/wiki/PHP)
	* [PHP Language Reference - php.net](https://www.php.net/manual/en/langref.php)
	* [PHP Tutorial - Tutorialspoint](https://www.tutorialspoint.com/php/index.htm)
- **Articles/Blogposts/Writeups**
	* [Pwning PHP mail() function For Fun And RCE | New Exploitation Techniques And Vectors](https://exploitbox.io/paper/Pwning-PHP-Mail-Function-For-Fun-And-RCE.html)
	* [The unexpected dangers of preg_replace](https://bitquark.co.uk/blog/2013/07/23/the_unexpected_dangers_of_preg_replace)
	* [Imagecreatefromgif-Bypass](https://github.com/JohnHoder/Imagecreatefromgif-Bypass)
		* A simple helper script to find byte sequences present in both of 2 given files. The main purpose of this is to find bytes that remain untouched after being processed with imagecreatefromgif() PHP function from GD-LIB. That is the place where a malicious PHP script can be inserted to achieve some nasty RCE.
	* [Is PHP vulnerable and under what conditions?](http://0x191unauthorized.blogspot.fr/2015/04/is-php-vulnerable-and-under-what.html)
	* [PHP7 Internals - Become a Wizard](https://github.com/0xbigshaq/php7-internals)
		* Welcome to the PHP Internals Hub - If you ever wondered about how PHP works internally and how you can exploit it: this is where you should start. In this repo, I show basic and advanced exploitation in PHP (some of the bugs reported by me). In every "chapter", you'll learn a little bit more about PHP Internals from an infosec perspective.
	* [Modern PHP Security Part 1: bug classes - Thomas Chauchefoin, Lena David(2020)](https://labs.detectify.com/2020/08/13/modern-php-security-part-1-bug-classes/)
	* [Modern PHP Security Part 2: Breaching and hardening the PHP engine - Thomas Chauchefoin, Lena David(2020)](https://labs.detectify.com/2020/08/20/modern-php-security-part-2-breaching-and-hardening-the-php-engine/)
- **Code Reuse**
	* **101**
		* [The ReflectionClass class](https://secure.php.net/ReflectionClass)
		* [Autoloading Classes](http://www.php.net/language.oop5.autoload)
	* **Articles/Blogposts/Writeups**
		* [PHP Autoload Invalid Classname Injection](https://hakre.wordpress.com/2013/02/10/php-autoload-invalid-classname-injection/)
- **Crypto**
	- **101**
	- **Articles/Blogposts/Writeups**
		* [I Forgot Your Password: Randomness Attacks Against PHP Applications - George Argyros, Aggelos Kiayia](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.360.4033&rep=rep1&type=pdf)
			* We provide a number of practical techniques and algorithms for exploiting randomness vulnerabilities in PHP applications.We focus on the predictability of password reset tokens and demonstrate how an attacker can take over user accounts in a web application via predicting or algorithmically derandomizing the PHP core randomness generators. While our techniques are designed for the PHP language, the principles behind our techniques and our algorithms are independent of PHP and can readily apply to any system that utilizes weak randomness generators or low entropy sources. Our results include: algorithms that reduce the entropy of time variables, identifying and exploiting vulnera- bilities of the PHP system that enable the recovery or reconstruction of PRNG seeds, an experimental analysis of the Hastad-Shamir framework for breaking truncated linear variables, an optimized online Gaussian solver for large sparse linear systems, and an algorithm for recovering the state of the Mersenne twister generator from any level of truncation.  We demonstrate the gravity of our attacks via a number of case studies. Specifically, we show that a number of current widely used web applications can be broken using our tech- niques including Mediawiki, Joomla, Gallery, osCommerce and others.
- **De/Serialization**
	- **101**
		* [serialize - php](http://us3.php.net/serialize)
		* [unserialize - php](https://secure.php.net/unserialize)
		* [PHP Object Injection](https://www.owasp.org/index.php/PHP_Object_Injection)
		* [Is PHP unserialize() exploitable without any 'interesting' methods? - StackOverflow](https://security.stackexchange.com/questions/77549/is-php-unserialize-exploitable-without-any-interesting-methods)
	- **Articles/Blogposts/Writeups**
		* [Demystifying Insecure Deserialization in PHP - Sourov Gosh(2020)](https://medium.com/bugbountywriteup/demystifying-insecure-deserialization-in-php-684cab9c4d24)
		* [Writing Exploits For Exotic Bug Classes: unserialize()](https://www.alertlogic.com/blog/writing-exploits-for-exotic-bug-classes-unserialize()/)
		* [Remote code execution via PHP [Unserialize] - notsosecure](https://www.notsosecure.com/remote-code-execution-via-php-unserialize/)
		* [PHP Generic Gadget Chains: Exploiting unserialize in unknown environments](https://www.ambionics.io/blog/php-generic-gadget-chains)
		* [PHPGGC: PHP Generic Gadget Chains](https://github.com/ambionics/phpggc)
			* PHPGGC is a library of unserialize() payloads along with a tool to generate them, from command line or programmatically. When encountering an unserialize on a website you don't have the code of, or simply when trying to build an exploit, this tool allows you to generate the payload without having to go through the tedious steps of finding gadgets and combining them. Currently, the tool supports: Doctrine, Guzzle, Laravel, Monolog, Slim, SwiftMailer.
		* [File Operation Induced Unserialization via the "phar://" Stream Wrapper - secarma labs](https://github.com/s-n-t/presentations/blob/master/us-18-Thomas-It's-A-PHP-Unserialization-Vulnerability-Jim-But-Not-As-We-Know-It-wp.pdf)
		* [PHP Object Injection Cheat Sheet - Lucian Nitescu(2018)](https://nitesculucian.github.io/2018/10/05/php-object-injection-cheat-sheet/)
		* [Testing Methodology for Insecure Deserialization Vulnerability - SecureLayer7(2021)](https://blog.securelayer7.net/testing-methodology-for-insecure-deserialization-vulnerability/)
		* [Insecure Deserialization - How to Trace Down a Gadget Chain - redteampentesting(2021)](https://blog.redteam-pentesting.de/2021/deserialization-gadget-chain/)
		* [Remote code execution through unsafe unserialize in PHP - Sjoerd Langkemper(2021)](https://www.sjoerdlangkemper.nl/2021/04/04/remote-code-execution-through-unsafe-unserialize/)
		* [Unserializable, but unreachable: Remote code execution on vBulletin - Charles Fol(2023)](https://www.ambionics.io/blog/vbulletin-unserializable-but-unreachable)
	- **Talks/Presentations/Videos**
		* [Intro to PHP Deserialization / Object Injection - Ippsec(2019)](https://www.youtube.com/watch?v=HaW15aMzBUM)
		* [Advanced PHP Deserialization - Phar Files - Ippsec(2019)](https://www.youtube.com/watch?v=fHZKSCMWqF4)
		* [Exploiting PHP7 unserialize - Yannay Livneh (33c3)](https://media.ccc.de/v/33c3-7858-exploiting_php7_unserialize)
			* PHP-7 is a new version of the most prevalent server-side language in use today. Like previous version, this version is also vulnerable to memory corruptions. However, the language has gone through extensive changes and none of previous exploitation techniques are relevant. In this talk, we explore the new memory internals of the language from exploiters and vulnerability researchers point of view. We will explain newly found vulnerabilities in the 'unserialize' mechanism of the language and present re-usable primitives for remote exploitation of these vulnerabilities.
	- **Pictures**
		* [Hacking with Pictures - Syscan2015](http://www.slideshare.net/saumilshah/hacking-with-pictures-syscan-2015)
		* [Exploiting PHP-GD imagecreatefromjpeg() function - fakhrizulkifli](https://github.com/fakhrizulkifli/Defeating-PHP-GD-imagecreatefromjpeg)
			* Proof-of-concept to exploit the flaw in the PHP-GD built-in function, imagecreatefromjpeg(). Inspired by one of Reddit's comment on my previous thread regarding exploiting the imagecreatefromgif() PHP-GD function.
	- **Property-Oriented Programming(POP)**
		* [Code Reuse Attacks in PHP: Automated POP Chain Generation](https://www.syssec.rub.de/media/emma/veroeffentlichungen/2014/09/10/POPChainGeneration-CCS14.pdf)
			* In this paper, we study code reuse attacks in the context of PHP-based web applications. We analyze how PHP object injection (POI) vulnerabilities can be exploited via property-oriented programming (POP) and perform a systematic analysis of available gadgets in common PHP applications. Furthermore, we introduce an automated approach to statically detect POI vulnerabilities in object-oriented PHP code. Our approach is also capable of generating POP chains in an automated way. We implemented a prototype of the proposed approach and evaluated it with 10 well-known applications. Overall, we detected 30 new POI vulnerabilities and 28 new gadget chains
		* [Utilizing Code Reuse/ROP in PHP Application Exploits - BH 2010](https://www.owasp.org/images/9/9e/Utilizing-Code-Reuse-Or-Return-Oriented-Programming-In-PHP-Application-Exploits.pdf)
		* [POP-Exploit](https://github.com/enddo/POP-Exploit)
			* Research into Property Oriented Programming about php applications.
- **Filters**
	* [PHP filter_var shenanigans - Jordy Zomer(2021](https://pwning.systems/posts/php_filter_var_shenanigans/)
		* "It is likely that we have all seen PHP filters that prevent us from encountering vulnerabilities. Here in this blog post, I’ll walk you through my thought process for bypassing a filter by looking for a bug in the filter itself in order to reach a bug!"
	* [PHP filters chain: What is it and how to use it -  Rémi Matasse(2022)](https://www.synacktiv.com/publications/php-filters-chain-what-is-it-and-how-to-use-it.html)
		* "In this article we will explain how to combine a recently discovered technique called PHP filters [LOKNOP-GIST], to transform file inclusion primitives in PHP applications to remote code execution."
- **Function Injection**
	* [Dynamic Function Injection in PHP - Osanda Malith Jayathissa(2015)](https://osandamalith.com/2015/03/27/dynamic-function-injection-in-php/)
- **Bypassing Disabled Functions**
	* [Bypass of Disabled System Functions - Netsparker](https://www.netsparker.com/blog/web-security/bypass-disabled-system-functions/)
	* [A deep dive into disable_functions bypasses and PHP exploitation - Juan Manuel Fernandez(2020)](https://www.blackarrow.net/disable-functions-bypasses-and-php-exploitation/)
- **Polyglots**
	* [Six files that are also a valid PHP - Caio Luders(2017)](https://medium.com/caio-noobs-around/six-files-that-are-also-a-valid-php-540343ad35c8)
- **String Parsing**
	* [Abusing PHP query string parser to bypass IDS, IPS, and WAF - theMiddle(2019)](https://www.secjuice.com/abusing-php-query-string-parser-bypass-ids-ips-waf/)
		* In this post, we'll see how the PHP query string parser could lead to many IDS/IPS and Application Firewall rules bypass.
- **Type Juggling**
	- **101**
		* [PHP Magic Tricks: Type Juggling](https://www.owasp.org/images/6/6b/PHPMagicTricks-TypeJuggling.pdf)
		* [PHP’s “Magic Hash” Vulnerability (Or Beware Of Type Juggling)](https://web.archive.org/web/20150530075600/http://blog.astrumfutura.com/2015/05/phps-magic-hash-vulnerability-or-beware-of-type-juggling)
	- **Articles/Blogposts/Writeups**
		* [(Super) Magic Hashes - myst404](https://offsec.almond.consulting/super-magic-hash.html)
			* "TL;DR: Magic hashes are well known specific hashes used to exploit Type Juggling attacks in PHP. Combined with bcrypt limitations, we propose the concept of Super Magic Hashes. These hashes can detect 3 different vulnerabilities: type juggling, weak password storage and incorrect Bcrypt usage. A Go PoC found some MD5, SHA1 and SHA224 super magic hashes."
		* [Writing Exploits For Exotic Bug Classes: PHP Type Juggling](https://turbochaos.blogspot.com.au/2013/08/exploiting-exotic-bugs-php-type-juggling.html)
		* [From hacked client to 0day discovery - infoteam](https://security.infoteam.ch/en/blog/posts/from-hacked-client-to-0day-discovery.html)
			* PHP equivalency check failure writeup
- **Writeups**
	* [Php Codz Hacking](https://github.com/80vul/phpcodz)
		* Writeups of specific PHP vulns
	* [Privilege Escalation in 2.3M WooCommerce Shops - Karim El Ouerghemmi, Slavco Mihajloski](https://blog.ripstech.com/2018/woocommerce-php-object-injection/)
		* During our research we discovered a PHP Object Injection vulnerability in WooCommerce (CVE-2017-18356) that allows to escalate privileges with a unique and interesting injection technique.
- **Tools**
	* [The shortest non-alphanumeric reverse shell (php) script (19 bytes)](https://gist.github.com/0xSojalSec/5bee09c7035985ddc13fddb16f191075)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="robots"></a> robots.txt
* **101**
		* [Protocol Buffers - Google](https://developers.google.com/protocol-buffers)
			* "Protocol buffers are Google's language-neutral, platform-neutral, extensible mechanism for serializing structured data – think XML, but smaller, faster, and simpler. You define how you want your data to be structured once, then you can use special generated source code to easily write and read your structured data to and from a variety of data streams and using a variety of languages."


--------------------------------------------------------------------------------------------------------------------------------


### <a name="robots"></a> robots.txt
* **101**
	* [About /robots.txt - robotstxt.org](https://www.robotstxt.org/robotstxt.html)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="rpc"></a> RPC-related
- **gRPC**
	- **101**
		* [Introduction to gRPC - grpc.io](https://grpc.io/docs/what-is-grpc/introduction/)
		* [What is gRPC? Meaning, Architecture, Advantages  - wallarm](https://www.wallarm.com/what/the-concept-of-grpc)
	- **General**
		* [Pentesting gRPC-Web : Recon and reverse-engineering - David Vasallo(2018)](https://blog.davidvassallo.me/2018/10/27/pentesting-grpc-web-recon-and-reverse-engineering/)
		* [gRPC Attack Surface - RastaMouse(2021)](https://offensivedefence.co.uk/posts/grpc-attack-surface/)
	- **Tools**
		* [grpcurl](https://github.com/fullstorydev/grpcurl)
			* Like cURL, but for gRPC: Command-line tool for interacting with gRPC servers


--------------------------------------------------------------------------------------------------------------------------------


### <a name="ruby"></a>Ruby/Ruby on Rails
- **101**
	* [Ruby on Rails Cheatsheet - OWASP](https://www.owasp.org/index.php/Ruby_on_Rails_Cheatsheet)
	* [Ruby on Rails Security Guide](http://guides.rubyonrails.org/security.html)
- **Articles/Blogposts/Writeups**
	* [Executing commands in ruby](http://blog.bigbinary.com/2012/10/18/backtick-system-exec-in-ruby.html)
	* [Attacking Ruby on Rails Applications - phrack](http://phrack.org/issues/69/12.html#article)
	* [Going AUTH the Rails on a Crazy Train: A Dive into Rails Authentication and Authorization](https://www.blackhat.com/docs/eu-15/materials/eu-15-Jarmoc-Going-AUTH-The-Rails-On-A-Crazy-Train-wp.pdf)
	* [Property Oriented Programming - Applied to Ruby](https://slides.com/benmurphy/property-oriented-programming/fullscreen#/)
	* [Pentesting Django and Rails](https://es.slideshare.net/levigross/pentesting-django-and-rails)
	* [Executing commands in ruby](http://blog.bigbinary.com/2012/10/18/backtick-system-exec-in-ruby.html)
	* [Execution of shell code in Ruby scripts](https://makandracards.com/makandra/1243-execution-of-shell-code-in-ruby-scripts)
	* [Pre-Auth RCE in Aspera Faspex: Case Guide for Auditing Ruby on Rails - Maxwell Garrett, Shubham Shah](https://blog.assetnote.io/2023/02/02/pre-auth-rce-aspera-faspex/)
- **Tools**
	* [Brakeman](https://github.com/presidentbeef/brakeman)
		* Brakeman is an open source static analysis tool which checks Ruby on Rails applications for security vulnerabilities.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="sop"></a> Same-Origin Policy
- **101**
	* [RFC 6454: The Web Origin Concept](https://tools.ietf.org/html/rfc6454)
		* This document defines the concept of an "origin", which is often used as the scope of authority or privilege by user agents. Typically, user agents isolate content retrieved from different origins to prevent malicious web site operators from interfering with the operation of benign web sites. In addition to outlining the principles that underlie the concept of origin, this document details how to determine the origin of a URI and how to serialize an origin into a string. It also defines an HTTP header field, named "Origin", that indicates which origins are associated with an HTTP request.
	* [Same-origin policy - Mozilla](https://developer.mozilla.org/en-US/docs/Web/Security/Same-origin_policy)
		* The same-origin policy is a critical security mechanism that restricts how a document or script loaded from one origin can interact with a resource from another origin. It helps isolate potentially malicious documents, reducing possible attack vectors.
	* [Same-origin policy - Wikipedia](https://en.wikipedia.org/wiki/Same-origin_policy)
	* [Same-origin Policy - W3](https://www.w3.org/Security/wiki/Same_Origin_Policy)
- **Articles/Blogposts/Writeups**
	* [Whitepaper: The Definitive Guide to Same-origin Policy - Alex Baker, Ziyahan Albeniz, Emre Iyidogan](https://www.netsparker.com/whitepaper-same-origin-policy/)
	* [Same-Origin Policy: From birth until today - Alex Nikolova](https://research.aurainfosec.io/same-origin-policy/)
	* [My hacking adventures with Safari reader mode - Nikhil Mittal(2020)](https://payatu.com/blog/my-hacking-adventures-with-safari-reader-mode/
	* [WebSockets not Bound by SOP and CORS? Does this mean… - Drew Branch(2018)](https://blog.securityevaluators.com/websockets-not-bound-by-cors-does-this-mean-2e7819374acc?gi=75e2bd4c2043#e8bc)
	* [The Same-Origin Policy Gone Wild - Parsia(2020)](https://parsiya.net/blog/2020-11-01-the-same-origin-policy-gone-wild/)
- **Talks/Presentations**
	* [The Tangled Web and Its Same Origin Policy - Pankaj](https://www.youtube.com/watch?v=xaYvpLv9pMI)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="saml"></a>Security Assertion Markup Language (SAML)
- **101**
	* [Security Assertion Markup Language - Wikipedia](https://en.wikipedia.org/wiki/Security_Assertion_Markup_Language)
	* [SAML 2.0 - Wikipedia](https://en.wikipedia.org/wiki/SAML_2.0)
	* [OASIS SAML Wiki](https://wiki.oasis-open.org/security/FrontPage)
	* [How SAML 2.0 Authentication Works - Russell Jones](https://gravitational.com/blog/how-saml-authentication-works/)
	* [What is SAML and How Does it Work? - Jeff Petters(2020)](https://www.varonis.com/blog/what-is-saml/)
- **Articles/Blogposts/Writeups**
	* [With Great Power Comes Great Pwnage](https://www.compass-security.com/fileadmin/Datein/Research/Praesentationen/area41_2016_saml.pdf)
	* [Out of Band  XML External Entity Injection via SAML SSO - Sean Melia](https://seanmelia.files.wordpress.com/2016/01/out-of-band-xml-external-entity-injection-via-saml-redacted.pdf)
	* [Web-based Single Sign-On and the Dangers of SAML XML Parsing](https://blog.sendsafely.com/web-based-single-sign-on-and-the-dangers-of-saml-xml-parsing)
	* [Following the white Rabbit Down the SAML Code](https://medium.com/section-9-lab/following-the-white-rabbit-5e392e3f6fb9)
	* [Evilginx - Advanced Phishing with Two-factor Authentication Bypass](https://breakdev.org/evilginx-advanced-phishing-with-two-factor-authentication-bypass/)
		* [Evilginx - Update 1.0](https://breakdev.org/evilginx-1-0-update-up-your-game-in-2fa-phishing/)
		* [Evilginx - Update 1.1](https://breakdev.org/evilginx-1-1-release/)
	* [SAML All the Things! A Deep Dive into SAML SSO - Elijah A. Martin-Merrill](https://blog.rapid7.com/2019/10/03/saml-all-the-things-a-deep-dive-into-saml-sso/)
- **Golden SAML Attack**
	* [Golden SAML: Newly Discovered Attack Technique Forges Authentication to Cloud Apps](https://www.cyberark.com/threat-research-blog/golden-saml-newly-discovered-attack-technique-forges-authentication-cloud-apps/)
	* [shimit](https://github.com/cyberark/shimit)
		* In a golden SAML attack, attackers can gain access to an application (any application that supports SAML authentication) with any privileges they desire and be any user on the targeted application. shimit allows the user to create a signed SAMLResponse object, and use it to open a session in the Service Provider. shimit now supports AWS Console as a Service Provider, more are in the works...
- **Tools**
	* [Evilginx](https://github.com/kgretzky/evilginx)
		* Evilginx is a man-in-the-middle attack framework used for phishing credentials and session cookies of any web service. It's core runs on Nginx HTTP server, which utilizes proxy_pass and sub_filter to proxy and modify HTTP content, while intercepting traffic between client and server.
	* [SAMLReQuest Burpsuite Extention](https://insinuator.net/2016/06/samlrequest-burpsuite-extention/)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="serviceworkers"></a> Service Workers
- **101**
	* [Service Worker - w3c](https://w3c.github.io/ServiceWorker/)
		* This specification describes a method that enables applications to take advantage of persistent background processing, including hooks to enable bootstrapping of web applications while offline.  The core of this system is an event-driven Web Worker, which responds to events dispatched from documents and other sources. A system for managing installation, versions, and upgrades is provided.  The service worker is a generic entry point for event-driven background processing in the Web Platform that is extensible by other specifications.
	* [Web Worker - Wikipedia](https://en.wikipedia.org/wiki/Web_worker)
	* [Web workers vs Service workers vs Worklets - bitsofcode(2018)](https://bitsofco.de/web-workers-vs-service-workers-vs-worklets/)
- **Articles/Blogposts/Writeups**
	* [Service Workers: an Introduction - developers.google](https://developers.google.com/web/fundamentals/primers/service-workers)
	* [Service Worker API - MDN(Mozilla)](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API)
	* [Using Service Workers - MDN(Mozilla)](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API/Using_Service_Workers)
	* [ServiceWorker is dangerous - @steike(@2014)](https://alf.nu/ServiceWorker)
	* [Abusing the Service Workers API - Daniel Abeles(2020)](https://blogs.akamai.com/sitr/2020/01/abusing-the-service-workers-api.html)
	* [Stuff I wish I'd known sooner about service workers - Rich Harris](https://gist.github.com/Rich-Harris/fd6c3c73e6e707e312d7c5d7d0f3b2f9)
	* [Service Worker Security FAQ - Chromium.google](https://chromium.googlesource.com/chromium/src/+/master/docs/security/service-worker-security-faq.md)
- **Papers**
	* [Master of Web Puppets: Abusing Web Browsersfor Persistent and Stealthy Computation - Panagiotis Papadopoulos, Panagiotis Ilia, Michalis Polychronakis, Evangelos P. Markatos, Sotiris Ioannidis, Giorgos Vasiliadis(2019)](https://www.ndss-symposium.org/wp-content/uploads/2019/02/ndss2019_01B-2_Papadopoulos_paper.pdf)
		* In this paper, we demonstrate the powerful capabilitiesthat modern browser APIs provide to attackers by presentingMarioNet: a framework that allows a remote malicious entity tocontrol a visitor’s browser and abuse its resources for unwantedcomputation or harmful operations, such as cryptocurrencymining, password-cracking, and DDoS. MarioNet relies solely onalready available HTML5 APIs, without requiring the installationof any additional software. In contrast to previous browser-based botnets, the persistence and stealthiness characteristics ofMarioNet allow the malicious computations to continue in thebackground of the browser even after the user closes the windowor tab of the initially visited malicious website. We present thedesign, implementation, and evaluation of our prototype system,which is compatible with all major browsers, and discuss potentialdefense strategies to counter the threat of such persistent in-browser attacks. Our main goal is to raise awareness about thisnew class of attacks, and inform the design of future browserAPIs so that they provide a more secure client-side environmentfor web applications.
- **Tools**
	* [Service Worker Cookbook](https://serviceworke.rs/)
		* The Service Worker Cookbook is a collection of working, practical examples of using service workers in modern web sites.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="siteisolate"></a> Site Isolation
- **101**
	* [Deep Dive into Site Isolation (Part 1) - Jun Kokatsu(2020)](https://microsoftedge.github.io/edgevr/posts/deep-dive-into-site-isolation-part-1/)
		* [Part 2](https://microsoftedge.github.io/edgevr/posts/deep-dive-into-site-isolation-part-2/)
	* [Introducing Firefox’s new Site Isolation Security Architecture - Anny Gakhokidze(2021)](https://hacks.mozilla.org/2021/05/introducing-firefox-new-site-isolation-security-architecture/)



--------------------------------------------------------------------------------------------------------------------------------



### <a name="sri"></a> Subresource Integrity
- **101**
	* [Subresource Integrity - W3.org](https://www.w3.org/TR/SRI/)
	* [Subresource Integrity - w3c.github.io](https://w3c.github.io/webappsec-subresource-integrity/)
		* This specification defines a mechanism by which user agents may verify that a fetched resource has been delivered without unexpected manipulation.
- **Articles/Blogposts/Writeups**
	* [Subresource Integrity - Mozilla](https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity)
	* [Subresource Integrity (SRI) for Validating Web Resources Hosted on Third Party Services (CDNs) - Netsparker](https://www.netsparker.com/blog/web-security/subresource-integrity-SRI-security/)
- **Tools**
	* [SRI Hash Generator](https://www.srihash.org/)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="ssltls"></a>Secure Sockets Layer/Transport Layer Security(SSL/TLS)
- **101**
	* [Transport Layer Security - Wikipedia](https://en.wikipedia.org/wiki/Transport_Layer_Security)
	* [RFC 6101: The Secure Sockets Layer (SSL) Protocol Version 3.0 - IETF](https://www.rfc-editor.org/rfc/rfc6101)
	* [RFC 2246: The TLS Protocol - IETF](https://www.ietf.org/rfc/rfc2246.txt)
	* [RFC 5246: The Transport Layer Security (TLS) Protocol Version 1.2 - IETF](https://www.rfc-editor.org/rfc/rfc5246)
	* [RFC 8446: The Transport Layer Security (TLS) Protocol Version 1.3 - IETF](https://datatracker.ietf.org/doc/rfc8446/)
	* [RFC 8740: Using TLS 1.3 with HTTP/2 - IETF](https://httpwg.org/specs/rfc8740.html)
- **Articles/Blogposts/Presentations/Talks/Writeups**
	* [Transport Layer Security (TLS) Extensions](https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml)
	* [Mixed content - w3c](https://w3c.github.io/webappsec-mixed-content/)
		* This specification describes how a user agent should handle fetching of content over unencrypted or unauthenticated connections in the context of an encrypted and authenticated document.
	* [Understanding SSL — Secure Socket Layer | 2023 - Karthikeyan Nagaraj(2022)](https://cyberw1ng.medium.com/understanding-ssl-secure-socket-layer-2023-a0ada4329842)
	* [How HTTPS Works](https://blog.dnsimple.com/2017/04/how-to-write-a-comic/)
	* [A Detailed Look at RFC 8446 (a.k.a. TLS 1.3) - Nick Sullivan(2018)](https://blog.cloudflare.com/rfc-8446-aka-tls-1-3/)
	* [curl’s TLS fingerprint - Daniel Stenberg(2022)](https://daniel.haxx.se/blog/2022/09/02/curls-tls-fingerprint/)
- **Attacks Against**
	- **Articles/Blogposts/Writeups**
		* [Downgrade Attack on TLS 1.3 and Vulnerabilities in Major TLS Libraries - David Wong](https://www.nccgroup.trust/us/about-us/newsroom-and-events/blog/2019/february/downgrade-attack-on-tls-1.3-and-vulnerabilities-in-major-tls-libraries/)
		* [SSL, GONE IN 30 SECONDS: A BREACH beyond CRIME - Angelo Prado, Neal Harris, Yoel Gluck(BHUSA2013)](https://www.breachattack.com/resources/BREACH%20-%20BH%202013%20-%20PRESENTATION.pdf)
		* [Playback: a TLS 1.3 story - Alfonso García Alguacil & Alejo Murillo Moya(2018)](https://labs.portcullis.co.uk/download/us-18-GarciaAlguacil_MurilloMoya-Playback_A_TLS_1.3_Story__v6.pdf)
	- **Talks/Presentations**
		* [SSL/TLS Interception Proxies and Transitive Trust](http://media.blackhat.com/bh-eu-12/Jarmoc/bh-eu-12-Jarmoc-SSL_TLS_Interception-WP.pdf)
			* Secure Sockets Layer (SSL) and its successor Transport Layer Security (TLS), have become key components of the modern Internet. The privacy, integrity, and authenticity provided by these protocols are critical to allowing sensitive communications to occur. Without these systems, e-commerce, online banking, and business-to-business exchange of information would likely be far less frequent. Threat actors have also recognized the benefits of transport security, and they are increasingly turning to SSL to hide their activities. Advanced Persistent Threat (APT ) attackers, botnets, and eve n commodity web attacks can leverage SSL encryption to evade detection. To counter these tactics, organizations are increasingly deploying security controls that intercept end-to-end encrypted channels. Web proxies, data loss prevention (DLP) systems, specialized threat detection solutions, and network intrusion prevention systems (NIPS) offer functionality to intercept, inspect, and filter encrypted traffic. Similar functionality is present in lawful intercept systems and solutions enabling the broad surveillance of encrypted communications by governments. Broadly classified as “SSL/TLS interception proxies”, these solutions act as a “man-in-the-middle", violating the end-to-end security promises of SSL. This type of interception comes at a cost. Intercepting SSL-encrypted connections sacrifices a degree of privacy and integrity for the benefit of content inspection, often at the risk of authenticity and endpoint validation. Implementers and designers of SSL interception proxies should consider these risks and understand how their systems operate in unusual circumstances
	- **Tools**



--------------------------------------------------------------------------------------------------------------------------------


### <a name="sso">Single Sign-On(SSO)</a>
- **101**
- **Articles/Blogposts/Writeups**
	* [Single Sign-On Security: Security Analysis of real-life OpenID Connect Implementations - Lauritz HoltmanN(2020)](https://web-in-security.blogspot.com/2020/11/single-sign-on-security-security.html)
	* [Improving OAuth App-to-App Security - Fabian Hauck, Joseph Heenan, Daniel Fett(2020)](https://danielfett.de/2020/11/27/improving-app2app/)
	* [ Security and Privacy of Social Logins (I): Single Sign-On Protocols in the Wild - Louis Jannett(2021)](https://web-in-security.blogspot.com/2021/02/security-and-privacy-of-social-logins-part1.html)
	SSO Wars: The Token Menace - Alvaro MuÒoz, Oleksandr Mirosh
	* [Common Federated Identity Protocols: OpenID Connect vs OAuth vs SAML 2 - Security Journey](https://www.securityjourney.com/post/analysis-of-common-federated-identity-protocols-openid-connect-vs-oauth-2.0-vs-saml-2.0)
	* [Breaking Through Single Sign On (SSO) - Alex Bainbridge](https://www.praetorian.com/blog/breaking-through-okta-single-sign-on-sso-security)
- **Talks & Presentations**
	* [SSO Wars: The Token Menace - Alvaro Munoz, Oleksandr Mirosh]()
		* [Slides](https://i.blackhat.com/USA-19/Wednesday/us-19-Munoz-SSO-Wars-The-Token-Menace.pdf)
- **Dupe Key Confusion**
	* attack to bypass XML signature verification by sending multiple key identifiers in the KeyInfo section. Vulnerable systems will use the first one to verify the XML signature and the second one to verify the trust on the signing party. This plugin applies this technique to SAML tokens by allowing to modify and then resign the SAML assertion with an arbitrary attacker-controlled key which is then send as the first element of the KeyInfo section, while the original key identifier is sent as the second key identifier.
	* **Tools**
		* [DupeKeyInjector](https://github.com/pwntester/DupeKeyInjector)
			* Dupe Key Injetctor is a Burp Suite extension implementing Dupe Key Confusion, a new XML signature bypass technique presented at BSides/BlackHat/DEFCON 2019 "SSO Wars: The Token Menace" presentation. 
			* [Slides](https://github.com/pwntester/DupeKeyInjector/blob/master/resources/slides.pdf)
			* [Paper](https://github.com/pwntester/DupeKeyInjector/blob/master/resources/whitepaper.pdf)
- **Tools**
	* [PrOfESSOS](https://github.com/RUB-NDS/PrOfESSOS)
		* PrOfESSOS is our open source implementation for fully automated Evaluation-as-a-Service for SSO. PrOfESSOS introduces a generic approach to improve the security of OpenID Connect implementations by systematically detecting vulnerabilities.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="streams"></a>Streans
- **101**
	* [Streams - Dec12 2019](https://streams.spec.whatwg.org)
		* This specification provides APIs for creating, composing, and consuming streams of data that map efficiently to low-level I/O primitives.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="unicode"></a>Unicode
- **101**
 	* [The Absolute Minimum Every Software Developer Absolutely, Positively Must Know About Unicode and Character Sets (No Excuses!) - Joel Spolsky(2003)](https://www.joelonsoftware.com/2003/10/08/the-absolute-minimum-every-software-developer-absolutely-positively-must-know-about-unicode-and-character-sets-no-excuses/)
- **Articles/Blogposts**
	* [Creative usernames and Spotify account hijacking - Mikael Goldmann(2013)](https://engineering.atspotify.com/2013/06/creative-usernames/)
	* [Unicode Normalization Vulnerabilities & the Special K Polyglot - AppCheck(2019)](https://appcheck-ng.com/unicode-normalization-vulnerabilities-the-special-k-polyglot)
	* [/i considered harmful - PentesterLab(2020)](https://blog.pentesterlab.com/i-considered-harmful-6e20936ea65f?gi=43ab93bbb616)
- **Talks/Presentations**
	* [Unraveling Unicode: A Bag of Tricks for Bug Hunting - Chris Weber(BHUSA2009)](https://www.blackhat.com/presentations/bh-usa-09/WEBER/BHUSA09-Weber-UnicodeSecurityPreview-SLIDES.pdf)
	* [5 Unicode Vulnerabilities that could bi/yte you - Philippe Arteau](https://www.youtube.com/watch?v=Mqg8e6lJ-E8&list=PLuUtcRxSUZUqhwo0e6j0hrqXifo8jItdl&index=12)
		* [Slides](https://gosecure.github.io/presentations/2020-05-unicode-northsec/unicode_v3_northsec.pdf)
		* "In this talk, you will learn about the security implications of encoding conversion. Normalizing a UTF-8 string to ASCII only character has numerous potential side effects. The latest research affecting Unicode will be summarized including the HostSplit and HostBond attacks. The HostSplit attack abuses minor characters conversion to trigger open redirect or Server-Side Request Forgery (SSRF). While HostBond is a risk affecting service provider giving subdomain to account created by users. Aside from normalization, uppercase and lowercase transformation can introduce vulnerability. Encoding can be used to circumvent security controls such as Web Application Firewalls. Punycode is the new representation to support domains with special characters outside of ASCII. This representation can be used to create visual confusion to end users."


--------------------------------------------------------------------------------------------------------------------------------


### <a name="uri"></a>Uniform Resource Identifier/Locator(URIs/URLs)
- **101**
	* [RFC5785: Defining Well-Known Uniform Resource Identifiers (URIs)](https://tools.ietf.org/html/rfc5785)
	* [URL Living Standard - spec.whatwg.org](https://url.spec.whatwg.org)
	* [Cool URIs don't change - W3C](https://www.w3.org/Provider/Style/URI)
	https://github.com/IAmStoxe/urlgrab
- **Articles/Blogposts/Presentations/Talks/Writeups**
	* [How to Obscure Any URL](http://www.pc-help.org/obscure.htm)
- **Data URIs**
	- **101**
		* [data URI scheme - Wikipedia](https://en.wikipedia.org/wiki/Data_URI_scheme)
			* The data URI scheme is a uniform resource identifier (URI) scheme that provides a way to include data in-line in Web pages as if they were external resources. It is a form of file literal or here document. This technique allows normally separate elements such as images and style sheets to be fetched in a single Hypertext Transfer Protocol (HTTP) request, which may be more efficient than multiple HTTP requests, and used by several browser extensions to package images as well as other multimedia contents in a single HTML file for page saving. As of 2015, data URIs are fully supported by most major browsers, and partially supported in Internet Explorer and Microsoft Edge.
		* [Data URLs - MDN(Mozilla)](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/Data_URIs)
		* [Data URIs - Chris Coyier](https://css-tricks.com/data-uris/)
	- **Articles/Blogposts/Writeups**
		* [Probably Don’t Base64 SVG - Chris Coyier(2016)](https://css-tricks.com/probably-dont-base64-svg/)
	- **Tools**
		* [Image to data-URI converter - Mike Foskett](https://websemantics.uk/tools/image-to-data-uri-converter/)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="waf">Web Application Firewalls(WAFs)</a>
- **101**
	* [Awesome WAF](https://github.com/0xInfection/Awesome-WAF)
		* 🔥 Everything awesome about web-application firewalls (WAF). 
- **Web Application Firewalls**
	* [ModSecurity](https://github.com/SpiderLabs/ModSecurity)
		* ModSecurity is an open source, cross platform web application firewall (WAF) engine for Apache, IIS and Nginx that is developed by Trustwave's SpiderLabs. It has a robust event-based programming language which provides protection from a range of attacks against web applications and allows for HTTP traffic monitoring, logging and real-time analys
	* [Shadow Daemon](https://shadowd.zecure.org/overview/introduction/)
		* Shadow Daemon is a collection of tools to detect, protocol and prevent attacks on web applications. Technically speaking, Shadow Daemon is a web application firewall that intercepts requests and filters out malicious parameters. It is a modular system that separates web application, analysis and interface to increase security, flexibility and expandability. Shadow Daemon is free software. It is released under the license GPLv2, so its source code can be examined, modified and distributed by everyone.
- **Articles/Blogposts/Writeups**
	* [Bypassing WAFs](http://www.nethemba.com/bypassing-waf.pdf)
	* [WAF Bypass Cheatsheet/gitbook](https://chybeta.gitbooks.io/waf-bypass/content/)
	* [Web Application Firewall (WAF) Evasion Techniques - theMiddle](https://medium.com/secjuice/waf-evasion-techniques-718026d693d8)
	* [Web Application Firewall (WAF) Evasion Techniques #2 - theMiddle](https://medium.com/secjuice/web-application-firewall-waf-evasion-techniques-2-125995f3e7b0)
	* [Web Application Firewall (WAF) Evasion Techniques - secjuice](https://medium.com/secjuice/waf-evasion-techniques-718026d693d8)
	* [Bypassing Web-Application Firewalls by abusing SSL/TLS - 0x09AL](https://0x09al.github.io/waf/bypass/ssl/2018/07/02/web-application-firewall-bypass.html)
	* [Request encoding to bypass web application firewalls - NCCGroup](https://www.nccgroup.trust/uk/about-us/newsroom-and-events/blogs/2017/august/request-encoding-to-bypass-web-application-firewalls/)
	* [Bypassing Web-Application Firewalls by abusing SSL/TLS - 0x09AL](https://0x09al.github.io/waf/bypass/ssl/2018/07/02/web-application-firewall-bypass.html)
	* [WAF bypass techniques - Pentestit(2019)](https://medium.com/@Pentestit_ru/bypassing-waf-4cfa1aad16bf)
	* [A Pentesters Guide - Part 5 (Unmasking WAFs and Finding the Source) - pyr0cc](https://delta.navisec.io/a-pentesters-guide-part-5-unmasking-wafs-and-finding-the-source/)
	* [WAF Bypassing with Unicode Compatibility - Jorge Lajara(2020)](https://jlajara.gitlab.io/web/2020/02/19/Bypass_WAF_Unicode.html)
	* [Bypassing WAF to do advanced Error-Based SQL Injection - kleiton0x7e(2020)](https://medium.com/bugbountywriteup/bypassing-waf-to-do-error-based-sql-injection-dd52773a66d3)
	* [Bypassing CDN WAF’s with Alternate Domain Routing - Ryan Gerstenkorn(2022)](https://blog.apnic.net/2022/05/19/bypassing-cdn-wafs-with-alternate-domain-routing/)
	* [How to Bypass Cloudflare in 2023: The 8 Best Methods - ZenRows(2023)](https://www.zenrows.com/blog/bypass-cloudflare#what-is-cloudflare-bot-management)
	* [A guide to non-conventional WAF/IDS evasion techniques - 0xFFFFF](https://web.archive.org/web/20210731223520/https://blog.0xffff.info/2021/07/24/a-guide-to-non-conventional-waf-ids-evasion-techniques/)
	* [Web application firewalls bypasses collection and testing tools](https://waf-bypass.com/)
	* [{JS-ON: Security-OFF}: Abusing JSON-Based SQL to Bypass WAF - Noam Moshe(2022)](https://claroty.com/team82/research/js-on-security-off-abusing-json-based-sql-to-bypass-waf)
	* [Bypass firewalls with of-CORs and typo-squatting - Grayson(2023)](https://trufflesecurity.com/blog/of-cors/)
- **Talks & Presentations**
	* [HTTP Invisibility Cloak by Soroush Dalili - SteelCon2017](https://www.youtube.com/watch?reload=9&v=sHEv_EoQJwc)
		* This talk illustrates a number of techniques to smuggle and reshape HTTP requests using features such as HTTP Pipelining that are not normally used by testers. The strange behaviour of web servers with different technologies will be reviewed using HTTP versions 1.1, 1.0, and 0.9 before HTTP v2 becomes too popular! Some of these techniques might come in handy when dealing with a dumb WAF or load balancer that blocks your attacks.
	* [Web Application Firewall Profiling and Evasion - Michael Ritter](https://owasp.org/www-pdf-archive/OWASP_Stammtisch_Frankfurt_WAF_Profiling_and_Evasion.pdf)
	* [Let's Talk About WAF (Bypass) Baby - Brett Gravois(NolaCon2019)](https://www.irongeek.com/i.php?page=videos/nolacon2019/nolacon-2019-c-10-lets-talk-about-waf-bypass-baby-brett-gravois)
		* All modern Web Application Firewalls are able to intercept (and even block) most common attacks from the web. However, what happens when an attacker uses HTTP2 to send attack traffic to a web application or service? In this talk we will cover basic attacks against web applications using HTTP2 to bypass WAFs and Proxies. Attendees will gain knowledge of how to bypass WAF and Proxies using the HTTP2 Protocol, and steps they can take to protect themselves against these kinds of attacks.
	* [Modern WAF Bypass Scripting Techniques for Autonomous Attacks - Jonny Xmas(2019)](https://www.infoq.com/presentations/waf-scripting-techniques-autonomous-attacks/)
	* [WAF Breakthrough in the Cloud Era - pyn3rd(2019)](https://github.com/pyn3rd/my-presentation-slide/blob/master/KCon_2019_WAF.pdf)
	* [AutoSpear : Towards Automatically Bypassing and Inspecting Web Application Firewalls - Zhenqing Qu, Xiang Ling, Chunming Wu(BHAsia2022)](https://i.blackhat.com/Asia-22/Thursday-Materials/AS-22-Qu-AutoSpear-Towards-Automatically-Bypassing-and-Inspecting-Web-Application-Firewalls.pdf)
- **Tools**
	* [WhatWaf](https://github.com/Ekultek/WhatWaf)
		* WhatWaf is an advanced firewall detection tool who's goal is to give you the idea of "There's a WAF?". WhatWaf works by detecting a firewall on a web application, and attempting to detect a bypass (or two) for said firewall, on the specified target.
	* [WAFPASS](https://github.com/wafpassproject/wafpass)
		* Analysing parameters with all payloads' bypass methods, aiming at benchmarking security solutions like WAF.
	* [WAF_buster](https://github.com/viperbluff/WAF_buster/blob/master/README.md)
	* [LightBulb](https://github.com/PortSwigger/lightbulb-framework)
		* LightBulb is an open source python framework for auditing web application firewalls and filters.
	* [WAFNinja](https://github.com/khalilbijjou/WAFNinja)
		* WAFNinja is a tool which contains two functions to attack Web Application Firewalls.
	* [Web Application Firewall Profiling and Evasion - Michael Ritter - OWASP](https://www.owasp.org/images/b/bf/OWASP_Stammtisch_Frankfurt_WAF_Profiling_and_Evasion.pdf)
	* [Guide To Identifying And Bypassing WAFs](https://www.sunnyhoi.com/guide-identifying-bypassing-wafs/)
	* [ftw](https://github.com/fastly/ftw)
		* Framework for Testing WAFs (FTW!)
	* [wafw00f](https://github.com/EnableSecurity/wafw00f)
		*  WAFW00F allows one to identify and fingerprint Web Application Firewall (WAF) products protecting a website. 
	* [cdn-proxy](https://github.com/RyanJarv/cdn-proxy)
		* A tool that can be used by web app pentesters to create a copy of a targeted website with CDN and WAF restrictions disabled.

--------------------------------------------------------------------------------------------------------------------------------


### <a name="webasm"></a>Web Assembly
- **101**
	* [Web Assembly](http://webassembly.org/)
	* [WebAssembly Specification](https://webassembly.github.io/spec/core/)
	* [A cartoon intro to WebAssembly Articles](https://hacks.mozilla.org/category/code-cartoons/a-cartoon-intro-to-webassembly/)
	* [Lin Clark: A Cartoon Intro to WebAssembly | JSConf EU 2017](https://www.youtube.com/watch?v=HktWin_LPf4&app=desktop)
	* [WebAssembly Design Documents](https://github.com/WebAssembly/design)
		* This repository contains documents describing the design and high-level overview of WebAssembly.
	* [WebAssembly - MDN(Mozilla)](https://developer.mozilla.org/en-US/docs/WebAssembly)
	* [How WebAssembly changes software distribution - Max Desiatov(2020)](https://desiatov.com/why-webassembly/)
	* [WebAssembly. Scary name, exciting applications. - Nicky Meuleman](https://nickymeuleman.netlify.app/blog/webassembly/)
	* [wasm-fizzbuzz - Cornelius Diekmann](https://github.com/diekmann/wasm-fizzbuzz)
		* WebAssembly from Scratch: From FizzBuzz to DooM.
- **Articles/Papers/Talks/Writeups**
	* [WebAssembly security: potentials and pitfalls - John Bergbom](https://www.forcepoint.com/blog/x-labs/webassembly-potentials-and-pitfalls)
	* [WebAssembly cut Figma's load time by 3x - Evan Wallace](https://www.figma.com/blog/webassembly-cut-figmas-load-time-by-3x/)
	* [Coding a WebAssembly CTF Challenge - Jacob Baines](https://medium.com/tenable-techblog/coding-a-webassembly-ctf-challenge-5560576e9cb7)
	* [Pay attention to WebAssembly - Harshal Sheth(2022)](https://harshal.sheth.io/2022/01/31/webassembly.html)
	* [Anti-Debug JS/WASM by Hand - Remy(2021)](https://remyhax.xyz/posts/javascript-wasm-anti-debug/)
- **Papers**
	* [Security Chasms of WASM - Brian McFadden, Tyler Lukasiewicz, Jeff Dileo, Justin Engler(2018)](https://i.blackhat.com/us-18/Thu-August-9/us-18-Lukasiewicz-WebAssembly-A-New-World-of-Native_Exploits-On-The-Web-wp.pdf)
		* WebAssembly is a new technology that allows web developers to run native C/C++on a webpage with near-native performance. This paper provides a basic introduc-tiontoWebAssemblyandexaminesthesecurityrisksthatadevelopermaytakeonbyusing it. We cover several examples exploring the theoretical security implications ofWebAssembly. We also cover Emscripten, which is currently the most popular Web-Assembly compiler toolchain. Our assessment of Emscripten includes its implemen-tation of compiler-and-linker-level exploit mitigations as well as the internal harden-ing of itslibcimplementation, and how its augmentation of WASM introduces newattack vectors and methods of exploitation. We also provide examples of memorycorruption exploits in the Wasm environment. Under certain circumstances, theseexploits could lead to to hijacking control flow or even executing arbitrary JavaScriptwithin the context of the web page. Finally, we provide a basic outline of best prac-tices and security considerations for developers wishing to integrate WebAssemblyinto their product.
	* [Everything Old is New Again:Binary Security of WebAssembly - Daniel Lehmann, Johannes Kinder, Michael Pradel(2020)](https://www.usenix.org/system/files/sec20-lehmann.pdf)
		* WebAssembly is an increasingly popular compilation targetdesigned to run code in browsers and on other platforms safelyand securely, by strictly separating code and data, enforcingtypes, and limiting indirect control flow. Still, vulnerabilitiesin memory-unsafe source languages can translate to vulnera-bilities in WebAssembly binaries. In this paper, we analyze towhat extent vulnerabilities are exploitable in WebAssemblybinaries, and how this compares to native code. We find thatmany classic vulnerabilities which, due to common mitiga-tions, are no longer exploitable in native binaries, are com-pletely exposed in WebAssembly. Moreover, WebAssemblyenables unique attacks, such as overwriting supposedly con-stant data or manipulating the heap using a stack overflow. Wepresent a set of attack primitives that enable an attacker (i) towrite arbitrary memory, (ii) to overwrite sensitive data, and(iii) to trigger unexpected behavior by diverting control flowor manipulating the host environment. We provide a set ofvulnerable proof-of-concept applications along with completeend-to-end exploits, which cover three WebAssembly plat-forms. An empirical risk assessment on real-world binariesand SPEC CPU programs compiled to WebAssembly showsthat our attack primitives are likely to be feasible in practice.Overall, our findings show a perhaps surprising lack of binarysecurity in WebAssembly. We discuss potential protectionmechanisms to mitigate the resulting risks.
- **Tools**
	* [WebAssembly for .NET](https://github.com/RyanLamansky/dotnet-webassembly)
		* A library able to create, read, modify, write and execute WebAssembly (WASM) files from .NET-based applications. Execution does not use an interpreter. WASM instructions are mapped to their .NET equivalents and converted to native machine language by the .NET JIT compiler.
	* [octopus](https://github.com/pventuzelo/octopus)
		* Security Analysis tool for WebAssembly module (wasm) and Blockchain Smart Contracts (BTC/ETH/NEO/EOS) 
	* [WasmEdge](https://github.com/WasmEdge/WasmEdge)
		* WasmEdge is a lightweight, high-performance, and extensible WebAssembly runtime for cloud native, edge, and decentralized applications. It powers serverless apps, embedded functions, microservices, smart contracts, and IoT devices.
- **Reversing**
	* [Web-(Dis)Assembly - Christophe Alladoum - Shakacon X](https://github.com/sophos/WebAssembly/blob/master/Misc/Web-(Dis)Assembly.pdf)
		* `https://github.com/sophos/WebAssembly/blob/master/Misc/Web-(Dis)Assembly.pdf`
	* [Analyzing WebAssembly binaries: initial feel and behavioral analysis - John Bergbom](https://www.forcepoint.com/blog/x-labs/analyzing-webassembly-binaries-initial-feel-and-behavioral-analysis)
	* [Analyzing WebAssembly binaries - Wasm Reverse Engineering - John Bergbom](https://www.forcepoint.com/blog/x-labs/analyzing-webassembly-binaries)
	* [Manual reverse engineering of WebAssembly: static code analysis - John Bergbom](https://www.forcepoint.com/blog/security-labs/manual-reverse-engineering-webassembly-static-code-analysis)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="webauthn"></a>Web Authentication
* **101**
	* [Web Authentication: An API for accessing Public Key Credentials](https://www.w3.org/TR/webauthn/)
* **Articles/Blogposts/Presentations/Talks/Writeups**
	* [Security Concerns Surrounding WebAuthn: Don't Implement ECDAA (Yet) - P.I.E. Staff](https://paragonie.com/blog/2018/08/security-concerns-surrounding-webauthn-don-t-implement-ecdaa-yet)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="webbt"></a>WebBluetooth
* **101**
	* [Web Bluetooth](https://webbluetoothcg.github.io/web-bluetooth/)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="webhooks"></a>Web Hooks
* **101**
	* [Webhooks - pbworks](https://webhooks.pbworks.com/w/page/13385124/FrontPage)
	* [WebHook - Wikipedia](https://en.wikipedia.org/wiki/Webhook)
* **Articles/Blogposts/Writeups**
	* [Abusing Webhooks for Command and Control - Dimitry Snezhkov - BSides LV 2017](https://www.youtube.com/watch?v=TmLoTrJuung)
		* [octohook](https://github.com/dsnezhkov/octohook)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="webnfc"></a>WebNFC
* **101**
	* [Web NFC](https://w3c.github.io/web-nfc/)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="webproxy">Web Proxies</a>
* **101**
* **Articles/Blogposts/Writeups**
	* [Utilizing Reverse Proxies to Inject Malicious Code & Extract Sensitive Information - James Sibley](https://versprite.com/blog/application-security/reverse-proxy-attack/)
	* [Weird Proxies](https://github.com/GrrrDog/weird_proxies)
	* [How to exfiltrate internal information using web proxies. - zezadas(2019)](https://sefod.eu/posts/web_proxies/)
- **Talks/Presentations**
	* [Weird proxies/2 and a bit of magic  - Aleksei Tiurin(ZeroNights2021)](https://www.youtube.com/watch?v=ADdG4MapO10)
		* Reverse proxies and their variations are used everywhere in modern web applications for routing, caching, and access differentiation. This talk is dedicated to new research results about different reverse proxies and new possibilities brought by HTTP/2. It is a collection of tricks for exploiting various misconfigurations.
* **Tools**
	* [Burpsuite](http://portswigger.net/burp/)
		* Burp Suite is an integrated platform for performing security testing of web applications. Its various tools work seamlessly together to support the entire testing process, from initial mapping and analysis of an application's attack surface, through to finding and exploiting security vulnerabilities. 
		- See [burp section](#burpstuff) at bottom of page.
	* [ZAP - Zed Attack Proxy](https://www.owasp.org/index.php/OWASP_Zed_Attack_Proxy_Project)
		* The Zed Attack Proxy (ZAP) is an easy to use integrated penetration testing tool for finding vulnerabilities in web applications.  It is designed to be used by people with a wide range of security experience and as such is ideal for developers and functional testers who are new to penetration testing.  ZAP provides automated scanners as well as a set of tools that allow you to find security vulnerabilities manually.
		* [ZAP Deep Dive Series - StackHawk](https://www.youtube.com/playlist?list=PLz_NN8o2uh8AQ7VyUEN1GCCnpzl5_FaJA)
		* https://www.youtube.com/playlist?list=PLz_NN8o2uh8AQ7VyUEN1GCCnpzl5_FaJA
		* https://github.com/zaproxy/zap-extensions/wiki/HelpAddonsOpenapiOpenapi
		* https://github.com/zaproxy/zap-extensions
		* https://github.com/we45/ZAP-Mini-Workshop
	* [Paros - Web Proxy](http://sourceforge.net/projects/paros/)
		* A Java based HTTP/HTTPS proxy for assessing web application vulnerability. It supports editing/viewing HTTP messages on-the-fly. Other featuers include spiders, client certificate, proxy-chaining, intelligent scanning for XSS and SQL injections etc.
	* [Mallory: Transparent TCP and UDP Proxy](https://intrepidusgroup.com/insight/mallory/)
		* Mallory is a transparent TCP and UDP proxy. It can be used to get at those hard to intercept network streams, assess those tricky mobile web applications, or maybe just pull a prank on your friend.
	* [TCP Catcher](http://www.tcpcatcher.org/)
		* TcpCatcher is a free TCP, SOCKS, HTTP and HTTPS proxy monitor server software. 
	* [wssip](https://github.com/nccgroup/wssip)
		* Application for capturing, modifying and sending custom WebSocket data from client to server and vice versa.
	* [ratproxy](https://github.com/wallin/ratproxy)
		* Ratproxy is a semi-automated, largely passive web application security audit  tool. It is meant to complement active crawlers and manual proxies more  commonly used for this task, and is optimized specifically for an accurate and  sensitive detection, and automatic annotation, of potential problems and  security-relevant design patterns based on the observation of existing,  user-initiated traffic in complex web 2.0 environments.
	* [proxify](https://github.com/projectdiscovery/proxify)
		* Swiss Army Knife Proxy for rapid deployments. Supports multiple operations such as request/response dump, filtering and manipulation via DSL language, upstream HTTP/Socks5 proxy. Additionally, a replay utility allows to import the dumped traffic (request/responses with correct domain name) into BurpSuite or any other proxy by simply setting the upstream proxy to proxify.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="webrtc"></a>WebRTC
* **101**
	* [WebRTC.org](https://webrtc.org/)
	* [WebRTC - Wikipedia](https://en.wikipedia.org/wiki/WebRTC)
	* [WebRTC 1.0: Real-Time Communication Between Browsers W3C](https://www.w3.org/TR/webrtc/)
	* [Webrtc.org](https://webrtc.org/)
	* [WebRTC - Wikipedia](https://en.wikipedia.org/wiki/WebRTC)
	* [Get started with WebRTC - Sam Dutton(2012/2020)](https://web.dev/webrtc-basics/)
	* [MDN Web Docs: WebRTC API](https://developer.mozilla.org/en-US/docs/Web/API/WebRTC_API)
* **Articles/Papers/Talks/Writeups**
	* [WebRTC API - MozillaDevNetwork](https://developer.mozilla.org/en-US/docs/Web/API/WebRTC_API)
	* [WebRTC - High Performance Browser Networking](https://hpbn.co/webrtc/)
	* [WebRTC for the Curious: Go beyond the APIs](https://webrtcforthecurious.com/)
		* he WebRTC book that explains everything. WebRTC is a real-time communication framework that makes it easy to build real-time interactions for web and mobile devices.  You will learn about the WebRTC specification and how all the protocols work in depth, not just a tour of the APIs. The book is completely Open Source and available at https://webrtcforthecurious.com and https://github.com/webrtc-for-the-curious/webrtc-for-the-curious Learn the full details of ICE, SCTP, DTLS, SRTP, and how they work together to make up the WebRTC stack.  Hear how WebRTC implementers debug issues with the tools of the trade. Listen to interviews with the authors of foundational WebRTC tech! Hear the motivations and design details that pre-dated WebRTC by 20 years. Explore the cutting edge of what people are building with WebRTC. Learn about interesting use cases and how real-world applications get designed, tested and implemented in production. Written by developers who have written all of this from scratch. We learned it the hard way, now we want to share it with you! This book is vendor agnostic and multiple Open Source projects and companies are involved. We would love to have you involved!
	* [Exploiting CVE-2022-0778, a bug in OpenSSL vis-à-vis WebRTC platforms - Sandro Gauci(2022)](https://www.rtcsec.com/article/exploiting-cve-2022-0778-in-openssl-vs-webrtc-platforms/)
* **Tools**
	* [STUN IP Address requests for WebRTC](https://github.com/diafygi/webrtc-ips)
* **Miscellaneous**
	* [Real time communication with WebRTC - Google(2019)](https://codelabs.developers.google.com/codelabs/webrtc-web#0)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="webservers">Web Servers</a>
- **Apache**
- **IIS**
- **Jetty**
	* [Making Jetty Bleed - Stephen Haywood](https://www.appsecconsulting.com/blog/making-jetty-bleed)
	* [JetLeak Vulnerability: Remote Leakage Of Shared Buffers In Jetty Web Server [CVE-2015-2080] - Stephen Komal](https://blog.gdssecurity.com/labs/2015/2/25/jetleak-vulnerability-remote-leakage-of-shared-buffers-in-je.html)
- **NGINX**


--------------------------------------------------------------------------------------------------------------------------------



### <a name="websockets"></a>WebSockets
- **101**
	* [The WebSocket Protocol Standard - IETF](https://tools.ietf.org/html/rfc6455)
	* [WebSocket Protocol - RFC Draft 17](https://tools.ietf.org/html/draft-ietf-hybi-thewebsocketprotocol-17)
	* [Websockets - An Introduction - subudeepak](https://gist.github.com/subudeepak/9897212)
	* [RFC 6455: The WebSocket Protocol - IETF](https://www.rfc-editor.org/rfc/rfc6455)
		* The WebSocket Protocol enables two-way communication between a client running untrusted code in a controlled environment to a remote host that has opted-in to communications from that code. The security model used for this is the origin-based security model commonly used by web browsers. The protocol consists of an opening handshake followed by basic message framing, layered over TCP. The goal of this technology is to provide a mechanism for browser-based applications that need two-way communication with servers that does not rely on opening multiple HTTP connections (e.g., using XMLHttpRequest or `<iframe>`s and long polling).
	* [How Do Websockets Work? - Kevin Sookocheff(2019)](https://sookocheff.com/post/networking/how-do-websockets-work/)
- **Articles/Papers/Talks/Writeups**
	* [What’s wrong with WebSocket APIs? Unveiling vulnerabilities in WebSocket APIs. - Mikhail Egorov](https://speakerdeck.com/0ang3el/whats-wrong-with-websocket-apis-unveiling-vulnerabilities-in-websocket-apis)
	* [Hacking Web Sockets: All Web Pentest Tools Welcomed - VDALabs(2019)](https://vdalabs.com/2019/03/05/hacking-web-sockets-all-web-pentest-tools-welcomed/)
	* [To Fuzz a WebSocket - Andreas Happe(2019)](https://snikt.net/blog/2019/05/22/to-fuzz-a-websocket/)
	* [Once upon a time there was a WebSocket - Jason Gillam(2020)](https://www.secureideas.com/blog/2020/03/once-upon-a-time-there-was-a-websocket.html)
	* [WebSockets: Attack Techniques and Protection Measures - Michael Schneider(2021)](https://www.scip.ch/en/?labs.20210408)
	* [Everything You Need to Know About Web Socket Pentesting - Saket Taneja(2021)](https://www.appknox.com/blog/everything-you-need-to-know-about-web-socket-pentesting)
	* [HN Discussion on 'Websocket Handbook' (2022)](https://news.ycombinator.com/item?id=29893242)
- **Talks/Presentations/Videos**
	* [Old Tools, New Tricks: Hacking WebSockets - Michael Fowl, Nick Defoe(Derbycon2019)](https://www.irongeek.com/i.php?page=videos/derbycon9/stable-35-old-tools-new-tricks-hacking-websockets-michael-fowl-nick-defoe)
	* [Old Tools, New Tricks: Hacking WebSockets - Michael Fowl, Nick Defoe(2019)](https://www.irongeek.com/i.php?page=videos/derbycon9/stable-35-old-tools-new-tricks-hacking-websockets-michael-fowl-nick-defoe)
		* Many application penetration testers and developers have struggled to figure out how to assess the security of WebSocket applications. When new technologies like WebSockets are developed, often the tooling available for penetration testing takes awhile to catch up. What if you could use traditional web penetration testing tools to assess WebSockets? By leveraging concepts found in native code fuzzing, you can! We have been using a novel approach that allows traditional web security testing tools to find vulnerabilities in WebSocket applications.
- **Tools**
	* [WSSiP: A WebSocket Manipulation Proxy](https://github.com/nccgroup/wssip)
		* Short for "WebSocket/Socket.io Proxy", this tool, written in Node.js, provides a user interface to capture, intercept, send custom messages and view all WebSocket and Socket.IO communications between the client and server.
	* [Websocket Fuzzer](https://github.com/andresriancho/websocket-fuzzer)
		* A simple websocket fuzzer for application penetration testing.;  HTML5 WebSocket message fuzzer
	* [websocket-harness](https://github.com/VDA-Labs/websocket-harness)
		* This python script can be placed between traditional web penetration testing tools and WebSocket connections, which does translation from HTTP to WebSocket and back. Think of it like a fuzzing harness that is used for native code.
	* [cswsh](https://github.com/DeepakPawar95/cswsh)
		* A command-line tool for Cross-Site WebSocket Hijacking
	* [SockJS-client](https://github.com/sockjs/sockjs-client)
		* SockJS is a browser JavaScript library that provides a WebSocket-like object. SockJS gives you a coherent, cross-browser, Javascript API which creates a low latency, full duplex, cross-domain communication channel between the browser and the web server.
	* [uWebSockets](https://github.com/uNetworking/uWebSockets)
		* "Simple, secure & standards compliant web server for the most demanding of applications"
	* [websockets](https://github.com/aaugustin/websockets)
		* "Library for building WebSocket servers and clients in Python"
	* [websocat](https://github.com/vi/websocat)
		* Command-line client for WebSockets, like netcat (or curl) for ws:// with advanced socat-like functions
* **Miscellaneous**


--------------------------------------------------------------------------------------------------------------------------------


### <a name="webstorage"></a>Web Storage 
* **101**
	* [Web storage - Wikipedia](https://en.wikipedia.org/wiki/Web_storage)
	* [Web Storage API - MDN(Mozilla)](https://developer.mozilla.org/en-US/docs/Web/API/Web_Storage_API)
	* [HTML5 - Web Storage - TutorialsPoint](https://www.tutorialspoint.com/html5/html5_web_storage.htm)
* **Articles/Blogposts/Writeups**
	* [Please Stop Using Local Storage - Randall Degges(2018)](https://www.rdegges.com/2018/please-stop-using-local-storage/)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="webusb"></a>WebUSB
* **101**
	* [WebUSB API - Sept2017](https://wicg.github.io/webusb/)
* **Articles/Blogposts/Presentations/Talks/Writeups**
	* [WebUSB - How a website could steal data off your phone](https://labs.mwrinfosecurity.com/blog/webusb/)
		* This blog post looks in to the capabilities of WebUSB to understand how it works, the new attack surface, and privacy issues. We will describe the processes necessary to get access to devices and how permissions are handled in the browser. Then we will discuss some security implications and shows, how a website can use WebUSB to establish an ADB connection and effectively compromise a connected Android phone.


--------------------------------------------------------------------------------------------------------------------------------


## End of Technologies Section


--------------------------------------------------------------------------------------------------------------------------------
























----------------


## <a name="attacks">Attacks & Techniques</a>
- **General Stuff**
	* [Attacking Modern SaaS Companies](https://github.com/cxxr/talks/blob/master/2017/nolacon/Attacking%20Modern%20SaaS%20Companies%20%E2%80%93%20NolaCon.pdf)
		* [Presentation](https://www.youtube.com/watch?v=J0otoKRh1Vk&app=desktop)
* **Securing**<a name="ttsec"></a>
	* See Defense page.
* **Guides & Methodologies**<a name="ttgm"></a>
	- **Documents/Writeups**
		* [OWASP Testing Checklist](https://www.owasp.org/index.php/Testing_Checklist)
		* [WebAppSec Testing Checklist](http://tuppad.com/blog/wp-content/uploads/2012/03/WebApp_Sec_Testing_Checklist.pdf)
		* [OWASP Testing Checklist(OTGv4)](https://github.com/tanprathan/OWASP-Testing-Checklist)
			* OWASP based Web Application Security Testing Checklist is an Excel based checklist which helps you to track the status of completed and pending test cases. This checklist is completely based on OWASP Testing Guide v 4. The OWASP Testing Guide includes a “best practice” penetration testing framework which users can implement in their own organizations and a “low level” penetration testing guide that describes techniques for testing most common web application security issues. Moreover, the checklist also contains OWASP Risk Assessment Calculator and Summary Findings template.
		* [LTR101: Web App Testing - Methods to The Madness - Andy Gill](https://blog.zsec.uk/ltr101-method-to-madness/)
		* [LTR101: Web Application Testing Methodologies - Andy Gill](https://blog.zsec.uk/ltr101-methodologies/)
		* [OWASP Web Application Security Testing Cheat Sheet](https://www.owasp.org/index.php/Web_Application_Security_Testing_Cheat_Sheet)
		* [120 Days of High Frequency Hunting - Kuldeep Pandya(2022](https://kuldeep.io/posts/120-days-of-high-frequency-hunting/)
		* [The-XSS-Rat Security Testing notes](https://github.com/The-XSS-Rat/SecurityTesting)
		* [How To Hack Web Applications in 2022: Part 1 - Luke Stephens(2022)](https://labs.detectify.com/2022/05/16/how-to-hack-web-applications/)
			* [Part 2](https://labs.detectify.com/2022/08/05/how-to-hack-web-applications-in-2022/)
		* [0-Day Hunting (Chaining Bugs/Methodology) - RiotSecurityTeam(2021)](https://blog.riotsecurityteam.com/0day-chains)
		* [Pentesting Web checklist - six2dez](https://pentestbook.six2dez.com/others/web-checklist)
		* [HolyBugx/HolyTips](https://github.com/HolyBugx/HolyTips)
			* "A Collection of Notes, Checklists, Writeups on Bug Bounty Hunting and Web Application Security."
		* [MindMaps](https://github.com/imran-parray/Mind-Maps)
			* Collection of various mindmaps for testing.
		* [Online Casino Roulette – A guideline for penetration testers and security researchers - Jesús Calderón Marín(2020)](https://research.nccgroup.com/2020/09/18/online-casino-roulette-a-guideline-for-penetration-testers-and-security-researchers/)
		* [Common Security Issues in Financially-Oriented Web Applications - Soroush Dalil(2019)](https://www.nccgroup.com/globalassets/our-research/uk/images/common_security_issues_in_financially-orientated_web.pdf.pdf)
		* [From ZERO To HERO In Web Security Research(Defcon29 Workshop)](https://github.com/romanzaikin/From-Zero-to-Hero-in-Web-Security-Research-DefCon-29-Workshop)
			* [Slides](https://raw.githubusercontent.com/romanzaikin/From-Zero-to-Hero-in-Web-Security-Research-DefCon-29-Workshop/main/slides/defcon_workshop.pdf)
		* [KathanP19/HowToHunt](https://github.com/KathanP19/HowToHunt)
			* "Collection of methodology and test case for various web vulnerabilities."
		* [A Konami Code for Vuln Chaining Combos - Curtis Brazzell(2021)](https://curtbraz.medium.com/a-konami-code-for-vuln-chaining-combos-1a29d0a27c2a)
		* [riramar/Web-Attack-Cheat-Sheet](https://github.com/riramar/Web-Attack-Cheat-Sheet)
			* -bunch of tools and associated commands for techniques using said tools.
		* [Golden-Guide-for-Pentesting/Web Application](https://github.com/0xCGonzalo/Golden-Guide-for-Pentesting/tree/master/Web%20Application)
			* This is a Web Security Guide for Pentesting, BugBounty and CTFs.
	- **Talks/Presentations**
		* [The Bug Hunter’s Methodology - Jason Haddix @jhaddix(Defcon Safemode RedTeamVillage 2020)](https://www.youtube.com/watch?v=gIz_yn0Uvb8)
			* The Bug Hunter’s Methodology is an ongoing yearly installment on the newest tools and techniques for bug hunters and red teamers. This version explores both common and lesser-known techniques to find assets for a target. The topics discussed will look at finding a targets main seed domains, subdomains, IP space, and discuss cutting edge tools and automation for each topic. By the end of this session a bug hunter or red team we will be able to discover and multiply their attack surface. We also discuss several vulnerabilities and misconfigurations related to the recon phase of assessment.
		* [Web Application testing approach and cheating to win Jim McMurry Lee Neely Chelle Clements - Derbycon7](https://www.youtube.com/watch?v=Z8ZAv_EN-9M)
		* [Testing stateful web application workflows - András Veres-Szentkirályi(2016)](https://www.youtube.com/watch?v=xiTFKigyncg)
			* [Paper](https://www.sans.org/reading-room/whitepapers/testing/testing-stateful-web-application-workflows-36637)
			* Most web applications used for complex business operations and/or employing advanced GUI frameworks have stateful functionality. Certain workflows, for example, might require completing certain steps before a transaction is committed, or a request sent by a client-side UI element might need several preceding requests that all contribute to the session state. Most automated tools focus on a request and maybe a redirection, thus completely missing the point in these cases, where resending a request gets ignored by the target application. As a result, while these tools are getting better day by day, using them for testing such execution paths are usually out of the question. Since thorough assessment is cumbersome without such tools, there's progress, but we are far from plug-and-play products. This paper focuses on the capabilities of currently available solutions, demonstrating their pros and cons, along with opportunities for improvement.
		* [Breaking and abusing specifications and policies - Frans Rosén(SecurityFest 2018)](https://www.youtube.com/watch?v=_VsFrYAjJ8k&feature=youtu.be)
			* Last year at Secfest, Frans Rosén talked about DNS hijacking using cloud services. This time, he approaches technologies where verification methods actually exists and how to break them. Let’s Encrypt closed down one of their three blessed verification methods due to a bug Frans found in January. Cloud storage containers already patched from being publicly exposed are still often vulnerable to full modification, extraction and deletion by abusing weak policies and application logic. Frans goes through some weak design patterns, policy structures and explains how to bypass them which have netted him over $45,000 in bug bounties.
		* [Attacking Modern Web Technologies - Frans Rosén(NDC Oslo 2018)](https://www.youtube.com/watch?v=vRqcUS4CPFs)
			* In this talk, top ranked white-hat hacker Frans Rosén will focus on methodologies and results of attacking modern web technologies. He will explain how he accessed private Slack tokens by using postMessage and WebSocket-reconnect, and how vulnerable configurations in both AWS and Google Cloud allow attackers to take full control of your assets.
		* [Live Bug Bounty Recon Session w/ @FransRosen 2019](https://www.youtube.com/watch?v=jTanLdLj5dY)
		* [Free Tools For Webapp Hacking - BB King(WWHF Deadwood2020)](https://www.youtube.com/watch?v=jC_HHwS6tCU&list=PLXF21PFPPXTMmtx0XBXqjxSMZSipIMXwX&index=8)
- **Tactics**<a name="ttt"></a>
	- **Writeups of techniques**
		* [Using HTTP Pipelining to hide requests - digi.ninja](https://digi.ninja/blog/pipelining.php)
		* [Advanced web security topics - george georgovassilis(2020)](https://blog.georgovassilis.com/2016/04/16/advanced-web-security-topics/)
		* [Backslash Powered Scanning: Hunting Unknown Vulnerability Classes](http://blog.portswigger.net/2016/11/backslash-powered-scanning-hunting.html)
			* Existing web scanners search for server-side injection vulnerabilities by throwing a canned list of technology-specific payloads at a target and looking for signatures - almost like an anti-virus. In this document, I'll share the conception and development of an alternative approach, capable of finding and confirming both known and unknown classes of injection vulnerabilities. Evolved from classic manual techniques, this approach reaps many of the benefits of manual testing including casual WAF evasion, a tiny network footprint, and flexibility in the face of input filtering.
	- **Asynchronous Vulns**
		* [Hunting asynchronous vulnerabilities - James Kettle(2015)](https://portswigger.net/research/hunting-asynchronous-vulnerabilities)
			* [Slides](https://portswigger.net/kb/papers/huntingasynchronousvulnerabilities.pdf)
	- **AuthN Testing**
		- **Articles/Blogposts/Writeups**
		- **Tools**
			* [AuthCov](https://github.com/authcov/authcov)
				* AuthCov crawls your web application using a Chrome headless browser while logged in as a pre-defined user. It intercepts and logs API requests as well as pages loaded during the crawling phase. In the next phase it logs in under a different user account, the "intruder", and attempts to access each of one of the API requests or pages discovered previously. It repeats this step for each intruder user defined. Finally it generates a detailed report listing the resources discovered and whether or not they are accessible to the intruder users.
	- **Out-of-Band Attacks**
		* [Out of Band Exploitation (OOB) CheatSheet - Ajay, Ashwin(2018)](https://notsosecure.com/oob-exploitation-cheatsheet/)
		* [Out-of-Band (OOB) SQL Injection - Lee Chun How(2019)](https://medium.com/bugbountywriteup/out-of-band-oob-sql-injection-87b7c666548b)
		* [Out-of-band Attacks [EN] - omercitak.com(2019)](https://omercitak.com/out-of-band-attacks-en/)
	- **Using Browser Devtools for testing**
		* [Chrome DevTools - Google](https://developer.chrome.com/docs/devtools/)
		* [I don’t need no proxy - Pentesterlab](https://blog.pentesterlab.com/i-dont-need-no-proxy-1bb540c22008)
			* Sending real-time browsing data directly to fuzzers from Chrome remote debugging
- **General Reconnaissance Techniques**<a name="genrecon"></a>
	- **General Articles/Methodology Writeups**
		* [Just another Recon Guide for Pentesters and Bug Bounty Hunters - @slashcrypto(2020)](https://www.offensity.com/de/blog/just-another-recon-guide-pentesters-and-bug-bounty-hunters/)
		* [Turbo Intruder: Embracing the billion-request attack - James Kettle(2020)](https://portswigger.net/research/turbo-intruder-embracing-the-billion-request-attack)
		* [Bug Bounty Methodology…Just Have a Look.! - Naveenroy(2020)](https://medium.com/@naveenroy008/bug-bounty-methodology-just-have-a-look-b3e7c4b6922)
		* [ReconNotes - bminossi](https://github.com/bminossi/ReconNotes)
		* [The Bug Hunter's Methodology (TBHM)](https://github.com/jhaddix/tbhm)
		* [Simple Recon Methodology - Eslam Aki(2020)](https://infosecwriteups.com/simple-recon-methodology-920f5c5936d4)
		* [zeroc00I/ReconNotes](https://github.com/zeroc00I/ReconNotes)
			* "Just some public notes that can be useful and i want let the world knows."
		* [Ultimate Reconnaissance RoadMap for Bug Bounty Hunters & Pentesters - Ahmad Halabi(2021)](https://ahmdhalabi.medium.com/ultimate-reconnaissance-roadmap-for-bug-bounty-hunters-pentesters-507c9a5374d)
		* [How to achieve enterprise-grade attack-surface monitoring with open source software - hakluke(2021)](https://hakluke.com/open-source-asm-spiderfoot/)
		* [Attack Surface Management. You’re (probably) doing it wrong. - Steve Micallef(2021)](https://medium.com/@micallst/attack-surface-management-youre-probably-doing-it-wrong-608719da1cab)
		* [Attacking the Perimeter - Miguel Martinez(2020)](https://www.tevora.com/threat-blog/attacking-the-perimeter/)
		* [epi052/recon-pipeline](https://github.com/epi052/recon-pipeline)
		* [How to Build an Automated Recon Pipeline with Python and Luigi - Part I (Setup and Scope) - epi052](https://epi052.gitlab.io/notes-to-self/blog/2019-09-01-how-to-build-an-automated-recon-pipeline-with-python-and-luigi/)
		* [Application Enumeration Tips using Aquatone and Burp Suite - Ryan Wendell(2019)](https://www.ryanwendel.com/2019/09/27/application-enumeration-tips-using-aquatone-and-burp-suite/)
		* [The Anti-Recon Recon Club (using ReconFTW) - jhaddix](https://www.jhaddix.com/post/the-anti-recon-recon-club-using-reconftw)
		* [It's the little things - Jon Bottarini(Disobey 2018)](https://www.youtube.com/watch?v=5cIT3JN7R8w&list=PLLvAhAn5sGfhnVt1IhgrqCvBGe6AxwsjQ&index=11)
	- **Tools that didn't fit elsewhere**
		* [webgrep](https://github.com/dhondta/webgrep)
			* This self-contained tool relies on the well-known grep tool for grepping Web pages. It binds nearly every option of the original tool and also provides additional features like deobfuscating Javascript or appyling OCR on images before grepping downloaded resources.
	- **(Almost)Fully Automating Recon**
		- **Articles/Blogposts/Writeups**
		- **Talks/Presentations/Videos**
			* [Mechanizing the Methodology : Automating Discovery, Testing, and Alerting using Recon/Testing Tools and Amazon SES - Daniel Miessler(Defcon Safemode RTV2020)](https://www.youtube.com/watch?v=URBnM6gGODo)
				* There are a million techniques out there for finding new attack surface and finding potential vulnerabilities; the problem is finding the time to run your entire methodology against all your targets. This talk will take you through finding new attack surface, performing multiple types of test against those targets, and sending real-time alerts---all on a continuous basis using automation from a cloud-based Linux host.
				* [Writeup/Review by Clint Gibler(recommend reading)](https://tldrsec.com/blog/mechanizing-the-methodology/)
		- **Tools**
			* [chomp-scan](https://github.com/SolomonSklash/chomp-scan)
				* A scripted pipeline of tools to simplify the bug bounty/penetration test reconnaissance phase, so you can focus on chomping bugs.
	- **Attack Surface Reconaissance**<a name="ttasr"></a>
		- **Articles/Blogposts/Writeups**
			* [Asset Enumeration: Expanding a Target's Attack Surface - Capt. Meelo](https://captmeelo.com/bugbounty/2019/09/02/asset-enumeration.html)
			* [ What's in a Domain Name? - Collin Meadows(SecureWV/Hack3rcon2018)](https://www.irongeek.com/i.php?page=videos/securewv-hack3rcon2018/speaker-16-whats-in-a-domain-name-collin-meadows)
				* The domain name is one of the most prominent assets an organization can have. While customers can discover an organization from many sources - social media, review aggregators, advertisements, etc - the webpage is often the first direct experience a person has with a business and brand. This vital role makes the domain a target for fraud, data leakage, and cyber attack. Implementing domain monitoring and performing risk assessments is important, but only half the battle. In this talk, we will consider amount of intelligence one can gather starting from only a domain name and investigate how this sets an attacker up with an ideal blueprint for malicious action.
			* [Basic Recon Using A Domain Name - Cedric Owens(2020)](https://medium.com/red-teaming-with-a-blue-team-mentality/basic-recon-starting-with-a-domain-name-17b58027c263)
		- **Tools**
			* [AttackSurfaceMapper](https://github.com/superhedgy/AttackSurfaceMapper)
				* Attack Surface Mapper is a reconnaissance tool that uses a mixture of open source intellgence and active techniques to expand the attack surface of your target. You feed in a mixture of one or more domains, subdomains and IP addresses and it uses numerous techniques to find more targets. It enumerates subdomains with bruteforcing and passive lookups, Other IPs of the same network block owner, IPs that have multiple domain names pointing to them and so on. Once the target list is fully expanded it performs passive reconnaissance on them, taking screenshots of websites, generating visual maps, looking up credentials in public breaches, passive port scanning with Shodan and scraping employees from LinkedIn.
			* [intrigue-core](https://github.com/intrigueio/intrigue-core)
				* Intrigue-core is a framework for external attack surface discovery and automated OSINT.
			* [Domain Analyzer](https://github.com/eldraco/domain_analyzer)
				* Domain analyzer is a security analysis tool which automatically discovers and reports information about the given domain. Its main purpose is to analyze domains in an unattended way.
			* [domain-profiler](https://github.com/jpf/domain-profiler)
				* domain-profiler is a tool that uses information from various sources (Whois, DNS, SSL, ASN) to determine what decisions have been made regarding a domain or list of domains.
			* [The Hamburglar](https://github.com/needmorecowbell/Hamburglar)
				* Hamburglar -- collect useful information from urls, directories, and files
			* [AutoRecon](https://github.com/JoshuaMart/AutoRecon)
				* Simple shell script for automated domain recognition with some tools 
				* [AutoRecon for Automated Reconnaissance - Ahmed Elsobky](https://github.com/0xsobky/HackVault/wiki/AutoRecon-for-Automated-Reconnaissance)
			* [Websy](https://github.com/0xrishabh/websy)
				* Keep an eye on your targets with Websy to get quickly notified for any change they push on their Web Server 
			* [BlueEye](https://github.com/BullsEye0/blue_eye)
				* Blue Eye is a python Recon Toolkit script. It shows subdomain resolves to the IP addresses, company email addresses and much more ..!
			* [FinalRecon](https://github.com/thewhiteh4t/FinalRecon)
				* "FinalRecon is an automatic web reconnaissance tool written in python. Goal of FinalRecon is to provide an overview of the target in a short amount of time while maintaining the accuracy of results. Instead of executing several tools one after another it can provide similar results keeping dependencies small and simple."
			* [changedetection.io](https://github.com/dgtlmoon/changedetection.io)
				* "The best and simplest self-hosted free open source website change detection, monitor and notification service."
			* [KENZER - Automated web assets enumeration & scanning](https://github.com/ARPSyndicate/kenzer)
			* [webstor](https://github.com/RossGeerlings/webstor)
				* "A script to quickly enumerate all websites across all of your organization's networks, store their responses, and query for known web technologies, such as those with zero-day vulnerabilities."
			* [cariddi](https://github.com/edoardottt/cariddi)
				* Take a list of domains, crawl urls and scan for endpoints, secrets, api keys, file extensions, tokens and more
			* [Crossfeed](https://github.com/cisagov/crossfeed)
				* Crossfeed is a tool that continuously enumerates and monitors an organization's public-facing attack surface in order to discover assets and flag potential security flaws. By operating in either passive or active scanning modes, Crossfeed collects data from a variety of open source tools and data feeds to provide actionable information about organization assets. Crossfeed is offered as a self-service portal and allows customers to view reports and customize scans performed.
			* [kunyu](https://github.com/knownsec/Kunyu)
				* Kunyu aims to make corporate asset collection more efficient and enable more security-related practitioners to understand and use cyberspace surveying and mapping technology.
		- **Nuclei**
			- **101**
				* [Nuclei](https://github.com/projectdiscovery/nuclei)
					* Nuclei is used to send requests across targets based on a template, leading to zero false positives and providing fast scanning on a large number of hosts. Nuclei offers scanning for a variety of protocols, including TCP, DNS, HTTP, SSL, File, Whois, Websocket, Headless etc. With powerful and flexible templating, Nuclei can be used to model all kinds of security checks.
			- **Articles**
				* [The Ultimate Guide to Finding Bugs With Nuclei - ProjectDiscovery(2022)](https://blog.projectdiscovery.io/ultimate-nuclei-guide/)
				* [Nuclei Templating Guide - ProjectDiscovery](https://nuclei.projectdiscovery.io/templating-guide/)
				* [Nuclei Templates](https://github.com/projectdiscovery/nuclei-templates)
					* Community curated list of templates for the nuclei engine to find security vulnerabilities.
				* [Creating Custom Nuclei Templates and Workflows - JTCSEC(2021)](https://www.youtube.com/watch?v=bHXkQjtBOLo)
					* A walkthrough for how to create a Nuclei template and turn it into a workflow. This is my first piece of content, so and feedback is greatly appreciated! If you have any suggestions for new things to cover, let me know!
				* [How-to-write-your-First-Nuclei-Template.pdf - DhiyaneshGeek](https://github.com/DhiyaneshGeek/My-Presentation-Slides/blob/main/slides/How-to-write-your-First-Nuclei-Template.pdf)
				* [Nuclei Templates Creation – My Experience - AndySvints(2021)](https://www.andysvints.com/nuclei-templates-creation-my-experience/)
			- **Templates**
				* [Virtual-Host](https://github.com/0xAwali/Virtual-Host)
					* Modified Nuclei Templates Version to FUZZ Host Header
	- **Browser Automation**
		* [playwright](https://github.com/microsoft/playwright)
			* Node.js library to automate Chromium, Firefox and WebKit with a single API 
	- **Browser/Client Fingerprinting**(see Also AnonOpSecPrivacy.md)
		- **Articles/Blogposts/Writeups**
			* [Cookieless cookies - lucb1e(2013)](https://lucb1e.com/randomprojects/cookielesscookies/)
		- **Talks/Presentations/Videos**
			* [Passive Fingerprinting of HTTP/2 Clients - Ory Segal, Aharon Fridman, Elad Shuster(2017)](https://www.blackhat.com/docs/eu-17/materials/eu-17-Shuster-Passive-Fingerprinting-Of-HTTP2-Clients-wp.pdf)
			* [Two New Ways To Exploit A Fixed Browser Fingerprinting Flaw - Xiaoyin Liu(BSidesMunic(2019)](https://www.youtube.com/watch?v=FBjlrVD5rOs)
			* [QCSD: A QUIC Client-Side Website-Fingerprinting Defence Framework - Jean-Pierre Smith, Luca Dolfi, Prateek Mittal, Adrian Perrig(2022)](https://www.youtube.com/watch?v=7Qe8ArVWLUs)
				* "We observe that the rapid and wide-spread deployment of QUIC and HTTP/3 creates an exciting opportunity to build website-fingerprinting defences directly into client applications, such as browsers, without requiring any changes to web servers, VPNs, or the deployment of new network services. We therefore design and implement the QCSD framework, which leverages QUIC and HTTP/3 to emulate existing website-fingerprinting defences by bidirectionally adding cover traffic and reshaping connections solely from the client. As case studies, we emulate both the FRONT and Tamaraw defences solely from the client and collected several datasets of live-defended traffic on which we evaluated modern machine-learning based attacks. Our results demonstrate the promise of this approach in shaping connections towards client-orchestrated defences, thereby removing a primary barrier to the deployment of website-fingerprinting defences."
		- **Papers**
			* [JavaScript Template Attacks: Automatically Inferring Host Information for Targeted Exploits - Michael Schwarz, Florian Lackner, Daniel Gruss(2019)](https://www.ndss-symposium.org/wp-content/uploads/2019/02/ndss2019_01B-4_Schwarz_paper.pdf)
		- **Tools**
			* [CSS-Fingerprint](https://github.com/OliverBrotchie/CSS-Fingerprint)
				* An experimental method for CSS based fingerprinting and a pure CSS 'supercookie'.
			* [Sniffer](https://github.com/wilddeer/Sniffer)
				* Sniffer is a browser/engine/os/device detection tool. Works both in a browser and with Node.
			* [FingerprintJS](https://github.com/fingerprintjs/fingerprintjs)
				* FingerprintJS is a browser fingerprinting library that queries browser attributes and computes a hashed visitor identifier from them. Unlike cookies and local storage, a fingerprint stays the same in incognito/private mode and even when browser data is purged. FingerprintJS is 100% open-source, but its accuracy is limited because it's only a client-side library without a backend.
			* [TorZillaPrint](https://github.com/arkenfox/TZP/)
				* TorZillaPrint (TZP) aims to provide a comprehensive, all-in-one, fingerprinting test suite, nicely broken into suitable sections with relevant information together. Long term, the goal is to collect Gecko only fingerprint data (no PII) for analysis to see how many classifications each metric or section provides.
	- **Browser-based Port Scan**
		* [Exposing Intranets with reliable Browser-based Port scanning - Gareth Hayes(2018)](https://portswigger.net/research/exposing-intranets-with-reliable-browser-based-port-scanning)
	- **DNS**
		* See Network_Attacks.md -> DNS
	- **Endpoint Discovery**<a name="tted"></a>
		- **Articles/Blogposts/Writeups**
			* [Improving Internet Wide Scanning with Dynamic Scanning - Alexandre Dulaunoy(2021)](https://github.com/adulau/active-scanning-techniques)
			* [HTTP Route BustingEnumerating Routes Instead of Directories - Dejan Zelic](https://dejandayoff.com/assets/files/HTTP-Route-Busting.pdf)
			* [Offensive Recon - Bug Hunter's Playbook - Harsh Bothra(2020)](https://www.youtube.com/watch?v=UrdvDCb4Gz8)
				* "Harsh Bothra is a security researcher and ranked as Bugcrowd Top 150 Hackers and MVP for 2020 Q1. He delivered this talk on offensive Recon."
			* [Bypassing the Redirect filters with 7 ways - elmahdi(2020)](https://elmahdi.tistory.com/m/4)
		- **Tools**
			* [JSParser](https://github.com/nahamsec/JSParser)
				* A python 2.7 script using Tornado and JSBeautifier to parse relative URLs from JavaScript files. Useful for easily discovering AJAX requests when performing security research or bug bounty hunting.
			* [LinkFinder](https://github.com/GerbenJavado/LinkFinder)
				* LinkFinder is a python script written to discover endpoints and their parameters in JavaScript files. This way penetration testers and bug hunters are able to gather new, hidden endpoints on the websites they are testing. Resulting in new testing ground, possibility containing new vulnerabilities. It does so by using [jsbeautifier](https://github.com/beautify-web/js-beautify) for python in combination with a fairly large regular expression.
			* [relative-url-extractor](https://github.com/jobertabma/relative-url-extractor)
				* During reconnaissance (recon) it is often helpful to get a quick overview of all the relative endpoints in a file. These days web applications have frontend pipelines that make it harder for humans to understand minified code. This tool contains a nifty regular expression to find and extract the relative URLs in such files. This can help surface new targets for security researchers to look at. It can also be used to periodically compare the results of the same file, to see which new endpoints have been deployed. History has shown that this is a goldmine for bug bounty hunters.
			* [hakrawler](https://github.com/hakluke/hakrawler)
				* Simple, fast web crawler designed for easy, quick discovery of endpoints and assets within a web application
				* [Introducing Hakrawler: A Fast Web Crawler for Hackers - Luke Stephens(2020)](https://medium.com/@hakluke/introducing-hakrawler-a-fast-web-crawler-for-hackers-ff799955f134)
			* [endpointdiff](https://github.com/ameenmaali/endpointdiff)
				* endpointdiff is a simple wrapper script around LinkFinder (https://github.com/GerbenJavado/LinkFinder) to quickly identify whether endpoints have changed based on diffs of JS files.
			* [gau](https://github.com/lc/gau)
				* Fetch known URLs from AlienVault's Open Threat Exchange, the Wayback Machine, and Common Crawl.
			* [FFUF Me - Target Practice For FFUF]()https://github.com/adamtlangley/ffufme
				* This is a simple website to get you used to using ffuf against a live target
			* [httpx](https://github.com/projectdiscovery/httpx)
				* "httpx is a fast and multi-purpose HTTP toolkit that allows running multiple probes using the retryablehttp library. It is designed to maintain result reliability with an increased number of threads."
			* [Kiterunner](https://github.com/assetnote/kiterunner)
				* Kiterunner is a tool that is capable of not only performing traditional content discovery at lightning fast speeds, but also bruteforcing routes/endpoints in modern applications.
			* [httploot](https://github.com/redhuntlabs/httploot)
				* [Blogpost](https://redhuntlabs.com/blog/millions-of-secrets-exposed-via-web-application-frontend.html)
				* An automated tool which can simultaneously crawl, fill forms, trigger error/debug pages and "loot" secrets out of the client-facing code of sites.
			* [reconFTW](https://github.com/six2dez/reconftw)
				*  reconFTW is a tool designed to perform automated recon on a target domain by running the best set of tools to perform scanning and finding out vulnerabilities 
			* [redscan](https://github.com/certmichelin/Redscan)
				* Redscan is built to discover exposed assets of a company, detect misconfigurations and compliance deviations.  Redscan was conceived with the idea to automate the recon phase and the vulnerability assertion as referred to the Bug Bounty Methodology.
			* [page-fetch](https://github.com/detectify/page-fetch)
				* Fetch web pages using headless Chrome, storing all fetched resources including JavaScript files. Run arbitrary JavaScript on many web pages and see the returned values
	- **Forced Browsing**<a name="ttfb"></a>
		- **Articles/Blogposts/Writeups**
			* [Turbo Intruder: Embracing the billion-request attack - James Kettle](https://portswigger.net/research/turbo-intruder-embracing-the-billion-request-attack)
		- **Tools**
			* [Dirbuster](https://www.owasp.org/index.php/Category:OWASP_DirBuster_Project)
				* DirBuster is a multi threaded java application designed to brute force directories and files names on web/application servers. Often is the case now of what looks like a web server in a state of default installation is actually not, and has pages and applications hidden within. DirBuster attempts to find these.
			* [Go Buster](https://github.com/OJ/gobuster)
				* Directory/file busting tool written in Go; Recursive, CLI-based, no java runtime
			* [WFuzz](https://code.google.com/p/wfuzz/)
				* Wfuzz is a tool designed for bruteforcing Web Applications, it can be used for finding resources not linked (directories, servlets, scripts, etc), bruteforce GET and POST parameters for checking different kind of injections (SQL, XSS, LDAP,etc), bruteforce Forms parameters (User/Password), Fuzzing,etc
			* [dirsearch](https://github.com/maurosoria/dirsearch)
				* dirsearch is a simple command line tool designed to brute force directories and files in websites.
			* [ffuf](https://github.com/ffuf/ffuf)
				* Fast web fuzzer written in Go
				* [Everything you need to know about FFUF - codingo(2020)](https://codingo.io/tools/ffuf/bounty/2020/09/17/everything-you-need-to-know-about-ffuf.html)
				* [ffuf on Steroids - securityjunky.com](https://securityjunky.com/ffuf-on-steroids/)
			* [Tachyon](https://github.com/delvelabs/tachyon)
				* Tachyon is a Fast Multi-Threaded Web Discovery Tool
			* [Syntribos](https://github.com/openstack/syntribos)
				* Given a simple configuration file and an example HTTP request, syntribos can replace any API URL, URL parameter, HTTP header and request body field with a given set of strings. Syntribos iterates through each position in the request automatically. Syntribos aims to automatically detect common security defects such as SQL injection, LDAP injection, buffer overflow, etc. In addition, syntribos can be used to help identify new security defects by automated fuzzing.
			* [OpenDoor](https://github.com/stanislav-web/OpenDoor)
				* OpenDoor OWASP is console multifunctional web sites scanner. This application find all possible ways to login, index of/ directories, web shells, restricted access points, subdomains, hidden data and large backups. The scanning is performed by the built-in dictionary and external dictionaries as well. Anonymity and speed are provided by means of using proxy servers.
			* [rustbuster](https://github.com/phra/rustbuster)
				* A Comprehensive Web Fuzzer and Content Discovery Tool
			* [feroxbuster](https://github.com/epi052/feroxbuster)
				*  A fast, simple, recursive content discovery tool written in Rust.
			* [SharpBuster](https://github.com/passthehashbrowns/SharpBuster)
				*  SharpBuster is a C# implementation of a directory brute forcing tool. It's designed to be used via Cobalt Strike's execute-assembly and similar tools, when running a similar tool over a SOCKS proxy is not feasible. 
			* [FES - Fast Endpoint Scanner](https://github.com/JohnWoodman/FES)
				* A web application endpoint scanner written in Rust, designed to put less load on the domains it scans with parsing features to help grab the important stuff (inspired by tomnomnom's meg).
			* [WAES](https://github.com/Shiva108/WAES)
				* CPH:SEC WAES: Web Auto Enum & Scanner - Auto enums website(s) and dumps files as result
			* [crithit](https://github.com/codingo/crithit)
				* Website Directory and file brute forcing at extreme scale.
			* [snallygaster](https://github.com/hannob/snallygaster)
				* Finds file leaks and other security problems on HTTP servers.
	- **HTTP Enumeration**<a name="tthe"></a>
		- **Articles/Blogposts/Writeups**
			* [Insecure HTTP Header Removal](https://www.aspectsecurity.com/blog/insecure-http-header-removal)
		- **Tools**
			* [Arjun](https://github.com/s0md3v/Arjun)
				* HTTP parameter discovery suite.
			* [Psi-Probe](https://github.com/psi-probe/psi-probe)
				* Advanced manager and monitor for Apache Tomcat, forked from Lambda Probe
			* [HTTPLeaks](https://github.com/cure53/HTTPLeaks)
				* HTTPLeaks - All possible ways, a website can leak HTTP requests
			* [HTTPie - curl for humans](https://gith*ub.com/jakubroztocil/httpie)
				* HTTPie (pronounced aych-tee-tee-pie) is a command line HTTP client. Its goal is to make CLI interaction with web services as human-friendly as possible. It provides a simple http command that allows for sending arbitrary HTTP requests using a simple and natural syntax, and displays colorized output. HTTPie can be used for testing, debugging, and generally interacting with HTTP servers.
			* [gethead](https://github.com/httphacker/gethead)
				* HTTP Header Analysis Vulnerability Tool 
	- **HTTP Fingerprinting**
		- **Articles/Blogposts/Writeups**
			* [An Introduction to HTTP fingerprinting - Saumil Shah](http://www.net-square.com/httprint_paper.html)
			* [Web Application Finger Printing - Anant Shrivastava](http://anantshri.info/articles/web_app_finger_printing.html)
		- **Tools**
			* [GoFingerprint](https://github.com/Static-Flow/gofingerprint)
				* GoFingerprint is a Go tool for taking a list of target web servers and matching their HTTP responses against a user defined list of fingerprints. 
	- **JS-based scanning**<a name="ttjs"></a>
		- **Articles/Blogposts/Writeups**
			* [Exposing Intranets with reliable Browser-based Port scanning - Gareth Heyes](https://portswigger.net/blog/exposing-intranets-with-reliable-browser-based-port-scanning)
 				* In this blog post I describe how I created a port scanner using JavaScript.
			* [JS-Recon detailed. Analizying the internal network with a XSS - Jorge Lajara (2018)](https://jlajara.gitlab.io/web/2018/10/18/js-recon.html)
			* [Scanning JS Files for Endpoints and Secrets - securityjunky.com](https://securityjunky.com/scanning-js-files-for-endpoint-and-secrets/)
		- **Tools**
			* [lan-js](https://github.com/jvennix-r7/lan-js)
				* Probe LAN devices from a web browser.
			* [sonar.js](https://thehackerblog.com/sonar-a-framework-for-scanning-and-exploiting-internal-hosts-with-a-webpage/)
				* A Framework for Scanning and Exploiting Internal Hosts With a Webpage
	- **(Sub)Domain Reconnaissance**<a name="sdr"></a>
		- **Articles/Blogposts/Writeups**
			* [A penetration tester’s guide to subdomain enumeration - Bharath](https://blog.appsecco.com/a-penetration-testers-guide-to-sub-domain-enumeration-7d842d5570f6)
			* [Subdomain Enumeration: 2019 Workflow - Patrik Hudak](https://0xpatrik.com/subdomain-enumeration-2019/)
			* [The Art of Subdomain Enumeration - Patrick Hudak(2017)]https://blog.sweepatic.com/art-of-subdomain-enumeration/)
			* [A penetration tester’s guide to subdomain enumeration - Bharath(2017)](https://blog.appsecco.com/a-penetration-testers-guide-to-sub-domain-enumeration-7d842d5570f6?gi=03f0c33e0552)
		- **Domain Discovery**
			* [Discovering Domains via a Time-Correlation Attack on Certificate Transparency - Arseniy Sharoglazov(2022)](https://swarm.ptsecurity.com/discovering-domains-via-a-time-correlation-attack/)
			* [DRROBOT](https://github.com/sandialabs/dr_robot)
				* Dr.ROBOT is a tool for Domain Reconnaissance and Enumeration. By utilizing containers to reduce the overhead of dealing with dependencies, inconsistencies across operating systems, and different languages, Dr.ROBOT is built to be highly portable and configurable.
			* [assetfinder](https://github.com/tomnomnom/assetfinder)
				* Find domains and subdomains potentially related to a given domain.
			* [Domains project](https://github.com/tb0hdan/domains)
				* "World’s single largest Internet domains dataset"
			* [ripgen](https://github.com/resyncgg/ripgen/)
				* A rust-based version of the popular dnsgen python utility.
			* [Finddomain](https://github.com/Findomain/Findomain)
				* The fastest and complete solution for domain recognition. Supports screenshoting, port scan, HTTP check, data import from other tools, subdomain monitoring, alerts via Discord, Slack and Telegram, multiple API Keys for sources and much more. 
		- **Subdomain Discovery Tools**
			* [Sudomy](https://github.com/Screetsec/Sudomy)
				* Sudomy is a subdomain enumeration tool, created using a bash script, to analyze domains and collect subdomains in fast and comprehensive way.
			* [domains-from-csp](https://github.com/0xbharath/domains-from-csp)
				* A Python script to parse domain names from CSP header
			* [pdlist. A passive subdomain finder](https://github.com/gnebbia/pdlist)
				* pdlist is a passive subdomain finder written in python3. This tool can be used effectively to collect information about a domain without ever sending a single packet to any of its hosts. Given a domain like "example.com" it will find all the hosts which have a `hostname <something>.example.com` or URLs strictly related to `example.com`.
			* [Find-Domains](https://github.com/iamj0ker/Find-domains)
				* This repo contain scripts written for finding subdomains using various available tools 
			* [sub-differ](https://github.com/smackerdodi/sub-differ)
				* take a list of old subdomain and new subdomain and the output is the deleted subdomain and the new subdomain
			* [OneForAll](https://github.com/shmilylty/OneForAll/)
				* [OneForAll, A Powerful Chinese Subdomain Enumeration Tool - Daehee Park](https://www.daehee.com/oneforall/)
			* [subscraper](https://github.com/m8sec/subscraper)
				* Perform subdomain enumeration through various techniques and retrieve detailed output to aid in further testing.
			* [subfinder](https://github.com/projectdiscovery/subfinder)
				*  Subfinder is a subdomain discovery tool that discovers valid subdomains for websites. Designed as a passive framework to be useful for bug bounties and safe for penetration testing. 
			* [Dome](https://github.com/v4d1/Dome)
				* Fast and reliable python script that makes active and/or passive scan to obtain subdomains and search for open ports.
	- **Javascript**
		- **Articles/Blogposts/Writeups**
			* [m4ll0k/JavascriptRecon.md](https://gist.github.com/m4ll0k/31ce0505270e0a022410a50c8b6311ff)
		- **Tools**
			* [SecretFinder](https://github.com/m4ll0k/SecretFinder)
				* A python script for find sensitive data (apikeys, accesstoken,jwt,..) and search anything on javascript files 
	- **Technology Identification**<a name="tttid"></a>
		- **Articles/Blogposts/Writeups**
		- **Tools**
			- **General**
				* [wappy](https://github.com/blackarrowsec/wappy)
					* A tool to discover technologies in web applications from your terminal. It uses the wap library, that is a python implementation of the great Wappalyzer browser extension. In fact, it uses the rules defined in the file technologies.json of the Wappalyzer repository.
			- **CMS**
				* [CMSExplorer](https://code.google.com/p/cms-explorer/)
					* CMS Explorer is designed to reveal the the specific modules, plugins, components and themes that various CMS driven web sites are running. Additionally, CMS Explorer can be used to aid in security testing. While it performs no direct security checks, the "explore" option can be used to reveal hidden/library files which are not typically accessed by web clients but are nonetheless accessible. This is done by retrieving the module's current source tree and then requesting those file names from the target system. These requests can be sent through a distinct proxy to help "bootstrap" security testing tools like Burp, Paros, Webinspect, etc. 
				* [BlindElephant Web Application Fingerprinter](http://blindelephant.sourceforge.net/)
					* The BlindElephant Web Application Fingerprinter attempts to discover the version of a (known) web application by comparing static files at known locations against precomputed hashes for versions of those files in all all available releases. The technique is fast, low-bandwidth, non-invasive, generic, and highly automatable. 
				* [Fingerprinter](https://github.com/erwanlr/Fingerprinter)
					*  CMS/LMS/Library etc Versions Fingerprinter. This script's goal is to try to find the version of the remote application/third party script etc by using a fingerprinting approach.
				* [WPScan](https://github.com/wpscanteam/wpscan)
					* WPScan is a free, for non-commercial use, black box WordPress security scanner written for security professionals and blog maintainers to test the security of their WordPress websites. 
			- **Proxies**
				* [Web Filter External Enumeration Tool (WebFEET)](https://github.com/nccgroup/WebFEET)
					* WebFEET is a web application for the drive-by enumeration of web security proxies and policies. See associated [white paper](https://www.nccgroup.com/media/481438/whitepaper-ben-web-filt.pdf) (Drive-by enumeration of web filtering solutions)
			- **Web Servers**
				* [httprecon - Advanced Web Server Fingerprinting](https://github.com/scipag/httprecon-win32)
					* The httprecon project is doing some research in the field of web server fingerprinting, also known as http fingerprinting. The goal is the highly accurate identification of given httpd implementations. This is very important within professional vulnerability analysis. Besides the discussion of different approaches and the documentation of gathered results also an implementation for automated analysis is provided. This software shall improve the easyness and efficiency of this kind of enumeration. Traditional approaches as like banner-grabbing, status code enumeration and header ordering analysis are used. However, many other analysis techniques were introduced to increase the possibilities of accurate web server fingerprinting. Some of them were already discussed in the book Die Kunst des Penetration Testing (Chapter 9.3, HTTP-Fingerprinting, pp. 530-550).
				* [WhatWeb](https://github.com/urbanadventurer/WhatWeb)
					* WhatWeb identifies websites. Its goal is to answer the question, "What is that Website?". WhatWeb recognises web technologies including content management systems (CMS), blogging platforms, statistic/analytics packages, JavaScript libraries, web servers, and embedded devices. WhatWeb has over 1500 plugins, each to recognise something different. WhatWeb also identifies version numbers, email addresses, account IDs, web framework modules, SQL errors, and more.
	- **Web Scraping**<a name="scraping"></a>
		- **101**
			* [Web scraping - Wikipedia](https://en.wikipedia.org/wiki/Web_scraping)
		- **Articles/Papers/Talks/Writeups**
			* [So you want to Scrape like the Big Boys? 🚀 - incolumitas.com(2021)](https://incolumitas.com/2021/11/03/so-you-want-to-scrape-like-the-big-boys/)
			* [Harden Vanilla Puppeteer](https://github.com/prescience-data/harden-puppeteer)
				* A conceptual patch which modifies some vanilla puppeteer files to decrease detection rates. 
		- **General**
			* [browser-fingerprinting](https://github.com/niespodd/browser-fingerprinting)
				* "Analysis of Bot Protection systems with available countermeasures 🚿. How to defeat anti-bot system 👻 and get around browser fingerprinting scripts 🕵️‍♂️ when scraping the web?"
		- **Tools**
			* [Puppeteer](https://github.com/GoogleChrome/puppeteer)
				* Puppeteer is a Node library which provides a high-level API to control Chrome or Chromium over the DevTools Protocol. Puppeteer runs headless by default, but can be configured to run full (non-headless) Chrome or Chromium.
			* [dvcs-ripper](https://github.com/kost/dvcs-ripper)
				* Rip web accessible (distributed) version control systems: SVN, GIT, Mercurial/hg, bzr, ... It can rip repositories even when directory browsing is turned off.
			* [Scrapy](https://scrapy.org/)
				* An open source and collaborative framework for extracting the data you need from websites. 
		- **Beautiful Soup**
			* [Beautiful Soup](https://www.crummy.com/software/BeautifulSoup/)
			* [Beautiful Soup (HTML parser) - Wikipedia](https://en.wikipedia.org/wiki/Beautiful_Soup_(HTML_parser))
			* [Beautiful Soup Documentation - crummy.com](https://www.crummy.com/software/BeautifulSoup/bs4/doc/)
			* [Intro to Beautiful Soup - Jeri Wieringa](https://programminghistorian.org/en/lessons/intro-to-beautiful-soup)
		- **Miscellaneous**
			* [WeasyPrint](http://weasyprint.org/)
				* WeasyPrint is a visual rendering engine for HTML and CSS that can export to PDF. It aims to support web standards for printing. WeasyPrint is free software made available under a BSD license.
	- **User Enumeration**<a name="ue"></a>
		- **Articles/Blogposts/Writeups**
			* [Six Methods to Determine Valid User Accounts in Web Applications - Dave](https://whiteoaksecurity.com/blog/2019/2/11/six-methods-to-determine-valid-user-accounts-in-web-applications)
		- **Tools**
			* [WhatsMyName](https://github.com/WebBreacher/WhatsMyName)
				*  This repository has the unified data required to perform user enumeration on various websites. Content is in a JSON file and can easily be used in other projects.
			* [hackability](https://github.com/PortSwigger/hackability)
				* Rendering Engine Hackability Probe performs a variety of tests to discover what the unknown rendering engine supports. To use it simply extract it to your web server and visit the url in the rendering engine you want to test. The more successful probes you get the more likely the target engine is vulnerable to attack.
	- **Virtual Hosts**<a name="ttrvhost"></a>
		- **101**
			* [Virtual Hosting - Wikipedia](https://en.wikipedia.org/wiki/Virtual_hosting)
		- **Tools**
			* [virtual-host-discovery](https://github.com/jobertabma/virtual-host-discovery)
				* This is a basic HTTP scanner that'll enumerate virtual hosts on a given IP address. During recon, this might help expand the target by detecting old or deprecated code. It may also reveal hidden hosts that are statically mapped in the developer's /etc/hosts file.
			* [blacksheepwall](https://github.com/tomsteele/blacksheepwall)
				* blacksheepwall is a hostname reconnaissance tool
			* [VHostScan](https://github.com/codingo/VHostScan)
				* A virtual host scanner that performs reverse lookups, can be used with pivot tools, detect catch-all scenarios, work around wildcards, aliases and dynamic default pages.
	- **Visual Reconnaissance**<a name="ttvr"></a>
		- **Articles/Blogposts/Writeups**
			* [Web Server Screenshots with a Single Command - Carrie Roberts](https://www.blackhillsinfosec.com/web-server-screenshots-single-command/)
			* [Application Enumeration Tips using Aquatone and Burp Suite - Ryan Wendel](https://www.ryanwendel.com/2019/09/27/application-enumeration-tips-using-aquatone-and-burp-suite/)
		- **Tools**
			* [Snapback](https://github.com/fkasler/snapback)
				* Snapback is a HTTP(s) screenshot tool written to take advantage of asynchronous threading in Nodejs. It's like EyeWitness, gowitness, and rawr, etc. but generally faster, and compatible with MacOS, Windows, and Linux.
			* [PowerWebShot](https://github.com/dafthack/PowerWebShot)
				* A PowerShell tool for taking screenshots of multiple web servers quickly.
			* [HTTrack - Website Copier](https://www.httrack.com/)
				* It allows you to download a World Wide Web site from the Internet to a local directory, building recursively all directories, getting HTML, images, and other files from the server to your computer. HTTrack arranges the original site's relative link-structure. Simply open a page of the "mirrored" website in your browser, and you can browse the site from link to link, as if you were viewing it online. HTTrack can also update an existing mirrored site, and resume interrupted downloads. HTTrack is fully configurable, and has an integrated help system. 
			* [Kraken](https://github.com/Sw4mpf0x/Kraken)
				* Kraken is a tool to help make your web interface testing workflow more efficient. This is done by using Django, Apache, and a MySql database to store and organize web interface screenshots and data. This allows you and your team to take notes and track which hosts have been tested simultaniously. Once you are finished, you can view these notes you took and generate reports in the Reports section.
			* [Eyeballer](https://github.com/bishopfox/eyeballer)
				* Eyeballer is meant for large-scope network penetration tests where you need to find "interesting" targets from a huge set of web-based hosts. Go ahead and use your favorite screenshotting tool like normal (EyeWitness or GoWitness) and then run them through Eyeballer to tell you what's likely to contain vulnerabilities, and what isn't.
			* [gowitness](https://github.com/sensepost/gowitness)
				* gowitness is a website screenshot utility written in Golang, that uses Chrome Headless to generate screenshots of web interfaces using the command line. Both Linux and macOS is supported, with Windows support 'partially working'.
			* [webscreenshot](https://github.com/maaaaz/webscreenshot)
				* A simple script to screenshot a list of websites, based on the url-to-image PhantomJS script.
			* [LazyShot](https://github.com/mdhama/lazyshot)
				* The simplest way to take an automated screenshot of given URLs. Easy installation!
			* [RAWR - Rapid Assessment of Web Resources](https://bitbucket.org/al14s/rawr/wiki/Home)
			* [EyeWitness](https://github.com/FortyNorthSecurity/EyeWitness)
				* EyeWitness is designed to take screenshots of websites, provide some server header info, and identify default credentials if possible. 
			* [SharpWitness](https://github.com/rasta-mouse/SharpWitness)
				*  C# implementation of EyeWitness 
			* [webDisco](https://github.com/joeybelans/webDisco)
				* Web discovery tool to capture screenshots from a list of hosts & vhosts.  Requests are made via IP address and vhosts to determine differences. Additionallty checks for common administrative interfaces and web server  misconfigurations.
			* [PowerWebShot](https://github.com/dafthack/PowerWebShot)
				* A PowerShell tool for taking screenshots of multiple web servers quickly.
			* [Kraken](https://github.com/Sw4mpf0x/Kraken)
				* Kraken is a tool to help make your web interface testing workflow more efficient. This is done by using Django, Apache, and a MySql database to store and organize web interface screenshots and data. This allows you and your team to take notes and track which hosts have been tested simultaniously. Once you are finished, you can view these notes you took and generate reports in the Reports section.
			* [electric-scan](https://github.com/moloch--/electric-scan)
				* Electron based screenshot scanner
			* [EyeWitnessTheFitness](https://github.com/knavesec/EyeWitnessTheFitness)
				* Generate one FireProx API to be used for all your EyeWitness targets, making your enumeration both opsec-friendly and convenient.
		- **3rd Party Hosted Tools**
			* [VisualSiteMapper](http://www.visualsitemapper.com)
				* Visual Site Mapper is a free service that can quickly show a map of your site.
		- **Web Page**
			* [HTCAP](https://htcap.org)
				* htcap is a web application scanner able to crawl single page application (SPA) recursively by intercepting ajax calls and DOM changes.
- **Vulnerability Scanner**<a name="ttvs"></a>
	* [Nikto](https://cirt.net/Nikto2)
	* [Spaghetti - Web Application Security Scanner](https://github.com/m4ll0k/Spaghetti)
		* Spaghetti is an Open Source web application scanner, it is designed to find various default and insecure files, configurations, and misconfigurations. Spaghetti is built on python2.7 and can run on any platform which has a Python environment.
	* [skipfish](https://code.google.com/p/skipfish/)
		* Skipfish is an active web application security reconnaissance tool. It prepares an interactive sitemap for the targeted site by carrying out a recursive crawl and dictionary-based probes. The resulting map is then annotated with the output from a number of active (but hopefully non-disruptive) security checks. The final report generated by the tool is meant to serve as a foundation for professional web application security assessments. 
	* [wikto](https://github.com/sensepost/wikto)
		* Wikto is Nikto for Windows - but with a couple of fancy extra features including Fuzzy logic error code checking, a back-end miner, Google assisted directory mining and real time HTTP request/response monitoring. Wikto is coded in C# and requires the .NET framework.
	* [WATOBO](https://github.com/siberas/watobo)
		* WATABO is a security tool for testing web applications. It is intended to enable security professionals to perform efficient (semi-automated) web application security audits.
	* [YASUO](https://github.com/0xsauby/yasuo)
		* Yasuo is a ruby script that scans for vulnerable 3rd-party web applications.
	* [ParrotNG](https://github.com/ikkisoft/ParrotNG)
		* ParrotNG is a tool capable of identifying Adobe Flex applications (SWF) vulnerable to CVE-2011-2461
	* [Arachni Web Scanner](http://www.arachni-scanner.com/)
		* Arachni is an Open Source, feature-full, modular, high-performance Ruby framework aimed towards helping penetration testers and administrators evaluate the security of web applications.  It is smart, it trains itself by monitoring and learning from the web application's behavior during the scan process and is able to perform meta-analysis using a number of factors in order to correctly assess the trustworthiness of results and intelligently identify (or avoid) false-positives.
	* [Pyfiscan](https://github.com/fgeek/pyfiscan)
		* Pyfiscan is free web-application vulnerability and version scanner and can be used to locate out-dated versions of common web-applications in Linux-servers. Example use case is hosting-providers keeping eye on their users installations to keep up with security-updates. Fingerprints are easy to create and modify as user can write those in YAML-syntax. Pyfiscan also contains tool to create email alerts using templates.
	* [jaeles](https://github.com/jaeles-project/jaeles)
		* "powerful, flexible and easily extensible framework written in Go for building your own Web Application Scanner."
		* [Showcase examples of usage](https://jaeles-project.github.io/showcases/)
	* [0d1n](https://github.com/CoolerVoid/0d1n)
		* 0d1n is a tool for automating customized attacks against web applications.
	* [reNgine](https://github.com/yogeshojha/rengine)
		* reNgine is an automated reconnaissance framework meant for gathering information during penetration testing of web applications. reNgine has customizable scan engines, which can be used to scan the websites, endpoints, and gather information. 
	* [Osmodeus](https://github.com/j3ssie/Osmedeus)
		* Fully automated offensive security framework for reconnaissance and vulnerability scanning 
	- **Pocsuite**
		* [pocsuite3](https://github.com/knownsec/pocsuite3)
		* [Let's talk about Nuclei YAML syntax templates and Pocsuite3 compatibility ideas - fenix(2022)](https://paper.seebug.org/2016/)

--------------------------------------------------------------------------------------------------------------------------------


### <a name="abuse"></a>Abuse of Functionality
* [jsgifkeylogger](https://github.com/wopot/jsgifkeylogger)
	* a javascript keylogger included in a gif file This is a PoC


--------------------------------------------------------------------------------------------------------------------------------


### <a name="backfile"></a>Backend File Parsing/Processing Exploitation
- **Images**
- **PDFs**
	- **101**
	- **Articles/Blogposts/Writeups**
		* [Export Injection - Inon Shkedy(2018)](https://inonst.medium.com/export-injection-2eebc4f17117)
		* [Postscript Pat and His Black and White Hat - Steven Seeley(2019)](https://srcincite.io/assets/postscript-pat-and-his-black-and-white-hat.pdf)
		* [ How To Spoof PDF Signatures - Jens Müller, Dominik Noss, Christian Mainka, Vladislav Mladenov, Jörg Schwenk (2019)](https://web-in-security.blogspot.com/2019/02/how-to-spoof-pdf-signatures.html)
		* [PDFex: Major Security Flaws in PDF Encryption - Jens Müller, Dominik Noss, Christian Mainka, Vladislav Mladenov, Jörg Schwenk (2019)](https://web-in-security.blogspot.com/2019/09/pdfex-major-security-flaws-in-pdf.html)
		* [Ghostscript SAFER Sandbox Breakout (CVE-2020-15900) - Tim Goddard(2020)](https://insomniasec.com/blog/ghostscript-cve-2020-15900)
		* [Portable Data exFiltration: XSS for PDFs - Gareth Hayes(2020)](https://portswigger.net/research/portable-data-exfiltration)
		* [Insecure Features in PDFs  - Jens Müller, Dominik Noss, Christian Mainka, Vladislav Mladenov, Jörg Schwenk (2021)](https://web-in-security.blogspot.com/2021/01/insecure-features-in-pdfs.html)
	- **Talks/Presentations/Videos**
		* [HotPics 2021 - Emil Lerner(ZeroNights2021)](https://www.youtube.com/watch?v=BQVoHLfAc8A)
			* [Slides](https://www.slideshare.net/neexemil/hotpics-2021)
			* Emil Lerner considers the current state of the web application attack vector via image conversion. What configurations are still vulnerable, and how to make sure that notifications about potential RCEs are (almost) automatically sent to your Telegram account? As a bonus, there are bug-bounty stories. One is more interesting than another.
	- **Tools**
		* [RCE-0-day-for-GhostScript-9.50](https://github.com/duc-nt/RCE-0-day-for-GhostScript-9.50)
			*  RCE 0-day for GhostScript 9.50 - Payload generator
		* [Ghostinthepdf](https://github.com/neex/ghostinthepdf)
			* This is a small tool that helps to embed a PostScript file into a PDF in a way that GhostScript will run the PostScript code during the PDF processing. The goal of the embedding is to run exploits against GhostScript. The output file is a semi-correct PDF that should bypass most signature checks. Thus, if you have an exploit that bypasses -dSAFER, you can "embed" it into a PDF using this tool and upload the resulting file to the target.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="brute">Brute Force/Fuzzing</a>
- See 'Forced-Browsing'


--------------------------------------------------------------------------------------------------------------------------------


### <a name="cache-based"></a>Cache-based Attacks
- <a name="webcache"></a>**Web Cache Deception Attack**
	- **101**
	- **Articles/Blogposts/Writeups**
		* [Web Cache Deception Attack - Omer Gil(2017)](https://omergil.blogspot.com/2017/02/web-cache-deception-attack.html)
		* [Understanding Our Cache and the Web Cache Deception Attack - Joshua Liebow-Feeser(2017)](https://blog.cloudflare.com/understanding-our-cache-and-the-web-cache-deception-attack/)
		* [On Web Cache Deception Attacks - Benjamin Brown(2017)](https://blogs.akamai.com/2017/03/on-web-cache-deception-attacks.html)
		* [How I Test For Web Cache Vulnerabilities + Tips And Tricks - bxmbn(2022)](https://bxmbn.medium.com/how-i-test-for-web-cache-vulnerabilities-tips-and-tricks-9b138da08ff9)
	- **Papers**
		* [Cached and Confused: Web Cache Deception in the Wild - Seyed Ali Mirheidari, Sajjad Arshad, Kaan Onarlioglu, Bruno Crispo, Engin Kirda, William Robertson(2020)](https://arxiv.org/abs/1912.10190)
			* Web cache deception (WCD) is an attack proposed in 2017, where an attacker tricks a caching proxy into erroneously storing private information transmitted over the Internet and subsequently gains unauthorized access to that cached data. Due to the widespread use of web caches and, in particular, the use of massive networks of caching proxies deployed by content distribution network (CDN) providers as a critical component of the Internet, WCD puts a substantial population of Internet users at risk. We present the first large-scale study that quantifies the prevalence of WCD in 340 high-profile sites among the Alexa Top 5K. Our analysis reveals WCD vulnerabilities that leak private user data as well as secret authentication and authorization tokens that can be leveraged by an attacker to mount damaging web application attacks. Furthermore, we explore WCD in a scientific framework as an instance of the path confusion class of attacks, and demonstrate that variations on the path confusion technique used make it possible to exploit sites that are otherwise not impacted by the original attack. Our findings show that many popular sites remain vulnerable two years after the public disclosure of WCD. Our empirical experiments with popular CDN providers underline the fact that web caches are not plug & play technologies. In order to mitigate WCD, site operators must adopt a holistic view of their web infrastructure and carefully configure cache settings appropriate for their applications. 
	* **Talks/Presentations/Videos**
		* [Web Cache Deception Attack - Omer Gil(BHUSA 2017)](https://www.youtube.com/watch?v=mroq9eHFOIU)
			* [slides](https://www.blackhat.com/docs/us-17/wednesday/us-17-Gil-Web-Cache-Deception-Attack.pdf)
			* Web Cache Deception attack is a new web attack vector that puts various technologies and frameworks at risk. By manipulating behaviors of web servers and caching mechanisms, anonymous attackers can expose sensitive information of authenticated application users, and in certain cases to even take control over their accounts. 
		* [Web Cache Deception attack: A new web attack vector - ](https://www.youtube.com/watch?v=FwFKaXM3QJ0)
		* [Cached and Confused: Web Cache Deception in the Wild - Seyed Ali Mirheidari, Sajjad "JJ" Arshad(h@ckivitycon 2020)](https://www.youtube.com/watch?v=czDfMWBsIKw)
			* Web Cache Deception (WCD) has been introduced in 2017 by Omer Gil, where an intruder lures a caching server to mistakenly store private information publicly and as a result obtains unauthorized access to cached data. In this talk, we will introduce new exploitation techniques based on the semantic disconnect among different framework-independent web technologies (e.g., browsers, CDNs, web servers) which results in different URL path interpretations. We coined the term ‚ÄúPath Confusion‚Äù to represent this disagreement and we will present the effectiveness of this technique on WCD attack. In February 2020, our related research was voted and led to an award as the top web hacking technique of 2019 by PortSwigger.   We explore WCD as an instance of the path confusion class of attacks, and demonstrate that variations on the path confusion technique make it possible to exploit sites that are otherwise not impacted by the original attack. Our findings show that many popular sites remain vulnerable three years after the public disclosure of WCD. To further elucidate the seriousness of path confusion, we will also present the large scale analysis results of WCD attack on high profile sites. We present a semi-automated path confusion crawler which detects hundreds of sites that are still vulnerable to WCD only with specific types of path confusion techniques. We conclude the talk with explaining why path confusion is so complicated to remediate while shedding light on potential areas that researchers and bughunters can apply new attack vectors through different path confusion techniques.
	- **Writeups**
		* [Web cache deception attack - expose token information - Memon Irshad(Hackerone2018)](https://hackerone.com/reports/397508)
		* [Web Cache Deception Attack leads to user info disclosure - Kunal Paney(2019)](https://medium.com/@kunal94/web-cache-deception-attack-leads-to-user-info-disclosure-805318f7bb29)
		* [Web cache deception attack on https://open.vanillaforums.com/messages/all - Ron Reshef(Hackerone2019)](https://hackerone.com/reports/593712)
	- **Tools**
		* [Web Cache Deception Burp Extension](https://github.com/PortSwigger/web-cache-deception-scanner)
			* A Burp extension to test applications for vulnerability to the Web Cache Deception attack.
- <a name="cachepoison"></a> **Web Cache Poisoining Attack**
	- **101**
		* [HTTP Cache Poisoning via Host Header Injection - Carlos Bueno(2007)](https://carlos.bueno.org/2008/06/host-header-injection.html)
		* [Web Cache Poisoning - 0xn3va](https://0xn3va.gitbook.io/cheat-sheets/web-application/web-cache-poisoning)
		* [Web cache poisoning - PortSwigger](https://portswigger.net/web-security/web-cache-poisoning)
		* [Practical Web Cache Poisoning: Redefining 'Unexploitable' - James Kettle(BHUSA2018)](https://www.youtube.com/watch?v=j2RrmNxJZ5c)
			* [Slides](https://i.blackhat.com/us-18/Thu-August-9/us-18-Kettle-Practical-Web-Cache-Poisoning-Redefining-Unexploitable.pdf)
			* Modern web applications are composed from a crude patchwork of caches and content delivery networks. In this session I'll show you how to compromise websites by using esoteric web features to turn their caches into exploit delivery systems, targeting everyone that makes the mistake of visiting their homepage.
	- **Articles/Blogposts/Writeups**
		* [Practical Web Cache Poisoning - James Kettle(2018/20)](https://portswigger.net/research/practical-web-cache-poisoning)
		* [Bypassing Web Cache Poisoning Countermeasures - James Kettle(2018/20)](https://portswigger.net/research/bypassing-web-cache-poisoning-countermeasures)
		* [Responsible denial of service with web cache poisoning - James Kettle(2019)](https://portswigger.net/research/responsible-denial-of-service-with-web-cache-poisoning)
		* [CPDoS: Cache Poisoned Denial of Service](https://cpdos.org/)
		* [Web Cache Entanglement: Novel Pathways to Poisoning - James Kettle(2020)](https://portswigger.net/research/web-cache-entanglement)
		* [Web Cache Poisoning for Beginners(2020)](https://www.youtube.com/watch?v=N6F2vngktrw)	
		* [Cache Poisoning at Scale - Youstin(2021)](https://youst.in/posts/cache-poisoning-at-scale/)
	* **Talks/Presentations/Videos**
	* **Tools**
		* [Param-miner](https://github.com/PortSwigger/param-miner)
			* This extension identifies hidden, unlinked parameters. It's particularly useful for finding web cache poisoning vulnerabilities.

--------------------------------------------------------------------------------------------------------------------------------


### <a name="ci"></a> Attacking Continous Integration Systems
- See section of same name under the 'Privesc/PostEx - General' page.


--------------------------------------------------------------------------------------------------------------------------------


### <a name="csvinjection"></a> CSV Injection
- **101**
	* [[Cell Injection] Attacking the end user through the application - David Stubley(2013)](http://blog.7elements.co.uk/2013/01/cell-injection.html)
	* [Comma Separated Vulnerabilities - James Kettle(2014)](https://web.archive.org/web/20140903012939/https://www.contextis.com/blog/comma-separated-vulnerabilities)
		* This post introduces Formula Injection, a technique for exploiting ‘Export to Spreadsheet’ functionality in web applications to attack users and steal spreadsheet contents. It also details a command injection exploit for Apache OpenOffice and LibreOffice that can be delivered using this technique.
	* [CSV injection: Basic to Exploit!!!! - Akansha Kesharwani(2017)](https://payatu.com/csv-injection-basic-to-exploit/)
- **Articles/Blogposts/Writeups**
	* [From CSV to Meterpreter - XPNSec(2015)](https://xpnsec.tumblr.com/post/133298850231/from-csv-to-meterpreter)
	* [CSV Injection Revisited - Making Things More Dangerous(and fun) - Andy Gill(2016)](https://blog.zsec.uk/csv-dangers-mitigations/)
	* [The Absurdly Underestimated Dangers of CSV Injection - George Mauer(2017)](http://georgemauer.net/2017/10/07/csv-injection.html)
	* [CSV Injection- There's devil in the detail - Sunil Joshi(2017)](https://www.we45.com/blog/2017/02/14/csv-injection-theres-devil-in-the-detail)
	* [Microsoft Excel CSV code execution/injection method - xor %eax,%eax(2017)](https://xorl.wordpress.com/2017/12/11/microsoft-excel-csv-code-execution-injection-method/)
	* [From CSV to CMD to qwerty - exploresecurity(2019)](http://www.exploresecurity.com/from-csv-to-cmd-to-qwerty/)
	* [Data Extraction to Command Execution CSV Injection - Jamie Rougvie(2019)](https://www.veracode.com/blog/secure-development/data-extraction-command-execution-csv-injection)
	* [CSV Injection Payload List - Ismail Tasdelen(2020)](https://ismailtasdelen.medium.com/csv-injection-payload-list-e8e1deca6da5)
	* [Everything about the CSV Excel Macro Injection - Ishaq Mohammed(2021)](http://blog.securelayer7.net/how-to-perform-csv-excel-macro-injection/)
- **Talks & Presentations**
	* [Tricks to improve web app excel export attacks(Slides) - Jerome Smith - CamSec2016]()
		* [Video](https://www.youtube.com/watch?v=3wNvxRCJLQQ)
		* This presentation is an embellished version of the second half of a talk originally presented at BSides MCR 2016. It covers more general web app export issues as well as revisions on the DDE content following feedback from BSides. This talk also had more demos.
- **Tools**


--------------------------------------------------------------------------------------------------------------------------------


### <a name="click"></a>Clickjacking
- **101**
	* [Clickjacking - Wikipedia](https://en.wikipedia.org/wiki/Clickjacking)
		*  Clickjacking (classified as a User Interface redress attack, UI redress attack, UI redressing) is a malicious technique of tricking a user into clicking on something different from what the user perceives, thus potentially revealing confidential information or allowing others to take control of their computer while clicking on seemingly innocuous objects, including web pages.
	* [Clickjacking Defense Cheat Sheet - OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Clickjacking_Defense_Cheat_Sheet.html)
		* This cheat sheet is intended to provide guidance for developers on how to defend against Clickjacking, also known as UI redress attacks.
	* [X-Frame-Options - MDN Web Docs](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options)
	* [Clickjacking (UI redressing) - PortSwigger](https://portswigger.net/web-security/clickjacking)
- **Articles/Blogposts/Writeups**
	* [Clickjacking DOM XSS on Google.org - Thomas Orlita](https://appio.dev/vulns/clickjacking-xss-on-google-org/)
	* [The clickjacking attack - javascript.info(2019)](https://javascript.info/clickjacking)
	* [Clickjacking Protection¶ - Django](https://docs.djangoproject.com/en/3.1/ref/clickjacking/)
- **Presentations/Talks/Videos**
	* [Clickjacking Attacks and How to Prevent Them - Andrea Chiarelli(2020)](https://auth0.com/blog/preventing-clickjacking-attacks/)
	* [A Tale of Two Headers: A Formal Analysis of Inconsistent Click-Jacking Protection on the Web - Stefano Calzavara, Sebastian Roth, Alvise Rabitti, Venezia; Michael Backes, Ben Stock(2020)](https://www.youtube.com/watch?v=KPXA6mairR0)
		* Click-jacking protection on the modern Web is commonly enforced via client-side security mechanisms for framing control, like the X-Frame-Options header (XFO) and Content Security Policy (CSP). Though these client-side security mechanisms are certainly useful and successful, delegating protection to web browsers opens room for inconsistencies in the security guarantees offered to users of different browsers. In particular, inconsistencies might arise due to the lack of support for CSP and the different implementations of the underspecified XFO header. In this paper, we formally study the problem of inconsistencies in framing control policies across different browsers and we implement an automated policy analyzer based on our theory, which we use to assess the state of click-jacking protection on the Web. Our analysis shows that 10% of the (distinct) framing control policies in the wild are inconsistent and most often do not provide any level of protection to at least one browser. We thus propose recommendations for web developers and browser vendors to mitigate this issue. Finally, we design and implement a server-side proxy to retrofit security in web applications.
- **Papers**
	* [Busting Frame Busting: A Study of Clickjacking Vulnerabilities on Popular Sites - Gustav Rydstedt, Elie Bursztein, Dan Boneh, Collin Jackson](https://seclab.stanford.edu/websec/framebusting/framebust.pdf)
- **Tools**


--------------------------------------------------------------------------------------------------------------------------------


### <a name="cpr"></a> Cross Protocol Scripting/Request Attack
- **101**
- **Articles/Blogposts/Writeups**
	* [How to steal any developer's local database - bouk.co](https://web.archive.org/web/20170119060232/https://bouk.co/blog/hacking-developers/)
- **Papers**
	* [HTML Form Protocol Attack - Jochen Topf(2001)](https://web.archive.org/web/20170810193321/https://www.jochentopf.com/hfpa/hfpa.pdf)
		* This paper describes how some HTML browsers can be tricked through the use of HTML forms into sending more or less arbitrary data to any TCP port. This can be used to send commands to servers using ASCII based protocols like SMTP, NNTP, POP3, IMAP, IRC, and others. By sending HTML email to unsuspecting users or using a trojan HTML page, an attacker might be able to send mail or post Usenet News through servers normally not accessible to him. In special cases an attacker might be able to do other harm, e.g. deleting mail from a POP3 mailbox.
	* [Cross-Protocol Request Forgery - Tanner Prynn(2018)](https://www.nccgroup.com/us/our-research/cross-protocol-request-forgery/)
		* Server-Side Request Forgery (SSRF) and Cross-Site Request Forgery (CSRF) are two attackmethods that enable attackers to cross network boundaries in order to attack applications,but can only target applications that speak HTTP. Custom TCP protocols are everywhere:IoT devices, smartphones, databases, development software, internal web applications, andmore. Often, these applications assume that no security is necessary because they are onlyaccessible over the local network. This paper aims to be a definitive overview of attacksthat allow cross-protocol exploitation of non-HTTP listeners using CSRF and SSRF, and alsoexpands on the state of the art in these types of attacks to target length-specified protocolsthat were not previously thought to be exploitable.
- **Presentations/Talks/Videos**
- **Tools**
	* [Extract data](https://github.com/bouk/extractdata)
		* Extract data is a demo combining a cross-protocol request attack with DNS rebinding


--------------------------------------------------------------------------------------------------------------------------------


### <a name="xsch"></a> Cross Site Content Hijacking
- **101**
	* [Cross domain data hijacking - acunetix.com](https://www.acunetix.com/vulnerabilities/web/cross-domain-data-hijacking/)
	* [Cross Domain Hijack – Flash File Upload Vulnerability - Dunn3S3C](https://web.archive.org/web/20150912225356/dunnesec.com/2014/05/26/cross-domain-hijack-flash-file-upload-vulnerability//)
- **Articles/Blogposts/Writeups**
	* [Content-Type Blues - Neil Bergman](https://d3adend.org/blog/posts/content-type-blues/)
	* [Exploiting CVE-2011-2461 on google.com - Mauro Gentile](https://blog.mindedsecurity.com/2015/03/exploiting-cve-2011-2461-on-googlecom.html)
	* [Cross-Site Content (Data) Hijacking (XSCH) PoC Project](https://github.com/nccgroup/CrossSiteContentHijacking/)
	* [Even uploading a JPG file can lead to Cross-Site Content Hijacking (client-side attack)! - Soroush Dalili](https://soroush.secproject.com/blog/2014/05/even-uploading-a-jpg-file-can-lead-to-cross-domain-data-hijacking-client-side-attack/)
	* [Same Origin Policy Weaknesses - Kuza55](https://www.slideshare.net/kuza55/same-origin-policy-weaknesses-1728474)
	* [The lesser known pitfalls of allowing file uploads on your website - Mathias Karlsson, Frans Rosén](https://labs.detectify.com/2014/05/20/the-lesser-known-pitfalls-of-allowing-file-uploads-on-your-website/)
- **Papers**
- **Presentations/Talks/Videos**
- **Tools**

--------------------------------------------------------------------------------------------------------------------------------


### <a name="xshm"></a> Cross Site History Manipulation
- **101**
	* [Cross Site History Manipulation (XSHM) - OWASP](https://owasp.org/www-community/attacks/Cross_Site_History_Manipulation_(XSHM))
	* [Cross Site History Manipulation resolution - StackOverflow](https://stackoverflow.com/questions/27782805/cross-site-history-manipulation-resolution)
- **Articles/Blogposts/Writeups**
- **Papers**
	* [Cross-Site History Manipulation: XSHM - Alex Roichman(2010)](https://www.checkmarx.com/wp-content/uploads/2012/07/XSHM-Cross-site-history-manipulation.pdf)
- **Presentations/Talks/Videos**
- **Tools**
	* [XSHM-Payload-Generator](https://github.com/xamfp/XSHM-Payload-Generator)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="csrf"></a>Cross Site Request Forgery (CSRF)
- **101**
	* [Cross-site request forgery - Wikipedia](https://en.wikipedia.org/wiki/Cross-site_request_forgery)
	* [Cross Site Request Forgery - OWASP](https://www.owasp.org/index.php/Cross-Site_Request_Forgery_%28CSRF%29)
	* [CSRF - PortSwigger](https://portswigger.net/web-security/csrf)
	* [The Cross-Site Request Forgery (CSRF/XSRF) FAQ  - Robert Auger(2010)](https://www.cgisecurity.com/csrf-faq.html#)
- **Articles/Blogposts**
	* [ClientSideTrojan - zope.org(2000)](https://web.archive.org/web/20201019030224/http://old.zope.org/Members/jim/ZopeSecurity/ClientSideTrojan/)
	* Cross-Site Request Forgeries - Peter Watkins(Bugtraq 2002)](https://web.archive.org/web/20020204142607/http://www.tux.org/~peterw/csrf.txt)
	* [Cross-Site Request Forgery (CSRF) Prevention Cheat Sheet](https://www.owasp.org/index.php/Cross-Site_Request_Forgery_(CSRF)\_Prevention_Cheat_Sheet)
	* [The OWASP Top Ten and ESAPI – Part 5 – Cross Site Request Forgery (CSRF)](http://www.jtmelton.com/2010/05/16/the-owasp-top-ten-and-esapi-part-6-cross-site-request-forgery-csrf/)
	* [Testing for CSRF (OTG-SESS-005) - OWASP](https://www.owasp.org/index.php/Testing_for_CSRF_(OTG-SESS-005)\)
	* [JavaScript Hijacking - Brian Chess, Yekaterina Tsipenyuk O'Neil, Jacob West(2007)](https://img2.helpnetsecurity.com/dl/articles/JavaScript_Hijacking.pdf)
	* [](https://www.trustedsec.com/blog/setting-the-referer-header-using-javascript/)
	* [A most Neglected Fact About CSRF - pdf](http://yehg.net/lab/pr0js/view.php/A_Most-Neglected_Fact_About_CSRF.pdf)
	* [Bypassing CSRF Protection - Vickie Li](https://medium.com/swlh/bypassing-csrf-protection-c9b217175ee)
	* [Samesite by Default and What It Means for Bug Bounty Hunters - Filedescriptor, Ron Chan & Edoverflow(2020)](https://blog.reconless.com//samesite-by-default/)
	* [Cross Site Request Forgery: Techniques - OneHackMan(2019)](https://medium.com/@onehackman/cross-site-request-forgery-techniques-19270174ea4)
	* [CSRF is dead - Scott Helme(2017)](https://scotthelme.co.uk/csrf-is-dead/)
	* [CSRF is (really) dead - Scott Helme(2019)](https://scotthelme.co.uk/csrf-is-really-dead/)
	* [Kicking Down the Cross Domain Door Techniques for Cross Domain Exploitation - Billy K Rios, Raghav Dube(BHEU 2007)](https://www.blackhat.com/presentations/bh-europe-07/Dube-Rios/Whitepaper/bh-eu-07-rios-WP.pdf)
	* [JSON CSRF with Parameter Padding - Gursev Kalra](http://blog.opensecurityresearch.com/2012/02/json-csrf-with-parameter-padding.html)
	* [Cross-Site Request Forgery (CSRF) | Complete Guide - Rana Khalil(2021)](https://www.youtube.com/watch?v=7bTNMSqCMI0)
		* In this video, we cover the theory behind Cross-Site Request Forgery (CSRF) vulnerabilities, how to find these types of vulnerabilities from both a white box and black box perspective, how to exploit them and how to prevent them.
	* [CSRF in YouTube Leanback API - xdavidhu(2021)](https://feed.bugs.xdavidhu.me/bugs/0001)
	* [The State of CSRF Vulnerability in 2022 - Utku Sen(2022)](https://utkusen.medium.com/the-state-of-csrf-vulnerability-in-2022-3858e6d90ab9)
	* [XSRFProbe](https://github.com/0xInfection/XSRFProbe)
		* The Prime Cross Site Request Forgery (CSRF) Audit and Exploitation Toolkit.
- **Writeups**
	* [WordPress 5.1 CSRF to Remote Code Execution - Simon Scannell(2019)](https://blog.ripstech.com/2019/wordpress-csrf-to-rce/)
	* [CSRF to RCE bug chain in Prestashop v1.7.6.4 and below - Sivanesh Ashok(2020)](https://stazot.com/prestashop-csrf-to-rce-article/)
	* [CSRF Protection Bypass in Play Framework - Luca Carrettoni(2020)](https://blog.doyensec.com/2020/08/20/playframework-csrf-bypass.html)
	* [Research: The mass CSRFing of *.google.com/* products. - missoumsai.com](http://www.missoumsai.com/google-csrfs.html)
	* [Zoom Security Exploit – Cracking private meeting passwords - Tom Anthony(2020)](https://www.tomanthony.co.uk/blog/zoom-security-exploit-crack-private-meeting-passwords/)
	* [Setting the ‘Referer’ Header Using JavaScript - Drew Kirkpatrick(2020)](https://www.trustedsec.com/blog/setting-the-referer-header-using-javascript/)
	* [How I leveraged an interesting CSRF vulnerability to turn self XSS into a persistent attack? - Akash Methani(2020)](https://medium.com/bugbountywriteup/how-i-leveraged-an-interesting-csrf-vulnerability-to-turn-self-xss-into-a-persistent-attack-b780824042d2)
	* [Exploiting WebSocket [Application Wide XSS / CSRF] - Osama Avvan](https://medium.com/@osamaavvan/exploiting-websocket-application-wide-xss-csrf-66e9e2ac8dfa)
	* [CSRF is No Joke: From CSRF to RCE in Cisco Energy Management - Chris Lyne](https://medium.com/tenable-techblog/csrf-is-no-joke-e6f00594b21e)
	* [From Csrf To Rce - fgsec.net(2020)](https://fgsec.net/2020/04/20/From-CSRF-to-RCE.html)
	* [From CSRF to RCE and WordPress-site takeover: CVE-2020-8417 - Jonas Lejon](https://blog.wpsec.com/csrf-to-rce-wordpress/)
	* [WordPress 5.1 CSRF + XSS + RCE – Poc  - Pablo Plaza Martinez](https://ironhackers.es/en/tutoriales/wordpress-5-1-csrf-xss-rce-poc/)
	* [Bolt CMS <= 3.7.0 Multiple Vulnerabilities - CSRF to RCE - Sivanesh Ashok](https://seclists.org/fulldisclosure/2020/Jul/4)
	* [Playing with GZIP: RCE in GLPI (CVE-2020-11060) - @myst404](https://offsec.almond.consulting/playing-with-gzip-rce-in-glpi.html)
- **Papers**
	* [Session Riding: A Widespread Vulnerability in Today's Web Applications - Thomas Schreiber(2004)(https://crypto.stanford.edu/cs155old/cs155-spring08/papers/Session_Riding.pdf)
	* [Robust Defenses for Cross-Site Request Forgery](http://theory.stanford.edu/people/jcm/papers/ccs2008-barth.pdf)
	* [RequestRodeo: Client Side Protection against Session Riding - Martin Johns and Justus Winter - pdf](https://www.owasp.org/images/4/42/RequestRodeo-MartinJohns.pdf)
- **Presentations/Talks/Videos**
- **Tools**
	* [OWASP CSRFGuard](https://www.owasp.org/index.php/Category:OWASP_CSRFGuard_Project)
	* [OWASP CSRFTester](https://www.owasp.org/index.php/Category:OWASP_CSRFTester_Project)
	* [](https://code.google.com/archive/p/pinata-csrf-tool/)
- **Onsite-Request-Forgery**
	* [On-Site Request Forgery - PortSwigger](http://blog.portswigger.net/2007/05/on-site-request-forgery.html)
	* [On-site Request Forgery - cm2.pw](https://blog.cm2.pw/on-site-request-forgery/)


--------------------------------------------------------------------------------------------------------------------------------


### <a name="cssi"></a>Cascading-StyleSheets-related Attacks
- **101**
	* [CSS - Wikipedia](https://en.wikipedia.org/wiki/CSS)
	* [Securing Cascading Style Sheets Cheat Sheet - OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Securing_Cascading_Style_Sheets_Cheat_Sheet.html)
- **General**
	- **Articles/Blogposts/Writeups**
		* [I know where you've been - Jeremiah Grossman(2006)](https://blog.jeremiahgrossman.com/2006/08/i-know-where-youve-been.html)
		* [CSS based Attack: Abusing unicode-range of @font-face - Masato Kinugawa(2015)](https://mksben.l0.cm/2015/10/css-based-attack-abusing-unicode-range.html)
		* [CSS: Cascading Style Scripting - XSS Jigsaw(2015)](https://blog.innerht.ml/cascading-style-scripting/)
		* [History theft with CSS Boolean algebra - lcamtuf](https://lcamtuf.coredump.cx/css_calc/)
		* [CSS mix-blend-mode is bad for your browsing history - lcamtuf(2016)](https://lcamtuf.blogspot.com/2016/08/css-mix-blend-mode-is-bad-for-keeping.html)
		* [Stealing Data With CSS: Attack and Defense - Mike Gualtieri(2018)](https://www.mike-gualtieri.com/posts/stealing-data-with-css-attack-and-defense)
		* [Third party CSS is not safe - Jake Archibald(2018)](https://jakearchibald.com/2018/third-party-css-is-not-safe/)
		* [CSS Security Vulnerabilities - Chris Coyier(2019)](https://css-tricks.com/css-security-vulnerabilities/)
		* [Cross-Origin CSS Attacks Revisited (feat. UTF-16) - @filedescriptor](https://blog.innerht.ml/cross-origin-css-attacks-revisited-feat-utf-16/)
	- **Talks/Presentations/Videos**
		* [The Sexy Assassin: Tactical Exploitation Using CSS - G. Heyes, D. Lindsay, and E.V. Nava(BlueHat 2009)](http://slideplayer.com/slide/3493669/)
		* [XSS. (No, the _other_ "S") - Mike West(CSSconf.eu 2013)](https://youtu.be/eb3suf4REyI?t=582)
		* [Attacking Rich Internet Applications - Stefano Di Paola, kuza55(25c3 2010)](https://www.youtube.com/watch?v=RNt_e0WR1sc)
			* This presentation will examine the largely underresearched topic of rich internet applications (RIAs) security in the hopes of illustrating how the complex interactions with their executing environment, and general bad security practices, can lead to exploitable applications. In recent years rich internet applications (RIAs) have become the mainstay of large internet applications and are becoming increasingly attractive to the industry due to their similarity to desktop applications. Furthermore their user of exsting web technologies such as HTTP, HTML/XML and Javascript/Actionscript make them attractive options to companies with existing web developers. Unfortunately the use of existing technologies brings with it the burden of existing ways to write vulnerable code, but adds yet more ways. This presentation will examine the largely underresearched topic of RIA security in the hopes of illustrating how the complex interactions with their executing environment, and general bad security practices, can lead to exploitable applications.
		* [The Curse of Cross-Origin Stylesheets - LiveOverflow(2018)](https://www.youtube.com/watch?v=bMPAXsgWNAc)
		* [The Sexy Assassin Tactical Exploitation using CSS. - Gerardo Speaks](https://slideplayer.com/slide/3493669/)
	- **Papers**
		* [Scriptless Attacks - Stealing the Pie Without Touching the Sill - Mario Heiderich, Marcus Niemietz, Felix Schuster, Thorsten Holz, Jörg Schwenk(2012)](https://www.nds.ruhr-uni-bochum.de/media/emma/veroeffentlichungen/2012/08/16/scriptlessAttacks-ccs2012.pdf)
			* In this paper, we examine the attack surface that remainsafter XSS and similar scripting attacks are supposedly mit-igated by preventing an attacker from executing JavaScriptcode. We address the question of whether an attacker reallyneeds JavaScript or similar functionality to perform attacksaiming for information theft. The surprising result is thatan attacker can also abuse Cascading Style Sheets (CSS) incombination with other Web techniques like plain HTML,inactive SVG images or font files.  Through several casestudies, we introduce the so calledscriptless attacksanddemonstrate that an adversary might not need to executecode to preserve his ability to extract sensitive informationfrom well protected websites. More precisely, we show thatan attacker can use seemingly benign features to build sidechannel attacks that measure and exfiltrate almost arbitrarydata displayed on a given website.We conclude this paper with a discussion of potential mit-igation techniques against this class of attacks. In addition,we have implemented a browser patch that enables a websiteto make a vital determination as to being loaded in a de-tached view or pop-up window. This approach proves usefulfor prevention of certain types of attacks we here discuss.
	- **Tools**
		* http://eaea.sirdarckcat.net/cssar/v2/
		* [CTF insomnihack'18 - Cool Storage Service web challenge](https://gist.github.com/cgvwzq/f7c55222fbde44fc686b17f745d0e1aa)
- **CSS Injection**
	- **101**
		* [CSS injection (stored) - PortSwigger](https://portswigger.net/kb/issues/00501301_css-injection-stored)
		* [CSS injection (reflected) - PortSwigger](https://portswigger.net/kb/issues/00501300_css-injection-reflected)
	- **Articles/Blogposts/Writeups**
		* [Stealing Secrets with CSS : Cross Origin CSS Attacks - Keith Makan(2016)](http://blog.k3170makan.com/2016/02/stealing-secrets-with-css-cross-origin.html)
		* [Better Exfiltration via HTML Injection - d0nut(2019)](https://d0nut.medium.com/better-exfiltration-via-html-injection-31c72a2dae8b)
		* [CSS Injection Primitives - x-c3ll](https://x-c3ll.github.io//posts/CSS-Injection-Primitives/)
		* [CSS data exfiltration in Firefox via a single injection point - Michal Bentkowski(2020)](https://research.securitum.com/css-data-exfiltration-in-firefox-via-single-injection-point/)
		* [Unleashing the power of CSS injection: The access key to an internal API(2023)](https://sanderwind.medium.com/unleashing-the-power-of-css-injection-the-access-key-to-an-internal-api-789b166d0527)
			* "In this write-up, we will be explaining a vulnerability that was discovered in an online accounting application. The vulnerability was a CSS injection flaw that could be exploited in the application’s PDF generator. We will explain to you how we discovered the vulnerability and how we were able to exploit it to get internal API access."
		* [Cross-origin pixel stealing: Timing attacks using CSS filters - Robert Kotcher, Yutong Pei, Pranjal Jumde, Collin Jackson](https://www.researchgate.net/publication/262292364_Cross-origin_pixel_stealing_Timing_attacks_using_CSS_filters)
	- **Presentations/Talks/Videos**
		* [CSS Injection Attacks or how to leak content with `<style>` - Pepe Vila(2019)](https://vwzq.net/slides/2019-s3_css_injection_attacks.pdf)
	- **Tools**
		* [sic](https://github.com/d0nutptr/sic)
			* A tool to perform Sequential Import Chaining


--------------------------------------------------------------------------------------------------------------------------------


### <a name="cswsh"></a>Cross Site WebSocket Hijacking
- **101**
	* [Cross-Site WebSocket Hijacking (CSWSH) - Christian Schneider(2019)](https://www.christian-schneider.net/CrossSiteWebSocketHijacking.html)
	* [Cross-site WebSocket hijacking - PortSwigger](https://portswigger.net/web-security/websockets/cross-site-websocket-hijacking)
	* [Testing WebSockets - OWASP WSTG v4.1](https://owasp.org/www-project-web-security-testing-guide/v41/4-Web_Application_Security_Testing/11-Client_Side_Testing/10-Testing_WebSockets)
- **Articles/Blogposts/Presentations/Talks/Videos**
	* [Security Testing HTML5 WebSockets - ethicalhack3r(2013)](https://web.archive.org/web/20140626111641/http://www.ethicalhack3r.co.uk/security-testing-html5-websockets/)
	* [How Cross-Site WebSocket Hijacking could lead to full Session Compromise - notsosecure.com(2014)](https://www.notsosecure.com/how-cross-site-websocket-hijacking-could-lead-to-full-session-compromise/)
	* [Analysing, Testing and Fuzzing WebSocket Implementations with IronWASP  - ironwasp.org(2014)](http://blog.ironwasp.org/2014/11/analysing-testing-and-fuzzing-websocket.html)
	* [Cross-Site Websocket Hijacking (CSWSH) - Jesse Somerville(2019)](https://www.praetorian.com/blog/cross-site-websocket-hijacking-cswsh?edition=2019)
	* [Hacking WebSocket With Cross-Site WebSocket Hijacking attacks - Vickie Li(2019)](https://medium.com/swlh/hacking-websocket-25d3cba6a4b9)
	* [Cross-site WebSocket hijacking (CSWSH) - HackTricks](https://book.hacktricks.xyz/pentesting-web/cross-site-websocket-hijacking-cswsh)
- **Talks/Presentations/Videos**
- **Papers**
	* [Research and Defense of Cross-Site WebSocket Hijacking Vulnerability - Wenbo Mei, Zhaohua Long(2020)](https://ieeexplore.ieee.org/document/9182458)
- **Tools**
	* [Cross-Site WebSocket Hijacking Tester](https://cow.cat/cswsh.html)


----------------------------------------------------------------------------------------------------------------


### <a name="dsa">Data Structure Attacks</a>
* --> See XML section
* --> See 'CSV Injection' Attack
* [Comma Separated Vulnerabilities](https://www.contextis.com/blog/comma-separated-vulnerabilities)


----------------------------------------------------------------------------------------------------------------


### <a name="esii">Edge Side Include Injection</a>
* **101**
	* [Edge Side Includes - Wikipedia](https://en.wikipedia.org/wiki/Edge_Side_Includes)
* **Articles/Blogposts/Writeups**
	* [Beyond XSS: Edge Side Include Injection - Louis Dion-Marcil(2018)](https://www.gosecure.net/blog/2018/04/03/beyond-xss-edge-side-include-injection/)
	* [ESI Injection Part 2: Abusing specific implementations - Philippe Arteau(2019)](https://www.gosecure.net/blog/2019/05/02/esi-injection-part-2-abusing-specific-implementations/)
	* [Edge Side Includes abused to enable RCE - Catherine Chapman(2019)](https://portswigger.net/daily-swig/edge-side-includes-abused-to-enable-rce)
* **Talks/Presentations/Videos**
	* [Cache Me If You Can - Philippe Arteau](https://gosecure.github.io/presentations/2019-02-26-confoo_mtl/Cache_Me_If_You_Can.pdf)
	* [Edge Side Include Injection: Abusing Caching Servers into SSRF and Transparent Session Hijacking - Louis Dion-Marcil(BHUSA2018)](https://www.youtube.com/watch?v=6t50uRAxFT8)
		* [Slides](https://i.blackhat.com/us-18/Wed-August-8/us-18-Dion_Marcil-Edge-Side-Include-Injection-Abusing-Caching-Servers-into-SSRF-and-Transparent-Session-Hijacking.pdf)
		* When caching servers and load balancers became an integral part of the Internet's infrastructure, vendors introduced what is called "Edge Side Includes" (ESI), a technology allowing malleability in caching systems. This legacy technology, still implemented in nearly all popular HTTP surrogates (caching/load balancing services), is dangerous by design and brings a yet unexplored vector for web-based attacks.
* **Tools**


----------------------------------------------------------------------------------------------------------------


### <a name="emc">Embedded Malicious Code</a>
* **101**
* **Articles/Blogposts/Writeups**
* **Papers**
* **Presentations/Talks/Videos**
* **Tools**


----------------------------------------------------------------------------------------------------------------


### <a name="eoa">Exploitation of Authentication </a>
* **101**
* **Articles/Blogposts/Writeups**
* **Papers**
* **Presentations/Talks/Videos**
* **Tools**


----------------------------------------------------------------------------------------------------------------


### <a name="fuzzing"></a> Fuzzing
- **APIs**
	- See api section
- **HTTP**
		* [httpfuzz](https://github.com/JonCooperWorks/httpfuzz)
			* httpfuzz is a fast HTTP fuzzer written in Go inspired by Burp Intruder. It takes a seed request and uses a wordlist to generate requests. For a wordlist with m words and a seed request with n injection points, httpfuzz will generate m * n requests. It can be used as a library, but is meant to be used with the included httpfuzz CLI. It allows fuzzing of HTTP requests with text bodies and multipart file uploads.
- **Injection Vulns**
	- **Papers**
		* [Toss a Fault to Your Witcher: Applying Grey-box Coverage-Guided Mutational Fuzzing to Detect SQL and Command Injection Vulnerabilities - Erik Trickel, Fabio Pagani, Chang Zhu, Lukas Dresel†, Giovanni Vigna, Christopher Kruegel, Ruoyu Wang, Tiffany Bao, Yan Shoshitaishvili, Adam Doupé(2022)](https://pagabuc.me/docs/oakland23_witcher.pdf)
			* To overcome these limitations, we propose Witcher, a novel web vulnerability discovery framework that is inspired by grey-box coverage-guided fuzzing. Witcher implements the concept of fault escalation to detect both SQL and command injection vulnerabilities. Additionally, Witcher captures coverage information and creates output-derived input guidance to focus the input generation and, therefore, to increase the state-space exploration of the web appli- cation. On a dataset of 18 web applications written in PHP, Python, Node.js, Java, Ruby, and C, 13 of which had known vulnerabilities, Witcher was able to find 23 of the 36 known vulnerabilities (64%), and additionally found 67 previously unknown vulnerabilities, 4 of which received CVE numbers. In our experiments, Witcher outper- formed state of the art scanners both in terms of number of vulner- abilities found, but also in terms of coverage of web applications
- **JSON**
	- **Articles/Blogposts/Writeups**
		* [Fuzzing JSON Web Services: Simple guide how to fuzz JSON web services properly - secapps](https://secapps.com/blog/2018/03/fuzzing-json-web-services)
	- **Tools**
- **Regex**
	- **Articles/Blogposts/Writeups**
		* [REcollapse](https://github.com/0xacb/recollapse)
			* [Blogpost](https://0xacb.com/2022/11/21/recollapse/)
			* REcollapse is a helper tool for black-box regex fuzzing to bypass validations and discover normalizations in web applications
	- **Talks/Presentations**
		* [ReDoSHunter: A Combined Static and Dynamic Approach for Regular Expression DoS Detection - Yeting Li and Zixuan Chen, Jialun Cao, Zhiwu Xu, Qiancheng Peng, Haiming Chen, Liyuan Chen, Shing-Chi Cheung(Usenix2021)](https://www.usenix.org/system/files/sec21-li-yeting.pdf)
			* [Tool](https://github.com/yetingli/ReDoSHunter)
			* To address these two problems, we propose ReDoSHunter, a ReDoS-vulnerable regex detection framework that can ef- fectively pinpoint the multiple vulnerabilities in a vulnerable regex, and generate examples of attack-triggering strings. Re- DoSHunter is driven by five vulnerability patterns derived from massive vulnerable regexes. Besides pinpointing vulner- abilities, ReDoSHunter can assess the degree (i.e., exponential or polynomial) of the vulnerabilities detected. Our experi- ment results show that ReDoSHunter achieves 100% preci- sion and 100% recall in the detection of ReDoS-vulnerable regexes in three large-scale datasets with 37,651 regexes. It significantly outperforms seven state-of-the-art techniques. ReDoSHunter uncovered 28 new ReDoS-vulnerabilities in 26 well-maintained popular projects, resulting in 26 assigned CVEs and 2 fixes.
	- **Tools**


----------------------------------------------------------------------------------------------------------------


### <a name="idn">IDN Homograph & Homograph Attacks</a>
* **101**
	* [The Homograph Attack - Evgeniy Gabrilovich, Alex Gontmakher](http://evgeniy.gabrilovich.com/publications/papers/homograph_full.pdf)
	* [IDN homograph attack - Wikipedia](https://en.wikipedia.org/wiki/IDN_homograph_attack)
* **Articles/Blogposts/Writeups**
	* [Homograph Attack - crypto-it.net](http://www.crypto-it.net/eng/attacks/homograph-attack.html)
	* [What is an IDN Homograph Attack and How Do You Protect Yourself? - zvelo(2018)](https://zvelo.com/what-is-idn-homograph-attack-protect-yourself/)
	* [Phishing with Unicode Domains - Xudong Zheng(2017)](https://www.xudongz.com/blog/2017/idn-phishing/)
	* [Watch Your Step: The Prevalence of IDN Homograph Attacks - Asaf Nadler(2017)](https://blogs.akamai.com/sitr/2020/05/watch-your-step-the-prevalence-of-idn-homograph-attacks.html)
	* [Homograph attacks: Don’t believe everything you see -  Cecilia Pastorino(2017)](https://www.welivesecurity.com/2017/07/27/homograph-attacks-see-to-believe/)
	* [A Quick Guide to the IDN Homograph Attack - Ronnie T. Baby](https://resources.infosecinstitute.com/a-quick-guide-to-the-idn-homograph-attack/)
* **Talks/Presentations/Videos**
	* [Weaponizing Unicode Homographs Beyond IDNs - The Tarquin(DEFCON 26)](https://www.youtube.com/watch?v=Ec1OOiG4RMA)
		* Most people are familiar with homograph attacks due to phishing or other attack campaigns using Internationalized Domain Names with look-alike characters. But homograph attacks exist against wide variety of systems that have gotten far less attention. This talk discusses the use of homographs to attack machine learning systems, to submit malicious software patches, and to craft cryptographic canary traps and leak repudiation mechanisms. It then introduces a generalized defense strategy that should work against homograph attacks in any context.
* **Papers**
	* [Cutting through the Confusion: A Measurement Study of Homograph Attacks. - Tobias Holgers, David E. Watson, Steven D. Gribble(2006)](https://www.researchgate.net/publication/220881094_Cutting_through_the_Confusion_A_Measurement_Study_of_Homograph_Attacks)
		* Web homograph attacks have existed for some time, and the recent adoption of International Domain Names (IDNs) support by browsers and DNS registrars has exacerbated the problem [Gabr02]. Many international letters have similar glyphs, such as the Cyrillic letter P (lower case 'er,' Unicode 0x0440) and the Latin letter p. Because of the large potential for misuse of IDNs, browser vendors, policy advocates, and researchers have been exploring techniques for mitigating homograph attacks [=Mozi05, Appl05, Oper05, Mark05]. There has been plenty of attention on the problem recently, but we are not aware of any data that quantifies the degree to which Web homograph attacks are currently taking place. In this paper, we use a combination of passive network tracing and active DNS probing to measure several aspects of Web homographs. Our main findings are four-fold. First, many authoritative Web sites that users visit have several confusable domain names registered. Popular Web sites are much more likely to have such confusable domains registered. Second, registered confusable domain names tend to consist of single character substitutions from their authoritative domains, though we saw instances of five-character substitutions. Most confusables currently use Latin character homographs, but we did find a non-trivial number of IDN homographs. Third, Web sites associated with non-authoritative confusable domains most commonly show users advertisements. Less common functions include redirecting victims to competitor sites and spoofing the content of authoritative site. Fourth, during our nine-day trace, none of the 828 Web clients we observed visited a non-authoritative confusable Web site. Overall, our measurement results suggest that homograph attacks currently are rare and not severe in nature. However, given the recent increases in phishing incidents, homograph attacks seem like an attractive future method for attackers to lure users to spoofed sites.
	* [Іntеrnɑtⅰonɑlⅰzеⅾ Dоmɑⅰn Nɑmе Hоmоɡrɑρh Attɑсκ - Chen Lai, Zhongrong Jian, J. Sidrach](https://github.com/jsidrach/idn-homograph-attack)
	* [ShamFinder: An Automated Framework for Detecting IDN Homographs - Hiroaki Suzuki, Daiki Chiba, Yoshiro Yoneya, Tatsuya Mori, Shigeki Goto](https://arxiv.org/pdf/1909.07539.pdf)
* **Tools**
	* [EvilURL v2.0](https://github.com/UndeadSec/EvilURL)
		* Generate unicode evil domains for IDN Homograph Attack and detect them.
	* [homoglyphs.net](https://www.homoglyphs.net)
	* [Punycode converter](https://www.punycoder.com/)
		* or an IDN converter, a tool for Punycode to Text/Unicode and vice-versa conversion


----------------------------------------------------------------------------------------------------------------



### <a name="idor">Insecure Direct Object Reference</a>
- **101**
	* [Insecure Direct Object References - tutorialspoint.com](https://www.tutorialspoint.com/security_testing/insecure_direct_object_reference.htm)
	* [What Are Insecure Direct Object References - Tomasz Andrzej Nidecki(2020)](https://www.acunetix.com/blog/web-security-zone/what-are-insecure-direct-object-references/)
- **Articles/Blogposts/Writeups**
	* [Testing for Insecure Direct Object References (OTG-AUTHZ-004) - OWASP](https://wiki.owasp.org/index.php/Testing_for_Insecure_Direct_Object_References_(OTG-AUTHZ-004))
	* [Insecure Direct Object Reference Prevention Cheat Sheet - OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Insecure_Direct_Object_Reference_Prevention_Cheat_Sheet.html)
	* [Airbnb – Web to App Phone Notification IDOR to view Everyone’s Airbnb Messages - Brett Buerhaus](https://buer.haus/2017/03/31/airbnb-web-to-app-phone-notification-idor-to-view-everyones-airbnb-messages/)
	* [How-To: Find IDOR (Insecure Direct Object Reference) Vulnerabilities for large bounty rewards - BugCrowd](https://www.bugcrowd.com/blog/how-to-find-idor-insecure-direct-object-reference-vulnerabilities-for-large-bounty-rewards/)
	* [A Less Known Attack Vector, Second Order IDOR Attacks - Ozgur Alp(2020)](https://blog.usejournal.com/a-less-known-attack-vector-second-order-idor-attacks-14468009781a?gi=49aab32e1f3d)
	* [Automated IDOR Discovery through Stateful Swagger Fuzzing - Aaron Loo(2020)](https://engineeringblog.yelp.com/2020/01/automated-idor-discovery-through-stateful-swagger-fuzzing.html)
	* [Finding more IDORs – Tips and Tricks - Max Cobridge(2021)](https://www.aon.com/cyber-solutions/aon_cyber_labs/finding-more-idors-tips-and-tricks/)
- **Talks/Presentations/Videos**
- **Tools**


----------------------------------------------------------------------------------------------------------------


### <a name="ear">Execution After(/Open) Redirect (EAR)
* **Execution After Redirect**
	* [Execution After Redirect - OWASP](https://www.owasp.org/index.php/Execution_After_Redirect_(EAR))
	* [Overview of Execution After Redirect Web Application Vulnerabilities](https://adamdoupe.com/blog/2011/04/20/overview-of-execution-after-redirect-web-application-vulnerabilities/)
	* [EARs in the Wild: Large-Scale Analysis of Execution After Redirect Vulnerabilities](https://www.cs.ucsb.edu/~vigna/publications/2013_SAC_EARdetect.pdf)
	* [Fear the EAR: Discovering and Mitigating Execution After Redirect Vulnerabilities](http://cs.ucsb.edu/~bboe/public/pubs/fear-the-ear-ccs2011.pdf)
* **Open Redirect**
	* [Open Redirect Payloads](https://github.com/cujanovic/Open-Redirect-Payloads)
	* [Security and Open Redirects  Impact of 301-ing people in 2013](https://makensi.es/rvl/openredirs/#/)
	* [Advanced Open Redirection Vulnerability Discovery - Toby Reynolds(2020)](https://insomniasec.com/blog/advanced-open-redirects)

----------------------------------------------------------------------------------------------------------------


### <a name="file"></a>File Upload Testing
* **101**
	* [Unrestricted File Upload - OWASP](https://owasp.org/www-community/vulnerabilities/Unrestricted_File_Upload)
	* [File Upload Cheat Sheet - OWASP](https://cheatsheetseries.owasp.org/cheatsheets/File_Upload_Cheat_Sheet.html)
	* [CWE-434: Unrestricted Upload of File with Dangerous Type](https://cwe.mitre.org/data/definitions/434.html)
* **Articles/Blogposts/Writeups**
	* [Why File Upload Forms are a Major Security Threat - acunetix](https://www.acunetix.com/websitesecurity/upload-forms-threat/)
	* [Unrestricted File Upload Testing](https://www.aptive.co.uk/blog/unrestricted-file-upload-testing/)
	* [BookFresh Tricky File Upload Bypass to RCE - secgeek.net](https://secgeek.net/bookfresh-vulnerability/)
	* [Ability to upload HTML via SRT caption files for Facebook Videos - philippeharewood.com(2015)](https://philippeharewood.com/ability-to-upload-html-via-srt-caption-files-for-facebook-videos/)
	* [15 Technique to Exploit File Upload Pages - Ebrahim Hegazy(HackIT17)](https://es.slideshare.net/HackIT-ukraine/15-technique-to-exploit-file-upload-pages-ebrahim-hegazy)
		* [15 Technique to Exploit File Upload Pages - Ebrahim Hegazy(HackIT-2017)](https://www.youtube.com/watch?v=CmF9sEyKZNo)
	* [File Upload and PHP on IIS: `>=?` and `<=*` and `"=.` - Soroush Dalili](https://soroush.secproject.com/blog/2014/07/file-upload-and-php-on-iis-wildcards/)
	* [Exploiting File Uploads Pt. 1 – MIME Sniffing to Stored XSS #bugbounty - HackerOnTwoWheels(2019)](https://anotherhackerblog.com/exploiting-file-uploads-pt1/)
	* [Bypassing file upload filter by source code review in Bolt CMS - Sivanesh Ashok](https://stazot.com/boltcms-file-upload-bypass/)
	* [File Upload Testing tips - HolyBugx](https://github.com/HolyBugx/HolyTips/blob/main/Checklist/File%20Upload.pdf)
	* [File upload tricks and checklist - Gus Ralph(2021)](https://www.onsecurity.io/blog/file-upload-checklist/)
	* [A New Vector For “Dirty” Arbitrary File Write to RCE - Maxence Schmitt, Lorenzo Stella(2023)](https://blog.doyensec.com/2023/02/28/new-vector-for-dirty-arbitrary-file-write-2-rce.html)
* **Papers**
	* [FUSE: Finding File Upload Bugs via Penetration Testing - Taekjin Lee, Seongil Wi, Suyoung Lee, Sooel Son](https://www.ndss-symposium.org/wp-content/uploads/2020/02/23126.pdf)
* **Presentations/Talks/Videos**
	* [FUSE: Finding File Upload Bugs via Penetration Testing - Taekjin Lee, Seongil Wi, Suyoung Lee, Sooel Son(NDSS2020)]()
		* An Unrestricted File Upload (UFU) vulnerability is a critical security threat that enables an adversary to upload her choice of a forged file to a target web server. This bug evolves into an Unrestricted Executable File Upload (UEFU) vulnerability when the adversary is able to conduct remote code execution of the uploaded file via triggering its URL. We design and implement FUSE, the first penetration testing tool designed to discover UFU and UEFU vulnerabilities in server-side PHP web applications. The goal of FUSE is to generate upload requests; each request becomes an exploit payload that triggers a UFU or UEFU vulnerability. However, this approach entails two technical challenges: (1) it should generate an upload request that bypasses all content-filtering checks present in a target web application; and (2) it should preserve the execution semantic of the resulting uploaded file. We address these technical challenges by mutating standard upload requests with carefully designed mutation operations that enable the bypassing of content- filtering checks and do not tamper with the execution of uploaded files. FUSE discovered 30 previously unreported UEFU vulnerabilities, including 15 CVEs from 33 real-world web applications, thereby demonstrating its efficacy in finding code execution bugs via file uploads.
		* [Paper](https://www.ndss-symposium.org/wp-content/uploads/2020/02/23126.pdf)
	* [Finding File Upload Bugs via Penetration Testing - Taekjin Lee, Seongil Wi, Suyoung Lee, Sooel Son(2020)](https://www.youtube.com/watch?v=Ot0unJErC-g)
		* [Paper](https://www.ndss-symposium.org/wp-content/uploads/2020/02/23126.pdf)
		* An Unrestricted File Upload (UFU) vulnerability is a critical security threat that enables an adversary to upload her choice of a forged file to a target web server. This bug evolves into an Unrestricted Executable File Upload (UEFU) vulnerability when the adversary is able to conduct remote code execution of the uploaded file via triggering its URL. We design and implement FUSE, the first penetration testing tool designed to discover UFU and UEFU vulnerabilities in server-side PHP web applications. The goal of FUSE is to generate upload requests; each request becomes an exploit payload that triggers a UFU or UEFU vulnerability. However, this approach entails two technical challenges: (1) it should generate an upload request that bypasses all content-filtering checks present in a target web application; and (2) it should preserve the execution semantic of the resulting uploaded file. We address these technical challenges by mutating standard upload requests with carefully designed mutation operations that enable the bypassing of content- filtering checks and do not tamper with the execution of uploaded files. FUSE discovered 30 previously unreported UEFU vulnerabilities, including 15 CVEs from 33 real-world web applications, thereby demonstrating its efficacy in finding code execution bugs via file uploads.
* **Tools**
	* [Anti Malware Testfile - EICAR](https://www.eicar.org/?page_id=3950)
	* [fuxploider](https://github.com/almandin/fuxploider)
		* File upload vulnerability scanner and exploitation tool.


----------------------------------------------------------------------------------------------------------------


### <a name="hsmug">HTML Smuggling</a>
* **101**
	* [HTML Smuggling Explained - Stan Hegt](https://outflank.nl/blog/2018/08/14/html-smuggling-explained/)
* **Articles/Blogposts/Writeups**
	* [File Smuggling with HTML and JavaScript - ired.team](https://ired.team/offensive-security/defense-evasion/file-smuggling-with-html-and-javascript)
	* [Strange Bits: HTML Smuggling and GitHub Hosted Malware - gdatasoftware.com](https://www.gdatasoftware.com/blog/2019/05/31695-strange-bits-smuggling-malware-github)
	* [Smuggling HTA files in Internet Explorer/Edge - Richard Warren](https://www.nccgroup.trust/us/about-us/newsroom-and-events/blog/2017/august/smuggling-hta-files-in-internet-exploreredge/)
* **Tools**
	* [SharpShooter](https://github.com/mdsecactivebreach/SharpShooter)
	* [Demiguise](https://github.com/nccgroup/demiguise)



----------------------------------------------------------------------------------------------------------------


### <a name="httprs">HTTP Request Smuggling</a>
* **101**
	* [HTTP request smuggling - Wikipedia](https://en.wikipedia.org/wiki/HTTP_request_smuggling)
		* HTTP request smuggling is a security exploit on the HTTP protocol that uses inconsistency between the interpretation of Content-length and/or Transfer-encoding headers between HTTP server implementations in an HTTP proxy server chain. It was first documented in 2005, and was again repopularized by PortSwigger's research.
	* [HTTP request smuggling - Portswigger](https://portswigger.net/web-security/request-smuggling)
	* [HTTP Desync Attacks: Request Smuggling Reborn - James Kettle](https://portswigger.net/research/http-desync-attacks-request-smuggling-reborn)
	* [‘HTTP Request Smuggling’ - Securiteam](https://securiteam.com/securityreviews/5gp0220g0u/)
	* [Help you understand HTTP Smuggling in one article - @ZeddYu_Lu](https://blog.zeddyu.info/2019/12/08/HTTP-Smuggling-en/)
	* [Request Smuggling 101 - Philippe Arteau(2021)](https://gosecure.github.io/presentations/2021-05-request-smuggling-101/RequestSmuggling101.pdf)
* **Articles/Blogposts/Writeups**
	* [Checking HTTP Smuggling issues in 2015 - Part1 - RBleug(2015)](https://regilero.github.io/security/english/2015/10/04/http_smuggling_in_2015_part_one/)
	* [Hiding in plain sight: HTTP request smuggling - Travis Isaacson(2020)](https://blog.detectify.com/2020/05/28/hiding-in-plain-sight-http-request-smuggling/)
	* [Demystifying HTTP request smuggling - Sam Sanoop](https://snyk.io/blog/demystifying-http-request-smuggling/)
	* [NGINX error_page request smuggling - Bert JW Regeer, Francisco Oca Gonzalez(2019)](https://bertjwregeer.keybase.pub/2019-12-10%20-%20error_page%20request%20smuggling.pdf)
	* [HTTP Request Smuggling + IDOR - hipotermia(2019)](https://hipotermia.pw/bb/http-desync-idor)
	* [The Powerful HTTP Request Smuggling 💪 - Ricardo Iramar dos Santos](https://medium.com/@ricardoiramar/the-powerful-http-request-smuggling-af208fafa142)
		* "TL;DR: This is how I was able to exploit a HTTP Request Smuggling in some Mobile Device Management (MDM) servers and send any MDM command to any device enrolled on them for a private bug bounty program."
	* [h2c Smuggling: Request Smuggling Via HTTP/2 Cleartext (h2c) - Jake Miller(2020)](https://labs.bishopfox.com/tech-blog/h2c-smuggling-request-smuggling-via-http/2-cleartext-h2c)
	* [HTTP Request Smuggling – 5 Practical Tips - Pieter Hiele(2020)](https://honoki.net/2020/02/18/http-request-smuggling-5-practical-tips/)
	* [XXE-scape through the front door: circumventing the firewall with HTTP request smuggling - Pieter Hiele(2020)](https://honoki.net/2020/03/18/xxe-scape-through-the-front-door-circumventing-the-firewall-with-http-request-smuggling/)
	* [Practical HTTP Header Smuggling: Sneaking Past Reverse Proxies to Attack AWS and Beyond - Daniel Thatcher(2020)](https://www.intruder.io/research/practical-http-header-smuggling)
	* [Account takeover via HTTP Request Smuggling - hipotermia(2020)](https://hipotermia.pw/bb/http-desync-account-takeover)
	* [HTTP Request Smuggling Workshop - Philippe Arteau](https://gosecure.github.io/request-smuggling-workshop/)
		* [Presentation](https://gosecure.github.io/presentations/2021-05-request-smuggling-101/RequestSmuggling101.pdf)
	* [HTTP Request Smuggling via higher HTTP versions - Emil Lerner(2021)](https://www.slideshare.net/neexemil/http-request-smuggling-via-higher-http-versions)
* **Performing**
	* [A Pentester’s Guide to HTTP Request Smuggling - Bursa Demir(2020)](https://blog.cobalt.io/a-pentesters-guide-to-http-request-smuggling-8b7bf0db1f0)
	* [Smuggling HTTP headers through reverse proxies - Robin Verton(2020)](http://github.security.telekom.com/2020/05/smuggling-http-headers-through-reverse-proxies.html)	
	* [HTTP Request Smuggling: Abusing Reverse Proxies - Christopher Elgee(2020)](https://www.sans.org/blog/http-request-smuggling-abusing-reverse-proxies/)
	* [WAF Bypass Techniques - Using HTTP Standard and Web Servers’ Behaviour - Soroush Dalili(2018)](https://www.slideshare.net/SoroushDalili/waf-bypass-techniques-using-http-standard-and-web-servers-behaviour)
* **Papers**
	* [HTTP Request Smuggling - Chaim Linhart, Amit Klein, Ronen Heled, Steve Orrin](https://www.cgisecurity.com/lib/HTTP-Request-Smuggling.pdf)
* **Presentations/Talks/Videos**
	* [HTTP Desync Attacks: Smashing into the Cell Next Door - James Kettle(DEFCON27)](https://www.youtube.com/watch?v=w-eJM2Pc0KI)
		* HTTP requests are traditionally viewed as isolated, standalone entities. In this session, I'll introduce techniques for remote, unauthenticated attackers to smash through this isolation and splice their requests into others, through which I was able to play puppeteer with the web infrastructure of numerous commercial and military systems, rain exploits on their visitors, and harvest over $50k in bug bounties.  Using these targets as case studies, I’ll show you how to delicately amend victim's requests to route them into malicious territory, invoke harmful responses, and lure credentials into your open arms. I’ll also demonstrate using backend reassembly on your own requests to exploit every modicum of trust placed on the frontend, gain maximum privilege access to internal APIs, poison web caches, and compromise my favourite login page.  Although documented over a decade ago, a fearsome reputation for difficulty and collateral damage has left this attack optimistically ignored for years while the web's susceptibility grew. By applying fresh ideas and new techniques, I’ll unveil a vast expanse of vulnerable systems ranging from huge content delivery networks to bespoke backends, and ensure you leave equipped to devise your own desync techniques and tailor attacks to your target of choice.
	* [Hiding Wookiees in HTTP: HTTP smuggling - regilero(Defcon24)](https://www.youtube.com/watch?v=dVU9i5PsMPY)
		* HTTP is everywhere, everybody wants to write an HTTP server. So I wrote mine :-) But mine not fast, and come with an HTTP client which sends very bad HTTP queries. My tool is a stress tester for HTTP servers and proxies, and I wrote it because I found flaws in all HTTP agents that I have checked in the last year i.e. nodejs, golang, Apache httpd, FreeBSD http, Nginx, Varnish and even Haproxy. This presentation will try to explain how flaws in HTTP parsers can be exploited for bad things; we'll play with HTTP to inject unexpected content in the user browser, or perform actions in his name. If you know nothing about HTTP it should be understandable, but you'll have to trust me blindly at the end. If you think you know HTTP, you have no reason to avoid this talk. Then, the short part, I will show you this new Open Source stress tool that I wrote and hope that you will remember it when you'll write your own HTTP parser for you new f** language.
	* [Practical Attacks Using HTTP Request Smuggling - @defparam(NahamCon2020)](https://www.youtube.com/watch?v=3tpnuzFLU8g&list=PLKAaMVNxvLmAD0ZVUJ2IGFFC0APFZ5gzy&index=14)
	* [HTTP Request Smuggling in 2020 – New Variants, New Defenses and New Challenges - Amit Klein(BHUSA2020)](https://www.youtube.com/watch?v=Zm-myHU8-RQ&list=PLH15HpR5qRsXE_4kOSy_SXwFkFQre4AV_&index=57)
		* HTTP Request Smuggling (AKA HTTP Desyncing) is an attack technique invented in 2005 that exploits different interpretations of a stream non-standard HTTP requests among various HTTP devices between the client (attacker) and the server (including the server itself). It can be used to smuggle requests across WAFs and security solutions, poison HTTP caches, inject responses to users and hijack user requests.
	* [HTTP Request Smuggling in 2020 – New Variants, New Defenses and New Challenges - Amit Klein(BHUSA2020)](https://www.blackhat.com/us-20/briefings/schedule/#http-request-smuggling-in---new-variants-new-defenses-and-new-challenges-20019)
		* [Slides](https://i.blackhat.com/USA-20/Wednesday/us-20-Klein-HTTP-Request-Smuggling-In-2020-New-Variants-New-Defenses-And-New-Challenges.pdf)
		* [Paper](https://i.blackhat.com/USA-20/Wednesday/us-20-Klein-HTTP-Request-Smuggling-In-2020-New-Variants-New-Defenses-And-New-Challenges-wp.pdf)
	* [HTTP Desync Attack Explained With Paper - LiveUnderflow(2021)](https://www.youtube.com/watch?v=dnyL7EKbRRk)
* **Tools**
	* [Smuggler](https://github.com/defparam/smuggler)
		* An HTTP Request Smuggling / Desync testing tool written in Python 3
	* [HTTPWookie](https://github.com/regilero/HTTPWookiee)
		*  HTTPWookiee is an HTTP server and proxy stress tool (respect of RFC, HTTP Smuggling issues, etc). If you run an HTTP server project contact me for private repository access with more tests. 
	* [smuggler.py](https://github.com/gwen001/pentest-tools/blob/master/smuggler.py)


----------------------------------------------------------------------------------------------------------------


### <a name="ibe"></a>Image-based Exploitation AKA Exploiting Polyglot features of File standards
* **101**
	* [Graphics Interchange Format Java Archives (GIFAR) - Wikipedia](https://en.wikipedia.org/wiki/Gifar)
* **Articles/Blogposts/Writeups**
	* [Revisiting XSS payloads in PNG IDAT chunks - Adam Logue](https://www.adamlogue.com/revisiting-xss-payloads-in-png-idat-chunks/)
	* [An XSS on Facebook via PNGs & Wonky Content Types - jack@whitton.io](https://whitton.io/articles/xss-on-facebook-via-png-content-types/)
	* [Encoding Web Shells in PNG IDAT chunks - idontplaydarts](https://www.idontplaydarts.com/2012/06/encoding-web-shells-in-png-idat-chunks/)
	* [Bypassing CSP using polyglot JPEGs - Gareth Heyes](https://portswigger.net/research/bypassing-csp-using-polyglot-jpegs)
	* [Hacking group using Polyglot images to hide malvertising attacks - Josh Summit](https://devcondetect.com/blog/2019/2/24/hacking-group-using-polyglot-images-to-hide-malvertsing-attacks)
	* [BMP/x86 Polyglot - steiner@warroom.securestate](https://warroom.securestate.com/bmp-x86-polyglot/)
	* [Upload a web.config File for Fun & Profit - Soroush Dalili](https://soroush.secproject.com/blog/2014/07/upload-a-web-config-file-for-fun-profit/)
	* [Uploading web.config for Fun and Profit 2 - Soroush Dalili](https://soroush.secproject.com/blog/2019/08/uploading-web-config-for-fun-and-profit-2/)
	* [Encoding Web Shells in PNG IDAT chunks - phil](https://www.idontplaydarts.com/2012/06/encoding-web-shells-in-png-idat-chunks/)
* **Tools**
	* [xss2png](https://github.com/vavkamil/xss2png)
		* A simple tool to generate PNG images with XSS payloads stored in PNG IDAT chunks
	* [pixload](https://github.com/chinarulezzz/pixload)
		* Set of tools for creating/injecting payload into images.
	* [PNG-IDAT-Payload-Generator](https://github.com/huntergregal/PNG-IDAT-Payload-Generator)
		* Generate a PNG with a payload embedded in the IDAT chunk (Based off of previous concepts and code -- credit in README)
	* [Imagecreatefromgif-Bypass](https://github.com/JohnHoder/Imagecreatefromgif-Bypass)


----------------------------------------------------------------------------------------------------------------


### <a name="ija">Injection Based Attacks</a>
- **101**
- **Articles/Blogposts/Writeups**
	* [Exploiting ShellShock getting a reverse shell](http://www.fantaghost.com/exploiting-shellshock-getting-reverse-shell)
	* [Exploiting Python Code Injection in Web Applications](https://sethsec.blogspot.com/2016/11/exploiting-python-code-injection-in-web.html)
	* [Exploiting Python Code Injection in Web Applications - sethsec](https://sethsec.blogspot.com/2016/11/exploiting-python-code-injection-in-web.html)
- **Command Injection**<a name="cmdinject"></a>
	* **101**
	- **Articles/Blogposts/Writeups**
		* [Re: Command injection with no spaces - pauldotcom@seclists](https://seclists.org/pauldotcom/2012/q2/216)
		* [; echo “Shell Injection”  - matklad(2021)](https://matklad.github.io/2021/07/30/shell-injection.html)
	- **Talks/Presentations**
		* [Bash injection without letters or numbers - 33c3ctf hohoho (misc 350) - LiveOverflow(2017)](https://www.youtube.com/watch?v=6D1LnMj0Yt0)
	- **Tools**
	- **Resources**
		* [FuzzDB OS Cmd Injection List](https://github.com/fuzzdb-project/fuzzdb/tree/master/attack/os-cmd-execution)
- **JSON(P) Injection**<a name="jsoninject"></a>
	- **101**
		* [What Are JSON Injections - Tomasz Andrzej Nidecki(2019)](https://www.acunetix.com/blog/web-security-zone/what-are-json-injections/)
	- **Articles/Blogposts/Writeups**
		* [Handling Untrusted JSON Safely - Jim Manico(2013)](https://www.whitehatsec.com/blog/handling-untrusted-json-safely/)
		* [DOM-based client-side JSON injection - PortSwigger](https://portswigger.net/web-security/dom-based/client-side-json-injection)
		* [Practical JSONP Injection - Petre Popescu(2018)](https://securitycafe.ro/2017/01/18/practical-jsonp-injection/)
		* [Hacking JWT Tokens: JSON Injection - Shivam Bathla(2020)](https://blog.pentesteracademy.com/hacking-jwt-tokens-json-injection-89ac555c484c?gi=2afc23113d06)
	- **Talks/Presentations/Videos**
		* [Web PenTesting Workshop Part 12 of 12 JSON injection - Jeremy Druin](https://www.youtube.com/watch?v=ZLAaq7Q-5jc)
			* Video from the ISSA Kentuckiana Web Pen-Testing Workshop.
	- **Tools**
	- **Resources**
		* [Lab: JSON Injection](https://github.com/enygma/h2-json-injection)
		* [AJAX Security Cheat Sheet - OWASP](https://cheatsheetseries.owasp.org/cheatsheets/AJAX_Security_Cheat_Sheet.html#Protect_against_JSON_Hijacking_for_Older_Browsers)	
- **LDAP Injection**<a name="ldapinject"></a>
	* [LDAP Injection - PayloadsAllTheThings](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/LDAP%20Injection)
- **OGNL Injection**
	* [Exploiting OGNL Injection in Apache Struts  - Ionut Popescu(2022)](https://pentest-tools.com/blog/exploiting-ognl-injection-in-apache-struts)
- **Papers**
- **Presentations/Talks/Videos**
	* [Popular Approaches to Preventing Code Injection Attacks are Dangerously Wrong - AppSecUSA 2017](https://www.youtube.com/watch?v=GjK0bB4K2zA&app=desktop)
	* [Remote Code Execution in Firefox beyond memory corruptions(2019) - Frederik Braun](https://frederik-braun.com/firefox-ui-xss-leading-to-rce.html)
		* Browsers are complicated enough to have attack surface beyond memory safety issues. This talk will look into injection flaws in the user interface of Mozilla Firefox, which is implemented in JS, HTML, and an XML-dialect called XUL. With an Cross-Site Scripting (XSS) in the user interface attackers can execute arbitrary code in the context of the main browser application process. This allows for cross-platform exploits of high reliability. The talk discusses past vulnerabilities and will also suggest mitigations that benefit Single Page Applications and other platforms that may suffer from DOM-based XSS, like Electron.
- **Tools**
* See also: JNDI, JSON, SQLi, XSS


----------------------------------------------------------------------------------------------------------------


### <a name="osci"></a> OS Command Injection
* **General**
	* [Command Injection - OWASP](https://www.owasp.org/index.php/Command_Injection)
* **Testing**
	* [Testing for Command Injection - OWASP](https://www.owasp.org/index.php/Testing_for_Command_Injection_(OTG-INPVAL-013))
	* [How To: Command Injections - Hackerone](https://www.hackerone.com/blog/how-to-command-injections)
	* [Data Exfiltration via Blind OS Command Injection](https://www.contextis.com/blog/data-exfiltration-via-blind-os-command-injection)
* **Tools**
	* [commix](https://github.com/stasinopoulos/commix)
		* Automated All-in-One OS Command Injection and Exploitation Tool
	* [SHELLING](https://github.com/ewilded/shelling)
		* A comprehensive OS command injection payload generator
* **Writeups**


----------------------------------------------------------------------------------------------------------------


### <a name="jndi"></a>JNDI Attack Class
* **General**
	* [What is JNDI ? What is its basic use..? When is it used? - StackOverflow](https://stackoverflow.com/questions/4365621/what-is-jndi-what-is-its-basic-use-when-is-it-used)
	* [Introducing JNDI Injection and LDAP Entry Poisoning](https://community.softwaregrp.com/t5/Security-Research/Introducing-JNDI-Injection-and-LDAP-Entry-Poisoning/ba-p/219821)
* **Testing**
	* [jndipoc](https://github.com/zerothoughts/jndipoc)
		* Proof of concept showing how java byte code can be injected through InitialContext.lookup() calls
* **Tools**
* **Writeups**
	* [Java Naming and Directory Interface - Wikipedia](https://en.wikipedia.org/wiki/Java_Naming_and_Directory_Interface)
	* [A Journey from JNDI-LDAP Manipulation to RCE](https://www.blackhat.com/docs/us-16/materials/us-16-Munoz-A-Journey-From-JNDI-LDAP-Manipulation-To-RCE-wp.pdf)
	* [Video - A Journey From JNDI/LDAP Manipulation to Remote Code Execution Dream Land - BH USA16](https://www.youtube.com/watch?v=Y8a5nB-vy78)
	* [Fun with JNDI remote code injection](http://zerothoughts.tumblr.com/post/137769010389/fun-with-jndi-remote-code-injection)


----------------------------------------------------------------------------------------------------------------


### <a name="passbrute"></a> Password Brute Forcing/Spraying
* **101**
* **Articles/Papers/Writeups**
- **Tools**
	* [BruteLoops](https://github.com/arch4ngel/BruteLoops)
		* A dead simple library providing the foundational logic for efficient password brute force attacks against authentication interfaces.
	* [Big Friggin Gun (BFG)](https://github.com/arch4ngel/bl-bfg)
		* BFG is a simple modular framework to perform brute-force attacks. It uses the BruteLoops library for the brute force and database management logic.


----------------------------------------------------------------------------------------------------------------


### <a name="pca"></a> Path Confusion Attacks
* **101**
* **Articles/Papers/Writeups**


----------------------------------------------------------------------------------------------------------------


### <a name="lrfi">LFI & RFI</a>
* **101**
	* [File inclusion vulnerability - Wikipedia](https://en.wikipedia.org/wiki/File_inclusion_vulnerability)
* **Articles/Papers/Writeups**
	* [LFI with PHPINFO() Assistance - InsomniaSecurity 2011](https://www.insomniasec.com/downloads/publications/LFI%20With%20PHPInfo%20Assistance.pdf)
	* [Turning LFI into RFI](https://l.avala.mp/?p=241)
		* When configured in a specific way the web application would load the JAR file and search within the file for a class. Interestingly enough, in Java classes you can define a static block that is executed upon the class being processed
	* [Unrestricted File Upload Security Testing - Aptive](https://www.aptive.co.uk/blog/unrestricted-file-upload-testing/)
	* [Local file inclusion tricks - Johan Adriaans(2007)](http://devels-playground.blogspot.fr/2007/08/local-file-inclusion-tricks.html)
	* [Upgrade from LFI to RCE via PHP Sessions - (2017)](https://www.rcesecurity.com/2017/08/from-lfi-to-rce-via-php-sessions/)
	* [CVV #1: Local File Inclusion - SI9INT](https://medium.com/bugbountywriteup/cvv-1-local-file-inclusion-ebc48e0e479a)
	* [File Inclusion - nets.ec(2016)](https://nets.ec/File_Inclusion)
	* [SMTP Log Poisioning through LFI to Remote Code Excecution - Aarti Singh((2019)](https://www.hackingarticles.in/smtp-log-poisioning-through-lfi-to-remote-code-exceution/)
	* [PHP Autoloading: Local File Inclusion by Design - Stephen Shkardoon(2019)](https://medium.com/@ss23/php-autloading-local-file-inclusion-by-design-71aafe627877)
	* [Practical strategies for exploiting FILE READ vulnerabilities - AFINE(2021)](https://blog.afine.com/practical-strategies-for-exploiting-file-read-vulnerabilities-272abe792078?gi=3c7bf2d1bdef)
- **Papers**
	* [LFI2RCE (Local File Inclusion to Remote Code Execution) advanced exploitation: /proc shortcuts](http://www.ush.it/2008/08/18/lfi2rce-local-file-inclusion-to-remote-code-execution-advanced-exploitation-proc-shortcuts/)
		* This paper exposes the ability from the attacker standpoint to use /proc in order to exploit LFI (Local File Inclusion) vulnerabilities.
* **Cheat Sheets/Reference Lists**
	* [HighOn.coffee LFI Cheat](https://highon.coffee/blog/lfi-cheat-sheet/)
	* [Local File Inclusion (LFI) [Definitive Guide] - aptive.co.uk](https://www.aptive.co.uk/blog/local-file-inclusion-lfi-testing/)
* **Testing**
	* [OWASP LFI](https://www.owasp.org/index.php/Testing_for_Local_File_Inclusion)
	* [LFI Local File Inclusion Techniques (paper)](http://www.ush.it/2008/08/18/lfi2rce-local-file-inclusion-to-remote-code-execution-advanced-exploitation-proc-shortcuts/)
		* This paper exposes the ability from the attacker standpoint to use /proc in order to exploit LFI (Local File Inclusion) vulnerabilities. While using /proc for such aim is well known this one is a specific technique that was not been previously published as far as we know. A tool to automatically exploit LFI using the shown approach is released accordingly. 
	* [Local File Inclusion (LFI) of session files to root escalation - ush.it(2008)](http://www_ush_it/2008/07/09/local-file-inclusion-lfi-of-session-files-to-root-escalation/)
	* [Windows Blind Files Collection - 0xsp](https://0xsp.com/offensive/windows-blind-files-collection)
* **Tools**
	* [dotdotpwn](https://github.com/wireghoul/dotdotpwn)
	* [Liffy](https://github.com/rotlogix/liffy)
		* Liffy is a Local File Inclusion Exploitation tool. 
	* [lfi-labs](https://github.com/paralax/lfi-labs)
		* small set of PHP scripts to practice exploiting LFI, RFI and CMD injection vulns
	* [psychoPATH - LFI](https://github.com/ewilded/psychoPATH/blob/master/README.md)
		* This tool is a highly configurable payload generator detecting LFI & web root file uploads. Involves advanced path traversal evasive techniques, dynamic web root list generation, output encoding, site map-searching payload generator, LFI mode, nix & windows support plus single byte generator.
	* [Kadimus](https://github.com/P0cL4bs/Kadimus)
		* Kadimus is a tool to check sites to lfi vulnerability , and also exploit it
	* [lfipwn](https://github.com/m101/lfipwn)
	* [LFISuite](https://github.com/D35m0nd142/LFISuite)


----------------------------------------------------------------------------------------------------------------


### <a name="log4j"></a>Log4j
- **General**
	* [pentesterland/Log4Shell](https://github.com/pentesterland/Log4Shell)
		* Log4J infodump by Pentesterland


----------------------------------------------------------------------------------------------------------------


### <a name="log4j"></a>Log4j
- **General**
	* [The Art of Exploiting Logical Flaws in Web Applications - SaifAllah BenMassaoud(HITB2020)](https://www.youtube.com/watch?v=FBXqUDEhumA&list=PLmv8T5-GONwQq16OhfaU77KCq7UQGiZsr&index=8)


----------------------------------------------------------------------------------------------------------------


### <a name="sqli"></a>(No)SQL Injection
- **101**
	* [NT Web Technology Vulnerabilities - rain.forest.puppy](http://phrack.org/issues/54/8.html)
	* [NT Web Technology Vulnerabilities - rain.forest.puppy](http://phrack.org/issues/54/8.html)
		* First public writeup of SQLi 
	* ["How I hacked PacketStorm" - rain forest puppy](http://www.ouah.org/rfp.txt)
	* [SQL injection - PortSwigger](https://portswigger.net/web-security/sql-injection)
	* [Basic of SQL for SQL Injection - SecurityIdiots](http://www.securityidiots.com/Web-Pentest/SQL-Injection/Part-1-Basic-of-SQL-for-SQLi.html)
	* [How to exploit the SQL Injection Attack - sqlzoo](https://sqlzoo.net/hack/)
	* [UNLEASH THE POWER OF SQL INJECTION! | Beginners Guide to Hacking with SQLi - SecAura](https://www.youtube.com/watch?v=_Y4MpvB6o7s)
* **Reference**
	* [SQL Injection Knowledge Base](http://websec.ca/kb/sql_injection#MySQL_Testing_Injection)
	* [SQL Injection Cheat Sheet](http://ferruh.mavituna.com/sql-injection-cheatsheet-oku/)
	* [SQL Injection Cheat Sheet - NetSparker](https://www.netsparker.com/blog/web-security/sql-injection-cheat-sheet/)
	* [SQL Injection wiki](http://www.sqlinjectionwiki.com/)
	* [Your Pokemon Guide for Essential SQL Pen Test Commands - Joshua Wright(2017)](https://www.sans.org/blog/your-pokemon-guide-for-essential-sql-pen-test-commands/)
* **General Articles/Blogposts/Writeups**
	* [Finding SQL injections fast with white-box analysis — a recent bug example - Frycos](https://medium.com/@frycos/finding-sql-injections-fast-with-white-box-analysis-a-recent-bug-example-ca449bce6c76)
	* [Blind (time-based) SQLi - Bug Bounty - jspin.re](https://jspin.re/fileupload-blind-sqli/)
	* [Exploiting difficult SQL injection vulnerabilities using sqlmap: Part 1 - stephen Bradshaw(2017)](http://thegreycorner.com/2017/01/05/exploiting-difficult-sql-injection.html)
	* [SELECT code_execution FROM * USING SQLite; Gaining code execution using a malicious SQLite database - Omer Gull(2019)](https://research.checkpoint.com/2019/select-code_execution-from-using-sqlite/)
	* [Beyond SQLi: Obfuscate and Bypass - CWH Underground](https://www.exploit-db.com/papers/17934/)
	* [Second Order SQLI: Automating with sqlmap - Jorge Lajara(2019)](https://jlajara.gitlab.io/web/2019/04/29/Second_order_sqli.html)
	* [SELECT code_execution FROM * USING SQLite; - Omer Gull(2019)](https://research.checkpoint.com/2019/select-code_execution-from-using-sqlite/)
	* [BigQuery SQL Injection Cheat Sheet - Ozgur Alp(2020)](https://ozguralp.medium.com/bigquery-sql-injection-cheat-sheet-65ad70e11eac)
	* [How to fuzz MySQL looking for weird characters - Luca Di Domenico(2020)](https://lucadidomenico.medium.com/how-to-fuzz-mysql-looking-for-weird-characters-28c7ad8b1057)
	* [Don't fear the bark, ts_rewrite to dodge the mark - Gaetan Ferry(2020)](https://www.synacktiv.com/en/publications/dont-fear-the-bark-tsrewrite-to-dodge-the-mark.html)
	* [Advanced boolean-based SQLi filter bypass techniques - theMiddle(2020)](https://www.secjuice.com/advanced-sqli-waf-bypass/)
	* [Hunting for SQL injections (SQLis) and Cross-Site Request Forgeries (CSRFs) in WordPress Plugins - Alex Pena(2020)](https://medium.com/tenable-techblog/hunting-for-sql-injections-sqlis-and-cross-site-request-forgeries-csrfs-in-wordpress-plugins-632dafc9cd2f)
	* [Automating Blind Sql Injection - Bad_Jubies(2020)](https://bad-jubies.github.io/Blind-SQLi-1/)
	* [SQL Injection filter bypass to perform blind SQL Injection - mannulinux.org(2020)](http://www.mannulinux.org/2020/09/sql-injection-filter-bypass-to-perform.html)
	* [SQLMap: One time use CSRF tokens - itsahobby(2022)](https://itasahobby.gitlab.io/posts/sqlmapcsrf/)
	* [Database Schema (Injection) - Hacksplained](https://www.youtube.com/watch?v=0-D-e66U2Z0&feature=youtu.be)
	* [kleiton0x00/Advanced SQL Injection Cheatsheet](https://github.com/kleiton0x00/Advanced-SQL-Injection-Cheatsheet)
		* A cheat sheet that contains advanced queries for SQL Injection of all types.
	* [SQL Injection Is Still Alive: From a Mall's Interactive Terminal to AWS WAF Bypass - Marc Olivier](https://gosecure.github.io/presentations/2021-11_sql-injection-is-still-alive/Marc_Olivier_Bergeron-SQL_Injection_Is_Still_Alive-From_a_Malls_Interactive_Terminal_to_AWS_WAF_Bypass.pdf)
	* [Tortellini in Brodobuf: How serializing data using Google’s Protobuf is not protecting your web app. -  Oblio, MrSaighnal(2021)](https://aptw.tf/2021/10/27/exploiting-protobuf-webapps.html)
		* "Many developers believe that serializing traffic makes a web application more secure, as well as faster. That would be easy, right? The truth is that security implications remain if the backend code does not adopt adequate defensive measures, regardless of how data is exchanged between the client and server. In this article we will show you how the serialization can’t stop an attacker if the web application is vulnerable at the root. During our activity the application was vulnerable to SQL injection, we will show how to exploit it in case the communications are serialized with Protocol Buffer and how to write a SQLMap tamper for it."
	* [Finding an unseen SQL Injection by bypassing escape functions in mysqljs/mysql - Flatt Security(2022)](https://flattsecurity.medium.com/finding-an-unseen-sql-injection-by-bypassing-escape-functions-in-mysqljs-mysql-90b27f6542b4)
	* [How I Found Multiple SQL Injections in 5 Minutes in Bug Bounty - Omar Hashem(2022)](https://infosecwriteups.com/how-i-found-multiple-sql-injections-in-5-minutes-in-bug-bounty-40155964c498?gi=25ae72179e1a)
	* [SQL Injection - PayloadsAllTheThings](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/SQL%20Injection)
* **Papers**
	* [SQL Injection In Insert, Update, And Delete - Osanda Malith(2014)](https://packetstormsecurity.com/files/126527/SQL-Injection-In-Insert-Update-And-Delete.html)
* **Talks/Presentations/Videos**
	* [Time-Based Blind SQL Injection using Heavy Queries: A practical approach for MS SQL Server, MS Access, Oracle and MySQL databases and Marathon Tool - Chema Alonso, Daniel Kachakil, Rodolfo Bordón, Antonio Guzmán y Marta Beltrán(Defcon16)](https://www.defcon.org/images/defcon-16/dc16-presentations/alonso-parada/defcon-16-alonso-parada-wp.pdf)
* **Writeups**
	* [Use google bots to perform SQL injections on websites](http://blog.sucuri.net/2013/11/google-bots-doing-sql-injection-attacks.html)
	* [Performing sqlmap POST request injection](https://hackertarget.com/sqlmap-post-request-injection/)
	* https://github.com/gosirys/Posts
* **Training**
	* [SQLi Lab lessons](https://github.com/Audi-1/sqli-labs)
		* SQLI-LABS is a platform to learn SQLI
- **Out-of-Band**
	* [Out-of-Band (OOB) SQL Injection - Lee Chun How(2019)](https://infosecwriteups.com/out-of-band-oob-sql-injection-87b7c666548b)
	* [A Study of Out-of-Band Structured Query Language Injection -  Lee Chun How(2019)](https://zenodo.org/record/3556347)
		* "Out-of-Band (OOB) Structured Query Language (SQL) Injection is an exploitation to exfiltrate data from database through different outbound channel. Common channel use by OOB SQL Injection for data exfiltration are through Domain Name Server (DNS) and HyperText Transfer Protocol (HTTP) channels. This type of SQL injection should address properly due to the impact is on the par with traditional methods. OOB SQL Injection impacts on database systems with insufficient of input validation control in place and allowed access to public, either DNS or HTTP protocol. Test cases and recommendation for remediation have been discussed in this paper in order to raise awareness of the exploitation."
* **NoSQL**
	* **Articles/Blogposts/Writeups**
		* [NoSQL Injection in Modern Web Applications - petecorey.com](http://www.petecorey.com/blog/2016/03/21/nosql-injection-in-modern-web-applications/)
		* [N1QL Injection: Kind of SQL Injection in a NoSQL Database - Krzysztof Pranczk(2020)](https://labs.f-secure.com/blog/n1ql-injection-kind-of-sql-injection-in-a-nosql-database/)
		* [nosqli](https://github.com/Charlie-belmer/nosqli)
			* NoSql Injection CLI tool, for finding vulnerable websites using MongoDB.
		* [NoSql Injection Cheatsheet - Nullsweep](https://nullsweep.com/nosql-injection-cheatsheet/)
	* **MeteorJS**
		* [Meteor Blind NoSQL Injection - Kert Ojasoo(2019)](https://medium.com/rangeforce/meteor-blind-nosql-injection-29211775cd01)
	* **MongoDB**
		* [Making Mongo Cry Attacking NoSQL for Pen Testers Russell Butturini](https://www.youtube.com/watch?v=NgsesuLpyOg)
		* [MongoDB: Typical Security Weaknesses in a NoSQL DB](http://blog.spiderlabs.com/2013/03/mongodb-security-weaknesses-in-a-typical-nosql-database.html)
		* [MongoDB Pentesting for Absolute Beginners](https://github.com/nixawk/pentest-wiki/blob/master/2.Vulnerability-Assessment/Database-Assessment/mongodb/MongoDB%20Pentesting%20for%20Absolute%20Beginners.pdf)
		* [A NoSQL Injection Primer (with Mongo) - Charlie Belmer(2020)](https://nullsweep.com/a-nosql-injection-primer-with-mongo/)
	- **Neo4j**
		* [Cypher Injection Cheat Sheet - pentester.land](https://pentester.land/blog/cypher-injection-cheatsheet/)
		* [Neo4jection: Secrets, Data, and Cloud Exploits - Nitay Bachrach(2023)](https://www.varonis.com/blog/neo4jection-secrets-data-and-cloud-exploits)
	* **Talks/Presentations/Videos**
		* [ Making Mongo Cry-Attacking NoSQL for Pen Testers - Russell Butturrini(Derbycon2014)](https://www.irongeek.com/i.php?page=videos/derbycon4/t408-making-mongo-cry-attacking-nosql-for-pen-testers-russell-butturini)
			* NoSQL databases continue to grow in popularity due to their scalability, dynamic data structures, ease of development and cloud readiness. As these types of databases become more prevalent, penetration testers need to understand how these databases work, how applications interact with them, and where the inherent weaknesses of NoSQL databases are. This presentation is targeted towards penetration testers and putting the theoretical attacks researchers have discussed into practice during a penetration testing engagement. It will discuss weaknesses with a particular focus on MongoDB and how to quickly and easily exploit them as well as where the high value targets in the system are post exploitation. NoSQLMap, a Python tool written for automatically stealing data from NoSQL database servers and web applications, will also be demoed. 
		* [Abusing NoSQL Databases - Ming Chow](https://www.youtube.com/watch?v=lcO1BTNh8r8)
			* [Slides](https://www.defcon.org/images/defcon-21/dc-21-presentations/Chow/DEFCON-21-Chow-Abusing-NoSQL-Databases.pdf)
			* The days of selecting from a few SQL database options for an application are over. There is now a plethora of NoSQL database options to choose from: some are better than others for certain jobs. There are good reasons why developers are choosing them over traditional SQL databases including performance, scalabiltiy, and ease-of-use. Unfortunately like for many hot techologies, security is largely an afterthought in NoSQL databases. This short but concise presentation will illustrate how poor the quality of security in many NoSQL database systems is. This presentation will not be confined to one particular NoSQL database system. Two sets of security issues will be discussed: those that affect all NoSQL database systems such as defaults, authentication, encryption; and those that affect specific NoSQL database systems such as MongoDB and CouchDB. The ideas that we now have a complicated heterogeneous problem and that defense-in-depth is even more necessary will be stressed. There is a common misconception that SQL injection attacks are eliminated by using a NoSQL database system. While specifically SQL injection is largely eliminated, injection attack vectors have increased thanks to JavaScript and the flexibility of NoSQL databases. This presentation will present and demo new classes of injection attacks. Attendees should be familiar with JavaScript and JSON.
	* **Papers**
		* [No SQL, No Injection? - Examining NoSQL Security - Aviv Ron, Alexandra Shulman-Peleg, Emanuel Bronshtein](https://arxiv.org/pdf/1506.04082.pdf)
			* NoSQL data storage systems have become very popular due to their scalability and ease of use. This paper examines the maturity of security measures for NoSQL databases, addressing their new query and access mechanisms. For example the emergence of new query formats makes the old SQL injection techniques irrelevant, but are NoSQL databases immune to injection in general? The answer is NO. Here we present a few techniques for attacking NoSQL databases such as injections and CSRF. We analyze the source of these vulnerabilities and present methodologies to mitigate the attacks. We show that this new vibrant technological area lacks the security measures and awareness which havedeveloped over the years in traditional RDBMSSQL systems.
	* **Tools**	
		* [Nosql-Exploitation-Framework](https://github.com/torque59/Nosql-Exploitation-Framework)
			* A FrameWork For NoSQL Scanning and Exploitation Framework
		* [NoSQL Injector](https://github.com/Charlie-belmer/nosqli)
			* NoSQL scanner and injector.
- **Apache Pinot**
	* [Apache Pinot SQLi and RCE Cheat Sheet - Ben Caller(2022)](https://blog.doyensec.com/2022/06/09/apache-pinot-sqli-rce.html)
* **DB2**
	* [DB2 SQL injection cheat sheet](https://securityetalii.es/2012/05/20/db2-sql-injection-cheat-sheet/)
* **MongoDB**
	* **101**
		* [Intro to Hacking Mongo DB - SecuritySynapse](https://securitysynapse.blogspot.com/2015/07/intro-to-hacking-mongo-db.html)
		* [Attacking MongoDB - ZeroNights2012](http://blog.ptsecurity.com/2012/11/attacking-mongodb.html)
		* [MongoDB Injection - How To Hack MongoDB](http://www.technopy.com/mongodb-injection-how-to-hack-mongodb-html/)
		* [Hacking NodeJS and MongoDB - websecurify](https://blog.websecurify.com/2014/08/hacking-nodejs-and-mongodb.html)
	* **Tools**
		* [mongoaudit](https://github.com/stampery/mongoaudit)
			* mongoaudit is a CLI tool for auditing MongoDB servers, detecting poor security settings and performing automated penetration testing.
		* [mongot](https://github.com/dstours/mongot)
			* mongot makes it easy to extract data from open MongoDB's. By specifying an IP/port with the -d/-p parameters, mongot will connect to an open MongoDB, display any identified database names, collections, and a small sample of data in each.
* **MS-SQL**
	* [Pen test and hack microsoft sql server (mssql)](http://travisaltman.com/pen-test-and-hack-microsoft-sql-server-mssql/)
	* [Advanced MSSQL Injection Tricks - PT Swarm Team(2020)](https://swarm.ptsecurity.com/advanced-mssql-injection-tricks/)
* **MySQL**
	* **101**
		* [](https://dev.mysql.com/doc/refman/8.0/en/select.html)
	* **Articles/Blogposts/Writeups**
		* [MySQL UDF Exploitation](https://osandamalith.com/2018/02/11/mysql-udf-exploitation/)
* **Oracle SQL**
	* **101**
		* [Oracle SQL Injection Guides & Whitepapers](https://haiderm.com/oracle-sql-injection-guides-and-whitepapers/)
	* **Articles/Blogposts/Writeups**
* **PostgreSQL**
	* **101**
		* [PostgreSQL Documentation: Ch4 SQL Syntax: Lexical Structure](https://www.postgresql.org/docs/9.0/sql-syntax-lexical.html)
	* **Articles/Blogposts/Writeups**
		* [PostgreSQL Pass The Hash protocol design weakness](https://hashcat.net/misc/postgres-pth/postgres-pth.pdf)
		* [Ultimate Guide: PostgreSQL Pentesting - Shlok Yadav(2020)](https://medium.com/@lordhorcrux_/ultimate-guide-postgresql-pentesting-989055d5551e)
		* [A Penetration Tester’s Guide to PostgreSQL - David Hayter(2017)](https://medium.com/@cryptocracker99/a-penetration-testers-guide-to-postgresql-d78954921ee9)
		* [Attacking Dell Foglight Server - infosecaddicts.com(2017)](https://infosecaddicts.com/attacking-dell-foglight-server/)
		* [Postgres “unsupported frontend protocol” mystery - Greg Sabino Mullane(2015)](https://www.endpoint.com/blog/2015/05/28/postgres-unsupported-frontend-protocol)
		* [SQL Injection Double Uppercut :: How to Achieve Remote Code Execution Against PostgreSQL - Steven Seeley](https://srcincite.io/blog/2020/06/26/sql-injection-double-uppercut-how-to-achieve-remote-code-execution-against-postgresql.html)
* **Ruby on Rails(ActiveRecord)**
	* [rails-sqli.org](https://rails-sqli.org/)
* **Tools**
	* [sqlmap](https://github.com/sqlmapproject/sqlmap)
	* [jSQL Injection](https://github.com/ron190/jsql-injection)
		* jSQL Injection is a Java application for automatic SQL database injection.
	* [mongoaudit](https://github.com/stampery/mongoaudit)
	* [Laduanum](http://laudanum.sourceforge.net/)
		* “Laudanum is a collection of injectable files, designed to be used in a pentest when SQL injection flaws are found and are in multiple languages for different environments.They provide functionality such as shell, DNS query, LDAP retrieval and others.”
	* [GraFScaN](https://github.com/grafscan/GraFScaN)
	* [Albatar](https://github.com/lanjelot/albatar)
		* Albatar is a SQLi exploitation framework in Python
	* [Sample Databases](https://github.com/tjcim/sample_dbs)
		* Databases with sample data for testing

----------------------------------------------------------------------------------------------------------------


### <a name="pta">Path Traversal Attacks</a>
* **101**
	* [Exploiting PHP File Inclusion – Overview](https://websec.wordpress.com/2010/02/22/exploiting-php-file-inclusion-overview/)
* **Articles/Blogposts/Writeups**
	* [Exploiting Blind File Reads / Path Traversal Vulnerabilities on Microsoft Windows Operating Systems - soffensive](https://www.soffensive.com/2018/06/exploiting-blind-file-reads-path.html)
	* [RCE using Path Traversal - inc0gbyt3](https://incogbyte.github.io/pathtraversal/)
	* [Zip Slip Vulnerability - snyk.io](https://snyk.io/research/zip-slip-vulnerability)
	* [Exploiting Blind File Reads / Path Traversal Vulnerabilities on Microsoft Windows Operating Systems - soffensive](http://www.soffensive.com/2018/06/exploiting-blind-file-reads-path.html)
	* [Targeting a macOS Application? Update Your Path Traversal Lists - James Sebree](https://medium.com/tenable-techblog/targeting-a-macos-application-update-your-path-traversal-lists-a1055959a75a)
	* [The Path for Testing Path Traversal Vulnerabilities with Python - Mazin Ahmed(2020)](https://mazinahmed.net/blog/testing-for-path-traversal-with-python/)
	* [Practical Client Side Path Traversal Attacks - mr medi(2022)](https://mr-medi.github.io/research/2022/11/04/practical-client-side-path-traversal-attacks.html)
* **Tools**
	* [dotdotpwn](https://github.com/wireghoul/dotdotpwn)
		* It's a very flexible intelligent fuzzer to discover traversal directory vulnerabilities in software such as HTTP/FTP/TFTP servers, Web platforms such as CMSs, ERPs, Blogs, etc.


----------------------------------------------------------------------------------------------------------------


### <a name="ppa"></a>Prototype Pollution Attack
- **101**
	* [Maintainable JavaScript: Don’t modify objects you don’t own - Nicholas C. Zakas](https://humanwhocodes.com/blog/2010/03/02/maintainable-javascript-dont-modify-objects-you-down-own/)
	* [What is Prototype Pollution? - Changhui Xu](https://codeburst.io/what-is-prototype-pollution-49482fc4b638)
	* [What is prototype pollution and why is it such a big deal? - Dani Akash](https://medium.com/node-modules/what-is-prototype-pollution-and-why-is-it-such-a-big-deal-2dd8d89a93c)
	* [JavaScript Prototype Pollution - Part 1 - HTTPVoid(2020)](https://www.youtube.com/watch?v=J3MIOIqvV8w)
	* [Prototype pollution: The dangerous and underrated vulnerability impacting JavaScript applications - Ben Dickson(2021)](https://portswigger.net/daily-swig/prototype-pollution-the-dangerous-and-underrated-vulnerability-impacting-javascript-applications)
	* [New ways to alert: prototype pollution - Sergey Bobrov, Nikita Stupin(2021)](http://archive.volgactf.ru/volgactf_2021/slides/VolgaCTF_2021_Stupin_Bobrov.pdf)
	* [The Complete Guide to Prototype Pollution Vulnerabilities - Daniel Elkabes(2021)](https://www.mend.io/resources/blog/prototype-pollution-vulnerabilities/)
	* [What is prototype poisoning? Prototype bugs explained! - Anton Linné, Christoffer Jerkeby(2022)](https://www.jerkeby.se/newsletter/posts/prototype-poisoning/)
	* [Prototype Pollution in Python - abdulrah33m(2023)](https://blog.abdulrah33m.com/prototype-pollution-in-python/)
- **Client-Side**
	* [Client-Side Prototype Pollution](https://github.com/BlackFan/client-side-prototype-pollution)
		* "In this repository, I am trying to collect examples of libraries that are vulnerable to Prototype Pollution due to document.location parsing and useful script gadgets that can be used to demonstrate the impact."
- **JavaScript**
	- **Articles/Blogposts/Writeups**
		* [Prototype Pollution Affecting jquery package, versions <3.4.0 - snyk.io](https://snyk.io/vuln/SNYK-JS-JQUERY-174006)
		* [After three years of silence, a new jQuery prototype pollution vulnerability emerges once again - Liran Tal](https://snyk.io/blog/after-three-years-of-silence-a-new-jquery-prototype-pollution-vulnerability-emerges-once-again/)
		* [Prototype pollution attack (lodash) - holyvier](https://hackerone.com/reports/310443)
		* [Inheritance and the prototype chain - MozillaDevNetwork](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Inheritance_and_the_prototype_chain)
		* [Prototype pollution attack through jQuery $.extend - Asger Feldthaus(HackerOne)](https://hackerone.com/reports/454365)
		* [Analysis and Exploitation of Prototype Pollution attacks on NodeJs - Nullcon HackIM CTF web 500 writeup - Anirudh Anand](https://blog.0daylabs.com/2019/02/15/prototype-pollution-javascript/)
		* [Prototype Pollution - Michal Bentkowski](https://slides.com/securitymb/prototype-pollution-in-kibana/#/)
		* [Exploiting prototype pollution – RCE in Kibana (CVE-2019-7609) - Michal Bentkowski](https://research.securitum.com/prototype-pollution-rce-kibana-cve-2019-7609/)
		* [Prototype pollution – and bypassing client-side HTML sanitizers - Michał Bentkowski(2020)](https://research.securitum.com/prototype-pollution-and-bypassing-client-side-html-sanitizers/)
		* ["A tale of making internet pollution free"- Exploiting Client-Side Prototype Pollution in the wild - s1r1us](https://blog.s1r1us.ninja/research/PP)
		* [AST Injection, Prototype Pollution to RCE - POSIX(2020)](https://blog.p6.is/AST-Injection/)
			* This article describes how to trigger RCE in two well-known template engines, using a new technique called AST Injection.
		* [Hunting for Prototype Pollution and it’s vulnerable code on JS libraries - kleiton0x7e(2021)](https://infosecwriteups.com/hunting-for-prototype-pollution-and-its-vulnerable-code-on-js-libraries-5bab2d6dc746)- **Python**
		* [Prototype Pollution in Flask - lanmaster53(2023)](https://www.lanmaster53.com/2023/02/01/prototype-polution-in-flask/)
		* [Server side prototype pollution, how to detect and exploit - yeswehack](https://blog.yeswehack.com/talent-development/server-side-prototype-pollution-how-to-detect-and-exploit/)
		* [Hit the Ground Running with Prototype Pollution - Isaac Burton(2023)](https://www.blackhillsinfosec.com/hit-the-ground-running-with-prototype-pollution/)
		* [Detecting Server-Side Prototype Pollution - Daniel Thatcher(2023)](https://www.intruder.io/research/server-side-prototype-pollution)
		* [Server-side prototype pollution: Black-box detection without the DoS - Gareth Hayes(2023)](https://portswigger.net/research/server-side-prototype-pollution)
		* [EJS - Server Side Prototype Pollution gadgets to RCE - ](https://mizu.re/post/ejs-server-side-prototype-pollution-gadgets-to-rce)
- **Presentations, Talks, Videos**
	* [Prototype pollution attack - HoLyVieR](https://github.com/HoLyVieR/prototype-pollution-nsec18)
		* "Content released at NorthSec 2018 for my talk on prototype pollution"
		* [Slides](https://github.com/HoLyVieR/prototype-pollution-nsec18/tree/master/slides)
		* [Paper](https://github.com/HoLyVieR/prototype-pollution-nsec18/blob/master/paper/JavaScript_prototype_pollution_attack_in_NodeJS.pdf)
	* [Hacking Modern Web Apps with RCE and Prototype Pollution - Abraham Aranguren(2020)](https://www.youtube.com/watch?v=0kVbvKjnGY4&list=PL7ZDZo2Xu333whl0HqUuWnooebiJNz23A&index=4)
	* [Very creative way to turn Prototype Pollution into RCE in kibana - Bug Bounty Reports Explained - gregxsunday(2020)](https://www.youtube.com/watch?v=KVDOIFeRaPQ)
		* This video is an explanation of prototype pollution vulnerability in kibana that, in a super cool and very creative way, was used to achieve remote code execution in kibana software.
	* [Prototype Pollution Attack in NodeJS Application - Olivier Arteau(NorthSec18)](https://github.com/HoLyVieR/prototype-pollution-nsec18/blob/master/paper/JavaScript_prototype_pollution_attack_in_NodeJS.pdf)	
	* [Prototype Pollution Attack Explained - CyberSecurityTV](https://www.youtube.com/watch?v=__65_GFERKs)
		* Parameter pollution is a very old attack however I feel like it is underrated. 20+ JS libraries were vulnerable to this attack including JQuery. This is an important attack to learn for any web application pentester. Few automated tools can detect this however, it does require manual inspection.
	* [Using Chromedp to Hunt for Prototype Pollution - @TomNomNomDotCom(NahamCon2021)](https://www.youtube.com/watch?v=Gv1nK6Wj8qM)
		* Prototype pollution is fairly well known, but being a client-side issue it can be difficult to look for at scale. Let's write a bit of Go using the chromedp package to solve that problem!
- **Papers**
	* [Silent Spring: Prototype Pollution Leads to Remote Code Execution in Node.js - Mikhail Shcherbakov, Musard Balliu, Cristian-Alexandru Staicu(2022)](https://arxiv.org/pdf/2207.11171.pdf)
		* In this paper, we set out to study the problem in a holistic way, from the detection of prototype pollution to detection of gadgets, with the ambitious goal of finding end-to-end exploits beyond DoS, in full-fledged Node.js applications. We build the first multi-staged framework that uses multi- label static taint analysis to identify prototype pollution in Node.js libraries and applications, as well as a hybrid ap- proach to detect universal gadgets, notably, by analyzing the Node.js source code. We implement our framework on top of GitHub’s static analysis framework CodeQL to find 11 universal gadgets in core Node.js APIs, leading to code exe- cution. Furthermore, we use our methodology in a study of 15 popular Node.js applications to identify prototype pollutions and gadgets. We manually exploit eight RCE vulnerabilities in three high-profile applications such as NPM CLI, Parse Server, and Rocket.Chat. Our results provide alarming evi- dence that prototype pollution in combination with powerful universal gadgets lead to RCE in Node.js.
- **Tools**
	* [client-side-prototype-pollution](https://github.com/BlackFan/client-side-prototype-pollution)
		* "In this repository, I am trying to collect examples of libraries that are vulnerable to Prototype Pollution due to `document.location` parsing and useful script gadgets that can be used to demonstrate the impact."
	* [PPScan](https://github.com/msrkp/PPScan)
		* Client Side Prototype Pollution Scanner
		* [protoscan](https://github.com/KathanP19/protoscan)
			* Prototype Pollution Scanner made in Golang, it was actually made by @tomnomnom in NahamCon2021


----------------------------------------------------------------------------------------------------------------


### <a name="rfd"></a>Reflected File Download
* **101**
* **Articles/Blogposts/Writeups**
	* [Technique of the Week: Reflected File Download (Intro) - uid0(2021)](https://web.archive.org/web/0/https://0x80dotblog.wordpress.com/2021/07/31/technique-of-the-week-reflected-file-download-intro/)
* **Tools**
* **Talks/Presentations/Videos**
	* [Reflected File Download - A New Web Attack Vector - BHEU 2014](https://www.youtube.com/watch?v=dl1BJUNk8V4)
		* Skip to 19:24 for technical content
	* [Paper](https://drive.google.com/file/d/0B0KLoHg_gR_XQnV4RVhlNl96MHM/view)


----------------------------------------------------------------------------------------------------------------


### <a name="rpo"></a>Relative Path Overwrite
* **101**
	* [Relative Path Overwrite Explanation/Writeup](http://www.thespanner.co.uk/2014/03/21/rpo/)
		* RPO (Relative Path Overwrite) is a technique to take advantage of relative URLs by overwriting their target file. To understand the technique we must first look into the differences between relative and absolute URLs. An absolute URL is basically the full URL for a destination address including the protocol and domain name whereas a relative URL doesn’t specify a domain or protocol and uses the existing destination to determine the protocol and domain.
* **Articles/Blogposts/Writeups**
	* [A few RPO exploitation techniques - Takeshi Terada](https://www.mbsd.jp/Whitepaper/rpo.pdf)
	* [Non-Root-Relative Path Overwrite (RPO) in IIS and .Net applications - soroush.techproject](https://soroush.secproject.com/blog/tag/non-root-relative-path-overwrite/)
* **Talks/Presentations/Videos**
* **Papers**
	* [Understanding and Mitigating theSecurity Risks of ContentInclusion in Web Browsers - Sajjad Arshad(2020)](https://arxiv.org/pdf/2001.03643.pdf)
		* In this thesis, I propose novel research into understanding and mitigatingthe security risks of content inclusion in web browsers to protect website pub-lishers as well as their users. First, I introduce an in-browser approach calledExcisionto automatically detect and block malicious third-party content in-clusions as web pages are loaded into the user’s browser or during the execu-tion of browser extensions. Then, I proposeOriginTracer, an in-browserapproach to highlight extension-based content modification of web pages. Fi-1 nally, I present the first in-depth study of style injection vulnerability usingRPO and discuss potential countermeasures
* **General**
* **Tools**
* **Miscellaneous**


----------------------------------------------------------------------------------------------------------------


### <a name="serialization">(De-)Serialization Attacks</a>
- **101**
	* [The Anatomy of Deserialization Attacks - Bursa Demir(2020)](https://www.cobalt.io/blog/the-anatomy-of-deserialization-attacks)
- **General**
	* **Articles/Blogposts/Writeups**
	* **Talks/Presentations/Videos**
		* [Pentesting J2EE - Marc Schönefeld(BlackHat 2006)](https://www.blackhat.com/presentations/bh-federal-06/BH-Fed-06-Schoenefeld-up.pdf)
		* [History of Deserialization: RCE for the modern web applications - Philippe Arteau(2019)](https://gosecure.github.io/presentations/2019-04-29_atlseccon/History_of_Deserialization_v2.2.pdf)
		* [Friday the 13th JSON Attacks - Alvaro Muñoz, Oleksandr Mirosh(BHUSA17)](https://www.blackhat.com/docs/us-17/thursday/us-17-Munoz-Friday-The-13th-JSON-Attacks-wp.pdf)
			* "In this paper, we will focus on JSON libraries and we will analyze which ones could allow arbitrary code execution upon deserialization of untrusted data. We will also have a look at .NET world by reviewing existing research on this field and completing it with updated list of vulnerable formatters and proof of concept gadgets to attack them. To finish, we will extend the research on JSON serialization libraries and .NET formatters into any serialization format available. We will provide guidance to find out whether it could be attacked and how to attack it. Where possible, we will also provide mitigation advice to help avoid vulnerable configurations that could turn your serialization library vulnerable."
		* [Json Deserialization Exploitation: RCE by Design - ?(2018)](https://owasp.org/www-pdf-archive/Marshaller_Deserialization_Attacks.pdf.pdf)
- **Java**
	- **101**
		* [Introduction to Java Serialization - baeldung(2021)](https://www.baeldung.com/java-serialization)
		* [Everything You Need to Know About Java Serialization Explained - Naresh Joshi(2019)](https://dzone.com/articles/what-is-serialization-everything-about-java-serial)
	* **Articles/Blogposts/Writeups**
		* [Java Deserialization Security FAQ - christian-schneider.net](https://christian-schneider.net/JavaDeserializationSecurityFAQ.html)
		* [Detecting deserialization bugs with DNS exfiltration - Philippe Arteau(2017)](http://gosecure.net/2017/03/22/detecting-deserialization-bugs-with-dns-exfiltration/)
		* [Reliable discovery and Exploitation of Java Deserialization vulns(2017)](https://techblog.mediaservice.net/2017/05/reliable-discovery-and-exploitation-of-java-deserialization-vulnerabilities/)
		* [What Do WebLogic, WebSphere, JBoss, Jenkins, OpenNMS, and Your Application Have in Common? This Vulnerability. - breenmachine(2015)](https://foxglovesecurity.com/2015/11/06/what-do-weblogic-websphere-jboss-jenkins-opennms-and-your-application-have-in-common-this-vulnerability/)
		* [Fastjson: exceptional deserialization vulnerabilities - Peter Stockli(2020)](https://www.alphabot.com/security/blog/2020/java/Fastjson-exceptional-deserialization-vulnerabilities.html)
		* [Liferay Portal JSON Web Service RCE Vulnerabilities - Markus Wulftange(2020)](https://codewhitesec.blogspot.com/2020/03/liferay-portal-json-vulns.html)
		* [Deserialized Double Dirty - John Skipper(2018)](https://www.coalfire.com/the-coalfire-blog/deserialized-double-dirty)
		* [Detecting deserialization bugs with DNS exfiltration - Philippe Arteau(2017)](https://www.gosecure.net/blog/2017/03/22/detecting-deserialization-bugs-with-dns-exfiltration/)
		* [Testing and exploiting Java Deserialization in 2021 - AFINE(2021)](https://blog.afine.com/testing-and-exploiting-java-deserialization-in-2021-e762f3e43ca2?gi=21a57033a29d)
		* [Jackson gadgets - Anatomy of a vulnerability - Andrea Brancaleoni(2019)](https://blog.doyensec.com/2019/07/22/jackson-gadgets.html)
		* [Unexpected Deserialization pt.1 - JMS - SilentSignal(2021)](https://blog.silentsignal.eu/2020/08/17/unexpected-deserialization-pt-1-jms/)
		* [Demystifying Insecure Deserialisation on JSF Application - Dhiyaneshwaran(2021)](https://dhiyaneshgeek.github.io/web/security/2021/05/08/demystifying-insecure-deserialisation-on-JSF-application/)
		* [Finding gadgets like it's 2015: part 1 - Hugo Vincent(2021)](https://www.synacktiv.com/en/publications/finding-gadgets-like-its-2015-part-1.html)
		* [Finding gadgets like it's 2022 - Hugo Vincent(2022)](https://www.synacktiv.com/en/publications/finding-gadgets-like-its-2022.html)
	- **General**
		* [Java-Deserialization-Cheat-Sheet](https://github.com/GrrrDog/Java-Deserialization-Cheat-Sheet)
			* A cheat sheet for pentesters about Java Native Binary Deserialization vulnerabilities
	- **Presentations/Talks/Videos**
		* [Pwning Your Java Messaging With De- serialization Vulnerabilities](https://www.blackhat.com/docs/us-16/materials/us-16-Kaiser-Pwning-Your-Java-Messaging-With-Deserialization-Vulnerabilities-wp.pdf)
		* [Marshalling Pickles - Chris Frohoff, Gabe Lawrence(AppSecCali 2015)](https://frohoff.github.io/appseccali-marshalling-pickles/)
			* [Slides](https://github.com/frohoff/appseccali-marshalling-pickles)
			* Object serialization technologies allow programs to easily convert in-memory objects to and from various binary and textual data formats for storage or transfer – but with great power comes great responsibility, because deserializing objects from untrusted data can ruin your day. We will look at historical and modern vulnerabilities across different languages and serialization technologies, including Python, Ruby, and Java, and show how to exploit these issues to achieve code execution. We will also cover some strategies to protect applications from these types of attacks.
		* [Exploiting Deserialization Vulnerabilities in Java - Matthis Kaiser(2015)](https://www.youtube.com/watch?v=VviY3O-euVQ)
			* Deserialization vulnerabilities in Java are lesser known and exploited (compared to unserialize() in PHP). This talk will give insights how this bug class can be turned into serverside Remote Code Execution. Details and a demo will be given for one of my patched vulnerabilities (CVE-2015-6576, Atlassian Bamboo RCE).
		* [Deserialize My Shorts Or How I Learned to Start Worrying and Hate Java Object Deserialization - Chris Frohoff, Gabe Lawrence](https://frohoff.github.io/owaspsd-deserialize-my-shorts/)
			* [Slides](https://www.slideshare.net/frohoff1/deserialize-my-shorts-or-how-i-learned-to-start-worrying-and-hate-java-object-deserialization)
			* Object deserialization is an established but poorly understood attack vector in applications that is disturbingly prevalent across many languages, platforms, formats, and libraries. In January 2015 at AppSec California, Chris Frohoff and Gabe Lawrence gave a talk on this topic, covering deserialization vulnerabilities across platforms, the many forms they take, and places they can be found. It covered, among other things, somewhat novel techniques using classes in commonly used libraries for attacking Java serialization that were subsequently released in the form of the ysoserial tool. Few people noticed until late 2015, when other researchers used these techniques/tools to exploit well known products such as Bamboo, WebLogic, WebSphere, ApacheMQ, and Jenkins, and then services such as PayPal. Since then, the topic has gotten some long-overdue attention and great work is being done by many to improve our understanding and developer awareness on the subject. This talk will review the details of Java deserialization exploit techniques and mitigations, as well as report on some of the recent (and future) activity in this area.
		* [Automated Discovery of Deserialization Gadget Chains - Ian Haken(Defcon26)](https://www.youtube.com/watch?v=wPbW6zQ52w8)
		* [In-Memory Data Grid Applications: Finding Common Java Deserialization Vulnerabilities with CodeQL - Man Yue Mo(2019)](https://securitylab.github.com/research/in-memory-data-grid-vulnerabilities)
		* [Pwning Your Java Messaging With Deserialization Vulnerabilities - Matthias Kaiser(BHUSA2016)](https://www.blackhat.com/docs/us-16/materials/us-16-Kaiser-Pwning-Your-Java-Messaging-With-Deserialization-Vulnerabilities.pdf
		* [Oracle Java Deserialization Vulnerabilities - Stephen Kost, Phil Reimann(2016)](https://www.youtube.com/watch?v=oZPZLiY2PeA)
			* Java deserialization is a class of security vulnerabilities that can result in server-side remote code execution (RCE). As many Oracle products are based on Java, deserialization bugs are found in many Oracle environments especially those using Oracle WebLogic, Oracle Fusion Middleware, and Oracle E-Business Suite. As an example, in November 2015 Oracle released an out-of-cycle security fix (CVE-2015-4852) in order to fix a deserialization bug in Oracle WebLogic. This education webinar provides an understanding of Java deserialization vulnerabilities, the potential impact for Oracle environments, and strategies to protect an Oracle environment from this class of security vulnerabilities.
		* [Defending against Java Deserialization Vulnerabilities - Luca Carettoni(2016)](https://www.ikkisoft.com/stuff/Defending_against_Java_Deserialization_Vulnerabilities.pdf)
		* [Deserialization: what, how and why [not] - Alexei Kojenov(AppSecUSA2018)](https://www.youtube.com/watch?v=t-zVC-CxYjw)
			* Insecure deserialization was recently added to OWASP's list of the top 10 most critical web application security risks, yet it is by no means a new vulnerability category. For years, data serialization and deserialization have been used in applications, services and frameworks, with many programming languages supporting them natively. Deserialization got more attention recently as a potential vehicle to conduct several types of attacks: data tampering, authentication bypass, privilege escalation, various injections and, ultimately, remote code execution. Two prominent vulnerabilities in Apache Commons and Apache Struts, both allowing remote code execution, also contributed to raising awareness of this risk. We will discuss how data serialization and deserialization are used in software, the dangers of deserializing untrusted input, and how to avoid insecure deserialization vulnerabilities. The presentation will contain several code examples with live demos of bypassing security controls due to incorrect deserialization. The examples and demos will use Java and its native serialization, but the techniques can be extrapolated to other languages and formats.
		* [Java Serialization security issues - Erno Jeges - OWASP Bay Area(2018)](https://www.youtube.com/watch?v=uur5B0rFMkQ)
			* In this short talk, we'll take a look at the various security issues coming from deserializing untrusted data in Java: information disclosure, denial of service, and even code execution. We'll examine these issues through live demonstrations with step-by-step explanations of what can go wrong – and how. Most importantly, we'll discuss several best practices and countermeasures you can use as a developer to protect yourself from these issues – or prevent them from affecting you in the first place.	
		* [Deserialization: what, how and why [not] - Alexei Kojenov(AppSec USA2018)](https://www.youtube.com/watch?v=t-zVC-CxYjw)
			* [Slides](https://drive.google.com/file/d/1o8VPE4nwNLb9cAYfG-3gM4WR4CY7FwoT/view)
			* [Code](https://github.com/kojenov/serial)
			* Insecure deserialization was recently added to OWASP's list of the top 10 most critical web application security risks, yet it is by no means a new vulnerability category. For years, data serialization and deserialization have been used in applications, services and frameworks, with many programming languages supporting them natively. Deserialization got more attention recently as a potential vehicle to conduct several types of attacks: data tampering, authentication bypass, privilege escalation, various injections and, ultimately, remote code execution. Two prominent vulnerabilities in Apache Commons and Apache Struts, both allowing remote code execution, also contributed to raising awareness of this risk. We will discuss how data serialization and deserialization are used in software, the dangers of deserializing untrusted input, and how to avoid insecure deserialization vulnerabilities. The presentation will contain several code examples with live demos of bypassing security controls due to incorrect deserialization. The examples and demos will use Java and its native serialization, but the techniques can be extrapolated to other languages and formats.
		* [Marshalling Pickles - Chris Frohoff & Gabriel Lawrence(OWASPAppSec California2015)](https://www.youtube.com/watch?v=KSA7vUkXGSg)
			* Object serialization technologies allow programs to easily convert in-memory objects to and from various binary and textual data formats for storage or transfer – but with great power comes great responsibility, because deserializing objects from untrusted data can ruin your day. We will look at historical and modern vulnerabilities across different languages and serialization technologies, including Python, Ruby, and Java, and show how to exploit these issues to achieve code execution. We will also cover some strategies to protect applications from these types of attacks.
		* [Automated Discovery of Deserialization Gadget Chains - Ian Haken(Defcon26)](https://www.youtube.com/watch?v=wPbW6zQ52w8)
			* [Slides](https://i.blackhat.com/us-18/Thu-August-9/us-18-Haken-Automated-Discovery-of-Deserialization-Gadget-Chains.pdf)
		* [New Exploit Technique In Java Deserialization Attack - Yang Zhang, Yongtao Wang, Keyi Li, Kunzhe Chai(BHEU2019)](https://www.youtube.com/watch?v=Lv9BC_bYaI8)
			* In our depth research, we analyzed more than 10000+ Java third-party libraries and found many cases which can be exploited in real-world attack scenarios. In this talk, we will bat around the principle and exploit technique of these vulnerabilities. Also, we will present how to pwn target server by our new exploit technique. It can not only improve the effect of java deserialization vulnerability but also enhance other Java security issues impact, and we will discuss profound impacts of the attack vector in the java security field.
	* **Papers**
		* [Java Unmarshaller Security - Turning your data into code execution](https://www.github.com/mbechler/marshalsec/blob/master/marshalsec.pdf?raw=true)
			* This paper presents an analysis, including exploitation details, of various Java open-source marshalling libraries that allow(ed) for unmarshalling of arbitrary, attacker supplied, types and shows that no matter how this process is performed and what implicit constraints are in place it is prone to similar exploitation techniques.
			* tool from the above paper: [marshalsec](https://github.com/mbechler/marshalsec/)
	* **Tools**
		* [Break Fast Serial](https://github.com/GoSecure/break-fast-serial)
			* A proof of concept that demonstrates asynchronous scanning for Java deserialization bugs
		* [ysoserial](https://github.com/frohoff/ysoserial)
		* [JMET](https://github.com/matthiaskaiser/jmet)
			* JMET was released at Blackhat USA 2016 and is an outcome of Code White's research effort presented in the talk "Pwning Your Java Messaging With Deserialization Vulnerabilities". The goal of JMET is to make the exploitation of the Java Message Service (JMS) easy. In the talk more than 12 JMS client implementations where shown, vulnerable to deserialization attacks. The specific deserialization vulnerabilities were found in ObjectMessage implementations (classes implementing javax.jms.ObjectMessage).
		* [GadgetProbe](https://github.com/BishopFox/GadgetProbe)
			* GadgetProbe takes a wordlist of Java classes, outputs serialized DNS callback objects, and reports what's lurking in the remote classpath.
			* [Blogpost](https://know.bishopfox.com/research/gadgetprobe)
		* [marshalsec](https://github.com/mbechler/marshalsec)
			* This paper presents an analysis, including exploitation details, of various Java open-source marshalling libraries that allow(ed) for unmarshalling of arbitrary, attacker supplied, types and shows that no matter how this process is performed and what implicit constraints are in place it is prone to similar exploitation techniques.
		* [QLinspector](https://github.com/synacktiv/QLinspector)
			* Finding Java gadget chains with CodeQL. 
		* [SerializationDumper](https://github.com/NickstaDB/SerializationDumper)
			* A tool to dump and rebuild Java serialization streams and Java RMI packet contents in a more human readable form. The tool does not deserialize the stream (i.e. objects in the stream are not instantiated), so it does not require access to the classes that were used in the stream*. This tool was developed to support research into Java deserialization vulnerabilities after spending many hours manually decoding raw serialization streams to debug code!
	- **Exploits**
		* [SerialKiller: Bypass Gadget Collection](https://github.com/pwntester/SerialKillerBypassGadgetCollection)
			* Collection of Bypass Gadgets that can be used in JVM Deserialization Gadget chains to bypass "Look-Ahead ObjectInputStreams" desfensive deserialization.
		* [Serianalyzer](https://github.com/mbechler/serianalyzer)
			* A static byte code analyzer for Java deserialization gadget research
		* [Java Deserialization Exploits](https://github.com/CoalfireLabs/java_deserialization_exploits)
			* A collection of Java Deserialization Exploits
		* [Java Deserialization Exploits](https://github.com/Coalfire-Research/java-deserialization-exploits)
			* A collection of curated Java Deserialization Exploits
- **.NET**
	* **Articles/Blogposts/Writeups**
		* [.NET Serialization: Detecting and defending vulnerable endpoints - Alvaro Munoz](https://speakerdeck.com/pwntester/dot-net-serialization-detecting-and-defending-vulnerable-endpoints)
		* [ASP.NET resource files (.RESX) and deserialisation issues - Soroush Dalili](https://www.nccgroup.trust/uk/about-us/newsroom-and-events/blogs/2018/august/aspnet-resource-files-resx-and-deserialisation-issues/)
		* [RCEVIL.NET: A Super Serial Story - Jared McLaren(BSides Iowa2019)](https://illuminopi.com/assets/files/BSidesIowa_RCEvil.net_20190420.pdf)
		* [HITCON 2018: Why so Serials? Write-up - cyku.tw](https://cyku.tw/ctf-hitcon-2018-why-so-serials/)
		* [HITCON CTF 2018 - Why so Serials? Writeup - Orange](https://xz.aliyun.com/t/3019)
	- **Talks/Presentations**
		* [.NET Serialization: Detecting and defending vulnerable endpoints - Alvaro Munez(LocoMocoSec2018)](https://www.youtube.com/watch?v=qDoBlLwREYk&list=PLwvifWoWyqwqkmJ3ieTG6uXUSuid95L33&index=9)
			* 2016 was the year of Java deserialization apocalypse. Although Java Deserialization attacks were known for years, the publication of the Apache Commons Collection Remote Code Execution gadget (RCE from now on) finally brought this forgotten vulnerability to the spotlight and motivated the community to start finding and fixing these issues. .NET is next in line; formatters such as BinaryFormatter and NetDataContractSerializer are known to share similar mechanics which make them potentially vulnerable to similar RCE attacks. However, as we saw with Java before, the lack of RCE gadgets led some software vendors to not take this issue seriously. In this talk, we will analyze .NET serializers including third party JSON parsers for potential RCE vectors. We will provide real-world examples of vulnerable code and more importantly, we will review how these vulnerabilities were detected and fixed in each case.
		* [Friday the 13th: Attacking JSON - Alvaro Muñoz & Oleksandr Mirosh(AppSecUSA 2017)](https://www.youtube.com/watch?v=NqHsaVhlxAQ)
			* 2016 was the year of Java deserialization apocalypse. Although Java Deserialization attacks were known for years, the publication of the Apache Commons Collection Remote Code Execution (RCE from now on) gadget finally brought this forgotten vulnerability to the spotlight and motivated the community to start finding and fixing these issues. One of the most suggested solutions for avoiding Java deserialization issues was to move away from Java Deserialization altogether and use safer formats such as JSON. In this talk, we will analyze the most popular JSON parsers in both .NET and Java for potential RCE vectors. We will demonstrate that RCE is also possible in these libraries and present details about the ones that are vulnerable to RCE by default. We will also discuss common configurations that make other libraries vulnerable. In addition to focusing on JSON format, we will generalize the attack techniques to other serialization formats. In particular, we will pay close attention to several serialization formats in .NET. These formats have also been known to be vulnerable since 2012 but the lack of known RCE gadgets led some software vendors to not take this issue seriously. We hope this talk will change this. With the intention of bringing the due attention to this vulnerability class in .NET, we will review the known vulnerable formats, present other formats which we found to be vulnerable as well and conclude presenting several gadgets from system libraries that may be used to achieve RCE in a stable way: no memory corruption -- just simple process invocation. Finally, we will provide recommendations on how to determine if your code is vulnerable, provide remediation advice, and discuss alternative approaches.
		* [.NET Roulette: Exploiting Insecure Deserialization in Telerik UI - Caleb Gross(DerpCon2020)](https://www.youtube.com/watch?v=--6PiuvBGAU&list=PLCXnHhr5mRLzcvpFSj389dO7ro2spPLTe&index=7)
			* So you're pentesting a .NET application, and you notice the server is deserializing user input—great! You know this is bad in theory, but have no idea how to actually get a shell in time for the engagement. This talk will bring you up to speed on how .NET deserialization works and how to get shells on real applications. In this presentation, we'll dig into the internals of CVE-2019-18935, a deserialization vulnerability that allows RCE on the popular web UI suite Telerik UI for ASP.NET AJAX. After demonstrating how to exploit this issue step-by-step, you'll learn a hands-on approach to debugging a locally running ASP.NET application, quickly assessing the site's attack surface, and examining possible avenues for finding and exploiting insecure uses of deserialization. This talk is intended for penetration testers and security researchers who'd like to begin testing deserialization vulnerabilities in .NET software.
	- **Papers**
	- **Tools**
		* [YSoSerial.Net](https://github.com/pwntester/ysoserial.net)
			* ysoserial.net is a collection of utilities and property-oriented programming "gadget chains" discovered in common .NET libraries that can, under the right conditions, exploit .NET applications performing unsafe deserialization of objects. The main driver program takes a user-specified command and wraps it in the user-specified gadget chain, then serializes these objects to stdout. When an application with the required gadgets on the classpath unsafely deserializes this data, the chain will automatically be invoked and cause the command to be executed on the application host.
- **PHP**
	* See [the PHP section for PHP Specific attacks](#php)
	- **Articles/Blogposts/Writeups**
		* [Diving into unserialize() - Vickie Li](https://medium.com/swlh/diving-into-unserialize-3586c1ec97e)
		* [Diving into unserialize(): POP Chains](https://medium.com/@vickieli/diving-into-unserialize-pop-chains-35bc1141b69a)
		* [Diving into unserialize(): Magic Methods - Vickie Li](https://medium.com/swlh/diving-into-unserialize-magic-methods-386d41c1b16a)
	- **Tools**
		* [Insecure-Deserialization](https://github.com/raadfhaddad/Insecure-Deserialization/tree/master/Challenge)
- **Python**
	- **Articles/Blogposts/Writeups**
		* [Exploiting Python Deserialization Vulnerabilities](https://crowdshield.com/blog.php?name=exploiting-python-deserialization-vulnerabilities)
		* [Exploiting misuse of Python's "pickle"](https://blog.nelhage.com/2011/03/exploiting-pickle/)
		* [Python web frameworks and pickles - Nicolas Oberli](https://www.balda.ch/posts/2013/Jun/23/python-web-frameworks-pickle/)
		* [Remote Code Execution - Insecure Deserialization - @SecureCookie](https://secure-cookie.io/attacks/insecuredeserialization/)
	- **Talks**
			* [Marshalling Pickles - Chris Frohoff & Gabriel Lawrence(OWASPAppSec California2015)](https://www.youtube.com/watch?v=KSA7vUkXGSg)
				* Object serialization technologies allow programs to easily convert in-memory objects to and from various binary and textual data formats for storage or transfer – but with great power comes great responsibility, because deserializing objects from untrusted data can ruin your day. We will look at historical and modern vulnerabilities across different languages and serialization technologies, including Python, Ruby, and Java, and show how to exploit these issues to achieve code execution. We will also cover some strategies to protect applications from these types of attacks.
- **Ruby**
	- **Articles/Blogposts/Writeups**
		* [Ruby 2.x Universal RCE Deserialization Gadget Chain - Luke Jahnke(2018)](https://www.elttam.com/blog/ruby-deserialization/)
		* [Universal Deserialisation Gadget for Ruby 2.x-3.x - vakzz(2021)](https://devcraft.io/2021/01/07/universal-deserialisation-gadget-for-ruby-2-x-3-x.html)
		* [Rails 3.2.10 Remote Code Execution -  Hailey Somerville(2022)](https://github.com/haileys/old-website/blob/master/posts/rails-3.2.10-remote-code-execution.md)
		* [Ruby Deserialization - Gadget on Rails - httpvoid](https://github.com/httpvoid/writeups/blob/main/Ruby-deserialization-gadget-on-rails.md)
	- **Talks**
		* [Marshalling Pickles - Chris Frohoff & Gabriel Lawrence(OWASPAppSec California2015)](https://www.youtube.com/watch?v=KSA7vUkXGSg)
			* Object serialization technologies allow programs to easily convert in-memory objects to and from various binary and textual data formats for storage or transfer – but with great power comes great responsibility, because deserializing objects from untrusted data can ruin your day. We will look at historical and modern vulnerabilities across different languages and serialization technologies, including Python, Ruby, and Java, and show how to exploit these issues to achieve code execution. We will also cover some strategies to protect applications from these types of attacks.


----------------------------------------------------------------------------------------------------------------


### <a name="ssrf"></a>Server Side Request Forgery (SSRF)
- **101**
	* [CWE-918: Server-Side Request Forgery (SSRF)](https://cwe.mitre.org/data/definitions/918.html)
	* [What is Server Side Request Forgery (SSRF)?](https://www.acunetix.com/blog/articles/server-side-request-forgery-vulnerability/)
	* [What is the Server Side Request Forgery Vulnerability & How to Prevent It? - netsparker](https://www.netsparker.com/blog/web-security/server-side-request-forgery-vulnerability-ssrf/)
	* [Vulnerable by Design: Understanding Server-Side Request Forgery - BishopFox](https://www.bishopfox.com/blog/2015/04/vulnerable-by-design-understanding-server-side-request-forgery/)
- **General**
	* [AllThingsSSRF](https://github.com/jdonsec/AllThingsSSRF)
		* This is a collection of writeups, cheatsheets, videos, related to SSRF in one single location
- **Articles/Blogposts/Writeups**
	* [SSRF vs Business-Critical Applications Part 1: XXE Tunneling In SAP Net Weaver - erpscan](https://erpscan.com/wp-content/uploads/publications/SSRF-vs-Businness-critical-applications-final-edit.pdf)
	* [A New Era of SSRF  - Exploiting URL Parser in  Trending Programming Languages! - Orange Tsai - BH USA 17](https://www.blackhat.com/docs/us-17/thursday/us-17-Tsai-A-New-Era-Of-SSRF-Exploiting-URL-Parser-In-Trending-Programming-Languages.pdf)
	* [curl Based SSRF Exploits Against Redis](https://maxchadwick.xyz/blog/ssrf-exploits-against-redis)
	* [Pivoting from blind SSRF to RCE with HashiCorp Consul](http://www.kernelpicnic.net/2017/05/29/Pivoting-from-blind-SSRF-to-RCE-with-Hashicorp-Consul.html)
	* [ How I Chained 4 vulnerabilities on GitHub Enterprise, From SSRF Execution Chain to RCE!](http://blog.orange.tw/2017/07/how-i-chained-4-vulnerabilities-on.html)
	* [Airbnb – Chaining Third-Party Open Redirect into Server-Side Request Forgery (SSRF) via LivePerson Chat - Brett Buerhaus](https://buer.haus/2017/03/09/airbnb-chaining-third-party-open-redirect-into-server-side-request-forgery-ssrf-via-liveperson-chat/)
	* [CVE-2020-13379 Unauthenticated Full-Read SSRF in Grafana - rhynorater(2020)](https://rhynorater.github.io/CVE-2020-13379-Write-Up)
	* [Blind SSRF exploitation - wallarm(2020)](https://lab.wallarm.com/blind-ssrf-exploitation/)
	* [SVG SSRF Cheatsheet](https://github.com/allanlw/svg-cheatsheet)
	* [Finding SSRF via HTML Injection inside a PDF file on AWS EC2 - Riyaz Walikar(2020)](https://blog.appsecco.com/finding-ssrf-via-html-injection-inside-a-pdf-file-on-aws-ec2-214cc5ec5d90?gi=de959c2b96f0)
	* [Triggering a DNS lookup using Java Deserialization - ParanoidSoftware(2021)](https://blog.paranoidsoftware.com/triggering-a-dns-lookup-using-java-deserialization/)
	* [Bring Your Own SSRF – The Gateway Actuator - Wyatt(2021)](https://wya.pl/2021/12/20/bring-your-own-ssrf-the-gateway-actuator/)
	* [Attacking Java RMI via SSRF - Tobias Neitzel](https://blog.tneitzel.eu/posts/01-attacking-java-rmi-via-ssrf/)
	* [A Glossary of Blind SSRF Chains - Shubham Shah(2021)](https://blog.assetnote.io/2021/01/13/blind-ssrf-chains/)
	* [SSRF vulnerabilities caused by SNI proxy misconfigurations - Aleksei Tiurin(2022)](https://www.invicti.com/blog/web-security/ssrf-vulnerabilities-caused-by-sni-proxy-misconfigurations/)
	* [Exploiting URL Parsing Confusion - Noam Moshe(2022)](https://claroty.com/team82/research/exploiting-url-parsing-confusion)
	* [SSRF vulnerabilities and where to find them - Luke Stephens(2022)](https://labs.detectify.com/2022/09/23/ssrf-vulns-and-where-to-find-them/)
	* [What functionalities are most often vulnerable to SSRFs? Case study of 124 bug bounty reports - BBE](https://www.bugbountyexplained.com/what-functionalities-are-most-often-vulnerable-to-ssrfs-case-study-of-124-bug-bounty-reports)
	* [Server Side Request Forgery (SSRF) and AWS EC2 instances after Instance Meta Data Service version 2(IMDSv2) - Riyaz Walikar(2022)](https://blog.appsecco.com/server-side-request-forgery-ssrf-and-aws-ec2-instances-after-instance-meta-data-service-version-38fc1ba1a28a)
	* [Attacking Java RMI via SSRF - Tobias Neitzel(2021)](https://blog.tneitzel.eu/posts/01-attacking-java-rmi-via-ssrf/)
	* [URL Filter Subversion - Ricardo Henrique(2021)](https://sidechannel.blog/en/url-filter-subversion/index.html)
	* [Exploiting URL Parsing Confusion - Noam Moshe(2022)](https://claroty.com/2022/01/10/blog-research-exploiting-url-parsing-confusion/)
- **Papers**
	* [Cracking the Lens: Targeting HTTP's Hidden Attack Surface](https://portswigger.net/knowledgebase/papers/CrackingTheLens-whitepaper.pdf)
	* [LAN-Based Blind SSRF Attack Primitive for Windows Systems (switcheroo) - initblog](https://initblog.com/2019/switcheroo/)
	https://medium.com/a-bugz-life/exploiting-an-ssrf-trials-and-tribulations-14c5d8dbd69a
- **Presentations, Talks, Videos**
	* [Server-Side Browsing Considered Harmful - Nicolas Gregoire(AppSec EU15)](https://www.youtube.com/watch?v=8t5-A4ASTIU)
		* [Slides](http://www.agarri.fr/docs/AppSecEU15-Server_side_browsing_considered_harmful.pdf)
	* [A New Era of SSRF - Exploiting URL Parser in Trending Programming Languages - Orange Tsai(BHUSA2017)](https://www.youtube.com/watch?v=R9pJ2YCXoJQ)
		* [Slides](https://www.blackhat.com/docs/us-17/thursday/us-17-Tsai-A-New-Era-Of-SSRF-Exploiting-URL-Parser-In-Trending-Programming-Languages.pdf)
	* [Owning The Cloud Through Server-Side Request Forgery - Ben Sadeghipour, Cody Brocious (Daeken)](https://www.youtube.com/watch?v=o-tL9ULF0KI)
		* With how many apps are running in the cloud, hacking these instances becomes easier with a simple vulnerability due to an unsanitized user input. In this talk, we’ll discuss a number of different methods that helped us exfil data from different applications using Server-Side Request Forgery (SSRF). Using these methods, we were able to hack some of the major transportation, hospitality, and social media companies and make $50,000 in rewards in 3 months.
	* [Server Side Request Forgery (SSRF) All-In-One - Busra Demir(2020)](https://www.youtube.com/watch?v=kkX2TZt6y38)
		* In this video, Busra Demir will explore how to exploit Server Side Request Forgery (SSRF) by using different attack scenarios. She will dig into how to exploit an SSRF vulnerability: ; - On a Hack the Box machine called Player (SSRF - FFMPEG Exploit); - On a Hack the Box machine called Kotarak (SSRF Filter Bypass/port scan); - By combining SQL Injection on a VulnHub machine called6Days; - Combined with HTML Injection on a VulnHub machine Gemini Inc 1
	* [A New Era of SSRF - Exploiting URL Parser in Trending Programming Languages! - Orange Tsai(BHUSA2017)](https://www.youtube.com/watch?v=R9pJ2YCXoJQ)
		* [Slides](https://www.blackhat.com/docs/us-17/thursday/us-17-Tsai-A-New-Era-Of-SSRF-Exploiting-URL-Parser-In-Trending-Programming-Languages.pdf)
	* [Piercing The Veil: Server Side Request Forgery Attacks On Internal Networks - Alyssa Herrera(Hack.lu2019)](https://www.youtube.com/watch?v=7J-5mTc2e8A)
	* [Demystifying the Server Side - Rajanish Pathak, Rahul Maini & Harsh Jaiswal(EkoParty2020)](https://www.youtube.com/watch?v=gluSEBZpplQ)
		* Some server-side mysteries, the unveiling of the lesser-known techniques, and how inconsistency in the URL parsing and treating of certain elements by the server-side components that usually go undetected and can open up big gaps are waiting to be demystified!
	* [When TLS Hacks You - Joshua Maddux(Defcon Safemode2021)](https://www.youtube.com/watch?v=qGpAJxfADjo)
		* [BHUSA2020 Slides](https://i.blackhat.com/USA-20/Wednesday/us-20-Maddux-When-TLS-Hacks-You.pdf)
		* Lots of people try to attack the security of TLS. But what if we use TLS to attack other things? It's a huge standard, and it turns out that features intended to make TLS fast have also made it useful as an attack vector.  Among other things, these features provide a lot of flexibility for Server-Side Request Forgery (SSRF). While past work using HTTPS URLs in SSRF has relied upon platform-specific bugs such as SNI injection, we can go further. In this talk, I present a novel, cross-platform way of leveraging TLS to target internal services.  Uniquely, these attacks are more effective the more comprehensively a platform supports modern TLS, so won't go away with library upgrades. It is also unlikely that the TLS spec will change overnight at the whim of a random security researcher. Instead, we need to walk through scenarios and dispel common assumptions so the audience can know what to look out for. Of course, the best way to do so is with demos!
- **Writeups**
	* [CRLF injection & SSRF in git:// protocal lead to arbitrary code execution - chromium1337(2018)](https://hackerone.com/reports/441090)
	* [GACTF 2020 SimpleFlask Challenge (SSTI) - Arash Parsa(2020)](https://www.arashparsa.com/gactf/)
	* [GACTF 2020 EZ FLASK (SSRF to SSTI) - Arash Parsa(2020)](https://www.arashparsa.com/gactf/)
	* [$10000 Facebook SSRF (Bug Bounty) - Amine Aboud(2020)](https://amineaboud.medium.com/10000-facebook-ssrf-bug-bounty-402bd21e58e5)
	* [Top 25 Server-Side Request Forgery (SSRF) Bug Bounty Reports - Lohitaksh Nandan(2023)](https://hackerinthehouse.in/top-25-server-side-request-forgery-ssrf-bug-bounty-reports/)
	* [31k$ SSRF in Google Cloud Monitoring led to metadata exposure - David Nechuta(2020)](https://nechudav.blogspot.com/2020/11/31k-ssrf-in-google-cloud-monitoring.html)
	* [Turning bad SSRF to good SSRF: Websphere Portal (CVE-2021-27748) - Shubham Sha(2021)](https://blog.assetnote.io/2021/12/26/chained-ssrf-websphere/)
	* [Piercing the Veil: Server Side Request Forgery to NIPRNet access](https://web.archive.org/web/20180410080115/https://medium.com/bugbountywriteup/piercing-the-veil-server-side-request-forgery-to-niprnet-access-171018bca2c3)
- **Testing**
	* [SSRF bible. Cheatsheet](https://docs.google.com/document/d/1v1TkWZtrhzRLy0bYXBcdLUedXGb9njTNIJXa3u9akHM/edit#heading=h.t4tsk5ixehdd)	
	* [SSRF (Server Side Request Forgery) testing resources](https://github.com/cujanovic/SSRF-Testing/)	
	* [How To: Server-Side Request Forgery (SSRF)](https://www.hackerone.com/blog-How-To-Server-Side-Request-Forgery-SSRF)
	* [Port scanning with Server Side Request Forgery (SSRF) - acunetix](https://www.acunetix.com/blog/articles/ssrf-vulnerability-used-to-scan-the-web-servers-network/)
	* [SVG SSRF Cheatsheet](https://github.com/allanlw/svg-cheatsheet)
* **Tools**
	* [SSRFmap](https://github.com/swisskyrepo/SSRFmap)
		* Automatic SSRF fuzzer and exploitation tool
	* [See-SURF](https://github.com/In3tinct/See-SURF)
		* A Python based scanner to find potential SSRF parameters in a web application. See-SURF helps you detect potential SSRF parameters and validates the finding it by making a DNS/HTTP request back to your server.
	* [oidc-ssrf](https://github.com/doyensec/oidc-ssrf)
		* Evil OIDC server: the OpenID Configuration URL returns a 307 to cause SSRF.
	* [LORSRF](https://github.com/knassar702/lorsrf)
		* Fast CLI tool to find the parameters that can be used to find SSRF or Out-of-band resource load
	* [TLS Poison](https://github.com/jmdx/TLS-poison)
		* A tool that allows for generic SSRF via TLS, as well as CSRF via image tags in most browsers. The goals are similar to SNI injection, but this new method uses inherent behaviors of TLS, instead of depending upon bugs in a particular implementation.
	* [SSRFIRE](https://github.com/ksharinarayanan/SSRFire)
		* An automated SSRF finder. Just give the domain name and your server and chill! ;) Also has options to find XSS and open redirects


----------------------------------------------------------------------------------------------------------------


### <a name="ssi"></a>Server Side Include
* **General**
	* [Server Side Includes - Wikipedia](https://en.wikipedia.org/wiki/Server_Side_Includes)
	* [Server-Side Includes (SSI) Injection - OWASP](https://www.owasp.org/index.php/Server-Side_Includes_(SSI)_Injection)
* **Testing**
	* [Testing for SSI Injection (OTG-INPVAL-009) - OWASP](https://www.owasp.org/index.php/Testing_for_SSI_Injection_(OTG-INPVAL-009))


----------------------------------------------------------------------------------------------------------------


### <a name="ssti">Client/Server Side Template Injection</a>
- **Server-Side Template Injection**
	- **101**
		* [Server-Side Template Injection: RCE for the modern webapp](https://portswigger.net/knowledgebase/papers/ServerSideTemplateInjection.pdf)
		* [Server-Side Template Injection](http://blog.portswigger.net/2015/08/server-side-template-injection.html)
			* [Video](https://www.youtube.com/watch?v=3cT0uE7Y87s)
			* This paper defines a methodology for detecting and exploiting template injection, and shows it being applied to craft RCE zerodays for two widely deployed enterprise web applications. Generic exploits are demonstrated for five of the most popular template engines, including escapes from sandboxes whose entire purpose is to handle user-supplied templates in a safe way.
		* [SSTI: The Hidden Threat to Web Application Security - Pranav Khune(2022)](https://medium.com/@pranavkhune/ssti-the-hidden-threat-to-web-application-security-a6c917a8f3b0)
	- **Articles/Writeups**
		* [Exploiting Custom Template Engines - Dalton Campbell](https://depthsecurity.com/blog/exploiting-custom-template-engines)
		* [Server-Side Template Injection - James Kettle(2015)](https://portswigger.net/research/server-side-template-injection)
		* [Exploiting Jinja SSTI with limited payload size. - niebardzo(2020)](https://niebardzo.github.io/2020-11-23-exploiting-jinja-ssti/)
		* [Jinja2 SSTI Research - Chivato(2020)](https://hackmd.io/@Chivato/HyWsJ31dI)
		* [GitHub Pages - Multiple RCEs via insecure Kramdown configuration - $25,000 Bounty - vakzz(2020)](https://devcraft.io/2020/10/20/github-pages-multiple-rces-via-kramdown-config.html)
		* [RCE via Server-Side Template Injection - Gaurav Mishra(2020](https://cyc10n3.medium.com/rce-via-server-side-template-injection-ad46f8e0c2ae)
		* [Method Confusion In Go SSTIs Lead To File Read And RCE. - Gus Ralph(2021)](https://www.onsecurity.io/blog/go-ssti-method-research/)
		* [Doing it the researcher’s way: How I Managed to Get SSTI (Server Side Template Injection) which lead to arbitrary file reading on One of the Leading Payment Systems in Asia - JzeeRx(2022)](https://medium.com/@jazdprince/doing-it-the-researchers-way-how-i-managed-to-get-ssti-server-side-template-injection-which-66b239ca0104)
		* [Bug Writeup: RCE via SSTI on Spring Boot Error Page with Akamai WAF Bypass - h1pmnh, Dark9T(2022)](https://h1pmnh.github.io/post/writeup_spring_el_waf_bypass/)
	- **Writeups**
		* [Exploring SSTI in Flask/Jinja2](https://nvisium.com/blog/2016/03/09/exploring-ssti-in-flask-jinja2/)
		* [Exploring SSTI in Flask/Jinja2, Part II](https://nvisium.com/blog/2016/03/11/exploring-ssti-in-flask-jinja2-part-ii/)
		* [Ruby ERB Template Injection](https://www.trustedsec.com/2017/09/rubyerb-template-injection/)
		* [Remote Code Execution via Server Side Template Injection at OFBiz 13.07.03 (CVE-2016-4462)](https://insinuator.net/2016/07/dilligent-bug/)
		* [Injecting Flask - Nvisium](https://nvisium.com/blog/2015/12/07/injecting-flask/)
		* [Spring Boot RCE](http://www.deadpool.sh/2017/RCE-Springs/)
		* [Fuzzing `{{7*7}} Till {{P1}}` - err0rr](http://verneet.com/fuzzing-77-till-p1/)
	- **Talks/Presentations/Videos**
		* [SEC642: Killing snakes for fun, Flask SSTIs and RCEs in Python - Moses Frost(SANS)](https://www.sans.org/webcasts/sec642-killing-snakes-fun-flask-sstis-rces-python-112860)
			* Here is a word: Reflection. How many times have you read the words SSTI or even CSTI and wondered what they actually did, how they worked, or how to execute one? How can you take a file reading vulnerability like SSTI into a Remote Code Execution exploit? In this talk we will give you a glance into the SEC642 topic on Server Side Template Injection in Flask and taking that one concept a few steps further by introducing Python Method Reflection to execute code, and even backdoors. Join Moses Frost as he discusses this and other topics that are found in SEC642: Advanced Web App Penetration Testing, Ethical Hacking, and Exploitation Techniques.
		* [Server-Side Template Injection: RCE For The Modern Web App - James Kettle(2015)](https://www.youtube.com/watch?v=3cT0uE7Y87s)
			* In this presentation, I'll discuss techniques to recognize template injection, then show how to take template engines on a journey deeply orthogonal to their intended purpose and ultimately gain arbitrary code execution. I'll show this technique being applied to craft exploits that hijack four popular template engines, then demonstrate RCE zero-days on two corporate web applications. This presentation will also cover techniques for automated detection of template injection, and exploiting subtle, application-specific vulnerabilities that can arise in otherwise secure template systems.
		* [Server-Side Template Injection Workshop - Tib3rius(2021)](https://www.youtube.com/watch?v=rJ-l_JSdUlE)
		* [Room for Escape: Scribbling Outside the Lines of Template Security - Alvaro Muñoz, Oleksandr Mirosh](https://www.youtube.com/watch?v=yMDCyzSBX5U&list=PLH15HpR5qRsXE_4kOSy_SXwFkFQre4AV_&index=51)
			* "Now more than ever, digital communication and collaboration are essential to the modern human experience. People around the globe work together online as they share information, create documents, send emails, and collaborate on spreadsheets and presentations. Shared digital content is everywhere and networked communication platforms and software play a crucial role. Content Management Systems (CMS) allow the user to design, create, modify, and visualize dynamic content. For many companies, CMS platforms are pivotal to their content pipelines and workforce collaboration."
	- **Tools**
		* [tplmap](https://github.com/epinna/tplmap)
			* Code and Server-Side Template Injection Detection and Exploitation Tool
- **Client-Side Template Injection**
	- **101**
		* [Client-side template injection - PortSwigger](https://portswigger.net/kb/issues/00200308_client-side-template-injection)
			* "Client-side template injection vulnerabilities arise when applications using a client-side template framework dynamically embed user input in web pages. When a web page is rendered, the framework will scan the page for template expressions, and execute any that it encounters. An attacker can exploit this by supplying a malicious template expression that launches a cross-site scripting (XSS) attack."
	- **Articles/Papers/Talks/Writeups**
		* [Reflected XSS on developer.uber.com via Angular template injection - albinowax(2015)](https://hackerone.com/reports/125027)
		* [XSS without HTML: Client-Side Template Injection with AngularJS - Gareth Hayes(2016/2020)](https://portswigger.net/research/xss-without-html-client-side-template-injection-with-angularjs)
		* [So you thought you were safe using AngularJS. . . . Think again! - Lewis Arden(2017)](https://owasp.org/www-chapter-london/assets/slides/OWASPLondon20170727_AngularJS.pdf)
		* [Angular Template Injection Payloads](https://gist.github.com/mccabe615/cc92daaf368c9f5e15eda371728083a3)
		* [Client-side Template Injection - ANZ Coders(2018](https://www.youtube.com/watch?v=VDAAGm_HUQU)
			* Browsers' security controls, backend security libraries and HTTP response security headers have made it very difficult to exploit common security vulnerabilities (yes, you know it, XSS!). However, a trend of insecure usage of JSMVCs has flipped the coin to an attacker advantage. The attacker can misuse rich functionalities brought by a JSMVC to bypass security controls. In this presentation/workshop I will elaborate one of the frontend security vulnerabilities classes, i.e. Client-Side Template Injection (CSTI) and demonstrate how a real-word attack can happen. I will conclude my presentation on best-practices to effectively protect our applications against CSTI.
		* [Client Side Template Injection - Kacper Szurek(2019)](https://security.szurek.pl/en/client-side-template-injection/)
		* [Payment Tampering Using Template Injection - Team we45](https://www.we45.com/post/payment-tampering-using-template-injection)
		* [Angular Template Injection without Quote Characters - Aviv Yahav(2020)](https://appsec-labs.com/portal/angular-template-injection-without-quote-characters/)
		* [Reflected XSS on Microsoft.com via Angular Js template injection - Pratik Dabhi(2020)](https://infosecwriteups.com/reflected-xss-on-microsoft-com-via-angular-template-injection-2e26d80a7fd8)
		* [How I Stole Plunker Session Tokens with an Angular Expression - Ryan Hanson(2021)](https://royaljay.com/security/angular-expression-injections/)
		* [Client Side Template Injection (CSTI) - Hacktricks](https://book.hacktricks.xyz/pentesting-web/client-side-template-injection-csti)
- **Purposefully Vulnerable Webapps**
	* [Breakable Flask](https://github.com/stephenbradshaw/breakableflask)
		* A simple vulnerable Flask application.
	* [Hackable](https://github.com/JasonHinds13/hackable)
		* A python flask app that is purposfully vulnerable to SQL injection and XSS Attacks
	* [Injecting Flask - Nvisium](https://nvisium.com/blog/2015/12/07/injecting-flask/) 
	* [hackable - JasonHinds](https://github.com/JasonHinds13/hackable)
		* A python flask app that is purposfully vulnerable to SQL injection and XSS attacks
	* [Template Injection Workshop: Twig, Jinja, Freemaker and more - GoSecure(2020)](https://www.youtube.com/watch?v=I7xQZOvZzIw)
		* [Code](https://github.com/GoSecure/template-injection-workshop)
		* [Workshop page](https://gosecure.github.io/template-injection-workshop/#0)
		* Welcome to this 2-hour workshop on Template Injection. Template injection, also known as Server-Side Template Injection (SSTI), is a vulnerability class that has emerged in 2015. The 2015 Black Hat talk from James Kettle established the foundations for the exploitation techniques in multiple template engines. The exploitation of this type of issue will require specific knowledge of the template library or the language being used under the hood. The workshop is divided in six labs and an introduction. First, there will be an introduction to the vulnerability. This segment is needed to get a good understanding of the attack patterns to recognize potential vulnerabilities. Then we will investigate five different template engines with unique twists. Each template engine will have an exercise which consists of a web application with a template engine being exposed.
- **Tools**
	* [Templates Injections - PayloadsAllTheThings](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/Server%20Side%20Template%20injections)


----------------------------------------------------------------------------------------------------------------


### Subdomain Hijack/Takeover<a name="subtake"></a>
* **101**
* **Articles/Blogposts/Writeups**
	* [Hostile Subdomain Takeover using Heroku/Github/Desk + more - Detectify](https://labs.detectify.com/2014/10/21/hostile-subdomain-takeover-using-herokugithubdesk-more/)
	* [5 Subdomain Takeover #ProTips - Patrik Hudak](https://securitytrails.com/blog/subdomain-takeover-tips)
	* [can-i-take-over-xyz](https://github.com/EdOverflow/can-i-take-over-xyz#all-entries)
		* "Can I take over XYZ?" — a list of services and how to claim (sub)domains with dangling DNS records.
* **Talks/Presentations**
	* [DNS hijacking using cloud providers - Frans Rosén - Security Fest 2017](https://www.youtube.com/watch?v=HhJv8CU-RIk)
		* A few years ago, Frans and his team posted an article on Detectify Labs regarding domain hijacking using services like AWS, Heroku and GitHub. These issues still remains and are still affecting a lot of companies. Jonathan Claudius from Mozilla even calls “Subdomain takeover” “the new XSS”. Since then, many tools have popped up to spot these sorts of vulnerabilities. Frans will go through both the currently disclosed and the non-disclosed ways to take control over domains and will share the specific techniques involved.
	* [Subdomain Takeovers, beyond the basics for Pentesters and Bug Bounty Hunters - Codingo(2020)](https://www.youtube.com/watch?v=q_A8aXLO1gA)
		* Discover the tricks to subdomain takeovers that go beyond the basics, allowing you to find more impactful findings in a pentest, or on a bug bounty program.
* **Tools**


----------------------------------------------------------------------------------------------------------------


### <a name="tabnab"></a>Tabnabbing Attacks
- **101**
	* [Tabnabbing: A New Type of Phishing Attack - Aza Raskin](http://www.azarask.in/blog/post/a-new-type-of-phishing-attack/)
	* [Reverse Tabnabbing - OWASP](https://www.owasp.org/index.php/Reverse_Tabnabbing)
		* Reverse tabnabbing is an attack where a page linked from the target page is able to rewrite that page, for example to replace it with a phishing site. As the user was originally on the correct page they are less likely to notice that it has been changed to a phishing site, especially it the site looks the same as the target. If the user authenticates to this new page then their credentials (or other sensitive data) are sent to the phishing site rather than the legitimate one.
- **Articles/Papers/Talks/Writeups**
	* [Tabnabbing Protection Bypass - Ziyahan Albeniz](https://www.netsparker.com/blog/web-security/tabnabbing-protection-bypass/)
	* [Tab nabbing via window.opener - Ashish singh(HackerOne)](https://hackerone.com/reports/403891)
- **Tools**


----------------------------------------------------------------------------------------------------------------


### <a name="timing"></a>Timing-based Attacks/Data race Attacks
* **101**
	* [Timing attack - Wikipedia](https://en.wikipedia.org/wiki/Timing_attack)
* **Articles/Blogposts/Writeups**
	* [Race conditions on the web ](https://www.josipfranjkovic.com/blog/race-conditions-on-web)
	* [Practical Race Condition Vulnerabilities in Web Applications](https://defuse.ca/race-conditions-in-web-applications.htm)
* **Papers**
	* [Race Detection for Web Applications - Boris Petrov, Martin Vechev, Manu Sridharan, Julian Dolby](http://www.cs.columbia.edu/~junfeng/14fa-e6121/papers/js-race.pdf)
		* We present the first formulation of a happens-before relation for common web platform features. Developing this relation was a non-trivial task, due to complex feature interactions and browser differences. We also present a logical memory access model for web applications that abstracts away browser implementation details. Based on the above, we implemented WEBRACER, the first dynamic race detector for web applications. WEBRACER is implemented atop the production-quality WebKit engine, enabling testing of full-featured web sites. WEBRACER can also simulate certain user actions, exposing more races. We evaluated WEBRACER by testing a large set of Fortune 100 company web sites. We discovered many harmful races, and also gained insights into how developers handle asynchrony in practice.
	* [Exposing Private Information by Timing Web Applications - Andrew Bortz, Dan Boneh, Palash Nandy(2007)](https://crypto.stanford.edu/~dabo/papers/webtiming.pdf)
		* "We show that the time web sites take to respond to HTTP requests can leak private information, using two different types of attacks. The first, direct timing, directly measures response times from a web site to expose private information such as validity of an username at a secured site or the number of private photos in a publicly viewable gallery. The second, cross-site timing, enables a malicious web site to obtain information from the user’s perspective at another site. For example, a malicious site can learn if the user is currently logged in at a victim site and, in some cases, the number of objects in the user’s shopping cart. Our experiments sug- gest that these timing vulnerabilities are wide-spread. We explain in detail how and why these attacks work, and dis- cuss methods for writing web application code that resists these attacks."
	* [Opportunities and Limits of Remote Timing Attacks - Scott A. Crosby, Dan S. Wallach, Rudolf H. Riedi(2009)](https://www.cs.rice.edu/~dwallach/pub/crosby-timing2009.pdf)
		* "Our work analyzes the limits of attacks based on accurately measuring network response times and jitter over a local network and across the Internet. We present the design of filters to significantly reduce the effects of jitter, allowing an attacker to measure events with 15-100μs accuracy across the Internet, and as good as 100ns over a local network. Notably, security-related algorithms on Web servers and other network servers need to be carefully engi- neered to avoid timing channel leaks at the accuracy demonstrated in this article."
	* [Cross-origin pixel stealing: Timing attacks using CSS filters - Robert Kotcher, Yutong Pei, Pranjal Jumde, Collin Jackson(2013)](https://www.researchgate.net/publication/262292364_Cross-origin_pixel_stealing_Timing_attacks_using_CSS_filters)
	* [The Clock is Still Ticking: Timing Attacks in the Modern Web - Tom Van Goethem, Wouter Joosen, Nick Nikiforakis(2015)](https://dl.acm.org/doi/10.1145/2810103.2813632)
		* "In this paper, we show that modern browsers expose new side-channels that can be used to acquire accurate timing measurements, regardless of network conditions. Using several real-world examples, we introduce four novel web-based timing attacks against modern browsers and describe how an attacker can use them to obtain personal information based on a user’s state on a cross-origin website. We evaluate our proposed attacks and demonstrate that they significantly outperform current attacks in terms of speed, reliability, and accuracy. Furthermore, we show that the nature of our attacks renders traditional defenses, i.e., those based on randomly delaying responses, moot and discuss possible server-side defense mechanisms."
	* [Timeless Timing Attacks: Exploiting Concurrency to Leak Secrets over Remote Connections - Tom Van Goethem, Christina Pöpper, Wouter Joosen, Mathy Vanhoef(2020)](https://www.usenix.org/conference/usenixsecurity20/presentation/van-goethem)
		* "In this paper, we introduce a conceptually novel type of timing attack that leverages the coalescing of packets by network protocols and concurrent handling of requests by applications. These concurrency-based timing attacks infer a relative timing difference by analyzing the order in which responses are returned, and thus do not rely on any absolute timing information. We show how these attacks result in a 100-fold improvement over typical timing attacks performed over the Internet, and can accurately detect timing differences as small as 100ns, similar to attacks launched on a local system. We describe how these timing attacks can be successfully deployed against HTTP/2 webservers, Tor onion services, and EAP-pwd, a popular Wi-Fi authentication method."
* **Tools**
	* [Requests-Racer](https://github.com/nccgroup/requests-racer)
		* Requests-Racer is a small Python library that lets you use the Requests library to submit multiple requests that will be processed by their destination servers at approximately the same time, even if the requests have different destinations or have payloads of different sizes. This can be helpful for detecting and exploiting race condition vulnerabilities in web applications. (For more information, see motivation.md.)
	* [Race the Web](https://github.com/aaronhnatiw/race-the-web)
		* Tests for race conditions in web applications by sending out a user-specified number of requests to a target URL (or URLs) simultaneously, and then compares the responses from the server for uniqueness. Includes a number of configuration options.
	* [timing_attack](https://github.com/ffleming/timing_attack)
		* Perform timing attacks against web applications
	* [Race condition exploit](https://github.com/andresriancho/race-condition-exploit)
		* Tool to help with the exploitation of web application race conditions
	* [OWASP TimeGap Theory](https://owasp.org/www-project-timegap-theory/)
		* [Repo](https://github.com/OWASP/TimeGap-Theory)
		* [Handbook](https://raw.githubusercontent.com/OWASP/TimeGap-Theory/master/OWASP%20TimeGap%20Theory%20Handbook.pdf)
		* OWASP TimeGap Theory is an auto-scoring capture-the-flag game that focuses entirely on TOCTOU vulnerabilities. There are seven unique challenges to be solved in TimeGap Theory. All of them can be solved just by using browser dev tools.
* **Miscellaneous**


----------------------------------------------------------------------------------------------------------------


### <a name="tls-redirect"></a> TLS Redirection (and Virtual Host Confusion)
* **101**
	* [TLS Redirection (and Virtual Host Confusion) - GrrDog](https://github.com/GrrrDog/TLS-Redirection)
		* The goal of this document is to raise awareness of a little-known group of attacks, TLS redirection / Virtual Host Confusion, and to bring all the information related to this topic together.
* **Articles/Papers/Talks/Writeups**
	* [Network-based Origin Confusion Attacks against HTTPS Virtual Hosting - Antoine Delignat-Lavaud, Karthikeyan Bhargavan](http://antoine.delignat-lavaud.fr/doc/www15.pdf)
	* [The BEAST Wins Again: Why TLS Keeps Failing to Protect HTTP - BHUSA14](https://www.blackhat.com/docs/us-14/materials/us-14-Delignat-The-BEAST-Wins-Again-Why-TLS-Keeps-Failing-To-Protect-HTTP.pdf)
* **General**
* **Tools**
* **Miscellaneous**


----------------------------------------------------------------------------------------------------------------


### <a name="typosquat"></a> TypoSquatting
* **101**


----------------------------------------------------------------------------------------------------------------


### <a name="typosquatting"></a> (Bit)/Typo-squatting
* **101**
	* [Typosquatting - ICANNWiki](https://icannwiki.org/Typosquatting)
	* [Typosquatting - Wikipedia](https://en.wikipedia.org/wiki/Typosquatting)
* **Articles/Blogposts/Writeups**
	* [Typosquatting programming language package managers](http://incolumitas.com/2016/06/08/typosquatting-package-managers/)
* **Talks/Presentations/Videos**
	* [Examining the Bitsquatting Attack Surface - Jaeson Schultz(Defcon21)](https://media.defcon.org/DEF%20CON%2021/DEF%20CON%2021%20video%20and%20slides/DEF%20CON%2021%20Hacking%20Conference%20Presentation%20By%20Jaeson%20Schultz%20-%20Examining%20the%20Bitsquatting%20Attack%20Surface%20-%20Video%20and%20Slides.m4v)
		* [Paper](https://www.defcon.org/images/defcon-21/dc-21-presentations/Schultz/DEFCON-21-Schultz-Examining-the-Bitsquatting-Attack-Surface-WP.pdf)
		* Bit errors in computer memory, when they occur in a stored domain name, can cause Internet traffic to be directed to the wrong Internet location potentially compromising security. When a domain name one bit different from a target domain is registered, this is called "bitsquatting". This presentation builds on previous work in this area presented by Artem Dinaburg at Blackhat 2011. Cisco's research into bitsquatting has revealed several previously unknown vectors for bitsquatting. Cisco has also discovered several new mitigations which do not involve installation of error correcting memory, nor the mass registration of bitsquat domains. In fact some of the new mitigations have the potential to render the problem of bitsquatting to the dustbin of history.


----------------------------------------------------------------------------------------------------------------


### <a name="shells">Web Shells</a>
* **Articles**
	* [Binary Webshell Through OPcache in PHP 7 - Ian Bouchard](https://gosecure.net/2016/04/27/binary-webshell-through-opcache-in-php-7/)
* **Detection**
	* [Case Study: How Backdoors Bypass Security Solutions with Advanced Camouflage Techniques](https://www.incapsula.com/blog/backdoor-malware-analysis-obfuscation-techniques.html)
		* Look at PHP obfuscation methods for webshells
	* [NeoPI](https://github.com/Neohapsis/NeoPI)
		* What is NeoPI? NeoPI is a Python script that uses a variety of statistical methods to detect obfuscated and encrypted content within text/script files. The intended purpose of NeoPI is to aid in the detection of hidden web shell code. The development focus of NeoPI was creating a tool that could be used in conjunction with other established detection methods such as Linux Malware Detect or traditional signature/keyword based searches.
	* [Shell Detector](https://github.com/emposha/Shell-Detector)
		* Shell Detector – is a application that helps you find and identify php/cgi(perl)/asp/aspx shells. Shell Detector has a “web shells” signature database that helps to identify “web shell” up to 99%.
	* [Loki - Simple IOC Scanner](https://github.com/Neo23x0/Loki)
		* Scanner for Simple Indicators of Compromise
* **Tools**
	* [Weevely](https://github.com/epinna/weevely3)
		* Weevely is a command line web shell dinamically extended over the network at runtime used for remote administration and pen testing. It provides a weaponized telnet-like console through a PHP script running on the target, even in restricted environments.  The low footprint agent and over 30 modules shape an extensible framework to administrate, conduct a pen-test, post-exploit, and audit remote web accesses in order to escalate privileges and pivot deeper in the internal networks.
		* [Getting Started](https://github.com/epinna/weevely3/wiki#getting-started)
	* [b374k shell 3.2](https://github.com/b374k/b374k)
		* This PHP Shell is a useful tool for system or web administrator to do remote management without using cpanel, connecting using ssh, ftp etc. All actions take place within a web browser
	* [Simple websockets based webshell](http://ibreak.software/2015/02/18/simple-websockets-based-webshell/)
	* [JSShell](https://github.com/Den1al/JSShell/)
		* An interactive multi-user web based JS shell written in Python with Flask (for server side) and of course Javascript and HTML (client side). It was initially created to debug remote esoteric browsers during tests and research. I'm aware of other purposes this tool might serve, use it at your own responsibility and risk.
	* [htshells](https://github.com/wireghoul/htshells)
		* Self contained web shells and other attacks via .htaccess files.
	* [Encoding Web Shells in PNG IDAT chunks - idontplaydarts.com](https://www.idontplaydarts.com/2012/06/encoding-web-shells-in-png-idat-chunks/)
	* [novahot](https://github.com/chrisallenlane/novahot)
		* novahot is a webshell framework for penetration testers. It implements a JSON-based API that can communicate with trojans written in any language. By default, it ships with trojans written in PHP, ruby, and python. Beyond executing system commands, novahot is able to emulate interactive terminals, including mysql, sqlite3, and psql. It additionally implements "virtual commands" that make it possible to upload, download, edit, and view remote files locallly using your preferred applications.


----------------------------------------------------------------------------------------------------------------


### <a name="xss">XSS</a>
* **101**
	* [Types of Cross-Site Scripting - OWASP](https://www.owasp.org/index.php/Types_of_Cross-Site_Scripting)
	* [Postcards from a Post-XSS World - Michael Zalewski](http://lcamtuf.coredump.cx/postxss/#dangling-markup-injection)
		* This page is a rough collection of notes on some of the fundamental alternatives to direct script injection that would be available to attackers following the universal deployment of CSP or other security mechanisms designed to prevent the execution of unauthorized scripts. I hope to demonstrate that in many cases, the capabilities offered by these alternative methods are highly compatible with the goals of contemporary XSS attacks.
	* ["Gimme a bit!" - Exploring Attacks in the "Post-XSS" World - Takashi Yoneuchi]
	* [Cross Site Scripting Prevention Cheat Sheet - OWASP](https://github.com/OWASP/CheatSheetSeries/blob/master/cheatsheets/Cross_Site_Scripting_Prevention_Cheat_Sheet.md)
	* [CERT Advisory CA-2000-02 Malicious HTML TagsEmbedded in Client Web Requests](http://www.cert.org/advisories/CA-2000-02.html)
	* [HTML Code Injection and Cross-site Scripting - Gunter Ollmann](http://www.technicalinfo.net/papers/CSS.html)
	* [Flirting with MIME Types: A Browser’sPerspective - Blake Frantz](http://www.leviathansecurity.com/pdf/Flirting%20with%20MIME%20Types.pdf)
* **Articles/Blogposts/Writeups**
	* [Actual XSS in 2020 - Samuel Anttila(2020)](https://netsec.expert/2020/02/01/xss-in-2020.html)
	* [Getting Real with XSS - Olive Simonnet(2019)](https://labs.f-secure.com/blog/getting-real-with-xss/)
	* [XSS technique without parentheses - The Spanner](http://www.thespanner.co.uk/2012/05/01/xss-technique-without-parentheses/)
	* [Text/Plain Considered Harmful - Jan](https://jankopecky.net/index.php/2017/04/18/0day-textplain-considered-harmful/)
	* [Setting The ‘REFERER’ Header Using Javascript - Drew Kirkpatrick(2020)](https://www.trustedsec.com/blog/setting-the-referer-header-using-javascript/)
	* [Unleashing an Ultimate XSS Polyglot - Ahmed Elsobky](https://github.com/0xsobky/HackVault/wiki/Unleashing-an-Ultimate-XSS-Polyglot)
	* [Password stealing from HTTPS login page and CSRF protection bypass with reflected XSS - Michael Koczwara(2020)](https://medium.com/@MichaelKoczwara/password-stealing-from-https-login-page-and-csrf-bypass-with-reflected-xss-76f56ebc4516)
	* [What is the use of CDATA inside JavaScript tags and HTML? - sptrac.com(2017)](http://sptrac.com/wordpress/?p=3765)
	* [Detecting valid tags/events on XSS exploitation. - Jorge Lajara(2020)](https://jlajara.gitlab.io/web/2020/01/25/XSS_tag_event_analyzer.html)
* **Presentations, Talks, Videos**
	* [Self XSS: we’re not so different you and I - Mathias Karlsson](https://www.youtube.com/watch?v=l3yThCIF7e4)	
	* [Scriptless Attacks – Stealing the Pie Without Touching the Sill](http://www.syssec.rub.de/media/emma/veroeffentlichungen/2012/08/16/scriptlessAttacks-ccs2012.pdf)
		* Due to their high practical impact, Cross-Site Scripting (XSS) attacks have attracted a lot of attention from the security community members. In the same way, a plethora of more or less effective defense techniques have been proposed, addressing the causes and effects of XSS vulnerabilities. As a result, an adversary often can no longer inject or even execute arbitrary scripting code in several real-life scenarios. In this paper, we examine the attack surface that remains after XSS and similar scripting attacks are supposedly mitigated by preventing an attacker from executing JavaScript code. We address the question of whether an attacker really needs JavaScript or similar functionality to perform attacks aiming for information theft. The surprising result is that an attacker can also abuse Cascading Style Sheets (CSS) in combination with other Web techniques like plain HTML, inactive SVG images or font files. Through several case studies, we introduce the so called scriptless attacks and demonstrate that an adversary might not need to execute code to preserve his ability to extract sensitive informati on from well protected websites. More precisely, we show that an attacker can use seemingly benign features to build side channel attacks that measure and exfiltrate almost arbitrary data displayed on a given website. We conclude this paper with a discussion of potential mitigation techniques against this class of attacks. In addition, we have implemented a browser patch that enables a website to make a vital determination as to being loaded in a detached view or pop-up window. This approach proves useful for prevention of certain types of attacks we here discuss.	
	* ["Gimme a bit!" - Exploring Attacks in the "Post-XSS" World - Takashi Yoneuchi](https://speakerdeck.com/lmt_swallow/gimme-a-bit-exploring-attacks-in-the-post-xss-world)
	* [Tricks For Weaponizing XSS - Drew Kirkpatrick](https://www.trustedsec.com/blog/tricks-for-weaponizing-xss/)
	* [Understanding XSS - Christina Mitchell(Nolacon2019)](https://www.irongeek.com/i.php?page=videos/nolacon2019/nolacon-2019-d-02-understanding-xss-christina-mitchell)
		* Come learn in depth about the web vulnerability XSS. First we discuss how browsers and web apps work to better understand how it's possible. Then we will cover the following: how to spot it in the wild, how to exploit it, remediation steps, and impact. How can I inject into your webpage? Come learn how!
	* [Popping Shells Instead OF Alert Boxes: Weaponizing XSS For Fun and Profit - Drew Kirkpatrick(2019)](https://www.trustedsec.com/events/webinar-popping-shells-instead-of-alert-boxes-weaponizing-xss-for-fun-and-profit/)
* **Bypass Techniques & Writeups**
	* Cheat-Sheets/References
		* [XSS Filter Evasion Cheat Sheet - OWASP](https://owasp.org/www-community/xss-filter-evasion-cheatsheet)
	* **Filter Evasion**
		* [XSS cheatsheet Esp: for filter evasion - RSnake](https://n0p.net/penguicon/php_app_sec/mirror/xss.html)
		* [Bypassing XSS Detection Mechanisms - Somdev Sangwan(2018)](https://github.com/s0md3v/MyPapers/tree/master/Bypassing-XSS-detection-mechanisms)
		* [XSS Filter Evasion - Zbigniew Banach(2019)](https://www.netsparker.com/blog/web-security/xss-filter-evasion/)
		* [XSS without parentheses and semi-colons - Gareth Heyes(2019)](https://portswigger.net/research/xss-without-parentheses-and-semi-colons)
		* [Bypass XSS filters using JavaScript global variables - theMiddle](https://www.secjuice.com/bypass-xss-filters-using-javascript-global-variables/)
		* [Executing non-alphanumeric JavaScript without parenthesis - Gareth Heyes](https://portswigger.net/research/executing-non-alphanumeric-javascript-without-parenthesis)
		* [Non-alphanumeric code With JavaScript & PHP - Gareth Heyes](http://www.businessinfo.co.uk/labs/talk/Nonalpha.pdf)
		* [CTF Challenge: INS Hack 2019 / Bypasses Everywhere -corb3nik](https://corb3nik.github.io/blog/ins-hack-2019/bypasses-everywhere)
		* [JavaScript without parentheses using DOMMatrix - Gareth Heyes(2020)](https://portswigger.net/research/javascript-without-parentheses-using-dommatrix)
		* [Arbitrary Parentheses-less XSS(against strict CSP policies) - terjang(2020)](https://medium.com/@terjanq/arbitrary-parentheses-less-xss-e4a1cf37c13d)
		* [XSS: Arithmetic Operators & Optional Chaining To Bypass Filters & Sanitization - theMiddle(2020)](https://www.secjuice.com/xss-arithmetic-operators-chaining-bypass-sanitization/)
	* **Images**
		* [JS via Images - Osanda Malith Jayathissa(2014)](https://osandamalith.com/2014/11/13/js-via-images/)
	* **Length**
		* [Exploiting XSS with 20 characters limitation - Jorge Lajara(2019)](https://jlajara.gitlab.io/web/2019/11/30/XSS_20_characters.html)
	* **Restricted Character Sets**
		* [JSFuck](http://www.jsfuck.com/)
		* [jsf$ck](https://github.com/centime/jsfsck)
			* jsf$ck is a fork from jsfuck.com that doesn't use parenthesis.
		* [jjencode](https://utf-8.jp/public/jjencode.html)
	* **SVG**
		* [XSS fun with animated SVG - Paweł Hałdrzyński(2020)](https://blog.isec.pl/xss-fun-with-animated-svg/)
		* [Redefining Impossible: XSS without arbitrary JavaScript - Luan Herrera(2020)](https://portswigger.net/research/redefining-impossible-xss-without-arbitrary-javascript)
		* [XSS Challenge Solution - SVG use - Alex Infuhr(2020)](https://insert-script.blogspot.com/2020/09/xss-challenge-solution-svg-use.html)
	* **Other**
		* [Bypass XSS Protection with xmp, noscript, noframes.. etc.. - Hahwul](https://www.hahwul.com/2019/04/bypass-xss-protection-with-xmp-noscript-etc....html)
		* [MITM XSS Protection – Still Popping Alerts - doyler.net(2017)](https://www.doyler.net/security-not-included/mitm-xss-protection-still-popping-alerts)
		* [Attacking and defending JavaScript sandboxes - Gareth Heyes(2020)](https://portswigger.net/research/attacking-and-defending-javascript-sandboxes)
		* [Evading defences using VueJS script gadgets - Gareth Heyes(2020)](https://portswigger.net/research/evading-defences-using-vuejs-script-gadgets)
		* [Escaping JavaScript sandboxes with parsing issues - Gareth Heyes(2020)](https://portswigger.net/research/escaping-javascript-sandboxes-with-parsing-issues)
		* [Bypassing modern XSS mitigations with code-reuse attacks - Alexander Andersson(2020)](https://blog.truesec.com/2020/04/03/bypassing-modern-xss-mitigations-with-code-reuse-attacks/)
	* **Lists**
		* [XSS bypass strtoupper & htmlspecialchars](https://security.stackexchange.com/questions/145716/xss-bypass-strtoupper-htmlspecialchars)
		* [Is htmlspecialchars enough to prevent an SQL injection on a variable enclosed in single quotes? - StackOverflow](https://stackoverflow.com/questions/22116934/is-htmlspecialchars-enough-to-prevent-an-sql-injection-on-a-variable-enclosed-in)
		* [XSS Web Filter Bypass list - rvrsh3ll](https://gist.github.com/rvrsh3ll/09a8b933291f9f98e8ec#file-xxsfilterbypass-lst-L1)
		* [XSS Filter Bypass List](https://gist.github.com/rvrsh3ll/09a8b933291f9f98e8ec)
* **Cheat-Sheets**
	* [XSS (Cross Site Scripting) - Carlos Polop](https://book.hacktricks.xyz/pentesting-web/xss-cross-site-scripting)
	* [Cross-site scripting (XSS) cheat sheet - portswigger](https://portswigger.net/web-security/cross-site-scripting/cheat-sheet)
	* [XSS Filter Evasion Cheat Sheet - OWASP](https://owasp.org/www-community/xss-filter-evasion-cheatsheet)
	* [Testing for Reflected Cross Site Scripting - OWASP WSTG](https://owasp.org/www-project-web-security-testing-guide/v41/4-Web_Application_Security_Testing/07-Input_Validation_Testing/01-Testing_for_Reflected_Cross_Site_Scripting.html)
	* [Testing for Stored Cross Site Scripting - OWASP WSTG](https://owasp.org/www-project-web-security-testing-guide/v41/4-Web_Application_Security_Testing/07-Input_Validation_Testing/02-Testing_for_Stored_Cross_Site_Scripting.html)
	* [Testing for DOM-Based Cross Site Scripting - OWASP WSTG](https://owasp.org/www-project-web-security-testing-guide/v41/4-Web_Application_Security_Testing/11-Client_Side_Testing/01-Testing_for_DOM-based_Cross_Site_Scripting.html)
* **Types-Of**
	* **DOM-based**
		* **101**
		* **Articles/Blogposts/Writeups**
			* postMessage API
				* [Window.postMessage() - MDN(Mozilla)](https://developer.mozilla.org/en-US/docs/Web/API/Window/postMessage)
				* [Detecting postMessage interfaces - Sjoerd Langkemper(2018)](https://www.sjoerdlangkemper.nl/2018/05/09/attacking-postmessage-interfaces/)
				* [The pitfalls of postMessage -  Mathias Karlsson(2016)](https://labs.detectify.com/2016/12/08/the-pitfalls-of-postmessage/)
				* [The Mystery of postMessage - Ron Chan(2018)](https://ngailong.wordpress.com/2018/02/13/the-mystery-of-postmessage/)
				* [PostMessage Vulnerabilities. Part I - Jorge Lajara(2020)](https://jlajara.gitlab.io/web/2020/06/12/Dom_XSS_PostMessage.html)
					* [Part 2](https://jlajara.gitlab.io/web/2020/07/17/Dom_XSS_PostMessage_2.html)
		* **Talks/Presentations/Videos**
			* [In the DOM - no one will hear you scream - Mario Heiderich(Garage4Hackers Ranchoddas Webcast2014)](https://www.youtube.com/watch?v=5W-zGBKvLxk)
				* This talk is about the DOM and its more twilight areas. Well see the weird parts and talk about where and why this might be security critical and affect your precious online applications, browser extensions or packaged apps. To understand the foundations of what the DOM has become by today, we'll further explore the historical parts - who created the DOM, what was the intention and how fought dirty about it during the browser wars.  Finally, we'll see a DOM based attack called "DOM Clobbering". An attack, that is everything but obvious and affected a very popular and commonly used Rich Text Editor. Be prepared for a lot of tech-talk as well as fear and loathing in the browser window. But don't shed no tears, there's a tool that fixes the security crazy for you and this talk will present it.
			* [Don't Trust The DOM: Bypassing XSS Mitigations Via Script Gadgets - Sebastian Lekies(AppSecEU2017)](https://www.youtube.com/watch?v=p07acPBi-qw)
				* Over the years many techniques have been introduced to prevent or mitigate XSS. Thereby, most of these techniques such as HTML sanitizers or CSP focus on script tags and event handlers. In this talk, we present a novel Web hacking technique that enables an attacker to bypass these mitigations. In order to to so, the attacker abuses so-called script gadgets. A gadget Is a legitimate piece of JS in a page that reads elements via selectors and processes them in a way that results in script execution. To abuse a gadget, the attacker injects benign elements that match the gadget&rsquo;s selector. Subsequently, the gadget selects the elements and executes the attacker's scripts. As the attacker's markup is benign it passes HTML sanitizers and security policies. The XSS only surfaces when the gadget mistakenly elevates the privileges of the element. Based on real-world examples, we will demonstrate that these gadgets are present in almost all modern JavaScript libraries, APIs and applications.
			* [Breaking XSS Mitigations Via Script Gadgets - Sebastian Lekies, Krzysztof Kotowicz & Eduardo Vela(BHUSA2017)](https://www.youtube.com/watch?v=i6Ug8O23DMU)
				* In this talk, we present a novel Web hacking technique that enables an attacker to circumvent most XSS mitigations. In order to do so, the attacker abuses so-called script gadgets. A script gadget Is a legitimate piece of JavaScript in a page that reads elements from the DOM via selectors and processes them in a way that results in script execution
			* [Eval Villain: Simplifying DOM XSS and JS Reversing - Dennis Goodlett(BSidesCLE2019)]()
				* JavaScript cruft is growing faster than my ability to read. Since I can't read every line of code, I need tools to find important lines. Eval Villain is a web extension for Firefox that hooks native JavaScript functions *before* the page loads so that you will be notified every time a function is called. Eval Villain has discovered instances of DOM XSS that only appear in 1 of 100 page loads. It makes the reversing of malicious, second-stage encrypted JavaScript code trivial. I plan on walking through all the features of this tool using examples. To follow along, bring a computer that can run Firefox.https://www.irongeek.com/i.php?page=videos/bsidescleveland2019/bsides-cleveland-c-00-eval-villain-simplifying-dom-xss-and-js-reversing-dennis-goodlett
		* **Papers**
			* [DOM Based Cross Site Scripting or XSS of the Third Kind: A look at an overlooked flavor of XSS - Amit Klein(2005)](http://www.webappsec.org/projects/articles/071105.html)
		* **Tools**
			* [DOM XSS Intro - MechaTechSec](https://mechatechsec.blogspot.com/2018/01/dom-xss-intro.html)
			* [DOM-based XSS – The 3 Sinks - brutelogic.com](https://brutelogic.com.br/blog/dom-based-xss-the-3-sinks/)
			* [DOM Event reference - MDN(Mozilla)](https://developer.mozilla.org/en-US/docs/Web/Events)
		* **Writeups(DOM XSS)**
			* [$20000 Facebook DOM XSS - Vinoth Kumar(2020)](https://vinothkumar.me/20000-facebook-dom-xss/)
			* [INTIGRITI XSS CHALLENGE WRITE-UP - František Uhrecký(2019)](https://citadelo.com/en/blog/intigriti-xss-challenge-write-up/)
			* [The XSS challenge that +100k people saw but only 90 solved - intigrit(2019)](https://blog.intigriti.com/2019/05/06/intigriti-xss-challenge-1/)
			* [How our community hacked our own XSS challenge - Intigriti(2019)](https://blog.intigriti.com/2019/05/27/winner-announced-how-our-community-hacked-our-own-xss-challenge/)
			* [Intigriti Easter XSS Challenge Write-up - Abdullah Hussam(2020)](https://ahussam.me/intigriti-easter-xss-challenge/)
			* [Intigriti XSS Challenge Write-Up - Renaud Martinet(2019)](https://renaudmarti.net/posts/intigriti-xss-challenge/)
			* [Intigriti XSS Challenge #4 - PSPAUL(2019)](https://blog.pspaul.de/posts/intigriti-xss-challenge-4/)
			* [Intigriti Easter XSS Challenge 2020 Write Up - lboynton.com(2020)](https://lboynton.com/2020/04/20/intigriti-easter-xss-challenge-2020-write-up/)
			* [Intigriti XSS Challenge – Fun with DOM XSS - doyler.net(2019)](https://www.doyler.net/security-not-included/intigriti-xss-challenge-dom-xss)
			* [Solving Intigriti Challenge using… Content Injection! - Amal Murali(2020)](https://medium.com/@amalmurali47/solving-intigriti-challenge-using-content-injection-84e212cae00f)
			* [Finally! HOW TO solve the INTIGRITI Easter XSS challenge using only Chrome DEVTOOLS! - ST0K](https://www.youtube.com/watch?v=IhPsBMBDFcg)
		* **Mutation XSS**
			* **101**
				* [What is mutation XSS (mXSS)? - StackOverflow](https://security.stackexchange.com/questions/46836/what-is-mutation-xss-mxss)
			* **Articles/Blogposts/Writeups**
				* [mXSS - TheSpanner(2014)](http://www.thespanner.co.uk/2014/05/06/mxss/)
				* [Write-up of DOMPurify 2.0.0 bypass using mutation XSS - Michał Bentkowski(2019)](https://research.securitum.com/dompurify-bypass-using-mxss/)
				* [Mutation XSS - Infinite8security(2016)](https://infinite8security.blogspot.com/2016/02/mutation-xss.html)
				* [Mutation XSS in Google Search - Tomasz Andrzej Nidecki(2019)](https://www.acunetix.com/blog/web-security-zone/mutation-xss-in-google-search/)
				* [Mutation XSS- A Unique class of XSS - Pankaj Rane(2019)](http://www.insejournal.co.in/mutation-xss.html)
				* [Mutation XSS via namespace confusion – DOMPurify < 2.0.17 bypass - Michal Bentkowski (2020)](https://research.securitum.com/mutation-xss-via-mathml-mutation-dompurify-2-0-17-bypass/)
				* [Bypassing DOMPurify again with mutation XSS - Gareth Heyes(2020)](https://portswigger.net/research/bypassing-dompurify-again-with-mutation-xss)
			* **Talks/Presentations/Videos**
				* [How mXSS attacks change everything we believed to know so far - Mario Heiderich - OWASP AppSec EU 2013](https://www.youtube.com/watch?v=Haum9UpIQzU)
			* **Papers**
				* [mXSS attacks: Attacking well-secured web-applications by using innerHTML mutations - Mario Heiderich, Jörg Schwenk, Tilman Frosch, Jonas Magazinius(2013)](https://www.researchgate.net/publication/266654651_mXSS_attacks_Attacking_well-secured_web-applications_by_using_innerHTML_mutations)
					* Back in 2007, Hasegawa discovered a novel Cross-Site Scripting (XSS) vector based on the mistreatment of the backtick character in a single browser implementation. This initially looked like an implementation error that could easily be fixed. Instead, as this paper shows, it was the first example of a new class of XSS vectors, the class of mutation-based XSS (mXSS) vectors, which may occur in innerHTML and related properties. mXSS affects all three major browser families: IE, Firefox, and Chrome. We were able to place stored mXSS vectors in high-profile applications like Yahoo! Mail, Rediff Mail, OpenExchange, Zimbra, Roundcube, and several commercial products. mXSS vectors bypassed widely deployed server-side XSS protection techniques (like HTML Purifier, kses, htmlLawed, Blueprint and Google Caja), client-side filters (XSS Auditor, IE XSS Filter), Web Application Firewall (WAF) systems, as well as Intrusion Detection and Intrusion Prevention Systems (IDS/IPS). We describe a scenario in which seemingly immune entities are being rendered prone to an attack based on the behavior of an involved party, in our case the browser. Moreover, it proves very difficult to mitigate these attacks: In browser implementations, mXSS is closely related to performance enhancements applied to the HTML code before rendering; in server side filters, strict filter rules would break many web applications since the mXSS vectors presented in this paper are harmless when sent to the browser. This paper introduces and discusses a set of seven different subclasses of mXSS attacks, among which only one was previously known. The work evaluates the attack surface, showcases examples of vulnerable high-profile applications, and provides a set of practicable and low-overhead solutions to defend against these kinds of attacks.
				* [Automation of Mutated Cross Site Scripting - Anchal Tiwari, J. Jeysree](https://www.ijsr.net/archive/v4i4/SUB152876.pdf)	
					* Cross-Site Scripting (XSS) attacks are a type of injection, in which malicious scripts are injected into otherwise benign and trusted web sites. XSS attacks occur when an attacker uses a web application to send malicious code, generally in the form of a browser side script, to a different end user. Flaws that allow these attacks to succeed are quite widespread and occur anywhere a web application uses input from a user within the output it generates without validating or encoding it. In browsers Mutation event occur when there is a change in the DOM Structure of the browsers. There are various ways in which DOM structure could be changed among which innerHTML property is discussed specifically. mXSS is a new class of XSS vectors, the class of mutation-based XSS (mXSS) vectors, which may occur in innerHTML andrelated properties. mXSS affects all three major browserfamilies: IE, Firefox, and Chrome.mXSS could be placed in major browser families and effecting major web applications. In this paper we apply the idea of mutation-based testing technique to generate adequate test data sets for testing XSSVs. Our work addresses XSSVs related to web-applications that use PHP and JavaScript code to generate dynamic HTML contents. Finally there would be the development of an automatic tool which would generate mutants automatically, automatically testing the web application and finally giving the output.
	* **Persistent XSS**
		* **101**
		* **Articles/Blogposts/Writeups**
			* **General**
				* [Self-XSS + CSRF to Stored XSS - Renwa(2018)](https://medium.com/@renwa/self-xss-csrf-to-stored-xss-54f9f423a7f1)
				* [AirBnb Bug Bounty: Turning Self-XSS into Good-XSS #2 - Geekboy(2016)](https://www.geekboy.ninja/blog/airbnb-bug-bounty-turning-self-xss-into-good-xss-2/)
			* **Blind**
				* [Blind XSS for beginners - Syntax Error(2018)](https://medium.com/bugbountywriteup/blind-xss-for-beginners-c88e48083071)
			* **File-Based**
				* [XSS SVG - Ghostlulz](http://ghostlulz.com/xss-svg/)
				* [XSS on Facebook via PNGs & Wonky Content Types - whitton.io(2016)](https://whitton.io/articles/xss-on-facebook-via-png-content-types/)
				* [$1,000 USD IN 5 MINUTES, XSS STORED IN OUTLOOK.COM (IOS BROWSERS) - @omespino(2019)](https://omespino.com/write-up-1000-usd-in-5-minutes-xss-stored-in-outlook-com-ios-browsers/)
				* [Persistent XSS at AH.nl - Jonathan Bouman(2018)](https://medium.com/@jonathanbouman/persistent-xss-at-ah-nl-198fe7b4c781)
		* **Talks/Presentations/Videos**
		* **Papers**
	* **Reflected XSS**
		* **101**
		* **Articles/Blogposts/Writeups**
			* [Reflected XSS at Philips.com - Jonathan Bouman](https://medium.com/@jonathanbouman/reflected-xss-at-philips-com-e48bf8f9cd3c)
			* [How I XSS’ed Uber and Bypassed CSP - Efkan(2018)](https://medium.com/@efkan162/how-i-xssed-uber-and-bypassed-csp-9ae52404f4c5)
			* [admin.google.com Reflected Cross-Site Scripting (XSS) - Brett Buerhaus(2015)](https://buer.haus/2015/01/21/admin-google-com-reflected-cross-site-scripting-xss/)
			* [From Reflected XSS to Account Takeover — Showing XSS Impact - A Bug'z Life(2019)](https://medium.com/a-bugz-life/from-reflected-xss-to-account-takeover-showing-xss-impact-9bc6dd35d4e6)
			* [Reflected DOM XSS and CLICKJACKING on https://silvergoldbull.de/bt.html - Daniel Maksimovic(2018)](https://medium.com/bugbountywriteup/reflected-dom-xss-and-clickjacking-on-https-silvergoldbull-de-bt-html-daa36bdf7bf0)
		* **Talks/Presentations/Videos**
		* **Papers**
* **JS Framework-Specific**
    * **Angular**
    	* [XSS without HTML: Client-Side Template Injection with AngularJS - Gareth Hayes(2020)](https://portswigger.net/research/xss-without-html-client-side-template-injection-with-angularjs)
    	* [DOM Based Angular Sandbox Escapes by Gareth Heyes - BSides Manchester2017](https://www.youtube.com/watch?v=jlSI5aVTEIg&index=16&list=PLcgqQkap1lNrOBNCXqpPqpPAqckxv0XhP)
    * **React.js**
    	* [The Most Common XSS Vulnerability in React.js Applications - Emelia Smith(2016)](https://medium.com/node-security/the-most-common-xss-vulnerability-in-react-js-applications-2bdffbcc1fa0)
		* [Exploiting Script Injection Flaws in ReactJS Apps - Bernhard Mueller(2017)](https://medium.com/dailyjs/exploiting-script-injection-flaws-in-reactjs-883fb1fe36c1)
		* [Avoiding XSS in React is Still Hard - Ron Perris(2018)](https://medium.com/javascript-security/avoiding-xss-in-react-is-still-hard-d2b5c7ad9412)
		* [How Much XSS Vulnerability Protection is React Responsible For? #3473 Github Issue](https://github.com/facebook/react/issues/3473)
			* [Response #1](https://github.com/facebook/react/issues/3473#issuecomment-90594748)
			* [Response #2](https://github.com/facebook/react/issues/3473#issuecomment-91349525)
* **JSON Hijacking**
	* **101**
		* [JSON Hijacking Demystified - Rohini Sulatycki(2012)](https://www.trustwave.com/en-us/resources/blogs/spiderlabs-blog/json-hijacking-demystified/)
		* [Reflected XSS via JSON executed with Burp, but how to do it in realistic conditions? - StackOverflow](https://security.stackexchange.com/questions/150009/reflected-xss-via-json-executed-with-burp-but-how-to-do-it-in-realistic-conditi)
		* [XSS : Content-type: application/json - StackOverflow](https://security.stackexchange.com/questions/13821/xss-content-type-application-json)
		* [Is it possible to XSS exploit JSON responses with proper JavaScript string escaping - StackOverflow](https://stackoverflow.com/questions/3146324/is-it-possible-to-xss-exploit-json-responses-with-proper-javascript-string-escap)
	* **Articles/Blogposts/Writeups**
		* [Story of a JSON XSS - Nikhil Mittal(2017)](https://c0d3g33k.blogspot.com/2017/11/story-of-json-xss.html)
		* [JSON hijacking for the modern web - Gareth Heyes(2020)](https://portswigger.net/research/json-hijacking-for-the-modern-web)
		* [Exploiting JSON Framework : 7 Attack Shots - Aditya K. Sood](http://www.infosecwriters.com/Papers/ASood_ExploitingJSON.pdf)
		* [Attacking JSON Application : Pentesting JSON Application - Narendra Bhati(2018)](https://www.websecgeeks.com/2015/10/attacking-json-application-pentesting.html)
		* [Airbnb – When Bypassing JSON Encoding, XSS Filter, WAF, CSP, and Auditor turns into Eight Vulnerabilities - Brett Buerhaus](https://buer.haus/2017/03/08/airbnb-when-bypassing-json-encoding-xss-filter-waf-csp-and-auditor-turns-into-eight-vulnerabilities/)
		* [JSON based XSS - Koumudi Garikipati(2020)](https://medium.com/@koumudi.garikipati/json-based-xss-84089141c136)
		* [XSSing Google Code-in thanks to improperly escaped JSON data - Thomas Orlita](https://websecblog.com/vulns/google-code-in-xss/)
* **Testing**
	* [XSS Test String Dump](https://github.com/zsitro/XSS-test-dump/blob/master/xss.txt)
	* [HTML Purifier XSS Attacks Smoketest](http://htmlpurifier.org/live/smoketests/xssAttacks.php)
	* [Cross-site scripting (XSS) cheat sheet - PortSwigger](https://portswigger.net/web-security/cross-site-scripting/cheat-sheet)
		* This cross-site scripting (XSS) cheat sheet contains many vectors that can help you bypass WAFs and filters. You can select vectors by the event, tag or browser and a proof of concept is included for every vector. This cheat sheet is regularly updated in 2019. Last updated: Fri, 08 Nov 2019
* **Training**
	* [XSS-Game.appspot](https://xss-game.appspot.com/)
	* [Firing-Range](https://github.com/google/firing-range)
		* Firing Range is a test bed for web application security scanners, providing synthetic, wide coverage for an array of vulnerabilities.
	* [XSSer](https://xsser.03c8.net/)
	* [prompt.ml - XSS Injection Game](http://prompt.ml/about)
	* [alert1 to win - XSS Injection Game](https://alf.nu/)
* **Tools**
	* [xsscrapy](https://github.com/byt3bl33d3r/xsscrapy)
	* [XSS Sniper](https://sourceforge.net/projects/xssniper/)
	* [Xenotix](https://github.com/ajinabraham/OWASP-Xenotix-XSS-Exploit-Framework)
		* OWASP Xenotix XSS Exploit Framework is an advanced Cross Site Scripting (XSS) vulnerability detection and exploitation framework.
	* [xssValidator](https://github.com/nVisium/xssValidator)
		* This is a burp intruder extender that is designed for automation and validation of XSS vulnerabilities. 
	* [Shuriken](https://github.com/shogunlab/shuriken)
		* Cross-Site Scripting (XSS) command line tool for testing lists of XSS payloads on web apps.
	* [XSStrike](https://github.com/UltimateHackers/XSStrike)
		* XSStrike is an advanced XSS detection and exploitation suite. 
	* [iframeBusterXSS](https://github.com/tr4l/iframeBusterXSS)
		* Check for know iframeBuster XSS
	* [XSS tag_event analyzer](https://gitlab.com/jlajara/xss-tag_event-analyzer)
		* Script to test suitable XSS payloads when tag/events are validated in a weak way.
	* [Security Headers(scanner)](https://securityheaders.com)
* **Writeups**
	* [Writing an XSS Worm](http://blog.gdssecurity.com/labs/2013/5/8/writing-an-xss-worm.html)
	* [XSS without HTML: Client-Side Template Injection with AngularJS](https://portswigger.net/blog/xss-without-html-client-side-template-injection-with-angularjs)
	* [XSS in AngularJS video series (walkthrough) - explaining some AngularJS sandbox bypasses, which resulted in the removal of the sandbox in 1.6](https://www.reddit.com/r/angularjs/comments/557bhr/xss_in_angularjs_video_series_walkthrough/)
	* [Chaining Cache Poisoning To Stored XSS - Rohan Aggarwal](https://medium.com/@nahoragg/chaining-cache-poisoning-to-stored-xss-b910076bda4f)
	* [Stealing JWTs in localStorage via XSS -David Roccasalva ](https://medium.com/redteam/stealing-jwts-in-localstorage-via-xss-6048d91378a0)
	* [Penetration testing & window.opener — XSS vectors part 1 - Josh Graham](https://medium.com/tsscyber/penetration-testing-window-opener-xss-vectors-part-1-c6be37701cab)
	* [A Questionable Journey From XSS to RCE - Dominik Penner](https://zero.lol/2019-05-13-xss-to-rce/)
	* [Firefox uXSS and CSS XSS - leucosite.com](https://leucosite.com/Firefox-uXSS-and-CSS-XSS/)
	* [Referer XSS with a Side of Link Injection - doyler.net](https://www.doyler.net/security-not-included/referer-xss)
	* [XSS in steam react chat client - Zemmez](https://hackerone.com/reports/409850)
	* [Cerberus FTP Blind Cross-Site Scripting to remote code execution as SYSTEM. (Version 9 and 10) - Kevin(secu.dk)]
	* [Winning Intigriti's XSS Challenge - Ryan Wise](https://ryanwise.me/intigriti-xss-challenge/)
	* [iOS Bug Hunting – Web View XSS - Allyson O'Malley](https://www.allysonomalley.com/2018/12/03/ios-bug-hunting-web-view-xss/)
	* [XSS in GMail’s AMP4Email via DOM Clobbering - Michal Bentkowski](https://research.securitum.com/xss-in-amp4email-dom-clobbering/)
	* [Auditing a Payment Processing of a Booking Framework - Jorge Lajara(2018)](https://jlajara.gitlab.io/web/2018/10/07/payment-processing-booking.html)
		* This article is thanks to the collaboration with Rayco Betancor and his crazy ideas and deep knowledge of how a Payment processing works, and a lot of trying different requests, forcing errors and trying harder.
	* [Sarahah XSS Exploitation Tool - Compromising Sarahah Users. - Shawar Khan](https://www.shawarkhan.com/2017/08/sarahah-xss-exploitation-tool.html)
	* [A Questionable Journey From XSS to RCE - Dominik Penner(2019)](https://zero.lol/2019-05-13-xss-to-rce/)
	* [Documenting the impossible: Unexploitable XSS labs - Gareth Heyes](https://portswigger.net/research/documenting-the-impossible-unexploitable-xss-labs)
	* [Art of bug bounty: a way from JS file analysis to XSS - Jakub Żoczek(2020)](https://research.securitum.com/art-of-bug-bounty-a-way-from-js-file-analysis-to-xss/)
	* [XSS a Paste Service - Pasteurize (web) Google CTF 2020 - LiveOVerflow(2020)](https://www.youtube.com/watch?v=Tw7ucd2lKBk)
	* [URL validation bypass | Filedescriptor solves Intigriti's XSS challenge - Reconless(2020)](https://www.youtube.com/watch?v=KpkrTUHoWsQ)
* **Payloads**
	* [Cross Site Scripting (XSS) Vulnerability Payload List](https://github.com/payloadbox/xss-payload-list)
	* [Stealing HttpOnly Cookie via XSS - Yasser Gersy(2018)](https://medium.com/@yassergersy/xss-to-session-hijack-6039e11e6a81)
	* [Tiny-XSS-Payloads](https://github.com/terjanq/Tiny-XSS-Payloads)
		* A collection of tiny XSS Payloads that can be used in different contexts.


----------------------------------------------------------------------------------------------------------------
























----------------------------------------------------------------------------------------------------------------
### <a name="xml"></a>XML
* **101**
	* [XML Schema, DTD, and Entity Attacks A Compendium of Known Techniques - Timothy D. Morgan, Omar Al Ibrahim]
	* [XML Schema, DTD, and Entity Attacks: A Compendium of Known Techniques - Timothy D. Morgan, Omar Al Ibrahim(2014)](www.vsecurity.com/download/papers/XMLDTDEntityAttacks.pdf)
* **DOS**
	* **Articles/Papers/Talks/Writeups**
		* [Security Briefs - XML Denial of Service Attacks and Defenses(2009)](https://msdn.microsoft.com/en-us/magazine/ee335713.aspx)
* **XXE Attack**
	* **101**
		* [XXE (Xml eXternal Entity) attack(2002) - Gregory Steuck](https://www.securityfocus.com/archive/1/297714/2002-10-27/2002-11-02/0)
	* **Articles/Papers/Talks/Writeups**
		* [Hunting in the Dark - Blind XXE](https://blog.zsec.uk/blind-xxe-learning/)
		* [Exploiting Out Of Band XXE using internal network and php wrappers - Mahmoud Gamal](https://mahmoudsec.blogspot.com/2019/08/exploiting-out-of-band-xxe-using.html)
		* [Playing with Content-Type – XXE on JSON Endpoints - Antti Rantasaari](https://blog.netspi.com/playing-content-type-xxe-json-endpoints/)
		* [XXE: How to become a Jedi - Yaroslav Babin(Zeronights 2017)](https://www.slideshare.net/ssuserf09cba/xxe-how-to-become-a-jedi)
		* [Advice From A Researcher: Hunting XXE For Fun and Profit](http://blog.bugcrowd.com/advice-from-a-researcher-xxe/)
		* [Leading the Blind to Light! - A Chain to RCE](https://blog.zsec.uk/rce-chain/)
		* [Generic XXE Detection - Christian Schneider](http://www.christian-schneider.net/GenericXxeDetection.html)
		* [Playing with Content-Type – XXE on JSON Endpoints - NETSPI](https://blog.netspi.com/playing-content-type-xxe-json-endpoints/)
		* [XXE OOB exploitation at Java 1.7+ - 2014](http://lab.onsec.ru/2014/06/xxe-oob-exploitation-at-java-17.html)
		* [Security of applications that parse XML (supplementary) - 2009](http://d.hatena.ne.jp/teracc/20090718)
		* [Exploiting XXE In File Upload Functionality](https://www.blackhat.com/docs/us-15/materials/us-15-Vandevanter-Exploiting-XXE-Vulnerabilities-In-File-Parsing-Functionality.pdf)
		* [XML Parser Evaluation - web-in-security.blogspot.de](https://web-in-security.blogspot.de/2016/03/xml-parser-evaluation.html)
		* [Hiding in Plain Sight: XXE Vulnerability in HP Project & Portfolio Mgmt Center - Benjamin Caudill](https://rhinosecuritylabs.com/application-security/xxe-zeroday-vulnerability-in-hp-project/)
		* [Don’t open that XML: XXE to RCE in XML plugins for VS Code, Eclipse, Theia, … - thezero](https://www.shielder.it/blog/dont-open-that-xml-xxe-to-rce-in-xml-plugins-for-vs-code-eclipse-theia/)
		* [Playing with Content-Type – XXE on JSON Endpoints(2015) - Antti Rantasaari](https://blog.netspi.com/playing-content-type-xxe-json-endpoints/)
	* **Talks/Presentations/Videos**
		* [Black Hat EU 2013 - XML Out-of-Band Data Retrieval](https://www.youtube.com/watch?v=eBm0YhBrT_c)
			* [Slides: XML Out-­Of-Band Data Retrieval - BHEU 2013](https://media.blackhat.com/eu-13/briefings/Osipov/bh-eu-13-XML-data-osipov-slides.pdf)
		* [What You Didn't Know About XML External Entities Attacks - Timothy D. Morgan](http://2013.appsecusa.org/2013/wp-content/uploads/2013/12/WhatYouDidntKnowAboutXXEAttacks.pdf)
		* [Exploiting XXE Vulnerabilities In File Parsing Functionality - Willis Vandevanter - BHUSA 2015](https://www.youtube.com/watch?v=LZUlw8hHp44)
			* In this 25-minute briefing, we will discuss techniques for exploiting XXE vulnerabilities in File Parsing/Upload functionality. Specifically, XML Entity Attacks are well known, but their exploitation inside XML supported file formats such as docx, xlsx, pptx, and others are not. Discussing the technically relevant points step by step, we will use real world examples from products and recent bug bounties. Finally, in our experience, creating 'XXE backdoored' files can be a very slow process. We will introduce our battle tested tool for infecting the file formats discussed.
		* [FileCry - The New Age of XXE - BH USA 2015](https://www.blackhat.com/docs/us-15/materials/us-15-Wang-FileCry-The-New-Age-Of-XXE.pdf)
	* **Papers**
		* [Security Implications of DTD Attacks Against a Wide Range of XML Parsers](https://www.nds.rub.de/media/nds/arbeiten/2015/11/04/spaeth-dtd_attacks.pdf)
	* **CVEs**
		* [Exploiting CVE-2016-4264 With OXML_XXE](https://www.silentrobots.com/blog/2016/10/02/exploiting-cve-2016-4264-with-oxml-xxe/)
* **Reference**
	* [Testing for XML Injection (OTG-INPVAL-008) - OWASP](https://www.owasp.org/index.php/Testing_for_XML_Injection_(OTG-INPVAL-008))
	* [XML Security Cheat Sheet - OWASP](https://www.owasp.org/index.php/XML_Security_Cheat_Sheet)
	* [XML External Entity (XXE) Prevention Cheat Sheet - OWASP](https://www.owasp.org/index.php/XML_External_Entity_(XXE)\_Prevention_Cheat_Sheet)
	* [XML External Entity (XXE) Processing](https://www.owasp.org/index.php/XML_External_Entity_(XXE)\_Processing)
* **Tools**
	* [XXEinjector](https://github.com/enjoiz/XXEinjector)
		* XXEinjector automates retrieving files using direct and out of band methods. Directory listing only works in Java applications. Bruteforcing method needs to be used for other applications
	* [oxml_xxe](https://github.com/BuffaloWill/oxml_xxe)
		* This tool is meant to help test XXE vulnerabilities in file formats. 
* **Miscellaneous**
	* [XML External Entity Injection in Jive-n (CVE-2018-5758) - Spencer Gietzen](https://rhinosecuritylabs.com/research/xml-external-entity-injection-xxe-cve-2018-5758/)


----------------------------------------------------------------------------------------------------------------

## End of Attacks section

----------------------------------------------------------------------------------------------------------------












----------------------------------------------------------------------------------------------------------------


## <a name="misc">Miscellaneous</a>
- **Wordlists**
	- Lists
		* [jhaddix all.txt](https://gist.github.com/jhaddix/f64c97d0863a78454e44c2f7119c2a6a)
			*  all wordlists from every dns enumeration tool... ever. Please excuse the lewd entries =/ 
		* [jhaddix content_discovery_all.txt](https://gist.github.com/jhaddix/b80ea67d85c13206125806f0828f4d10)
			* a masterlist of content discovery URLs and files (used most commonly with gobuster) 
		* [SecLists](https://github.com/danielmiessler/SecLists)
			* SecLists is the security tester's companion. It's a collection of multiple types of lists used during security assessments, collected in one place. List types include usernames, passwords, URLs, sensitive data patterns, fuzzing payloads, web shells, and many more.
		* [IntruderPayloads](https://github.com/1N3/IntruderPayloads)
			* A collection of Burpsuite Intruder payloads, BurpBounty payloads (https://github.com/wagiro/BurpBounty), fuzz lists and pentesting methodologies.
		* [CommonSpeak2](https://github.com/assetnote/commonspeak2)
		* [CWFF - Custom wordlists for fuzzing](https://github.com/D4Vinci/CWFF)
			* CWFF is a tool that creates a special High quality fuzzing/content discovery wordlist for you at the highest speed possible using concurrency and it's heavily inspired by @tomnomnom's Who, What, Where, When, Wordlist
		* [1ndiList v 1.0](https://github.com/1ndianl33t/1ndiList)
			* Recon Custom WordList Ganerator 
		* [Who, What, Where, When, Wordlist - TomNomNom](https://tomnomnom.com/talks/wwwww.pdf)
		* [OneListForAll](https://github.com/six2dez/OneListForAll)
			* Rockyou for web fuzzing
		* [Samlists](https://github.com/the-xentropy/samlists)
			* "Free, libre, effective, and data-driven wordlists for all!"
		* [Payloads](https://github.com/sh377c0d3/Payloads)
			* "Payload Arsenal for Pentration Tester and Bug Bounty Hunters"
		* [webapp-wordlists](https://github.com/p0dalirius/webapp-wordlists/)
			* This repository contains wordlists for each versions of common web applications and content management systems (CMS). Each version contains a wordlist of all the files directories for this version.
		* [RFI/LFI Payload List](https://github.com/payloadbox/rfi-lfi-payload-list)
		* [all.txt - jhaddix](https://gist.github.com/jhaddix/86a06c5dc309d08580a018c66354a056)
			* "all wordlists from every dns enumeration tool... ever. Please excuse the lewd entries =/"
		* [sql-injection-payload-list](https://github.com/payloadbox/sql-injection-payload-list)
		* [xxe-injection-payload-list](https://github.com/payloadbox/xxe-injection-payload-list)
		* [Big List of Naughty Strings](https://github.com/minimaxir/big-list-of-naughty-strings)
			* The Big List of Naughty Strings is an evolving list of strings which have a high probability of causing issues when used as user-input data. This is intended for use in helping both automated and manual QA testing; useful for whenever your QA engineer walks into a bar.
		* [subdirectories-discover](https://github.com/aels/subdirectories-discover)
			* "Perfect wordlist to discover directories and files on target site with tools like ffuf."
		* [wordlists - assetnote](https://github.com/assetnote/wordlists)
			* Automated & Manual Wordlists provided by Assetnote
		* [n0kovo subdomain wordlist](https://github.com/n0kovo/n0kovo_subdomains)
			* A subdomain wordlist of 3,000,000 lines, crafted by harvesting SSL certs from the entire IPv4 space.
	- **Creation of**
		* [Assetnote Wordlists](https://wordlists.assetnote.io/)
			* "This website provides you with wordlists that are up to date and effective against the most popular technologies on the internet. Wordlists are generated on the 28th of each month, using Commonspeak2 and GitHub Actions. If there's an extension or technology that you would like a wordlist for, but it's not in the table below, send us a PR and it will be included on this page after the next run."
		* [Who, What, Where, When, Wordlist - @TomNomNom(NahamCon2020)](https://www.youtube.com/watch?v=W4_QCSIujQ4&list=PLKAaMVNxvLmAD0ZVUJ2IGFFC0APFZ5gzy&index=8)
- **Payload Lists**
	* [PayloadsAllTheThings](https://github.com/swisskyrepo/PayloadsAllTheThings)
	* [weapons4pentester](https://github.com/merttasci/weapons4pentester)
	* [IntruderPayloads](https://github.com/1N3/IntruderPayloads/blob/master/README.md)


----------------------------------------------------------------------------------------------------------------


### <a name="burpstuff">Burpsuite Stuff/Plugins</a>
* **Tutorials/Tips/Stuff**
	* **101**
		* [Issue Definitions](https://portswigger.net/kb/issues)
			* This listing contains the definitions of all issues that can be detected by Burp Scanner.
		* [Burp Suite Training - PortSwigger](https://portswigger.net/training)
	* **Articles/Blogposts/Writeups**
		* [Various Burp Resources - agarri.fr](https://hackademy.agarri.fr/freebies)
		* [Burp Pro : Real-life tips and tricks](https://hackinparis.com/talk-nicolazs-gregoire)
		* [Behind enemy lines: Bug hunting with Burp Infiltrator](http://blog.portswigger.net/2017/06/behind-enemy-lines-bug-hunting-with.html)
		* [Automating Web Apps Input fuzzing via Burp Macros](http://blog.securelayer7.net/automating-web-apps-input-fuzzing-via-burp-macros/)
		* [Intro to Web App Security Testing: Logging - Aaron James(2020](https://www.trustedsec.com/blog/intro-to-web-app-security-testing-logging/)
			* "The Logger++ extension is a great tool for recording requests and responses across all of Burp Suite. However, it is important to ensure enough log entries are retained from the tools you expect and that logs are exported if you want to keep them (my preference is automatic export to CSV)."
		* [SSH "accept : too many open files" on OS X when using Burp - dewhurstsecurity.com(2013)](https://blog.dewhurstsecurity.com/2013/04/08/ssh-too-many-open-files-burp.html)
		* [Burp Suite Visual Aids - lanmaster53(2015)](https://www.lanmaster53.com/2015/04/24/burp-suite-visual-aids/)
		* [Brute Forcing with Burp - Pentesters Tips & Tricks Week 1 - securenetwork.com(2017)](https://www.securenetworkinc.com/news/2017/7/16/brute-forcing-with-burp-pentesters-tips-tricks-week-1)
		* [How to Burp Good - n00py(2017)](https://www.n00py.io/2017/10/how-to-burp-good/)
		* [Towards a Quieter Firefox - Brian King(2017)](https://www.blackhillsinfosec.com/towards-quieter-firefox/)	
		* [Quality of Life Tips and Tricks - Burp Suite - Parsia(2019)](https://parsiya.net/blog/2019-10-13-quality-of-life-tips-and-tricks-burp-suite/)
		* [Using Burp’s session Handling Rules to insert authorization cookies into Intruder, Repeater and even sqlmap - NVISO(2019)](https://blog.nviso.eu/2019/08/29/using-burps-session-handling-rules-to-insert-authorization-cookies-into-intruderrepeater-and-even-sqlmap/)
		* [Detecting and annoying Burp users - Julien Voisin(2021)](https://dustri.org/b/detecting-and-annoying-burp-users.html)
		* [Burp Automation | Automating Burp Scanning Via Rest API & Robot Framework Using Python3 - Divyanshu(2021)](https://infosecwriteups.com/burp-automation-automating-burp-scanning-via-rest-api-robot-framework-using-python3-78aebdd35c53)
		* [Proxy managed by enterprise? No problem! Abusing PAC and the registry to get burpin’ - Thomas Grimee(2021)](https://blog.nviso.eu/2021/08/17/proxy-managed-by-enterprise-no-problem-abusing-pac-and-the-registry-to-get-burpin/)
		* [Burp Suite: Match And Replace - thexssrat(2021)](https://thexssrat.medium.com/burp-suite-match-and-replace-babac6415cad)
		* [PimpMyBurp #1 – PwnFox + Autorize: The perfect combo to find IDOR - @adrien_jeanneau(2021)](https://blog.yeswehack.com/yeswerhackers/pimpmyburp-pwnfox-autorize-find-idor/)
			* [PimpMyBurp #2 – Auth Analyzer : How to test horizontal and vertical privileges escalation](https://blog.yeswehack.com/yeswerhackers/pimpmyburp-auth-analyzer-test-horizontal-vertical-privileges-escalation/)
			* [PimpMyBurp #3 – AutoRepeater: add automation to your beautiful hunter life](https://blog.yeswehack.com/yeswerhackers/pimpmyburp/pimpmyburp-autorepeater-add-automation-burp-suite/)
			* [PimpMyBurp #5 – Intruder: Use the tool to its full advantage - Nicolas Grégoire(2021)](https://blog.yeswehack.com/category/yeswerhackers/pimpmyburp/)
		* [Automating Authorization Testing: AuthMatrix: Part 1 - Tib3rius(2021)](https://www.whiteoaksecurity.com/blog/authorization-testing-authmatrix-part-1/)
			* [Part 2](https://www.whiteoaksecurity.com/blog/automating-authorization-testing-authmatrix-part-2/)
	* **Talks/Presentations/Videos**
		* [OWASP Top 10: Hacking Web Applications with Burp Suite - Chad Furman](https://www.youtube.com/watch?v=2p6twRRXK_o)
		* [Tactical Burp Suite: Next steps webcast - SecureIdeas(2020)](https://www.youtube.com/watch?v=DFnxptySDgI&feature=youtu.be)
			* Secure Ideas' Tactical Burp: Next Steps is a two-hour video exploring topics related to Burp Suite and its use in a web application penetration test. This course explores the various features of Burp Suite, focusing on how we use the system during our penetration testing.
		* [Burp Macro Auto Authentication - CyberSecurityTV(2020)](https://www.youtube.com/watch?v=Ba2EzXP4swE)
			* Burp session handling rules are very powerful. In this episode, we have seen an example of how to configure burp to auto login or activate session after it detects session invalidity.
- **Plugins**<a name="burpplugin"></a>
	* [Collection of Burp Suite Extensions](https://apps.burpsuite.guide/)
	- **Creating**
		* [Adapting Burp Extensions for Tailored Pentesting](http://blog.portswigger.net/2017/08/adapting-burp-extensions-for-tailored.html)
		* [Developing Burp Suite Extensions - DOYENSEC](https://github.com/doyensec/burpdeveltraining)
			* Material for the training "Developing Burp Suite Extensions – From Manual Testing to Security Automation"
		* [Developing and Debugging Java Burp Extensions with Visual Studio Code - Parsia(2019)](https://parsiya.net/blog/2019-12-02-developing-and-debugging-java-burp-extensions-with-visual-studio-code/)
		* [Burp Extension Generator](https://github.com/rsrdesarrollo/generator-burp-extension)
			* Everything you need about Burp Extension Generation
		* [Burp Suite Extension Development - Ismail Tasdelen(2022)](https://infosecwriteups.com/burp-suite-extension-development-b177bddaa940)
	- **API**
		* [burp-rest-api](https://github.com/vmware/burp-rest-api)
			* A REST/JSON API to the Burp Suite security tool.  Upon successfully building the project, an executable JAR file is created with the Burp Suite Professional JAR bundled in it. When the JAR is launched, it provides a REST/JSON endpoint to access the Scanner, Spider, Proxy and other features of the Burp Suite Professional security tool.
	- **AuthN/AuthZ-related**
		* [AuthMatrix](https://github.com/SecurityInnovation/AuthMatrix)
			* AuthMatrix is a Burp Suite extension that provides a simple way to test authorization in web applications and web services. 
		* [Autorize](https://github.com/Quitten/Autorize)
			* Autorize is an automatic authorization enforcement detection extension for Burp Suite. It was written in Python by Barak Tawily, an application security expert, and Federico Dotta, a security expert at Mediaservice.net. Autorize was designed to help security testers by performing automatic authorization tests. With the last release now Autorize also perform automatic authentication tests.
		* [Escalating Privileges like a Pro - Gaurav Narwani](https://gauravnarwani.com/escalating-privileges-like-a-pro/)
		* [AutoRepeater](https://github.com/nccgroup/AutoRepeater)
			* Burp Suite is an intercepting HTTP Proxy, and it is the defacto tool for performing web application security testing. While Burp Suite is a very useful tool, using it to perform authorization testing is often a tedious effort involving a "change request and resend" loop, which can miss vulnerabilities and slow down testing. AutoRepeater, an open source Burp Suite extension, was developed to alleviate this effort. AutoRepeater automates and streamlines web application authorization testing, and provides security researchers with an easy-to-use tool for automatically duplicating, modifying, and resending requests within Burp Suite while quickly evaluating the differences in responses.
		* [Uniqueness plugin for Burp Suite](https://github.com/silentsignal/burp-uniqueness)
			* Makes requests unique based on regular expressions. Handy for registration forms and any other endpoint that requires unique values upon every request.
	- **Code Scanning**
		* [semgrepper](https://github.com/gand3lf/semgrepper)
	- **Collaborator-related**
		* [Running Your Instance of Burp Collaborator Server - blog.fabiopires.pt](https://blog.fabiopires.pt/running-your-instance-of-burp-collaborator-server/)
		* [collaborator-everywhere](https://github.com/PortSwigger/collaborator-everywhere)
			* A Burp Suite Pro extension which augments your proxy traffic by injecting non-invasive headers designed to reveal backend systems by causing pingbacks to Burp Collaborator
	- **Diagramming**
		* [PESD Exporter](https://github.com/doyensec/PESD-Exporter-Extension)
			* Generate security-oriented sequence diagrams and fine-grained parsed traffic from Burp Suite Proxy history.
	- **Extra-Checks/Scanners**
		* [backslash-powered-scanner](https://github.com/PortSwigger/backslash-powered-scanner)
			* This extension complements Burp's active scanner by using a novel approach capable of finding and confirming both known and unknown classes of server-side injection vulnerabilities. Evolved from classic manual techniques, this approach reaps many of the benefits of manual testing including casual WAF evasion, a tiny network footprint, and flexibility in the face of input filtering.
		* [HUNT](https://github.com/bugcrowd/HUNT)
			* HUNT is a Burp Suite extension to: 1. Identify common parameters vulnerable to certain vulnerability classes; 2. Organize testing methodologies inside of Burp Suite;
		* [Burp-molly-pack](https://github.com/yandex/burp-molly-pack)
			* Burp-molly-pack is Yandex security checks pack for Burp. The main goal of Burp-molly-pack is to extend Burp checks. Plugins contains Active and Passive security checks.
		* [burp-suite-error-message-checks](https://github.com/ewilded/burp-suite-error-message-checks)
			* Burp Suite extension to passively scan for applications revealing server error messages
		* [Asset Discover](https://github.com/redhuntlabs/BurpSuite-Asset_Discover)
			* Burp Suite extension to discover assets from HTTP response using passive scanning.
			* [Blogpost](https://redhuntlabs.com/blog/asset-discovery-burp-extension.html)
		* [Dr. Watson](https://github.com/prodigysml/Dr.-Watson)
			* Dr. Watson is a simple Burp Suite extension that helps find assets, keys, subdomains, IP addresses, and other useful information! It's your very own discovery side kick, the Dr. Watson to your Sherlock!
		* [LinkDumper Burp Plugin](https://github.com/arbazkiraak/LinksDumper)
			* Extract (links/possible endpoints) from responses & filter them via decoding/sorting
		* [BurpExtenderHeaderChecks](https://github.com/eonlight/BurpExtenderHeaderChecks)
		* [SQLTruncScanner](https://github.com/InitRoot/BurpSQLTruncSanner)
			* Messy BurpSuite plugin for SQL Truncation vulnerabilities.
		* [Asset_Discover](https://github.com/redhuntlabs/BurpSuite-Asset_Discover)
			* Burp Suite extension to discover assets from HTTP response using passive scanning.
	* **Extended-Functionality**
		* [burp-highlighter](https://github.com/CarveSystems/burp-highlighter/)
			* [Blogpost](https://carvesystems.com/news/rule-based-highlighter-plugin-for-burpsuite/)
		* [Exporter Extension for Burp Suite](https://github.com/artssec/burp-exporter)
			* Exporter is a Burp Suite extension to copy a request to the clipboard as multiple programming languages functions.
		* [Stepper](https://github.com/portswigger/stepper)
			* Stepper is designed to be a natural evolution of Burp Suite's Repeater tool, providing the ability to create sequences of steps and define regular expressions to extract values from responses which can then be used in subsequent steps.
		* [BurpSuiteSharpener](https://github.com/mdsecresearch/BurpSuiteSharpener)
			* "This extension should add a number of UI and functional features to Burp Suite to make working with it easier."
		* [Piper](https://github.com/silentsignal/burp-piper)
			* [Unix-style approach to web application testing - Andras Veres-Szentkiralyi(2020)](https://www.sans.org/reading-room/whitepapers/testing/paper/39440)
				* Web application testers of our time have lots of tools at their disposal. Some of these offer the option to be extended in ways the original developers did not think of, thus making their tool more useful. However, developing extensions or plugins have entry barriers in the form of fixed costs, boilerplate, et cetera. At the same time, many problems already have a solution designed as a smaller standalone program, which could be combined in the Unix fashion to produce a useful complex tool quickly and easily. In this paper, a (meta)solution is introduced for this integration problem by lowering the entry barriers and offer several examples that demonstrate how it saved time in web application assessments. 
		* [burp-copy-as-ffuf](https://github.com/d3k4z/burp-copy-as-ffuf)
			* Burp Extension that copies a request and builds a FFUF skeleton
		* [Burp Bounty](https://github.com/wagiro/BurpBounty)
			* "Burp Bounty (Scan Check Builder in BApp Store) is a extension of Burp Suite that allows you, in a quick and simple way, to improve the active and passive scanner by means of personalized rules through a very intuitive graphical interface."
		* [Autowasp](https://github.com/GovTech-CSG/Autowasp)
			* a Burp Suite extension that integrates Burp issues logging, with OWASP Web Security Testing Guide (WSTG), to provide a streamlined web security testing flow
		* [burpa](https://github.com/tristanlatr/burpa)
			* Burp Automator - A Burp Suite Automation Tool. It provides a high level CLI and Python interfaces to Burp Suite scanner and can be used to setup Dynamic Application Security Testing (DAST). 
	- **File Upload**
		* [UploadScanner Burp extension](https://github.com/modzero/mod0BurpUploadScanner)
			* A Burp Suite Pro extension to do security tests for HTTP file uploads.
	* **Forced-Browsing/File Discovery**
		* [BurpSmartBuster](https://github.com/pathetiq/BurpSmartBuster)
			* Looks for files, directories and file extensions based on current requests received by Burp Suite
	* **J2EE**
		* [J2EEScan](https://github.com/ilmila/J2EEScan)
			* J2EEScan is a plugin for Burp Suite Proxy. The goal of this plugin is to improve the test coverage during web application penetration tests on J2EE applications.
	* **JavaScript**
		* [BitMapper](https://github.com/BitTheByte/BitMapper)
			* Burp-suite Extension For finding .map files
	* **JSONP**
		* [jsonp](https://github.com/kapytein/jsonp)
			* jsonp is a Burp Extension which attempts to reveal JSONP functionality behind JSON endpoints. This could help reveal cross-site script inclusion vulnerabilities or aid in bypassing content security policies.
	* **JWTs**
		* [JWT4B](https://github.com/mvetsch/JWT4B)
			* JSON Web Tokens (JWT) support for the Burp Interception Proxy. JWT4B will let you manipulate a JWT on the fly, automate common attacks against JWT and decode it for you in the proxy history. JWT4B automagically detects JWTs in the form of 'Authorization Bearer' headers as well as customizable post body parameters.
		* [jwt-heartbreaker](https://github.com/wallarm/jwt-heartbreaker)
			* The Burp extension to check JWT (JSON Web Tokens) for using keys from known from public sources
			* [Blogpost](https://lab.wallarm.com/meet-jwt-heartbreaker-a-burp-extension-that-finds-thousands-weak-secrets-automatically/)
	- **Protobufs**
	 	* [burp-protobuf-decoder](https://github.com/federicodotta/protobuf-decoder)
 			* A simple Google Protobuf Decoder for Burp
		* [Blackbox Protobuf](https://github.com/nccgroup/blackboxprotobuf)
			* Blackbox protobuf is a Burp Suite extension for decoding and modifying arbitrary protobuf messages without the protobuf type definition.
	* **Proxy**
		* [NoPE Proxy](https://github.com/summitt/Burp-Non-HTTP-Extension)
			* Non-HTTP Protocol Extension (NoPE) Proxy and DNS for Burp Suite.
	* **Postman**
		* [Postman-Integration](https://github.com/PortSwigger/postman-integration)
			* Postman Integration is an extension for burp to generate Postman collection fomat json file.
	- **Repeater**
		* [RepeaterSearch](https://github.com/Static-Flow/RepeaterSearch)
			* "This extension adds a search bar to the Repeater tab that can be used to highlight all repeater tabs where the request and/or response matches a query via simple text matching or Regex."
		* [Bookmarks](https://github.com/cak/Bookmarks)
			* "A Burp Suite extension to bookmark requests for later, instead of those 100 unnamed repeater tabs you've got open."
	* **SAML**
		* [SAML Raider](https://github.com/SAMLRaider/SAMLRaider)
			* SAML Raider is a Burp Suite extension for testing SAML infrastructures. It contains two core functionalities: Manipulating SAML Messages and manage X.509 certificates.
	* **Serialization**
		* [Freddy the Serial(isation) Killer - Deserialization Bug Finder](https://github.com/nccgroup/freddy)
			* A Burp Suite extension to aid in detecting and exploiting serialisation libraries/APIs.
	* **Single-Page-Apps**
		* [BurpKit](https://github.com/allfro/BurpKit)
			* BurpKit is a BurpSuite plugin which helps in assessing complex web apps that render the contents of their pages dynamically. It also provides a bi-directional Script bridge API which allows users to create quick one-off BurpSuite plugin prototypes which can interact directly with the DOM and Burp's extender API.
	* **Sitemap**
		* [PwnBack](https://github.com/k4ch0w/PwnBack)
			* Burp Extender plugin that generates a sitemap of a website using Wayback Machine
	* **SQL Injection**
		* [sqlipy](https://github.com/portswigger/sqli-py)
			 * SQLiPy is a Python plugin for Burp Suite that integrates SQLMap using the SQLMap API. 
		* [SQLi Query Tampering](https://github.com/xer0days/SQLi-Query-Tampering)
			* SQLi Query Tampering extends and adds custom Payload Generator/Processor in Burp Suite's Intruder. This extension gives you the flexibility of manual testing with many powerful evasion techniques. 
	* **Swagger**
		* [swurg](https://github.com/AresS31/swurg)
			* Parses Swagger files into the BurpSuite for automating RESTful API testing – approved by Burp for inclusion in their official BApp Store.
	- **TLS**
		* [Awesome TLS](https://github.com/sleeyax/burp-awesome-tls)
			* Fix Burp Suite's horrible TLS stack & spoof any browser fingerprint
	- **Turbo Intruder**
		* [Haptyc](https://github.com/defparam/haptyc)
			* "Haptyc is a python library which was built to add payload position support and Sniper/Clusterbomb/Batteringram/Pitchfork attack types into Turbo Intruder. While Haptyc accomplishes these goals fairly well it also introduces a simpler way to express test sequences in general. While this library was meant to target Turbo Intruder it has no hard dependencies on Turbo Intruder and can be used anywhere one requires test generation in a Python context. Unfortunately at this time since Haptyc was built for a jython interpreter it only supports Python 2.7 (however future changes will fix this)."
	* **WAFs**
		* [HTTPSmuggler](https://github.com/nccgroup/BurpSuiteHTTPSmuggler)
			* A Burp Suite extension to help pentesters to bypass WAFs or test their effectiveness using a number of techniques. This extension has been developed by Soroush Dalili (@irsdl) from NCC Group.
	* **Wordlists**
		* [Golden Nuggets](https://github.com/GainSec/GoldenNuggets-1)
			* Burp Suite Extension to easily create Wordlists based off URI, URI Parameters and Single Words (Minus the Domain)
		* [whey-cewler.py](https://gist.github.com/lanmaster53/a0d3523279f3d1efdfe6d9dfc4da0d4a)
			* "Whey CeWLer runs within Portswigger's Burp Suite and parses an already crawled sitemap to build a custom wordlist."
	- **XSS**
		* [reflector](https://github.com/elkokc/reflector/)
			* Burp Suite extension is able to find reflected XSS on page in real-time while browsing on web-site
	* **Other**
		* [C02](https://code.google.com/p/burp-co2/)
			* Co2 includes several useful enhancements bundled into a single Java-based Burp Extension. The extension has it's own configuration tab with multiple sub-tabs (for each Co2 module). Modules that interact with other Burp tools can be disabled from within the Co2 configuration tab, so there is no need to disable the entire extension when using just part of the functionality.
		* [distribute-damage](https://github.com/PortSwigger/distribute-damage)
			* Designed to make Burp evenly distribute load across multiple scanner targets, this extension introduces a per-host throttle, and a context menu to trigger scans from. It may also come in useful for avoiding detection.
		* [Office Open XML Editor - burp extension](https://github.com/maxence-schmitt/OfficeOpenXMLEditor)
		* [Bumpster](https://github.com/markclayton/bumpster)
			* The Unofficial Burp Extension for DNSDumpster.com. You simply supply a domain name and it returns a ton of DNS information and basically lays out the external network topology.
		* [ParrotNG - burp plugin](https://portswigger.net/bappstore/bapps/details/f99325340a404c67a8de2ce593824e0e)
		* [Brida](https://github.com/federicodotta/Brida)
			* Brida is a Burp Suite Extension that, working as a bridge between Burp Suite and Frida, lets you use and manipulate applications’ own methods while tampering the traffic exchanged between the applications and their back-end services/servers. It supports all platforms supported by Frida (Windows, macOS, Linux, iOS, Android, and QNX)
		* [Cyber Security Transformation Chef](https://github.com/usdAG/cstc)
			* The Cyber Security Transformation Chef (CSTC) is a Burp Suite extension. It is build for security experts to extend Burp Suite for chaining simple operations for each incomming or outgoing message. It can also be used to quickly make a special custom formatting for the message.
		* [Hackbar](https://github.com/d3vilbug/HackBar)
			* Hackbar plugin for Burp
		* [progress-burp](https://github.com/dariusztytko/progress-burp)
			* Burp Suite extension to track vulnerability assessment progress
- **Burp Macros**
	* [Postman+Burp Macros and Asymmetrical API Testing - stacktitan(2019)](https://rift.stacktitan.com/burp-macros-and-asymmetrical-api-testing/)
	* [Burp Macros: What, Why & How? - Akshita Gupta(2021)](https://akshita-infosec.medium.com/burp-macros-what-why-how-151df8901641)
----------------------------------------------------------------------------------------------------------------




------------------
### <a name="cloudflare"></a> Cloudflare
* **101**
* **Articles/Blogposts/Writeups**
	* [CloudFlair: Bypassing Cloudflare using Internet-wide scan data - blog.christophetd](https://blog.christophetd.fr/bypassing-cloudflare-using-internet-wide-scan-data/)
	* [Exposing Server IPs Behind CloudFlare - chokepoint](http://www.chokepoint.net/2017/10/exposing-server-ips-behind-cloudflare.html)
	* [Introducing CFire: Evading CloudFlare Security Protections - rhinosecuritylabs](https://rhinosecuritylabs.com/cloud-security/cloudflare-bypassing-cloud-security/)
* **Tools**
	* [CloudFlair](https://github.com/christophetd/CloudFlair)
		* CloudFlair is a tool to find origin servers of websites protected by CloudFlare who are publicly exposed and don't restrict network access to the CloudFlare IP ranges as they should. The tool uses Internet-wide scan data from Censys to find exposed IPv4 hosts presenting an SSL certificate associated with the target's domain name.
	* [CloudFire](https://github.com/RhinoSecurityLabs/Security-Research/tree/master/tools/cfire)
		* This project focuses on discovering potential IP's leaking from behind cloud-proxied services, e.g. Cloudflare. Although there are many ways to tackle this task, we are focusing right now on CrimeFlare database lookups, search engine scraping and other enumeration techniques.
----------------------------------------------------------------------------------------------------------------





--------------------------
### <a name="bugbounty"></a> Bug Bounty Writeups
* [HackerOne H1-212 Capture the Flag Solution - Corben Douglas](http://www.sxcurity.pro/H1-212%20CTF%20Solution.pdf)
* [ebay.com: RCE using CCS](http://secalert.net/#ebay-rce-ccs)
* [$10k host header - eze2307](https://sites.google.com/site/testsitehacking/10k-host-header)
* [REMOTE CODE EXECUTION! Recon Wins - vishnuraj](https://medium.com/@vishnu0002/remote-code-execution-recon-wins-e9c1db79f3da)
* [Analyzing a Creative Attack Chain Used To Compromise A Web Application](https://www.offensive-security.com/offsec/analyzing-a-creative-attack-chain/)
* [RCE in Hubspot with EL injection in HubL - betterhacker.com](https://www.betterhacker.com/2018/12/rce-in-hubspot-with-el-injection-in-hubl.html)
	* "This is the story of how I was able to get remote code execution on Hubspot's servers by exploiting a vulnerability in HubL expression language, which is used for creating templates and custom modules within the Hubspot CRM."
* [Hacking Slack using postMessage and WebSocket-reconnect to steal your precious token - labs.detectify](https://labs.detectify.com/2017/02/28/hacking-slack-using-postmessage-and-websocket-reconnect-to-steal-your-precious-token/)
* **Tools**
	* [Boucan: A Bug Bounty Canary Platform](https://github.com/3lpsy/boucanpy)
		* This project is an attempt to implement a lightweight burp collaborator-esc application and consists of two main components: a DNS Server (Custom Python Implemention with dnslib) and an API. It is still very much in the early days of development. You can think of Boucan as sort of a Canary that will notify you when an external asset (DNS Record, HTTP Server, SMTP Server) has been interacted with. This is useful for blind payload injection.
	* [Keyhacks](https://github.com/streaak/keyhacks)
		* Keyhacks is a repository which shows quick ways in which API keys leaked by a bug bounty program can be checked to see if they're valid.
----------------------------------------------------------------------------------------------------------------




	
	ToDo links
```
XSS
	https://github.com/EgeBalci/xss-flare
	https://medium.com/@spade.com/a-guide-to-make-your-own-serverless-blind-xss-and-blind-oob-payload-18f8f2b9c507
	https://ysamm.com/?p=493
	https://netsec.expert/posts/xss-in-2021/
	https://0xmkr24.medium.com/cross-site-scripting-contexts-walkthrough-portswigger-labs-part-1-aad6cf65e49b
	https://securitygoat.medium.com/data-exfiltration-with-some-fun-xss-tricks-49e9251f05fd
	https://portswigger.net/research/portable-data-exfiltration
	https://swarm.ptsecurity.com/fuzzing-for-xss-via-nested-parsers-condition/
	https://www.rcesecurity.com/2020/11/Smuggling-an-un-exploitable-xss/
	https://github.com/heroanswer/XSS_Cheat_Sheet_2020_Edition
	https://liveoverflow.com/do-not-use-alert-1-in-xss/
	https://blog.mozilla.org/attack-and-defense/2021/11/03/finding-and-fixing-dom-based-xss-with-static-analysis/
	https://hacklido.com/blog/252-xss-filter-evasion-and-waf-bypassing
	https://whynotsecurity.com/blog/xss-to-rce/
	https://www.youtube.com/embed/xxKAvx4UeUg
	https://www.volkis.com.au/blog/bypass-xss-in-wafs/
	https://www.youtube.com/watch?v=mKAWpFdVcPY
	https://docs.google.com/presentation/d/130n98LMDyD1xyZp5wzgmjmrZPP-nBcU9tI3NaOVfBs0/preview#slide=id.p
	https://github.com/redcode-labs/poXSSon
	https://www.youtube.com/watch?v=HU3np5xvioA
	https://github.com/kleiton0x00/ppmap
	https://www.blackhat.com/presentations/bh-europe-07/Dube-Rios/Whitepaper/bh-eu-07-rios-WP.pdf
	https://pentestit.medium.com/hey-dude-do-you-need-script-on-your-page-d9192df990f4
	https://twitter.com/orange_8361/status/1333458585980813333
	https://www.trustedsec.com/events/webinar-popping-shells-instead-of-alert-boxes-weaponizing-xss-for-fun-and-profit/
	https://github.com/0xsobky/HackVault/wiki/Unleashing-an-Ultimate-XSS-Polyglot
	https://web.archive.org/web/20190617111911/https://polyglot.innerht.ml/
	https://dev.to/caffiendkitten/xss-javascript-polyglots-4i64
	https://bishopfox.com/blog/lexss-bypassing-lexical-parsing-security-controls
	https://lutfumertceylan.com.tr/posts/acc-takeover-web-cache-xss/
	https://medium.com/bugbountywriteup/content-security-policy-bypass-to-perform-xss-3c8dd0d40c2e
	https://knoxss.me/?page_id=766
	https://www.youtube.com/watch?v=TgilzlNHFz8
	https://github.com/hakluke/weaponised-XSS-payloads
	https://twitter.com/intigriti/status/1356245100414840833
	https://github.com/yavolo/eventlistener-xss-recon
	https://medium.com/@know.0nix/hunting-good-bugs-with-only-html-d8fd40d17b38	
	https://leucosite.com/Edge-Chromium-EoP-RCE/
	https://github.com/hahwul/dalfox
	https://www.immersivelabs.com/resources/blog/wagtail-xss-localstorage-account-hijack/
	https://portswigger.net/research/redefining-impossible-xss-without-arbitrary-javascript
	https://r2c.dev/blog/2021/xss-cheat-sheets/
	https://thehackerblog.com/video-download-uxss-exploit-detailed/
	https://medium.com/realmodelabs/kindledrip-from-your-kindles-email-address-to-using-your-credit-card-bb93dbfb2a08
	https://blog.s1r1us.ninja/bug-bounty/cookie-tossing-to-rce-on-google-cloud-jupyter-notebooks
	https://medium.com/bugbountywriteup/intigritis-december-xss-challenge-2020-unintended-solution-8205b4a4b95b
	https://chefsecure.com/courses/xss/recipes/polyglots-the-ultimate-xss-payloads
	https://medium.com/cyberverse/obfuscated-polyglot-xss-payloads-simplified-with-references-157e95b1d601
	https://security.szurek.pl/en/xss-polyglot.html
	https://easterxss.terjanq.me/writeup.html
	https://www.youtube.com/watch?utm_campaign=bug_bytes_99_bypassing_bots_and_wafs_jq_in_burp_smarter_json_fuzzing_and_subdomain_takeovers
		* [AwesomeXSS - Somdev Sangwan](https://github.com/s0md3v/AwesomeXSS)
			* Awesome XSS stuff
	Cookies
		https://medium.com/@agrawalsmart7/cookie-based-injection-xss-making-exploitable-with-out-exploiting-other-vulns-81132ca01d67
		https://security.stackexchange.com/questions/36172/is-cookie-based-xss-exploitable
		https://wesecureapp.com/2017/07/10/xss-by-tossing-cookies/
		http://zhchbin.github.io/2017/08/30/Uber-XSS-via-Cookie/
		https://appsecnotes.blogspot.com/2009/11/xss-via-cookie-how-severe.html
		http://blog.k3170makan.com/2013/10/aboutme-cookie-based-xss.html
		https://blog.jeremiahgrossman.com/2010/02/converting-unimplementable-cookie-based.html
	DOM
		https://enfinlay.github.io//xss/dom/burp/2021/02/23/dom-xss-is-dead.html
		https://vovohelo.medium.com/from-svg-and-back-yet-another-mutation-xss-via-namespace-confusion-for-dompurify-2-2-2-bypass-5d9ae8b1878f
		https://github.com/nccgroup/tracy
		https://static.sched.com/hosted_files/njsi2019/31/Securing%20the%20DOM%20from%20the%20bottom%20up%20-%20Node%2BJS%20Interactive.pdf
		https://www.youtube.com/watch?v=QBkLI35sxVsutm_campaign=bug_bytes_103_cookie_tossing_recon_tools_benchmarks_stealing_google_docs_with_screenshots&utm_term=2020-12-30
		https://research.securitum.com/helping-secure-dompurify-part-1/
		https://github.com/filedescriptor/untrusted-types
		https://thexssrat.medium.com/digging-deep-into-dom-xss-9ed172876477
		* [Restricted-character XSS for fun - physuru.dev(2021)](https://web.archive.org/web/20210414031135/https://physuru.dev/blog/restricted_character_xss/)
		https://blog.mozilla.org/attack-and-defense/2021/11/03/finding-and-fixing-dom-based-xss-with-static-analysis/
		https://portswigger.net/web-security/dom-based/cookie-manipulation
		https://owasp.org/www-community/attacks/DOM_Based_XSS
		https://portswigger.net/blog/introducing-dom-invader
		https://medium.com/@shilpybanerjee/dom-based-cookie-manipulation-portswigger-lab-16ae86de26fc
		https://medium.com/bugbountywriteup/reflected-xss-on-microsoft-com-via-angular-template-injection-2e26d80a7fd8
		https://medium.com/@lucideus/a-definitive-guide-to-session-hijacking-lucideus-research-71165a672973
		https://security.stackexchange.com/questions/176897/how-to-exploit-dom-xss-in-cookies-without-having-xss-on-the-page/176938
		https://github.com/wisec/domxsswiki
		https://hackerone.com/reports/57356
		https://book.hacktricks.xyz/pentesting-web/xss-cross-site-scripting/dom-xss
		https://github.com/wisec/domxsswiki
	Talks
		* [Tracing User Input Through JavaScript is for Tools - Jake Heath, Michael Roberts(2018)](https://www.youtube.com/watch?v=3zowuWLEGsA&list=PL7D3STHEa66TbZwq9w3S2qWzoJeNo3YYN&index=21)
			* Being able to comprehend causal relationships between sources of user input and their corresponding output is a distinguishing characteristic that separates the master web hacker from the novice script kiddy. The better a tester can grasp these relationships, the faster they can abuse lapses in input sanitization, identify dangerous programming patterns, and understand the overall attack surface of the application. However, enumerating these relationships is difficult and time intensive to do by hand, especially with JavaScript-heavy apps. Security scanning tools have tried to automate this procedure, but they face several problems in modern web applications: To solve these problems, we need a tool that augments, not automates, a manual penetration tester by helping them understand all of the inputs and outputs of a web application. To this end, we present Tracy, a tool for assisting penetration testers with enumerating every sink of output for all user input sources.
XSSI
	https://blog.cm2.pw/exploiting-post-based-xssi/
	https://www.usenix.org/system/files/conference/usenixsecurity15/sec15-paper-lekies.pdf
	* [XSSI and JSONP leaks](https://github.com/EdOverflow/bugbountywiki/wiki/XSSI-and-JSONP-leaks)
	* [The Tale of a Fameless but Widespread Web Vulnerability Class - Veit Hailperin](https://www.youtube.com/watch?v=5qA0CtS6cZ4)
		* [Blogpost](https://www.scip.ch/en/?labs.20160414)
		* Two keys components account for finding vulnerabilities of a certain class: awareness of the vulnerability and ease of finding the vulnerability. Cross-Site Script Inclusion (XSSI) vulnerabilities are not mentioned in the de facto standard for public attention - the OWASP Top 10. Additionally there is no public tool available to facilitate finding XSSI. The impact reaches from leaking personal information stored, circumvention of token-based protection to complete compromise of accounts. XSSI vulnerabilities are fairly wide spread and the lack of detection increases the risk of each XSSI. In this talk we are going to demonstrate how to find XSSI, exploit XSSI and also how to protect against XSSI.
XS-Leaks
	https://arturjanc.com/visited-delenda-est.pdf
XS-Search
	https://www.youtube.com/watch?v=HcrQy0C-hEA
	https://scarybeastsecurity.blogspot.com/2009/12/cross-domain-search-timing.html
	https://www.abortz.net/papers/timingweb.pdf
	https://www.owasp.org/images/a/a7/AppSecIL2015_Cross-Site-Search-Attacks_HemiLeibowitz.pdf
	https://medium.com/@luanherrera/xs-searching-googles-bug-tracker-to-find-out-vulnerable-source-code-50d8135b7549
	https://www.blackhat.com/docs/us-16/materials/us-16-Gelernter-Timing-Attacks-Have-Never-Been-So-Practical-Advanced-Cross-Site-Search-Attacks.pdf
	https://sites.google.com/site/bughunteruniversity/nonvuln/xsleaks
	https://terjanq.github.io/Bug-Bounty/Google/cache-attack-06jd2d2mz2r0/index.html
	https://github.com/xsleaks/xsleaks/wiki/Links
	http://sirdarckcat.blogspot.com/2019/03/http-cache-cross-site-leaks.html
XXE
	https://www.shielder.it/blog/dont-open-that-xml-xxe-to-rce-in-xml-plugins-for-vs-code-eclipse-theia/
	https://gosecure.github.io/xxe-workshop/#0
	https://cinzinga.com/XXE-Case-Studies/
	https://read.martiandefense.llc/hacking-xml-xml-injection-51bea2edd3a2?gi=5fb445391ec6
	https://gosecure.github.io/presentations/2019-06-19-hack_in_paris/HIP2019-Advanced_XXE_Exploitation.pdf
		https://gosecure.github.io/presentations/2019-06-19-hack_in_paris/Exercise_1_simple.pdf
		https://gosecure.github.io/presentations/2019-06-19-hack_in_paris/Exercise_2_external_dtd.pdf
		https://gosecure.github.io/presentations/2019-06-19-hack_in_paris/Exercise_3_php_encoding.pdf
		https://gosecure.github.io/presentations/2019-06-19-hack_in_paris/Exercise_4_jar_proto.pdf
		https://gosecure.github.io/presentations/2019-06-19-hack_in_paris/Exercise_5_local_dtd.pdf
	https://speakerdeck.com/0ang3el/a-hackers-perspective-on-aem-applications-security
```
