# Social Engineering

## Table of Contents
-----------------------------------------------------------------------------
- [Articles/Blogposts/Writeups](#articles)
- [Books](#books)
- [Talks & Presentations](#talks)
	- [101](#101)
	- [Education](#edu)
	- [Experiences in Performance](#perfexp)
	- [Improv Comedy](#improv)
	- [In-Person Networking](#inpern)
	- [Pretexting](#pretext)
	- [Skills Improvement](#skills)
	- [Voice Phishing/Pretexting](#voice)
--------------------------------------------------------------------------------

----------------------------------------------------
### Social Engineering
* **Articles/Blogposts/Writeups**<a name="articles"></a>
	* [Source Handling](http://guerrillamerica.com/2014/01/source-handling-part-one/)
	* [Source Recruitment](http://guerrillamerica.com/2013/12/source-recruitment/)
	* [List of the 48 Laws of Power](http://cgt411.tech.purdue.edu/covey/48_laws_of_power.htm)
	* [Influence: Book notes](http://www.2uo.de/influence/)
	* [DiSC Overview](https://www.discprofile.com/what-is-disc/overview/)
		* DiSC is a personal assessment tool used to improve work productivity, teamwork and communication. DiSC is non-judgmental and helps people discuss their behavioral differences.
	* [The Social Engineering Framework](http://www.social-engineer.org/framework/general-discussion/)
		* The Social Engineering Framework is a searchable information resource for people wishing to learn more about the psychological, physical and historical aspects of social engineering. 
	* [Phishing Family Tree Now: A Social Engineering Odyssey](https://www.blackhillsinfosec.com/?p=5629)
	* [The Man Who Captures Criminals for the D.E.A. by Playing Them - The New Yorker](https://www.newyorker.com/magazine/2018/07/30/the-man-who-captures-criminals-for-the-dea-by-playing-them)
	* [Our Take on Social Engineering - dnet(silentsignla)](https://blog.silentsignal.eu/2019/04/04/our-take-on-social-engineering/)
* **Books**<a name="books"></a>
	* [48 Laws of Power](https://en.wikipedia.org/wiki/The_48_Laws_of_Power)
	* [Anything by Paul Eckman and his research](https://www.paulekman.com/)
	* [Art of Deception](https://en.wikipedia.org/wiki/The_Art_of_Deception)
	* [Art of War by Sun Tzu](https://en.wikipedia.org/wiki/The_Art_of_War)
	* [Art of the Steal](https://www.penguinrandomhouse.com/books/86/the-art-of-the-steal-by-frank-w-abagnale/)
	* [Craft of Intelligence - Allen Dulles](https://www.goodreads.com/book/show/375593.The_Craft_of_Intelligence)
		* [On The Craft of Intelligence - US CIA](https://www.cia.gov/library/center-for-the-study-of-intelligence/kent-csi/vol8no1/html/v08i1a07p_0001.htm)
	* [Emotions Revealed, Second Edition: Recognizing Faces and Feelings to Improve Communication and Emotional Life](https://www.paulekman.com/resources/books/)
	* [How to Win Friends and Influence People](https://en.wikipedia.org/wiki/How_to_Win_Friends_and_Influence_People)
	* [Influence Without Authority - Allan R. Cohen, David L. Bradford](https://www.wiley.com/en-us/Influence+Without+Authority%2C+3rd+Edition-p-9781119347712)
	* [Influence: Science and Practice - Robert Cialdini](https://en.wikipedia.org/wiki/Influence:_Science_and_Practice)
	* [Language Intelligence: Lessons on persuasion from Jesus, Shakespeare, Lincoln, and Lady Gaga](https://www.goodreads.com/book/show/15829050-language-intelligence)
	* [Miss Manners Guide to Excellent Manners](https://www.missmanners.com/in-print/miss-manners-books/)
	* [Propaganda by Edward Bernays](https://en.wikipedia.org/wiki/Propaganda_(book))
	* [Social Engineering: Art of Human Hacking](https://www.social-engineer.org/social-engineering/the-art-of-human-hacking/)
	* [Thank You For Arguing, Revised and Updated Edition: What Aristotle, Lincoln, And Homer Simpson Can Teach Us About the Art of Persuasion]()
	* [The Amy Vanderbilt Complete Book of Etiquette](https://www.archive.org/stream/amyvanderbiltsco00vandrich/amyvanderbiltsco00vandrich_djvu.txt)
	* [The Definitive Book of Body Language - Barbara Pease](https://www.goodreads.com/book/show/262731.The_Definitive_Book_of_Body_Language)
	* [The Prince by Machiavelli](https://www.gutenberg.org/files/1232/1232-h/1232-h.htm)
	* [Thinking Fast and Slow](https://en.wikipedia.org/wiki/Thinking,_Fast_and_Slow)
	* [Toastmaster's guide to body language](http://westsidetoastmasters.com/resources/book_of_body_language/toc.html)
	* [Social Engineering: The Science of Human Hacking - Christopher Hadnagy]()
	* [What Every Body is saying - Joe Navarro, Marvin Karlins](https://www.goodreads.com/book/show/1173576.What_Every_Body_is_Saying)
* **Talks & Presentations**<a name="talks"></a>
	* **101**<a name="101"></a>
		* [Social Engineering: The Gentleman Thief  - Apollo Robins - Defcon21](https://www.youtube.com/watch?v=1kkOKvPrdZ4)
		* [No-Tech Hacking - Hacking without a Computer - Johnny Long](https://www.youtube.com/watch?v=N4kfsxF8Tio)
	* **Education**<a name="edu"></a>
		* ["Humans, right?" Soft Skills in Security - Ariel Robinson](http://www.irongeek.com/i.php?page=videos/bsidesnova2017/200-humans-right-soft-skills-in-security-ariel-robinson)
			* Let's face it: humans ruin everything. They are almost always the weak link in the information security chain, between their susceptibility to social engineering, rejection of security threats, and sheer laziness. You can make the best security tool in the business, but if a human doesn't use it right, well, you might as well leave your passwords on a sticky note on your-- wait a minute. Yes, humans suck at information security. But we don't make it easy. Infosec is incredibly inaccessible to your average user. Just ask me: I am one. We can't change humans (or get rid of them, no matter how much we might want to), but we can change information security. We can leverage insights from non-technical disciplines such as cognitive science, human-centered design, strategic communications, and psychology. Or we can keep hitting our heads against our desktops. As a professional communicator and bridge builder, help me help you. To make security work, we have to make it easy. For humans.
		* [For The Win Tools Techniques to Maximize Effectiveness of Your Social Engineering Attacks - Joe Gray](https://www.youtube.com/watch?v=Jh9Kl4JAdEA)
		* [Social Engineering: When the Phone is More Dangerous than Malware](https://www.youtube.com/watch?v=fui9AVpp1wo)
			* Is social engineering (SE) the most dangerous security threat to your business? The Social-Engineer team will analyze current trends in social engineering through the official (and unofficial) results from the DefCon 21 Social Engineering Capture the Flag event. They will reveal how these attacks work, the latest social engineering research and how to use this information to protect organizations.
		* [Mind Reading for Fun and Profit using DISC - Christopher Hadnagy(Derbycon2016)](http://www.irongeek.com/i.php?page=videos/derbycon6/201-mind-reading-for-fun-and-profit-using-disc-christopher-hadnagy)
			* Learning to profile a target is a key element to social engineering. Learn how to use a quick and easy profiling tool to make targets feel as if you can read their minds. You will also learn how to release chemicals in your targets brains to make them more agreeable to your suggestions.
		* [Social Engineering for the Blue Team - Timothy De Block(BSides Nashville2018)](https://www.irongeek.com/i.php?page=videos/bsidesnashville2018/bsides-nashville-2018-green-05-social-engineering-for-the-blue-team-timothy-de-block)
			* Social engineering is not just for red team. It'۪s a powerful tool that the blue team can use to improve security within the organization. Have you ever struggled to get another department to take security seriously? Have you ever been frustrated that security takes a back seat to other priorities? Social engineering is the answer. We can be better at getting our goals and objectives accomplished by improving how we interact with others. This talk will provide tools and techniques to build better relationships. We'll talk about what we're doing right and what we're doing wrong. How to use social engineering to build rapport with your co-workers. We'll talk about verbal and electronic communication techniques, body language, going the extra mile, and appreciation. Learning the tools and techniques of social engineers will help you build better relationships and influence others into a better security mindset.
	* **Experiences in Performance**<a name="perfexp"></a>
		* [Steal Everything, Kill Everyone, Cause Total Financial Ruin!](https://www.youtube.com/watch?v=JsVtHqICeKE)
			* This is not a presentation where I talk about how I would get in or the things I might be able to do. This is a talk where I am already in and I show you pictures from actual engagements that I have been on. They say one picture is worth a thousand words I show you how one picture cost a company a million dollars and maybe even a few lives. In a community where we focus so much on the offensive I also make sure with every attack I highlight. I spend time discussing what would have stopped me. We need to know the problems but we need more talks providing solutions and that is what I hope people will get from this. I show the dangers of Social engineering and how even an employee with no SE experience can be an eBay James Bond which can cause total financial ruin to a company. These Security threats are real. So are these stories!
		* [`**I Will Kill You**` - Chris Rock(Defcon23)](https://www.youtube.com/watch?v=9FdHq3WfJg)
		* [Total Fail: and Bad Mistakes, I've Made a Few- Jayson Street -DEF CON 24 SE Village](https://www.youtube.com/watch?v=l1OFH_H8PjQ)
		* [Security Guards LOL Brent White Tim Roberts - Nolacon2017](https://www.youtube.com/watch?v=yIQ-7ZSwrYw)
		* [How I met your girlfriend - Samy Kamkar - Defcon18](https://www.youtube.com/watch?v=YDW7kobM6Ik)
		* [The Future of Social Engineering - Sharon Conheady - DeepSec2010](https://www.youtube.com/watch?v=aVIq9mdVHlc&index=11&list=PL_At9BlHdC-_764ciDVexbJL0hwsCzqLK)
			* Social engineering is hitting the headlines more than ever. As computer security becomes more sophisticated, hackers are combining their technical expertise with social engineering to gain access to IT infrastructures and critical information. In any security programme people are the weakest link. It can often be easier and quicker to target the end user than using technical hacking techniques. When you combine both social engineering and traditional hacking techniques, you have an extremely dangerous attack. So what's next on the social engineering agenda? What are the emerging trends and what social engineering techniques might we expect to see in the future? In this talk, I will give an overview of the types of social engineering attacks people have used throughout the ages, from tricks used by the classic conmen of the past to the phishing attacks that are at an all time high, and the proliferation of social networking and how useful this is to social engineers. I will describe some of the new social engineering techniques and trends that are emerging and discuss war stories from my experience of social engineering, describing techniques I have used to gain access to sensitive information
	* **Improv Comedy**<a name="improv"></a>
		* [Improv Comedy as a Social Engineering Tool - Dave Mattingly - Derbycon 2017](https://www.irongeek.com/i.php?page=videos/derbycon7/s11-improv-comedy-as-a-social-engineering-tool-dave-mattingly)
	* **In-Person Networking**<a name="inpern"></a>
		* [That’s still not my RJ 45 Jack - IRL Networking for Humans Pt 2 - Johnny Xmas](https://www.irongeek.com/i.php?page=videos/converge2015/%22track112-how-to-dress-like-a-human-being-irl-networking-for-humans-pt-2-johnny-xmas%22)
			* We're smart. We're incredibly tech savvy. We can rock some mad OSINT with our Google-Fu. We're 85% +-10% sure which part of the body a hat goes on. We think you can never have enough beard. WE THINK THAT'S ACCEPTABLE. The second in his multi-part series on building social prowess, this talk will focus on the inconvenient truth of your book always, always, always being judged by its cover, and how to deal with that with minimal effort so you can get back to sewing more pockets on your utilikilt. This talk covers both male and female situations, though it is primarily unisex. We'll get you set up with a core wardrobe and hygenic skillset so you'll be able to roll out of bed, spend minimal time "getting ready," rock the dreaded client-facing meeting or industry meetup, and get you back home where you can safely take your pants off.
		* [Dropping hell0days Business Interaction for Security Professionals Or Anyone Else - Elliot Johnson(BSidesLV2015) ](https://www.youtube.com/watch?v=COyN3NwY1v0)
	* **Pretexting**<a name="pretext"></a>
		* [Phishy Little Liars - Pretexts That Kill - Alethe Denis(BSidesSF2020)](https://www.youtube.com/watch?v=JFAuHEOc77M&list=PLbZzXF2qC3RvlcHIxrqrsN1XhwHX8SQ-g)
			* The 'IT Guy' is the Nigerian Prince of Pretexts. As bad actors begin to use more specialized pretexts, so too should Pentesters use more specialized, custom pretexts during assessments. Learn to make custom pretexts that fly under the radar and won’t raise any red flags using target specific data.
	* **Skills Improvement(General Stuff)**<a name="skills"></a>
		* [Cheat Codez: Level UP Your SE Game - Eric Smith (@InfoSecMafia)](http://www.irongeek.com/i.php?page=videos/derbycon3/1206-cheat-codez-level-up-your-se-game-eric-smith)
			* Everyone knows what phishing is. Everyone realizes Java applets lead to massive storms of shells. Everyone accepts tailgating is the easiest way into your building. Everyone knows smoking (areas) are bad for you AND your business. Admit it, you paid for that EXACT assessment last year. I could write your report for you without even doing the job. So what’s the problem you ask? That’s EXACTLY the problem, I say. So how do we fix these issues that plague our industry and misalign business expectations? This talk will discuss the value of Social Engineering exercises when conducted with realistic goals yielding actionable results. Of course, that means putting in REAL work throughout the engagement, not “point, click, report, rinse and repeat”. We’ll discuss tips, techniques and secrets that the PROS don’t always blog about. *PRO TIP* – This won’t be a talk on how to use a particular framework or release of a tool (there are plenty of those already). So bring your work boots, it’s time to get dirty and UP your game.
		* [What Your Body Tells Me - Body Language for the SE](https://media.defcon.org/DEF%20CON%2022/DEF%20CON%2022%20video%20and%20slides/DEF%20CON%2022%20Hacking%20Conference%20Presentation%20By%20Chris%20Hadnagy%20-%20What%20Your%20Body%20Tells%20Me%20-%20Body%20Language%20for%20the%20SE%20-%20Video%20and%20Slides.m4v)
		* [Beyond Social Engineering: Tools for Reinventing Yourself - Defcon14](https://www.youtube.com/watch?v=S-FPJ6lpRYU)
			* Managing multiple modular identities is not a trivial task. But that's what the technologies and politics of Now demand. These tools will enable you to create personas at a deep level, then link them into a seamless life.
		* [DEF CON 11 Hacking Conference Presentation By Panel - Social Engineering Fundamentals](https://www.youtube.com/watch?v=Pcrmpevn5K0&index=12&list=PLMcNSdhdNcP1RZDn1GtTETHtAN3I6-M-r)
		* [Allan Cohen on Growing Influence Without Authority(2018)](https://www.youtube.com/watch?v=_YZicFgn1MQ)
			* Allan Cohen, Distinguished Professor of Global Leadership at Babson College, and Box Board Member (and former COO) Dan Levin discuss concepts and practice of influence without explicit authority – how to get what you need from people you don’t control, on a personal, team, and organizational level.
		* [The Dirty South - David Kennedy and Nick Hitchcock  - Defcon21](https://www.youtube.com/watch?v=dJbm8Eh-880&index=22&list=PLMcNSdhdNcP1RZDn1GtTETHtAN3I6-M-r)
			* It seems that every day there's a new NextGen firewall, whitelisting and blacklisting, DLP, or the latest technology thats suppose to stop us. But does it really stop "hackers"? Truth is, naw not really. In this talk we'll be showing off the latest bypass techniques for the "latest" hacker stoppers, using a universally whitelisted website as our middle man for a command and control, social engineering our way into some of the toughest companies, and showing off some techniques that work for us. This talk is about throwing misconceptions of protection and safety out the window, and going back the dirty south. Where thinking outside of the box is a requirement. We'll be releasing two new tools, one that makes meterpreter invisible over the network, and the other a shell that uses a popular third party as the command and control. A vulnerability scanner won't help you herrrrrrre.
		* [Classic Misdirection: Social Engineering to Counter Surveillance - Peter Clemenko III(BSidesLV2015)](https://www.youtube.com/watch?v=AysOwnSUmgg)
			* Good OPSEC is not enough, sometimes you're already being watched. Sometimes good OPSEC goes wrong and backfires. This talk will discuss how good OPSEC can backfire, show some history of real-world psychological operations, and how to social engineer and troll your way to being less conspicuous of a target, or at least give those watching you a show and bad intelligence. While you can't hide everything, you can shape the way you are viewed by those who are watching you.
	* **Voice Phishing/Pretexting**<a name="voice"></a>
		* [Make Vishing Suck Less - Jonathan Stines(Layer8 2018)](https://www.youtube.com/watch?v=4DphohJvnx8&index=5&list=UUynWOUeHAOflEQtJnrZpkNA)
			* The purpose of this talk is to describe methodologies which one could follow when performing telephone pretexting. Social dynamics have changed over the years causing the entry barrier to being successful with Vishing more difficult and talking on the telephone less comfortable. The aim of this speech will be to crack the code for a newb getting started so he or she can hit the ground running, jump on the horn, and start pwning some folks like it's 1989.
	* **Unsorted**
		* [The Silver Tongue vs The Iron Fist - Deviant Ollam](https://www.youtube.com/watch?v=dVTcifBspRc&list=PLgfYOpahpSezQ5Mqg2RHE92M9Pb2BHLTl&index=2)
			* Physical security operations are meant to keep your people and your facility safe. And while you've heard Deviant discuss the myriad ways he and his team get through mechanical and electronic access control systems... often it's the human element that is weakest. And it also is the most overlooked. But this is not a social engineering talk. Nor is this a talk about how to make your employees and executives more aware about phishing and tailgating. No... this is a much more hard-hitting talk about physical security on the front lines. Whether guards, goons, or general volunteers... your staff who interact with the public are the first line of defense against those who would cause trouble and disrupt your affairs. But do your people have the skills to contain disturbances calmly and professionally? Or are some on your team inadvertently making incidents worse because they lack training in certain key disciplines? Deviant will share all that he's learned through decades of work as a guard, a counselor, and a professional ruffian bent on getting past defenses. Often, it's not bluster and displays of authority that are the best medicine when folk step out of line... rather, it tends to be individuals with the best people skills and training in crisis management who come to the rescue time and time again.
		* [Dynamic Risk Taking and Social Engineering - Chris Hadnagy(Derbycon2019)](https://www.youtube.com/watch?v=5EjSwH_T7hQ&feature=share)
		* [Total Fail: and Bad Mistakes, I've Made a Few- Jayson Street -DEF CON 24 SE Village](https://www.youtube.com/watch?v=l1OFH_H8PjQ)
		* [Social Engineering Like In Movies -- Reality of awareness and manipulation - Dale Pearson- #days](https://www.youtube.com/watch?v=XUIWi5p0oFI)
		* [Manipulating Human Minds: The Psychological Side of Social Engineering - Christina Camilleri - CrikeyCon](https://www.youtube.com/watch?v=8enkIWl79_4)
		* [Psychological Tricks of the Social Engineer - William Tarkington - GrrCON2012](https://www.youtube.com/watch?v=bk-TK4MPs8s&index=10&list=PL_At9BlHdC-_764ciDVexbJL0hwsCzqLK)
			* While several Social Engineering talks and books focus on the techniques no one clearly explains why they work. Learn why the techniques are used and what impact they have on behavior. Discover aspects of human social interaction that can be leveraged to accomplish discrete and specific goals. Gain a firm understanding of the limitations of humans objective reasoning. Finally understand the social rules that are used to navigate within the social engineering construct.
		* [Social Engineering: The Good, the Bad, and the Ugly -- Stephanie Carruthers ](https://www.youtube.com/watch?v=9wCrUOYQlCI&index=31&list=PL_At9BlHdC-_764ciDVexbJL0hwsCzqLK)
		* [Deceiving the heavens to cross the sea - Jayson E Street - Defcon18](https://www.youtube.com/watch?v=EzGwO5L9oq4&feature=player_embedded)
		* [Go With the Flow Strategies for Successful Social Engineering - Chris Silvers](https://www.youtube.com/watch?v=Lfm1mBrcuhY&feature=player_embedded)
		* [The Science of Social Engineering: NLP, Hypnosis and the science of persuasion-Defcon15](https://www.youtube.com/watch?v=vk-IrvrC2fo)
		* [Pwning People Personally - Josh Schwartz](https://www.youtube.com/watch?v=T2Ha-ZLZTz0)
		* [Area41 2016: Dominique-Cédric Brack: Professional Social Engineering](https://youtu.be/NcpmhsSVzuM)
		* [Manipulating Human Minds: The Psychological Side of Social Engineering - Christina Camilleri - CrikeyCon](https://www.youtube.com/watch?v=8enkIWl79_4)
		* [Social Engineering Like In Movies -- Reality of awareness and manipulation - Dale Pearson](https://www.youtube.com/watch?v=XUIWi5p0oFI)
		* [How do you Feel about your Mother? Psych and The SE - Michele Fincher](https://www.youtube.com/watch?v=A0_NL1YBvK4)
		* [Social Engineering Defense Contractors on LinkedIn and Facebook ](https://www.youtube.com/watch?v=L5qETnAKe7A&index=24&list=PLMcNSdhdNcP1RZDn1GtTETHtAN3I6-M-r)
		* [Social Engineering, or "hacking people" - DefCamp 2014](https://www.youtube.com/watch?v=JAOTRgWdPTU&index=49&list=PL_At9BlHdC-_764ciDVexbJL0hwsCzqLK)
		* [BSidesSF 2016 - The Art of the Jedi Mind Trick (Jeff Man) ](https://www.youtube.com/watch?v=3L5_Kaps5t4)
		* [Pwning People Personally](http://www.irongeek.com/i.php?page=videos/derbycon5/break-me08-pwning-people-personally-josh-schwartz)
		* [Jedi Mind Tricks: People Skills for Security Pros - Alex DiPerma - 2017 ANYCON](http://www.irongeek.com/i.php?page=videos/anycon2017/104-jedi-mind-tricks-people-skills-for-security-pros-alex-diperna)
			* People skills for security professionals but WAY MORE FUN!
		* [Patching the Human Vulns  - Leonard Isham](http://www.irongeek.com/i.php?page=videos/derbycon4/t300-patching-the-human-vulns-leonard-isham)
			* You are a hacker, you learn, you play, and you break. The very nature of a hacker is to question what is given to us and to play with the rules. However, most of us do not apply this methodology in all parts of our lives. Many take what is given to us about mood and health as fact and what are the results...overweight, depression, anxiety, and self esteem issues. In this presentation, we will show 2 hackers and their journey on how they addressed the issues mentioned above. Len and Moey followed two separate paths to losing over a combined 150 lbs, gaining confidence, and changing their outlook. The talk will not only cover the touchy feely portion of how to deal with weight, mood,and self esteem but will also be supported by the science behind diets, supplements and perspective. The talk will provide what worked for two hackers. YMMV. 
		* [From Zero to Muso in 5 Minutes - Samantha Coates](https://www.youtube.com/watch?v=lQwXVAP224Q)
		* [Automated Social Engineering for the Antisocial Engineer - Patrick Slayer(2019)](https://www.slideshare.net/PatrickSayler/automated-social-engineering-for-the-antisocial-engineer)
			* While modern technical controls and protections can thwart basic phishing attempts, phone communication remains a lucrative avenue for would-be attackers. This is a typical route used to gain a foothold into an environment via an unsuspecting employee. However, this time-consuming manual process makes documenting and utilizing your social engineering results difficult. Fortunately, existing interactive voice response (IVR) technology can help solve this problem. While these systems are typically used to assist people, we could also leverage them to attack. The abundance of cloud-based services makes this easy to accomplish and even easier to expand upon with your own custom scenarios, all while capturing respondent information. This presentation will cover how to take existing, off-the-shelf tools and configure them to build your own social engineering “robot”.
		* [Disguise - Appearance Hacking](http://www.irongeek.com/i.php?page=videos/derbycon2/valerie-thomas-appearance-hacking-101-the-art-of-everyday-camouflage)
			* [Transcript](http://www.ted.com/talks/amy_cuddy_your_body_language_shapes_who_you_are/transcript)
* My notes from it: 
```
* Why use makeup?
  *    Blend into crowd
    *  Pose as employee/vendor
    *  Regain access if caught
* Create distraction for teammates
* Whom to disguise as?
  *    Technician
    *  Sales Executive
* Goodwill
 *     Employee
  *    Interview Candidate
* Easy to see goings on
 *     Pedestrian
  *    Sidewalk Sleeper
* Transform into another person:
 *     Can take minutes/hours
   *   Examine each physical attribute
* Some modified easier than others
  *    Entire appearance makes the difference. One part is off, whole cover can be blown
* If using hardhat, make sure to beat the shit out of it. Add stickers. 
```

* **Research Papers**
	* [Construal-Level Theory of Psychological Distance](http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3152826/)
		* Abstract: People are capable of thinking about the future, the past, remote locations, another person’s perspective, and counterfactual alternatives. Without denying the uniqueness of each process, it is proposed that they constitute different forms of traversing psychological distance. Psychological distance is egocentric: Its reference point is the self in the here and now, and the different ways in which an object might be removed from that point—in time, in space, in social distance, and in hypotheticality—constitute different distance dimensions. Transcending the self in the here and now entails mental construal, and the farther removed an object is from direct experience, the higher (more abstract) the level of construal of that object. Supporting this analysis, research shows (a) that the various distances are cognitively related to each other, (b) that they similarly influence and are influenced by level of mental construal, and (c) that they similarly affect prediction, preference, and action.
	* [The Neural Basis of Decision-Making During Sensemaking: Implications for Human-System Interaction](https://www.researchgate.net/publication/278679336_The_Neural_Basis_of_Decision-Making_During_Sensemaking_Implications_for_Human-System_Interaction)
