# Physical Security

## Table of Contents
* [General](#general)
	* [Articles/Blogposts](#articles)
	* [Videos/Talks](#videos)
	* [Tools](#tools)
	* [Papers](#papers)
* [Tamper Evident Related](#tamper)
* [Lockpicking](#lockpicking)
	* [Guides/Techniques](#guides)
	* [Videos/Talks](#talks)
	* [Books](#books)
	* [Sites/Organizations](#sites)
* [Alarm Systems](#alarm)
* [Doors](#doors)

-----------------------
### <a name="general"></a>
* **General**
	* **101**
		* [Physical Security - Centre for the Protection of National Infrastructure - UK](https://www.cpni.gov.uk/physical-security)
	* **Articles/Blogposts/Writeups**
		* [The Green Beret Hotel Check-In Safety List](https://www.entrepreneur.com/article/286411)
		* [Physical Home Security Options - DiabloHorn](https://diablohorn.wordpress.com/2014/07/13/physical-home-security-options/#more-984)
		* [Contents of a Physical Pentester Backpack](https://www.tunnelsup.com/contents-of-a-physical-pen-testers-backpack/)
		* [Hacking things by touching them - armadillo](https://www.armadillophone.com/blog/2017/08/27/hacking-things-by-touching-them)
		* [Under Cover of Darkness: Practical considerations for (legally) breaking and entering. - Tom](https://medium.com/tsscyber/under-cover-of-darkness-7c2b4b5203f8)
	* **Videos/Talks**
		* [Physical Security: From Locks to Dox - Jess Hires](http://www.irongeek.com/i.php?page=videos/derbycon4/t540-physical-security-from-locks-to-dox-jess-hires)
			* This talk is an introduction to Physical Penetration Testing. I briefly cover the Penetration Testing Methodology from a Physical Security perspective, but the talk is mostly oriented around the analysis and exploitation phases. Various attacks will be covered, from lock picking and bypass to safe cracking. No prior experience with lock picking or physical security is required, I will start with the basics and work up to advanced topics.
		* [Physical Penetration Testing You Keep a Knockin But You Cant Come In Phil Grime](https://www.youtube.com/watch?v=_0gz_iWoMT0)
		* [Home Insecurity: No Alarms, False Alarms, and SIGINT](https://media.defcon.org/DEF%20CON%2022/DEF%20CON%2022%20presentations/Logan%20Lamb/DEFCON-22-Logan-Lamb-HOME-INSECURITY-NO-ALARMS-FALSE-ALARMS-AND-SIGINT-WP.pdf)
			* The market share of home security systems has substantially increased as vendors incorporate more desirable features: intrusion detection, automation, wireless, and LCD touch panel controls. Wireless connectivity allows vendors to manufacture cheaper, more featureful products that require little to no home modification to install.  Consumer win, since adding devices is easier. The result: an ostensibly more secure, convenient, and connected home for a larger number of citizens. Sadly, this hypothesis is flawed; the idea of covering a home with more security sensors does not translate into a more secure home.  Additionally, the number of homes using these vulnerable systems is large, and the growth rate is increasing producing a even larger problem. In this paper, we will demonstrate a generalized approach for compromising three systems: ADT, the largest home security dealer in North America; Honeywell, one of the largest manufacturers of security devices; and Vivint, a top 5 security dealer.  We will suppress alarms, create false alarms, and collect artifacts that facilitate tracking the movements of individuals in their homes
		* [Defcon 19: DIY Non-Destructive-Entry](https://www.youtube.com/watch?v=ChbyaXBKNY8)
		* [Home Alone with localhost - Automating Home Defense - Chris Littlebury Defcon22](https://www.youtube.com/watch?v=9Tbft190x3Q)
		* [88MPH Digital tricks to bypass Physical security- Andrew MacPherson - ZaCon4](https://vimeo.com/52865794)
	* **Tools**
		* [Hacks and Crafts: Improvised Physical Security Tools for Improvised Situations - CG](https://www.youtube.com/watch?v=hrXzt2mdwl4&list=PLjpIlpOLoRNQxZXPxPUzBkzU5m0iZkPG_&index=5)
		* [zoneminder](https://www.zoneminder.com/)
			* A full-featured, open source, state-of-the-art video surveillance software system.
* **Tamper Evident Related**<a name="lockpicking"></a>
	* **101**
		* [What does tamper-evident mean?](https://www.healthcarepackaging.com/article/package-design/structural/what-does-tamper-evident-mean)
		* [Tamper-evident technology - Wikipedia](https://en.wikipedia.org/wiki/Tamper-evident_technology)
	* **Articles/Blogposts/Writeups**
		* [Tamper resistance and  hardware security](https://www.cl.cam.ac.uk/~sps32/PartII_030214.pdf)
		* [How to Steal a Nuclear Warhead Without Voiding Your XBox Warranty (paper)](https://www.scribd.com/document/47334072/How-to-Steal-a-Nuclear-Warhead-Without-Voiding-Your-XBox-Warranty-paper)
	* **Talks/Videos**
		* [Introduction to Tamper Evident Devices -DEFCON 19 ](https://www.youtube.com/watch?v=SIQml3MBJoE&spfreload=10)
* **Lock Picking**<a name="lockpicking"></a>
	* **101**
		* [Wikipedia on Lockpicking](https://en.wikipedia.org/wiki/Lock_picking)
	* **General**
		* [Various types of locks](https://securitysnobs.com/Types-Of-Locks.html)
		* [lockwiki](http://www.lockwiki.com/index.php/Main_Page)
	* **Books**
		* [Locksport Primer](http://pdf.textfiles.com/security/lsiguide.pdf)
		* [Academic book on Locks](https://www.goodreads.com/book/show/525753.Locks_Safes_and_Security)
		* [MIT Guide to Lockpicking](http://www.capricorn.org/~akira/home/lockpick/)
	* **Guides**
		* [Newbies guide to picking safes](http://cybergibbons.com/lockpicking-2/a-newbies-guide-to-safes/)
		* [Attack the Key, Own the Lock - Defcon18](https://www.youtube.com/watch?v=_-PqzkoQQ7s)
		* [Key Impressioning by Jos Weyers - Defcon 19](https://www.youtube.com/watch?v=s8aQSxXoLFk)
		* [Safecracking for the computer scientist * ](http://www.crypto.com/papers/safelocks.pdf)
		* [Jos Weyers – Lock Impressioning](https://www.youtube.com/watch?v=JcNc1BVaCE0)
		* [CIA Lock Picking [Field Operative Training Manual]](https://archive.org/details/pdfy-eGBVTYko5TUI5P_B)
		* [Lock Picking Course - LockLab](https://lock-lab.com/locklab-university/lock-picking-course-2/)
		* [A newbies guide to safes, both opening and using](https://www.reddit.com/r/WhatsInThisThing/comments/1gm6uk/a_newbies_guide_to_safes_both_opening_and_using/)
		* [How To Pick Locks: The Definitive Guide To Lock Picking - unitedlocksmith](https://unitedlocksmith.net/blog/how-to-pick-locks-the-definitive-guide-to-lock-picking?utm_content=buffer87d82&utm_medium=social&utm_source=twitter.com&utm_campaign=buffer)
	* **Videos/Talks**
		* [Safe to Armed in Seconds - Deviant Ollam - DEF CON 19](https://www.youtube.com/watch?v=3SVMT_zNlgA)
		* [This Key is Your Key, This Key is My Key - Howard Payne & Deviant Ollam](https://www.youtube.com/watch?v=a9b9IYqsb_U)
		* [I'll Let Myself In Tactics of Physical Pentesters - Deviant Ollam -B-sides Orlando 2017](https://www.youtube.com/watch?v=Rctzi66kCX4)
		* [Introduction to Lockpicking and Physical Security - DEFCON 13](https://www.youtube.com/watch?v=JupQ3BpKGYg)
		* [Lockpicking by Deviant Ollam](http://deviating.net/lockpicking/videos.html)
			* Glorious set of videos and instructional information. Must watch.
		* [Electronic Locks - are really secure?!](https://www.youtube.com/watch?v=ZK0MfE7o4HU)
			* Many people are familiar with the ways in which mechanical locks can be attacked, compromised, and bypassed. Indeed, the hands-on workshops and the availability of pick tools at the Lockpick Village is an enduring part of the fun at DeepSec and other popular security conferences around the world. Often, attendees will ask questions like, "So, this is really great... but what if someone is using an electronic lock? How hard is it to open the door, then?" Unfortunately, due to time and space constraints, our answer is typically, "Well... that's a very complicated question. Sometimes they're good, and sometimes they're weak." We often promise greater detail another day, another time... but until now that time has not come. Finally now, however, TOOOL will describe some of the most popular electronic locks and show examples of how they can sometimes be attacked.
		* [Distinguishing Lockpicks: Raking vs Lifting vs Jiggling and More - Deviant Ollam](https://www.youtube.com/watch?v=e07VRxJ01Fs)
		* [Mastering Master Keys - Deviant Ollam - HOPE Number 9](https://www.youtube.com/watch?v=aVPSaKLKHd4)
		* [!$@$Lockpicking & Physical security - Deviant Ollam - Best lockpicking course abc tutorial diy](https://www.youtube.com/watch?v=j6WCe-4XQ3Q)
		* [Lockpicking, Safecracking, & More by Deviant Ollam & renderman at ShmooCon 3](https://www.youtube.com/watch?v=WTgUVhjts2U)
			* For the first time on the same stage together at ShmooCon, renderman and i give a funny and informative presentation about lockpicking using much of my traditional material as well as a whole load of new content that my favorite Canadian demonstrates. In addition to his all-around general badassery, renderman even opened up a locked safe on stage... one that he had never seen before and was simply given by an audience member. That took fucking balls.
		* ["Lockpicking in Real Life versus on the Screen" - The Eleventh HOPE (2016)](https://www.youtube.com/watch?v=mjBSocgMCPU)
			* We all know that Hollywood has a difficult time portraying hackers accurately. This quirk often extends to the realm of showing lockpicking in movies and on TV. But sometimes, a film gets it really right! This talk is both an introduction to lockpicking (in case you still need to learn) as well as a walk through some of the best - and some of the worst - scenes of lockpicking that have ever been seen by movie and TV audiences. Learn about how to be a better lockpicker and a better filmmaker... all at the same time!
		* [Electronic Safe Fail](http://www.irongeek.com/i.php?page=videos/centralohioinfosec2015/tech204-electronic-safe-fail-jeff-popio)
		* Commonly safes are used in IT to secure backup tapes, certificate roots, and other sensitive material. This talk will demonstrate that many of the safes used to secure these sensitive materials are ineffective. Today there are many varieties of electronic safes that utilize a VERY weak mechanism to physically lock the safe. In many cases there are ways to open the safe in less than a minute that leaves no evidence behind. (Sometimes only a few seconds) This talk will cover my experience discovering the flaw and dealing with a safe vendor to issue a fix, then discovering the inadequacies of the fix itself and vendor's continuing ignorance of the problem with most electronic locks. Fixing these problems can be relatively easy. There will be general instruction on how to fix the problems and what needs to be done by the vendors to make safes well... safer."
		* [Lockpicking how to video using a cut-away lock](http://www.youtube.com/watch?v=LSt0RxkA_f8)
		* [Distinguishing Lockpicks: Raking vs Lifting vs Jiggling and More - Deviant Ollam](https://www.youtube.com/watch?v=e07VRxJ01Fs)
	* **Sites/Organizations**
		* [The Open Organization of Lockpickers](http://toool.us/)
			* The mission of the Open Organisation Of Lockpickers is to advance the general public knowledge about locks and lockpicking. By examining locks, safes, and other such hardware and by publicly discussing our findings we hope to strip away the mystery with which so many of these products are imbued.  The more that people know about lock technology, the better they are capable of understanding how and where certain weaknesses are present. This makes them well-equipped to participate in sportpicking endeavors and also helps them simply be better consumers in the marketplace, making decisions based on sound fact and research.
		* [lockpicking101](http://www.lockpicking101.com/)
			* A community dedicated to the fun and ethical hobby of lock picking.
		* [/r/lockpicking - Reddit Lockpicking Community](https://www.reddit.com/r/lockpicking)
		* [keypicking.com](http://www.keypicking.com/)
* **Alarm Systems**<a name="alarm"></a>
	* **101**
	* **General**
	* **Videos/Talks**
		* [Ways your alarm system can fail - abak Javadi Keith Howell](https://www.youtube.com/watch?v=g4-B7d3ZQUA)
		* [Alarmed About Your Alarm System Yet - Keith Howell, Babak Javadi](https://www.youtube.com/watch?v=5rnkhqEj_Po)
		* [Hacking Wireless Home Security Systems by Eric Escobar - BSides Manchester2017](https://www.youtube.com/watch?v=kERUpg5YMis&index=12&list=PLcgqQkap1lNrOBNCXqpPqpPAqckxv0XhP)
		* [Home Insecurity: No Alarms, False Alarms, and SIGINT](https://media.defcon.org/DEF%20CON%2022/DEF%20CON%2022%20presentations/Logan%20Lamb/DEFCON-22-Logan-Lamb-HOME-INSECURITY-NO-ALARMS-FALSE-ALARMS-AND-SIGINT-WP.pdf)
		* [Let's get physical: Breaking home security systems & bypassing controls - Black Hat USA 2013](https://www.youtube.com/watch?v=O4ya3z-PCQs)
* **Doors**<a name="doors"></a>
	* **101**
	* **Articles/Blogposts/Writeups**
		* [Door Control Systems: An Examination of Lines of Attack](https://www.nccgroup.com/en/blog/2013/09/door-control-systems-an-examination-of-lines-of-attack/)
	* **Talks/Videos**
		* [What Does The Perfect Door Or Padlock Look Like? - Deviant Ollam - BruCON 0x08](https://www.youtube.com/watch?v=4skSBwBBI-s&list=PLtb1FJdVWjUfCe1Vcj67PG5Px8u1VY3YD&index=2)
		* [What Does The Perfect Door Or Padlock Look Like? - Deviant Ollam - BruCON 0x08](https://www.youtube.com/watch?v=4skSBwBBI-s)
		* [The Search for the Perfect Door - Deviant Ollam - Shakacon](https://www.youtube.com/watch?v=4YYvBLAF4T8)
			* You have spent lots of money on a high-grade, pick-resistant, ANSI-rated lock for your door. Your vendor has assured you how it will resist attack and how difficult it would be for someone to copy your key. Maybe they’re right. But… the bulk of attacks that both penetration testers and also criminals attempt against doors have little or nothing to do with the lock itself! This talk will be a hard-hitting exploration (full of photo and video examples) of the ways in which your door — the most fundamental part of your physical security — can possibly be thwarted by someone attempting illicit entry. The scary problems will be immediately followed by simple solutions that are instantly implementable and usually very within-budget. You, too, can have a near-perfect door… if you’re willing to learn and understand the problems that all doors tend to have. 
		* [Physical Security - Everything That's Wrong With Your Typical Door - Deviant Ollam - SANS Webcast](https://www.youtube.com/watch?v=raBMFqZRB0s&t=&feature=youtu.be&app=desktop)




