# Exploit Development

## Table of Contents
* [General Stuff/Techniques](#general)
* [Acquiring Old/Vulnerable Software](#acquire)
* [Practice Exploit Dev/Structured Learning](#practice)
* [Exploit Dev Papers](#expapers)
	* [bof](#bof)
	* [ROP](#ROP)
		* BlindROP
		* SignalROP
		* JumpROP
	* [Heap](#heap)
	* [Format String](#fs)
	* [Integer Overflows](#into)
	* [Null Ptr Dereference](#nullptr)
	* [JIT-Spray](#jit)
	* [ASLR](#aslr)
	* [Kernel Exploitation](#kernelex)
	* [Use After Free](#uaf)
	* [Other](#other)
* [writing shellcode](#shellcode)
	* Windows Specific
	* Linux specific
* [Tutorials](#tutorials)
* [AV Bypass Methods](#avbypass)
* [Bypassing Exploit Protections/Mitigations](#bypass-ep)
	* DEP/SEHop/ASLR
	* CFG/EMET
	* DeviceGuard
* [Obfuscation](#obfuscation)
* [ARM Specific things](#arm)
* [Linux Specific](#linux)
* [Windows Specific](#windows)
* [Bypass SEH/SE-HOP; ](#SEH)
* [Windows Heap Exploitation](#winheap)
* [Anti Fuzzing](#antifuzz)
* [Assembly](#asm)
* [Anti Debugging](#antidebug)
* [General Tools](#generaltools)
	* General
	* Hunting/Making Exploits
	* Shellcode
* [Decompilers/Disassemblers](#decomp)
* [Debuggers](#debug)
	* General
	* Linux 
	* Windows
* [General Papers](#papers)
* [Miscellaneous Exploit Writeups](#miscex)
	* Talks
	* blogposts
	* Papers
* [Attacking AV](#attackav)
* [Finding Vulnerabilities](#finding)
* [GPU Exploit/Research](#gpu)
* [Building a lab to Practice Exploit Development](#lab)


#### To Do
* Sort tools better, like enviromental tools vs use-specific tools
* Corelan, swift, primal Exploit Series
* Add more sites to Acquiring Old/Vulnerable Software
* More sites to structured learning
* Add ARM stuff
* Add more on Borrowed-Instruction-Set Computing


* [Why .shared sections are a security hole](https://devblogs.microsoft.com/oldnewthing/?p=38253)
https://rastating.github.io/creating-a-custom-shellcode-encoder/
https://www.corelan.be/index.php/2019/04/23/windows-10-egghunter/
https://blog.flanker017.me/galaxy-leapfrogging-pwning-the-galaxy-s8/
https://blog.flanker017.me/galaxy-leapfrogging-pwning-the-galaxy-s8/

http://blog.azimuthsecurity.com/2013/05/exploiting-samsung-galaxy-s4-secure-boot.html

https://github.com/swisskyrepo/PayloadsAllTheThings
https://github.com/Cn33liz/MS17-012
https://github.com/qazbnm456/awesome-cve-poc#cve-2018-5318
https://github.com/Cn33liz/Tater
https://exploit.education/

https://www.contextis.com/en/blog/a-beginners-guide-to-windows-shellcode-execution-techniques

https://m0chan.github.io/2019/08/21/Win32-Buffer-Overflow-SEH.html
https://googleprojectzero.blogspot.com/2019/09/windows-exploitation-tricks-spoofing.html

	* [High-Level Approaches for Finding Vulnerabilities - @Jackson_T](https://web.archive.org/web/20171119102445/https://jackson.thuraisamy.me/finding-vulnerabilities.html)

* [Bypassing Windows ASLR in Microsoft Office using ActiveX controls - Parvez](https://www.greyhathacker.net/?p=894)
* [Exploiting the Linux kernel via packet sockets - Andrey Konovalov](https://googleprojectzero.blogspot.com/2017/05/exploiting-linux-kernel-via-packet.html)
	* https://github.com/xairy/kernel-exploits/tree/master/CVE-2017-7308
https://github.com/CENSUS/shadow
https://heap-exploitation.dhavalkapil.com/attacks/house_of_spirit.html
http://blog.sevagas.com/?Code-segment-encryption
Solaris
	* https://techblog.mediaservice.net/2018/11/cve-2018-14665-exploit-local-privilege-escalation-on-solaris-11/
	* https://www.giac.org/paper/gcih/700/local-privilege-escalation-solaris-8-solaris-9-buffer-overflow-passwd1/105309
	* https://www.exploit-db.com/exploits/715


* [I Am Groot: Examining the Guardians of Windows 10 Security - Chuanda Ding(Defcon China 1)](https://www.youtube.com/watch?v=a0AB76YNMlQ)
	* Being one of the main targets of 3 Pwn2Own competitions, Microsoft Windows 10, along with Microsoft Edge, is proven more and more difficult to exploit. Now Windows 10 has been released for more than 2 years, Microsoft has been constantly updating the security mitigations integrated with the operating system. After 5 major releases, multiple levels of protections have been added to prevent a programming error from turning into a full system compromise. You may have heard many of them marketed as "Guards" under the Windows Defender brand. But how do they actually work? As Pwn2Own participants (and winners), we closely watched Windows 10 security evolve over the years. In this talk, you will get a behind-the-scene view of Windows 10 security mitigation implementations, how it helped make attackers' life harder, and how the attackers overcame it.

	* https://www.thezdi.com/blog/2019/3/13/cve-2019-0604-details-of-a-microsoft-sharepoint-rce-vulnerability
	* https://habr.com/ru/company/pt/blog/448378/
	* https://blog.ret2.io/2018/08/28/pwn2own-2018-sandbox-escape/
	* CVE-2017-11882
	* http://www.trapkit.de/books/bhd/en.html#code

iOS Exploitation - Title: 2PAC 2FURIOUS: Envisioning an iOS compromise in 2019
	* https://googleprojectzero.blogspot.com/2019/04/splitting-atoms-in-xnu.html
	* https://www.qualcomm.com/media/documents/files/whitepaper-pointer-authentication-on-armv8-3.pdf

Android Chrome exploitation infiltrate
	* https://vimeo.com/270454588
https://osandamalith.com/2018/02/01/exploiting-format-strings-in-windows/
https://googleprojectzero.blogspot.com/2017/05/exploiting-linux-kernel-via-packet.html
* [Get Cozy with OpenBSM Auditing...the good, the bad, & the ugly - Patrick Wardle](https://objective-see.com/talks/Wardle_ShmooCon2018.pdf)
* [Getting Cozy With OpenBSM Auditing On MacOS - Patrick Wardle](https://www.youtube.com/watch?v=CqlpJ7rIT6M)
	* With the demise of dtrace on macOS, and Apple’s push to rid the kernel of 3rd-party kexts, another option is needed to perform effective auditing on macOS. Lucky for us, OpenBSM fits the bill. Though quite powerful, this auditing mechanism is rather poorly documented and suffered from a variety of kernel vulnerabilities. In this talk, we’ll begin with an introductory overview of OpenBSM’s goals, capabilities, and components before going ‘behind-the-scenes’ to take a closer look at it’s kernel-mode implementation. Armed with this understanding, we’ll then detail exactly how to build powerful user-mode macOS monitoring utilities such as file, process, and networking monitors based on the OpenBSM framework and APIs. Next we’ll don our hacker hats and discuss a handful of kernel bugs discovered during a previous audit of the audit subsystem (yes, quite meta): a subtle off-by-one read error, a blotched patch that turned the off-by-one into a kernel info leak, and finally an exploitable heap overflow. Though now patched, the discussion of these bugs provides an interesting ‘case-study’ of finding and exploiting several types of bugs that lurked within the macOS kernel for many years



* [Bypassing Windows ASLR by determining the library address using shared pages - stackoverflow](https://stackoverflow.com/questions/29865977/bypassing-windows-aslr-by-determining-the-library-address-using-shared-pages)

https://modexp.wordpress.com/2019/05/10/dotnet-loader-shellcode/

Prep for https://medium.com/@iphelix/exodus-vuln-dev-master-class-44741b1ebdd5
	https://msrc-blog.microsoft.com/2009/02/02/preventing-the-exploitation-of-structured-exception-handler-seh-overwrites-with-sehop/
	https://trailofbits.files.wordpress.com/2010/04/practical-rop.pdf
	https://www.csc2.ncsu.edu/faculty/xjiang4/pubs/ASIACCS11.pdf
	https://www.corelan.be/index.php/2013/07/02/root-cause-analysis-integer-overflows/
	http://www.phreedom.org/research/heap-feng-shui/
	http://illmatics.com/Understanding_the_LFH_Slides.pdf
	https://net-ninja.net/article/2012/Mar/1/heap-overflows-for-humans-104/

https://github.com/googleprojectzero/iOS-messaging-tools
https://googleprojectzero.blogspot.com/2019/04/windows-exploitation-tricks-abusing.html
https://googleprojectzero.blogspot.com/p/working-at-project-zero.html

http://blog.sevagas.com/?Code-segment-encryption


* [windows-kernel-exploits](https://github.com/SecWiki/windows-kernel-exploits)
* https://j00ru.vexillium.org/papers/2018/bochspwn_reloaded.pdf



https://www.youtube.com/watch?v=gu_i6LYuePg
https://j00ru.vexillium.org/syscalls/nt/64/
http://www.exploit-monday.com/2013/08/writing-optimized-windows-shellcode-in-c.html
https://hovav.net/ucsd/dist/noret-ccs.pdf
* [Practical case: Buffer Overflow 0x01 - ](https://maxkersten.nl/binary-analysis-course/assembly-basics/practical-case-buffer-overflow-0x01/)
https://googleprojectzero.blogspot.com/2018/04/windows-exploitation-tricks-exploiting.html



---------------
### <a name="general">General</a>
* **General**
	* **101**
		* [Getting Cozy with Exploit Development - mallardlabs](https://blog.mallardlabs.com/getting-cozy-with-exploit-development/)
	* **Articles/Papers/Talks/Writeups**
		* [Vulnserver - my KSTET exploit (delivering the final stage shellcode through the active server socket) - ewilded.blogspot](https://ewilded.blogspot.com/2018/01/vulnserver-my-kstet-exploit-delivering.html)
	* **Educational/Informative**
		* [A brief history of Exploitation - Devin Cook](http://www.irongeek.com/i.php?page=videos/derbycon4/t514-a-brief-history-of-exploitation-devin-cook)
		* [Mechanization of Exploits](https://github.com/REMath/literature_review/blob/master/mechanization_of_exploits.org)
		* [REMath](https://github.com/REMath/literature_review)
		* [Exploit Mitigation Killchain](http://0xdabbad00.com/wp-content/uploads/2013/04/exploit_mitigation_kill_chain.pdf)
		* [Exploit Tips and Techniques(ReCon2014 William Peteroy)](https://www.youtube.com/watch?v=FEXnJKXYoLM)
		* [Root Cause Analysis – Memory Corruption Vulnerabilities](https://www.corelan.be/index.php/2013/02/26/root-cause-analysis-memory-corruption-vulnerabilities/)		
		* [Unusual Bugs(23C3)](https://www.youtube.com/watch?v=qj79Qdmw0Pk)
			* In this presentation I'll present a series of unusual security bugs. Things that I've ran into at some point and went "There's gotta be some security consequence here". None of these are really a secret, and most of them are even documented somewhere. But apparently most people don't seem to know about them.  What you'll see in this presentation is a list of bugs and then some explanation of how these could be exploited somehow. Some of the things I'll be talking about are (recursive) stack overflow, NULL pointer dereferences, regular expressions and more.
		* [From MS08 067 To EternalBlue by Denis Isakov - BSides Manchester2017](https://www.youtube.com/watch?v=LZ_G6RdqrHA&index=13&list=PLcgqQkap1lNrOBNCXqpPqpPAqckxv0XhP)
		* [RAP: RIP ROP (GRSEC/PaX team)](https://pax.grsecurity.net/docs/PaXTeam-H2HC15-RAP-RIP-ROP.pdf)
	* **Tools**
		* **Testing Payloads**
			* [pop-nedry](https://github.com/zznop/pop-nedry)
				* Why pop calc, when you can pop Nedry!? This repository contains an x86-64 payload that recreates the Jurassic Park scene in which Dennis Nedry locks Ray Arnold out of his terminal.	
		* [Vivisect](https://github.com/vivisect/vivisect)
			* Fairly un-documented static analysis / emulation / symbolic analysis framework for PE/Elf/Mach-O/Blob binary formats on various architectures.
		* [Dr. Memory](https://github.com/DynamoRIO/drmemory)
			* Dr. Memory is a memory monitoring tool capable of identifying memory-related programming errors such as accesses of uninitialized memory, accesses to unaddressable memory (including outside of allocated heap units and heap underflow and overflow), accesses to freed memory, double frees, memory leaks, and (on Windows) handle leaks, GDI API usage errors, and accesses to un-reserved thread local storage slots. Dr. Memory operates on unmodified application binaries running on Windows, Linux, Mac, or Android on commodity IA-32, AMD64, and ARM hardware.
	* **Miscellaneous**
		* [OneRNG](http://moonbaseotago.com/onerng/theory.html)
		* [Offset-DB](http://offset-db.com/)
			* This website provide you a list of useful offset that you can use for your exploit.

---------------
### <a name="acquire">Acquiring Old/Vulnerable Software</a>
* [Acquiring VMs of any Windows going back to XP to Windows 10](https://www.modern.ie/en-us/virtualization-tools#downloads)
* [OldApps.com](http://www.oldapps.com/)

--------------
### <a name="practice"></a>Practice Exploit Development / Structured Learning
* [Exploit-Challenges - A collection of vulnerable ARM binaries for practicing exploit development](https://github.com/Billy-Ellis/Exploit-Challenges)
	* Here are a collection of vulnerable ARM binaries designed for beginner vulnerability researchers & exploit developers to play around with and test their skills!
* [BinTut](https://github.com/NoviceLive/bintut)
	* Dynamic or live demonstration of classical exploitation techniques of typical memory corruption vulnerabilities, from debugging to payload generation and exploitation, for educational purposes
* [ROP Emporium](https://ropemporium.com/)
	* Learn return-oriented programming through a series of challenges designed to teach ROP techniques in isolation, with minimal reverse-engineering and bug-hunting.
* [Pwnables.kr](https://pwnable.kr)



------------------ 
* Originally from (originally a pastebin link, which had been modified from a persons personal page, i believe it may have been an r2 dev?) If you made this, thank you so much; I've now added onto it and changed it from what it originally was. I've kept the original creator's note as I feel it is highly relevant and aligns with my goal)

* "My intention with this document is for it to be somewhat of a recommended reading list for the aspiring hacker. I have tried to order the articles by technique and chronology. - sar"

### <a name="bof">Buffer overflows:</a>
* [How to write buffer overflows, mudge, 1995](http://insecure.org/stf/mudge_buffer_overflow_tutorial.html)
* [Smashing the stack for fun and profit, Aleph One, 1996](http://www.phrack.com/issues.html?issue=49&id=14)
* [Smashing the Stack for Fun and Profit in 2010](http://www.mgraziano.info/docs/stsi2010.pdf)
* [The Frame Pointer Overwrite, klog, 1999](http://www.phrack.com/issues.html?issue=55&id=8)
* [win32 buffer overflows, dark spyrit, 1999](http://www.phrack.com/issues.html?issue=55&id=15)
* [Understanding Buffer Overflow Exploits](http://proactivedefender.blogspot.com/2013/05/understanding-buffer-overflows.html)
 

------------------ 
### <a name="rop">Return-into-lib / Return oriented programming:</a>
* [Getting around non-executable stack (and fix) (First public description of a return-into-libc exploit), Solar Designer, 1997](http://marc.info/?l=bugtraq&m=87602746719512)
* [More advanced ret-into-lib(c) techniques, Nergal, 2001](http://www.phrack.com/issues.html?issue=58&id=4)
* [On the effectiveness of address-space randomization, , 2004](http://benpfaff.org/papers/asrandom.pdf)
* [Introduction to Return Oriented Programming (ROP) - ketansingh.net](https://ketansingh.net/Introduction-to-Return-Oriented-Programming-ROP/)
* [Gentle introduction to ROP programming](http://blog.zynamics.com/2010/03/12/a-gentle-introduction-to-return-oriented-programming/)
* [Borrowed code chunks exploitation technique, Sebastian Krahmer, 2005](http://www.suse.de/~krahmer/no-nx.pdf)
* [The Geometry of Innocent Flesh on the Bone: Return-into-libc without function calls, Hovav Shacham, 2007](http://cseweb.ucsd.edu/~hovav/dist/geometry.pdf)
* [Defeating DEP, the Immunity Debugger way, Pablo Sole,2008](http://www.immunitysec.com/downloads/DEPLIB.pdf)
* [The Case of Return-Oriented Programming and the AVC Advantage, 2009](http://www.usenix.org/event/evtwote09/tech/full_papers/checkoway.pdf)
* [Practical Return-Oriented Programming, Dino A. Dai Zovi, 2010](http://www.sourceconference.com/bos10pubs/Dino.pdf)
* [Return-Oriented Programming without Returns](https://www.cs.uic.edu/~s/papers/noret_ccs2010/noret_ccs2010.pdf)
* [Introduction to ROP programming](http://codearcana.com/posts/2013/05/28/introduction-to-return-oriented-programming-rop.html)
* [Return-Oriented Programming without Returns - Stephen Checkoway, Lucas Davi, Alexandra Dmitrienko, Ahmad-Reza Sadeghi, Hovav Shacham, and Marcel Winandy](https://hovav.net/ucsd/papers/cddssw10.html)
	* We show that on both the x86 and ARM architectures it is possible to mount return-oriented programming attacks without using return instructions. Our attacks instead make use of certain instruction sequences that behave like a return, which occur with sufficient frequency in large libraries on (x86) Linux and (ARM) Android to allow creation of Turing-complete gadget sets. Because they do not make use of return instructions, our new attacks have negative implications for several recently proposed classes of defense against return-oriented programming: those that detect the too-frequent use of returns in the instruction stream; those that detect violations of the last-in, first-out invariant normally maintained for the return-address stack; and those that modify compilers to produce code that avoids the return instruction.


#### Blind ROP
* [Blind Return Oriented Programming (BROP)](http://www.scs.stanford.edu/~sorbo/brop/) 
	* The BROP attack makes it possible to write exploits without possessing the target's binary. It requires a stack overflow and a service that restarts after a crash. Based on whether a service crashes or not (i.e., connection closes or stays open), the BROP attack is able to construct a full remote exploit that leads to a shell. The BROP attack remotely leaks enough gadgets to perform the write system call, after which the binary is transferred from memory to the attacker's socket. Following that, a standard ROP attack can be carried out. Apart from attacking proprietary services, BROP is very useful in targeting open-source software for which the particular binary used is not public (e.g., installed from source setups, Gentoo boxes, etc.). The attack completes within 4,000 requests (within minutes) when tested against a toy proprietary service, and real vulnerabilities in nginx and MySQL. 
* [Hacking Blind - BROP paper](http://www.scs.stanford.edu/~sorbo/brop/bittau-brop.pdf)
* [Blind Return Oriented Programming](http://www.scs.stanford.edu/brop/)
* [Blind Return Oriented Programming (BROP) Attack (1)](http://ytliu.info/blog/2014/05/31/blind-return-oriented-programming-brop-attack-yi/)
* [Blind Return Oriented Programming (BROP) Attack (2)](http://ytliu.info/blog/2014/06/01/blind-return-oriented-programming-brop-attack-er/)

#### Signal ROP
* [Sigreturn Oriented Programming is a real Threat](https://subs.emis.de/LNI/Proceedings/Proceedings259/2077.pdf)
* [Playing with signals : An overview on Sigreturn Oriented Programming](https://thisissecurity.net/2015/01/03/playing-with-signals-an-overview-on-sigreturn-oriented-programming/)
* [SROP | Signals, you say?](https://0x00sec.org/t/srop-signals-you-say/2890)

#### Jump Oriented Programming
* [Jump-Oriented Programming: A New Class of Code-Reusegghunte](https://www.comp.nus.edu.sg/~liangzk/papers/asiaccs11.pdf)
* [Attacking x86 Windows Binaries by Jump Oriented Programming](http://www.uni-obuda.hu/users/szakala/INES%202013%20pendrive/61_ines2013.pdf)
* [Jumping the Fence Comparison and Improvements for Existing Jump Oriented Programming Tools - John Dunlap - Derbycon7](https://www.youtube.com/watch?v=eRICJ_bEC54&index=15&list=PLNhlcxQZJSm-PKUZTYe1C94ymf0omysM3)






------------------ 
### <a name="heap">Heap exploitation:</a>
* [how2heap - shellphish](https://github.com/shellphish/how2heap)
	* A repository for learning various heap exploitation techniques.
* [w00w00 on heap overflows, Matt Conover, 1999](http://w00w00.org/files/articles/heaptut.txt)
* [Vudo - An object superstitiously believed to embody magical powers, Michel "MaXX" Kaempf, 2001](http://www.phrack.com/issues.html?issue=57&id=8)
* [Once upon a free(), anonymous author, 2001](http://www.phrack.com/issues.html?issue=57&id=9)
* [Advanced Doug Lea's malloc exploits, jp, 2003](http://www.phrack.com/issues.html?issue=61&id=6) 
* [Exploiting the wilderness, Phantasmal Phantasmagoria, 2004](http://www.derkeiler.com/Mailing-Lists/securityfocus/vuln-dev/2004-02/0024.html)
* [Malloc Maleficarum, Phantasmal Phantasmagoria, 2005](http://www.packetstormsecurity.org/papers/attack/MallocMaleficarum.txt)
* [Yet another free() exploitation technique, huku, 2009](http://www.phrack.com/issues.html?issue=66&id=6)
* [Heap Feng Shui in JavaScript](https://www.blackhat.com/presentations/bh-usa-07/Sotirov/Whitepaper/bh-usa-07-sotirov-WP.pdf) 
* [heap-exploitation](https://github.com/DhavalKapil/heap-exploitation)
	* This book on heap exploitation is a guide to understanding the internals of glibc's heap and various attacks possible on the heap structure.
* [Project HeapBleed](http://census-labs.com/news/2014/11/27/project-heapbleed/)
	* CENSUS researcher Patroklos Argyroudis has recently presented a talk on heap exploitation abstraction at two conferences, namely ZeroNights 2014 (Moscow, Russia) and BalCCon 2014 (Novi Sad, Serbia). In the talk titled Project Heapbleed, Patroklos has collected the experience of exploiting allocators in various different target applications and platforms. He focused on practical, reusable heap attack primitives that aim to reduce the exploit development time and effort.


------------------ 
### <a name="format">Format string exploitation:</a>
* [Exploiting format string vulnerabilities, scut / Team-TESO, 2001](http://crypto.stanford.edu/cs155old/cs155-spring08/papers/formatstring-1.2.pdf)
* [Advances in format string exploitation, gera, 2002](http://www.phrack.com/issues.html?issue=59&id=7)
* [An alternative method in format string exploitation, K-sPecial, 2006](https://web.archive.org/web/20070513143544/http://www.milw0rm.com/papers/103)
* [Maximum Overkill Two - From Format String Vulnerability to Remote Code Execution](https://barrebas.github.io/blog/2015/02/22/maximum-overkill-two-from-format-string-vulnerability-to-remote-code-execution/)
 * [Exploiting Format Strings: Getting the Shell](http://resources.infosecinstitute.com/exploiting-format-strings-getting-the-shell/)



------------------ 
### <a name="into">Integer overflows:</a>
* [Big Loop Integer Protection, Oded Horovitz, 2002](http://www.phrack.com/issues.html?issue=60&id=9)
* [Basic Integer Overflows, blexim, 2002](http://www.phrack.com/issues.html?issue=60&id=10)
 


------------------ 
### <a name="nullptr">Null-ptr dereference:</a>
* [Large memory management vulnerabilities, Gael Delalleau, 2005](http://cansecwest.com/core05/memory_vulns_delalleau.pdf)
* [Exploiting the Otherwise Non-exploitable on Windows, skape, 2006](http://www.uninformed.org/?v=4&a=5&t=pdf)
* [Vector rewrite attack, Barnaby Jack, 2007](http://www.juniper.net/solutions/literature/white_papers/Vector-Rewrite-Attack.pdf)
* [Application-Specific Attacks: Leveraging the ActionScript Virtual Machine, Mark Dowd, 2008](http://documents.iss.net/whitepapers/IBM_X-Force_WP_final.pdf)
 

------------------ 
### <a name="jit">JIT-spray:</a>
* [Pointer inference and JIT-Spraying, Dion Blazakis, 2010](http://www.semantiscope.com/research/BHDC2010/BHDC-2010-Paper.pdf)
* [Writing JIT shellcode for fun and profit, Alexey Sintsov, 2010](http://dsecrg.com/files/pub/pdf/Writing%20JIT-Spray%20Shellcode%20for%20fun%20and%20profit.pdf)
 * [Too LeJIT to Quit: Extending JIT Spraying to ARM](http://www.internetsociety.org/sites/default/files/09_3_2.pdf)
* [Interpreter  Exploitation: Pointer Inference and JIT Spraying](http://www.semantiscope.com/research/BHDC2010/BHDC-2010-Paper.pdf)
* [Understanding JIT Spray](http://blog.cdleary.com/2011/08/understanding-jit-spray/)
* [Writing JIT-Spray Shellcode For Fun And Profit](https://packetstormsecurity.com/files/86975/Writing-JIT-Spray-Shellcode-For-Fun-And-Profit.html)
 * [The Devil is in the Constants: Bypassing Defenses in Browser JIT Engines](http://users.ics.forth.gr/~elathan/papers/ndss15.pdf)


------------------ 
### <a name="aslr"> ASLR:</a>
* [Exploit writing tutorial part 6 : Bypassing Stack Cookies, SafeSeh, SEHOP, HW DEP and ASLR](https://www.corelan.be/index.php/2009/09/21/exploit-writing-tutorial-part-6-bypassing-stack-cookies-safeseh-hw-dep-and-aslr/)
* [Aslr Smack and Laugh Reference](http://www-users.rwth-aachen.de/Tilo.Mueller/ASLRpaper.pdf)
* [Advanced Buffer Overflow Methods](http://www.cs.tau.ac.il/tausec/lectures/Advanced_Buffer_Overflow_Methods.ppt)
* [Smack the Stack](http://www.sts.synflood.de/dump/doc/smackthestack.txt)
* [Exploiting the random number generator to bypass ASLR](https://www.blackhat.com/presentations/bh-europe-09/Fritsch/Blackhat-Europe-2009-Fritsch-Bypassing-aslr-whitepaper.pdf)
* [Wikipedia on ASLR](https://www.en.wikipedia.org/wiki/Address_space_layout_randomization)
* [Bypassing Memory Protections: The Future of Exploitation](http://www.usenix.org/events/sec09/tech/slides/sotirov.pdf)
* [On the Effectiveness of Address-Space Randomization](https://www.stanford.edu/~blp/papers/asrandom.pdf)
* [Exploiting with linux-gate.so.1](https://web.archive.org/web/20100205151431/milw0rm.com/papers/55)
* [Circumventing the VA kernel patch For Fun and Profit](https://web.archive.org/web/20090826171410/http://www.milw0rm.com:80/papers/94)
* [Defeating the Matasano C++ Challenge](https://timetobleed.com/defeating-the-matasano-c-challenge-with-aslr-enabled/)
* [Bypassing PaX ASLR protection](https://www.phrack.com/issues.html?issue=59&id=9)
* [Thoughts about ASLR, NX Stack and format string attacks](https://www.nibbles.tuxfamily.org/?p=1190)
* [Return-into-libc without Function Calls](http://www.cseweb.ucsd.edu/~hovav/dist/geometry.pdf)
* [Linux ASLR Curiosities. Tavis Ormandy. Julien Tinnes](https://www.cr0.org/paper/to-jt-linux-alsr-leak.pdf)
* [Fun With Info-Leaks(DEP+ASLR bypass)](https://rh0dev.github.io/blog/2015/fun-with-info-leaks/)/
	* This article is about information leaks in form of memory disclosures created in Internet Explorer 10 32-bit on Windows 7 64-bit. They are used to bypass full ASLR/DEP to gain remote code execution. While the software containing the bug might not be that popular, it's quite nice what can be done with the bug.
* [Reducing the Effective Entropy of GS Cookies](http://uninformed.org/?v=all&a=32&t=sumry)
* [Exploiting Buffer Overflows On Kernels With Aslr Enabled Using Brute Force On The Stack Layer](http://www.securitytube.net/video/273)
* [Bypassing The Linux Kernel Aslr And Exploiting A Buffer Overflow Vulnerable Application With Ret2esp](http://www.securitytube.net/video/178)
	* This video tutorial illustrates how to exploit an application vulnerable to buffer overflow under a modern 2.6 Linux kernel with ASLR, bypassing stack layer randomization by search a `jmp *%esp` inside the executable file and forcing our program to jump there. 
* [Exploiting A Buffer Overflow Under Linux Kernel 2.6 With Aslr Through Ret2reg](http://www.securitytube.net/video/236)
	* Linux kernel versions 2.6.x implement ASLR to faexecution of arbitrary code located in the stack segment of a process. Moreover, kernel versions >= 2.6.18 also made the allocation of ld-linux.so.2 dynamic, and recent compilers also tend to avoid the generation of `jmp|call *%esp` instructions, so the use of a ret2esp technique to exploit a vulnerable application is becoming harder and harder. A way to turn around the problem is analyzing the registers situations just a while before the vulnerable code is executed: very probably one of them points to the address of the vulnerable buffer. All we have to do is searching inside the executable or a static library a ret2reg instruction, where reg is the register pointing to the vulnerable area, and use that as return address.
* [Pwn2Own 2010 Windows 7 Internet Explorer 8 exploit](http://vreugdenhilresearch.nl/Pwn2Own-2010-Windows7-InternetExplorer8.pdf)




------------------ 
### <a name="kernelex">Kernel Exploitation</a>
* [Attacking the Core : Kernel Exploiting Notes](http://phrack.org/issues/64/6.html)
* [Much ado about NULL: Exploiting a kernel NULL dereference](https://blogs.oracle.com/ksplice/entry/much_ado_about_null_exploiting)
* [Integer Overflow in FreeBSD Kernel(2002)](http://archives.neohapsis.com/archives/vulnwatch/2003-q1/att-0006/01-pine-cert-20030101.txt.asc)
* [Post MS06-035 Mailslot DoS Workaround(Kernel Null Ptr Deref)](http://eeyeresearch.typepad.com/blog/2006/08/post_ms06035_ma.html)
* https://lkml.org/lkml/2010/5/27/490
* [Attacking the XNU Kernel For Fun And Profit: Part 1](http://blog.qwertyoruiop.com/?p=38)
	* This blog post is part of a series of posts in which I will discuss several techniques to own XNU, the kernel used by Apple's OS X and iOS. My focus will be on heap-based attacks, such as heap overflows, double frees, use-after-frees and zone confusion.



------------------ 
### <a name="uaf">Addendum: Use-After-Free</a>
* [An Introduction to Use After Free Vulnerabilities](https://www.purehacking.com/blog/lloyd-simon/an-introduction-to-use-after-free-vulnerabilities)
* [Exploit writing tutorial part 11 : Heap Spraying Demystified](https://www.corelan.be/index.php/2011/12/31/exploit-writing-tutorial-part-11-heap-spraying-demystified/)
* [Part 9: Spraying the Heap [Chapter 2: Use-After-Free] – Finding a needle in a Haystack](https://www.fuzzysecurity.com/tutorials/expDev/11.html)


------------------ 
Other:
* [Overwriting the .dtors section, Juan M. Bello Rivas, 2000](http://seclists.org/bugtraq/2000/Dec/175)
* [Abusing .CTORS and .DTORS for fun 'n profit, Izik, 2006](http://vxheavens.com/lib/viz00.html)
* [Large memory management vulnerabilities, Gael Delalleau, 2005](https://cansecwest.com/core05/memory_vulns_delalleau.pdf)
* [Symlinks and Cryogenic Sleep](http://seclists.org/bugtraq/2000/Jan/16)
* [Clutching at straws: When you can shift the stack pointer](http://sebug.net/paper/phrack/63/p63-0x0e_Shifting_the_Stack_Pointer.txt)
* 
-------------------------------

--------------------------------

-------------------------------------

### <a name="tutorials">Exploit Development Tutorials</a>
* **Structured Learning/Courses**
	* [Modern Windows Exploit Development](http://expdev-kiuhnm.rhcloud.com/download-the-book/)
	* [Bypassing All the Things](https://www.exodusintel.com/files/Aaron_Portnoy-Bypassing_All_Of_The_Things.pdf)
		* Handholding through Vuln Discovery and Exploitation
	* [Smashing the Browser - From fuzzing to 0day on IE11](https://github.com/demi6od/Smashing_The_Browser)
		* Goes from introducing a fuzzer to producing an IE11 0day
	* [armpwn](https://github.com/saelo/armpwn)
		* "Repository to train/learn memory corruption exploitation on the ARM platform. This is the material of a workshop I prepared for my CTF Team."
* **Tutorials/Follow-alongs**
	* [From fuzzing to 0-day](http://blog.techorganic.com/2014/05/14/from-fuzzing-to-0-day/)
	* [SQL Injection to MIPS Overflows: Part Deux](https://s3.amazonaws.com/zcutlip_storage/SQL%20Injection%20to%20MIPS%20Overflows%20-%20Part%20Deux.pdf)
		* This paper is a followup to a paper presented at BlackHat USA 2012, entitled SQL Injec0ons to MIPS Overflows: Rooting SOHO Routers." That previous paper described how to combine SQL injection vulnerabilies with MIPS Linux buffer overflows in order to gain root on Netgear SOHO routers. This paper revisits the MiniDLNA UPnP server that ships on nearly all Netgear routers in order to explore what has changed in the past two years.
	* [Writing a stack-based overflow exploit in Ruby with the help of vulnserver.exe and Spike 2.9](https://cyberandspace.wordpress.com/category/kali-linux/)
	* [From 0-day to exploit Buffer overflow in Belkin N750 (CVE-2014-1635)](https://labs.integrity.pt/articles/from-0-day-to-exploit-buffer-overflow-in-belkin-n750-cve-2014-1635/)
	* AVM Fritz!Box root RCE: From Patch to Metasploit Module
		* [Part 1](http://breaking.systems/blog/2014/04/avm-fritzbox-root-rce-from-patch-to-metasploit-module-i)
		* [Part 2](http://breaking.systems/blog/2014/04/avm-fritzbox-root-rce-from-patch-to-metasploit-module-ii)
	* [Link to Lab Writeup for Winx86 ExploitDev Practice](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/Draft/Exploit%20Development/Lab%20for%20Practicing%20Exploit%20Writing.txt)
* **Corelan**
	* [Exploit writing tutorial part 10 : Chaining DEP with ROP – the Rubik’s[TM] Cube](https://www.corelan.be/index.php/2010/06/16/exploit-writing-tutorial-part-10-chaining-dep-with-rop-the-rubikstm-cube/)
	* [Exploit writing tutorial part 11 : Heap Spraying Demystified](https://www.corelan.be/index.php/2011/12/31/exploit-writing-tutorial-part-11-heap-spraying-demystified/)
	* [QuickZip Stack BOF 0day: a box of chocolates](https://www.corelan.be/index.php/2010/03/27/quickzip-stack-bof-0day-a-box-of-chocolates/)
* **FuzzySecurity**
	* [Part 9: Spraying the Heap [Chapter 2: Use-After-Free] – Finding a needle in a Haystack](https://www.fuzzysecurity.com/tutorials/expDev/11.html)
* **SwiftSecurity**
	


--------------------
### <a name="asm">Assembly(x86/x64/ARM)</a>
* [X86 Instruction Reference](http://www.Felixcoutier.com/x86)
* [Awesome Reference for Intel x86/64](http://ref.x86asm.net/)
	* This reference is intended to be precise opcode and instruction set reference (including x86-64). Its principal aim is exact definition of instruction parameters and attributes.
* [Nasm x86 reference](https://www.cs.uaf.edu/2006/fall/cs301/support/x86/)
* [Intel Pentium Instruction Set Reference (A)](http://faydoc.tripod.com/cpu/index_a.htm)
* [Iczelion's Win32 Assembly Homepage](http://www.programminghorizon.com/win32assembly/)
* [cgasm](https://github.com/bnagy/cgasm)
	* cgasm is a standalone, offline terminal-based tool with no dependencies that gives me x86 assembly documentation. It is pronounced "SeekAzzem".


-----------------
### <a name="shellcode">Shellcode</a>
* **ShellCode**
	* **101**
	* **Articles/Blogposts/Writeups**
		* Introduction to Windows Shellcode Development - securitycafe.ro
			* [Introduction to Windows shellcode development – Part 1](https://securitycafe.ro/2015/10/30/introduction-to-windows-shellcode-development-part1/)
			* [Introduction to Windows shellcode development – Part 2](https://securitycafe.ro/2015/12/14/introduction-to-windows-shellcode-development-part-2/)
			* [Introduction to Windows shellcode development – Part 3](https://securitycafe.ro/2016/02/15/introduction-to-windows-shellcode-development-part-3/)
		* Windows Kernel Shellcode on Windows 10 - improsec.com
			* [Windows Kernel Shellcode on Windows 10 – Part 1](https://improsec.com/blog//windows-kernel-shellcode-on-windows-10-part-1)
			* [Windows Kernel Shellcode on Windows 10 – Part 2](https://improsec.com/blog//windows-kernel-shellcode-on-windows-10-part-2)
			* [Windows Kernel Shellcode on Windows 10 – Part 3](https://improsec.com/blog//windows-kernel-shellcode-on-windows-10-part-3)
			* [Windows Kernel Shellcode on Windows 10 – Part 4 - There is No Code](https://improsec.com/blog//windows-kernel-shellcode-on-windows-10-part-4-there-is-no-code)
	* **Educational/Informative**
		* [Shellcode Time: Come on Grab Your Friends - wartortell -Derbycon4](http://www.irongeek.com/i.php?page=videos/derbycon4/t116-shellcode-time-come-on-grab-your-friends-wartortell)
			* Packed shellcode is a common deterrent against reverse engineering. Mainstream software will use it in order to protect intellectual property or prevent software cracking. Malicious binaries and Capture the Flag (CTF) challenges employ packed shellcode to hide their intended functionality. However, creating these binaries is an involved process requiring significant experience with machine language. Due to the complexity of creating packed shellcode, the majority of samples are painstakingly custom-created or encoded with very simple mechanisms, such as a single byte XOR. In order to aid in the creation of packed shellcode and better understand how to reverse engineer it, I created a tool to generate samples of modular packed shellcode. During this talk, I will demonstrate the use of the shellcode creation tool and how to reverse engineer the binaries it creates. I will also demonstrate an automated process for unpacking the binaries that are created.
	* **How to Write it**
		* [Shellcoding for Linux and Windows Tutorial - Steve Hannah](http://www.vividmachines.com/shellcode/shellcode.html)
		* [Phrack Magazine Extraction Utility](http://phrack.org/issues/57/18.html) 
			* writing ia32 alphanumeric shellcode
		* [shellcode tutorials](http://projectshellcode.com/?q=node/12)
		* [Writing Manual Shellcode by Hand](https://www.exploit-db.com/docs/17065.pdf)
		* **Linux Specific**
			* [Writing my first shellcode - iptables -P INPUT ACCEPT](https://0day.work/writing-my-first-shellcode-iptables-p-input-accept/)
		* **<a name="winspec"></a>Windows Specific**
			* [WinAPI for Hackers](https://www.bnxnet.com/wp-content/uploads/2015/01/WinAPIs_for_hackers.pdf)
			* [History and Advances in Windows Shellcode - Phrack 2004](http://phrack.org/issues/62/7.html)
			* [Writing Win32 Shellcode with VisualStudio](http://winternl.com/2016/05/02/hello-world/)
				* demonstrating how to write optimized (sort of) Win32 shellcode using Visual Studio’s compiler
	* **Techniques**
		* [Loading and Debugging Windows Kernel Shellcodes with Windbg. Debugging DoublePulsar Shellcode.](https://vallejo.cc/2017/06/23/loading-and-debugging-windows-kernel-shellcodes-with-windbg-debugging-doublepulsar-shellcode/)
		* [Shellcode Debugging with OllyDbg](https://blackc0.de/2014/06/shellcode-debugging-ollydbg/)
		* **Canaries**
				* [Playing with canaries](https://www.elttam.com.au/blog/playing-with-canaries/)
		* **Code Trampolines**
			* [Trampolines in x64](http://www.ragestorm.net/blogs/?p=107)
		* Finding Opcodes: 
			* metasploit opcode DB; 
			* memdump; 
			* pvefindaddr - mona.py
		* **Egg Hunters**
			* [Beta aaKsYS TEAM: EGG HUNTER (Windows)](https://www.exploit-db.com/docs/18482.pdf)
				* Explanation of egghunters, how they work and a working demonstration on windows.
			* [jmp2it](https://github.com/adamkramer/jmp2it)
				* This will allow you to transfer EIP control to a specified offset within a file containing shellcode and then pause to support a malware analysis investigation  The file will be mapped to memory and maintain a handle, allowing shellcode to egghunt for second stage payload as would have happened in original loader  Patches / self modifications are dynamically written to jmp2it-flypaper.out
		* [Resolving the Base Pointer of the Linux Program Interpreter with Shellcode](https://web-beta.archive.org/web/20160720084253/http://howto.hackallthethings.com:80/2015/03/resolving-base-pointer-of-linux-program.html)
		* [Art of Picking Intel Registers](http://www.swansontec.com/sregisters.html)
		* [Using ARM Inline Assembly and Naked Functions to fool Disassemblers](http://www.evilsocket.net/2015/05/02/using-inline-assembly-and-naked-functions-to-fool-disassemblers/#sthash.Gt6f7f7y.4pLres53.sfju)
		* [Shellcode without Sockets](https://0x00sec.org/t/remote-exploit-shellcode-without-sockets/1440)
		* [English Shellcode](http://web.cs.jhu.edu/~sam/ccs243-mason.pdf)
			* History indicates that the security community commonly takes a divide-and-conquer approach to battling malware threats: identify the essential and inalienable components of an attack, then develop detection and prevention techniques that directly target one or more of the essential components. This abstraction is evident in much of the literature for buffer overflow attacks including, for instance, stack protection and NOP sled detection. It comes as no surprise then that we approach shellcode detection and prevention in a similar fashion. However, the common belief that components of polymorphic shellcode (e.g., the decoder) cannot reliably be hidden suggests a more implicit and broader assumption that continues to drive contemporary research: namely, that valid and complete representations of shellcode are fundamentally different in structure than benign payloads. While the first tenet of this assumption is philosoph- ically undeniable (i.e., a string of bytes is either shellcode or it is not), truth of the latter claim is less obvious if there exist encoding techniques capable of producing shellcode with features nearly indistinguishable from non-executable content. In this paper, we challenge the assumption that shellcode must conform to superficial and discernible representations. Specifically, we demonstrate a technique for automatically producing English  Shellcode, transforming arbitrary shellcode into a representation that is superficially similar to English prose. The shellcode is completely self-contained - i.e., it does not require an external loader and executes as valid IA32 code)—and can typically be generated in under an hour on commodity hardware. Our primary objective in this paper is to promote discussion and stimulate new ideas for thinking ahead about preventive measures for tackling evolutions in code-injection attacks
		* **Obfuscation/Hiding**
			* [X86 Shellcode Obfuscation - Part 1 - breakdev.org](https://breakdev.org/x86-shellcode-obfuscation-part-1/)
			* [Less is More, Exploring Code/Process-less Techniques and Other Weird Machine Methods to Hide Code (and How to Detect Them)](https://cansecwest.com/slides/2014/less%20is%20more3.pptx)
			* [Obfuscating python](https://reverseengineering.stackexchange.com/questions/1943/what-are-the-techniques-and-tools-to-obfuscate-python-programs)
			* [Code segment encryption](http://blog.sevagas.com/?Code-segment-encryption)
	* **General**
	* **Reference/Resources**
		* [Shellcodes database for study cases](http://shell-storm.org/shellcode/)
	* **REPLs**
		* [rappel](https://github.com/yrp604/rappel/)
			* Rappel is a pretty janky assembly REPL. It works by creating a shell ELF, starting it under ptrace, then continiously rewriting/running the .text section, while showing the register states. It's maybe half done right now, and supports Linux x86, amd64, armv7 (no thumb), and armv8 at the moment.(As of Aug 2017)
		* [WinREPL](https://github.com/zerosum0x0/WinREPL)
			* x86 and x64 assembly "read-eval-print loop" shell for Windows
	* **Tools**
		* **General**
			* [Sickle](https://github.com/wetw0rk/Sickle)
				* Sickle is a shellcode development tool, created to speed up the various steps needed to create functioning shellcode.
			* [meterssh](https://github.com/trustedsec/meterssh)
				* MeterSSH is a way to take shellcode, inject it into memory then tunnel whatever port you want to over SSH to mask any type of communications as a normal SSH connection.
			* [Shellcode_Tools](https://github.com/MarioVilas/shellcode_tools)
				* Miscellaneous tools written in Python, mostly centered around shellcodes.
				* bin2py: Embed binary files into Python source code.
				* shellcode2exe: Convert shellcodes into executable files for multiple platforms.
			* [ShellSploit Framework](https://github.com/b3mb4m/shellsploit-framework)
			* [shellnoob](https://github.com/reyammer/shellnoob)
				* A shellcode writing toolkit
			* [rex](https://github.com/shellphish/rex)
				* Shellphish's automated exploitation engine, originally created for the Cyber Grand Challenge. 
			* [Patcherex](https://github.com/shellphish/patcherex)
				* Shellphish's automated patching engine, originally created for the Cyber Grand Challenge. 
			* [sRDI](https://github.com/monoxgas/sRDI)
				* Shellcode implementation of Reflective DLL Injection. Convert DLLs to position independent shellcode
			* [ShellcodeStdio](https://github.com/jackullrich/ShellcodeStdio)
				* An extensible framework for easily writing debuggable, compiler optimized, position independent, x86 shellcode for windows platforms.
			* [OWASP ZSC](https://github.com/viraintel/OWASP-ZSC)
				* OWASP ZSC is open source software written in python which lets you generate customized shellcode and convert scripts to an obfuscated script. This software can be run on Windows/Linux/OSX with python.
			* [Shellen](https://github.com/merrychap/shellen)
				* Shellen is an interactive shellcoding environment. If you want a handy tool to write shellcodes, then shellen may be your friend. Shellen can also be used as an assembly or disassembly tool. keystone and capstone engines are used for all of shellen's operations. Shellen only works on python3. python2 support may appear in the future.
		* **Encoders**
			* [Context-keyed Payload Encoding](http://uninformed.org/?v=all&a=42&t=sumry)
				* A common goal of payload encoders is to evade a third-party detection mechanism which is actively observing attack traffic somewhere along the route from an attacker to their target, filtering on commonly used payload instructions. The use of a payload encoder may be easily detected and blocked as well as opening up the opportunity for the payload to be decoded for further analysis. Even so-called keyed encoders utilize easily observable, recoverable, or guessable key values in their encoding algorithm, thus making decoding on-the-fly trivial once the encoding algorithm is identified. It is feasible that an active observer may make use of the inherent functionality of the decoder stub to decode the payload of a suspected exploit in order to inspect the contents of that payload and make a control decision about the network traffic. This paper presents a new method of keying an encoder which is based entirely on contextual information that is predictable or known about the target by the attacker and constructible or recoverable by the decoder stub when executed at the target. An active observer of the attack traffic however should be unable to decode the payload due to lack of the contextual keying information.
		* **Obfuscators**
			* [UniByAv](https://github.com/Mr-Un1k0d3r/UniByAv)
				* UniByAv is a simple obfuscator that take raw shellcode and generate executable that are Anti-Virus friendly. The obfuscation routine is purely writtend in assembly to remain pretty short and efficient. In a nutshell the application generate a 32 bits xor key and brute force the key at run time then perform the decryption of the actually shellcode.
	* **Miscellaneous**




-------------------
### <a name="bypass-ep">Bypassing Exploit Protections/Mitigations & Corresponding literature</a>
* **101**
	* [A Brief History of Exploit Techniques and Mitigations on Windows](http://www.hick.org/~mmiller/presentations/misc/exploitation_techniques_and_mitigations_on_windows.pdf)
	* [Windows Exploit Protection History/Overview - Compass Security](https://exploit.courses/files/bfh2017/day6/0x60_WindowsExploiting.pdf)
* **Articles/Blogposts/Writeups**
	* **ASLR**
		* [Defeating the Matasano C++ Challenge with ASLR enabled](http://timetobleed.com/defeating-the-matasano-c-challenge-with-aslr-enabled/)
	* **Win10**
		* [Toward mitigating arbitrary native code execution in Windows 10](https://github.com/Microsoft/MSRC-Security-Research/blob/master/presentations/2017_05_SysScan360_Seattle/SyScan360_Miller_Towards_Mitigating_Arbitrary_Native_Code_Execution.pdf)
		* [Strengthening the Microsoft Edge Sandbox](https://blogs.windows.com/msedgedev/2017/03/23/strengthening-microsoft-edge-sandbox/#Y6ziSVVBqc1TPHFp.97)
		* [Mitigating arbitrary native code execution in Microsoft Edge](https://blogs.windows.com/msedgedev/2017/02/23/mitigating-arbitrary-native-code-execution/#fAlvade7vV0bQrWs.97)
* **General**
	* [Exploit Mitigation Killchain](http://0xdabbad00.com/wp-content/uploads/2013/04/exploit_mitigation_kill_chain.pdf)
* **Stack Protections**
	* **Reference Material**
		* [Stack Smashing Protector](http://wiki.osdev.org/Stack_Smashing_Protector)
	* **DEP/SEHop/ASLR/NX**
		* [Understanding DEP as a mitigation Technology](http://blogs.technet.com/b/srd/archive/2009/06/05/understanding-dep-as-a-mitigation-technology-part-1.aspx)
		* [Preventing the Exploitation of SEH Overwrites](http://uninformed.org/?v=all&a=24&t=sumry)
			* This paper proposes a technique that can be used to prevent the exploitation of SEH overwrites on 32-bit Windows applications without requiring any recompilation. While Microsoft has attempted to address this attack vector through changes to the exception dispatcher and through enhanced compiler support, such as with /SAFESEH and /GS, the majority of benefits they offer are limited to image files that have been compiled to make use of the compiler enhancements. This limitation means that without all image files being compiled with these enhancements, it may still be possible to leverage an SEH overwrite to gain code execution. In particular, many third-party applications are still vulnerable to SEH overwrites even on the latest versions of Windows because they have not been recompiled to incorporate these enhancements. To that point, the technique described in this paper does not rely on any compile time support and instead can be applied at runtime to existing applications without any noticeable performance degradation. This technique is also backward compatible with all versions of Windows NT+, thus making it a viable and proactive solution for legacy installations. 
		* [Understanding DEP as a mitigation Technology](http://blogs.technet.com/b/srd/archive/2009/06/05/understanding-dep-as-a-mitigation-technology-part-1.aspx)
		* [Preventing the Exploitation of Structured Exception Handler (SEH) Overwrites with SEHOP](http://blogs.technet.com/b/srd/archive/2009/02/02/preventing-the-exploitation-of-seh-overwrites-with-sehop.aspx)
		* [Fun With Info-Leaks(DEP+ASLR bypass)](https://rh0dev.github.io/blog/2015/fun-with-info-leaks/)/
			* This article is about information leaks in form of memory disclosures created in Internet Explorer 10 32-bit on Windows 7 64-bit. They are used to bypass full ASLR/DEP to gain remote code execution. While the software containing the bug might not be that popular, its quite nice what can be done with the bug.
		* [Bypassing Windows Hardware-enforced Data Execution Prevention Oct 2, 2005](http://www.uninformed.org/?v=2&a=4&t=txt)
		* [Bypassing Windows Hardware-enforced DEP ](http://uninformed.org/?v=all&a=11&t=sumry)
			* This paper describes a technique that can be used to bypass Windows hardware-enforced Data Execution Prevention (DEP) on default installations of Windows XP Service Pack 2 and Windows 2003 Server Service Pack 1. This technique makes it possible to execute code from regions that are typically non-executable when hardware support is present, such as thread stacks and process heaps. While other techniques have been used to accomplish similar feats, such as returning into NtProtectVirtualMemory, this approach requires no direct reprotecting of memory regions, no copying of arbitrary code to other locations, and does not have issues with NULL bytes. The result is a feasible approach that can be used to easily bypass the enhancements offered by hardware-enforced DEP on Windows in a way that requires very minimal modifications to existing exploits. 
		* [Exploit Writeup on Flash vuln explaining use of ASLR + DEP bypass](http://www.semantiscope.com/research/BHDC2010/BHDC-2010-Slides-v2.pdf)
		* [DEP/ASLR bypass without ROP/JIT](https://cansecwest.com/slides/2013/DEP-ASLR bypass without ROP-JIT.pdf)
			* [Slides, codes and videos of the talk "DEP/ASLR bypass without ROP/JIT" on CanSecWest 2013](https://github.com/tombkeeper/DEP-and-ASLR-bypass-without-ROP-or-JIT)
		* [Bypassing SEHOP](https://repo.zenk-security.com/Reversing%20.%20cracking/Bypassing%20SEHOP.pdf)
		* [Great Writeup/Example of SEH Bypass](http://www.primalsecurity.net/0x3-exploit-tutorial-buffer-overflow-seh-bypass/)
		* [SEH Overwrites Simplified v1.01](http://repo.palkeo.com/hacking/bas%20niveau/SEH%20overwrite.pdf)
		* [(SEH Bypass)Defeating the Stack Based Buffer Overflow Prevention Mechanism of Microsoft Windows 2003 Server.](https://www.blackhat.com/presentations/bh-asia-03/bh-asia-03-litchfield.pdf)
		* [A Crash Course on the Depths of Win32 Structured Exception Handling](https://www.microsoft.com/msj/0197/exception/exception.aspx)
		* [Intro to Windows kernel exploitation 1/N: Kernel Debugging](https://www.whitehatters.academy/intro-to-kernel-exploitation-part-1/)
		* [Win32 Assembly Components - Last Stage of Delirium Research Group](http://www.bandwidthco.com/whitepapers/programming/asm/Win32%20Assembly%20Components.pdf)
		* [Preventing the Exploitation of Structured Exception Handler (SEH) Overwrites with SEHOP](https://blogs.technet.microsoft.com/srd/2009/02/02/preventing-the-exploitation-of-structured-exception-handler-seh-overwrites-with-sehop/)
		* [Structured Exception Handling - TechNet](https://msdn.microsoft.com/en-us/library/windows/desktop/ms680657%28v=vs.85%29.aspx)
		* [Defeating Microsoft Windows XP SP2 Heap protection and DEP bypass ](https://www.ptsecurity.com/upload/corporate/ww-en/download/defeating-xpsp2-heap-protection.pdf)
		* [x86-64 buffer overflow exploits and the borrowed code chunks exploitation technique](http://users.suse.com/~krahmer/no-nx.pdf)
			* The x86-64 CPU platform (i.e. AMD64 or Hammer) introduces new features to protect against exploitation of buffer overflows, the so called No Execute(NX) or Advanced Virus Protection (A VP). This non-executable enforcement of data pages and the ELF64 SystemV ABI render common buffer overflow exploitation techniques useless. This paper describes and analyzes the protection mechanisms in depth. Research and tar get platform was a SUSE Linux 9.3 x86-64 system but the results can be expanded to non-Linux systems as well.
	* **DeviceGuard**
		* [Bypassing Device Guard with .NET Assembly Compilation Methods](http://www.exploit-monday.com/2017/07/bypassing-device-guard-with-dotnet-methods.html)
	* **EMET/Control Flow Guard**
		* [Exploring Control-Flow-Guard in Windows10](http://sjc1-te-ftp.trendmicro.com/assets/wp/exploring-control-flow-guard-in-windows10.pdf)
		* [Bypassing EMET's EAF with custom shellcode using kernel pointer](https://www.greyhathacker.net/?p=483)
		* [Bypassing EMET 4.1](http://labs.bromium.com/2014/02/24/bypassing-emet-4-1/)
			* [Paper](https://bromiumlabs.files.wordpress.com/2014/02/bypassing-emet-4-1.pdf)
		* [Disarming and Bypassing EMET 5.1 - OffSec](http://www.offensive-security.com/vulndev/disarming-and-bypassing-emet-5-1/)
		* [Bypassing Microsoft EMET 5.1 . Yet again.](http://blog.sec-consult.com/2014/11/bypassing-microsoft-emet-51-yet-again.html)
		* [Disarming and Bypassing EMET 5.1](https://www.offensive-security.com/vulndev/disarming-and-bypassing-emet-5-1/)
		* [Defeating EMET 5.2 Protections - Part 1](http://casual-scrutiny.blogspot.in/2015/03/defeating-emet-52.html)
		* [Defeating EMET 5.2 Protections - Part 2](http://casual-scrutiny.blogspot.in/2015/03/defeating-emet-52-protections-2.html)
		* [Bypassing EMET 5.2 Protection](http://adsecurity.org/?p=1487)
		* [BYPASSING EMET Export Address Table Access Filtering feature](http://piotrbania.com/all/articles/anti_emet_eaf.txt)
		* [Disarming Control Flow Guard Using Advanced Code Reuse Attacks](https://www.endgame.com/blog/disarming-control-flow-guard-using-advanced-code-reuse-attacks)
		* [BYPASS CONTROL FLOW  GUARD  COMPREHENSIVELY - Zhang Yunhai](https://www.blackhat.com/docs/us-15/materials/us-15-Zhang-Bypass-Control-Flow-Guard-Comprehensively-wp.pdf)
		* [Proposed Windows 10 EAF/EMET "Bypass" for Reflective DLL Injection](https://zerosum0x0.blogspot.com/2017/06/proposed-eafemet-bypass-for-reflective.html?m=1)
	* **Kernel PatchGuard/Protection**
		* [Kernel Patch Protection - Wikipedia](https://en.wikipedia.org/wiki/Kernel_Patch_Protection)
		* [An Introduction to Kernel Patch Protection - blogs.msdn](https://blogs.msdn.microsoft.com/windowsvistasecurity/2006/08/12/an-introduction-to-kernel-patch-protection/)
		* [KPP Destroyer](http://forum.cheatengine.org/viewtopic.php?t=573311)
		* [Bypassing PatchGuard 3](https://www.codeproject.com/Articles/28318/Bypassing-PatchGuard)
		* [Disable PatchGuard - the easy/lazy way - fyyre](http://fyyre.ru/vault/bootloader.txt)
		* [GhostHook – Bypassing PatchGuard with Processor Trace Based Hooking](https://www.cyberark.com/threat-research-blog/ghosthook-bypassing-patchguard-processor-trace-based-hooking/)
		* [UPGSED Universal PatchGuard and Driver Signature Enforcement Disable](https://github.com/hfiref0x/UPGDSED)

* **Tools**
* **Miscellaneous**



--------------------
### Exploit Development
* **<a name="armspecific">ARM Specific Exploit Development</a>**
	* **101**
	* **Articles/Blogposts/Writeups**
	* **Educational/Informative**
		* [A SysCall to ARMs - Brendan Watters - Brendan Watters -Derbycon 2013](https://www.irongeek.com/i.php?page=videos/derbycon3/3304-a-syscall-to-arms-brendan-watters)
			* Description:ARM processors are growing more and more prevalent in the world; ARM itself claims that more than 20 billion chips have been shipped. Take a moment to appreciate that is about three chips for every man, woman, and child on earth. The three main topics I aim to cover are (1) how to perform a Linux system call on an ARM processor via assembly, ARM pipelining used in most modern ARM processors and how it came about, and (3) the really cool way ARM can avoid branching, even with conditional control flow. These will be explained in both code, English, and (hopefully successful) live demos using an ARM development board. The end result is to get the audience to understand how to create a simple socket program written in ARM assembly.
	* **Papers**
	* **Tools**
	* **Miscellaneous**
* **Adobe**
	* [Pwning Adobe Reader with XFA](http://siberas.de/presentations/SyScan360_2016_-_Pwning_Adobe_Reader_with_XFA.pdf)
	* [Adobe Reader Escape... or how to steal research and be lame.](http://sandboxescaper.blogspot.be/2018/01/adobe-reader-escape-or-how-to-steal.html)
* **Barcodes**
	* [SCANSPLOIT](https://github.com/huntergregal/scansploit)
		* Exploit using barcodes, QRcodes, earn13, datamatrix
* **Borrowed Instruction Programs**
	* [BISC: Borrowed Instructions Synthetic Computation](https://github.com/trailofbits/bisc)
		* BISC is a Ruby library for demonstrating how to build borrowed-instruction programs. BISC aims to be simple, analogous to a traditional assembler, minimize behind-the-scenes magic, and let users write simple macros. BISC was developed by Dino Dai Zovi for Practical Return-oriented Programming at Blackhat USA 2010 and was used for the Assured Exploitation course.
* **BroadPwn**
	* [A cursory analysis of @nitayart's Broadpwn bug (CVE-2017-9417)](http://boosterok.com/blog/broadpwn/)
	* [Emulation and Exploration of BCM WiFi Frame Parsing using LuaQEMU](https://comsecuris.com/blog/posts/luaqemu_bcm_wifi/)
	* [Broadpwn: Remotely Compromising Android and iOS via a Bug in Broadcom’s Wi-Fi Chipsets](https://blog.exodusintel.com/2017/07/26/broadpwn/)
	* [Crashing phones with Wi-Fi: Exploiting nitayart's Broadpwn bug (CVE-2017-9417)](http://boosterok.com/blog/broadpwn2/)
* **Cisco**
	* [Cisco IOS MIPS GDB remote serial protocol implementation](https://github.com/artkond/ios_mips_gdb)
		* A hacky implementation of GDB RSP to aid exploit development for MIPS based Cisco routers
	* [Cisco ASA Episode 3: A Journey In Analysing Heaps by Cedric Halbronn - BSides Manchester2017](https://www.youtube.com/watch?v=ADYdToi6Wn0&index=21&list=PLcgqQkap1lNrOBNCXqpPqpPAqckxv0XhP)
* **Glibc**
	* [Glibc Adventures: The Forgotten Chunks](http://www.contextis.com/documents/117/Glibc_Adventures-The_Forgotten_Chunks.pdf)
		* Exploiting Glibc
* **Hypervisor**
	* [Compromise-as-a-Service: Our PleAZURE.](https://www.troopers.de/events/troopers14/49_compromise-as-a-service_our_pleazure/)
		* This could be a comprehensive introduction about the ubiquity of virtualization, the essential role of the hypervisor, and how the security posture of the overall environment depends on it. However, we decided otherwise, as this is what everybody is interested in: We will describe the Hyper-V architecture in detail, provide a taxonomy of hypervisor exploits, and demonstrate how we found MS13-092 which had the potential to compromise the whole Azure environment. Live demo included!
* **Java Specific**
	* [Exploiting Memory Corruption Vulnerabilities in the Java Runtime](https://media.blackhat.com/bh-ad-11/Drake/bh-ad-11-Drake-Exploiting_Java_Memory_Corruption-WP.pdf)
* **Macros**
	* [It All Swings Around - Malicious Macros](http://sketchymoose.blogspot.com/2015/02/it-all-swings-round-malicious-macros.html)
		* Writeup and explanation of random Macro exploits
* **<a name="linuxspec">Linux Specific Exploit Development</a>**
	* **101**
	* **Articles/Blogposts/Writeups**
		* [Pool Blade: A new approach for kernel pool exploitation](https://zdresearch.com/pool-blade-a-new-approach-for-kernel-pool-exploitation/)
		* [Linux ASLR integer overflow: Reducing stack entropy by four](http://hmarco.org/bugs/linux-ASLR-integer-overflow.html)
			* A bug in Linux ASLR implementation for versions prior to 3.19-rc3 has been found. The issue is that the stack for processes is not properly randomized on some 64 bit architectures due to an integer overflow. This is a writeup of the bug and how to fix it.
		* [Linux GLibC Stack Canary Values](https://xorl.wordpress.com/2010/10/14/linux-glibc-stack-canary-values/)
		* [Shellshock bug writeup by lcamtuf](http://lcamtuf.blogspot.com/2014/10/bash-bug-how-we-finally-cracked.html)
		* [Adventures in Xen Exploitation](https://www.nccgroup.com/en/blog/2015/02/adventures-in-xen-exploitation/)
			* "This post is about my experience trying to exploit the Xen SYSRET bug (CVE-2012-0217)."
	* **Educational/Informative**
		* [Return into Lib(C) Theory Primer(Security-Tube)](http://www.securitytube.net/video/257)
		* [64-bit Linux Return-Oriented Programming - Standford](https://crypto.stanford.edu/~blynn/rop/)
		* [Understanding glibc malloc](https://sploitfun.wordpress.com/2015/02/10/understanding-glibc-malloc/)
	* **Heap**
		* [Painless intro to the Linux userland heap](https://sensepost.com/blog/2017/painless-intro-to-the-linux-userland-heap/)
		* [Linux Heap Exploitation Intro Series: Used and Abused – Use After Free](https://sensepost.com/blog/2017/linux-heap-exploitation-intro-series-used-and-abused-use-after-free/)
		* [Linux Heap Exploitation Intro Series: The magicians cape – 1 Byte Overflow](https://sensepost.com/blog/2017/linux-heap-exploitation-intro-series-the-magicians-cape-1-byte-overflow/)
	* **Kernel Exploit Development**
		* [Linux Kernel Exploitation Paper Archive - xairy](https://github.com/xairy/linux-kernel-exploitation)
	* **Papers**
		* [Cheating the ELF - Subversive Dynamic Linking to Libraries](http://www.cs.dartmouth.edu/~sergey/cs108/2010/subversiveld.pdf)
	* **Tools**
		* [rappel](https://github.com/yrp604/rappel/)
			* Rappel is a pretty janky assembly REPL. It works by creating a shell ELF, starting it under ptrace, then continiously rewriting/running the .text section, while showing the register states. It's maybe half done right now, and supports Linux x86, amd64, armv7 (no thumb), and armv8 at the moment.(As of Aug 2017)
		* [Build a database of libc offsets to simplify exploitation](https://github.com/niklasb/libc-database)
	* **Miscellaneous**
* **<a name="osx-specific"></a>OS X Specific**
	* **101**
	* **Articles/Blogposts/Papers/Writeups**	
		* [IOHIDeous](https://github.com/Siguza/IOHIDeous)
			* A macOS kernel exploit based on an IOHIDFamily 0day.
			* [Writeup](https://siguza.github.io/IOHIDeous/)
		* [OS X Kernel-mode Exploitation in a Weekend](http://uninformed.org/?v=all&a=37&t=sumry)
			* Apple's Mac OS X operating system is attracting more attention from users and security researchers alike. Despite this increased interest, there is still an apparent lack of detailed vulnerability development information for OS X. This paper will attempt to help bridge this gap by walking through the entire vulnerability development process. This process starts with vulnerability discovery and ultimately finished with a remote code execution. To help illustrate this process, a real vulnerability found in the OS X wireless device driver is used.
	* **Educational/Informative**
	* **Tools**
* **PDF**
	* [Advanced PDF Tricks - Ange Albertini, Kurt Pfeifle - [TROOPERS15]](https://www.youtube.com/watch?v=k9g9jZdjRcE)
* **RPC**
	* [Automating VMware RPC Request Sniffing - Abdul-Aziz Hariri - ZDI](https://www.zerodayinitiative.com/blog/2018/1/19/automating-vmware-rpc-request-sniffing)
		* In this blog, I will discuss how I was able to write a PyKD script to sniff RPC requests that helped me tremendously while writing VMware RPC exploits.
* **Software into Hardware back into Software**
	* [Exploiting the DRAM rowhammer bug to gain kernel privileges](http://googleprojectzero.blogspot.com/2015/03/exploiting-dram-rowhammer-bug-to-gain.html)
		* "Rowhammer is a problem with some recent DRAM devices in which repeatedly accessing a row of memory can cause bit flips in adjacent rows. We tested a selection of laptops and found that a subset of them exhibited the problem. We built two working privilege escalation exploits that use this effect. One exploit uses rowhammer-induced bit flips to gain kernel privileges on x86-64 Linux when run as an unprivileged userland process. When run on a machine vulnerable to the rowhammer problem, the process was able to induce bit flips in page table entries (PTEs). It was able to use this to gain write access to its own page table, and hence gain read-write access to all of physical memory.
	* [Program for testing for the DRAM "rowhammer" problem](https://github.com/google/rowhammer-test)
* **<a name="winspec">Windows Specific</a>**
	* **101**
	* **Articles/Blogposts/Writeups**
		* [Writing Exploits for Win32 Systems from Scratch](https://www.nccgroup.trust/uk/about-us/newsroom-and-events/blogs/2016/june/writing-exploits-for-win32-systems-from-scratch/)
		* [Exploiting MS14-066](http://www.securitysift.com/exploiting-ms14-066-cve-2014-6321-aka-winshock/)
		* [MS17-010: EternalBlue’s Large Non-Paged Pool Overflow in SRV Driver - blog.trendmicro](http://blog.trendmicro.com/trendlabs-security-intelligence/ms17-010-eternalblue/)
	* **Educational/Informative**
	* **Papers**
		* [Getting out of Jail: Escaping Internet Explorer Protected Mode](http://uninformed.org/?v=all&a=39&t=sumry)
			* With the introduction of Windows Vista, Microsoft has added a new form of mandatory access control to the core operating system. Internally known as "integrity levels", this new addition to the security manager allows security controls to be placed on a per-process basis. This is different from the traditional model of per-user security controls used in all prior versions of Windows NT. In this manner, integrity levels are essentially a bolt-on to the existing Windows NT security architecture. While the idea is theoretically sound, there does exist a great possibility for implementation errors with respect to how integrity levels work in practice. Integrity levels are the core of Internet Explorer Protected Mode, a new "low-rights" mode where Internet Explorer runs without permission to modify most files or registry keys. This places both Internet Explorer and integrity levels as a whole at the forefront of the computer security battle with respect to Windows Vista.
		* [PatchGuard Reloaded: A Brief Analysis of PatchGuard Version 3](http://uninformed.org/?v=all&a=38&t=sumry)
			* Since the publication of previous bypass or circumvention techniques for Kernel Patch Protection (otherwise known as "PatchGuard"), Microsoft has continued to refine their patch protection system in an attempt to foil known bypass mechanisms. With the release of Windows Server 2008 Beta 3, and later a full-blown distribution of PatchGuard to Windows Vista and Windows Server 2003 via Windows Update, Microsoft has introduced the next generation of PatchGuard to the general public ("PatchGuard 3"). As with previous updates to PatchGuard, version three represents a set of incremental changes that are designed to address perceived weaknesses and known bypass vectors in earlier versions. Additionally, PatchGuard 3 expands the set of kernel variables that are protected from unauthorized modification, eliminating several mechanisms that might be used to circumvent PatchGuard while co-existing (as opposed to disabling) it. This article describes some of the changes that have been made in PatchGuard 3. This article also proposes several new techniques that can be used to circumvent PatchGuard's defenses. Countermeasures for these techniques are also discussed.
		* [Subverting PatchGuard Version 2](http://uninformed.org/?v=all&a=28&t=sumry)
			* Windows Vista x64 and recently hotfixed versions of the Windows Server 2003 x64 kernel contain an updated version of Microsoft's kernel-mode patch prevention technology known as PatchGuard. This new version of PatchGuard improves on the previous version in several ways, primarily dealing with attempts to increase the difficulty of bypassing PatchGuard from the perspective of an independent software vendor (ISV) deploying a driver that patches the kernel. The feature-set of PatchGuard version 2 is otherwise quite similar to PatchGuard version 1; the SSDT, IDT/GDT, various MSRs, and several kernel global function pointer variables (as well as kernel code) are guarded against unauthorized modification. This paper proposes several methods that can be used to bypass PatchGuard version 2 completely. Potential solutions to these bypass techniques are also suggested. Additionally, this paper describes a mechanism by which PatchGuard version 2 can be subverted to run custom code in place of PatchGuard's system integrity checking code, all while leaving no traces of any kernel patching or custom kernel drivers loaded in the system after PatchGuard has been subverted. This is particularly interesting from the perspective of using PatchGuard's defenses to hide kernel mode code, a goal that is (in many respects) completely contrary to what PatchGuard is designed to do. 
		* [Bypassing PatchGuard on Windows x64](http://uninformed.org/?v=all&a=14&t=sumry)
			* The version of the Windows kernel that runs on the x64 platform has introduced a new feature, nicknamed PatchGuard, that is intended to prevent both malicious software and third-party vendors from modifying certain critical operating system structures. These structures include things like specific system images, the SSDT, the IDT, the GDT, and certain critical processor MSRs. This feature is intended to ensure kernel stability by preventing uncondoned behavior, such as hooking. However, it also has the side effect of preventing legitimate products from working properly. For that reason, this paper will serve as an in-depth analysis of PatchGuard's inner workings with an eye toward techniques that can be used to bypass it. Possible solutions will also be proposed for the bypass techniques that are suggested.
	* **Tools**
		* [Vulnserver](http://www.thegreycorner.com/2010/12/introducing-vulnserver.html)
			* 'I have just released a program named Vulnserver - a Windows based threaded TCP server application that is designed to be exploited.''
		* [Blackbone](https://github.com/DarthTon/Blackbone)
			* Windows memory hacking library
	* **Code Injection**
		* [Portable Executable Injection For Beginners](http://www.malwaretech.com/2013/11/portable-executable-injection-for.html)
	* **DLL**
		* [Windows DLL-Injection basics](http://blog.opensecurityresearch.com/2013/01/windows-dll-injection-basics.html)
		* [Example of a DLL Hijack Exploit - Winamp 5.581](https://www.exploit-db.com/exploits/14789/)
		* [Loading a DLL from memory](https://www.joachim-bauch.de/tutorials/loading-a-dll-from-memory/)
	* **<a name="winheap"></a>Windows Heap Exploitation**
		* [Reliable Windows Heap Exploits](http://xcon.xfocus.org/XCon2004/archives/14_Reliable%20Windows%20Heap%20Exploits_BY_SHOK.pdf)
			* [Windows 10 HAL’s Heap – Extinction of the "HalpInterruptController" Table Exploitation Technique  Another kernel exploitation technique killed in Windows 10 Creators Update](https://labs.bluefrostsecurity.de/blog/2017/05/11/windows-10-hals-heap-extinction-of-the-halpinterruptcontroller-table-exploitation-technique/)
		* [WinHeap-Explorer](https://github.com/WinHeapExplorer/WinHeap-Explorer)
			* The efficient and transparent proof-of-concept tool for heap-based bugs detection in x86 machine code for Windows applications.
		* [Advanced Windows Debugging: Memory Corruption Part II—Heaps](http://www.informit.com/articles/article.aspx?p=1081496)
			* Daniel Pravat and Mario Hewardt discuss security vulnerabilities and stability issues that can surface in an application when the heap is used in a nonconventional fashion.
	* **Windows Kernel Exploitation**
		* **Writeups**
			* [Windows Kernel Exploitation  101 : Exploiting CVE - 2014 - 4113](https://www.exploit-db.com/docs/39665.pdf)
			* [Intro to Windows kernel exploitation 1/N: Kernel Debugging](https://www.whitehatters.academy/intro-to-kernel-exploitation-part-1/)
			* [Intro to Windows kernel exploitation 2/N: HackSys Extremely Vulnerable Driver](https://www.whitehatters.academy/intro-to-windows-kernel-exploitation-2-windows-drivers/)
			* [I Know Where Your Page Lives: Derandomizing the latest Windows 10 Kernel - ZeroNights 2016](https://github.com/IOActive/I-know-where-your-page-lives)
			* [Sharks in the Pool :: Mixed Object Exploitation in the Windows Kernel PoolSharks in the Pool :: Mixed Object Exploitation in the Windows Kernel Pool](http://srcincite.io/blog/2017/09/06/sharks-in-the-pool-mixed-object-exploitation-in-the-windows-kernel-pool.html)
			* [Analysing the NULL SecurityDescriptor kernel exploitation mitigation in the latest Windows 10 v1607 Build 14393](https://labs.nettitude.com/blog/analysing-the-null-securitydescriptor-kernel-exploitation-mitigation-in-the-latest-windows-10-v1607-build-14393/)
			* [Abatchy - Windows Kernel Exploitation Series]()
				* [1: Setting up the environment](http://www.abatchy.com/2018/01/kernel-exploitation-1)
				* [2: Payloads](http://www.abatchy.com/2018/01/kernel-exploitation-2)
				* [3: Stack Buffer Overflow (Windows 7 x86/x64)](http://www.abatchy.com/2018/01/kernel-exploitation-3)
				* [4: Stack Buffer Overflow (SMEP Bypass)](http://www.abatchy.com/2018/01/kernel-exploitation-4)
				* [5: Integer Overflow](http://www.abatchy.com/2018/01/kernel-exploitation-5)
		* **Papers**
			* [Windows Kernel-mode Payload Fundamentals](http://uninformed.org/?v=all&a=15&t=sumry)
				* This paper discusses the theoretical and practical implementations of kernel-mode payloads on Windows. At the time of this writing, kernel-mode research is generally regarded as the realm of a few, but it is hoped that documents such as this one will encourage a thoughtful progression of the subject matter. To that point, this paper will describe some of the general techniques and algorithms that may be useful when implementing kernel-mode payloads. Furthermore, the anatomy of a kernel-mode payload will be broken down into four distinct units, known as payload components, and explained in detail. In the end, the reader should walk away with a concrete understanding of the way in which kernel-mode payloads operate on Windows. 
			* [A Window into Ring0 - Paper](https://labs.mwrinfosecurity.com/publications/a-window-into-ring0/)
				* With the rise of sandboxes and locked down user accounts attackers are increasingly resorting to attacking kernel mode code to gain full access to compromised systems. The talk provided an overview of the Windows kernel mode attack surface and how to interact with it. It then went on to cover the tools available for finding bugs in Windows kernel mode code and drivers as well as highlighting some of the lower hanging fruit, common mistakes and the steps being taken (or lack of steps being taken) to mitigate the risks posed. The talk also covered common exploitation techniques to gather information about the state of kernel mode memory and to gain code execution as SYSTEM. Finally the talk walked through exploiting CVE-2016-7255 on modern 64 bit versions of Windows.
		* **Talks**
			* [Securi-Tay 2017 - A Window into Ring0](https://www.youtube.com/watch?v=DLND8bKv27w)
				* With the rise of sandboxes and locked down user accounts attackers are increasingly resorting to attacking kernel mode code to gain full access to compromised systems. This talk aims to provide an overview of the Windows kernel mode attack surface and how to interact with it. This talk will demonstrate the tools available for finding bugs in Windows kernel mode code and drivers together with highlighting some of the lower hanging fruit, common mistakes and the steps being taken (or lack of steps being taken) to mitigate the risks posed. The talk will then cover common exploitation techniques to gather information about the state of kernel mode memory and to gain code execution as SYSTEM using examples from publicly known exploits.
		* **Tools**
			* [HackSys Extreme Vulnerable Driver](http://www.payatu.com/hacksys-extreme-vulnerable-driver/)
				* HackSys Extreme Vulnerable Driver is intentionally vulnerable Windows driver developed for security enthusiasts to learn and polish their exploitation skills at Kernel level.  
				* HackSys Extreme Vulnerable Driver caters wide range of vulnerabilities ranging from simple Buffer Overflows to complex Use After Frees and Pool Overflows. This allows the researchers to explore the exploitation techniques for all the implemented vulnerabilities.z6z
			* [Windows-driver-samples](https://github.com/Microsoft/Windows-driver-samples	)
				* This repo contains driver samples prepared for use with Microsoft Visual Studio and the Windows Driver Kit (WDK). It contains both Universal Windows Driver and desktop-only driver samples.
			* [DriverBuddy](https://github.com/nccgroup/DriverBuddy)
				* DriverBuddy is an IDA Python script to assist with the reverse engineering of Windows kernel drivers.
				* [Blog post](https://www.nccgroup.trust/uk/about-us/newsroom-and-events/blogs/2016/november/driverbuddy-tool-release/)
			* [win_driver_plugin](https://github.com/mwrlabs/win_driver_plugin)
				* A tool to help when dealing with Windows IOCTL codes or reversing Windows drivers.
			* [Write your first driver - docs ms](https://docs.microsoft.com/en-us/windows-hardware/drivers/gettingstarted/writing-your-first-driver)
	* **Patch Analysis**
		* [Microsoft Patch Analysis for Exploitation](https://www.irongeek.com/i.php?page=videos/bsidescharm2017/bsidescharm-2017-t111-microsoft-patch-analysis-for-exploitation-stephen-sims)
			* Since the early 2000's Microsoft has distributed patches on the second Tuesday of each month. Bad guys, good guys, and many in-between compare the newly released patches to the unpatched version of the files to identify the security fixes. Many organizations take weeks to patch and the faster someone can reverse engineer the patches and get a working exploit written, the more valuable it is as an attack vector. Analysis also allows a researcher to identify common ways that Microsoft fixes bugs which can be used to find 0-days. Microsoft has recently moved to mandatory cumulative patches which introduces complexity in extracting patches for analysis. Join me in this presentation while I demonstrate the analysis of various patches and exploits, as well as the best-known method for modern patch extraction.
		* [Microsoft Patch Analysis for Exploitation Stephen Sims](https://www.youtube.com/watch?v=LHNcBVQF1tM)
		* [The Wallstreet of Windows Binaries - Marion Marschalek, Joseph Moti](https://www.youtube.com/watch?v=8zlTv7fRjV8)
			* [Wallstreet - Github Repository](https://github.com/pinkflawd/Wallstreet)
			* Wallstreet of Windows binaries 7, 8, 9 err 10 sorry
		* [Microsoft Patch Analysis for Exploitation](https://www.irongeek.com/i.php?page=videos/bsidescharm2017/bsidescharm-2017-t111-microsoft-patch-analysis-for-exploitation-stephen-sims)
			* Since the early 2000's Microsoft has distributed patches on the second Tuesday of each month. Bad guys, good guys, and many in-between compare the newly released patches to the unpatched version of the files to identify the security fixes. Many organizations take weeks to patch and the faster someone can reverse engineer the patches and get a working exploit written, the more valuable it is as an attack vector. Analysis also allows a researcher to identify common ways that Microsoft fixes bugs which can be used to find 0-days. Microsoft has recently moved to mandatory cumulative patches which introduces complexity in extracting patches for analysis. Join me in this presentation while I demonstrate the analysis of various patches and exploits, as well as the best-known method for modern patch extraction.
	* **Papers**
		* [ActiveX - Active Exploitation](http://uninformed.org/?v=all&a=41&t=sumry)
			* This paper provides a general introduction to the topic of understanding security vulnerabilities that affect ActiveX controls. A brief description of how ActiveX controls are exposed to Internet Explorer is given along with an analysis of three example ActiveX vulnerabilities that have been previously disclosed.
		* [Exploiting the Otherwise Non-Exploitable on Windows](http://uninformed.org/?v=all&a=22&t=sumry)
			* This paper describes a technique that can be applied in certain situations to gain arbitrary code execution through software bugs that would not otherwise be exploitable, such as NULL pointer dereferences. To facilitate this, an attacker gains control of the top-level unhandled exception filter for a process in an indirect fashion. While there has been previous work illustrating the usefulness in gaining control of the top-level unhandled exception filter, Microsoft has taken steps in XPSP2 and beyond, such as function pointer encoding, to prevent attackers from being able to overwrite and control the unhandled exception filter directly. While this security enhancement is a marked improvement, it is still possible for an attacker to gain control of the top-level unhandled exception filter by taking advantage of a design flaw in the way unhandled exception filters are chained. This approach, however, is limited by an attacker's ability to control the chaining of unhandled exception filters, such as through the loading and unloading of DLLs. This does reduce the global impact of this approach; however, there are some interesting cases where it can be immediately applied, such as with Internet Explorer. 
* **Countermeasures**
	* [BuBBle: A Javascript Engine Level Countermeasure against Heap-Spraying Attacks](http://cd80.ca/files/bubble.pdf)
		* Abstract. Web browsers that support a safe language such as Javascript are becoming a platform of great interest for security attacks. One such attack is a heap-spraying attack: a new kind of attack that combines the notoriously hard to reliably exploit heap-based buffer overflow with the use of an in-browser script- ing language for improved r eliability. A typical heap-s praying attack allocates a high number of objects containing the attacker’s code on the heap, dramatically increasing the probability that the contents of one of these objects is executed. In this paper we present a lightweight approach that makes heap-spraying attacks in Javascript significantly harder. Our prototype, which is implemented in Firefox, has a negligible performance and memory overhead while effectively protecting against heap-spraying attacks.




------------
### Android
* [Android Security Ecosystem Investments Pay Dividends for Pixel](https://android-developers.googleblog.com/2018/01/android-security-ecosystem-investments.html)

------------
### <a name="antifuzz"></a>Anti-Debugging/Fuzzing
* [Intro to Anti-Fuzzing](https://www.nccgroup.com/en/blog/2014/01/introduction-to-anti-fuzzing-a-defence-in-depth-aid/()
* <a name="antidebug">Anti-Debugging</a>
	* [The Ultimate Anti-Debugging Reference(2011)](http://pferrie.host22.com/papers/antidebug.pdf)
		* Good reference, though old.
	* [Windows Anti-Debug Reference](http://www.symantec.com/connect/articles/windows-anti-debug-reference)
		* Good, but also old, Nov2010
	* [gargoyle, a memory scanning evasion technique](https://jlospinoso.github.io/security/assembly/c/cpp/developing/software/2017/03/04/gargoyle-memory-analysis-evasion.html)



### <a name="generaltools"></a>General Tools
Check out the 'Reverse Engineering" Section's Tools list for a lot of useful tools that aren't listed here.
* **General Tools**
	* [binwally](https://github.com/bmaia/binwally)
		* Binary and Directory tree comparison tool using the Fuzzy Hashing concept (ssdeep)
		* [Using Binwally](http://w00tsec.blogspot.com/2013/12/binwally-directory-tree-diff-tool-using.html)
	* [lisa.py](https://github.com/ant4g0nist/lisa.py)
		* An Exploit Dev Swiss Army Knife.
* **Hunting/Making Exploits Tools(DeBrujinn sequence)**
	* [Pattern-Create/offset as a python function](https://github.com/jbertman/pattern_create)
		* Metasploit pattern generator in Python, modified to be used as a function 
	* [!exploitable Crash Analyzer](https://msecdbg.codeplex.com/)
		* !exploitable (pronounced bang exploitable) is a Windows debugging extension (Windbg) that provides automated crash analysis and security risk assessment. The tool first creates hashes to determine the uniqueness of a crash and then assigns an exploitability rating to the crash: Exploitable, Probably Exploitable, Probably Not Exploitable, or Unknown. There is more detailed information about the tool in the following .pptx file or at http://www.microsoft.com/security/msec. Additonally, see the [blog post](http://blogs.technet.com/srd/archive/2009/04/08/the-history-of-the-exploitable-crash-analyzer.aspx), or [watch the video](http://channel9.msdn.com/posts/PDCNews/Bang-Exploitable-Security-Analyzer/).
	* [Findjmp2](http://www.securiteam.com/tools/5LP0C1PEUY.html)
		* Findjmp2 is a modified version of Findjmp from eEye.com to find jmp, call, push in a loaded DLL. This version includes search for pop/pop/ret set of instructions that is useful to bypass Windows XP SP2 and Windows 2003 stack protection mechanism.
	* [binjitsu](https://github.com/binjitsu/binjitsu/)
		* binjitsu is a CTF framework and exploit development library. Written in Python, it is designed for rapid prototyping and development, and intended to make exploit writing as simple as possible.
* **Shellcode Tools**
	* [rp++](https://github.com/0vercl0k/rp)
		* rp++ is a full-cpp written tool that aims to find ROP sequences in PE/Elf/Mach-O (doesn't support the FAT binaries) x86/x64 binaries. It is open-source, documented with Doxygen (well, I'm trying to..) and has been tested on several OS: Debian / Windows 7 / FreeBSD / Mac OSX Lion (10.7.3). Moreover, it is x64 compatible. I almost forgot, it handles both Intel and AT&T syntax (beloved BeaEngine). By the way, the tool is a standalone executable ; I will upload static-compiled binaries for each OS.




-----------------------
### <a name="decomp">Decompilers & Disassemblers</a>
* **List**
	* [Bokken](https://inguma.eu/projects/bokken)
		* Bokken is a GUI for the Pyew and Radare projects so it offers almost all the same features that Pyew has and and some of the Radare's ones. It's intended to be a basic disassembler, mainly, to analyze malware and vulnerabilities.  Currently Bokken is neither an hexadecimal editor nor a full featured disassembler YET, so it should not be used for deep code analysis or to try to modify files with it.
	* [IDA](https://www.hex-rays.com/products/ida/)
		* IDA Pro combines an interactive, programmable, multi-processor disassembler coupled to a local and remote debugger and augmented by a complete plugin programming environment.
		* [Overview & Tutorials](https://www.hex-rays.com/products/ida/debugger/index.shtml)
		* Ida Plugins
			* [Ida Sploiter](https://thesprawl.org/projects/ida-sploiter/)
				* IDA Sploiter is a plugin for Hex-Ray's IDA Pro disassembler designed to enhance IDA's capabilities as an exploit development and vulnerability research tool. Some of the plugin's features include a powerful ROP gadgets search engine, semantic gadget analysis and filtering, interactive ROP chain builder, stack pivot analysis, writable function pointer search, cyclic memory pattern generation and offset analysis, detection of bad characters and memory holes, and many others.
			* [Ida Pomidor](https://thesprawl.org/projects/ida-pomidor/)
				* IDA Pomidor is a fun and simple plugin for the Hex-Ray's IDA Pro disassembler that will help you retain concentration and productivity during long reversing sessions. 
			* [FLARE-Ida](https://github.com/fireeye/flare-ida)
				* This repository contains a collection of IDA Pro scripts and plugins used by the FireEye Labs Advanced Reverse Engineering (FLARE) team.
	* [Hopper](http://www.hopperapp.com/)
		* Hopper is a reverse engineering tool for OS X and Linux, that lets you disassemble, decompile and debug your 32/64bits Intel Mac, Linux, Windows and iOS executables!
	* [Reverse](https://github.com/joelpx/reverse)
		* Reverse engineering for x86 binaries (elf-format). Generate a more readable code (pseudo-C) with colored syntax. Warning, the project is still in development, use it at your own risks. This tool will try to disassemble one function (by default main). The address of the function, or its symbol, can be passed by argument.
	* [fREedom - capstone based disassembler for extracting to binnavi](https://github.com/cseagle/fREedom)
	* fREedom is a primitive attempt to provide an IDA Pro independent means of extracting disassembly information from executables for use with binnavi (https://github.com/google/binnavi).
		* [Setting up fREedom and BinNavi](https://summitroute.com/blog/2015/12/31/setting_up_freedom_and_binnavi/)
	* [BinNavi](https://github.com/google/binnavi)
		* BinNavi is a binary analysis IDE that allows to inspect, navigate, edit and annotate control flow graphs and call graphs of disassembled code.



---------
### <a name="debug">Debuggers</a>
* **General/Platform Neutral**
	* [The Secret Lives of Debuggers - Lance Buttars - BSides SLC15](https://www.youtube.com/watch?v=V8trrmIsdb0)
		* Binaries are files like any text file or a bitmap. They can be modified and changed.With some basic understanding of assembly language anyone can take a binary and modify its execution in a debugger and using a hex editor change how it executes. In this presentation I will cover the basics of binary manipulation and the use of debuggers to change program execution.
	* [HyperDbg](https://github.com/rmusser01/hyperdbg/)
		* HyperDbg is a kernel debugger that leverages hardware-assisted virtualization. More precisely, HyperDbg is based on a minimalistic hypervisor that is installed while the system runs. Compared to traditional kernel debuggers (e.g., WinDbg, SoftIce, Rasta R0 Debugger) HyperDbg is completely transparent to the kernel and can be used to debug kernel code without the need of serial (or USB) cables. For example, HyperDbg allows to single step the execution of the kernel, even when the kernel is executing exception and interrupt handlers. Compared to traditional virtual machine based debuggers (e.g., the VMware builtin debugger), HyperDbg does not require the kernel to be run as a guest of a virtual machine, although it is as powerful. 
		* [Paper](http://roberto.greyhats.it/pubs/ase10.pdf)
	* [scdbg](http://sandsprite.com/blogs/index.php?uid=7&pid=152)
		* scdbg is an open source, multi-platform, shellcode analysis application that runs shellcode through a virtual machine that emulates a 32bit processor, memory, and basic Windows API environment. scdbg uses the libemu library to provide this environment. Builds of scdbg exist for both Windows and Unix users. 
	* [scdbg Manual](http://sandsprite.com/CodeStuff/scdbg_manual/MANUAL_EN.html)
	* [xnippet](https://github.com/isislab/xnippet)
		* xnippet is a tool that lets you load code snippets or isolated functions (no matter the operating system they came from), pass parameters to it in several formats (signed decimal, string, unsigned hexadecimal...), hook other functions called by the snippet and analyze the result. The tool is written in a way that will let me improve it in a future, defining new calling conventions and output argument pointers.
	* [voltron](https://github.com/snare/voltron)
		* Voltron is an extensible debugger UI toolkit written in Python. It aims to improve the user experience of various debuggers (LLDB, GDB, VDB and WinDbg) by enabling the attachment of utility views that can retrieve and display data from the debugger host. By running these views in other TTYs, you can build a customised debugger user interface to suit your needs.
* **Linux**
	* [GDB - GNU Debugger](https://www.gnu.org/software/gdb/)
			* GDB, the GNU Project debugger, allows you to see what is going on 'inside' another program while it executes -- or what another program was doing at the moment it crashed.
			* [GDB 'exploitable' plugin](https://github.com/jfoote/exploitable)
				* 'exploitable' is a GDB extension that classifies Linux application bugs by severity. The extension inspects the state of a Linux application that has crashed and outputs a summary of how difficult it might be for an attacker to exploit the underlying software bug to gain control of the system. The extension can be used to prioritize bugs for software developers so that they can address the most severe ones first. The extension implements a GDB command called 'exploitable'. The command uses heuristics to describe the exploitability of the state of the application that is currently being debugged in GDB. The command is designed to be used on Linux platforms and versions of GDB that include the GDB Python API. Note that the command will not operate correctly on core file targets at this time.
	* [PEDA](https://github.com/longld/peda)
		* PEDA - Python Exploit Development Assistance for GDB 
	* [radare2 as an alternative to gdb-peda](https://monosource.github.io/2016/10/radare2-peda)
	* [pwndbg - Making debugging suck less](https://github.com/zachriggle/pwndbg)
		* A PEDA replacement. In the spirit of our good friend windbg, pwndbg is pronounced pwnd-bag.
		* Uses capstone as backend.
	* [gdbgui](https://github.com/cs01/gdbgui)
		* A modern, browser-based frontend to gdb (gnu debugger). Add breakpoints, view stack traces, and more in C, C++, Go, and Rust. Simply run gdbgui from the terminal and a new tab will open in your browser.
	* [GEF - GDB Enhanced Features](https://github.com/hugsy/gef)
		* GEF is aimed to be used mostly by exploiters and reverse-engineers. It provides additional features to GDB using the Python API to assist during the process of dynamic analysis or exploit development.
		* Why not PEDA?
		* Yes!! Why not?! PEDA is a fantastic tool to do the same, but is only to be used for x86-32 or x86-64. On the other hand, GEF supports all the architecture supported by GDB (x86, ARM, MIPS, PowerPC, SPARC, and so on).
		* [Docs](https://gef.readthedocs.org/en/latest/)
* **Windows**
	* [An Introduction to Debugging the Windows Kernel with WinDbg](http://www.contextis.com/resources/blog/introduction-debugging-windows-kernel-windbg/)
	* [Getting Started with WinDbg part 1](http://blog.opensecurityresearch.com/2013/12/getting-started-with-windbg-part-1.html)
	* [OllyDbg](http://www.ollydbg.de/)
		* OllyDbg is a 32-bit assembler level analysing debugger for Microsoft® Windows®. Emphasis on binary code analysis makes it particularly useful in cases where source is unavailable.
		* [OllyDbg Tricks for Exploit Development](http://resources.infosecinstitute.com/in-depth-seh-exploit-writing-tutorial-using-ollydbg/)
	* [WinDbg](https://msdn.microsoft.com/en-us/library/windows/hardware/ff551063%28v=vs.85%29.aspx)
		* [Excellent Resource Site](http://www.windbg.org/)
		* [Crash Dump Analysis Poster](http://www.dumpanalysis.org/CDAPoster.html)
		* [Getting Started with WinDbg (User-Mode)](https://msdn.microsoft.com/en-us/library/windows/hardware/dn745911%28v=vs.85%29.aspx)
		* [Getting Started with WinDbg (Kernel-Mode)](https://msdn.microsoft.com/en-us/library/windows/hardware/dn745912%28v=vs.85%29.aspx)
	* [TWindbg](https://github.com/bruce30262/TWindbg)
		* PEDA-like debugger UI for WinDbg
	* [WinAppDbg](http://winappdbg.sourceforge.net/)
		* The WinAppDbg python module allows developers to quickly code instrumentation scripts in Python under a Windows environment. It uses ctypes to wrap many Win32 API calls related to debugging, and provides a powerful abstraction layer to manipulate threads, libraries and processes, attach your script as a debugger, trace execution, hook API calls, handle events in your debugee and set breakpoints of different kinds (code, hardware and memory). Additionally it has no native code at all, making it easier to maintain or modify than other debuggers on Windows. The intended audience are QA engineers and software security auditors wishing to test or fuzz Windows applications with quickly coded Python scripts. Several ready to use tools are shipped and can be used for this purposes. Current features also include disassembling x86/x64 native code, debugging multiple processes simultaneously and produce a detailed log of application crashes, useful for fuzzing and automated testing.
	* [x64dbg](http://x64dbg.com/)
		* [An introduction to x64dbg](http://reverseengineeringtips.blogspot.com/2015/01/an-introduction-to-x64dbg.html)


----------------
### <a name="collection"></a>Exploit Collections/Repository
* **Exploit Collections**
	* [XiphosResearch PoC Exploits](https://github.com/XiphosResearch/exploits)
		* Miscellaneous proof of concept exploit code written at Xiphos Research for testing purposes.
	* [exploit-db.org](https://www.exploit-db.org)
	* [All AIX exploits written by Hector Monsegur](https://github.com/RhinoSecurityLabs/Security-Research/tree/master/exploits/IBM)
	* [The Exploit Database Git Repository](https://github.com/offensive-security/exploit-database)
		* The official Exploit Database repository
* **PoC Collections**
	* [PoC for CVE-2018-0802 And CVE-2017-11882](https://github.com/Ridter/RTF_11882_0802)
	* [MS17-010 worawit](https://github.com/worawit/MS17-010)
	* [explodingcan](https://github.com/danigargu/explodingcan)
		* An implementation of NSA's ExplodingCan exploit in Python
	* [CVE-2017-10271 identification and exploitation. Unauthenticated Weblogic RCE.](https://github.com/c0mmand3rOpSec/CVE-2017-10271)
	* [Chimay-Red](https://github.com/BigNerd95/Chimay-Red)
		* Working POC of Mikrotik exploit from Vault 7 CIA Leaks
		* [Writeup](https://github.com/BigNerd95/Chimay-Red/blob/master/docs/ChimayRed.pdf)
	* [Proof of concept exploits / tools for Epson vulnerabilities: CVE-2017-12860 and CVE-2017-12861](https://github.com/RhinoSecurityLabs/Security-Research/tree/master/exploits/Epson)
	* [Exploits for Unitrends version 9.1.1 and earlier ; all by Dwight Hohnstein](https://github.com/RhinoSecurityLabs/Security-Research/tree/master/exploits/Unitrends)
	* [CVE-2017-10271](https://github.com/kkirsche/CVE-2017-10271)
		* Oracle WebLogic WLS-WSAT Remote Code Execution Exploit (CVE-2017-10271)
	* [CVE-2018-0802](https://github.com/rxwx/CVE-2018-0802)
		* This repo contains a Proof of Concept exploit for CVE-2018-0802. To get round the limited command length allowed, the exploit uses the Packager OLE object to drop an embedded payload into the %TMP% directory, and then executes the file using a short command via a WinExec call, such as: cmd.exe /c%TMP%\file.exe.
	* [Epson Vulnerability: EasyMP Projector Takeover (CVE-2017-12860 / CVE-2017-12861)](https://rhinosecuritylabs.com/research/epson-easymp-remote-projection-vulnerabilities/)
	* [Code Execution (CVE-2018-5189) Walkthrough On JUNGO Windriver 12.5.1](https://www.fidusinfosec.com/jungo-windriver-code-execution-cve-2018-5189)












----------------
### <a name="gpu"></a>GPU Exploits / Research
* [A Study of Overflow Vulnerabilities on GPUs](https://www.aimlab.org/haochen/papers/npc16-overflow.pdf)
* [Jellyfish - GPU rootkit PoC by Team Jellyfish ](https://github.com/x0r1/jellyfish)
	* Jellyfish is a Linux based userland gpu rootkit proof of concept project utilizing the LD_PRELOAD technique from Jynx (CPU), as well as the OpenCL API developed by Khronos group (GPU). Code currently supports AMD and NVIDIA graphics cards. However, the AMDAPPSDK does support Intel as well. 





### Temporal Return Address
* [Temporal Return Addresses](http://uninformed.org/?v=all&a=9&t=sumry)
	* Nearly all existing exploitation vectors depend on some knowledge of a process' address space prior to an attack in order to gain meaningful control of execution flow. In cases where this is necessary, exploit authors generally make use of static addresses that may or may not be portable between various operating system and application revisions. This fact can make exploits unreliable depending on how well researched the static addresses were at the time that the exploit was implemented. In some cases, though, it may be possible to predict and make use of certain addresses in memory that do not have static contents. This document introduces the concept of temporal addresses and describes how they can be used, under certain circumstances, to make exploitation more reliable. 
* [Automating Mimicry Attacks Using Static Binary Analysis](https://www.usenix.org/legacy/events/sec05/tech/full_papers/kruegel/kruegel_html/attack.html)
	* Intrusion detection systems that monitor sequences of system calls have recently become more sophisticated in defining legitimate application behavior. In particular, additional information, such as the value of the program counter and the configuration of the program's call stack at each system call, has been used to achieve better characterization of program behavior. While there is common agreement that this additional information complicates the task for the attacker, it is less clear to which extent an intruder is constrained.  In this paper, we present a novel technique to evade the extended detection features of state-of-the-art intrusion detection systems and reduce the task of the intruder to a traditional mimicry attack. Given a legitimate sequence of system calls, our technique allows the attacker to execute each system call in the correct execution context by obtaining and relinquishing the control of the application's execution flow through manipulation of code pointers.  We have developed a static analysis tool for Intel x86 binaries that uses symbolic execution to automatically identify instructions that can be used to redirect control flow and to compute the necessary modifications to the environment of the process. We used our tool to successfully exploit three vulnerable programs and evade detection by existing state-of-the-art system call monitors. In addition, we analyzed three real-world applications to verify the general applicability of our techniques. 
* [Anti-Virus Software Gone Wrong](http://uninformed.org/?v=all&a=21&t=sumry)
	* Anti-virus software is becoming more and more prevalent on end-user computers today. Many major computer vendors (such as Dell) bundle anti-virus software and other personal security suites in the default configuration of newly-sold computer systems. As a result, it is becoming increasingly important that anti-virus software be well-designed, secure by default, and interoperable with third-party applications. Software that is installed and running by default constitutes a prime target for attack and, as such, it is especially important that said software be designed with security and interoperability in mind. In particular, this article provides examples of issues found in well-known anti-virus products. These issues range from not properly validating input from an untrusted source (especially within the context of a kernel driver) to failing to conform to API contracts when hooking or implementing an intermediary between applications and the underlying APIs upon which they rely. For popular software, or software that is installed by default, errors of this sort can become a serious problem to both system stability and security. Beyond that, it can impact the ability of independent software vendors to deploy functioning software on end-user systems. 
* [Sigreturn Oriented Programming is a real Threat](https://subs.emis.de/LNI/Proceedings/Proceedings259/2077.pdf)
	* Abstract: This paper shows that Sigreturn Oriented Programming (SROP), which consists of using calls to sigreturn to execute arbitrary code, is a pow erful method for the de velopment of exploits. This is demonstrated by developing two different kinds of SROP based exploits, one asterisk exploit which was already portrayed in the paper presenting SROP, and one novel exploit for a recently disclosed bug inthe DNS address resolution of the default GNUC library. Taking advantage of the fact, that these exploits have very few dependencies on the program being exploited, a library is implemented to automate wide parts of SROP exploit creation. This highlights the potential of SROP in respect to reusable and portable exploit code which strongly supports the conclusion of the original paper: SROP is areal threat!
* [Breaking the links: Exploiting the linker](https://www.nth-dimension.org.uk/pub/BTL.pdf)
* [nt!`_SEP_`TOKEN_PRIVILEGES - Single Write EoP Protect - Kyriakos 'kyREcon' Economou](http://anti-reversing.com/Downloads/Sec_Research/ntoskrnl_v10.0.15063_nt!_SEP_TOKEN_PRIVILEGES-Single_Write_EoP_Protect.pdf)
	* TL;DR: Abusing enabled token privileges through a kernel exploit to gain EoP it won't be enough anymore as from NT kernel version 10.0.15063 are 'checked' against the privileges present in the token of the calling process. So you will need two writes



#### Writeups that haven't been sorted
* [Fun with info leaks](https://rh0dev.github.io/blog/2015/fun-with-info-leaks/)
* [Linux Kernel < 2.6.36.2 Econet Privilege Escalation Exploit](http://eshunrd.blogspot.com/2011/09/linux-kernel-26362-econet-privilege.html)
* [Coding Malware for Fun and Not for Profit (Because that would be illegal)](http://www.malwaretech.com/2014/04/coding-malware-for-fun-and-not-for.html)
* [Exploiting BadIRET vulnerability - CVE-2014-9322, Linux kernel privilege escalation](http://labs.bromium.com/2015/02/02/exploiting-badiret-vulnerability-cve-2014-9322-linux-kernel-privilege-escalation/)
* [A Technical Analysis of CVE 2014-1776](http://blog.fortinet.com/post/a-technical-analysis-of-cve-2014-1776)
* [Diving into A Silverlight Exploit and Shellcode - Analysis and Techniques](http://www.checkpoint.com/downloads/partners/TCC-Silverlight-Jan2015.pdf)
* Abstract: We will observe how the exploit is obfuscated; how it loads parts of the code dynamically into the memory in order to reduce the chances of being detected by signature based protections and how to extract these components from the exploit. In addition we will look at the shell-code supplied by the exploit-kit and how it uses encryption to hide the payload's URL and contents.
* [Owning Internet Printing - A Case Study in Modern Software Exploitation](https://googleprojectzero.blogspot.com/2015/06/owning-internet-printing-case-study-in.html?m=1)
* [The Chakra Exploit and the Limitations of Modern Mitigation Techniques](https://www.endgame.com/blog/chakra-exploit-and-limitations-modern-mitigation-techniques)
* [EnglishmansDentist Exploit Analysis](https://blogs.technet.microsoft.com/srd/2017/07/20/englishmansdentist-exploit-analysis/)
* [Dangerous Clipboard: Analysis of the MS15-072 Patch](http://blog.talosintel.com/2015/10/dangerous-clipboard.html?m=1)
* [MS16-039 - "Windows 10" 64 bits Integer Overflow exploitation by using GDI objects](https://www.coresecurity.com/blog/ms16-039-windows-10-64-bits-integer-overflow-exploitation-by-using-gdi-objects)
* [The Weak Bug - Exploiting a Heap Overflow in VMware](http://acez.re/the-weak-bug-exploiting-a-heap-overflow-in-vmware/)
* [MS17-010](https://github.com/worawit/MS17-010)
* [CVE-2016-7255 - Git repo](https://github.com/mwrlabs/CVE-2016-7255)
* [Hijacking Arbitrary .NET Application Control Flow](https://www.tophertimzen.com/resources/grayStorm/HijackingArbitraryDotnetApplicationControlFlow.pdf)
	* This paper describes the use of Reflection in .NET and how it can be utilized to change the control flow of an arbitrary application at runtime. A tool, Gray Storm, will be introduced that can be injected into an AppDomain and used to control the executing assembly instructions after just-in-time compilation.
* [Dissecting Veil-Evasion Powershell Payloads and Converting to a Bind Shell](http://threat.tevora.com/dissecting-veil-evasion-powershell-payloads-and-converting-to-a-bind-shell/)
* **iOS**
	* [The Userland Exploits of Pangu 8](http://blog.pangu.io/wp-content/uploads/2015/03/CanSecWest2015_Final.pdf)
* **MIPS**
	* [EXPLOITING  BUFFER  OVERFLOWS ON  MIPS ARCHITECTURE](https://www.exploit-db.com/docs/39658.pdf)
* [Smashing the Heap with Vector: Advanced Exploitation Technique in Recent Flash Zero-day Attack](https://0b3dcaf9-a-62cb3a1a-s-sites.googlegroups.com/site/zerodayresearch/smashing_the_heap_with_vector_Li.pdf)
* [Exploiting CVE-2014-4113 on Win8.1](http://www.jodeit.org/research/Exploiting_CVE-2014-4113_on_Windows_8.1.pdf) 
* [Debugging Windows kernel under VMWare using IDA's GDB debugger](https://cyberview.files.wordpress.com/2010/09/gdb_vmware_winkernel.pdf)
* [Hello MS08-067, My Old Friend!](https://labs.mwrinfosecurity.com/assets/BlogFiles/hello-ms08-067-my-old-friend.pdf)
* [The Birth of a Complete IE11 Exploit Under the New Exploit Mitigations](https://www.syscan.org/index.php/download/get/aef11ba81927bf9aa02530bab85e303a/SyScan15%20Yuki%20Chen%20-%20The%20Birth%20of%20a%20Complete%20IE11%20Exploit%20Under%20the%20New%20Exploit%20Mitigations.pdf)
* [Modern Objective-C Exploitation Techniques](http://www.phrack.com/papers/modern_objc_exploitation.html)
* [A New CVE-2015-0057 Exploit Technology](https://www.exploit-db.com/docs/39660.pdf)
* [PLASMA PULSAR](https://github.com/stealth/plasmapulsar/blob/master/README.md)
	* This document describes a generic root exploit against kde.
* **ROP**
* stuff
		* [ROPs are for the 99% - Yang Yu](https://cansecwest.com/slides/2014/ROPs_are_for_the_99_CanSecWest_2014.pdf)
		* [OptiROP: The art of hunting ROP gadgets](https://media.blackhat.com/us-13/US-13-Quynh-OptiROP-Hunting-for-ROP-Gadgets-in-Style-WP.pdf)
			* [Video](https://www.youtube.com/watch?v=_3uBybBpq48)
			* This research attempts to solve the problem by introducing a tool named OptiROP that lets exploitation writers search for ROP gadgets with semantic queries. Combining sophisticated techniques such as code normalization, code optimization, code slicing, SMT solver and some creative heuristic searching methods, OptiROP is able to discover desired gadgets very quickly, with much less efforts. Our tool also provides the detail semantic meaning of each gadget found, so users can easily decide how to chain their gadgets for the final shellcode.
	* **Tools**
		* [ropa](https://github.com/orppra/ropa)
			* ropa is a Ropper-based GUI that streamlines crafting ROP chains. It provides a cleaner interface when using Ropper as compared to the command line. It can provide a smoother workflow for crafting the rop chain in the GUI, then exporting the final chain in the desired format. For those used to using CLI, this tool may serve as a cleaner interface to filter out the relevant gadgets.
		* [Ropper](https://github.com/sashs/ropper)
			* You can use ropper to display information about binary files in different file formats and you can search for gadgets to build rop chains for different architectures (x86/X86_64, ARM/ARM64, MIPS/MIPS64, PowerPC). For disassembly ropper uses the awesome Capstone Framework.
* **UAF**
	* [Exploiting CVE-2015-0311: A Use-After-Free in Adobe Flash Player](http://blog.coresecurity.com/2015/03/04/exploiting-cve-2015-0311-a-use-after-free-in-adobe-flash-player/)
		* "The vulnerability was first discovered as a zero-day being actively exploited in the wild as part of the Angler Exploit Kit. Although the exploit code was highly obfuscated using the SecureSWF obfuscation tool, malware samples taking advantage of this vulnerability became publicly available, so I decided to dig into the underlying vulnerability in order to exploit it and write the corresponding module for Core Impact Pro and Core Insight."
	* [ Use-After-Silence: Exploiting a quietly patched UAF in VMware - Abdul-Aziz Hariri](https://www.thezdi.com/blog/2017/6/26/use-after-silence-exploiting-a-quietly-patched-uaf-in-vmware)
* **Extended: \*alloc/Heap**
	* [shadow :: De Mysteriis Dom jemalloc](https://github.com/CENSUS/shadow)
		* shadow is a jemalloc heap exploitation framework. It has been designed to be agnostic of the target application that uses jemalloc as its heap allocator (be it Android's libc, Firefox, FreeBSD's libc, standalone jemalloc, or whatever else). The current version (2.0) has been tested extensively with the following targets: Android 6 and 7 libc (ARM32 and ARM64); Firefox (x86 and x86-64) on Windows and Linux;
	* [Overview of Android's jemalloc structures using shadow](https://github.com/CENSUS/shadow/blob/master/docs/android_heap.md)
		* In this document we explore Android's jemalloc structures using shadow. A simplified view of the heap is presented here. The intention of this document is to get you started with jemalloc structures and shadow's commands.
	* [MALLOC DES-MALEFICARUM - blackngel](http://phrack.org/issues/66/10.html)
	* Understanding the Heap - Sploitfun
		* [Syscalls used by malloc](https://sploitfun.wordpress.com/2015/02/11/syscalls-used-by-malloc/)
		* [Understanding glibc malloc](https://sploitfun.wordpress.com/2015/02/10/understanding-glibc-malloc/)
		* [Understanding the heap by breaking it](https://www.blackhat.com/presentations/bh-usa-07/Ferguson/Whitepaper/bh-usa-07-ferguson-WP.pdf)
	* [Automated vulnerability analysis  of zero sized heap allocations](http://www.hackitoergosum.org/2010/HES2010-jvanegue-Zero-Allocations.pdf)
	* [Tracking Down Heap Overflows with rr](https://sean.heelan.io/2016/05/31/tracking-down-heap-overflows-with-rr/)
	* [Walking Heap using Pydbg](http://www.debasish.in/2015/02/walking-heap-using-pydbg.html)
		* This is the simplest implementation of HeapWalk() API based on pydbg. Heap walk API enumerates the memory blocks in the specified heap. If you are not very familiar with HeapWalk() API this page has a very good example in C++.
	* [Linux Heap Exploitation Intro Series – (BONUS) printf might be leaking!](https://sensepost.com/blog/2018/linux-heap-exploitation-intro-series-bonus-printf-might-be-leaking/)
	* [Linux Heap Exploitation Intro Series: Riding free on the heap – Double free attacks!](https://sensepost.com/blog/2017/linux-heap-exploitation-intro-series-riding-free-on-the-heap-double-free-attacks/)







----------------
### <a name="attackingav"></a>Attacking AntiVirus
* [Kaspersky Hooking Engine Analysis](https://quequero.org/2014/10/kaspersky-hooking-engine-analysis/)
* [AV_Kernel_Vulns](https://github.com/bee13oy/AV_Kernel_Vulns)
	* Pocs for Antivirus Software‘s Kernel Vulnerabilities




----------------
### <a name="bughunt">Finding Vulnerabilities</a>
* Look at fuzzing section.
* [Winmerge](http://winmerge.org/)
	* WinMerge is an Open Source differencing and merging tool for Windows. WinMerge can compare both folders and files, presenting differences in a visual text format that is easy to understand and handle.
* [Analyzing Common Binary Parser Mistakes](http://uninformed.org/?v=all&a=12&t=sumry)
	* With just about one file format bug being consistently released on a weekly basis over the past six to twelve months, one can only hope developers would look and learn. The reality of it all is unfortunate; no one cares enough. These bugs have been around for some time now, but have only recently gained media attention due to the large number of vulnerabilities being released. Researchers have been finding more elaborate and passive attack vectors for these bugs, some of which can even leverage a remote compromise. 

#### Finding and analyzing Crash dumps
* [All the Ways to Capture a Crash Dump](http://blogs.msdn.com/b/pfedev/archive/2008/09/26/all-the-ways-to-capture-a-dump.aspx)
* [Basic Debugging of an Application Crash](http://blogs.technet.com/b/askperf/archive/2007/05/29/basic-debugging-of-an-application-crash.aspx)
* [Collecting User Mode Dumps](https://msdn.microsoft.com/en-us/library/windows/desktop/bb787181(v=vs.85).aspx)



#### High Level Searching
##### Searching Github for vulnerable code/credentials
* [Blogpost](http://blog.conviso.com.br/2013/06/github-hacking-for-fun-and-sensitive.html)
* [Code - Automated Tool](https://github.com/convisoappsec/research_github_hack/blob/master/github_hack.pl)
* [Cheatsheet](https://github.com/search#search_cheatsheet_pane)
* [Actual Search Page](https://github.com/search)


















-------------
### <a name="practice"></a>Exploit Development Practice Lab Setup
Building a Lab to practice Exploit writing(Windows, x86, OSCE Prep)

So, this is a thing I found while doing some googling. If you wrote this, I owe you a lot of beer. I redacted the place/username as it was on a less than happy place.
```
|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
This assumes you have an idea of ASM x86 and general exploitation methods.

Idea with this setup, is that you have a VM of XP SP3 running with the following software and tools installed. You look up the exploits on exploit-db and recreate them. Or you lookup the vulnerabilities and fuzz it yourself knowing where to look.

 
Start here:
I'm designing exploit lab based on WinXP SP3. As for now I have following vulnerabilities/apps:

1. Simple RET - Ability FTP Server (FTP)
2. Simple RET - FreeFloat FTP (FTP)
3. Simple RET (harder) - CesarFTP (FTP)
4. Simple RET - Easy RM to MP3 Converter (.pls)
5. Simple RET - DL-10 - Need to find copy of
6. SEH - DVDXPlayer
7. SEH - Millenium
8. SEH - Soritong
9. SEH - mp3nator
10. SEH - NNM (hard) - Need to find copy of
11. SEH + UNICODE - ALLPlayer
12. SEH (difficult) - Winamp

with following tools installed:

1. WinDBG + MSEC.dll (!load winext\msec.dll) + byakugan (!load byakugan)
2. Immunity Debugger + mona.py (!mona)
3. OllyDBG+Plugins(SSEH+OllySnake+AdvancedOlly+OllyHeapVis+Virtual2Physical)
4. C:\Windows\system32\findjmp2.exe
5. Cygwin + perl + gdb + gcc...
6. Python26 (for IDA) + PyDbg - https://code.google.com/p/pydbgr/wiki/HowToInstall
6. Python27 (for ImmunityDebugger)+pyDbg
7. lcc-win
8. Wireshark
9. Mantra on Chrome (MoC)
10. Google-Chrome
11. Microsoft Visual C++ 2008 Express
12. Nasm
13. metasploit
14. Alpha3 (c:\Alpha3)
15. IDA
16. Sysinternals (c:\Windows\System32)
17. Proxifier Edition
18. Echo Mirage

```
#### Sort:

* [heapwn](https://github.com/str8outtaheap/heapwn)
	* Heap exploitation is a dark art to me. This repo is an attempt to document my findings/notes on the heap pwnables I deal with while learning heap's internals (Linux specific). - str8outtaheap
https://github.com/Microsoft/MSRC-Security-Research/tree/master/presentations
https://cseweb.ucsd.edu/~hovav/dist/sparc.pdf
* [Machine Motivated Practical Page Table Shellcode & Finding Out What's Running on Your System - Slides](https://www.defcon.org/images/defcon-22/dc-22-presentations/Macaulay/DEFCON-22-Shane-Macaulay-Weird-Machine-Motivated-Practical-Page-Table-Shellcode-UPDATED.pdf)
* [Counterfeit Object-oriented Programming](http://syssec.rub.de/media/emma/veroeffentlichungen/2015/03/28/COOP-Oakland15.pdf)
* [Modern Binary Attacks and Defences in the  Windows Environment: Fighting Against Microsoft EMET in Seven Rounds]()
* [ADI vs ROP](https://lazytyped.blogspot.it/2017/09/adi-vs-rop.html)
* [Low Level Exploits - hugh pearse](https://dl.packetstormsecurity.net/papers/presentations/Low-Level-Exploits.pdf)
* [credssp](https://github.com/preempt/credssp)
	* This is a poc code for exploiting CVE-2018-0886. 
https://github.com/secretsquirrel/fido
* [Dark Compsition kernel exploitation Case Study ---- Integer Overflow](https://whereisk0shl.top/post/2018-01-17)
	* [Code](https://github.com/k0keoyo/Dark_Composition_case_study_Integer_Overflow)
* [Obfuscated String/Shellcode Generator - Online Tool - zerosum0x0](https://zerosum0x0.blogspot.com/2017/08/obfuscatedencrypted-cc-online-string.html?m=1)
* [PSKernel-Primitives](https://github.com/FuzzySecurity/PSKernel-Primitives)
	* Exploit primitives for PowerShell
* [Protectors](https://github.com/rootm0s/Protectors)
	* Obfuscator, Encryption, Junkcode, Anti-Debug, PE protection/modification
* [When "ASLR" Is Not Really ASLR - The Case of Incorrect Assumptions and Bad Defaults - cmu](https://insights.sei.cmu.edu/cert/2018/08/when-aslr-is-not-really-aslr---the-case-of-incorrect-assumptions-and-bad-defaults.html)

* [Implementing a Custom X86 Encoder](http://uninformed.org/?v=all&a=25&t=sumry)
	* This paper describes the process of implementing a custom encoder for the x86 architecture. To help set the stage, the McAfee Subscription Manager ActiveX control vulnerability, which was discovered by eEye, will be used as an example of a vulnerability that requires the implementation of a custom encoder. In particular, this vulnerability does not permit the use of uppercase characters. To help make things more interesting, the encoder described in this paper will also avoid all characters above 0x7f. This will make the encoder both UTF-8 safe and tolower safe.



* [ Marshalling to SYSTEM - An analysis of CVE-2018-0824 - codewhitesec.blogspot](https://codewhitesec.blogspot.com/2018/06/cve-2018-0624.html)
* [windows-kernel-exploits](https://github.com/SecWiki/windows-kernel-exploits)
* [ MindshaRE: Walking the Windows Kernel with IDA Python  - Jasiel Spelman](https://www.zerodayinitiative.com/blog/2018/5/21/mindshare-walking-the-windows-kernel-with-ida-python)
* [CVE-2017-11176: A step-by-step Linux Kernel exploitation (part 1/4) - blog.lexfo](https://blog.lexfo.fr/cve-2017-11176-linux-kernel-exploitation-part1.html)
* [Executable and Linkable Format 101 - Part 1 Sections and Segments - Ignacio Sanmillan](http://www.intezer.com/executable-linkable-format-101-part1-sections-segments/)
* [Executable and Linkable Format 101. Part 2: Symbols - Ignacio Sanmillan](https://www.intezer.com/executable-linkable-format-101-part-2-symbols/)
* [Executable and Linkable Format 101 Part 3: Relocations - Ignacio Sanmillan](https://www.intezer.com/executable-and-linkable-format-101-part-3-relocations/)
* [Shellab](https://github.com/TheSecondSun/Shellab)
	* Shellab is a tool that can be used to improve existing shellcodes and adapt them for personal needs. Developed to provide an alternative to msfvenom with new functionalities. Suitable for both Windows and Linux shellcode (32 and 64 bit).
* [Kernel crash caused by out-of-bounds write in Apple's ICMP packet-handling code (CVE-2018-4407) - lgtm.com](https://lgtm.com/blog/apple_xnu_icmp_error_CVE-2018-4407)
* [Yet another memory leak in ImageMagick or how to exploit CVE-2018–16323. - barracud4](https://medium.com/@ilja.bv/yet-another-memory-leak-in-imagemagick-or-how-to-exploit-cve-2018-16323-a60f048a1e12)
* [Flash News - CVE-2018-15981 - Gil Dabah](https://www.ragestorm.net/blogs/?p=421)


#### End Sort