# Classes & Training

-----------------
## Table of Contents
- [Learning](#learning)
- [General Security Classes](#general)
- [General Sources/Repositories of Classes](#repo)
- [ARM](#arm)
- [Basic Security](#basic)
- [Cloud](#cloud)
	- [AWS](#aws)
	- [Azure](#azure)
	- [GCP](#gcp)
- [Computer Science](#cs)
- [Containers](#containers)
- [Cryptography](#crypto)
- [Data Science](#ds)
- [Databases](#db)
- [Exploit Development Training](#exploit)
- [Incident Response and Forensics Training](#ir)
- [Linux](#linux)
- [Machine Learning](#ml)
- [Malware Analysis](#malw)
- [Mobile Applications](#mobile)
- [Networking](#networking)
- [Penetration Testing Training](#pt)
- [Program Management](#pm)
- [Programming Classes/Training](#prog)
- [Red Team Training](#rt)
- [Regular Expressions](#regex)
- [Reverse Engineering Classes/Training](#re)
- [Security Awareness Training](#aware)
- [Threat Hunting](#th)
- [Threat Intelligence](#cti)
- [UEFI/BIOS Training](#uefi)
- [Web Security Focused Training](#web)
- [Wireless](#wireless)
- [Resources for instructors/Trainers](#resource)




------------------------------------------------------------------------------------------------------------------------------------------------------
### Classes & Training
* **HEADS UP**
	* These classes are all focused on computer/information security. If you're looking for online courses to learn material other than the mentioned, check out "coursera.com", Standford's online classes or MIT's online courses.
	* [MIT OpenCourseware](https://ocw.mit.edu/courses/)
	* [Standford](http://online.stanford.edu/courses)
	* [Harvard](https://online-learning.harvard.edu/catalog)
	* [Coursera](https://www.coursera.org/)
	* [Open Security Training](https://www.opensecuritytraining.info)
	* [Udemy](https://www.udemy.com/courses/)
	* [Hackr.io](http://hackr.io/)
		* Share and discover the best programming tutorials and courses online.
	* [Class Central](https://www.class-central.com/)
		* Search engine for MooCs
	* [Roppers Academy](https://www.hoppersroppers.org/training.html)
	
* **Learning**<a name="learning"></a>
	* [Learning How to Learn](https://www.coursera.org/learn/learning-how-to-learn)
		* Free Coursera Course
		* About this course: This course gives you easy access to the invaluable learning techniques used by experts in art, music, literature, math, science, sports, and many other disciplines. We’ll learn about the how the brain uses two very different learning modes and how it encapsulates (“chunks”) information. We’ll also cover illusions of learning, memory techniques, dealing with procrastination, and best practices shown by research to be most effective in helping you master tough subjects. 
	* **General/Interesting Ideas**
		* [SQ3R - Wikipedia](https://en.wikipedia.org/wiki/SQ3R)
			* SQRRR or SQ3R is a reading comprehension method named for its five steps: survey, question, read, recite, and review. The method was introduced by Francis P. Robinson, an American education philosopher in his 1946 book Effective Study.
		* [The Process of Mastering a Skill - Azeria](https://azeria-labs.com/the-process-of-mastering-a-skill/)
		* [The Importance of Deep Work & The 30-Hour Method for Learning a New Skill - Azeria](https://azeria-labs.com/the-importance-of-deep-work-the-30-hour-method-for-learning-a-new-skill/)
		* [The Paradox of Choice: Learning New Skills In Infosec Without Getting Overwhelmed - Azeria](https://azeria-labs.com/paradox-of-choice/)
	* **Spaced-Repetition Learning**
		* [Spaced Repetition for Efficient Learning - gwern](https://www.gwern.net/Spaced-repetition)
		* **Anki**
			* **101**
				* [Homepage](https://apps.ankiweb.net/)
				* [Anki Manual](https://docs.ankiweb.net/#/)
				* [Getting Started - docs.ankiweb](https://docs.ankiweb.net/#/getting-started)
			* **Articles/Blogposts/Writeups**
				* [Better Anki Usage Guide [2019] - andrewzah](https://andrewzah.com/posts/better-anki-usage-guide-2019/#references)
				* [Augmenting Long-term Memory - Michael Nielsen](http://augmentingcognition.com/ltm.html)
				* [Strategies, Tips, and Tricks for Anki - Jeff Shek](https://senrigan.io/blog/everything-i-know-strategies-tips-and-tricks-for-spaced-repetition-anki/)
				* [Anki Tips: What I Learned Making 10,000 Flashcards - rs.io](https://rs.io/anki-tips/)
* **General Classes**<a name="general"></a>
	* [ENISA CERT Exercises and Training](http://www.enisa.europa.eu/activities/cert/support/exercise)
		* ENISA CERT Exercises and training material was introduced in 2008, in 2012 and 2013 it was complemented with new exercise scenarios containing essential material for success in the CERT community and in the field of information security. In this page you will find the ENISA CERT Exercise material, containing Handbook for teachers, Toolset for students and Virtual Image to support hands on training sessions.
	* [SEEDLabs](http://www.cis.syr.edu/~wedu/seed/all_labs.html)
		* People learn from mistakes. In security education, we study mistakes that lead to software vulnerabilities. Studying mistakes from the past not only help students understand why systems are vulnerable, why a "seemly-benign" mistake can turn into a disaster, and why many security mechanisms are needed. More importantly, it also helps students learn the common patterns of vulnerabilities, so they can avoid making similar mistakes in the future. Moreover, using vulnerabilities as case studies, students can learn the principles of secure design, secure programming, and security testing. 
* **ARM**<a name="arm"></a>
	* [ARM Assembly Basics - Azeria](https://azeria-labs.com/writing-arm-assembly-part-1/)
	* [ARM Exploit Development - Azeria](https://azeria-labs.com/writing-arm-shellcode/)
	* [Whirlwind Tour of ARM Assembly - ](https://www.coranac.com/tonc/text/asm.htm)
* **Basic Security**<a name='basic'></a>
	* [Roppers Academy Computing Fundamentals](https://hoppersroppers.org/course.html)
		* Free, self-paced curriculum that builds a base of knowledge in computers and networking. Intended to build up a student with no prior technical knowledge to be confident in their ability to learn anything and continue their security education. Full text available as a [gitbook](https://www.hoppersroppers.org/fundamentals/).
	* [Roppers Academy CTF Fundamentals](https://www.hoppersroppers.org/courseCTF.html)
		* Free course designed to get a student crushing CTFs as quickly as possible. Teaches the mentality and skills required for crypto, forensics, and more. Full text available as a [gitbook](https://www.hoppersroppers.org/ctf/).
	* [Roppers Academy Security Fundamentals](https://www.hoppersroppers.org/courseSecurity.html)
		* Free course that teaches a beginner how security works in the real world. Learn security theory and execute defensive measures so that you are better prepared against threats online and in the physical world. Full text available as a [gitbook](https://www.hoppersroppers.org/security/).
* **Cloud**<a name="cloud"></a>
	* **AWS**<a name="aws"></a>
	* **Azure**
		* [So you want to learn Azure Security? - Michael Howard(2020)](https://michaelhowardsecure.blog/2020/02/14/so-you-want-to-learn-azure-security/)
	* **GCP**
- **Computer Science**<a name="cs"></a>
* **Containers**<a name="containers"></a>
	* [Attacking and Auditing Docker Containers and Kubernetes Clusters](https://github.com/appsecco/attacking-and-auditing-docker-containers-and-kubernetes-clusters)
		* This course will set the base for security testers and DevOps teams to test for common security vulnerabilities and configuration weaknesses across containerised environments and distributed systems. It also helps to understand approach and process to audit the Kubernetes environment for security posture. The courseware is meant to introduce participants to container and cluster management with Kubernetes.
* **Cryptography**<a name="crypto"></a>
    * [Coursera Cryptography](https://www.coursera.org/learn/crypto)
    * [Matsano Crypto Challenges](https://www.cryptopals.com)
        * Go through a series of increasingly difficult challenges while learning all about cryptography. Expected knowledge level: You passed 9th grade math and you have 0 knowledge of crypto.
    * [A Graduate Course in Applied Cryptography - Dan Boneh and Victor Shoup](http://toc.cryptobook.us/)
        * Version 0.3 - posted Dec. 9, 2016
	* [CS255: Introduction to Cryptography - Stanford(Winter2020)](https://crypto.stanford.edu/~dabo/cs255/)
	* [CS 355: Topics in Cryptography - Stanford(Spring 2020)](https://crypto.stanford.edu/cs355/20sp/)
* **Data Science**<a name="data"></a>
	* [CS 259D Data Mining for Cyber Security Autumn 2014](http://web.stanford.edu/class/cs259d/)
* **Databases**<a name="db"></a>
	* [Intro to Databases Systems(CMU) / Fall 2019)](https://www.youtube.com/watch?list=PLSE8ODhjZXjbohkNBWQs_otTrBTrjyohi&v=oeYBdghaIjc&app=desktop)
		* [Site page](https://15445.courses.cs.cmu.edu/fall2019/)
		* This course is on the design and implementation of database management systems. Topics include data models (relational, document, key/value), storage models (n-ary, decomposition), query languages (SQL, stored procedures), storage architectures (heaps, log-structured), indexing (order preserving trees, hash tables), transaction processing (ACID, concurrency control), recovery (logging, checkpoints), query processing (joins, sorting, aggregation, optimization), and parallel architectures (multi-core, distributed). Case studies on open-source and commercial database systems are used to illustrate these techniques and trade-offs. The course is appropriate for students with lit systems programming skills.
	* [CS 186: Introduction to Database Systems - Berkely(Spring2020)](https://cs186berkeley.net/)
		* [Videos From 2012](https://archive.org/details/UCBerkeley_Course_Computer_Science_186)
* **Exploit Development Training**<a name="exploit"></a>
	* [exrs - Binary Exploitation/Reverse Engineering Challenge training](https://github.com/wapiflapi/exrs)
		* Exercises for learning Reverse Engineering and Exploitation. All binaries for these challenges are ELF 64-bit LSB executable, x86-64.
	* [BFH Exploiting & Defense Course - Dobin Rutishauser](https://blog.compass-security.com/2017/05/bfh-exploiting-defense-course/)
	* [Modern Binary Exploitation - CSCI 4968 - Spring '15](http://security.cs.rpi.edu/courses/binexp-spring2015/)
		* The course will start off by covering basic x86 reverse engineering, vulnerability analysis, and classical forms of Linux based userland binary exploitation. It will then transitionin to protections found on modern systems(Canaries, DEP, ASLR, RELRO, FortifySource, etc) and the techniques used to defeat them.Time permitting, the course will also cover other subjects in exploitation including kernel land and Windows based exploitation.
	* [Modern Binary Exploitation - CSCI 4968](https://github.com/RPISEC/MBE)
		* This repository contains the materials as developed and used by RPISEC to teach Modern Binary Exploitation at Rensselaer Polytechnic Institute in Spring 2015. This was a university course developed and run solely by students to teach skills in vulnerability research, reverse engineering, and binary exploitation.
	* [armpwn](https://github.com/saelo/armpwn)
		* Repository to train/learn memory corruption exploitation on the ARM platform. This is the material of a workshop I prepared for my CTF Team.
	* [BinTut](https://github.com/NoviceLive/bintut)
		* Dynamic or live demonstration of classical exploitation techniques of typical memory corruption vulnerabilities, from debugging to payload generation and exploitation, for educational purposes
	* [CNIT 127: Exploit Development - samsclass(Fall2019)](https://samsclass.info/127/127_F19.shtml)
		* "Learn how to find vulnerabilities and exploit them to gain control of target systems, including Linux, Windows, Mac, and Cisco. This class covers how to write tools, not just how to use them; essential skills for advanced penetration testers and software security professionals." Student Learning Outcomes: 1. Read and write basic assembly code routines; 2. Find stack overflow vulnerabilities and exploit them; 3. Evade filters and other Windows defenses
	* [Advanced Exploitation and Rootkit Development, CSCI Spring 2013](http://security.cs.rpi.edu/~candej2/)
	* [Windows Exploitation, CSCI Spring 2014](http://security.cs.rpi.edu/~gaasem/winexp/IndependentStudy.pdf)
		* Abstract: As of January 2014, the Microsoft Windows operating system series maintains over a 90% market share in the global market of computing1 . This fact alone helps explain why Windows is the most commonly targeted platform for malicious exploitation by hackers, organizations, and nation states alike. With years of relentless exploitation, great strides have been made by Microsoft in securing their operating system through numerous exploit mitigation techniques from the Windows XP era onwards. This course will explore the tools, a number of mitigations, and their associated bypass techniques that are utilized in most modern exploits on the Windows platform. The outcome of this course will leave one with the ability to analyze real world vulnerabilities and develop reliable exploits from end to end for Windows XP – Windows 7 systems.
	* [pwn.college](https://pwn.college/)
		* pwn.college is a first-stage education platform for students (and other interested parties) to learn about, and practice, core cybersecurity concepts in a hands-on fashion. It is designed to take a “white belt” in cybersecurity to becoming a “yellow belt”, able to approach (simple) CTFs and wargames.
* **Incident Response/Forensics/NSM Training**<a name="ir"></a>
	* [Android Forensics & Security Testing - OpenSecurityTraining.info](http://opensecuritytraining.info/AndroidForensics.html)
	* [CS 259D Data Mining for Cyber Security Autumn 2014](http://web.stanford.edu/class/cs259d/)
* **Linux**<a name="linux"></a>
	* **Kernel**
		* [Linux Kernel Teaching - linux-kernel-labs](https://linux-kernel-labs.github.io/refs/heads/master/index.html)
			* This is a collection of lectures and labs Linux kernel topics. The lectures focus on theoretical and Linux kernel exploration. The labs focus on device drivers topics and they resemble “howto” style documentation. Each topic has two parts: a walk-through the topic which contains an overview, the main abstractions, simple examples and pointers to APIs, and a hands-on part which contains a few exercises that should be resolved by the student; to focus on the topic at hand, the student is presented with a starting coding skeleton and with in-depth tips on how to solve the exercises This content is based on the [Operatings Systems 2 course](https://ocw.cs.pub.ro/courses/so2_) from the Computer Science and Engineering Department, the Faculty of Automatic Control and Computers, University POLITEHNICA of Bucharest. You can get the latest version at http://github.com/linux-kernel-labs.
* **Machine Learning**<a name="ml"></a>
	* [IntroductionToMachineLearningForSecurityPros](https://github.com/CylanceSPEAR/IntroductionToMachineLearningForSecurityPros)
* **Malware Analysis**<a name="malw"></a>
	* [CS6038/CS5138 Malware Analysis, UC](https://class.malware.re/)
		* This class will introduce the CS graduate students to malware concepts, malware analysis, and black-box reverse engineering techniques. The target audience is focused on computer science graduate students or undergraduate seniors without prior cyber security or malware experience. It is intended to introduce the students to types of malware, common attack recipes, some tools, and a wide array of malware analysis techniques.
	* [Malware Analysis - CSCI 4976](https://github.com/RPISEC/Malware)
		* This repository contains the materials as developed and used by RPISEC to teach Malware Analysis at Rensselaer Polytechnic Institute in Fall 2015. This was a university course developed and run soley by students, primarily using the Practical Malware Analysis book by Michael Sikorski and Andrew Honig, to teach skills in reverse engineering, malicious behaviour, malware, and anti-analysis techniques.
		* [Malware Analysis - CSCI 4972/6963, Spring 2013](http://security.cs.rpi.edu/courses/malware-spring2013/)
	* [Malware-Analysis-Training](https://github.com/OpenRCE/Malware-Analysis-Training)
		* Retired beginner/intermediate malware analysis training materials from @pedramamini and @erocarrera. This course was last given in 2010 and the materials were open sourced in 2020. Written in LaTeX + Beamer, the course materials can be rendered in slideshow and article modes. This course was designed for students who have an introductory / basic understanding of x86 assembly and reverse engineering as well as more advanced students wishing to refresh their skills and learn new approaches to familiar problems. The course will cover the basics of x86 assembly and pattern recognition, Windows process memory layout, tools of the trade (such as IDA Pro and OllyDbg), the PE file format and basic exploitation methodologies abused by worms to penetrate a target system (stack/heap overflows). As this course is focused on malicious code analysis, students will be given real-world virus samples to reverse engineer. The details of executable packing, obfuscation methods, anti-debugging and anti-disassembling will be revealed and re-enforced with hands-on exercises.
* **Mobile Application Security**<a name="mobile"></a>
	* [Mobile Security Trainings](https://github.com/enovella/androidtrainings)
		* Mobile security trainings based on android
* **Networking**<a name="networking">
	* [CS 144: Introduction to Computer Networking, Fall 2019](https://cs144.github.io)
	* [Introduction to Computer Networking(Stanford) - Philip Levis, Nick McKeown](https://lagunita.stanford.edu/courses/Engineering/Networking-SP/SelfPaced/about)
		* This is a self-paced introductory course on computer networking, specifically the Internet. It focuses on explaining how the Internet works, ranging from how bits are modulated on wires and in wireless to application-level protocols like BitTorrent and HTTP. It also explains the principles of how to design networks and network protocols. Students gain experience reading and understanding RFCs (Internet protocol specifications) as statements of what a system should do. The course grounds many of the concepts in current practice and recent developments, such as net neutrality and DNS security. A textbook is recommended, but not required: you can use either Peterson and Davie or Kurose and Ross, any version in the past 5 years will do.
	* [CS 155: Computer and Network Security - Stanford(Spring2020)](https://cs155.stanford.edu/)
	* [Network Examples - knorrie](https://github.com/knorrie/network-examples)
		* Linux networking examples and tutorials
	* [High Performance Browser Networking - Ilya Grigorik](https://hpbn.co/)
		* Performance is a feature. This book provides a hands-on overview of what every web developer needs to know about the various types of networks (WiFi, 3G/4G), transport protocols (UDP, TCP, and TLS), application protocols (HTTP/1.1, HTTP/2), and APIs available in the browser (XHR, WebSocket, WebRTC, and more) to deliver the best—fast, reliable, and resilient—user experience.
* **Penetration Testing**<a name="pt"></a>
	* [Pentester Lab](https://www.pentesterlab.com/)
		* PentesterLab provides vulnerable systems that can be used to test and understand vulnerabilities.
	* [FSU Offensive Security 2014](http://www.cs.fsu.edu/~redwood/OffensiveComputerSecurity/)
		* Florida State University Offensive Security 2014 Class materials
	* [FSU Offensive Security 2013](http://www.cs.fsu.edu/~redwood/OffensiveSecurity/)
		* Florida State University Offensive Security 2013 Class materials
	* [HackSplaining](https://www.hacksplaining.com/faq)
		* Security training aimed towards developers. Free.
	* **Cloud**
		* [Breaking and Pwning Apps and Servers on AWS and Azure - Appsecco](https://github.com/appsecco/breaking-and-pwning-apps-and-servers-aws-azure-training)
			* The training covers a multitude of scenarios taken from our vulnerability assessment, penetration testing and OSINT engagements which take the student through the journey of discovery, identification and exploitation of security weaknesses, misconfigurations and poor programming practices that can lead to complete compromise of the cloud infrastructure. The training is meant to be a hands-on training with guided walkthroughs, scenario based attacks, coverage of tool that can be used for attacking and auditing. Due to the attack, focused nature of the training, not a lot of documentation is around security architecture, defence in depth etc. Additional references are provided in case further reading is required.
	* **'Network' Pentesting**
		* [Beginner Network Pentesting - The Cyber Mentor](https://github.com/hmaverickadams/Beginner-Network-Pentesting)
			* Welcome to the Beginner Network Pentesting course. Previously, the course was delivered weekly on Twitch and built from lessons learned in the previous week. The course provides an opportunity for those interested in becoming an ethical hacker / penetration tester the chance to learn the practical skills necessary to work in the field. Throughout the course, we will develop our own Active Directory lab in Windows, make it vulnerable, hack it, and patch it. We'll cover the red and blue sides. We'll also cover some of the boring stuff like report writing :).
	* **PowerShell**
		* [Fundamentals of Leveraging PowerShell - Carlos Perez(Defcon25)](https://media.defcon.org/DEF%20CON%2025/DEF%20CON%2025%20workshops/DEF%20CON%2025%20-%20Carlos-Perez-Leveraging-PowerShell.pdf)
		* [SpecterOps Adversary Tactics: PowerShell Course](https://github.com/specterops/at-ps)
		* [Powershell-Attack-Guide](https://github.com/rootclay/Powershell-Attack-Guide)
			* Learning PowerShell for internal Pentesting
	* **Web**
		* [Penetration Test Guide based on the OWASP + Extra](https://github.com/Voorivex/pentest-guide)
			* This guid[e] is for the penetration testers seeking for the appropriate test cases required during a penetration test project. I rearranged the OWASP Testing Guide v4 from my point of view including 9 Test Classes and each class has several Test Cases to conduct against the target. Each Test Case covers several OWASP tests which also is useful for the report document. I've also added 14 extra Tests Cases marked by the EXTRA-TEST. I hope it will be useful in both penetration test projects and bug-bounty.
* **Product Management**<a name="pm"></a>
	* [Software Product Management Specialization - University of Alabama(Coursera)](https://www.coursera.org/specializations/product-management)
		* In this Software Product Management Specialization, you will master Agile software management practices to lead a team of developers and interact with clients. In the final Capstone Project, you will practice and apply management techniques to realistic scenarios that you will face as a Software Product Manager. You will have the opportunity to share your experiences and learn from the insights of others as part of a Software Product Management
* **Programming Classes/Courses**<a name="prog"></a>
	* **ASM**
		* [asm - 0xAX](https://github.com/0xAX/asm)
			* Learning assembly for linux-x64 
		* [Introductory Intel x86: Architecture, Assembly, Applications, & Alliteration](http://opensecuritytraining.info/IntroX86.html)
			* This class serves as a foundation for the follow on Intermediate level x86 class. It teaches the basic concepts and describes the hardware that assembly code deals with. It also goes over many of the most common assembly instructions. Although x86 has hundreds of special purpose instructions, students will be shown it is possible to read most programs by knowing only around 20-30 instructions and their variations.
		* [Win32 ASM tutorials - Iczelion](http://win32assembly.programminghorizon.com/tutorials.html)
	* **C**
		* [Beej's Guide to C Programming](https://beej.us/guide/bgc/)
			* Classic
	* **Computer Science**
		* [Computer Science courses with video lectures](https://github.com/Developer-Y/cs-video-courses)
			* List of Computer Science courses with video lectures.
		* [Teach Yourself Computer Science](https://teachyourselfcs.com/)
		* [Technical Development Guide - Google](https://www.google.com/about/careers/students/guide-to-technical-development.html)
		* [OSS University - Computer Science](https://github.com/open-source-society/computer-science)
			* Path to a free self-taught education in Computer Science!
		* [Concepts, Techniques, and Models of Computer Programming](https://www.info.ucl.ac.be/~pvr/book.html)
			* Textbook and Reference Work
		* [Introduction to Computer Science and Programming in Python - MIT(Fall2016)]](https://www.youtube.com/playlist?list=PLUl4u3cNGP63WbdFxL8giv4yhgdMGaZNA)
		* [How to Design Programs](https://htdp.org/)
		* [The Structure and Interpretation of the Computer Science Curriculum - Matthias Felleisen, Robert Bruce Findler, Matthew Flatt, Shriram Krishnamurthi](https://www2.ccs.neu.edu/racket/pubs/jfp2004-fffk.pdf)
			* Twenty years ago Abelson and Sussman’s Structure and Interpretation of Computer Programs radically changed the intellectual landscape of introductory computing courses. Instead of teaching some currently fashionable programming language, it employed Scheme and functional programming to teach important ideas. Introductory courses based on the book showed up around the world and made Scheme and functional programming popular. Unfortunately, these courses quickly disappeared again due to shortcomings of the book and the whimsies of Scheme. Worse, the experiment left people with a bad impression of Scheme and functional programming in general. In this pearl, we propose an alternative role for functional programming in the first-year curriculum. Specifically, we present a framework for discussing the first-year curriculum and, based on it, the design rationale for our book and course, dubbed How to Design Programs. The approach emphasizes the systematic design of programs. Experience shows that it works extremely well as a preparation for a course on object-oriented programming
		* [Structure and Interpretration of Computer Programs](https://mitpress.mit.edu/sites/default/files/sicp/index.html)
			* [MIT Lecture Series](https://www.youtube.com/watch?v=2Op3QLzMgSY)
	* **Secure Coding**
		* [Introduction to Secure Coding - Andrew Buttner, Larry Shields](http://opensecuritytraining.info/IntroSecureCoding.html)
			* The purpose of this course is to provide developers with a short, focused primer related to secure coding.  The hope is that each developer will leave the course with a better understanding of how they can improve, from a security perspective, the code that they write.  This course provides a look at some of the most prevalent security related coding mistakes made in industry today.  Each type of issue is explained in depth including how a malicious user may attack the code, and strategies for avoiding the issues are then reviewed.  Knowledge of at least one programming language is required, although the specific programming language is not important as the concepts that will be discussed are language independent.  The course will cover many of the weaknesses within the context of a web application, but most of the concepts will apply to all application development.
		* [Secure Code Review - Andrew Buttner, Mark Davidson](http://opensecuritytraining.info/SecureCodeReview.html)
			* This course is designed to help developers bring a secure coding mindset into typical project peer reviews. The course briefly talks about the development lifecycle and the importance of peer reviews in delivering a quality product. How to perform this review is discussed and how to keep secure coding a priority during the review is stressed. A variety of hands-on exercises will address common coding mistakes, what to focus on during a review, and how to manage limited time. Throughout the course, the class will break out into pairs and perform example peer reviews on sample code. Perl will be used for the hands-on exercises; however every attempt will be made to generalize the code such that anyone with an understanding of a coding language will be comfortable.
		* [Pushing Left, Like a Boss - Train the Trainer](https://github.com/shehackspurple/TTT-Pushing-Left)
			* This is a “Train the Trainer” document, to be used by someone who wants to present this talk for an audience.
	* **Development**
		* [Software Development Lifecycle Specialization - University of Minnesota(Coursera)](https://www.coursera.org/specializations/software-development-lifecycle)
			* This Specialization is designed for people who are new to software engineering. It's also for those who have already developed software, but wish to gain a deeper understanding of the underlying context and theory of software development practices. At the end of this Specialization, we expect learners to be able to: 1.) Build high-quality and secure software using SDLC methodologies such as agile, lean, and traditional/waterfall.; 2.) Analyze a software development team's SDLC methodology and make recommendations for improvements.; 3.) Compare and contrast software development methodologies with respect to environmental, organizational, and product constraints.
		* [Secure Software Principles - CSCI 4971, Spring 2010](http://www.cs.rpi.edu/academics/courses/spring10/csci4971/)
	* **Functional Programming**
		* [Discrete Mathematics and Functional Programming - Thomas VanDrunen](https://cs.wheaton.edu/~tvandrun/dmfp/)
			* This site provides information about and supplemental material for Thomas VanDrunen, Discrete Mathematics and Functional Programming August 2012 by Franklin, Beedle and Associates. (See Franklin Beedle's catalogue entry.)
	* **'Low-Level'**
		* [Low-Level Programming University](https://github.com/gurugio/lowlevelprogramming-university)
			* This page is for beginners who want to be low-level programmers. I'm inspired by [google-interview-university](https://github.com/jwasham/google-interview-university). I'd like to share my experience and show a roadmap to becoming a low-level programmer because I have found that these skills are not as common as they once were. In addition, many students and beginners ask me how they could become low-level programmers and Linux kernel engineers.
	* **PowerShell**
		* [InfosecPosh101](https://github.com/garignack/InfosecPosh101)
			* A repository of Labs and other information for learning how PowerShell can help with infosec
		* [PowerShell Basics - Carlos Perez](https://www.darkoperator.com/powershellbasics/)
	* **Python**
		* [Introduction to Computer Science and Programming in Python - MIT(Fall2016)]](https://www.youtube.com/playlist?list=PLUl4u3cNGP63WbdFxL8giv4yhgdMGaZNA)
	* **Scheme**
		* [Simply Scheme: Introducing Computer Science - Brian Harvey, Matthew Wright](https://people.eecs.berkeley.edu/~bh/ss-toc2.html)
			* Below this short table of contents is an expanded table of contents including sections within each chapter. Click on the chapter name to jump down. You can also download the complete text of each chapter in PDF format for elegant printing, or browse the HTML version. Part introductions are included in the PDF of the following chapter. Projects are included in the PDF of the preceding chapter.
* **Red-Team**<a name="rt"></a>
	* [Red Team Operations with Cobalt Strike (2019) - Raphael Mudge](https://www.youtube.com/playlist?list=PL9HO6M_MU2nfQ4kHSCzAQMqxQxH47d1no)
		* Red Team Operations with Cobalt Strike is a course on Adversary Simulations and Red Team Operations. Learn how to stand up sophisticated command and control infrastructure, weaponize a payload, send a phishing email, conduct post-exploitation, evade defenses, escalate privileges, take over an Active Directory domain, and tunnel tools and attacks through compromised systems.
* **Regular Expressions**<a name="regex"></a>
	* [RegEx Crossword](https://regexcrossword.com/)
		* Learn RegEx through crosswords
* **Reverse Engineering**<a name="re"></a>
	* [Binary Auditing Training - Thorsten Schneider](http://www.binary-auditing.com/)
		* The training package includes all necessary files to run a complete lecture for Binary Auditing and Reverse Code Engineering at university. All files are well sorted by topics and with increasing difficulty. You need Windows XP, Windows Vista or Windows 7 to use this training package. The training package does NOT include runnable viruses! 
	* [exrs - Binary Exploitation/Reverse Engineering Challenge training](https://github.com/wapiflapi/exrs)
		* Exercises for learning Reverse Engineering and Exploitation. All binaries for these challenges are ELF 64-bit LSB executable, x86-64.
	* [mammon_'s tales to his grandson - Reverse Engineering](https://mammon.github.io/tales/)
	* [Software Modeling  and Verification - Static Analysis](http://www-i2.informatik.rwth-aachen.de/i2/spa12/)
	* [The Life of Binaries](http://opensecuritytraining.info/LifeOfBinaries.html)
		* Topics include but are not limited to: 
			* Scanning and tokenizing source code. 
			* Parsing a grammar.  
			* Different targets for x86 assembly object files generation. (E.g. relocatable vs. position independent code).  
			* Linking object files together to create a well-formed binary.  
			* Detailed descriptions of the high level similarities and low level differences between the Windows PE and Linux ELF binary formats. (NOTE: we didn't get to this in the class where the video was recorded, but the materials are in the slides)
			* How an OS loads a binary into memory and links it on the fly before executing it.   
			* Along the way we discuss the relevance of security at different stages of a binary’s life, from the tricks that can be played by a malicious compiler, to how viruses really work, to the way which malware “packers” duplicate OS process execution functionality, to the benefit of a security-enhanced OS loader which implements address space layout randomization (ASLR).
	* [Introduction to Reverse Engineering Software - Dartmouth](http://althing.cs.dartmouth.edu/local/www.acm.uiuc.edu/sigmil/RevEng/)
	* [CSCI 4974 / 6974 Hardware Reverse Engineering](http://security.cs.rpi.edu/courses/hwre-spring2014/)
	* [Reverse Engineering 101 - MalwareUnicorn](https://malwareunicorn.org/workshops/re101.html#0)
	* [Reverse Engineering 102 - MalwareUnicorn](https://malwareunicorn.org/workshops/re102.html#0)
	* [Binary Analysis Course - Max Kersten](https://maxkersten.nl/binary-analysis-course/)
		* This course starts at the very start, where it is assumed that the reader has little to no low level knowledge. It is expected that the reader is able to understand basic programming aspects such as functions/methods, variables, types and system calls. Unlike most courses, this course aims to only use free and open-source software. This way, everybody can participate and follow the course, whereas most other courses are focused on proprietary tools which cost up to thousands of dollars. This won’t exclude such tools from being used in additional examples later on, but they will not be used as the sole tool in an example. As the course progresses, the material gets more in-depth and complex. Throughout the chapters, there are practical cases included. These cases serve two purposes. Firstly, the reader is greeted with a puzzle every once in a while, instead of pure theory. Secondly, it provides insight in the reader’s learning curve with the help of a given case.
	* [Reverse-Engineering-Intel-x64-101](https://github.com/0xdidu/Reverse-Engineering-Intel-x64-101)
		* Material for a RE 101 class on Intel x64 binaries
	* [Android App Reversing 101 - Maddie Stone](https://maddiestone.github.io/AndroidAppRE/)
	* [Program Obfuscation, Fall 2013 - CSCI](http://security.cs.rpi.edu/courses/obfuscation-fall2013/syllabus.pdf)
		* The issue of program protection has never been more relevant. Commerical software companies need techniques to protect their intellectual property, malware authors try to slow the down the process of reversing and detecting their creations, and nation-states are creating cyber-weapons that they do not want reverse engineered and repurposed. Program protection is has two main approaches, tamper-resistance and obfuscation. Tamperresistance focuses on the detection and corruption of tools used to analyze programs. Obfuscation focuses on making a program hard to understand, even when under flawless analysis tools. Tamper-resistance techniques tend to be an arms race, of one off tricks versus analysis tool updates. Obfuscation offers a much more stable and provably secure avenue in which to protect programs. Obfuscation is thorougly grounded in the formal methods and proofs of cryptography. The only distinction between obfuscation and cryptography is the location of the key. In cryptography, the key is outside the system or data under analysis. In obfuscation, the obfuscated data and key are together, making it a challenging problem of its own. It is the difficulty of provable security and the great need program protection in the current day, that make this class relevant and necessary. In this readings class, we will focus on 15 of the most important works in program obfuscation. We will attain thorough understanding of these papers through paper reviews, discussion, and a project implementing an obfuscation scheme from one of the papers.
	* [Advanced Binary Deobfuscation(2020)](https://github.com/malrev/ABD)
		* This repository contains the course materials of Advanced Binary Deobfuscation at the Global Cybersecurity Camp (GCC) Tokyo in 2020. Reverse engineering is not easy, especially if a binary code is obfuscated. Once obfuscation performed, the binary would not be analyzed accurately with naive techniques alone. In this course, you will learn obfuscation principles (especially used by malware), theory and practice of obfuscated code analysis, and how to write your own tool for deobfuscation. In particular, we delve into data-flow analysis and SAT/SMT-based binary analysis (e.g., symbolic execution) to render obfuscation ineffective.
* **Security (Awareness) Training**<a name='aware'></a>
	* [Security Training for Engineers - Pagerduty](https://sudo.pagerduty.com/for_engineers/)
		* This is an open-source version of "Security Training for Engineers", PagerDuty's internal technical security training, open to all PagerDuty employees as part of our continuous security training program. Unlike our course for everyone, this course covers more technical topics and is more applicable to those in an engineering role. While it delves into various technical topics, it has been designed in such a way as it should be useful regardless of your skill level, whether you've just started your engineering career, or you've been doing this for years. While some of the material we present internally contains sensitive PagerDuty information, the majority consists of generic security lessons, presented in a light-hearted and informative way. Many employees asked for a version of the training they could share with friends and family. This site is the culmination of our efforts to do just that.
* **Threat Hunting**<a name='th'></a>
	* [Flow Analysis & Network Hunting](http://opensecuritytraining.info/Flow.html)
		* This course focuses on network analysis and hunting of malicious activity from a security operations center perspective. We will dive into the netflow strengths, operational limitations of netflow, recommended sensor placement, netflow tools, visualization of network data, analytic trade craft for network situational awareness and networking hunting scenarios.
* **Threat Intelligence**<a name='cti'></a>
	* [Using ATT&CK for Cyber Threat Intelligence Training - MITRE](https://attack.mitre.org/resources/training/cti/)
* **UEFI/BIOS Training**<a name="uefi"></a>
	* [firmware-security-training](https://github.com/advanced-threat-research/firmware-security-training)
* **Web Security Focused Training**<a name="web"></a>
	* [Google Gruyere -  Web Application Exploits and Defenses ](http://google-gruyere.appspot.com/)
	* [Professionally Evil Web App Pen Testing 101 Course - secureideas](https://blog.secureideas.com/2018/01/professionally-evil-web-app-pen-testing-101-course.html)
	* [OWASP Broken Web Applications Project](https://www.owasp.org/index.php/OWASP_Broken_Web_Applications_Project)
		* OWASP Broken Web Applications Project is a collection of vulnerable web applications that is distributed on a Virtual Machine.
	* [OWASP Juiceshop](https://www.owasp.org/index.php/OWASP_Juice_Shop_Project)
		* [OWASP JuiceShop Gitbook walkthrough](https://www.gitbook.com/book/bkimminich/pwning-owasp-juice-shop/details)
		* [Video Walk through by Sunny Wear](https://www.youtube.com/watch?v=zi3yDovd0RY&list=PL-giMT7sGCVI9T4rKhuiTG4EDmUz-arBo)
	* [hacker101](https://github.com/Hacker0x01/hacker101)
		* Hacker101 is structured as a set of video lessons -- some covering multiple topics, some covering a single one -- and can be consumed in two different ways. You can either watch them in the order produced as in a normal class ([§](https://github.com/Hacker0x01/hacker101#sessions) Sessions), or you can watch individual videos ([§](https://github.com/Hacker0x01/hacker101#vulnerabilities) Vulnerabilities). If you're new to security, we recommend the former; this provides a guided path through the content and covers more than just individual bugs.
	* [Security_Ninjas_AppSec_Training](https://github.com/opendns/Security_Ninjas_AppSec_Training)
		* OpenDNS application security training program. This hands-on training lab consists of 10 fun real world like hacking exercises, corresponding to each of the OWASP Top 10 vulnerabilities. Hints and solutions are provided along the way. Although the backend for this is written in PHP, vulnerabilities would remain the same across all web based languages, so the training would still be relevant even if you don’t actively code in PHP.
	* [PortSwigger Web Security Academy](https://portswigger.net/web-security)
		* Free, online web security training from the creators of Burp Suite
	* [Sunny Wear's Brakeing Down Security Web App Sec Training](https://www.youtube.com/playlist?list=PL-giMT7sGCVI9T4rKhuiTG4EDmUz-arBo&app=desktop)
	* [CS253 Web Security - Stanford(Fall 2019)](https://web.stanford.edu/class/cs253/)
		* This course is a comprehensive overview of web security. The goal is to build an understanding of the most common web attacks and their countermeasures. Given the pervasive insecurity of the modern web landscape, there is a pressing need for programmers and system designers to improve their understanding of web security issues.
* **Wireless**<a name="wireless"></a>
	* [Dissecting Industrial Wireless Implementations - DEF CON 25](https://github.com/voteblake/DIWI)
		* https://github.com/vortessence/vortessence
	* [RFID INFOSEC](http://rfidsecurity.uark.edu/course/index.html)
		* RFID INFOSEC is designed to teach undergraduate students about radio frequency identification (RFID) information systems security (INFOSEC).  It provides a system-wide description of a RFID system using a layered reference model that describes the tag, media interface, reader, network, middleware, and application layers.  In addition, it addresses RFID security and privacy threats, risks, and mitigation techniques.  These materials include lesson plans, slides, homework, laboratories, and assessment rubrics organized into modules. 
* **Resources for Instructors and Trainers**<a name="resource"></a>
	* **General Stuff**
		* [The Distribution of Users’ Computer Skills: Worse Than You Think](https://www.nngroup.com/articles/computer-skill-levels/)
		* [LevelUP](https://www.level-up.cc/)
			* Resources for the global digital safety training community.
		* [Swim Don’t Sink: Why Training Matters to a Site Reliability Engineering Practice • Jennifer Petoff (2020)](https://www.youtube.com/watch?v=8iaNMMwozCc&app=desktop)
			* This talk will explore the business case for training, the trade-offs between cost and effectiveness, and best practices for training design and deployment depending on where your organization lies on the spectrum of size and maturity.
	* **Training**
		* [How To Give A Digital Security Training](https://medium.com/@geminiimatt/how-to-give-a-digital-security-training-4c83af667d40)
		* [Be a Better Trainer](https://www.level-up.cc/you-the-trainer/be-a-better-trainer/)
		* [Teaching Evil - Chris Niemira](https://www.irongeek.com/i.php?page=videos/bsidescharm2017/bsidescharm-2017-t200-teaching-evil-chris-niemira)
		* [Reflections on Teaching Wargame Design - James Fielder(War on the Rocks)](https://warontherocks.com/2020/01/reflections-on-teaching-wargame-design/)
		* [How To Learn (And Teach) Hacking - Ruben Gonzalez(OWASP Amsterdam2019)](https://www.youtube.com/watch?v=p6IC-7Nx3r4)
			* We started hacking a couple of years back, competing in capture the flag competitions. Hacking through the weekends and winning prizes sure was a lot of fun. But it‘s nothing compared to the joy of teaching offensive security to students and observing them surpass themselves every week. For multiple semesters now, we‘re teaching hacking to undergraduate students. Somehow we managed to make our course the most attended one in the whole bachelor program. Our lecture doesn't follow teacher centered methods, but utilizes problem based learning and lessons learned from capture the flag competitions. Since teaching also means learning, we worked in a lot of feedback from our students and aligned the contents of the course. In this talk we‘ll explain how to learn and teach this challenging topic, how to correctly use problem based learning in teaching and how to avoid typical pitfalls.
	* **Writeups of experiences**
		* [Scaling up Binary Exploitation Education Augmenting Esoteric Security Subjects with Gamification & Accessibility - Markus Gaasedelen, Patrick Biernat, Amy Burnett](https://blog.ret2.io/2018/09/11/scalable-security-education/)
			* [Demo](https://wargames.ret2.systems/level/corruption)
	* **Constructivism**
		* [Cognitive Constructivism - BerkelyGraduateDivision](https://gsi.berkeley.edu/gsi-guide-contents/learning-theory-research/cognitive-constructivism/)
		* [Constructivist Theory (Jerome Bruner) - instructionaldesign.org](https://www.instructionaldesign.org/theories/constructivist/)
		* [Why Minimal Guidance During Instruction Does Not Work: An Analysis of the Failure of Constructivist, Discovery, Problem-Based, Experiential, and Inquiry-Based Teaching - Paul Kirschner, John Sweller, Richard Edward Clark](https://www.researchgate.net/publication/27699659_Why_Minimal_Guidance_During_Instruction_Does_Not_Work_An_Analysis_of_the_Failure_of_Constructivist_Discovery_Problem-Based_Experiential_and_Inquiry-Based_Teaching)
			* Evidence for the superiority of guided instruction is explained in the context of our knowledge of human cognitive architecture, expert–novice differences, and cognitive load. Although unguided or minimally guided instructional approaches are very popular and intuitively appealing, the point is made that these approaches ignore both the structures that constitute human cognitive architecture and evidence from empirical studies over the past half-century that consistently indicate that minimally guided instruction is less effective and less efficient than instructional approaches that place a strong emphasis on guidance of the student learning process. The advantage of guidance begins to recede only when learners have sufficiently high prior knowledge to provide “internal” guidance. Recent developments in instructional research and instructional designmodels that support guidance during instruction are briefly described.
		* [Epistemological Pluralism and the Revaluation of the Concrete - Sherry Turkle and Seymour Papert](https://cmapspublic2.ihmc.us/rid=1N5PWLBKV-28C3D13-380S/Turkle%20and%20Papert%20epistemological%20pluralism.pdf)
			* The prevailing image of the computer represents it as a logical machine and computer programming as a technical, mathematical activity. Both the popular and technical culture have constructed computation as the ultimate embodiment of the abstract and formal. Yet the computer's intellectual personality has another side: our research finds diversity in the practice of computing that is denied by its social construction. When we looked closely at programmers in action we saw formal and abstract approaches; but we also saw highly successful programmers in relationships with their material that are more reminiscent of a painter than a logician. They use concrete and personal approaches to knowledge that are far from the cultural stereotypes of formal mathematics.'
		* ["How to teach programming (and other things)?" by Felienne Hermans](https://www.youtube.com/watch?v=g1ib43q3uXQ&app=desktop)
			* Everyone should learn programming, right? Yes! But how... Should we allow children to explore and learn about syntax on their own, or should we drill programming like we rote memorize the table of multiplication or German grammatical cases? Felienne's talk outlines this history of programming education and didactics beliefs in programming that lead to the prevalence of exploratory forms of teaching, starting with Papert's LOGO. She will then explore programming education in relation to mathematics and language education and explore how rote learning could look like for programming. Felienne will discuss her own research into misconceptions and code phonology as means to teach programming more effectively.
		* [The case for case studies of programming problems - Marcia C. Linn, Michael J Clancy](https://dl.acm.org/doi/10.1145/131295.131301)
		* [The Effect of Reading Code Aloud on Comprehension: An Empirical Study with School Students - Alaaeddin  Swidan, Felienne Hermans](https://dl.acm.org/doi/10.1145/3300115.3309504)
		* [Constructivism in computer science education - Mordechai Ben-Ari](https://dl.acm.org/doi/10.1145/274790.274308)
	* **Problem Based Learning**
		* [Problem-based learning - Wikipedia](https://en.wikipedia.org/wiki/Problem-based_learning)
			* "[..] a student-centered pedagogy in which students learn about a subject through the experience of solving an open-ended problem found in trigger material. The PBL process does not focus on problem solving with a defined solution, but it allows for the development of other desirable skills and attributes."


