# Cheat Sheets & Reference Pages

## Table of Contents
- [General](#general)
- [Collection of Multiple](#collection)
- [Communication](#comm)
- [Active Directory](#ad)
- [ARM](#arm)
- [ASM](#asm)
- [Android](#Android)
- [iOS](#ios)
- [Credential Attacks](#credatt)
- [Exploitation Development](#exploitation)
- [Forensics/IR](#for)
- [Linux](#Linux)
- [Malware](#Malware)
- [Metasploit](#metasploit)
- [Network Monitoring](#netmon)
- [Network Scanning](#netscan)
- [Penetration Testing Related](#pentest)
- [PowerShell](#powershell)
- [RE](#re)
- [Security Design and Engineering](#sde)
- [Tmux](#tmux)
- [Web](#web)
- [Windows](#windows)
- [Wireless](#wifi)
- [DB](#db)


## Contents
* **General** <a name="general"></a>
	* [How to Suck at Information Security](https://zeltser.com/suck-at-security-cheat-sheet/)
	* [cheat.sh](https://github.com/chubin/cheat.sh)
		*  the only cheat sheet you need https://cheat.sh/
	* [exp](https://github.com/troydm/exp)
		* a command line client for explainshell.com
	* [Malware Archaeology Cheatsheets](https://www.malwarearchaeology.com/cheat-sheets)
	* [Out of Band Exploitation (OOB) CheatSheet - NotSoSecure(2018)](https://notsosecure.com/oob-exploitation-cheatsheet/)
	* **Tools**
		* [cheat](https://github.com/cheat/cheat)
			* cheat allows you to create and view interactive cheatsheets on the command-line. It was designed to help remind nix system administrators of options for commands that they use frequently, but not frequently enough to remember.
* **Collection of Multiple** <a name="collection"></a>
	* [Aman Hardikar's Mindmaps](http://www.amanhardikar.com/mindmaps.html)
	* [Hack3rScroll Mindmaps](https://github.com/hackerscrolls/SecurityTips/tree/master/MindMaps)
		* Mindmaps for Bugbounties, SSRF, OAUTH 2.0, and iOS Vuln assessment.
	* [Mobile Application Penetration Testing Cheat Sheet](https://github.com/tanprathan/MobileApp-Pentest-Cheatsheet)
		* The Mobile App Pentest cheat sheet was created to provide concise collection of high value information on specific mobile application penetration testing topics.
	* [Templates and Checklists - Strategic Environmental Research and Development Program/US DoD](https://www.serdp-estcp.org/Tools-and-Training/Installation-Energy-and-Water/Cybersecurity/Templates-and-Checklists)
		* The Templates and Checklists are the various forms needed to create an RMF package and artifacts that support the completion of the eMASS registration. In addition to the Templates and Checklists, refer to the Cyber Commissioning and the Resources and Tools pages to review and download the Unified Facility Criteria and the Unified Facility Guide Specifications. While the templates and checklists are labeled DoD, ESTCP or Navy, they are fairly organization agnostic and any organization can modify them to suit their own use.
* **Communication** <a name="comm"></a>
	* [Tips for Troubleshooting Human Communications](https://zeltser.com/human-communications-cheat-sheet/)
* **Active Directory** <a name="ad"></a>
	* [Active Directory Cheat Sheet](https://github.com/punishell/ADCheatSheet)
		* Domain Demolition with Frank Castle and Powershell.
	* [Active Directory Exploitation Cheat Sheet - buftas](https://github.com/buftas/Active-Directory-Exploitation-Cheat-Sheet)
		* A cheat sheet that contains common enumeration and attack methods for Windows Active Directory.
* **ARM** <a name="arm"></a>
	* [ARM Assembly Basics Cheatsheet - AzeriaLabs](https://azeria-labs.com/assembly-basics-cheatsheet/)
	* [ARMwiki - hehyrick.co.uk](https://www.heyrick.co.uk/armwiki/Category:Introduction)
		* ARM processor wiki
* **ASM** <a name="asm"></a>
	* [x86 opcode structure and instruction overview](http://pnx.tf/files/x86_opcode_structure_and_instruction_overview.pdf)
	* [Intro to x86 calling conventions](http://codearcana.com/posts/2013/05/21/a-brief-introduction-to-x86-calling-conventions.html)
	* [Reading ASM](http://cseweb.ucsd.edu/classes/sp11/cse141/pdf/02/S01_x86_64.key.pdf)
	* [Assembler Language Instructions](http://www.laynetworks.com/assembly%20tutorials3.htm)
* **Android** <a name="Android"></a>
	* [Android ADB cheat sheet](https://github.com/maldroid/adb_cheatsheet/blob/master/cheatsheet.pdf?raw=true)
* **iOS** <a name="ios"></a>
	* [OWASP IOS Application Security Testing Cheat Sheet](https://www.owasp.org/index.php/IOS_Application_Security_Testing_Cheat_Sheet#Insecure_data_storage)
* **Credential Attacks** <a name="credatt"></a>
	* Windows
		* [Credential Dumping Cheatsheet - Ignitetechnologies](https://github.com/Ignitetechnologies/Credential-Dumping)
			* This cheatsheet is aimed at the Red Teamers to help them understand the fundamentals of Credential Dumping (Sub Technique of Credential Access) with examples.
* **Exploitation Development** <a name="exploitation"></a>
	* [x86 opcode structure and instruction overview](http://pnx.tf/files/x86_opcode_structure_and_instruction_overview.pdf)
	* [Nasm x86 reference](https://www.cs.uaf.edu/2006/fall/cs301/support/x86/)
	* [ARM Exploitation Cheat Sheet](https://azeria-labs.com/assembly-basics-cheatsheet/)
* **Forensics/IR** <a name="for"></a>
	* [File Signature Table](http://www.garykessler.net/library/file_sigs.html)
	* [Mem forenics cheat sheet](http://forensicmethods.com/wp-content/uploads/2012/04/Memory-Forensics-Cheat-Sheet-v1.pdf)
	* [Security Incident Survey Cheat Sheet](https://zeltser.com/security-incident-survey-cheat-sheet/)
	* [Initial Security Incident Questionnaire for responders Cheat Sheet](https://zeltser.com/security-incident-questionnaire-cheat-sheet/)
	* [Critical Log Review Checklist for Security Incidents](https://zeltser.com/security-incident-log-review-checklist/)
	* [Network DDOS Incident Response Cheat Sheet](https://zeltser.com/ddos-incident-cheat-sheet/)
	* [Windows Registry Auditing Cheatsheet - Malware Archaeology](https://static1.squarespace.com/static/552092d5e4b0661088167e5c/t/5d497aefe58b7e00011f6947/1565096688890/Windows+Registry+Auditing+Cheat+Sheet+ver+Aug+2019.pdf)
* **Linux** <a name="Linux"></a>
	* [Linux Syscall Table](http://www.informatik.htw-dresden.de/~beck/ASM/syscall_list.html)
		* Complete listing of all Linux Syscalls
* **Malware** <a name="Malware"></a>
	* [Reverse Engineering Malware Cheat Sheet](https://zeltser.com/reverse-malware-cheat-sheet/)
	* [Analyzing Malicious Documents Cheat Sheet](https://zeltser.com/analyzing-malicious-documents/)
	* [Windows Registry Auditing Cheatsheet - Malware Archaeology](https://static1.squarespace.com/static/552092d5e4b0661088167e5c/t/5d497aefe58b7e00011f6947/1565096688890/Windows+Registry+Auditing+Cheat+Sheet+ver+Aug+2019.pdf)
* **Metasploit** <a name="metasploit"></a>
	* [Metasploit 4.2 documentation](https://community.rapid7.com/docs/DOC-1751)
	* [MSF Payload Cheat Sheet](http://aerokid240.blogspot.com/2009/11/msfpayload-goodness-cheatsheet.html)
	* [Metasploit Meterpreter Cheat Sheet](https://scadahacker.com/library/Documents/Cheat_Sheets/Hacking%20-%20Meterpreter%20Cheat%20%20Sheet.pdf)
	* [Tips & Tricks](https://en.wikibooks.org/wiki/Metasploit/Tips_and_Tricks)
	* [Meterpreter Paranoid Mode - rapid7](https://github.com/rapid7/metasploit-framework/wiki/Meterpreter-Paranoid-Mode)
	* [Using the Database in Metasploit](https://www.offensive-security.com/metasploit-unleashed/using-databases/)
* **Network Monitoring** <a name="netmon"></a>
	* [SiLK Toolsuite Quick Reference Guide](https://tools.netsa.cert.org/silk/silk-quickref.pdf)
* **Network Scanning** <a name="netscan"></a>
	* [Nmap](https://highon.coffee/docs/nmap/)
* **Penetration Testing Related** <a name="pentest"></a>
	* [General Tricks](http://averagesecurityguy.info/cheat-sheet/)
	* [Penetration Testing Tools Cheat Sheet](https://highon.coffee/blog/penetration-testing-tools-cheat-sheet/)
	* [AIX For Pentesters](http://www.giac.org/paper/gpen/6684/aix-penetration-testers/125890)
		* Good paper on exploiting/pentesting AIX based machines. From the paper itself “ The paper proposes some basic methods to do comprehensive local security checks and how to exploit the vulnerabilities.”
	* [Linux - Breaking out of shells](https://highon.coffee/docs/linux-commands/#breaking-out-of-limited-shells)
	* [RootVG - Website Dedicated to AIX](http://www.rootvg.net/content/view/102/98/)
	* [Windows Privilege Escalation Cheat Sheet/Tricks](http://it-ovid.blogspot.fr/2012/02/windows-privilege-escalation.html)
	* [Attack Surface Analysis Cheat Sheet](https://www.owasp.org/index.php/Attack_Surface_Analysis_Cheat_Sheet)
	* [Web Application Penetration Testing Cheat Sheet - jdow.io](https://jdow.io/blog/2018/03/18/web-application-penetration-testing-methodology/)
	* [Pentesting CheatSheets - @spotheplanet](https://ired.team/offensive-security-experiments/offensive-security-cheetsheets)
	* [Active Directory Cheat Sheet](https://github.com/Integration-IT/Active-Directory-Exploitation-Cheat-Sheet)
		* This repository contains a general methodology in the Active Directory environment. It is offered with a selection of quick commands from the most efficient tools based on Powershell, C, .Net 3.5 and .Net 4.5.
* **PowerShell** <a name="powershell"></a>
	* [PowerShell Remoting Cheatsheet - Scott Sutherland](https://blog.netspi.com/powershell-remoting-cheatsheet/)
* **RE** <a name="re"></a>
	* [Radare2 Cheat-Sheet](https://github.com/radareorg/radare2/blob/master/doc/intro.md)
	* [WinDbg Cheat Sheet/mindmap](http://tylerhalfpop.com/2014/08/16/windbg-cheatsheet/)
	* [Pdf of all WinDbg commands](http://windbg.info/download/doc/pdf/WinDbg_cmds.pdf)
	* [Arm instruction set](http://simplemachines.it/doc/arm_inst.pdf)
	* [IdaRef](https://github.com/nologic/idaref)
		* IDA Pro Full Instruction Reference Plugin - It's like auto-comments but useful.
* **Security Design and Engineering** <a name="sde"></a>
	* [Security Architecture Cheat Sheet for Internet Applications](https://zeltser.com/security-architecture-cheat-sheet/)
* **Tmux** <a name="tmux"></a>
	* [tmux Cheat Sheet](http://tmuxcheatsheet.com/)
* **Web** <a name="web"></a>
	* [API Security Checklist](https://github.com/shieldfy/API-Security-Checklist/)
	* Checklist of the most important security countermeasures when designing, testing, and releasing your API.
	* [Drupal Security Checklist](https://github.com/gfoss/attacking-drupal/blob/master/presentation/drupal-security-checklist.pdf)
	* [OWASP Authentication Cheat Sheet](https://www.owasp.org/index.php/Authentication_Cheat_Sheet)
	* [OWASP Testing Checklist](https://www.owasp.org/index.php/Testing_Checklist)
	* [Securing Web Application Technologies Checklist](http://www.securingthehuman.org/developer/swat)
	* [SSRF Bible Cheatsheet](https://docs.google.com/document/d/1v1TkWZtrhzRLy0bYXBcdLUedXGb9njTNIJXa3u9akHM/edit)
	* [WebAppSec Testing Checklist](http://tuppad.com/blog/wp-content/uploads/2012/03/WebApp_Sec_Testing_Checklist.pdf)
	* [HTML5 Security Cheatsheet](https://github.com/jshaw87/Cheatsheets)
	* [XML DTD Cheat Sheet](https://web-in-security.blogspot.it/2016/03/xxe-cheat-sheet.html)
	* [OWASP XSS (Cross Site Scripting) Prevention Cheat Sheet](https://www.owasp.org/index.php/XSS_(Cross_Site_Scripting)\_Prevention_Cheat_Sheet)
	* [OWASP Input Validation Cheat Sheet](https://www.owasp.org/index.php/Input_Validation_Cheat_Sheet)
	* [OWASP Authentication Cheat Sheet](https://www.owasp.org/index.php/Authentication_Cheat_Sheet)
	* [OWASP Forgot Password Cheat Sheet](https://www.owasp.org/index.php/Forgot_Password_Cheat_Sheet)
	* [OWASP Choosing and Using Security Questions Cheat Sheet](https://www.owasp.org/index.php/Choosing_and_Using_Security_Questions_Cheat_Sheet)
	* [OWASP Session Management Cheat Sheet](https://www.owasp.org/index.php/Session_Management_Cheat_Sheet)
	* [OWASP Transport Layer Protection Cheat Sheet](https://www.owasp.org/index.php/Transport_Layer_Protection_Cheat_Sheet)
	* [OWASP Pinning Cheat Sheet](https://www.owasp.org/index.php/Pinning_Cheat_Sheet)
	* [OWASP Cryptographic Storage Cheat Sheet](https://www.owasp.org/index.php/Cryptographic_Storage_Cheat_Sheet)
	* [Web Application Cheatsheet (Vulnhub)](https://github.com/Ignitetechnologies/Web-Application-Cheatsheet)
		* This cheatsheet is aimed at the CTF Players and Beginners to help them understand Web Application Vulnerablity with examples.
* **Windows** <a name="windows"></a>
	* [Windows Startup Application Database](http://www.pacs-portal.co.uk/startup_content.php)
	* [Windows CMD Reference - ms](https://www.microsoft.com/en-us/download/details.aspx?id=56846)
	* [Windows Command Line cheatsheet (part 2): WMIC - andreafortuna](https://www.andreafortuna.org/dfir/windows-command-line-cheatsheet-part-2-wmic/)
	* [Windows CLI gems. Tweets of @wincmdfu](https://github.com/madhuakula/wincmdfu#list-missing-updates)
		* Windows one line commands that make life easier, shortcuts and command line fu.
	* [MS "reg" commandreference](http://www.computerhope.com/reg.htm)
* **Wireless** <a name="wifi"></a>
	* [Management Frames Reference Sheet](http://download.aircrack-ng.org/wiki-files/other/managementframes.pdf)
* **DB** <a name="db"></a>
	* [Checklist for mongodb](http://blog.mongodirector.com/10-tips-to-improve-your-mongodb-security/)
