# Career/Job Related Stuff

---------------------------------------------------------------------------------------------------------
## Table of Contents
- [101](#101)
- [Business](#business)
- [Career Growth/Progression](#growth)
- [Careers in InfoSec](#infosec-careers)
- [Choosing a Job/Looking for Work](#looking)
- [Company Culture](#culture)
- [Compensation](#comp)
- [Contracting & Consulting](#contract)
- [Difficult Conversations](#difficult)
- [Employee Attrition](#attrition)
- [General(Miscellaneous)](#general)
- [Hiring](#hiring)
- [Imposter Syndrome](#imposter)
- [Independent Business](#independent)
- [Informal Laws & Principles](#laws)
- [Interview Prep](#interview)
- [Interviewing](#interviewing)
- [Management](#mgmt)
- [Meetings](#meetings)
- [Mental Health](#mentalh)
- [Mentoring](#mentor)
- [Metrics](#metrics)
- [Networking(social)](#networking)
- [Non-Competes](#noncomp)
- [Non-Technical Skills](#non-tech)
- [Organizational Theory](#orgtheory)
- [Performance Reviews](#perf)
- [Post-Mortems](#postmort)
- [Project Management](#projm)
- [Resume](#resume)
- [Strategy](#strategy)
- [Teams](#teams)
- [Testing](#testing)
- [Other](#other)
- [Industry](#industry)
---------------------------------------------------------------------------------------------------------






------------------------------------------------------
### Career Information<a name="career-info"></a>
* **101**<a name="101"></a>
	* [Ten Simple Rules for Doing Your Best Research, According to Hamming](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2041981/)
	* [‘Thought Leader’ gives talk that will inspire your thoughts | CBC Radio (Comedy/Satire Skit)](https://www.youtube.com/watch?v=_ZBKX-6Gz6A)
		* Self proclaimed “thought leader,” Pat Kelly gives his talk on “thought leadership” at the annual This Is That Talks in Whistler, B.C. In the seminar, Kelly covers: How to talk with your hands, how to get a standing ovation, and how to inspire people by saying nothing at all.
	* [Lack of progress exposed by the Canary MacGuffin - rachelbythebay](https://rachelbythebay.com/w/2018/10/23/idle/)
	* [Strategy Letter I: Ben and Jerry’s vs. Amazon - Joel on Software](https://www.joelonsoftware.com/2000/05/12/strategy-letter-i-ben-and-jerrys-vs-amazon/)
	* [Defining The Corporate Hierarchy - Erik Dietrich](https://daedtech.com/defining-the-corporate-hierarchy/)
	* [The Beggar CEO and Sucker Culture - Erik Dietrich](https://daedtech.com/the-beggar-ceo-and-sucker-culture/)
	* [One week of bugs - Dan Luu](http://danluu.com/everything-is-broken/)
	* [I could do that in a weekend! - danluu.com](https://danluu.com/sounds-easy/)
	* [Harvey Weinstein and the Common Knowledge Game - Ben Hunt](https://www.epsilontheory.com/harvey-weinstein-common-knowledge-game/)
	* [Cybersecurity Career Pathway](https://www.cyberseek.org/pathway.html)
	* [Tech Company Org Charts(Joke)](http://bonkersworld.net/organizational-charts)
	* [Keynote by Jayson Street at leHACK 2019 in Paris](https://www.youtube.com/watch?v=LX5Xy3a2uJU)
		* What is a Hacker Convention & who deserves to be called a Hacker (Plus other uncomfortable discussions with Jayson)
	* [Real Software Engineering by Glenn Vanderburg(Lone Star Ruby Conference(2010)](https://www.youtube.com/watch?v=NP9AIUT9nos&feature=youtu.be)
		* Software engineering as it's taught in universities simply doesn't work. It doesn't produce software systems of high quality, and it doesn't produce them for low cost. Sometimes, even when practiced rigorously, it doesn't produce systems at all.  That's odd, because in every other field, the term "engineering" is reserved for methods that work.  What then, does real software engineering look like? How can we consistently deliver high-quality systems to our customers and employers in a timely fashion and for a reasonable cost? In this session, we'll discuss where software engineering went wrong, and build the case that disciplined Agile methods, far from being "anti-engineering" (as they are often described), actually represent the best of engineering principles applied to the task of software development.
	* [The Rise of the Meritocracy - Wikipedia](https://en.wikipedia.org/wiki/The_Rise_of_the_Meritocracy)
		* [...] a book by British sociologist and politician Michael Dunlop Young which was first published in 1958. It describes a dystopian society in a future United Kingdom in which intelligence and merit have become the central tenet of society, replacing previous divisions of social class and creating a society stratified between a merited power-holding elite and a disenfranchised underclass of the less merited. The essay satirised the Tripartite System of education that was being practised at the time.
	* [Operator: The Well-Rounded Hacker - Matthew Curtin(CircleCityCon2018)](https://www.irongeek.com/i.php?page=videos/circlecitycon2018/circle-city-con-50-209-operator-the-well-rounded-hacker-matthew-curtin)
		* Technical skills are of little value if they cannot be put to work, which is to say, put in context. While specialization, and even hyperspecialization can provide certain advantages, it comes at a cost: the inability to adjust to changes outside of one's field of expertise. It is no secret that demand for "security professionals" is high, that barriers to entry are great, and that rate of burnout is high. What starts as specialization ends with pigeonholed: trapped in a position that is unrewarding. We introduce the `*Operator*`: a hacker with not only depth of knowledge, but important breadth, and the ability to apply the combination of skills to problems and opportunities encountered over a lifetime.
* **Attention**
	* [Attention is your scarcest resource - benkuhn.net](https://www.benkuhn.net/attention/)
* **Business**<a name="business"></a>
	* [When Everything That Counts Can’t Be Counted - Joshua M. Brown](https://thereformedbroker.com/2019/06/13/when-everything-that-counts-cant-be-counted/)
	* [The Trillion-Dollar Vision of Dee Hock - Mitchell Waldrop(FastCompany)](https://www.fastcompany.com/27333/trillion-dollar-vision-dee-hock)
	* [The Longest Yard: Reorganizing IT for Success - Bruce F. Webster](http://brucefwebster.com/2008/04/14/the-longest-yard-reorganizing-it-for-success/)
	* [How Complex Systems Fail - Richard I. Cook](http://web.mit.edu/2.75/resources/random/How%20Complex%20Systems%20Fail.pdf)
	* [Big companies v. startups - Dan Luu](https://danluu.com/startup-tradeoffs/)
	* [The Innovation Equation - Safi Bahcall](https://hbr.org/2019/03/the-innovation-equation)
	* [The story of Totlol](https://web.archive.org/web/20100113220844/http://www.totlol.com/t/story)
		* Example/reminder of why you don't build your product on someone else's API.
	* [Benchmarking - Wikipedia](https://en.m.wikipedia.org/wiki/Benchmarking)
		* Benchmarking is the practice of comparing business processes and performance metrics to industry bests and best practices from other companies. Dimensions typically measured are quality, time and cost. 
	* [Capability Immaturity Model - Wikipedia](https://en.m.wikipedia.org/wiki/Capability_Immaturity_Model)
		* Capability Immaturity Model (CIMM) in software engineering is a parody acronym, a semi-serious effort to provide a contrast to the Capability Maturity Model (CMM). The Capability Maturity Model is a five point scale of capability in an organization, ranging from random processes at level 1 to fully defined, managed and optimized processes at level 5. The ability of an organization to carry out its mission on time and within budget is claimed to improve as the CMM level increases.
	* [Explain Security To Business People - wiki.c2](http://wiki.c2.com/?ExplainSecurityToBusinessPeople)
	* [Sharpe ratio - Wikipedia](https://en.wikipedia.org/wiki/Sharpe_ratio)
		* In finance, the Sharpe ratio (also known as the Sharpe index, the Sharpe measure, and the reward-to-variability ratio) measures the performance of an investment (e.g., a security or portfolio) compared to a risk-free asset, after adjusting for its risk. It is defined as the difference between the returns of the investment and the risk-free return, divided by the standard deviation of the investment (i.e., its volatility). It represents the additional amount of return that an investor receives per unit of increase in risk. 
* **Career Growth/Progression**<a name="growth"></a>
	* [How Developers Stop Learning: Rise of the Expert Beginner - Erik Dietrich](https://daedtech.com/how-developers-stop-learning-rise-of-the-expert-beginner/)
	* [Your Job Title of Tomorrow: Efficiencer - Erik Dietrich](https://daedtech.com/your-job-title-of-tomorrow-efficiencer/)
	* [Things I Learnt The Hard Way (in 30 Years of Software Development) - juliobiason.net](https://blog.juliobiason.net/thoughts/things-i-learnt-the-hard-way/)
	* [Recommended Reading for Developers(2015) - blog.codinghorror.com]
	* [Research Debt - Chris Olah, Shan Carter](https://distill.pub/2017/research-debt/)
	* [A day at the park - mused](http://kiriakakis.net/comics/mused/a-day-at-the-park)
	* [The Asshole Filter - Siderea](https://siderea.livejournal.com/1230660.html)
	* [Hacking a Security Career - Deviant Ollam(WWHF19)](https://www.youtube.com/watch?v=jZFuCYyQB6c&list=PLXF21PFPPXTNXEgkUEBbRgvraxWP3c4Hr&index=2)
	* [Accelerate Your Career By Building FIVE Critical Professional Skills - Ted Demopoulos](https://www.sans.org/webcasts/accelerate-career-building-critical-professional-skills-112310/success)
	* [Continuous Skills Improvement For Everyone - Matt Scheurer(OISF19)](http://www.irongeek.com/i.php?page=videos/oisf2019/oisf-2019-03-continuous-skills-improvement-for-everyone-matt-scheurer)
* **Careers in Information Security**<a name="infosec-careers"></a>
	* **101/General**
		* [NICE Cybersecurity Workforce Framework - NICCS.us-cert.gov](https://niccs.us-cert.gov/workforce-development/cyber-security-workforce-framework)
		* [Cyber Career Pathways Tool - National Initiative For CyberSecurity Careers and Studies](https://niccs.us-cert.gov/workforce-development/cyber-career-pathways)
			* This tool presents a new and interactive way to explore work roles within the NICE Cybersecurity Workforce Framework. It depicts the Cyber Workforce according to five distinct, yet complementary, skill communities. It also highlights core attributes among each of the 52 work roles and offers actionable insights for employers, professionals, and those considering a career in Cyber.
		* [Q: Why Do Keynote Speakers Keep Suggesting That Improving Security Is Possible? A: Because Keynote Speakers Make Bad Life Decisions and Are Poor Role Models](https://www.usenix.org/conference/usenixsecurity18/presentation/mickens)
			* Some people enter the technology industry to build newer, more exciting kinds of technology as quickly as possible. My keynote will savage these people and will burn important professional bridges, likely forcing me to join a monastery or another penance-focused organization. In my keynote, I will explain why the proliferation of ubiquitous technology is good in the same sense that ubiquitous Venus weather would be good, i.e., not good at all. Using case studies involving machine learning and other hastily-executed figments of Silicon Valley’s imagination, I will explain why computer security (and larger notions of ethical computing) are difficult to achieve if developers insist on literally not questioning anything that they do since even brief introspection would reduce the frequency of git commits. At some point, my microphone will be cut off, possibly by hotel management, but possibly by myself, because microphones are technology and we need to reclaim the stark purity that emerges from amplifying our voices using rams’ horns and sheets of papyrus rolled into cone shapes. I will explain why papyrus cones are not vulnerable to buffer overflow attacks, and then I will conclude by observing that my new start-up papyr.us is looking for talented full-stack developers who are comfortable executing computational tasks on an abacus or several nearby sticks.
		* [VB 2019 London Keynote address: The security products we deserve](https://www.youtube.com/watch?v=GHuQC1qLnJ4)
			* Everybody decries the state of the industry. Everyone hates the over-hyped headlines, the obvious FUD and the shameless snake-oil. So why do we have so much of it? This talk aims to examine several of the dark-patterns that have become perfectly acceptable in infosec and then aims to drill down to their root causes. With any luck, we will also get to discuss some options to chart our way out of this mess.
		* [How to Start in InfoSec - Mubix](https://gist.github.com/mubix/5737a066c8845d25721ec4bf3139fd31)
		* ["Firemen vs Safety Matches" - Amélie Koran(ShmooCon XV 2019)](https://www.youtube.com/watch?v=_pej1oHN-pE)
		* [So, you want to work in security? - Parisa Tabriz(2016)](https://www.freecodecamp.org/news/so-you-want-to-work-in-security-bc6c10157d23/)
	* **Educational/Informational**
		* [Navigating Career Choices in InfoSec - Fernando Montenegro - BSides Detroit2017](https://www.youtube.com/watch?v=yM2xCjrQSY4)
			* Making career choices can be intimidating and stressful. Perhaps this presentation can help. The tidal forces affecting technology impact our careers as well. If we're not actively managing them, we're leaving decisions to chance (or to others), and may not like the outcomes. This presentation describes a framework I've used over the past few years to evaluate both ongoing job satisfaction as well as new opportunities as they appear. I'm happy with the outcomes I've obtained with it, and have used this same framework when providing advice to others, and it has been well received. Hopefully it can help others as well.
		* [Infosec Tools of the Trade: Getting Your Hands Dirty](http://www.irongeek.com/i.php?page=videos/bsidesnashville2017/bsides-nashville-2017-green00-infosec-tools-of-the-trade-getting-your-hands-dirty-jason-smith-and-tara-wink)
			* In this presentation we'll will be going over introductions to the various focuses in information security and demoing the most common tools that are used in operational security, both offense and defense. You'll leave with an idea on how to freely obtain and use these tools so that you can have what you need for that first interview: experience and a passion for security. This is a green talk for people who don't have a clue on what offensive and defensive people do operationally, from a tool perspective.
		* [So You Want To Be A H6x0r Getting Started in Cybersecurity Doug White and Russ Beauchemin ](https://www.youtube.com/watch?v=rRJKghTTics)
		* [How to Get Any Job You Want (even if you’re unqualified) - Raghav Haran](https://medium.com/the-mission/how-to-get-any-job-you-want-even-if-you-re-unqualified-6f49a65f5491)
		* [Getting Hired: A Few Tips - Mubix](https://malicious.link/post/2018/getting-hired-a-few-tips/)
		* [Day-1 Skills That Cybersecurity Hiring Managers Are Looking For - Daniel Messler](https://danielmiessler.com/blog/day-1-skills-required-to-land-an-entry-level-cybersecurity-job/)
		* [What is the difference amongst a TPM, PM, and EM in a technology company? How do they typically work together? - Quora](https://www.quora.com/What-is-the-difference-amongst-a-TPM-PM-and-EM-in-a-technology-company-How-do-they-typically-work-together)
		* [Hack Apart Your Career: How to Fund Doing What You Love - John Grigg(WWHF2019)](https://www.youtube.com/watch?v=6yaVmcPrhkA)
			* Our field is full of extremely creative people who have a lot to offer the industry. But often we lose focus because we are working for a company that has their own goals and competing priorities. This leads to long hours of work, a declining quality of life, and various other troubles. In this talk I focus on the tidal wave of DOD-related opportunities that exist to fund novel research and cutting edge technology, all while allowing autonomy of the individual. I've personally used these sources to transition to running my own company and have helped a lot of folks in the industry do the same. I'll discuss why people should consider this as a career path, where to find these resources, and walk through exactly how to apply.
		* [From Barista to Cyber Security Pro - Alyssa Miller(DEF CON Safe Mode Career Hacking Village)](https://www.youtube.com/watch?v=dGpHdExqu0k)
		* [How to Social Engineer your way into your dream job - Jason Blanchard(Derbycon2016)](https://www.youtube.com/watch?v=__lvS2pjuSg)
		* [How to Hunt for Jobs like a Hacker - Jason Blanchard(2020)](https://www.youtube.com/watch?v=Air1c697tjw&feature=youtu.be)
			* Job hunting? Looking for a career change? Still in college and want to know how to get started now in your career? Have an hour free on a Thursday afternoon? If you answered yes to any of these questions, this might be the BHIS webcast for you.  This webcast is an update to Jason's popular recorded DerbyCon 2016 talk -- How to Social Engineer Your Way Into Your Dream Job. If you don't want to wait, you can watch that now. https://youtu.be/__lvS2pjuSg  What will be covered? * How to combine OSINT, marketing technology, and a hacker/social engineer mindset to job hunting; How to be a hunter of jobs... not just a seeker of jobs; How to write your resume during the job hunt; You might already have your dream job  The hope of this webcast is that you'll look at job hunting differently and apply the skills and techniques in an effective way to help you get the career of your dreams... or at least a job for now that will help you get to the career of your dreams in the next 5 years.
	* **Interview Preparation**
		* [How to prepare for an infosec interview - Timothy DeBlock](http://www.timothydeblock.com/eis/135)
	* **Relevant Standards**
		* [NICE Cybersecurity Workforce Framework](https://www.nist.gov/itl/applied-cybersecurity/national-initiative-cybersecurity-education-nice/nice-cybersecurity)
			* The NICE Framework, NIST Special Publication 800-181, establishes taxonomy and common lexicon that is to be used to describe all cybersecurity work and workers irrespective of where or for whom the work is performed. The NICE Framework is intended to be applied in the public, private, and academic sectors. (USA Focused)
	* **Switching Jobs**
		* [The Difficult Decision to Switch Jobs - Katie Nickels(2020)](https://medium.com/katies-five-cents/the-difficult-decision-to-switch-jobs-25955949bd5b)
	* **Application Security**
		* [Pushing Left, Like a Boss: Table of Contents - SheHacksPurple](https://medium.com/bugbountywriteup/pushing-left-like-a-boss-table-of-contents-42fd063a75bb)
			* The following is a table of contents for my modern-day book, based off of a talk I wrote in 2016 entitled “Pushing Left, Like a Boss”. It serves as a foundational lesson on what “Application Security” is, and how to get started. I hope you find the series helpful.
	* **Autonomous Vehicles**
		* [Want to become an autonomous vehicle engineer? - Kyle Martin](https://becomeautonomous.com/)
	* **Data Scientist**
		* [What Data Scientists Really Do, According to 35 Data Scientists - HBR](https://hbr.org/2018/08/what-data-scientists-really-do-according-to-35-data-scientists?mc_cid=f8f788d39e&mc_eid=f956a0c5ca)
		* [How to Become a Data Scientist - On your own - Zeeshan Usmani](https://www.datasciencecentral.com/profiles/blogs/how-to-become-a-data-scientist-for-free)
	* **Penetration Tester**
		* **Articles & Writeups**
			* [How to become a pentester - Corelan(2015)](https://www.corelan.be/index.php/2015/10/13/how-to-become-a-pentester/)
			* [Attacking Big Business](https://www.cyberis.co.uk/blog/attacking-big-business)	
			* [10 common mistakes aspiring/new pentesters make - PentesterLab](https://blog.pentesterlab.com/10-common-mistakes-aspiring-new-pentesters-make-b74a81e58934)
			* [So You Want To Be a Pentester? - Jack Halon](https://jhalon.github.io/becoming-a-pentester/)
			* [And THIS is Why Penetration Testing Sucks - Ronin Chang](https://www.linkedin.com/pulse/why-penetration-testing-sucks-ronin-chang/)
			* [World's Worst Penetration Test Report - rant](https://it.toolbox.com/blogs/chiefmonkey/the-worlds-worst-penetration-test-report-by-scumbagpentester-012814)
			* [Make It Count: Progressing through Pentesting - Bálint Varga-Perke -Silent Signal](https://silentsignal.hu/docs/Make_It_Count_-_Progressing_through_Pentesting_Balint_Varga-Perke_Silent_Signal.pdf)
		* **On-The-Job Experiences**
			* [A Pentester’s Voyage – The First Few Hours - Jordan Drysdale(2020)](https://www.blackhillsinfosec.com/a-pentesters-voyage-the-first-few-hours/)
		* **Talks & Presentations**
			* [So you think you want to be a penetration tester - Defcon24](https://www.youtube.com/watch?v=be7bvZkgFmY)
				* So, you think you want to be a penetration tester, or you already are and don't understand what the difference between you and all the other "so called" penetration testers out there. Think you know the difference between a Red Team, Penetration Test and a Vulnerability assessment? Know how to write a report your clients will actually read and understand? Can you leverage the strengths of your team mates to get through tough roadblocks, migrate, pivot, pwn and pillage? No? well this talk is probably for you then! We will go through the fascinating, intense and often crazily boring on-site assessment process. Talk about planning and performing Red Teams, how they are different, and why they can be super effective and have some fun along the way. I'll tell you stories that will melt your face, brain and everything in between. Give you the answers to all of your questions you never knew you had, and probably make you question your life choices. By the end of this session you will be ready to take your next steps into the job you've always wanted, or know deep inside that you should probably look for something else. There will be no judgment or shame, only information, laughter and fun.
			* [So you want to be a pentester? - Hans-Michael Varbaek](https://speakerdeck.com/varbaek/so-you-want-to-be-a-pentester?slide=104)
				* This presentation gives the viewer an idea of what it is to be a pentester full-time, what a pentester typically works with, how to learn ethical hacking, and improving your chances of getting a full-time job.
			* [Certification? College?: How do you get into Cybersec really? - Doug White(WWHF2018)](https://www.youtube.com/watch?v=eljymhtIsDs)
				* Doug White talks about College options, Certifications, and what you need to do to break into the Cybersec field. How to start and move your career if you want to make a living, legally.
			* [Hold my Red Bull Undergraduate Red Teaming Jonathan Gaines](https://www.youtube.com/watch?v=9vgpqRzuvLk)
			* [What to Expect in an Ethical Hacking Interview - TheCyberMentor](https://www.youtube.com/watch?v=nrewE1mLlaU)
	* **Reverse Engineering**
		* [Reversing w/o reversing – how to become Alex in practice - hexacorn](http://www.hexacorn.com/blog/2019/04/11/reversing-w-o-reversing-how-to-become-alex-in-practice/)
		* [How to start RE/malware analysis? - hasherezade(2018)](https://hshrzd.wordpress.com/how-to-start/)
	* **Security Analyst**
		* [Security Analyst Workshop - Florian Roth(2019/3)](https://www.slideshare.net/FlorianRoth2/security-analyst-workshop-20190314)
	* **Security Engineer**
		* [So you want to be a security engineer? - Niru Ragupathy](https://medium.com/@niruragu/so-you-want-to-be-a-security-engineer-d8775976afb7)
		* [How to Secure Anything - Veeral Patel](https://github.com/veeral-patel/how-to-secure-anything)
			* How to systematically secure anything: a repository about security engineering
	* **Security Researcher**
		* [So you want to be a web security researcher? - James Kettle(2020)](https://portswigger.net/research/so-you-want-to-be-a-web-security-researcher)
	* **SRE**
		* [Google SRE Book - HTML version](https://landing.google.com/sre/sre-book/chapters/part1/)
		* [Do you have an SRE team yet? How to start and assess your journey - Google](https://cloud.google.com/blog/products/devops-sre/how-to-start-and-assess-your-sre-journey)
	* **Threat Intel**
		* [A Top 10 Reading List if You’re Getting Started in Cyber Threat Intelligence - Katie Nickels(2019)](https://medium.com/katies-five-cents/a-top-10-reading-list-if-youre-getting-started-in-cyber-threat-intelligence-c11a18fc9798)
	* **(Technical) Product & Project Managers**
		* [Technical Program Managers vs Product Managers vs Product Managers – Technical vs Engineering Managers - Mario Gerard(2018)](https://www.mariogerard.com/technical-program-managers-vs-product-managers-vs-product-managers-technical-vs-engineering-managers/)
* **CEOs**
	* [What Only the CEO Can Do - A. G. Lafley](https://hbr.org/2009/05/what-only-the-ceo-can-do)
	* [How CEOs Manage Time - Michael E. Porter, Nitin Nohria](https://hbr.org/2018/07/the-leaders-calendar)
	* [The CEO’s most important operational responsibility - Gokul Rajaram](https://medium.com/@gokulrajaram/designing-a-communication-architecture-the-ceos-most-important-operational-responsibility-28937bd291e8)
	* [Control fraud - Wikipedia](https://en.wikipedia.org/wiki/Control_fraud)
	* [How CEOs think - Robert Graham(2020)](https://blog.erratasec.com/2020/07/how-ceos-think.html)
* **Choosing a Job/Looking for Work**<a name="looking"></a>
	* [How to Get Any Job You Want (even if you’re unqualified) - Raghav Haran](https://www.huffpost.com/entry/how-to-get-any-job-you-want-even-if-youre-unqualified_b_5850fb7ee4b0b662c2fddeea)
	* [80+ Back Doors Into Cyber Careers - keirstenbrager](https://keirstenbrager.tech/80-back-doors-into-cyber-careers/)
	* [Common Sense Career Transitions - Celeste Thayer[DC206]](https://www.youtube.com/watch?v=tIb1776SoC8&feature=share)
		* Have you considered a tech career that was "above your pay grade"? What about a dream gig that you have few or - gasp - none of the basic qualifications for? Celeste will give you a few tips on how to identify skill gaps, then learn, network, and otherwise wrangle yourself into a job you wanted but never thought you could apply for, and have a better chance to pass the resume review stage.
	* [There Is No Shortage of Talent - There's a Shortage of Suckers - ResumeSkills.us](https://resumeskills.us/talent/shortage)
	* [Pushing Left, Like a Boss: Part 1 - SheHacksPurple](https://code.likeagirl.io/pushing-left-like-a-boss-part-1-80f1f007da95)
	* [The Secret Rules For Getting Hired - Terence Eden](https://shkspr.mobi/blog/2019/04/the-secret-rules-for-getting-hired/)
	* [How To Land A Job In Infosec](https://www.secjuice.com/getting-a-job-in-infosec/)
	* [How to Get a Programming Job without a Degree - Erik Dietrich](https://daedtech.com/programming-job-without-degree/)
	* **Startups**
		* [20 Questions To Ask Before Joining A Startup - Harrison Harnisch](https://hharnisc.github.io/2018/11/25/twenty-questions-to-ask-before-joining-a-startup.html)
		* [How to Choose a Startup to Work For by Thinking Like An Investor - Harj Taggar(TripleByte)](https://triplebyte.com/blog/how-to-choose-a-startup-to-work-for)
		* [Don’t waste your time in crappy startup jobs. - Michael O. Church(2012)](http://sasamat.xen.prgmr.com/michaelochurch/wp/2012/07/09/dont-waste-your-time-in-crappy-startup-jobs/)
* **Communication**
	* [SBAR - Wikipedia](https://en.wikipedia.org/wiki/SBAR)
		* SBAR is an acronym for Situation, Background, Assessment, Recommendation; a technique that can be used to facilitate prompt and appropriate communication.
* **Company/Org Culture**<a name="culture"></a>
	* **101**
		* [The Holloway Syllabus on Company Culture - Haley S. Anderson(2019)](https://www.holloway.com/s/syllabus-company-culture)
		* [American Cultural Assumption - wiki.c2.com](http://wiki.c2.com/?AmericanCulturalAssumption)
	* **Articles/Blogposts/Writeups**
		* [The Joel Test: 12 Steps to Better Code - Joel Spolsky](https://www.joelonsoftware.com/2000/08/09/the-joel-test-12-steps-to-better-code/)
		* [Containers Will Not Fix Your Broken Culture (and Other Hard Truths) - Complex socio-technical systems are hard; film at 11. - Bridget Kromhout](https://queue.acm.org/detail.cfm?id=3185224)
		* [How to Discourage Secretive Behavior From Members of Your Family/Team - kletische.com](https://kletische.com/discourage-secretive-behavior/)
		* [Developers don't need ping-pong tables - Koh Samui(2020)](https://sizovs.net/2020/03/26/developers-dont-need-ping-pong-tables/)
		* [Operational Thoughts in Trying Times - Carlos Perez(2020)](https://www.darkoperator.com/blog/2020/5/6/operational-thoughts-in-trying-times)
		* [How to handle Brent in The Phoenix Project - Allen Geer](allengeer.com/how-to-handle-brent-in-the-phoenix-project/)
		* [Geeks, MOPs, and sociopaths in subculture evolution - meaningness.com](https://meaningness.com/geeks-mops-sociopaths)
			* Also see [Entryism - Wikipedia](https://en.wikipedia.org/wiki/Entryism)
		* [Why Netflix CEO Reed Hastings once fired his co-founder via a PowerPoint - Zack Guzman](https://finance.yahoo.com/news/why-netflix-ceo-reed-hastings-once-fired-his-cofounder-with-a-power-point-125537309.html)
	* **Talks/Presentations/Videos**
		* [This is not fine - Surviving Cynicism and Building Happy Security Teams - Chris Deibler(BlueHat v18)](https://www.youtube.com/watch?v=YUwBja45fBQ)
			* [Slides](https://www.slideshare.net/MSbluehat/bhv18-keynote-this-is-not-fine-surviving-cynicism-and-building-happy-security-teams)
		* [Engineering Empathy: Adapting Software Engineering Principles and Process to Security - Craig Ingram, Camille Mackinnon](https://www.blackhat.com/us-20/briefings/schedule/index.html#engineering-empathy-adapting-software-engineering-principles-and-process-to-security-19659)
			* [Slides](http://i.blackhat.com/USA-20/Wednesday/us-20-Mackinnon-Engineering-Empathy-Adapting-Software-Engineering-Principles-And-Process-To-Security-2.pdf)
		* ["The Hard Parts of Open Source" by Evan Czaplicki(StrangeLoop2018)](https://www.youtube.com/watch?v=o_4EX4dPppA)
			* As more people enter /r/elm and the Elm discourse, I have thought a lot about how "online communities" work. Patterns of conflict. Why those patterns exist. Structures that would diffuse that conflict in healthy ways. Initially I just wanted to get yelled at less, but I instead stumbled upon "a cultural history of open source" that may reveal a path to more civil and productive online communication in general. Attendees will leave with (1) an inside perspective on open source projects, (2) a historical and cultural framework that I think can improve online communities right now, and (3) some interesting references and ideas to explore further in their own projects and interactions.
* **Compensation/Equity**<a name="comp"></a>
	* See 'Salary Negotiations' under interviewing
	* [H1B Salary Database - h1bdata.info](https://h1bdata.info/index.php)
	* [Compensation in 2019 New Grad Tech Offers - Jon Luca](https://blog.jonlu.ca/posts/tech-offers)
	* [How to Calculate and Communicate Your Desired Total Compensation - Danile Miessler](https://danielmiessler.com/blog/how-to-calculate-and-communicate-your-desired-compensation/)
	* [Equifax Could Be Selling Your Salary History. Here’s How To Protect It(2017 - Joel Winston)](https://www.fastcompany.com/40508924/equifax-could-be-selling-your-salary-history-heres-how-to-protect-it)
* **Conflict Resolution**
	* [Why We Can't Have Nice Things: Original Research on Conflict Resolution Styles in Information Security & Risk Management - Rachael Lininger(BSides LV2015)](https://www.irongeek.com/i.php?page=videos/bsideslasvegas2015/pg22-why-we-cant-have-nice-things-original-research-on-conflict-resolution-styles-in-information-security-risk-management-rachael-lininger)
		* Conflict can be a good thing, really. Without it, we get groupthink and dumbass decisions. But how we approach and resolve conflicts can make the difference between healthy conflict and an unproductive, frustrating fight. Why do we have so much of the latter? My graduate research on the conflict resolution style preferences of information security professionals sheds light on the “culture of no”: why infosec conflict so often results in fights, why we keep burning bridges to make a point, and why people can be unwilling to talk to us. More importantly, this research gives us ideas on how we can resolve conflicts without burning all the bridges" in other words, how we can begin to have nice things. (No hackers or statistics were harmed in this research.)
* **Consulting & Contracting(Independent Business)**<a name="contract"></a>
	* **About**
		* [Not A Full Timer: Slight difference from Pro to cattle - Mohamed Hayibor](https://mohamedhayibor.github.io/blog/post/Not-A-Full-Timer/)
			* A quick litmus test: if you’re getting paid by the hour. You’re not a full time employee. You’re a contractor.
		* [Entrepreneurial Adventures - Bryson Bort(DEF CON 28 Safe Mode Career Hacking Village )](https://www.youtube.com/watch?v=xyEEvxJKd5E)
			* So you’re not crazy, you just want to start your own company. Which kinda takes a level of crazy to pull it off. We’ll talk through what it takes to be an entrepreneur, ideation and the phases of startup, different kinds of companies (service, product, non-profit), how and why (or why not) to raise capital, types of investors, legal requirements, working (or not) with friends, challenges, building total/service addressable market size, back-office administration, employee benefits, equity, pricing, Intellectual Property Rights, economics, and resources for more information and networking. Will include anecdotes and insights of my experiences starting several companies and from multiple founders across the spectrum.
	* **Billing**
		* [Why A Billable Hours Model Does not Work in Consulting - firmsconsulting.com](https://www.firmsconsulting.com/quarterly/billable-hours-strategy-consulting/)
		* [Why You Should Charge Clients More Than You Think You’re Worth - Dorie Clark(HBR)](https://hbr.org/2017/10/why-you-should-charge-clients-more-than-you-think-youre-worth)
		* [How to Write a Statement of Work - Mary K Pratt](https://www.computerworld.com/article/2555324/how-to-write-a-statement-of-work.html)
	* **Building**
		* [How To Build Your Own Infosec Company - Mario Heiderich (BSides Lisbon 2018: Keynote)](https://www.youtube.com/watch?reload=9&v=UE5xS7-kFjE)
		* [How to build your own Infosec Company - Mario Heiderich(nullcon Goa2019)](https://www.youtube.com/watch?v=N2JG7qIlpi0&feature=youtu.be)
		* [Entrepreneurship for hackers - snyff(Christchurch CON 2019)](https://www.slideshare.net/snyff/entrepreneurship-for-hackers)
		* [How I Made $100,000 in a Month - TheCyberMentor](https://www.youtube.com/watch?v=dRTqRJsr1ss)
	* **Consulting**
		* [Successful Infosec Consulting 101 - Ted Demopoulos](https://www.sans.org/webcasts/successful-infosec-consulting-101-111885)
		* [Successful Infosec Consulting: Lessons from Three Decades in The Field - Ted Demopoulos](https://www.sans.org/webcasts/successful-infosec-consulting-lessons-decades-field-111890)
		* [Managing Client Relationships as an Investment Banker, Lawyer or Consultant - Jim Donovan(2015)](https://www.youtube.com/watch?v=z8kqCIxXTEw)
			* Goldman Sachs managing director and Law School adjunct professor Jim Donovan shares his insights on the skills necessary to manage and cultivate client relationships. Donovan is responsible for advising many of the largest corporate and individual clients of Goldman Sachs. (University of Virginia School of Law, Nov. 6, 2015)
	* **Contracts**
		* [Contract drafting for an engagement - Craig Wright(pen-test mailing list 2006)](https://seclists.org/pen-test/2006/May/246)
	* **Engaging Clients**
		* [Pre-Engagement Interactions - Sabtu(2017)](http://pentestdiary.blogspot.com/2017/08/pre-engagement-interactions.html)
		* [Pre-Engagement Interactions - @shai_saint](https://n00bpentesting.wordpress.com/lessons/ptes-101/pre-engagement-interactions/)
		* [Why Creators Should Move to Direct Support Monetization - Daniel Miessler(2020)](https://danielmiessler.com/blog/why-infosec-creators-should-move-to-direct-support-monetization/)
	* **Policies & Regulations**
		* [The SOC2 Starting Seven - Latacora Blog](https://latacora.micro.blog/2020/03/12/the-soc-starting.html)
			* Sage advice about SOC2 from Latacora.
	* **Scoping**
		* [Hacking Techniques & Intrusion Detection - Ali Al-Shemery](https://web.archive.org/web/20180613152827/http://opensecuritytraining.info/HTID_files/Day04-Scoping.pdf)
			* Guidance on preparing for an engagement.
* **Decision Making**
	* [Square Defangs Difficult Decisions with this System — Here’s How - Gokul Rajaram](https://firstround.com/review/square-defangs-difficult-decisions-with-this-system-heres-how/)
	* [$how Me the Money! (Getting Business Buy-in) - Carlota Sage(BSidesSLC 2020)](https://www.youtube.com/watch?v=kEWZXUpkn-Y&list=PLqVzh0_XpLfSJ2Okt38acDdO_xu2zKYmK&index=14&t=0s)
	* [Architecture decision record (ADR)](https://github.com/joelparkerhenderson/architecture_decision_record)
		*  Architecture decision record (ADR) examples for software planning, IT leadership, and template documentation 
* **Difficult Conversations**<a name="difficult"></a>
	* [Our 6 Must Reads for Cutting Through Conflict and Tough Conversations - firstround.com](https://firstround.com/review/our-6-must-reads-for-cutting-through-conflict-and-tough-conversations/)
	* [7 Tips for Difficult Conversations - Daisy Wademan Dowling(HBR)](https://hbr.org/2009/03/7-tips-for-difficult-conversat)
	* [How to Have Difficult Conversations When You Don’t Like Conflict - Joel Garfinkle(HBR)](https://hbr.org/2017/05/how-to-have-difficult-conversations-when-you-dont-like-conflict)
	* [Civilized Discourse… But How? - Jeff Atwood](https://www.heavybit.com/library/video/civilized-discourse-but-how/)
	* **Books**
		* [Difficult Conversations How to Discuss What Matters Most By Douglas Stone, Bruce Patton and Sheila Heen](https://www.penguinrandomhouse.com/books/331191/difficult-conversations-by-douglas-stone-bruce-patton-and-sheila-heen/9780143118442/)
* **Disagreement**
	* [How to Disagree - Paul Graham(2008)](http://www.paulgraham.com/disagree.html)
	* [My Twitter-Discussion-Deescalation Policy - Halvar Flake(2020)](https://addxorrol.blogspot.com/2020/08/my-twitter-discussion-deescalation.html)
	* [How to Fix the Co-Founder Fights You’re Sick of Having — Lessons from Couples Therapist Esther Perel](https://firstround.com/review/how-to-fix-the-co-founder-fights-youre-sick-of-having-lessons-from-couples-therapist-esther-perel/)
	* [Disagree and Commit: The Importance of disagreement in decision making - Simón Muñoz(2019)](https://hackernoon.com/disagree-and-commit-the-importance-of-disagreement-in-decision-making-b31d1b5f1bdc)
	* [Imago therapy - Wikipedia](https://en.wikipedia.org/wiki/Imago_therapy)
* **Employee Attrition**<a name="attrition">
	* [How To Keep Your Best Programmers - Erik Dietrich](https://daedtech.com/how-to-keep-your-best-programmers/)
	* [The Wetware Crisis: TEPES - Bruce Webster(2008)](http://brucefwebster.com/2008/01/10/the-wetware-crisis-tepes/)
	* [The Wetware Crisis: the Dead Sea effect - Bruce Webster](http://brucefwebster.com/2008/04/11/the-wetware-crisis-the-dead-sea-effect/)
	* [The Elves Leave Middle Earth – Sodas Are No Longer Free - Steve Blank](https://steveblank.com/2009/12/21/the-elves-leave-middle-earth-%E2%80%93-soda%E2%80%99s-are-no-longer-free/)
* **Employer References**
	* [State Laws on References and Statements By Former Employers - Barbara Kate Repa(Nolo.com)](https://www.nolo.com/legal-encyclopedia/free-books/employee-rights-book/chapter9-6.html)
* **Finance**
	* [Unit: Accounting and financial statements - Khan Academy](https://www.khanacademy.org/economics-finance-domain/core-finance/accounting-and-financial-stateme)
	* [Financial Statements: A Beginner's Guide - Tamiur Abdaal(2020)](https://www.causal.app/blog/whats-a-financial-statement)
* **General**<a name="general"></a>
	* [Mozilla Enterprise Information Security](https://infosec.mozilla.org/)
	* [Rating Infosec Relevant Masters Programs - netsecfocus](https://netsecfocus.com/training/development/certifications/2017/03/08/rating_infosec_masters.html)
	* [Career advice I wish I’d been given when I was young - 8000 Hours](https://80000hours.org/2019/04/career-advice-i-wish-id-been-given-when-i-was-young/)
	* [In Nobel Prize lecture, lessons for managing employee incentives - Kara Baskin(MIT Sloan)](https://mitsloan.mit.edu/ideas-made-to-matter/nobel-prize-lecture-lessons-managing-employee-incentives)
	* [The worst morale boosting gesture I've experienced - Terence Eden](https://shkspr.mobi/blog/2019/06/the-worst-morale-boosting-gesture-ive-experienced/)
	* [How to Identify an Immoral Maze - thezvi](https://thezvi.wordpress.com/2020/01/12/how-to-identify-an-immoral-maze/)
	* [How Software Groups Rot: Legacy of the Expert Beginner - Erik Dietrich](https://daedtech.com/how-software-groups-rot-legacy-of-the-expert-beginner/)
	* [Moral Mazes: Bureaucracy and Managerial Work - Robert Jackall](https://hbr.org/1983/09/moral-mazes-bureaucracy-and-managerial-work)
* **Hiring**<a name="hiring"></a>
	* [What I Learned Doing 250 Interviews at Google - Moishe Lettvin](https://www.youtube.com/watch?v=r8RxkpUvxK0)
	* [F*** You, I Quit — Hiring Is Broken - Sahat Yalkabov](https://medium.com/@evnowandforever/f-you-i-quit-hiring-is-broken-bb8f3a48d324)
	* [Hiring is Broken And Yours Is Too - RajivPrab.com](https://software.rajivprab.com/2019/07/27/hiring-is-broken-and-yours-is-too/amp/)
	* [In Head-Hunting, Big Data May Not Be Such a Big Deal - Adam Bryant](https://www.nytimes.com/2013/06/20/business/in-head-hunting-big-data-may-not-be-such-a-big-deal.html)
		* "This interview with Laszlo Bock, senior vice president of people operations at Google, was conducted and condensed by Adam Bryant."
	* [Here's Google's Secret To Hiring The Best People - Lazlo Bock(Wired - 2015)](https://www.wired.com/2015/04/hire-like-google/)
	* [Hiring is Broken… And It Isn’t Worth Fixing - Erik Dietrich](https://daedtech.com/hiring-is-broken/)
	* [A Players Don’t Hire A Players — They Partner with A Players - Erik Dietrich](https://daedtech.com/a-players-dont-hire-a-players-they-partner-with-a-players/)
	* [The Hiring Post - sockpuppet.org](https://sockpuppet.org/blog/2015/03/06/the-hiring-post/)
	* [On Secretly Terrible Engineers - Danny Crichton](https://techcrunch.com/2015/03/08/on-secretly-terrible-engineers/)
	* [Hiring and the market for lemons - Dan Luu](https://danluu.com/hiring-lemons/)
	* [Our 6 Must Reads for Onboarding Tactics That Help New Hires Succeed (and Stay) - FirstRoundReview](https://firstround.com/review/our-6-must-reads-for-onboarding-tactics-that-help-new-hires-succeed-and-stay/)
	* [Engineering Hiring - obvious.in](https://playbook.obvious.in/hiring/hiring-process/engineering-hiring)
* **Impostor Syndrome**<a name="imposter"></a>
	* [Would the real imposter please stand up? - Dr. Jessica Barker(SteelCon2016)](https://www.youtube.com/watch?v=tGyBFOWsFbk&feature=share)
	* [Dark Matter Developers: The Unseen 99%(2012) - Scott Hanselman](https://www.hanselman.com/blog/DarkMatterDevelopersTheUnseen99.aspx)
* **Informal Laws & Principles(and other things)**<a name="laws"></a>
	* [Akin's Laws of Spacecraft Design - David L. Akin](https://spacecraft.ssl.umd.edu/akins_laws.html)
	* [The Fallacy Of Chesterton’s Fence - Keith Lee](https://abovethelaw.com/2014/01/the-fallacy-of-chestertons-fence/)
		* If you think you can improve a policy or procedure in your office, first ask yourself: Are you falling victim to the fallacy of Chesterton's fence?
	* [Conway's Law - Wikipedia](https://en.wikipedia.org/wiki/Conway%27s_law)
	* [Dilbert Principle - Wikipedia](https://en.wikipedia.org/wiki/Dilbert_principle)
		* The Dilbert principle refers to a 1990s theory by Dilbert cartoonist Scott Adams stating that companies tend to systematically promote their least competent employees to management (generally middle management), to limit the amount of damage they are capable of doing.
	* [The Gervais Principle - RibbonFarm](https://www.ribbonfarm.com/the-gervais-principle/)
	* [Gervais Principle questioned: MacLeod’s hierarchy, the Technocrat, and VC startups - Michael O Church(2013)](http://sasamat.xen.prgmr.com/michaelochurch/wp/2013/02/19/gervais-principle-questioned-macleods-hierarchy-the-technocrat-and-vc-startups/)
	* [Golden Hammer - wiki.c2.com](http://wiki.c2.com/?GoldenHammer)
	* [Goodhart's law - Wikipedia](https://en.wikipedia.org/wiki/Goodhart%27s_law)
	* [Gresham’s Law: Why Bad Drives Out Good As Time Passes - Farnam Street](https://fs.blog/2009/12/mental-model-greshams-law/)
	* [HiPPO FAQ](https://exp-platform.com/hippo/)
		* Highest Paid Persons Opinion
	* [Induced demand - Wikipedia](https://en.wikipedia.org/wiki/Induced_demand)
	* [The Iron Law of Bureaucracy](https://www.jerrypournelle.com/reports/jerryp/iron.html)
		* Pournelle's Iron Law of Bureaucracy states that in any bureaucratic organization there will be two kinds of people":
			* `First, there will be those who are devoted to the goals of the organization. Examples are dedicated classroom teachers in an educational bureaucracy, many of the engineers and launch technicians and scientists at NASA, even some agricultural scientists and advisors in the former Soviet Union collective farming administration.`
			* `Secondly, there will be those dedicated to the organization itself. Examples are many of the administrators in the education system, many professors of education, many teachers union officials, much of the NASA headquarters staff, etc.`
		* The Iron Law states that in every case the second group will gain and keep control of the organization. It will write the rules, and control promotions within the organization.
	* [Law #8: The Law of Duality - ericsink.com](https://ericsink.com/laws/Law_08.html)
	* [No Silver Bullet - fmiljang.co.uk](http://www.fmjlang.co.uk/blog/NoSilverBullet.html)
	* [Parkinson's Law - Wikipedia](https://en.wikipedia.org/wiki/Parkinson%27s_law)
	* [Parkinson’s law: how constraints can create freedom - Anne-Laure](https://nesslabs.com/parkinson-law)
	* [Peter Principle - Wikipedia](https://en.wikipedia.org/wiki/Peter_principle)
		* The Peter principle is a concept in management developed by Laurence J. Peter, which observes that people in a hierarchy tend to rise to their "level of incompetence". In other words, employees are promoted based on their success in previous jobs until they reach a level at which they are no longer competent, as skills in one job do not necessarily translate to another. The concept was enunciated in the 1969 book The Peter Principle by Peter and Raymond Hull.
		* It was originally written as a satire.	
	* [Robustness Principle - Wikipedia](https://en.m.wikipedia.org/wiki/Robustness_principle)
	* [Simpson's paradox - Wikipedia](https://en.wikipedia.org/wiki/Simpson%27s_paradox)
	* [The Shirky Principle - Technium](https://kk.org/thetechnium/the-shirky-prin/)
		* “Institutions will try to preserve the problem to which they are the solution.” — Clay Shirky
	* [hacker-laws](https://github.com/dwmkerr/hacker-laws)
		* Laws, Theories, Principles and Patterns that developers will find useful.
* **Interview Prep**<a name="interview"></a>
	* **Articles/Blogposts/Writeups**
		* [The Hidden Flaw In Behavioral Interview Questions - Mark Murphy](https://www.forbes.com/sites/markmurphy/2014/12/03/the-hidden-flaw-in-behavioral-interview-questions)
		* [Tech Interview Handbook - yangshun.github.io](https://yangshun.github.io/tech-interview-handbook/)
		* [Ten Rules for Negotiating a Job Offer - Haseeb Qureshi](https://haseebq.com/my-ten-rules-for-negotiating-a-job-offer/)
		* [How Not to Bomb Your Offer Negotiation - Haseeb Qureshi](https://haseebq.com/farewell-app-academy-hello-airbnb-part-i/)
		* [Deploying Guerrilla Tactics to Combat Stupid Tech Interviews - Erik Dietrch](https://daedtech.com/deploying-guerrilla-tactics-combat-stupid-tech-interviews/)
		* [Preparing the SRE interview - balthazar-rouberol](https://blog.balthazar-rouberol.com/preparing-the-sre-interview)
	* **Interview Questions**
		* [Ask Me This Instead - Kendra Haberkorn](https://www.holloway.com/g/ask-me-this-instead/preview)
		* [test-your-admin-skills](https://github.com/trimstray/test-your-sysadmin-skills)
			*  A collection of \*nix Sysadmin Test Questions with Answers for Interview/Exam (2018 Edition).
		* [Linux System Administrator/DevOps Interview Questions - chassing](https://github.com/chassing/linux-sysadmin-interview-questions/blob/master/README.md)
		* [offensiveinterview - WebBreacher](https://github.com/WebBreacher/offensiveinterview)
			* Interview questions to screen offensive (red team/pentest) candidates
		* [test-your-admin-skills](https://github.com/trimstray/test-your-sysadmin-skills)
			*  A collection of \*nix Sysadmin Test Questions with Answers for Interview/Exam (2018 Edition).
		* [Security_Engineer_Interview_Questions - Tad Whitaker](https://github.com/tadwhitaker/Security_Engineer_Interview_Questions/blob/master/security-interview-questions)
		* [Application Security Engineer Interview Questions](https://github.com/security-prince/Application-Security-Engineer-Interview-Questions)
		* [Cyber Security and DFIR Interview Questions - kunwar-atul-hax0r.blogspot](https://kunwar-atul-hax0r.blogspot.com/2017/12/cyber-security-and-dfir-interview.html)
		* [web-sec-interview](https://github.com/zhaoweiho/web-sec-interview)
			*  Information Security (Web Security/Penetration Testing Direction) Interview Questions/Solutions 信息安全(Web安全/渗透测试方向)面试题/解题思路
		* [Network Security Engineer Interview Questions - jobinterviewquestions.com](https://www.jobinterviewquestions.com/information-security/network-security-engineer/page/2)
		* [what-happens-when](https://github.com/alex/what-happens-when)
			* An attempt to answer the age old interview question "What happens when you type google.com into your browser and press enter?"
		* [Interview Tips (Information Security) - jigerjain](https://github.com/jigerjain/Interview_Tips)
		* [fuck-coding-interviews](https://github.com/vinta/fuck-coding-interviews)
	* **Interview Questions**
		* [Reverse interview](https://github.com/viraptor/reverse-interview)
			* This is a list of questions which may be interesting to a tech job applicant. The points are not ordered and many may not apply to a given position, or work type. It was started as my personal list of questions, which grew over time to include both things I'd like to see more of and red flags which I'd like to avoid. I've also noticed how few questions were asked by people I interviewed and I think those were missed opportunities.
		* 4 categories of questions: Connect, Culture, Challenges, Close
			1. How did you come to work here? 
			2. What do you love most about working here?
			3. Tell me about the most successful hire and why?
			4. Who didn't succeed as a new hire and why?
			5. Tell me about the company's biggest challenge this year and how will this job help to solve it?
			6. How will I measure my performance so I know I'm having a positive impact?
			7. If there were some skills or experience that you wish I had, what would they be?
			8. What are the next steps in the process?
* **Interviewing**<a name="interviewing"></a>
	* **101**
		* [STAR Method Technique Interview Questions & Answers - Christian Eilers](https://zety.com/blog/star-method-interview)
	* **Experiences/Lessons Learned**
		* [What I Learned Doing 250 Interviews at Google - Moishe Lettvin](https://www.youtube.com/watch?v=r8RxkpUvxK0)
		* [What I Learned From Conducting 500 Technical Interviews, Pt. 1: The Interviewer Skills Ladder - Alex Allain](https://www.holloway.com/s/trh-what-i-learned-from-conducting-500-technical-interviews-part-1)
		* [After a lot more data, technical interview performance really is kind of arbitrary. - Aline Lerner](http://blog.interviewing.io/after-a-lot-more-data-technical-interview-performance-really-is-kind-of-arbitrary/)
		* [Get that job at Google - Steve Yegge(2008)](https://steve-yegge.blogspot.com/2008/03/get-that-job-at-google.html)
			* Sharing for context.
	* **'Culture Fit'**
		* [Raising the Bar - The Unconventional Interview Method That Really Works - socialtalent](https://www.socialtalent.com/blog/recruitment/raising-the-bar-unconventional-interview-method-really-works)
		* [The Trouble With "Culture Fit" - Rich Moy](https://www.stackoverflowbusiness.com/blog/the-trouble-with-culture-fit)
	* **Articles/Blogposts/Writeups**
		* [Guide to Guerilla Interviewing Discussion - C2](http://wiki.c2.com/?GuerrillaGuideToInterviewing)
		* [The Technical Interview is an Ego Trip - Kowsheek(2020)](https://blog.kowsheek.com/the-technical-interview-is-an-ego-trip/)
		* [The Horrifically Dystopian World of Software Engineering Interviews - jarednelsen.dev(2020)](https://www.jarednelsen.dev/posts/the-horrifically-dystopian-world-of-software-engineering-interviews/)
		* [The Joel Test: 12 Steps to Better Code - Joel Spolsky](https://www.joelonsoftware.com/2000/08/09/the-joel-test-12-steps-to-better-code/)
		* [The Rands Test - RandsinRepose](https://randsinrepose.com/archives/the-rands-test/)
			* It’s hard to pick a single best work by Joel Spolsky, but if I was forced to, I’d pick The Joel Test. It’s his own, highly irresponsible, sloppy test to rate the quality of software, and when anyone asks me what is wrong with their team I usually start by pointing the questioner at the test. Start here.  It’s a test with 12 points and as Joel says, “A score of 12 is perfect, 11 is tolerable, but a 10 or lower and you’ve got serious problems”. More important than the points, his test clearly documents what I consider to be healthy aspects of an engineering team, but there are other points to be made. So it is completely an homage to Joel that I offer The Rands Test.
	* **Salary Negeotiation**
		* [Salary Negotiation: Make More Money, Be More Valued - Patrick McKenzie](https://www.kalzumeus.com/2012/01/23/salary-negotiation/)
		* [The Holloway Guide to Equity Compensation](https://www.holloway.com/g/equity-compensation)
			* Stock options, RSUs, job offers, and taxes—a detailed reference, including hundreds of resources, explained from the ground up and made to be improved over time.
		* [Salary strategies everyone in tech already knows — but you don't - Candor](https://teamcandor.com/salary/guide/)
		* [Ten Rules for Negotiating a Job Offer - Haseeb Qureshi](https://haseebq.com/my-ten-rules-for-negotiating-a-job-offer/)
		* [Negotiating Pattern Language - wiki.c2.com](http://wiki.c2.com/?NegotiatingPatternLanguage)
		* [Salary Negotiations: Win by Losing - Erik Dietrich](https://daedtech.com/salary-negotiations-win-by-losing/)
		* [10 essential negotiation tactics CISOs should know - Mary K Pratt](https://www.csoonline.com/article/3564515/10-essential-negotiation-tactics-cisos-should-know.html)	
	* **Talks**
		* [Nose Breathing 101: A Guide to Infosec Interviewing - Wartortell, Aaron Bayles](https://www.irongeek.com/i.php?page=videos/derbycon6/504-nose-breathing-101-a-guide-to-infosec-interviewing-wartortell-and-aaron-bayles)
			* The Information Security sector is a special place filled with special snowflakes. For a special snowflake, interviewing for a job can sometimes be a daunting or awkward task. There is a thin line when talking to humans between looking cocky and potato. On the other side, the interviewer must understand that there's a limited pool of special snowflakes. There's a sweet spot between auto-hiring someone and telling them you'll need three months to make a decision. Each snowflake must be nurtured into a beautiful snowerfly, or whatever their final form may be. For this talk I plan to start a conversation about how to interview and be interviewed in the information security space. Good interviews combine a mix of targeted questions, appropriate information sharing, and a goal of what you'd like to learn from a person and vice versa. Bad interviews... don't. This leads to bad hires, good snowflakes being pushed aside, stupid questions being asked, people being sad pandas, poor team cohesion, and a general overwhelming feeling of meh. Do not despair, this is a solvable situation. Come join me on the journey to being less meh at hiring!
* **Letter of Recommendation**
	* [“Model of a Letter of Recommendation of a Person You Are Unacquainted with.” - Benjamin Franklin(1777)](https://founders.archives.gov/documents/Franklin/01-23-02-0365)
* **Loyalty**
	* [Loyalty and Layoffs - David Brady](https://whydavewhy.com/2013/08/16/loyalty-and-layoffs/)
* **Management**<a name="mgmt"></a>
	* **101**
		* [HN Comment by walterbell on understanding management](https://news.ycombinator.com/item?id=8881752)
		* [The Manager FAQ - Peter Seebach](http://www.seebs.net/faqs/manager.html)
			* The following list is an attempt to cover some of the issues that will invariably come up when hackers without previous experience of the business community first start working in it. Other workers may also find it informative.
		* [Choosing the Management Track - blog.danielna.com](https://blog.danielna.com/choosing-the-management-track/)
	* **Getting Better**
		* ManagerTools
		* [re:Work - Management@Google](https://rework.withgoogle.com/subjects/managers/)
	* **Metrics**
		* [Objectives and Key Results(OKR) - Wikipedia](https://en.wikipedia.org/wiki/OKR)
		* [OKRs: The Fundamentals - niket](https://medium.com/startup-tools/okrs-5afdc298bc28)
		* [Management by objectives - Wikipedia](https://en.wikipedia.org/wiki/Management_by_objectives)
		* [Objectives, Goals, Strategies, and Measures - Wikipedia](https://en.wikipedia.org/wiki/OGSM)
		* [SMART criteria - Wikipedia](https://en.wikipedia.org/wiki/SMART_criteria)
		* [The Beginner's Guide to OKRs - Felipe Castro](https://felipecastro.com/en/okr/what-is-okr/)
	* **Things to know/be aware of**
		* [Up Or Out: Solving The IT Turnover Crisis - Alex Papadimoulis](http://thedailywtf.com/articles/Up-or-Out-Solving-the-IT-Turnover-Crisis)
		* [The Wetware Crisis: the Dead Sea effect - Bruce F. Webster](http://brucefwebster.com/2008/04/11/the-wetware-crisis-the-dead-sea-effect/)
		* [The Tyranny of Structurelessness - Jo freeman](https://www.jofreeman.com/joreen/tyranny.htm)
		* [Vitality Curve](https://en.m.wikipedia.org/wiki/Vitality_curve)
		* [Servant leadership - Wikipedia](https://en.wikipedia.org/wiki/Servant_leadership)
		* ["The Loser" - Warning Signs You're Dating a Loser - Joseph M. Carver](https://www.drjoecarver.com/clients/49355/File/IdentifyingLosers.html)
		* [Sick Systems: How to Keep Someone With You Forever - issendai](http://www.issendai.com/psychology/sick-systems.html)
			* Things to look out for/be aware of.
	* **Industry**
		* [Cybersecurity, The C-Suite, & The Boardroom: The Rising Specter Of Director & Officer Liability - Tom Kulik](https://abovethelaw.com/2019/10/cybersecurity-the-c-suite-the-boardroom-the-rising-specter-of-director-officer-liability/)
		* [About Cybersecurity Management and Expectations - Leslie Carhart(2020)](https://tisiphone.net/2020/10/27/about-cybersecurity-management-and-expectations/)
* **Management Skills**<a name="mgmt"></a>
	* [Managers - rework.withgoogle.com](https://rework.withgoogle.com/subjects/managers/)
	* [Manager Tools](https://www.manager-tools.com/)
	* [31 Core Competencies Explained - Edward J. Cripe](https://www.workforce.com/2002/09/03/31-core-competencies-explained/)
	* [Radical Candor — The Surprising Secret to Being a Good Boss - FirstRoundReview](https://firstround.com/review/radical-candor-the-surprising-secret-to-being-a-good-boss/)
	* [The Power of Performance Reviews: Use This System to Become a Better Manager - Lenny Rachitsky](https://firstround.com/review/the-power-of-performance-reviews-use-this-system-to-become-a-better-manager/)
	* [The Indispensable Document for the Modern Manager - FirstRoundReview](https://firstround.com/review/the-indispensable-document-for-the-modern-manager/)
	* [The Eng Team Handbook (eng-handbook)](https://github.com/raylene/eng-handbook)
		* A developer's guide to management: an open-sourced handbook for leading engineering teams
* **Marketing**
	* [Marketing-for-Engineers](https://github.com/LisaDziuba/Marketing-for-Engineers)
		* A curated collection of marketing articles & tools to grow your product.
* **Meetings**<a name="meetings"></a>
	* [Reaching Peak Meeting Efficiency: Meetings are a critical tool for building a diverse, high-performance team with shared values - Steven Sinofsky](https://medium.learningbyshipping.com/reaching-peak-meeting-efficiency-f8e47c93317a)
	* [Maker's Schedule, Manager's Schedule - Paul Graham(2009)](http://www.paulgraham.com/makersschedule.html)
	* [How to Design an Agenda for an Effective Meeting - Roger Schwarz(HBR)](https://hbr.org/2015/03/how-to-design-an-agenda-for-an-effective-meeting)
	* [How To Run EPIC Meetings - Julia Felton(2020)](https://leadchangegroup.com/how-to-run-epic-meetings/)
* **Mental Health**<a name="mentalh"></a>
	* **General**
		* [USA Mental Health First Aid](https://www.mentalhealthfirstaid.org/)
		* [National Alliance on Mental Illness](https://www.nami.org/#)
		* [Mental Health Hackers](https://www.mentalhealthhackers.org/)
		* [Laziness Does Not Exist - But unseen barriers do - Devon Price](https://medium.com/@devonprice/laziness-does-not-exist-3af27e312d01)
		* [#44CON: Establishing a Mental Health Toolbox - Dan Raywood](https://www.infosecurity-magazine.com/news/44con-mental-health-toolbox/)
		* [Sick Systems: How to Keep Someone With You Forever - issendai](http://www.issendai.com/psychology/sick-systems.html)
		* [Spoon theory - Wikipedia](https://en.wikipedia.org/wiki/Spoon_theory)
		* [How to Be Kind to Yourself & Still Get Stuff Done - Leo Babauta](https://zenhabits.net/kind-done/)
		* [Morale, Mental Health, and Burnout in Remote Teams - Holloway](https://www.holloway.com/g/remote-work/sections/morale-mental-health-and-burnout-in-remote-teams)
	* **Abusive Behaviour**
		* [Sick systems: How to keep someone with you forever - Issendai](https://issendai.livejournal.com/572510.html)
		* [14 Thought-Control Tactics Narcissists Use to Confuse and Dominate You -  Dan Neuharth(2017)](https://www.psychcentral.com/blog/narcissism-decoded/2017/09/14-thought-control-tactics-narcissists-use-to-confuse-and-dominate-you)
	* **Burnout**
		* [13 Surprising Signs of Burnout You May Be Missing - thriveglobal](https://thriveglobal.com/stories/13-surprising-signs-of-burnout-you-may-be-missing/)
		* [Burnout and the Brain - Alexandra Michel(psychologicalscience.org)](https://www.psychologicalscience.org/observer/burnout-and-the-brain)
		* [The Maslach Burnout Inventory Manual - Christina Maslach, Michael P. Leiter, Susan E. Jackson](https://www.researchgate.net/publication/277816643_The_Maslach_Burnout_Inventory_Manual)
		* [When Passion Leads to Burnout - Jennifer Moss](https://hbr.org/2019/07/when-passion-leads-to-burnout)
		* [Managing Burnout - TaoSecurity](https://taosecurity.blogspot.com/2018/12/managing-burnout.html)
		* [Only race cars should burnout - Brett Shavers](https://brettshavers.com/brett-s-blog/entry/only-race-cars-should-burnout)
	* **Depression**
		* [Living with Depression in Tech - Jonathan Zdziarski](https://www.zdziarski.com/blog/?p=7437)
		* [The Only Thing You Cant Fix Is Killing Yourself - notdan](https://medium.com/@notdan/the-only-thing-you-cant-fix-is-killing-yourself-da8b555a99f1)
	* **Suicide**
		* [Suicide Risk Assessment and Intervention Tactics - Amber Baldet(Defcon21)](https://media.defcon.org/DEF%20CON%2021/DEF%20CON%2021%20video%20and%20slides/DEF%20CON%2021%20Hacking%20Conference%20Presentation%20By%20Amber%20Baldet%20-%20Suicide%20Risk%20Assessment%20and%20Intervention%20Tactics%20-%20Video%20and%20Slides.m4v)
			* [Slides](https://www.defcon.org/images/defcon-21/dc-21-presentations/Baldet/DEFCON-21-Baldet-Suicide-Intervention-Risk-Assessment-Tactics-Updated.pdf)
	* **Stress**
		* [Stress management - Mayo Clinic](https://www.mayoclinic.org/healthy-lifestyle/stress-management/in-depth/stress/art-20046037)
		* [Understanding chronic stress - American Psychological Association](https://www.apa.org/helpcenter/understanding-chronic-stress)
		* [Chronic Stress and a Life: How Stress Almost Killed Me - Sergio Caltagirone](http://www.activeresponse.org/chronic-stress-and-a-life-how-stress-almost-killed-me/)
	* **Talks**
		* [Hackers, Hugs, & Drugs: Mental Health in Infosec - Amanda Berlin(Derbycon2018)](https://www.irongeek.com/i.php?page=videos/derbycon8/track-1-03-hackers-hugs-drugs-mental-health-in-infosec-amanda-berlin)
		* [Playing Through Pain: The Impact of Secrets and Dark Knowledge - Richard Thieme(Defcon24)](https://www.youtube.com/watch?v=yGrcHhfUZDk)
			* Dismissing or laughing off concerns about what it does to a person to know critical secrets does not lessen the impact when those secrets build a different map of reality than "normals" use and one has to calibrate narratives to what another believes. The cognitive dissonance that inevitably causes is managed by some with denial who live as if refusing to feel the pain makes it disappear. But as Philip K. Dick said, reality is that which, when you no longer believe in it, refuses to go away. And when cognitive dissonance evolves into symptoms of traumatic stress, one ignores those symptoms at one's peril. But the constraints of one's work often make it impossible to speak aloud about those symptoms, because that might threaten one's clearances, work, and career. The real cost of security work and professional intelligence goes beyond dollars. It is measured in family life, relationships, and mental and physical well-being. The divorce rate is as high among intelligence professionals as it is among medical professionals, for good reason - how can relationships be based on openness and trust when one's primary commitments make truth-telling and disclosure impossible? Richard Thieme has been around that space for years. He has listened to people in pain because of the compelling necessities of their work, the consequences of their actions, the misfiring of imperfect plans, and the burdens of - for example - listening to terrorists slit someone's throat in real time, then having to act as if they had a normal day at the office. Thieme touched on some of this impact in his story, "Northward into the Night," published in the Ranfurly Review, Big City Lit, Wanderings and Bewildering Stories before collection in "Mind Games." The story illuminates the emotional toll of managing multiple personas and ultimately forgetting who you are in the first place. The bottom line is, trauma and secondary trauma have identifiable symptoms and they are everywhere in the "industry." The "hyper-real" space which the national security state creates by its very nature extends to normals, too, now, but it's more intense for professionals. Living as "social engineers," always trying to understand the other's POV so one can manipulate and exploit it, erodes the core self. The challenge is not abstract or philosophical, it's existential, fired into our faces every day at point blank range, and it constitutes an assault on authenticity and integrity. Sometimes sanity is at stake, too, and sometimes, life itself. In one week, two different people linked to the CIA told Thieme that going into that agency was like becoming a scientologist. Think about what that analogy means. For his own sake and sanity, Thieme has thought about it a lot and that's what this talk is about - the real facts of the matter and strategies for effective life-serving responses.
		* [The Road to Resilience How Real Hacking Redeems a Damnable Profession - Richard Thieme(Defcon26)](https://www.youtube.com/watch?v=WHpFSIYlVoc)
			* Two years ago Richard Thieme spoke on “Playing Through the Pain: The Impact of Dark Knowledge on Security and Intelligence Professionals” for Def Con 24. He relied on dozens of experiences provided by colleagues over a quarter-century, colleagues from NSA, CIA, corporate, and military. Responses to the presentation have often been emotional and have corroborated his thesis. The real impact of this work on people over the long term has to be mitigated by counter-measures and strategies so scars can be endured or,even better,incorporated and put to use.  In this presentation, Thieme elaborates those strategies and counter-measures. In what is likely his final speech at Def Con, he speaks directly to the “human in the machine” AS a human being. It’s not about leaving the profession: it’s about what we can do to thrive and transcend the challenges. It‘s about “saving this space,” this play space of hacking, work and life, and knowing the cost of being fully human while encountering dehumanizing impacts.  It is easier to focus on exploits, cool tools, zero days, and the games we play in the space that “makes us smile.” It is not so easy to know how to play through the pain successfully. The damage to us does not show up in brain scans. It shows up in our families, our relationships, and our lives.  Thieme is not preaching, he is sharing insights based on what he too has had to transcend in his own life. They call a lot of us “supernormals,” which means we discovered resilient responses to deprivation, abuse, profound loss … or the daily challenges of work that makes clear that evil is real. We are driven, we never quit, we fight through adversity, we create and recreate personas that work, we do what has to be done. It pays to know how we do that and know THAT we know so we can recreate resilience in the face of whatever comes our way.   A contractor for NSA suggested that everyone inside the agency should see the video of “Playing Through the Pain.” A long-time Def Con attendee asks all new hires to watch “Staring into the Abyss,” a talk Thieme did a few years before. This subject matter is seldom discussed aloud “out here” and by all accounts is not taken seriously “inside,” which is perhaps why there have been half a dozen suicides lately at NSA and a CIA veteran said, “I have 23 suicides on my mind, the most recent senior people who could not live with what they knew.”  The assumption baked into this talk: real hacking, its ethos and its execution, provides the tools we need to do this damn thing right.
* **Mentoring**<a name="mentor"></a>
	* [How to get coaching, mentoring, and attention - Jake Seliger](https://jakeseliger.com/2010/10/02/how-to-get-your-professors%E2%80%99-attention-or-how-to-get-the-coaching-and-mentorship-you-need/)
	* [How to Be a Career-Changing Mentor — 25 Tips From The Best Mentors We Know - FirstRoundReview](https://firstround.com/review/how-to-be-a-career-changing-mentor-25-tips-from-the-best-mentors-we-know/)
	* [How to Initiate Contact With a Mentor - Daniel Miessler(2020)](https://danielmiessler.com/blog/how-to-initiate-first-contact-with-a-mentor/)
	* [Learning through Mentorship -  Michael Ortega, Magen Wu(Derbycon2015)](https://www.irongeek.com/i.php?page=videos/derbycon5/teach-me04-learning-through-mentorship-michael-ortega-magen-wu)
		* 'Try Harder', 'Lurk Moar', 'You're doing it wrong'. In the InfoSec community, we pride ourselves on being able to learn on our own and believe going through a 'trial by fire' is necessary in order to be a respected and established in the community. What we don't realize is, we have many opportunities to better guide each other and learn from one another in order to improve...but are we making the best use of those opportunities? In this talk, we will explore the benefits of mentoring based on research we gathered and using data collected from within our industry. We will also discuss what makes a good mentor/mentee and how to get the most out of the relationship to help one another-and the community-grow.
	* [ How to Give the Gift That Keeps on Giving - Your Knowledge - Jason Blanchard(Derbycon 2019)](https://www.irongeek.com/i.php?page=videos/derbycon9/2-15-how-to-give-the-gift-that-keeps-on-giving-your-knowledge-jason-blanchard)
		* Do you attend InfoSec talks, watch InfoSec webcasts, read InfoSec blogs, and follow your favorite InfoSec knowledge-sharers on Twitter? Do you want to learn how to share the knowledge in your brain in ways people want to hear it? Yes! Then this is the talk for you. Jason will give you the knowledge to confidently share what you know with people who don't know it. This talk will inspire you to create your own blog, give your own webcasts and presentations, or launch a podcast so that the next generation will be prepare for the what's to come. There will be demos and actionable content, so you'll know what to do to get started.
* **Metrics**<a name="metrics"></a>
	* [Be Careful What You Measure - Mark Graham Brown](https://corporater.com/en/the-chicken-kpi-be-careful-of-what-you-measure/)
	* [How to Use Metrics - George K. Campbell(2006)](https://www.csoonline.com/article/2120344/how-to-use-metrics.html)
	* [Security metric techniques: How to answer the 'so what?' - Bill Brenner](https://www.csoonline.com/article/2125789/security-metric-techniques--how-to-answer-the--so-what--.html)
	* [Security Value Made Visible: How American Water's Bruce Larson uses a simple metric to build bridges with business partners and justify security spending at the same time - Scott Berinato](https://www.csoonline.com/article/2120656/security-value-made-visible.html)
	* [A key performance indicator for infosec organizations: Using probabilistic risk KPIs to direct complex risk engineering efforts - Ryan McGeehan(2019)](https://medium.com/starting-up-security/a-key-performance-indicator-for-infosec-organizations-7f654b7cd256)
	* [Security Metrics: Critical Issues - Derek Slater(2012)](https://www.csoonline.com/article/2123361/security-metrics--critical-issues.html)
* **Networking**<a name="network"></a>
	* [That’s still not my RJ 45 Jack - IRL Networking for Humans Pt 2 - Johnny Xmas](https://www.irongeek.com/i.php?page=videos/converge2015/%22track112-how-to-dress-like-a-human-being-irl-networking-for-humans-pt-2-johnny-xmas%22)
		* We're smart. We're incredibly tech savvy. We can rock some mad OSINT with our Google-Fu. We're 85% +-10% sure which part of the body a hat goes on. We think you can never have enough beard. WE THINK THAT'S ACCEPTABLE. The second in his multi-part series on building social prowess, this talk will focus on the inconvenient truth of your book always, always, always being judged by its cover, and how to deal with that with minimal effort so you can get back to sewing more pockets on your utilikilt. This talk covers both male and female situations, though it is primarily unisex. We'll get you set up with a core wardrobe and hygenic skillset so you'll be able to roll out of bed, spend minimal time "getting ready," rock the dreaded client-facing meeting or industry meetup, and get you back home where you can safely take your pants off.
* **Non-Competes**<a name="noncomp"></a>
	* [Why I Turned Down an AWS Job Offer  - Corey Quinn](https://www.lastweekinaws.com/blog/why-i-turned-down-an-aws-job-offer/)
* **Normalization of Deviance**
	* [The normalization of deviance in healthcare delivery - John Banja](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2821100/)
	* [Bedford and the Normalization of Deviance - Ron Rapp](https://www.rapp.org/archives/2015/12/normalization-of-deviance/)
	* [Resilience In Complex Adaptive Systems - Richard Cook(Velocity NY 2013)](https://www.youtube.com/watch?v=PGLYEDpNu60)
	* [Normalization of deviance - Dan Luu](https://danluu.com/wat/)
	* [Resilience Engineering: Part I - Kitchen Soap](https://www.kitchensoap.com/2011/04/07/resilience-engineering-part-i/)
* **Non-Technical Skills**<a name="non-tech"></a>
	* [Relearning the Art of Asking Questions - HBR](https://hbr.org/2015/03/relearning-the-art-of-asking-questions)
	* [How To Ask Questions The Smart Way - Eric Raymond](http://www.catb.org/esr/faqs/smart-questions.html)
* **Offices**
	* [The History of Office Design - k2space](https://k2space.co.uk/knowledge/history-of-office-design/)
* **Organizational Theory/Stuff about Organizations**<a name="orgtheory"></a>
	* [Organizational Theory - Wikipedia](https://en.wikipedia.org/wiki/Organizational_theory)
	* [Bureaucratic drift - Wikipedia](https://en.wikipedia.org/wiki/Bureaucratic_drift)
	* [Why are large companies so difficult to rescue (regarding bad internal technology) - Lawrence Krubner](http://www.smashcompany.com/business/why-are-large-companies-so-difficult-to-rescue-regarding-bad-internal-technology)
	* [Leverage Points: Places to Intervene in a System - Donella Meadows](http://donellameadows.org/archives/leverage-points-places-to-intervene-in-a-system/)
	* [How Software Companies Die - Orson Scott Card](http://www.call-with-current-continuation.org/rants/how-companies-die.txt)
	* [Accountability Theatre - Harry Stottle](https://harrystottle.wordpress.com/2016/09/04/accountability-theatre/)
	* [Images of Organization - Wikipedia](https://en.wikipedia.org/wiki/Images_of_Organization)
	* [Theory of the firm: Managerial behavior, agency costs and ownership structure - Michael C.Jensen, William H.Meckling](https://www.sciencedirect.com/science/article/pii/0304405X7690026X)
	* [The Tyranny of Structurelessness - Jo Freeman](https://www.jofreeman.com/joreen/tyranny.htm)
	* [The Eight Metaphors of Organization - Venkatesh Rao(2010)](https://www.ribbonfarm.com/2010/07/13/the-eight-metaphors-of-organization/)
		* "Gareth Morgan’s Images of Organization is a must-read for those who want to develop a deeper understanding of a lot of the stuff I talk about here. Though I’ve cited the book lots of times, it is one of those dense, complex books that I am never going to attempt to review or summarize. You’ll just have to read it. But I figured since I refer to it so much, I need at least a simple anchor post about it. So I thought I’d summarize the main idea with a picture, and point out some quick connections to things I have written/plan to write."
	* [Inverse Conway Maneuver - thoughtworks.com](https://www.thoughtworks.com/radar/techniques/inverse-conway-maneuver)
		* The 'Inverse Conway Maneuver' recommends evolving your team and organizational structure to promote your desired architecture. Ideally your technology architecture will display isomorphism with your business architecture.
* **Performance Reviews**<a name="perf-review"></a>
	* [A Beginner’s Guide to Giving Performance Reviews - Advice for new managers on the most effective way to deliver feedback(Rebecca Fishbein)](https://medium.com/s/story/a-beginners-guide-to-giving-performance-reviews-963aba23bd)
* **Personal Safety**
	* [Top Warning Signs of Domestic Abuse - Buddy-T(2020)](https://www.verywellmind.com/signs-someone-is-being-abused-66535)
	* [Signs of a Stalker: Are You Being Followed? - Brianne Sandorf(2019)](https://www.asecurelife.com/signs-of-a-stalker/)
* **Presenting**
	* [Presentation and Social Media tips with SheHacksPurple](https://www.youtube.com/watch?v=wDHliJ2qH_c)
	* [More Tips for Social Media and Presenting - SheHacksPurple](https://medium.com/@shehackspurple/more-tips-for-social-media-and-presenting-a887062eda57)
	* [How to Look and Sound Confident During a Presentation - Carmine Gallo](https://hbr.org/2019/10/how-to-look-and-sound-confident-during-a-presentation)
	* [Make your PowerPoint presentations accessible to people with disabilities - support.office.com](https://support.office.com/en-us/article/make-your-powerpoint-presentations-accessible-to-people-with-disabilities-6f7772b2-2f33-4bd2-8ca7-dae3b2b3ef25)
		* This topic gives you step-by-step instructions to make your PowerPoint presentations accessible to people with disabilities.
* **Post-Mortems**<a name="postmort"></a>
	* [A List of Post-mortems! - Dan Luu](https://github.com/danluu/post-mortems)
* **Product Managemnt**
	* [Product Management 101: The Product Lifecycle - Anand Subramani, Jiaona Zhang(Stanford)](http://learn.stanford.edu/Product-Mngmt-WBN-On-Demand.html)
* **Project Management**<a name="projm"></a>
	* [Anatomy of a runaway IT project - Bruce F. Webster](http://brucefwebster.com/2008/06/16/anatomy-of-a-runaway-it-project/)
	* [Why “Agile” and especially Scrum are terrible - Michael O. Church](https://michaelochurch.wordpress.com/2015/06/)
		* [Article Comments](https://michaelochurch.wordpress.com/2015/06/06/why-agile-and-especially-scrum-are-terrible/#comments)
	* [Minimal Project Management - Hilton Lipschitz](https://hiltmon.com/blog/2016/03/05/minimal-project-management/)
	* [Multiply by Pi - David Strom](https://strom.wordpress.com/2008/03/26/multiply-by-pi/)
	* [Project Management Tips and Tricks - Quang Truong(2020)](https://knowledgevault-sharing.blogspot.com/2020/05/project-management-tips-and-tricks.html)
	* [5 Ways to Manage Scope Creep - marketingmatters.net(2013)](https://marketingmatters.net/increase-productivity-by-decreasing-scope-creep/)
	* [Shape Up: Stop Running in Circles and Ship Work that Matters - Basecamp](https://basecamp.com/shapeup)
		* Shape Up is for product development teams who struggle to ship. Full of eye-opening insights, Shape Up will help you break free of "best practices" that aren't working, think deeper about the right problems, and start shipping meaningful projects.
* **Remote Work**
	* [awesome-remote-job](https://github.com/lukasz-madon/awesome-remote-job)
		* A curated list of awesome remote jobs and resources.
	* [All Remote - Gitlab](https://about.gitlab.com/company/culture/all-remote/)
	* [Gitlab Team Handbook](https://about.gitlab.com/handbook/)
	* [A Decade of Remote Work - Viktor Petersson](https://blog.viktorpetersson.com/remote-work/2019/05/18/a-decade-of-remote.html)
	* [Remote Work Guides - Twist](https://twist.com/remote-work-guides/)
	* [Tips from 16 years of working from home - a.wholelottanothing.org](https://a.wholelottanothing.org/2019/08/09/tips-from-16-years-of-working-from-home/)
	* [A Year of Working Remotely - mikeindustries.com](https://mikeindustries.com/blog/archive/2019/08/a-year-of-working-remotely)
	* [Why Working from Home is Good for Business - Mat Mullenweg](https://www.ted.com/talks/matt_mullenweg_why_working_from_home_is_good_for_business)
		* As the popularity of remote working continues to spread, workers today can collaborate across cities, countries and even multiple time zones. How does this change office dynamics? And how can we make sure that all employees, both at headquarters and at home, feel connected? Matt Mullenweg, cofounder of Wordpress and CEO of Automattic (which has a 100 percent distributed workforce), shares his secrets.
	* [Remote Work - Zapier](https://zapier.com/learn/remote-work/)
		* Beginning as a series of posts on the Zapier blog, this book is an ongoing work about our experiences as a remote team, with much of the book written by Zapier CEO Wade Foster along with chapters from our team members and other remote employees. We'll update it periodically so you can learn how our thinking and processes change as we've grown from three to 200+ people and beyond, and we'll keep the older versions of each chapter archived so you can learn with us over time.
	* [How Remote Workers Make Work Friends - Beth SchinoffBlake E. AshforthKevin Corley(HBR)](https://hbr.org/2019/11/how-remote-workers-make-work-friends)
	* [The tools and tricks that let Ars Technica function without a physical office - Lee Hutchinson(2020)](https://arstechnica.com/information-technology/2020/01/no-office-no-problem-how-ars-technicas-remote-workers-work/)
* **Resume**<a name="resume"></a>
	* [17 things that make this the perfect résumé - Áine Cain and Shayanne Gal(BusinessInsider)](https://www.businessinsider.com/why-this-is-an-excellent-resume-2013-11)
	* [résumés - PracticalTypography](https://practicaltypography.com/resumes.html)
	* [Become a Software Specialist with the Help of Your Resume - Erik Dietrich](https://daedtech.com/become-software-specialist-help-resume/)
	* [How to Prepare Your Resume (Your Resume Stinks!) (Hall Of Fame Guidance) - ManagerTools](https://www.manager-tools.com/2005/10/your-resume-stinks)
	* [Resume Update 2019 - Part 1 - ManagerTools](https://www.manager-tools.com/2019/06/resume-update-2019-part-1)
	* [Impossible is Nothing - Resume](https://en.m.wikipedia.org/wiki/Impossible_Is_Nothing_(video_r%C3%A9sum%C3%A9))
	* [How to document your knowledge (in a CV/resume) - Gynvael Coldwind(20202)](https://gynvael.coldwind.pl/?id=728)
	* [JSON Resume](https://github.com/jsonresume)
		* A community driven open source initiative to create a JSON based standard for resumes
	* [Cybersecurity engineer resume tips - Frank Siemons](https://resources.infosecinstitute.com/category/cybersecurity-careers/how-to-become-a-cybersecurity-engineer/cybersecurity-engineer-resume-tips/)
* **Skill Development**
	* [Expiring vs. Permanent Skills - Morgan Housel(2020)](https://www.collaborativefund.com/blog/expiring-vs-permanent-skills/)
* **Social Skills**
	* [Basic Guide to Social Skills](https://www.improveyoursocialskills.com/basic-social-skills-guide)
* **Sr/Staff Engineers**
	* [What senior engineers do: fix knowledge holes - Dan Moore](http://www.mooreds.com/wordpress/archives/3232)
		* Worthwhile for the first comment in response to the article: "I don’t see anything “senior” about it, or even “engineer”.  Seeing problems and solving them is what everyone does.  Documenting the solution is one part of solving a problem.  An apprentice carpenter does these things, too, and so does a farmer, and a waiter.  Unfortunately, it’s not what most software companies reward, or how they operate.  Whenever I did this, my manager, at every software company I’ve worked for, would say:  “That’s cool, but you’re supposed to add the FooBar feature, and it needs to be done this Friday.  Don’t waste time with reverse-engineering, or documentation.  Just add one new field to the protocol somewhere.  We can clean it up Later(TM).”  This is Conway’s Law at work.  What sort of company encourages the creation of two critical components which are completely undocumented?  The sort of company which doesn’t reward documentation of critical components.  That’s not likely to change because the engineer that created them happened to leave.  (It took more time to reverse-engineer the protocol than it would have to document it when the knowledge was fresh.)  The PM and QA who allowed this to happen are still there, right?  What “Senior Engineer” really means is someone who’s spent enough time in the trenches to have earned a job title that allows them the latitude to make these sorts of improvements, and not have a PM question why they aren’t, instead, doing exactly what they were assigned.  Look back at the story.  Did the “senior engineer” go through proper channels to schedule a “reverse-engineer and document network protocol” task?  No, he clearly didn’t trust that it would happen.  Or maybe it was already there, but lowest priority (way below “fix CSS on IE”, of course).  What was his actual responsibility that week?  The story doesn’t say, but I don’t see any remarks about a PM breathing down his neck asking about the CSS fix he asked for (because that PM is the only user of the system, anywhere, of course, who uses IE and sees that particular bug).  Documentation is not on this week’s “Sprint”!  The process is fundamentally broken.  We hear fables like this about how life would be better if we all did something one way (you’ll get promoted to Senior Engineer!), while in practice we’re punished for doing so." 
	* [StaffEng](https://staffeng.com/stories/)
		* Folks who have shared their stories of reaching Staff-plus engineer roles:
	* [Being Glue - Tanya Reilly](https://noidea.dog/glue)
	* [What's it like as a Senior Engineer at Google? - Zain Rizvi](https://www.zainrizvi.io/blog/whats-it-like-as-a-senior-engineer/)
* **Strategy**
	* **101**
	* **Books**
		* [The Art of War - Internet Archive](https://archive.org/details/TheArtOfWarBySunTzu)
		* Good Strategy/Bad Strategy
		* Playing to Win
	* **Articles/Blogposts/Writeups**
		* [Playing to Win: How Strategy Really Works - farnamstreet](https://fs.blog/2013/03/playing-to-win-how-strategy-really-works/)
	* **Talks/Presentations/Videos**
		* [Good Strategy/Bad Strategy: the difference and why it matters - Prof. Richard Rumelt(LSE Events)(2011)](https://www.youtube.com/watch?v=UZrTl16hZdk)
			* Developing and implementing a strategy is the central task of any leader. Richard Rumelt shows that there has been a growing and unfortunate tendency to equate motherhood and apple-pie values and fluffy packages of buzzwords with "strategy."
* **Teams**<a name="teams"></a>
	* **Building a Team**
		* [How to Size and Assess Teams From an Eng Lead at Stripe, Uber and Digg - FirstRoundReview](https://firstround.com/review/how-to-size-and-assess-teams-from-an-eng-lead-at-stripe-uber-and-digg/)
		* [Scaling engineering organizations - Raylene Yung(Stripe)](https://stripe.com/atlas/guides/scaling-eng)
			* Lessons learned from scaling Stripe's engineering team.
	* **Leading a Team**
	* **Operating in a Team**
	* **Understanding Teams**
		* **Books**
			* Five Dysfunctions of a Team
			* [The Goal](https://en.wikipedia.org/wiki/The_Goal_(novel))
				* The Phoenix Project & The Unicorn Project
			* I think should b read anyways despite whatever personal opinions on them(Better to know than not)
				* 48 Laws of Power
				* The Prince - Machiavelli
	* **Articles/Blogposts/Writeups**
		* [Don’t Serve Burnt Pizza (And Other Lessons in Building Minimum Lovable Products) - FirstRoundReview](https://firstround.com/review/dont-serve-burnt-pizza-and-other-lessons-in-building-minimum-lovable-products/)
		* [This Is What Impactful Engineering Leadership Looks Like - FirstRoundReview](https://firstround.com/review/this-is-what-impactful-engineering-leadership-looks-like/)
		* [How to Become Insanely Well-Connected - FirstRoundReview](https://firstround.com/review/how-to-become-insanely-well-connected/)
		* [What are the core team types in Team Topologies? - Matthew Skelton, Manuel Pais(2019)](https://teamtopologies.com/key-concepts-content/what-are-the-core-team-types-in-team-topologies)
* **Testing(Certifications/Exams)**<a name="testing"></a>
	* [Better GIAC Testing with Pancakes - H4cks4panckakes](https://tisiphone.net/2015/08/18/giac-testing/)
	* [Self-Study SANS SEC503 GCIA - Gary Hoffman](https://www.linkedin.com/pulse/self-study-sans-sec503-gcia-gary-hoffman/)
* **Training**
	* [Employee Training: Paid or Unpaid? - Epstein Becker & Green, P.C.](https://www.wagehourblog.com/2014/01/articles/off-the-clock/employee-training-paid-or-unpaid/)
	* [Does My Employer Have to Pay Me for Training? - Lisa Guerin](https://www.lawyers.com/legal-info/labor-employment-law/wage-and-hour-law/employer-paid-training-may-really-be-employee-paid.html)
	* [Are Employers Required to Pay Employees for Training Courses? - Jules Halpern Associates](https://www.halpernadvisors.com/employers-required-pay-employees-training-courses/)
* **Other**<a name="other"></a>
	* [Revisiting L0pht testimony – 20yrs later -Space Rogue](https://www.spacerogue.net/wordpress/?p=709)
	* [My Canons on (ISC)² Ethics - Such as They Are(2011)](http://infosecisland.com/blogview/15450-My-Canons-on-ISC-Ethics-Such-as-They-Are.html)
	* [Apple’s Software “Problem” and “Fixing” It (via twitter)](https://medium.learningbyshipping.com/apples-software-problem-and-fixing-it-via-twitter-c941a905ba20)
	* **Job Hunting Experiences**
		* [Farewell, App Academy. Hello, Airbnb. (Part I) - Haseeb Qureshi](https://haseebq.com/farewell-app-academy-hello-airbnb-part-i/)
* **Industry**<a name="Industry"></a>
	* **Android**
		* [Google’s iron grip on Android: Controlling open source by any means necessary - Ron Amadeo(2018)](https://arstechnica.com/gadgets/2018/07/googles-iron-grip-on-android-controlling-open-source-by-any-means-necessary/)
		* [Internal Google Program Taps Data on Rival Android Apps - Alex Heath, Nick Bastone, Amir Efrati(2020)](https://www.theinformation.com/articles/internal-google-program-taps-data-on-rival-android-apps)
	* **Ageism in Tech**
		* [REID v. GOOGLE INC - findlaw](https://caselaw.findlaw.com/ca-supreme-court/1534156.html)
		* [The Apple engineer who moved Mac to Intel applied to work at the Genius Bar in an Apple store and was rejected - BuisinessInsider](https://www.businessinsider.com/jk-scheinberg-apple-engineer-rejected-job-apple-store-genius-bar-2016-9)
		* [Lawsuit klaxon: HP, HPE accused of coordinated plan to oust older staff in favor of cheaper, compliant youngsters - Thomas Claburn(2020)](https://www.theregister.com/2020/05/22/hp_hpe_accused_of_coordinated/)
		* [Cutting ‘Old Heads’ at IBM - Peter Gosselin, Ariana Tobin(2018)](https://features.propublica.org/ibm/ibm-age-discrimination-american-workers/)
			* As it scrambled to compete in the internet world, the once-dominant tech company cut tens of thousands of U.S. workers, hitting its most senior employees hardest and flouting rules against age bias.
	* **Anti-Union**
		* [Amazon's Aggressive Anti-Union Tactics Revealed in Leaked 45-Minute Video - Bryan Menegus(2018)](https://gizmodo.com/amazons-aggressive-anti-union-tactics-revealed-in-leake-1829305201)
		* [Leaked Amazon Memo Details Plan to Smear Fired Warehouse Organizer: ‘He’s Not Smart or Articulate’ - Paul Blest(2020)]
		* [Google Urged the U.S. to Limit Protection For Activist Workers - Josh Eidelson, Hassan Kanu, Mark Bergen](https://www.bloomberg.com/news/articles/2019-01-24/google-urged-the-u-s-to-limit-protection-for-activist-workers)
			* While Google publicly supported employees who protested company policies, it quietly asked the government to narrow the right to organize over work email
	* **Bribes**
		* [Former Uber Executive Charged With Paying 'Hush Money' To Conceal Massive Breach - Shannon Bond(2020)](https://www.npr.org/2020/08/20/904113981/former-uber-executive-charged-with-paying-hush-money-to-conceal-massive-breach)
	* **Censorship/Propaganda**
		* [A Genocide Incited on Facebook, With Posts From Myanmar’s Military - Paul Mozur(2018)](https://www.nytimes.com/2018/10/15/technology/myanmar-facebook-genocide.html)
		* [Invisible Censorship: TikTok Told Moderators to Suppress Posts by “Ugly” People and the Poor to Attract New Users - Sam Biddle, Paulo Victor Ribeiro, Tatiana Dias(2020)](https://theintercept.com/2020/03/16/tiktok-app-moderators-users-discrimination/)
		* [China-Based Executive at U.S. Telecommunications Company Charged with Disrupting Video Meetings Commemorating Tiananmen Square Massacre - Department of Justice(USA - 2020)](https://www.justice.gov/opa/pr/china-based-executive-us-telecommunications-company-charged-disrupting-video-meetings)
		* [Facebook Fired An Employee Who Collected Evidence Of Right-Wing Pages Getting Preferential Treatment - Craig Silverman, Ryan Mac(2020)](https://www.buzzfeednews.com/article/craigsilverman/facebook-zuckerberg-what-if-trump-disputes-election-results)
	* **Content Moderators**
		* [Facebook will pay $52 million in settlement with moderators who developed PTSD on the job - Casey Newton(2020)](https://www.theverge.com/2020/5/12/21255870/facebook-content-moderator-settlement-scola-ptsd-mental-health)
	* **Dissapearing Messages**
		* [Uber Criminal Probe Shines Light on Vanishing Message System - Joel Rosenblatt](https://www.bloomberg.com/news/articles/2017-11-28/waymo-trial-delayed-again-with-sharp-words-for-uber-from-judge)
			* I have this listed here as a thought piece rather than commentary; i.e. Is it better to archive all messages or to have them deleted after so long? If the latter, how long? etc.
	* **Google Searches**
		* [An Interview With A Google Search Quality Rater - Matt McGee(2012)](https://searchengineland.com/interview-google-search-quality-rater-108702)
			* Since at least 2005, Google has been using a large, worldwide focus group to help review its search results and the quality of the web pages that rank well in its algorithm. The people in this program are called Quality Raters and, as you can imagine, the work they do is important to search marketers […]
	* **History**
		* [If I Told You I’d Have to Kill You: The Story Behind “The Secret History of Silicon Valley” - Steve Blank](https://steveblank.com/2009/03/23/if-i-told-you-i%e2%80%99d-have-to-kill-you-the-story-behind-the-secret-history-of-silicon-valley/)
	* **Monopolies/Trusts**
		* [United States v. Microsoft Corp.(2001) - Wikipedia](https://en.wikipedia.org/wiki/United_States_v._Microsoft_Corp.)
		* [Halloween documents - Wikipedia](https://en.m.wikipedia.org/wiki/Halloween_documents)
			* The Halloween documents comprise a series of confidential Microsoft memoranda on potential strategies relating to free software, open-source software, and to Linux in particular, and a series of media responses to these memoranda. Both the leaked documents and the responses were published by Eric S. Raymond in 1998.
		* [Amazon Scooped Up Data From Its Own Sellers to Launch Competing Products - Angela Owens(2020)](https://www.wsj.com/amp/articles/amazon-scooped-up-data-from-its-own-sellers-to-launch-competing-products-11587650015)
		* [Amazon Met With Startups About Investing, Then Launched Competing Products - Dana Mattioloi, Cara Lombardo(2020)](https://www.wsj.com/articles/amazon-tech-startup-echo-bezos-alexa-investment-fund-11595520249)
		* [Former App Store exec testifies Apple's rules are "a weapon against competitors" - Cal Jeffery(2020)](https://www.techspot.com/news/87038-former-app-store-exec-testifies-apple-rules-weapon.html)
		* [What Does It Mean When Apple “Sherlocks” an App? - Justin Pot(2017)](https://www.google.com/amp/s/www.howtogeek.com/297651/what-does-it-mean-when-a-company-sherlocks-an-app)
	* **Palantir**
		* [Inside Palantir, Silicon Valley's Most Secretive Company - William Alden(2016)](https://www.buzzfeednews.com/article/williamalden/inside-palantir-silicon-valleys-most-secretive-company)
	* **Patent Trolling**
		* [How much is Microsoft earning from its Android taxes again? - Andrew Orlowski(2014)](https://www.theregister.com/2014/10/07/how_much_is_that_microsoft_android_tax_again/)
		* [Report: Microsoft making patents royalty-free for Android OEMs - Ryne Hager(201)](https://www.androidpolice.com/2018/10/10/report-microsoft-making-patents-royalty-free-android-oems/)
	* **Pharmacy Sales**
		* [Google Forfeits $500 Million Generated by Online Ads & Prescription Drug Sales by Canadian Online Pharmacies - US Department of Justice(2011)](https://www.justice.gov/opa/pr/google-forfeits-500-million-generated-online-ads-prescription-drug-sales-canadian-online)
	* **Privacy Violations/Spying on the Customer**
		* [Facebook will pay $550 million to settle class action lawsuit over privacy violations - Devin Coldewey(2020)](https://techcrunch.com/2020/01/29/facebook-will-pay-550-million-to-settle-class-action-lawsuit-over-privacy-violations/)
		* [ ‘Crush This Lady.’ Inside eBay’s Bizarre Campaign Against a Blog Critic. - Kirsten Grind, Sebastian Herrera(2020)](https://www.wsj.com/articles/ebay-harassment-campaign-pig-cockroach-blog-11593009038)
	* **Public Monitoring**
		* [Police Surveilled George Floyd Protests With Help From Twitter-Affiliated Startup Dataminr - Sam Biddle(2020)](https://theintercept.com/2020/07/09/twitter-dataminr-police-spy-surveillance-black-lives-matter-protests/)
	* **Racism**
		* [‘Tokenized’: Inside Black Workers’ Struggles at the King of Crypto Start-Ups - Nathaniel Popper(2020)](https://www.nytimes.com/2020/11/27/technology/coinbase-cryptocurrency-black-employees.html?smid=tw-nytimesbusiness&smtyp=cur)
	* **Sex-related**
		* [Google reportedly paid Andy Rubin $90 million after he allegedly coerced sex from employee - Chris Welch(2018)](https://www.theverge.com/2018/10/25/18023364/google-andy-rubin-payoff-90-million-sexual-misconduct-harassment)
			* [How Google Protected Andy Rubin, the ‘Father of Android’ - Daisuke Wakabayashi and Katie Benner(NYT)(2018)](https://www.nytimes.com/2018/10/25/technology/google-sexual-harassment-andy-rubin.html)
		* [Alphabet Settles Shareholder Suits Over Sexual Harassment Claims - Daisuke Wakabayashi(2020)](https://www.nytimes.com/2020/09/25/technology/google-sexual-harassment-lawsuit-settlement.html)
		* [Inside The Culture Of Sexism At Riot Games - Cecilia D'Anastasio](https://kotaku.com/inside-the-culture-of-sexism-at-riot-games-1828165483)
	* **Surveillance of Workers**
		* [Secret Amazon Reports Expose the Company’s Surveillance of Labor and Environmental Groups - Lauren Kaori Gurley(2020)](https://www.vice.com/en/article/5dp3yn/amazon-leaked-reports-expose-spying-warehouse-workers-labor-union-environmental-groups-social-movements)
		* [Amazon Is Hiring an Intelligence Analyst to Track 'Labor Organizing Threats' - Lorenzo Franceschi-Bicchierai(2020)](https://www.vice.com/en/article/qj4aqw/amazon-hiring-intelligence-analyst-to-track-labor-organizing-threats)
		* [Inside Amazon’s Secret Program to Spy On Workers’ Private Facebook Groups -  Lauren Kaori Gurley, Joseph Cox(2020)](https://www.vice.com/en/article/3azegw/amazon-is-spying-on-its-workers-in-closed-facebook-groups-internal-reports-show)
		* [Google illegally spied on workers before firing them, US labor board alleges - Zoe Schiffer(2020)](https://www.theverge.com/2020/12/2/22047383/google-spied-workers-before-firing-labor-complaint)		
	**Tax Avoidance/Fraud**
		* [Google Agrees to Pay Italy $334 Million in Back Taxes - New York Times(2017)](https://www.nytimes.com/2017/05/04/technology/google-italy-tax.html)
		* [Google shifted $23 billion to tax haven Bermuda in 2017: filing - Reuters](https://www.reuters.com/article/us-google-taxes-netherlands/google-shifted-23-billion-to-tax-haven-bermuda-in-2017-filing-idUSKCN1OX1G9)
		* [Google will finally stop using controversial Irish and Dutch tax loopholes - Zoe Schiffer(2019)](https://www.theverge.com/2019/12/31/21044662/google-end-tax-loophole-double-irish-dutch-sandwich-2020)
		* [Google to pay $1 billion in France to settle fiscal fraud probe - Reuters](https://www.reuters.com/article/us-france-tech-google-tax/google-to-pay-1-billion-in-france-to-settle-fiscal-fraud-probe-idUSKCN1VX1SM)
		* [The IRS Decided to Get Tough Against Microsoft. Microsoft Got Tougher. - ProPublica(2020)](https://www.propublica.org/article/the-irs-decided-to-get-tough-against-microsoft-microsoft-got-tougher)
	**Tesla**
		* [When Elon Musk Tried to Destroy a Tesla Whistleblower - Matt Robinson, Zeke Faux(2019)](https://www.bloomberg.com/news/features/2019-03-13/when-elon-musk-tried-to-destroy-tesla-whistleblower-martin-tripp)
		* [Musk Misses: The Stories You Don’t Hear About Tesla Anymore - Niya Tishan White(2019)](https://medium.com/@windycityn0velist/musk-misses-the-stories-you-dont-hear-about-tesla-anymore-8dfce1d803d2)
		* [Tesla says its factory is safer. But it left injuries off the books - Will Evans, Alyssa Jeong Perry(2018)](https://revealnews.org/article/tesla-says-its-factory-is-safer-but-it-left-injuries-off-the-books/)
		* [Tesla Had 3 Times as Many OSHA Violations as the 10 Largest US Plants Combined - Rob Stumpf(2019)](https://www.thedrive.com/news/26727/tesla-had-3-times-as-many-osha-violations-as-the-10-largest-us-plants-combined)
		* [The Big Tesla Hack: A hacker gained control over the entire fleet, but fortunately he’s a good guy - Fred Lambert(2020)](https://electrek.co/2020/08/27/tesla-hack-control-over-entire-fleet/)
	* **Stack Ranking**
		* [Vitality curve - Wikipedia](https://en.wikipedia.org/wiki/Vitality_curve)
		* [How stack ranking corrupts culture, at Uber and Beyond - Rob Davies(Perdoo)](https://www.perdoo.com/blog/stack-ranking/)
		* [Stack-ranking is appealing, and it should die - Girard Dorney(HRMOnline)](https://www.hrmonline.com.au/performance/stack-ranking-appealing-die/)
		* [Inside Facebook’s ‘cult-like’ workplace, where dissent is discouraged and employees pretend to be happy all the time - Salvador Rodriguez(CNBC)](https://www.cnbc.com/2019/01/08/facebook-culture-cult-performance-review-process-blamed.html)
		* [Microsoft's Lost Decade - Kurt Eichenwald(Vanitfair)](https://www.vanityfair.com/news/business/2012/08/microsoft-lost-mojo-steve-ballmer)
		* [Microsoft Abandons 'Stack Ranking' of Employees - Shira Ovide, Rachel Feintzeig(WallStreetJournal)](https://www.wsj.com/articles/microsoft-abandons-8216stack-ranking8217-of-employees-1384279446)
		* [ Amazon to drop dreaded stack-ranking performance reviews - Ángel González, Matt Day(SeattleTimes)](https://www.seattletimes.com/business/amazon/amazon-says-it-will-change-performance-reviews-focus-on-staffers-strengths/)
	* **Unions/Labor Organization**
		* [Workers can be barred from using company email for union organizing - NLRB - Daniel Wiessner()](https://www.reuters.com/article/labor-disclosure/workers-can-be-barred-from-using-company-email-for-union-organizing-nlrb-idUSL1N28R25I)
		* [Amazon Is Hiring an Intelligence Analyst to Track 'Labor Organizing Threats' - Lorenzo Franceschi-Bicchierai(2020)](https://www.vice.com/en_us/article/qj4aqw/amazon-hiring-intelligence-analyst-to-track-labor-organizing-threats)
	* **Wages**
		* [Techtopus - Pando](https://pando.com/tag/techtopus/)
		* [Newly unsealed documents show Steve Jobs' brutal response after getting a Google employee fired - Mark Ames](https://pando.com/2014/03/25/newly-unsealed-documents-show-steve-jobs-brutally-callous-response-after-getting-a-google-employee-fired/)
		* [Revealed: Apple and Google's wage-fixing cartel involved dozens more companies, over one million employees - Mark Ames(Pando)](https://pando.com/2014/03/22/revealed-apple-and-googles-wage-fixing-cartel-involved-dozens-more-companies-over-one-million-employees/)
		* [Is Your Employer Stealing From You? - Luke Darby(GQ2019)](https://www.gq.com/story/wage-theft)
	* **Other**
		* [Attrition.org](http://attrition.org/attrition/)
			* Attrition.org (http://attrition.org/) is a computer security web site dedicated to the collection, dissemination and distribution of information about the security industry for anyone interested in the subject. They maintain one of the only open and honest grim look at the industry, reminding everyone that we must strive to be better than we have been historically. The crusade to expose industry frauds and inform the public about incorrect information in computer security articles is a primary goal of the site. Previously, Attrition.org maintained the largest catalogs of security advisories, text files, and humorous image galleries. They are also known for maintaining the largest mirror of Web site defacements and the creation of the Data Loss Database (Open Source), which eventually became DatalossDB (http://datalossdb.org/).
* **Other**
	* [Microservices - KRAZAM](https://www.youtube.com/watch?v=y8OnoxKotPQ&app=desktop)
	* [The Expert](https://www.youtube.com/watch?v=BKorP55Aqvg)
	* [Elon Musk Today](https://elonmusk.today/)
		* Like Donald Trump, But For Nerds

