### Mitre Pre-ATT&CK Mappings
---------------------------
* MITRE Pre-ATT&CK Framework ([MITRE ATT&CK Framework](https://attack.mitre.org/pre-attack/index.php/Main_Page) for attackers.
* This is a copy of the mappings with links to techniques and background information.
- [Adversary Opsec]()
- [Build Capabilities]()
- [Organization Informational Gathering]()
- [Organizational Weakness]()
- [People Information Gathering]()
- [People Weakness Identification]()
- [Persona Development]()
- [Priority Definition Planning]()
- [Priority Definition Directive]()
- [Stage Capabilities]()
- [Target Selection]()
- [Technical Information Gathering]()
- [Test Capabilities]()






### MITRE ATT&CK Framework Mappings 
---------------------------
* MITRE ATT&CK Framework ([MITRE ATT&CK Framework](https://attack.mitre.org/wiki/Main_Page)) for attackers.
* This is a copy of the mappings with links to techniques and background information rather than APT reports.
	* If you want to test your defenses against a lot of these things:
		* [Atomic Red Team - Small and highly portable detection tests mapped to the Mitre ATT&CK Framework.](https://github.com/redcanaryco/atomic-red-team)
* [Collection](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/ATT%26CK-Stuff/Collection.md)
* [Command and Control](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/ATT%26CK-Stuff/Command_and_Control.md)
* [Credential Access](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/ATT%26CK-Stuff/Command_and_Control.md)
* [Defense Evasion](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/ATT%26CK-Stuff/Defense_Evasion.md)
* [Discovery](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/ATT%26CK-Stuff/Discovery.md)
* [Execution](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/ATT%26CK-Stuff/Execution.md)
* [Exfiltration](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/ATT%26CK-Stuff/Exfiltration.md)
* [Initial Access](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/ATT%26CK-Stuff/Initial_Access.md)
* [Lateral Movement](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/ATT%26CK-Stuff/Lateral%20Movement.md)
* [Persistence](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/ATT%26CK-Stuff/Persistence.md)
* [Privilege Escalation](https://github.com/rmusser01/Infosec_Reference/blob/master/Draft/ATT%26CK-Stuff/Privilege_Escalation.md)
* If you want to test your defenses against a lot of these things:
	* [Atomic Red Team - Small and highly portable detection tests mapped to the Mitre ATT&CK Framework.](https://github.com/redcanaryco/atomic-red-team)
	* [Caldera](https://github.com/mitre/caldera)
		* CALDERA is an automated adversary emulation system that performs post-compromise adversarial behavior within enterprise networks. It generates plans during operation using a planning system and a pre-configured adversary model based on the Adversarial Tactics, Techniques & Common Knowledge (ATT&CK™) project. These features allow CALDERA to dynamically operate over a set of systems using variable behavior, which better represents how human adversaries perform operations than systems that follow prescribed sequences of actions.
	* [Metta](https://github.com/uber-common/metta)
		* An information security preparedness tool to do adversarial simulation. This project uses Redis/Celery, python, and vagrant with virtualbox to do adversarial simulation. This allows you to test (mostly) your host based instrumentation but may also allow you to test any network based detection and controls depending on how you set up your vagrants. The project parses yaml files with actions and uses celery to queue these actions up and run them one at a time without interaction.








