﻿{ ****************************************************************************** }
{ * ffmpeg all in one by qq600585                                              * }
{ * https://zpascal.net                                                        * }
{ * https://github.com/PassByYou888/zAI                                        * }
{ * https://github.com/PassByYou888/ZServer4D                                  * }
{ * https://github.com/PassByYou888/PascalString                               * }
{ * https://github.com/PassByYou888/zRasterization                             * }
{ * https://github.com/PassByYou888/CoreCipher                                 * }
{ * https://github.com/PassByYou888/zSound                                     * }
{ * https://github.com/PassByYou888/zChinese                                   * }
{ * https://github.com/PassByYou888/zExpression                                * }
{ * https://github.com/PassByYou888/zGameWare                                  * }
{ * https://github.com/PassByYou888/zAnalysis                                  * }
{ * https://github.com/PassByYou888/FFMPEG-Header                              * }
{ * https://github.com/PassByYou888/zTranslate                                 * }
{ * https://github.com/PassByYou888/InfiniteIoT                                * }
{ * https://github.com/PassByYou888/FastMD5                                    * }
{ ****************************************************************************** }
(*
 * copyright (c) 2001 Fabrice Bellard
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *)
unit FFMPEG;

{$IFDEF FPC}
  {$MODE DELPHI }
  {$PACKENUM 4}    (* use 4-byte enums *)
  {$PACKRECORDS C} (* C/C++-compatible record packing *)
  {$DEFINE API_Dynamic}
{$ELSE}
  {$MINENUMSIZE 4} (* use 4-byte enums *)
  {$LEGACYIFEND ON}

  {$IF Defined(IOS) and Defined(CPUARM)}
    {$UNDEF API_Dynamic}
  {$ELSE}
    {$DEFINE API_Dynamic}
  {$IFEND}

  {$IF Defined(Android) or Defined(IOS) or Defined(MACOS) or Defined(LINUX)}
    {$DEFINE LINUX_OSX_ANDROID}
  {$IFEND}
{$ENDIF}

{$IFNDEF ANDROID}
{$ENDIF ANDROID}

{$UNDEF FF_API_SWS_VECTOR}
{$UNDEF FF_API_AVFILTERBUFFER}

interface

uses
  SysUtils, Math,
{$IFDEF FPC}
  Dynlibs,
{$ELSE FPC}
{$IFDEF MSWINDOWS} Windows, {$ENDIF MSWINDOWS}
  System.IOUtils,
{$ENDIF FPC}
  Classes;

procedure Load_ffmpeg();
procedure Free_ffmpeg();

{$Region 'compiler const'}

const
  // libavcodec
  LIBAVCODEC_VERSION_MAJOR = 57;
  LIBAVCODEC_VERSION_MINOR = 107;
  LIBAVCODEC_VERSION_MICRO = 100;
  LIBAVCODEC_VERSION       = '57.107.100';
  LIBAVCODEC_VERSION_INT   = (LIBAVCODEC_VERSION_MAJOR shl 16) or
                             (LIBAVCODEC_VERSION_MINOR shl 8) or
                              LIBAVCODEC_VERSION_MICRO;
  LIBAVCODEC_BUILD         = LIBAVCODEC_VERSION_INT;
  LIBAVCODEC_IDENT         = 'Lavc' + LIBAVCODEC_VERSION;

(**
 * FF_API_* defines may be placed below to indicate public API that will be
 * dropped at a future version bump. The defines themselves are not part of
 * the public API and may change, break or disappear at any time.
 *
 * @note, when bumping the major version it is recommended to manually
 * disable each FF_API_* in its own commit instead of disabling them all
 * at once through the bump. This improves the git bisect-ability of the change.
 *)

{$IFNDEF FF_API_VIMA_DECODER}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_VIMA_DECODER}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_AUDIO_CONVERT}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_AUDIO_CONVERT}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_AVCODEC_RESAMPLE}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_AVCODEC_RESAMPLE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_MISSING_SAMPLE}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_MISSING_SAMPLE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_LOWRES}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_LOWRES}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_CAP_VDPAU}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_CAP_VDPAU}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_BUFS_VDPAU}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_BUFS_VDPAU}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_VOXWARE}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_VOXWARE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_SET_DIMENSIONS}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_SET_DIMENSIONS}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_DEBUG_MV}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_DEBUG_MV}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_AC_VLC}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_AC_VLC}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_OLD_MSMPEG4}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_OLD_MSMPEG4}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_ASPECT_EXTENDED}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_ASPECT_EXTENDED}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_ARCH_ALPHA}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_ARCH_ALPHA}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_XVMC}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_XVMC}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_ERROR_RATE}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_ERROR_RATE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_QSCALE_TYPE}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_QSCALE_TYPE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_MB_TYPE}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_MB_TYPE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_MAX_BFRAMES}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_MAX_BFRAMES}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_NEG_LINESIZES}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_NEG_LINESIZES}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_EMU_EDGE}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_EMU_EDGE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_ARCH_SH4}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_ARCH_SH4}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_ARCH_SPARC}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_ARCH_SPARC}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_UNUSED_MEMBERS}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_UNUSED_MEMBERS}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_IDCT_XVIDMMX}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_IDCT_XVIDMMX}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_INPUT_PRESERVED}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_INPUT_PRESERVED}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_NORMALIZE_AQP}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_NORMALIZE_AQP}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_GMC}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_GMC}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_MV0}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_MV0}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_CODEC_NAME}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_CODEC_NAME}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_AFD}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_AFD}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_VISMV}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    (* XXX: don't forget to drop the -vismv documentation *)
    {$DEFINE FF_API_VISMV}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_AUDIOENC_DELAY}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_AUDIOENC_DELAY}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_VAAPI_CONTEXT}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_VAAPI_CONTEXT}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_MERGE_SD}
  {$IF LIBAVCODEC_VERSION_MAJOR < 58}
    {$DEFINE FF_API_MERGE_SD}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_AVCTX_TIMEBASE}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_AVCTX_TIMEBASE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_MPV_OPT}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_MPV_OPT}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_STREAM_CODEC_TAG}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_STREAM_CODEC_TAG}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_QUANT_BIAS}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_QUANT_BIAS}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_RC_STRATEGY}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_RC_STRATEGY}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_CODED_FRAME}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_CODED_FRAME}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_MOTION_EST}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_MOTION_EST}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_WITHOUT_PREFIX}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_WITHOUT_PREFIX}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_SIDEDATA_ONLY_PKT}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_SIDEDATA_ONLY_PKT}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_VDPAU_PROFILE}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_VDPAU_PROFILE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_CONVERGENCE_DURATION}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_CONVERGENCE_DURATION}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_AVPICTURE}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_AVPICTURE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_AVPACKET_OLD_API}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_AVPACKET_OLD_API}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_RTP_CALLBACK}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_RTP_CALLBACK}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_VBV_DELAY}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_VBV_DELAY}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_CODER_TYPE}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_CODER_TYPE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_STAT_BITS}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_STAT_BITS}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_PRIVATE_OPT}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_PRIVATE_OPT}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_ASS_TIMING}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_ASS_TIMING}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_OLD_BSF}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_OLD_BSF}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_COPY_CONTEXT}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_COPY_CONTEXT}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_GET_CONTEXT_DEFAULTS}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_GET_CONTEXT_DEFAULTS}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_NVENC_OLD_NAME}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_NVENC_OLD_NAME}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_STRUCT_VAAPI_CONTEXT}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_STRUCT_VAAPI_CONTEXT}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_MERGE_SD_API}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_MERGE_SD_API}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_TAG_STRING}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_TAG_STRING}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_GETCHROMA}
  {$IF LIBAVCODEC_VERSION_MAJOR < 59}
    {$DEFINE FF_API_GETCHROMA}
  {$IFEND}
{$ENDIF}

  // libavdevice
  LIBAVDEVICE_VERSION_MAJOR = 57;
  LIBAVDEVICE_VERSION_MINOR = 10;
  LIBAVDEVICE_VERSION_MICRO = 100;
  LIBAVDEVICE_VERSION       = '57.10.100';
  LIBAVDEVICE_VERSION_INT   = (LIBAVDEVICE_VERSION_MAJOR shl 16) or
                              (LIBAVDEVICE_VERSION_MINOR shl 8) or
                               LIBAVDEVICE_VERSION_MICRO;
  LIBAVDEVICE_BUILD         = LIBAVDEVICE_VERSION_INT;
  LIBAVDEVICE_IDENT         = 'Lavc' + LIBAVDEVICE_VERSION;

(**
 * FF_API_* defines may be placed below to indicate public API that will be
 * dropped at a future version bump. The defines themselves are not part of
 * the public API and may change, break or disappear at any time.
 *)

  // libavfilter
  LIBAVFILTER_VERSION_MAJOR  = 6;
  LIBAVFILTER_VERSION_MINOR  = 107;
  LIBAVFILTER_VERSION_MICRO  = 100;
  LIBAVFILTER_VERSION        = '6.107.100';
  LIBAVFILTER_VERSION_INT    = (LIBAVFILTER_VERSION_MAJOR shl 16) or
                               (LIBAVFILTER_VERSION_MINOR shl 8) or
                                LIBAVFILTER_VERSION_MICRO;
  LIBAVFILTER_BUILD          = LIBAVFILTER_VERSION_INT;
  LIBAVFILTER_IDENT          = 'Lavfi' + LIBAVFILTER_VERSION;

(**
 * FF_API_* defines may be placed below to indicate public API that will be
 * dropped at a future version bump. The defines themselves are not part of
 * the public API and may change, break or disappear at any time.
 *)

{$IFNDEF FF_API_OLD_FILTER_OPTS}
  {$IF LIBAVFILTER_VERSION_MAJOR < 7}
    {$DEFINE FF_API_OLD_FILTER_OPTS}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_OLD_FILTER_OPTS_ERROR}
  {$IF LIBAVFILTER_VERSION_MAJOR < 7}
    {$DEFINE FF_API_OLD_FILTER_OPTS_ERROR}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_AVFILTER_OPEN}
  {$IF LIBAVFILTER_VERSION_MAJOR < 7}
    {$DEFINE FF_API_AVFILTER_OPEN}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_AVFILTER_INIT_FILTER}
  {$IF LIBAVFILTER_VERSION_MAJOR < 7}
    {$DEFINE FF_API_AVFILTER_INIT_FILTER}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_OLD_FILTER_REGISTER}
  {$IF LIBAVFILTER_VERSION_MAJOR < 7}
    {$DEFINE FF_API_OLD_FILTER_REGISTER}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_NOCONST_GET_NAME}
  {$IF LIBAVFILTER_VERSION_MAJOR < 7}
    {$DEFINE FF_API_NOCONST_GET_NAME}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_LAVR_OPTS}
  {$IF LIBAVFILTER_VERSION_MAJOR < 7}
    {$DEFINE FF_API_LAVR_OPTS}
  {$IFEND}
{$ENDIF}

  // libavformat
  LIBAVFORMAT_VERSION_MAJOR = 57;
  LIBAVFORMAT_VERSION_MINOR = 83;
  LIBAVFORMAT_VERSION_MICRO = 100;
  LIBAVFORMAT_VERSION       = '57.83.100';
  LIBAVFORMAT_VERSION_INT   = (LIBAVFORMAT_VERSION_MAJOR shl 16) or
                              (LIBAVFORMAT_VERSION_MINOR shl 8) or
                               LIBAVFORMAT_VERSION_MICRO;
  LIBAVFORMAT_BUILD         = LIBAVFORMAT_VERSION_INT;
  LIBAVFORMAT_IDENT         = 'Lavf' + LIBAVFORMAT_VERSION;

(**
 * FF_API_* defines may be placed below to indicate public API that will be
 * dropped at a future version bump. The defines themselves are not part of
 * the public API and may change, break or disappear at any time.
 *
 * @note, when bumping the major version it is recommended to manually
 * disable each FF_API_* in its own commit instead of disabling them all
 * at once through the bump. This improves the git bisect-ability of the change.
 *
 *)

{$IFNDEF FF_API_LAVF_BITEXACT}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
   {$DEFINE FF_API_LAVF_BITEXACT}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_LAVF_FRAC}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
   {$DEFINE FF_API_LAVF_FRAC}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_LAVF_CODEC_TB}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
   {$DEFINE FF_API_LAVF_CODEC_TB}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_URL_FEOF}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
    {$DEFINE FF_API_URL_FEOF}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_LAVF_FMT_RAWPICTURE}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
    {$DEFINE FF_API_LAVF_FMT_RAWPICTURE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_COMPUTE_PKT_FIELDS2}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
    {$DEFINE FF_API_COMPUTE_PKT_FIELDS2}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_OLD_OPEN_CALLBACKS}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
    {$DEFINE FF_API_OLD_OPEN_CALLBACKS}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_LAVF_AVCTX}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
    {$DEFINE FF_API_LAVF_AVCTX}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_NOCONST_GET_SIDE_DATA}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
    {$DEFINE FF_API_NOCONST_GET_SIDE_DATA}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_HTTP_USER_AGENT}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
    {$DEFINE FF_API_HTTP_USER_AGENT}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_HLS_WRAP}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
    {$DEFINE FF_API_HLS_WRAP}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_LAVF_MERGE_SD}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
    {$DEFINE FF_API_LAVF_MERGE_SD}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_LAVF_KEEPSIDE_FLAG}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
    {$DEFINE FF_API_LAVF_KEEPSIDE_FLAG}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_OLD_ROTATE_API}
  {$IF LIBAVFORMAT_VERSION_MAJOR < 58}
    {$DEFINE FF_API_OLD_ROTATE_API}
  {$IFEND}
{$ENDIF}

{$IFNDEF FF_API_R_FRAME_RATE}
  {$DEFINE FF_API_R_FRAME_RATE}
{$ENDIF}

  // libavutil
  LIBAVUTIL_VERSION_MAJOR = 55;
  LIBAVUTIL_VERSION_MINOR = 78;
  LIBAVUTIL_VERSION_MICRO = 100;
  LIBAVUTIL_VERSION       = '55.78.100';
  LIBAVUTIL_VERSION_INT   = (LIBAVUTIL_VERSION_MAJOR shl 16) or
                            (LIBAVUTIL_VERSION_MINOR shl 8) or
                             LIBAVUTIL_VERSION_MICRO;
  LIBAVUTIL_BUILD         = LIBAVUTIL_VERSION_INT;
  LIBAVUTIL_IDENT         = 'Lavu' + LIBAVUTIL_VERSION;

(**
 * @defgroup lavu_depr_guards Deprecation Guards
 * FF_API_* defines may be placed below to indicate public API that will be
 * dropped at a future version bump. The defines themselves are not part of
 * the public API and may change, break or disappear at any time.
 *
 * @note, when bumping the major version it is recommended to manually
 * disable each FF_API_* in its own commit instead of disabling them all
 * at once through the bump. This improves the git bisect-ability of the change.
 *
 * @{
 *)

{$IFNDEF FF_API_VDPAU}
  {$IF LIBAVUTIL_VERSION_MAJOR < 56}
    {$DEFINE FF_API_VDPAU}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_XVMC}
  {$IF LIBAVUTIL_VERSION_MAJOR < 56}
    {$DEFINE FF_API_XVMC}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_OPT_TYPE_METADATA}
  {$IF LIBAVUTIL_VERSION_MAJOR < 56}
    {$DEFINE FF_API_OPT_TYPE_METADATA}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_DLOG}
  {$IF LIBAVUTIL_VERSION_MAJOR < 56}
    {$DEFINE FF_API_DLOG}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_VAAPI}
  {$IF LIBAVUTIL_VERSION_MAJOR < 56}
    {$DEFINE FF_API_VAAPI}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_FRAME_QP}
  {$IF LIBAVUTIL_VERSION_MAJOR < 56}
    {$DEFINE FF_API_FRAME_QP}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_PLUS1_MINUS1}
  {$IF LIBAVUTIL_VERSION_MAJOR < 56}
    {$DEFINE FF_API_PLUS1_MINUS1}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_ERROR_FRAME}
  {$IF LIBAVUTIL_VERSION_MAJOR < 56}
    {$DEFINE FF_API_ERROR_FRAME}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_CRC_BIG_TABLE}
  {$IF LIBAVUTIL_VERSION_MAJOR < 56}
    {$DEFINE FF_API_CRC_BIG_TABLE}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_PKT_PTS}
  {$IF LIBAVUTIL_VERSION_MAJOR < 56}
    {$DEFINE FF_API_PKT_PTS}
  {$IFEND}
{$ENDIF}
{$IFNDEF FF_API_CRYPTO_SIZE_T}
  {$IF LIBAVUTIL_VERSION_MAJOR < 56}
    {$DEFINE FF_API_CRYPTO_SIZE_T}
  {$IFEND}
{$ENDIF}

(**
 * @}
 *)

  // libswresample
  LIBSWRESAMPLE_VERSION_MAJOR = 2;
  LIBSWRESAMPLE_VERSION_MINOR = 9;
  LIBSWRESAMPLE_VERSION_MICRO = 100;
  LIBSWRESAMPLE_VERSION       = '2.9.100';
  LIBSWRESAMPLE_VERSION_INT   = (LIBSWRESAMPLE_VERSION_MAJOR shl 16) or
                                (LIBSWRESAMPLE_VERSION_MINOR shl 8) or
                                 LIBSWRESAMPLE_VERSION_MICRO;
  LIBSWRESAMPLE_BUILD         = LIBSWRESAMPLE_VERSION_INT;
  LIBSWRESAMPLE_IDENT         = 'SwS' + LIBSWRESAMPLE_VERSION;

  // libswscale
  LIBSWSCALE_VERSION_MAJOR = 4;
  LIBSWSCALE_VERSION_MINOR = 8;
  LIBSWSCALE_VERSION_MICRO = 100;
  LIBSWSCALE_VERSION       = '4.8.100';
  LIBSWSCALE_VERSION_INT   = (LIBSWSCALE_VERSION_MAJOR shl 16) or
                             (LIBSWSCALE_VERSION_MINOR shl 8) or
                              LIBSWSCALE_VERSION_MICRO;
  LIBSWSCALE_BUILD         = LIBSWSCALE_VERSION_INT;
  LIBSWSCALE_IDENT         = 'SwS' + LIBSWSCALE_VERSION;

(**
 * FF_API_* defines may be placed below to indicate public API that will be
 * dropped at a future version bump. The defines themselves are not part of
 * the public API and may change, break or disappear at any time.
 *)

{$IFNDEF FF_API_SWS_VECTOR}
  {$IF LIBAVUTIL_VERSION_MAJOR < 6}
    {$DEFINE FF_API_SWS_VECTOR}
  {$IFEND}
{$ENDIF}
{$EndRegion 'compiler const'}

const
{$IF Defined(WIN32) or Defined(WIN64)}
    CLibPrefix    = '';
    CLibExtension = '.dll';
    _PU           = '';

    AVCODEC_LIBNAME    = CLibPrefix + 'avcodec-57'   + CLibExtension;
    AVDEVICE_LIBNAME   = CLibPrefix + 'avdevice-57'  + CLibExtension;
    AVFILTER_LIBNAME   = CLibPrefix + 'avfilter-6'   + CLibExtension;
    AVFORMAT_LIBNAME   = CLibPrefix + 'avformat-57'  + CLibExtension;
    AVUTIL_LIBNAME     = CLibPrefix + 'avutil-55'    + CLibExtension;
    SWRESAMPLE_LIBNAME = CLibPrefix + 'swresample-2' + CLibExtension;
    SWSCALE_LIBNAME    = CLibPrefix + 'swscale-4'    + CLibExtension;
{$ELSEIF Defined(OSX)}
    error: no support
{$ELSEIF Defined(IOS)}
  {$IFDEF CPUARM}
    CLibPrefix    = 'lib';
    CLibExtension = '.a';
    _PU           = '';

    AVCODEC_LIBNAME    = CLibPrefix + 'avcodec57'   + CLibExtension;
    AVDEVICE_LIBNAME   = CLibPrefix + 'avdevice57'  + CLibExtension;
    AVFILTER_LIBNAME   = CLibPrefix + 'avfilter6'   + CLibExtension;
    AVFORMAT_LIBNAME   = CLibPrefix + 'avformat57'  + CLibExtension;
    AVUTIL_LIBNAME     = CLibPrefix + 'avutil55'    + CLibExtension;
    SWRESAMPLE_LIBNAME = CLibPrefix + 'swresample2' + CLibExtension;
    SWSCALE_LIBNAME    = CLibPrefix + 'swscale4'    + CLibExtension;
  {$ELSE CPUARM}
    error: no support
  {$ENDIF CPUARM}
{$ELSEIF Defined(ANDROID)}
    CLibPrefix    = 'lib';
    CLibExtension = '.so';
    _PU           = '';

    AVCODEC_LIBNAME    = CLibPrefix + 'avcodec'   + CLibExtension;
    AVDEVICE_LIBNAME   = CLibPrefix + 'avdevice'  + CLibExtension;
    AVFILTER_LIBNAME   = CLibPrefix + 'avfilter'   + CLibExtension;
    AVFORMAT_LIBNAME   = CLibPrefix + 'avformat'  + CLibExtension;
    AVUTIL_LIBNAME     = CLibPrefix + 'avutil'    + CLibExtension;
    SWRESAMPLE_LIBNAME = CLibPrefix + 'swresample' + CLibExtension;
    SWSCALE_LIBNAME    = CLibPrefix + 'swscale'    + CLibExtension;
{$ELSEIF Defined(Linux)}
    error: no support
{$IFEND}

type
  PPPByte    = ^PPByte;
  PPByte     = ^PByte;
  ByteArray  = array [0 .. $EFFFFFF] of Byte;
  PByteArray = ^ByteArray;
  PInteger   = ^Integer;
  PPInteger  = ^PInteger;

{$IFNDEF FPC}
{$IF defined(IOS) or defined(Android) or defined(Linux)}
  AnsiChar    = Byte;
  PAnsiChar   = MarshaledAString;
  PPAnsiChar  = ^PAnsiChar;
  PUTF8String = MarshaledString;
{$IFEND}
{$ENDIF FPC}


(* ****************************************************** *)
(* import libavutil_rational *)
(* ****************************************************** *)






(**
 * @defgroup lavu_math_rational AVRational
 * @ingroup lavu_math
 * Rational number calculation.
 *
 * While rational numbers can be expressed as floating-point numbers, the
 * conversion process is a lossy one, so are floating-point operations. On the
 * other hand, the nature of FFmpeg demands highly accurate calculation of
 * timestamps. This set of rational number utilities serves as a generic
 * interface for manipulating rational numbers as pairs of numerators and
 * denominators.
 *
 * Many of the functions that operate on AVRational's have the suffix `_q`, in
 * reference to the mathematical symbol "?" (Q) which denotes the set of all
 * rational numbers.
 *
 * @{
 *)

(**
 * Rational number (pair of numerator and denominator).
 *)
type
  PAVRational = ^TAVRational;
  TAVRational = record
    num: Integer; ///< Numerator
    den: Integer; ///< Denominator
  end;

(**
 * Create an AVRational.
 *
 * Useful for compilers that do not support compound literals.
 *
 * @note The return value is not reduced.
 * @see av_reduce()
 *)
function av_make_q(num, den: Integer): TAVRational;  {$IFDEF USE_INLINE}inline;{$ENDIF}
(*
{
    AVRational r = { num, den };
    return r;
}
*)

(**
 *
 * @param a First rational
 * @param b Second rational
 *
 * @return One of the following values:
 *         - 0 if `a == b`
 *         - 1 if `a > b`
 *         - -1 if `a < b`
 *         - `INT_MIN` if one of the values is of the form `0 / 0`
 *)
function av_cmp_q(a, b: TAVRational): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}
(*
{
    const int64_t tmp= a.num * (int64_t)b.den - b.num * (int64_t)a.den;

    if(tmp) return (int)((tmp ^ a.den ^ b.den)>>63)|1;
    else if(b.den && a.den) return 0;
    else if(a.num && b.num) return (a.num>>31) - (b.num>>31);
    else                    return INT_MIN;
}
*)

(**
 * Convert an AVRational to a `double`.
 * @param a AVRational to convert
 * @return `a` in floating-point form
 * @see av_d2q()
 *)
function av_q2d(a: TAVRational): Double;  {$IFDEF USE_INLINE}inline;{$ENDIF}
(*
{
    return a.num / (double) a.den;
}
*)

(**
 * Reduce a fraction.
 *
 * This is useful for framerate calculations.
 *
 * @param[out] dst_num Destination numerator
 * @param[out] dst_den Destination denominator
 * @param[in]      num Source numerator
 * @param[in]      den Source denominator
 * @param[in]      max Maximum allowed values for `dst_num` & `dst_den`
 * @return 1 if the operation is exact, 0 otherwise
 *)

{$IFDEF API_Dynamic}
var av_reduce : function(dst_num, dst_den: PInteger; num, den, max: Int64): Integer; cdecl;
{$ELSE API_Dynamic}
function av_reduce(dst_num, dst_den: PInteger; num, den, max: Int64): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_reduce';
{$ENDIF API_Dynamic}


(**
 * Multiply two rationals.
 * @param b First rational
 * @param c Second rational
 * @return b*c
 *)
function av_mul_q(b, c: TAVRational): TAVRational;  {$IFDEF USE_INLINE}inline;{$ENDIF}

(**
 * Divide one rational by another.
 * @param b First rational
 * @param c Second rational
 * @return b/c
 *)
function av_div_q(b, c: TAVRational): TAVRational;  {$IFDEF USE_INLINE}inline;{$ENDIF}

(**
 * Add two rationals.
 * @param b First rational
 * @param c Second rational
 * @return b+c
 *)
function av_add_q(b, c: TAVRational): TAVRational;  {$IFDEF USE_INLINE}inline;{$ENDIF}

(**
 * Subtract one rational from another.
 * @param b First rational
 * @param c Second rational
 * @return b-c
 *)
function av_sub_q(b, c: TAVRational): TAVRational;  {$IFDEF USE_INLINE}inline;{$ENDIF}

(**
 * Invert a rational.
 * @param q value
 * @return 1 / q
 *)
function av_inv_q(q: TAVRational): TAVRational;  {$IFDEF USE_INLINE}inline;{$ENDIF}
(*
{
    AVRational r = { q.den, q.num };
    return r;
}
*)

(**
 * Convert a double precision floating point number to a rational.
 *
 * In case of infinity, the returned value is expressed as `{1, 0}` or
 * `{-1, 0}` depending on the sign.
 *
 * @param d   `double` to convert
 * @param max Maximum allowed numerator and denominator
 * @return `d` in AVRational form
 * @see av_q2d()
 *)
function av_d2q(d: Double; max: Integer): TAVRational;  {$IFDEF USE_INLINE}inline;{$ENDIF}

(**
 * Find which of the two rationals is closer to another rational.
 *
 * @param q     Rational to be compared against
 * @param q1,q2 Rationals to be tested
 * @return One of the following values:
 *         - 1 if `q1` is nearer to `q` than `q2`
 *         - -1 if `q2` is nearer to `q` than `q1`
 *         - 0 if they have the same distance
 *)

{$IFDEF API_Dynamic}
var av_nearer_q : function(q, q1, q2: TAVRational): Integer; cdecl;
{$ELSE API_Dynamic}
function av_nearer_q(q, q1, q2: TAVRational): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_nearer_q';
{$ENDIF API_Dynamic}


(**
 * Find the value in a list of rationals nearest a given reference rational.
 *
 * @param q      Reference rational
 * @param q_list Array of rationals terminated by `{0, 0}`
 * @return Index of the nearest value found in the array
 *)

{$IFDEF API_Dynamic}
var av_find_nearest_q_idx : function(q: TAVRational; const q_list: PAVRational): Integer; cdecl;
{$ELSE API_Dynamic}
function av_find_nearest_q_idx(q: TAVRational; const q_list: PAVRational): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_find_nearest_q_idx';
{$ENDIF API_Dynamic}


(**
 * Convert an AVRational to a IEEE 32-bit `float` expressed in fixed-point
 * format.
 *
 * @param q Rational to be converted
 * @return Equivalent floating-point value, expressed as an unsigned 32-bit
 *         integer.
 * @note The returned value is platform-indepedant.
 *)

{$IFDEF API_Dynamic}
var av_q2intfloat : function(q: TAVRational): Cardinal; cdecl;
{$ELSE API_Dynamic}
function av_q2intfloat(q: TAVRational): Cardinal; cdecl; external AVUTIL_LIBNAME name _PU + 'av_q2intfloat';
{$ENDIF API_Dynamic}


(**
 * @}
 *)


(* ****************************************************** *)
(* import libavcodec_avfft *)
(* ****************************************************** *)






(**
 * @defgroup lavc_fft FFT functions
 * @ingroup lavc_misc
 *
 * @{
 *)

type
  PFFTSample = ^TFFTSample;
  TFFTSample = Single;

  PFFTComplex = ^TFFTComplex;
  TFFTComplex = record
    re, im: TFFTSample;
  end;

  PFFTContext = ^TFFTContext;
  TFFTContext = record
    // need {$ALIGN 8}
    // defined in libavcodec/fft.h
  end;

(**
 * Set up a complex FFT.
 * @param nbits           log2 of the length of the input array
 * @param inverse         if 0 perform the forward transform, if 1 perform the inverse
 *)

{$IFDEF API_Dynamic}
var av_fft_init : function(nbits, inverse: Integer): PFFTContext; cdecl;
{$ELSE API_Dynamic}
function av_fft_init(nbits, inverse: Integer): PFFTContext; cdecl; external AVCODEC_LIBNAME name _PU + 'av_fft_init';
{$ENDIF API_Dynamic}


(**
 * Do the permutation needed BEFORE calling ff_fft_calc().
 *)

{$IFDEF API_Dynamic}
var av_fft_permute : procedure(s: PFFTContext; z: PFFTComplex); cdecl;
{$ELSE API_Dynamic}
procedure av_fft_permute(s: PFFTContext; z: PFFTComplex); cdecl; external AVCODEC_LIBNAME name _PU + 'av_fft_permute';
{$ENDIF API_Dynamic}


(**
 * Do a complex FFT with the parameters defined in av_fft_init(). The
 * input data must be permuted before. No 1.0/sqrt(n) normalization is done.
 *)

{$IFDEF API_Dynamic}
var av_fft_calc : procedure(s: PFFTContext; z: PFFTComplex); cdecl;
{$ELSE API_Dynamic}
procedure av_fft_calc(s: PFFTContext; z: PFFTComplex); cdecl; external AVCODEC_LIBNAME name _PU + 'av_fft_calc';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_fft_end : procedure(s: PFFTContext); cdecl;
{$ELSE API_Dynamic}
procedure av_fft_end(s: PFFTContext); cdecl; external AVCODEC_LIBNAME name _PU + 'av_fft_end';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_mdct_init : function(nbits, inverse: Integer; scale: Double): PFFTContext; cdecl;
{$ELSE API_Dynamic}
function av_mdct_init(nbits, inverse: Integer; scale: Double): PFFTContext; cdecl; external AVCODEC_LIBNAME name _PU + 'av_mdct_init';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_imdct_calc : procedure(s: PFFTContext; output: PFFTSample; const input: PFFTSample); cdecl;
{$ELSE API_Dynamic}
procedure av_imdct_calc(s: PFFTContext; output: PFFTSample; const input: PFFTSample); cdecl; external AVCODEC_LIBNAME name _PU + 'av_imdct_calc';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_imdct_half : procedure(s: PFFTContext; output: PFFTSample; const input: PFFTSample); cdecl;
{$ELSE API_Dynamic}
procedure av_imdct_half(s: PFFTContext; output: PFFTSample; const input: PFFTSample); cdecl; external AVCODEC_LIBNAME name _PU + 'av_imdct_half';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_mdct_calc : procedure(s: PFFTContext; output: PFFTSample; const input: PFFTSample); cdecl;
{$ELSE API_Dynamic}
procedure av_mdct_calc(s: PFFTContext; output: PFFTSample; const input: PFFTSample); cdecl; external AVCODEC_LIBNAME name _PU + 'av_mdct_calc';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_mdct_end : procedure(s: PFFTContext); cdecl;
{$ELSE API_Dynamic}
procedure av_mdct_end(s: PFFTContext); cdecl; external AVCODEC_LIBNAME name _PU + 'av_mdct_end';
{$ENDIF API_Dynamic}


(* Real Discrete Fourier Transform *)
type
  TRDFTransformType = (
      DFT_R2C,
      IDFT_C2R,
      IDFT_R2C,
      DFT_C2R
    );

  PRDFTContext = ^TRDFTContext;
  TRDFTContext = record
    // need {$ALIGN 8}
    // defined in libavcodec/rdft.h
  end;

(**
 * Set up a real FFT.
 * @param nbits           log2 of the length of the input array
 * @param trans           the type of transform
 *)

{$IFDEF API_Dynamic}
var av_rdft_init : function(nbits: Integer; trans: TRDFTransformType): PRDFTContext; cdecl;
{$ELSE API_Dynamic}
function av_rdft_init(nbits: Integer; trans: TRDFTransformType): PRDFTContext; cdecl; external AVCODEC_LIBNAME name _PU + 'av_rdft_init';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_rdft_calc : procedure(s: PRDFTContext; data: PFFTSample); cdecl;
{$ELSE API_Dynamic}
procedure av_rdft_calc(s: PRDFTContext; data: PFFTSample); cdecl; external AVCODEC_LIBNAME name _PU + 'av_rdft_calc';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_rdft_end : procedure(s: PRDFTContext); cdecl;
{$ELSE API_Dynamic}
procedure av_rdft_end(s: PRDFTContext); cdecl; external AVCODEC_LIBNAME name _PU + 'av_rdft_end';
{$ENDIF API_Dynamic}


(* Discrete Cosine Transform *)
type
  PDCTContext = ^TDCTContext;
  TDCTContext = record
    // need {$ALIGN 8}
    // defined in libavcodec/dct.h
  end;

  TDCTTransformType = (
    DCT_II = 0,
    DCT_III,
    DCT_I,
    DST_I
  );

(**
 * Set up DCT.
 *
 * @param nbits           size of the input array:
 *                        (1 << nbits)     for DCT-II, DCT-III and DST-I
 *                        (1 << nbits) + 1 for DCT-I
 * @param type            the type of transform
 *
 * @note the first element of the input of DST-I is ignored
 *)

{$IFDEF API_Dynamic}
var av_dct_init : function(nbits: Integer; ttype: TDCTTransformType): PDCTContext; cdecl;
{$ELSE API_Dynamic}
function av_dct_init(nbits: Integer; ttype: TDCTTransformType): PDCTContext; cdecl; external AVCODEC_LIBNAME name _PU + 'av_dct_init';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_dct_calc : procedure(s: PDCTContext; data: PFFTSample); cdecl;
{$ELSE API_Dynamic}
procedure av_dct_calc(s: PDCTContext; data: PFFTSample); cdecl; external AVCODEC_LIBNAME name _PU + 'av_dct_calc';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_dct_end : procedure(s: PDCTContext); cdecl;
{$ELSE API_Dynamic}
procedure av_dct_end(s: PDCTContext); cdecl; external AVCODEC_LIBNAME name _PU + 'av_dct_end';
{$ENDIF API_Dynamic}


(**
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_avstring *)
(* ****************************************************** *)






(**
 * @addtogroup lavu_string
 * @{
 *)

(**
 * Return non-zero if pfx is a prefix of str. If it is, *ptr is set to
 * the address of the first character in str after the prefix.
 *
 * @param str input string
 * @param pfx prefix to test
 * @param ptr updated if the prefix is matched inside str
 * @return non-zero if the prefix matches, zero otherwise
 *)

{$IFDEF API_Dynamic}
var av_strstart : function(const str, pfx: PAnsiChar; const ptr: PPAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_strstart(const str, pfx: PAnsiChar; const ptr: PPAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strstart';
{$ENDIF API_Dynamic}


(**
 * Return non-zero if pfx is a prefix of str independent of case. If
 * it is, *ptr is set to the address of the first character in str
 * after the prefix.
 *
 * @param str input string
 * @param pfx prefix to test
 * @param ptr updated if the prefix is matched inside str
 * @return non-zero if the prefix matches, zero otherwise
 *)

{$IFDEF API_Dynamic}
var av_stristart : function(const str, pfx: PAnsiChar; const ptr: PPAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_stristart(const str, pfx: PAnsiChar; const ptr: PPAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_stristart';
{$ENDIF API_Dynamic}


(**
 * Locate the first case-independent occurrence in the string haystack
 * of the string needle.  A zero-length string needle is considered to
 * match at the start of haystack.
 *
 * This function is a case-insensitive version of the standard strstr().
 *
 * @param haystack string to search in
 * @param needle   string to search for
 * @return         pointer to the located match within haystack
 *                 or a null pointer if no match
 *)

{$IFDEF API_Dynamic}
var av_stristr : function(const haystack, needle: PAnsiChar): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_stristr(const haystack, needle: PAnsiChar): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_stristr';
{$ENDIF API_Dynamic}


(**
 * Locate the first occurrence of the string needle in the string haystack
 * where not more than hay_length characters are searched. A zero-length
 * string needle is considered to match at the start of haystack.
 *
 * This function is a length-limited version of the standard strstr().
 *
 * @param haystack   string to search in
 * @param needle     string to search for
 * @param hay_length length of string to search in
 * @return           pointer to the located match within haystack
 *                   or a null pointer if no match
 *)

{$IFDEF API_Dynamic}
var av_strnstr : function(const haystack, needle: PAnsiChar; hay_length: Cardinal): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_strnstr(const haystack, needle: PAnsiChar; hay_length: Cardinal): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strnstr';
{$ENDIF API_Dynamic}


(**
 * Copy the string src to dst, but no more than size - 1 bytes, and
 * null-terminate dst.
 *
 * This function is the same as BSD strlcpy().
 *
 * @param dst destination buffer
 * @param src source string
 * @param size size of destination buffer
 * @return the length of src
 *
 * @warning since the return value is the length of src, src absolutely
 * _must_ be a properly 0-terminated string, otherwise this will read beyond
 * the end of the buffer and possibly crash.
 *)

{$IFDEF API_Dynamic}
var av_strlcpy : function(dst: PAnsiChar; const src: PAnsiChar; size: Cardinal{size_t}): Cardinal; cdecl;
{$ELSE API_Dynamic}
function av_strlcpy(dst: PAnsiChar; const src: PAnsiChar; size: Cardinal{size_t}): Cardinal{size_t}; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strlcpy';
{$ENDIF API_Dynamic}


(**
 * Append the string src to the string dst, but to a total length of
 * no more than size - 1 bytes, and null-terminate dst.
 *
 * This function is similar to BSD strlcat(), but differs when
 * size <= strlen(dst).
 *
 * @param dst destination buffer
 * @param src source string
 * @param size size of destination buffer
 * @return the total length of src and dst
 *
 * @warning since the return value use the length of src and dst, these
 * absolutely _must_ be a properly 0-terminated strings, otherwise this
 * will read beyond the end of the buffer and possibly crash.
 *)

{$IFDEF API_Dynamic}
var av_strlcat : function(dst: PAnsiChar; const src: PAnsiChar; size: Cardinal{size_t}): Cardinal; cdecl;
{$ELSE API_Dynamic}
function av_strlcat(dst: PAnsiChar; const src: PAnsiChar; size: Cardinal{size_t}): Cardinal{size_t}; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strlcat';
{$ENDIF API_Dynamic}


(**
 * Append output to a string, according to a format. Never write out of
 * the destination buffer, and always put a terminating 0 within
 * the buffer.
 * @param dst destination buffer (string to which the output is
 *  appended)
 * @param size total size of the destination buffer
 * @param fmt printf-compatible format string, specifying how the
 *  following parameters are used
 * @return the length of the string that would have been generated
 *  if enough space had been available
 *)

{$IFDEF API_Dynamic}
var av_strlcatf : function(dst: PAnsiChar; size: Cardinal{size_t}; const fmt: PAnsiChar): Cardinal; cdecl;
{$ELSE API_Dynamic}
function av_strlcatf(dst: PAnsiChar; size: Cardinal{size_t}; const fmt: PAnsiChar): Cardinal{size_t}; cdecl varargs; external AVUTIL_LIBNAME name _PU + 'av_strlcatf';
{$ENDIF API_Dynamic}


(**
 * Get the count of continuous non zero chars starting from the beginning.
 *
 * @param len maximum number of characters to check in the string, that
 *            is the maximum value which is returned by the function
 *)
//static inline size_t av_strnlen(const char *s, size_t len)
{
    size_t i;
    for (i = 0; i < len && s[i]; i++)
        ;
    return i;
}

(**
 * Print arguments following specified format into a large enough auto
 * allocated buffer. It is similar to GNU asprintf().
 * @param fmt printf-compatible format string, specifying how the
 *            following parameters are used.
 * @return the allocated string
 * @note You have to free the string yourself with av_free().
 *)

{$IFDEF API_Dynamic}
var av_asprintf : function(const fmt: PAnsiChar): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_asprintf(const fmt: PAnsiChar): PAnsiChar; cdecl varargs; external AVUTIL_LIBNAME name _PU + 'av_asprintf';
{$ENDIF API_Dynamic}


(**
 * Convert a number to an av_malloced string.
 *)

{$IFDEF API_Dynamic}
var av_d2str : function(d: Double): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_d2str(d: Double): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_d2str';
{$ENDIF API_Dynamic}


(**
 * Unescape the given string until a non escaped terminating char,
 * and return the token corresponding to the unescaped string.
 *
 * The normal \ and ' escaping is supported. Leading and trailing
 * whitespaces are removed, unless they are escaped with '\' or are
 * enclosed between ''.
 *
 * @param buf the buffer to parse, buf will be updated to point to the
 * terminating char
 * @param term a 0-terminated list of terminating chars
 * @return the malloced unescaped string, which must be av_freed by
 * the user, NULL in case of allocation failure
 *)

{$IFDEF API_Dynamic}
var av_get_token : function(const buf: PPAnsiChar; const term: PAnsiChar): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_token(const buf: PPAnsiChar; const term: PAnsiChar): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_token';
{$ENDIF API_Dynamic}


(**
 * Split the string into several tokens which can be accessed by
 * successive calls to av_strtok().
 *
 * A token is defined as a sequence of characters not belonging to the
 * set specified in delim.
 *
 * On the first call to av_strtok(), s should point to the string to
 * parse, and the value of saveptr is ignored. In subsequent calls, s
 * should be NULL, and saveptr should be unchanged since the previous
 * call.
 *
 * This function is similar to strtok_r() defined in POSIX.1.
 *
 * @param s the string to parse, may be NULL
 * @param delim 0-terminated list of token delimiters, must be non-NULL
 * @param saveptr user-provided pointer which points to stored
 * information necessary for av_strtok() to continue scanning the same
 * string. saveptr is updated to point to the next character after the
 * first delimiter found, or to NULL if the string was terminated
 * @return the found token, or NULL when no token is found
 *)

{$IFDEF API_Dynamic}
var av_strtok : function(s: PAnsiChar; const delim: PAnsiChar; saveptr: PPAnsiChar): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_strtok(s: PAnsiChar; const delim: PAnsiChar; saveptr: PPAnsiChar): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strtok';
{$ENDIF API_Dynamic}


(**
 * Locale-independent conversion of ASCII isdigit.
 *)
//static inline av_const int av_isdigit(int c)
{
    return c >= '0' && c <= '9';
}

(**
 * Locale-independent conversion of ASCII isgraph.
 *)
//static inline av_const int av_isgraph(int c)
{
    return c > 32 && c < 127;
}

(**
 * Locale-independent conversion of ASCII isspace.
 *)
//static inline av_const int av_isspace(int c)
{
    return c == ' ' || c == '\f' || c == '\n' || c == '\r' || c == '\t' ||
           c == '\v';
}

(**
 * Locale-independent conversion of ASCII characters to uppercase.
 *)
//static inline int av_toupper(int c)
{
    if (c >= 'a' && c <= 'z')
        c ^= 0x20;
    return c;
}

(**
 * Locale-independent conversion of ASCII characters to lowercase.
 *)
//static inline int av_tolower(int c)
{
    if (c >= 'A' && c <= 'Z')
        c ^= 0x20;
    return c;
}

(**
 * Locale-independent conversion of ASCII isxdigit.
 *)
//static inline av_const int av_isxdigit(int c)
{
    c = av_tolower(c);
    return av_isdigit(c) || (c >= 'a' && c <= 'f');
}

(**
 * Locale-independent case-insensitive compare.
 * @note This means only ASCII-range characters are case-insensitive
 *)

{$IFDEF API_Dynamic}
var av_strcasecmp : function(const a, b: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_strcasecmp(const a, b: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strcasecmp';
{$ENDIF API_Dynamic}


(**
 * Locale-independent case-insensitive compare.
 * @note This means only ASCII-range characters are case-insensitive
 *)

{$IFDEF API_Dynamic}
var av_strncasecmp : function(const a, b: PAnsiChar; n: Cardinal{size_t}): Integer; cdecl;
{$ELSE API_Dynamic}
function av_strncasecmp(const a, b: PAnsiChar; n: Cardinal{size_t}): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strncasecmp';
{$ENDIF API_Dynamic}


(**
 * Locale-independent strings replace.
 * @note This means only ASCII-range characters are replace
 *)

{$IFDEF API_Dynamic}
var av_strireplace : function(const str, from, to_: PAnsiChar): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_strireplace(const str, from, to_: PAnsiChar): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strireplace';
{$ENDIF API_Dynamic}


(**
 * Thread safe basename.
 * @param path the path, on DOS both \ and / are considered separators.
 * @return pointer to the basename substring.
 *)

{$IFDEF API_Dynamic}
var av_basename : function(const path: PAnsiChar): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_basename(const path: PAnsiChar): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_basename';
{$ENDIF API_Dynamic}


(**
 * Thread safe dirname.
 * @param path the path, on DOS both \ and / are considered separators.
 * @return the path with the separator replaced by the string terminator or ".".
 * @note the function may change the input string.
 *)

{$IFDEF API_Dynamic}
var av_dirname : function(path: PAnsiChar): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_dirname(path: PAnsiChar): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_dirname';
{$ENDIF API_Dynamic}


(**
 * Match instances of a name in a comma-separated list of names.
 * List entries are checked from the start to the end of the names list,
 * the first match ends further processing. If an entry prefixed with '-'
 * matches, then 0 is returned. The "ALL" list entry is considered to
 * match all names.
 *
 * @param name  Name to look for.
 * @param names List of names.
 * @return 1 on match, 0 otherwise.
 *)

{$IFDEF API_Dynamic}
var av_match_name : function(const name, names: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_match_name(const name, names: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_match_name';
{$ENDIF API_Dynamic}


{**
 * Append path component to the existing path.
 * Path separator '/' is placed between when needed.
 * Resulting string have to be freed with av_free().
 * @param path      base path
 * @param component component to be appended
 * @return new path or NULL on error.
 *}

{$IFDEF API_Dynamic}
var av_append_path_component : function(const path: PAnsiChar; const component: PAnsiChar): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_append_path_component(const path: PAnsiChar; const component: PAnsiChar): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_append_path_component';
{$ENDIF API_Dynamic}


type
  TAVEscapeMode = (
    AV_ESCAPE_MODE_AUTO,      ///< Use auto-selected escaping mode.
    AV_ESCAPE_MODE_BACKSLASH, ///< Use backslash escaping.
    AV_ESCAPE_MODE_QUOTE      ///< Use single-quote escaping.
  );

(**
 * Consider spaces special and escape them even in the middle of the
 * string.
 *
 * This is equivalent to adding the whitespace characters to the special
 * characters lists, except it is guaranteed to use the exact same list
 * of whitespace characters as the rest of libavutil.
 *)
const
  AV_ESCAPE_FLAG_WHITESPACE = $01;

(**
 * Escape only specified special characters.
 * Without this flag, escape also any characters that may be considered
 * special by av_get_token(), such as the single quote.
 *)
  AV_ESCAPE_FLAG_STRICT = $02;

(**
 * Escape string in src, and put the escaped string in an allocated
 * string in *dst, which must be freed with av_free().
 *
 * @param dst           pointer where an allocated string is put
 * @param src           string to escape, must be non-NULL
 * @param special_chars string containing the special characters which
 *                      need to be escaped, can be NULL
 * @param mode          escape mode to employ, see AV_ESCAPE_MODE_* macros.
 *                      Any unknown value for mode will be considered equivalent to
 *                      AV_ESCAPE_MODE_BACKSLASH, but this behaviour can change without
 *                      notice.
 * @param flags         flags which control how to escape, see AV_ESCAPE_FLAG_ macros
 * @return the length of the allocated string, or a negative error code in case of error
 * @see av_bprint_escape()
 *)

{$IFDEF API_Dynamic}
var av_escape : function(dst: PAnsiChar; const src, special_chars: PAnsiChar;
                  mode: TAVEscapeMode; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_escape(dst: PAnsiChar; const src, special_chars: PAnsiChar;
                  mode: TAVEscapeMode; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_escape';
{$ENDIF API_Dynamic}


const
  AV_UTF8_FLAG_ACCEPT_INVALID_BIG_CODES          = 1; ///< accept codepoints over 0x10FFFF
  AV_UTF8_FLAG_ACCEPT_NON_CHARACTERS             = 2; ///< accept non-characters - 0xFFFE and 0xFFFF
  AV_UTF8_FLAG_ACCEPT_SURROGATES                 = 4; ///< accept UTF-16 surrogates codes
  AV_UTF8_FLAG_EXCLUDE_XML_INVALID_CONTROL_CODES = 8; ///< exclude control codes not accepted by XML

  AV_UTF8_FLAG_ACCEPT_ALL =
    AV_UTF8_FLAG_ACCEPT_INVALID_BIG_CODES or AV_UTF8_FLAG_ACCEPT_NON_CHARACTERS or AV_UTF8_FLAG_ACCEPT_SURROGATES;

(**
 * Read and decode a single UTF-8 code point (character) from the
 * buffer in *buf, and update *buf to point to the next byte to
 * decode.
 *
 * In case of an invalid byte sequence, the pointer will be updated to
 * the next byte after the invalid sequence and the function will
 * return an error code.
 *
 * Depending on the specified flags, the function will also fail in
 * case the decoded code point does not belong to a valid range.
 *
 * @note For speed-relevant code a carefully implemented use of
 * GET_UTF8() may be preferred.
 *
 * @param codep   pointer used to return the parsed code in case of success.
 *                The value in *codep is set even in case the range check fails.
 * @param bufp    pointer to the address the first byte of the sequence
 *                to decode, updated by the function to point to the
 *                byte next after the decoded sequence
 * @param buf_end pointer to the end of the buffer, points to the next
 *                byte past the last in the buffer. This is used to
 *                avoid buffer overreads (in case of an unfinished
 *                UTF-8 sequence towards the end of the buffer).
 * @param flags   a collection of AV_UTF8_FLAG_* flags
 * @return >= 0 in case a sequence was successfully read, a negative
 * value in case of invalid sequence
 *)

{$IFDEF API_Dynamic}
var av_utf8_decode : function(codep: PLongInt; const bufp: PPByte; const buf_end: PByte;
                   flags: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function av_utf8_decode(codep: PLongInt; const bufp: PPByte; const buf_end: PByte;
                   flags: Cardinal): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_utf8_decode';
{$ENDIF API_Dynamic}


(**
 * Check if a name is in a list.
 * @returns 0 if not found, or the 1 based index where it has been found in the
 *            list.
 *)

{$IFDEF API_Dynamic}
var av_match_list : function(const name, list: PAnsiChar; separator: AnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_match_list(const name, list: PAnsiChar; separator: AnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_match_list';
{$ENDIF API_Dynamic}


(**
 * @}
 *)

function av_strnlen(const s: PAnsiChar; len: Cardinal): Cardinal;  {$IFDEF USE_INLINE}inline;{$ENDIF}


(* ****************************************************** *)
(* import libavutil_buffer *)
(* ****************************************************** *)






(**
 * @defgroup lavu_buffer AVBuffer
 * @ingroup lavu_data
 *
 * @{
 * AVBuffer is an API for reference-counted data buffers.
 *
 * There are two core objects in this API -- AVBuffer and AVBufferRef. AVBuffer
 * represents the data buffer itself; it is opaque and not meant to be accessed
 * by the caller directly, but only through AVBufferRef. However, the caller may
 * e.g. compare two AVBuffer pointers to check whether two different references
 * are describing the same data buffer. AVBufferRef represents a single
 * reference to an AVBuffer and it is the object that may be manipulated by the
 * caller directly.
 *
 * There are two functions provided for creating a new AVBuffer with a single
 * reference -- av_buffer_alloc() to just allocate a new buffer, and
 * av_buffer_create() to wrap an existing array in an AVBuffer. From an existing
 * reference, additional references may be created with av_buffer_ref().
 * Use av_buffer_unref() to free a reference (this will automatically free the
 * data once all the references are freed).
 *
 * The convention throughout this API and the rest of FFmpeg is such that the
 * buffer is considered writable if there exists only one reference to it (and
 * it has not been marked as read-only). The av_buffer_is_writable() function is
 * provided to check whether this is true and av_buffer_make_writable() will
 * automatically create a new writable buffer when necessary.
 * Of course nothing prevents the calling code from violating this convention,
 * however that is safe only when all the existing references are under its
 * control.
 *
 * @note Referencing and unreferencing the buffers is thread-safe and thus
 * may be done from multiple threads simultaneously without any need for
 * additional locking.
 *
 * @note Two different references to the same buffer can point to different
 * parts of the buffer (i.e. their AVBufferRef.data will not be equal).
 *)

(**
 * A reference counted buffer type. It is opaque and is meant to be used through
 * references (AVBufferRef).
 *)
type
  PAVBuffer = ^TAVBuffer;
  TAVBuffer = record
    // need {$ALIGN 8}
    // defined libavutil/buffer_internal.h
  end;

(**
 * A reference to a data buffer.
 *
 * The size of this struct is not a part of the public ABI and it is not meant
 * to be allocated directly.
 *)
  PPAVBufferRef = ^PAVBufferRef;
  PAVBufferRef = ^TAVBufferRef;
  TAVBufferRef = record
    buffer: PAVBuffer;

    (**
     * The data buffer. It is considered writable if and only if
     * this is the only reference to the buffer, in which case
     * av_buffer_is_writable() returns 1.
     *)
    data: PByte;
    (**
     * Size of data in bytes.
     *)
    size: Integer;
  end;

(**
 * Allocate an AVBuffer of the given size using av_malloc().
 *
 * @return an AVBufferRef of given size or NULL when out of memory
 *)

{$IFDEF API_Dynamic}
var av_buffer_alloc : function(size: Integer): PAVBufferRef; cdecl;
{$ELSE API_Dynamic}
function av_buffer_alloc(size: Integer): PAVBufferRef; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_alloc';
{$ENDIF API_Dynamic}


(**
 * Same as av_buffer_alloc(), except the returned buffer will be initialized
 * to zero.
 *)

{$IFDEF API_Dynamic}
var av_buffer_allocz : function(size: Integer): PAVBufferRef; cdecl;
{$ELSE API_Dynamic}
function av_buffer_allocz(size: Integer): PAVBufferRef; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_allocz';
{$ENDIF API_Dynamic}


(**
 * Always treat the buffer as read-only, even when it has only one
 * reference.
 *)
const
  AV_BUFFER_FLAG_READONLY = (1 shl 0);

(**
 * Create an AVBuffer from an existing array.
 *
 * If this function is successful, data is owned by the AVBuffer. The caller may
 * only access data through the returned AVBufferRef and references derived from
 * it.
 * If this function fails, data is left untouched.
 * @param data   data array
 * @param size   size of data in bytes
 * @param free   a callback for freeing this buffer's data
 * @param opaque parameter to be got for processing or passed to free
 * @param flags  a combination of AV_BUFFER_FLAG_*
 *
 * @return an AVBufferRef referring to data on success, NULL on failure.
 *)
type
  TfreeCall = procedure(opaque: Pointer; data: PByte); cdecl;

{$IFDEF API_Dynamic}
var av_buffer_create : function(data: PByte; size: Integer; free: TfreeCall;
                              opaque: Pointer; flags: Integer): PAVBufferRef; cdecl;
{$ELSE API_Dynamic}
function av_buffer_create(data: PByte; size: Integer; free: TfreeCall;
                              opaque: Pointer; flags: Integer): PAVBufferRef; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_create';
{$ENDIF API_Dynamic}


(**
 * Default free callback, which calls av_free() on the buffer data.
 * This function is meant to be passed to av_buffer_create(), not called
 * directly.
 *)

{$IFDEF API_Dynamic}
var av_buffer_default_free : procedure(opaque: Pointer; data: PByte); cdecl;
{$ELSE API_Dynamic}
procedure av_buffer_default_free(opaque: Pointer; data: PByte); cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_default_free';
{$ENDIF API_Dynamic}


(**
 * Create a new reference to an AVBuffer.
 *
 * @return a new AVBufferRef referring to the same AVBuffer as buf or NULL on
 * failure.
 *)

{$IFDEF API_Dynamic}
var av_buffer_ref : function(buf: PAVBufferRef): PAVBufferRef; cdecl;
{$ELSE API_Dynamic}
function av_buffer_ref(buf: PAVBufferRef): PAVBufferRef; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_ref';
{$ENDIF API_Dynamic}


(**
 * Free a given reference and automatically free the buffer if there are no more
 * references to it.
 *
 * @param buf the reference to be freed. The pointer is set to NULL on return.
 *)

{$IFDEF API_Dynamic}
var av_buffer_unref : procedure(buf: PPAVBufferRef); cdecl;
{$ELSE API_Dynamic}
procedure av_buffer_unref(buf: PPAVBufferRef); cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_unref';
{$ENDIF API_Dynamic}


(**
 * @return 1 if the caller may write to the data referred to by buf (which is
 * true if and only if buf is the only reference to the underlying AVBuffer).
 * Return 0 otherwise.
 * A positive answer is valid until av_buffer_ref() is called on buf.
 *)

{$IFDEF API_Dynamic}
var av_buffer_is_writable : function(const buf: PAVBufferRef): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffer_is_writable(const buf: PAVBufferRef): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_is_writable';
{$ENDIF API_Dynamic}


(**
 * @return the opaque parameter set by av_buffer_create.
 *)

{$IFDEF API_Dynamic}
var av_buffer_get_opaque : function(const buf: PAVBufferRef): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_buffer_get_opaque(const buf: PAVBufferRef): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_get_opaque';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_buffer_get_ref_count : function(const buf: PAVBufferRef): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffer_get_ref_count(const buf: PAVBufferRef): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_get_ref_count';
{$ENDIF API_Dynamic}


(**
 * Create a writable reference from a given buffer reference, avoiding data copy
 * if possible.
 *
 * @param buf buffer reference to make writable. On success, buf is either left
 *            untouched, or it is unreferenced and a new writable AVBufferRef is
 *            written in its place. On failure, buf is left untouched.
 * @return 0 on success, a negative AVERROR on failure.
 *)

{$IFDEF API_Dynamic}
var av_buffer_make_writable : function(buf: PPAVBufferRef): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffer_make_writable(buf: PPAVBufferRef): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_make_writable';
{$ENDIF API_Dynamic}


(**
 * Reallocate a given buffer.
 *
 * @param buf  a buffer reference to reallocate. On success, buf will be
 *             unreferenced and a new reference with the required size will be
 *             written in its place. On failure buf will be left untouched. *buf
 *             may be NULL, then a new buffer is allocated.
 * @param size required new buffer size.
 * @return 0 on success, a negative AVERROR on failure.
 *
 * @note the buffer is actually reallocated with av_realloc() only if it was
 * initially allocated through av_buffer_realloc(NULL) and there is only one
 * reference to it (i.e. the one passed to this function). In all other cases
 * a new buffer is allocated and the data is copied.
 *)

{$IFDEF API_Dynamic}
var av_buffer_realloc : function(buf: PPAVBufferRef; size: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffer_realloc(buf: PPAVBufferRef; size: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_realloc';
{$ENDIF API_Dynamic}


(**
 * @}
 *)

(**
 * @defgroup lavu_bufferpool AVBufferPool
 * @ingroup lavu_data
 *
 * @{
 * AVBufferPool is an API for a lock-free thread-safe pool of AVBuffers.
 *
 * Frequently allocating and freeing large buffers may be slow. AVBufferPool is
 * meant to solve this in cases when the caller needs a set of buffers of the
 * same size (the most obvious use case being buffers for raw video or audio
 * frames).
 *
 * At the beginning, the user must call av_buffer_pool_init() to create the
 * buffer pool. Then whenever a buffer is needed, call av_buffer_pool_get() to
 * get a reference to a new buffer, similar to av_buffer_alloc(). This new
 * reference works in all aspects the same way as the one created by
 * av_buffer_alloc(). However, when the last reference to this buffer is
 * unreferenced, it is returned to the pool instead of being freed and will be
 * reused for subsequent av_buffer_pool_get() calls.
 *
 * When the caller is done with the pool and no longer needs to allocate any new
 * buffers, av_buffer_pool_uninit() must be called to mark the pool as freeable.
 * Once all the buffers are released, it will automatically be freed.
 *
 * Allocating and releasing buffers with this API is thread-safe as long as
 * either the default alloc callback is used, or the user-supplied one is
 * thread-safe.
 *)

(**
 * The buffer pool. This structure is opaque and not meant to be accessed
 * directly. It is allocated with av_buffer_pool_init() and freed with
 * av_buffer_pool_uninit().
 *)
type
  PPAVBufferPool = ^PAVBufferPool;
  PAVBufferPool = ^TAVBufferPool;
  TAVBufferPool = record
    // need {$ALIGN 8}
    // defined libavutil/buffer_internal.h
  end;

(**
 * Allocate and initialize a buffer pool.
 *
 * @param size size of each buffer in this pool
 * @param alloc a function that will be used to allocate new buffers when the
 * pool is empty. May be NULL, then the default allocator will be used
 * (av_buffer_alloc()).
 * @return newly created buffer pool on success, NULL on error.
 *)
  TallocCall = function(size: Integer): PAVBufferRef; cdecl;

{$IFDEF API_Dynamic}
var av_buffer_pool_init : function(size: Integer; alloc: TallocCall): PAVBufferPool; cdecl;
{$ELSE API_Dynamic}
function av_buffer_pool_init(size: Integer; alloc: TallocCall): PAVBufferPool; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_pool_init';
{$ENDIF API_Dynamic}


(**
 * Allocate and initialize a buffer pool with a more complex allocator.
 *
 * @param size size of each buffer in this pool
 * @param opaque arbitrary user data used by the allocator
 * @param alloc a function that will be used to allocate new buffers when the
 *              pool is empty.
 * @param pool_free a function that will be called immediately before the pool
 *                  is freed. I.e. after av_buffer_pool_uninit() is called
 *                  by the caller and all the frames are returned to the pool
 *                  and freed. It is intended to uninitialize the user opaque
 *                  data.
 * @return newly created buffer pool on success, NULL on error.
 *)
type
  Talloc2Call = function(opaque: Pointer; size: Integer): PAVBufferRef; cdecl;
  Tfree2Call = procedure(opaque: POinter); cdecl;

{$IFDEF API_Dynamic}
var av_buffer_pool_init2 : function(size: Integer; opaque: Pointer;
                                   alloc: Talloc2Call;
                                   pool_free: Tfree2Call): PAVBufferPool; cdecl;
{$ELSE API_Dynamic}
function av_buffer_pool_init2(size: Integer; opaque: Pointer;
                                   alloc: Talloc2Call;
                                   pool_free: Tfree2Call): PAVBufferPool; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_pool_init2';
{$ENDIF API_Dynamic}


(**
 * Mark the pool as being available for freeing. It will actually be freed only
 * once all the allocated buffers associated with the pool are released. Thus it
 * is safe to call this function while some of the allocated buffers are still
 * in use.
 *
 * @param pool pointer to the pool to be freed. It will be set to NULL.
 *)

{$IFDEF API_Dynamic}
var av_buffer_pool_uninit : procedure(pool: PPAVBufferPool); cdecl;
{$ELSE API_Dynamic}
procedure av_buffer_pool_uninit(pool: PPAVBufferPool); cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_pool_uninit';
{$ENDIF API_Dynamic}


(**
 * Allocate a new AVBuffer, reusing an old buffer from the pool when available.
 * This function may be called simultaneously from multiple threads.
 *
 * @return a reference to the new buffer on success, NULL on error.
 *)

{$IFDEF API_Dynamic}
var av_buffer_pool_get : function(pool: PAVBufferPool): PAVBufferRef; cdecl;
{$ELSE API_Dynamic}
function av_buffer_pool_get(pool: PAVBufferPool): PAVBufferRef; cdecl; external AVUTIL_LIBNAME name _PU + 'av_buffer_pool_get';
{$ENDIF API_Dynamic}


(**
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_dict *)
(* ****************************************************** *)






(**
 * @addtogroup lavu_dict AVDictionary
 * @ingroup lavu_data
 *
 * @brief Simple key:value store
 *
 * @{
 * Dictionaries are used for storing key:value pairs. To create
 * an AVDictionary, simply pass an address of a NULL pointer to
 * av_dict_set(). NULL can be used as an empty dictionary wherever
 * a pointer to an AVDictionary is required.
 * Use av_dict_get() to retrieve an entry or iterate over all
 * entries and finally av_dict_free() to free the dictionary
 * and all its contents.
 *
 @code
   AVDictionary *d = NULL;           // "create" an empty dictionary
   AVDictionaryEntry *t = NULL;

   av_dict_set(&d, "foo", "bar", 0); // add an entry

   char *k = av_strdup("key");       // if your strings are already allocated,
   char *v = av_strdup("value");     // you can avoid copying them like this
   av_dict_set(&d, k, v, AV_DICT_DONT_STRDUP_KEY | AV_DICT_DONT_STRDUP_VAL);

   while (t = av_dict_get(d, "", t, AV_DICT_IGNORE_SUFFIX)) {
       <....>                             // iterate over all entries in d
   }
   av_dict_free(&d);
 @endcode
 *)

const
  AV_DICT_MATCH_CASE      = 1;    (**< Only get an entry with exact-case key match. Only relevant in av_dict_get(). *)
  AV_DICT_IGNORE_SUFFIX   = 2;    (**< Return first entry in a dictionary whose first part corresponds to the search key,
                                       ignoring the suffix of the found key string. Only relevant in av_dict_get(). *)
  AV_DICT_DONT_STRDUP_KEY = 4;    (**< Take ownership of a key that's been
                                       allocated with av_malloc() or another memory allocation function. *)
  AV_DICT_DONT_STRDUP_VAL = 8;    (**< Take ownership of a value that's been
                                       allocated with av_malloc() or another memory allocation function. *)
  AV_DICT_DONT_OVERWRITE  = 16;   ///< Don't overwrite existing entries.
  AV_DICT_APPEND          = 32;   (**< If the entry already exists, append to it.  Note that no
                                    delimiter is added, the strings are simply concatenated. *)
  AV_DICT_MULTIKEY        = 64;   (**< Allow to store several equal keys in the dictionary *)

type
  PAVDictionaryEntry = ^TAVDictionaryEntry;
  TAVDictionaryEntry = record
    key: PAnsiChar;
    value: PAnsiChar;
  end;

  PPAVDictionary = ^PAVDictionary;
  PAVDictionary = ^TAVDictionary;
  TAVDictionary = record
    // defined in libavutil/dict.h
    count: Integer;
    elems: PAVDictionaryEntry;
  end;

(**
 * Get a dictionary entry with matching key.
 *
 * The returned entry key or value must not be changed, or it will
 * cause undefined behavior.
 *
 * To iterate through all the dictionary entries, you can set the matching key
 * to the null string "" and set the AV_DICT_IGNORE_SUFFIX flag.
 *
 * @param prev Set to the previous matching element to find the next.
 *             If set to NULL the first matching element is returned.
 * @param key matching key
 * @param flags a collection of AV_DICT_* flags controlling how the entry is retrieved
 * @return found entry or NULL in case no matching entry was found in the dictionary
 *)

{$IFDEF API_Dynamic}
var av_dict_get : function(const m: PAVDictionary; const key: PAnsiChar; const prev: PAVDictionaryEntry; flags: Integer): PAVDictionaryEntry; cdecl;
{$ELSE API_Dynamic}
function av_dict_get(const m: PAVDictionary; const key: PAnsiChar; const prev: PAVDictionaryEntry; flags: Integer): PAVDictionaryEntry; cdecl; external AVUTIL_LIBNAME name _PU + 'av_dict_get';
{$ENDIF API_Dynamic}


(**
 * Get number of entries in dictionary.
 *
 * @param m dictionary
 * @return  number of entries in dictionary
 *)

{$IFDEF API_Dynamic}
var av_dict_count : function(const m: PAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function av_dict_count(const m: PAVDictionary): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_dict_count';
{$ENDIF API_Dynamic}


(**
 * Set the given entry in *pm, overwriting an existing entry.
 *
 * Note: If AV_DICT_DONT_STRDUP_KEY or AV_DICT_DONT_STRDUP_VAL is set,
 * these arguments will be freed on error.
 *
 * Warning: Adding a new entry to a dictionary invalidates all existing entries
 * previously returned with av_dict_get.
 *
 * @param pm pointer to a pointer to a dictionary struct. If *pm is NULL
 * a dictionary struct is allocated and put in *pm.
 * @param key entry key to add to *pm (will either be av_strduped or added as a new key depending on flags)
 * @param value entry value to add to *pm (will be av_strduped or added as a new key depending on flags).
 *        Passing a NULL value will cause an existing entry to be deleted.
 * @return >= 0 on success otherwise an error code <0
 *)

{$IFDEF API_Dynamic}
var av_dict_set : function(pm: PPAVDictionary; const key, value: PAnsiChar; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_dict_set(pm: PPAVDictionary; const key, value: PAnsiChar; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_dict_set';
{$ENDIF API_Dynamic}


(**
 * Convenience wrapper for av_dict_set that converts the value to a string
 * and stores it.
 *
 * Note: If AV_DICT_DONT_STRDUP_KEY is set, key will be freed on error.
 *)

{$IFDEF API_Dynamic}
var av_dict_set_int : function(pm: PPAVDictionary; const key: PAnsiChar; value: Int64; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_dict_set_int(pm: PPAVDictionary; const key: PAnsiChar; value: Int64; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_dict_set_int';
{$ENDIF API_Dynamic}


(**
 * Parse the key/value pairs list and add the parsed entries to a dictionary.
 *
 * In case of failure, all the successfully set entries are stored in
 * *pm. You may need to manually free the created dictionary.
 *
 * @param key_val_sep  a 0-terminated list of characters used to separate
 *                     key from value
 * @param pairs_sep    a 0-terminated list of characters used to separate
 *                     two pairs from each other
 * @param flags        flags to use when adding to dictionary.
 *                     AV_DICT_DONT_STRDUP_KEY and AV_DICT_DONT_STRDUP_VAL
 *                     are ignored since the key/value tokens will always
 *                     be duplicated.
 * @return             0 on success, negative AVERROR code on failure
 *)

{$IFDEF API_Dynamic}
var av_dict_parse_string : function(pm: PPAVDictionary; const str, key_val_sep, pairs_sep: PAnsiChar;
                                  flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_dict_parse_string(pm: PPAVDictionary; const str, key_val_sep, pairs_sep: PAnsiChar;
                                  flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_dict_parse_string';
{$ENDIF API_Dynamic}


(**
 * Copy entries from one AVDictionary struct into another.
 * @param dst pointer to a pointer to a AVDictionary struct. If *dst is NULL,
 *            this function will allocate a struct for you and put it in *dst
 * @param src pointer to source AVDictionary struct
 * @param flags flags to use when setting entries in *dst
 * @note metadata is read using the AV_DICT_IGNORE_SUFFIX flag
 * @return 0 on success, negative AVERROR code on failure. If dst was allocated
 *           by this function, callers should free the associated memory.
 *)

{$IFDEF API_Dynamic}
var av_dict_copy : function(dst: PPAVDictionary; const src: PAVDictionary; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_dict_copy(dst: PPAVDictionary; const src: PAVDictionary; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_dict_copy';
{$ENDIF API_Dynamic}


(**
 * Free all the memory allocated for an AVDictionary struct
 * and all keys and values.
 *)

{$IFDEF API_Dynamic}
var av_dict_free : procedure(m: PPAVDictionary); cdecl;
{$ELSE API_Dynamic}
procedure av_dict_free(m: PPAVDictionary); cdecl; external AVUTIL_LIBNAME name _PU + 'av_dict_free';
{$ENDIF API_Dynamic}


(**
 * Get dictionary entries as a string.
 *
 * Create a string containing dictionary's entries.
 * Such string may be passed back to av_dict_parse_string().
 * @note String is escaped with backslashes ('\').
 *
 * @param[in]  m             dictionary
 * @param[out] buffer        Pointer to buffer that will be allocated with string containg entries.
 *                           Buffer must be freed by the caller when is no longer needed.
 * @param[in]  key_val_sep   character used to separate key from value
 * @param[in]  pairs_sep     character used to separate two pairs from each other
 * @return                   >= 0 on success, negative on error
 * @warning Separators cannot be neither '\\' nor '\0'. They also cannot be the same.
 *)

{$IFDEF API_Dynamic}
var av_dict_get_string : function(const m: PAVDictionary; buffer: PPAnsiChar;
                       const key_val_sep, pairs_sep: AnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_dict_get_string(const m: PAVDictionary; buffer: PPAnsiChar;
                       const key_val_sep, pairs_sep: AnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_dict_get_string';
{$ENDIF API_Dynamic}


(**
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_pixfmt *)
(* ****************************************************** *)






const
  AVPALETTE_SIZE = 1024;
  AVPALETTE_COUNT = 256;

{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  AV_PIX_FMT_NONE=-1;
  AV_PIX_FMT_YUV420P=$0;
  AV_PIX_FMT_YUYV422=$1;
  AV_PIX_FMT_RGB24=$2;
  AV_PIX_FMT_BGR24=$3;
  AV_PIX_FMT_YUV422P=$4;
  AV_PIX_FMT_YUV444P=$5;
  AV_PIX_FMT_YUV410P=$6;
  AV_PIX_FMT_YUV411P=$7;
  AV_PIX_FMT_GRAY8=$8;
  AV_PIX_FMT_MONOWHITE=$9;
  AV_PIX_FMT_MONOBLACK=$A;
  AV_PIX_FMT_PAL8=$B;
  AV_PIX_FMT_YUVJ420P=$C;
  AV_PIX_FMT_YUVJ422P=$D;
  AV_PIX_FMT_YUVJ444P=$E;
{$IFDEF FF_API_XVMC}
  AV_PIX_FMT_XVMC_MPEG2_MC=$F;
  AV_PIX_FMT_XVMC_MPEG2_IDCT=$10;
//AV_PIX_FMT_XVMC = AV_PIX_FMT_XVMC_MPEG2_IDCT,
  _AV_PIX_FMT_DELTA=0;  
{$ELSE}
  _AV_PIX_FMT_DELTA=2;  
{$ENDIF}
  AV_PIX_FMT_UYVY422=$11-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_UYYVYY411=$12-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_BGR8=$13-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_BGR4=$14-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_BGR4_BYTE=$15-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_RGB8=$16-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_RGB4=$17-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_RGB4_BYTE=$18-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_NV12=$19-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_NV21=$1A-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_ARGB=$1B-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_RGBA=$1C-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_ABGR=$1D-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_BGRA=$1E-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_GRAY16BE=$1F-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_GRAY16LE=$20-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_YUV440P=$21-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_YUVJ440P=$22-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_YUVA420P=$23-_AV_PIX_FMT_DELTA;
{$IFDEF FF_API_VDPAU}
  AV_PIX_FMT_VDPAU_H264=$24-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_VDPAU_MPEG1=$25-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_VDPAU_MPEG2=$26-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_VDPAU_WMV3=$27-_AV_PIX_FMT_DELTA;
  AV_PIX_FMT_VDPAU_VC1=$28-_AV_PIX_FMT_DELTA;
  _AV_PIX_FMT_DELTA2=_AV_PIX_FMT_DELTA;
{$ELSE}
  _AV_PIX_FMT_DELTA2=_AV_PIX_FMT_DELTA+5;
{$ENDIF}
  AV_PIX_FMT_RGB48BE=$29-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_RGB48LE=$2A-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_RGB565BE=$2B-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_RGB565LE=$2C-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_RGB555BE=$2D-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_RGB555LE=$2E-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_BGR565BE=$2F-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_BGR565LE=$30-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_BGR555BE=$31-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_BGR555LE=$32-_AV_PIX_FMT_DELTA2;
{$IFDEF FF_API_VAAPI}
  AV_PIX_FMT_VAAPI_MOCO=$33-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_VAAPI_IDCT=$34-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_VAAPI_VLD=$35-_AV_PIX_FMT_DELTA2;
  AV_PIX_FMT_VAAPI=AV_PIX_FMT_VAAPI_VLD;
  _AV_PIX_FMT_DELTA3=_AV_PIX_FMT_DELTA2;
{$ELSE}
  AV_PIX_FMT_VAAPI=$33-_AV_PIX_FMT_DELTA2;
  _AV_PIX_FMT_DELTA3=_AV_PIX_FMT_DELTA2+2;
{$ENDIF}
  AV_PIX_FMT_YUV420P16LE=$36-_AV_PIX_FMT_DELTA3;
  AV_PIX_FMT_YUV420P16BE=$37-_AV_PIX_FMT_DELTA3;
  AV_PIX_FMT_YUV422P16LE=$38-_AV_PIX_FMT_DELTA3;
  AV_PIX_FMT_YUV422P16BE=$39-_AV_PIX_FMT_DELTA3;
  AV_PIX_FMT_YUV444P16LE=$3A-_AV_PIX_FMT_DELTA3;
  AV_PIX_FMT_YUV444P16BE=$3B-_AV_PIX_FMT_DELTA3;
{$IFDEF FF_API_VDPAU}
  AV_PIX_FMT_VDPAU_MPEG4=$3C-_AV_PIX_FMT_DELTA3;
  _AV_PIX_FMT_DELTA4=_AV_PIX_FMT_DELTA3;
{$ELSE}
  _AV_PIX_FMT_DELTA4=_AV_PIX_FMT_DELTA3+1;
{$ENDIF}
  AV_PIX_FMT_DXVA2_VLD=$3D-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_RGB444LE=$3E-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_RGB444BE=$3F-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_BGR444LE=$40-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_BGR444BE=$41-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YA8=$42-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_BGR48BE=$43-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_BGR48LE=$44-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV420P9BE=$45-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV420P9LE=$46-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV420P10BE=$47-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV420P10LE=$48-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV422P10BE=$49-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV422P10LE=$4A-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV444P9BE=$4B-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV444P9LE=$4C-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV444P10BE=$4D-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV444P10LE=$4E-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV422P9BE=$4F-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_YUV422P9LE=$50-_AV_PIX_FMT_DELTA4;
  AV_PIX_FMT_VDA_VLD=$51-_AV_PIX_FMT_DELTA4;
  _AV_PIX_FMT_DELTA5=_AV_PIX_FMT_DELTA4+4;
  AV_PIX_FMT_GBRP=$56-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_GBRP9BE=$57-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_GBRP9LE=$58-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_GBRP10BE=$59-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_GBRP10LE=$5A-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_GBRP16BE=$5B-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_GBRP16LE=$5C-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA422P=$5D-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA444P=$5E-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA420P9BE=$5F-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA420P9LE=$60-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA422P9BE=$61-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA422P9LE=$62-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA444P9BE=$63-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA444P9LE=$64-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA420P10BE=$65-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA420P10LE=$66-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA422P10BE=$67-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA422P10LE=$68-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA444P10BE=$69-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA444P10LE=$6A-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA420P16BE=$6B-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA420P16LE=$6C-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA422P16BE=$6D-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA422P16LE=$6E-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA444P16BE=$6F-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YUVA444P16LE=$70-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_VDPAU=$71-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_XYZ12LE=$72-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_XYZ12BE=$73-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_NV16=$74-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_NV20LE=$75-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_NV20BE=$76-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_RGBA64BE=$77-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_RGBA64LE=$78-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_BGRA64BE=$79-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_BGRA64LE=$7A-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YVYU422=$7B-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_VDA=$7C-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YA16BE=$7D-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_YA16LE=$7E-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_GBRAP=$7F-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_GBRAP16BE=$80-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_GBRAP16LE=$81-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_QSV=$82-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_MMAL=$83-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_D3D11VA_VLD=$84-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_CUDA=$85-_AV_PIX_FMT_DELTA5;
  AV_PIX_FMT_0RGB=$123+4;
  AV_PIX_FMT_RGB0=$123+5;
  AV_PIX_FMT_0BGR=$123+6;
  AV_PIX_FMT_BGR0=$123+7;
  AV_PIX_FMT_YUV420P12BE=$123+$8;
  AV_PIX_FMT_YUV420P12LE=$123+$9;
  AV_PIX_FMT_YUV420P14BE=$123+$A;
  AV_PIX_FMT_YUV420P14LE=$123+$B;
  AV_PIX_FMT_YUV422P12BE=$123+$C;
  AV_PIX_FMT_YUV422P12LE=$123+$D;
  AV_PIX_FMT_YUV422P14BE=$123+$E;
  AV_PIX_FMT_YUV422P14LE=$123+$F;
  AV_PIX_FMT_YUV444P12BE=$123+$10;
  AV_PIX_FMT_YUV444P12LE=$123+$11;
  AV_PIX_FMT_YUV444P14BE=$123+$12;
  AV_PIX_FMT_YUV444P14LE=$123+$13;
  AV_PIX_FMT_GBRP12BE=$123+$14;
  AV_PIX_FMT_GBRP12LE=$123+$15;
  AV_PIX_FMT_GBRP14BE=$123+$16;
  AV_PIX_FMT_GBRP14LE=$123+$17;
  AV_PIX_FMT_YUVJ411P=$123+$18;
  AV_PIX_FMT_BAYER_BGGR8=$123+$19;
  AV_PIX_FMT_BAYER_RGGB8=$123+$1A;
  AV_PIX_FMT_BAYER_GBRG8=$123+$1B;
  AV_PIX_FMT_BAYER_GRBG8=$123+$1C;
  AV_PIX_FMT_BAYER_BGGR16LE=$123+$1D;
  AV_PIX_FMT_BAYER_BGGR16BE=$123+$1E;
  AV_PIX_FMT_BAYER_RGGB16LE=$123+$1F;
  AV_PIX_FMT_BAYER_RGGB16BE=$123+$20;
  AV_PIX_FMT_BAYER_GBRG16LE=$123+$21;
  AV_PIX_FMT_BAYER_GBRG16BE=$123+$22;
  AV_PIX_FMT_BAYER_GRBG16LE=$123+$23;
  AV_PIX_FMT_BAYER_GRBG16BE=$123+$24;
{$IFNDEF FF_API_XVMC}
  AV_PIX_FMT_XVMC=$123+$25;
  _AV_PIX_FMT_DELTA6=0;
{$ELSE}
  _AV_PIX_FMT_DELTA6=1;
{$ENDIF}
  AV_PIX_FMT_YUV440P10LE=$123+$26-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_YUV440P10BE=$123+$27-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_YUV440P12LE=$123+$28-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_YUV440P12BE=$123+$29-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_AYUV64LE=$123+$2A-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_AYUV64BE=$123+$2B-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_VIDEOTOOLBOX=$123+$2C-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_P010LE=$123+$2D-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_P010BE=$123+$2E-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GBRAP12BE=$123+$2F-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GBRAP12LE=$123+$30-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GBRAP10BE=$123+$31-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GBRAP10LE=$123+$32-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_MEDIACODEC=$123+$33-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GRAY12BE=$123+$34-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GRAY12LE=$123+$35-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GRAY10BE=$123+$36-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GRAY10LE=$123+$37-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_P016LE=$123+$38-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_P016BE=$123+$39-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_D3D11=$123+$3A-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GRAY9BE=$123+$3B-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GRAY9LE=$123+$3C-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GBRPF32BE=$123+$3D-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GBRPF32LE=$123+$3E-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GBRAPF32BE=$123+$3F-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_GBRAPF32LE=$123+$40-_AV_PIX_FMT_DELTA6;
  AV_PIX_FMT_DRM_PRIME=$123+$41-_AV_PIX_FMT_DELTA6;

  AV_PIX_FMT_NB=$123+$42-_AV_PIX_FMT_DELTA6;
{$IFEND}

type
(**
 * Pixel format.
 *
 * @note
 * AV_PIX_FMT_RGB32 is handled in an endian-specific manner. An RGBA
 * color is put together as:
 *  (A << 24) | (R << 16) | (G << 8) | B
 * This is stored as BGRA on little-endian CPU architectures and ARGB on
 * big-endian CPUs.
 *
 * @par
 * When the pixel format is palettized RGB32 (AV_PIX_FMT_PAL8), the palettized
 * image data is stored in AVFrame.data[0]. The palette is transported in
 * AVFrame.data[1], is 1024 bytes long (256 4-byte entries) and is
 * formatted the same as in AV_PIX_FMT_RGB32 described above (i.e., it is
 * also endian-specific). Note also that the individual RGB32 palette
 * components stored in AVFrame.data[1] should be in the range 0..255.
 * This is important as many custom PAL8 video codecs that were designed
 * to run on the IBM VGA graphics adapter use 6-bit palette components.
 *
 * @par
 * For all the 8 bits per pixel formats, an RGB32 palette is in data[1] like
 * for pal8. This palette is filled in automatically by the function
 * allocating the picture.
 *)
  PPAVPixelFormat = ^PAVPixelFormat;
  PAVPixelFormat = ^TAVPixelFormat;
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVPixelFormat = Integer;
{$ELSE}
  TAVPixelFormat = (
    AV_PIX_FMT_NONE = -1,
    AV_PIX_FMT_YUV420P,   ///< planar YUV 4:2:0, 12bpp, (1 Cr & Cb sample per 2x2 Y samples)
    AV_PIX_FMT_YUYV422,   ///< packed YUV 4:2:2, 16bpp, Y0 Cb Y1 Cr
    AV_PIX_FMT_RGB24,     ///< packed RGB 8:8:8, 24bpp, RGBRGB...
    AV_PIX_FMT_BGR24,     ///< packed RGB 8:8:8, 24bpp, BGRBGR...
    AV_PIX_FMT_YUV422P,   ///< planar YUV 4:2:2, 16bpp, (1 Cr & Cb sample per 2x1 Y samples)
    AV_PIX_FMT_YUV444P,   ///< planar YUV 4:4:4, 24bpp, (1 Cr & Cb sample per 1x1 Y samples)
    AV_PIX_FMT_YUV410P,   ///< planar YUV 4:1:0,  9bpp, (1 Cr & Cb sample per 4x4 Y samples)
    AV_PIX_FMT_YUV411P,   ///< planar YUV 4:1:1, 12bpp, (1 Cr & Cb sample per 4x1 Y samples)
    AV_PIX_FMT_GRAY8,     ///<        Y        ,  8bpp
    AV_PIX_FMT_MONOWHITE, ///<        Y        ,  1bpp, 0 is white, 1 is black, in each byte pixels are ordered from the msb to the lsb
    AV_PIX_FMT_MONOBLACK, ///<        Y        ,  1bpp, 0 is black, 1 is white, in each byte pixels are ordered from the msb to the lsb
    AV_PIX_FMT_PAL8,      ///< 8 bits with AV_PIX_FMT_RGB32 palette
    AV_PIX_FMT_YUVJ420P,  ///< planar YUV 4:2:0, 12bpp, full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV420P and setting color_range
    AV_PIX_FMT_YUVJ422P,  ///< planar YUV 4:2:2, 16bpp, full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV422P and setting color_range
    AV_PIX_FMT_YUVJ444P,  ///< planar YUV 4:4:4, 24bpp, full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV444P and setting color_range
{$IFDEF FF_API_XVMC}
    AV_PIX_FMT_XVMC_MPEG2_MC,///< XVideo Motion Acceleration via common packet passing
    AV_PIX_FMT_XVMC_MPEG2_IDCT,
//    AV_PIX_FMT_XVMC = AV_PIX_FMT_XVMC_MPEG2_IDCT,
{$ENDIF}
    AV_PIX_FMT_UYVY422,   ///< packed YUV 4:2:2, 16bpp, Cb Y0 Cr Y1
    AV_PIX_FMT_UYYVYY411, ///< packed YUV 4:1:1, 12bpp, Cb Y0 Y1 Cr Y2 Y3
    AV_PIX_FMT_BGR8,      ///< packed RGB 3:3:2,  8bpp, (msb)2B 3G 3R(lsb)
    AV_PIX_FMT_BGR4,      ///< packed RGB 1:2:1 bitstream,  4bpp, (msb)1B 2G 1R(lsb), a byte contains two pixels, the first pixel in the byte is the one composed by the 4 msb bits
    AV_PIX_FMT_BGR4_BYTE, ///< packed RGB 1:2:1,  8bpp, (msb)1B 2G 1R(lsb)
    AV_PIX_FMT_RGB8,      ///< packed RGB 3:3:2,  8bpp, (msb)2R 3G 3B(lsb)
    AV_PIX_FMT_RGB4,      ///< packed RGB 1:2:1 bitstream,  4bpp, (msb)1R 2G 1B(lsb), a byte contains two pixels, the first pixel in the byte is the one composed by the 4 msb bits
    AV_PIX_FMT_RGB4_BYTE, ///< packed RGB 1:2:1,  8bpp, (msb)1R 2G 1B(lsb)
    AV_PIX_FMT_NV12,      ///< planar YUV 4:2:0, 12bpp, 1 plane for Y and 1 plane for the UV components, which are interleaved (first byte U and the following byte V)
    AV_PIX_FMT_NV21,      ///< as above, but U and V bytes are swapped

    AV_PIX_FMT_ARGB,      ///< packed ARGB 8:8:8:8, 32bpp, ARGBARGB...
    AV_PIX_FMT_RGBA,      ///< packed RGBA 8:8:8:8, 32bpp, RGBARGBA...
    AV_PIX_FMT_ABGR,      ///< packed ABGR 8:8:8:8, 32bpp, ABGRABGR...
    AV_PIX_FMT_BGRA,      ///< packed BGRA 8:8:8:8, 32bpp, BGRABGRA...

    AV_PIX_FMT_GRAY16BE,  ///<        Y        , 16bpp, big-endian
    AV_PIX_FMT_GRAY16LE,  ///<        Y        , 16bpp, little-endian
    AV_PIX_FMT_YUV440P,   ///< planar YUV 4:4:0 (1 Cr & Cb sample per 1x2 Y samples)
    AV_PIX_FMT_YUVJ440P,  ///< planar YUV 4:4:0 full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV440P and setting color_range
    AV_PIX_FMT_YUVA420P,  ///< planar YUV 4:2:0, 20bpp, (1 Cr & Cb sample per 2x2 Y & A samples)
{$IFDEF FF_API_VDPAU}
    AV_PIX_FMT_VDPAU_H264,///< H.264 HW decoding with VDPAU, data[0] contains a vdpau_render_state struct which contains the bitstream of the slices as well as various fields extracted from headers
    AV_PIX_FMT_VDPAU_MPEG1,///< MPEG-1 HW decoding with VDPAU, data[0] contains a vdpau_render_state struct which contains the bitstream of the slices as well as various fields extracted from headers
    AV_PIX_FMT_VDPAU_MPEG2,///< MPEG-2 HW decoding with VDPAU, data[0] contains a vdpau_render_state struct which contains the bitstream of the slices as well as various fields extracted from headers
    AV_PIX_FMT_VDPAU_WMV3,///< WMV3 HW decoding with VDPAU, data[0] contains a vdpau_render_state struct which contains the bitstream of the slices as well as various fields extracted from headers
    AV_PIX_FMT_VDPAU_VC1, ///< VC-1 HW decoding with VDPAU, data[0] contains a vdpau_render_state struct which contains the bitstream of the slices as well as various fields extracted from headers
{$ENDIF}
    AV_PIX_FMT_RGB48BE,   ///< packed RGB 16:16:16, 48bpp, 16R, 16G, 16B, the 2-byte value for each R/G/B component is stored as big-endian
    AV_PIX_FMT_RGB48LE,   ///< packed RGB 16:16:16, 48bpp, 16R, 16G, 16B, the 2-byte value for each R/G/B component is stored as little-endian

    AV_PIX_FMT_RGB565BE,  ///< packed RGB 5:6:5, 16bpp, (msb)   5R 6G 5B(lsb), big-endian
    AV_PIX_FMT_RGB565LE,  ///< packed RGB 5:6:5, 16bpp, (msb)   5R 6G 5B(lsb), little-endian
    AV_PIX_FMT_RGB555BE,  ///< packed RGB 5:5:5, 16bpp, (msb)1X 5R 5G 5B(lsb), big-endian   , X=unused/undefined
    AV_PIX_FMT_RGB555LE,  ///< packed RGB 5:5:5, 16bpp, (msb)1X 5R 5G 5B(lsb), little-endian, X=unused/undefined

    AV_PIX_FMT_BGR565BE,  ///< packed BGR 5:6:5, 16bpp, (msb)   5B 6G 5R(lsb), big-endian
    AV_PIX_FMT_BGR565LE,  ///< packed BGR 5:6:5, 16bpp, (msb)   5B 6G 5R(lsb), little-endian
    AV_PIX_FMT_BGR555BE,  ///< packed BGR 5:5:5, 16bpp, (msb)1X 5B 5G 5R(lsb), big-endian   , X=unused/undefined
    AV_PIX_FMT_BGR555LE,  ///< packed BGR 5:5:5, 16bpp, (msb)1X 5B 5G 5R(lsb), little-endian, X=unused/undefined

{$IFDEF FF_API_VAAPI}
    (** @name Deprecated pixel formats *)
    (**@{*)
    AV_PIX_FMT_VAAPI_MOCO, ///< HW acceleration through VA API at motion compensation entry-point, Picture.data[3] contains a vaapi_render_state struct which contains macroblocks as well as various fields extracted from headers
    AV_PIX_FMT_VAAPI_IDCT, ///< HW acceleration through VA API at IDCT entry-point, Picture.data[3] contains a vaapi_render_state struct which contains fields extracted from headers
    AV_PIX_FMT_VAAPI_VLD,  ///< HW decoding through VA API, Picture.data[3] contains a VASurfaceID
    (**@}*)
    AV_PIX_FMT_VAAPI = AV_PIX_FMT_VAAPI_VLD,
{$ELSE}
    (**
     *  Hardware acceleration through VA-API, data[3] contains a
     *  VASurfaceID.
     *)
    AV_PIX_FMT_VAAPI,
{$ENDIF}

    AV_PIX_FMT_YUV420P16LE,  ///< planar YUV 4:2:0, 24bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian
    AV_PIX_FMT_YUV420P16BE,  ///< planar YUV 4:2:0, 24bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian
    AV_PIX_FMT_YUV422P16LE,  ///< planar YUV 4:2:2, 32bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian
    AV_PIX_FMT_YUV422P16BE,  ///< planar YUV 4:2:2, 32bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian
    AV_PIX_FMT_YUV444P16LE,  ///< planar YUV 4:4:4, 48bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian
    AV_PIX_FMT_YUV444P16BE,  ///< planar YUV 4:4:4, 48bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian
{$IFDEF FF_API_VDPAU}
    AV_PIX_FMT_VDPAU_MPEG4,  ///< MPEG-4 HW decoding with VDPAU, data[0] contains a vdpau_render_state struct which contains the bitstream of the slices as well as various fields extracted from headers
{$ENDIF}
    AV_PIX_FMT_DXVA2_VLD,    ///< HW decoding through DXVA2, Picture.data[3] contains a LPDIRECT3DSURFACE9 pointer

    AV_PIX_FMT_RGB444LE,  ///< packed RGB 4:4:4, 16bpp, (msb)4X 4R 4G 4B(lsb), little-endian, X=unused/undefined
    AV_PIX_FMT_RGB444BE,  ///< packed RGB 4:4:4, 16bpp, (msb)4X 4R 4G 4B(lsb), big-endian,    X=unused/undefined
    AV_PIX_FMT_BGR444LE,  ///< packed BGR 4:4:4, 16bpp, (msb)4X 4B 4G 4R(lsb), little-endian, X=unused/undefined
    AV_PIX_FMT_BGR444BE,  ///< packed BGR 4:4:4, 16bpp, (msb)4X 4B 4G 4R(lsb), big-endian,    X=unused/undefined
    AV_PIX_FMT_YA8,       ///< 8 bits gray, 8 bits alpha

    AV_PIX_FMT_BGR48BE,   ///< packed RGB 16:16:16, 48bpp, 16B, 16G, 16R, the 2-byte value for each R/G/B component is stored as big-endian
    AV_PIX_FMT_BGR48LE,   ///< packed RGB 16:16:16, 48bpp, 16B, 16G, 16R, the 2-byte value for each R/G/B component is stored as little-endian

    (**
     * The following 12 formats have the disadvantage of needing 1 format for each bit depth.
     * Notice that each 9/10 bits sample is stored in 16 bits with extra padding.
     * If you want to support multiple bit depths, then using AV_PIX_FMT_YUV420P16* with the bpp stored separately is better.
     *)
    AV_PIX_FMT_YUV420P9BE, ///< planar YUV 4:2:0, 13.5bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian
    AV_PIX_FMT_YUV420P9LE, ///< planar YUV 4:2:0, 13.5bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian
    AV_PIX_FMT_YUV420P10BE,///< planar YUV 4:2:0, 15bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian
    AV_PIX_FMT_YUV420P10LE,///< planar YUV 4:2:0, 15bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian
    AV_PIX_FMT_YUV422P10BE,///< planar YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian
    AV_PIX_FMT_YUV422P10LE,///< planar YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian
    AV_PIX_FMT_YUV444P9BE, ///< planar YUV 4:4:4, 27bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian
    AV_PIX_FMT_YUV444P9LE, ///< planar YUV 4:4:4, 27bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian
    AV_PIX_FMT_YUV444P10BE,///< planar YUV 4:4:4, 30bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian
    AV_PIX_FMT_YUV444P10LE,///< planar YUV 4:4:4, 30bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian
    AV_PIX_FMT_YUV422P9BE, ///< planar YUV 4:2:2, 18bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian
    AV_PIX_FMT_YUV422P9LE, ///< planar YUV 4:2:2, 18bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian
    AV_PIX_FMT_VDA_VLD,    ///< hardware decoding through VDA

    AV_PIX_FMT_GBRP,      ///< planar GBR 4:4:4 24bpp
//    AV_PIX_FMT_GBR24P = AV_PIX_FMT_GBRP, // alias for #AV_PIX_FMT_GBRP
    AV_PIX_FMT_GBRP9BE,   ///< planar GBR 4:4:4 27bpp, big-endian
    AV_PIX_FMT_GBRP9LE,   ///< planar GBR 4:4:4 27bpp, little-endian
    AV_PIX_FMT_GBRP10BE,  ///< planar GBR 4:4:4 30bpp, big-endian
    AV_PIX_FMT_GBRP10LE,  ///< planar GBR 4:4:4 30bpp, little-endian
    AV_PIX_FMT_GBRP16BE,  ///< planar GBR 4:4:4 48bpp, big-endian
    AV_PIX_FMT_GBRP16LE,  ///< planar GBR 4:4:4 48bpp, little-endian
    AV_PIX_FMT_YUVA422P,  ///< planar YUV 4:2:2 24bpp, (1 Cr & Cb sample per 2x1 Y & A samples)
    AV_PIX_FMT_YUVA444P,  ///< planar YUV 4:4:4 32bpp, (1 Cr & Cb sample per 1x1 Y & A samples)
    AV_PIX_FMT_YUVA420P9BE,  ///< planar YUV 4:2:0 22.5bpp, (1 Cr & Cb sample per 2x2 Y & A samples), big-endian
    AV_PIX_FMT_YUVA420P9LE,  ///< planar YUV 4:2:0 22.5bpp, (1 Cr & Cb sample per 2x2 Y & A samples), little-endian
    AV_PIX_FMT_YUVA422P9BE,  ///< planar YUV 4:2:2 27bpp, (1 Cr & Cb sample per 2x1 Y & A samples), big-endian
    AV_PIX_FMT_YUVA422P9LE,  ///< planar YUV 4:2:2 27bpp, (1 Cr & Cb sample per 2x1 Y & A samples), little-endian
    AV_PIX_FMT_YUVA444P9BE,  ///< planar YUV 4:4:4 36bpp, (1 Cr & Cb sample per 1x1 Y & A samples), big-endian
    AV_PIX_FMT_YUVA444P9LE,  ///< planar YUV 4:4:4 36bpp, (1 Cr & Cb sample per 1x1 Y & A samples), little-endian
    AV_PIX_FMT_YUVA420P10BE, ///< planar YUV 4:2:0 25bpp, (1 Cr & Cb sample per 2x2 Y & A samples, big-endian)
    AV_PIX_FMT_YUVA420P10LE, ///< planar YUV 4:2:0 25bpp, (1 Cr & Cb sample per 2x2 Y & A samples, little-endian)
    AV_PIX_FMT_YUVA422P10BE, ///< planar YUV 4:2:2 30bpp, (1 Cr & Cb sample per 2x1 Y & A samples, big-endian)
    AV_PIX_FMT_YUVA422P10LE, ///< planar YUV 4:2:2 30bpp, (1 Cr & Cb sample per 2x1 Y & A samples, little-endian)
    AV_PIX_FMT_YUVA444P10BE, ///< planar YUV 4:4:4 40bpp, (1 Cr & Cb sample per 1x1 Y & A samples, big-endian)
    AV_PIX_FMT_YUVA444P10LE, ///< planar YUV 4:4:4 40bpp, (1 Cr & Cb sample per 1x1 Y & A samples, little-endian)
    AV_PIX_FMT_YUVA420P16BE, ///< planar YUV 4:2:0 40bpp, (1 Cr & Cb sample per 2x2 Y & A samples, big-endian)
    AV_PIX_FMT_YUVA420P16LE, ///< planar YUV 4:2:0 40bpp, (1 Cr & Cb sample per 2x2 Y & A samples, little-endian)
    AV_PIX_FMT_YUVA422P16BE, ///< planar YUV 4:2:2 48bpp, (1 Cr & Cb sample per 2x1 Y & A samples, big-endian)
    AV_PIX_FMT_YUVA422P16LE, ///< planar YUV 4:2:2 48bpp, (1 Cr & Cb sample per 2x1 Y & A samples, little-endian)
    AV_PIX_FMT_YUVA444P16BE, ///< planar YUV 4:4:4 64bpp, (1 Cr & Cb sample per 1x1 Y & A samples, big-endian)
    AV_PIX_FMT_YUVA444P16LE, ///< planar YUV 4:4:4 64bpp, (1 Cr & Cb sample per 1x1 Y & A samples, little-endian)

    AV_PIX_FMT_VDPAU,     ///< HW acceleration through VDPAU, Picture.data[3] contains a VdpVideoSurface

    AV_PIX_FMT_XYZ12LE,      ///< packed XYZ 4:4:4, 36 bpp, (msb) 12X, 12Y, 12Z (lsb), the 2-byte value for each X/Y/Z is stored as little-endian, the 4 lower bits are set to 0
    AV_PIX_FMT_XYZ12BE,      ///< packed XYZ 4:4:4, 36 bpp, (msb) 12X, 12Y, 12Z (lsb), the 2-byte value for each X/Y/Z is stored as big-endian, the 4 lower bits are set to 0
    AV_PIX_FMT_NV16,         ///< interleaved chroma YUV 4:2:2, 16bpp, (1 Cr & Cb sample per 2x1 Y samples)
    AV_PIX_FMT_NV20LE,       ///< interleaved chroma YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian
    AV_PIX_FMT_NV20BE,       ///< interleaved chroma YUV 4:2:2, 20bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian

    (**
     * duplicated pixel formats for compatibility with libav.
     * FFmpeg supports these formats since Sat Sep 24 06:01:45 2011 +0200 (commits 9569a3c9f41387a8c7d1ce97d8693520477a66c3)
     * also see Fri Nov 25 01:38:21 2011 +0100 92afb431621c79155fcb7171d26f137eb1bee028
     * Libav added them Sun Mar 16 23:05:47 2014 +0100 with incompatible values (commit 1481d24c3a0abf81e1d7a514547bd5305232be30)
     *)
    AV_PIX_FMT_RGBA64BE,     ///< packed RGBA 16:16:16:16, 64bpp, 16R, 16G, 16B, 16A, the 2-byte value for each R/G/B/A component is stored as big-endian
    AV_PIX_FMT_RGBA64LE,     ///< packed RGBA 16:16:16:16, 64bpp, 16R, 16G, 16B, 16A, the 2-byte value for each R/G/B/A component is stored as little-endian
    AV_PIX_FMT_BGRA64BE,     ///< packed RGBA 16:16:16:16, 64bpp, 16B, 16G, 16R, 16A, the 2-byte value for each R/G/B/A component is stored as big-endian
    AV_PIX_FMT_BGRA64LE,     ///< packed RGBA 16:16:16:16, 64bpp, 16B, 16G, 16R, 16A, the 2-byte value for each R/G/B/A component is stored as little-endian

    AV_PIX_FMT_YVYU422,   ///< packed YUV 4:2:2, 16bpp, Y0 Cr Y1 Cb

    AV_PIX_FMT_VDA,          ///< HW acceleration through VDA, data[3] contains a CVPixelBufferRef

    AV_PIX_FMT_YA16BE,       ///< 16 bits gray, 16 bits alpha (big-endian)
    AV_PIX_FMT_YA16LE,       ///< 16 bits gray, 16 bits alpha (little-endian)

    AV_PIX_FMT_GBRAP,        ///< planar GBRA 4:4:4:4 32bpp
    AV_PIX_FMT_GBRAP16BE,    ///< planar GBRA 4:4:4:4 64bpp, big-endian
    AV_PIX_FMT_GBRAP16LE,    ///< planar GBRA 4:4:4:4 64bpp, little-endian
    (**
     *  HW acceleration through QSV, data[3] contains a pointer to the
     *  mfxFrameSurface1 structure.
     *)
    AV_PIX_FMT_QSV,
    (**
     * HW acceleration though MMAL, data[3] contains a pointer to the
     * MMAL_BUFFER_HEADER_T structure.
     *)
    AV_PIX_FMT_MMAL,

    AV_PIX_FMT_D3D11VA_VLD,  ///< HW decoding through Direct3D11 via old API, Picture.data[3] contains a ID3D11VideoDecoderOutputView pointer

    (**
     * HW acceleration through CUDA. data[i] contain CUdeviceptr pointers
     * exactly as for system memory frames.
     *)
    AV_PIX_FMT_CUDA,

    AV_PIX_FMT_0RGB=$123+4, ///< packed RGB 8:8:8, 32bpp, XRGBXRGB...   X=unused/undefined
    AV_PIX_FMT_RGB0,        ///< packed RGB 8:8:8, 32bpp, RGBXRGBX...   X=unused/undefined
    AV_PIX_FMT_0BGR,        ///< packed BGR 8:8:8, 32bpp, XBGRXBGR...   X=unused/undefined
    AV_PIX_FMT_BGR0,        ///< packed BGR 8:8:8, 32bpp, BGRXBGRX...   X=unused/undefined

    AV_PIX_FMT_YUV420P12BE, ///< planar YUV 4:2:0,18bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian
    AV_PIX_FMT_YUV420P12LE, ///< planar YUV 4:2:0,18bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian
    AV_PIX_FMT_YUV420P14BE, ///< planar YUV 4:2:0,21bpp, (1 Cr & Cb sample per 2x2 Y samples), big-endian
    AV_PIX_FMT_YUV420P14LE, ///< planar YUV 4:2:0,21bpp, (1 Cr & Cb sample per 2x2 Y samples), little-endian
    AV_PIX_FMT_YUV422P12BE, ///< planar YUV 4:2:2,24bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian
    AV_PIX_FMT_YUV422P12LE, ///< planar YUV 4:2:2,24bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian
    AV_PIX_FMT_YUV422P14BE, ///< planar YUV 4:2:2,28bpp, (1 Cr & Cb sample per 2x1 Y samples), big-endian
    AV_PIX_FMT_YUV422P14LE, ///< planar YUV 4:2:2,28bpp, (1 Cr & Cb sample per 2x1 Y samples), little-endian
    AV_PIX_FMT_YUV444P12BE, ///< planar YUV 4:4:4,36bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian
    AV_PIX_FMT_YUV444P12LE, ///< planar YUV 4:4:4,36bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian
    AV_PIX_FMT_YUV444P14BE, ///< planar YUV 4:4:4,42bpp, (1 Cr & Cb sample per 1x1 Y samples), big-endian
    AV_PIX_FMT_YUV444P14LE, ///< planar YUV 4:4:4,42bpp, (1 Cr & Cb sample per 1x1 Y samples), little-endian
    AV_PIX_FMT_GBRP12BE,    ///< planar GBR 4:4:4 36bpp, big-endian
    AV_PIX_FMT_GBRP12LE,    ///< planar GBR 4:4:4 36bpp, little-endian
    AV_PIX_FMT_GBRP14BE,    ///< planar GBR 4:4:4 42bpp, big-endian
    AV_PIX_FMT_GBRP14LE,    ///< planar GBR 4:4:4 42bpp, little-endian
    AV_PIX_FMT_YUVJ411P,    ///< planar YUV 4:1:1, 12bpp, (1 Cr & Cb sample per 4x1 Y samples) full scale (JPEG), deprecated in favor of AV_PIX_FMT_YUV411P and setting color_range

    AV_PIX_FMT_BAYER_BGGR8,    ///< bayer, BGBG..(odd line), GRGR..(even line), 8-bit samples */
    AV_PIX_FMT_BAYER_RGGB8,    ///< bayer, RGRG..(odd line), GBGB..(even line), 8-bit samples */
    AV_PIX_FMT_BAYER_GBRG8,    ///< bayer, GBGB..(odd line), RGRG..(even line), 8-bit samples */
    AV_PIX_FMT_BAYER_GRBG8,    ///< bayer, GRGR..(odd line), BGBG..(even line), 8-bit samples */
    AV_PIX_FMT_BAYER_BGGR16LE, ///< bayer, BGBG..(odd line), GRGR..(even line), 16-bit samples, little-endian */
    AV_PIX_FMT_BAYER_BGGR16BE, ///< bayer, BGBG..(odd line), GRGR..(even line), 16-bit samples, big-endian */
    AV_PIX_FMT_BAYER_RGGB16LE, ///< bayer, RGRG..(odd line), GBGB..(even line), 16-bit samples, little-endian */
    AV_PIX_FMT_BAYER_RGGB16BE, ///< bayer, RGRG..(odd line), GBGB..(even line), 16-bit samples, big-endian */
    AV_PIX_FMT_BAYER_GBRG16LE, ///< bayer, GBGB..(odd line), RGRG..(even line), 16-bit samples, little-endian */
    AV_PIX_FMT_BAYER_GBRG16BE, ///< bayer, GBGB..(odd line), RGRG..(even line), 16-bit samples, big-endian */
    AV_PIX_FMT_BAYER_GRBG16LE, ///< bayer, GRGR..(odd line), BGBG..(even line), 16-bit samples, little-endian */
    AV_PIX_FMT_BAYER_GRBG16BE, ///< bayer, GRGR..(odd line), BGBG..(even line), 16-bit samples, big-endian */
{$IFNDEF FF_API_XVMC}
    AV_PIX_FMT_XVMC,///< XVideo Motion Acceleration via common packet passing
{$ENDIF}
    AV_PIX_FMT_YUV440P10LE, ///< planar YUV 4:4:0,20bpp, (1 Cr & Cb sample per 1x2 Y samples), little-endian
    AV_PIX_FMT_YUV440P10BE, ///< planar YUV 4:4:0,20bpp, (1 Cr & Cb sample per 1x2 Y samples), big-endian
    AV_PIX_FMT_YUV440P12LE, ///< planar YUV 4:4:0,24bpp, (1 Cr & Cb sample per 1x2 Y samples), little-endian
    AV_PIX_FMT_YUV440P12BE, ///< planar YUV 4:4:0,24bpp, (1 Cr & Cb sample per 1x2 Y samples), big-endian
    AV_PIX_FMT_AYUV64LE,    ///< packed AYUV 4:4:4,64bpp (1 Cr & Cb sample per 1x1 Y & A samples), little-endian
    AV_PIX_FMT_AYUV64BE,    ///< packed AYUV 4:4:4,64bpp (1 Cr & Cb sample per 1x1 Y & A samples), big-endian

    AV_PIX_FMT_VIDEOTOOLBOX, ///< hardware decoding through Videotoolbox

    AV_PIX_FMT_P010LE, ///< like NV12, with 10bpp per component, data in the high bits, zeros in the low bits, little-endian
    AV_PIX_FMT_P010BE, ///< like NV12, with 10bpp per component, data in the high bits, zeros in the low bits, big-endian

    AV_PIX_FMT_GBRAP12BE,  ///< planar GBR 4:4:4:4 48bpp, big-endian
    AV_PIX_FMT_GBRAP12LE,  ///< planar GBR 4:4:4:4 48bpp, little-endian

    AV_PIX_FMT_GBRAP10BE,  ///< planar GBR 4:4:4:4 40bpp, big-endian
    AV_PIX_FMT_GBRAP10LE,  ///< planar GBR 4:4:4:4 40bpp, little-endian

    AV_PIX_FMT_MEDIACODEC, ///< hardware decoding through MediaCodec

    AV_PIX_FMT_GRAY12BE,   ///<        Y        , 12bpp, big-endian
    AV_PIX_FMT_GRAY12LE,   ///<        Y        , 12bpp, little-endian
    AV_PIX_FMT_GRAY10BE,   ///<        Y        , 10bpp, big-endian
    AV_PIX_FMT_GRAY10LE,   ///<        Y        , 10bpp, little-endian

    AV_PIX_FMT_P016LE, ///< like NV12, with 16bpp per component, little-endian
    AV_PIX_FMT_P016BE, ///< like NV12, with 16bpp per component, big-endian

    (**
     * Hardware surfaces for Direct3D11.
     *
     * This is preferred over the legacy AV_PIX_FMT_D3D11VA_VLD. The new D3D11
     * hwaccel API and filtering support AV_PIX_FMT_D3D11 only.
     *
     * data[0] contains a ID3D11Texture2D pointer, and data[1] contains the
     * texture array index of the frame as intptr_t if the ID3D11Texture2D is
     * an array texture (or always 0 if it's a normal texture).
     *)
    AV_PIX_FMT_D3D11,

    AV_PIX_FMT_GRAY9BE,   ///<        Y        , 9bpp, big-endian
    AV_PIX_FMT_GRAY9LE,   ///<        Y        , 9bpp, little-endian

    AV_PIX_FMT_GBRPF32BE,  ///< IEEE-754 single precision planar GBR 4:4:4,     96bpp, big-endian
    AV_PIX_FMT_GBRPF32LE,  ///< IEEE-754 single precision planar GBR 4:4:4,     96bpp, little-endian
    AV_PIX_FMT_GBRAPF32BE, ///< IEEE-754 single precision planar GBRA 4:4:4:4, 128bpp, big-endian
    AV_PIX_FMT_GBRAPF32LE, ///< IEEE-754 single precision planar GBRA 4:4:4:4, 128bpp, little-endian

    (**
     * DRM-managed buffers exposed through PRIME buffer sharing.
     *
     * data[0] points to an AVDRMFrameDescriptor.
     *)
    AV_PIX_FMT_DRM_PRIME,

    AV_PIX_FMT_NB         ///< number of pixel formats, DO NOT USE THIS if you want to link with shared libav* because the number of formats might differ between versions
  );
{$IFEND}

const
{$IFDEF FF_API_XVMC}
  AV_PIX_FMT_XVMC = AV_PIX_FMT_XVMC_MPEG2_IDCT;
{$ENDIF}

//  AV_PIX_FMT_Y400A   = AV_PIX_FMT_GRAY8A;
  AV_PIX_FMT_GBR24P  = AV_PIX_FMT_GBRP;
  AV_PIX_FMT_Y400A = AV_PIX_FMT_YA8; ///< alias for AV_PIX_FMT_YA8
  AV_PIX_FMT_GRAY8A= AV_PIX_FMT_YA8; ///< alias for AV_PIX_FMT_YA8

{
#if AV_HAVE_BIGENDIAN
#   define AV_PIX_FMT_NE(be, le) AV_PIX_FMT_##be
#else
#   define AV_PIX_FMT_NE(be, le) AV_PIX_FMT_##le
#endif
}
  AV_PIX_FMT_RGB32   = AV_PIX_FMT_BGRA;
  AV_PIX_FMT_RGB32_1 = AV_PIX_FMT_ABGR;
  AV_PIX_FMT_BGR32   = AV_PIX_FMT_RGBA;
  AV_PIX_FMT_BGR32_1 = AV_PIX_FMT_ARGB;
  AV_PIX_FMT_0RGB32  = AV_PIX_FMT_BGR0;
  AV_PIX_FMT_0BGR32  = AV_PIX_FMT_RGB0;

  AV_PIX_FMT_GRAY9  = AV_PIX_FMT_GRAY9LE;
  AV_PIX_FMT_GRAY10 = AV_PIX_FMT_GRAY10LE;
  AV_PIX_FMT_GRAY12 = AV_PIX_FMT_GRAY12LE;
  AV_PIX_FMT_GRAY16 = AV_PIX_FMT_GRAY16LE;
  AV_PIX_FMT_YA16   = AV_PIX_FMT_YA16LE;
  AV_PIX_FMT_RGB48  = AV_PIX_FMT_RGB48LE;
  AV_PIX_FMT_RGB565 = AV_PIX_FMT_RGB565LE;
  AV_PIX_FMT_RGB555 = AV_PIX_FMT_RGB555LE;
  AV_PIX_FMT_RGB444 = AV_PIX_FMT_RGB444LE;
  AV_PIX_FMT_RGBA64 = AV_PIX_FMT_RGBA64LE;
  AV_PIX_FMT_BGR48  = AV_PIX_FMT_BGR48LE;
  AV_PIX_FMT_BGR565 = AV_PIX_FMT_BGR565LE;
  AV_PIX_FMT_BGR555 = AV_PIX_FMT_BGR555LE;
  AV_PIX_FMT_BGR444 = AV_PIX_FMT_BGR444LE;
  AV_PIX_FMT_BGRA64 = AV_PIX_FMT_BGRA64LE;

  AV_PIX_FMT_YUV420P9  = AV_PIX_FMT_YUV420P9LE;
  AV_PIX_FMT_YUV422P9  = AV_PIX_FMT_YUV422P9LE;
  AV_PIX_FMT_YUV444P9  = AV_PIX_FMT_YUV444P9LE;
  AV_PIX_FMT_YUV420P10 = AV_PIX_FMT_YUV420P10LE;
  AV_PIX_FMT_YUV422P10 = AV_PIX_FMT_YUV422P10LE;
  AV_PIX_FMT_YUV440P10 = AV_PIX_FMT_YUV440P10LE;
  AV_PIX_FMT_YUV444P10 = AV_PIX_FMT_YUV444P10LE;
  AV_PIX_FMT_YUV420P12 = AV_PIX_FMT_YUV420P12LE;
  AV_PIX_FMT_YUV422P12 = AV_PIX_FMT_YUV422P12LE;
  AV_PIX_FMT_YUV440P12 = AV_PIX_FMT_YUV440P12LE;
  AV_PIX_FMT_YUV444P12 = AV_PIX_FMT_YUV444P12LE;
  AV_PIX_FMT_YUV420P14 = AV_PIX_FMT_YUV420P14LE;
  AV_PIX_FMT_YUV422P14 = AV_PIX_FMT_YUV422P14LE;
  AV_PIX_FMT_YUV444P14 = AV_PIX_FMT_YUV444P14LE;
  AV_PIX_FMT_YUV420P16 = AV_PIX_FMT_YUV420P16LE;
  AV_PIX_FMT_YUV422P16 = AV_PIX_FMT_YUV422P16LE;
  AV_PIX_FMT_YUV444P16 = AV_PIX_FMT_YUV444P16LE;

  AV_PIX_FMT_GBRP9  = AV_PIX_FMT_GBRP9LE;
  AV_PIX_FMT_GBRP10 = AV_PIX_FMT_GBRP10LE;
  AV_PIX_FMT_GBRP12 = AV_PIX_FMT_GBRP12LE;
  AV_PIX_FMT_GBRP14 = AV_PIX_FMT_GBRP14LE;
  AV_PIX_FMT_GBRP16 = AV_PIX_FMT_GBRP16LE;
  AV_PIX_FMT_GBRAP10 = AV_PIX_FMT_GBRAP10LE;
  AV_PIX_FMT_GBRAP12 = AV_PIX_FMT_GBRAP12LE;
  AV_PIX_FMT_GBRAP16 = AV_PIX_FMT_GBRAP16LE;

  AV_PIX_FMT_BAYER_BGGR16 = AV_PIX_FMT_BAYER_BGGR16LE;
  AV_PIX_FMT_BAYER_RGGB16 = AV_PIX_FMT_BAYER_RGGB16LE;
  AV_PIX_FMT_BAYER_GBRG16 = AV_PIX_FMT_BAYER_GBRG16LE;
  AV_PIX_FMT_BAYER_GRBG16 = AV_PIX_FMT_BAYER_GRBG16LE;

  AV_PIX_FMT_GBRPF32    = AV_PIX_FMT_GBRPF32LE;
  AV_PIX_FMT_GBRAPF32   = AV_PIX_FMT_GBRAPF32LE;

  AV_PIX_FMT_YUVA420P9  = AV_PIX_FMT_YUVA420P9LE;
  AV_PIX_FMT_YUVA422P9  = AV_PIX_FMT_YUVA422P9LE;
  AV_PIX_FMT_YUVA444P9  = AV_PIX_FMT_YUVA444P9LE;
  AV_PIX_FMT_YUVA420P10 = AV_PIX_FMT_YUVA420P10LE;
  AV_PIX_FMT_YUVA422P10 = AV_PIX_FMT_YUVA422P10LE;
  AV_PIX_FMT_YUVA444P10 = AV_PIX_FMT_YUVA444P10LE;
  AV_PIX_FMT_YUVA420P16 = AV_PIX_FMT_YUVA420P16LE;
  AV_PIX_FMT_YUVA422P16 = AV_PIX_FMT_YUVA422P16LE;
  AV_PIX_FMT_YUVA444P16 = AV_PIX_FMT_YUVA444P16LE;

  AV_PIX_FMT_XYZ12      = AV_PIX_FMT_XYZ12LE;
  AV_PIX_FMT_NV20       = AV_PIX_FMT_NV20LE;
  AV_PIX_FMT_AYUV64     = AV_PIX_FMT_AYUV64LE;
  AV_PIX_FMT_P010       = AV_PIX_FMT_P010LE;
  AV_PIX_FMT_P016       = AV_PIX_FMT_P016LE;

{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  AVCOL_PRI_RESERVED0   = 0;
  AVCOL_PRI_BT709       = 1;
  AVCOL_PRI_UNSPECIFIED = 2;
  AVCOL_PRI_RESERVED    = 3;
  AVCOL_PRI_BT470M      = 4;
  AVCOL_PRI_BT470BG     = 5;
  AVCOL_PRI_SMPTE170M   = 6;
  AVCOL_PRI_SMPTE240M   = 7;
  AVCOL_PRI_FILM        = 8;
  AVCOL_PRI_BT2020      = 9;
  AVCOL_PRI_SMPTE428    = 10;
  AVCOL_PRI_SMPTEST428_1= AVCOL_PRI_SMPTE428;
  AVCOL_PRI_SMPTE431    = 11;
  AVCOL_PRI_SMPTE432    = 12;
  AVCOL_PRI_JEDEC_P22   = 22;
  AVCOL_PRI_NB          = 23;

  AVCOL_TRC_RESERVED0    = 0;
  AVCOL_TRC_BT709        = 1;
  AVCOL_TRC_UNSPECIFIED  = 2;
  AVCOL_TRC_RESERVED     = 3;
  AVCOL_TRC_GAMMA22      = 4;
  AVCOL_TRC_GAMMA28      = 5;
  AVCOL_TRC_SMPTE170M    = 6;
  AVCOL_TRC_SMPTE240M    = 7;
  AVCOL_TRC_LINEAR       = 8;
  AVCOL_TRC_LOG          = 9;
  AVCOL_TRC_LOG_SQRT     = 10;
  AVCOL_TRC_IEC61966_2_4 = 11;
  AVCOL_TRC_BT1361_ECG   = 12;
  AVCOL_TRC_IEC61966_2_1 = 13;
  AVCOL_TRC_BT2020_10    = 14;
  AVCOL_TRC_BT2020_12    = 15;
  AVCOL_TRC_SMPTE2084    = 16;
  AVCOL_TRC_SMPTEST2084  = AVCOL_TRC_SMPTE2084;
  AVCOL_TRC_SMPTE428     = 17;
  AVCOL_TRC_SMPTEST428_1 = AVCOL_TRC_SMPTE428;
  AVCOL_TRC_ARIB_STD_B67 = 18;
  AVCOL_TRC_NB           = 19;

  AVCOL_SPC_RGB         = 0;
  AVCOL_SPC_BT709       = 1;
  AVCOL_SPC_UNSPECIFIED = 2;
  AVCOL_SPC_RESERVED    = 3;
  AVCOL_SPC_FCC         = 4;
  AVCOL_SPC_BT470BG     = 5;
  AVCOL_SPC_SMPTE170M   = 6;
  AVCOL_SPC_SMPTE240M   = 7;
  AVCOL_SPC_YCGCO       = 8;  ///< Used by Dirac / VC-2 and H.264 FRext, see ITU-T SG16
  AVCOL_SPC_YCOCG       = AVCOL_SPC_YCGCO;
  AVCOL_SPC_BT2020_NCL  = 9;
  AVCOL_SPC_BT2020_CL   = 10;
  AVCOL_SPC_NB          = 11;

  AVCOL_RANGE_UNSPECIFIED = 0;
  AVCOL_RANGE_MPEG        = 1;
  AVCOL_RANGE_JPEG        = 2;
  AVCOL_RANGE_NB          = 3;

  AVCHROMA_LOC_UNSPECIFIED = 0;
  AVCHROMA_LOC_LEFT        = 1;
  AVCHROMA_LOC_CENTER      = 2;
  AVCHROMA_LOC_TOPLEFT     = 3;
  AVCHROMA_LOC_TOP         = 4;
  AVCHROMA_LOC_BOTTOMLEFT  = 5;
  AVCHROMA_LOC_BOTTOM      = 6;
  AVCHROMA_LOC_NB          = 7;
{$IFEND}

type
(**
  * Chromaticity coordinates of the source primaries.
  * These values match the ones defined by ISO/IEC 23001-8_2013 § 7.1.
  *)
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVColorPrimaries = Integer;
{$ELSE}
  TAVColorPrimaries = (
    AVCOL_PRI_RESERVED0   = 0,
    AVCOL_PRI_BT709       = 1,  ///< also ITU-R BT1361 / IEC 61966-2-4 / SMPTE RP177 Annex B
    AVCOL_PRI_UNSPECIFIED = 2,
    AVCOL_PRI_RESERVED    = 3,
    AVCOL_PRI_BT470M      = 4,  ///< also FCC Title 47 Code of Federal Regulations 73.682 (a)(20)

    AVCOL_PRI_BT470BG     = 5,  ///< also ITU-R BT601-6 625 / ITU-R BT1358 625 / ITU-R BT1700 625 PAL & SECAM
    AVCOL_PRI_SMPTE170M   = 6,  ///< also ITU-R BT601-6 525 / ITU-R BT1358 525 / ITU-R BT1700 NTSC
    AVCOL_PRI_SMPTE240M   = 7,  ///< functionally identical to above
    AVCOL_PRI_FILM        = 8,  ///< colour filters using Illuminant C
    AVCOL_PRI_BT2020      = 9,  ///< ITU-R BT2020
    AVCOL_PRI_SMPTE428    = 10, ///< SMPTE ST 428-1 (CIE 1931 XYZ)
    AVCOL_PRI_SMPTEST428_1= AVCOL_PRI_SMPTE428,
    AVCOL_PRI_SMPTE431    = 11, ///< SMPTE ST 431-2 (2011) / DCI P3
    AVCOL_PRI_SMPTE432    = 12, ///< SMPTE ST 432-1 (2010) / P3 D65 / Display P3
    AVCOL_PRI_JEDEC_P22   = 22, ///< JEDEC P22 phosphors
    AVCOL_PRI_NB                ///< Not part of ABI
  );
{$IFEND}

(**
 * Color Transfer Characteristic.
 * These values match the ones defined by ISO/IEC 23001-8_2013 § 7.2.
 *)
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVColorTransferCharacteristic = Integer;
{$ELSE}
  TAVColorTransferCharacteristic = (
    AVCOL_TRC_RESERVED0    = 0,
    AVCOL_TRC_BT709        = 1,  ///< also ITU-R BT1361
    AVCOL_TRC_UNSPECIFIED  = 2,
    AVCOL_TRC_RESERVED     = 3,
    AVCOL_TRC_GAMMA22      = 4,  ///< also ITU-R BT470M / ITU-R BT1700 625 PAL & SECAM
    AVCOL_TRC_GAMMA28      = 5,  ///< also ITU-R BT470BG
    AVCOL_TRC_SMPTE170M    = 6,  ///< also ITU-R BT601-6 525 or 625 / ITU-R BT1358 525 or 625 / ITU-R BT1700 NTSC
    AVCOL_TRC_SMPTE240M    = 7,
    AVCOL_TRC_LINEAR       = 8,  ///< "Linear transfer characteristics"
    AVCOL_TRC_LOG          = 9,  ///< "Logarithmic transfer characteristic (100:1 range)"
    AVCOL_TRC_LOG_SQRT     = 10, ///< "Logarithmic transfer characteristic (100 * Sqrt( 10 ) : 1 range)"
    AVCOL_TRC_IEC61966_2_4 = 11, ///< IEC 61966-2-4
    AVCOL_TRC_BT1361_ECG   = 12, ///< ITU-R BT1361 Extended Colour Gamut
    AVCOL_TRC_IEC61966_2_1 = 13, ///< IEC 61966-2-1 (sRGB or sYCC)
    AVCOL_TRC_BT2020_10    = 14, ///< ITU-R BT2020 for 10-bit system
    AVCOL_TRC_BT2020_12    = 15, ///< ITU-R BT2020 for 12-bit system
    AVCOL_TRC_SMPTE2084    = 16, ///< SMPTE ST 2084 for 10-, 12-, 14- and 16-bit systems
    AVCOL_TRC_SMPTEST2084  = AVCOL_TRC_SMPTE2084,
    AVCOL_TRC_SMPTE428     = 17, ///< SMPTE ST 428-1
    AVCOL_TRC_SMPTEST428_1 = AVCOL_TRC_SMPTE428,
    AVCOL_TRC_ARIB_STD_B67 = 18, ///< ARIB STD-B67, known as "Hybrid log-gamma"
    AVCOL_TRC_NB                 ///< Not part of ABI
  );
{$IFEND}

type
(**
 * YUV colorspace type.
 * These values match the ones defined by ISO/IEC 23001-8_2013 § 7.3.
 *)
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVColorSpace = Integer;
{$ELSE}
  TAVColorSpace = (
    AVCOL_SPC_RGB         = 0,  ///< order of coefficients is actually GBR, also IEC 61966-2-1 (sRGB)
    AVCOL_SPC_BT709       = 1,  ///< also ITU-R BT1361 / IEC 61966-2-4 xvYCC709 / SMPTE RP177 Annex B
    AVCOL_SPC_UNSPECIFIED = 2,
    AVCOL_SPC_RESERVED    = 3,
    AVCOL_SPC_FCC         = 4,  ///< FCC Title 47 Code of Federal Regulations 73.682 (a)(20)
    AVCOL_SPC_BT470BG     = 5,  ///< also ITU-R BT601-6 625 / ITU-R BT1358 625 / ITU-R BT1700 625 PAL & SECAM / IEC 61966-2-4 xvYCC601
    AVCOL_SPC_SMPTE170M   = 6,  ///< also ITU-R BT601-6 525 / ITU-R BT1358 525 / ITU-R BT1700 NTSC
    AVCOL_SPC_SMPTE240M   = 7,  ///< functionally identical to above
    AVCOL_SPC_YCGCO       = 8,  ///< Used by Dirac / VC-2 and H.264 FRext, see ITU-T SG16
    AVCOL_SPC_YCOCG       = AVCOL_SPC_YCGCO,
    AVCOL_SPC_BT2020_NCL  = 9,  ///< ITU-R BT2020 non-constant luminance system
    AVCOL_SPC_BT2020_CL   = 10, ///< ITU-R BT2020 constant luminance system
    AVCOL_SPC_SMPTE2085   = 11, ///< SMPTE 2085, Y'D'zD'x
    AVCOL_SPC_CHROMA_DERIVED_NCL = 12, ///< Chromaticity-derived non-constant luminance system
    AVCOL_SPC_CHROMA_DERIVED_CL = 13, ///< Chromaticity-derived constant luminance system
    AVCOL_SPC_ICTCP       = 14, ///< ITU-R BT.2100-0, ICtCp
    AVCOL_SPC_NB                ///< Not part of ABI
  );
{$IFEND}

(**
 * MPEG vs JPEG YUV range.
 *)
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVColorRange = Integer;
{$ELSE}
  TAVColorRange = (
    AVCOL_RANGE_UNSPECIFIED = 0,
    AVCOL_RANGE_MPEG        = 1, ///< the normal 219*2^(n-8) "MPEG" YUV ranges
    AVCOL_RANGE_JPEG        = 2, ///< the normal     2^n-1   "JPEG" YUV ranges
    AVCOL_RANGE_NB               ///< Not part of ABI
  );
{$IFEND}

(**
 * Location of chroma samples.
 *
 * Illustration showing the location of the first (top left) chroma sample of the
 * image, the left shows only luma, the right
 * shows the location of the chroma sample, the 2 could be imagined to overlay
 * each other but are drawn separately due to limitations of ASCII
 *
 *                1st 2nd       1st 2nd horizontal luma sample positions
 *                 v   v         v   v
 *                 ______        ______
 *1st luma line > |X   X ...    |3 4 X ...     X are luma samples,
 *                |             |1 2           1-6 are possible chroma positions
 *2nd luma line > |X   X ...    |5 6 X ...     0 is undefined/unknown position
 *)
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVChromaLocation = Integer;
{$ELSE}
  TAVChromaLocation = (
    AVCHROMA_LOC_UNSPECIFIED = 0,
    AVCHROMA_LOC_LEFT        = 1, ///< MPEG-2/4 4:2:0, H.264 default for 4:2:0
    AVCHROMA_LOC_CENTER      = 2, ///< MPEG-1 4:2:0, JPEG 4:2:0, H.263 4:2:0
    AVCHROMA_LOC_TOPLEFT     = 3, ///< ITU-R 601, SMPTE 274M 296M S314M(DV 4:1:1), mpeg2 4:2:2
    AVCHROMA_LOC_TOP         = 4,
    AVCHROMA_LOC_BOTTOMLEFT  = 5,
    AVCHROMA_LOC_BOTTOM      = 6,
    AVCHROMA_LOC_NB               ///< Not part of ABI
  );
{$IFEND}


(* ****************************************************** *)
(* import libavutil_samplefmt *)
(* ****************************************************** *)






{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
const
  AV_SAMPLE_FMT_NONE=-1;
  AV_SAMPLE_FMT_U8=0;
  AV_SAMPLE_FMT_S16=1;
  AV_SAMPLE_FMT_S32=2;
  AV_SAMPLE_FMT_FLT=3;
  AV_SAMPLE_FMT_DBL=4;
  AV_SAMPLE_FMT_U8P=5;
  AV_SAMPLE_FMT_S16P=6;
  AV_SAMPLE_FMT_S32P=7;
  AV_SAMPLE_FMT_FLTP=8;
  AV_SAMPLE_FMT_DBLP=9;
  AV_SAMPLE_FMT_S64=10;
  AV_SAMPLE_FMT_S64P=11;
  AV_SAMPLE_FMT_NB=12;
{$IFEND}

type
(**
 * @addtogroup lavu_audio
 * @{
 *
 * @defgroup lavu_sampfmts Audio sample formats
 *
 * Audio sample format enumeration and related convenience functions.
 * @{
 *)

(**
 * Audio sample formats
 *
 * - The data described by the sample format is always in native-endian order.
 *   Sample values can be expressed by native C types, hence the lack of a signed
 *   24-bit sample format even though it is a common raw audio data format.
 *
 * - The floating-point formats are based on full volume being in the range
 *   [-1.0, 1.0]. Any values outside this range are beyond full volume level.
 *
 * - The data layout as used in av_samples_fill_arrays() and elsewhere in FFmpeg
 *   (such as AVFrame in libavcodec) is as follows:
 *
 * @par
 * For planar sample formats, each audio channel is in a separate data plane,
 * and linesize is the buffer size, in bytes, for a single plane. All data
 * planes must be the same size. For packed sample formats, only the first data
 * plane is used, and samples for each channel are interleaved. In this case,
 * linesize is the buffer size, in bytes, for the 1 plane.
 *
 *)
  PAVSampleFormat = ^TAVSampleFormat;
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVSampleFormat = Integer;
{$ELSE}
  TAVSampleFormat = (
    AV_SAMPLE_FMT_NONE = -1,
    AV_SAMPLE_FMT_U8,          ///< unsigned 8 bits
    AV_SAMPLE_FMT_S16,         ///< signed 16 bits
    AV_SAMPLE_FMT_S32,         ///< signed 32 bits
    AV_SAMPLE_FMT_FLT,         ///< float
    AV_SAMPLE_FMT_DBL,         ///< double

    AV_SAMPLE_FMT_U8P,         ///< unsigned 8 bits, planar
    AV_SAMPLE_FMT_S16P,        ///< signed 16 bits, planar
    AV_SAMPLE_FMT_S32P,        ///< signed 32 bits, planar
    AV_SAMPLE_FMT_FLTP,        ///< float, planar
    AV_SAMPLE_FMT_DBLP,        ///< double, planar
    AV_SAMPLE_FMT_S64,         ///< signed 64 bits
    AV_SAMPLE_FMT_S64P,        ///< signed 64 bits, planar

    AV_SAMPLE_FMT_NB           ///< Number of sample formats. DO NOT USE if linking dynamically
  );
{$IFEND}

(**
 * Return the name of sample_fmt, or NULL if sample_fmt is not
 * recognized.
 *)

{$IFDEF API_Dynamic}
var av_get_sample_fmt_name : function(sample_fmt: TAVSampleFormat): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_sample_fmt_name(sample_fmt: TAVSampleFormat): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_sample_fmt_name';
{$ENDIF API_Dynamic}


(**
 * Return a sample format corresponding to name, or AV_SAMPLE_FMT_NONE
 * on error.
 *)

{$IFDEF API_Dynamic}
var av_get_sample_fmt : function(const name: PAnsiChar): TAVSampleFormat; cdecl;
{$ELSE API_Dynamic}
function av_get_sample_fmt(const name: PAnsiChar): TAVSampleFormat; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_sample_fmt';
{$ENDIF API_Dynamic}


(**
 * Return the planar<->packed alternative form of the given sample format, or
 * AV_SAMPLE_FMT_NONE on error. If the passed sample_fmt is already in the
 * requested planar/packed format, the format returned is the same as the
 * input.
 *)

{$IFDEF API_Dynamic}
var av_get_alt_sample_fmt : function(sample_fmt: TAVSampleFormat; planar: Integer): TAVSampleFormat; cdecl;
{$ELSE API_Dynamic}
function av_get_alt_sample_fmt(sample_fmt: TAVSampleFormat; planar: Integer): TAVSampleFormat; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_alt_sample_fmt';
{$ENDIF API_Dynamic}


(**
 * Get the packed alternative form of the given sample format.
 *
 * If the passed sample_fmt is already in packed format, the format returned is
 * the same as the input.
 *
 * @return  the packed alternative form of the given sample format or
            AV_SAMPLE_FMT_NONE on error.
 *)

{$IFDEF API_Dynamic}
var av_get_packed_sample_fmt : function(sample_fmt: TAVSampleFormat): TAVSampleFormat; cdecl;
{$ELSE API_Dynamic}
function av_get_packed_sample_fmt(sample_fmt: TAVSampleFormat): TAVSampleFormat; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_packed_sample_fmt';
{$ENDIF API_Dynamic}


(**
 * Get the planar alternative form of the given sample format.
 *
 * If the passed sample_fmt is already in planar format, the format returned is
 * the same as the input.
 *
 * @return  the planar alternative form of the given sample format or
            AV_SAMPLE_FMT_NONE on error.
 *)

{$IFDEF API_Dynamic}
var av_get_planar_sample_fmt : function(sample_fmt: TAVSampleFormat): TAVSampleFormat; cdecl;
{$ELSE API_Dynamic}
function av_get_planar_sample_fmt(sample_fmt: TAVSampleFormat): TAVSampleFormat; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_planar_sample_fmt';
{$ENDIF API_Dynamic}


(**
 * Generate a string corresponding to the sample format with
 * sample_fmt, or a header if sample_fmt is negative.
 *
 * @param buf the buffer where to write the string
 * @param buf_size the size of buf
 * @param sample_fmt the number of the sample format to print the
 * corresponding info string, or a negative value to print the
 * corresponding header.
 * @return the pointer to the filled buffer or NULL if sample_fmt is
 * unknown or in case of other errors
 *)

{$IFDEF API_Dynamic}
var av_get_sample_fmt_string : function(buf: PAnsiChar; buf_size: Integer; sample_fmt: TAVSampleFormat): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_sample_fmt_string(buf: PAnsiChar; buf_size: Integer; sample_fmt: TAVSampleFormat): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_sample_fmt_string';
{$ENDIF API_Dynamic}


(**
 * Return number of bytes per sample.
 *
 * @param sample_fmt the sample format
 * @return number of bytes per sample or zero if unknown for the given
 * sample format
 *)

{$IFDEF API_Dynamic}
var av_get_bytes_per_sample : function(sample_fmt: TAVSampleFormat): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_bytes_per_sample(sample_fmt: TAVSampleFormat): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_bytes_per_sample';
{$ENDIF API_Dynamic}


(**
 * Check if the sample format is planar.
 *
 * @param sample_fmt the sample format to inspect
 * @return 1 if the sample format is planar, 0 if it is interleaved
 *)

{$IFDEF API_Dynamic}
var av_sample_fmt_is_planar : function(sample_fmt: TAVSampleFormat): Integer; cdecl;
{$ELSE API_Dynamic}
function av_sample_fmt_is_planar(sample_fmt: TAVSampleFormat): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_sample_fmt_is_planar';
{$ENDIF API_Dynamic}


(**
 * Get the required buffer size for the given audio parameters.
 *
 * @param[out] linesize calculated linesize, may be NULL
 * @param nb_channels   the number of channels
 * @param nb_samples    the number of samples in a single channel
 * @param sample_fmt    the sample format
 * @param align         buffer size alignment (0 = default, 1 = no alignment)
 * @return              required buffer size, or negative error code on failure
 *)

{$IFDEF API_Dynamic}
var av_samples_get_buffer_size : function(linesize: PInteger; nb_channels, nb_samples: Integer;
                               sample_fmt: TAVSampleFormat; align: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_samples_get_buffer_size(linesize: PInteger; nb_channels, nb_samples: Integer;
                               sample_fmt: TAVSampleFormat; align: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_samples_get_buffer_size';
{$ENDIF API_Dynamic}


(**
 * @}
 *
 * @defgroup lavu_sampmanip Samples manipulation
 *
 * Functions that manipulate audio samples
 * @{
 *)

(**
 * Fill plane data pointers and linesize for samples with sample
 * format sample_fmt.
 *
 * The audio_data array is filled with the pointers to the samples data planes:
 * for planar, set the start point of each channel's data within the buffer,
 * for packed, set the start point of the entire buffer only.
 *
 * The value pointed to by linesize is set to the aligned size of each
 * channel's data buffer for planar layout, or to the aligned size of the
 * buffer for all channels for packed layout.
 *
 * The buffer in buf must be big enough to contain all the samples
 * (use av_samples_get_buffer_size() to compute its minimum size),
 * otherwise the audio_data pointers will point to invalid data.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param[out] audio_data  array to be filled with the pointer for each channel
 * @param[out] linesize    calculated linesize, may be NULL
 * @param buf              the pointer to a buffer containing the samples
 * @param nb_channels      the number of channels
 * @param nb_samples       the number of samples in a single channel
 * @param sample_fmt       the sample format
 * @param align            buffer size alignment (0 = default, 1 = no alignment)
 * @return                 >=0 on success or a negative error code on failure
 * @todo return minimum size in bytes required for the buffer in case
 * of success at the next bump
 *)

{$IFDEF API_Dynamic}
var av_samples_fill_arrays : function(audio_data: PPByte; linesize: PInteger;
                           const buf: PByte; nb_channels, nb_samples: Integer;
                           sample_fmt: TAVSampleFormat; align: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_samples_fill_arrays(audio_data: PPByte; linesize: PInteger;
                           const buf: PByte; nb_channels, nb_samples: Integer;
                           sample_fmt: TAVSampleFormat; align: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_samples_fill_arrays';
{$ENDIF API_Dynamic}


(**
 * Allocate a samples buffer for nb_samples samples, and fill data pointers and
 * linesize accordingly.
 * The allocated samples buffer can be freed by using av_freep(&audio_data[0])
 * Allocated data will be initialized to silence.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param[out] audio_data  array to be filled with the pointer for each channel
 * @param[out] linesize    aligned size for audio buffer(s), may be NULL
 * @param nb_channels      number of audio channels
 * @param nb_samples       number of samples per channel
 * @param align            buffer size alignment (0 = default, 1 = no alignment)
 * @return                 >=0 on success or a negative error code on failure
 * @todo return the size of the allocated buffer in case of success at the next bump
 * @see av_samples_fill_arrays()
 * @see av_samples_alloc_array_and_samples()
 *)

{$IFDEF API_Dynamic}
var av_samples_alloc : function(audio_data: PPByte; linesize: PInteger;
                     nb_channels, nb_samples: Integer;
                     sample_fmt: TAVSampleFormat; align: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_samples_alloc(audio_data: PPByte; linesize: PInteger;
                     nb_channels, nb_samples: Integer;
                     sample_fmt: TAVSampleFormat; align: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_samples_alloc';
{$ENDIF API_Dynamic}


(**
 * Allocate a data pointers array, samples buffer for nb_samples
 * samples, and fill data pointers and linesize accordingly.
 *
 * This is the same as av_samples_alloc(), but also allocates the data
 * pointers array.
 *
 * @see av_samples_alloc()
 *)

{$IFDEF API_Dynamic}
var av_samples_alloc_array_and_samples : function(audio_data: PPPByte; linesize: PInteger; nb_channels: Integer;
                                       nb_samples: Integer; sample_fmt: TAVSampleFormat; align: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_samples_alloc_array_and_samples(audio_data: PPPByte; linesize: PInteger; nb_channels: Integer;
                                       nb_samples: Integer; sample_fmt: TAVSampleFormat; align: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_samples_alloc_array_and_samples';
{$ENDIF API_Dynamic}


(**
 * Copy samples from src to dst.
 *
 * @param dst destination array of pointers to data planes
 * @param src source array of pointers to data planes
 * @param dst_offset offset in samples at which the data will be written to dst
 * @param src_offset offset in samples at which the data will be read from src
 * @param nb_samples number of samples to be copied
 * @param nb_channels number of audio channels
 * @param sample_fmt audio sample format
 *)

{$IFDEF API_Dynamic}
var av_samples_copy : function(dst: PPByte; const src: PPByte;
                    dst_offset, src_offset, nb_samples, nb_channels: Integer;
                    sample_fmt: TAVSampleFormat): Integer; cdecl;
{$ELSE API_Dynamic}
function av_samples_copy(dst: PPByte; const src: PPByte;
                    dst_offset, src_offset, nb_samples, nb_channels: Integer;
                    sample_fmt: TAVSampleFormat): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_samples_copy';
{$ENDIF API_Dynamic}


(**
 * Fill an audio buffer with silence.
 *
 * @param audio_data  array of pointers to data planes
 * @param offset      offset in samples at which to start filling
 * @param nb_samples  number of samples to fill
 * @param nb_channels number of audio channels
 * @param sample_fmt  audio sample format
 *)

{$IFDEF API_Dynamic}
var av_samples_set_silence : function(audio_data: PPByte;
                            offset, nb_samples, nb_channels: Integer;
                            sample_fmt: TAVSampleFormat): Integer; cdecl;
{$ELSE API_Dynamic}
function av_samples_set_silence(audio_data: PPByte;
                            offset, nb_samples, nb_channels: Integer;
                            sample_fmt: TAVSampleFormat): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_samples_set_silence';
{$ENDIF API_Dynamic}


(**
 * @}
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_opt *)
(* ****************************************************** *)






(**
 * @defgroup avoptions AVOptions
 * @ingroup lavu_data
 * @{
 * AVOptions provide a generic system to declare options on arbitrary structs
 * ("objects"). An option can have a help text, a type and a range of possible
 * values. Options may then be enumerated, read and written to.
 *
 * @section avoptions_implement Implementing AVOptions
 * This section describes how to add AVOptions capabilities to a struct.
 *
 * All AVOptions-related information is stored in an AVClass. Therefore
 * the first member of the struct should be a pointer to an AVClass describing it.
 * The option field of the AVClass must be set to a NULL-terminated static array
 * of AVOptions. Each AVOption must have a non-empty name, a type, a default
 * value and for number-type AVOptions also a range of allowed values. It must
 * also declare an offset in bytes from the start of the struct, where the field
 * associated with this AVOption is located. Other fields in the AVOption struct
 * should also be set when applicable, but are not required.
 *
 * The following example illustrates an AVOptions-enabled struct:
 * @code
 * typedef struct test_struct {
 *     const AVClass *class;
 *     int      int_opt;
 *     char    *str_opt;
 *     uint8_t *bin_opt;
 *     int      bin_len;
 * } test_struct;
 *
 * static const AVOption test_options[] = {
 *   { "test_int", "This is a test option of int type.", offsetof(test_struct, int_opt),
 *     AV_OPT_TYPE_INT, { .i64 = -1 }, INT_MIN, INT_MAX },
 *   { "test_str", "This is a test option of string type.", offsetof(test_struct, str_opt),
 *     AV_OPT_TYPE_STRING },
 *   { "test_bin", "This is a test option of binary type.", offsetof(test_struct, bin_opt),
 *     AV_OPT_TYPE_BINARY },
 *   { NULL },
 * };
 *
 * static const AVClass test_class = {
 *     .class_name = "test class",
 *     .item_name  = av_default_item_name,
 *     .option     = test_options,
 *     .version    = LIBAVUTIL_VERSION_INT,
 * };
 * @endcode
 *
 * Next, when allocating your struct, you must ensure that the AVClass pointer
 * is set to the correct value. Then, av_opt_set_defaults() can be called to
 * initialize defaults. After that the struct is ready to be used with the
 * AVOptions API.
 *
 * When cleaning up, you may use the av_opt_free() function to automatically
 * free all the allocated string and binary options.
 *
 * Continuing with the above example:
 *
 * @code
 * test_struct *alloc_test_struct(void)
 * {
 *     test_struct *ret = av_mallocz(sizeof(*ret));
 *     ret->class = &test_class;
 *     av_opt_set_defaults(ret);
 *     return ret;
 * }
 * void free_test_struct(test_struct **foo)
 * {
 *     av_opt_free(*foo);
 *     av_freep(foo);
 * }
 * @endcode
 *
 * @subsection avoptions_implement_nesting Nesting
 *      It may happen that an AVOptions-enabled struct contains another
 *      AVOptions-enabled struct as a member (e.g. AVCodecContext in
 *      libavcodec exports generic options, while its priv_data field exports
 *      codec-specific options). In such a case, it is possible to set up the
 *      parent struct to export a child's options. To do that, simply
 *      implement AVClass.child_next() and AVClass.child_class_next() in the
 *      parent struct's AVClass.
 *      Assuming that the test_struct from above now also contains a
 *      child_struct field:
 *
 *      @code
 *      typedef struct child_struct {
 *          AVClass *class;
 *          int flags_opt;
 *      } child_struct;
 *      static const AVOption child_opts[] = {
 *          { "test_flags", "This is a test option of flags type.",
 *            offsetof(child_struct, flags_opt), AV_OPT_TYPE_FLAGS, { .i64 = 0 }, INT_MIN, INT_MAX },
 *          { NULL },
 *      };
 *      static const AVClass child_class = {
 *          .class_name = "child class",
 *          .item_name  = av_default_item_name,
 *          .option     = child_opts,
 *          .version    = LIBAVUTIL_VERSION_INT,
 *      };
 *
 *      void *child_next(void *obj, void *prev)
 *      {
 *          test_struct *t = obj;
 *          if (!prev && t->child_struct)
 *              return t->child_struct;
 *          return NULL
 *      }
 *      const AVClass child_class_next(const AVClass *prev)
 *      {
 *          return prev ? NULL : &child_class;
 *      }
 *      @endcode
 *      Putting child_next() and child_class_next() as defined above into
 *      test_class will now make child_struct's options accessible through
 *      test_struct (again, proper setup as described above needs to be done on
 *      child_struct right after it is created).
 *
 *      From the above example it might not be clear why both child_next()
 *      and child_class_next() are needed. The distinction is that child_next()
 *      iterates over actually existing objects, while child_class_next()
 *      iterates over all possible child classes. E.g. if an AVCodecContext
 *      was initialized to use a codec which has private options, then its
 *      child_next() will return AVCodecContext.priv_data and finish
 *      iterating. OTOH child_class_next() on AVCodecContext.av_class will
 *      iterate over all available codecs with private options.
 *
 * @subsection avoptions_implement_named_constants Named constants
 *      It is possible to create named constants for options. Simply set the unit
 *      field of the option the constants should apply to a string and
 *      create the constants themselves as options of type AV_OPT_TYPE_CONST
 *      with their unit field set to the same string.
 *      Their default_val field should contain the value of the named
 *      constant.
 *      For example, to add some named constants for the test_flags option
 *      above, put the following into the child_opts array:
 *      @code
 *      { "test_flags", "This is a test option of flags type.",
 *        offsetof(child_struct, flags_opt), AV_OPT_TYPE_FLAGS, { .i64 = 0 }, INT_MIN, INT_MAX, "test_unit" },
 *      { "flag1", "This is a flag with value 16", 0, AV_OPT_TYPE_CONST, { .i64 = 16 }, 0, 0, "test_unit" },
 *      @endcode
 *
 * @section avoptions_use Using AVOptions
 * This section deals with accessing options in an AVOptions-enabled struct.
 * Such structs in FFmpeg are e.g. AVCodecContext in libavcodec or
 * AVFormatContext in libavformat.
 *
 * @subsection avoptions_use_examine Examining AVOptions
 * The basic functions for examining options are av_opt_next(), which iterates
 * over all options defined for one object, and av_opt_find(), which searches
 * for an option with the given name.
 *
 * The situation is more complicated with nesting. An AVOptions-enabled struct
 * may have AVOptions-enabled children. Passing the AV_OPT_SEARCH_CHILDREN flag
 * to av_opt_find() will make the function search children recursively.
 *
 * For enumerating there are basically two cases. The first is when you want to
 * get all options that may potentially exist on the struct and its children
 * (e.g.  when constructing documentation). In that case you should call
 * av_opt_child_class_next() recursively on the parent struct's AVClass.  The
 * second case is when you have an already initialized struct with all its
 * children and you want to get all options that can be actually written or read
 * from it. In that case you should call av_opt_child_next() recursively (and
 * av_opt_next() on each result).
 *
 * @subsection avoptions_use_get_set Reading and writing AVOptions
 * When setting options, you often have a string read directly from the
 * user. In such a case, simply passing it to av_opt_set() is enough. For
 * non-string type options, av_opt_set() will parse the string according to the
 * option type.
 *
 * Similarly av_opt_get() will read any option type and convert it to a string
 * which will be returned. Do not forget that the string is allocated, so you
 * have to free it with av_free().
 *
 * In some cases it may be more convenient to put all options into an
 * AVDictionary and call av_opt_set_dict() on it. A specific case of this
 * are the format/codec open functions in lavf/lavc which take a dictionary
 * filled with option as a parameter. This allows to set some options
 * that cannot be set otherwise, since e.g. the input file format is not known
 * before the file is actually opened.
 *)

{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
const
  AV_OPT_TYPE_FLAGS=0;
  AV_OPT_TYPE_INT=1;
  AV_OPT_TYPE_INT64=2;
  AV_OPT_TYPE_DOUBLE=3;
  AV_OPT_TYPE_FLOAT=4;
  AV_OPT_TYPE_STRING=5;
  AV_OPT_TYPE_RATIONAL=6;
  AV_OPT_TYPE_BINARY=7;
  AV_OPT_TYPE_DICT=8;
  AV_OPT_TYPE_UINT64=9;
  AV_OPT_TYPE_CONST=128;
  AV_OPT_TYPE_IMAGE_SIZE=(Ord('S') shl 24) or (Ord('I') shl 16) or (Ord('Z') shl 8) or Ord('E');
  AV_OPT_TYPE_PIXEL_FMT=(Ord('P') shl 24) or (Ord('F') shl 16) or (Ord('M') shl 8) or Ord('T');
  AV_OPT_TYPE_SAMPLE_FMT=(Ord('S') shl 24) or (Ord('F') shl 16) or (Ord('M') shl 8) or Ord('T');
  AV_OPT_TYPE_VIDEO_RATE=(Ord('V') shl 24) or (Ord('R') shl 16) or (Ord('A') shl 8) or Ord('T');
  AV_OPT_TYPE_DURATION=(Ord('D') shl 24) or (Ord('U') shl 16) or (Ord('R') shl 8) or Ord(' ');
  AV_OPT_TYPE_COLOR=(Ord('C') shl 24) or (Ord('O') shl 16) or (Ord('L') shl 8) or Ord('R');
  AV_OPT_TYPE_CHANNEL_LAYOUT=(Ord('C') shl 24) or (Ord('H') shl 16) or (Ord('L') shl 8) or Ord('A');
  AV_OPT_TYPE_BOOL=(Ord('B') shl 24) or (Ord('O') shl 16) or (Ord('O') shl 8) or Ord('L');
type
  TAVOptionType = Integer;
{$ELSE}
type
  TAVOptionType = (
    AV_OPT_TYPE_FLAGS,
    AV_OPT_TYPE_INT,
    AV_OPT_TYPE_INT64,
    AV_OPT_TYPE_DOUBLE,
    AV_OPT_TYPE_FLOAT,
    AV_OPT_TYPE_STRING,
    AV_OPT_TYPE_RATIONAL,
    AV_OPT_TYPE_BINARY,  ///< offset must point to a pointer immediately followed by an int for the length
    AV_OPT_TYPE_DICT,
    AV_OPT_TYPE_UINT64,
    AV_OPT_TYPE_CONST = 128,
    AV_OPT_TYPE_IMAGE_SIZE = (Ord('S') shl 24) or (Ord('I') shl 16) or (Ord('Z') shl 8) or Ord('E'), ///< offset must point to two consecutive integers
    AV_OPT_TYPE_PIXEL_FMT  = (Ord('P') shl 24) or (Ord('F') shl 16) or (Ord('M') shl 8) or Ord('T'),
    AV_OPT_TYPE_SAMPLE_FMT = (Ord('S') shl 24) or (Ord('F') shl 16) or (Ord('M') shl 8) or Ord('T'),
    AV_OPT_TYPE_VIDEO_RATE = (Ord('V') shl 24) or (Ord('R') shl 16) or (Ord('A') shl 8) or Ord('T'), ///< offset must point to AVRational
    AV_OPT_TYPE_DURATION   = (Ord('D') shl 24) or (Ord('U') shl 16) or (Ord('R') shl 8) or Ord(' '),
    AV_OPT_TYPE_COLOR      = (Ord('C') shl 24) or (Ord('O') shl 16) or (Ord('L') shl 8) or Ord('R'),
    AV_OPT_TYPE_CHANNEL_LAYOUT=(Ord('C') shl 24) or (Ord('H') shl 16) or (Ord('L') shl 8) or Ord('A'),
    AV_OPT_TYPE_BOOL       = (Ord('B') shl 24) or (Ord('O') shl 16) or (Ord('O') shl 8) or Ord('L')
  );
{$IFEND}

const
  // const for TAVOption.flags
  AV_OPT_FLAG_ENCODING_PARAM  = 1;   ///< a generic parameter which can be set by the user for muxing or encoding
  AV_OPT_FLAG_DECODING_PARAM  = 2;   ///< a generic parameter which can be set by the user for demuxing or decoding
{$IFDEF FF_API_OPT_TYPE_METADATA}
  AV_OPT_FLAG_METADATA        = 4;   ///< some data extracted or inserted into the file like title, comment, ...
{$ENDIF}
  AV_OPT_FLAG_AUDIO_PARAM     = 8;
  AV_OPT_FLAG_VIDEO_PARAM     = 16;
  AV_OPT_FLAG_SUBTITLE_PARAM  = 32;
(**
 * The option is intended for exporting values to the caller.
 *)
  AV_OPT_FLAG_EXPORT          = 64;
(**
 * The option may not be set through the AVOptions API, only read.
 * This flag only makes sense when AV_OPT_FLAG_EXPORT is also set.
 *)
  AV_OPT_FLAG_READONLY        = 128;
  AV_OPT_FLAG_FILTERING_PARAM = (1 shl 16); ///< a generic parameter which can be set by the user for filtering
//FIXME think about enc-audio, ... style flags

(**
 * AVOption
 *)
type
  _Tdefault_val = record
    case Integer of
      0: (i64: Int64);
      1: (dbl: Double);
      2: (str: PAnsiChar);
      (* TODO those are unused now *)
      3: (q: TAVRational);
  end;

  PPAVOption = ^PAVOption;
  PAVOption = ^TAVOption;
  TAVOption = record
    name: PAnsiChar;

    (**
     * short English help text.
     * @todo What about other languages
     *)
    help: PAnsiChar;

    (**
     * The offset relative to the context structure where the option
     * value is stored. It should be 0 for named constants.
     *)
    offset: Integer;
    ttype: TAVOptionType;

    (**
     * the default value for scalar options
     *)
    default_val: _Tdefault_val;
    min: Double;                        ///< minimum valid value for the option
    max: Double;                        ///< maximum valid value for the option

    flags: Integer;
{
#define AV_OPT_FLAG_ENCODING_PARAM  1   ///< a generic parameter which can be set by the user for muxing or encoding
#define AV_OPT_FLAG_DECODING_PARAM  2   ///< a generic parameter which can be set by the user for demuxing or decoding
#if FF_API_OPT_TYPE_METADATA
#define AV_OPT_FLAG_METADATA        4   ///< some data extracted or inserted into the file like title, comment, ...
#endif
#define AV_OPT_FLAG_AUDIO_PARAM     8
#define AV_OPT_FLAG_VIDEO_PARAM     16
#define AV_OPT_FLAG_SUBTITLE_PARAM  32
/**
 * The option is intended for exporting values to the caller.
 */
#define AV_OPT_FLAG_EXPORT          64
/**
 * The option may not be set through the AVOptions API, only read.
 * This flag only makes sense when AV_OPT_FLAG_EXPORT is also set.
 */
#define AV_OPT_FLAG_READONLY        128
#define AV_OPT_FLAG_FILTERING_PARAM (1<<16) ///< a generic parameter which can be set by the user for filtering
//FIXME think about enc-audio, ... style flags
}

    (**
     * The logical unit to which the option belongs. Non-constant
     * options and corresponding named constants share the same
     * unit. May be NULL.
     *)
    uunit: PAnsiChar; //const char *unit;
  end;

(**
 * A single allowed range of values, or a single allowed value.
 *)
  PPAVOptionRange = ^PAVOptionRange;
  PAVOptionRange = ^TAVOptionRange;
  TAVOptionRange = record
    str: PAnsiChar;
    (**
     * Value range.
     * For string ranges this represents the min/max length.
     * For dimensions this represents the min/max pixel count or width/height in multi-component case.
     *)
    value_min, value_max: Double;
    (**
     * Value's component range.
     * For string this represents the unicode range for chars, 0-127 limits to ASCII.
     *)
    component_min, component_max: Double;
    (**
     * Range flag.
     * If set to 1 the struct encodes a range, if set to 0 a single value.
     *)
    is_range: Integer;
  end;

(**
 * List of AVOptionRange structs.
 *)
  PPAVOptionRanges = ^PAVOptionRanges;
  PAVOptionRanges = ^TAVOptionRanges;
  TAVOptionRanges = record
    (**
     * Array of option ranges.
     *
     * Most of option types use just one component.
     * Following describes multi-component option types:
     *
     * AV_OPT_TYPE_IMAGE_SIZE:
     * component index 0: range of pixel count (width * height).
     * component index 1: range of width.
     * component index 2: range of height.
     *
     * @note To obtain multi-component version of this structure, user must
     *       provide AV_OPT_MULTI_COMPONENT_RANGE to av_opt_query_ranges or
     *       av_opt_query_ranges_default function.
     *
     * Multi-component range can be read as in following example:
     *
     * @code
     * int range_index, component_index;
     * AVOptionRanges *ranges;
     * AVOptionRange *range[3]; //may require more than 3 in the future.
     * av_opt_query_ranges(&ranges, obj, key, AV_OPT_MULTI_COMPONENT_RANGE);
     * for (range_index = 0; range_index < ranges->nb_ranges; range_index++) {
     *     for (component_index = 0; component_index < ranges->nb_components; component_index++)
     *         range[component_index] = ranges->range[ranges->nb_ranges * component_index + range_index];
     *     //do something with range here.
     * }
     * av_opt_freep_ranges(&ranges);
     * @endcode
     *)
    range: PPAVOptionRange;
    (**
     * Number of ranges per component.
     *)
    nb_ranges: Integer;
    (**
     * Number of componentes.
     *)
    nb_components: Integer;
  end;

(**
 * Show the obj options.
 *
 * @param req_flags requested flags for the options to show. Show only the
 * options for which it is opt->flags & req_flags.
 * @param rej_flags rejected flags for the options to show. Show only the
 * options for which it is !(opt->flags & req_flags).
 * @param av_log_obj log context to use for showing the options
 *)

{$IFDEF API_Dynamic}
var av_opt_show2 : function(obj: Pointer; av_log_obj: Pointer; req_flags, rej_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_show2(obj: Pointer; av_log_obj: Pointer; req_flags, rej_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_show2';
{$ENDIF API_Dynamic}


(**
 * Set the values of all AVOption fields to their default values.
 *
 * @param s an AVOption-enabled struct (its first member must be a pointer to AVClass)
 *)

{$IFDEF API_Dynamic}
var av_opt_set_defaults : procedure(s: Pointer); cdecl;
{$ELSE API_Dynamic}
procedure av_opt_set_defaults(s: Pointer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_defaults';
{$ENDIF API_Dynamic}


(**
 * Set the values of all AVOption fields to their default values. Only these
 * AVOption fields for which (opt->flags & mask) == flags will have their
 * default applied to s.
 *
 * @param s an AVOption-enabled struct (its first member must be a pointer to AVClass)
 * @param mask combination of AV_OPT_FLAG_*
 * @param flags combination of AV_OPT_FLAG_*
 *)

{$IFDEF API_Dynamic}
var av_opt_set_defaults2 : procedure(s: Pointer; mask, flags: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_opt_set_defaults2(s: Pointer; mask, flags: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_defaults2';
{$ENDIF API_Dynamic}


(**
 * Parse the key/value pairs list in opts. For each key/value pair
 * found, stores the value in the field in ctx that is named like the
 * key. ctx must be an AVClass context, storing is done using
 * AVOptions.
 *
 * @param opts options string to parse, may be NULL
 * @param key_val_sep a 0-terminated list of characters used to
 * separate key from value
 * @param pairs_sep a 0-terminated list of characters used to separate
 * two pairs from each other
 * @return the number of successfully set key/value pairs, or a negative
 * value corresponding to an AVERROR code in case of error:
 * AVERROR(EINVAL) if opts cannot be parsed,
 * the error code issued by av_opt_set() if a key/value pair
 * cannot be set
 *)

{$IFDEF API_Dynamic}
var av_set_options_string : function(ctx: Pointer; const opts: PAnsiChar;
                          const key_val_sep: PAnsiChar; const pairs_sep: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_set_options_string(ctx: Pointer; const opts: PAnsiChar;
                          const key_val_sep: PAnsiChar; const pairs_sep: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_set_options_string';
{$ENDIF API_Dynamic}


(**
 * Parse the key-value pairs list in opts. For each key=value pair found,
 * set the value of the corresponding option in ctx.
 *
 * @param ctx          the AVClass object to set options on
 * @param opts         the options string, key-value pairs separated by a
 *                     delimiter
 * @param shorthand    a NULL-terminated array of options names for shorthand
 *                     notation: if the first field in opts has no key part,
 *                     the key is taken from the first element of shorthand;
 *                     then again for the second, etc., until either opts is
 *                     finished, shorthand is finished or a named option is
 *                     found; after that, all options must be named
 * @param key_val_sep  a 0-terminated list of characters used to separate
 *                     key from value, for example '='
 * @param pairs_sep    a 0-terminated list of characters used to separate
 *                     two pairs from each other, for example ':' or ','
 * @return  the number of successfully set key=value pairs, or a negative
 *          value corresponding to an AVERROR code in case of error:
 *          AVERROR(EINVAL) if opts cannot be parsed,
 *          the error code issued by av_set_string3() if a key/value pair
 *          cannot be set
 *
 * Options names must use only the following characters: a-z A-Z 0-9 - . / _
 * Separators must use characters distinct from option names and from each
 * other.
 *)

{$IFDEF API_Dynamic}
var av_opt_set_from_string : function(ctx: Pointer; const opts: PAnsiChar;
                           const shorthand: PPAnsiChar;//const char *const *shorthand,
                           const key_val_sep, pairs_sep: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_from_string(ctx: Pointer; const opts: PAnsiChar;
                           const shorthand: PPAnsiChar;//const char *const *shorthand,
                           const key_val_sep, pairs_sep: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_from_string';
{$ENDIF API_Dynamic}

(**
 * Free all allocated objects in obj.
 *)

{$IFDEF API_Dynamic}
var av_opt_free : procedure(obj: Pointer); cdecl;
{$ELSE API_Dynamic}
procedure av_opt_free(obj: Pointer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_free';
{$ENDIF API_Dynamic}


(**
 * Check whether a particular flag is set in a flags field.
 *
 * @param field_name the name of the flag field option
 * @param flag_name the name of the flag to check
 * @return non-zero if the flag is set, zero if the flag isn't set,
 *         isn't of the right type, or the flags field doesn't exist.
 *)

{$IFDEF API_Dynamic}
var av_opt_flag_is_set : function(obj: Pointer; const field_name, flag_name: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_flag_is_set(obj: Pointer; const field_name, flag_name: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_flag_is_set';
{$ENDIF API_Dynamic}


(**
 * Set all the options from a given dictionary on an object.
 *
 * @param obj a struct whose first element is a pointer to AVClass
 * @param options options to process. This dictionary will be freed and replaced
 *                by a new one containing all options not found in obj.
 *                Of course this new dictionary needs to be freed by caller
 *                with av_dict_free().
 *
 * @return 0 on success, a negative AVERROR if some option was found in obj,
 *         but could not be set.
 *
 * @see av_dict_copy()
 *)

{$IFDEF API_Dynamic}
var av_opt_set_dict : function(obj: Pointer; options: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_dict(obj: Pointer; options: PPAVDictionary): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_dict';
{$ENDIF API_Dynamic}


(**
 * Set all the options from a given dictionary on an object.
 *
 * @param obj a struct whose first element is a pointer to AVClass
 * @param options options to process. This dictionary will be freed and replaced
 *                by a new one containing all options not found in obj.
 *                Of course this new dictionary needs to be freed by caller
 *                with av_dict_free().
 * @param search_flags A combination of AV_OPT_SEARCH_*.
 *
 * @return 0 on success, a negative AVERROR if some option was found in obj,
 *         but could not be set.
 *
 * @see av_dict_copy()
 *)

{$IFDEF API_Dynamic}
var av_opt_set_dict2 : function(obj: Pointer; options: PPAVDictionary; search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_dict2(obj: Pointer; options: PPAVDictionary; search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_dict2';
{$ENDIF API_Dynamic}


(**
 * Extract a key-value pair from the beginning of a string.
 *
 * @param ropts        pointer to the options string, will be updated to
 *                     point to the rest of the string (one of the pairs_sep
 *                     or the final NUL)
 * @param key_val_sep  a 0-terminated list of characters used to separate
 *                     key from value, for example '='
 * @param pairs_sep    a 0-terminated list of characters used to separate
 *                     two pairs from each other, for example ':' or ','
 * @param flags        flags; see the AV_OPT_FLAG_* values below
 * @param rkey         parsed key; must be freed using av_free()
 * @param rval         parsed value; must be freed using av_free()
 *
 * @return  >=0 for success, or a negative value corresponding to an
 *          AVERROR code in case of error; in particular:
 *          AVERROR(EINVAL) if no key is present
 *
 *)

{$IFDEF API_Dynamic}
var av_opt_get_key_value : function(const ropts: PPAnsiChar;
                         const key_val_sep, pairs_sep: PAnsiChar;
                         flags: Cardinal;
                         rkey, rval: PPAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_get_key_value(const ropts: PPAnsiChar;
                         const key_val_sep, pairs_sep: PAnsiChar;
                         flags: Cardinal;
                         rkey, rval: PPAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_get_key_value';
{$ENDIF API_Dynamic}


const
  (**
   * Accept to parse a value without a key; the key will then be returned
   * as NULL.
   *)
  AV_OPT_FLAG_IMPLICIT_KEY = 1;

(**
 * @defgroup opt_eval_funcs Evaluating option strings
 * @{
 * This group of functions can be used to evaluate option strings
 * and get numbers out of them. They do the same thing as av_opt_set(),
 * except the result is written into the caller-supplied pointer.
 *
 * @param obj a struct whose first element is a pointer to AVClass.
 * @param o an option for which the string is to be evaluated.
 * @param val string to be evaluated.
 * @param *_out value of the string will be written here.
 *
 * @return 0 on success, a negative number on failure.
 *)

{$IFDEF API_Dynamic}
var av_opt_eval_flags : function(obj: Pointer; const o: PAVOption; const val: PAnsiChar; flags_out : PInteger): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_eval_flags(obj: Pointer; const o: PAVOption; const val: PAnsiChar; flags_out : PInteger)   : Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_eval_flags';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_eval_int : function(obj: Pointer; const o: PAVOption; const val: PAnsiChar; int_out   : PInteger): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_eval_int(obj: Pointer; const o: PAVOption; const val: PAnsiChar; int_out   : PInteger)   : Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_eval_int';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_eval_int64 : function(obj: Pointer; const o: PAVOption; const val: PAnsiChar; int64_out : PInt64): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_eval_int64(obj: Pointer; const o: PAVOption; const val: PAnsiChar; int64_out : PInt64)     : Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_eval_int64';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_eval_float : function(obj: Pointer; const o: PAVOption; const val: PAnsiChar; float_out : PSingle): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_eval_float(obj: Pointer; const o: PAVOption; const val: PAnsiChar; float_out : PSingle)    : Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_eval_float';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_eval_double : function(obj: Pointer; const o: PAVOption; const val: PAnsiChar; double_out: PDouble): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_eval_double(obj: Pointer; const o: PAVOption; const val: PAnsiChar; double_out: PDouble)    : Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_eval_double';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_eval_q : function(obj: Pointer; const o: PAVOption; const val: PAnsiChar; q_out     : PAVRational): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_eval_q(obj: Pointer; const o: PAVOption; const val: PAnsiChar; q_out     : PAVRational): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_eval_q';
{$ENDIF API_Dynamic}

(**
 * @}
 *)

const
  AV_OPT_SEARCH_CHILDREN  = (1 shl 0); (**< Search in possible children of the
                                            given object first. *)
(**
 *  The obj passed to av_opt_find() is fake -- only a double pointer to AVClass
 *  instead of a required pointer to a struct containing AVClass. This is
 *  useful for searching for options without needing to allocate the corresponding
 *  object.
 *)
  AV_OPT_SEARCH_FAKE_OBJ  = (1 shl 1);

(**
 *  In av_opt_get, return NULL if the option has a pointer type and is set to NULL,
 *  rather than returning an empty string.
 *)
  AV_OPT_ALLOW_NULL       = (1 shl 2);

(**
 *  Allows av_opt_query_ranges and av_opt_query_ranges_default to return more than
 *  one component for certain option types.
 *  @see AVOptionRanges for details.
 *)
  AV_OPT_MULTI_COMPONENT_RANGE = (1 shl 12);

(**
 * Look for an option in an object. Consider only options which
 * have all the specified flags set.
 *
 * @param[in] obj A pointer to a struct whose first element is a
 *                pointer to an AVClass.
 *                Alternatively a double pointer to an AVClass, if
 *                AV_OPT_SEARCH_FAKE_OBJ search flag is set.
 * @param[in] name The name of the option to look for.
 * @param[in] unit When searching for named constants, name of the unit
 *                 it belongs to.
 * @param opt_flags Find only options with all the specified flags set (AV_OPT_FLAG).
 * @param search_flags A combination of AV_OPT_SEARCH_*.
 *
 * @return A pointer to the option found, or NULL if no option
 *         was found.
 *
 * @note Options found with AV_OPT_SEARCH_CHILDREN flag may not be settable
 * directly with av_opt_set(). Use special calls which take an options
 * AVDictionary (e.g. avformat_open_input()) to set options found with this
 * flag.
 *)

{$IFDEF API_Dynamic}
var av_opt_find : function(obj: Pointer; const name, unit_: PAnsiChar;
                            opt_flags, search_flags: Integer): PAVOption; cdecl;
{$ELSE API_Dynamic}
function av_opt_find(obj: Pointer; const name, unit_: PAnsiChar;
                            opt_flags, search_flags: Integer): PAVOption; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_find';
{$ENDIF API_Dynamic}


(**
 * Look for an option in an object. Consider only options which
 * have all the specified flags set.
 *
 * @param[in] obj A pointer to a struct whose first element is a
 *                pointer to an AVClass.
 *                Alternatively a double pointer to an AVClass, if
 *                AV_OPT_SEARCH_FAKE_OBJ search flag is set.
 * @param[in] name The name of the option to look for.
 * @param[in] unit When searching for named constants, name of the unit
 *                 it belongs to.
 * @param opt_flags Find only options with all the specified flags set (AV_OPT_FLAG).
 * @param search_flags A combination of AV_OPT_SEARCH_*.
 * @param[out] target_obj if non-NULL, an object to which the option belongs will be
 * written here. It may be different from obj if AV_OPT_SEARCH_CHILDREN is present
 * in search_flags. This parameter is ignored if search_flags contain
 * AV_OPT_SEARCH_FAKE_OBJ.
 *
 * @return A pointer to the option found, or NULL if no option
 *         was found.
 *)

{$IFDEF API_Dynamic}
var av_opt_find2 : function(obj: Pointer; const name, unit_: PAnsiChar;
                              opt_flags, search_flags: Integer; target_obj: PPointer): PAVOption; cdecl;
{$ELSE API_Dynamic}
function av_opt_find2(obj: Pointer; const name, unit_: PAnsiChar;
                              opt_flags, search_flags: Integer; target_obj: PPointer): PAVOption; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_find2';
{$ENDIF API_Dynamic}


(**
 * Iterate over all AVOptions belonging to obj.
 *
 * @param obj an AVOptions-enabled struct or a double pointer to an
 *            AVClass describing it.
 * @param prev result of the previous call to av_opt_next() on this object
 *             or NULL
 * @return next AVOption or NULL
 *)

{$IFDEF API_Dynamic}
var av_opt_next : function(const obj: Pointer; const prev: PAVOption): PAVOption; cdecl;
{$ELSE API_Dynamic}
function av_opt_next(const obj: Pointer; const prev: PAVOption): PAVOption; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_next';
{$ENDIF API_Dynamic}


(**
 * Iterate over AVOptions-enabled children of obj.
 *
 * @param prev result of a previous call to this function or NULL
 * @return next AVOptions-enabled child or NULL
 *)

{$IFDEF API_Dynamic}
var av_opt_child_next : procedure(obj, prev: Pointer); cdecl;
{$ELSE API_Dynamic}
procedure av_opt_child_next(obj, prev: Pointer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_child_next';
{$ENDIF API_Dynamic}


(**
 * Iterate over potential AVOptions-enabled children of parent.
 *
 * @param prev result of a previous call to this function or NULL
 * @return AVClass corresponding to next potential child or NULL
 *)

{$IFDEF API_Dynamic}
var av_opt_child_class_next : function(const parent, prev: Pointer{PAVClass}): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_opt_child_class_next(const parent, prev: Pointer{PAVClass}): Pointer{PAVClass}; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_child_class_next';
{$ENDIF API_Dynamic}


(**
 * @defgroup opt_set_funcs Option setting functions
 * @{
 * Those functions set the field of obj with the given name to value.
 *
 * @param[in] obj A struct whose first element is a pointer to an AVClass.
 * @param[in] name the name of the field to set
 * @param[in] val The value to set. In case of av_opt_set() if the field is not
 * of a string type, then the given string is parsed.
 * SI postfixes and some named scalars are supported.
 * If the field is of a numeric type, it has to be a numeric or named
 * scalar. Behavior with more than one scalar and +- infix operators
 * is undefined.
 * If the field is of a flags type, it has to be a sequence of numeric
 * scalars or named flags separated by '+' or '-'. Prefixing a flag
 * with '+' causes it to be set without affecting the other flags;
 * similarly, '-' unsets a flag.
 * @param search_flags flags passed to av_opt_find2. I.e. if AV_OPT_SEARCH_CHILDREN
 * is passed here, then the option may be set on a child of obj.
 *
 * @return 0 if the value has been set, or an AVERROR code in case of
 * error:
 * AVERROR_OPTION_NOT_FOUND if no matching option exists
 * AVERROR(ERANGE) if the value is out of range
 * AVERROR(EINVAL) if the value is not valid
 *)

{$IFDEF API_Dynamic}
var av_opt_set : function(obj: Pointer; const name: PAnsiChar; val: PAnsiChar;   search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set(obj: Pointer; const name: PAnsiChar; val: PAnsiChar;   search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_set_int : function(obj: Pointer; const name: PAnsiChar; val: Int64;       search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_int(obj: Pointer; const name: PAnsiChar; val: Int64;       search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_int';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_set_double : function(obj: Pointer; const name: PAnsiChar; val: Double;      search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_double(obj: Pointer; const name: PAnsiChar; val: Double;      search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_double';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_set_q : function(obj: Pointer; const name: PAnsiChar; val: TAVRational; search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_q(obj: Pointer; const name: PAnsiChar; val: TAVRational; search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_q';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_set_bin : function(obj: Pointer; const name: PAnsiChar; val: PByte; size, search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_bin(obj: Pointer; const name: PAnsiChar; val: PByte; size, search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_bin';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_set_image_size : function(obj: Pointer; const name: PAnsiChar; w, h, search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_image_size(obj: Pointer; const name: PAnsiChar; w, h, search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_image_size';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_set_pixel_fmt : function(obj: Pointer; const name: PAnsiChar; fmt: TAVPixelFormat; search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_pixel_fmt(obj: Pointer; const name: PAnsiChar; fmt: TAVPixelFormat; search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_pixel_fmt';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_set_sample_fmt : function(obj: Pointer; const name: PAnsiChar; fmt: TAVSampleFormat; search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_sample_fmt(obj: Pointer; const name: PAnsiChar; fmt: TAVSampleFormat; search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_sample_fmt';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_set_video_rate : function(obj: Pointer; const name: PAnsiChar; val: TAVRational; search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_video_rate(obj: Pointer; const name: PAnsiChar; val: TAVRational; search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_video_rate';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_set_channel_layout : function(obj: Pointer; const name: PAnsiChar; ch_layout: Int64; search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_channel_layout(obj: Pointer; const name: PAnsiChar; ch_layout: Int64; search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_channel_layout';
{$ENDIF API_Dynamic}

(**
 * @note Any old dictionary present is discarded and replaced with a copy of the new one. The
 * caller still owns val is and responsible for freeing it.
 *)

{$IFDEF API_Dynamic}
var av_opt_set_dict_val : function(obj: Pointer; const name: PAnsiChar; const val: PAVDictionary; search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_set_dict_val(obj: Pointer; const name: PAnsiChar; const val: PAVDictionary; search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_set_dict_val';
{$ENDIF API_Dynamic}


(**
 * Set a binary option to an integer list.
 *
 * @param obj    AVClass object to set options on
 * @param name   name of the binary option
 * @param val    pointer to an integer list (must have the correct type with
 *               regard to the contents of the list)
 * @param term   list terminator (usually 0 or -1)
 * @param flags  search flags
 *)
//#define av_opt_set_int_list(obj, name, val, term, flags) \
//    (av_int_list_length(val, term) > INT_MAX / sizeof(*(val)) ? \
//     AVERROR(EINVAL) : \
//     av_opt_set_bin(obj, name, (const uint8_t *)(val), \
//                    av_int_list_length(val, term) * sizeof(*(val)), flags))
function av_opt_set_int_list(obj: Pointer; name: PAnsiChar; list: Pointer; item_size: Integer; term: Int64; flags: Integer): Integer;

(**
 * @}
 *)

(**
 * @defgroup opt_get_funcs Option getting functions
 * @{
 * Those functions get a value of the option with the given name from an object.
 *
 * @param[in] obj a struct whose first element is a pointer to an AVClass.
 * @param[in] name name of the option to get.
 * @param[in] search_flags flags passed to av_opt_find2. I.e. if AV_OPT_SEARCH_CHILDREN
 * is passed here, then the option may be found in a child of obj.
 * @param[out] out_val value of the option will be written here
 * @return >=0 on success, a negative error code otherwise
 *)
(**
 * @note the returned string will be av_malloc()ed and must be av_free()ed by the caller
 *
 * @note if AV_OPT_ALLOW_NULL is set in search_flags in av_opt_get, and the option has
 * AV_OPT_TYPE_STRING or AV_OPT_TYPE_BINARY and is set to NULL, *out_val will be set
 * to NULL instead of an allocated empty string.
 *)

{$IFDEF API_Dynamic}
var av_opt_get : function(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PPByte): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_get(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PPByte)     : Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_get';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_get_int : function(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PInt64): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_get_int(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PInt64)     : Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_get_int';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_get_double : function(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PDouble): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_get_double(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PDouble)    : Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_get_double';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_get_q : function(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PAVRational): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_get_q(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PAVRational): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_get_q';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_get_image_size : function(obj: Pointer; const name: PAnsiChar; search_flags: Integer; w_out, h_out: PInteger): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_get_image_size(obj: Pointer; const name: PAnsiChar; search_flags: Integer; w_out, h_out: PInteger): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_get_image_size';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_get_pixel_fmt : function(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_fmt: PAVPixelFormat): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_get_pixel_fmt(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_fmt: PAVPixelFormat): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_get_pixel_fmt';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_get_sample_fmt : function(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_fmt: PAVPixelFormat): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_get_sample_fmt(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_fmt: PAVPixelFormat): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_get_sample_fmt';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_get_video_rate : function(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PAVRational): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_get_video_rate(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PAVRational): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_get_video_rate';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_opt_get_channel_layout : function(obj: Pointer; const name: PAnsiChar; search_flags: Integer; ch_layout: PInt64): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_get_channel_layout(obj: Pointer; const name: PAnsiChar; search_flags: Integer; ch_layout: PInt64): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_get_channel_layout';
{$ENDIF API_Dynamic}

(**
 * @param[out] out_val The returned dictionary is a copy of the actual value and must
 * be freed with av_dict_free() by the caller
 *)

{$IFDEF API_Dynamic}
var av_opt_get_dict_val : function(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_get_dict_val(obj: Pointer; const name: PAnsiChar; search_flags: Integer; out_val: PPAVDictionary): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_get_dict_val';
{$ENDIF API_Dynamic}

(**
 * @}
 *)
(**
 * Gets a pointer to the requested field in a struct.
 * This function allows accessing a struct even when its fields are moved or
 * renamed since the application making the access has been compiled,
 *
 * @returns a pointer to the field, it can be cast to the correct type and read
 *          or written to.
 *)

{$IFDEF API_Dynamic}
var av_opt_ptr : function(const avclass: Pointer{PAVClass}; obj: Pointer; const name: PAnsiChar): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_opt_ptr(const avclass: Pointer{PAVClass}; obj: Pointer; const name: PAnsiChar): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_ptr';
{$ENDIF API_Dynamic}


(**
 * Free an AVOptionRanges struct and set it to NULL.
 *)

{$IFDEF API_Dynamic}
var av_opt_freep_ranges : procedure(ranges: PPAVOptionRanges); cdecl;
{$ELSE API_Dynamic}
procedure av_opt_freep_ranges(ranges: PPAVOptionRanges); cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_freep_ranges';
{$ENDIF API_Dynamic}


(**
 * Get a list of allowed ranges for the given option.
 *
 * The returned list may depend on other fields in obj like for example profile.
 *
 * @param flags is a bitmask of flags, undefined flags should not be set and should be ignored
 *              AV_OPT_SEARCH_FAKE_OBJ indicates that the obj is a double pointer to a AVClass instead of a full instance
 *              AV_OPT_MULTI_COMPONENT_RANGE indicates that function may return more than one component, @see AVOptionRanges
 *
 * The result must be freed with av_opt_freep_ranges.
 *
 * @return number of compontents returned on success, a negative errro code otherwise
 *)

{$IFDEF API_Dynamic}
var av_opt_query_ranges : function(ranges: PPAVOptionRanges; obj: Pointer; const key: PAnsiChar; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_query_ranges(ranges: PPAVOptionRanges; obj: Pointer; const key: PAnsiChar; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_query_ranges';
{$ENDIF API_Dynamic}


(**
 * Copy options from src object into dest object.
 *
 * Options that require memory allocation (e.g. string or binary) are malloc'ed in dest object.
 * Original memory allocated for such options is freed unless both src and dest options points to the same memory.
 *
 * @param dest Object to copy from
 * @param src  Object to copy into
 * @return 0 on success, negative on error
 *)

{$IFDEF API_Dynamic}
var av_opt_copy : function(dest: Pointer; const src: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_copy(dest: Pointer; const src: Pointer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_copy';
{$ENDIF API_Dynamic}


(**
 * Get a default list of allowed ranges for the given option.
 *
 * This list is constructed without using the AVClass.query_ranges() callback
 * and can be used as fallback from within the callback.
 *
 * @param flags is a bitmask of flags, undefined flags should not be set and should be ignored
 *              AV_OPT_SEARCH_FAKE_OBJ indicates that the obj is a double pointer to a AVClass instead of a full instance
 *              AV_OPT_MULTI_COMPONENT_RANGE indicates that function may return more than one component, @see AVOptionRanges
 *
 * The result must be freed with av_opt_free_ranges.
 *
 * @return number of compontents returned on success, a negative errro code otherwise
 *)

{$IFDEF API_Dynamic}
var av_opt_query_ranges_default : function(ranges: PPAVOptionRanges; obj: Pointer; const key: PAnsiChar; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_query_ranges_default(ranges: PPAVOptionRanges; obj: Pointer; const key: PAnsiChar; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_query_ranges_default';
{$ENDIF API_Dynamic}


(**
 * Check if given option is set to its default value.
 *
 * Options o must belong to the obj. This function must not be called to check child's options state.
 * @see av_opt_is_set_to_default_by_name().
 *
 * @param obj  AVClass object to check option on
 * @param o    option to be checked
 * @return     >0 when option is set to its default,
 *              0 when option is not set its default,
 *             <0 on error
 *)

{$IFDEF API_Dynamic}
var av_opt_is_set_to_default : function(obj: Pointer; const o: PAVOption): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_is_set_to_default(obj: Pointer; const o: PAVOption): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_is_set_to_default';
{$ENDIF API_Dynamic}


(**
 * Check if given option is set to its default value.
 *
 * @param obj          AVClass object to check option on
 * @param name         option name
 * @param search_flags combination of AV_OPT_SEARCH_*
 * @return             >0 when option is set to its default,
 *                     0 when option is not set its default,
 *                     <0 on error
 *)

{$IFDEF API_Dynamic}
var av_opt_is_set_to_default_by_name : function(obj: Pointer; const name: PAnsiChar; search_flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_is_set_to_default_by_name(obj: Pointer; const name: PAnsiChar; search_flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_is_set_to_default_by_name';
{$ENDIF API_Dynamic}



const
  AV_OPT_SERIALIZE_SKIP_DEFAULTS   = $00000001;  ///< Serialize options that are not set to default values only.
  AV_OPT_SERIALIZE_OPT_FLAGS_EXACT = $00000002;  ///< Serialize options that exactly match opt_flags only.

(**
 * Serialize object's options.
 *
 * Create a string containing object's serialized options.
 * Such string may be passed back to av_opt_set_from_string() in order to restore option values.
 * A key/value or pairs separator occurring in the serialized value or
 * name string are escaped through the av_escape() function.
 *
 * @param[in]  obj           AVClass object to serialize
 * @param[in]  opt_flags     serialize options with all the specified flags set (AV_OPT_FLAG)
 * @param[in]  flags         combination of AV_OPT_SERIALIZE_* flags
 * @param[out] buffer        Pointer to buffer that will be allocated with string containg serialized options.
 *                           Buffer must be freed by the caller when is no longer needed.
 * @param[in]  key_val_sep   character used to separate key from value
 * @param[in]  pairs_sep     character used to separate two pairs from each other
 * @return                   >= 0 on success, negative on error
 * @warning Separators cannot be neither '\\' nor '\0'. They also cannot be the same.
 *)

{$IFDEF API_Dynamic}
var av_opt_serialize : function(obj: Pointer; opt_flags, flags: Integer; buffer: PPAnsiChar;
                     const key_val_sep, pairs_sep: AnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_opt_serialize(obj: Pointer; opt_flags, flags: Integer; buffer: PPAnsiChar;
                     const key_val_sep, pairs_sep: AnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_opt_serialize';
{$ENDIF API_Dynamic}

(**
 * @}
 *)


(* ****************************************************** *)
(* import libavutil *)
(* ****************************************************** *)






(**
 * @mainpage
 *
 * @section ffmpeg_intro Introduction
 *
 * This document describes the usage of the different libraries
 * provided by FFmpeg.
 *
 * @li @ref libavc "libavcodec" encoding/decoding library
 * @li @ref lavfi "libavfilter" graph-based frame editing library
 * @li @ref libavf "libavformat" I/O and muxing/demuxing library
 * @li @ref lavd "libavdevice" special devices muxing/demuxing library
 * @li @ref lavu "libavutil" common utility library
 * @li @ref lswr "libswresample" audio resampling, format conversion and mixing
 * @li @ref lpp  "libpostproc" post processing library
 * @li @ref libsws "libswscale" color conversion and scaling library
 *
 * @section ffmpeg_versioning Versioning and compatibility
 *
 * Each of the FFmpeg libraries contains a version.h header, which defines a
 * major, minor and micro version number with the
 * <em>LIBRARYNAME_VERSION_{MAJOR,MINOR,MICRO}</em> macros. The major version
 * number is incremented with backward incompatible changes - e.g. removing
 * parts of the public API, reordering public struct members, etc. The minor
 * version number is incremented for backward compatible API changes or major
 * new features - e.g. adding a new public function or a new decoder. The micro
 * version number is incremented for smaller changes that a calling program
 * might still want to check for - e.g. changing behavior in a previously
 * unspecified situation.
 *
 * FFmpeg guarantees backward API and ABI compatibility for each library as long
 * as its major version number is unchanged. This means that no public symbols
 * will be removed or renamed. Types and names of the public struct members and
 * values of public macros and enums will remain the same (unless they were
 * explicitly declared as not part of the public API). Documented behavior will
 * not change.
 *
 * In other words, any correct program that works with a given FFmpeg snapshot
 * should work just as well without any changes with any later snapshot with the
 * same major versions. This applies to both rebuilding the program against new
 * FFmpeg versions or to replacing the dynamic FFmpeg libraries that a program
 * links against.
 *
 * However, new public symbols may be added and new members may be appended to
 * public structs whose size is not part of public ABI (most public structs in
 * FFmpeg). New macros and enum values may be added. Behavior in undocumented
 * situations may change slightly (and be documented). All those are accompanied
 * by an entry in doc/APIchanges and incrementing either the minor or micro
 * version number.
 *)

(**
 * @defgroup lavu libavutil
 * Common code shared across all FFmpeg libraries.
 *
 * @note
 * libavutil is designed to be modular. In most cases, in order to use the
 * functions provided by one component of libavutil you must explicitly include
 * the specific header containing that feature. If you are only using
 * media-related components, you could simply include libavutil/avutil.h, which
 * brings in most of the "core" components.
 *
 * @{
 *
 * @defgroup lavu_crypto Crypto and Hashing
 *
 * @{
 * @}
 *
 * @defgroup lavu_math Mathematics
 * @{
 *
 * @}
 *
 * @defgroup lavu_string String Manipulation
 *
 * @{
 *
 * @}
 *
 * @defgroup lavu_mem Memory Management
 *
 * @{
 *
 * @}
 *
 * @defgroup lavu_data Data Structures
 * @{
 *
 * @}
 *
 * @defgroup lavu_video Video related
 *
 * @{
 *
 * @}
 *
 * @defgroup lavu_audio Audio related
 *
 * @{
 *
 * @}
 *
 * @defgroup lavu_error Error Codes
 *
 * @{
 *
 * @}
 *
 * @defgroup lavu_log Logging Facility
 *
 * @{
 *
 * @}
 *
 * @defgroup lavu_misc Other
 *
 * @{
 *
 * @defgroup preproc_misc Preprocessor String Macros
 *
 * @{
 *
 * @}
 *
 * @defgroup version_utils Library Version Macros
 *
 * @{
 *
 * @}
 *)


(**
 * @addtogroup lavu_ver
 * @{
 *)

{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
const
  AVMEDIA_TYPE_UNKNOWN=-1;
  AVMEDIA_TYPE_VIDEO=0;
  AVMEDIA_TYPE_AUDIO=1;
  AVMEDIA_TYPE_DATA=2;
  AVMEDIA_TYPE_SUBTITLE=3;
  AVMEDIA_TYPE_ATTACHMENT=4;
  AVMEDIA_TYPE_NB=5;

  AV_PICTURE_TYPE_NONE=0;
  AV_PICTURE_TYPE_I=1;
  AV_PICTURE_TYPE_P=2;
  AV_PICTURE_TYPE_B=3;
  AV_PICTURE_TYPE_S=4;
  AV_PICTURE_TYPE_SI=5;
  AV_PICTURE_TYPE_SP=6;
  AV_PICTURE_TYPE_BI=7;
{$IFEND}

(**
 * Return the LIBAVUTIL_VERSION_INT constant.
 *)

{$IFDEF API_Dynamic}
var avutil_version : function: Cardinal; cdecl;
{$ELSE API_Dynamic}
function avutil_version: Cardinal; cdecl; external AVUTIL_LIBNAME name _PU + 'avutil_version';
{$ENDIF API_Dynamic}


(**
 * Return an informative version string. This usually is the actual release
 * version number or a git commit description. This string has no fixed format
 * and can change any time. It should never be parsed by code.
 *)

{$IFDEF API_Dynamic}
var av_version_info : function: PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_version_info: PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_version_info';
{$ENDIF API_Dynamic}


(**
 * Return the libavutil build-time configuration.
 *)

{$IFDEF API_Dynamic}
var avutil_configuration : function: PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avutil_configuration: PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'avutil_configuration';
{$ENDIF API_Dynamic}


(**
 * Return the libavutil license.
 *)

{$IFDEF API_Dynamic}
var avutil_license : function: PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avutil_license: PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'avutil_license';
{$ENDIF API_Dynamic}


(**
 * @}
 *)

(**
 * @addtogroup lavu_media Media Type
 * @brief Media Type
 *)

type
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVMediaType = Integer;
{$ELSE}
  TAVMediaType = (
    AVMEDIA_TYPE_UNKNOWN = -1,  ///< Usually treated as AVMEDIA_TYPE_DATA
    AVMEDIA_TYPE_VIDEO,
    AVMEDIA_TYPE_AUDIO,
    AVMEDIA_TYPE_DATA,          ///< Opaque data information usually continuous
    AVMEDIA_TYPE_SUBTITLE,
    AVMEDIA_TYPE_ATTACHMENT,    ///< Opaque data information usually sparse
    AVMEDIA_TYPE_NB
  );
{$IFEND}

(**
 * Return a string describing the media_type enum, NULL if media_type
 * is unknown.
 *)

{$IFDEF API_Dynamic}
var av_get_media_type_string : function(media_type: TAVMediaType): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_media_type_string(media_type: TAVMediaType): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_media_type_string';
{$ENDIF API_Dynamic}


(**
 * @defgroup lavu_const Constants
 * @{
 *
 * @defgroup lavu_enc Encoding specific
 *
 * @note those definition should move to avcodec
 * @{
 *)

const
  // AVCodecContext.global_quality;
  FF_LAMBDA_SHIFT = 7;
  FF_LAMBDA_SCALE = (1 shl FF_LAMBDA_SHIFT);
  FF_QP2LAMBDA = 118; ///< factor to convert from H.263 QP to lambda
  FF_LAMBDA_MAX = (256*128-1);

  FF_QUALITY_SCALE = FF_LAMBDA_SCALE; //FIXME maybe remove

(**
 * @}
 * @defgroup lavu_time Timestamp specific
 *
 * FFmpeg internal timebase and timestamp definitions
 *
 * @{
 *)

(**
 * @brief Undefined timestamp value
 *
 * Usually reported by demuxer that work on containers that do not provide
 * either pts or dts.
 *)

  AV_NOPTS_VALUE: Int64    = Int64($8000000000000000);

(**
 * Internal time base represented as integer
 *)

  AV_TIME_BASE_I           = 1000000;
  AV_TIME_BASE: Int64      = AV_TIME_BASE_I;

(**
 * Internal time base represented as fractional value
 *)

  AV_TIME_BASE_Q: TAVRational = (num: 1; den: AV_TIME_BASE_I);
  AV_TIME_BASE_SUB: TAVRational = (num: 1; den: 1000);

(**
 * @}
 * @}
 * @defgroup lavu_picture Image related
 *
 * AVPicture types, pixel formats and basic image planes manipulation.
 *
 * @{
 *)

type
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVPictureType = Integer;
{$ELSE}
  TAVPictureType = (
    AV_PICTURE_TYPE_NONE = 0, ///< Undefined
    AV_PICTURE_TYPE_I,     ///< Intra
    AV_PICTURE_TYPE_P,     ///< Predicted
    AV_PICTURE_TYPE_B,     ///< Bi-dir predicted
    AV_PICTURE_TYPE_S,     ///< S(GMC)-VOP MPEG-4
    AV_PICTURE_TYPE_SI,    ///< Switching Intra
    AV_PICTURE_TYPE_SP,    ///< Switching Predicted
    AV_PICTURE_TYPE_BI     ///< BI type
  );
{$IFEND}

(**
 * Return a single letter to describe the given picture type
 * pict_type.
 *
 * @param[in] pict_type the picture type @return a single character
 * representing the picture type, '?' if pict_type is unknown
 *)

{$IFDEF API_Dynamic}
var av_get_picture_type_char : function(pict_type: TAVPictureType): AnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_picture_type_char(pict_type: TAVPictureType): AnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_picture_type_char';
{$ENDIF API_Dynamic}


(**
 * @}
 *)

(**
 * Return x default pointer in case p is NULL.
 *)
//static inline void *av_x_if_null(const void *p, const void *x)
{
    return (void *)(intptr_t)(p ? p : x);
}

(**
 * Compute the length of an integer list.
 *
 * @param elsize  size in bytes of each list element (only 1, 2, 4 or 8)
 * @param term    list terminator (usually 0 or -1)
 * @param list    pointer to the list
 * @return  length of the list, in elements, not counting the terminator
 *)

{$IFDEF API_Dynamic}
var av_int_list_length_for_size : function(elsize: Cardinal;
                                     const list: Pointer; term: Int64): Cardinal; cdecl;
{$ELSE API_Dynamic}
function av_int_list_length_for_size(elsize: Cardinal;
                                     const list: Pointer; term: Int64): Cardinal; cdecl; external AVUTIL_LIBNAME name _PU + 'av_int_list_length_for_size';
{$ENDIF API_Dynamic}


(**
 * Compute the length of an integer list.
 *
 * @param term  list terminator (usually 0 or -1)
 * @param list  pointer to the list
 * @return  length of the list, in elements, not counting the terminator
 *)
//#define av_int_list_length(list, term) \
//    av_int_list_length_for_size(sizeof(*(list)), list, term)
function av_int_list_length(list: Pointer; item_size: Integer; term: Int64): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}

(**
 * Open a file using a UTF-8 filename.
 * The API of this function matches POSIX fopen(), errors are returned through
 * errno.
 *)

{$IFDEF API_Dynamic}
var av_fopen_utf8 : function(const path, mode: PAnsiChar): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_fopen_utf8(const path, mode: PAnsiChar): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fopen_utf8';
{$ENDIF API_Dynamic}


(**
 * Fill the provided buffer with a string containing a FourCC (four-character
 * code) representation.
 *
 * @param buf    a buffer with size in bytes of at least AV_FOURCC_MAX_STRING_SIZE
 * @param fourcc the fourcc to represent
 * @return the buffer in input
 *)

{$IFDEF API_Dynamic}
var av_fourcc_make_string : function(buf: PAnsiChar; fourcc: Cardinal): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_fourcc_make_string(buf: PAnsiChar; fourcc: Cardinal): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fourcc_make_string';
{$ENDIF API_Dynamic}


(**
 * Return the fractional representation of the internal time base.
 *)
function av_get_time_base_q: TAVRational;  {$IFDEF USE_INLINE}inline;{$ENDIF}

const
  AV_FOURCC_MAX_STRING_SIZE = 32;

//#define av_fourcc2str(fourcc) av_fourcc_make_string((char[AV_FOURCC_MAX_STRING_SIZE]){0}, fourcc)

(**
 * Return x default pointer in case p is NULL.
 *)
function av_x_if_null(const p, x: PAnsiChar): PAnsiChar;  {$IFDEF USE_INLINE}inline;{$ENDIF}


(* ****************************************************** *)
(* import libavutil_bprint *)
(* ****************************************************** *)






(**
 * Define a structure with extra padding to a fixed size
 * This helps ensuring binary compatibility with future versions.
 *)

//#define FF_PAD_STRUCTURE(name, size, ...) \
//struct ff_pad_helper_##name { __VA_ARGS__ }; \
//typedef struct name { \
//    __VA_ARGS__ \
//    char reserved_padding[size - sizeof(struct ff_pad_helper_##name)]; \
//} name;

type
(**
 * Buffer to print data progressively
 *
 * The string buffer grows as necessary and is always 0-terminated.
 * The content of the string is never accessed, and thus is
 * encoding-agnostic and can even hold binary data.
 *
 * Small buffers are kept in the structure itself, and thus require no
 * memory allocation at all (unless the contents of the buffer is needed
 * after the structure goes out of scope). This is almost as lightweight as
 * declaring a local "char buf[512]".
 *
 * The length of the string can go beyond the allocated size: the buffer is
 * then truncated, but the functions still keep account of the actual total
 * length.
 *
 * In other words, buf->len can be greater than buf->size and records the
 * total length of what would have been to the buffer if there had been
 * enough memory.
 *
 * Append operations do not need to be tested for failure: if a memory
 * allocation fails, data stop being appended to the buffer, but the length
 * is still updated. This situation can be tested with
 * av_bprint_is_complete().
 *
 * The size_max field determines several possible behaviours:
 *
 * size_max = -1 (= UINT_MAX) or any large value will let the buffer be
 * reallocated as necessary, with an amortized linear cost.
 *
 * size_max = 0 prevents writing anything to the buffer: only the total
 * length is computed. The write operations can then possibly be repeated in
 * a buffer with exactly the necessary size
 * (using size_init = size_max = len + 1).
 *
 * size_max = 1 is automatically replaced by the exact size available in the
 * structure itself, thus ensuring no dynamic memory allocation. The
 * internal buffer is large enough to hold a reasonable paragraph of text,
 * such as the current paragraph.
 *)
  ff_pad_helper_AVBPrint = record
    str: PAnsiChar;     (**< string so far *)
    len: Cardinal;      (**< length so far *)
    size: Cardinal;     (**< allocated memory *)
    size_max: Cardinal; (**< maximum allocated memory *)
    reserved_internal_buffer: array[0..0] of AnsiChar;
  end;
  PAVBPrint = ^TAVBPrint;
  TAVBPrint = record
    str: PAnsiChar;     (**< string so far *)
    len: Cardinal;      (**< length so far *)
    size: Cardinal;     (**< allocated memory *)
    size_max: Cardinal; (**< maximum allocated memory *)
    reserved_internal_buffer: array[0..0] of AnsiChar;
    reserved_padding: array[0..1024 - SizeOf(ff_pad_helper_AVBPrint) - 1] of AnsiChar;
  end;

(**
 * Convenience macros for special values for av_bprint_init() size_max
 * parameter.
 *)
const
  AV_BPRINT_SIZE_UNLIMITED  = Cardinal(-1);
  AV_BPRINT_SIZE_AUTOMATIC  = 1;
  AV_BPRINT_SIZE_COUNT_ONLY = 0;

(**
 * Init a print buffer.
 *
 * @param buf        buffer to init
 * @param size_init  initial size (including the final 0)
 * @param size_max   maximum size;
 *                   0 means do not write anything, just count the length;
 *                   1 is replaced by the maximum value for automatic storage;
 *                   any large value means that the internal buffer will be
 *                   reallocated as needed up to that limit; -1 is converted to
 *                   UINT_MAX, the largest limit possible.
 *                   Check also AV_BPRINT_SIZE_* macros.
 *)

{$IFDEF API_Dynamic}
var av_bprint_init : procedure(buf: PAVBPrint; size_init, size_max: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_bprint_init(buf: PAVBPrint; size_init, size_max: Cardinal); cdecl; external AVUTIL_LIBNAME name _PU + 'av_bprint_init';
{$ENDIF API_Dynamic}


(**
 * Init a print buffer using a pre-existing buffer.
 *
 * The buffer will not be reallocated.
 *
 * @param buf     buffer structure to init
 * @param buffer  byte buffer to use for the string data
 * @param size    size of buffer
 *)

{$IFDEF API_Dynamic}
var av_bprint_init_for_buffer : procedure(buf: PAVBPrint; buffer: PAnsiChar; size: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_bprint_init_for_buffer(buf: PAVBPrint; buffer: PAnsiChar; size: Cardinal); cdecl; external AVUTIL_LIBNAME name _PU + 'av_bprint_init_for_buffer';
{$ENDIF API_Dynamic}


(**
 * Append a formatted string to a print buffer.
 *)

{$IFDEF API_Dynamic}
var av_bprintf : procedure(buf: PAVBPrint; const fmt: PAnsiChar); cdecl;
{$ELSE API_Dynamic}
procedure av_bprintf(buf: PAVBPrint; const fmt: PAnsiChar); cdecl varargs; external AVUTIL_LIBNAME name _PU + 'av_bprintf';
{$ENDIF API_Dynamic}


(**
 * Append a formatted string to a print buffer.
 *)

{$IFDEF API_Dynamic}
var av_vbprintf : procedure(buf: PAVBPrint; const fmt: PAnsiChar; vl_arg: Pointer{va_list}); cdecl;
{$ELSE API_Dynamic}
procedure av_vbprintf(buf: PAVBPrint; const fmt: PAnsiChar; vl_arg: Pointer{va_list}); cdecl; external AVUTIL_LIBNAME name _PU + 'av_vbprintf';
{$ENDIF API_Dynamic}


(**
 * Append char c n times to a print buffer.
 *)

{$IFDEF API_Dynamic}
var av_bprint_chars : procedure(buf: PAVBPrint; c: AnsiChar; n: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_bprint_chars(buf: PAVBPrint; c: AnsiChar; n: Cardinal); cdecl; external AVUTIL_LIBNAME name _PU + 'av_bprint_chars';
{$ENDIF API_Dynamic}


(**
 * Append data to a print buffer.
 *
 * param buf  bprint buffer to use
 * param data pointer to data
 * param size size of data
 *)

{$IFDEF API_Dynamic}
var av_bprint_append_data : procedure(buf: PAVBPrint; const data: PAnsiChar; size: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_bprint_append_data(buf: PAVBPrint; const data: PAnsiChar; size: Cardinal); cdecl; external AVUTIL_LIBNAME name _PU + 'av_bprint_append_data';
{$ENDIF API_Dynamic}


//struct tm;
(**
 * Append a formatted date and time to a print buffer.
 *
 * param buf  bprint buffer to use
 * param fmt  date and time format string, see strftime()
 * param tm   broken-down time structure to translate
 *
 * @note due to poor design of the standard strftime function, it may
 * produce poor results if the format string expands to a very long text and
 * the bprint buffer is near the limit stated by the size_max option.
 *)

{$IFDEF API_Dynamic}
var av_bprint_strftime : procedure(buf: PAVBPrint; const fmt: PAnsiChar; const tm: Pointer{struct tm *tm}); cdecl;
{$ELSE API_Dynamic}
procedure av_bprint_strftime(buf: PAVBPrint; const fmt: PAnsiChar; const tm: Pointer{struct tm *tm}); cdecl; external AVUTIL_LIBNAME name _PU + 'av_bprint_strftime';
{$ENDIF API_Dynamic}


(**
 * Allocate bytes in the buffer for external use.
 *
 * @param[in]  buf          buffer structure
 * @param[in]  size         required size
 * @param[out] mem          pointer to the memory area
 * @param[out] actual_size  size of the memory area after allocation;
 *                          can be larger or smaller than size
 *)

{$IFDEF API_Dynamic}
var av_bprint_get_buffer : procedure(buf: PAVBPrint; size: Cardinal;
                          mem: PPByte{unsigned char **mem}; actual_size: PCardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_bprint_get_buffer(buf: PAVBPrint; size: Cardinal;
                          mem: PPByte{unsigned char **mem}; actual_size: PCardinal); cdecl; external AVUTIL_LIBNAME name _PU + 'av_bprint_get_buffer';
{$ENDIF API_Dynamic}


(**
 * Reset the string to "" but keep internal allocated data.
 *)

{$IFDEF API_Dynamic}
var av_bprint_clear : procedure(buf: PAVBPrint); cdecl;
{$ELSE API_Dynamic}
procedure av_bprint_clear(buf: PAVBPrint); cdecl; external AVUTIL_LIBNAME name _PU + 'av_bprint_clear';
{$ENDIF API_Dynamic}


(**
 * Test if the print buffer is complete (not truncated).
 *
 * It may have been truncated due to a memory allocation failure
 * or the size_max limit (compare size and size_max if necessary).
 *)
//static inline int av_bprint_is_complete(const AVBPrint *buf)
{
    return buf->len < buf->size;
}

(**
 * Finalize a print buffer.
 *
 * The print buffer can no longer be used afterwards,
 * but the len and size fields are still valid.
 *
 * @arg[out] ret_str  if not NULL, used to return a permanent copy of the
 *                    buffer contents, or NULL if memory allocation fails;
 *                    if NULL, the buffer is discarded and freed
 * @return  0 for success or error code (probably AVERROR(ENOMEM))
 *)

{$IFDEF API_Dynamic}
var av_bprint_finalize : function(buf: PAVBPrint; ret_str: PPAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_bprint_finalize(buf: PAVBPrint; ret_str: PPAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_bprint_finalize';
{$ENDIF API_Dynamic}


(**
 * Escape the content in src and append it to dstbuf.
 *
 * @param dstbuf        already inited destination bprint buffer
 * @param src           string containing the text to escape
 * @param special_chars string containing the special characters which
 *                      need to be escaped, can be NULL
 * @param mode          escape mode to employ, see AV_ESCAPE_MODE_* macros.
 *                      Any unknown value for mode will be considered equivalent to
 *                      AV_ESCAPE_MODE_BACKSLASH, but this behaviour can change without
 *                      notice.
 * @param flags         flags which control how to escape, see AV_ESCAPE_FLAG_* macros
 *)

{$IFDEF API_Dynamic}
var av_bprint_escape : procedure(dstbuf: PAVBPrint; const src, special_chars: PAnsiChar;
                            mode: TAVEscapeMode; flags: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_bprint_escape(dstbuf: PAVBPrint; const src, special_chars: PAnsiChar;
                            mode: TAVEscapeMode; flags: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_bprint_escape';
{$ENDIF API_Dynamic}


function av_bprint_is_complete(const buf: PAVBPrint): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}


(* ****************************************************** *)
(* import libavutil_log *)
(* ****************************************************** *)






type
  TAVClassCategory = (
    AV_CLASS_CATEGORY_NA = 0,
    AV_CLASS_CATEGORY_INPUT,
    AV_CLASS_CATEGORY_OUTPUT,
    AV_CLASS_CATEGORY_MUXER,
    AV_CLASS_CATEGORY_DEMUXER,
    AV_CLASS_CATEGORY_ENCODER,
    AV_CLASS_CATEGORY_DECODER,
    AV_CLASS_CATEGORY_FILTER,
    AV_CLASS_CATEGORY_BITSTREAM_FILTER,
    AV_CLASS_CATEGORY_SWSCALER,
    AV_CLASS_CATEGORY_SWRESAMPLER,
    AV_CLASS_CATEGORY_DEVICE_VIDEO_OUTPUT = 40,
    AV_CLASS_CATEGORY_DEVICE_VIDEO_INPUT,
    AV_CLASS_CATEGORY_DEVICE_AUDIO_OUTPUT,
    AV_CLASS_CATEGORY_DEVICE_AUDIO_INPUT,
    AV_CLASS_CATEGORY_DEVICE_OUTPUT,
    AV_CLASS_CATEGORY_DEVICE_INPUT,
    AV_CLASS_CATEGORY_NB  ///< not part of ABI/API
  );

{
#define AV_IS_INPUT_DEVICE(category) \
    (((category) == AV_CLASS_CATEGORY_DEVICE_VIDEO_INPUT) || \
     ((category) == AV_CLASS_CATEGORY_DEVICE_AUDIO_INPUT) || \
     ((category) == AV_CLASS_CATEGORY_DEVICE_INPUT))

#define AV_IS_OUTPUT_DEVICE(category) \
    (((category) == AV_CLASS_CATEGORY_DEVICE_VIDEO_OUTPUT) || \
     ((category) == AV_CLASS_CATEGORY_DEVICE_AUDIO_OUTPUT) || \
     ((category) == AV_CLASS_CATEGORY_DEVICE_OUTPUT))
}

(*
  PPAVOptionRanges = ^PAVOptionRanges;
  PAVOptionRanges = ^TAVOptionRanges;
  TAVOptionRanges = record
    // need {$ALIGN 8}
    // defined in libavutil/opt.h
  end;
*)

(**
 * Describe the class of an AVClass context structure. That is an
 * arbitrary struct of which the first field is a pointer to an
 * AVClass struct (e.g. AVCodecContext, AVFormatContext etc.).
 *)
  PPPAVClass = ^PPAVClass;
  PPAVClass = ^PAVClass;
  PAVClass = ^TAVClass;
  TAVClass = record
    (**
     * The name of the class; usually it is the same name as the
     * context structure type to which the AVClass is associated.
     *)
    class_name: PAnsiChar;

    (**
     * A pointer to a function which returns the name of a context
     * instance ctx associated with the class.
     *)
    item_name: function(ctx: Pointer): PAnsiChar; cdecl;

    (**
     * a pointer to the first option specified in the class if any or NULL
     *
     * @see av_set_default_options()
     *)
    option: PAVOption;

    (**
     * LIBAVUTIL_VERSION with which this structure was created.
     * This is used to allow fields to be added without requiring major
     * version bumps everywhere.
     *)
    version: Integer;

    (**
     * Offset in the structure where log_level_offset is stored.
     * 0 means there is no such variable
     *)
    log_level_offset_offset: Integer;

    (**
     * Offset in the structure where a pointer to the parent context for
     * logging is stored. For example a decoder could pass its AVCodecContext
     * to eval as such a parent context, which an av_log() implementation
     * could then leverage to display the parent context.
     * The offset can be NULL.
     *)
    parent_log_context_offset: Integer;

    (**
     * Return next AVOptions-enabled child or NULL
     *)
    child_next: function(obj, prev: Pointer): Pointer; cdecl;

    (**
     * Return an AVClass corresponding to the next potential
     * AVOptions-enabled child.
     *
     * The difference between child_next and this is that
     * child_next iterates over _already existing_ objects, while
     * child_class_next iterates over _all possible_ children.
     *)
    child_class_next: function(const prev: PAVClass): PAVClass; cdecl;

    (**
     * Category used for visualization (like color)
     * This is only set if the category is equal for all objects using this class.
     * available since version (51 << 16 | 56 << 8 | 100)
     *)
    category: TAVClassCategory;

    (**
     * Callback to return the category.
     * available since version (51 << 16 | 59 << 8 | 100)
     *)
    get_category: function(ctx: Pointer): TAVClassCategory; cdecl;

    (**
     * Callback to return the supported/allowed ranges.
     * available since version (52.12)
     *)
    query_ranges: function(ranges: PPAVOptionRanges; obj: Pointer; const key: PAnsiChar; flags: Integer): Integer; cdecl;
  end;

(**
 * @addtogroup lavu_log
 *
 * @{
 *
 * @defgroup lavu_log_constants Logging Constants
 *
 * @{
 *)

(**
 * Print no output.
 *)
const
  AV_LOG_QUIET    = -8;

(**
 * Something went really wrong and we will crash now.
 *)
  AV_LOG_PANIC    = 0;

(**
 * Something went wrong and recovery is not possible.
 * For example, no header was found for a format which depends
 * on headers or an illegal combination of parameters is used.
 *)
  AV_LOG_FATAL    = 8;

(**
 * Something went wrong and cannot losslessly be recovered.
 * However, not all future data is affected.
 *)
  AV_LOG_ERROR    = 16;

(**
 * Something somehow does not look correct. This may or may not
 * lead to problems. An example would be the use of '-vstrict -2'.
 *)
  AV_LOG_WARNING  = 24;

(**
 * Standard information.
 *)
  AV_LOG_INFO     = 32;

(**
 * Detailed information.
 *)
  AV_LOG_VERBOSE  = 40;

(**
 * Stuff which is only useful for libav* developers.
 *)
  AV_LOG_DEBUG    = 48;

(**
 * Extremely verbose debugging, useful for libav* development.
 *)
  AV_LOG_TRACE    = 56;

  AV_LOG_MAX_OFFSET = (AV_LOG_TRACE - AV_LOG_QUIET);

(**
 * @}
 *)

(**
 * Sets additional colors for extended debugging sessions.
 * @code
   av_log(ctx, AV_LOG_DEBUG|AV_LOG_C(134), "Message in purple\n");
   @endcode
 * Requires 256color terminal support. Uses outside debugging is not
 * recommended.
 *)
//#define AV_LOG_C(x) ((x) << 8)
function AV_LOG_C(x: Integer): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}

(**
 * Send the specified message to the log if the level is less than or equal
 * to the current av_log_level. By default, all logging messages are sent to
 * stderr. This behavior can be altered by setting a different logging callback
 * function.
 * @see av_log_set_callback
 *
 * @param avcl A pointer to an arbitrary struct of which the first field is a
 *        pointer to an AVClass struct or NULL if general log.
 * @param level The importance level of the message expressed using a @ref
 *        lavu_log_constants "Logging Constant".
 * @param fmt The format string (printf-compatible) that specifies how
 *        subsequent arguments are converted to output.
 *)

{$IFDEF API_Dynamic}
var av_log : procedure(avcl: Pointer; level: Integer; const fmt: PAnsiChar); cdecl;
{$ELSE API_Dynamic}
procedure av_log(avcl: Pointer; level: Integer; const fmt: PAnsiChar); cdecl varargs; external AVUTIL_LIBNAME name _PU + 'av_log';
{$ENDIF API_Dynamic}



(**
 * Send the specified message to the log if the level is less than or equal
 * to the current av_log_level. By default, all logging messages are sent to
 * stderr. This behavior can be altered by setting a different logging callback
 * function.
 * @see av_log_set_callback
 *
 * @param avcl A pointer to an arbitrary struct of which the first field is a
 *        pointer to an AVClass struct.
 * @param level The importance level of the message expressed using a @ref
 *        lavu_log_constants "Logging Constant".
 * @param fmt The format string (printf-compatible) that specifies how
 *        subsequent arguments are converted to output.
 * @param vl The arguments referenced by the format string.
 *)
type
  Tav_vlogCall = procedure(avcl: Pointer; level: Integer; const fmt: PAnsiChar; vl: PAnsiChar); cdecl;

{$IFDEF API_Dynamic}
var av_vlog : procedure(avcl: Pointer; level: Integer; const fmt: PAnsiChar; vl: PAnsiChar); cdecl;
{$ELSE API_Dynamic}
procedure av_vlog(avcl: Pointer; level: Integer; const fmt: PAnsiChar; vl: PAnsiChar); cdecl; external AVUTIL_LIBNAME name _PU + 'av_vlog';
{$ENDIF API_Dynamic}


(**
 * Get the current log level
 *
 * @see lavu_log_constants
 *
 * @return Current log level
 *)

{$IFDEF API_Dynamic}
var av_log_get_level : function: Integer; cdecl;
{$ELSE API_Dynamic}
function av_log_get_level: Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_log_get_level';
{$ENDIF API_Dynamic}


(**
 * Set the log level
 *
 * @see lavu_log_constants
 *
 * @param level Logging level
 *)

{$IFDEF API_Dynamic}
var av_log_set_level : procedure(level: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_log_set_level(level: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_log_set_level';
{$ENDIF API_Dynamic}


(**
 * Set the logging callback
 *
 * @note The callback must be thread safe, even if the application does not use
 *       threads itself as some codecs are multithreaded.
 *
 * @see av_log_default_callback
 *
 * @param callback A logging function with a compatible signature.
 *)

{$IFDEF API_Dynamic}
var av_log_set_callback : procedure(callback: Tav_vlogCall); cdecl;
{$ELSE API_Dynamic}
procedure av_log_set_callback(callback: Tav_vlogCall); cdecl; external AVUTIL_LIBNAME name _PU + 'av_log_set_callback';
{$ENDIF API_Dynamic}


(**
 * Default logging callback
 *
 * It prints the message to stderr, optionally colorizing it.
 *
 * @param avcl A pointer to an arbitrary struct of which the first field is a
 *        pointer to an AVClass struct.
 * @param level The importance level of the message expressed using a @ref
 *        lavu_log_constants "Logging Constant".
 * @param fmt The format string (printf-compatible) that specifies how
 *        subsequent arguments are converted to output.
 * @param vl The arguments referenced by the format string.
 *)

{$IFDEF API_Dynamic}
var av_log_default_callback : procedure(avcl: Pointer; level: Integer; const fmt: PAnsiChar;
                             vl: PAnsiChar); cdecl;
{$ELSE API_Dynamic}
procedure av_log_default_callback(avcl: Pointer; level: Integer; const fmt: PAnsiChar;
                             vl: PAnsiChar); cdecl; external AVUTIL_LIBNAME name _PU + 'av_log_default_callback';
{$ENDIF API_Dynamic}


(**
 * Return the context name
 *
 * @param  ctx The AVClass context
 *
 * @return The AVClass class_name
 *)

{$IFDEF API_Dynamic}
var av_default_item_name : function(ctx: Pointer): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_default_item_name(ctx: Pointer): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_default_item_name';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_default_get_category : function(ptr: Pointer): TAVClassCategory; cdecl;
{$ELSE API_Dynamic}
function av_default_get_category(ptr: Pointer): TAVClassCategory; cdecl; external AVUTIL_LIBNAME name _PU + 'av_default_get_category';
{$ENDIF API_Dynamic}


(**
 * Format a line of log the same way as the default callback.
 * @param line          buffer to receive the formatted line
 * @param line_size     size of the buffer
 * @param print_prefix  used to store whether the prefix must be printed;
 *                      must point to a persistent integer initially set to 1
 *)

{$IFDEF API_Dynamic}
var av_log_format_line : procedure(ptr: Pointer; level: Integer; const fmt: PAnsiChar; vl: Pointer;{va_list}
                        line: PAnsiChar; line_size: Integer; print_prefix: PInteger); cdecl;
{$ELSE API_Dynamic}
procedure av_log_format_line(ptr: Pointer; level: Integer; const fmt: PAnsiChar; vl: Pointer;{va_list}
                        line: PAnsiChar; line_size: Integer; print_prefix: PInteger); cdecl; external AVUTIL_LIBNAME name _PU + 'av_log_format_line';
{$ENDIF API_Dynamic}


(**
 * Format a line of log the same way as the default callback.
 * @param line          buffer to receive the formatted line;
 *                      may be NULL if line_size is 0
 * @param line_size     size of the buffer; at most line_size-1 characters will
 *                      be written to the buffer, plus one null terminator
 * @param print_prefix  used to store whether the prefix must be printed;
 *                      must point to a persistent integer initially set to 1
 * @return Returns a negative value if an error occurred, otherwise returns
 *         the number of characters that would have been written for a
 *         sufficiently large buffer, not including the terminating null
 *         character. If the return value is not less than line_size, it means
 *         that the log message was truncated to fit the buffer.
 *)

{$IFDEF API_Dynamic}
var av_log_format_line2 : function(ptr: Pointer; level: Integer; const fmt: PAnsiChar; vl: Pointer;{va_list}
                        line: PAnsiChar; line_size: Integer; print_prefix: PInteger): Integer; cdecl;
{$ELSE API_Dynamic}
function av_log_format_line2(ptr: Pointer; level: Integer; const fmt: PAnsiChar; vl: Pointer;{va_list}
                        line: PAnsiChar; line_size: Integer; print_prefix: PInteger): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_log_format_line2';
{$ENDIF API_Dynamic}


{$IFDEF FF_API_DLOG}
(**
 * av_dlog macros
 * @deprecated unused
 * Useful to print debug messages that shouldn't get compiled in normally.
 *)

//#ifdef DEBUG
//#    define av_dlog(pctx, ...) av_log(pctx, AV_LOG_DEBUG, __VA_ARGS__)
//#else
//#    define av_dlog(pctx, ...) do { if (0) av_log(pctx, AV_LOG_DEBUG, __VA_ARGS__); } while (0)
//#endif
{$ENDIF} (* FF_API_DLOG *)


{$IFDEF API_Dynamic}
var av_log_set_flags : procedure(arg: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_log_set_flags(arg: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_log_set_flags';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_log_get_flags : function: Integer; cdecl;
{$ELSE API_Dynamic}
function av_log_get_flags: Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_log_get_flags';
{$ENDIF API_Dynamic}


const
(**
 * Skip repeated messages, this requires the user app to use av_log() instead of
 * (f)printf as the 2 would otherwise interfere and lead to
 * "Last message repeated x times" messages below (f)printf messages with some
 * bad luck.
 * Also to receive the last, "last repeated" line if any, the user app must
 * call av_log(NULL, AV_LOG_QUIET, "%s", ""); at the end
 *)
  AV_LOG_SKIP_REPEATED = 1;


(**
 * Include the log severity in messages originating from codecs.
 *
 * Results in messages such as:
 * [rawvideo @ 0xDEADBEEF] [error] encode did not produce valid pts
 *)
  AV_LOG_PRINT_LEVEL = 2;

(**
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_frame *)
(* ****************************************************** *)






const
  AV_NUM_DATA_POINTERS = 8;
  AV_FRAME_FLAG_CORRUPT     =  (1 shl 0);
  AV_FRAME_FLAG_DISCARD     =  (1 shl 2);
  FF_DECODE_ERROR_INVALID_BITSTREAM = 1;
  FF_DECODE_ERROR_MISSING_REFERENCE = 2;

type
(**
 * @defgroup lavu_frame AVFrame
 * @ingroup lavu_data
 *
 * @{
 * AVFrame is an abstraction for reference-counted raw multimedia data.
 *)

  TAVFrameSideDataType = (
    (**
     * The data is the AVPanScan struct defined in libavcodec.
     *)
    AV_FRAME_DATA_PANSCAN,
    (**
     * ATSC A53 Part 4 Closed Captions.
     * A53 CC bitstream is stored as uint8_t in AVFrameSideData.data.
     * The number of bytes of CC data is AVFrameSideData.size.
     *)
    AV_FRAME_DATA_A53_CC,
    (**
     * Stereoscopic 3d metadata.
     * The data is the AVStereo3D struct defined in libavutil/stereo3d.h.
     *)
    AV_FRAME_DATA_STEREO3D,
    (**
     * The data is the AVMatrixEncoding enum defined in libavutil/channel_layout.h.
     *)
    AV_FRAME_DATA_MATRIXENCODING,
    (**
     * Metadata relevant to a downmix procedure.
     * The data is the AVDownmixInfo struct defined in libavutil/downmix_info.h.
     *)
    AV_FRAME_DATA_DOWNMIX_INFO,
    (**
     * ReplayGain information in the form of the AVReplayGain struct.
     *)
    AV_FRAME_DATA_REPLAYGAIN,
    (**
     * This side data contains a 3x3 transformation matrix describing an affine
     * transformation that needs to be applied to the frame for correct
     * presentation.
     *
     * See libavutil/display.h for a detailed description of the data.
     *)
    AV_FRAME_DATA_DISPLAYMATRIX,
    (**
     * Active Format Description data consisting of a single byte as specified
     * in ETSI TS 101 154 using AVActiveFormatDescription enum.
     *)
    AV_FRAME_DATA_AFD,
    (**
     * Motion vectors exported by some codecs (on demand through the export_mvs
     * flag set in the libavcodec AVCodecContext flags2 option).
     * The data is the AVMotionVector struct defined in
     * libavutil/motion_vector.h.
     *)
    AV_FRAME_DATA_MOTION_VECTORS,
    (**
     * Recommmends skipping the specified number of samples. This is exported
     * only if the "skip_manual" AVOption is set in libavcodec.
     * This has the same format as AV_PKT_DATA_SKIP_SAMPLES.
     * @code
     * u32le number of samples to skip from start of this packet
     * u32le number of samples to skip from end of this packet
     * u8    reason for start skip
     * u8    reason for end   skip (0=padding silence, 1=convergence)
     * @endcode
     *)
    AV_FRAME_DATA_SKIP_SAMPLES,
    (**
     * This side data must be associated with an audio frame and corresponds to
     * enum AVAudioServiceType defined in avcodec.h.
     *)
    AV_FRAME_DATA_AUDIO_SERVICE_TYPE,
    (**
     * Mastering display metadata associated with a video frame. The payload is
     * an AVMasteringDisplayMetadata type and contains information about the
     * mastering display color volume.
     *)
    AV_FRAME_DATA_MASTERING_DISPLAY_METADATA,
    (**
     * The GOP timecode in 25 bit timecode format. Data format is 64-bit integer.
     * This is set on the first frame of a GOP that has a temporal reference of 0.
     *)
    AV_FRAME_DATA_GOP_TIMECODE,

    (**
     * The data represents the AVSphericalMapping structure defined in
     * libavutil/spherical.h.
     *)
    AV_FRAME_DATA_SPHERICAL,

    (**
     * Content light level (based on CTA-861.3). This payload contains data in
     * the form of the AVContentLightMetadata struct.
     *)
    AV_FRAME_DATA_CONTENT_LIGHT_LEVEL,

    (**
     * The data contains an ICC profile as an opaque octet buffer following the
     * format described by ISO 15076-1 with an optional name defined in the
     * metadata key entry "name".
     *)
    AV_FRAME_DATA_ICC_PROFILE
  );

  TAVActiveFormatDescription = (
    AV_AFD_SAME         = 8,
    AV_AFD_4_3          = 9,
    AV_AFD_16_9         = 10,
    AV_AFD_14_9         = 11,
    AV_AFD_4_3_SP_14_9  = 13,
    AV_AFD_16_9_SP_14_9 = 14,
    AV_AFD_SP_4_3       = 15
  );

(**
 * Structure to hold side data for an AVFrame.
 *
 * sizeof(AVFrameSideData) is not a part of the public ABI, so new fields may be added
 * to the end with a minor bump.
 *)
  PPAVFrameSideData = ^PAVFrameSideData;
  PAVFrameSideData = ^TAVFrameSideData;
  TAVFrameSideData = record
    type_: TAVFrameSideDataType;
    data: PByte;
    size: Integer;
    metadata: PAVDictionary;
    buf: PAVBufferRef;
  end;

(**
 * This structure describes decoded (raw) audio or video data.
 *
 * AVFrame must be allocated using av_frame_alloc(). Note that this only
 * allocates the AVFrame itself, the buffers for the data must be managed
 * through other means (see below).
 * AVFrame must be freed with av_frame_free().
 *
 * AVFrame is typically allocated once and then reused multiple times to hold
 * different data (e.g. a single AVFrame to hold frames received from a
 * decoder). In such a case, av_frame_unref() will free any references held by
 * the frame and reset it to its original clean state before it
 * is reused again.
 *
 * The data described by an AVFrame is usually reference counted through the
 * AVBuffer API. The underlying buffer references are stored in AVFrame.buf /
 * AVFrame.extended_buf. An AVFrame is considered to be reference counted if at
 * least one reference is set, i.e. if AVFrame.buf[0] != NULL. In such a case,
 * every single data plane must be contained in one of the buffers in
 * AVFrame.buf or AVFrame.extended_buf.
 * There may be a single buffer for all the data, or one separate buffer for
 * each plane, or anything in between.
 *
 * sizeof(AVFrame) is not a part of the public ABI, so new fields may be added
 * to the end with a minor bump.
 *
 * Fields can be accessed through AVOptions, the name string used, matches the
 * C structure field name for fields accessible through AVOptions. The AVClass
 * for AVFrame can be obtained from avcodec_get_frame_class()
 *)
  PPAVFrame = ^PAVFrame;
  PAVFrame = ^TAVFrame;
  TAVFrame = record
//#define AV_NUM_DATA_POINTERS 8
    (**
     * pointer to the picture/channel planes.
     * This might be different from the first allocated byte
     *
     * Some decoders access areas outside 0,0 - width,height, please
     * see avcodec_align_dimensions2(). Some filters and swscale can read
     * up to 16 bytes beyond the planes, if these filters are to be used,
     * then 16 extra bytes must be allocated.
     *
     * NOTE: Except for hwaccel formats, pointers not needed by the format
     * MUST be set to NULL.
     *)
    data: array[0..AV_NUM_DATA_POINTERS-1] of PByte;

    (**
     * For video, size in bytes of each picture line.
     * For audio, size in bytes of each plane.
     *
     * For audio, only linesize[0] may be set. For planar audio, each channel
     * plane must be the same size.
     *
     * For video the linesizes should be multiples of the CPUs alignment
     * preference, this is 16 or 32 for modern desktop CPUs.
     * Some code requires such alignment other code can be slower without
     * correct alignment, for yet other it makes no difference.
     *
     * @note The linesize may be larger than the size of usable data -- there
     * may be extra padding present for performance reasons.
     *)
    linesize: array[0..AV_NUM_DATA_POINTERS-1] of Integer;

    (**
     * pointers to the data planes/channels.
     *
     * For video, this should simply point to data[].
     *
     * For planar audio, each channel has a separate data pointer, and
     * linesize[0] contains the size of each channel buffer.
     * For packed audio, there is just one data pointer, and linesize[0]
     * contains the total size of the buffer for all channels.
     *
     * Note: Both data and extended_data should always be set in a valid frame,
     * but for planar audio with more channels that can fit in data,
     * extended_data must be used in order to access all channels.
     *)
    extended_data: PPByte;

    (**
     * @name Video dimensions
     * Video frames only. The coded dimensions (in pixels) of the video frame,
     * i.e. the size of the rectangle that contains some well-defined values.
     *
     * @note The part of the frame intended for display/presentation is further
     * restricted by the @ref cropping "Cropping rectangle".
     * @{
     *)
    width, height: Integer;
    (**
     * @}
     *)

    (**
     * number of audio samples (per channel) described by this frame
     *)
    nb_samples: Integer;

    (**
     * format of the frame, -1 if unknown or unset
     * Values correspond to enum AVPixelFormat for video frames,
     * enum AVSampleFormat for audio)
     *)
    format: Integer;

    (**
     * 1 -> keyframe, 0-> not
     *)
    key_frame: Integer;

    (**
     * Picture type of the frame.
     *)
    pict_type: TAVPictureType;

    (**
     * Sample aspect ratio for the video frame, 0/1 if unknown/unspecified.
     *)
    sample_aspect_ratio: TAVRational;

    (**
     * Presentation timestamp in time_base units (time when frame should be shown to user).
     *)
    pts: Int64;

{$IFDEF FF_API_PKT_PTS}
    (**
     * PTS copied from the AVPacket that was decoded to produce this frame.
     * @deprecated use the pts field instead
     *)
    pkt_pts: Int64;
{$ENDIF}

    (**
     * DTS copied from the AVPacket that triggered returning this frame. (if frame threading isn't used)
     * This is also the Presentation time of this AVFrame calculated from
     * only AVPacket.dts values without pts values.
     *)
    pkt_dts: Int64;

    (**
     * picture number in bitstream order
     *)
    coded_picture_number: Integer;
    (**
     * picture number in display order
     *)
    display_picture_number: Integer;

    (**
     * quality (between 1 (good) and FF_LAMBDA_MAX (bad))
     *)
    quality: Integer;

    (**
     * for some private data of the user
     *)
    opaque: Pointer;

{$IFDEF FF_API_ERROR_FRAME}
    (**
     * @deprecated unused
     *)
    error: array[0..AV_NUM_DATA_POINTERS-1] of Int64;
{$ENDIF}

    (**
     * When decoding, this signals how much the picture must be delayed.
     * extra_delay = repeat_pict / (2*fps)
     *)
    repeat_pict: Integer;

    (**
     * The content of the picture is interlaced.
     *)
    interlaced_frame: Integer;

    (**
     * If the content is interlaced, is top field displayed first.
     *)
    top_field_first: Integer;

    (**
     * Tell user application that palette has changed from previous frame.
     *)
    palette_has_changed: Integer;

    (**
     * reordered opaque 64 bits (generally an integer or a double precision float
     * PTS but can be anything).
     * The user sets AVCodecContext.reordered_opaque to represent the input at
     * that time,
     * the decoder reorders values as needed and sets AVFrame.reordered_opaque
     * to exactly one of the values provided by the user through AVCodecContext.reordered_opaque
     * @deprecated in favor of pkt_pts
     *)
    reordered_opaque: Int64;

    (**
     * Sample rate of the audio data.
     *)
    sample_rate: Integer;

    (**
     * Channel layout of the audio data.
     *)
    channel_layout: Int64;

    (**
     * AVBuffer references backing the data for this frame. If all elements of
     * this array are NULL, then this frame is not reference counted. This array
     * must be filled contiguously -- if buf[i] is non-NULL then buf[j] must
     * also be non-NULL for all j < i.
     *
     * There may be at most one AVBuffer per data plane, so for video this array
     * always contains all the references. For planar audio with more than
     * AV_NUM_DATA_POINTERS channels, there may be more buffers than can fit in
     * this array. Then the extra AVBufferRef pointers are stored in the
     * extended_buf array.
     *)
    buf: array[0..AV_NUM_DATA_POINTERS - 1] of PAVBufferRef;

    (**
     * For planar audio which requires more than AV_NUM_DATA_POINTERS
     * AVBufferRef pointers, this array will hold all the references which
     * cannot fit into AVFrame.buf.
     *
     * Note that this is different from AVFrame.extended_data, which always
     * contains all the pointers. This array only contains the extra pointers,
     * which cannot fit into AVFrame.buf.
     *
     * This array is always allocated using av_malloc() by whoever constructs
     * the frame. It is freed in av_frame_unref().
     *)
    extended_buf: PPAVBufferRef;
    (**
     * Number of elements in extended_buf.
     *)
    nb_extended_buf: Integer;

    side_data: PPAVFrameSideData;
    nb_side_data: Integer;

(**
 * @defgroup lavu_frame_flags AV_FRAME_FLAGS
 * @ingroup lavu_frame
 * Flags describing additional frame properties.
 *
 * @{
 *)

(**
 * The frame data may be corrupted, e.g. due to decoding errors.
 *)
//#define AV_FRAME_FLAG_CORRUPT       (1 << 0)
(**
 * A flag to mark the frames which need to be decoded, but shouldn't be output.
 *)
//#define AV_FRAME_FLAG_DISCARD   (1 << 2)
(**
 * @}
 *)

    (**
     * Frame flags, a combination of @ref lavu_frame_flags
     *)
    flags: Integer;

    (**
     * MPEG vs JPEG YUV range.
     * - encoding: Set by user
     * - decoding: Set by libavcodec
     *)
    color_range: TAVColorRange;

    color_primaries: TAVColorPrimaries;

    color_trc: TAVColorTransferCharacteristic;

    (**
     * YUV colorspace type.
     * - encoding: Set by user
     * - decoding: Set by libavcodec
     *)
    colorspace: TAVColorSpace;

    chroma_location: TAVChromaLocation;

    (**
     * frame timestamp estimated using various heuristics, in stream time base
     * - encoding: unused
     * - decoding: set by libavcodec, read by user.
     *)
    best_effort_timestamp: Int64;

    (**
     * reordered pos from the last AVPacket that has been input into the decoder
     * - encoding: unused
     * - decoding: Read by user.
     *)
    pkt_pos: Int64;

    (**
     * duration of the corresponding packet, expressed in
     * AVStream->time_base units, 0 if unknown.
     * - encoding: unused
     * - decoding: Read by user.
     *)
    pkt_duration: Int64;

    (**
     * metadata.
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     *)
    metadata: PAVDictionary;

    (**
     * decode error flags of the frame, set to a combination of
     * FF_DECODE_ERROR_xxx flags if the decoder produced a frame, but there
     * were errors during the decoding.
     * - encoding: unused
     * - decoding: set by libavcodec, read by user.
     *)
    decode_error_flags: Integer;
//#define FF_DECODE_ERROR_INVALID_BITSTREAM   1
//#define FF_DECODE_ERROR_MISSING_REFERENCE   2

    (**
     * number of audio channels, only used for audio.
     * - encoding: unused
     * - decoding: Read by user.
     *)
    channels: Integer;

    (**
     * size of the corresponding packet containing the compressed
     * frame.
     * It is set to a negative value if unknown.
     * - encoding: unused
     * - decoding: set by libavcodec, read by user.
     *)
    pkt_size: Integer;

{$IFDEF FF_API_FRAME_QP}
    (**
     * QP table
     *)
    qscale_table: PByte;
    (**
     * QP store stride
     *)
    qstride: Integer;

    qscale_type: Integer;

    qp_table_buf: PAVBufferRef;
{$ENDIF}
    (**
     * For hwaccel-format frames, this should be a reference to the
     * AVHWFramesContext describing the frame.
     *)
    hw_frames_ctx: PAVBufferRef;

    (**
     * AVBufferRef for free use by the API user. FFmpeg will never check the
     * contents of the buffer ref. FFmpeg calls av_buffer_unref() on it when
     * the frame is unreferenced. av_frame_copy_props() calls create a new
     * reference with av_buffer_ref() for the target frame's opaque_ref field.
     *
     * This is unrelated to the opaque field, although it serves a similar
     * purpose.
     *)
    opaque_ref: PAVBufferRef;

    (**
     * @anchor cropping
     * @name Cropping
     * Video frames only. The number of pixels to discard from the the
     * top/bottom/left/right border of the frame to obtain the sub-rectangle of
     * the frame intended for presentation.
     * @{
     *)
    crop_top: Cardinal;
    crop_bottom: Cardinal;
    crop_left: Cardinal;
    crop_right: Cardinal;
    (**
     * @}
     *)
  end;

(**
 * Accessors for some AVFrame fields. These used to be provided for ABI
 * compatibility, and do not need to be used anymore.
 *)

{$IFDEF API_Dynamic}
var av_frame_get_best_effort_timestamp : function(const frame: PAVFrame): Int64; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_best_effort_timestamp(const frame: PAVFrame): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_best_effort_timestamp';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_best_effort_timestamp : procedure(frame: PAVFrame; val: Int64); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_set_best_effort_timestamp(frame: PAVFrame; val: Int64); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_best_effort_timestamp';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_get_pkt_duration : function(const frame: PAVFrame): Int64; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_pkt_duration(const frame: PAVFrame): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_pkt_duration';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_pkt_duration : procedure(frame: PAVFrame; val: Int64); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_set_pkt_duration(frame: PAVFrame; val: Int64); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_pkt_duration';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_get_pkt_pos : function(const frame: PAVFrame): Int64; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_pkt_pos(const frame: PAVFrame): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_pkt_pos';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_pkt_pos : procedure(frame: PAVFrame; val: Int64); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_set_pkt_pos(frame: PAVFrame; val: Int64); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_pkt_pos';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_get_channel_layout : function(const frame: PAVFrame): Int64; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_channel_layout(const frame: PAVFrame): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_channel_layout';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_channel_layout : procedure(frame: PAVFrame; val: Int64); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_set_channel_layout(frame: PAVFrame; val: Int64); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_channel_layout';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_get_channels : function(const frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_channels(const frame: PAVFrame): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_channels';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_channels : procedure(frame: PAVFrame; val: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_set_channels(frame: PAVFrame; val: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_channels';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_get_sample_rate : function(const frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_sample_rate(const frame: PAVFrame): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_sample_rate';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_sample_rate : procedure(frame: PAVFrame; val: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_set_sample_rate(frame: PAVFrame; val: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_sample_rate';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_get_metadata : function(const frame: PAVFrame): PAVDictionary; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_metadata(const frame: PAVFrame): PAVDictionary; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_metadata';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_metadata : procedure(frame: PAVFrame; val: PAVDictionary); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_set_metadata(frame: PAVFrame; val: PAVDictionary); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_metadata';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_get_decode_error_flags : function(const frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_decode_error_flags(const frame: PAVFrame): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_decode_error_flags';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_decode_error_flags : procedure(frame: PAVFrame; val: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_set_decode_error_flags(frame: PAVFrame; val: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_decode_error_flags';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_get_pkt_size : function(const frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_pkt_size(const frame: PAVFrame): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_pkt_size';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_pkt_size : procedure(frame: PAVFrame; val: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_set_pkt_size(frame: PAVFrame; val: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_pkt_size';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avpriv_frame_get_metadatap : function(frame: PAVFrame): PPAVDictionary; cdecl;
{$ELSE API_Dynamic}
function avpriv_frame_get_metadatap(frame: PAVFrame): PPAVDictionary; cdecl; external AVUTIL_LIBNAME name _PU + 'avpriv_frame_get_metadatap';
{$ENDIF API_Dynamic}

{$IFDEF FF_API_FRAME_QP}

{$IFDEF API_Dynamic}
var av_frame_get_qp_table : function(f: PAVFrame; stride, type_: PInteger): PByte; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_qp_table(f: PAVFrame; stride, type_: PInteger): PByte; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_qp_table';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_qp_table : function(f: PAVFrame; buf: PAVBufferRef; stride, type_: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_set_qp_table(f: PAVFrame; buf: PAVBufferRef; stride, type_: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_qp_table';
{$ENDIF API_Dynamic}

{$ENDIF}

{$IFDEF API_Dynamic}
var av_frame_get_colorspace : function(const frame: PAVFrame): TAVColorSpace; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_colorspace(const frame: PAVFrame): TAVColorSpace; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_colorspace';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_colorspace : procedure(frame: PAVFrame; val: TAVColorSpace); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_set_colorspace(frame: PAVFrame; val: TAVColorSpace); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_colorspace';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_get_color_range : function(const frame: PAVFrame): TAVColorRange; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_color_range(const frame: PAVFrame): TAVColorRange; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_color_range';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_frame_set_color_range : procedure(frame: PAVFrame; val: TAVColorRange); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_set_color_range(frame: PAVFrame; val: TAVColorRange); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_set_color_range';
{$ENDIF API_Dynamic}


(**
 * Get the name of a colorspace.
 * @return a static string identifying the colorspace; can be NULL.
 *)

{$IFDEF API_Dynamic}
var av_get_colorspace_name : function(val: TAVColorSpace): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_colorspace_name(val: TAVColorSpace): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_colorspace_name';
{$ENDIF API_Dynamic}


(**
 * Allocate an AVFrame and set its fields to default values.  The resulting
 * struct must be freed using av_frame_free().
 *
 * @return An AVFrame filled with default values or NULL on failure.
 *
 * @note this only allocates the AVFrame itself, not the data buffers. Those
 * must be allocated through other means, e.g. with av_frame_get_buffer() or
 * manually.
 *)

{$IFDEF API_Dynamic}
var av_frame_alloc : function(): PAVFrame; cdecl;
{$ELSE API_Dynamic}
function av_frame_alloc(): PAVFrame; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_alloc';
{$ENDIF API_Dynamic}


(**
 * Free the frame and any dynamically allocated objects in it,
 * e.g. extended_data. If the frame is reference counted, it will be
 * unreferenced first.
 *
 * @param frame frame to be freed. The pointer will be set to NULL.
 *)

{$IFDEF API_Dynamic}
var av_frame_free : procedure(frame: PPAVFrame); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_free(frame: PPAVFrame); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_free';
{$ENDIF API_Dynamic}


(**
 * Set up a new reference to the data described by the source frame.
 *
 * Copy frame properties from src to dst and create a new reference for each
 * AVBufferRef from src.
 *
 * If src is not reference counted, new buffers are allocated and the data is
 * copied.
 *
 * @warning: dst MUST have been either unreferenced with av_frame_unref(dst),
 *           or newly allocated with av_frame_alloc() before calling this
 *           function, or undefined behavior will occur.
 *
 * @return 0 on success, a negative AVERROR on error
 *)

{$IFDEF API_Dynamic}
var av_frame_ref : function(dst: PAVFrame; const src: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_ref(dst: PAVFrame; const src: PAVFrame): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_ref';
{$ENDIF API_Dynamic}


(**
 * Create a new frame that references the same data as src.
 *
 * This is a shortcut for av_frame_alloc()+av_frame_ref().
 *
 * @return newly created AVFrame on success, NULL on error.
 *)

{$IFDEF API_Dynamic}
var av_frame_clone : function(const src: PAVFrame): PAVFrame; cdecl;
{$ELSE API_Dynamic}
function av_frame_clone(const src: PAVFrame): PAVFrame; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_clone';
{$ENDIF API_Dynamic}


(**
 * Unreference all the buffers referenced by frame and reset the frame fields.
 *)

{$IFDEF API_Dynamic}
var av_frame_unref : procedure(frame: PAVFrame); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_unref(frame: PAVFrame); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_unref';
{$ENDIF API_Dynamic}


(**
 * Move everything contained in src to dst and reset src.
 *
 * @warning: dst is not unreferenced, but directly overwritten without reading
 *           or deallocating its contents. Call av_frame_unref(dst) manually
 *           before calling this function to ensure that no memory is leaked.
 *)

{$IFDEF API_Dynamic}
var av_frame_move_ref : procedure(dst, src: PAVFrame); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_move_ref(dst, src: PAVFrame); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_move_ref';
{$ENDIF API_Dynamic}


(**
 * Allocate new buffer(s) for audio or video data.
 *
 * The following fields must be set on frame before calling this function:
 * - format (pixel format for video, sample format for audio)
 * - width and height for video
 * - nb_samples and channel_layout for audio
 *
 * This function will fill AVFrame.data and AVFrame.buf arrays and, if
 * necessary, allocate and fill AVFrame.extended_data and AVFrame.extended_buf.
 * For planar formats, one buffer will be allocated for each plane.
 *
 * @warning: if frame already has been allocated, calling this function will
 *           leak memory. In addition, undefined behavior can occur in certain
 *           cases.
 *
 * @param frame frame in which to store the new buffers.
 * @param align Required buffer size alignment. If equal to 0, alignment will be
 *              chosen automatically for the current CPU. It is highly
 *              recommended to pass 0 here unless you know what you are doing.
 *
 * @return 0 on success, a negative AVERROR on error.
 *)

{$IFDEF API_Dynamic}
var av_frame_get_buffer : function(frame: PAVFrame; align: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_buffer(frame: PAVFrame; align: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_buffer';
{$ENDIF API_Dynamic}


(**
 * Check if the frame data is writable.
 *
 * @return A positive value if the frame data is writable (which is true if and
 * only if each of the underlying buffers has only one reference, namely the one
 * stored in this frame). Return 0 otherwise.
 *
 * If 1 is returned the answer is valid until av_buffer_ref() is called on any
 * of the underlying AVBufferRefs (e.g. through av_frame_ref() or directly).
 *
 * @see av_frame_make_writable(), av_buffer_is_writable()
 *)

{$IFDEF API_Dynamic}
var av_frame_is_writable : function(frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_is_writable(frame: PAVFrame): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_is_writable';
{$ENDIF API_Dynamic}


(**
 * Ensure that the frame data is writable, avoiding data copy if possible.
 *
 * Do nothing if the frame is writable, allocate new buffers and copy the data
 * if it is not.
 *
 * @return 0 on success, a negative AVERROR on error.
 *
 * @see av_frame_is_writable(), av_buffer_is_writable(),
 * av_buffer_make_writable()
 *)

{$IFDEF API_Dynamic}
var av_frame_make_writable : function(frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_make_writable(frame: PAVFrame): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_make_writable';
{$ENDIF API_Dynamic}


(**
 * Copy the frame data from src to dst.
 *
 * This function does not allocate anything, dst must be already initialized and
 * allocated with the same parameters as src.
 *
 * This function only copies the frame data (i.e. the contents of the data /
 * extended data arrays), not any other properties.
 *
 * @return >= 0 on success, a negative AVERROR on error.
 *)

{$IFDEF API_Dynamic}
var av_frame_copy : function(dst: PAVFrame; const src: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_copy(dst: PAVFrame; const src: PAVFrame): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_copy';
{$ENDIF API_Dynamic}


(**
 * Copy only "metadata" fields from src to dst.
 *
 * Metadata for the purpose of this function are those fields that do not affect
 * the data layout in the buffers.  E.g. pts, sample rate (for audio) or sample
 * aspect ratio (for video), but not width/height or channel layout.
 * Side data is also copied.
 *)

{$IFDEF API_Dynamic}
var av_frame_copy_props : function(dst: PAVFrame; const src: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_copy_props(dst: PAVFrame; const src: PAVFrame): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_copy_props';
{$ENDIF API_Dynamic}


(**
 * Get the buffer reference a given data plane is stored in.
 *
 * @param plane index of the data plane of interest in frame->extended_data.
 *
 * @return the buffer reference that contains the plane or NULL if the input
 * frame is not valid.
 *)

{$IFDEF API_Dynamic}
var av_frame_get_plane_buffer : function(frame: PAVFrame; plane: Integer): PAVBufferRef; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_plane_buffer(frame: PAVFrame; plane: Integer): PAVBufferRef; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_plane_buffer';
{$ENDIF API_Dynamic}


(**
 * Add a new side data to a frame.
 *
 * @param frame a frame to which the side data should be added
 * @param type type of the added side data
 * @param size size of the side data
 *
 * @return newly added side data on success, NULL on error
 *)

{$IFDEF API_Dynamic}
var av_frame_new_side_data : function(frame: PAVFrame;
                                         type_: TAVFrameSideDataType;
                                         size: Integer): PAVFrameSideData; cdecl;
{$ELSE API_Dynamic}
function av_frame_new_side_data(frame: PAVFrame;
                                         type_: TAVFrameSideDataType;
                                         size: Integer): PAVFrameSideData; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_new_side_data';
{$ENDIF API_Dynamic}


(**
 * @return a pointer to the side data of a given type on success, NULL if there
 * is no side data with such type in this frame.
 *)

{$IFDEF API_Dynamic}
var av_frame_get_side_data : function(const frame: PAVFrame;
                                         type_: TAVFrameSideDataType): PAVFrameSideData; cdecl;
{$ELSE API_Dynamic}
function av_frame_get_side_data(const frame: PAVFrame;
                                         type_: TAVFrameSideDataType): PAVFrameSideData; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_get_side_data';
{$ENDIF API_Dynamic}


(**
 * If side data of the supplied type exists in the frame, free it and remove it
 * from the frame.
 *)

{$IFDEF API_Dynamic}
var av_frame_remove_side_data : procedure(frame: PAVFrame; type_: TAVFrameSideDataType); cdecl;
{$ELSE API_Dynamic}
procedure av_frame_remove_side_data(frame: PAVFrame; type_: TAVFrameSideDataType); cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_remove_side_data';
{$ENDIF API_Dynamic}



(**
 * Flags for frame cropping.
 *)
//enum {
    (**
     * Apply the maximum possible cropping, even if it requires setting the
     * AVFrame.data[] entries to unaligned pointers. Passing unaligned data
     * to FFmpeg API is generally not allowed, and causes undefined behavior
     * (such as crashes). You can pass unaligned data only to FFmpeg APIs that
     * are explicitly documented to accept it. Use this flag only if you
     * absolutely know what you are doing.
     *)
const
    AV_FRAME_CROP_UNALIGNED     = (1 shl 0);
//};

(**
 * Crop the given video AVFrame according to its crop_left/crop_top/crop_right/
 * crop_bottom fields. If cropping is successful, the function will adjust the
 * data pointers and the width/height fields, and set the crop fields to 0.
 *
 * In all cases, the cropping boundaries will be rounded to the inherent
 * alignment of the pixel format. In some cases, such as for opaque hwaccel
 * formats, the left/top cropping is ignored. The crop fields are set to 0 even
 * if the cropping was rounded or ignored.
 *
 * @param frame the frame which should be cropped
 * @param flags Some combination of AV_FRAME_CROP_* flags, or 0.
 *
 * @return >= 0 on success, a negative AVERROR on error. If the cropping fields
 * were invalid, AVERROR(ERANGE) is returned, and nothing is changed.
 *)

{$IFDEF API_Dynamic}
var av_frame_apply_cropping : function(frame: PAVFrame; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_frame_apply_cropping(frame: PAVFrame; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_apply_cropping';
{$ENDIF API_Dynamic}


(**
 * @return a string identifying the side data type
 *)

{$IFDEF API_Dynamic}
var av_frame_side_data_name : function(type_: TAVFrameSideDataType): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_frame_side_data_name(type_: TAVFrameSideDataType): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_frame_side_data_name';
{$ENDIF API_Dynamic}


(**
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_audio_fifo *)
(* ****************************************************** *)






(**
 * @addtogroup lavu_audio
 * @{
 *
 * @defgroup lavu_audiofifo Audio FIFO Buffer
 * @{
 *)

(**
 * Context for an Audio FIFO Buffer.
 *
 * - Operates at the sample level rather than the byte level.
 * - Supports multiple channels with either planar or packed sample format.
 * - Automatic reallocation when writing to a full buffer.
 *)
type
  PAVAudioFifo = ^TAVAudioFifo;
  TAVAudioFifo = record
    // need {$ALIGN 8}
    // defined in libavutil/audio_fifo.c
  end;

(**
 * Free an AVAudioFifo.
 *
 * @param af  AVAudioFifo to free
 *)

{$IFDEF API_Dynamic}
var av_audio_fifo_free : procedure(af: PAVAudioFifo); cdecl;
{$ELSE API_Dynamic}
procedure av_audio_fifo_free(af: PAVAudioFifo); cdecl; external AVUTIL_LIBNAME name _PU + 'av_audio_fifo_free';
{$ENDIF API_Dynamic}


(**
 * Allocate an AVAudioFifo.
 *
 * @param sample_fmt  sample format
 * @param channels    number of channels
 * @param nb_samples  initial allocation size, in samples
 * @return            newly allocated AVAudioFifo, or NULL on error
 *)

{$IFDEF API_Dynamic}
var av_audio_fifo_alloc : function(sample_fmt: TAVSampleFormat; channels, nb_samples: Integer): PAVAudioFifo; cdecl;
{$ELSE API_Dynamic}
function av_audio_fifo_alloc(sample_fmt: TAVSampleFormat; channels, nb_samples: Integer): PAVAudioFifo; cdecl; external AVUTIL_LIBNAME name _PU + 'av_audio_fifo_alloc';
{$ENDIF API_Dynamic}


(**
 * Reallocate an AVAudioFifo.
 *
 * @param af          AVAudioFifo to reallocate
 * @param nb_samples  new allocation size, in samples
 * @return            0 if OK, or negative AVERROR code on failure
 *)

{$IFDEF API_Dynamic}
var av_audio_fifo_realloc : function(af: PAVAudioFifo; nb_samples: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_audio_fifo_realloc(af: PAVAudioFifo; nb_samples: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_audio_fifo_realloc';
{$ENDIF API_Dynamic}


(**
 * Write data to an AVAudioFifo.
 *
 * The AVAudioFifo will be reallocated automatically if the available space
 * is less than nb_samples.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param af          AVAudioFifo to write to
 * @param data        audio data plane pointers
 * @param nb_samples  number of samples to write
 * @return            number of samples actually written, or negative AVERROR
 *                    code on failure. If successful, the number of samples
 *                    actually written will always be nb_samples.
 *)

{$IFDEF API_Dynamic}
var av_audio_fifo_write : function(af: PAVAudioFifo; data: PPointer; nb_samples: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_audio_fifo_write(af: PAVAudioFifo; data: PPointer; nb_samples: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_audio_fifo_write';
{$ENDIF API_Dynamic}


(**
 * Peek data from an AVAudioFifo.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param af          AVAudioFifo to read from
 * @param data        audio data plane pointers
 * @param nb_samples  number of samples to peek
 * @return            number of samples actually peek, or negative AVERROR code
 *                    on failure. The number of samples actually peek will not
 *                    be greater than nb_samples, and will only be less than
 *                    nb_samples if av_audio_fifo_size is less than nb_samples.
 *)

{$IFDEF API_Dynamic}
var av_audio_fifo_peek : function(af: PAVAudioFifo; data: PPointer; nb_samples: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_audio_fifo_peek(af: PAVAudioFifo; data: PPointer; nb_samples: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_audio_fifo_peek';
{$ENDIF API_Dynamic}


(**
 * Peek data from an AVAudioFifo.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param af          AVAudioFifo to read from
 * @param data        audio data plane pointers
 * @param nb_samples  number of samples to peek
 * @param offset      offset from current read position
 * @return            number of samples actually peek, or negative AVERROR code
 *                    on failure. The number of samples actually peek will not
 *                    be greater than nb_samples, and will only be less than
 *                    nb_samples if av_audio_fifo_size is less than nb_samples.
 *)

{$IFDEF API_Dynamic}
var av_audio_fifo_peek_at : function(af: PAVAudioFifo; data: Pointer; nb_samples, offset: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_audio_fifo_peek_at(af: PAVAudioFifo; data: Pointer; nb_samples, offset: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_audio_fifo_peek_at';
{$ENDIF API_Dynamic}


(**
 * Read data from an AVAudioFifo.
 *
 * @see enum AVSampleFormat
 * The documentation for AVSampleFormat describes the data layout.
 *
 * @param af          AVAudioFifo to read from
 * @param data        audio data plane pointers
 * @param nb_samples  number of samples to read
 * @return            number of samples actually read, or negative AVERROR code
 *                    on failure. The number of samples actually read will not
 *                    be greater than nb_samples, and will only be less than
 *                    nb_samples if av_audio_fifo_size is less than nb_samples.
 *)

{$IFDEF API_Dynamic}
var av_audio_fifo_read : function(af: PAVAudioFifo; data: PPointer; nb_samples: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_audio_fifo_read(af: PAVAudioFifo; data: PPointer; nb_samples: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_audio_fifo_read';
{$ENDIF API_Dynamic}


(**
 * Drain data from an AVAudioFifo.
 *
 * Removes the data without reading it.
 *
 * @param af          AVAudioFifo to drain
 * @param nb_samples  number of samples to drain
 * @return            0 if OK, or negative AVERROR code on failure
 *)

{$IFDEF API_Dynamic}
var av_audio_fifo_drain : function(af: PAVAudioFifo; nb_samples: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_audio_fifo_drain(af: PAVAudioFifo; nb_samples: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_audio_fifo_drain';
{$ENDIF API_Dynamic}


(**
 * Reset the AVAudioFifo buffer.
 *
 * This empties all data in the buffer.
 *
 * @param af  AVAudioFifo to reset
 *)

{$IFDEF API_Dynamic}
var av_audio_fifo_reset : procedure(af: PAVAudioFifo); cdecl;
{$ELSE API_Dynamic}
procedure av_audio_fifo_reset(af: PAVAudioFifo); cdecl; external AVUTIL_LIBNAME name _PU + 'av_audio_fifo_reset';
{$ENDIF API_Dynamic}


(**
 * Get the current number of samples in the AVAudioFifo available for reading.
 *
 * @param af  the AVAudioFifo to query
 * @return    number of samples available for reading
 *)

{$IFDEF API_Dynamic}
var av_audio_fifo_size : function(af: PAVAudioFifo): Integer; cdecl;
{$ELSE API_Dynamic}
function av_audio_fifo_size(af: PAVAudioFifo): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_audio_fifo_size';
{$ENDIF API_Dynamic}


(**
 * Get the current number of samples in the AVAudioFifo available for writing.
 *
 * @param af  the AVAudioFifo to query
 * @return    number of samples available for writing
 *)

{$IFDEF API_Dynamic}
var av_audio_fifo_space : function(af: PAVAudioFifo): Integer; cdecl;
{$ELSE API_Dynamic}
function av_audio_fifo_space(af: PAVAudioFifo): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_audio_fifo_space';
{$ENDIF API_Dynamic}


(**
 * @}
 * @}
 *)


(* ****************************************************** *)
(* import libavformat_avio *)
(* ****************************************************** *)






const
(**
 * Seeking works like for a local file.
 *)
  AVIO_SEEKABLE_NORMAL = (1 shl 0);

(**
 * Seeking by timestamp with avio_seek_time() is possible.
 *)
  AVIO_SEEKABLE_TIME   = (1 shl 1);

type
(**
 * Callback for checking whether to abort blocking functions.
 * AVERROR_EXIT is returned in this case by the interrupted
 * function. During blocking operations, callback is called with
 * opaque as parameter. If the callback returns 1, the
 * blocking operation will be aborted.
 *
 * No members can be added to this struct without a major bump, if
 * new elements have been added after this struct in AVFormatContext
 * or AVIOContext.
 *)
  PAVIOInterruptCB = ^TAVIOInterruptCB;
  TAVIOInterruptCB = record
    callback: function(opaque: Pointer): Integer; cdecl;
    opaque: Pointer;
  end;

(**
 * Directory entry types.
 *)
  TAVIODirEntryType = (
    AVIO_ENTRY_UNKNOWN,
    AVIO_ENTRY_BLOCK_DEVICE,
    AVIO_ENTRY_CHARACTER_DEVICE,
    AVIO_ENTRY_DIRECTORY,
    AVIO_ENTRY_NAMED_PIPE,
    AVIO_ENTRY_SYMBOLIC_LINK,
    AVIO_ENTRY_SOCKET,
    AVIO_ENTRY_FILE,
    AVIO_ENTRY_SERVER,
    AVIO_ENTRY_SHARE,
    AVIO_ENTRY_WORKGROUP
  );

(**
 * Describes single entry of the directory.
 *
 * Only name and type fields are guaranteed be set.
 * Rest of fields are protocol or/and platform dependent and might be unknown.
 *)
  PPAVIODirEntry = ^PAVIODirEntry;
  PAVIODirEntry = ^TAVIODirEntry;
  TAVIODirEntry = record
    name: PAnsiChar;                      (**< Filename *)
    type_: Integer;                       (**< Type of the entry *)
    utf8: Integer;                        (**< Set to 1 when name is encoded with UTF-8, 0 otherwise.
                                               Name can be encoded with UTF-8 even though 0 is set. *)
    size: Int64;                          (**< File size in bytes, -1 if unknown. *)
    modification_timestamp: Int64;        (**< Time of last modification in microseconds since unix
                                               epoch, -1 if unknown. *)
    access_timestamp: Int64;              (**< Time of last access in microseconds since unix epoch,
                                               -1 if unknown. *)
    status_change_timestamp: Int64;       (**< Time of last status change in microseconds since unix
                                               epoch, -1 if unknown. *)
    user_id: Int64;                       (**< User ID of owner, -1 if unknown. *)
    group_id: Int64;                      (**< Group ID of owner, -1 if unknown. *)
    filemode: Int64;                      (**< Unix file mode, -1 if unknown. *)
  end;

  PPAVIODirContext = ^PAVIODirContext;
  PAVIODirContext = ^TAVIODirContext;
  TAVIODirContext = record
    url_context: Pointer; // libavformat_url.PURLContext;
  end;

(**
 * Different data types that can be returned via the AVIO
 * write_data_type callback.
 *)
  TAVIODataMarkerType = (
    (**
     * Header data; this needs to be present for the stream to be decodeable.
     *)
    AVIO_DATA_MARKER_HEADER,
    (**
     * A point in the output bytestream where a decoder can start decoding
     * (i.e. a keyframe). A demuxer/decoder given the data flagged with
     * AVIO_DATA_MARKER_HEADER, followed by any AVIO_DATA_MARKER_SYNC_POINT,
     * should give decodeable results.
     *)
    AVIO_DATA_MARKER_SYNC_POINT,
    (**
     * A point in the output bytestream where a demuxer can start parsing
     * (for non self synchronizing bytestream formats). That is, any
     * non-keyframe packet start point.
     *)
    AVIO_DATA_MARKER_BOUNDARY_POINT,
    (**
     * This is any, unlabelled data. It can either be a muxer not marking
     * any positions at all, it can be an actual boundary/sync point
     * that the muxer chooses not to mark, or a later part of a packet/fragment
     * that is cut into multiple write callbacks due to limited IO buffer size.
     *)
    AVIO_DATA_MARKER_UNKNOWN,
    (**
     * Trailer data, which doesn't contain actual content, but only for
     * finalizing the output file.
     *)
    AVIO_DATA_MARKER_TRAILER,
    (**
     * A point in the output bytestream where the underlying AVIOContext might
     * flush the buffer depending on latency or buffering requirements. Typically
     * means the end of a packet.
     *)
    AVIO_DATA_MARKER_FLUSH_POINT
  );

(**
 * Bytestream IO Context.
 * New fields can be added to the end with minor version bumps.
 * Removal, reordering and changes to existing fields require a major
 * version bump.
 * sizeof(AVIOContext) must not be used outside libav*.
 *
 * @note None of the function pointers in AVIOContext should be called
 *       directly, they should only be set by the client application
 *       when implementing custom I/O. Normally these are set to the
 *       function pointers specified in avio_alloc_context()
 *)
  PPAVIOContext = ^PAVIOContext;
  PAVIOContext = ^TAVIOContext;
  TAVIOContext = record
    (**
     * A class for private options.
     *
     * If this AVIOContext is created by avio_open2(), av_class is set and
     * passes the options down to protocols.
     *
     * If this AVIOContext is manually allocated, then av_class may be set by
     * the caller.
     *
     * warning -- this field can be NULL, be sure to not pass this AVIOContext
     * to any av_opt_* functions in that case.
     *)
    av_class: PAVClass;

    (*
     * The following shows the relationship between buffer, buf_ptr,
     * buf_ptr_max, buf_end, buf_size, and pos, when reading and when writing
     * (since AVIOContext is used for both):
     *
     **********************************************************************************
     *                                   READING
     **********************************************************************************
     *
     *                            |              buffer_size              |
     *                            |---------------------------------------|
     *                            |                                       |
     *
     *                         buffer          buf_ptr       buf_end
     *                            +---------------+-----------------------+
     *                            |/ / / / / / / /|/ / / / / / /|         |
     *  read buffer:              |/ / consumed / | to be read /|         |
     *                            |/ / / / / / / /|/ / / / / / /|         |
     *                            +---------------+-----------------------+
     *
     *                                                         pos
     *              +-------------------------------------------+-----------------+
     *  input file: |                                           |                 |
     *              +-------------------------------------------+-----------------+
     *
     *
     **********************************************************************************
     *                                   WRITING
     **********************************************************************************
     *
     *                             |          buffer_size                 |
     *                             |--------------------------------------|
     *                             |                                      |
     *
     *                                                buf_ptr_max
     *                          buffer                 (buf_ptr)       buf_end
     *                             +-----------------------+--------------+
     *                             |/ / / / / / / / / / / /|              |
     *  write buffer:              | / / to be flushed / / |              |
     *                             |/ / / / / / / / / / / /|              |
     *                             +-----------------------+--------------+
     *                               buf_ptr can be in this
     *                               due to a backward seek
     *
     *                            pos
     *               +-------------+----------------------------------------------+
     *  output file: |             |                                              |
     *               +-------------+----------------------------------------------+
     *
     *)
    buffer: PByte;        (**< Start of the buffer. *)
    buffer_size: Integer; (**< Maximum buffer size *)
    buf_ptr: PByte;       (**< Current position in the buffer *)
    buf_end: PByte;       (**< End of the data, may be less than
                               buffer+buffer_size if the read function returned
                               less data than requested, e.g. for streams where
                               no more data has been received yet. *)
    opaque: Pointer;      (**< A private pointer, passed to the read/write/seek/...
                               functions. *)
    read_packet: function(opaque: Pointer; buf: PByte; buf_size: Integer): Integer; cdecl;
    write_packet: function(opaque: Pointer; buf: PByte; buf_size: Integer): Integer; cdecl;
    seek: function(opaque: Pointer; offset: Int64; whence: Integer): Int64; cdecl;
    pos: Int64;           (**< position in the file of the current buffer *)
    must_flush: Integer;  (**< unused *)
    eof_reached: Integer; (**< true if eof reached *)
    write_flag: Integer;  (**< true if open for writing *)
    max_packet_size: Integer;
    checksum: Cardinal;
    checksum_ptr: PByte;
    update_checksum: function(checksum: Cardinal; const buf: PByte; size: Cardinal): Cardinal; cdecl;
    error: Integer;       (**< contains the error code or 0 if no error happened *)
    (**
     * Pause or resume playback for network streaming protocols - e.g. MMS.
     *)
    read_pause: function(opaque: Pointer; pause: Integer): Integer; cdecl;
    (**
     * Seek to a given timestamp in stream with the specified stream_index.
     * Needed for some network streaming protocols which don't support seeking
     * to byte position.
     *)
    read_seek: function(opaque: Pointer; stream_index: Integer;
                        timestamp: Int64; flags: Integer): Int64; cdecl;
    (**
     * A combination of AVIO_SEEKABLE_ flags or 0 when the stream is not seekable.
     *)
    seekable: Integer;

    (**
     * max filesize, used to limit allocations
     * This field is internal to libavformat and access from outside is not allowed.
     *)
    maxsize: Int64;

    (**
     * avio_read and avio_write should if possible be satisfied directly
     * instead of going through a buffer, and avio_seek will always
     * call the underlying seek function directly.
     *)
    direct: Integer;

    (**
     * Bytes read statistic
     * This field is internal to libavformat and access from outside is not allowed.
     *)
    bytes_read: Int64;

    (**
     * seek statistic
     * This field is internal to libavformat and access from outside is not allowed.
     *)
    seek_count: Integer;

    (**
     * writeout statistic
     * This field is internal to libavformat and access from outside is not allowed.
     *)
    writeout_count: Integer;

    (**
     * Original buffer size
     * used internally after probing and ensure seekback to reset the buffer size
     * This field is internal to libavformat and access from outside is not allowed.
     *)
    orig_buffer_size: Integer;

    (**
     * Threshold to favor readahead over seek.
     * This is current internal only, do not use from outside.
     *)
    short_seek_threshold: Integer;

    (**
     * ',' separated list of allowed protocols.
     *)
    protocol_whitelist: PAnsiChar;

    (**
     * ',' separated list of disallowed protocols.
     *)
    protocol_blacklist: PAnsiChar;

    (**
     * A callback that is used instead of write_packet.
     *)
    write_data_type: function(opaque: Pointer; buf: PByte; buf_size: Integer;
                           ttype: TAVIODataMarkerType; time: Int64): Integer; cdecl;
    (**
     * If set, don't call write_data_type separately for AVIO_DATA_MARKER_BOUNDARY_POINT,
     * but ignore them and treat them as AVIO_DATA_MARKER_UNKNOWN (to avoid needlessly
     * small chunks of data returned from the callback).
     *)
    ignore_boundary_point: Integer;

    (**
     * Internal, not meant to be used from outside of AVIOContext.
     *)
    current_type: TAVIODataMarkerType;
    last_time: Int64;

    (**
     * A callback that is used instead of short_seek_threshold.
     * This is current internal only, do not use from outside.
     *)
    short_seek_get: function(opaque: Pointer): Integer; cdecl;

    written: Int64;

    (**
     * Maximum reached position before a backward seek in the write buffer,
     * used keeping track of already written data for a later flush.
     *)
    buf_ptr_max: PByte;

    (**
     * Try to buffer at least this amount of data before flushing it
     *)
    min_packet_size: Integer;
  end;

(**
 * Return the name of the protocol that will handle the passed URL.
 *
 * NULL is returned if no protocol could be found for the given URL.
 *
 * @return Name of the protocol or NULL.
 *)

{$IFDEF API_Dynamic}
var avio_find_protocol_name : function(const url: PAnsiChar): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avio_find_protocol_name(const url: PAnsiChar): PAnsiChar; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_find_protocol_name';
{$ENDIF API_Dynamic}


(**
 * Return AVIO_FLAG_* access flags corresponding to the access permissions
 * of the resource in url, or a negative value corresponding to an
 * AVERROR code in case of failure. The returned access flags are
 * masked by the value in flags.
 *
 * @note This function is intrinsically unsafe, in the sense that the
 * checked resource may change its existence or permission status from
 * one call to another. Thus you should not trust the returned value,
 * unless you are sure that no other processes are accessing the
 * checked resource.
 *)

{$IFDEF API_Dynamic}
var avio_check : function(const url: PAnsiChar; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_check(const url: PAnsiChar; flags: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_check';
{$ENDIF API_Dynamic}


(**
 * Move or rename a resource.
 *
 * @note url_src and url_dst should share the same protocol and authority.
 *
 * @param url_src url to resource to be moved
 * @param url_dst new url to resource if the operation succeeded
 * @return >=0 on success or negative on error.
 *)

{$IFDEF API_Dynamic}
var avpriv_io_move : function(const url_src, url_dst: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function avpriv_io_move(const url_src, url_dst: PAnsiChar): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avpriv_io_move';
{$ENDIF API_Dynamic}


(**
 * Delete a resource.
 *
 * @param url resource to be deleted.
 * @return >=0 on success or negative on error.
 *)

{$IFDEF API_Dynamic}
var avpriv_io_delete : function(const url: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function avpriv_io_delete(const url: PAnsiChar): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avpriv_io_delete';
{$ENDIF API_Dynamic}


(**
 * Open directory for reading.
 *
 * @param s       directory read context. Pointer to a NULL pointer must be passed.
 * @param url     directory to be listed.
 * @param options A dictionary filled with protocol-private options. On return
 *                this parameter will be destroyed and replaced with a dictionary
 *                containing options that were not found. May be NULL.
 * @return >=0 on success or negative on error.
 *)

{$IFDEF API_Dynamic}
var avio_open_dir : function(s: PPAVIODirContext; const url: PAnsiChar; options: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_open_dir(s: PPAVIODirContext; const url: PAnsiChar; options: PPAVDictionary): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_open_dir';
{$ENDIF API_Dynamic}


(**
 * Get next directory entry.
 *
 * Returned entry must be freed with avio_free_directory_entry(). In particular
 * it may outlive AVIODirContext.
 *
 * @param s         directory read context.
 * @param[out] next next entry or NULL when no more entries.
 * @return >=0 on success or negative on error. End of list is not considered an
 *             error.
 *)

{$IFDEF API_Dynamic}
var avio_read_dir : function(s: PAVIODirContext; next: PPAVIODirEntry): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_read_dir(s: PAVIODirContext; next: PPAVIODirEntry): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_read_dir';
{$ENDIF API_Dynamic}


(**
 * Close directory.
 *
 * @note Entries created using avio_read_dir() are not deleted and must be
 * freeded with avio_free_directory_entry().
 *
 * @param s         directory read context.
 * @return >=0 on success or negative on error.
 *)

{$IFDEF API_Dynamic}
var avio_close_dir : function(s: PPAVIODirContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_close_dir(s: PPAVIODirContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_close_dir';
{$ENDIF API_Dynamic}


(**
 * Free entry allocated by avio_read_dir().
 *
 * @param entry entry to be freed.
 *)

{$IFDEF API_Dynamic}
var avio_free_directory_entry : procedure(entry: PPAVIODirEntry); cdecl;
{$ELSE API_Dynamic}
procedure avio_free_directory_entry(entry: PPAVIODirEntry); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_free_directory_entry';
{$ENDIF API_Dynamic}


(**
 * Allocate and initialize an AVIOContext for buffered I/O. It must be later
 * freed with avio_context_free().
 *
 * @param buffer Memory block for input/output operations via AVIOContext.
 *        The buffer must be allocated with av_malloc() and friends.
 *        It may be freed and replaced with a new buffer by libavformat.
 *        AVIOContext.buffer holds the buffer currently in use,
 *        which must be later freed with av_free().
 * @param buffer_size The buffer size is very important for performance.
 *        For protocols with fixed blocksize it should be set to this blocksize.
 *        For others a typical size is a cache page, e.g. 4kb.
 * @param write_flag Set to 1 if the buffer should be writable, 0 otherwise.
 * @param opaque An opaque pointer to user-specific data.
 * @param read_packet  A function for refilling the buffer, may be NULL.
 * @param write_packet A function for writing the buffer contents, may be NULL.
 *        The function may not change the input buffers content.
 * @param seek A function for seeking to specified byte position, may be NULL.
 *
 * @return Allocated AVIOContext or NULL on failure.
 *)
type
  Tread_packetCall = function(opaque: Pointer; buf: PByte; buf_size: Integer): Integer; cdecl;
  Twrite_packetCall = function(opaque: Pointer; buf: PByte; buf_size: Integer): Integer; cdecl;
  TseekCall = function(opaque: Pointer; offset: Int64; whence: Integer): Int64; cdecl;

{$IFDEF API_Dynamic}
var avio_alloc_context : function(
                  buffer: PByte;
                  buffer_size: Integer;
                  write_flag: Integer;
                  opaque: Pointer;
                  read_packet: Tread_packetCall;
                  write_packet: Twrite_packetCall;
                  seek: TseekCall): PAVIOContext; cdecl;
{$ELSE API_Dynamic}
function avio_alloc_context(
                  buffer: PByte;
                  buffer_size: Integer;
                  write_flag: Integer;
                  opaque: Pointer;
                  read_packet: Tread_packetCall;
                  write_packet: Twrite_packetCall;
                  seek: TseekCall): PAVIOContext; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_alloc_context';
{$ENDIF API_Dynamic}


(**
 * Free the supplied IO context and everything associated with it.
 *
 * @param s Double pointer to the IO context. This function will write NULL
 * into s.
 *)

{$IFDEF API_Dynamic}
var avio_context_free : procedure(s: PPAVIOContext); cdecl;
{$ELSE API_Dynamic}
procedure avio_context_free(s: PPAVIOContext); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_context_free';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var avio_w8 : procedure(s: PAVIOContext; b: Integer); cdecl;
{$ELSE API_Dynamic}
procedure avio_w8(s: PAVIOContext; b: Integer); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_w8';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_write : procedure(s: PAVIOContext; const buf: PByte; size: Integer); cdecl;
{$ELSE API_Dynamic}
procedure avio_write(s: PAVIOContext; const buf: PByte; size: Integer); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_write';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_wl64 : procedure(s: PAVIOContext; val: Int64); cdecl;
{$ELSE API_Dynamic}
procedure avio_wl64(s: PAVIOContext; val: Int64); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_wl64';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_wb64 : procedure(s: PAVIOContext; val: Int64); cdecl;
{$ELSE API_Dynamic}
procedure avio_wb64(s: PAVIOContext; val: Int64); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_wb64';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_wl32 : procedure(s: PAVIOContext; val: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure avio_wl32(s: PAVIOContext; val: Cardinal); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_wl32';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_wb32 : procedure(s: PAVIOContext; val: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure avio_wb32(s: PAVIOContext; val: Cardinal); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_wb32';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_wl24 : procedure(s: PAVIOContext; val: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure avio_wl24(s: PAVIOContext; val: Cardinal); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_wl24';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_wb24 : procedure(s: PAVIOContext; val: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure avio_wb24(s: PAVIOContext; val: Cardinal); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_wb24';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_wl16 : procedure(s: PAVIOContext; val: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure avio_wl16(s: PAVIOContext; val: Cardinal); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_wl16';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_wb16 : procedure(s: PAVIOContext; val: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure avio_wb16(s: PAVIOContext; val: Cardinal); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_wb16';
{$ENDIF API_Dynamic}


(**
 * Write a NULL-terminated string.
 * @return number of bytes written.
 *)

{$IFDEF API_Dynamic}
var avio_put_str : function(s: PAVIOContext; const str: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_put_str(s: PAVIOContext; const str: PAnsiChar): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_put_str';
{$ENDIF API_Dynamic}


(**
 * Convert an UTF-8 string to UTF-16LE and write it.
 * @param s the AVIOContext
 * @param str NULL-terminated UTF-8 string
 *
 * @return number of bytes written.
 *)

{$IFDEF API_Dynamic}
var avio_put_str16le : function(s: PAVIOContext; const str: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_put_str16le(s: PAVIOContext; const str: PAnsiChar): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_put_str16le';
{$ENDIF API_Dynamic}


(**
 * Convert an UTF-8 string to UTF-16BE and write it.
 * @param s the AVIOContext
 * @param str NULL-terminated UTF-8 string
 *
 * @return number of bytes written.
 *)

{$IFDEF API_Dynamic}
var avio_put_str16be : function(s: PAVIOContext; const str: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_put_str16be(s: PAVIOContext; const str: PAnsiChar): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_put_str16be';
{$ENDIF API_Dynamic}


(**
 * Mark the written bytestream as a specific type.
 *
 * Zero-length ranges are omitted from the output.
 *
 * @param time the stream time the current bytestream pos corresponds to
 *             (in AV_TIME_BASE units), or AV_NOPTS_VALUE if unknown or not
 *             applicable
 * @param type the kind of data written starting at the current pos
 *)

{$IFDEF API_Dynamic}
var avio_write_marker : procedure(s: PAVIOContext; time: Int64; ttype: TAVIODataMarkerType); cdecl;
{$ELSE API_Dynamic}
procedure avio_write_marker(s: PAVIOContext; time: Int64; ttype: TAVIODataMarkerType); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_write_marker';
{$ENDIF API_Dynamic}


const
(**
 * ORing this as the "whence" parameter to a seek function causes it to
 * return the filesize without seeking anywhere. Supporting this is optional.
 * If it is not supported then the seek function will return <0.
 *)
  AVSEEK_SIZE  = $10000;

(**
 * Passing this flag as the "whence" parameter to a seek function causes it to
 * seek by any means (like reopening and linear reading) or other normally unreasonable
 * means that can be extremely slow.
 * This may be ignored by the seek code.
 *)
  AVSEEK_FORCE = $20000;

(**
 * fseek() equivalent for AVIOContext.
 * @return new position or AVERROR.
 *)

{$IFDEF API_Dynamic}
var avio_seek : function(s: PAVIOContext; offset: Int64; whence: Integer): Int64; cdecl;
{$ELSE API_Dynamic}
function avio_seek(s: PAVIOContext; offset: Int64; whence: Integer): Int64; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_seek';
{$ENDIF API_Dynamic}


(**
 * Skip given number of bytes forward
 * @return new position or AVERROR.
 *)

{$IFDEF API_Dynamic}
var avio_skip : function(s: PAVIOContext; offset: Int64): Int64; cdecl;
{$ELSE API_Dynamic}
function avio_skip(s: PAVIOContext; offset: Int64): Int64; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_skip';
{$ENDIF API_Dynamic}


(**
 * ftell() equivalent for AVIOContext.
 * @return position or AVERROR.
 *)
//static av_always_inline int64_t avio_tell(AVIOContext *s)
//{
//    return avio_seek(s, 0, SEEK_CUR);
//}

(**
 * Get the filesize.
 * @return filesize or AVERROR
 *)

{$IFDEF API_Dynamic}
var avio_size : function(s: PAVIOContext): Int64; cdecl;
{$ELSE API_Dynamic}
function avio_size(s: PAVIOContext): Int64; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_size';
{$ENDIF API_Dynamic}


(**
 * feof() equivalent for AVIOContext.
 * @return non zero if and only if end of file
 *)

{$IFDEF API_Dynamic}
var avio_feof : function(s: PAVIOContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_feof(s: PAVIOContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_feof';
{$ENDIF API_Dynamic}

{$IFDEF FF_API_URL_FEOF}
(**
 * @deprecated use avio_feof()
 *)

{$IFDEF API_Dynamic}
var url_feof : function(s: PAVIOContext): Integer; cdecl;
{$ELSE API_Dynamic}
function url_feof(s: PAVIOContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'url_feof';
{$ENDIF API_Dynamic}

{$ENDIF}

(** @warning Writes up to 4 KiB per call *)

{$IFDEF API_Dynamic}
var avio_printf : function(s: PAVIOContext; const fmt: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_printf(s: PAVIOContext; const fmt: PAnsiChar): Integer; cdecl varargs; external AVFORMAT_LIBNAME name _PU + 'avio_printf';
{$ENDIF API_Dynamic}


(**
 * Force flushing of buffered data.
 *
 * For write streams, force the buffered data to be immediately written to the output,
 * without to wait to fill the internal buffer.
 *
 * For read streams, discard all currently buffered data, and advance the
 * reported file position to that of the underlying stream. This does not
 * read new data, and does not perform any seeks.
 *)

{$IFDEF API_Dynamic}
var avio_flush : procedure(s: PAVIOContext); cdecl;
{$ELSE API_Dynamic}
procedure avio_flush(s: PAVIOContext); cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_flush';
{$ENDIF API_Dynamic}


(**
 * Read size bytes from AVIOContext into buf.
 * @return number of bytes read or AVERROR
 *)

{$IFDEF API_Dynamic}
var avio_read : function(s: PAVIOContext; buf: PAnsiChar; size: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_read(s: PAVIOContext; buf: PAnsiChar; size: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_read';
{$ENDIF API_Dynamic}


(**
 * Read size bytes from AVIOContext into buf. Unlike avio_read(), this is allowed
 * to read fewer bytes than requested. The missing bytes can be read in the next
 * call. This always tries to read at least 1 byte.
 * Useful to reduce latency in certain cases.
 * @return number of bytes read or AVERROR
 *)

{$IFDEF API_Dynamic}
var avio_read_partial : function(s: PAVIOContext; buf: PByte; size: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_read_partial(s: PAVIOContext; buf: PByte; size: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_read_partial';
{$ENDIF API_Dynamic}


(**
 * @name Functions for reading from AVIOContext
 * @{
 *
 * @note return 0 if EOF, so you cannot use it if EOF handling is
 *       necessary
 *)

{$IFDEF API_Dynamic}
var avio_r8 : function(s: PAVIOContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_r8(s: PAVIOContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_r8';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_rl16 : function(s: PAVIOContext): Cardinal; cdecl;
{$ELSE API_Dynamic}
function avio_rl16(s: PAVIOContext): Cardinal; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_rl16';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_rl24 : function(s: PAVIOContext): Cardinal; cdecl;
{$ELSE API_Dynamic}
function avio_rl24(s: PAVIOContext): Cardinal; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_rl24';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_rl32 : function(s: PAVIOContext): Cardinal; cdecl;
{$ELSE API_Dynamic}
function avio_rl32(s: PAVIOContext): Cardinal; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_rl32';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_rl64 : function(s: PAVIOContext): Int64; cdecl;
{$ELSE API_Dynamic}
function avio_rl64(s: PAVIOContext): Int64; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_rl64';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_rb16 : function(s: PAVIOContext): Cardinal; cdecl;
{$ELSE API_Dynamic}
function avio_rb16(s: PAVIOContext): Cardinal; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_rb16';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_rb24 : function(s: PAVIOContext): Cardinal; cdecl;
{$ELSE API_Dynamic}
function avio_rb24(s: PAVIOContext): Cardinal; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_rb24';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_rb32 : function(s: PAVIOContext): Cardinal; cdecl;
{$ELSE API_Dynamic}
function avio_rb32(s: PAVIOContext): Cardinal; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_rb32';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_rb64 : function(s: PAVIOContext): Int64; cdecl;
{$ELSE API_Dynamic}
function avio_rb64(s: PAVIOContext): Int64; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_rb64';
{$ENDIF API_Dynamic}

(**
 * @}
 *)

(**
 * Read a string from pb into buf. The reading will terminate when either
 * a NULL character was encountered, maxlen bytes have been read, or nothing
 * more can be read from pb. The result is guaranteed to be NULL-terminated, it
 * will be truncated if buf is too small.
 * Note that the string is not interpreted or validated in any way, it
 * might get truncated in the middle of a sequence for multi-byte encodings.
 *
 * @return number of bytes read (is always <= maxlen).
 * If reading ends on EOF or error, the return value will be one more than
 * bytes actually read.
 *)

{$IFDEF API_Dynamic}
var avio_get_str : function(pb: PAVIOContext; maxlen: Integer; buf: PAnsiChar; buflen: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_get_str(pb: PAVIOContext; maxlen: Integer; buf: PAnsiChar; buflen: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_get_str';
{$ENDIF API_Dynamic}


(**
 * Read a UTF-16 string from pb and convert it to UTF-8.
 * The reading will terminate when either a null or invalid character was
 * encountered or maxlen bytes have been read.
 * @return number of bytes read (is always <= maxlen)
 *)

{$IFDEF API_Dynamic}
var avio_get_str16le : function(pb: PAVIOContext; maxlen: Integer; buf: PAnsiChar; buflen: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_get_str16le(pb: PAVIOContext; maxlen: Integer; buf: PAnsiChar; buflen: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_get_str16le';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avio_get_str16be : function(pb: PAVIOContext; maxlen: Integer; buf: PAnsiChar; buflen: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_get_str16be(pb: PAVIOContext; maxlen: Integer; buf: PAnsiChar; buflen: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_get_str16be';
{$ENDIF API_Dynamic}



const
(**
 * @name URL open modes
 * The flags argument to avio_open must be one of the following
 * constants, optionally ORed with other flags.
 * @{
 *)
  AVIO_FLAG_READ  = 1;                                        (**< read-only *)
  AVIO_FLAG_WRITE = 2;                                        (**< write-only *)
  AVIO_FLAG_READ_WRITE = (AVIO_FLAG_READ or AVIO_FLAG_WRITE); (**< read-write pseudo flag *)
(**
 * @}
 *)

(**
 * Use non-blocking mode.
 * If this flag is set, operations on the context will return
 * AVERROR(EAGAIN) if they can not be performed immediately.
 * If this flag is not set, operations on the context will never return
 * AVERROR(EAGAIN).
 * Note that this flag does not affect the opening/connecting of the
 * context. Connecting a protocol will always block if necessary (e.g. on
 * network protocols) but never hang (e.g. on busy devices).
 * Warning: non-blocking protocols is work-in-progress; this flag may be
 * silently ignored.
 *)
  AVIO_FLAG_NONBLOCK  = 8;

(**
 * Use direct mode.
 * avio_read and avio_write should if possible be satisfied directly
 * instead of going through a buffer, and avio_seek will always
 * call the underlying seek function directly.
 *)
  AVIO_FLAG_DIRECT = $8000;

(**
 * Create and initialize a AVIOContext for accessing the
 * resource indicated by url.
 * @note When the resource indicated by url has been opened in
 * read+write mode, the AVIOContext can be used only for writing.
 *
 * @param s Used to return the pointer to the created AVIOContext.
 * In case of failure the pointed to value is set to NULL.
 * @param url resource to access
 * @param flags flags which control how the resource indicated by url
 * is to be opened
 * @return >= 0 in case of success, a negative value corresponding to an
 * AVERROR code in case of failure
 *)

{$IFDEF API_Dynamic}
var avio_open : function(s: PPAVIOContext; const url: PAnsiChar; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_open(s: PPAVIOContext; const url: PAnsiChar; flags: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_open';
{$ENDIF API_Dynamic}


(**
 * Create and initialize a AVIOContext for accessing the
 * resource indicated by url.
 * @note When the resource indicated by url has been opened in
 * read+write mode, the AVIOContext can be used only for writing.
 *
 * @param s Used to return the pointer to the created AVIOContext.
 * In case of failure the pointed to value is set to NULL.
 * @param url resource to access
 * @param flags flags which control how the resource indicated by url
 * is to be opened
 * @param int_cb an interrupt callback to be used at the protocols level
 * @param options  A dictionary filled with protocol-private options. On return
 * this parameter will be destroyed and replaced with a dict containing options
 * that were not found. May be NULL.
 * @return >= 0 in case of success, a negative value corresponding to an
 * AVERROR code in case of failure
 *)

{$IFDEF API_Dynamic}
var avio_open2 : function(s: PPAVIOContext; const url: PAnsiChar; flags: Integer;
               const int_cb: PAVIOInterruptCB; options: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_open2(s: PPAVIOContext; const url: PAnsiChar; flags: Integer;
               const int_cb: PAVIOInterruptCB; options: PPAVDictionary): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_open2';
{$ENDIF API_Dynamic}


(**
 * Close the resource accessed by the AVIOContext s and free it.
 * This function can only be used if s was opened by avio_open().
 *
 * The internal buffer is automatically flushed before closing the
 * resource.
 *
 * @return 0 on success, an AVERROR < 0 on error.
 * @see avio_closep
 *)

{$IFDEF API_Dynamic}
var avio_close : function(s: PAVIOContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_close(s: PAVIOContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_close';
{$ENDIF API_Dynamic}


(**
 * Close the resource accessed by the AVIOContext *s, free it
 * and set the pointer pointing to it to NULL.
 * This function can only be used if s was opened by avio_open().
 *
 * The internal buffer is automatically flushed before closing the
 * resource.
 *
 * @return 0 on success, an AVERROR < 0 on error.
 * @see avio_close
 *)

{$IFDEF API_Dynamic}
var avio_closep : function(s: PPAVIOContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_closep(s: PPAVIOContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_closep';
{$ENDIF API_Dynamic}



(**
 * Open a write only memory stream.
 *
 * @param s new IO context
 * @return zero if no error.
 *)

{$IFDEF API_Dynamic}
var avio_open_dyn_buf : function(s: PPAVIOContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_open_dyn_buf(s: PPAVIOContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_open_dyn_buf';
{$ENDIF API_Dynamic}


(**
 * Return the written size and a pointer to the buffer.
 * The AVIOContext stream is left intact.
 * The buffer must NOT be freed.
 * No padding is added to the buffer.
 *
 * @param s IO context
 * @param pbuffer pointer to a byte buffer
 * @return the length of the byte buffer
 *)

{$IFDEF API_Dynamic}
var avio_get_dyn_buf : function(s: PAVIOContext; pbuffer: PPByte): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_get_dyn_buf(s: PAVIOContext; pbuffer: PPByte): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_get_dyn_buf';
{$ENDIF API_Dynamic}


(**
 * Return the written size and a pointer to the buffer. The buffer
 * must be freed with av_free().
 * Padding of AV_INPUT_BUFFER_PADDING_SIZE is added to the buffer.
 *
 * @param s IO context
 * @param pbuffer pointer to a byte buffer
 * @return the length of the byte buffer
 *)

{$IFDEF API_Dynamic}
var avio_close_dyn_buf : function(s: PAVIOContext; pbuffer: PPByte): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_close_dyn_buf(s: PAVIOContext; pbuffer: PPByte): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_close_dyn_buf';
{$ENDIF API_Dynamic}


(**
 * Iterate through names of available protocols.
 *
 * @param opaque A private pointer representing current protocol.
 *        It must be a pointer to NULL on first iteration and will
 *        be updated by successive calls to avio_enum_protocols.
 * @param output If set to 1, iterate over output protocols,
 *               otherwise over input protocols.
 *
 * @return A static string containing the name of current protocol or NULL
 *)

{$IFDEF API_Dynamic}
var avio_enum_protocols : function(opaque: PPointer; output: Integer): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avio_enum_protocols(opaque: PPointer; output: Integer): PAnsiChar; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_enum_protocols';
{$ENDIF API_Dynamic}


(**
 * Pause and resume playing - only meaningful if using a network streaming
 * protocol (e.g. MMS).
 *
 * @param h     IO context from which to call the read_pause function pointer
 * @param pause 1 for pause, 0 for resume
 *)

{$IFDEF API_Dynamic}
var avio_pause : function(h: PAVIOContext; pause: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_pause(h: PAVIOContext; pause: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_pause';
{$ENDIF API_Dynamic}


(**
 * Seek to a given timestamp relative to some component stream.
 * Only meaningful if using a network streaming protocol (e.g. MMS.).
 *
 * @param h IO context from which to call the seek function pointers
 * @param stream_index The stream index that the timestamp is relative to.
 *        If stream_index is (-1) the timestamp should be in AV_TIME_BASE
 *        units from the beginning of the presentation.
 *        If a stream_index >= 0 is used and the protocol does not support
 *        seeking based on component streams, the call will fail.
 * @param timestamp timestamp in AVStream.time_base units
 *        or if there is no stream specified then in AV_TIME_BASE units.
 * @param flags Optional combination of AVSEEK_FLAG_BACKWARD, AVSEEK_FLAG_BYTE
 *        and AVSEEK_FLAG_ANY. The protocol may silently ignore
 *        AVSEEK_FLAG_BACKWARD and AVSEEK_FLAG_ANY, but AVSEEK_FLAG_BYTE will
 *        fail if used and not supported.
 * @return >= 0 on success
 * @see AVInputFormat::read_seek
 *)

{$IFDEF API_Dynamic}
var avio_seek_time : function(h: PAVIOContext; stream_index: Integer;
                          timestamp: Int64; flags: Integer): Int64; cdecl;
{$ELSE API_Dynamic}
function avio_seek_time(h: PAVIOContext; stream_index: Integer;
                          timestamp: Int64; flags: Integer): Int64; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_seek_time';
{$ENDIF API_Dynamic}


(* Avoid a warning. The header can not be included because it breaks c++. *)
//struct AVBPrint;

(**
 * Read contents of h into print buffer, up to max_size bytes, or up to EOF.
 *
 * @return 0 for success (max_size bytes read or EOF reached), negative error
 * code otherwise
 *)

{$IFDEF API_Dynamic}
var avio_read_to_bprint : function(h: PAVIOContext; pb: PAVBPrint; max_size: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_read_to_bprint(h: PAVIOContext; pb: PAVBPrint; max_size: Cardinal): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_read_to_bprint';
{$ENDIF API_Dynamic}


(**
 * Accept and allocate a client context on a server context.
 * @param  s the server context
 * @param  c the client context, must be unallocated
 * @return   >= 0 on success or a negative value corresponding
 *           to an AVERROR on failure
 *)

{$IFDEF API_Dynamic}
var avio_accept : function(s: PAVIOContext; c: PPAVIOContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_accept(s: PAVIOContext; c: PPAVIOContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_accept';
{$ENDIF API_Dynamic}


(**
 * Perform one step of the protocol handshake to accept a new client.
 * This function must be called on a client returned by avio_accept() before
 * using it as a read/write context.
 * It is separate from avio_accept() because it may block.
 * A step of the handshake is defined by places where the application may
 * decide to change the proceedings.
 * For example, on a protocol with a request header and a reply header, each
 * one can constitute a step because the application may use the parameters
 * from the request to change parameters in the reply; or each individual
 * chunk of the request can constitute a step.
 * If the handshake is already finished, avio_handshake() does nothing and
 * returns 0 immediately.
 *
 * @param  c the client context to perform the handshake on
 * @return   0   on a complete and successful handshake
 *           > 0 if the handshake progressed, but is not complete
 *           < 0 for an AVERROR code
 *)

{$IFDEF API_Dynamic}
var avio_handshake : function(c: PAVIOContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avio_handshake(c: PAVIOContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avio_handshake';
{$ENDIF API_Dynamic}


function avio_tell(s: PAVIOContext): Int64;  {$IFDEF USE_INLINE}inline;{$ENDIF}


(* ****************************************************** *)
(* import libavcodec *)
(* ****************************************************** *)






(**
 * @defgroup libavc libavcodec
 * Encoding/Decoding Library
 *
 * @{
 *
 * @defgroup lavc_decoding Decoding
 * @{
 * @}
 *
 * @defgroup lavc_encoding Encoding
 * @{
 * @}
 *
 * @defgroup lavc_codec Codecs
 * @{
 * @defgroup lavc_codec_native Native Codecs
 * @{
 * @}
 * @defgroup lavc_codec_wrappers External library wrappers
 * @{
 * @}
 * @defgroup lavc_codec_hwaccel Hardware Accelerators bridge
 * @{
 * @}
 * @}
 * @defgroup lavc_internal Internal
 * @{
 * @}
 * @}
 *
 *)

(**
 * @ingroup libavc
 * @defgroup lavc_encdec send/receive encoding and decoding API overview
 * @{
 *
 * The avcodec_send_packet()/avcodec_receive_frame()/avcodec_send_frame()/
 * avcodec_receive_packet() functions provide an encode/decode API, which
 * decouples input and output.
 *
 * The API is very similar for encoding/decoding and audio/video, and works as
 * follows:
 * - Set up and open the AVCodecContext as usual.
 * - Send valid input:
 *   - For decoding, call avcodec_send_packet() to give the decoder raw
 *     compressed data in an AVPacket.
 *   - For encoding, call avcodec_send_frame() to give the encoder an AVFrame
 *     containing uncompressed audio or video.
 *   In both cases, it is recommended that AVPackets and AVFrames are
 *   refcounted, or libavcodec might have to copy the input data. (libavformat
 *   always returns refcounted AVPackets, and av_frame_get_buffer() allocates
 *   refcounted AVFrames.)
 * - Receive output in a loop. Periodically call one of the avcodec_receive_*()
 *   functions and process their output:
 *   - For decoding, call avcodec_receive_frame(). On success, it will return
 *     an AVFrame containing uncompressed audio or video data.
 *   - For encoding, call avcodec_receive_packet(). On success, it will return
 *     an AVPacket with a compressed frame.
 *   Repeat this call until it returns AVERROR(EAGAIN) or an error. The
 *   AVERROR(EAGAIN) return value means that new input data is required to
 *   return new output. In this case, continue with sending input. For each
 *   input frame/packet, the codec will typically return 1 output frame/packet,
 *   but it can also be 0 or more than 1.
 *
 * At the beginning of decoding or encoding, the codec might accept multiple
 * input frames/packets without returning a frame, until its internal buffers
 * are filled. This situation is handled transparently if you follow the steps
 * outlined above.
 *
 * In theory, sending input can result in EAGAIN - this should happen only if
 * not all output was received. You can use this to structure alternative decode
 * or encode loops other than the one suggested above. For example, you could
 * try sending new input on each iteration, and try to receive output if that
 * returns EAGAIN.
 *
 * End of stream situations. These require "flushing" (aka draining) the codec,
 * as the codec might buffer multiple frames or packets internally for
 * performance or out of necessity (consider B-frames).
 * This is handled as follows:
 * - Instead of valid input, send NULL to the avcodec_send_packet() (decoding)
 *   or avcodec_send_frame() (encoding) functions. This will enter draining
 *   mode.
 * - Call avcodec_receive_frame() (decoding) or avcodec_receive_packet()
 *   (encoding) in a loop until AVERROR_EOF is returned. The functions will
 *   not return AVERROR(EAGAIN), unless you forgot to enter draining mode.
 * - Before decoding can be resumed again, the codec has to be reset with
 *   avcodec_flush_buffers().
 *
 * Using the API as outlined above is highly recommended. But it is also
 * possible to call functions outside of this rigid schema. For example, you can
 * call avcodec_send_packet() repeatedly without calling
 * avcodec_receive_frame(). In this case, avcodec_send_packet() will succeed
 * until the codec's internal buffer has been filled up (which is typically of
 * size 1 per output frame, after initial input), and then reject input with
 * AVERROR(EAGAIN). Once it starts rejecting input, you have no choice but to
 * read at least some output.
 *
 * Not all codecs will follow a rigid and predictable dataflow; the only
 * guarantee is that an AVERROR(EAGAIN) return value on a send/receive call on
 * one end implies that a receive/send call on the other end will succeed, or
 * at least will not fail with AVERROR(EAGAIN). In general, no codec will
 * permit unlimited buffering of input or output.
 *
 * This API replaces the following legacy functions:
 * - avcodec_decode_video2() and avcodec_decode_audio4():
 *   Use avcodec_send_packet() to feed input to the decoder, then use
 *   avcodec_receive_frame() to receive decoded frames after each packet.
 *   Unlike with the old video decoding API, multiple frames might result from
 *   a packet. For audio, splitting the input packet into frames by partially
 *   decoding packets becomes transparent to the API user. You never need to
 *   feed an AVPacket to the API twice (unless it is rejected with AVERROR(EAGAIN) - then
 *   no data was read from the packet).
 *   Additionally, sending a flush/draining packet is required only once.
 * - avcodec_encode_video2()/avcodec_encode_audio2():
 *   Use avcodec_send_frame() to feed input to the encoder, then use
 *   avcodec_receive_packet() to receive encoded packets.
 *   Providing user-allocated buffers for avcodec_receive_packet() is not
 *   possible.
 * - The new API does not handle subtitles yet.
 *
 * Mixing new and old function calls on the same AVCodecContext is not allowed,
 * and will result in undefined behavior.
 *
 * Some codecs might require using the new API; using the old API will return
 * an error when calling it. All codecs support the new API.
 *
 * A codec is not allowed to return AVERROR(EAGAIN) for both sending and receiving. This
 * would be an invalid state, which could put the codec user into an endless
 * loop. The API has no concept of time either: it cannot happen that trying to
 * do avcodec_send_packet() results in AVERROR(EAGAIN), but a repeated call 1 second
 * later accepts the packet (with no other receive/flush API calls involved).
 * The API is a strict state machine, and the passage of time is not supposed
 * to influence it. Some timing-dependent behavior might still be deemed
 * acceptable in certain cases. But it must never result in both send/receive
 * returning EAGAIN at the same time at any point. It must also absolutely be
 * avoided that the current state is "unstable" and can "flip-flop" between
 * the send/receive APIs allowing progress. For example, it's not allowed that
 * the codec randomly decides that it actually wants to consume a packet now
 * instead of returning a frame, after it just returned AVERROR(EAGAIN) on an
 * avcodec_send_packet() call.
 * @}
 *)

(**
 * @defgroup lavc_core Core functions/structures.
 * @ingroup libavc
 *
 * Basic definitions, functions for querying libavcodec capabilities,
 * allocating core structures, etc.
 * @{
 *)


(**
 * Identify the syntax and semantics of the bitstream.
 * The principle is roughly:
 * Two decoders with the same ID can decode the same streams.
 * Two encoders with the same ID can encode compatible streams.
 * There may be slight deviations from the principle due to implementation
 * details.
 *
 * If you add a codec ID to this list, add it so that
 * 1. no value of an existing codec ID changes (that would break ABI),
 * 2. it is as close as possible to similar codecs
 *
 * After adding new codec IDs, do not forget to add an entry to the codec
 * descriptor list and bump libavcodec minor version.
 *)
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
const
  AV_CODEC_ID_NONE=$0;
  AV_CODEC_ID_MPEG1VIDEO=$1;
  AV_CODEC_ID_MPEG2VIDEO=$2;
{$IFDEF FF_API_XVMC}
  AV_CODEC_ID_MPEG2VIDEO_XVMC=$3;
  _AV_ID_DELTA=0;
{$ELSE}
  _AV_ID_DELTA=1;
{$ENDIF}
  AV_CODEC_ID_H261=$4-_AV_ID_DELTA;
  AV_CODEC_ID_H263=$5-_AV_ID_DELTA;
  AV_CODEC_ID_RV10=$6-_AV_ID_DELTA;
  AV_CODEC_ID_RV20=$7-_AV_ID_DELTA;
  AV_CODEC_ID_MJPEG=$8-_AV_ID_DELTA;
  AV_CODEC_ID_MJPEGB=$9-_AV_ID_DELTA;
  AV_CODEC_ID_LJPEG=$A-_AV_ID_DELTA;
  AV_CODEC_ID_SP5X=$B-_AV_ID_DELTA;
  AV_CODEC_ID_JPEGLS=$C-_AV_ID_DELTA;
  AV_CODEC_ID_MPEG4=$D-_AV_ID_DELTA;
  AV_CODEC_ID_RAWVIDEO=$E-_AV_ID_DELTA;
  AV_CODEC_ID_MSMPEG4V1=$F-_AV_ID_DELTA;
  AV_CODEC_ID_MSMPEG4V2=$10-_AV_ID_DELTA;
  AV_CODEC_ID_MSMPEG4V3=$11-_AV_ID_DELTA;
  AV_CODEC_ID_WMV1=$12-_AV_ID_DELTA;
  AV_CODEC_ID_WMV2=$13-_AV_ID_DELTA;
  AV_CODEC_ID_H263P=$14-_AV_ID_DELTA;
  AV_CODEC_ID_H263I=$15-_AV_ID_DELTA;
  AV_CODEC_ID_FLV1=$16-_AV_ID_DELTA;
  AV_CODEC_ID_SVQ1=$17-_AV_ID_DELTA;
  AV_CODEC_ID_SVQ3=$18-_AV_ID_DELTA;
  AV_CODEC_ID_DVVIDEO=$19-_AV_ID_DELTA;
  AV_CODEC_ID_HUFFYUV=$1A-_AV_ID_DELTA;
  AV_CODEC_ID_CYUV=$1B-_AV_ID_DELTA;
  AV_CODEC_ID_H264=$1C-_AV_ID_DELTA;
  AV_CODEC_ID_INDEO3=$1D-_AV_ID_DELTA;
  AV_CODEC_ID_VP3=$1E-_AV_ID_DELTA;
  AV_CODEC_ID_THEORA=$1F-_AV_ID_DELTA;
  AV_CODEC_ID_ASV1=$20-_AV_ID_DELTA;
  AV_CODEC_ID_ASV2=$21-_AV_ID_DELTA;
  AV_CODEC_ID_FFV1=$22-_AV_ID_DELTA;
  AV_CODEC_ID_4XM=$23-_AV_ID_DELTA;
  AV_CODEC_ID_VCR1=$24-_AV_ID_DELTA;
  AV_CODEC_ID_CLJR=$25-_AV_ID_DELTA;
  AV_CODEC_ID_MDEC=$26-_AV_ID_DELTA;
  AV_CODEC_ID_ROQ=$27-_AV_ID_DELTA;
  AV_CODEC_ID_INTERPLAY_VIDEO=$28-_AV_ID_DELTA;
  AV_CODEC_ID_XAN_WC3=$29-_AV_ID_DELTA;
  AV_CODEC_ID_XAN_WC4=$2A-_AV_ID_DELTA;
  AV_CODEC_ID_RPZA=$2B-_AV_ID_DELTA;
  AV_CODEC_ID_CINEPAK=$2C-_AV_ID_DELTA;
  AV_CODEC_ID_WS_VQA=$2D-_AV_ID_DELTA;
  AV_CODEC_ID_MSRLE=$2E-_AV_ID_DELTA;
  AV_CODEC_ID_MSVIDEO1=$2F-_AV_ID_DELTA;
  AV_CODEC_ID_IDCIN=$30-_AV_ID_DELTA;
  AV_CODEC_ID_8BPS=$31-_AV_ID_DELTA;
  AV_CODEC_ID_SMC=$32-_AV_ID_DELTA;
  AV_CODEC_ID_FLIC=$33-_AV_ID_DELTA;
  AV_CODEC_ID_TRUEMOTION1=$34-_AV_ID_DELTA;
  AV_CODEC_ID_VMDVIDEO=$35-_AV_ID_DELTA;
  AV_CODEC_ID_MSZH=$36-_AV_ID_DELTA;
  AV_CODEC_ID_ZLIB=$37-_AV_ID_DELTA;
  AV_CODEC_ID_QTRLE=$38-_AV_ID_DELTA;
  AV_CODEC_ID_TSCC=$39-_AV_ID_DELTA;
  AV_CODEC_ID_ULTI=$3A-_AV_ID_DELTA;
  AV_CODEC_ID_QDRAW=$3B-_AV_ID_DELTA;
  AV_CODEC_ID_VIXL=$3C-_AV_ID_DELTA;
  AV_CODEC_ID_QPEG=$3D-_AV_ID_DELTA;
  AV_CODEC_ID_PNG=$3E-_AV_ID_DELTA;
  AV_CODEC_ID_PPM=$3F-_AV_ID_DELTA;
  AV_CODEC_ID_PBM=$40-_AV_ID_DELTA;
  AV_CODEC_ID_PGM=$41-_AV_ID_DELTA;
  AV_CODEC_ID_PGMYUV=$42-_AV_ID_DELTA;
  AV_CODEC_ID_PAM=$43-_AV_ID_DELTA;
  AV_CODEC_ID_FFVHUFF=$44-_AV_ID_DELTA;
  AV_CODEC_ID_RV30=$45-_AV_ID_DELTA;
  AV_CODEC_ID_RV40=$46-_AV_ID_DELTA;
  AV_CODEC_ID_VC1=$47-_AV_ID_DELTA;
  AV_CODEC_ID_WMV3=$48-_AV_ID_DELTA;
  AV_CODEC_ID_LOCO=$49-_AV_ID_DELTA;
  AV_CODEC_ID_WNV1=$4A-_AV_ID_DELTA;
  AV_CODEC_ID_AASC=$4B-_AV_ID_DELTA;
  AV_CODEC_ID_INDEO2=$4C-_AV_ID_DELTA;
  AV_CODEC_ID_FRAPS=$4D-_AV_ID_DELTA;
  AV_CODEC_ID_TRUEMOTION2=$4E-_AV_ID_DELTA;
  AV_CODEC_ID_BMP=$4F-_AV_ID_DELTA;
  AV_CODEC_ID_CSCD=$50-_AV_ID_DELTA;
  AV_CODEC_ID_MMVIDEO=$51-_AV_ID_DELTA;
  AV_CODEC_ID_ZMBV=$52-_AV_ID_DELTA;
  AV_CODEC_ID_AVS=$53-_AV_ID_DELTA;
  AV_CODEC_ID_SMACKVIDEO=$54-_AV_ID_DELTA;
  AV_CODEC_ID_NUV=$55-_AV_ID_DELTA;
  AV_CODEC_ID_KMVC=$56-_AV_ID_DELTA;
  AV_CODEC_ID_FLASHSV=$57-_AV_ID_DELTA;
  AV_CODEC_ID_CAVS=$58-_AV_ID_DELTA;
  AV_CODEC_ID_JPEG2000=$59-_AV_ID_DELTA;
  AV_CODEC_ID_VMNC=$5A-_AV_ID_DELTA;
  AV_CODEC_ID_VP5=$5B-_AV_ID_DELTA;
  AV_CODEC_ID_VP6=$5C-_AV_ID_DELTA;
  AV_CODEC_ID_VP6F=$5D-_AV_ID_DELTA;
  AV_CODEC_ID_TARGA=$5E-_AV_ID_DELTA;
  AV_CODEC_ID_DSICINVIDEO=$5F-_AV_ID_DELTA;
  AV_CODEC_ID_TIERTEXSEQVIDEO=$60-_AV_ID_DELTA;
  AV_CODEC_ID_TIFF=$61-_AV_ID_DELTA;
  AV_CODEC_ID_GIF=$62-_AV_ID_DELTA;
  AV_CODEC_ID_DXA=$63-_AV_ID_DELTA;
  AV_CODEC_ID_DNXHD=$64-_AV_ID_DELTA;
  AV_CODEC_ID_THP=$65-_AV_ID_DELTA;
  AV_CODEC_ID_SGI=$66-_AV_ID_DELTA;
  AV_CODEC_ID_C93=$67-_AV_ID_DELTA;
  AV_CODEC_ID_BETHSOFTVID=$68-_AV_ID_DELTA;
  AV_CODEC_ID_PTX=$69-_AV_ID_DELTA;
  AV_CODEC_ID_TXD=$6A-_AV_ID_DELTA;
  AV_CODEC_ID_VP6A=$6B-_AV_ID_DELTA;
  AV_CODEC_ID_AMV=$6C-_AV_ID_DELTA;
  AV_CODEC_ID_VB=$6D-_AV_ID_DELTA;
  AV_CODEC_ID_PCX=$6E-_AV_ID_DELTA;
  AV_CODEC_ID_SUNRAST=$6F-_AV_ID_DELTA;
  AV_CODEC_ID_INDEO4=$70-_AV_ID_DELTA;
  AV_CODEC_ID_INDEO5=$71-_AV_ID_DELTA;
  AV_CODEC_ID_MIMIC=$72-_AV_ID_DELTA;
  AV_CODEC_ID_RL2=$73-_AV_ID_DELTA;
  AV_CODEC_ID_ESCAPE124=$74-_AV_ID_DELTA;
  AV_CODEC_ID_DIRAC=$75-_AV_ID_DELTA;
  AV_CODEC_ID_BFI=$76-_AV_ID_DELTA;
  AV_CODEC_ID_CMV=$77-_AV_ID_DELTA;
  AV_CODEC_ID_MOTIONPIXELS=$78-_AV_ID_DELTA;
  AV_CODEC_ID_TGV=$79-_AV_ID_DELTA;
  AV_CODEC_ID_TGQ=$7A-_AV_ID_DELTA;
  AV_CODEC_ID_TQI=$7B-_AV_ID_DELTA;
  AV_CODEC_ID_AURA=$7C-_AV_ID_DELTA;
  AV_CODEC_ID_AURA2=$7D-_AV_ID_DELTA;
  AV_CODEC_ID_V210X=$7E-_AV_ID_DELTA;
  AV_CODEC_ID_TMV=$7F-_AV_ID_DELTA;
  AV_CODEC_ID_V210=$80-_AV_ID_DELTA;
  AV_CODEC_ID_DPX=$81-_AV_ID_DELTA;
  AV_CODEC_ID_MAD=$82-_AV_ID_DELTA;
  AV_CODEC_ID_FRWU=$83-_AV_ID_DELTA;
  AV_CODEC_ID_FLASHSV2=$84-_AV_ID_DELTA;
  AV_CODEC_ID_CDGRAPHICS=$85-_AV_ID_DELTA;
  AV_CODEC_ID_R210=$86-_AV_ID_DELTA;
  AV_CODEC_ID_ANM=$87-_AV_ID_DELTA;
  AV_CODEC_ID_BINKVIDEO=$88-_AV_ID_DELTA;
  AV_CODEC_ID_IFF_ILBM=$89-_AV_ID_DELTA;
  AV_CODEC_ID_KGV1=$8A-_AV_ID_DELTA;
  AV_CODEC_ID_YOP=$8B-_AV_ID_DELTA;
  AV_CODEC_ID_VP8=$8C-_AV_ID_DELTA;
  AV_CODEC_ID_PICTOR=$8D-_AV_ID_DELTA;
  AV_CODEC_ID_ANSI=$8E-_AV_ID_DELTA;
  AV_CODEC_ID_A64_MULTI=$8F-_AV_ID_DELTA;
  AV_CODEC_ID_A64_MULTI5=$90-_AV_ID_DELTA;
  AV_CODEC_ID_R10K=$91-_AV_ID_DELTA;
  AV_CODEC_ID_MXPEG=$92-_AV_ID_DELTA;
  AV_CODEC_ID_LAGARITH=$93-_AV_ID_DELTA;
  AV_CODEC_ID_PRORES=$94-_AV_ID_DELTA;
  AV_CODEC_ID_JV=$95-_AV_ID_DELTA;
  AV_CODEC_ID_DFA=$96-_AV_ID_DELTA;
  AV_CODEC_ID_WMV3IMAGE=$97-_AV_ID_DELTA;
  AV_CODEC_ID_VC1IMAGE=$98-_AV_ID_DELTA;
  AV_CODEC_ID_UTVIDEO=$99-_AV_ID_DELTA;
  AV_CODEC_ID_BMV_VIDEO=$9A-_AV_ID_DELTA;
  AV_CODEC_ID_VBLE=$9B-_AV_ID_DELTA;
  AV_CODEC_ID_DXTORY=$9C-_AV_ID_DELTA;
  AV_CODEC_ID_V410=$9D-_AV_ID_DELTA;
  AV_CODEC_ID_XWD=$9E-_AV_ID_DELTA;
  AV_CODEC_ID_CDXL=$9F-_AV_ID_DELTA;
  AV_CODEC_ID_XBM=$100-_AV_ID_DELTA;
  AV_CODEC_ID_ZEROCODEC=$101-_AV_ID_DELTA;
  AV_CODEC_ID_MSS1=$102-_AV_ID_DELTA;
  AV_CODEC_ID_MSA1=$103-_AV_ID_DELTA;
  AV_CODEC_ID_TSCC2=$104-_AV_ID_DELTA;
  AV_CODEC_ID_MTS2=$105-_AV_ID_DELTA;
  AV_CODEC_ID_CLLC=$106-_AV_ID_DELTA;
  AV_CODEC_ID_MSS2=$107-_AV_ID_DELTA;
  AV_CODEC_ID_VP9=$108-_AV_ID_DELTA;
  AV_CODEC_ID_AIC=$109-_AV_ID_DELTA;
  AV_CODEC_ID_ESCAPE130=$10A-_AV_ID_DELTA;
  AV_CODEC_ID_G2M=$10B-_AV_ID_DELTA;
  AV_CODEC_ID_WEBP=$10C-_AV_ID_DELTA;
  AV_CODEC_ID_HNM4_VIDEO=$10D-_AV_ID_DELTA;
  AV_CODEC_ID_HEVC=$10E-_AV_ID_DELTA;
  AV_CODEC_ID_FIC=$10F-_AV_ID_DELTA;
  AV_CODEC_ID_ALIAS_PIX=$110-_AV_ID_DELTA;
  AV_CODEC_ID_BRENDER_PIX=$111-_AV_ID_DELTA;
  AV_CODEC_ID_PAF_VIDEO=$112-_AV_ID_DELTA;
  AV_CODEC_ID_EXR=$113-_AV_ID_DELTA;
  AV_CODEC_ID_VP7=$114-_AV_ID_DELTA;
  AV_CODEC_ID_SANM=$115-_AV_ID_DELTA;
  AV_CODEC_ID_SGIRLE=$116-_AV_ID_DELTA;
  AV_CODEC_ID_MVC1=$117-_AV_ID_DELTA;
  AV_CODEC_ID_MVC2=$118-_AV_ID_DELTA;
  AV_CODEC_ID_HQX=$119-_AV_ID_DELTA;
  AV_CODEC_ID_TDSC=$11A-_AV_ID_DELTA;
  AV_CODEC_ID_HQ_HQA=$11B-_AV_ID_DELTA;
  AV_CODEC_ID_HAP=$11C-_AV_ID_DELTA;
  AV_CODEC_ID_DDS=$11D-_AV_ID_DELTA;
  AV_CODEC_ID_DXV=$11E-_AV_ID_DELTA;
  AV_CODEC_ID_SCREENPRESSO=$11F-_AV_ID_DELTA;
  AV_CODEC_ID_RSCC=$120-_AV_ID_DELTA;

  AV_CODEC_ID_Y41P=$8000;
  AV_CODEC_ID_AVRP=$8001;
  AV_CODEC_ID_012V=$8002;
  AV_CODEC_ID_AVUI=$8003;
  AV_CODEC_ID_AYUV=$8004;
  AV_CODEC_ID_TARGA_Y216=$8005;
  AV_CODEC_ID_V308=$8006;
  AV_CODEC_ID_V408=$8007;
  AV_CODEC_ID_YUV4=$8008;
  AV_CODEC_ID_AVRN=$8009;
  AV_CODEC_ID_CPIA=$800A;
  AV_CODEC_ID_XFACE=$800B;
  AV_CODEC_ID_SNOW=$800C;
  AV_CODEC_ID_SMVJPEG=$800D;
  AV_CODEC_ID_APNG=$800E;
  AV_CODEC_ID_DAALA=$800F;
  AV_CODEC_ID_CFHD=$8010;
  AV_CODEC_ID_TRUEMOTION2RT=$8011;
  AV_CODEC_ID_M101=$8012;
  AV_CODEC_ID_MAGICYUV=$8013;
  AV_CODEC_ID_SHEERVIDEO=$8014;
  AV_CODEC_ID_YLC=$8015;
  AV_CODEC_ID_PSD=$8016;
  AV_CODEC_ID_PIXLET=$8017;
  AV_CODEC_ID_SPEEDHQ=$8018;
  AV_CODEC_ID_FMVC=$8019;
  AV_CODEC_ID_SCPR=$801A;
  AV_CODEC_ID_CLEARVIDEO=$801B;
  AV_CODEC_ID_XPM=$801C;
  AV_CODEC_ID_AV1=$801D;
  AV_CODEC_ID_BITPACKED=$801E;
  AV_CODEC_ID_MSCC=$801F;
  AV_CODEC_ID_SRGC=$8020;
  AV_CODEC_ID_SVG=$8021;
  AV_CODEC_ID_GDV=$8022;
  AV_CODEC_ID_FITS=$8023;

  AV_CODEC_ID_FIRST_AUDIO=$10000;
  AV_CODEC_ID_PCM_S16LE=$10000;
  AV_CODEC_ID_PCM_S16BE=$10001;
  AV_CODEC_ID_PCM_U16LE=$10002;
  AV_CODEC_ID_PCM_U16BE=$10003;
  AV_CODEC_ID_PCM_S8=$10004;
  AV_CODEC_ID_PCM_U8=$10005;
  AV_CODEC_ID_PCM_MULAW=$10006;
  AV_CODEC_ID_PCM_ALAW=$10007;
  AV_CODEC_ID_PCM_S32LE=$10008;
  AV_CODEC_ID_PCM_S32BE=$10009;
  AV_CODEC_ID_PCM_U32LE=$1000A;
  AV_CODEC_ID_PCM_U32BE=$1000B;
  AV_CODEC_ID_PCM_S24LE=$1000C;
  AV_CODEC_ID_PCM_S24BE=$1000D;
  AV_CODEC_ID_PCM_U24LE=$1000E;
  AV_CODEC_ID_PCM_U24BE=$1000F;
  AV_CODEC_ID_PCM_S24DAUD=$10010;
  AV_CODEC_ID_PCM_ZORK=$10011;
  AV_CODEC_ID_PCM_S16LE_PLANAR=$10012;
  AV_CODEC_ID_PCM_DVD=$10013;
  AV_CODEC_ID_PCM_F32BE=$10014;
  AV_CODEC_ID_PCM_F32LE=$10015;
  AV_CODEC_ID_PCM_F64BE=$10016;
  AV_CODEC_ID_PCM_F64LE=$10017;
  AV_CODEC_ID_PCM_BLURAY=$10018;
  AV_CODEC_ID_PCM_LXF=$10019;
  AV_CODEC_ID_S302M=$1001A;
  AV_CODEC_ID_PCM_S8_PLANAR=$1001B;
  AV_CODEC_ID_PCM_S24LE_PLANAR=$1001C;
  AV_CODEC_ID_PCM_S32LE_PLANAR=$1001D;
  AV_CODEC_ID_PCM_S16BE_PLANAR=$1001E;

  AV_CODEC_ID_PCM_S64LE=$10800;
  AV_CODEC_ID_PCM_S64BE=$10801;
  AV_CODEC_ID_PCM_F16LE=$10802;
  AV_CODEC_ID_PCM_F24LE=$10803;

  AV_CODEC_ID_ADPCM_IMA_QT=$11000;
  AV_CODEC_ID_ADPCM_IMA_WAV=$11001;
  AV_CODEC_ID_ADPCM_IMA_DK3=$11002;
  AV_CODEC_ID_ADPCM_IMA_DK4=$11003;
  AV_CODEC_ID_ADPCM_IMA_WS=$11004;
  AV_CODEC_ID_ADPCM_IMA_SMJPEG=$11005;
  AV_CODEC_ID_ADPCM_MS=$11006;
  AV_CODEC_ID_ADPCM_4XM=$11007;
  AV_CODEC_ID_ADPCM_XA=$11008;
  AV_CODEC_ID_ADPCM_ADX=$11009;
  AV_CODEC_ID_ADPCM_EA=$1100A;
  AV_CODEC_ID_ADPCM_G726=$1100B;
  AV_CODEC_ID_ADPCM_CT=$1100C;
  AV_CODEC_ID_ADPCM_SWF=$1100D;
  AV_CODEC_ID_ADPCM_YAMAHA=$1100E;
  AV_CODEC_ID_ADPCM_SBPRO_4=$1100F;
  AV_CODEC_ID_ADPCM_SBPRO_3=$11010;
  AV_CODEC_ID_ADPCM_SBPRO_2=$11011;
  AV_CODEC_ID_ADPCM_THP=$11012;
  AV_CODEC_ID_ADPCM_IMA_AMV=$11013;
  AV_CODEC_ID_ADPCM_EA_R1=$11014;
  AV_CODEC_ID_ADPCM_EA_R3=$11015;
  AV_CODEC_ID_ADPCM_EA_R2=$11016;
  AV_CODEC_ID_ADPCM_IMA_EA_SEAD=$11017;
  AV_CODEC_ID_ADPCM_IMA_EA_EACS=$11018;
  AV_CODEC_ID_ADPCM_EA_XAS=$11019;
  AV_CODEC_ID_ADPCM_EA_MAXIS_XA=$1101A;
  AV_CODEC_ID_ADPCM_IMA_ISS=$1101B;
  AV_CODEC_ID_ADPCM_G722=$1101C;
  AV_CODEC_ID_ADPCM_IMA_APC=$1101D;
  AV_CODEC_ID_ADPCM_VIMA=$1101E;
{$IFDEF FF_API_VIMA_DECODER}
  AV_CODEC_ID_VIMA=AV_CODEC_ID_ADPCM_VIMA;
{$ENDIF}

  AV_CODEC_ID_ADPCM_AFC=$11800;
  AV_CODEC_ID_ADPCM_IMA_OKI=$11801;
  AV_CODEC_ID_ADPCM_DTK=$11802;
  AV_CODEC_ID_ADPCM_IMA_RAD=$11803;
  AV_CODEC_ID_ADPCM_G726LE=$11804;
  AV_CODEC_ID_ADPCM_THP_LE=$11805;
  AV_CODEC_ID_ADPCM_PSX=$11806;
  AV_CODEC_ID_ADPCM_AICA=$11807;
  AV_CODEC_ID_ADPCM_IMA_DAT4=$11808;
  AV_CODEC_ID_ADPCM_MTAF=$11809;

  AV_CODEC_ID_AMR_NB=$12000;
  AV_CODEC_ID_AMR_WB=$12001;
  AV_CODEC_ID_RA_144=$13000;
  AV_CODEC_ID_RA_288=$13001;
  AV_CODEC_ID_ROQ_DPCM=$14000;
  AV_CODEC_ID_INTERPLAY_DPCM=$14001;
  AV_CODEC_ID_XAN_DPCM=$14002;
  AV_CODEC_ID_SOL_DPCM=$14003;
  AV_CODEC_ID_SDX2_DPCM=$14800;
  AV_CODEC_ID_GREMLIN_DPCM=$14801,
  AV_CODEC_ID_MP2=$15000;
  AV_CODEC_ID_MP3=$15001;
  AV_CODEC_ID_AAC=$15002;
  AV_CODEC_ID_AC3=$15003;
  AV_CODEC_ID_DTS=$15004;
  AV_CODEC_ID_VORBIS=$15005;
  AV_CODEC_ID_DVAUDIO=$15006;
  AV_CODEC_ID_WMAV1=$15007;
  AV_CODEC_ID_WMAV2=$15008;
  AV_CODEC_ID_MACE3=$15009;
  AV_CODEC_ID_MACE6=$1500A;
  AV_CODEC_ID_VMDAUDIO=$1500B;
  AV_CODEC_ID_FLAC=$1500C;
  AV_CODEC_ID_MP3ADU=$1500D;
  AV_CODEC_ID_MP3ON4=$1500E;
  AV_CODEC_ID_SHORTEN=$1500F;
  AV_CODEC_ID_ALAC=$15010;
  AV_CODEC_ID_WESTWOOD_SND1=$15011;
  AV_CODEC_ID_GSM=$15012;
  AV_CODEC_ID_QDM2=$15013;
  AV_CODEC_ID_COOK=$15014;
  AV_CODEC_ID_TRUESPEECH=$15015;
  AV_CODEC_ID_TTA=$15016;
  AV_CODEC_ID_SMACKAUDIO=$15017;
  AV_CODEC_ID_QCELP=$15018;
  AV_CODEC_ID_WAVPACK=$15019;
  AV_CODEC_ID_DSICINAUDIO=$1501A;
  AV_CODEC_ID_IMC=$1501B;
  AV_CODEC_ID_MUSEPACK7=$1501C;
  AV_CODEC_ID_MLP=$1501D;
  AV_CODEC_ID_GSM_MS=$1501E;
  AV_CODEC_ID_ATRAC3=$1501F;
{$IFDEF FF_API_VOXWARE}
  AV_CODEC_ID_VOXWARE=$15020;
  _AV_ID_DELTA_2=0;
{$ELSE}
  _AV_ID_DELTA_2=1;
{$ENDIF}
  AV_CODEC_ID_APE=$15021-_AV_ID_DELTA_2;
  AV_CODEC_ID_NELLYMOSER=$15022-_AV_ID_DELTA_2;
  AV_CODEC_ID_MUSEPACK8=$15023-_AV_ID_DELTA_2;
  AV_CODEC_ID_SPEEX=$15024-_AV_ID_DELTA_2;
  AV_CODEC_ID_WMAVOICE=$15025-_AV_ID_DELTA_2;
  AV_CODEC_ID_WMAPRO=$15026-_AV_ID_DELTA_2;
  AV_CODEC_ID_WMALOSSLESS=$15027-_AV_ID_DELTA_2;
  AV_CODEC_ID_ATRAC3P=$15028-_AV_ID_DELTA_2;
  AV_CODEC_ID_EAC3=$15029-_AV_ID_DELTA_2;
  AV_CODEC_ID_SIPR=$1502A-_AV_ID_DELTA_2;
  AV_CODEC_ID_MP1=$1502B-_AV_ID_DELTA_2;
  AV_CODEC_ID_TWINVQ=$1502C-_AV_ID_DELTA_2;
  AV_CODEC_ID_TRUEHD=$1502D-_AV_ID_DELTA_2;
  AV_CODEC_ID_MP4ALS=$1502E-_AV_ID_DELTA_2;
  AV_CODEC_ID_ATRAC1=$1502F-_AV_ID_DELTA_2;
  AV_CODEC_ID_BINKAUDIO_RDFT=$15030-_AV_ID_DELTA_2;
  AV_CODEC_ID_BINKAUDIO_DCT=$15031-_AV_ID_DELTA_2;
  AV_CODEC_ID_AAC_LATM=$15032-_AV_ID_DELTA_2;
  AV_CODEC_ID_QDMC=$15033-_AV_ID_DELTA_2;
  AV_CODEC_ID_CELT=$15034-_AV_ID_DELTA_2;
  AV_CODEC_ID_G723_1=$15035-_AV_ID_DELTA_2;
  AV_CODEC_ID_G729=$15036-_AV_ID_DELTA_2;
  AV_CODEC_ID_8SVX_EXP=$15037-_AV_ID_DELTA_2;
  AV_CODEC_ID_8SVX_FIB=$15038-_AV_ID_DELTA_2;
  AV_CODEC_ID_BMV_AUDIO=$15039-_AV_ID_DELTA_2;
  AV_CODEC_ID_RALF=$1503A-_AV_ID_DELTA_2;
  AV_CODEC_ID_IAC=$1503B-_AV_ID_DELTA_2;
  AV_CODEC_ID_ILBC=$1503C-_AV_ID_DELTA_2;
  AV_CODEC_ID_OPUS=$1503D-_AV_ID_DELTA_2;
  AV_CODEC_ID_COMFORT_NOISE=$1503E-_AV_ID_DELTA_2;
  AV_CODEC_ID_TAK=$1503F-_AV_ID_DELTA_2;
  AV_CODEC_ID_METASOUND=$15040-_AV_ID_DELTA_2;
  AV_CODEC_ID_PAF_AUDIO=$15041-_AV_ID_DELTA_2;
  AV_CODEC_ID_ON2AVC=$15042-_AV_ID_DELTA_2;
  AV_CODEC_ID_DSS_SP=$15043-_AV_ID_DELTA_2;
  AV_CODEC_ID_FFWAVESYNTH=$15800;
  AV_CODEC_ID_SONIC=$15801;
  AV_CODEC_ID_SONIC_LS=$15802;
  AV_CODEC_ID_EVRC=$15803;
  AV_CODEC_ID_SMV=$15804;
  AV_CODEC_ID_DSD_LSBF=$15805;
  AV_CODEC_ID_DSD_MSBF=$15806;
  AV_CODEC_ID_DSD_LSBF_PLANAR=$15807;
  AV_CODEC_ID_DSD_MSBF_PLANAR=$15808;
  AV_CODEC_ID_4GV=$15809;
  AV_CODEC_ID_INTERPLAY_ACM=$1580A;
  AV_CODEC_ID_XMA1=$1580B;
  AV_CODEC_ID_XMA2=$1580C;
  AV_CODEC_ID_DST=$1580D;
  AV_CODEC_ID_ATRAC3AL=$1580E;
  AV_CODEC_ID_ATRAC3PAL=$1580F;
  AV_CODEC_ID_DOLBY_E=$15810;
  AV_CODEC_ID_FIRST_SUBTITLE=$17000;
  AV_CODEC_ID_DVD_SUBTITLE=$17000;
  AV_CODEC_ID_DVB_SUBTITLE=$17001;
  AV_CODEC_ID_TEXT=$17002;
  AV_CODEC_ID_XSUB=$17003;
  AV_CODEC_ID_SSA=$17004;
  AV_CODEC_ID_MOV_TEXT=$17005;
  AV_CODEC_ID_HDMV_PGS_SUBTITLE=$17006;
  AV_CODEC_ID_DVB_TELETEXT=$17007;
  AV_CODEC_ID_SRT=$17008;
  AV_CODEC_ID_MICRODVD=$17800;
  AV_CODEC_ID_EIA_608=$17801;
  AV_CODEC_ID_JACOSUB=$17802;
  AV_CODEC_ID_SAMI=$17803;
  AV_CODEC_ID_REALTEXT=$17804;
  AV_CODEC_ID_STL=$17805;
  AV_CODEC_ID_SUBVIEWER1=$17806;
  AV_CODEC_ID_SUBVIEWER=$17807;
  AV_CODEC_ID_SUBRIP=$17808;
  AV_CODEC_ID_WEBVTT=$17809;
  AV_CODEC_ID_MPL2=$1780A;
  AV_CODEC_ID_VPLAYER=$1780B;
  AV_CODEC_ID_PJS=$1780C;
  AV_CODEC_ID_ASS=$1780D;
  AV_CODEC_ID_HDMV_TEXT_SUBTITLE=$1780E;
  AV_CODEC_ID_FIRST_UNKNOWN=$18000;
  AV_CODEC_ID_TTF=$18000;
  AV_CODEC_ID_SCTE_35=$18001;
  AV_CODEC_ID_BINTEXT=$18800;
  AV_CODEC_ID_XBIN=$18801;
  AV_CODEC_ID_IDF=$18802;
  AV_CODEC_ID_OTF=$18803;
  AV_CODEC_ID_SMPTE_KLV=$18804;
  AV_CODEC_ID_DVD_NAV=$18805;
  AV_CODEC_ID_TIMED_ID3=$18806;
  AV_CODEC_ID_BIN_DATA=$18807;
  AV_CODEC_ID_PROBE=$19000;
  AV_CODEC_ID_MPEG2TS=$20000;
  AV_CODEC_ID_MPEG4SYSTEMS=$20001;
  AV_CODEC_ID_FFMETADATA=$21000;
  AV_CODEC_ID_WRAPPED_AVFRAME=$21001;
  ME_ZERO=1;
  ME_FULL=2;
  ME_LOG=3;
  ME_PHODS=4;
  ME_EPZS=5;
  ME_X1=6;
  ME_HEX=7;
  ME_UMH=8;
  ME_ITER=9;
  ME_TESA=10;

  AVDISCARD_NONE   =-16;
  AVDISCARD_DEFAULT=  0;
  AVDISCARD_NONREF =  8;
  AVDISCARD_BIDIR  = 16;
  AVDISCARD_NONKEY = 32;
  AVDISCARD_ALL    = 48;

  AV_AUDIO_SERVICE_TYPE_MAIN              = 0;
  AV_AUDIO_SERVICE_TYPE_EFFECTS           = 1;
  AV_AUDIO_SERVICE_TYPE_VISUALLY_IMPAIRED = 2;
  AV_AUDIO_SERVICE_TYPE_HEARING_IMPAIRED  = 3;
  AV_AUDIO_SERVICE_TYPE_DIALOGUE          = 4;
  AV_AUDIO_SERVICE_TYPE_COMMENTARY        = 5;
  AV_AUDIO_SERVICE_TYPE_EMERGENCY         = 6;
  AV_AUDIO_SERVICE_TYPE_VOICE_OVER        = 7;
  AV_AUDIO_SERVICE_TYPE_KARAOKE           = 8;
  AV_AUDIO_SERVICE_TYPE_NB                = 9;
{$IFEND}

{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
type
  PAVCodecID = ^TAVCodecID;
  TAVCodecID = Integer;
{$ELSE}
type
  PAVCodecID = ^TAVCodecID;
  TAVCodecID = (
    AV_CODEC_ID_NONE,

    (* video codecs *)
    AV_CODEC_ID_MPEG1VIDEO,
    AV_CODEC_ID_MPEG2VIDEO,      ///< preferred ID for MPEG-1/2 video decoding
{$IFDEF FF_API_XVMC}
    AV_CODEC_ID_MPEG2VIDEO_XVMC,
{$ENDIF}
    AV_CODEC_ID_H261,
    AV_CODEC_ID_H263,
    AV_CODEC_ID_RV10,
    AV_CODEC_ID_RV20,
    AV_CODEC_ID_MJPEG,
    AV_CODEC_ID_MJPEGB,
    AV_CODEC_ID_LJPEG,
    AV_CODEC_ID_SP5X,
    AV_CODEC_ID_JPEGLS,
    AV_CODEC_ID_MPEG4,
    AV_CODEC_ID_RAWVIDEO,
    AV_CODEC_ID_MSMPEG4V1,
    AV_CODEC_ID_MSMPEG4V2,
    AV_CODEC_ID_MSMPEG4V3,
    AV_CODEC_ID_WMV1,
    AV_CODEC_ID_WMV2,
    AV_CODEC_ID_H263P,
    AV_CODEC_ID_H263I,
    AV_CODEC_ID_FLV1,
    AV_CODEC_ID_SVQ1,
    AV_CODEC_ID_SVQ3,
    AV_CODEC_ID_DVVIDEO,
    AV_CODEC_ID_HUFFYUV,
    AV_CODEC_ID_CYUV,
    AV_CODEC_ID_H264,
    AV_CODEC_ID_INDEO3,
    AV_CODEC_ID_VP3,
    AV_CODEC_ID_THEORA,
    AV_CODEC_ID_ASV1,
    AV_CODEC_ID_ASV2,
    AV_CODEC_ID_FFV1,
    AV_CODEC_ID_4XM,
    AV_CODEC_ID_VCR1,
    AV_CODEC_ID_CLJR,
    AV_CODEC_ID_MDEC,
    AV_CODEC_ID_ROQ,
    AV_CODEC_ID_INTERPLAY_VIDEO,
    AV_CODEC_ID_XAN_WC3,
    AV_CODEC_ID_XAN_WC4,
    AV_CODEC_ID_RPZA,
    AV_CODEC_ID_CINEPAK,
    AV_CODEC_ID_WS_VQA,
    AV_CODEC_ID_MSRLE,
    AV_CODEC_ID_MSVIDEO1,
    AV_CODEC_ID_IDCIN,
    AV_CODEC_ID_8BPS,
    AV_CODEC_ID_SMC,
    AV_CODEC_ID_FLIC,
    AV_CODEC_ID_TRUEMOTION1,
    AV_CODEC_ID_VMDVIDEO,
    AV_CODEC_ID_MSZH,
    AV_CODEC_ID_ZLIB,
    AV_CODEC_ID_QTRLE,
    AV_CODEC_ID_TSCC,
    AV_CODEC_ID_ULTI,
    AV_CODEC_ID_QDRAW,
    AV_CODEC_ID_VIXL,
    AV_CODEC_ID_QPEG,
    AV_CODEC_ID_PNG,
    AV_CODEC_ID_PPM,
    AV_CODEC_ID_PBM,
    AV_CODEC_ID_PGM,
    AV_CODEC_ID_PGMYUV,
    AV_CODEC_ID_PAM,
    AV_CODEC_ID_FFVHUFF,
    AV_CODEC_ID_RV30,
    AV_CODEC_ID_RV40,
    AV_CODEC_ID_VC1,
    AV_CODEC_ID_WMV3,
    AV_CODEC_ID_LOCO,
    AV_CODEC_ID_WNV1,
    AV_CODEC_ID_AASC,
    AV_CODEC_ID_INDEO2,
    AV_CODEC_ID_FRAPS,
    AV_CODEC_ID_TRUEMOTION2,
    AV_CODEC_ID_BMP,
    AV_CODEC_ID_CSCD,
    AV_CODEC_ID_MMVIDEO,
    AV_CODEC_ID_ZMBV,
    AV_CODEC_ID_AVS,
    AV_CODEC_ID_SMACKVIDEO,
    AV_CODEC_ID_NUV,
    AV_CODEC_ID_KMVC,
    AV_CODEC_ID_FLASHSV,
    AV_CODEC_ID_CAVS,
    AV_CODEC_ID_JPEG2000,
    AV_CODEC_ID_VMNC,
    AV_CODEC_ID_VP5,
    AV_CODEC_ID_VP6,
    AV_CODEC_ID_VP6F,
    AV_CODEC_ID_TARGA,
    AV_CODEC_ID_DSICINVIDEO,
    AV_CODEC_ID_TIERTEXSEQVIDEO,
    AV_CODEC_ID_TIFF,
    AV_CODEC_ID_GIF,
    AV_CODEC_ID_DXA,
    AV_CODEC_ID_DNXHD,
    AV_CODEC_ID_THP,
    AV_CODEC_ID_SGI,
    AV_CODEC_ID_C93,
    AV_CODEC_ID_BETHSOFTVID,
    AV_CODEC_ID_PTX,
    AV_CODEC_ID_TXD,
    AV_CODEC_ID_VP6A,
    AV_CODEC_ID_AMV,
    AV_CODEC_ID_VB,
    AV_CODEC_ID_PCX,
    AV_CODEC_ID_SUNRAST,
    AV_CODEC_ID_INDEO4,
    AV_CODEC_ID_INDEO5,
    AV_CODEC_ID_MIMIC,
    AV_CODEC_ID_RL2,
    AV_CODEC_ID_ESCAPE124,
    AV_CODEC_ID_DIRAC,
    AV_CODEC_ID_BFI,
    AV_CODEC_ID_CMV,
    AV_CODEC_ID_MOTIONPIXELS,
    AV_CODEC_ID_TGV,
    AV_CODEC_ID_TGQ,
    AV_CODEC_ID_TQI,
    AV_CODEC_ID_AURA,
    AV_CODEC_ID_AURA2,
    AV_CODEC_ID_V210X,
    AV_CODEC_ID_TMV,
    AV_CODEC_ID_V210,
    AV_CODEC_ID_DPX,
    AV_CODEC_ID_MAD,
    AV_CODEC_ID_FRWU,
    AV_CODEC_ID_FLASHSV2,
    AV_CODEC_ID_CDGRAPHICS,
    AV_CODEC_ID_R210,
    AV_CODEC_ID_ANM,
    AV_CODEC_ID_BINKVIDEO,
    AV_CODEC_ID_IFF_ILBM,
    AV_CODEC_ID_KGV1,
    AV_CODEC_ID_YOP,
    AV_CODEC_ID_VP8,
    AV_CODEC_ID_PICTOR,
    AV_CODEC_ID_ANSI,
    AV_CODEC_ID_A64_MULTI,
    AV_CODEC_ID_A64_MULTI5,
    AV_CODEC_ID_R10K,
    AV_CODEC_ID_MXPEG,
    AV_CODEC_ID_LAGARITH,
    AV_CODEC_ID_PRORES,
    AV_CODEC_ID_JV,
    AV_CODEC_ID_DFA,
    AV_CODEC_ID_WMV3IMAGE,
    AV_CODEC_ID_VC1IMAGE,
    AV_CODEC_ID_UTVIDEO,
    AV_CODEC_ID_BMV_VIDEO,
    AV_CODEC_ID_VBLE,
    AV_CODEC_ID_DXTORY,
    AV_CODEC_ID_V410,
    AV_CODEC_ID_XWD,
    AV_CODEC_ID_CDXL,
    AV_CODEC_ID_XBM,
    AV_CODEC_ID_ZEROCODEC,
    AV_CODEC_ID_MSS1,
    AV_CODEC_ID_MSA1,
    AV_CODEC_ID_TSCC2,
    AV_CODEC_ID_MTS2,
    AV_CODEC_ID_CLLC,
    AV_CODEC_ID_MSS2,
    AV_CODEC_ID_VP9,
    AV_CODEC_ID_AIC,
    AV_CODEC_ID_ESCAPE130,
    AV_CODEC_ID_G2M,
    AV_CODEC_ID_WEBP,
    AV_CODEC_ID_HNM4_VIDEO,
    AV_CODEC_ID_HEVC,
    AV_CODEC_ID_FIC,
    AV_CODEC_ID_ALIAS_PIX,
    AV_CODEC_ID_BRENDER_PIX,
    AV_CODEC_ID_PAF_VIDEO,
    AV_CODEC_ID_EXR,
    AV_CODEC_ID_VP7,
    AV_CODEC_ID_SANM,
    AV_CODEC_ID_SGIRLE,
    AV_CODEC_ID_MVC1,
    AV_CODEC_ID_MVC2,
    AV_CODEC_ID_HQX,
    AV_CODEC_ID_TDSC,
    AV_CODEC_ID_HQ_HQA,
    AV_CODEC_ID_HAP,
    AV_CODEC_ID_DDS,
    AV_CODEC_ID_DXV,
    AV_CODEC_ID_SCREENPRESSO,
    AV_CODEC_ID_RSCC,

    AV_CODEC_ID_Y41P = $8000,
    AV_CODEC_ID_AVRP,
    AV_CODEC_ID_012V,
    AV_CODEC_ID_AVUI,
    AV_CODEC_ID_AYUV,
    AV_CODEC_ID_TARGA_Y216,
    AV_CODEC_ID_V308,
    AV_CODEC_ID_V408,
    AV_CODEC_ID_YUV4,
    AV_CODEC_ID_AVRN,
    AV_CODEC_ID_CPIA,
    AV_CODEC_ID_XFACE,
    AV_CODEC_ID_SNOW,
    AV_CODEC_ID_SMVJPEG,
    AV_CODEC_ID_APNG,
    AV_CODEC_ID_DAALA,
    AV_CODEC_ID_CFHD,
    AV_CODEC_ID_TRUEMOTION2RT,
    AV_CODEC_ID_M101,
    AV_CODEC_ID_MAGICYUV,
    AV_CODEC_ID_SHEERVIDEO,
    AV_CODEC_ID_YLC,
    AV_CODEC_ID_PSD,
    AV_CODEC_ID_PIXLET,
    AV_CODEC_ID_SPEEDHQ,
    AV_CODEC_ID_FMVC,
    AV_CODEC_ID_SCPR,
    AV_CODEC_ID_CLEARVIDEO,
    AV_CODEC_ID_XPM,
    AV_CODEC_ID_AV1,
    AV_CODEC_ID_BITPACKED,
    AV_CODEC_ID_MSCC,
    AV_CODEC_ID_SRGC,
    AV_CODEC_ID_SVG,
    AV_CODEC_ID_GDV,
    AV_CODEC_ID_FITS,

    (* various PCM "codecs" *)
{$IFNDEF FPC}
    AV_CODEC_ID_FIRST_AUDIO = $10000,     ///< A dummy id pointing at the start of audio codecs
{$ENDIF}
    AV_CODEC_ID_PCM_S16LE = $10000,
    AV_CODEC_ID_PCM_S16BE,
    AV_CODEC_ID_PCM_U16LE,
    AV_CODEC_ID_PCM_U16BE,
    AV_CODEC_ID_PCM_S8,
    AV_CODEC_ID_PCM_U8,
    AV_CODEC_ID_PCM_MULAW,
    AV_CODEC_ID_PCM_ALAW,
    AV_CODEC_ID_PCM_S32LE,
    AV_CODEC_ID_PCM_S32BE,
    AV_CODEC_ID_PCM_U32LE,
    AV_CODEC_ID_PCM_U32BE,
    AV_CODEC_ID_PCM_S24LE,
    AV_CODEC_ID_PCM_S24BE,
    AV_CODEC_ID_PCM_U24LE,
    AV_CODEC_ID_PCM_U24BE,
    AV_CODEC_ID_PCM_S24DAUD,
    AV_CODEC_ID_PCM_ZORK,
    AV_CODEC_ID_PCM_S16LE_PLANAR,
    AV_CODEC_ID_PCM_DVD,
    AV_CODEC_ID_PCM_F32BE,
    AV_CODEC_ID_PCM_F32LE,
    AV_CODEC_ID_PCM_F64BE,
    AV_CODEC_ID_PCM_F64LE,
    AV_CODEC_ID_PCM_BLURAY,
    AV_CODEC_ID_PCM_LXF,
    AV_CODEC_ID_S302M,
    AV_CODEC_ID_PCM_S8_PLANAR,
    AV_CODEC_ID_PCM_S24LE_PLANAR,
    AV_CODEC_ID_PCM_S32LE_PLANAR,
    AV_CODEC_ID_PCM_S16BE_PLANAR,

    AV_CODEC_ID_PCM_S64LE = $10800,
    AV_CODEC_ID_PCM_S64BE,
    AV_CODEC_ID_PCM_F16LE,
    AV_CODEC_ID_PCM_F24LE,

    (* various ADPCM codecs *)
    AV_CODEC_ID_ADPCM_IMA_QT = $11000,
    AV_CODEC_ID_ADPCM_IMA_WAV,
    AV_CODEC_ID_ADPCM_IMA_DK3,
    AV_CODEC_ID_ADPCM_IMA_DK4,
    AV_CODEC_ID_ADPCM_IMA_WS,
    AV_CODEC_ID_ADPCM_IMA_SMJPEG,
    AV_CODEC_ID_ADPCM_MS,
    AV_CODEC_ID_ADPCM_4XM,
    AV_CODEC_ID_ADPCM_XA,
    AV_CODEC_ID_ADPCM_ADX,
    AV_CODEC_ID_ADPCM_EA,
    AV_CODEC_ID_ADPCM_G726,
    AV_CODEC_ID_ADPCM_CT,
    AV_CODEC_ID_ADPCM_SWF,
    AV_CODEC_ID_ADPCM_YAMAHA,
    AV_CODEC_ID_ADPCM_SBPRO_4,
    AV_CODEC_ID_ADPCM_SBPRO_3,
    AV_CODEC_ID_ADPCM_SBPRO_2,
    AV_CODEC_ID_ADPCM_THP,
    AV_CODEC_ID_ADPCM_IMA_AMV,
    AV_CODEC_ID_ADPCM_EA_R1,
    AV_CODEC_ID_ADPCM_EA_R3,
    AV_CODEC_ID_ADPCM_EA_R2,
    AV_CODEC_ID_ADPCM_IMA_EA_SEAD,
    AV_CODEC_ID_ADPCM_IMA_EA_EACS,
    AV_CODEC_ID_ADPCM_EA_XAS,
    AV_CODEC_ID_ADPCM_EA_MAXIS_XA,
    AV_CODEC_ID_ADPCM_IMA_ISS,
    AV_CODEC_ID_ADPCM_G722,
    AV_CODEC_ID_ADPCM_IMA_APC,
    AV_CODEC_ID_ADPCM_VIMA,

    AV_CODEC_ID_ADPCM_AFC = $11800,
    AV_CODEC_ID_ADPCM_IMA_OKI,
    AV_CODEC_ID_ADPCM_DTK,
    AV_CODEC_ID_ADPCM_IMA_RAD,
    AV_CODEC_ID_ADPCM_G726LE,
    AV_CODEC_ID_ADPCM_THP_LE,
    AV_CODEC_ID_ADPCM_PSX,
    AV_CODEC_ID_ADPCM_AICA,
    AV_CODEC_ID_ADPCM_IMA_DAT4,
    AV_CODEC_ID_ADPCM_MTAF,

    (* AMR *)
    AV_CODEC_ID_AMR_NB = $12000,
    AV_CODEC_ID_AMR_WB,

    (* RealAudio codecs*)
    AV_CODEC_ID_RA_144 = $13000,
    AV_CODEC_ID_RA_288,

    (* various DPCM codecs *)
    AV_CODEC_ID_ROQ_DPCM = $14000,
    AV_CODEC_ID_INTERPLAY_DPCM,
    AV_CODEC_ID_XAN_DPCM,
    AV_CODEC_ID_SOL_DPCM,

    AV_CODEC_ID_SDX2_DPCM = $14800,
    AV_CODEC_ID_GREMLIN_DPCM,

    (* audio codecs *)
    AV_CODEC_ID_MP2 = $15000,
    AV_CODEC_ID_MP3,          ///< preferred ID for decoding MPEG audio layer 1, 2 or 3
    AV_CODEC_ID_AAC,
    AV_CODEC_ID_AC3,
    AV_CODEC_ID_DTS,
    AV_CODEC_ID_VORBIS,
    AV_CODEC_ID_DVAUDIO,
    AV_CODEC_ID_WMAV1,
    AV_CODEC_ID_WMAV2,
    AV_CODEC_ID_MACE3,
    AV_CODEC_ID_MACE6,
    AV_CODEC_ID_VMDAUDIO,
    AV_CODEC_ID_FLAC,
    AV_CODEC_ID_MP3ADU,
    AV_CODEC_ID_MP3ON4,
    AV_CODEC_ID_SHORTEN,
    AV_CODEC_ID_ALAC,
    AV_CODEC_ID_WESTWOOD_SND1,
    AV_CODEC_ID_GSM,           ///< as in Berlin toast format
    AV_CODEC_ID_QDM2,
    AV_CODEC_ID_COOK,
    AV_CODEC_ID_TRUESPEECH,
    AV_CODEC_ID_TTA,
    AV_CODEC_ID_SMACKAUDIO,
    AV_CODEC_ID_QCELP,
    AV_CODEC_ID_WAVPACK,
    AV_CODEC_ID_DSICINAUDIO,
    AV_CODEC_ID_IMC,
    AV_CODEC_ID_MUSEPACK7,
    AV_CODEC_ID_MLP,
    AV_CODEC_ID_GSM_MS, (* as found in WAV *)
    AV_CODEC_ID_ATRAC3,
{$IFDEF FF_API_VOXWARE}
    AV_CODEC_ID_VOXWARE,
{$ENDIF}
    AV_CODEC_ID_APE,
    AV_CODEC_ID_NELLYMOSER,
    AV_CODEC_ID_MUSEPACK8,
    AV_CODEC_ID_SPEEX,
    AV_CODEC_ID_WMAVOICE,
    AV_CODEC_ID_WMAPRO,
    AV_CODEC_ID_WMALOSSLESS,
    AV_CODEC_ID_ATRAC3P,
    AV_CODEC_ID_EAC3,
    AV_CODEC_ID_SIPR,
    AV_CODEC_ID_MP1,
    AV_CODEC_ID_TWINVQ,
    AV_CODEC_ID_TRUEHD,
    AV_CODEC_ID_MP4ALS,
    AV_CODEC_ID_ATRAC1,
    AV_CODEC_ID_BINKAUDIO_RDFT,
    AV_CODEC_ID_BINKAUDIO_DCT,
    AV_CODEC_ID_AAC_LATM,
    AV_CODEC_ID_QDMC,
    AV_CODEC_ID_CELT,
    AV_CODEC_ID_G723_1,
    AV_CODEC_ID_G729,
    AV_CODEC_ID_8SVX_EXP,
    AV_CODEC_ID_8SVX_FIB,
    AV_CODEC_ID_BMV_AUDIO,
    AV_CODEC_ID_RALF,
    AV_CODEC_ID_IAC,
    AV_CODEC_ID_ILBC,
    AV_CODEC_ID_OPUS,
    AV_CODEC_ID_COMFORT_NOISE,
    AV_CODEC_ID_TAK,
    AV_CODEC_ID_METASOUND,
    AV_CODEC_ID_PAF_AUDIO,
    AV_CODEC_ID_ON2AVC,
    AV_CODEC_ID_DSS_SP,

    AV_CODEC_ID_FFWAVESYNTH = $15800,
    AV_CODEC_ID_SONIC,
    AV_CODEC_ID_SONIC_LS,
    AV_CODEC_ID_EVRC,
    AV_CODEC_ID_SMV,
    AV_CODEC_ID_DSD_LSBF,
    AV_CODEC_ID_DSD_MSBF,
    AV_CODEC_ID_DSD_LSBF_PLANAR,
    AV_CODEC_ID_DSD_MSBF_PLANAR,
    AV_CODEC_ID_4GV,
    AV_CODEC_ID_INTERPLAY_ACM,
    AV_CODEC_ID_XMA1,
    AV_CODEC_ID_XMA2,
    AV_CODEC_ID_DST,
    AV_CODEC_ID_ATRAC3AL,
    AV_CODEC_ID_ATRAC3PAL,
    AV_CODEC_ID_DOLBY_E,

    (* subtitle codecs *)
{$IFNDEF FPC}
    AV_CODEC_ID_FIRST_SUBTITLE = $17000,          ///< A dummy ID pointing at the start of subtitle codecs.
{$ENDIF}
    AV_CODEC_ID_DVD_SUBTITLE = $17000,
    AV_CODEC_ID_DVB_SUBTITLE,
    AV_CODEC_ID_TEXT,          ///< raw UTF-8 text
    AV_CODEC_ID_XSUB,
    AV_CODEC_ID_SSA,
    AV_CODEC_ID_MOV_TEXT,
    AV_CODEC_ID_HDMV_PGS_SUBTITLE,
    AV_CODEC_ID_DVB_TELETEXT,
    AV_CODEC_ID_SRT,

    AV_CODEC_ID_MICRODVD   = $17800,
    AV_CODEC_ID_EIA_608,
    AV_CODEC_ID_JACOSUB,
    AV_CODEC_ID_SAMI,
    AV_CODEC_ID_REALTEXT,
    AV_CODEC_ID_STL,
    AV_CODEC_ID_SUBVIEWER1,
    AV_CODEC_ID_SUBVIEWER,
    AV_CODEC_ID_SUBRIP,
    AV_CODEC_ID_WEBVTT,
    AV_CODEC_ID_MPL2,
    AV_CODEC_ID_VPLAYER,
    AV_CODEC_ID_PJS,
    AV_CODEC_ID_ASS,
    AV_CODEC_ID_HDMV_TEXT_SUBTITLE,

    (* other specific kind of codecs (generally used for attachments) *)
{$IFNDEF FPC}
    AV_CODEC_ID_FIRST_UNKNOWN = $18000,           ///< A dummy ID pointing at the start of various fake codecs.
{$ENDIF}
    AV_CODEC_ID_TTF = $18000,

    AV_CODEC_ID_SCTE_35, ///< Contain timestamp estimated through PCR of program stream.
    AV_CODEC_ID_BINTEXT    = $18800,
    AV_CODEC_ID_XBIN,
    AV_CODEC_ID_IDF,
    AV_CODEC_ID_OTF,
    AV_CODEC_ID_SMPTE_KLV,
    AV_CODEC_ID_DVD_NAV,
    AV_CODEC_ID_TIMED_ID3,
    AV_CODEC_ID_BIN_DATA,

    AV_CODEC_ID_PROBE = $19000, ///< codec_id is not known (like AV_CODEC_ID_NONE) but lavf should attempt to identify it

    AV_CODEC_ID_MPEG2TS = $20000, (**< _FAKE_ codec to indicate a raw MPEG-2 TS
                                * stream (only used by libavformat) *)
    AV_CODEC_ID_MPEG4SYSTEMS = $20001, (**< _FAKE_ codec to indicate a MPEG-4 Systems
                                * stream (only used by libavformat) *)
    AV_CODEC_ID_FFMETADATA = $21000,   ///< Dummy codec for streams containing only metadata information.
    AV_CODEC_ID_WRAPPED_AVFRAME = $21001 ///< Passthrough codec, AVFrames wrapped in AVPacket
  );
{$IFEND}

const
  AV_CODEC_ID_H265 = AV_CODEC_ID_HEVC;
  AV_CODEC_ID_IFF_BYTERUN1 = AV_CODEC_ID_IFF_ILBM;

{$IFDEF FF_API_VIMA_DECODER}
  AV_CODEC_ID_VIMA=AV_CODEC_ID_ADPCM_VIMA;
{$ENDIF}
{$IFDEF FPC}
  AV_CODEC_ID_FIRST_UNKNOWN = AV_CODEC_ID_TTF;           ///< A dummy ID pointing at the start of various fake codecs.
{$ENDIF}

(**
 * This struct describes the properties of a single codec described by an
 * AVCodecID.
 * @see avcodec_descriptor_get()
 *)
type
(**
 * AVProfile.
 *)
  PAVProfile = ^TAVProfile;
  TAVProfile = record
    profile: Integer;
    name: PAnsiChar; ///< short name for the profile
  end;

  PAVCodecDescriptor = ^TAVCodecDescriptor;
  TAVCodecDescriptor = record
    id: TAVCodecID;
    ttype: TAVMediaType;
    (**
     * Name of the codec described by this descriptor. It is non-empty and
     * unique for each codec descriptor. It should contain alphanumeric
     * characters and '_' only.
     *)
    name: PAnsiChar;
    (**
     * A more descriptive name for this codec. May be NULL.
     *)
    long_name: PAnsiChar;
    (**
     * Codec properties, a combination of AV_CODEC_PROP_* flags.
     *)
    props: Integer;
    (**
     * MIME type(s) associated with the codec.
     * May be NULL; if not, a NULL-terminated array of MIME types.
     * The first item is always non-NULL and is the preferred MIME type.
     *)
    //const char *const *mime_types;
    mime_types: PPAnsiChar;
    (**
     * If non-NULL, an array of profiles recognized for this codec.
     * Terminated with FF_PROFILE_UNKNOWN.
     *)
    profiles: PAVProfile;
  end;

const
(**
 * Codec uses only intra compression.
 * Video and audio codecs only.
 *)
  AV_CODEC_PROP_INTRA_ONLY    = (1 shl 0);
(**
 * Codec supports lossy compression. Audio and video codecs only.
 * @note a codec may support both lossy and lossless
 * compression modes
 *)
  AV_CODEC_PROP_LOSSY         = (1 shl 1);
(**
 * Codec supports lossless compression. Audio and video codecs only.
 *)
  AV_CODEC_PROP_LOSSLESS      = (1 shl 2);
(**
 * Codec supports frame reordering. That is, the coded order (the order in which
 * the encoded packets are output by the encoders / stored / input to the
 * decoders) may be different from the presentation order of the corresponding
 * frames.
 *
 * For codecs that do not have this property set, PTS and DTS should always be
 * equal.
 *)
  AV_CODEC_PROP_REORDER       = (1 shl 3);
(**
 * Subtitle codec is bitmap based
 * Decoded AVSubtitle data can be read from the AVSubtitleRect->pict field.
 *)
  AV_CODEC_PROP_BITMAP_SUB    = (1 shl 16);
(**
 * Subtitle codec is text based.
 * Decoded AVSubtitle data can be read from the AVSubtitleRect->ass field.
 *)
  AV_CODEC_PROP_TEXT_SUB      = (1 shl 17);

(**
 * @ingroup lavc_decoding
 * Required number of additionally allocated bytes at the end of the input bitstream for decoding.
 * This is mainly needed because some optimized bitstream readers read
 * 32 or 64 bit at once and could read over the end.<br>
 * Note: If the first 23 bits of the additional bytes are not 0, then damaged
 * MPEG bitstreams could cause overread and segfault.
 *)
  AV_INPUT_BUFFER_PADDING_SIZE = 32;

(**
 * @ingroup lavc_encoding
 * minimum encoding buffer size
 * Used to avoid some checks during header writing.
 *)
  AV_INPUT_BUFFER_MIN_SIZE = 16384;

{$IFDEF FF_API_WITHOUT_PREFIX}
(**
 * @deprecated use AV_INPUT_BUFFER_PADDING_SIZE instead
 *)
  FF_INPUT_BUFFER_PADDING_SIZE = 32;

(**
 * @deprecated use AV_INPUT_BUFFER_MIN_SIZE instead
 *)
  FF_MIN_BUFFER_SIZE = 16384;
{$ENDIF} (* FF_API_WITHOUT_PREFIX *)

(**
 * @ingroup lavc_encoding
 * motion estimation type.
 * @deprecated use codec private option instead
 *)
type
{$IFDEF FF_API_MOTION_EST}
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TMotion_Est_ID = Integer;
{$ELSE}
  TMotion_Est_ID = (
    ME_ZERO = 1,    ///< no search, that is use 0,0 vector whenever one is needed
    ME_FULL,
    ME_LOG,
    ME_PHODS,
    ME_EPZS,        ///< enhanced predictive zonal search
    ME_X1,          ///< reserved for experiments
    ME_HEX,         ///< hexagon based search
    ME_UMH,         ///< uneven multi-hexagon search
    ME_TESA,        ///< transformed exhaustive search algorithm
    ME_ITER=50      ///< iterative search
  );
{$IFEND}
{$ENDIF}

(**
 * @ingroup lavc_decoding
 *)
{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVDiscard = Integer;
{$ELSE}
  TAVDiscard = (
    (* We leave some space between them for extensions (drop some
     * keyframes for intra-only or drop just some bidir frames). *)
    AVDISCARD_NONE    =-16, ///< discard nothing
    AVDISCARD_DEFAULT =  0, ///< discard useless packets like 0 size packets in avi
    AVDISCARD_NONREF  =  8, ///< discard all non reference
    AVDISCARD_BIDIR   = 16, ///< discard all bidirectional frames
    AVDISCARD_NONINTRA= 24, ///< discard all non intra frames
    AVDISCARD_NONKEY  = 32, ///< discard all frames except keyframes
    AVDISCARD_ALL     = 48  ///< discard all
  );
{$IFEND}

{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVAudioServiceType = Integer;
{$ELSE}
  TAVAudioServiceType = (
    AV_AUDIO_SERVICE_TYPE_MAIN              = 0,
    AV_AUDIO_SERVICE_TYPE_EFFECTS           = 1,
    AV_AUDIO_SERVICE_TYPE_VISUALLY_IMPAIRED = 2,
    AV_AUDIO_SERVICE_TYPE_HEARING_IMPAIRED  = 3,
    AV_AUDIO_SERVICE_TYPE_DIALOGUE          = 4,
    AV_AUDIO_SERVICE_TYPE_COMMENTARY        = 5,
    AV_AUDIO_SERVICE_TYPE_EMERGENCY         = 6,
    AV_AUDIO_SERVICE_TYPE_VOICE_OVER        = 7,
    AV_AUDIO_SERVICE_TYPE_KARAOKE           = 8,
    AV_AUDIO_SERVICE_TYPE_NB                     ///< Not part of ABI
  );
{$IFEND}

(**
 * @ingroup lavc_encoding
 *)
  PRcOverride = ^TRcOverride;
  TRcOverride = record // SizeOf = 16
    start_frame: Integer;
    end_frame: Integer;
    qscale: Integer; // If this is 0 then quality_factor will be used instead.
    quality_factor: Single;
  end;

const
{$IFDEF FF_API_MAX_BFRAMES}
(**
 * @deprecated there is no libavcodec-wide limit on the number of B-frames
 *)
  FF_MAX_B_FRAMES = 16;
{$ENDIF}

(* encoding support
   These flags can be passed in AVCodecContext.flags before initialization.
   Note: Not everything is supported yet.
*)

(**
 * Allow decoders to produce frames with data planes that are not aligned
 * to CPU requirements (e.g. due to cropping).
 *)
  AV_CODEC_FLAG_UNALIGNED       = (1 shl  0);
(**
 * Use fixed qscale.
 *)
  AV_CODEC_FLAG_QSCALE          = (1 shl  1);
(**
 * 4 MV per MB allowed / advanced prediction for H.263.
 *)
  AV_CODEC_FLAG_4MV             = (1 shl  2);
(**
 * Output even those frames that might be corrupted.
 *)
  AV_CODEC_FLAG_OUTPUT_CORRUPT  = (1 shl  3);
(**
 * Use qpel MC.
 *)
  AV_CODEC_FLAG_QPEL            = (1 shl  4);
(**
 * Use internal 2pass ratecontrol in first pass mode.
 *)
  AV_CODEC_FLAG_PASS1           = (1 shl  9);
(**
 * Use internal 2pass ratecontrol in second pass mode.
 *)
  AV_CODEC_FLAG_PASS2           = (1 shl 10);
(**
 * loop filter.
 *)
  AV_CODEC_FLAG_LOOP_FILTER     = (1 shl 11);
(**
 * Only decode/encode grayscale.
 *)
  AV_CODEC_FLAG_GRAY            = (1 shl 13);
(**
 * error[?] variables will be set during encoding.
 *)
  AV_CODEC_FLAG_PSNR            = (1 shl 15);
(**
 * Input bitstream might be truncated at a random location
 * instead of only at frame boundaries.
 *)
  AV_CODEC_FLAG_TRUNCATED       = (1 shl 16);
(**
 * Use interlaced DCT.
 *)
  AV_CODEC_FLAG_INTERLACED_DCT  = (1 shl 18);
(**
 * Force low delay.
 *)
  AV_CODEC_FLAG_LOW_DELAY       = (1 shl 19);
(**
 * Place global headers in extradata instead of every keyframe.
 *)
  AV_CODEC_FLAG_GLOBAL_HEADER   = (1 shl 22);
(**
 * Use only bitexact stuff (except (I)DCT).
 *)
  AV_CODEC_FLAG_BITEXACT        = (1 shl 23);
(* Fx : Flag for H.263+ extra options *)
(**
 * H.263 advanced intra coding / MPEG-4 AC prediction
 *)
  AV_CODEC_FLAG_AC_PRED         = (1 shl 24);
(**
 * interlaced motion estimation
 *)
  AV_CODEC_FLAG_INTERLACED_ME   = (1 shl 29);
  AV_CODEC_FLAG_CLOSED_GOP      = (1 shl 31);

(**
 * Allow non spec compliant speedup tricks.
 *)
  AV_CODEC_FLAG2_FAST           = (1 shl  0);
(**
 * Skip bitstream encoding.
 *)
  AV_CODEC_FLAG2_NO_OUTPUT      = (1 shl  2);
(**
 * Place global headers at every keyframe instead of in extradata.
 *)
  AV_CODEC_FLAG2_LOCAL_HEADER   = (1 shl  3);

(**
 * timecode is in drop frame format. DEPRECATED!!!!
 *)
  AV_CODEC_FLAG2_DROP_FRAME_TIMECODE = (1 shl 13);

(**
 * Input bitstream might be truncated at a packet boundaries
 * instead of only at frame boundaries.
 *)
  AV_CODEC_FLAG2_CHUNKS         = (1 shl 15);
(**
 * Discard cropping information from SPS.
 *)
  AV_CODEC_FLAG2_IGNORE_CROP    = (1 shl 16);

(**
 * Show all frames before the first keyframe
 *)
  AV_CODEC_FLAG2_SHOW_ALL       = (1 shl 22);
(**
 * Export motion vectors through frame side data
 *)
  AV_CODEC_FLAG2_EXPORT_MVS     = (1 shl 28);
(**
 * Do not skip samples and export skip information as frame side data
 *)
  AV_CODEC_FLAG2_SKIP_MANUAL    = (1 shl 29);
(**
 * Do not reset ASS ReadOrder field on flush (subtitles decoding)
 *)
  AV_CODEC_FLAG2_RO_FLUSH_NOOP  = (1 shl 30);

(* Unsupported options :
 *              Syntax Arithmetic coding (SAC)
 *              Reference Picture Selection
 *              Independent Segment Decoding *)
(* /Fx *)
(* codec capabilities *)

(**
 * Decoder can use draw_horiz_band callback.
 *)
  AV_CODEC_CAP_DRAW_HORIZ_BAND     = (1 shl  0);
(**
 * Codec uses get_buffer() for allocating buffers and supports custom allocators.
 * If not set, it might not use get_buffer() at all or use operations that
 * assume the buffer was allocated by avcodec_default_get_buffer.
 *)
  AV_CODEC_CAP_DR1                 = (1 shl  1);
  AV_CODEC_CAP_TRUNCATED           = (1 shl  3);
(**
 * Encoder or decoder requires flushing with NULL input at the end in order to
 * give the complete and correct output.
 *
 * NOTE: If this flag is not set, the codec is guaranteed to never be fed with
 *       with NULL data. The user can still send NULL data to the public encode
 *       or decode function, but libavcodec will not pass it along to the codec
 *       unless this flag is set.
 *
 * Decoders:
 * The decoder has a non-zero delay and needs to be fed with avpkt->data=NULL,
 * avpkt->size=0 at the end to get the delayed data until the decoder no longer
 * returns frames.
 *
 * Encoders:
 * The encoder needs to be fed with NULL data at the end of encoding until the
 * encoder no longer returns data.
 *
 * NOTE: For encoders implementing the AVCodec.encode2() function, setting this
 *       flag also means that the encoder must set the pts and duration for
 *       each output packet. If this flag is not set, the pts and duration will
 *       be determined by libavcodec from the input frame.
 *)
  AV_CODEC_CAP_DELAY               = (1 shl  5);
(**
 * Codec can be fed a final frame with a smaller size.
 * This can be used to prevent truncation of the last audio samples.
 *)
  AV_CODEC_CAP_SMALL_LAST_FRAME    = (1 shl  6);

{$IFDEF FF_API_CAP_VDPAU}
(**
 * Codec can export data for HW decoding (VDPAU).
 *)
  AV_CODEC_CAP_HWACCEL_VDPAU       = (1 shl  7);
{$ENDIF}

(**
 * Codec can output multiple frames per AVPacket
 * Normally demuxers return one frame at a time, demuxers which do not do
 * are connected to a parser to split what they return into proper frames.
 * This flag is reserved to the very rare category of codecs which have a
 * bitstream that cannot be split into frames without timeconsuming
 * operations like full decoding. Demuxers carrying such bitstreams thus
 * may return multiple frames in a packet. This has many disadvantages like
 * prohibiting stream copy in many cases thus it should only be considered
 * as a last resort.
 *)
  AV_CODEC_CAP_SUBFRAMES           = (1 shl  8);
(**
 * Codec is experimental and is thus avoided in favor of non experimental
 * encoders
 *)
  AV_CODEC_CAP_EXPERIMENTAL        = (1 shl  9);
(**
 * Codec should fill in channel configuration and samplerate instead of container
 *)
  AV_CODEC_CAP_CHANNEL_CONF        = (1 shl 10);
(**
 * Codec supports frame-level multithreading.
 *)
  AV_CODEC_CAP_FRAME_THREADS       = (1 shl 12);
(**
 * Codec supports slice-based (or partition-based) multithreading.
 *)
  AV_CODEC_CAP_SLICE_THREADS       = (1 shl 13);
(**
 * Codec supports changed parameters at any point.
 *)
  AV_CODEC_CAP_PARAM_CHANGE        = (1 shl 14);
(**
 * Codec supports avctx->thread_count == 0 (auto).
 *)
  AV_CODEC_CAP_AUTO_THREADS        = (1 shl 15);
(**
 * Audio encoder supports receiving a different number of samples in each call.
 *)
  AV_CODEC_CAP_VARIABLE_FRAME_SIZE = (1 shl 16);
(**
 * Decoder is not a preferred choice for probing.
 * This indicates that the decoder is not a good choice for probing.
 * It could for example be an expensive to spin up hardware decoder,
 * or it could simply not provide a lot of useful information about
 * the stream.
 * A decoder marked with this flag should only be used as last resort
 * choice for probing.
 *)
  AV_CODEC_CAP_AVOID_PROBING       = (1 shl 17);
(**
 * Codec is intra only.
 *)
  AV_CODEC_CAP_INTRA_ONLY       = $40000000;
(**
 * Codec is lossless.
 *)
  AV_CODEC_CAP_LOSSLESS         = $80000000;


{$IFDEF FF_API_WITHOUT_PREFIX}
(**
 * Allow decoders to produce frames with data planes that are not aligned
 * to CPU requirements (e.g. due to cropping).
 *)
  CODEC_FLAG_UNALIGNED = AV_CODEC_FLAG_UNALIGNED;
  CODEC_FLAG_QSCALE = AV_CODEC_FLAG_QSCALE;
  CODEC_FLAG_4MV    = AV_CODEC_FLAG_4MV;
  CODEC_FLAG_OUTPUT_CORRUPT = AV_CODEC_FLAG_OUTPUT_CORRUPT;
  CODEC_FLAG_QPEL   = AV_CODEC_FLAG_QPEL;
{$IFDEF FF_API_GMC}
(**
 * @deprecated use the "gmc" private option of the libxvid encoder
 *)
  CODEC_FLAG_GMC    = $0020;  ///< Use GMC.
{$ENDIF}
{$IFDEF FF_API_MV0}
(**
 * @deprecated use the flag "mv0" in the "mpv_flags" private option of the
 * mpegvideo encoders
 *)
  CODEC_FLAG_MV0    = $0040;
{$ENDIF}
{$IFDEF FF_API_INPUT_PRESERVED}
(**
 * @deprecated passing reference-counted frames to the encoders replaces this
 * flag
 *)
  CODEC_FLAG_INPUT_PRESERVED = $0100;
{$ENDIF}
  CODEC_FLAG_PASS1           = AV_CODEC_FLAG_PASS1;
  CODEC_FLAG_PASS2           = AV_CODEC_FLAG_PASS2;
  CODEC_FLAG_GRAY            = AV_CODEC_FLAG_GRAY;
{$IFDEF FF_API_EMU_EDGE}
(**
 * @deprecated edges are not used/required anymore. I.e. this flag is now always
 * set.
 *)
  CODEC_FLAG_EMU_EDGE        = $4000;
{$ENDIF}
  CODEC_FLAG_PSNR            = AV_CODEC_FLAG_PSNR;
  CODEC_FLAG_TRUNCATED       = AV_CODEC_FLAG_TRUNCATED;

{$IFDEF FF_API_NORMALIZE_AQP}
(**
 * @deprecated use the flag "naq" in the "mpv_flags" private option of the
 * mpegvideo encoders
 *)
  CODEC_FLAG_NORMALIZE_AQP  = $00020000;
{$ENDIF}
  CODEC_FLAG_INTERLACED_DCT = AV_CODEC_FLAG_INTERLACED_DCT;
  CODEC_FLAG_LOW_DELAY      = AV_CODEC_FLAG_LOW_DELAY;
  CODEC_FLAG_GLOBAL_HEADER  = AV_CODEC_FLAG_GLOBAL_HEADER;
  CODEC_FLAG_BITEXACT       = AV_CODEC_FLAG_BITEXACT;
  CODEC_FLAG_AC_PRED        = AV_CODEC_FLAG_AC_PRED;
  CODEC_FLAG_LOOP_FILTER    = AV_CODEC_FLAG_LOOP_FILTER;
  CODEC_FLAG_INTERLACED_ME  = AV_CODEC_FLAG_INTERLACED_ME;
  CODEC_FLAG_CLOSED_GOP     = AV_CODEC_FLAG_CLOSED_GOP;
  CODEC_FLAG2_FAST          = AV_CODEC_FLAG2_FAST;
  CODEC_FLAG2_NO_OUTPUT     = AV_CODEC_FLAG2_NO_OUTPUT;
  CODEC_FLAG2_LOCAL_HEADER  = AV_CODEC_FLAG2_LOCAL_HEADER;
  CODEC_FLAG2_DROP_FRAME_TIMECODE = AV_CODEC_FLAG2_DROP_FRAME_TIMECODE;
  CODEC_FLAG2_IGNORE_CROP   = AV_CODEC_FLAG2_IGNORE_CROP;

  CODEC_FLAG2_CHUNKS        = AV_CODEC_FLAG2_CHUNKS;
  CODEC_FLAG2_SHOW_ALL      = AV_CODEC_FLAG2_SHOW_ALL;
  CODEC_FLAG2_EXPORT_MVS    = AV_CODEC_FLAG2_EXPORT_MVS;
  CODEC_FLAG2_SKIP_MANUAL   = AV_CODEC_FLAG2_SKIP_MANUAL;

(* Unsupported options :
 *              Syntax Arithmetic coding (SAC)
 *              Reference Picture Selection
 *              Independent Segment Decoding *)
(* /Fx *)
(* codec capabilities *)

  CODEC_CAP_DRAW_HORIZ_BAND = AV_CODEC_CAP_DRAW_HORIZ_BAND; ///< Decoder can use draw_horiz_band callback.
(**
 * Codec uses get_buffer() for allocating buffers and supports custom allocators.
 * If not set, it might not use get_buffer() at all or use operations that
 * assume the buffer was allocated by avcodec_default_get_buffer.
 *)
  CODEC_CAP_DR1             = AV_CODEC_CAP_DR1;
  CODEC_CAP_TRUNCATED       = AV_CODEC_CAP_TRUNCATED;
{$IFDEF FF_API_XVMC}
(* Codec can export data for HW decoding. This flag indicates that
 * the codec would call get_format() with list that might contain HW accelerated
 * pixel formats (XvMC, VDPAU, VAAPI, etc). The application can pick any of them
 * including raw image format.
 * The application can use the passed context to determine bitstream version,
 * chroma format, resolution etc.
 *)
  CODEC_CAP_HWACCEL         = $0010;
{$ENDIF}
(**
 * Encoder or decoder requires flushing with NULL input at the end in order to
 * give the complete and correct output.
 *
 * NOTE: If this flag is not set, the codec is guaranteed to never be fed with
 *       with NULL data. The user can still send NULL data to the public encode
 *       or decode function, but libavcodec will not pass it along to the codec
 *       unless this flag is set.
 *
 * Decoders:
 * The decoder has a non-zero delay and needs to be fed with avpkt->data=NULL,
 * avpkt->size=0 at the end to get the delayed data until the decoder no longer
 * returns frames.
 *
 * Encoders:
 * The encoder needs to be fed with NULL data at the end of encoding until the
 * encoder no longer returns data.
 *
 * NOTE: For encoders implementing the AVCodec.encode2() function, setting this
 *       flag also means that the encoder must set the pts and duration for
 *       each output packet. If this flag is not set, the pts and duration will
 *       be determined by libavcodec from the input frame.
 *)
  CODEC_CAP_DELAY           = AV_CODEC_CAP_DELAY;
(**
 * Codec can be fed a final frame with a smaller size.
 * This can be used to prevent truncation of the last audio samples.
 *)
  CODEC_CAP_SMALL_LAST_FRAME = AV_CODEC_CAP_SMALL_LAST_FRAME;
{$IFDEF FF_API_CAP_VDPAU}
(**
 * Codec can export data for HW decoding (VDPAU).
 *)
  CODEC_CAP_HWACCEL_VDPAU    = AV_CODEC_CAP_HWACCEL_VDPAU;
{$ENDIF}
(**
 * Codec can output multiple frames per AVPacket
 * Normally demuxers return one frame at a time, demuxers which do not do
 * are connected to a parser to split what they return into proper frames.
 * This flag is reserved to the very rare category of codecs which have a
 * bitstream that cannot be split into frames without timeconsuming
 * operations like full decoding. Demuxers carrying such bitstreams thus
 * may return multiple frames in a packet. This has many disadvantages like
 * prohibiting stream copy in many cases thus it should only be considered
 * as a last resort.
 *)
  CODEC_CAP_SUBFRAMES        = AV_CODEC_CAP_SUBFRAMES;
(**
 * Codec is experimental and is thus avoided in favor of non experimental
 * encoders
 *)
  CODEC_CAP_EXPERIMENTAL     = AV_CODEC_CAP_EXPERIMENTAL;
(**
 * Codec should fill in channel configuration and samplerate instead of container
 *)
  CODEC_CAP_CHANNEL_CONF     = AV_CODEC_CAP_CHANNEL_CONF;
{$IFDEF FF_API_NEG_LINESIZES}
(**
 * @deprecated no codecs use this capability
 *)
  CODEC_CAP_NEG_LINESIZES    = $0800;
{$ENDIF}
(**
 * Codec supports frame-level multithreading.
 *)
  CODEC_CAP_FRAME_THREADS    = AV_CODEC_CAP_FRAME_THREADS;
(**
 * Codec supports slice-based (or partition-based) multithreading.
 *)
  CODEC_CAP_SLICE_THREADS    = AV_CODEC_CAP_SLICE_THREADS;
(**
 * Codec supports changed parameters at any point.
 *)
  CODEC_CAP_PARAM_CHANGE     = AV_CODEC_CAP_PARAM_CHANGE;
(**
 * Codec supports avctx->thread_count == 0 (auto).
 *)
  CODEC_CAP_AUTO_THREADS     = AV_CODEC_CAP_AUTO_THREADS;
(**
 * Audio encoder supports receiving a different number of samples in each call.
 *)
  CODEC_CAP_VARIABLE_FRAME_SIZE = AV_CODEC_CAP_VARIABLE_FRAME_SIZE;
(**
 * Codec is intra only.
 *)
  CODEC_CAP_INTRA_ONLY       = AV_CODEC_CAP_INTRA_ONLY;
(**
 * Codec is lossless.
 *)
  CODEC_CAP_LOSSLESS         = AV_CODEC_CAP_LOSSLESS;

(**
 * HWAccel is experimental and is thus avoided in favor of non experimental
 * codecs
 *)
  HWACCEL_CODEC_CAP_EXPERIMENTAL     = $0200;
{$ENDIF} (* FF_API_WITHOUT_PREFIX *)

{$IFDEF FF_API_MB_TYPE}
//The following defines may change, don't expect compatibility if you use them.
  MB_TYPE_INTRA4x4   = $0001;
  MB_TYPE_INTRA16x16 = $0002; //FIXME H.264-specific
  MB_TYPE_INTRA_PCM  = $0004; //FIXME H.264-specific
  MB_TYPE_16x16      = $0008;
  MB_TYPE_16x8       = $0010;
  MB_TYPE_8x16       = $0020;
  MB_TYPE_8x8        = $0040;
  MB_TYPE_INTERLACED = $0080;
  MB_TYPE_DIRECT2    = $0100; //FIXME
  MB_TYPE_ACPRED     = $0200;
  MB_TYPE_GMC        = $0400;
  MB_TYPE_SKIP       = $0800;
  MB_TYPE_P0L0       = $1000;
  MB_TYPE_P1L0       = $2000;
  MB_TYPE_P0L1       = $4000;
  MB_TYPE_P1L1       = $8000;
  MB_TYPE_L0         = (MB_TYPE_P0L0 or MB_TYPE_P1L0);
  MB_TYPE_L1         = (MB_TYPE_P0L1 or MB_TYPE_P1L1);
  MB_TYPE_L0L1       = (MB_TYPE_L0   or MB_TYPE_L1);
  MB_TYPE_QUANT      = $00010000;
  MB_TYPE_CBP        = $00020000;
// Note bits 24-31 are reserved for codec specific use (H.264 ref0, MPEG-1 0mv, ...)
{$ENDIF}

(**
 * Pan Scan area.
 * This specifies the area which should be displayed.
 * Note there may be multiple such areas for one frame.
 *)
type
  PAVPanScan = ^TAVPanScan;
  TAVPanScan = record
    (**
     * id
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     *)
    id: Integer;

    (**
     * width and height in 1/16 pel
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     *)
    width: Integer;
    height: Integer;

    (**
     * position of the top left corner in 1/16 pel for up to 3 fields/frames
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     *)
    position: array[0..2] of array[0..1] of SmallInt; // int16_t
  end;

(**
 * This structure describes the bitrate properties of an encoded bitstream. It
 * roughly corresponds to a subset the VBV parameters for MPEG-2 or HRD
 * parameters for H.264/HEVC.
 *)
  PAVCPBProperties = ^TAVCPBProperties;
  TAVCPBProperties = record
    (**
     * Maximum bitrate of the stream, in bits per second.
     * Zero if unknown or unspecified.
     *)
    max_bitrate: Integer;
    (**
     * Minimum bitrate of the stream, in bits per second.
     * Zero if unknown or unspecified.
     *)
    min_bitrate: Integer;
    (**
     * Average bitrate of the stream, in bits per second.
     * Zero if unknown or unspecified.
     *)
    avg_bitrate: Integer;

    (**
     * The size of the buffer to which the ratecontrol is applied, in bits.
     * Zero if unknown or unspecified.
     *)
    buffer_size: Integer;

    (**
     * The delay between the time the packet this structure is associated with
     * is received and the time when it should be decoded, in periods of a 27MHz
     * clock.
     *
     * UINT64_MAX when unknown or unspecified.
     *)
    vbv_delay: Int64;
  end;

const
{$IFDEF FF_API_QSCALE_TYPE}
  FF_QSCALE_TYPE_MPEG1 = 0;
  FF_QSCALE_TYPE_MPEG2 = 1;
  FF_QSCALE_TYPE_H264  = 2;
  FF_QSCALE_TYPE_VP56  = 3;
{$ENDIF}

(**
 * The decoder will keep a reference to the frame and may reuse it later.
 *)
  AV_GET_BUFFER_FLAG_REF = (1 shl 0);

  AV_PKT_FLAG_KEY     = $0001; ///< The packet contains a keyframe
  AV_PKT_FLAG_CORRUPT = $0002; ///< The packet content is corrupted
(**
 * Flag is used to discard packets which are required to maintain valid
 * decoder state but are not required for output and should be dropped
 * after decoding.
 **)
  AV_PKT_FLAG_DISCARD = $0004;
(**
 * The packet comes from a trusted source.
 *
 * Otherwise-unsafe constructs such as arbitrary pointers to data
 * outside the packet may be followed.
 *)
  AV_PKT_FLAG_TRUSTED = $0008;

{$IFDEF FF_API_ASPECT_EXTENDED}
  // const for TAVCodecContext
  // AVCodecContext.gop_size
  FF_ASPECT_EXTENDED = 15;
{$ENDIF}

  // AVCodecContext.rc_strategy
  FF_RC_STRATEGY_XVID = 1;

  // AVCodecContext.workaround_bugs
  FF_BUG_AUTODETECT       = 1;  ///< autodetection
{$IFDEF FF_API_OLD_MSMPEG4}
  FF_BUG_OLD_MSMPEG4      = 2;
{$ENDIF}
  FF_BUG_XVID_ILACE       = 4;
  FF_BUG_UMP4             = 8;
  FF_BUG_NO_PADDING       = 16;
  FF_BUG_AMV              = 32;
{$IFDEF FF_API_AC_VLC}
  FF_BUG_AC_VLC           = 0;  ///< Will be removed, libavcodec can now handle these non-compliant files by default.
{$ENDIF}
  FF_BUG_QPEL_CHROMA      = 64;
  FF_BUG_STD_QPEL         = 128;
  FF_BUG_QPEL_CHROMA2     = 256;
  FF_BUG_DIRECT_BLOCKSIZE = 512;
  FF_BUG_EDGE             = 1024;
  FF_BUG_HPEL_CHROMA      = 2048;
  FF_BUG_DC_CLIP          = 4096;
  FF_BUG_MS               = 8192; ///< Work around various bugs in Microsoft's broken decoders.
  FF_BUG_TRUNCATED        = 16384;
  FF_BUG_IEDGE            = 32768;

  // AVCodecContext.strict_std_compliance
  FF_COMPLIANCE_VERY_STRICT  = 2; ///< Strictly conform to an older more strict version of the spec or reference software.
  FF_COMPLIANCE_STRICT       = 1; ///< Strictly conform to all the things in the spec no matter what consequences.
  FF_COMPLIANCE_NORMAL       = 0;
  FF_COMPLIANCE_UNOFFICIAL   = -1; ///< Allow unofficial extensions
  FF_COMPLIANCE_EXPERIMENTAL = -2; ///< Allow nonstandardized experimental things.

  // AVCodecContext.dct_algo
  FF_DCT_AUTO    = 0;
  FF_DCT_FASTINT = 1;
  FF_DCT_INT     = 2;
  FF_DCT_MMX     = 3;
  FF_DCT_ALTIVEC = 5;
  FF_DCT_FAAN    = 6;

  // AVCodecContext.idct_algo
  FF_IDCT_AUTO          = 0;
  FF_IDCT_INT           = 1;
  FF_IDCT_SIMPLE        = 2;
  FF_IDCT_SIMPLEMMX     = 3;
  FF_IDCT_ARM           = 7;
  FF_IDCT_ALTIVEC       = 8;
{$IFDEF FF_API_ARCH_SH4}
  FF_IDCT_SH4           = 9;
{$ENDIF}
  FF_IDCT_SIMPLEARM     = 10;
{$IFDEF FF_API_UNUSED_MEMBERS}
  FF_IDCT_IPP           = 13;
{$ENDIF} (* FF_API_UNUSED_MEMBERS *)
  FF_IDCT_XVID          = 14;
{$IFDEF FF_API_IDCT_XVIDMMX}
  FF_IDCT_XVIDMMX       = 14;
{$ENDIF} (* FF_API_IDCT_XVIDMMX *)
  FF_IDCT_SIMPLEARMV5TE = 16;
  FF_IDCT_SIMPLEARMV6   = 17;
{$IFDEF FF_API_ARCH_SPARC}
  FF_IDCT_SIMPLEVIS     = 18;
{$ENDIF}
  FF_IDCT_FAAN          = 20;
  FF_IDCT_SIMPLENEON    = 22;
{$IFDEF FF_API_ARCH_ALPHA}
  FF_IDCT_SIMPLEALPHA   = 23;
{$ENDIF}
  FF_IDCT_NONE          = 24; (* Used by XvMC to extract IDCT coefficients with FF_IDCT_PERM_NONE *)
  FF_IDCT_SIMPLEAUTO    = 128;

  // AVCodecContext.error_concealment
  FF_EC_GUESS_MVS   = 1;
  FF_EC_DEBLOCK     = 2;
  FF_EC_FAVOR_INTER = 256;

{$IFDEF FF_API_PRIVATE_OPT}
  // AVCodecContext.prediction_method
  FF_PRED_LEFT   = 0;
  FF_PRED_PLANE  = 1;
  FF_PRED_MEDIAN = 2;
{$ENDIF}

  // AVCodecContext.debug
  FF_DEBUG_PICT_INFO   = 1;
  FF_DEBUG_RC          = 2;
  FF_DEBUG_BITSTREAM   = 4;
  FF_DEBUG_MB_TYPE     = 8;
  FF_DEBUG_QP          = 16;
{$IFDEF FF_API_DEBUG_MV}
(**
 * @deprecated this option does nothing
 *)
  FF_DEBUG_MV          = 32;
{$ENDIF}
  FF_DEBUG_DCT_COEFF   = $00000040;
  FF_DEBUG_SKIP        = $00000080;
  FF_DEBUG_STARTCODE   = $00000100;
{$IFDEF FF_API_UNUSED_MEMBERS}
  FF_DEBUG_PTS         = $00000200;
{$ENDIF} (* FF_API_UNUSED_MEMBERS *)
  FF_DEBUG_ER          = $00000400;
  FF_DEBUG_MMCO        = $00000800;
  FF_DEBUG_BUGS        = $00001000;
{$IFDEF FF_API_DEBUG_MV}
  FF_DEBUG_VIS_QP      = $00002000;
  FF_DEBUG_VIS_MB_TYPE = $00004000;
{$ENDIF}
  FF_DEBUG_BUFFERS     = $00008000;
  FF_DEBUG_THREADS     = $00010000;
  FF_DEBUG_GREEN_MD    = $00800000;
  FF_DEBUG_NOMC        = $01000000;

{$IFDEF FF_API_DEBUG_MV}
  // AVCodecContext.debug_mv
  FF_DEBUG_VIS_MV_P_FOR  = $00000001; // visualize forward predicted MVs of P-frames
  FF_DEBUG_VIS_MV_B_FOR  = $00000002; // visualize forward predicted MVs of B-frames
  FF_DEBUG_VIS_MV_B_BACK = $00000004; // visualize backward predicted MVs of B-frames
{$ENDIF}

  // AVCodecContext.properties
  FF_CODEC_PROPERTY_LOSSLESS        = $00000001;
  FF_CODEC_PROPERTY_CLOSED_CAPTIONS = $00000002;

  // AVCodecContext.sub_text_format
  FF_SUB_TEXT_FMT_ASS              = 0;
{$IFDEF FF_API_ASS_TIMING}
  FF_SUB_TEXT_FMT_ASS_WITH_TIMINGS = 1;
{$ENDIF}

  // AVCodecContext.ildct_cmp
  FF_CMP_SAD        = 0;
  FF_CMP_SSE        = 1;
  FF_CMP_SATD       = 2;
  FF_CMP_DCT        = 3;
  FF_CMP_PSNR       = 4;
  FF_CMP_BIT        = 5;
  FF_CMP_RD         = 6;
  FF_CMP_ZERO       = 7;
  FF_CMP_VSAD       = 8;
  FF_CMP_VSSE       = 9;
  FF_CMP_NSSE       = 10;
  FF_CMP_W53        = 11;
  FF_CMP_W97        = 12;
  FF_CMP_DCTMAX     = 13;
  FF_CMP_DCT264     = 14;
  FF_CMP_MEDIAN_SAD = 15;
  FF_CMP_CHROMA     = 256;

{$IFDEF FF_API_AFD}
  // AVCodecContext.dtg_active_format
  FF_DTG_AFD_SAME         = 8;
  FF_DTG_AFD_4_3          = 9;
  FF_DTG_AFD_16_9         = 10;
  FF_DTG_AFD_14_9         = 11;
  FF_DTG_AFD_4_3_SP_14_9  = 13;
  FF_DTG_AFD_16_9_SP_14_9 = 14;
  FF_DTG_AFD_SP_4_3       = 15;
{$ENDIF} (* FF_API_AFD *)

  // AVCodecContext.intra_quant_bias
  FF_DEFAULT_QUANT_BIAS = 999999;

{$IFDEF FF_API_CODER_TYPE}
  // AVCodecContext.coder_type
  FF_CODER_TYPE_VLC       = 0;
  FF_CODER_TYPE_AC        = 1;
  FF_CODER_TYPE_RAW       = 2;
  FF_CODER_TYPE_RLE       = 3;
{$IFDEF FF_API_UNUSED_MEMBERS}
  FF_CODER_TYPE_DEFLATE   = 4;
{$ENDIF} (* FF_API_UNUSED_MEMBERS *)
{$ENDIF} (* FF_API_CODER_TYPE *)

  // AVCodecContext.slice_flags
  SLICE_FLAG_CODED_ORDER    = $0001; ///< draw_horiz_band() is called in coded order instead of display
  SLICE_FLAG_ALLOW_FIELD    = $0002; ///< allow draw_horiz_band() with field slices (MPEG-2 field pics)
  SLICE_FLAG_ALLOW_PLANE    = $0004; ///< allow draw_horiz_band() with 1 component at a time (SVQ1)

  // AVCodecContext.mb_decision
  FF_MB_DECISION_SIMPLE = 0;        ///< uses mb_cmp
  FF_MB_DECISION_BITS   = 1;        ///< chooses the one which needs the fewest bits
  FF_MB_DECISION_RD     = 2;        ///< rate distortion

  // AVCodecContext.profile
  FF_PROFILE_UNKNOWN  = -99;
  FF_PROFILE_RESERVED = -100;

  FF_PROFILE_AAC_MAIN = 0;
  FF_PROFILE_AAC_LOW  = 1;
  FF_PROFILE_AAC_SSR  = 2;
  FF_PROFILE_AAC_LTP  = 3;
  FF_PROFILE_AAC_HE   = 4;
  FF_PROFILE_AAC_HE_V2 = 28;
  FF_PROFILE_AAC_LD   = 22;
  FF_PROFILE_AAC_ELD  = 38;
  FF_PROFILE_MPEG2_AAC_LOW = 128;
  FF_PROFILE_MPEG2_AAC_HE  = 131;

  FF_PROFILE_DNXHD       = 0;
  FF_PROFILE_DNXHR_LB    = 1;
  FF_PROFILE_DNXHR_SQ    = 2;
  FF_PROFILE_DNXHR_HQ    = 3;
  FF_PROFILE_DNXHR_HQX   = 4;
  FF_PROFILE_DNXHR_444   = 5;

  FF_PROFILE_DTS         = 20;
  FF_PROFILE_DTS_ES      = 30;
  FF_PROFILE_DTS_96_24   = 40;
  FF_PROFILE_DTS_HD_HRA  = 50;
  FF_PROFILE_DTS_HD_MA   = 60;
  FF_PROFILE_DTS_EXPRESS = 70;

  FF_PROFILE_MPEG2_422    = 0;
  FF_PROFILE_MPEG2_HIGH   = 1;
  FF_PROFILE_MPEG2_SS     = 2;
  FF_PROFILE_MPEG2_SNR_SCALABLE = 3;
  FF_PROFILE_MPEG2_MAIN   = 4;
  FF_PROFILE_MPEG2_SIMPLE = 5;

  FF_PROFILE_H264_CONSTRAINED = (1 shl 9);  // 8+1; constraint_set1_flag
  FF_PROFILE_H264_INTRA       = (1 shl 11); // 8+3; constraint_set3_flag

  FF_PROFILE_H264_BASELINE             = 66;
  FF_PROFILE_H264_CONSTRAINED_BASELINE = (66 or FF_PROFILE_H264_CONSTRAINED);
  FF_PROFILE_H264_MAIN                 = 77;
  FF_PROFILE_H264_EXTENDED             = 88;
  FF_PROFILE_H264_HIGH                 = 100;
  FF_PROFILE_H264_HIGH_10              = 110;
  FF_PROFILE_H264_HIGH_10_INTRA        = (110 or FF_PROFILE_H264_INTRA);
  FF_PROFILE_H264_MULTIVIEW_HIGH       = 118;
  FF_PROFILE_H264_HIGH_422             = 122;
  FF_PROFILE_H264_HIGH_422_INTRA       = (122 or FF_PROFILE_H264_INTRA);
  FF_PROFILE_H264_STEREO_HIGH          = 128;
  FF_PROFILE_H264_HIGH_444             = 144;
  FF_PROFILE_H264_HIGH_444_PREDICTIVE  = 244;
  FF_PROFILE_H264_HIGH_444_INTRA       = (244 or FF_PROFILE_H264_INTRA);
  FF_PROFILE_H264_CAVLC_444            = 44;

  FF_PROFILE_VC1_SIMPLE   = 0;
  FF_PROFILE_VC1_MAIN     = 1;
  FF_PROFILE_VC1_COMPLEX  = 2;
  FF_PROFILE_VC1_ADVANCED = 3;

  FF_PROFILE_MPEG4_SIMPLE                    =  0;
  FF_PROFILE_MPEG4_SIMPLE_SCALABLE           =  1;
  FF_PROFILE_MPEG4_CORE                      =  2;
  FF_PROFILE_MPEG4_MAIN                      =  3;
  FF_PROFILE_MPEG4_N_BIT                     =  4;
  FF_PROFILE_MPEG4_SCALABLE_TEXTURE          =  5;
  FF_PROFILE_MPEG4_SIMPLE_FACE_ANIMATION     =  6;
  FF_PROFILE_MPEG4_BASIC_ANIMATED_TEXTURE    =  7;
  FF_PROFILE_MPEG4_HYBRID                    =  8;
  FF_PROFILE_MPEG4_ADVANCED_REAL_TIME        =  9;
  FF_PROFILE_MPEG4_CORE_SCALABLE             = 10;
  FF_PROFILE_MPEG4_ADVANCED_CODING           = 11;
  FF_PROFILE_MPEG4_ADVANCED_CORE             = 12;
  FF_PROFILE_MPEG4_ADVANCED_SCALABLE_TEXTURE = 13;
  FF_PROFILE_MPEG4_SIMPLE_STUDIO             = 14;
  FF_PROFILE_MPEG4_ADVANCED_SIMPLE           = 15;

  FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_0  = 1;
  FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_1  = 2;
  FF_PROFILE_JPEG2000_CSTREAM_NO_RESTRICTION = 32768;
  FF_PROFILE_JPEG2000_DCINEMA_2K             = 3;
  FF_PROFILE_JPEG2000_DCINEMA_4K             = 4;

  FF_PROFILE_VP9_0                           = 0;
  FF_PROFILE_VP9_1                           = 1;
  FF_PROFILE_VP9_2                           = 2;
  FF_PROFILE_VP9_3                           = 3;

  FF_PROFILE_HEVC_MAIN                       = 1;
  FF_PROFILE_HEVC_MAIN_10                    = 2;
  FF_PROFILE_HEVC_MAIN_STILL_PICTURE         = 3;
  FF_PROFILE_HEVC_REXT                       = 4;

  // AVCodecContext.level
  FF_LEVEL_UNKNOWN = -99;

  // AVCodecContext.thread_type
  FF_THREAD_FRAME   = 1; ///< Decode more than one frame at once
  FF_THREAD_SLICE   = 2; ///< Decode more than one part of a single frame at once

  // AVCodecContext.err_recognition
  AV_EF_CRCCHECK   = 1 shl 0;
  AV_EF_BITSTREAM  = 1 shl 1;
  AV_EF_BUFFER     = 1 shl 2;
  AV_EF_EXPLODE    = 1 shl 3;
  AV_EF_IGNORE_ERR = 1 shl 15;
  AV_EF_CAREFUL    = 1 shl 16;
  AV_EF_COMPLIANT  = 1 shl 17;
  AV_EF_AGGRESSIVE = 1 shl 18;

  // AVCodecContext.compression_level
  FF_COMPRESSION_DEFAULT = -1;

  // AVCodecContext.sub_charenc_mode
  FF_SUB_CHARENC_MODE_DO_NOTHING  = -1; ///< do nothing (demuxer outputs a stream supposed to be already in UTF-8, or the codec is bitmap for instance)
  FF_SUB_CHARENC_MODE_AUTOMATIC   = 0;  ///< libavcodec will select the mode itself
  FF_SUB_CHARENC_MODE_PRE_DECODER = 1;  ///< the AVPacket data needs to be recoded to UTF-8 before being fed to the decoder, requires iconv

  AV_SUBTITLE_FLAG_FORCED = $00000001;

(**
 * HWAccel is experimental and is thus avoided in favor of non experimental
 * codecs
 *)
  AV_HWACCEL_CODEC_CAP_EXPERIMENTAL = $0200;

(**
 * Hardware acceleration should be used for decoding even if the codec level
 * used is unknown or higher than the maximum supported level reported by the
 * hardware driver.
 *
 * It's generally a good idea to pass this flag unless you have a specific
 * reason not to, as hardware tends to under-report supported levels.
 *)
  AV_HWACCEL_FLAG_IGNORE_LEVEL = (1 shl 0);

(**
 * Hardware acceleration can output YUV pixel formats with a different chroma
 * sampling than 4:2:0 and/or other than 8 bits per component.
 *)
  AV_HWACCEL_FLAG_ALLOW_HIGH_DEPTH = (1 shl 1);

(**
 * Hardware acceleration should still be attempted for decoding when the
 * codec profile does not match the reported capabilities of the hardware.
 *
 * For example, this can be used to try to decode baseline profile H.264
 * streams in hardware - it will often succeed, because many streams marked
 * as baseline profile actually conform to constrained baseline profile.
 *
 * @warning If the stream is actually not supported then the behaviour is
 *          undefined, and may include returning entirely incorrect output
 *          while indicating success.
 *)
  AV_HWACCEL_FLAG_ALLOW_PROFILE_MISMATCH = (1 shl 2);

(**
 * @defgroup lavc_packet AVPacket
 *
 * Types and functions for working with AVPacket.
 * @{
 *)
type
  TAVPacketSideDataType = (
    (**
     * An AV_PKT_DATA_PALETTE side data packet contains exactly AVPALETTE_SIZE
     * bytes worth of palette. This side data signals that a new palette is
     * present.
     *)
    AV_PKT_DATA_PALETTE,

    (**
     * The AV_PKT_DATA_NEW_EXTRADATA is used to notify the codec or the format
     * that the extradata buffer was changed and the receiving side should
     * act upon it appropriately. The new extradata is embedded in the side
     * data buffer and should be immediately used for processing the current
     * frame or packet.
     *)
    AV_PKT_DATA_NEW_EXTRADATA,

    (**
     * An AV_PKT_DATA_PARAM_CHANGE side data packet is laid out as follows:
     * @code
     * u32le param_flags
     * if (param_flags & AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_COUNT)
     *     s32le channel_count
     * if (param_flags & AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_LAYOUT)
     *     u64le channel_layout
     * if (param_flags & AV_SIDE_DATA_PARAM_CHANGE_SAMPLE_RATE)
     *     s32le sample_rate
     * if (param_flags & AV_SIDE_DATA_PARAM_CHANGE_DIMENSIONS)
     *     s32le width
     *     s32le height
     * @endcode
     *)
    AV_PKT_DATA_PARAM_CHANGE,

    (**
     * An AV_PKT_DATA_H263_MB_INFO side data packet contains a number of
     * structures with info about macroblocks relevant to splitting the
     * packet into smaller packets on macroblock edges (e.g. as for RFC 2190).
     * That is, it does not necessarily contain info about all macroblocks,
     * as long as the distance between macroblocks in the info is smaller
     * than the target payload size.
     * Each MB info structure is 12 bytes, and is laid out as follows:
     * @code
     * u32le bit offset from the start of the packet
     * u8    current quantizer at the start of the macroblock
     * u8    GOB number
     * u16le macroblock address within the GOB
     * u8    horizontal MV predictor
     * u8    vertical MV predictor
     * u8    horizontal MV predictor for block number 3
     * u8    vertical MV predictor for block number 3
     * @endcode
     *)
    AV_PKT_DATA_H263_MB_INFO,

    (**
     * This side data should be associated with an audio stream and contains
     * ReplayGain information in form of the AVReplayGain struct.
     *)
    AV_PKT_DATA_REPLAYGAIN,

    (**
     * This side data contains a 3x3 transformation matrix describing an affine
     * transformation that needs to be applied to the decoded video frames for
     * correct presentation.
     *
     * See libavutil/display.h for a detailed description of the data.
     *)
    AV_PKT_DATA_DISPLAYMATRIX,

    (**
     * This side data should be associated with a video stream and contains
     * Stereoscopic 3D information in form of the AVStereo3D struct.
     *)
    AV_PKT_DATA_STEREO3D,

    (**
     * This side data should be associated with an audio stream and corresponds
     * to enum AVAudioServiceType.
     *)
    AV_PKT_DATA_AUDIO_SERVICE_TYPE,

    (**
     * This side data contains quality related information from the encoder.
     * @code
     * u32le quality factor of the compressed frame. Allowed range is between 1 (good) and FF_LAMBDA_MAX (bad).
     * u8    picture type
     * u8    error count
     * u16   reserved
     * u64le[error count] sum of squared differences between encoder in and output
     * @endcode
     *)
    AV_PKT_DATA_QUALITY_STATS,

    (**
     * This side data contains an integer value representing the stream index
     * of a "fallback" track.  A fallback track indicates an alternate
     * track to use when the current track can not be decoded for some reason.
     * e.g. no decoder available for codec.
     *)
    AV_PKT_DATA_FALLBACK_TRACK,

    (**
     * This side data corresponds to the AVCPBProperties struct.
     *)
    AV_PKT_DATA_CPB_PROPERTIES,

    (**
     * Recommmends skipping the specified number of samples
     * @code
     * u32le number of samples to skip from start of this packet
     * u32le number of samples to skip from end of this packet
     * u8    reason for start skip
     * u8    reason for end   skip (0=padding silence, 1=convergence)
     * @endcode
     *)
    AV_PKT_DATA_SKIP_SAMPLES=70,

    (**
     * An AV_PKT_DATA_JP_DUALMONO side data packet indicates that
     * the packet may contain "dual mono" audio specific to Japanese DTV
     * and if it is true, recommends only the selected channel to be used.
     * @code
     * u8    selected channels (0=mail/left, 1=sub/right, 2=both)
     * @endcode
     *)
    AV_PKT_DATA_JP_DUALMONO,

    (**
     * A list of zero terminated key/value strings. There is no end marker for
     * the list, so it is required to rely on the side data size to stop.
     *)
    AV_PKT_DATA_STRINGS_METADATA,

    (**
     * Subtitle event position
     * @code
     * u32le x1
     * u32le y1
     * u32le x2
     * u32le y2
     * @endcode
     *)
    AV_PKT_DATA_SUBTITLE_POSITION,

    (**
     * Data found in BlockAdditional element of matroska container. There is
     * no end marker for the data, so it is required to rely on the side data
     * size to recognize the end. 8 byte id (as found in BlockAddId) followed
     * by data.
     *)
    AV_PKT_DATA_MATROSKA_BLOCKADDITIONAL,

    (**
     * The optional first identifier line of a WebVTT cue.
     *)
    AV_PKT_DATA_WEBVTT_IDENTIFIER,

    (**
     * The optional settings (rendering instructions) that immediately
     * follow the timestamp specifier of a WebVTT cue.
     *)
    AV_PKT_DATA_WEBVTT_SETTINGS,

    (**
     * A list of zero terminated key/value strings. There is no end marker for
     * the list, so it is required to rely on the side data size to stop. This
     * side data includes updated metadata which appeared in the stream.
     *)
    AV_PKT_DATA_METADATA_UPDATE,

    (**
     * MPEGTS stream ID, this is required to pass the stream ID
     * information from the demuxer to the corresponding muxer.
     *)
    AV_PKT_DATA_MPEGTS_STREAM_ID,

    (**
     * Mastering display metadata (based on SMPTE-2086:2014). This metadata
     * should be associated with a video stream and contains data in the form
     * of the AVMasteringDisplayMetadata struct.
     *)
    AV_PKT_DATA_MASTERING_DISPLAY_METADATA,

    (**
     * This side data should be associated with a video stream and corresponds
     * to the AVSphericalMapping structure.
     *)
    AV_PKT_DATA_SPHERICAL,

    (**
     * Content light level (based on CTA-861.3). This metadata should be
     * associated with a video stream and contains data in the form of the
     * AVContentLightMetadata struct.
     *)
    AV_PKT_DATA_CONTENT_LIGHT_LEVEL,

    (**
     * ATSC A53 Part 4 Closed Captions. This metadata should be associated with
     * a video stream. A53 CC bitstream is stored as uint8_t in AVPacketSideData.data.
     * The number of bytes of CC data is AVPacketSideData.size.
     *)
    AV_PKT_DATA_A53_CC,

    (**
     * The number of side data elements (in fact a bit more than it).
     * This is not part of the public API/ABI in the sense that it may
     * change when new side data types are added.
     * This must stay the last enum value.
     * If its value becomes huge, some code using it
     * needs to be updated as it assumes it to be smaller than other limits.
     *)
    AV_PKT_DATA_NB
  );

const
  AV_PKT_DATA_QUALITY_FACTOR = AV_PKT_DATA_QUALITY_STATS; //DEPRECATED

type
  PAVPacketSideData = ^TAVPacketSideData;
  TAVPacketSideData = record
    data: PByte;
    size: Integer;
    type_: TAVPacketSideDataType;
  end;

(**
 * This structure stores compressed data. It is typically exported by demuxers
 * and then passed as input to decoders, or received as output from encoders and
 * then passed to muxers.
 *
 * For video, it should typically contain one compressed frame. For audio it may
 * contain several compressed frames. Encoders are allowed to output empty
 * packets, with no compressed data, containing only side data
 * (e.g. to update some stream parameters at the end of encoding).
 *
 * AVPacket is one of the few structs in FFmpeg, whose size is a part of public
 * ABI. Thus it may be allocated on stack and no new fields can be added to it
 * without libavcodec and libavformat major bump.
 *
 * The semantics of data ownership depends on the buf field.
 * If it is set, the packet data is dynamically allocated and is
 * valid indefinitely until a call to av_packet_unref() reduces the
 * reference count to 0.
 *
 * If the buf field is not set av_packet_ref() would make a copy instead
 * of increasing the reference count.
 *
 * The side data is always allocated with av_malloc(), copied by
 * av_packet_ref() and freed by av_packet_unref().
 *
 * @see av_packet_ref
 * @see av_packet_unref
 *)
  PPAVPacket = ^PAVPacket;
  PAVPacket = ^TAVPacket;
  TAVPacket = record
    (**
     * A reference to the reference-counted buffer where the packet data is
     * stored.
     * May be NULL, then the packet data is not reference-counted.
     *)
    buf: PAVBufferRef;
    (**
     * Presentation timestamp in AVStream->time_base units; the time at which
     * the decompressed packet will be presented to the user.
     * Can be AV_NOPTS_VALUE if it is not stored in the file.
     * pts MUST be larger or equal to dts as presentation cannot happen before
     * decompression, unless one wants to view hex dumps. Some formats misuse
     * the terms dts and pts/cts to mean something different. Such timestamps
     * must be converted to true pts/dts before they are stored in AVPacket.
     *)
    pts: Int64;
    (**
     * Decompression timestamp in AVStream->time_base units; the time at which
     * the packet is decompressed.
     * Can be AV_NOPTS_VALUE if it is not stored in the file.
     *)
    dts: Int64;
    data: PByte;
    size: Integer;
    stream_index: Integer;
    (**
     * A combination of AV_PKT_FLAG values
     *)
    flags: Integer;
    (**
     * Additional packet data that can be provided by the container.
     * Packet can contain several types of side information.
     *)
    side_data: PAVPacketSideData;
    side_data_elems: Integer;

    (**
     * Duration of this packet in AVStream->time_base units, 0 if unknown.
     * Equals next_pts - this_pts in presentation order.
     *)
    duration: Int64;

    pos: Int64;             ///< byte position in stream, -1 if unknown

{$IFDEF FF_API_CONVERGENCE_DURATION}
    (**
     * @deprecated Same as the duration field, but as int64_t. This was required
     * for Matroska subtitles, whose duration values could overflow when the
     * duration field was still an int.
     *)
    convergence_duration: Int64;
{$ENDIF}
  end;

  TAVSideDataParamChangeFlags = (
    AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_COUNT  = $0001,
    AV_SIDE_DATA_PARAM_CHANGE_CHANNEL_LAYOUT = $0002,
    AV_SIDE_DATA_PARAM_CHANGE_SAMPLE_RATE    = $0004,
    AV_SIDE_DATA_PARAM_CHANGE_DIMENSIONS     = $0008
  );
(**
 * @}
 *)

  PAVCodecInternal = ^TAVCodecInternal;
  TAVCodecInternal = record
    // need {$ALIGN 8}
    // defined in libavcodec/internal.h
  end;

  TAVFieldOrder = (
    AV_FIELD_UNKNOWN,
    AV_FIELD_PROGRESSIVE,
    AV_FIELD_TT,          //< Top coded_first, top displayed first
    AV_FIELD_BB,          //< Bottom coded first, bottom displayed first
    AV_FIELD_TB,          //< Top coded first, bottom displayed first
    AV_FIELD_BT           //< Bottom coded first, top displayed first
  );

(**
 * main external API structure.
 * New fields can be added to the end with minor version bumps.
 * Removal, reordering and changes to existing fields require a major
 * version bump.
 * You can use AVOptions (av_opt* / av_set/get*()) to access these fields from user
 * applications.
 * The name string for AVOptions options matches the associated command line
 * parameter name and can be found in libavcodec/options_table.h
 * The AVOption/command line parameter names differ in some cases from the C
 * structure field names for historic reasons or brevity.
 * sizeof(AVCodecContext) must not be used outside libav*.
 *)
  PPAVCodec = ^PAVCodec;
  PAVCodec = ^TAVCodec;
  PAVHWAccel = ^TAVHWAccel;
  PPAVCodecContext = ^PAVCodecContext;
  PAVCodecContext = ^TAVCodecContext;
  TexecuteCall = function (c2: PAVCodecContext; arg: Pointer): Integer; cdecl;
  Texecute2Call = function (c2: PAVCodecContext; arg: Pointer; jobnr, threadnr: Integer): Integer; cdecl;
  TAVCodecContext = record
    (**
     * information on struct for av_log
     * - set by avcodec_alloc_context3
     *)
    av_class: PAVClass;
    log_level_offset: Integer;

    codec_type: TAVMediaType; (* see AVMEDIA_TYPE_xxx *)
    codec: PAVCodec;
{$IFDEF FF_API_CODEC_NAME}
    (**
     * @deprecated this field is not used for anything in libavcodec
     *)
    codec_name: array[0..31] of AnsiChar;
{$ENDIF}
    codec_id: TAVCodecID; (* see AV_CODEC_ID_xxx *)

    (**
     * fourcc (LSB first, so "ABCD" -> ('D'<<24) + ('C'<<16) + ('B'<<8) + 'A').
     * This is used to work around some encoder bugs.
     * A demuxer should set this to what is stored in the field used to identify the codec.
     * If there are multiple such fields in a container then the demuxer should choose the one
     * which maximizes the information about the used codec.
     * If the codec tag field in a container is larger than 32 bits then the demuxer should
     * remap the longer ID to 32 bits with a table or other structure. Alternatively a new
     * extra_codec_tag + size could be added but for this a clear advantage must be demonstrated
     * first.
     * - encoding: Set by user, if not then the default based on codec_id will be used.
     * - decoding: Set by user, will be converted to uppercase by libavcodec during init.
     *)
    //unsigned int codec_tag;
    //codec_tag: Cardinal;
    //codec_tag: array[0..3] of AnsiChar;
    codec_tag: packed record
      case Integer of
        0: (tag: Cardinal);
        1: (fourcc: array[0..3] of AnsiChar);
        2: (fourbb: array[0..3] of Byte);
      end;

{$IFDEF FF_API_STREAM_CODEC_TAG}
    (**
     * @deprecated this field is unused
     *)
    stream_codec_tag: array[0..3] of AnsiChar;
{$ENDIF}

    priv_data: Pointer;

    (**
     * Private context used for internal data.
     *
     * Unlike priv_data, this is not codec-specific. It is used in general
     * libavcodec functions.
     *)
    internal: PAVCodecInternal;

    (**
     * Private data of the user, can be used to carry app specific stuff.
     * - encoding: Set by user.
     * - decoding: Set by user.
     *)
    opaque: Pointer;

    (**
     * the average bitrate
     * - encoding: Set by user; unused for constant quantizer encoding.
     * - decoding: Set by user, may be overwritten by libavcodec
     *             if this info is available in the stream
     *)
    bit_rate: Int64;

    (**
     * number of bits the bitstream is allowed to diverge from the reference.
     *           the reference can be CBR (for CBR pass1) or VBR (for pass2)
     * - encoding: Set by user; unused for constant quantizer encoding.
     * - decoding: unused
     *)
    bit_rate_tolerance: Integer;

    (**
     * Global quality for codecs which cannot change it per frame.
     * This should be proportional to MPEG-1/2/4 qscale.
     * - encoding: Set by user.
     * - decoding: unused
     *)
    global_quality: Integer;

    (**
     * - encoding: Set by user.
     * - decoding: unused
     *)
    compression_level: Integer;
//#define FF_COMPRESSION_DEFAULT -1

    (**
     * AV_CODEC_FLAG_*.
     * - encoding: Set by user.
     * - decoding: Set by user.
     *)
    flags: Integer;

    (**
     * AV_CODEC_FLAG2_*
     * - encoding: Set by user.
     * - decoding: Set by user.
     *)
    flags2: Integer;

    (**
     * some codecs need / can use extradata like Huffman tables.
     * MJPEG: Huffman tables
     * rv10: additional flags
     * MPEG-4: global headers (they can be in the bitstream or here)
     * The allocated memory should be AV_INPUT_BUFFER_PADDING_SIZE bytes larger
     * than extradata_size to avoid problems if it is read with the bitstream reader.
     * The bytewise contents of extradata must not depend on the architecture or CPU endianness.
     * - encoding: Set/allocated/freed by libavcodec.
     * - decoding: Set/allocated/freed by user.
     *)
    extradata: PByte;
    extradata_size: Integer;

    (**
     * This is the fundamental unit of time (in seconds) in terms
     * of which frame timestamps are represented. For fixed-fps content,
     * timebase should be 1/framerate and timestamp increments should be
     * identically 1.
     * This often, but not always is the inverse of the frame rate or field rate
     * for video. 1/time_base is not the average frame rate if the frame rate is not
     * constant.
     *
     * Like containers, elementary streams also can store timestamps, 1/time_base
     * is the unit in which these timestamps are specified.
     * As example of such codec time base see ISO/IEC 14496-2:2001(E)
     * vop_time_increment_resolution and fixed_vop_rate
     * (fixed_vop_rate == 0 implies that it is different from the framerate)
     *
     * - encoding: MUST be set by user.
     * - decoding: the use of this field for decoding is deprecated.
     *             Use framerate instead.
     *)
    time_base: TAVRational;

    (**
     * For some codecs, the time base is closer to the field rate than the frame rate.
     * Most notably, H.264 and MPEG-2 specify time_base as half of frame duration
     * if no telecine is used ...
     *
     * Set to time_base ticks per frame. Default 1, e.g., H.264/MPEG-2 set it to 2.
     *)
    ticks_per_frame: Integer;

    (**
     * Codec delay.
     *
     * Encoding: Number of frames delay there will be from the encoder input to
     *           the decoder output. (we assume the decoder matches the spec)
     * Decoding: Number of frames delay in addition to what a standard decoder
     *           as specified in the spec would produce.
     *
     * Video:
     *   Number of frames the decoded output will be delayed relative to the
     *   encoded input.
     *
     * Audio:
     *   For encoding, this field is unused (see initial_padding).
     *
     *   For decoding, this is the number of samples the decoder needs to
     *   output before the decoder's output is valid. When seeking, you should
     *   start decoding this many samples prior to your desired seek point.
     *
     * - encoding: Set by libavcodec.
     * - decoding: Set by libavcodec.
     *)
    delay: Integer;


    (* video only *)
    (**
     * picture width / height.
     *
     * @note Those fields may not match the values of the last
     * AVFrame output by avcodec_decode_video2 due frame
     * reordering.
     *
     * - encoding: MUST be set by user.
     * - decoding: May be set by the user before opening the decoder if known e.g.
     *             from the container. Some decoders will require the dimensions
     *             to be set by the caller. During decoding, the decoder may
     *             overwrite those values as required while parsing the data.
     *)
    width, height: Integer;

    (**
     * Bitstream width / height, may be different from width/height e.g. when
     * the decoded frame is cropped before being output or lowres is enabled.
     *
     * @note Those field may not match the value of the last
     * AVFrame output by avcodec_receive_frame() due frame
     * reordering.
     *
     * - encoding: unused
     * - decoding: May be set by the user before opening the decoder if known
     *             e.g. from the container. During decoding, the decoder may
     *             overwrite those values as required while parsing the data.
     *)
    coded_width, coded_height: Integer;

//#if FF_API_ASPECT_EXTENDED
//#define FF_ASPECT_EXTENDED 15
//#endif

    (**
     * the number of pictures in a group of pictures, or 0 for intra_only
     * - encoding: Set by user.
     * - decoding: unused
     *)
    gop_size: Integer;

    (**
     * Pixel format, see AV_PIX_FMT_xxx.
     * May be set by the demuxer if known from headers.
     * May be overridden by the decoder if it knows better.
     *
     * @note This field may not match the value of the last
     * AVFrame output by avcodec_receive_frame() due frame
     * reordering.
     *
     * - encoding: Set by user.
     * - decoding: Set by user if known, overridden by libavcodec while
     *             parsing the data.
     *)
    pix_fmt: TAVPixelFormat;

{$IFDEF FF_API_MOTION_EST}
    (**
     * This option does nothing
     * @deprecated use codec private options instead
     *)
    me_method: Integer;
{$ENDIF}

    (**
     * If non NULL, 'draw_horiz_band' is called by the libavcodec
     * decoder to draw a horizontal band. It improves cache usage. Not
     * all codecs can do that. You must check the codec capabilities
     * beforehand.
     * When multithreading is used, it may be called from multiple threads
     * at the same time; threads might draw different parts of the same AVFrame,
     * or multiple AVFrames, and there is no guarantee that slices will be drawn
     * in order.
     * The function is also used by hardware acceleration APIs.
     * It is called at least once during frame decoding to pass
     * the data needed for hardware render.
     * In that mode instead of pixel data, AVFrame points to
     * a structure specific to the acceleration API. The application
     * reads the structure and can change some fields to indicate progress
     * or mark state.
     * - encoding: unused
     * - decoding: Set by user.
     * @param height the height of the slice
     * @param y the y position of the slice
     * @param type 1->top field, 2->bottom field, 3->frame
     * @param offset offset into the AVFrame.data from which the slice should be read
     *)
    draw_horiz_band: procedure (s: PAVCodecContext;
                            const src: PAVFrame; offset: PInteger;{int offset[AV_NUM_DATA_POINTERS]}
                            y, ttype, height: Integer); cdecl;

    (**
     * callback to negotiate the pixelFormat
     * @param fmt is the list of formats which are supported by the codec,
     * it is terminated by -1 as 0 is a valid format, the formats are ordered by quality.
     * The first is always the native one.
     * @note The callback may be called again immediately if initialization for
     * the selected (hardware-accelerated) pixel format failed.
     * @warning Behavior is undefined if the callback returns a value not
     * in the fmt list of formats.
     * @return the chosen format
     * - encoding: unused
     * - decoding: Set by user, if not set the native format will be chosen.
     *)
    get_format: function(s: PAVCodecContext; const fmt: PAVPixelFormat): TAVPixelFormat; cdecl;

    (**
     * maximum number of B-frames between non-B-frames
     * Note: The output will be delayed by max_b_frames+1 relative to the input.
     * - encoding: Set by user.
     * - decoding: unused
     *)
    max_b_frames: Integer;

    (**
     * qscale factor between IP and B-frames
     * If > 0 then the last P-frame quantizer will be used (q= lastp_q*factor+offset).
     * If < 0 then normal ratecontrol will be done (q= -normal_q*factor+offset).
     * - encoding: Set by user.
     * - decoding: unused
     *)
    b_quant_factor: Single;

{$IFDEF FF_API_RC_STRATEGY}
    (** @deprecated use codec private option instead *)
    rc_strategy: Integer;
//#define FF_RC_STRATEGY_XVID 1
{$ENDIF}

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    b_frame_strategy: Integer;
{$ENDIF}

    (**
     * qscale offset between IP and B-frames
     * - encoding: Set by user.
     * - decoding: unused
     *)
    b_quant_offset: Single;

    (**
     * Size of the frame reordering buffer in the decoder.
     * For MPEG-2 it is 1 IPB or 0 low delay IP.
     * - encoding: Set by libavcodec.
     * - decoding: Set by libavcodec.
     *)
    has_b_frames: Integer;

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    mpeg_quant: Integer;
{$ENDIF}

    (**
     * qscale factor between P- and I-frames
     * If > 0 then the last P-frame quantizer will be used (q = lastp_q * factor + offset).
     * If < 0 then normal ratecontrol will be done (q= -normal_q*factor+offset).
     * - encoding: Set by user.
     * - decoding: unused
     *)
    i_quant_factor: Single;

    (**
     * qscale offset between P and I-frames
     * - encoding: Set by user.
     * - decoding: unused
     *)
    i_quant_offset: Single;

    (**
     * luminance masking (0-> disabled)
     * - encoding: Set by user.
     * - decoding: unused
     *)
    lumi_masking: Single;

    (**
     * temporary complexity masking (0-> disabled)
     * - encoding: Set by user.
     * - decoding: unused
     *)
    temporal_cplx_masking: Single;

    (**
     * spatial complexity masking (0-> disabled)
     * - encoding: Set by user.
     * - decoding: unused
     *)
    spatial_cplx_masking: Single;

    (**
     * p block masking (0-> disabled)
     * - encoding: Set by user.
     * - decoding: unused
     *)
    p_masking: Single;

    (**
     * darkness masking (0-> disabled)
     * - encoding: Set by user.
     * - decoding: unused
     *)
    dark_masking: Single;

    (**
     * slice count
     * - encoding: Set by libavcodec.
     * - decoding: Set by user (or 0).
     *)
    slice_count: Integer;

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    prediction_method: Integer;
{
#define FF_PRED_LEFT   0
#define FF_PRED_PLANE  1
#define FF_PRED_MEDIAN 2
}
{$ENDIF}

    (**
     * slice offsets in the frame in bytes
     * - encoding: Set/allocated by libavcodec.
     * - decoding: Set/allocated by user (or NULL).
     *)
    slice_offset: PInteger;

    (**
     * sample aspect ratio (0 if unknown)
     * That is the width of a pixel divided by the height of the pixel.
     * Numerator and denominator must be relatively prime and smaller than 256 for some video standards.
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     *)
    sample_aspect_ratio: TAVRational;

    (**
     * motion estimation comparison function
     * - encoding: Set by user.
     * - decoding: unused
     *)
    me_cmp: Integer;
    (**
     * subpixel motion estimation comparison function
     * - encoding: Set by user.
     * - decoding: unused
     *)
    me_sub_cmp: Integer;
    (**
     * macroblock comparison function (not supported yet)
     * - encoding: Set by user.
     * - decoding: unused
     *)
    mb_cmp: Integer;
    (**
     * interlaced DCT comparison function
     * - encoding: Set by user.
     * - decoding: unused
     *)
    ildct_cmp: Integer;
{
#define FF_CMP_SAD          0
#define FF_CMP_SSE          1
#define FF_CMP_SATD         2
#define FF_CMP_DCT          3
#define FF_CMP_PSNR         4
#define FF_CMP_BIT          5
#define FF_CMP_RD           6
#define FF_CMP_ZERO         7
#define FF_CMP_VSAD         8
#define FF_CMP_VSSE         9
#define FF_CMP_NSSE         10
#define FF_CMP_W53          11
#define FF_CMP_W97          12
#define FF_CMP_DCTMAX       13
#define FF_CMP_DCT264       14
#define FF_CMP_MEDIAN_SAD   15
#define FF_CMP_CHROMA       256
}
    (**
     * ME diamond size & shape
     * - encoding: Set by user.
     * - decoding: unused
     *)
    dia_size: Integer;

    (**
     * amount of previous MV predictors (2a+1 x 2a+1 square)
     * - encoding: Set by user.
     * - decoding: unused
     *)
    last_predictor_count: Integer;

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    pre_me: Integer;
{$ENDIF}

    (**
     * motion estimation prepass comparison function
     * - encoding: Set by user.
     * - decoding: unused
     *)
    me_pre_cmp: Integer;

    (**
     * ME prepass diamond size & shape
     * - encoding: Set by user.
     * - decoding: unused
     *)
    pre_dia_size: Integer;

    (**
     * subpel ME quality
     * - encoding: Set by user.
     * - decoding: unused
     *)
    me_subpel_quality: Integer;

{$IFDEF FF_API_AFD}
    (**
     * DTG active format information (additional aspect ratio
     * information only used in DVB MPEG-2 transport streams)
     * 0 if not set.
     *
     * - encoding: unused
     * - decoding: Set by decoder.
     * @deprecated Deprecated in favor of AVSideData
     *)
    dtg_active_format: Integer;
{
#define FF_DTG_AFD_SAME         8
#define FF_DTG_AFD_4_3          9
#define FF_DTG_AFD_16_9         10
#define FF_DTG_AFD_14_9         11
#define FF_DTG_AFD_4_3_SP_14_9  13
#define FF_DTG_AFD_16_9_SP_14_9 14
#define FF_DTG_AFD_SP_4_3       15
}
{$ENDIF} (* FF_API_AFD *)
    (**
     * maximum motion estimation search range in subpel units
     * If 0 then no limit.
     *
     * - encoding: Set by user.
     * - decoding: unused
     *)
    me_range: Integer;

{$IFDEF FF_API_QUANT_BIAS}
    (**
     * @deprecated use encoder private option instead
     *)
    intra_quant_bias: Integer;
//#define FF_DEFAULT_QUANT_BIAS 999999

    (**
     * @deprecated use encoder private option instead
     *)
    inter_quant_bias: Integer;
{$ENDIF}

    (**
     * slice flags
     * - encoding: unused
     * - decoding: Set by user.
     *)
    slice_flags: Integer;
{
#define SLICE_FLAG_CODED_ORDER    0x0001 ///< draw_horiz_band() is called in coded order instead of display
#define SLICE_FLAG_ALLOW_FIELD    0x0002 ///< allow draw_horiz_band() with field slices (MPEG-2 field pics)
#define SLICE_FLAG_ALLOW_PLANE    0x0004 ///< allow draw_horiz_band() with 1 component at a time (SVQ1)
}

{$IFDEF FF_API_XVMC}
    (**
     * XVideo Motion Acceleration
     * - encoding: forbidden
     * - decoding: set by decoder
     * @deprecated XvMC doesn't need it anymore.
     *)
    xvmc_acceleration: Integer;
{$ENDIF}

    (**
     * macroblock decision mode
     * - encoding: Set by user.
     * - decoding: unused
     *)
    mb_decision: Integer;
{
#define FF_MB_DECISION_SIMPLE 0        ///< uses mb_cmp
#define FF_MB_DECISION_BITS   1        ///< chooses the one which needs the fewest bits
#define FF_MB_DECISION_RD     2        ///< rate distortion
}
    (**
     * custom intra quantization matrix
     * - encoding: Set by user, can be NULL.
     * - decoding: Set by libavcodec.
     *)
    intra_matrix: PWord;

    (**
     * custom inter quantization matrix
     * - encoding: Set by user, can be NULL.
     * - decoding: Set by libavcodec.
     *)
    inter_matrix: PWord;

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    scenechange_threshold: Integer;

    (** @deprecated use encoder private options instead *)
    noise_reduction: Integer;
{$ENDIF}

{$IFDEF FF_API_MPV_OPT}
    (**
     * @deprecated this field is unused
     *)
    me_threshold: Integer;

    (**
     * @deprecated this field is unused
     *)
    mb_threshold: Integer;
{$ENDIF}

    (**
     * precision of the intra DC coefficient - 8
     * - encoding: Set by user.
     * - decoding: Set by libavcodec
     *)
    intra_dc_precision: Integer;

    (**
     * Number of macroblock rows at the top which are skipped.
     * - encoding: unused
     * - decoding: Set by user.
     *)
    skip_top: Integer;

    (**
     * Number of macroblock rows at the bottom which are skipped.
     * - encoding: unused
     * - decoding: Set by user.
     *)
    skip_bottom: Integer;

{$IFDEF FF_API_MPV_OPT}
    (**
     * @deprecated use encoder private options instead
     *)
    border_masking: Single;
{$ENDIF}

    (**
     * minimum MB Lagrange multiplier
     * - encoding: Set by user.
     * - decoding: unused
     *)
    mb_lmin: Integer;

    (**
     * maximum MB Lagrange multiplier
     * - encoding: Set by user.
     * - decoding: unused
     *)
    mb_lmax: Integer;

{$IFDEF FF_API_PRIVATE_OPT}
    (**
     * @deprecated use encoder private options instead
     *)
    me_penalty_compensation: Integer;
{$ENDIF}

    (**
     * - encoding: Set by user.
     * - decoding: unused
     *)
    bidir_refine: Integer;

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    brd_scale: Integer;
{$ENDIF}

    (**
     * minimum GOP size
     * - encoding: Set by user.
     * - decoding: unused
     *)
    keyint_min: Integer;

    (**
     * number of reference frames
     * - encoding: Set by user.
     * - decoding: Set by lavc.
     *)
    refs: Integer;

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    chromaoffset: Integer;
{$ENDIF}

{$IFDEF FF_API_UNUSED_MEMBERS}
    (**
     * Multiplied by qscale for each frame and added to scene_change_score.
     * - encoding: Set by user.
     * - decoding: unused
     *)
    scenechange_factor: Integer;
{$ENDIF}

    (**
     * Note: Value depends upon the compare function used for fullpel ME.
     * - encoding: Set by user.
     * - decoding: unused
     *)
    mv0_threshold: Integer;

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    b_sensitivity: Integer;
{$ENDIF}

    (**
     * Chromaticity coordinates of the source primaries.
     * - encoding: Set by user
     * - decoding: Set by libavcodec
     *)
    color_primaries: TAVColorPrimaries;

    (**
     * Color Transfer Characteristic.
     * - encoding: Set by user
     * - decoding: Set by libavcodec
     *)
    color_trc: TAVColorTransferCharacteristic;

    (**
     * YUV colorspace type.
     * - encoding: Set by user
     * - decoding: Set by libavcodec
     *)
    colorspace: TAVColorSpace;

    (**
     * MPEG vs JPEG YUV range.
     * - encoding: Set by user
     * - decoding: Set by libavcodec
     *)
    color_range: TAVColorRange;

    (**
     * This defines the location of chroma samples.
     * - encoding: Set by user
     * - decoding: Set by libavcodec
     *)
    chroma_sample_location: TAVChromaLocation;

    (**
     * Number of slices.
     * Indicates number of picture subdivisions. Used for parallelized
     * decoding.
     * - encoding: Set by user
     * - decoding: unused
     *)
    slices: Integer;

    (** Field order
     * - encoding: set by libavcodec
     * - decoding: Set by user.
     *)
    field_order: TAVFieldOrder;

    (* audio only *)
    sample_rate: Integer; ///< samples per second
    channels: Integer;    ///< number of audio channels

    (**
     * audio sample format
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     *)
    sample_fmt: TAVSampleFormat;  ///< sample format

    (* The following data should not be initialized. *)
    (**
     * Number of samples per channel in an audio frame.
     *
     * - encoding: set by libavcodec in avcodec_open2(). Each submitted frame
     *   except the last must contain exactly frame_size samples per channel.
     *   May be 0 when the codec has AV_CODEC_CAP_VARIABLE_FRAME_SIZE set, then the
     *   frame size is not restricted.
     * - decoding: may be set by some decoders to indicate constant frame size
     *)
    frame_size: Integer;

    (**
     * Frame counter, set by libavcodec.
     *
     * - decoding: total number of frames returned from the decoder so far.
     * - encoding: total number of frames passed to the encoder so far.
     *
     *   @note the counter is not incremented if encoding/decoding resulted in
     *   an error.
     *)
    frame_number: Integer;

    (**
     * number of bytes per packet if constant and known or 0
     * Used by some WAV based audio codecs.
     *)
    block_align: Integer;

    (**
     * Audio cutoff bandwidth (0 means "automatic")
     * - encoding: Set by user.
     * - decoding: unused
     *)
    cutoff: Integer;

    (**
     * Audio channel layout.
     * - encoding: set by user.
     * - decoding: set by user, may be overwritten by libavcodec.
     *)
    channel_layout: Int64;

    (**
     * Request decoder to use this channel layout if it can (0 for default)
     * - encoding: unused
     * - decoding: Set by user.
     *)
    request_channel_layout: Int64;

    (**
     * Type of service that the audio stream conveys.
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     *)
     audio_service_type: TAVAudioServiceType;

    (**
     * desired sample format
     * - encoding: Not used.
     * - decoding: Set by user.
     * Decoder will decode to this format if it can.
     *)
    request_sample_fmt: TAVSampleFormat;

    (**
     * This callback is called at the beginning of each frame to get data
     * buffer(s) for it. There may be one contiguous buffer for all the data or
     * there may be a buffer per each data plane or anything in between. What
     * this means is, you may set however many entries in buf[] you feel necessary.
     * Each buffer must be reference-counted using the AVBuffer API (see description
     * of buf[] below).
     *
     * The following fields will be set in the frame before this callback is
     * called:
     * - format
     * - width, height (video only)
     * - sample_rate, channel_layout, nb_samples (audio only)
     * Their values may differ from the corresponding values in
     * AVCodecContext. This callback must use the frame values, not the codec
     * context values, to calculate the required buffer size.
     *
     * This callback must fill the following fields in the frame:
     * - data[]
     * - linesize[]
     * - extended_data:
     *   * if the data is planar audio with more than 8 channels, then this
     *     callback must allocate and fill extended_data to contain all pointers
     *     to all data planes. data[] must hold as many pointers as it can.
     *     extended_data must be allocated with av_malloc() and will be freed in
     *     av_frame_unref().
     *   * otherwise extended_data must point to data
     * - buf[] must contain one or more pointers to AVBufferRef structures. Each of
     *   the frame's data and extended_data pointers must be contained in these. That
     *   is, one AVBufferRef for each allocated chunk of memory, not necessarily one
     *   AVBufferRef per data[] entry. See: av_buffer_create(), av_buffer_alloc(),
     *   and av_buffer_ref().
     * - extended_buf and nb_extended_buf must be allocated with av_malloc() by
     *   this callback and filled with the extra buffers if there are more
     *   buffers than buf[] can hold. extended_buf will be freed in
     *   av_frame_unref().
     *
     * If AV_CODEC_CAP_DR1 is not set then get_buffer2() must call
     * avcodec_default_get_buffer2() instead of providing buffers allocated by
     * some other means.
     *
     * Each data plane must be aligned to the maximum required by the target
     * CPU.
     *
     * @see avcodec_default_get_buffer2()
     *
     * Video:
     *
     * If AV_GET_BUFFER_FLAG_REF is set in flags then the frame may be reused
     * (read and/or written to if it is writable) later by libavcodec.
     *
     * avcodec_align_dimensions2() should be used to find the required width and
     * height, as they normally need to be rounded up to the next multiple of 16.
     *
     * Some decoders do not support linesizes changing between frames.
     *
     * If frame multithreading is used and thread_safe_callbacks is set,
     * this callback may be called from a different thread, but not from more
     * than one at once. Does not need to be reentrant.
     *
     * @see avcodec_align_dimensions2()
     *
     * Audio:
     *
     * Decoders request a buffer of a particular size by setting
     * AVFrame.nb_samples prior to calling get_buffer2(). The decoder may,
     * however, utilize only part of the buffer by setting AVFrame.nb_samples
     * to a smaller value in the output frame.
     *
     * As a convenience, av_samples_get_buffer_size() and
     * av_samples_fill_arrays() in libavutil may be used by custom get_buffer2()
     * functions to find the required data size and to fill data pointers and
     * linesize. In AVFrame.linesize, only linesize[0] may be set for audio
     * since all planes must be the same size.
     *
     * @see av_samples_get_buffer_size(), av_samples_fill_arrays()
     *
     * - encoding: unused
     * - decoding: Set by libavcodec, user can override.
     *)
    get_buffer2: function(s: PAVCodecContext; frame: PAVFrame; flags: Integer): Integer; cdecl;

    (**
     * If non-zero, the decoded audio and video frames returned from
     * avcodec_decode_video2() and avcodec_decode_audio4() are reference-counted
     * and are valid indefinitely. The caller must free them with
     * av_frame_unref() when they are not needed anymore.
     * Otherwise, the decoded frames must not be freed by the caller and are
     * only valid until the next decode call.
     *
     * This is always automatically enabled if avcodec_receive_frame() is used.
     *
     * - encoding: unused
     * - decoding: set by the caller before avcodec_open2().
     *)
    refcounted_frames: Integer;

    (* - encoding parameters *)
    qcompress: Single;  ///< amount of qscale change between easy & hard scenes (0.0-1.0)
    qblur: Single;      ///< amount of qscale smoothing over time (0.0-1.0)

    (**
     * minimum quantizer
     * - encoding: Set by user.
     * - decoding: unused
     *)
    qmin: Integer;

    (**
     * maximum quantizer
     * - encoding: Set by user.
     * - decoding: unused
     *)
    qmax: Integer;

    (**
     * maximum quantizer difference between frames
     * - encoding: Set by user.
     * - decoding: unused
     *)
    max_qdiff: Integer;

{$IFDEF FF_API_MPV_OPT}
    (**
     * @deprecated use encoder private options instead
     *)
    rc_qsquish: Single;

    rc_qmod_amp: Single;
    rc_qmod_freq: Integer;
{$ENDIF}

    (**
     * decoder bitstream buffer size
     * - encoding: Set by user.
     * - decoding: unused
     *)
    rc_buffer_size: Integer;

    (**
     * ratecontrol override, see RcOverride
     * - encoding: Allocated/set/freed by user.
     * - decoding: unused
     *)
    rc_override_count: Integer;
    rc_override: PRcOverride;

{$IFDEF FF_API_MPV_OPT}
    (**
     * @deprecated use encoder private options instead
     *)
    rc_eq: PAnsiChar;
{$ENDIF}

    (**
     * maximum bitrate
     * - encoding: Set by user.
     * - decoding: Set by user, may be overwritten by libavcodec.
     *)
    rc_max_rate: Int64;

    (**
     * minimum bitrate
     * - encoding: Set by user.
     * - decoding: unused
     *)
    rc_min_rate: Int64;

{$IFDEF FF_API_MPV_OPT}
    (**
     * @deprecated use encoder private options instead
     *)
    rc_buffer_aggressivity: Single;
    rc_initial_cplx: Single;
{$ENDIF}

    (**
     * Ratecontrol attempt to use, at maximum, <value> of what can be used without an underflow.
     * - encoding: Set by user.
     * - decoding: unused.
     *)
    rc_max_available_vbv_use: Single;

    (**
     * Ratecontrol attempt to use, at least, <value> times the amount needed to prevent a vbv overflow.
     * - encoding: Set by user.
     * - decoding: unused.
     *)
    rc_min_vbv_overflow_use: Single;

    (**
     * Number of bits which should be loaded into the rc buffer before decoding starts.
     * - encoding: Set by user.
     * - decoding: unused
     *)
    rc_initial_buffer_occupancy: Integer;

{$IFDEF FF_API_CODER_TYPE}
{
#define FF_CODER_TYPE_VLC       0
#define FF_CODER_TYPE_AC        1
#define FF_CODER_TYPE_RAW       2
#define FF_CODER_TYPE_RLE       3
#if FF_API_UNUSED_MEMBERS
#define FF_CODER_TYPE_DEFLATE   4
#endif /* FF_API_UNUSED_MEMBERS */
}
    (**
     * @deprecated use encoder private options instead
     *)
    coder_type: Integer;
{$ENDIF} (* FF_API_CODER_TYPE *)

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    context_model: Integer;
{$ENDIF}

{$IFDEF FF_API_MPV_OPT}
    (**
     * @deprecated use encoder private options instead
     *)
    lmin: Integer;

    (**
     * @deprecated use encoder private options instead
     *)
    lmax: Integer;
{$ENDIF}

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    frame_skip_threshold: Integer;

    (** @deprecated use encoder private options instead *)
    frame_skip_factor: Integer;

    (** @deprecated use encoder private options instead *)
    frame_skip_exp: Integer;

    (** @deprecated use encoder private options instead *)
    frame_skip_cmp: Integer;
{$ENDIF} (* FF_API_PRIVATE_OPT *)

    (**
     * trellis RD quantization
     * - encoding: Set by user.
     * - decoding: unused
     *)
    trellis: Integer;

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    min_prediction_order: Integer;

    (** @deprecated use encoder private options instead *)
    max_prediction_order: Integer;

    (** @deprecated use encoder private options instead *)
    timecode_frame_start: Int64;
{$ENDIF}

{$IFDEF FF_API_RTP_CALLBACK}
    (**
     * @deprecated unused
     *)
    (* The RTP callback: This function is called    *)
    (* every time the encoder has a packet to send. *)
    (* It depends on the encoder if the data starts *)
    (* with a Start Code (it should). H.263 does.   *)
    (* mb_nb contains the number of macroblocks     *)
    (* encoded in the RTP payload.                  *)
    //void (*rtp_callback)(struct AVCodecContext *avctx, void *data, int size, int mb_nb);
    rtp_callback: procedure(avctx: PAVCodecContext; data: Pointer; size, mb_nb: Integer);
{$ENDIF}

{$IFDEF FF_API_PRIVATE_OPT}
    (** @deprecated use encoder private options instead *)
    rtp_payload_size: Integer;   (* The size of the RTP payload: the coder will  *)
                            (* do its best to deliver a chunk with size     *)
                            (* below rtp_payload_size, the chunk will start *)
                            (* with a start code on some codecs like H.263. *)
                            (* This doesn't take account of any particular  *)
                            (* headers inside the transmitted RTP payload.  *)
{$ENDIF}

{$IFDEF FF_API_STAT_BITS}
    (* statistics, used for 2-pass encoding *)
    mv_bits: Integer;
    header_bits: Integer;
    i_tex_bits: Integer;
    p_tex_bits: Integer;
    i_count: Integer;
    p_count: Integer;
    skip_count: Integer;
    misc_bits: Integer;

    (** @deprecated this field is unused *)
    frame_bits: Integer;
{$ENDIF}

    (**
     * pass1 encoding statistics output buffer
     * - encoding: Set by libavcodec.
     * - decoding: unused
     *)
    stats_out: PAnsiChar;

    (**
     * pass2 encoding statistics input buffer
     * Concatenated stuff from stats_out of pass1 should be placed here.
     * - encoding: Allocated/set/freed by user.
     * - decoding: unused
     *)
    stats_in: PAnsiChar;

    (**
     * Work around bugs in encoders which sometimes cannot be detected automatically.
     * - encoding: Set by user
     * - decoding: Set by user
     *)
    workaround_bugs: Integer;
{
#define FF_BUG_AUTODETECT       1  ///< autodetection
#if FF_API_OLD_MSMPEG4
#define FF_BUG_OLD_MSMPEG4      2
#endif
#define FF_BUG_XVID_ILACE       4
#define FF_BUG_UMP4             8
#define FF_BUG_NO_PADDING       16
#define FF_BUG_AMV              32
#if FF_API_AC_VLC
#define FF_BUG_AC_VLC           0  ///< Will be removed, libavcodec can now handle these non-compliant files by default.
#endif
#define FF_BUG_QPEL_CHROMA      64
#define FF_BUG_STD_QPEL         128
#define FF_BUG_QPEL_CHROMA2     256
#define FF_BUG_DIRECT_BLOCKSIZE 512
#define FF_BUG_EDGE             1024
#define FF_BUG_HPEL_CHROMA      2048
#define FF_BUG_DC_CLIP          4096
#define FF_BUG_MS               8192 ///< Work around various bugs in Microsoft's broken decoders.
#define FF_BUG_TRUNCATED       16384
#define FF_BUG_IEDGE           32768
}

    (**
     * strictly follow the standard (MPEG-4, ...).
     * - encoding: Set by user.
     * - decoding: Set by user.
     * Setting this to STRICT or higher means the encoder and decoder will
     * generally do stupid things, whereas setting it to unofficial or lower
     * will mean the encoder might produce output that is not supported by all
     * spec-compliant decoders. Decoders don't differentiate between normal,
     * unofficial and experimental (that is, they always try to decode things
     * when they can) unless they are explicitly asked to behave stupidly
     * (=strictly conform to the specs)
     *)
    strict_std_compliance: Integer;
{
#define FF_COMPLIANCE_VERY_STRICT   2 ///< Strictly conform to an older more strict version of the spec or reference software.
#define FF_COMPLIANCE_STRICT        1 ///< Strictly conform to all the things in the spec no matter what consequences.
#define FF_COMPLIANCE_NORMAL        0
#define FF_COMPLIANCE_UNOFFICIAL   -1 ///< Allow unofficial extensions
#define FF_COMPLIANCE_EXPERIMENTAL -2 ///< Allow nonstandardized experimental things.
}

    (**
     * error concealment flags
     * - encoding: unused
     * - decoding: Set by user.
     *)
    error_concealment: Integer;
//#define FF_EC_GUESS_MVS   1
//#define FF_EC_DEBLOCK     2
//#define FF_EC_FAVOR_INTER 256

    (**
     * debug
     * - encoding: Set by user.
     * - decoding: Set by user.
     *)
    debug: Integer;
{
#define FF_DEBUG_PICT_INFO   1
#define FF_DEBUG_RC          2
#define FF_DEBUG_BITSTREAM   4
#define FF_DEBUG_MB_TYPE     8
#define FF_DEBUG_QP          16
#if FF_API_DEBUG_MV
/**
 * @deprecated this option does nothing
 */
#define FF_DEBUG_MV          32
#endif
#define FF_DEBUG_DCT_COEFF   0x00000040
#define FF_DEBUG_SKIP        0x00000080
#define FF_DEBUG_STARTCODE   0x00000100
#if FF_API_UNUSED_MEMBERS
#define FF_DEBUG_PTS         0x00000200
#endif /* FF_API_UNUSED_MEMBERS */
#define FF_DEBUG_ER          0x00000400
#define FF_DEBUG_MMCO        0x00000800
#define FF_DEBUG_BUGS        0x00001000
#if FF_API_DEBUG_MV
#define FF_DEBUG_VIS_QP      0x00002000
#define FF_DEBUG_VIS_MB_TYPE 0x00004000
#endif
#define FF_DEBUG_BUFFERS     0x00008000
#define FF_DEBUG_THREADS     0x00010000
#define FF_DEBUG_GREEN_MD    0x00800000
#define FF_DEBUG_NOMC        0x01000000
}

{$IFDEF FF_API_DEBUG_MV}
    (**
     * debug
     * - encoding: Set by user.
     * - decoding: Set by user.
     *)
    debug_mv: Integer;
{
#define FF_DEBUG_VIS_MV_P_FOR  0x00000001 // visualize forward predicted MVs of P-frames
#define FF_DEBUG_VIS_MV_B_FOR  0x00000002 // visualize forward predicted MVs of B-frames
#define FF_DEBUG_VIS_MV_B_BACK 0x00000004 // visualize backward predicted MVs of B-frames
}
{$ENDIF}
    (**
     * Error recognition; may misdetect some more or less valid parts as errors.
     * - encoding: unused
     * - decoding: Set by user.
     *)
    err_recognition: Integer;
{
/**
 * Verify checksums embedded in the bitstream (could be of either encoded or
 * decoded data, depending on the codec) and print an error message on mismatch.
 * If AV_EF_EXPLODE is also set, a mismatching checksum will result in the
 * decoder returning an error.
 */
#define AV_EF_CRCCHECK  (1<<0)
#define AV_EF_BITSTREAM (1<<1)          ///< detect bitstream specification deviations
#define AV_EF_BUFFER    (1<<2)          ///< detect improper bitstream length
#define AV_EF_EXPLODE   (1<<3)          ///< abort decoding on minor error detection

#define AV_EF_IGNORE_ERR (1<<15)        ///< ignore errors and continue
#define AV_EF_CAREFUL    (1<<16)        ///< consider things that violate the spec, are fast to calculate and have not been seen in the wild as errors
#define AV_EF_COMPLIANT  (1<<17)        ///< consider all spec non compliances as errors
#define AV_EF_AGGRESSIVE (1<<18)        ///< consider things that a sane encoder should not do as an error
}

    (**
     * opaque 64-bit number (generally a PTS) that will be reordered and
     * output in AVFrame.reordered_opaque
     * - encoding: unused
     * - decoding: Set by user.
     *)
    reordered_opaque: Int64;

    (**
     * Hardware accelerator in use
     * - encoding: unused.
     * - decoding: Set by libavcodec
     *)
    hwaccel: PAVHWAccel;

    (**
     * Hardware accelerator context.
     * For some hardware accelerators, a global context needs to be
     * provided by the user. In that case, this holds display-dependent
     * data FFmpeg cannot instantiate itself. Please refer to the
     * FFmpeg HW accelerator documentation to know how to fill this
     * is. e.g. for VA API, this is a struct vaapi_context.
     * - encoding: unused
     * - decoding: Set by user
     *)
    hwaccel_context: Pointer;

    (**
     * error
     * - encoding: Set by libavcodec if flags & AV_CODEC_FLAG_PSNR.
     * - decoding: unused
     *)
    error: array[0..AV_NUM_DATA_POINTERS-1] of Int64;

    (**
     * DCT algorithm, see FF_DCT_* below
     * - encoding: Set by user.
     * - decoding: unused
     *)
    dct_algo: Integer;
{
#define FF_DCT_AUTO    0
#define FF_DCT_FASTINT 1
#define FF_DCT_INT     2
#define FF_DCT_MMX     3
#define FF_DCT_ALTIVEC 5
#define FF_DCT_FAAN    6
}

    (**
     * IDCT algorithm, see FF_IDCT_* below.
     * - encoding: Set by user.
     * - decoding: Set by user.
     *)
    idct_algo: Integer;
{
#define FF_IDCT_AUTO          0
#define FF_IDCT_INT           1
#define FF_IDCT_SIMPLE        2
#define FF_IDCT_SIMPLEMMX     3
#define FF_IDCT_ARM           7
#define FF_IDCT_ALTIVEC       8
#if FF_API_ARCH_SH4
#define FF_IDCT_SH4           9
#endif
#define FF_IDCT_SIMPLEARM     10
#if FF_API_UNUSED_MEMBERS
#define FF_IDCT_IPP           13
#endif /* FF_API_UNUSED_MEMBERS */
#define FF_IDCT_XVID          14
#if FF_API_IDCT_XVIDMMX
#define FF_IDCT_XVIDMMX       14
#endif /* FF_API_IDCT_XVIDMMX */
#define FF_IDCT_SIMPLEARMV5TE 16
#define FF_IDCT_SIMPLEARMV6   17
#if FF_API_ARCH_SPARC
#define FF_IDCT_SIMPLEVIS     18
#endif
#define FF_IDCT_FAAN          20
#define FF_IDCT_SIMPLENEON    22
#if FF_API_ARCH_ALPHA
#define FF_IDCT_SIMPLEALPHA   23
#endif
#define FF_IDCT_NONE          24 /* Used by XvMC to extract IDCT coefficients with FF_IDCT_PERM_NONE */
#define FF_IDCT_SIMPLEAUTO    128
}

    (**
     * bits per sample/pixel from the demuxer (needed for huffyuv).
     * - encoding: Set by libavcodec.
     * - decoding: Set by user.
     *)
    bits_per_coded_sample: Integer;

    (**
     * Bits per sample/pixel of internal libavcodec pixel/sample format.
     * - encoding: set by user.
     * - decoding: set by libavcodec.
     *)
    bits_per_raw_sample: Integer;

{$IFDEF FF_API_LOWRES}
    (**
     * low resolution decoding, 1-> 1/2 size, 2->1/4 size
     * - encoding: unused
     * - decoding: Set by user.
     *)
     lowres: Integer;
{$ENDIF}

{$IFDEF FF_API_CODED_FRAME}
    (**
     * the picture in the bitstream
     * - encoding: Set by libavcodec.
     * - decoding: unused
     *
     * @deprecated use the quality factor packet side data instead
     *)
    coded_frame: PAVFrame;
{$ENDIF}

    (**
     * thread count
     * is used to decide how many independent tasks should be passed to execute()
     * - encoding: Set by user.
     * - decoding: Set by user.
     *)
    thread_count: Integer;

    (**
     * Which multithreading methods to use.
     * Use of FF_THREAD_FRAME will increase decoding delay by one frame per thread,
     * so clients which cannot provide future frames should not use it.
     *
     * - encoding: Set by user, otherwise the default is used.
     * - decoding: Set by user, otherwise the default is used.
     *)
    thread_type: Integer;
{
#define FF_THREAD_FRAME   1 ///< Decode more than one frame at once
#define FF_THREAD_SLICE   2 ///< Decode more than one part of a single frame at once
}

    (**
     * Which multithreading methods are in use by the codec.
     * - encoding: Set by libavcodec.
     * - decoding: Set by libavcodec.
     *)
    active_thread_type: Integer;

    (**
     * Set by the client if its custom get_buffer() callback can be called
     * synchronously from another thread, which allows faster multithreaded decoding.
     * draw_horiz_band() will be called from other threads regardless of this setting.
     * Ignored if the default get_buffer() is used.
     * - encoding: Set by user.
     * - decoding: Set by user.
     *)
    thread_safe_callbacks: Integer;

    (**
     * The codec may call this to execute several independent things.
     * It will return only after finishing all tasks.
     * The user may replace this with some multithreaded implementation,
     * the default implementation will execute the parts serially.
     * @param count the number of things to execute
     * - encoding: Set by libavcodec, user can override.
     * - decoding: Set by libavcodec, user can override.
     *)
    execute: function (c: PAVCodecContext; func: TexecuteCall; arg2: Pointer; ret: PInteger; count, size: Integer): Integer; cdecl;

    (**
     * The codec may call this to execute several independent things.
     * It will return only after finishing all tasks.
     * The user may replace this with some multithreaded implementation,
     * the default implementation will execute the parts serially.
     * Also see avcodec_thread_init and e.g. the --enable-pthread configure option.
     * @param c context passed also to func
     * @param count the number of things to execute
     * @param arg2 argument passed unchanged to func
     * @param ret return values of executed functions, must have space for "count" values. May be NULL.
     * @param func function that will be called count times, with jobnr from 0 to count-1.
     *             threadnr will be in the range 0 to c->thread_count-1 < MAX_THREADS and so that no
     *             two instances of func executing at the same time will have the same threadnr.
     * @return always 0 currently, but code should handle a future improvement where when any call to func
     *         returns < 0 no further calls to func may be done and < 0 is returned.
     * - encoding: Set by libavcodec, user can override.
     * - decoding: Set by libavcodec, user can override.
     *)
    execute2: function (c: PAVCodecContext; func: Texecute2Call; arg2: Pointer; ret: PInteger; count: Integer): Integer; cdecl;

    (**
     * noise vs. sse weight for the nsse comparison function
     * - encoding: Set by user.
     * - decoding: unused
     *)
     nsse_weight: Integer;

    (**
     * profile
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     *)
     profile: Integer;
{
#define FF_PROFILE_UNKNOWN -99
#define FF_PROFILE_RESERVED -100

#define FF_PROFILE_AAC_MAIN 0
#define FF_PROFILE_AAC_LOW  1
#define FF_PROFILE_AAC_SSR  2
#define FF_PROFILE_AAC_LTP  3
#define FF_PROFILE_AAC_HE   4
#define FF_PROFILE_AAC_HE_V2 28
#define FF_PROFILE_AAC_LD   22
#define FF_PROFILE_AAC_ELD  38
#define FF_PROFILE_MPEG2_AAC_LOW 128
#define FF_PROFILE_MPEG2_AAC_HE  131

#define FF_PROFILE_DNXHD         0
#define FF_PROFILE_DNXHR_LB      1
#define FF_PROFILE_DNXHR_SQ      2
#define FF_PROFILE_DNXHR_HQ      3
#define FF_PROFILE_DNXHR_HQX     4
#define FF_PROFILE_DNXHR_444     5

#define FF_PROFILE_DTS         20
#define FF_PROFILE_DTS_ES      30
#define FF_PROFILE_DTS_96_24   40
#define FF_PROFILE_DTS_HD_HRA  50
#define FF_PROFILE_DTS_HD_MA   60
#define FF_PROFILE_DTS_EXPRESS 70

#define FF_PROFILE_MPEG2_422    0
#define FF_PROFILE_MPEG2_HIGH   1
#define FF_PROFILE_MPEG2_SS     2
#define FF_PROFILE_MPEG2_SNR_SCALABLE  3
#define FF_PROFILE_MPEG2_MAIN   4
#define FF_PROFILE_MPEG2_SIMPLE 5

#define FF_PROFILE_H264_CONSTRAINED  (1<<9)  // 8+1; constraint_set1_flag
#define FF_PROFILE_H264_INTRA        (1<<11) // 8+3; constraint_set3_flag

#define FF_PROFILE_H264_BASELINE             66
#define FF_PROFILE_H264_CONSTRAINED_BASELINE (66|FF_PROFILE_H264_CONSTRAINED)
#define FF_PROFILE_H264_MAIN                 77
#define FF_PROFILE_H264_EXTENDED             88
#define FF_PROFILE_H264_HIGH                 100
#define FF_PROFILE_H264_HIGH_10              110
#define FF_PROFILE_H264_HIGH_10_INTRA        (110|FF_PROFILE_H264_INTRA)
#define FF_PROFILE_H264_MULTIVIEW_HIGH       118
#define FF_PROFILE_H264_HIGH_422             122
#define FF_PROFILE_H264_HIGH_422_INTRA       (122|FF_PROFILE_H264_INTRA)
#define FF_PROFILE_H264_STEREO_HIGH          128
#define FF_PROFILE_H264_HIGH_444             144
#define FF_PROFILE_H264_HIGH_444_PREDICTIVE  244
#define FF_PROFILE_H264_HIGH_444_INTRA       (244|FF_PROFILE_H264_INTRA)
#define FF_PROFILE_H264_CAVLC_444            44

#define FF_PROFILE_VC1_SIMPLE   0
#define FF_PROFILE_VC1_MAIN     1
#define FF_PROFILE_VC1_COMPLEX  2
#define FF_PROFILE_VC1_ADVANCED 3

#define FF_PROFILE_MPEG4_SIMPLE                     0
#define FF_PROFILE_MPEG4_SIMPLE_SCALABLE            1
#define FF_PROFILE_MPEG4_CORE                       2
#define FF_PROFILE_MPEG4_MAIN                       3
#define FF_PROFILE_MPEG4_N_BIT                      4
#define FF_PROFILE_MPEG4_SCALABLE_TEXTURE           5
#define FF_PROFILE_MPEG4_SIMPLE_FACE_ANIMATION      6
#define FF_PROFILE_MPEG4_BASIC_ANIMATED_TEXTURE     7
#define FF_PROFILE_MPEG4_HYBRID                     8
#define FF_PROFILE_MPEG4_ADVANCED_REAL_TIME         9
#define FF_PROFILE_MPEG4_CORE_SCALABLE             10
#define FF_PROFILE_MPEG4_ADVANCED_CODING           11
#define FF_PROFILE_MPEG4_ADVANCED_CORE             12
#define FF_PROFILE_MPEG4_ADVANCED_SCALABLE_TEXTURE 13
#define FF_PROFILE_MPEG4_SIMPLE_STUDIO             14
#define FF_PROFILE_MPEG4_ADVANCED_SIMPLE           15

#define FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_0   1
#define FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_1   2
#define FF_PROFILE_JPEG2000_CSTREAM_NO_RESTRICTION  32768
#define FF_PROFILE_JPEG2000_DCINEMA_2K              3
#define FF_PROFILE_JPEG2000_DCINEMA_4K              4

#define FF_PROFILE_VP9_0                            0
#define FF_PROFILE_VP9_1                            1
#define FF_PROFILE_VP9_2                            2
#define FF_PROFILE_VP9_3                            3

#define FF_PROFILE_HEVC_MAIN                        1
#define FF_PROFILE_HEVC_MAIN_10                     2
#define FF_PROFILE_HEVC_MAIN_STILL_PICTURE          3
#define FF_PROFILE_HEVC_REXT                        4
}
    (**
     * level
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     *)
     level: Integer;
//#define FF_LEVEL_UNKNOWN -99

    (**
     * Skip loop filtering for selected frames.
     * - encoding: unused
     * - decoding: Set by user.
     *)
    skip_loop_filter: TAVDiscard;

    (**
     * Skip IDCT/dequantization for selected frames.
     * - encoding: unused
     * - decoding: Set by user.
     *)
    skip_idct: TAVDiscard;

    (**
     * Skip decoding for selected frames.
     * - encoding: unused
     * - decoding: Set by user.
     *)
    skip_frame: TAVDiscard;

    (**
     * Header containing style information for text subtitles.
     * For SUBTITLE_ASS subtitle type, it should contain the whole ASS
     * [Script Info] and [V4+ Styles] section, plus the [Events] line and
     * the Format line following. It shouldn't include any Dialogue line.
     * - encoding: Set/allocated/freed by user (before avcodec_open2())
     * - decoding: Set/allocated/freed by libavcodec (by avcodec_open2())
     *)
    subtitle_header: PByte;
    subtitle_header_size: Integer;

{$IFDEF FF_API_ERROR_RATE}
    (**
     * @deprecated use the 'error_rate' private AVOption of the mpegvideo
     * encoders
     *)
    error_rate: Integer;
{$ENDIF}

{$IFDEF FF_API_VBV_DELAY}
    (**
     * VBV delay coded in the last frame (in periods of a 27 MHz clock).
     * Used for compliant TS muxing.
     * - encoding: Set by libavcodec.
     * - decoding: unused.
     * @deprecated this value is now exported as a part of
     * AV_PKT_DATA_CPB_PROPERTIES packet side data
     *)
    vbv_delay: Int64;
{$ENDIF}

{$IFDEF FF_API_SIDEDATA_ONLY_PKT}
    (**
     * Encoding only and set by default. Allow encoders to output packets
     * that do not contain any encoded data, only side data.
     *
     * Some encoders need to output such packets, e.g. to update some stream
     * parameters at the end of encoding.
     *
     * @deprecated this field disables the default behaviour and
     *             it is kept only for compatibility.
     *)
    side_data_only_packets: Integer;
{$ENDIF}

    (**
     * Audio only. The number of "priming" samples (padding) inserted by the
     * encoder at the beginning of the audio. I.e. this number of leading
     * decoded samples must be discarded by the caller to get the original audio
     * without leading padding.
     *
     * - decoding: unused
     * - encoding: Set by libavcodec. The timestamps on the output packets are
     *             adjusted by the encoder so that they always refer to the
     *             first sample of the data actually contained in the packet,
     *             including any added padding.  E.g. if the timebase is
     *             1/samplerate and the timestamp of the first input sample is
     *             0, the timestamp of the first output packet will be
     *             -initial_padding.
     *)
    initial_padding: Integer;

    (**
     * - decoding: For codecs that store a framerate value in the compressed
     *             bitstream, the decoder may export it here. { 0, 1} when
     *             unknown.
     * - encoding: May be used to signal the framerate of CFR content to an
     *             encoder.
     *)
    framerate: TAVRational;

    (**
     * Nominal unaccelerated pixel format, see AV_PIX_FMT_xxx.
     * - encoding: unused.
     * - decoding: Set by libavcodec before calling get_format()
     *)
    sw_pix_fmt: TAVPixelFormat;

    (**
     * Timebase in which pkt_dts/pts and AVPacket.dts/pts are.
     * - encoding unused.
     * - decoding set by user.
     *)
    pkt_timebase: TAVRational;

    (**
     * AVCodecDescriptor
     * - encoding: unused.
     * - decoding: set by libavcodec.
     *)
    codec_descriptor: PAVCodecDescriptor;

{$IFNDEF FF_API_LOWRES}
    (**
     * low resolution decoding, 1-> 1/2 size, 2->1/4 size
     * - encoding: unused
     * - decoding: Set by user.
     *)
    lowres: Integer;
{$ENDIF}

    (**
     * Current statistics for PTS correction.
     * - decoding: maintained and used by libavcodec, not intended to be used by user apps
     * - encoding: unused
     *)
    pts_correction_num_faulty_pts: Int64; /// Number of incorrect PTS values so far
    pts_correction_num_faulty_dts: Int64; /// Number of incorrect DTS values so far
    pts_correction_last_pts: Int64;       /// PTS of the last frame
    pts_correction_last_dts: Int64;       /// DTS of the last frame

    (**
     * Character encoding of the input subtitles file.
     * - decoding: set by user
     * - encoding: unused
     *)
    sub_charenc: PAnsiChar;

    (**
     * Subtitles character encoding mode. Formats or codecs might be adjusting
     * this setting (if they are doing the conversion themselves for instance).
     * - decoding: set by libavcodec
     * - encoding: unused
     *)
    sub_charenc_mode: Integer;
{
#define FF_SUB_CHARENC_MODE_DO_NOTHING  -1  ///< do nothing (demuxer outputs a stream supposed to be already in UTF-8, or the codec is bitmap for instance)
#define FF_SUB_CHARENC_MODE_AUTOMATIC    0  ///< libavcodec will select the mode itself
#define FF_SUB_CHARENC_MODE_PRE_DECODER  1  ///< the AVPacket data needs to be recoded to UTF-8 before being fed to the decoder, requires iconv
}

    (**
     * Skip processing alpha if supported by codec.
     * Note that if the format uses pre-multiplied alpha (common with VP6,
     * and recommended due to better video quality/compression)
     * the image will look as if alpha-blended onto a black background.
     * However for formats that do not use pre-multiplied alpha
     * there might be serious artefacts (though e.g. libswscale currently
     * assumes pre-multiplied alpha anyway).
     *
     * - decoding: set by user
     * - encoding: unused
     *)
    skip_alpha: Integer;

    (**
     * Number of samples to skip after a discontinuity
     * - decoding: unused
     * - encoding: set by libavcodec
     *)
    seek_preroll: Integer;

{$IFNDEF FF_API_DEBUG_MV}
    (**
     * debug motion vectors
     * - encoding: Set by user.
     * - decoding: Set by user.
     *)
    debug_mv: Integer;
//#define FF_DEBUG_VIS_MV_P_FOR  0x00000001 //visualize forward predicted MVs of P frames
//#define FF_DEBUG_VIS_MV_B_FOR  0x00000002 //visualize forward predicted MVs of B frames
//#define FF_DEBUG_VIS_MV_B_BACK 0x00000004 //visualize backward predicted MVs of B frames
{$ENDIF}

    (**
     * custom intra quantization matrix
     * - encoding: Set by user, can be NULL.
     * - decoding: unused.
     *)
    chroma_intra_matrix: PWord;

    (**
     * dump format separator.
     * can be ", " or "\n      " or anything else
     * - encoding: Set by user.
     * - decoding: Set by user.
     *)
    dump_separator: PByte;

    (**
     * ',' separated list of allowed decoders.
     * If NULL then all are allowed
     * - encoding: unused
     * - decoding: set by user
     *)
    codec_whitelist: PAnsiChar;

    (**
     * Properties of the stream that gets decoded
     * - encoding: unused
     * - decoding: set by libavcodec
     *)
    properties: Cardinal;
//#define FF_CODEC_PROPERTY_LOSSLESS        0x00000001
//#define FF_CODEC_PROPERTY_CLOSED_CAPTIONS 0x00000002

    (**
     * Additional data associated with the entire coded stream.
     *
     * - decoding: unused
     * - encoding: may be set by libavcodec after avcodec_open2().
     *)
    coded_side_data: PAVPacketSideData;
    nb_coded_side_data: Integer;

    (**
     * A reference to the AVHWFramesContext describing the input (for encoding)
     * or output (decoding) frames. The reference is set by the caller and
     * afterwards owned (and freed) by libavcodec - it should never be read by
     * the caller after being set.
     *
     * - decoding: This field should be set by the caller from the get_format()
     *             callback. The previous reference (if any) will always be
     *             unreffed by libavcodec before the get_format() call.
     *
     *             If the default get_buffer2() is used with a hwaccel pixel
     *             format, then this AVHWFramesContext will be used for
     *             allocating the frame buffers.
     *
     * - encoding: For hardware encoders configured to use a hwaccel pixel
     *             format, this field should be set by the caller to a reference
     *             to the AVHWFramesContext describing input frames.
     *             AVHWFramesContext.format must be equal to
     *             AVCodecContext.pix_fmt.
     *
     *             This field should be set before avcodec_open2() is called.
     *)
    hw_frames_ctx: PAVBufferRef;

    (**
     * Control the form of AVSubtitle.rects[N]->ass
     * - decoding: set by user
     * - encoding: unused
     *)
    sub_text_format: Integer;
//#define FF_SUB_TEXT_FMT_ASS              0
//#if FF_API_ASS_TIMING
//#define FF_SUB_TEXT_FMT_ASS_WITH_TIMINGS 1
//#endif

    (**
     * Audio only. The amount of padding (in samples) appended by the encoder to
     * the end of the audio. I.e. this number of decoded samples must be
     * discarded by the caller from the end of the stream to get the original
     * audio without any trailing padding.
     *
     * - decoding: unused
     * - encoding: unused
     *)
    trailing_padding: Integer;

    (**
     * The number of pixels per image to maximally accept.
     *
     * - decoding: set by user
     * - encoding: set by user
     *)
    max_pixels: Int64;

    (**
     * A reference to the AVHWDeviceContext describing the device which will
     * be used by a hardware encoder/decoder.  The reference is set by the
     * caller and afterwards owned (and freed) by libavcodec.
     *
     * This should be used if either the codec device does not require
     * hardware frames or any that are used are to be allocated internally by
     * libavcodec.  If the user wishes to supply any of the frames used as
     * encoder input or decoder output then hw_frames_ctx should be used
     * instead.  When hw_frames_ctx is set in get_format() for a decoder, this
     * field will be ignored while decoding the associated stream segment, but
     * may again be used on a following one after another get_format() call.
     *
     * For both encoders and decoders this field should be set before
     * avcodec_open2() is called and must not be written to thereafter.
     *
     * Note that some decoders may require this field to be set initially in
     * order to support hw_frames_ctx at all - in that case, all frames
     * contexts used must be created on the same device.
     *)
    hw_device_ctx: PAVBufferRef;

    (**
     * Bit set of AV_HWACCEL_FLAG_* flags, which affect hardware accelerated
     * decoding (if active).
     * - encoding: unused
     * - decoding: Set by user (either before avcodec_open2(), or in the
     *             AVCodecContext.get_format callback)
     *)
    hwaccel_flags: Integer;

    (**
     * Video decoding only. Certain video codecs support cropping, meaning that
     * only a sub-rectangle of the decoded frame is intended for display.  This
     * option controls how cropping is handled by libavcodec.
     *
     * When set to 1 (the default), libavcodec will apply cropping internally.
     * I.e. it will modify the output frame width/height fields and offset the
     * data pointers (only by as much as possible while preserving alignment, or
     * by the full amount if the AV_CODEC_FLAG_UNALIGNED flag is set) so that
     * the frames output by the decoder refer only to the cropped area. The
     * crop_* fields of the output frames will be zero.
     *
     * When set to 0, the width/height fields of the output frames will be set
     * to the coded dimensions and the crop_* fields will describe the cropping
     * rectangle. Applying the cropping is left to the caller.
     *
     * @warning When hardware acceleration with opaque output frames is used,
     * libavcodec is unable to apply cropping from the top/left border.
     *
     * @note when this option is set to zero, the width/height fields of the
     * AVCodecContext and output AVFrames have different meanings. The codec
     * context fields store display dimensions (with the coded dimensions in
     * coded_width/height), while the frame fields store the coded dimensions
     * (with the display dimensions being determined by the crop_* fields).
     *)
    apply_cropping: Integer;
  end;

  PAVCodecDefault = ^TAVCodecDefault;
  TAVCodecDefault = record
    // need {$ALIGN 8}
    // defined in libavcodec/internal.h
  end;

  PAVSubtitle = ^TAVSubtitle;

(**
 * AVCodec.
 *)
  TAVCodec = record
    (**
     * Name of the codec implementation.
     * The name is globally unique among encoders and among decoders (but an
     * encoder and a decoder can share the same name).
     * This is the primary way to find a codec from the user perspective.
     *)
    name: PAnsiChar;
    (**
     * Descriptive name for the codec, meant to be more human readable than name.
     * You should use the NULL_IF_CONFIG_SMALL() macro to define it.
     *)
    long_name: PAnsiChar;
    ttype: TAVMediaType;
    id: TAVCodecID;
    (**
     * Codec capabilities.
     * see AV_CODEC_CAP_*
     *)
    capabilities: Integer;
    supported_framerates: PAVRational;  ///< array of supported framerates, or NULL if any, array is terminated by {0,0}
    pix_fmts: PAVPixelFormat;           ///< array of supported pixel formats, or NULL if unknown, array is terminated by -1
    supported_samplerates: PInteger;    ///< array of supported audio samplerates, or NULL if unknown, array is terminated by 0
    sample_fmts: PAVSampleFormat;       ///< array of supported sample formats, or NULL if unknown, array is terminated by -1
    channel_layouts: PInt64;            ///< array of support channel layouts, or NULL if unknown. array is terminated by 0
    max_lowres: Byte;                   ///< maximum value for lowres supported by the decoder
    priv_class: PAVClass;               ///< AVClass for the private context
    profiles: PAVProfile;               ///< array of recognized profiles, or NULL if unknown, array is terminated by {FF_PROFILE_UNKNOWN}

    (*****************************************************************
     * No fields below this line are part of the public API. They
     * may not be used outside of libavcodec and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     *)
    priv_data_size: Integer;
    next: PAVCodec;
    (**
     * @name Frame-level threading support functions
     * @{
     *)
    (**
     * If defined, called on thread contexts when they are created.
     * If the codec allocates writable tables in init(), re-allocate them here.
     * priv_data will be set to a copy of the original.
     *)
    init_thread_copy: function(ctx: PAVCodecContext): Integer; cdecl;
    (**
     * Copy necessary context variables from a previous thread context to the current one.
     * If not defined, the next thread will start automatically; otherwise, the codec
     * must call ff_thread_finish_setup().
     *
     * dst and src will (rarely) point to the same context, in which case memcpy should be skipped.
     *)
    update_thread_context: function(dst, src: PAVCodecContext): Integer; cdecl;
    (** @} *)

    (**
     * Private codec-specific defaults.
     *)
    defaults: PAVCodecDefault;

    (**
     * Initialize codec static data, called from avcodec_register().
     *)
    init_static_data: function(codec: PAVCodec): Pointer; cdecl;

    init: function(avctx: PAVCodecContext): Integer; cdecl;
    encode_sub: function(avctx: PAVCodecContext; buf: PByte; buf_size: Integer;
                      const sub: PAVSubtitle): Integer; cdecl;
    (**
     * Encode data to an AVPacket.
     *
     * @param      avctx          codec context
     * @param      avpkt          output AVPacket (may contain a user-provided buffer)
     * @param[in]  frame          AVFrame containing the raw data to be encoded
     * @param[out] got_packet_ptr encoder sets to 0 or 1 to indicate that a
     *                            non-empty packet was returned in avpkt.
     * @return 0 on success, negative error code on failure
     *)
    encode2: function(avctx: PAVCodecContext; avpkt: PAVPacket; const frame: PAVFrame;
                      got_packet_ptr: PInteger): Integer; cdecl;
    decode: function(avcctx: PAVCodecContext; outdata: Pointer; outdata_size: PInteger; avpkt: PAVPacket): Integer; cdecl;
    close: function(avcctx: PAVCodecContext): Integer; cdecl;
    (**
     * Encode API with decoupled packet/frame dataflow. The API is the
     * same as the avcodec_ prefixed APIs (avcodec_send_frame() etc.), except
     * that:
     * - never called if the codec is closed or the wrong type,
     * - if AV_CODEC_CAP_DELAY is not set, drain frames are never sent,
     * - only one drain frame is ever passed down,
     *)
    send_frame: function(avctx: PAVCodecContext; const frame: PAVFrame): Integer; cdecl;
    receive_packet: function(avctx: PAVCodecContext; avpkt: PAVPacket): Integer; cdecl;

    (**
     * Decode API with decoupled packet/frame dataflow. This function is called
     * to get one output frame. It should call ff_decode_get_packet() to obtain
     * input data.
     *)
    receive_frame: function(avctx: PAVCodecContext; frame: PAVFrame): Integer; cdecl;
    (**
     * Flush buffers.
     * Will be called when seeking
     *)
    flush: procedure(avcctx: PAVCodecContext); cdecl;
    (**
     * Internal codec capabilities.
     * See FF_CODEC_CAP_* in internal.h
     *)
    caps_internal: Integer;

    (**
     * Decoding only, a comma-separated list of bitstream filters to apply to
     * packets before decoding.
     *)
    bsfs: PAnsiChar;
  end;

  PMpegEncContext = ^TMpegEncContext;
  TMpegEncContext = record
    // need {$ALIGN 8}
    // defined in libavcodec/mpegvideo.h
  end;

(**
 * @defgroup lavc_hwaccel AVHWAccel
 * @{
 *)
  TAVHWAccel = record
    (**
     * Name of the hardware accelerated codec.
     * The name is globally unique among encoders and among decoders (but an
     * encoder and a decoder can share the same name).
     *)
    name: PAnsiChar;

    (**
     * Type of codec implemented by the hardware accelerator.
     *
     * See AVMEDIA_TYPE_xxx
     *)
    ttype: TAVMediaType;

    (**
     * Codec implemented by the hardware accelerator.
     *
     * See AV_CODEC_ID_xxx
     *)
    id: TAVCodecID;

    (**
     * Supported pixel format.
     *
     * Only hardware accelerated formats are supported here.
     *)
    pix_fmt: TAVPixelFormat;

    (**
     * Hardware accelerated codec capabilities.
     * see AV_HWACCEL_CODEC_CAP_*
     *)
    capabilities: Integer;

    (*****************************************************************
     * No fields below this line are part of the public API. They
     * may not be used outside of libavcodec and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     *)
    next: PAVHWAccel;

    (**
     * Allocate a custom buffer
     *)
    alloc_frame: function(avctx: PAVCodecContext; frame: PAVFrame): Integer; cdecl;

    (**
     * Called at the beginning of each frame or field picture.
     *
     * Meaningful frame information (codec specific) is guaranteed to
     * be parsed at this point. This function is mandatory.
     *
     * Note that buf can be NULL along with buf_size set to 0.
     * Otherwise, this means the whole frame is available at this point.
     *
     * @param avctx the codec context
     * @param buf the frame data buffer base
     * @param buf_size the size of the frame in bytes
     * @return zero if successful, a negative value otherwise
     *)
    start_frame: function(avctx: PAVCodecContext; const buf: PByte; buf_size: Cardinal): Integer; cdecl;

    (**
     * Callback for each slice.
     *
     * Meaningful slice information (codec specific) is guaranteed to
     * be parsed at this point. This function is mandatory.
     * The only exception is XvMC, that works on MB level.
     *
     * @param avctx the codec context
     * @param buf the slice data buffer base
     * @param buf_size the size of the slice in bytes
     * @return zero if successful, a negative value otherwise
     *)
    decode_slice: function(avctx: PAVCodecContext; const buf: PByte; buf_size: Cardinal): Integer; cdecl;

    (**
     * Called at the end of each frame or field picture.
     *
     * The whole picture is parsed at this point and can now be sent
     * to the hardware accelerator. This function is mandatory.
     *
     * @param avctx the codec context
     * @return zero if successful, a negative value otherwise
     *)
    end_frame: function(avctx: PAVCodecContext): Integer; cdecl;

    (**
     * Size of per-frame hardware accelerator private data.
     *
     * Private data is allocated with av_mallocz() before
     * AVCodecContext.get_buffer() and deallocated after
     * AVCodecContext.release_buffer().
     *)
    frame_priv_data_size: Integer;

    (**
     * Called for every Macroblock in a slice.
     *
     * XvMC uses it to replace the ff_mpv_reconstruct_mb().
     * Instead of decoding to raw picture, MB parameters are
     * stored in an array provided by the video driver.
     *
     * @param s the mpeg context
     *)
    decode_mb: procedure(s: PMpegEncContext); cdecl;

    (**
     * Initialize the hwaccel private data.
     *
     * This will be called from ff_get_format(), after hwaccel and
     * hwaccel_context are set and the hwaccel private data in AVCodecInternal
     * is allocated.
     *)
    init: function(avctx: PAVCodecContext): Integer; cdecl;

    (**
     * Uninitialize the hwaccel private data.
     *
     * This will be called from get_format() or avcodec_close(), after hwaccel
     * and hwaccel_context are already uninitialized.
     *)
    uninit: function(avctx: PAVCodecContext): Integer; cdecl;

    (**
     * Size of the private data to allocate in
     * AVCodecInternal.hwaccel_priv_data.
     *)
    priv_data_size: Integer;

    (**
     * Internal hwaccel capabilities.
     *)
    caps_internal: Integer;
  end;

(**
 * @}
 *)

{$IFDEF FF_API_AVPICTURE}
(**
 * @defgroup lavc_picture AVPicture
 *
 * Functions for working with AVPicture
 * @{
 *)

(**
 * Picture data structure.
 *
 * Up to four components can be stored into it, the last component is
 * alpha.
 * @deprecated use AVFrame or imgutils functions instead
 *)
  PAVPicture = ^TAVPicture;
  TAVPicture = record
    data: array[0..AV_NUM_DATA_POINTERS-1] of PByte;        ///< pointers to the image data planes
    linesize: array[0..AV_NUM_DATA_POINTERS-1] of Integer;  ///< number of bytes per line
  end;

(**
 * @}
 *)
{$ENDIF}

  TAVSubtitleType = (
    SUBTITLE_NONE,

    SUBTITLE_BITMAP,                ///< A bitmap, pict will be set

    (**
     * Plain text, the text field must be set by the decoder and is
     * authoritative. ass and pict fields may contain approximations.
     *)
    SUBTITLE_TEXT,

    (**
     * Formatted text, the ass field must be set by the decoder and is
     * authoritative. pict and text fields may contain approximations.
     *)
    SUBTITLE_ASS
  );

//#define AV_SUBTITLE_FLAG_FORCED 0x00000001

  PPAVSubtitleRect = ^PAVSubtitleRect;
  PAVSubtitleRect = ^TAVSubtitleRect;
  TAVSubtitleRect = record
    x: Integer;         ///< top left corner  of pict, undefined when pict is not set
    y: Integer;         ///< top left corner  of pict, undefined when pict is not set
    w: Integer;         ///< width            of pict, undefined when pict is not set
    h: Integer;         ///< height           of pict, undefined when pict is not set
    nb_colors: Integer; ///< number of colors in pict, undefined when pict is not set

{$IFDEF FF_API_AVPICTURE}
    (**
     * @deprecated unused
     *)
    pict: TAVPicture;
{$ENDIF}

    (**
     * data+linesize for the bitmap of this subtitle.
     * Can be set for text/ass as well once they are rendered.
     *)
    data: array[0..3] of PByte;
    linesize: array[0..3] of Integer;

    ttype: TAVSubtitleType;

    text: PAnsiChar;                     ///< 0 terminated plain UTF-8 text

    (**
     * 0 terminated ASS/SSA compatible event line.
     * The presentation of this is unaffected by the other values in this
     * struct.
     *)
    ass: PAnsiChar;

    flags: Integer;
  end;

  TAVSubtitle = record
    format: Word; (* 0 = graphics *)
    start_display_time: Cardinal; (* relative to packet pts, in ms *)
    end_display_time: Cardinal; (* relative to packet pts, in ms *)
    num_rects: Cardinal;
    rects: PPAVSubtitleRect;
    pts: Int64;    ///< Same as packet pts, in AV_TIME_BASE
  end;

(**
 * This struct describes the properties of an encoded stream.
 *
 * sizeof(AVCodecParameters) is not a part of the public ABI, this struct must
 * be allocated with avcodec_parameters_alloc() and freed with
 * avcodec_parameters_free().
 *)
  PPAVCodecParameters = ^PAVCodecParameters;
  PAVCodecParameters = ^TAVCodecParameters;
  TAVCodecParameters = record
    (**
     * General type of the encoded data.
     *)
    codec_type: TAVMediaType;
    (**
     * Specific type of the encoded data (the codec used).
     *)
    codec_id: TAVCodecID;
    (**
     * Additional information about the codec (corresponds to the AVI FOURCC).
     *)
    //unsigned int codec_tag;
    //codec_tag: Cardinal;
    //codec_tag: array[0..3] of AnsiChar;
    codec_tag: packed record
      case Integer of
        0: (tag: Cardinal);
        1: (fourcc: array[0..3] of AnsiChar);
        2: (fourbb: array[0..3] of Byte);
      end;

    (**
     * Extra binary data needed for initializing the decoder, codec-dependent.
     *
     * Must be allocated with av_malloc() and will be freed by
     * avcodec_parameters_free(). The allocated size of extradata must be at
     * least extradata_size + AV_INPUT_BUFFER_PADDING_SIZE, with the padding
     * bytes zeroed.
     *)
    extradata: PByte;
    (**
     * Size of the extradata content in bytes.
     *)
    extradata_size: Integer;

    (**
     * - video: the pixel format, the value corresponds to enum AVPixelFormat.
     * - audio: the sample format, the value corresponds to enum AVSampleFormat.
     *)
    format: Integer;

    (**
     * The average bitrate of the encoded data (in bits per second).
     *)
    bit_rate: Int64;

    (**
     * The number of bits per sample in the codedwords.
     *
     * This is basically the bitrate per sample. It is mandatory for a bunch of
     * formats to actually decode them. It's the number of bits for one sample in
     * the actual coded bitstream.
     *
     * This could be for example 4 for ADPCM
     * For PCM formats this matches bits_per_raw_sample
     * Can be 0
     *)
    bits_per_coded_sample: Integer;

    (**
     * This is the number of valid bits in each output sample. If the
     * sample format has more bits, the least significant bits are additional
     * padding bits, which are always 0. Use right shifts to reduce the sample
     * to its actual size. For example, audio formats with 24 bit samples will
     * have bits_per_raw_sample set to 24, and format set to AV_SAMPLE_FMT_S32.
     * To get the original sample use "(int32_t)sample >> 8"."
     *
     * For ADPCM this might be 12 or 16 or similar
     * Can be 0
     *)
    bits_per_raw_sample: Integer;

    (**
     * Codec-specific bitstream restrictions that the stream conforms to.
     *)
    profile: Integer;
    level: Integer;

    (**
     * Video only. The dimensions of the video frame in pixels.
     *)
    width: Integer;
    height: Integer;

    (**
     * Video only. The aspect ratio (width / height) which a single pixel
     * should have when displayed.
     *
     * When the aspect ratio is unknown / undefined, the numerator should be
     * set to 0 (the denominator may have any value).
     *)
    sample_aspect_ratio: TAVRational;

    (**
     * Video only. The order of the fields in interlaced video.
     *)
    field_order: TAVFieldOrder;

    (**
     * Video only. Additional colorspace characteristics.
     *)
    color_range: TAVColorRange;
    color_primaries: TAVColorPrimaries;
    color_trc: TAVColorTransferCharacteristic;
    color_space: TAVColorSpace;
    chroma_location: TAVChromaLocation;

    (**
     * Video only. Number of delayed frames.
     *)
    video_delay: Integer;

    (**
     * Audio only. The channel layout bitmask. May be 0 if the channel layout is
     * unknown or unspecified, otherwise the number of bits set must be equal to
     * the channels field.
     *)
    channel_layout: Int64;
    (**
     * Audio only. The number of audio channels.
     *)
    channels: Integer;
    (**
     * Audio only. The number of audio samples per second.
     *)
    sample_rate: Integer;
    (**
     * Audio only. The number of bytes per coded audio frame, required by some
     * formats.
     *
     * Corresponds to nBlockAlign in WAVEFORMATEX.
     *)
    block_align: Integer;
    (**
     * Audio only. Audio frame size, if known. Required by some formats to be static.
     *)
    frame_size: Integer;

    (**
     * Audio only. The amount of padding (in samples) inserted by the encoder at
     * the beginning of the audio. I.e. this number of leading decoded samples
     * must be discarded by the caller to get the original audio without leading
     * padding.
     *)
    initial_padding: Integer;
    (**
     * Audio only. The amount of padding (in samples) appended by the encoder to
     * the end of the audio. I.e. this number of decoded samples must be
     * discarded by the caller from the end of the stream to get the original
     * audio without any trailing padding.
     *)
    trailing_padding: Integer;
    (**
     * Audio only. Number of samples to skip after a discontinuity.
     *)
    seek_preroll: Integer;
  end;

//TODO: API return record  function av_codec_get_pkt_timebase(const avctx: PAVCodecContext): TAVRational; cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_get_pkt_timebase';

{$IFDEF API_Dynamic}
var av_codec_set_pkt_timebase : procedure(avctx: PAVCodecContext; val: TAVRational); cdecl;
{$ELSE API_Dynamic}
procedure av_codec_set_pkt_timebase(avctx: PAVCodecContext; val: TAVRational); cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_set_pkt_timebase';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_codec_get_codec_descriptor : function(const avctx: PAVCodecContext): PAVCodecDescriptor; cdecl;
{$ELSE API_Dynamic}
function av_codec_get_codec_descriptor(const avctx: PAVCodecContext): PAVCodecDescriptor; cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_get_codec_descriptor';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_codec_set_codec_descriptor : procedure(avctx: PAVCodecContext; const desc: PAVCodecDescriptor); cdecl;
{$ELSE API_Dynamic}
procedure av_codec_set_codec_descriptor(avctx: PAVCodecContext; const desc: PAVCodecDescriptor); cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_set_codec_descriptor';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_codec_get_codec_properties : function(const avctx: PAVCodecContext): Cardinal; cdecl;
{$ELSE API_Dynamic}
function av_codec_get_codec_properties(const avctx: PAVCodecContext): Cardinal; cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_get_codec_properties';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_codec_get_lowres : function(const avctx: PAVCodecContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_codec_get_lowres(const avctx: PAVCodecContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_get_lowres';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_codec_set_lowres : procedure(avctx: PAVCodecContext; val: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_codec_set_lowres(avctx: PAVCodecContext; val: Integer); cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_set_lowres';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_codec_get_seek_preroll : function(const avctx: PAVCodecContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_codec_get_seek_preroll(const avctx: PAVCodecContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_get_seek_preroll';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_codec_set_seek_preroll : procedure(avctx: PAVCodecContext; val: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_codec_set_seek_preroll(avctx: PAVCodecContext; val: Integer); cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_set_seek_preroll';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_codec_get_chroma_intra_matrix : function(const avctx: PAVCodecContext): PWord; cdecl;
{$ELSE API_Dynamic}
function av_codec_get_chroma_intra_matrix(const avctx: PAVCodecContext): PWord; cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_get_chroma_intra_matrix';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_codec_set_chroma_intra_matrix : procedure(avctx: PAVCodecContext; val: PWord); cdecl;
{$ELSE API_Dynamic}
procedure av_codec_set_chroma_intra_matrix(avctx: PAVCodecContext; val: PWord); cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_set_chroma_intra_matrix';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_codec_get_max_lowres : function(const codec: PAVCodec): Integer; cdecl;
{$ELSE API_Dynamic}
function av_codec_get_max_lowres(const codec: PAVCodec): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_get_max_lowres';
{$ENDIF API_Dynamic}


(**
 * If c is NULL, returns the first registered codec,
 * if c is non-NULL, returns the next registered codec after c,
 * or NULL if c is the last one.
 *)

{$IFDEF API_Dynamic}
var av_codec_next : function(const c: PAVCodec): PAVCodec; cdecl;
{$ELSE API_Dynamic}
function av_codec_next(const c: PAVCodec): PAVCodec; cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_next';
{$ENDIF API_Dynamic}


(**
 * Return the LIBAVCODEC_VERSION_INT constant.
 *)

{$IFDEF API_Dynamic}
var avcodec_version : function: Cardinal; cdecl;
{$ELSE API_Dynamic}
function avcodec_version: Cardinal; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_version';
{$ENDIF API_Dynamic}


(**
 * Return the libavcodec build-time configuration.
 *)

{$IFDEF API_Dynamic}
var avcodec_configuration : function: PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avcodec_configuration: PAnsiChar; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_configuration';
{$ENDIF API_Dynamic}


(**
 * Return the libavcodec license.
 *)

{$IFDEF API_Dynamic}
var avcodec_license : function: PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avcodec_license: PAnsiChar; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_license';
{$ENDIF API_Dynamic}


(**
 * Register the codec codec and initialize libavcodec.
 *
 * @warning either this function or avcodec_register_all() must be called
 * before any other libavcodec functions.
 *
 * @see avcodec_register_all()
 *)

{$IFDEF API_Dynamic}
var avcodec_register : procedure(codec: PAVCodec); cdecl;
{$ELSE API_Dynamic}
procedure avcodec_register(codec: PAVCodec); cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_register';
{$ENDIF API_Dynamic}


(**
 * Register all the codecs, parsers and bitstream filters which were enabled at
 * configuration time. If you do not call this function you can select exactly
 * which formats you want to support, by using the individual registration
 * functions.
 *
 * @see avcodec_register
 * @see av_register_codec_parser
 * @see av_register_bitstream_filter
 *)

{$IFDEF API_Dynamic}
var avcodec_register_all : procedure; cdecl;
{$ELSE API_Dynamic}
procedure avcodec_register_all; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_register_all';
{$ENDIF API_Dynamic}


(**
 * Allocate an AVCodecContext and set its fields to default values. The
 * resulting struct should be freed with avcodec_free_context().
 *
 * @param codec if non-NULL, allocate private data and initialize defaults
 *              for the given codec. It is illegal to then call avcodec_open2()
 *              with a different codec.
 *              If NULL, then the codec-specific defaults won't be initialized,
 *              which may result in suboptimal default settings (this is
 *              important mainly for encoders, e.g. libx264).
 *
 * @return An AVCodecContext filled with default values or NULL on failure.
 *)

{$IFDEF API_Dynamic}
var avcodec_alloc_context3 : function(const codec: PAVCodec): PAVCodecContext; cdecl;
{$ELSE API_Dynamic}
function avcodec_alloc_context3(const codec: PAVCodec): PAVCodecContext; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_alloc_context3';
{$ENDIF API_Dynamic}


(**
 * Free the codec context and everything associated with it and write NULL to
 * the provided pointer.
 *)

{$IFDEF API_Dynamic}
var avcodec_free_context : procedure(avctx: PPAVCodecContext); cdecl;
{$ELSE API_Dynamic}
procedure avcodec_free_context(avctx: PPAVCodecContext); cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_free_context';
{$ENDIF API_Dynamic}


{$IFDEF FF_API_GET_CONTEXT_DEFAULTS}
(**
 * @deprecated This function should not be used, as closing and opening a codec
 * context multiple time is not supported. A new codec context should be
 * allocated for each new use.
 *)

{$IFDEF API_Dynamic}
var avcodec_get_context_defaults3 : function(s: PAVCodecContext; const codec: PAVCodec): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_get_context_defaults3(s: PAVCodecContext; const codec: PAVCodec): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_get_context_defaults3';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * Get the AVClass for AVCodecContext. It can be used in combination with
 * AV_OPT_SEARCH_FAKE_OBJ for examining options.
 *
 * @see av_opt_find().
 *)

{$IFDEF API_Dynamic}
var avcodec_get_class : function(): PAVClass; cdecl;
{$ELSE API_Dynamic}
function avcodec_get_class(): PAVClass; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_get_class';
{$ENDIF API_Dynamic}


{$IFDEF FF_API_COPY_CONTEXT}
(**
 * Get the AVClass for AVFrame. It can be used in combination with
 * AV_OPT_SEARCH_FAKE_OBJ for examining options.
 *
 * @see av_opt_find().
 *)

{$IFDEF API_Dynamic}
var avcodec_get_frame_class : function(): PAVClass; cdecl;
{$ELSE API_Dynamic}
function avcodec_get_frame_class(): PAVClass; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_get_frame_class';
{$ENDIF API_Dynamic}


(**
 * Get the AVClass for AVSubtitleRect. It can be used in combination with
 * AV_OPT_SEARCH_FAKE_OBJ for examining options.
 *
 * @see av_opt_find().
 *)

{$IFDEF API_Dynamic}
var avcodec_get_subtitle_rect_class : function(): PAVClass; cdecl;
{$ELSE API_Dynamic}
function avcodec_get_subtitle_rect_class(): PAVClass; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_get_subtitle_rect_class';
{$ENDIF API_Dynamic}


(**
 * Copy the settings of the source AVCodecContext into the destination
 * AVCodecContext. The resulting destination codec context will be
 * unopened, i.e. you are required to call avcodec_open2() before you
 * can use this AVCodecContext to decode/encode video/audio data.
 *
 * @param dest target codec context, should be initialized with
 *             avcodec_alloc_context3(NULL), but otherwise uninitialized
 * @param src source codec context
 * @return AVERROR() on error (e.g. memory allocation error), 0 on success
 *
 * @deprecated The semantics of this function are ill-defined and it should not
 * be used. If you need to transfer the stream parameters from one codec context
 * to another, use an intermediate AVCodecParameters instance and the
 * avcodec_parameters_from_context() / avcodec_parameters_to_context()
 * functions.
 *)

{$IFDEF API_Dynamic}
var avcodec_copy_context : function(dest: PAVCodecContext; const src: PAVCodecContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_copy_context(dest: PAVCodecContext; const src: PAVCodecContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_copy_context';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * Allocate a new AVCodecParameters and set its fields to default values
 * (unknown/invalid/0). The returned struct must be freed with
 * avcodec_parameters_free().
 *)

{$IFDEF API_Dynamic}
var avcodec_parameters_alloc : function: PAVCodecParameters; cdecl;
{$ELSE API_Dynamic}
function avcodec_parameters_alloc: PAVCodecParameters; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_parameters_alloc';
{$ENDIF API_Dynamic}


(**
 * Free an AVCodecParameters instance and everything associated with it and
 * write NULL to the supplied pointer.
 *)

{$IFDEF API_Dynamic}
var avcodec_parameters_free : procedure(par: PPAVCodecParameters); cdecl;
{$ELSE API_Dynamic}
procedure avcodec_parameters_free(par: PPAVCodecParameters); cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_parameters_free';
{$ENDIF API_Dynamic}


(**
 * Copy the contents of src to dst. Any allocated fields in dst are freed and
 * replaced with newly allocated duplicates of the corresponding fields in src.
 *
 * @return >= 0 on success, a negative AVERROR code on failure.
 *)

{$IFDEF API_Dynamic}
var avcodec_parameters_copy : function(dst: PAVCodecParameters; const src: PAVCodecParameters): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_parameters_copy(dst: PAVCodecParameters; const src: PAVCodecParameters): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_parameters_copy';
{$ENDIF API_Dynamic}


(**
 * Fill the parameters struct based on the values from the supplied codec
 * context. Any allocated fields in par are freed and replaced with duplicates
 * of the corresponding fields in codec.
 *
 * @return >= 0 on success, a negative AVERROR code on failure
 *)

{$IFDEF API_Dynamic}
var avcodec_parameters_from_context : function(par: PAVCodecParameters; const codec: PAVCodecContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_parameters_from_context(par: PAVCodecParameters; const codec: PAVCodecContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_parameters_from_context';
{$ENDIF API_Dynamic}


(**
 * Fill the codec context based on the values from the supplied codec
 * parameters. Any allocated fields in codec that have a corresponding field in
 * par are freed and replaced with duplicates of the corresponding field in par.
 * Fields in codec that do not have a counterpart in par are not touched.
 *
 * @return >= 0 on success, a negative AVERROR code on failure.
 *)

{$IFDEF API_Dynamic}
var avcodec_parameters_to_context : function(codec: PAVCodecContext; const par: PAVCodecParameters): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_parameters_to_context(codec: PAVCodecContext; const par: PAVCodecParameters): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_parameters_to_context';
{$ENDIF API_Dynamic}


(**
 * Initialize the AVCodecContext to use the given AVCodec. Prior to using this
 * function the context has to be allocated with avcodec_alloc_context3().
 *
 * The functions avcodec_find_decoder_by_name(), avcodec_find_encoder_by_name(),
 * avcodec_find_decoder() and avcodec_find_encoder() provide an easy way for
 * retrieving a codec.
 *
 * @warning This function is not thread safe!
 *
 * @note Always call this function before using decoding routines (such as
 * @ref avcodec_receive_frame()).
 *
 * @code
 * avcodec_register_all();
 * av_dict_set(&opts, "b", "2.5M", 0);
 * codec = avcodec_find_decoder(AV_CODEC_ID_H264);
 * if (!codec)
 *     exit(1);
 *
 * context = avcodec_alloc_context3(codec);
 *
 * if (avcodec_open2(context, codec, opts) < 0)
 *     exit(1);
 * @endcode
 *
 * @param avctx The context to initialize.
 * @param codec The codec to open this context for. If a non-NULL codec has been
 *              previously passed to avcodec_alloc_context3() or
 *              for this context, then this parameter MUST be either NULL or
 *              equal to the previously passed codec.
 * @param options A dictionary filled with AVCodecContext and codec-private options.
 *                On return this object will be filled with options that were not found.
 *
 * @return zero on success, a negative value on error
 * @see avcodec_alloc_context3(), avcodec_find_decoder(), avcodec_find_encoder(),
 *      av_dict_set(), av_opt_find().
 *)

{$IFDEF API_Dynamic}
var avcodec_open2 : function(avctx: PAVCodecContext; const codec: PAVCodec; options: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_open2(avctx: PAVCodecContext; const codec: PAVCodec; options: PPAVDictionary): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_open2';
{$ENDIF API_Dynamic}


(**
 * Close a given AVCodecContext and free all the data associated with it
 * (but not the AVCodecContext itself).
 *
 * Calling this function on an AVCodecContext that hasn't been opened will free
 * the codec-specific data allocated in avcodec_alloc_context3() with a non-NULL
 * codec. Subsequent calls will do nothing.
 *
 * @note Do not use this function. Use avcodec_free_context() to destroy a
 * codec context (either open or closed). Opening and closing a codec context
 * multiple times is not supported anymore -- use multiple codec contexts
 * instead.
 *)

{$IFDEF API_Dynamic}
var avcodec_close : function(avctx: PAVCodecContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_close(avctx: PAVCodecContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_close';
{$ENDIF API_Dynamic}


(**
 * Free all allocated data in the given subtitle struct.
 *
 * @param sub AVSubtitle to free.
 *)

{$IFDEF API_Dynamic}
var avsubtitle_free : procedure(sub: PAVSubtitle); cdecl;
{$ELSE API_Dynamic}
procedure avsubtitle_free(sub: PAVSubtitle); cdecl; external AVCODEC_LIBNAME name _PU + 'avsubtitle_free';
{$ENDIF API_Dynamic}


(**
 * @}
 *)

(**
 * @addtogroup lavc_packet
 * @{
 *)

(**
 * Allocate an AVPacket and set its fields to default values.  The resulting
 * struct must be freed using av_packet_free().
 *
 * @return An AVPacket filled with default values or NULL on failure.
 *
 * @note this only allocates the AVPacket itself, not the data buffers. Those
 * must be allocated through other means such as av_new_packet.
 *
 * @see av_new_packet
 *)

{$IFDEF API_Dynamic}
var av_packet_alloc : function: PAVPacket; cdecl;
{$ELSE API_Dynamic}
function av_packet_alloc: PAVPacket; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_alloc';
{$ENDIF API_Dynamic}


(**
 * Create a new packet that references the same data as src.
 *
 * This is a shortcut for av_packet_alloc()+av_packet_ref().
 *
 * @return newly created AVPacket on success, NULL on error.
 *
 * @see av_packet_alloc
 * @see av_packet_ref
 *)

{$IFDEF API_Dynamic}
var av_packet_clone : function(const src: PAVPacket): PAVPacket; cdecl;
{$ELSE API_Dynamic}
function av_packet_clone(const src: PAVPacket): PAVPacket; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_clone';
{$ENDIF API_Dynamic}


(**
 * Free the packet, if the packet is reference counted, it will be
 * unreferenced first.
 *
 * @param pkt packet to be freed. The pointer will be set to NULL.
 * @note passing NULL is a no-op.
 *)

{$IFDEF API_Dynamic}
var av_packet_free : procedure(pkt: PPAVPacket); cdecl;
{$ELSE API_Dynamic}
procedure av_packet_free(pkt: PPAVPacket); cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_free';
{$ENDIF API_Dynamic}


(**
 * Initialize optional fields of a packet with default values.
 *
 * Note, this does not touch the data and size members, which have to be
 * initialized separately.
 *
 * @param pkt packet
 *)

{$IFDEF API_Dynamic}
var av_init_packet : procedure(pkt: PAVPacket); cdecl;
{$ELSE API_Dynamic}
procedure av_init_packet(pkt: PAVPacket); cdecl; external AVCODEC_LIBNAME name _PU + 'av_init_packet';
{$ENDIF API_Dynamic}


(**
 * Allocate the payload of a packet and initialize its fields with
 * default values.
 *
 * @param pkt packet
 * @param size wanted payload size
 * @return 0 if OK, AVERROR_xxx otherwise
 *)

{$IFDEF API_Dynamic}
var av_new_packet : function(pkt: PAVPacket; size: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_new_packet(pkt: PAVPacket; size: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_new_packet';
{$ENDIF API_Dynamic}


(**
 * Reduce packet size, correctly zeroing padding
 *
 * @param pkt packet
 * @param size new size
 *)

{$IFDEF API_Dynamic}
var av_shrink_packet : procedure(pkt: PAVPacket; size: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_shrink_packet(pkt: PAVPacket; size: Integer); cdecl; external AVCODEC_LIBNAME name _PU + 'av_shrink_packet';
{$ENDIF API_Dynamic}


(**
 * Increase packet size, correctly zeroing padding
 *
 * @param pkt packet
 * @param grow_by number of bytes by which to increase the size of the packet
 *)

{$IFDEF API_Dynamic}
var av_grow_packet : function(pkt: PAVPacket; grow_by: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_grow_packet(pkt: PAVPacket; grow_by: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_grow_packet';
{$ENDIF API_Dynamic}


(**
 * Initialize a reference-counted packet from av_malloc()ed data.
 *
 * @param pkt packet to be initialized. This function will set the data, size,
 *        buf and destruct fields, all others are left untouched.
 * @param data Data allocated by av_malloc() to be used as packet data. If this
 *        function returns successfully, the data is owned by the underlying AVBuffer.
 *        The caller may not access the data through other means.
 * @param size size of data in bytes, without the padding. I.e. the full buffer
 *        size is assumed to be size + AV_INPUT_BUFFER_PADDING_SIZE.
 *
 * @return 0 on success, a negative AVERROR on error
 *)

{$IFDEF API_Dynamic}
var av_packet_from_data : function(pkt: PAVPacket; data: PByte; size: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_packet_from_data(pkt: PAVPacket; data: PByte; size: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_from_data';
{$ENDIF API_Dynamic}


{$IFDEF FF_API_AVPACKET_OLD_API}
(**
 * @warning This is a hack - the packet memory allocation stuff is broken. The
 * packet is allocated if it was not really allocated.
 *
 * @deprecated Use av_packet_ref
 *)

{$IFDEF API_Dynamic}
var av_dup_packet : function(pkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_dup_packet(pkt: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_dup_packet';
{$ENDIF API_Dynamic}


(**
 * Copy packet, including contents
 *
 * @return 0 on success, negative AVERROR on fail
 *
 * @deprecated Use av_packet_ref
 *)

{$IFDEF API_Dynamic}
var av_copy_packet : function(dst: PAVPacket; const src: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_copy_packet(dst: PAVPacket; const src: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_copy_packet';
{$ENDIF API_Dynamic}


(**
 * Copy packet side data
 *
 * @return 0 on success, negative AVERROR on fail
 *
 * @deprecated Use av_packet_copy_props
 *)

{$IFDEF API_Dynamic}
var av_copy_packet_side_data : function(dst: PAVPacket; const src: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_copy_packet_side_data(dst: PAVPacket; const src: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_copy_packet_side_data';
{$ENDIF API_Dynamic}


(**
 * Free a packet.
 *
 * @deprecated Use av_packet_unref
 *
 * @param pkt packet to free
 *)

{$IFDEF API_Dynamic}
var av_free_packet : procedure(pkt: PAVPacket); cdecl;
{$ELSE API_Dynamic}
procedure av_free_packet(pkt: PAVPacket); cdecl; external AVCODEC_LIBNAME name _PU + 'av_free_packet';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * Allocate new information of a packet.
 *
 * @param pkt packet
 * @param type side information type
 * @param size side information size
 * @return pointer to fresh allocated data or NULL otherwise
 *)

{$IFDEF API_Dynamic}
var av_packet_new_side_data : function(pkt: PAVPacket; type_: TAVPacketSideDataType;
                                 size: Integer): PByte; cdecl;
{$ELSE API_Dynamic}
function av_packet_new_side_data(pkt: PAVPacket; type_: TAVPacketSideDataType;
                                 size: Integer): PByte; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_new_side_data';
{$ENDIF API_Dynamic}


(**
 * Wrap an existing array as a packet side data.
 *
 * @param pkt packet
 * @param type side information type
 * @param data the side data array. It must be allocated with the av_malloc()
 *             family of functions. The ownership of the data is transferred to
 *             pkt.
 * @param size side information size
 * @return a non-negative number on success, a negative AVERROR code on
 *         failure. On failure, the packet is unchanged and the data remains
 *         owned by the caller.
 *)

{$IFDEF API_Dynamic}
var av_packet_add_side_data : function(pkt: PAVPacket; type_: TAVPacketSideDataType;
                            data: PByte; size: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function av_packet_add_side_data(pkt: PAVPacket; type_: TAVPacketSideDataType;
                            data: PByte; size: Cardinal): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_add_side_data';
{$ENDIF API_Dynamic}


(**
 * Shrink the already allocated side data buffer
 *
 * @param pkt packet
 * @param type side information type
 * @param size new side information size
 * @return 0 on success, < 0 on failure
 *)

{$IFDEF API_Dynamic}
var av_packet_shrink_side_data : function(pkt: PAVPacket; ttype: TAVPacketSideDataType;
                               size: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_packet_shrink_side_data(pkt: PAVPacket; ttype: TAVPacketSideDataType;
                               size: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_shrink_side_data';
{$ENDIF API_Dynamic}


(**
 * Get side information from packet.
 *
 * @param pkt packet
 * @param type desired side information type
 * @param size pointer for side information size to store (optional)
 * @return pointer to data if present or NULL otherwise
 *)

{$IFDEF API_Dynamic}
var av_packet_get_side_data : function(const pkt: PAVPacket; type_: TAVPacketSideDataType;
                                 size: PInteger): PByte; cdecl;
{$ELSE API_Dynamic}
function av_packet_get_side_data(const pkt: PAVPacket; type_: TAVPacketSideDataType;
                                 size: PInteger): PByte; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_get_side_data';
{$ENDIF API_Dynamic}


{$IFDEF FF_API_MERGE_SD_API}

{$IFDEF API_Dynamic}
var av_packet_merge_side_data : function(pkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_packet_merge_side_data(pkt: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_merge_side_data';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_packet_split_side_data : function(pkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_packet_split_side_data(pkt: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_split_side_data';
{$ENDIF API_Dynamic}

{$ENDIF}


{$IFDEF API_Dynamic}
var av_packet_side_data_name : function(type_: TAVPacketSideDataType): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_packet_side_data_name(type_: TAVPacketSideDataType): PAnsiChar; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_side_data_name';
{$ENDIF API_Dynamic}


(**
 * Pack a dictionary for use in side_data.
 *
 * @param dict The dictionary to pack.
 * @param size pointer to store the size of the returned data
 * @return pointer to data if successful, NULL otherwise
 *)

{$IFDEF API_Dynamic}
var av_packet_pack_dictionary : function(dict: PAVDictionary; size: PInteger): PByte; cdecl;
{$ELSE API_Dynamic}
function av_packet_pack_dictionary(dict: PAVDictionary; size: PInteger): PByte; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_pack_dictionary';
{$ENDIF API_Dynamic}

(**
 * Unpack a dictionary from side_data.
 *
 * @param data data from side_data
 * @param size size of the data
 * @param dict the metadata storage dictionary
 * @return 0 on success, < 0 on failure
 *)

{$IFDEF API_Dynamic}
var av_packet_unpack_dictionary : function(const data: PByte; size: Integer; dict: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function av_packet_unpack_dictionary(const data: PByte; size: Integer; dict: PPAVDictionary): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_unpack_dictionary';
{$ENDIF API_Dynamic}



(**
 * Convenience function to free all the side data stored.
 * All the other fields stay untouched.
 *
 * @param pkt packet
 *)

{$IFDEF API_Dynamic}
var av_packet_free_side_data : procedure(pkt: PAVPacket); cdecl;
{$ELSE API_Dynamic}
procedure av_packet_free_side_data(pkt: PAVPacket); cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_free_side_data';
{$ENDIF API_Dynamic}


(**
 * Setup a new reference to the data described by a given packet
 *
 * If src is reference-counted, setup dst as a new reference to the
 * buffer in src. Otherwise allocate a new buffer in dst and copy the
 * data from src into it.
 *
 * All the other fields are copied from src.
 *
 * @see av_packet_unref
 *
 * @param dst Destination packet
 * @param src Source packet
 *
 * @return 0 on success, a negative AVERROR on error.
 *)

{$IFDEF API_Dynamic}
var av_packet_ref : function(dst: PAVPacket; const src: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_packet_ref(dst: PAVPacket; const src: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_ref';
{$ENDIF API_Dynamic}


(**
 * Wipe the packet.
 *
 * Unreference the buffer referenced by the packet and reset the
 * remaining packet fields to their default values.
 *
 * @param pkt The packet to be unreferenced.
 *)

{$IFDEF API_Dynamic}
var av_packet_unref : procedure(pkt: PAVPacket); cdecl;
{$ELSE API_Dynamic}
procedure av_packet_unref(pkt: PAVPacket); cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_unref';
{$ENDIF API_Dynamic}


(**
 * Move every field in src to dst and reset src.
 *
 * @see av_packet_unref
 *
 * @param src Source packet, will be reset
 * @param dst Destination packet
 *)

{$IFDEF API_Dynamic}
var av_packet_move_ref : procedure(dst, src: PAVPacket); cdecl;
{$ELSE API_Dynamic}
procedure av_packet_move_ref(dst, src: PAVPacket); cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_move_ref';
{$ENDIF API_Dynamic}


(**
 * Copy only "properties" fields from src to dst.
 *
 * Properties for the purpose of this function are all the fields
 * beside those related to the packet data (buf, data, size)
 *
 * @param dst Destination packet
 * @param src Source packet
 *
 * @return 0 on success AVERROR on failure.
 *)

{$IFDEF API_Dynamic}
var av_packet_copy_props : function(dst: PAVPacket; const src: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_packet_copy_props(dst: PAVPacket; const src: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_copy_props';
{$ENDIF API_Dynamic}


(**
 * Convert valid timing fields (timestamps / durations) in a packet from one
 * timebase to another. Timestamps with unknown values (AV_NOPTS_VALUE) will be
 * ignored.
 *
 * @param pkt packet on which the conversion will be performed
 * @param tb_src source timebase, in which the timing fields in pkt are
 *               expressed
 * @param tb_dst destination timebase, to which the timing fields will be
 *               converted
 *)

{$IFDEF API_Dynamic}
var av_packet_rescale_ts : procedure(pkt: PAVPacket; tb_src, tb_dst: TAVRational); cdecl;
{$ELSE API_Dynamic}
procedure av_packet_rescale_ts(pkt: PAVPacket; tb_src, tb_dst: TAVRational); cdecl; external AVCODEC_LIBNAME name _PU + 'av_packet_rescale_ts';
{$ENDIF API_Dynamic}


(**
 * @}
 *)

(**
 * @addtogroup lavc_decoding
 * @{
 *)

(**
 * Find a registered decoder with a matching codec ID.
 *
 * @param id AVCodecID of the requested decoder
 * @return A decoder if one was found, NULL otherwise.
 *)

{$IFDEF API_Dynamic}
var avcodec_find_decoder : function(id: TAVCodecID): PAVCodec; cdecl;
{$ELSE API_Dynamic}
function avcodec_find_decoder(id: TAVCodecID): PAVCodec; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_find_decoder';
{$ENDIF API_Dynamic}


(**
 * Find a registered decoder with the specified name.
 *
 * @param name name of the requested decoder
 * @return A decoder if one was found, NULL otherwise.
 *)

{$IFDEF API_Dynamic}
var avcodec_find_decoder_by_name : function(const name: PAnsiChar): PAVCodec; cdecl;
{$ELSE API_Dynamic}
function avcodec_find_decoder_by_name(const name: PAnsiChar): PAVCodec; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_find_decoder_by_name';
{$ENDIF API_Dynamic}


(**
 * The default callback for AVCodecContext.get_buffer2(). It is made public so
 * it can be called by custom get_buffer2() implementations for decoders without
 * AV_CODEC_CAP_DR1 set.
 *)

{$IFDEF API_Dynamic}
var avcodec_default_get_buffer2 : function(s: PAVCodecContext; frame: PAVFrame; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_default_get_buffer2(s: PAVCodecContext; frame: PAVFrame; flags: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_default_get_buffer2';
{$ENDIF API_Dynamic}


{$IFDEF FF_API_EMU_EDGE}
(**
 * Return the amount of padding in pixels which the get_buffer callback must
 * provide around the edge of the image for codecs which do not have the
 * CODEC_FLAG_EMU_EDGE flag.
 *
 * @return Required padding in pixels.
 *
 * @deprecated CODEC_FLAG_EMU_EDGE is deprecated, so this function is no longer
 * needed
 *)

{$IFDEF API_Dynamic}
var avcodec_get_edge_width : function: Cardinal; cdecl;
{$ELSE API_Dynamic}
function avcodec_get_edge_width: Cardinal; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_get_edge_width';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * Modify width and height values so that they will result in a memory
 * buffer that is acceptable for the codec if you do not use any horizontal
 * padding.
 *
 * May only be used if a codec with AV_CODEC_CAP_DR1 has been opened.
 *)

{$IFDEF API_Dynamic}
var avcodec_align_dimensions : procedure(s: PAVCodecContext; width, height: PInteger); cdecl;
{$ELSE API_Dynamic}
procedure avcodec_align_dimensions(s: PAVCodecContext; width, height: PInteger); cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_align_dimensions';
{$ENDIF API_Dynamic}


(**
 * Modify width and height values so that they will result in a memory
 * buffer that is acceptable for the codec if you also ensure that all
 * line sizes are a multiple of the respective linesize_align[i].
 *
 * May only be used if a codec with AV_CODEC_CAP_DR1 has been opened.
 *)

{$IFDEF API_Dynamic}
var avcodec_align_dimensions2 : procedure(s: PAVCodecContext; width, height: PInteger;
                               linesize_align: PInteger{int linesize_align[AV_NUM_DATA_POINTERS]}); cdecl;
{$ELSE API_Dynamic}
procedure avcodec_align_dimensions2(s: PAVCodecContext; width, height: PInteger;
                               linesize_align: PInteger{int linesize_align[AV_NUM_DATA_POINTERS]}); cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_align_dimensions2';
{$ENDIF API_Dynamic}


(**
 * Converts AVChromaLocation to swscale x/y chroma position.
 *
 * The positions represent the chroma (0,0) position in a coordinates system
 * with luma (0,0) representing the origin and luma(1,1) representing 256,256
 *
 * @param xpos  horizontal chroma sample position
 * @param ypos  vertical   chroma sample position
 *)

{$IFDEF API_Dynamic}
var avcodec_enum_to_chroma_pos : function(xpos, ypos: PInteger; pos: TAVChromaLocation): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_enum_to_chroma_pos(xpos, ypos: PInteger; pos: TAVChromaLocation): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_enum_to_chroma_pos';
{$ENDIF API_Dynamic}


(**
 * Converts swscale x/y chroma position to AVChromaLocation.
 *
 * The positions represent the chroma (0,0) position in a coordinates system
 * with luma (0,0) representing the origin and luma(1,1) representing 256,256
 *
 * @param xpos  horizontal chroma sample position
 * @param ypos  vertical   chroma sample position
 *)

{$IFDEF API_Dynamic}
var avcodec_chroma_pos_to_enum : function(xpos, ypos: Integer): TAVChromaLocation; cdecl;
{$ELSE API_Dynamic}
function avcodec_chroma_pos_to_enum(xpos, ypos: Integer): TAVChromaLocation; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_chroma_pos_to_enum';
{$ENDIF API_Dynamic}


(**
 * Decode the audio frame of size avpkt->size from avpkt->data into frame.
 *
 * Some decoders may support multiple frames in a single AVPacket. Such
 * decoders would then just decode the first frame and the return value would be
 * less than the packet size. In this case, avcodec_decode_audio4 has to be
 * called again with an AVPacket containing the remaining data in order to
 * decode the second frame, etc...  Even if no frames are returned, the packet
 * needs to be fed to the decoder with remaining data until it is completely
 * consumed or an error occurs.
 *
 * Some decoders (those marked with AV_CODEC_CAP_DELAY) have a delay between input
 * and output. This means that for some packets they will not immediately
 * produce decoded output and need to be flushed at the end of decoding to get
 * all the decoded data. Flushing is done by calling this function with packets
 * with avpkt->data set to NULL and avpkt->size set to 0 until it stops
 * returning samples. It is safe to flush even those decoders that are not
 * marked with AV_CODEC_CAP_DELAY, then no samples will be returned.
 *
 * @warning The input buffer, avpkt->data must be AV_INPUT_BUFFER_PADDING_SIZE
 *          larger than the actual read bytes because some optimized bitstream
 *          readers read 32 or 64 bits at once and could read over the end.
 *
 * @note The AVCodecContext MUST have been opened with @ref avcodec_open2()
 * before packets may be fed to the decoder.
 *
 * @param      avctx the codec context
 * @param[out] frame The AVFrame in which to store decoded audio samples.
 *                   The decoder will allocate a buffer for the decoded frame by
 *                   calling the AVCodecContext.get_buffer2() callback.
 *                   When AVCodecContext.refcounted_frames is set to 1, the frame is
 *                   reference counted and the returned reference belongs to the
 *                   caller. The caller must release the frame using av_frame_unref()
 *                   when the frame is no longer needed. The caller may safely write
 *                   to the frame if av_frame_is_writable() returns 1.
 *                   When AVCodecContext.refcounted_frames is set to 0, the returned
 *                   reference belongs to the decoder and is valid only until the
 *                   next call to this function or until closing or flushing the
 *                   decoder. The caller may not write to it.
 * @param[out] got_frame_ptr Zero if no frame could be decoded, otherwise it is
 *                           non-zero. Note that this field being set to zero
 *                           does not mean that an error has occurred. For
 *                           decoders with AV_CODEC_CAP_DELAY set, no given decode
 *                           call is guaranteed to produce a frame.
 * @param[in]  avpkt The input AVPacket containing the input buffer.
 *                   At least avpkt->data and avpkt->size should be set. Some
 *                   decoders might also require additional fields to be set.
 * @return A negative error code is returned if an error occurred during
 *         decoding, otherwise the number of bytes consumed from the input
 *         AVPacket is returned.
 *
* @deprecated Use avcodec_send_packet() and avcodec_receive_frame().
 *)

{$IFDEF API_Dynamic}
var avcodec_decode_audio4 : function(avctx: PAVCodecContext; frame: PAVFrame;
                          got_frame_ptr: PInteger; const avpkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_decode_audio4(avctx: PAVCodecContext; frame: PAVFrame;
                          got_frame_ptr: PInteger; const avpkt: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_decode_audio4';
{$ENDIF API_Dynamic}


(**
 * Decode the video frame of size avpkt->size from avpkt->data into picture.
 * Some decoders may support multiple frames in a single AVPacket, such
 * decoders would then just decode the first frame.
 *
 * @warning The input buffer must be FF_INPUT_BUFFER_PADDING_SIZE larger than
 * the actual read bytes because some optimized bitstream readers read 32 or 64
 * bits at once and could read over the end.
 *
 * @warning The end of the input buffer buf should be set to 0 to ensure that
 * no overreading happens for damaged MPEG streams.
 *
 * @note Codecs which have the CODEC_CAP_DELAY capability set have a delay
 * between input and output, these need to be fed with avpkt->data=NULL,
 * avpkt->size=0 at the end to return the remaining frames.
 *
 * @note The AVCodecContext MUST have been opened with @ref avcodec_open2()
 * before packets may be fed to the decoder.
 *
 * @param avctx the codec context
 * @param[out] picture The AVFrame in which the decoded video frame will be stored.
 *             Use av_frame_alloc() to get an AVFrame. The codec will
 *             allocate memory for the actual bitmap by calling the
 *             AVCodecContext.get_buffer2() callback.
 *             When AVCodecContext.refcounted_frames is set to 1, the frame is
 *             reference counted and the returned reference belongs to the
 *             caller. The caller must release the frame using av_frame_unref()
 *             when the frame is no longer needed. The caller may safely write
 *             to the frame if av_frame_is_writable() returns 1.
 *             When AVCodecContext.refcounted_frames is set to 0, the returned
 *             reference belongs to the decoder and is valid only until the
 *             next call to this function or until closing or flushing the
 *             decoder. The caller may not write to it.
 *
 * @param[in] avpkt The input AVPacket containing the input buffer.
 *            You can create such packet with av_init_packet() and by then setting
 *            data and size, some decoders might in addition need other fields like
 *            flags&AV_PKT_FLAG_KEY. All decoders are designed to use the least
 *            fields possible.
 * @param[in,out] got_picture_ptr Zero if no frame could be decompressed, otherwise, it is nonzero.
 * @return On error a negative value is returned, otherwise the number of bytes
 * used or zero if no frame could be decompressed.
 *
 * @deprecated Use avcodec_send_packet() and avcodec_receive_frame().
 *)

{$IFDEF API_Dynamic}
var avcodec_decode_video2 : function(avctx: PAVCodecContext; picture: PAVFrame;
                         got_picture_ptr: PInteger;
                         const avpkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_decode_video2(avctx: PAVCodecContext; picture: PAVFrame;
                         got_picture_ptr: PInteger;
                         const avpkt: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_decode_video2';
{$ENDIF API_Dynamic}


(**
 * Decode a subtitle message.
 * Return a negative value on error, otherwise return the number of bytes used.
 * If no subtitle could be decompressed, got_sub_ptr is zero.
 * Otherwise, the subtitle is stored in *sub.
 * Note that AV_CODEC_CAP_DR1 is not available for subtitle codecs. This is for
 * simplicity, because the performance difference is expect to be negligible
 * and reusing a get_buffer written for video codecs would probably perform badly
 * due to a potentially very different allocation pattern.
 *
 * Some decoders (those marked with AV_CODEC_CAP_DELAY) have a delay between input
 * and output. This means that for some packets they will not immediately
 * produce decoded output and need to be flushed at the end of decoding to get
 * all the decoded data. Flushing is done by calling this function with packets
 * with avpkt->data set to NULL and avpkt->size set to 0 until it stops
 * returning subtitles. It is safe to flush even those decoders that are not
 * marked with AV_CODEC_CAP_DELAY, then no subtitles will be returned.
 *
 * @note The AVCodecContext MUST have been opened with @ref avcodec_open2()
 * before packets may be fed to the decoder.
 *
 * @param avctx the codec context
 * @param[out] sub The Preallocated AVSubtitle in which the decoded subtitle will be stored,
 *                 must be freed with avsubtitle_free if *got_sub_ptr is set.
 * @param[in,out] got_sub_ptr Zero if no subtitle could be decompressed, otherwise, it is nonzero.
 * @param[in] avpkt The input AVPacket containing the input buffer.
 *)

{$IFDEF API_Dynamic}
var avcodec_decode_subtitle2 : function(avctx: PAVCodecContext; sub: PAVSubtitle;
                            got_sub_ptr: PInteger;
                            avpkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_decode_subtitle2(avctx: PAVCodecContext; sub: PAVSubtitle;
                            got_sub_ptr: PInteger;
                            avpkt: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_decode_subtitle2';
{$ENDIF API_Dynamic}


(**
 * Supply raw packet data as input to a decoder.
 *
 * Internally, this call will copy relevant AVCodecContext fields, which can
 * influence decoding per-packet, and apply them when the packet is actually
 * decoded. (For example AVCodecContext.skip_frame, which might direct the
 * decoder to drop the frame contained by the packet sent with this function.)
 *
 * @warning The input buffer, avpkt->data must be AV_INPUT_BUFFER_PADDING_SIZE
 *          larger than the actual read bytes because some optimized bitstream
 *          readers read 32 or 64 bits at once and could read over the end.
 *
 * @warning Do not mix this API with the legacy API (like avcodec_decode_video2())
 *          on the same AVCodecContext. It will return unexpected results now
 *          or in future libavcodec versions.
 *
 * @note The AVCodecContext MUST have been opened with @ref avcodec_open2()
 *       before packets may be fed to the decoder.
 *
 * @param avctx codec context
 * @param[in] avpkt The input AVPacket. Usually, this will be a single video
 *                  frame, or several complete audio frames.
 *                  Ownership of the packet remains with the caller, and the
 *                  decoder will not write to the packet. The decoder may create
 *                  a reference to the packet data (or copy it if the packet is
 *                  not reference-counted).
 *                  Unlike with older APIs, the packet is always fully consumed,
 *                  and if it contains multiple frames (e.g. some audio codecs),
 *                  will require you to call avcodec_receive_frame() multiple
 *                  times afterwards before you can send a new packet.
 *                  It can be NULL (or an AVPacket with data set to NULL and
 *                  size set to 0); in this case, it is considered a flush
 *                  packet, which signals the end of the stream. Sending the
 *                  first flush packet will return success. Subsequent ones are
 *                  unnecessary and will return AVERROR_EOF. If the decoder
 *                  still has frames buffered, it will return them after sending
 *                  a flush packet.
 *
 * @return 0 on success, otherwise negative error code:
 *      AVERROR(EAGAIN):   input is not accepted in the current state - user
 *                         must read output with avcodec_receive_frame() (once
 *                         all output is read, the packet should be resent, and
 *                         the call will not fail with EAGAIN).
 *      AVERROR_EOF:       the decoder has been flushed, and no new packets can
 *                         be sent to it (also returned if more than 1 flush
 *                         packet is sent)
 *      AVERROR(EINVAL):   codec not opened, it is an encoder, or requires flush
 *      AVERROR(ENOMEM):   failed to add packet to internal queue, or similar
 *      other errors: legitimate decoding errors
 *)

{$IFDEF API_Dynamic}
var avcodec_send_packet : function(avctx: PAVCodecContext; const avpkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_send_packet(avctx: PAVCodecContext; const avpkt: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_send_packet';
{$ENDIF API_Dynamic}


(**
 * Return decoded output data from a decoder.
 *
 * @param avctx codec context
 * @param frame This will be set to a reference-counted video or audio
 *              frame (depending on the decoder type) allocated by the
 *              decoder. Note that the function will always call
 *              av_frame_unref(frame) before doing anything else.
 *
 * @return
 *      0:                 success, a frame was returned
 *      AVERROR(EAGAIN):   output is not available in this state - user must try
 *                         to send new input
 *      AVERROR_EOF:       the decoder has been fully flushed, and there will be
 *                         no more output frames
 *      AVERROR(EINVAL):   codec not opened, or it is an encoder
 *      other negative values: legitimate decoding errors
 *)

{$IFDEF API_Dynamic}
var avcodec_receive_frame : function(avctx: PAVCodecContext; frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_receive_frame(avctx: PAVCodecContext; frame: PAVFrame): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_receive_frame';
{$ENDIF API_Dynamic}


(**
 * Supply a raw video or audio frame to the encoder. Use avcodec_receive_packet()
 * to retrieve buffered output packets.
 *
 * @param avctx     codec context
 * @param[in] frame AVFrame containing the raw audio or video frame to be encoded.
 *                  Ownership of the frame remains with the caller, and the
 *                  encoder will not write to the frame. The encoder may create
 *                  a reference to the frame data (or copy it if the frame is
 *                  not reference-counted).
 *                  It can be NULL, in which case it is considered a flush
 *                  packet.  This signals the end of the stream. If the encoder
 *                  still has packets buffered, it will return them after this
 *                  call. Once flushing mode has been entered, additional flush
 *                  packets are ignored, and sending frames will return
 *                  AVERROR_EOF.
 *
 *                  For audio:
 *                  If AV_CODEC_CAP_VARIABLE_FRAME_SIZE is set, then each frame
 *                  can have any number of samples.
 *                  If it is not set, frame->nb_samples must be equal to
 *                  avctx->frame_size for all frames except the last.
 *                  The final frame may be smaller than avctx->frame_size.
 * @return 0 on success, otherwise negative error code:
 *      AVERROR(EAGAIN):   input is not accepted in the current state - user
 *                         must read output with avcodec_receive_packet() (once
 *                         all output is read, the packet should be resent, and
 *                         the call will not fail with EAGAIN).
 *      AVERROR_EOF:       the encoder has been flushed, and no new frames can
 *                         be sent to it
 *      AVERROR(EINVAL):   codec not opened, refcounted_frames not set, it is a
 *                         decoder, or requires flush
 *      AVERROR(ENOMEM):   failed to add packet to internal queue, or similar
 *      other errors: legitimate decoding errors
 *)

{$IFDEF API_Dynamic}
var avcodec_send_frame : function(avctx: PAVCodecContext; const frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_send_frame(avctx: PAVCodecContext; const frame: PAVFrame): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_send_frame';
{$ENDIF API_Dynamic}


(**
 * Read encoded data from the encoder.
 *
 * @param avctx codec context
 * @param avpkt This will be set to a reference-counted packet allocated by the
 *              encoder. Note that the function will always call
 *              av_frame_unref(frame) before doing anything else.
 * @return 0 on success, otherwise negative error code:
 *      AVERROR(EAGAIN):   output is not available in the current state - user
 *                         must try to send input
 *      AVERROR_EOF:       the encoder has been fully flushed, and there will be
 *                         no more output packets
 *      AVERROR(EINVAL):   codec not opened, or it is an encoder
 *      other errors: legitimate decoding errors
 *)

{$IFDEF API_Dynamic}
var avcodec_receive_packet : function(avctx: PAVCodecContext; avpkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_receive_packet(avctx: PAVCodecContext; avpkt: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_receive_packet';
{$ENDIF API_Dynamic}



(**
 * @defgroup lavc_parsing Frame parsing
 * @{
 *)

const
  AV_PARSER_PTS_NB = 4;
  PARSER_FLAG_COMPLETE_FRAMES = $0001;
  PARSER_FLAG_ONCE            = $0002;
  PARSER_FLAG_FETCHED_OFFSET  = $0004;
  PARSER_FLAG_USE_CODEC_TS    = $1000;

type
  TAVPictureStructure = (
    AV_PICTURE_STRUCTURE_UNKNOWN,      //< unknown
    AV_PICTURE_STRUCTURE_TOP_FIELD,    //< coded as top field
    AV_PICTURE_STRUCTURE_BOTTOM_FIELD, //< coded as bottom field
    AV_PICTURE_STRUCTURE_FRAME         //< coded as frame
  );

  PAVCodecParserContext = ^TAVCodecParserContext;
  PAVCodecParser = ^TAVCodecParser;
  TAVCodecParserContext = record
    priv_data: Pointer;
    parser: PAVCodecParser;
    frame_offset: Int64; (* offset of the current frame *)
    cur_offset: Int64; (* current offset
                           (incremented by each av_parser_parse()) *)
    next_frame_offset: Int64; (* offset of the next frame *)
    (* video info *)
    pict_type: Integer; (* XXX: Put it back in AVCodecContext. *)
    (**
     * This field is used for proper frame duration computation in lavf.
     * It signals, how much longer the frame duration of the current frame
     * is compared to normal frame duration.
     *
     * frame_duration = (1 + repeat_pict) * time_base
     *
     * It is used by codecs like H.264 to display telecined material.
     *)
    repeat_pict: Integer; (* XXX: Put it back in AVCodecContext. *)
    pts: Int64;     (* pts of the current frame *)
    dts: Int64;     (* dts of the current frame *)

    (* private data *)
    last_pts: Int64;
    last_dts: Int64;
    fetch_timestamp: Integer;

//#define AV_PARSER_PTS_NB 4
    cur_frame_start_index: Integer;
    cur_frame_offset: array[0..AV_PARSER_PTS_NB-1] of Int64;
    cur_frame_pts: array[0..AV_PARSER_PTS_NB-1] of Int64;
    cur_frame_dts: array[0..AV_PARSER_PTS_NB-1] of Int64;

    flags: Integer;
//#define PARSER_FLAG_COMPLETE_FRAMES           0x0001
//#define PARSER_FLAG_ONCE                      0x0002
/// Set if the parser has a valid file offset
//#define PARSER_FLAG_FETCHED_OFFSET            0x0004
//#define PARSER_FLAG_USE_CODEC_TS              0x1000

    offset: Int64;      ///< byte offset from starting packet start
    cur_frame_end: array[0..AV_PARSER_PTS_NB-1] of Int64;

    (**
     * Set by parser to 1 for key frames and 0 for non-key frames.
     * It is initialized to -1, so if the parser doesn't set this flag,
     * old-style fallback using AV_PICTURE_TYPE_I picture type as key frames
     * will be used.
     *)
    key_frame: Integer;

{$IFDEF FF_API_CONVERGENCE_DURATION}
    (**
     * @deprecated unused
     *)
    convergence_duration: Int64;
{$ENDIF}

    // Timestamp generation support:
    (**
     * Synchronization point for start of timestamp generation.
     *
     * Set to >0 for sync point, 0 for no sync point and <0 for undefined
     * (default).
     *
     * For example, this corresponds to presence of H.264 buffering period
     * SEI message.
     *)
    dts_sync_point: Integer;

    (**
     * Offset of the current timestamp against last timestamp sync point in
     * units of AVCodecContext.time_base.
     *
     * Set to INT_MIN when dts_sync_point unused. Otherwise, it must
     * contain a valid timestamp offset.
     *
     * Note that the timestamp of sync point has usually a nonzero
     * dts_ref_dts_delta, which refers to the previous sync point. Offset of
     * the next frame after timestamp sync point will be usually 1.
     *
     * For example, this corresponds to H.264 cpb_removal_delay.
     *)
    dts_ref_dts_delta: Integer;

    (**
     * Presentation delay of current frame in units of AVCodecContext.time_base.
     *
     * Set to INT_MIN when dts_sync_point unused. Otherwise, it must
     * contain valid non-negative timestamp delta (presentation time of a frame
     * must not lie in the past).
     *
     * This delay represents the difference between decoding and presentation
     * time of the frame.
     *
     * For example, this corresponds to H.264 dpb_output_delay.
     *)
    pts_dts_delta: Integer;

    (**
     * Position of the packet in file.
     *
     * Analogous to cur_frame_pts/dts
     *)
    cur_frame_pos: array[0..AV_PARSER_PTS_NB-1] of Int64;

    (**
     * Byte position of currently parsed frame in stream.
     *)
    pos: Int64;

    (**
     * Previous frame byte position.
     *)
    last_pos: Int64;

    (**
     * Duration of the current frame.
     * For audio, this is in units of 1 / AVCodecContext.sample_rate.
     * For all other types, this is in units of AVCodecContext.time_base.
     *)
    duration: Integer;

    field_order: TAVFieldOrder;

    (**
     * Indicate whether a picture is coded as a frame, top field or bottom field.
     *
     * For example, H.264 field_pic_flag equal to 0 corresponds to
     * AV_PICTURE_STRUCTURE_FRAME. An H.264 picture with field_pic_flag
     * equal to 1 and bottom_field_flag equal to 0 corresponds to
     * AV_PICTURE_STRUCTURE_TOP_FIELD.
     *)
    picture_structure: TAVPictureStructure;

    (**
     * Picture number incremented in presentation or output order.
     * This field may be reinitialized at the first picture of a new sequence.
     *
     * For example, this corresponds to H.264 PicOrderCnt.
     *)
    output_picture_number: Integer;

    (**
     * Dimensions of the decoded video intended for presentation.
     *)
    width: Integer;
    height: Integer;

    (**
     * Dimensions of the coded video.
     *)
    coded_width: Integer;
    coded_height: Integer;

    (**
     * The format of the coded data, corresponds to enum AVPixelFormat for video
     * and for enum AVSampleFormat for audio.
     *
     * Note that a decoder can have considerable freedom in how exactly it
     * decodes the data, so the format reported here might be different from the
     * one returned by a decoder.
     *)
    format: Integer;
  end;

  TAVCodecParser = record
    codec_ids: array[0..4] of Integer; (* several codec IDs are permitted *)
    priv_data_size: Integer;
    parser_init: function(s: PAVCodecParserContext): Integer; cdecl;
    (* This callback never returns an error, a negative value means that
     * the frame start was in a previous packet. *)
    parser_parse: function(s: PAVCodecParserContext;
                        avctx: PAVCodecContext;
                        const poutbuf: PPByte; poutbuf_size: PInteger;
                        const buf: PByte; buf_size: Integer): Integer; cdecl;
    parser_close: procedure(s: PAVCodecParserContext); cdecl;
    split: function(avctx: PAVCodecContext; const buf: PByte; buf_size: Integer): Integer; cdecl;
    next: PAVCodecParser;
  end;


{$IFDEF API_Dynamic}
var av_parser_next : function(const c: PAVCodecParser): PAVCodecParser; cdecl;
{$ELSE API_Dynamic}
function av_parser_next(const c: PAVCodecParser): PAVCodecParser; cdecl; external AVCODEC_LIBNAME name _PU + 'av_parser_next';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_register_codec_parser : procedure(parser: PAVCodecParser); cdecl;
{$ELSE API_Dynamic}
procedure av_register_codec_parser(parser: PAVCodecParser); cdecl; external AVCODEC_LIBNAME name _PU + 'av_register_codec_parser';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_parser_init : function(codec_id: Integer): PAVCodecParserContext; cdecl;
{$ELSE API_Dynamic}
function av_parser_init(codec_id: Integer): PAVCodecParserContext; cdecl; external AVCODEC_LIBNAME name _PU + 'av_parser_init';
{$ENDIF API_Dynamic}


(**
 * Parse a packet.
 *
 * @param s             parser context.
 * @param avctx         codec context.
 * @param poutbuf       set to pointer to parsed buffer or NULL if not yet finished.
 * @param poutbuf_size  set to size of parsed buffer or zero if not yet finished.
 * @param buf           input buffer.
 * @param buf_size      buffer size in bytes without the padding. I.e. the full buffer
                        size is assumed to be buf_size + AV_INPUT_BUFFER_PADDING_SIZE.
                        To signal EOF, this should be 0 (so that the last frame
                        can be output).
 * @param pts           input presentation timestamp.
 * @param dts           input decoding timestamp.
 * @param pos           input byte position in stream.
 * @return the number of bytes of the input bitstream used.
 *
 * Example:
 * @code
 *   while(in_len){
 *       len = av_parser_parse2(myparser, AVCodecContext, &data, &size,
 *                                        in_data, in_len,
 *                                        pts, dts, pos);
 *       in_data += len;
 *       in_len  -= len;
 *
 *       if(size)
 *          decode_frame(data, size);
 *   }
 * @endcode
 *)

{$IFDEF API_Dynamic}
var av_parser_parse2 : function(s: PAVCodecParserContext;
                     avctx: PAVCodecContext;
                     poutbuf: PPByte; poutbuf_size: PInteger;
                     const buf: PByte; buf_size: Integer;
                     pts, dts,
                     pos: Int64): Integer; cdecl;
{$ELSE API_Dynamic}
function av_parser_parse2(s: PAVCodecParserContext;
                     avctx: PAVCodecContext;
                     poutbuf: PPByte; poutbuf_size: PInteger;
                     const buf: PByte; buf_size: Integer;
                     pts, dts,
                     pos: Int64): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_parser_parse2';
{$ENDIF API_Dynamic}


(**
 * @return 0 if the output buffer is a subset of the input, 1 if it is allocated and must be freed
 * @deprecated use AVBitStreamFilter
 *)

{$IFDEF API_Dynamic}
var av_parser_change : function(s: PAVCodecParserContext;
                     avctx: PAVCodecContext;
                     poutbuf: PPByte; poutbuf_size: PInteger;
                     const buf: PByte; buf_size, keyframe: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_parser_change(s: PAVCodecParserContext;
                     avctx: PAVCodecContext;
                     poutbuf: PPByte; poutbuf_size: PInteger;
                     const buf: PByte; buf_size, keyframe: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_parser_change';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_parser_close : procedure(s: PAVCodecParserContext); cdecl;
{$ELSE API_Dynamic}
procedure av_parser_close(s: PAVCodecParserContext); cdecl; external AVCODEC_LIBNAME name _PU + 'av_parser_close';
{$ENDIF API_Dynamic}


(**
 * @}
 * @}
 *)

(**
 * @addtogroup lavc_encoding
 * @{
 *)

(**
 * Find a registered encoder with a matching codec ID.
 *
 * @param id AVCodecID of the requested encoder
 * @return An encoder if one was found, NULL otherwise.
 *)

{$IFDEF API_Dynamic}
var avcodec_find_encoder : function(id: TAVCodecID): PAVCodec; cdecl;
{$ELSE API_Dynamic}
function avcodec_find_encoder(id: TAVCodecID): PAVCodec; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_find_encoder';
{$ENDIF API_Dynamic}


(**
 * Find a registered encoder with the specified name.
 *
 * @param name name of the requested encoder
 * @return An encoder if one was found, NULL otherwise.
 *)

{$IFDEF API_Dynamic}
var avcodec_find_encoder_by_name : function(const name: PAnsiChar): PAVCodec; cdecl;
{$ELSE API_Dynamic}
function avcodec_find_encoder_by_name(const name: PAnsiChar): PAVCodec; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_find_encoder_by_name';
{$ENDIF API_Dynamic}


(**
 * Encode a frame of audio.
 *
 * Takes input samples from frame and writes the next output packet, if
 * available, to avpkt. The output packet does not necessarily contain data for
 * the most recent frame, as encoders can delay, split, and combine input frames
 * internally as needed.
 *
 * @param avctx     codec context
 * @param avpkt     output AVPacket.
 *                  The user can supply an output buffer by setting
 *                  avpkt->data and avpkt->size prior to calling the
 *                  function, but if the size of the user-provided data is not
 *                  large enough, encoding will fail. If avpkt->data and
 *                  avpkt->size are set, avpkt->destruct must also be set. All
 *                  other AVPacket fields will be reset by the encoder using
 *                  av_init_packet(). If avpkt->data is NULL, the encoder will
 *                  allocate it. The encoder will set avpkt->size to the size
 *                  of the output packet.
 *
 *                  If this function fails or produces no output, avpkt will be
 *                  freed using av_packet_unref().
 * @param[in] frame AVFrame containing the raw audio data to be encoded.
 *                  May be NULL when flushing an encoder that has the
 *                  AV_CODEC_CAP_DELAY capability set.
 *                  If AV_CODEC_CAP_VARIABLE_FRAME_SIZE is set, then each frame
 *                  can have any number of samples.
 *                  If it is not set, frame->nb_samples must be equal to
 *                  avctx->frame_size for all frames except the last.
 *                  The final frame may be smaller than avctx->frame_size.
 * @param[out] got_packet_ptr This field is set to 1 by libavcodec if the
 *                            output packet is non-empty, and to 0 if it is
 *                            empty. If the function returns an error, the
 *                            packet can be assumed to be invalid, and the
 *                            value of got_packet_ptr is undefined and should
 *                            not be used.
 * @return          0 on success, negative error code on failure
 *
 * @deprecated use avcodec_send_frame()/avcodec_receive_packet() instead
 *)

{$IFDEF API_Dynamic}
var avcodec_encode_audio2 : function(avctx: PAVCodecContext; avpkt: PAVPacket;
                          const frame: PAVFrame; got_packet_ptr: PInteger): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_encode_audio2(avctx: PAVCodecContext; avpkt: PAVPacket;
                          const frame: PAVFrame; got_packet_ptr: PInteger): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_encode_audio2';
{$ENDIF API_Dynamic}


(**
 * Encode a frame of video.
 *
 * Takes input raw video data from frame and writes the next output packet, if
 * available, to avpkt. The output packet does not necessarily contain data for
 * the most recent frame, as encoders can delay and reorder input frames
 * internally as needed.
 *
 * @param avctx     codec context
 * @param avpkt     output AVPacket.
 *                  The user can supply an output buffer by setting
 *                  avpkt->data and avpkt->size prior to calling the
 *                  function, but if the size of the user-provided data is not
 *                  large enough, encoding will fail. All other AVPacket fields
 *                  will be reset by the encoder using av_init_packet(). If
 *                  avpkt->data is NULL, the encoder will allocate it.
 *                  The encoder will set avpkt->size to the size of the
 *                  output packet. The returned data (if any) belongs to the
 *                  caller, he is responsible for freeing it.
 *
 *                  If this function fails or produces no output, avpkt will be
 *                  freed using av_packet_unref().
 * @param[in] frame AVFrame containing the raw video data to be encoded.
 *                  May be NULL when flushing an encoder that has the
 *                  AV_CODEC_CAP_DELAY capability set.
 * @param[out] got_packet_ptr This field is set to 1 by libavcodec if the
 *                            output packet is non-empty, and to 0 if it is
 *                            empty. If the function returns an error, the
 *                            packet can be assumed to be invalid, and the
 *                            value of got_packet_ptr is undefined and should
 *                            not be used.
 * @return          0 on success, negative error code on failure
 *
 * @deprecated use avcodec_send_frame()/avcodec_receive_packet() instead
 *)

{$IFDEF API_Dynamic}
var avcodec_encode_video2 : function(avctx: PAVCodecContext; avpkt: PAVPacket;
                          const frame: PAVFrame; got_packet_ptr: PInteger): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_encode_video2(avctx: PAVCodecContext; avpkt: PAVPacket;
                          const frame: PAVFrame; got_packet_ptr: PInteger): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_encode_video2';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var avcodec_encode_subtitle : function(avctx: PAVCodecContext; buf: PByte; buf_size: Integer;
                            const sub: PAVSubtitle): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_encode_subtitle(avctx: PAVCodecContext; buf: PByte; buf_size: Integer;
                            const sub: PAVSubtitle): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_encode_subtitle';
{$ENDIF API_Dynamic}



(**
 * @}
 *)

{$IFDEF FF_API_AVCODEC_RESAMPLE}
(**
 * @defgroup lavc_resample Audio resampling
 * @ingroup libavc
 * @deprecated use libswresample instead
 *
 * @{
 *)
type
  PReSampleContext = ^TReSampleContext;
  TReSampleContext = record
    // need {$ALIGN 8}
    // defined in libavcodec/resample.c
  end;
  PAVResampleContext = ^TAVResampleContext;
  TAVResampleContext = record
    // need {$ALIGN 8}
    // defined in libavcodec/resample2.c
  end;

(**
 *  Initialize audio resampling context.
 *
 * @param output_channels  number of output channels
 * @param input_channels   number of input channels
 * @param output_rate      output sample rate
 * @param input_rate       input sample rate
 * @param sample_fmt_out   requested output sample format
 * @param sample_fmt_in    input sample format
 * @param filter_length    length of each FIR filter in the filterbank relative to the cutoff frequency
 * @param log2_phase_count log2 of the number of entries in the polyphase filterbank
 * @param linear           if 1 then the used FIR filter will be linearly interpolated
                           between the 2 closest, if 0 the closest will be used
 * @param cutoff           cutoff frequency, 1.0 corresponds to half the output sampling rate
 * @return allocated ReSampleContext, NULL if error occurred
 *)

{$IFDEF API_Dynamic}
var av_audio_resample_init : function(output_channels, input_channels,
                                        output_rate, input_rate: Integer;
                                        sample_fmt_out, sample_fmt_in: TAVSampleFormat;
                                        filter_length, log2_phase_count,
                                        linear: Integer; cutoff: Double): PReSampleContext; cdecl;
{$ELSE API_Dynamic}
function av_audio_resample_init(output_channels, input_channels,
                                        output_rate, input_rate: Integer;
                                        sample_fmt_out, sample_fmt_in: TAVSampleFormat;
                                        filter_length, log2_phase_count,
                                        linear: Integer; cutoff: Double): PReSampleContext; cdecl; external AVCODEC_LIBNAME name _PU + 'av_audio_resample_init';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var audio_resample : function(s: PReSampleContext; output: PSmallInt; input: PSmallInt; nb_samples: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function audio_resample(s: PReSampleContext; output: PSmallInt; input: PSmallInt; nb_samples: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'audio_resample';
{$ENDIF API_Dynamic}


(**
 * Free resample context.
 *
 * @param s a non-NULL pointer to a resample context previously
 *          created with av_audio_resample_init()
 *)

{$IFDEF API_Dynamic}
var audio_resample_close : procedure(s: PReSampleContext); cdecl;
{$ELSE API_Dynamic}
procedure audio_resample_close(s: PReSampleContext); cdecl; external AVCODEC_LIBNAME name _PU + 'audio_resample_close';
{$ENDIF API_Dynamic}


(**
 * Initialize an audio resampler.
 * Note, if either rate is not an integer then simply scale both rates up so they are.
 * @param filter_length length of each FIR filter in the filterbank relative to the cutoff freq
 * @param log2_phase_count log2 of the number of entries in the polyphase filterbank
 * @param linear If 1 then the used FIR filter will be linearly interpolated
                 between the 2 closest, if 0 the closest will be used
 * @param cutoff cutoff frequency, 1.0 corresponds to half the output sampling rate
 *)

{$IFDEF API_Dynamic}
var av_resample_init : function(out_rate: Integer; in_rate: Integer; filter_length: Integer; log2_phase_count: Integer; linear: Integer; cutoff: Double): PAVResampleContext; cdecl;
{$ELSE API_Dynamic}
function av_resample_init(out_rate: Integer; in_rate: Integer; filter_length: Integer; log2_phase_count: Integer; linear: Integer; cutoff: Double): PAVResampleContext; cdecl; external AVCODEC_LIBNAME name _PU + 'av_resample_init';
{$ENDIF API_Dynamic}


(**
 * Resample an array of samples using a previously configured context.
 * @param src an array of unconsumed samples
 * @param consumed the number of samples of src which have been consumed are returned here
 * @param src_size the number of unconsumed samples available
 * @param dst_size the amount of space in samples available in dst
 * @param update_ctx If this is 0 then the context will not be modified, that way several channels can be resampled with the same context.
 * @return the number of samples written in dst or -1 if an error occurred
 *)

{$IFDEF API_Dynamic}
var av_resample : function(c: PAVResampleContext; dst: PSmallInt; src: PSmallInt; consumed: PInteger; src_size: Integer; dst_size: Integer; update_ctx: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_resample(c: PAVResampleContext; dst: PSmallInt; src: PSmallInt; consumed: PInteger; src_size: Integer; dst_size: Integer; update_ctx: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_resample';
{$ENDIF API_Dynamic}


(**
 * Compensate samplerate/timestamp drift. The compensation is done by changing
 * the resampler parameters, so no audible clicks or similar distortions occur
 * @param compensation_distance distance in output samples over which the compensation should be performed
 * @param sample_delta number of output samples which should be output less
 *
 * example: av_resample_compensate(c, 10, 500)
 * here instead of 510 samples only 500 samples would be output
 *
 * note, due to rounding the actual compensation might be slightly different,
 * especially if the compensation_distance is large and the in_rate used during init is small
 *)

{$IFDEF API_Dynamic}
var av_resample_compensate : procedure(c: PAVResampleContext; sample_delta: Integer; compensation_distance: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_resample_compensate(c: PAVResampleContext; sample_delta: Integer; compensation_distance: Integer); cdecl; external AVCODEC_LIBNAME name _PU + 'av_resample_compensate';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_resample_close : procedure(c: PAVResampleContext); cdecl;
{$ELSE API_Dynamic}
procedure av_resample_close(c: PAVResampleContext); cdecl; external AVCODEC_LIBNAME name _PU + 'av_resample_close';
{$ENDIF API_Dynamic}


(**
 * @}
 *)
{$ENDIF}

{$IFDEF FF_API_AVPICTURE}
(**
 * @addtogroup lavc_picture
 * @{
 *)

(**
 * @deprecated unused
 *)

{$IFDEF API_Dynamic}
var avpicture_alloc : function(picture: PAVPicture; pix_fmt: TAVPixelFormat; width, height: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avpicture_alloc(picture: PAVPicture; pix_fmt: TAVPixelFormat; width, height: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avpicture_alloc';
{$ENDIF API_Dynamic}


(**
 * @deprecated unused
 *)

{$IFDEF API_Dynamic}
var avpicture_free : procedure(picture: PAVPicture); cdecl;
{$ELSE API_Dynamic}
procedure avpicture_free(picture: PAVPicture); cdecl; external AVCODEC_LIBNAME name _PU + 'avpicture_free';
{$ENDIF API_Dynamic}


(**
 * @deprecated use av_image_fill_arrays() instead.
 *)

{$IFDEF API_Dynamic}
var avpicture_fill : function(picture: PAVPicture; const ptr: PByte;
                   pix_fmt: TAVPixelFormat; width, height: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avpicture_fill(picture: PAVPicture; const ptr: PByte;
                   pix_fmt: TAVPixelFormat; width, height: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avpicture_fill';
{$ENDIF API_Dynamic}


(**
 * @deprecated use av_image_copy_to_buffer() instead.
 *)

{$IFDEF API_Dynamic}
var avpicture_layout : function(const src: PAVPicture; pix_fmt: TAVPixelFormat;
                     width, height: Integer;
                     dest: PByte; dest_size: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avpicture_layout(const src: PAVPicture; pix_fmt: TAVPixelFormat;
                     width, height: Integer;
                     dest: PByte; dest_size: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avpicture_layout';
{$ENDIF API_Dynamic}


(**
 * @deprecated use av_image_get_buffer_size() instead.
 *)

{$IFDEF API_Dynamic}
var avpicture_get_size : function(pix_fmt: TAVPixelFormat; width, height: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avpicture_get_size(pix_fmt: TAVPixelFormat; width, height: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avpicture_get_size';
{$ENDIF API_Dynamic}


(**
 * @deprecated av_image_copy() instead.
 *)

{$IFDEF API_Dynamic}
var av_picture_copy : procedure(dst: PAVPicture; const src: PAVPicture;
              pix_fmt: TAVPixelFormat; width, height: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_picture_copy(dst: PAVPicture; const src: PAVPicture;
              pix_fmt: TAVPixelFormat; width, height: Integer); cdecl; external AVCODEC_LIBNAME name _PU + 'av_picture_copy';
{$ENDIF API_Dynamic}


(**
 * @deprecated unused
 *)

{$IFDEF API_Dynamic}
var av_picture_crop : function(dst: PAVPicture; const src: PAVPicture;
             pix_fmt: TAVPixelFormat; top_band, left_band: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_picture_crop(dst: PAVPicture; const src: PAVPicture;
             pix_fmt: TAVPixelFormat; top_band, left_band: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_picture_crop';
{$ENDIF API_Dynamic}


(**
 * @deprecated unused
 *)

{$IFDEF API_Dynamic}
var av_picture_pad : function(dst: PAVPicture; const src: PAVPicture; height, width: Integer; pix_fmt: TAVPixelFormat{Integer};
            padtop, padbottom, padleft, padright: Integer; color: PInteger): Integer; cdecl;
{$ELSE API_Dynamic}
function av_picture_pad(dst: PAVPicture; const src: PAVPicture; height, width: Integer; pix_fmt: TAVPixelFormat{Integer};
            padtop, padbottom, padleft, padright: Integer; color: PInteger): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_picture_pad';
{$ENDIF API_Dynamic}


(**
 * @}
 *)
{$ENDIF}

(**
 * @defgroup lavc_misc Utility functions
 * @ingroup libavc
 *
 * Miscellaneous utility functions related to both encoding and decoding
 * (or neither).
 * @{
 *)

(**
 * @defgroup lavc_misc_pixfmt Pixel formats
 *
 * Functions for working with pixel formats.
 * @{
 *)

{$IFDEF FF_API_GETCHROMA}
(**
 * @deprecated Use av_pix_fmt_get_chroma_sub_sample
 *)

{$IFDEF API_Dynamic}
var avcodec_get_chroma_sub_sample : procedure(pix_fmt: TAVPixelFormat; h_shift, v_shift: PInteger); cdecl;
{$ELSE API_Dynamic}
procedure avcodec_get_chroma_sub_sample(pix_fmt: TAVPixelFormat; h_shift, v_shift: PInteger); cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_get_chroma_sub_sample';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * Return a value representing the fourCC code associated to the
 * pixel format pix_fmt, or 0 if no associated fourCC code can be
 * found.
 *)

{$IFDEF API_Dynamic}
var avcodec_pix_fmt_to_codec_tag : function(pix_fmt: TAVPixelFormat): Cardinal; cdecl;
{$ELSE API_Dynamic}
function avcodec_pix_fmt_to_codec_tag(pix_fmt: TAVPixelFormat): Cardinal; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_pix_fmt_to_codec_tag';
{$ENDIF API_Dynamic}


(**
 * @deprecated see av_get_pix_fmt_loss()
 *)

{$IFDEF API_Dynamic}
var avcodec_get_pix_fmt_loss : function(dst_pix_fmt, src_pix_fmt: TAVPixelFormat;
                             has_alpha: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_get_pix_fmt_loss(dst_pix_fmt, src_pix_fmt: TAVPixelFormat;
                             has_alpha: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_get_pix_fmt_loss';
{$ENDIF API_Dynamic}


(**
 * Find the best pixel format to convert to given a certain source pixel
 * format.  When converting from one pixel format to another, information loss
 * may occur.  For example, when converting from RGB24 to GRAY, the color
 * information will be lost. Similarly, other losses occur when converting from
 * some formats to other formats. avcodec_find_best_pix_fmt_of_2() searches which of
 * the given pixel formats should be used to suffer the least amount of loss.
 * The pixel formats from which it chooses one, are determined by the
 * pix_fmt_list parameter.
 *
 *
 * @param[in] pix_fmt_list AV_PIX_FMT_NONE terminated array of pixel formats to choose from
 * @param[in] src_pix_fmt source pixel format
 * @param[in] has_alpha Whether the source pixel format alpha channel is used.
 * @param[out] loss_ptr Combination of flags informing you what kind of losses will occur.
 * @return The best pixel format to convert to or -1 if none was found.
 *)

{$IFDEF API_Dynamic}
var avcodec_find_best_pix_fmt_of_list : function(const pix_fmt_list: PAVPixelFormat;
                                            src_pix_fmt: TAVPixelFormat;
                                            has_alpha: Integer; loss_ptr: PInteger): TAVPixelFormat; cdecl;
{$ELSE API_Dynamic}
function avcodec_find_best_pix_fmt_of_list(const pix_fmt_list: PAVPixelFormat;
                                            src_pix_fmt: TAVPixelFormat;
                                            has_alpha: Integer; loss_ptr: PInteger): TAVPixelFormat; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_find_best_pix_fmt_of_list';
{$ENDIF API_Dynamic}


(**
 * @deprecated see av_find_best_pix_fmt_of_2()
 *)

{$IFDEF API_Dynamic}
var avcodec_find_best_pix_fmt_of_2 : function(dst_pix_fmt1, dst_pix_fmt2, src_pix_fmt: TAVPixelFormat;
                                                  has_alpha: Integer; loss_ptr: PInteger): TAVPixelFormat; cdecl;
{$ELSE API_Dynamic}
function avcodec_find_best_pix_fmt_of_2(dst_pix_fmt1, dst_pix_fmt2, src_pix_fmt: TAVPixelFormat;
                                                  has_alpha: Integer; loss_ptr: PInteger): TAVPixelFormat; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_find_best_pix_fmt_of_2';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var avcodec_find_best_pix_fmt2 : function(dst_pix_fmt1, dst_pix_fmt2, src_pix_fmt: TAVPixelFormat;
                        has_alpha: Integer; loss_ptr: PInteger): TAVPixelFormat; cdecl;
{$ELSE API_Dynamic}
function avcodec_find_best_pix_fmt2(dst_pix_fmt1, dst_pix_fmt2, src_pix_fmt: TAVPixelFormat;
                        has_alpha: Integer; loss_ptr: PInteger): TAVPixelFormat; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_find_best_pix_fmt2';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var avcodec_default_get_format : function(s: PAVCodecContext; const fmt: PAVPixelFormat): TAVPixelFormat; cdecl;
{$ELSE API_Dynamic}
function avcodec_default_get_format(s: PAVCodecContext; const fmt: PAVPixelFormat): TAVPixelFormat; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_default_get_format';
{$ENDIF API_Dynamic}


(**
 * @}
 *)

{$IFDEF FF_API_SET_DIMENSIONS}
(**
 * @deprecated this function is not supposed to be used from outside of lavc
 *)

{$IFDEF API_Dynamic}
var avcodec_set_dimensions : procedure(s: PAVCodecContext; width, height: Integer); cdecl;
{$ELSE API_Dynamic}
procedure avcodec_set_dimensions(s: PAVCodecContext; width, height: Integer); cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_set_dimensions';
{$ENDIF API_Dynamic}

{$ENDIF}

{$IFDEF FF_API_TAG_STRING}
(**
 * Put a string representing the codec tag codec_tag in buf.
 *
 * @param buf       buffer to place codec tag in
 * @param buf_size size in bytes of buf
 * @param codec_tag codec tag to assign
 * @return the length of the string that would have been generated if
 * enough space had been available, excluding the trailing null
 *
 * @deprecated see av_fourcc_make_string() and av_fourcc2str().
 *)

{$IFDEF API_Dynamic}
var av_get_codec_tag_string : function(buf: PAnsiChar; buf_size, codec_tag: Cardinal): Cardinal; cdecl;
{$ELSE API_Dynamic}
function av_get_codec_tag_string(buf: PAnsiChar; buf_size, codec_tag: Cardinal): Cardinal; cdecl; external AVCODEC_LIBNAME name _PU + 'av_get_codec_tag_string';
{$ENDIF API_Dynamic}

{$ENDIF}


{$IFDEF API_Dynamic}
var avcodec_string : procedure(buf: PAnsiChar; buf_size: Integer; enc: PAVCodecContext; encode: Integer); cdecl;
{$ELSE API_Dynamic}
procedure avcodec_string(buf: PAnsiChar; buf_size: Integer; enc: PAVCodecContext; encode: Integer); cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_string';
{$ENDIF API_Dynamic}


(**
 * Return a name for the specified profile, if available.
 *
 * @param codec the codec that is searched for the given profile
 * @param profile the profile value for which a name is requested
 * @return A name for the profile if found, NULL otherwise.
 *)

{$IFDEF API_Dynamic}
var av_get_profile_name : function(const codec: PAVCodec; profile: Integer): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_profile_name(const codec: PAVCodec; profile: Integer): PAnsiChar; cdecl; external AVCODEC_LIBNAME name _PU + 'av_get_profile_name';
{$ENDIF API_Dynamic}


(**
 * Return a name for the specified profile, if available.
 *
 * @param codec_id the ID of the codec to which the requested profile belongs
 * @param profile the profile value for which a name is requested
 * @return A name for the profile if found, NULL otherwise.
 *
 * @note unlike av_get_profile_name(), which searches a list of profiles
 *       supported by a specific decoder or encoder implementation, this
 *       function searches the list of profiles from the AVCodecDescriptor
 *)

{$IFDEF API_Dynamic}
var avcodec_profile_name : function(codec_id: TAVCodecID; profile: Integer): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avcodec_profile_name(codec_id: TAVCodecID; profile: Integer): PAnsiChar; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_profile_name';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var avcodec_default_execute : function(c: PAVCodecContext; func: TexecuteCall; arg: Pointer; ret: PInteger; count, size: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_default_execute(c: PAVCodecContext; func: TexecuteCall; arg: Pointer; ret: PInteger; count, size: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_default_execute';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var avcodec_default_execute2 : function(c: PAVCodecContext; func: Texecute2Call; arg: Pointer; ret: PInteger; count: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_default_execute2(c: PAVCodecContext; func: Texecute2Call; arg: Pointer; ret: PInteger; count: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_default_execute2';
{$ENDIF API_Dynamic}

//FIXME func typedef

(**
 * Fill AVFrame audio data and linesize pointers.
 *
 * The buffer buf must be a preallocated buffer with a size big enough
 * to contain the specified samples amount. The filled AVFrame data
 * pointers will point to this buffer.
 *
 * AVFrame extended_data channel pointers are allocated if necessary for
 * planar audio.
 *
 * @param frame       the AVFrame
 *                    frame->nb_samples must be set prior to calling the
 *                    function. This function fills in frame->data,
 *                    frame->extended_data, frame->linesize[0].
 * @param nb_channels channel count
 * @param sample_fmt  sample format
 * @param buf         buffer to use for frame data
 * @param buf_size    size of buffer
 * @param align       plane size sample alignment (0 = default)
 * @return            >=0 on success, negative error code on failure
 * @todo return the size in bytes required to store the samples in
 * case of success, at the next libavutil bump
 *)

{$IFDEF API_Dynamic}
var avcodec_fill_audio_frame : function(frame: PAVFrame; nb_channels: Integer;
                             sample_fmt: TAVSampleFormat; const buf: PByte;
                             buf_size, align: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_fill_audio_frame(frame: PAVFrame; nb_channels: Integer;
                             sample_fmt: TAVSampleFormat; const buf: PByte;
                             buf_size, align: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_fill_audio_frame';
{$ENDIF API_Dynamic}


(**
 * Reset the internal decoder state / flush internal buffers. Should be called
 * e.g. when seeking or when switching to a different stream.
 *
 * @note when refcounted frames are not used (i.e. avctx->refcounted_frames is 0),
 * this invalidates the frames previously returned from the decoder. When
 * refcounted frames are used, the decoder just releases any references it might
 * keep internally, but the caller's reference remains valid.
 *)

{$IFDEF API_Dynamic}
var avcodec_flush_buffers : procedure(avctx: PAVCodecContext); cdecl;
{$ELSE API_Dynamic}
procedure avcodec_flush_buffers(avctx: PAVCodecContext); cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_flush_buffers';
{$ENDIF API_Dynamic}


(**
 * Return codec bits per sample.
 *
 * @param[in] codec_id the codec
 * @return Number of bits per sample or zero if unknown for the given codec.
 *)

{$IFDEF API_Dynamic}
var av_get_bits_per_sample : function(codec_id: TAVCodecID): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_bits_per_sample(codec_id: TAVCodecID): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_get_bits_per_sample';
{$ENDIF API_Dynamic}


(**
 * Return the PCM codec associated with a sample format.
 * @param be  endianness, 0 for little, 1 for big,
 *            -1 (or anything else) for native
 * @return  AV_CODEC_ID_PCM_* or AV_CODEC_ID_NONE
 *)

{$IFDEF API_Dynamic}
var av_get_pcm_codec : function(fmt: TAVSampleFormat; be: Integer): TAVCodecID; cdecl;
{$ELSE API_Dynamic}
function av_get_pcm_codec(fmt: TAVSampleFormat; be: Integer): TAVCodecID; cdecl; external AVCODEC_LIBNAME name _PU + 'av_get_pcm_codec';
{$ENDIF API_Dynamic}


(**
 * Return codec bits per sample.
 * Only return non-zero if the bits per sample is exactly correct, not an
 * approximation.
 *
 * @param[in] codec_id the codec
 * @return Number of bits per sample or zero if unknown for the given codec.
 *)

{$IFDEF API_Dynamic}
var av_get_exact_bits_per_sample : function(codec_id: TAVCodecID): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_exact_bits_per_sample(codec_id: TAVCodecID): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_get_exact_bits_per_sample';
{$ENDIF API_Dynamic}


(**
 * Return audio frame duration.
 *
 * @param avctx        codec context
 * @param frame_bytes  size of the frame, or 0 if unknown
 * @return             frame duration, in samples, if known. 0 if not able to
 *                     determine.
 *)

{$IFDEF API_Dynamic}
var av_get_audio_frame_duration : function(avctx: PAVCodecContext; frame_bytes: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_audio_frame_duration(avctx: PAVCodecContext; frame_bytes: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_get_audio_frame_duration';
{$ENDIF API_Dynamic}


(**
 * This function is the same as av_get_audio_frame_duration(), except it works
 * with AVCodecParameters instead of an AVCodecContext.
 *)

{$IFDEF API_Dynamic}
var av_get_audio_frame_duration2 : function(par: PAVCodecParameters; frame_bytes: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_audio_frame_duration2(par: PAVCodecParameters; frame_bytes: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_get_audio_frame_duration2';
{$ENDIF API_Dynamic}


type
{$IFDEF FF_API_OLD_BSF}
  PPAVBitStreamFilterContext = ^PAVBitStreamFilterContext;
  PAVBitStreamFilterContext = ^TAVBitStreamFilterContext;
  PAVBitStreamFilter = ^TAVBitStreamFilter;
  TAVBitStreamFilterContext = record
    priv_data: Pointer;
    filter: PAVBitStreamFilter;
    parser: PAVCodecParserContext;
    next: PAVBitStreamFilterContext;
    (**
     * Internal default arguments, used if NULL is passed to av_bitstream_filter_filter().
     * Not for access by library users.
     *)
    args: PAnsiChar;
  end;
{$ENDIF}

  PAVBSFInternal = ^TAVBSFInternal;
  TAVBSFInternal = record
    // need {$ALIGN 8}
    // defined in libavcodec/bsf.c
  end;

(**
 * The bitstream filter state.
 *
 * This struct must be allocated with av_bsf_alloc() and freed with
 * av_bsf_free().
 *
 * The fields in the struct will only be changed (by the caller or by the
 * filter) as described in their documentation, and are to be considered
 * immutable otherwise.
 *)
  PPAVBSFContext = ^PAVBSFContext;
  PAVBSFContext = ^TAVBSFContext;
  TAVBSFContext = record
    (**
     * A class for logging and AVOptions
     *)
    av_class: PAVClass;

    (**
     * The bitstream filter this context is an instance of.
     *)
    filter: PAVBitStreamFilter;

    (**
     * Opaque libavcodec internal data. Must not be touched by the caller in any
     * way.
     *)
    internal: PAVBSFInternal;

    (**
     * Opaque filter-specific private data. If filter->priv_class is non-NULL,
     * this is an AVOptions-enabled struct.
     *)
    priv_data: Pointer;

    (**
     * Parameters of the input stream. This field is allocated in
     * av_bsf_alloc(), it needs to be filled by the caller before
     * av_bsf_init().
     *)
    par_in: PAVCodecParameters;

    (**
     * Parameters of the output stream. This field is allocated in
     * av_bsf_alloc(), it is set by the filter in av_bsf_init().
     *)
    par_out: PAVCodecParameters;

    (**
     * The timebase used for the timestamps of the input packets. Set by the
     * caller before av_bsf_init().
     *)
    time_base_in: TAVRational;

    (**
     * The timebase used for the timestamps of the output packets. Set by the
     * filter in av_bsf_init().
     *)
    time_base_out: TAVRational;
  end;

  TAVBitStreamFilter = record
    name: PAnsiChar;

    (**
     * A list of codec ids supported by the filter, terminated by
     * AV_CODEC_ID_NONE.
     * May be NULL, in that case the bitstream filter works with any codec id.
     *)
    codec_ids: PAVCodecID;

    (**
     * A class for the private data, used to declare bitstream filter private
     * AVOptions. This field is NULL for bitstream filters that do not declare
     * any options.
     *
     * If this field is non-NULL, the first member of the filter private data
     * must be a pointer to AVClass, which will be set by libavcodec generic
     * code to this class.
     *)
    priv_class: PAVClass;

    (*****************************************************************
     * No fields below this line are part of the public API. They
     * may not be used outside of libavcodec and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     *)

    priv_data_size: Integer;
    init: function(ctx: PAVBSFContext): Integer; cdecl;
    filter: function(ctx: PAVBSFContext; pkt: PAVPacket): Integer; cdecl;
    close: procedure(ctx: PAVBSFContext); cdecl;
  end;

{$IFDEF FF_API_OLD_BSF}
(**
 * Register a bitstream filter.
 *
 * The filter will be accessible to the application code through
 * av_bitstream_filter_next() or can be directly initialized with
 * av_bitstream_filter_init().
 *
 * @see avcodec_register_all()
 *)

{$IFDEF API_Dynamic}
var av_register_bitstream_filter : procedure(bsf: PAVBitStreamFilter); cdecl;
{$ELSE API_Dynamic}
procedure av_register_bitstream_filter(bsf: PAVBitStreamFilter); cdecl; external AVCODEC_LIBNAME name _PU + 'av_register_bitstream_filter';
{$ENDIF API_Dynamic}


(**
 * Create and initialize a bitstream filter context given a bitstream
 * filter name.
 *
 * The returned context must be freed with av_bitstream_filter_close().
 *
 * @param name    the name of the bitstream filter
 * @return a bitstream filter context if a matching filter was found
 * and successfully initialized, NULL otherwise
 *)

{$IFDEF API_Dynamic}
var av_bitstream_filter_init : function(const name: PAnsiChar): PAVBitStreamFilterContext; cdecl;
{$ELSE API_Dynamic}
function av_bitstream_filter_init(const name: PAnsiChar): PAVBitStreamFilterContext; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bitstream_filter_init';
{$ENDIF API_Dynamic}


(**
 * Filter bitstream.
 *
 * This function filters the buffer buf with size buf_size, and places the
 * filtered buffer in the buffer pointed to by poutbuf.
 *
 * The output buffer must be freed by the caller.
 *
 * @param bsfc            bitstream filter context created by av_bitstream_filter_init()
 * @param avctx           AVCodecContext accessed by the filter, may be NULL.
 *                        If specified, this must point to the encoder context of the
 *                        output stream the packet is sent to.
 * @param args            arguments which specify the filter configuration, may be NULL
 * @param poutbuf         pointer which is updated to point to the filtered buffer
 * @param poutbuf_size    pointer which is updated to the filtered buffer size in bytes
 * @param buf             buffer containing the data to filter
 * @param buf_size        size in bytes of buf
 * @param keyframe        set to non-zero if the buffer to filter corresponds to a key-frame packet data
 * @return >= 0 in case of success, or a negative error code in case of failure
 *
 * If the return value is positive, an output buffer is allocated and
 * is available in *poutbuf, and is distinct from the input buffer.
 *
 * If the return value is 0, the output buffer is not allocated and
 * should be considered identical to the input buffer, or in case
 * *poutbuf was set it points to the input buffer (not necessarily to
 * its starting address). A special case is if *poutbuf was set to NULL and
 * *poutbuf_size was set to 0, which indicates the packet should be dropped.
 *)

{$IFDEF API_Dynamic}
var av_bitstream_filter_filter : function(bsfc: PAVBitStreamFilterContext;
                               avctx: PAVCodecContext; const args: PAnsiChar;
                               poutbuf: PPByte; poutbuf_size: PInteger;
                               const buf: PByte; buf_size, keyframe: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_bitstream_filter_filter(bsfc: PAVBitStreamFilterContext;
                               avctx: PAVCodecContext; const args: PAnsiChar;
                               poutbuf: PPByte; poutbuf_size: PInteger;
                               const buf: PByte; buf_size, keyframe: Integer): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bitstream_filter_filter';
{$ENDIF API_Dynamic}


(**
 * Release bitstream filter context.
 *
 * @param bsf the bitstream filter context created with
 * av_bitstream_filter_init(), can be NULL
 *)

{$IFDEF API_Dynamic}
var av_bitstream_filter_close : procedure(bsf: PAVBitStreamFilterContext); cdecl;
{$ELSE API_Dynamic}
procedure av_bitstream_filter_close(bsf: PAVBitStreamFilterContext); cdecl; external AVCODEC_LIBNAME name _PU + 'av_bitstream_filter_close';
{$ENDIF API_Dynamic}


(**
 * If f is NULL, return the first registered bitstream filter,
 * if f is non-NULL, return the next registered bitstream filter
 * after f, or NULL if f is the last one.
 *
 * This function can be used to iterate over all registered bitstream
 * filters.
 *)

{$IFDEF API_Dynamic}
var av_bitstream_filter_next : function(const f: PAVBitStreamFilter): PAVBitStreamFilter; cdecl;
{$ELSE API_Dynamic}
function av_bitstream_filter_next(const f: PAVBitStreamFilter): PAVBitStreamFilter; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bitstream_filter_next';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * @return a bitstream filter with the specified name or NULL if no such
 *         bitstream filter exists.
 *)

{$IFDEF API_Dynamic}
var av_bsf_get_by_name : function(const name: PAnsiChar): PAVBitStreamFilter; cdecl;
{$ELSE API_Dynamic}
function av_bsf_get_by_name(const name: PAnsiChar): PAVBitStreamFilter; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_get_by_name';
{$ENDIF API_Dynamic}


(**
 * Iterate over all registered bitstream filters.
 *
 * @param opaque a pointer where libavcodec will store the iteration state. Must
 *               point to NULL to start the iteration.
 *
 * @return the next registered bitstream filter or NULL when the iteration is
 *         finished
 *)

{$IFDEF API_Dynamic}
var av_bsf_next : function(opaque: PPointer): PAVBitStreamFilter; cdecl;
{$ELSE API_Dynamic}
function av_bsf_next(opaque: PPointer): PAVBitStreamFilter; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_next';
{$ENDIF API_Dynamic}


(**
 * Allocate a context for a given bitstream filter. The caller must fill in the
 * context parameters as described in the documentation and then call
 * av_bsf_init() before sending any data to the filter.
 *
 * @param filter the filter for which to allocate an instance.
 * @param ctx a pointer into which the pointer to the newly-allocated context
 *            will be written. It must be freed with av_bsf_free() after the
 *            filtering is done.
 *
 * @return 0 on success, a negative AVERROR code on failure
 *)

{$IFDEF API_Dynamic}
var av_bsf_alloc : function(const filter: PAVBitStreamFilter; ctx: PPAVBSFContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_bsf_alloc(const filter: PAVBitStreamFilter; ctx: PPAVBSFContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_alloc';
{$ENDIF API_Dynamic}


(**
 * Prepare the filter for use, after all the parameters and options have been
 * set.
 *)

{$IFDEF API_Dynamic}
var av_bsf_init : function(ctx: PAVBSFContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_bsf_init(ctx: PAVBSFContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_init';
{$ENDIF API_Dynamic}


(**
 * Submit a packet for filtering.
 *
 * After sending each packet, the filter must be completely drained by calling
 * av_bsf_receive_packet() repeatedly until it returns AVERROR(EAGAIN) or
 * AVERROR_EOF.
 *
 * @param pkt the packet to filter. The bitstream filter will take ownership of
 * the packet and reset the contents of pkt. pkt is not touched if an error occurs.
 * This parameter may be NULL, which signals the end of the stream (i.e. no more
 * packets will be sent). That will cause the filter to output any packets it
 * may have buffered internally.
 *
 * @return 0 on success, a negative AVERROR on error.
 *)

{$IFDEF API_Dynamic}
var av_bsf_send_packet : function(ctx: PAVBSFContext; pkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_bsf_send_packet(ctx: PAVBSFContext; pkt: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_send_packet';
{$ENDIF API_Dynamic}


(**
 * Retrieve a filtered packet.
 *
 * @param[out] pkt this struct will be filled with the contents of the filtered
 *                 packet. It is owned by the caller and must be freed using
 *                 av_packet_unref() when it is no longer needed.
 *                 This parameter should be "clean" (i.e. freshly allocated
 *                 with av_packet_alloc() or unreffed with av_packet_unref())
 *                 when this function is called. If this function returns
 *                 successfully, the contents of pkt will be completely
 *                 overwritten by the returned data. On failure, pkt is not
 *                 touched.
 *
 * @return 0 on success. AVERROR(EAGAIN) if more packets need to be sent to the
 * filter (using av_bsf_send_packet()) to get more output. AVERROR_EOF if there
 * will be no further output from the filter. Another negative AVERROR value if
 * an error occurs.
 *
 * @note one input packet may result in several output packets, so after sending
 * a packet with av_bsf_send_packet(), this function needs to be called
 * repeatedly until it stops returning 0. It is also possible for a filter to
 * output fewer packets than were sent to it, so this function may return
 * AVERROR(EAGAIN) immediately after a successful av_bsf_send_packet() call.
 *)

{$IFDEF API_Dynamic}
var av_bsf_receive_packet : function(ctx: PAVBSFContext; pkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_bsf_receive_packet(ctx: PAVBSFContext; pkt: PAVPacket): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_receive_packet';
{$ENDIF API_Dynamic}


(**
 * Free a bitstream filter context and everything associated with it; write NULL
 * into the supplied pointer.
 *)

{$IFDEF API_Dynamic}
var av_bsf_free : procedure(ctx: PPAVBSFContext); cdecl;
{$ELSE API_Dynamic}
procedure av_bsf_free(ctx: PPAVBSFContext); cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_free';
{$ENDIF API_Dynamic}


(**
 * Get the AVClass for AVBSFContext. It can be used in combination with
 * AV_OPT_SEARCH_FAKE_OBJ for examining options.
 *
 * @see av_opt_find().
 *)

{$IFDEF API_Dynamic}
var av_bsf_get_class : function: PAVClass; cdecl;
{$ELSE API_Dynamic}
function av_bsf_get_class: PAVClass; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_get_class';
{$ENDIF API_Dynamic}


type
(**
 * Structure for chain/list of bitstream filters.
 * Empty list can be allocated by av_bsf_list_alloc().
 *)
  PPAVBSFList = ^PAVBSFList;
  PAVBSFList = ^TAVBSFList;
  TAVBSFList = record
    // need {$ALIGN 8}
    // defined in libavcodec/bsf.c
  end;

(**
 * Allocate empty list of bitstream filters.
 * The list must be later freed by av_bsf_list_free()
 * or finalized by av_bsf_list_finalize().
 *
 * @return Pointer to @ref AVBSFList on success, NULL in case of failure
 *)

{$IFDEF API_Dynamic}
var av_bsf_list_alloc : function: PAVBSFList; cdecl;
{$ELSE API_Dynamic}
function av_bsf_list_alloc: PAVBSFList; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_list_alloc';
{$ENDIF API_Dynamic}


(**
 * Free list of bitstream filters.
 *
 * @param lst Pointer to pointer returned by av_bsf_list_alloc()
 *)

{$IFDEF API_Dynamic}
var av_bsf_list_free : procedure(lst: PPAVBSFList); cdecl;
{$ELSE API_Dynamic}
procedure av_bsf_list_free(lst: PPAVBSFList); cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_list_free';
{$ENDIF API_Dynamic}


(**
 * Append bitstream filter to the list of bitstream filters.
 *
 * @param lst List to append to
 * @param bsf Filter context to be appended
 *
 * @return >=0 on success, negative AVERROR in case of failure
 *)

{$IFDEF API_Dynamic}
var av_bsf_list_append : function(lst: PAVBSFList; bsf: PAVBSFContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_bsf_list_append(lst: PAVBSFList; bsf: PAVBSFContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_list_append';
{$ENDIF API_Dynamic}


(**
 * Construct new bitstream filter context given it's name and options
 * and append it to the list of bitstream filters.
 *
 * @param lst      List to append to
 * @param bsf_name Name of the bitstream filter
 * @param options  Options for the bitstream filter, can be set to NULL
 *
 * @return >=0 on success, negative AVERROR in case of failure
 *)

{$IFDEF API_Dynamic}
var av_bsf_list_append2 : function(lst: PAVBSFList; const bsf_name: PAnsiChar; options: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function av_bsf_list_append2(lst: PAVBSFList; const bsf_name: PAnsiChar; options: PPAVDictionary): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_list_append2';
{$ENDIF API_Dynamic}


(**
 * Finalize list of bitstream filters.
 *
 * This function will transform @ref AVBSFList to single @ref AVBSFContext,
 * so the whole chain of bitstream filters can be treated as single filter
 * freshly allocated by av_bsf_alloc().
 * If the call is successful, @ref AVBSFList structure is freed and lst
 * will be set to NULL. In case of failure, caller is responsible for
 * freeing the structure by av_bsf_list_free()
 *
 * @param      lst Filter list structure to be transformed
 * @param[out] bsf Pointer to be set to newly created @ref AVBSFContext structure
 *                 representing the chain of bitstream filters
 *
 * @return >=0 on success, negative AVERROR in case of failure
 *)

{$IFDEF API_Dynamic}
var av_bsf_list_finalize : function(lst: PPAVBSFList; bsf: PPAVBSFContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_bsf_list_finalize(lst: PPAVBSFList; bsf: PPAVBSFContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_list_finalize';
{$ENDIF API_Dynamic}


(**
 * Parse string describing list of bitstream filters and create single
 * @ref AVBSFContext describing the whole chain of bitstream filters.
 * Resulting @ref AVBSFContext can be treated as any other @ref AVBSFContext freshly
 * allocated by av_bsf_alloc().
 *
 * @param      str String describing chain of bitstream filters in format
 *                 `bsf1[=opt1=val1:opt2=val2][,bsf2]`
 * @param[out] bsf Pointer to be set to newly created @ref AVBSFContext structure
 *                 representing the chain of bitstream filters
 *
 * @return >=0 on success, negative AVERROR in case of failure
 *)

{$IFDEF API_Dynamic}
var av_bsf_list_parse_str : function(const str: PAnsiChar; bsf: PPAVBSFContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_bsf_list_parse_str(const str: PAnsiChar; bsf: PPAVBSFContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_list_parse_str';
{$ENDIF API_Dynamic}


(**
 * Get null/pass-through bitstream filter.
 *
 * @param[out] bsf Pointer to be set to new instance of pass-through bitstream filter
 *
 * @return
 *)

{$IFDEF API_Dynamic}
var av_bsf_get_null_filter : function(bsf: PPAVBSFContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_bsf_get_null_filter(bsf: PPAVBSFContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_bsf_get_null_filter';
{$ENDIF API_Dynamic}


(* memory *)

(**
 * Same behaviour av_fast_malloc but the buffer has additional
 * AV_INPUT_BUFFER_PADDING_SIZE at the end which will always be 0.
 *
 * In addition the whole buffer will initially and after resizes
 * be 0-initialized so that no uninitialized data will ever appear.
 *)

{$IFDEF API_Dynamic}
var av_fast_padded_malloc : procedure(ptr: Pointer; size: PCardinal; min_size: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_fast_padded_malloc(ptr: Pointer; size: PCardinal; min_size: Cardinal); cdecl; external AVCODEC_LIBNAME name _PU + 'av_fast_padded_malloc';
{$ENDIF API_Dynamic}


(**
 * Same behaviour av_fast_padded_malloc except that buffer will always
 * be 0-initialized after call.
 *)

{$IFDEF API_Dynamic}
var av_fast_padded_mallocz : procedure(ptr: Pointer; size: PCardinal; min_size: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_fast_padded_mallocz(ptr: Pointer; size: PCardinal; min_size: Cardinal); cdecl; external AVCODEC_LIBNAME name _PU + 'av_fast_padded_mallocz';
{$ENDIF API_Dynamic}


(**
 * Encode extradata length to a buffer. Used by xiph codecs.
 *
 * @param s buffer to write to; must be at least (v/255+1) bytes long
 * @param v size of extradata in bytes
 * @return number of bytes written to the buffer.
 *)

{$IFDEF API_Dynamic}
var av_xiphlacing : function(s: PAnsiChar; v: Cardinal): Cardinal; cdecl;
{$ELSE API_Dynamic}
function av_xiphlacing(s: PAnsiChar; v: Cardinal): Cardinal; cdecl; external AVCODEC_LIBNAME name _PU + 'av_xiphlacing';
{$ENDIF API_Dynamic}


{$IFDEF FF_API_MISSING_SAMPLE}
(**
 * Log a generic warning message about a missing feature. This function is
 * intended to be used internally by FFmpeg (libavcodec, libavformat, etc.)
 * only, and would normally not be used by applications.
 * @param[in] avc a pointer to an arbitrary struct of which the first field is
 * a pointer to an AVClass struct
 * @param[in] feature string containing the name of the missing feature
 * @param[in] want_sample indicates if samples are wanted which exhibit this feature.
 * If want_sample is non-zero, additional verbiage will be added to the log
 * message which tells the user how to report samples to the development
 * mailing list.
 * @deprecated Use avpriv_report_missing_feature() instead.
 *)

{$IFDEF API_Dynamic}
var av_log_missing_feature : procedure(avc: Pointer; const feature: PAnsiChar; want_sample: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_log_missing_feature(avc: Pointer; const feature: PAnsiChar; want_sample: Integer); cdecl; external AVCODEC_LIBNAME name _PU + 'av_log_missing_feature';
{$ENDIF API_Dynamic}


(**
 * Log a generic warning message asking for a sample. This function is
 * intended to be used internally by FFmpeg (libavcodec, libavformat, etc.)
 * only, and would normally not be used by applications.
 * @param[in] avc a pointer to an arbitrary struct of which the first field is
 * a pointer to an AVClass struct
 * @param[in] msg string containing an optional message, or NULL if no message
 * @deprecated Use avpriv_request_sample() instead.
 *)
  //void av_log_ask_for_sample(void *avc, const char *msg, ...) av_printf_format(2, 3);

{$IFDEF API_Dynamic}
var av_log_ask_for_sample : procedure(avc: Pointer; const msg: PAnsiChar); cdecl;
{$ELSE API_Dynamic}
procedure av_log_ask_for_sample(avc: Pointer; const msg: PAnsiChar); cdecl varargs; external AVCODEC_LIBNAME name _PU + 'av_log_ask_for_sample';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * Register the hardware accelerator hwaccel.
 *)

{$IFDEF API_Dynamic}
var av_register_hwaccel : procedure(hwaccel: PAVHWAccel); cdecl;
{$ELSE API_Dynamic}
procedure av_register_hwaccel(hwaccel: PAVHWAccel); cdecl; external AVCODEC_LIBNAME name _PU + 'av_register_hwaccel';
{$ENDIF API_Dynamic}


(**
 * If hwaccel is NULL, returns the first registered hardware accelerator,
 * if hwaccel is non-NULL, returns the next registered hardware accelerator
 * after hwaccel, or NULL if hwaccel is the last one.
 *)

{$IFDEF API_Dynamic}
var av_hwaccel_next : function(const hwaccel: PAVHWAccel): PAVHWAccel; cdecl;
{$ELSE API_Dynamic}
function av_hwaccel_next(const hwaccel: PAVHWAccel): PAVHWAccel; cdecl; external AVCODEC_LIBNAME name _PU + 'av_hwaccel_next';
{$ENDIF API_Dynamic}



(**
 * Lock operation used by lockmgr
 *)
type
  TAVLockOp = (
    AV_LOCK_CREATE,  ///< Create a mutex
    AV_LOCK_OBTAIN,  ///< Lock the mutex
    AV_LOCK_RELEASE, ///< Unlock the mutex
    AV_LOCK_DESTROY  ///< Free mutex resources
  );

(**
 * Register a user provided lock manager supporting the operations
 * specified by AVLockOp. The "mutex" argument to the function points
 * to a (void * ) where the lockmgr should store/get a pointer to a user
 * allocated mutex. It is NULL upon AV_LOCK_CREATE and equal to the
 * value left by the last call for all other ops. If the lock manager is
 * unable to perform the op then it should leave the mutex in the same
 * state as when it was called and return a non-zero value. However,
 * when called with AV_LOCK_DESTROY the mutex will always be assumed to
 * have been successfully destroyed. If av_lockmgr_register succeeds
 * it will return a non-negative value, if it fails it will return a
 * negative value and destroy all mutex and unregister all callbacks.
 * av_lockmgr_register is not thread-safe, it must be called from a
 * single thread before any calls which make use of locking are used.
 *
 * @param cb User defined callback. av_lockmgr_register invokes calls
 *           to this callback and the previously registered callback.
 *           The callback will be used to create more than one mutex
 *           each of which must be backed by its own underlying locking
 *           mechanism (i.e. do not use a single static object to
 *           implement your lock manager). If cb is set to NULL the
 *           lockmgr will be unregistered.
 *)
  TlockmgrcbCall = function(mutex: PPointer; op: TAVLockOp): Integer; cdecl;

{$IFDEF API_Dynamic}
var av_lockmgr_register : function(cb: TlockmgrcbCall): Integer; cdecl;
{$ELSE API_Dynamic}
function av_lockmgr_register(cb: TlockmgrcbCall): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_lockmgr_register';
{$ENDIF API_Dynamic}


(**
 * Get the type of the given codec.
 *)

{$IFDEF API_Dynamic}
var avcodec_get_type : function(codec_id: TAVCodecID): TAVMediaType; cdecl;
{$ELSE API_Dynamic}
function avcodec_get_type(codec_id: TAVCodecID): TAVMediaType; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_get_type';
{$ENDIF API_Dynamic}


(**
 * Get the name of a codec.
 * @return  a static string identifying the codec; never NULL
 *)

{$IFDEF API_Dynamic}
var avcodec_get_name : function(id: TAVCodecID): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avcodec_get_name(id: TAVCodecID): PAnsiChar; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_get_name';
{$ENDIF API_Dynamic}


(**
 * @return a positive value if s is open (i.e. avcodec_open2() was called on it
 * with no corresponding avcodec_close()), 0 otherwise.
 *)

{$IFDEF API_Dynamic}
var avcodec_is_open : function(s: PAVCodecContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avcodec_is_open(s: PAVCodecContext): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_is_open';
{$ENDIF API_Dynamic}


(**
 * @return a non-zero number if codec is an encoder, zero otherwise
 *)

{$IFDEF API_Dynamic}
var av_codec_is_encoder : function(const codec: PAVCodec): Integer; cdecl;
{$ELSE API_Dynamic}
function av_codec_is_encoder(const codec: PAVCodec): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_is_encoder';
{$ENDIF API_Dynamic}


(**
 * @return a non-zero number if codec is a decoder, zero otherwise
 *)

{$IFDEF API_Dynamic}
var av_codec_is_decoder : function(const codec: PAVCodec): Integer; cdecl;
{$ELSE API_Dynamic}
function av_codec_is_decoder(const codec: PAVCodec): Integer; cdecl; external AVCODEC_LIBNAME name _PU + 'av_codec_is_decoder';
{$ENDIF API_Dynamic}


(**
 * @return descriptor for given codec ID or NULL if no descriptor exists.
 *)

{$IFDEF API_Dynamic}
var avcodec_descriptor_get : function(id: TAVCodecID): PAVCodecDescriptor; cdecl;
{$ELSE API_Dynamic}
function avcodec_descriptor_get(id: TAVCodecID): PAVCodecDescriptor; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_descriptor_get';
{$ENDIF API_Dynamic}


(**
 * Iterate over all codec descriptors known to libavcodec.
 *
 * @param prev previous descriptor. NULL to get the first descriptor.
 *
 * @return next descriptor or NULL after the last descriptor
 *)

{$IFDEF API_Dynamic}
var avcodec_descriptor_next : function(const prev: PAVCodecDescriptor): PAVCodecDescriptor; cdecl;
{$ELSE API_Dynamic}
function avcodec_descriptor_next(const prev: PAVCodecDescriptor): PAVCodecDescriptor; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_descriptor_next';
{$ENDIF API_Dynamic}


(**
 * @return codec descriptor with the given name or NULL if no such descriptor
 *         exists.
 *)

{$IFDEF API_Dynamic}
var avcodec_descriptor_get_by_name : function(const name: PAnsiChar): PAVCodecDescriptor; cdecl;
{$ELSE API_Dynamic}
function avcodec_descriptor_get_by_name(const name: PAnsiChar): PAVCodecDescriptor; cdecl; external AVCODEC_LIBNAME name _PU + 'avcodec_descriptor_get_by_name';
{$ENDIF API_Dynamic}


(**
 * Allocate a CPB properties structure and initialize its fields to default
 * values.
 *
 * @param size if non-NULL, the size of the allocated struct will be written
 *             here. This is useful for embedding it in side data.
 *
 * @return the newly allocated struct or NULL on failure
 *)

{$IFDEF API_Dynamic}
var av_cpb_properties_alloc : function(size: Cardinal): PAVCPBProperties; cdecl;
{$ELSE API_Dynamic}
function av_cpb_properties_alloc(size: Cardinal): PAVCPBProperties; cdecl; external AVCODEC_LIBNAME name _PU + 'av_cpb_properties_alloc';
{$ENDIF API_Dynamic}


(**
 * @}
 *)

(*
// libavutil/internal.h
#define MAKE_ACCESSORS(str, name, type, field) \
    type av_##name##_get_##field(const str *s) { return s->field; } \
    void av_##name##_set_##field(str *s, type v) { s->field = v; }
// libavcodec/utils.c
MAKE_ACCESSORS(AVCodecContext, codec, AVRational, pkt_timebase)
MAKE_ACCESSORS(AVCodecContext, codec, const AVCodecDescriptor *, codec_descriptor)
MAKE_ACCESSORS(AVCodecContext, codec, int, lowres)
MAKE_ACCESSORS(AVCodecContext, codec, int, seek_preroll)
MAKE_ACCESSORS(AVCodecContext, codec, uint16_t*, chroma_intra_matrix)
*)

function av_codec_get_pkt_timebase(const avctx: PAVCodecContext): TAVRational;  {$IFDEF USE_INLINE}inline;{$ENDIF}


(* ****************************************************** *)
(* import libavfilter *)
(* ****************************************************** *)






(**
 * @defgroup lavfi libavfilter
 * Graph-based frame editing library.
 *
 * @{
 *)

const
(**
 * The number of the filter inputs is not determined just by AVFilter.inputs.
 * The filter might add additional inputs during initialization depending on the
 * options supplied to it.
 *)
  AVFILTER_FLAG_DYNAMIC_INPUTS            = (1 shl  0);
(**
 * The number of the filter outputs is not determined just by AVFilter.outputs.
 * The filter might add additional outputs during initialization depending on
 * the options supplied to it.
 *)
  AVFILTER_FLAG_DYNAMIC_OUTPUTS           = (1 shl  1);
(**
 * The filter supports multithreading by splitting frames into multiple parts
 * and processing them concurrently.
 *)
  AVFILTER_FLAG_SLICE_THREADS             = (1 shl  2);
(**
 * Some filters support a generic "enable" expression option that can be used
 * to enable or disable a filter in the timeline. Filters supporting this
 * option have this flag set. When the enable expression is false, the default
 * no-op filter_frame() function is called in place of the filter_frame()
 * callback defined on each input pad, thus the frame is passed unchanged to
 * the next filters.
 *)
  AVFILTER_FLAG_SUPPORT_TIMELINE_GENERIC  = (1 shl 16);
(**
 * Same as AVFILTER_FLAG_SUPPORT_TIMELINE_GENERIC, except that the filter will
 * have its filter_frame() callback(s) called as usual even when the enable
 * expression is false. The filter will disable filtering within the
 * filter_frame() callback(s) itself, for example executing code depending on
 * the AVFilterContext->is_disabled value.
 *)
  AVFILTER_FLAG_SUPPORT_TIMELINE_INTERNAL = (1 shl 17);
(**
 * Handy mask to test whether the filter supports or no the timeline feature
 * (internally or generically).
 *)
  AVFILTER_FLAG_SUPPORT_TIMELINE          = (AVFILTER_FLAG_SUPPORT_TIMELINE_GENERIC or AVFILTER_FLAG_SUPPORT_TIMELINE_INTERNAL);

(**
 * Process multiple parts of the frame concurrently.
 *)
  AVFILTER_THREAD_SLICE  = (1 shl 0);

  AVFILTER_CMD_FLAG_ONE  = 1; ///< Stop once a filter understood the command (for target=all for example), fast filters are favored automatically
  AVFILTER_CMD_FLAG_FAST = 2; ///< Only execute command when its fast (like a video out that supports contrast adjustment in hw)

  AVFILTER_AUTO_CONVERT_NONE = -1; (**< all automatic conversions disabled *)
  AVFILTER_AUTO_CONVERT_ALL  =  0;  (**< all automatic conversions enabled *)

(**
 * Return the LIBAVFILTER_VERSION_INT constant.
 *)

{$IFDEF API_Dynamic}
var avfilter_version : function: Cardinal; cdecl;
{$ELSE API_Dynamic}
function avfilter_version: Cardinal; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_version';
{$ENDIF API_Dynamic}


(**
 * Return the libavfilter build-time configuration.
 *)

{$IFDEF API_Dynamic}
var avfilter_configuration : function: PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avfilter_configuration: PAnsiChar; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_configuration';
{$ENDIF API_Dynamic}


(**
 * Return the libavfilter license.
 *)

{$IFDEF API_Dynamic}
var avfilter_license : function: PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avfilter_license: PAnsiChar; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_license';
{$ENDIF API_Dynamic}


type
(**
 * A list of supported formats for one end of a filter link. This is used
 * during the format negotiation process to try to pick the best format to
 * use to minimize the number of necessary conversions. Each filter gives a
 * list of the formats supported by each input and output pad. The list
 * given for each pad need not be distinct - they may be references to the
 * same list of formats, as is often the case when a filter supports multiple
 * formats, but will always output the same format as it is given in input.
 *
 * In this way, a list of possible input formats and a list of possible
 * output formats are associated with each link. When a set of formats is
 * negotiated over a link, the input and output lists are merged to form a
 * new list containing only the common elements of each list. In the case
 * that there were no common elements, a format conversion is necessary.
 * Otherwise, the lists are merged, and all other links which reference
 * either of the format lists involved in the merge are also affected.
 *
 * For example, consider the filter chain:
 * filter (a) --> (b) filter (b) --> (c) filter
 *
 * where the letters in parenthesis indicate a list of formats supported on
 * the input or output of the link. Suppose the lists are as follows:
 * (a) = {A, B}
 * (b) = {A, B, C}
 * (c) = {B, C}
 *
 * First, the first link's lists are merged, yielding:
 * filter (a) --> (a) filter (a) --> (c) filter
 *
 * Notice that format list (b) now refers to the same list as filter list (a).
 * Next, the lists for the second link are merged, yielding:
 * filter (a) --> (a) filter (a) --> (a) filter
 *
 * where (a) = {B}.
 *
 * Unfortunately, when the format lists at the two ends of a link are merged,
 * we must ensure that all links which reference either pre-merge format list
 * get updated as well. Therefore, we have the format list structure store a
 * pointer to each of the pointers to itself.
 *)
  PPPAVFilterFormats = ^PPAVFilterFormats;
  PPAVFilterFormats = ^PAVFilterFormats;
  PAVFilterFormats = ^TAVFilterFormats;
  TAVFilterFormats = record
    nb_formats: Cardinal;         ///< number of formats
    formats: PInteger;            ///< list of media formats

    refcount: Cardinal;           ///< number of references to this list
    refs: PPPAVFilterFormats;     ///< references to this list
  end;

(**
 * A list of supported channel layouts.
 *
 * The list works the same as AVFilterFormats, except for the following
 * differences:
 * - A list with all_layouts = 1 means all channel layouts with a known
 *   disposition; nb_channel_layouts must then be 0.
 * - A list with all_counts = 1 means all channel counts, with a known or
 *   unknown disposition; nb_channel_layouts must then be 0 and all_layouts 1.
 * - The list must not contain a layout with a known disposition and a
 *   channel count with unknown disposition with the same number of channels
 *   (e.g. AV_CH_LAYOUT_STEREO and FF_COUNT2LAYOUT(2).
 *)
  PPPAVFilterChannelLayouts = ^PPAVFilterChannelLayouts;
  PPAVFilterChannelLayouts = ^PAVFilterChannelLayouts;
  PAVFilterChannelLayouts = ^TAVFilterChannelLayouts;
  TAVFilterChannelLayouts = record
    channel_layouts: PInt64;          ///< list of channel layouts
    nb_channel_layouts: Integer;      ///< number of channel layouts
    all_layouts: AnsiChar;            ///< accept any known channel layout
    all_counts: AnsiChar;             ///< accept any channel layout or count

    refcount: Cardinal;               ///< number of references to this list
    refs: PPPAVFilterChannelLayouts;  ///< references to this list
  end;

  PAVFilterPad = ^TAVFilterPad;
  TAVFilterPad = record
    // need {$ALIGN 8}
    // defined in libavfilter/internal.h
  end;

(**
 * Filter definition. This defines the pads a filter contains, and all the
 * callback functions used to interact with the filter.
 *)
  PPAVFilterContext = ^PAVFilterContext;
  PAVFilterContext = ^TAVFilterContext;
  PPAVFilter = ^PAVFilter;
  PAVFilter = ^TAVFilter;
  TAVFilter = record
    (**
     * Filter name. Must be non-NULL and unique among filters.
     *)
    name: PAnsiChar;         ///< filter name

    (**
     * A description of the filter. May be NULL.
     *
     * You should use the NULL_IF_CONFIG_SMALL() macro to define it.
     *)
    description: PAnsiChar;

    (**
     * List of inputs, terminated by a zeroed element.
     *
     * NULL if there are no (static) inputs. Instances of filters with
     * AVFILTER_FLAG_DYNAMIC_INPUTS set may have more inputs than present in
     * this list.
     *)
    inputs: PAVFilterPad;  ///< NULL terminated list of inputs. NULL if none
    (**
     * List of outputs, terminated by a zeroed element.
     *
     * NULL if there are no (static) outputs. Instances of filters with
     * AVFILTER_FLAG_DYNAMIC_OUTPUTS set may have more outputs than present in
     * this list.
     *)
    outputs: PAVFilterPad; ///< NULL terminated list of outputs. NULL if none

    (**
     * A class for the private data, used to declare filter private AVOptions.
     * This field is NULL for filters that do not declare any options.
     *
     * If this field is non-NULL, the first member of the filter private data
     * must be a pointer to AVClass, which will be set by libavfilter generic
     * code to this class.
     *)
    priv_class: PAVClass;

    (**
     * A combination of AVFILTER_FLAG_*
     *)
    flags: Integer;

    (*****************************************************************
     * All fields below this line are not part of the public API. They
     * may not be used outside of libavfilter and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     *)

    (**
     * Filter pre-initialization function
     *
     * This callback will be called immediately after the filter context is
     * allocated, to allow allocating and initing sub-objects.
     *
     * If this callback is not NULL, the uninit callback will be called on
     * allocation failure.
     *
     * @return 0 on success,
     *         AVERROR code on failure (but the code will be
     *           dropped and treated as ENOMEM by the calling code)
     *)
    preinit: function(ctx: PAVFilterContext): Integer; cdecl;

    (**
     * Filter initialization function.
     *
     * This callback will be called only once during the filter lifetime, after
     * all the options have been set, but before links between filters are
     * established and format negotiation is done.
     *
     * Basic filter initialization should be done here. Filters with dynamic
     * inputs and/or outputs should create those inputs/outputs here based on
     * provided options. No more changes to this filter's inputs/outputs can be
     * done after this callback.
     *
     * This callback must not assume that the filter links exist or frame
     * parameters are known.
     *
     * @ref AVFilter.uninit "uninit" is guaranteed to be called even if
     * initialization fails, so this callback does not have to clean up on
     * failure.
     *
     * @return 0 on success, a negative AVERROR on failure
     *)
    init: function(ctx: PAVFilterContext): Integer; cdecl;

    (**
     * Should be set instead of @ref AVFilter.init "init" by the filters that
     * want to pass a dictionary of AVOptions to nested contexts that are
     * allocated during init.
     *
     * On return, the options dict should be freed and replaced with one that
     * contains all the options which could not be processed by this filter (or
     * with NULL if all the options were processed).
     *
     * Otherwise the semantics is the same as for @ref AVFilter.init "init".
     *)
    init_dict: function(ctx: PAVFilterContext; options: PPAVDictionary): Integer; cdecl;

    (**
     * Filter uninitialization function.
     *
     * Called only once right before the filter is freed. Should deallocate any
     * memory held by the filter, release any buffer references, etc. It does
     * not need to deallocate the AVFilterContext.priv memory itself.
     *
     * This callback may be called even if @ref AVFilter.init "init" was not
     * called or failed, so it must be prepared to handle such a situation.
     *)
    uninit: procedure(ctx: PAVFilterContext); cdecl;

    (**
     * Query formats supported by the filter on its inputs and outputs.
     *
     * This callback is called after the filter is initialized (so the inputs
     * and outputs are fixed), shortly before the format negotiation. This
     * callback may be called more than once.
     *
     * This callback must set AVFilterLink.out_formats on every input link and
     * AVFilterLink.in_formats on every output link to a list of pixel/sample
     * formats that the filter supports on that link. For audio links, this
     * filter must also set @ref AVFilterLink.in_samplerates "in_samplerates" /
     * @ref AVFilterLink.out_samplerates "out_samplerates" and
     * @ref AVFilterLink.in_channel_layouts "in_channel_layouts" /
     * @ref AVFilterLink.out_channel_layouts "out_channel_layouts" analogously.
     *
     * This callback may be NULL for filters with one input, in which case
     * libavfilter assumes that it supports all input formats and preserves
     * them on output.
     *
     * @return zero on success, a negative value corresponding to an
     * AVERROR code otherwise
     *)
    query_formats: function(ctx: PAVFilterContext): Integer; cdecl;

    priv_size: Integer;  ///< size of private data to allocate for the filter

    flags_internal: Integer; ///< Additional flags for avfilter internal use only.

    (**
     * Used by the filter registration system. Must not be touched by any other
     * code.
     *)
    next: PAVFilter;

    (**
     * Make the filter instance process a command.
     *
     * @param cmd    the command to process, for handling simplicity all commands must be alphanumeric only
     * @param arg    the argument for the command
     * @param res    a buffer with size res_size where the filter(s) can return a response. This must not change when the command is not supported.
     * @param flags  if AVFILTER_CMD_FLAG_FAST is set and the command would be
     *               time consuming then a filter should treat it like an unsupported command
     *
     * @returns >=0 on success otherwise an error code.
     *          AVERROR(ENOSYS) on unsupported commands
     *)
    process_command: function(ctx: PAVFilterContext; const cmd, arg: PAnsiChar; res: PAnsiChar; res_len, flags: Integer): Integer; cdecl;

    (**
     * Filter initialization function, alternative to the init()
     * callback. Args contains the user-supplied parameters, opaque is
     * used for providing binary data.
     *)
    init_opaque: function(ctx: PAVFilterContext; opaque: Pointer): Integer; cdecl;

    (**
     * Filter activation function.
     *
     * Called when any processing is needed from the filter, instead of any
     * filter_frame and request_frame on pads.
     *
     * The function must examine inlinks and outlinks and perform a single
     * step of processing. If there is nothing to do, the function must do
     * nothing and not return an error. If more steps are or may be
     * possible, it must use ff_filter_set_ready() to schedule another
     * activation.
     *)
    activate: function(ctx: PAVFilterContext): Integer; cdecl;
  end;

  PAVFilterInternal = ^TAVFilterInternal;
  TAVFilterInternal = record
    // need {$ALIGN 8}
    // defined in libavfilter/internal.h
  end;

(** An instance of a filter *)
  PPPAVFilterLink = ^PPAVFilterLink;
  PPAVFilterLink = ^PAVFilterLink;
  PAVFilterLink = ^TAVFilterLink;
  PPAVFilterGraph = ^PAVFilterGraph;
  PAVFilterGraph = ^TAVFilterGraph;
  TAVFilterContext = record
    av_class: PAVClass;         ///< needed for av_log() and filters common options

    filter: PAVFilter;          ///< the AVFilter of which this is an instance

    name: PAnsiChar;            ///< name of this filter instance

    input_pads: PAVFilterPad;   ///< array of input pads
    inputs: PPAVFilterLink;     ///< array of pointers to input links
    nb_inputs: Cardinal;        ///< number of input pads

    output_pads: PAVFilterPad;  ///< array of output pads
    outputs: PPAVFilterLink;    ///< array of pointers to output links
    nb_outputs: Cardinal;       ///< number of output pads

    priv: Pointer;              ///< private data for use by the filter

    graph: PAVFilterGraph;      ///< filtergraph this filter belongs to

    (**
     * Type of multithreading being allowed/used. A combination of
     * AVFILTER_THREAD_* flags.
     *
     * May be set by the caller before initializing the filter to forbid some
     * or all kinds of multithreading for this filter. The default is allowing
     * everything.
     *
     * When the filter is initialized, this field is combined using bit AND with
     * AVFilterGraph.thread_type to get the final mask used for determining
     * allowed threading types. I.e. a threading type needs to be set in both
     * to be allowed.
     *
     * After the filter is initialized, libavfilter sets this field to the
     * threading type that is actually used (0 for no multithreading).
     *)
    thread_type: Integer;

    (**
     * An opaque struct for libavfilter internal use.
     *)
    internal: PAVFilterInternal;

    command_queue: Pointer; //PAVFilterCommand;

    enable_str: PAnsiChar;      ///< enable expression string
    enable: Pointer;            ///< parsed expression (AVExpr*)
    var_values: PDouble;        ///< variable values for the enable expression
    is_disabled: Integer;       ///< the enabled state from the last expression evaluation

    (**
     * For filters which will create hardware frames, sets the device the
     * filter should create them in.  All other filters will ignore this field:
     * in particular, a filter which consumes or processes hardware frames will
     * instead use the hw_frames_ctx field in AVFilterLink to carry the
     * hardware context information.
     *)
    hw_device_ctx: PAVBufferRef;

    (**
     * Max number of threads allowed in this filter instance.
     * If <= 0, its value is ignored.
     * Overrides global number of threads set per filter graph.
     *)
    nb_threads: Integer;

    (**
     * Ready status of the filter.
     * A non-0 value means that the filter needs activating;
     * a higher value suggests a more urgent activation.
     *)
    ready: Cardinal;
  end;

  Tinit_state = (
    AVLINK_UNINIT = 0,      ///< not started
    AVLINK_STARTINIT,       ///< started, but incomplete
    AVLINK_INIT             ///< complete
  );

(**
 * A link between two filters. This contains pointers to the source and
 * destination filters between which this link exists, and the indexes of
 * the pads involved. In addition, this link also contains the parameters
 * which have been negotiated and agreed upon between the filter, such as
 * image dimensions, format, etc.
 *
 * Applications must not normally access the link structure directly.
 * Use the buffersrc and buffersink API instead.
 * In the future, access to the header may be reserved for filters
 * implementation.
 *)
  TAVFilterLink = record
    src: PAVFilterContext;    ///< source filter
    srcpad: PAVFilterPad;     ///< output pad on the source filter

    dst: PAVFilterContext;    ///< dest filter
    dstpad: PAVFilterPad;     ///< input pad on the dest filter

    type_: TAVMediaType;      ///< filter media type

    (* These parameters apply only to video *)
    w: Integer;               ///< agreed upon image width
    h: Integer;               ///< agreed upon image height
    sample_aspect_ratio: TAVRational; ///< agreed upon sample aspect ratio
    (* These parameters apply only to audio *)
    channel_layout: Int64;    ///< channel layout of current buffer (see libavutil/channel_layout.h)
    sample_rate: Integer;     ///< samples per second

    format: Integer;          ///< agreed upon media format

    (**
     * Define the time base used by the PTS of the frames/samples
     * which will pass through this link.
     * During the configuration stage, each filter is supposed to
     * change only the output timebase, while the timebase of the
     * input link is assumed to be an unchangeable property.
     *)
    time_base: TAVRational;

    (*****************************************************************
     * All fields below this line are not part of the public API. They
     * may not be used outside of libavfilter and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     *)
    (**
     * Lists of formats and channel layouts supported by the input and output
     * filters respectively. These lists are used for negotiating the format
     * to actually be used, which will be loaded into the format and
     * channel_layout members, above, when chosen.
     *
     *)
    in_formats: PAVFilterFormats;
    out_formats: PAVFilterFormats;

    (**
     * Lists of channel layouts and sample rates used for automatic
     * negotiation.
     *)
    in_samplerates: PAVFilterFormats;
    out_samplerates: PAVFilterFormats;
    in_channel_layouts: PAVFilterChannelLayouts;
    out_channel_layouts: PAVFilterChannelLayouts;

    (**
     * Audio only, the destination filter sets this to a non-zero value to
     * request that buffers with the given number of samples should be sent to
     * it. AVFilterPad.needs_fifo must also be set on the corresponding input
     * pad.
     * Last buffer before EOF will be padded with silence.
     *)
    request_samples: Integer;

    (** stage of the initialization of the link properties (dimensions, etc) *)
    init_state: Tinit_state;

    (**
     * Graph the filter belongs to.
     *)
    graph: PAVFilterGraph;

    (**
     * Current timestamp of the link, as defined by the most recent
     * frame(s), in link time_base units.
     *)
    current_pts: Int64;

    (**
     * Current timestamp of the link, as defined by the most recent
     * frame(s), in AV_TIME_BASE units.
     *)
    current_pts_us: Int64;

    (**
     * Index in the age array.
     *)
    age_index: Integer;

    (**
     * Frame rate of the stream on the link, or 1/0 if unknown or variable;
     * if left to 0/0, will be automatically copied from the first input
     * of the source filter if it exists.
     *
     * Sources should set it to the best estimation of the real frame rate.
     * If the source frame rate is unknown or variable, set this to 1/0.
     * Filters should update it if necessary depending on their function.
     * Sinks can use it to set a default output frame rate.
     * It is similar to the r_frame_rate field in AVStream.
     *)
    frame_rate: TAVRational;

    (**
     * Buffer partially filled with samples to achieve a fixed/minimum size.
     *)
    partial_buf: PAVFrame;

    (**
     * Size of the partial buffer to allocate.
     * Must be between min_samples and max_samples.
     *)
    partial_buf_size: Integer;

    (**
     * Minimum number of samples to filter at once. If filter_frame() is
     * called with fewer samples, it will accumulate them in partial_buf.
     * This field and the related ones must not be changed after filtering
     * has started.
     * If 0, all related fields are ignored.
     *)
    min_samples: Integer;

    (**
     * Maximum number of samples to filter at once. If filter_frame() is
     * called with more samples, it will split them.
     *)
    max_samples: Integer;

    (**
     * Number of channels.
     *)
    channels: Integer;

    (**
     * Link processing flags.
     *)
    flags: Cardinal;

    (**
     * Number of past frames sent through the link.
     *)
    frame_count_in, frame_count_out: Int64;

    (**
     * A pointer to a FFFramePool struct.
     *)
    frame_pool: Pointer;

    (**
     * True if a frame is currently wanted on the output of this filter.
     * Set when ff_request_frame() is called by the output,
     * cleared when a frame is filtered.
     *)
    frame_wanted_out: Integer;

    (**
     * For hwaccel pixel formats, this should be a reference to the
     * AVHWFramesContext describing the frames.
     *)
    hw_frames_ctx: PAVBufferRef;

{$IFNDEF FF_INTERNAL_FIELDS}

    (**
     * Internal structure members.
     * The fields below this limit are internal for libavfilter's use
     * and must in no way be accessed by applications.
     *)
    reserved: array[0..$F000-1] of AnsiChar;

{$ELSE} {* FF_INTERNAL_FIELDS *}

    (**
     * Queue of frames waiting to be filtered.
     *)
    fifo: TFFFrameQueue;

    (**
     * If set, the source filter can not generate a frame as is.
     * The goal is to avoid repeatedly calling the request_frame() method on
     * the same link.
     *)
    frame_blocked_in: Integer;

    (**
     * Link input status.
     * If not zero, all attempts of filter_frame will fail with the
     * corresponding code.
     *)
    status_in: Integer;

    (**
     * Timestamp of the input status change.
     *)
    status_in_pts: Int64;

    (**
     * Link output status.
     * If not zero, all attempts of request_frame will fail with the
     * corresponding code.
     *)
    status_out: Integer;

{$ENDIF} (* FF_INTERNAL_FIELDS *)
  end;

  PAVFilterGraphInternal = ^TAVFilterGraphInternal;
  TAVFilterGraphInternal = record
    // need {$ALIGN 8}
    // defined in libavfilter/internal.h
  end;

(**
 * A function pointer passed to the @ref AVFilterGraph.execute callback to be
 * executed multiple times, possibly in parallel.
 *
 * @param ctx the filter context the job belongs to
 * @param arg an opaque parameter passed through from @ref
 *            AVFilterGraph.execute
 * @param jobnr the index of the job being executed
 * @param nb_jobs the total number of jobs
 *
 * @return 0 on success, a negative AVERROR on error
 *)
  Tavfilter_action_func = function(ctx: PAVFilterContext; arg: Pointer; jobnr, nb_jobs: Integer): Integer; cdecl;

(**
 * A function executing multiple jobs, possibly in parallel.
 *
 * @param ctx the filter context to which the jobs belong
 * @param func the function to be called multiple times
 * @param arg the argument to be passed to func
 * @param ret a nb_jobs-sized array to be filled with return values from each
 *            invocation of func
 * @param nb_jobs the number of jobs to execute
 *
 * @return 0 on success, a negative AVERROR on error
 *)
  Tavfilter_execute_func = function(ctx: PAVFilterContext; func: Tavfilter_action_func;
                                    arg: Pointer; ret: PInteger; nb_jobs: Integer): Integer; cdecl;

  TAVFilterGraph = record
    av_class: PAVClass;
    filters: PPAVFilterContext;
    nb_filters: Cardinal;

    scale_sws_opts: PAnsiChar; ///< sws options to use for the auto-inserted scale filters
{$IFDEF FF_API_LAVR_OPTS}
    resample_lavr_opts: PAnsiChar; ///< libavresample options to use for the auto-inserted resample filters
{$ENDIF}

    (**
     * Type of multithreading allowed for filters in this graph. A combination
     * of AVFILTER_THREAD_* flags.
     *
     * May be set by the caller at any point, the setting will apply to all
     * filters initialized after that. The default is allowing everything.
     *
     * When a filter in this graph is initialized, this field is combined using
     * bit AND with AVFilterContext.thread_type to get the final mask used for
     * determining allowed threading types. I.e. a threading type needs to be
     * set in both to be allowed.
     *)
    thread_type: Integer;

    (**
     * Maximum number of threads used by filters in this graph. May be set by
     * the caller before adding any filters to the filtergraph. Zero (the
     * default) means that the number of threads is determined automatically.
     *)
    nb_threads: Integer;

    (**
     * Opaque object for libavfilter internal use.
     *)
    internal: PAVFilterGraphInternal;

    (**
     * Opaque user data. May be set by the caller to an arbitrary value, e.g. to
     * be used from callbacks like @ref AVFilterGraph.execute.
     * Libavfilter will not touch this field in any way.
     *)
    opaque: Pointer;

    (**
     * This callback may be set by the caller immediately after allocating the
     * graph and before adding any filters to it, to provide a custom
     * multithreading implementation.
     *
     * If set, filters with slice threading capability will call this callback
     * to execute multiple jobs in parallel.
     *
     * If this field is left unset, libavfilter will use its internal
     * implementation, which may or may not be multithreaded depending on the
     * platform and build options.
     *)
    execute: Tavfilter_execute_func;

    aresample_swr_opts: PAnsiChar; ///< swr options to use for the auto-inserted aresample filters, Access ONLY through AVOptions

    (**
     * Private fields
     *
     * The following fields are for internal use only.
     * Their type, offset, number and semantic can change without notice.
     *)

    sink_links: PPAVFilterLink;
    sink_links_count: Integer;

    disable_auto_convert: Cardinal;
  end;

(**
 * Get the number of elements in a NULL-terminated array of AVFilterPads (e.g.
 * AVFilter.inputs/outputs).
 *)

{$IFDEF API_Dynamic}
var avfilter_pad_count : function(const pads: PAVFilterPad): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_pad_count(const pads: PAVFilterPad): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_pad_count';
{$ENDIF API_Dynamic}


(**
 * Get the name of an AVFilterPad.
 *
 * @param pads an array of AVFilterPads
 * @param pad_idx index of the pad in the array it; is the caller's
 *                responsibility to ensure the index is valid
 *
 * @return name of the pad_idx'th pad in pads
 *)

{$IFDEF API_Dynamic}
var avfilter_pad_get_name : function(const pads: PAVFilterPad; pad_idx: Integer): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avfilter_pad_get_name(const pads: PAVFilterPad; pad_idx: Integer): PAnsiChar; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_pad_get_name';
{$ENDIF API_Dynamic}


(**
 * Get the type of an AVFilterPad.
 *
 * @param pads an array of AVFilterPads
 * @param pad_idx index of the pad in the array; it is the caller's
 *                responsibility to ensure the index is valid
 *
 * @return type of the pad_idx'th pad in pads
 *)

{$IFDEF API_Dynamic}
var avfilter_pad_get_type : function(const pads: PAVFilterPad; pad_idx: Integer): TAVMediaType; cdecl;
{$ELSE API_Dynamic}
function avfilter_pad_get_type(const pads: PAVFilterPad; pad_idx: Integer): TAVMediaType; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_pad_get_type';
{$ENDIF API_Dynamic}


(**
 * Link two filters together.
 *
 * @param src    the source filter
 * @param srcpad index of the output pad on the source filter
 * @param dst    the destination filter
 * @param dstpad index of the input pad on the destination filter
 * @return       zero on success
 *)

{$IFDEF API_Dynamic}
var avfilter_link : function(src: PAVFilterContext; srcpad: Cardinal;
                  dst: PAVFilterContext; dstpad: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_link(src: PAVFilterContext; srcpad: Cardinal;
                  dst: PAVFilterContext; dstpad: Cardinal): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_link';
{$ENDIF API_Dynamic}


(**
 * Free the link in *link, and set its pointer to NULL.
 *)

{$IFDEF API_Dynamic}
var avfilter_link_free : procedure(link: PPAVFilterLink); cdecl;
{$ELSE API_Dynamic}
procedure avfilter_link_free(link: PPAVFilterLink); cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_link_free';
{$ENDIF API_Dynamic}


(**
 * Get the number of channels of a link.
 *)

{$IFDEF API_Dynamic}
var avfilter_link_get_channels : function(link: PAVFilterLink): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_link_get_channels(link: PAVFilterLink): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_link_get_channels';
{$ENDIF API_Dynamic}


(**
 * Set the closed field of a link.
 * @deprecated applications are not supposed to mess with links, they should
 * close the sinks.
 *)

{$IFDEF API_Dynamic}
var avfilter_link_set_closed : procedure(link: PAVFilterLink; closed: Integer); cdecl;
{$ELSE API_Dynamic}
procedure avfilter_link_set_closed(link: PAVFilterLink; closed: Integer); cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_link_set_closed';
{$ENDIF API_Dynamic}


(**
 * Negotiate the media format, dimensions, etc of all inputs to a filter.
 *
 * @param filter the filter to negotiate the properties for its inputs
 * @return       zero on successful negotiation
 *)

{$IFDEF API_Dynamic}
var avfilter_config_links : function(filter: PAVFilterContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_config_links(filter: PAVFilterContext): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_config_links';
{$ENDIF API_Dynamic}


(**
 * Make the filter instance process a command.
 * It is recommended to use avfilter_graph_send_command().
 *)

{$IFDEF API_Dynamic}
var avfilter_process_command : function(filter: PAVFilterContext; const cmd, arg: PAnsiChar; res: PAnsiChar; res_len, flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_process_command(filter: PAVFilterContext; const cmd, arg: PAnsiChar; res: PAnsiChar; res_len, flags: Integer): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_process_command';
{$ENDIF API_Dynamic}


(** Initialize the filter system. Register all builtin filters. *)

{$IFDEF API_Dynamic}
var avfilter_register_all : procedure; cdecl;
{$ELSE API_Dynamic}
procedure avfilter_register_all; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_register_all';
{$ENDIF API_Dynamic}


{$IFDEF FF_API_OLD_FILTER_REGISTER}
(** Uninitialize the filter system. Unregister all filters. *)

{$IFDEF API_Dynamic}
var avfilter_uninit : procedure; cdecl;
{$ELSE API_Dynamic}
procedure avfilter_uninit; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_uninit';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * Register a filter. This is only needed if you plan to use
 * avfilter_get_by_name later to lookup the AVFilter structure by name. A
 * filter can still by instantiated with avfilter_graph_alloc_filter even if it
 * is not registered.
 *
 * @param filter the filter to register
 * @return 0 if the registration was successful, a negative value
 * otherwise
 *)

{$IFDEF API_Dynamic}
var avfilter_register : function(filter: PAVFilter): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_register(filter: PAVFilter): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_register';
{$ENDIF API_Dynamic}


(**
 * Get a filter definition matching the given name.
 *
 * @param name the filter name to find
 * @return     the filter definition, if any matching one is registered.
 *             NULL if none found.
 *)

{$IFDEF API_Dynamic}
var avfilter_get_by_name : function(const name: PAnsiChar): PAVFilter; cdecl;
{$ELSE API_Dynamic}
function avfilter_get_by_name(const name: PAnsiChar): PAVFilter; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_get_by_name';
{$ENDIF API_Dynamic}


(**
 * Iterate over all registered filters.
 * @return If prev is non-NULL, next registered filter after prev or NULL if
 * prev is the last filter. If prev is NULL, return the first registered filter.
 *)

{$IFDEF API_Dynamic}
var avfilter_next : function(const prev: PAVFilter): PAVFilter; cdecl;
{$ELSE API_Dynamic}
function avfilter_next(const prev: PAVFilter): PAVFilter; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_next';
{$ENDIF API_Dynamic}


{$IFDEF FF_API_OLD_FILTER_REGISTER}
(**
 * If filter is NULL, returns a pointer to the first registered filter pointer,
 * if filter is non-NULL, returns the next pointer after filter.
 * If the returned pointer points to NULL, the last registered filter
 * was already reached.
 * @deprecated use avfilter_next()
 *)

{$IFDEF API_Dynamic}
var av_filter_next : function(filter: PPAVFilter): PPAVFilter; cdecl;
{$ELSE API_Dynamic}
function av_filter_next(filter: PPAVFilter): PPAVFilter; cdecl; external AVFILTER_LIBNAME name _PU + 'av_filter_next';
{$ENDIF API_Dynamic}

{$ENDIF}

{$IFDEF FF_API_AVFILTER_OPEN}
(**
 * Create a filter instance.
 *
 * @param filter_ctx put here a pointer to the created filter context
 * on success, NULL on failure
 * @param filter    the filter to create an instance of
 * @param inst_name Name to give to the new instance. Can be NULL for none.
 * @return >= 0 in case of success, a negative error code otherwise
 * @deprecated use avfilter_graph_alloc_filter() instead
 *)

{$IFDEF API_Dynamic}
var avfilter_open : function(filter_ctx: PPAVFilterContext; filter: PAVFilter; const inst_name: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_open(filter_ctx: PPAVFilterContext; filter: PAVFilter; const inst_name: PAnsiChar): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_open';
{$ENDIF API_Dynamic}

{$ENDIF}


{$IFDEF FF_API_AVFILTER_INIT_FILTER}
(**
 * Initialize a filter.
 *
 * @param filter the filter to initialize
 * @param args   A string of parameters to use when initializing the filter.
 *               The format and meaning of this string varies by filter.
 * @param opaque Any extra non-string data needed by the filter. The meaning
 *               of this parameter varies by filter.
 * @return       zero on success
 *)

{$IFDEF API_Dynamic}
var avfilter_init_filter : function(filter: PAVFilterContext; const args: PAnsiChar; opaque: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_init_filter(filter: PAVFilterContext; const args: PAnsiChar; opaque: Pointer): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_init_filter';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * Initialize a filter with the supplied parameters.
 *
 * @param ctx  uninitialized filter context to initialize
 * @param args Options to initialize the filter with. This must be a
 *             ':'-separated list of options in the 'key=value' form.
 *             May be NULL if the options have been set directly using the
 *             AVOptions API or there are no options that need to be set.
 * @return 0 on success, a negative AVERROR on failure
 *)

{$IFDEF API_Dynamic}
var avfilter_init_str : function(ctx: PAVFilterContext; const args: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_init_str(ctx: PAVFilterContext; const args: PAnsiChar): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_init_str';
{$ENDIF API_Dynamic}


(**
 * Initialize a filter with the supplied dictionary of options.
 *
 * @param ctx     uninitialized filter context to initialize
 * @param options An AVDictionary filled with options for this filter. On
 *                return this parameter will be destroyed and replaced with
 *                a dict containing options that were not found. This dictionary
 *                must be freed by the caller.
 *                May be NULL, then this function is equivalent to
 *                avfilter_init_str() with the second parameter set to NULL.
 * @return 0 on success, a negative AVERROR on failure
 *
 * @note This function and avfilter_init_str() do essentially the same thing,
 * the difference is in manner in which the options are passed. It is up to the
 * calling code to choose whichever is more preferable. The two functions also
 * behave differently when some of the provided options are not declared as
 * supported by the filter. In such a case, avfilter_init_str() will fail, but
 * this function will leave those extra options in the options AVDictionary and
 * continue as usual.
 *)

{$IFDEF API_Dynamic}
var avfilter_init_dict : function(ctx: PAVFilterContext; options: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_init_dict(ctx: PAVFilterContext; options: PPAVDictionary): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_init_dict';
{$ENDIF API_Dynamic}


(**
 * Free a filter context. This will also remove the filter from its
 * filtergraph's list of filters.
 *
 * @param filter the filter to free
 *)

{$IFDEF API_Dynamic}
var avfilter_free : procedure(filter: PAVFilterContext); cdecl;
{$ELSE API_Dynamic}
procedure avfilter_free(filter: PAVFilterContext); cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_free';
{$ENDIF API_Dynamic}


(**
 * Insert a filter in the middle of an existing link.
 *
 * @param link the link into which the filter should be inserted
 * @param filt the filter to be inserted
 * @param filt_srcpad_idx the input pad on the filter to connect
 * @param filt_dstpad_idx the output pad on the filter to connect
 * @return     zero on success
 *)

{$IFDEF API_Dynamic}
var avfilter_insert_filter : function(link: PAVFilterLink; filt: PAVFilterContext;
                           filt_srcpad_idx, filt_dstpad_idx: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_insert_filter(link: PAVFilterLink; filt: PAVFilterContext;
                           filt_srcpad_idx, filt_dstpad_idx: Cardinal): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_insert_filter';
{$ENDIF API_Dynamic}


(**
 * @return AVClass for AVFilterContext.
 *
 * @see av_opt_find().
 *)

{$IFDEF API_Dynamic}
var avfilter_get_class : function: PAVClass; cdecl;
{$ELSE API_Dynamic}
function avfilter_get_class: PAVClass; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_get_class';
{$ENDIF API_Dynamic}


(**
 * Allocate a filter graph.
 *
 * @return the allocated filter graph on success or NULL.
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_alloc : function: PAVFilterGraph; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_alloc: PAVFilterGraph; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_alloc';
{$ENDIF API_Dynamic}


(**
 * Create a new filter instance in a filter graph.
 *
 * @param graph graph in which the new filter will be used
 * @param filter the filter to create an instance of
 * @param name Name to give to the new instance (will be copied to
 *             AVFilterContext.name). This may be used by the caller to identify
 *             different filters, libavfilter itself assigns no semantics to
 *             this parameter. May be NULL.
 *
 * @return the context of the newly created filter instance (note that it is
 *         also retrievable directly through AVFilterGraph.filters or with
 *         avfilter_graph_get_filter()) on success or NULL on failure.
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_alloc_filter : function(graph: PAVFilterGraph;
                                              const filter: PAVFilter;
                                              const name: PAnsiChar): PAVFilterContext; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_alloc_filter(graph: PAVFilterGraph;
                                              const filter: PAVFilter;
                                              const name: PAnsiChar): PAVFilterContext; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_alloc_filter';
{$ENDIF API_Dynamic}


(**
 * Get a filter instance identified by instance name from graph.
 *
 * @param graph filter graph to search through.
 * @param name filter instance name (should be unique in the graph).
 * @return the pointer to the found filter instance or NULL if it
 * cannot be found.
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_get_filter : function(graph: PAVFilterGraph; const name: PAnsiChar): PAVFilterContext; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_get_filter(graph: PAVFilterGraph; const name: PAnsiChar): PAVFilterContext; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_get_filter';
{$ENDIF API_Dynamic}


{$IFDEF FF_API_AVFILTER_OPEN}
(**
 * Add an existing filter instance to a filter graph.
 *
 * @param graphctx  the filter graph
 * @param filter The filter to be added
 *
 * @deprecated use avfilter_graph_alloc_filter() to allocate a filter in a
 * filter graph
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_add_filter : function(graphctx: PAVFilterGraph; filter: PAVFilterContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_add_filter(graphctx: PAVFilterGraph; filter: PAVFilterContext): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_add_filter';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * Create and add a filter instance into an existing graph.
 * The filter instance is created from the filter filt and inited
 * with the parameters args and opaque.
 *
 * In case of success put in *filt_ctx the pointer to the created
 * filter instance, otherwise set *filt_ctx to NULL.
 *
 * @param name the instance name to give to the created filter instance
 * @param graph_ctx the filter graph
 * @return a negative AVERROR error code in case of failure, a non
 * negative value otherwise
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_create_filter : function(filt_ctx: PPAVFilterContext; const filt: PAVFilter;
                                 const name: PAnsiChar; const args: PAnsiChar; opaque: Pointer;
                                 graph_ctx: PAVFilterGraph): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_create_filter(filt_ctx: PPAVFilterContext; const filt: PAVFilter;
                                 const name: PAnsiChar; const args: PAnsiChar; opaque: Pointer;
                                 graph_ctx: PAVFilterGraph): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_create_filter';
{$ENDIF API_Dynamic}


(**
 * Enable or disable automatic format conversion inside the graph.
 *
 * Note that format conversion can still happen inside explicitly inserted
 * scale and aresample filters.
 *
 * @param flags  any of the AVFILTER_AUTO_CONVERT_* constants
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_set_auto_convert : procedure(graph: PAVFilterGraph; flags: Integer); cdecl;
{$ELSE API_Dynamic}
procedure avfilter_graph_set_auto_convert(graph: PAVFilterGraph; flags: Integer); cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_set_auto_convert';
{$ENDIF API_Dynamic}


//  TAVFilterConverter = (
//    AVFILTER_AUTO_CONVERT_NONE = -1, (**< all automatic conversions disabled *)
//    AVFILTER_AUTO_CONVERT_ALL  =  0  (**< all automatic conversions enabled *)
//  );

(**
 * Check validity and configure all the links and formats in the graph.
 *
 * @param graphctx the filter graph
 * @param log_ctx context used for logging
 * @return >= 0 in case of success, a negative AVERROR code otherwise
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_config : function(graphctx: PAVFilterGraph; log_ctx: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_config(graphctx: PAVFilterGraph; log_ctx: Pointer): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_config';
{$ENDIF API_Dynamic}


(**
 * Free a graph, destroy its links, and set *graph to NULL.
 * If *graph is NULL, do nothing.
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_free : procedure(graph: PPAVFilterGraph); cdecl;
{$ELSE API_Dynamic}
procedure avfilter_graph_free(graph: PPAVFilterGraph); cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_free';
{$ENDIF API_Dynamic}


(**
 * A linked-list of the inputs/outputs of the filter chain.
 *
 * This is mainly useful for avfilter_graph_parse() / avfilter_graph_parse2(),
 * where it is used to communicate open (unlinked) inputs and outputs from and
 * to the caller.
 * This struct specifies, per each not connected pad contained in the graph, the
 * filter context and the pad index required for establishing a link.
 *)
type
  PPAVFilterInOut = ^PAVFilterInOut;
  PAVFilterInOut = ^TAVFilterInOut;
  TAVFilterInOut = record
    (** unique name for this input/output in the list *)
    name: PAnsiChar;

    (** filter context associated to this input/output *)
    filter_ctx: PAVFilterContext;

    (** index of the filt_ctx pad to use for linking *)
    pad_idx: Integer;

    (** next input/input in the list, NULL if this is the last *)
    next: PAVFilterInOut;
  end;

(**
 * Allocate a single AVFilterInOut entry.
 * Must be freed with avfilter_inout_free().
 * @return allocated AVFilterInOut on success, NULL on failure.
 *)

{$IFDEF API_Dynamic}
var avfilter_inout_alloc : function: PAVFilterInOut; cdecl;
{$ELSE API_Dynamic}
function avfilter_inout_alloc: PAVFilterInOut; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_inout_alloc';
{$ENDIF API_Dynamic}


(**
 * Free the supplied list of AVFilterInOut and set *inout to NULL.
 * If *inout is NULL, do nothing.
 *)

{$IFDEF API_Dynamic}
var avfilter_inout_free : procedure(inout: PPAVFilterInOut); cdecl;
{$ELSE API_Dynamic}
procedure avfilter_inout_free(inout: PPAVFilterInOut); cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_inout_free';
{$ENDIF API_Dynamic}


(**
 * Add a graph described by a string to a graph.
 *
 * @note The caller must provide the lists of inputs and outputs,
 * which therefore must be known before calling the function.
 *
 * @note The inputs parameter describes inputs of the already existing
 * part of the graph; i.e. from the point of view of the newly created
 * part, they are outputs. Similarly the outputs parameter describes
 * outputs of the already existing filters, which are provided as
 * inputs to the parsed filters.
 *
 * @param graph   the filter graph where to link the parsed graph context
 * @param filters string to be parsed
 * @param inputs  linked list to the inputs of the graph
 * @param outputs linked list to the outputs of the graph
 * @return zero on success, a negative AVERROR code on error
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_parse : function(graph: PAVFilterGraph; const filters: PAnsiChar;
                          inputs, outputs: PAVFilterInOut; log_ctx: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_parse(graph: PAVFilterGraph; const filters: PAnsiChar;
                          inputs, outputs: PAVFilterInOut; log_ctx: Pointer): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_parse';
{$ENDIF API_Dynamic}


(**
 * Add a graph described by a string to a graph.
 *
 * In the graph filters description, if the input label of the first
 * filter is not specified, "in" is assumed; if the output label of
 * the last filter is not specified, "out" is assumed.
 *
 * @param graph   the filter graph where to link the parsed graph context
 * @param filters string to be parsed
 * @param inputs  pointer to a linked list to the inputs of the graph, may be NULL.
 *                If non-NULL, *inputs is updated to contain the list of open inputs
 *                after the parsing, should be freed with avfilter_inout_free().
 * @param outputs pointer to a linked list to the outputs of the graph, may be NULL.
 *                If non-NULL, *outputs is updated to contain the list of open outputs
 *                after the parsing, should be freed with avfilter_inout_free().
 * @return non negative on success, a negative AVERROR code on error
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_parse_ptr : function(graph: PAVFilterGraph; const filters: PAnsiChar;
                              inputs, outputs: PPAVFilterInOut; log_ctx: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_parse_ptr(graph: PAVFilterGraph; const filters: PAnsiChar;
                              inputs, outputs: PPAVFilterInOut; log_ctx: Pointer): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_parse_ptr';
{$ENDIF API_Dynamic}


(**
 * Add a graph described by a string to a graph.
 *
 * @param[in]  graph   the filter graph where to link the parsed graph context
 * @param[in]  filters string to be parsed
 * @param[out] inputs  a linked list of all free (unlinked) inputs of the
 *                     parsed graph will be returned here. It is to be freed
 *                     by the caller using avfilter_inout_free().
 * @param[out] outputs a linked list of all free (unlinked) outputs of the
 *                     parsed graph will be returned here. It is to be freed by the
 *                     caller using avfilter_inout_free().
 * @return zero on success, a negative AVERROR code on error
 *
 * @note This function returns the inputs and outputs that are left
 * unlinked after parsing the graph and the caller then deals with
 * them.
 * @note This function makes no reference whatsoever to already
 * existing parts of the graph and the inputs parameter will on return
 * contain inputs of the newly parsed part of the graph.  Analogously
 * the outputs parameter will contain outputs of the newly created
 * filters.
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_parse2 : function(graph: PAVFilterGraph; const filters: PAnsiChar;
                          inputs, outputs: PPAVFilterInOut): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_parse2(graph: PAVFilterGraph; const filters: PAnsiChar;
                          inputs, outputs: PPAVFilterInOut): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_parse2';
{$ENDIF API_Dynamic}


(**
 * Send a command to one or more filter instances.
 *
 * @param graph  the filter graph
 * @param target the filter(s) to which the command should be sent
 *               "all" sends to all filters
 *               otherwise it can be a filter or filter instance name
 *               which will send the command to all matching filters.
 * @param cmd    the command to send, for handling simplicity all commands must be alphanumeric only
 * @param arg    the argument for the command
 * @param res    a buffer with size res_size where the filter(s) can return a response.
 *
 * @returns >=0 on success otherwise an error code.
 *              AVERROR(ENOSYS) on unsupported commands
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_send_command : function(graph: PAVFilterGraph; const target, cmd, arg: PAnsiChar; res: PAnsiChar; res_len, flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_send_command(graph: PAVFilterGraph; const target, cmd, arg: PAnsiChar; res: PAnsiChar; res_len, flags: Integer): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_send_command';
{$ENDIF API_Dynamic}


(**
 * Queue a command for one or more filter instances.
 *
 * @param graph  the filter graph
 * @param target the filter(s) to which the command should be sent
 *               "all" sends to all filters
 *               otherwise it can be a filter or filter instance name
 *               which will send the command to all matching filters.
 * @param cmd    the command to sent, for handling simplicity all commands must be alphanumeric only
 * @param arg    the argument for the command
 * @param ts     time at which the command should be sent to the filter
 *
 * @note As this executes commands after this function returns, no return code
 *       from the filter is provided, also AVFILTER_CMD_FLAG_ONE is not supported.
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_queue_command : function(graph: PAVFilterGraph; const target, cmd, arg: PAnsiChar; flags: Integer; ts: Double): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_queue_command(graph: PAVFilterGraph; const target, cmd, arg: PAnsiChar; flags: Integer; ts: Double): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_queue_command';
{$ENDIF API_Dynamic}


(**
 * Dump a graph into a human-readable string representation.
 *
 * @param graph    the graph to dump
 * @param options  formatting options; currently ignored
 * @return  a string, or NULL in case of memory allocation failure;
 *          the string must be freed using av_free
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_dump : function(graph: PAVFilterGraph; const options: PAnsiChar): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_dump(graph: PAVFilterGraph; const options: PAnsiChar): PAnsiChar; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_dump';
{$ENDIF API_Dynamic}


(**
 * Request a frame on the oldest sink link.
 *
 * If the request returns AVERROR_EOF, try the next.
 *
 * Note that this function is not meant to be the sole scheduling mechanism
 * of a filtergraph, only a convenience function to help drain a filtergraph
 * in a balanced way under normal circumstances.
 *
 * Also note that AVERROR_EOF does not mean that frames did not arrive on
 * some of the sinks during the process.
 * When there are multiple sink links, in case the requested link
 * returns an EOF, this may cause a filter to flush pending frames
 * which are sent to another sink link, although unrequested.
 *
 * @return  the return value of ff_request_frame(),
 *          or AVERROR_EOF if all links returned AVERROR_EOF
 *)

{$IFDEF API_Dynamic}
var avfilter_graph_request_oldest : function(graph: PAVFilterGraph): Integer; cdecl;
{$ELSE API_Dynamic}
function avfilter_graph_request_oldest(graph: PAVFilterGraph): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_graph_request_oldest';
{$ENDIF API_Dynamic}


(**
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_channel_layout *)
(* ****************************************************** *)






(**
 * @addtogroup lavu_audio
 * @{
 *)

const
(**
 * @defgroup channel_masks Audio channel masks
 *
 * A channel layout is a 64-bits integer with a bit set for every channel.
 * The number of bits set must be equal to the number of channels.
 * The value 0 means that the channel layout is not known.
 * @note this data structure is not powerful enough to handle channels
 * combinations that have the same channel multiple times, such as
 * dual-mono.
 *
 * @{
 *)
  AV_CH_FRONT_LEFT             = $00000001;
  AV_CH_FRONT_RIGHT            = $00000002;
  AV_CH_FRONT_CENTER           = $00000004;
  AV_CH_LOW_FREQUENCY          = $00000008;
  AV_CH_BACK_LEFT              = $00000010;
  AV_CH_BACK_RIGHT             = $00000020;
  AV_CH_FRONT_LEFT_OF_CENTER   = $00000040;
  AV_CH_FRONT_RIGHT_OF_CENTER  = $00000080;
  AV_CH_BACK_CENTER            = $00000100;
  AV_CH_SIDE_LEFT              = $00000200;
  AV_CH_SIDE_RIGHT             = $00000400;
  AV_CH_TOP_CENTER             = $00000800;
  AV_CH_TOP_FRONT_LEFT         = $00001000;
  AV_CH_TOP_FRONT_CENTER       = $00002000;
  AV_CH_TOP_FRONT_RIGHT        = $00004000;
  AV_CH_TOP_BACK_LEFT          = $00008000;
  AV_CH_TOP_BACK_CENTER        = $00010000;
  AV_CH_TOP_BACK_RIGHT         = $00020000;
  AV_CH_STEREO_LEFT            = $20000000;  ///< Stereo downmix.
  AV_CH_STEREO_RIGHT           = $40000000;  ///< See AV_CH_STEREO_LEFT.
  AV_CH_WIDE_LEFT              = Int64($0000000080000000);
  AV_CH_WIDE_RIGHT             = Int64($0000000100000000);
  AV_CH_SURROUND_DIRECT_LEFT   = Int64($0000000200000000);
  AV_CH_SURROUND_DIRECT_RIGHT  = Int64($0000000400000000);
  AV_CH_LOW_FREQUENCY_2        = Int64($0000000800000000);

(** Channel mask value used for AVCodecContext.request_channel_layout
    to indicate that the user requests the channel order of the decoder output
    to be the native codec channel order. *)
  AV_CH_LAYOUT_NATIVE          = Int64($8000000000000000);

(**
 * @}
 * @defgroup channel_mask_c Audio channel layouts
 * @{
 * *)
  AV_CH_LAYOUT_MONO            = (AV_CH_FRONT_CENTER);
  AV_CH_LAYOUT_STEREO          = (AV_CH_FRONT_LEFT or AV_CH_FRONT_RIGHT);
  AV_CH_LAYOUT_2POINT1         = (AV_CH_LAYOUT_STEREO or AV_CH_LOW_FREQUENCY);
  AV_CH_LAYOUT_2_1             = (AV_CH_LAYOUT_STEREO or AV_CH_BACK_CENTER);
  AV_CH_LAYOUT_SURROUND        = (AV_CH_LAYOUT_STEREO or AV_CH_FRONT_CENTER);
  AV_CH_LAYOUT_3POINT1         = (AV_CH_LAYOUT_SURROUND or AV_CH_LOW_FREQUENCY);
  AV_CH_LAYOUT_4POINT0         = (AV_CH_LAYOUT_SURROUND or AV_CH_BACK_CENTER);
  AV_CH_LAYOUT_4POINT1         = (AV_CH_LAYOUT_4POINT0 or AV_CH_LOW_FREQUENCY);
  AV_CH_LAYOUT_2_2             = (AV_CH_LAYOUT_STEREO or AV_CH_SIDE_LEFT or AV_CH_SIDE_RIGHT);
  AV_CH_LAYOUT_QUAD            = (AV_CH_LAYOUT_STEREO or AV_CH_BACK_LEFT or AV_CH_BACK_RIGHT);
  AV_CH_LAYOUT_5POINT0         = (AV_CH_LAYOUT_SURROUND or AV_CH_SIDE_LEFT or AV_CH_SIDE_RIGHT);
  AV_CH_LAYOUT_5POINT1         = (AV_CH_LAYOUT_5POINT0 or AV_CH_LOW_FREQUENCY);
  AV_CH_LAYOUT_5POINT0_BACK    = (AV_CH_LAYOUT_SURROUND or AV_CH_BACK_LEFT or AV_CH_BACK_RIGHT);
  AV_CH_LAYOUT_5POINT1_BACK    = (AV_CH_LAYOUT_5POINT0_BACK or AV_CH_LOW_FREQUENCY);
  AV_CH_LAYOUT_6POINT0         = (AV_CH_LAYOUT_5POINT0 or AV_CH_BACK_CENTER);
  AV_CH_LAYOUT_6POINT0_FRONT   = (AV_CH_LAYOUT_2_2 or AV_CH_FRONT_LEFT_OF_CENTER or AV_CH_FRONT_RIGHT_OF_CENTER);
  AV_CH_LAYOUT_HEXAGONAL       = (AV_CH_LAYOUT_5POINT0_BACK or AV_CH_BACK_CENTER);
  AV_CH_LAYOUT_6POINT1         = (AV_CH_LAYOUT_5POINT1 or AV_CH_BACK_CENTER);
  AV_CH_LAYOUT_6POINT1_BACK    = (AV_CH_LAYOUT_5POINT1_BACK or AV_CH_BACK_CENTER);
  AV_CH_LAYOUT_6POINT1_FRONT   = (AV_CH_LAYOUT_6POINT0_FRONT or AV_CH_LOW_FREQUENCY);
  AV_CH_LAYOUT_7POINT0         = (AV_CH_LAYOUT_5POINT0 or AV_CH_BACK_LEFT or AV_CH_BACK_RIGHT);
  AV_CH_LAYOUT_7POINT0_FRONT   = (AV_CH_LAYOUT_5POINT0 or AV_CH_FRONT_LEFT_OF_CENTER or AV_CH_FRONT_RIGHT_OF_CENTER);
  AV_CH_LAYOUT_7POINT1         = (AV_CH_LAYOUT_5POINT1 or AV_CH_BACK_LEFT or AV_CH_BACK_RIGHT);
  AV_CH_LAYOUT_7POINT1_WIDE    = (AV_CH_LAYOUT_5POINT1 or AV_CH_FRONT_LEFT_OF_CENTER or AV_CH_FRONT_RIGHT_OF_CENTER);
  AV_CH_LAYOUT_7POINT1_WIDE_BACK=(AV_CH_LAYOUT_5POINT1_BACK or AV_CH_FRONT_LEFT_OF_CENTER or AV_CH_FRONT_RIGHT_OF_CENTER);
  AV_CH_LAYOUT_OCTAGONAL       = (AV_CH_LAYOUT_5POINT0 or AV_CH_BACK_LEFT or AV_CH_BACK_CENTER or AV_CH_BACK_RIGHT);
  AV_CH_LAYOUT_HEXADECAGONAL   = (AV_CH_LAYOUT_OCTAGONAL or AV_CH_WIDE_LEFT or AV_CH_WIDE_RIGHT or AV_CH_TOP_BACK_LEFT or
    AV_CH_TOP_BACK_RIGHT or AV_CH_TOP_BACK_CENTER or AV_CH_TOP_FRONT_CENTER or AV_CH_TOP_FRONT_LEFT or AV_CH_TOP_FRONT_RIGHT);
  AV_CH_LAYOUT_STEREO_DOWNMIX  = (AV_CH_STEREO_LEFT or AV_CH_STEREO_RIGHT);

type
  TAVMatrixEncoding = (
    AV_MATRIX_ENCODING_NONE,
    AV_MATRIX_ENCODING_DOLBY,
    AV_MATRIX_ENCODING_DPLII,
    AV_MATRIX_ENCODING_DPLIIX,
    AV_MATRIX_ENCODING_DPLIIZ,
    AV_MATRIX_ENCODING_DOLBYEX,
    AV_MATRIX_ENCODING_DOLBYHEADPHONE,
    AV_MATRIX_ENCODING_NB
  );

(**
 * Return a channel layout id that matches name, or 0 if no match is found.
 *
 * name can be one or several of the following notations,
 * separated by '+' or '|':
 * - the name of an usual channel layout (mono, stereo, 4.0, quad, 5.0,
 *   5.0(side), 5.1, 5.1(side), 7.1, 7.1(wide), downmix);
 * - the name of a single channel (FL, FR, FC, LFE, BL, BR, FLC, FRC, BC,
 *   SL, SR, TC, TFL, TFC, TFR, TBL, TBC, TBR, DL, DR);
 * - a number of channels, in decimal, followed by 'c', yielding
 *   the default channel layout for that number of channels (@see
 *   av_get_default_channel_layout);
 * - a channel layout mask, in hexadecimal starting with "0x" (see the
 *   AV_CH_* macros).
 *
 * Example: "stereo+FC" = "2c+FC" = "2c+1c" = "0x7"
 *)

{$IFDEF API_Dynamic}
var av_get_channel_layout : function(const name: PAnsiChar): Int64; cdecl;
{$ELSE API_Dynamic}
function av_get_channel_layout(const name: PAnsiChar): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_channel_layout';
{$ENDIF API_Dynamic}


(**
 * Return a channel layout and the number of channels based on the specified name.
 *
 * This function is similar to (@see av_get_channel_layout), but can also parse
 * unknown channel layout specifications.
 *
 * @param[in]  name             channel layout specification string
 * @param[out] channel_layout   parsed channel layout (0 if unknown)
 * @param[out] nb_channels      number of channels
 *
 * @return 0 on success, AVERROR(EINVAL) if the parsing fails.
 *)

{$IFDEF API_Dynamic}
var av_get_extended_channel_layout : function(const name: PAnsiChar; channel_layout: PInt64; nb_channels: PInteger): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_extended_channel_layout(const name: PAnsiChar; channel_layout: PInt64; nb_channels: PInteger): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_extended_channel_layout';
{$ENDIF API_Dynamic}


(**
 * Return a description of a channel layout.
 * If nb_channels is <= 0, it is guessed from the channel_layout.
 *
 * @param buf put here the string containing the channel layout
 * @param buf_size size in bytes of the buffer
 *)

{$IFDEF API_Dynamic}
var av_get_channel_layout_string : procedure(buf: PAnsiChar; buf_size, nb_channels: Integer; channel_layout: Int64); cdecl;
{$ELSE API_Dynamic}
procedure av_get_channel_layout_string(buf: PAnsiChar; buf_size, nb_channels: Integer; channel_layout: Int64); cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_channel_layout_string';
{$ENDIF API_Dynamic}


//  PAVBPrint = ^TAVBPrint;
//  TAVBPrint = record
    // need {$ALIGN 8}
    // defined in libavutil/bprint.h
//  end;

(**
 * Append a description of a channel layout to a bprint buffer.
 *)

{$IFDEF API_Dynamic}
var av_bprint_channel_layout : procedure(bp: PAVBPrint; nb_channels: Integer; channel_layout: Int64); cdecl;
{$ELSE API_Dynamic}
procedure av_bprint_channel_layout(bp: PAVBPrint; nb_channels: Integer; channel_layout: Int64); cdecl; external AVUTIL_LIBNAME name _PU + 'av_bprint_channel_layout';
{$ENDIF API_Dynamic}


(**
 * Return the number of channels in the channel layout.
 *)

{$IFDEF API_Dynamic}
var av_get_channel_layout_nb_channels : function(channel_layout: Int64): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_channel_layout_nb_channels(channel_layout: Int64): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_channel_layout_nb_channels';
{$ENDIF API_Dynamic}


(**
 * Return default channel layout for a given number of channels.
 *)

{$IFDEF API_Dynamic}
var av_get_default_channel_layout : function(nb_channels: Integer): Int64; cdecl;
{$ELSE API_Dynamic}
function av_get_default_channel_layout(nb_channels: Integer): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_default_channel_layout';
{$ENDIF API_Dynamic}


(**
 * Get the index of a channel in channel_layout.
 *
 * @param channel a channel layout describing exactly one channel which must be
 *                present in channel_layout.
 *
 * @return index of channel in channel_layout on success, a negative AVERROR
 *         on error.
 *)

{$IFDEF API_Dynamic}
var av_get_channel_layout_channel_index : function(channel_layout, channel: Int64): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_channel_layout_channel_index(channel_layout, channel: Int64): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_channel_layout_channel_index';
{$ENDIF API_Dynamic}


(**
 * Get the channel with the given index in channel_layout.
 *)

{$IFDEF API_Dynamic}
var av_channel_layout_extract_channel : function(channel_layout: Int64; index: Integer): Int64; cdecl;
{$ELSE API_Dynamic}
function av_channel_layout_extract_channel(channel_layout: Int64; index: Integer): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_channel_layout_extract_channel';
{$ENDIF API_Dynamic}


(**
 * Get the name of a given channel.
 *
 * @return channel name on success, NULL on error.
 *)

{$IFDEF API_Dynamic}
var av_get_channel_name : function(channel: Int64): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_channel_name(channel: Int64): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_channel_name';
{$ENDIF API_Dynamic}


(**
 * Get the description of a given channel.
 *
 * @param channel  a channel layout with a single channel
 * @return  channel description on success, NULL on error
 *)

{$IFDEF API_Dynamic}
var av_get_channel_description : function(channel: Int64): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_channel_description(channel: Int64): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_channel_description';
{$ENDIF API_Dynamic}


(**
 * Get the value and name of a standard channel layout.
 *
 * @param[in]  index   index in an internal list, starting at 0
 * @param[out] layout  channel layout mask
 * @param[out] name    name of the layout
 * @return  0  if the layout exists,
 *          <0 if index is beyond the limits
 *)

{$IFDEF API_Dynamic}
var av_get_standard_channel_layout : function(index: Cardinal; layout: PInt64;
                                                  const name: PPAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_standard_channel_layout(index: Cardinal; layout: PInt64;
                                                  const name: PPAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_standard_channel_layout';
{$ENDIF API_Dynamic}


(**
 * @}
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_common *)
(* ****************************************************** *)






//#if AV_HAVE_BIGENDIAN
//#   define AV_NE(be, le) (be)
//#else
//#   define AV_NE(be, le) (le)
//#endif

//rounded division & shift
//#define RSHIFT(a,b) ((a) > 0 ? ((a) + ((1<<(b))>>1))>>(b) : ((a) + ((1<<(b))>>1)-1)>>(b))
(* assume b>0 *)
//#define ROUNDED_DIV(a,b) (((a)>0 ? (a) + ((b)>>1) : (a) - ((b)>>1))/(b))
(* Fast a/(1<<b) rounded toward +inf. Assume a>=0 and b>=0 *)
//#define AV_CEIL_RSHIFT(a,b) (!av_builtin_constant_p(b) ? -((-(a)) >> (b)) \
//                                                       : ((a) + (1<<(b)) - 1) >> (b))
function AV_CEIL_RSHIFT(a, b: Integer): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}
(* Backwards compat. *)
//#define FF_CEIL_RSHIFT AV_CEIL_RSHIFT

//#define FFUDIV(a,b) (((a)>0 ?(a):(a)-(b)+1) / (b))
//#define FFUMOD(a,b) ((a)-(b)*FFUDIV(a,b))

(**
 * Absolute value, Note, INT_MIN / INT64_MIN result in undefined behavior as they
 * are not representable as absolute values of their type. This is the same
 * as with *abs()
 * @see FFNABS()
 *)
//#define FFABS(a) ((a) >= 0 ? (a) : (-(a)))
//#define FFSIGN(a) ((a) > 0 ? 1 : -1)
function FFSIGN(a: Double): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}

(**
 * Negative Absolute value.
 * this works for all integers of all types.
 * As with many macros, this evaluates its argument twice, it thus must not have
 * a sideeffect, that is FFNABS(x++) has undefined behavior.
 *)
//#define FFNABS(a) ((a) <= 0 ? (a) : (-(a)))

(**
 * Comparator.
 * For two numerical expressions x and y, gives 1 if x > y, -1 if x < y, and 0
 * if x == y. This is useful for instance in a qsort comparator callback.
 * Furthermore, compilers are able to optimize this to branchless code, and
 * there is no risk of overflow with signed types.
 * As with many macros, this evaluates its argument multiple times, it thus
 * must not have a side-effect.
 *)
//#define FFDIFFSIGN(x,y) (((x)>(y)) - ((x)<(y)))

//#define FFMAX(a,b) ((a) > (b) ? (a) : (b))
//#define FFMAX3(a,b,c) FFMAX(FFMAX(a,b),c)
//#define FFMIN(a,b) ((a) > (b) ? (b) : (a))
//#define FFMIN3(a,b,c) FFMIN(FFMIN(a,b),c)

//#define FFSWAP(type,a,b) do{type SWAP_tmp= b; b= a; a= SWAP_tmp;}while(0)
//#define FF_ARRAY_ELEMS(a) (sizeof(a) / sizeof((a)[0]))

(* misc math functions *)

const
  TAG_YUY2 = Ord('Y') or (Ord('U') shl 8) or (Ord('Y') shl 16) or (Ord('2') shl 24);
  TAG_I420 = Ord('I') or (Ord('4') shl 8) or (Ord('2') shl 16) or (Ord('0') shl 24);
  TAG_dvsd = Ord('d') or (Ord('v') shl 8) or (Ord('s') shl 16) or (Ord('d') shl 24);

function my_sar(AValue: Integer; AShift: Byte): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}

function av_log2(v: Cardinal): Integer;



function av_ceil_log2(x: Integer): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_clip(a, amin, amax: Integer): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_clip64(a, amin, amax: Int64): Int64;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_clip_uint8(a: Integer): Byte;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_clip_int8(a: Integer): Byte;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_clip_uint16(a: Integer): SmallInt;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_clip_int16(a: Integer): SmallInt;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_clipl_int32(a: Int64): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_clip_intp2(a, p: Integer): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_clip_uintp2(a, p: Integer): Cardinal;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_mod_uintp2(a, p: Cardinal): Cardinal;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_sat_add32(a, b: Integer): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_sat_dadd32(a, b: Integer): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_clipf(a, amin, amax: Single): Single;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_clipd(a, amin, amax: Double): Double;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_popcount(x: Cardinal): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function av_popcount64(x: Int64): Integer;  {$IFDEF USE_INLINE}inline;{$ENDIF}

function MKTAG(a,b,c,d: AnsiChar): Cardinal;  {$IFDEF USE_INLINE}inline;{$ENDIF}
function MKBETAG(a,b,c,d: AnsiChar): Cardinal;  {$IFDEF USE_INLINE}inline;{$ENDIF}


(* ****************************************************** *)
(* import libavutil_cpu *)
(* ****************************************************** *)




{$IF Defined(BCB)}
{$IFEND}



const
  AV_CPU_FLAG_FORCE   = $80000000; (* force usage of selected flags (OR) *)

  (* lower 16 bits - CPU features *)
  AV_CPU_FLAG_MMX      =     $0001; ///< standard MMX
  AV_CPU_FLAG_MMXEXT   =     $0002; ///< SSE integer functions or AMD MMX ext
  AV_CPU_FLAG_MMX2     =     $0002; ///< SSE integer functions or AMD MMX ext
  AV_CPU_FLAG_3DNOW    =     $0004; ///< AMD 3DNOW
  AV_CPU_FLAG_SSE      =     $0008; ///< SSE functions
  AV_CPU_FLAG_SSE2     =     $0010; ///< PIV SSE2 functions
  AV_CPU_FLAG_SSE2SLOW = $40000000; ///< SSE2 supported, but usually not faster
                                    ///< than regular MMX/SSE (e.g. Core1)
  AV_CPU_FLAG_3DNOWEXT =     $0020; ///< AMD 3DNowExt
  AV_CPU_FLAG_SSE3     =     $0040; ///< Prescott SSE3 functions
  AV_CPU_FLAG_SSE3SLOW = $20000000; ///< SSE3 supported, but usually not faster
                                    ///< than regular MMX/SSE (e.g. Core1)
  AV_CPU_FLAG_SSSE3    =     $0080; ///< Conroe SSSE3 functions
  AV_CPU_FLAG_SSSE3SLOW=  $4000000; ///< SSSE3 supported, but usually not faster
  AV_CPU_FLAG_ATOM     = $10000000; ///< Atom processor, some SSSE3 instructions are slower
  AV_CPU_FLAG_SSE4     =     $0100; ///< Penryn SSE4.1 functions
  AV_CPU_FLAG_SSE42    =     $0200; ///< Nehalem SSE4.2 functions
  AV_CPU_FLAG_AESNI    =    $80000; ///< Advanced Encryption Standard functions
  AV_CPU_FLAG_AVX      =     $4000; ///< AVX functions: requires OS support even if YMM registers aren't used
  AV_CPU_FLAG_AVXSLOW  =  $8000000; ///< AVX supported, but slow when using YMM registers (e.g. Bulldozer)
  AV_CPU_FLAG_XOP      =     $0400; ///< Bulldozer XOP functions
  AV_CPU_FLAG_FMA4     =     $0800; ///< Bulldozer FMA4 functions
  AV_CPU_FLAG_CMOV     =     $1000; ///< supports cmov instruction
  AV_CPU_FLAG_AVX2     =     $8000; ///< AVX2 functions: requires OS support even if YMM registers aren't used
  AV_CPU_FLAG_FMA3     =    $10000; ///< Haswell FMA3 functions
  AV_CPU_FLAG_BMI1     =    $20000; ///< Bit Manipulation Instruction Set 1
  AV_CPU_FLAG_BMI2     =    $40000; ///< Bit Manipulation Instruction Set 2

  AV_CPU_FLAG_ALTIVEC  =     $0001; ///< standard
  AV_CPU_FLAG_VSX      =     $0002; ///< ISA 2.06
  AV_CPU_FLAG_POWER8   =     $0004; ///< ISA 2.07

  AV_CPU_FLAG_ARMV5TE  =    (1 shl 0);
  AV_CPU_FLAG_ARMV6    =    (1 shl 1);
  AV_CPU_FLAG_ARMV6T2  =    (1 shl 2);
  AV_CPU_FLAG_VFP      =    (1 shl 3);
  AV_CPU_FLAG_VFPV3    =    (1 shl 4);
  AV_CPU_FLAG_NEON     =    (1 shl 5);
  AV_CPU_FLAG_ARMV8    =    (1 shl 6);
  AV_CPU_FLAG_VFP_VM   =    (1 shl 7); ///< VFPv2 vector mode, deprecated in ARMv7-A and unavailable in various CPUs implementations
  AV_CPU_FLAG_SETEND   =    (1 shl 16);

(**
 * Return the flags which specify extensions supported by the CPU.
 * The returned value is affected by av_force_cpu_flags() if that was used
 * before. So av_get_cpu_flags() can easily be used in an application to
 * detect the enabled cpu flags.
 *)

{$IFDEF API_Dynamic}
var av_get_cpu_flags : function: Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_cpu_flags: Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_cpu_flags';
{$ENDIF API_Dynamic}


(**
 * Disables cpu detection and forces the specified flags.
 * -1 is a special case that disables forcing of specific flags.
 *)

{$IFDEF API_Dynamic}
var av_force_cpu_flags : procedure(flags: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_force_cpu_flags(flags: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_force_cpu_flags';
{$ENDIF API_Dynamic}


(**
 * Set a mask on flags returned by av_get_cpu_flags().
 * This function is mainly useful for testing.
 * Please use av_force_cpu_flags() and av_get_cpu_flags() instead which are more flexible
 *)

{$IFDEF API_Dynamic}
var av_set_cpu_flags_mask : procedure(mask: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_set_cpu_flags_mask(mask: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_set_cpu_flags_mask';
{$ENDIF API_Dynamic}


(**
 * Parse CPU flags from a string.
 *
 * The returned flags contain the specified flags as well as related unspecified flags.
 *
 * This function exists only for compatibility with libav.
 * Please use av_parse_cpu_caps() when possible.
 * @return a combination of AV_CPU_* flags, negative on error.
 *)

{$IFDEF API_Dynamic}
var av_parse_cpu_flags : function(const s: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_parse_cpu_flags(const s: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_parse_cpu_flags';
{$ENDIF API_Dynamic}


(**
 * Parse CPU caps from a string and update the given AV_CPU_* flags based on that.
 *
 * @return negative on error.
 *)

{$IFDEF API_Dynamic}
var av_parse_cpu_caps : function(flags: PCardinal; const s: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_parse_cpu_caps(flags: PCardinal; const s: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_parse_cpu_caps';
{$ENDIF API_Dynamic}


(**
 * @return the number of logical CPU cores present.
 *)

{$IFDEF API_Dynamic}
var av_cpu_count : function(): Integer; cdecl;
{$ELSE API_Dynamic}
function av_cpu_count(): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_cpu_count';
{$ENDIF API_Dynamic}


(**
 * Get the maximum data alignment that may be required by FFmpeg.
 *
 * Note that this is affected by the build configuration and the CPU flags mask,
 * so e.g. if the CPU supports AVX, but libavutil has been built with
 * --disable-avx or the AV_CPU_FLAG_AVX flag has been disabled through
 *  av_set_cpu_flags_mask(), then this function will behave as if AVX is not
 *  present.
 *)

{$IFDEF API_Dynamic}
var av_cpu_max_align : function(): Cardinal; cdecl;
{$ELSE API_Dynamic}
function av_cpu_max_align(): Cardinal; cdecl; external AVUTIL_LIBNAME name _PU + 'av_cpu_max_align';
{$ENDIF API_Dynamic}



(* ****************************************************** *)
(* import libavfilter_buffersink *)
(* ****************************************************** *)






(**
 * @defgroup lavfi_buffersink Buffer sink API
 * @ingroup lavfi
 * @{
 *)

(**
 * Get a frame with filtered data from sink and put it in frame.
 *
 * @param ctx    pointer to a buffersink or abuffersink filter context.
 * @param frame  pointer to an allocated frame that will be filled with data.
 *               The data must be freed using av_frame_unref() / av_frame_free()
 * @param flags  a combination of AV_BUFFERSINK_FLAG_* flags
 *
 * @return  >= 0 in for success, a negative AVERROR code for failure.
 *)

{$IFDEF API_Dynamic}
var av_buffersink_get_frame_flags : function(ctx: PAVFilterContext; frame: PAVFrame; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_get_frame_flags(ctx: PAVFilterContext; frame: PAVFrame; flags: Integer): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_get_frame_flags';
{$ENDIF API_Dynamic}


(**
 * Tell av_buffersink_get_buffer_ref() to read video/samples buffer
 * reference, but not remove it from the buffer. This is useful if you
 * need only to read a video/samples buffer, without to fetch it.
 *)
const
  AV_BUFFERSINK_FLAG_PEEK = 1;

(**
 * Tell av_buffersink_get_buffer_ref() not to request a frame from its input.
 * If a frame is already buffered, it is read (and removed from the buffer),
 * but if no frame is present, return AVERROR(EAGAIN).
 *)
  AV_BUFFERSINK_FLAG_NO_REQUEST = 2;

(**
 * Struct to use for initializing a buffersink context.
 *)
type
  PAVBufferSinkParams = ^TAVBufferSinkParams;
  TAVBufferSinkParams = record
    pixel_fmts: PAVPixelFormat; ///< list of allowed pixel formats, terminated by AV_PIX_FMT_NONE
  end;

(**
 * Create an AVBufferSinkParams structure.
 *
 * Must be freed with av_free().
 *)

{$IFDEF API_Dynamic}
var av_buffersink_params_alloc : function: PAVBufferSinkParams; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_params_alloc: PAVBufferSinkParams; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_params_alloc';
{$ENDIF API_Dynamic}


(**
 * Struct to use for initializing an abuffersink context.
 *)
type
  PAVABufferSinkParams = ^TAVABufferSinkParams;
  TAVABufferSinkParams = record
    sample_fmts: PAVSampleFormat; ///< list of allowed sample formats, terminated by AV_SAMPLE_FMT_NONE
    channel_layouts: PInt64;      ///< list of allowed channel layouts, terminated by -1
    channel_counts: PInteger;     ///< list of allowed channel counts, terminated by -1
    all_channel_counts: Integer;  ///< if not 0, accept any channel count or layout
    sample_rates: PInteger;       ///< list of allowed sample rates, terminated by -1
  end;

(**
 * Create an AVABufferSinkParams structure.
 *
 * Must be freed with av_free().
 *)

{$IFDEF API_Dynamic}
var av_abuffersink_params_alloc : function: PAVABufferSinkParams; cdecl;
{$ELSE API_Dynamic}
function av_abuffersink_params_alloc: PAVABufferSinkParams; cdecl; external AVFILTER_LIBNAME name _PU + 'av_abuffersink_params_alloc';
{$ENDIF API_Dynamic}


(**
 * Set the frame size for an audio buffer sink.
 *
 * All calls to av_buffersink_get_buffer_ref will return a buffer with
 * exactly the specified number of samples, or AVERROR(EAGAIN) if there is
 * not enough. The last buffer at EOF will be padded with 0.
 *)

{$IFDEF API_Dynamic}
var av_buffersink_set_frame_size : procedure(ctx: PAVFilterContext; frame_size: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_buffersink_set_frame_size(ctx: PAVFilterContext; frame_size: Cardinal); cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_set_frame_size';
{$ENDIF API_Dynamic}


(**
 * @defgroup lavfi_buffersink_accessors Buffer sink accessors
 * Get the properties of the stream
 * @{
 *)


{$IFDEF API_Dynamic}
var av_buffersink_get_type : function(const ctx: PAVFilterContext): TAVMediaType; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_get_type(const ctx: PAVFilterContext): TAVMediaType; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_get_type';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_buffersink_get_format : function(const ctx: PAVFilterContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_get_format(const ctx: PAVFilterContext): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_get_format';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_buffersink_get_w : function(const ctx: PAVFilterContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_get_w(const ctx: PAVFilterContext): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_get_w';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_buffersink_get_h : function(const ctx: PAVFilterContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_get_h(const ctx: PAVFilterContext): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_get_h';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_buffersink_get_channels : function(const ctx: PAVFilterContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_get_channels(const ctx: PAVFilterContext): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_get_channels';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_buffersink_get_channel_layout : function(const ctx: PAVFilterContext): Int64; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_get_channel_layout(const ctx: PAVFilterContext): Int64; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_get_channel_layout';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_buffersink_get_sample_rate : function(const ctx: PAVFilterContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_get_sample_rate(const ctx: PAVFilterContext): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_get_sample_rate';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_buffersink_get_hw_frames_ctx : function(const ctx: PAVFilterContext): PAVBufferRef; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_get_hw_frames_ctx(const ctx: PAVFilterContext): PAVBufferRef; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_get_hw_frames_ctx';
{$ENDIF API_Dynamic}


function av_buffersink_get_time_base          (const ctx: PAVFilterContext): TAVRational;

function av_buffersink_get_frame_rate         (const ctx: PAVFilterContext): TAVRational;

function av_buffersink_get_sample_aspect_ratio(const ctx: PAVFilterContext): TAVRational;



(** @} *)

(**
 * Get a frame with filtered data from sink and put it in frame.
 *
 * @param ctx pointer to a context of a buffersink or abuffersink AVFilter.
 * @param frame pointer to an allocated frame that will be filled with data.
 *              The data must be freed using av_frame_unref() / av_frame_free()
 *
 * @return
 *         - >= 0 if a frame was successfully returned.
 *         - AVERROR(EAGAIN) if no frames are available at this point; more
 *           input frames must be added to the filtergraph to get more output.
 *         - AVERROR_EOF if there will be no more output frames on this sink.
 *         - A different negative AVERROR code in other failure cases.
 *)

{$IFDEF API_Dynamic}
var av_buffersink_get_frame : function(ctx: PAVFilterContext; frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_get_frame(ctx: PAVFilterContext; frame: PAVFrame): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_get_frame';
{$ENDIF API_Dynamic}


(**
 * Same as av_buffersink_get_frame(), but with the ability to specify the number
 * of samples read. This function is less efficient than
 * av_buffersink_get_frame(), because it copies the data around.
 *
 * @param ctx pointer to a context of the abuffersink AVFilter.
 * @param frame pointer to an allocated frame that will be filled with data.
 *              The data must be freed using av_frame_unref() / av_frame_free()
 *              frame will contain exactly nb_samples audio samples, except at
 *              the end of stream, when it can contain less than nb_samples.
 *
 * @return The return codes have the same meaning as for
 *         av_buffersink_get_samples().
 *
 * @warning do not mix this function with av_buffersink_get_frame(). Use only one or
 * the other with a single sink, not both.
 *)

{$IFDEF API_Dynamic}
var av_buffersink_get_samples : function(ctx: PAVFilterContext; frame: PAVFrame; nb_samples: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersink_get_samples(ctx: PAVFilterContext; frame: PAVFrame; nb_samples: Integer): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersink_get_samples';
{$ENDIF API_Dynamic}


(**
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_display *)
(* ****************************************************** *)






(**
 * @addtogroup lavu_video
 * @{
 *
 * @defgroup lavu_video_display Display transformation matrix functions
 * @{
 *)

(**
 * @addtogroup lavu_video_display
 * The display transformation matrix specifies an affine transformation that
 * should be applied to video frames for correct presentation. It is compatible
 * with the matrices stored in the ISO/IEC 14496-12 container format.
 *
 * The data is a 3x3 matrix represented as a 9-element array:
 *
 * @code{.unparsed}
 *                                  | a b u |
 *   (a, b, u, c, d, v, x, y, w) -> | c d v |
 *                                  | x y w |
 * @endcode
 *
 * All numbers are stored in native endianness, as 16.16 fixed-point values,
 * except for u, v and w, which are stored as 2.30 fixed-point values.
 *
 * The transformation maps a point (p, q) in the source (pre-transformation)
 * frame to the point (p', q') in the destination (post-transformation) frame as
 * follows:
 *
 * @code{.unparsed}
 *               | a b u |
 *   (p, q, 1) . | c d v | = z * (p', q', 1)
 *               | x y w |
 * @endcode
 *
 * The transformation can also be more explicitly written in components as
 * follows:
 *
 * @code{.unparsed}
 *   p' = (a * p + c * q + x) / z;
 *   q' = (b * p + d * q + y) / z;
 *   z  =  u * p + v * q + w
 * @endcode
 *)

(**
 * Extract the rotation component of the transformation matrix.
 *
 * @param matrix the transformation matrix
 * @return the angle (in degrees) by which the transformation rotates the frame
 *         counterclockwise. The angle will be in range [-180.0, 180.0],
 *         or NaN if the matrix is singular.
 *
 * @note floating point numbers are inherently inexact, so callers are
 *       recommended to round the return value to nearest integer before use.
 *)

{$IFDEF API_Dynamic}
var av_display_rotation_get : function(const matrix: PInteger{int32_t matrix[9]}): Double; cdecl;
{$ELSE API_Dynamic}
function av_display_rotation_get(const matrix: PInteger{int32_t matrix[9]}): Double; cdecl; external AVUTIL_LIBNAME name _PU + 'av_display_rotation_get';
{$ENDIF API_Dynamic}


(**
 * Initialize a transformation matrix describing a pure counterclockwise
 * rotation by the specified angle (in degrees).
 *
 * @param matrix an allocated transformation matrix (will be fully overwritten
 *               by this function)
 * @param angle rotation angle in degrees.
 *)

{$IFDEF API_Dynamic}
var av_display_rotation_set : procedure(matrix: PInteger{int32_t matrix[9]}; angle: Double); cdecl;
{$ELSE API_Dynamic}
procedure av_display_rotation_set(matrix: PInteger{int32_t matrix[9]}; angle: Double); cdecl; external AVUTIL_LIBNAME name _PU + 'av_display_rotation_set';
{$ENDIF API_Dynamic}


(**
 * Flip the input matrix horizontally and/or vertically.
 *
 * @param matrix an allocated transformation matrix
 * @param hflip whether the matrix should be flipped horizontally
 * @param vflip whether the matrix should be flipped vertically
 *)

{$IFDEF API_Dynamic}
var av_display_matrix_flip : procedure(matrix: PInteger{int32_t matrix[9]}; hflip, vflip: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_display_matrix_flip(matrix: PInteger{int32_t matrix[9]}; hflip, vflip: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_display_matrix_flip';
{$ENDIF API_Dynamic}


(**
 * @}
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_error *)
(* ****************************************************** *)






const

(**
 * @addtogroup lavu_error
 *
 * @{
 *)


(* error handling *)
//#if EDOM > 0
//#define AVERROR(e) (-(e))   ///< Returns a negative error code from a POSIX error code, to return from library functions.
//#define AVUNERROR(e) (-(e)) ///< Returns a POSIX error code from a library function error return value.
//#else
(* Some platforms have E* and errno already negated. *)
//#define AVERROR(e) (e)
//#define AVUNERROR(e) (e)
//#endif

//#define FFERRTAG(a, b, c, d) (-(int)MKTAG(a, b, c, d))

//#define AVERROR_BSF_NOT_FOUND      FFERRTAG(0xF8,'B','S','F') ///< Bitstream filter not found
  AVERROR_BSF_NOT_FOUND       = -(    $F8  or (Ord('B') shl 8) or (Ord('S') shl 16) or (Ord('F') shl 24));
//#define AVERROR_BUG                FFERRTAG( 'B','U','G','!') ///< Internal bug, also see AVERROR_BUG2
  AVERROR_BUG                 = -(Ord('B') or (Ord('U') shl 8) or (Ord('G') shl 16) or (Ord('!') shl 24));
//#define AVERROR_BUFFER_TOO_SMALL   FFERRTAG( 'B','U','F','S') ///< Buffer too small
  AVERROR_BUFFER_TOO_SMALL    = -(Ord('B') or (Ord('U') shl 8) or (Ord('F') shl 16) or (Ord('S') shl 24));
//#define AVERROR_DECODER_NOT_FOUND  FFERRTAG(0xF8,'D','E','C') ///< Decoder not found
  AVERROR_DECODER_NOT_FOUND   = -(    $F8  or (Ord('D') shl 8) or (Ord('E') shl 16) or (Ord('C') shl 24));
//#define AVERROR_DEMUXER_NOT_FOUND  FFERRTAG(0xF8,'D','E','M') ///< Demuxer not found
  AVERROR_DEMUXER_NOT_FOUND   = -(    $F8  or (Ord('D') shl 8) or (Ord('E') shl 16) or (Ord('M') shl 24));
//#define AVERROR_ENCODER_NOT_FOUND  FFERRTAG(0xF8,'E','N','C') ///< Encoder not found
  AVERROR_ENCODER_NOT_FOUND   = -(    $F8  or (Ord('E') shl 8) or (Ord('N') shl 16) or (Ord('C') shl 24));
//#define AVERROR_EOF                FFERRTAG( 'E','O','F',' ') ///< End of file
  AVERROR_EOF                 = -(Ord('E') or (Ord('O') shl 8) or (Ord('F') shl 16) or (Ord(' ') shl 24));
//#define AVERROR_EXIT               FFERRTAG( 'E','X','I','T') ///< Immediate exit was requested; the called function should not be restarted
  AVERROR_EXIT                = -(Ord('E') or (Ord('X') shl 8) or (Ord('I') shl 16) or (Ord('T') shl 24));
//#define AVERROR_EXTERNAL           FFERRTAG( 'E','X','T',' ') ///< Generic error in an external library
  AVERROR_EXTERNAL            = -(Ord('E') or (Ord('X') shl 8) or (Ord('T') shl 16) or (Ord(' ') shl 24));
//#define AVERROR_FILTER_NOT_FOUND   FFERRTAG(0xF8,'F','I','L') ///< Filter not found
  AVERROR_FILTER_NOT_FOUND    = -(    $F8  or (Ord('F') shl 8) or (Ord('I') shl 16) or (Ord('L') shl 24));
//#define AVERROR_INVALIDDATA        FFERRTAG( 'I','N','D','A') ///< Invalid data found when processing input
  AVERROR_INVALIDDATA         = -(Ord('I') or (Ord('N') shl 8) or (Ord('D') shl 16) or (Ord('A') shl 24));
//#define AVERROR_MUXER_NOT_FOUND    FFERRTAG(0xF8,'M','U','X') ///< Muxer not found
  AVERROR_MUXER_NOT_FOUND     = -(    $F8  or (Ord('M') shl 8) or (Ord('U') shl 16) or (Ord('X') shl 24));
//#define AVERROR_OPTION_NOT_FOUND   FFERRTAG(0xF8,'O','P','T') ///< Option not found
  AVERROR_OPTION_NOT_FOUND    = -(    $F8  or (Ord('O') shl 8) or (Ord('P') shl 16) or (Ord('T') shl 24));
//#define AVERROR_PATCHWELCOME       FFERRTAG( 'P','A','W','E') ///< Not yet implemented in FFmpeg, patches welcome
  AVERROR_PATCHWELCOME        = -(Ord('P') or (Ord('A') shl 8) or (Ord('W') shl 16) or (Ord('E') shl 24));
//#define AVERROR_PROTOCOL_NOT_FOUND FFERRTAG(0xF8,'P','R','O') ///< Protocol not found
  AVERROR_PROTOCOL_NOT_FOUND  = -(    $F8  or (Ord('P') shl 8) or (Ord('R') shl 16) or (Ord('O') shl 24));
//#define AVERROR_STREAM_NOT_FOUND   FFERRTAG(0xF8,'S','T','R') ///< Stream not found
  AVERROR_STREAM_NOT_FOUND    = -(    $F8  or (Ord('S') shl 8) or (Ord('T') shl 16) or (Ord('R') shl 24));

(**
 * This is semantically identical to AVERROR_BUG
 * it has been introduced in Libav after our AVERROR_BUG and with a modified value.
 *)
//#define AVERROR_BUG2               FFERRTAG( 'B','U','G',' ')
  AVERROR_BUG2                = -(Ord('B') or (Ord('U') shl 8) or (Ord('G') shl 16) or (Ord(' ') shl 24));
//#define AVERROR_UNKNOWN            FFERRTAG( 'U','N','K','N') ///< Unknown error, typically from an external library
  AVERROR_UNKNOWN             = -(Ord('U') or (Ord('N') shl 8) or (Ord('K') shl 16) or (Ord('N') shl 24));
//#define AVERROR_EXPERIMENTAL       (-0x2bb2afa8) ///< Requested feature is flagged experimental. Set strict_std_compliance if you really want to use it.
  AVERROR_EXPERIMENTAL       = -$2bb2afa8;
//#define AVERROR_INPUT_CHANGED      (-0x636e6701) ///< Input changed between calls. Reconfiguration is required. (can be OR-ed with AVERROR_OUTPUT_CHANGED)
  AVERROR_INPUT_CHANGED      = -$636e6701;
//#define AVERROR_OUTPUT_CHANGED     (-0x636e6702) ///< Output changed between calls. Reconfiguration is required. (can be OR-ed with AVERROR_INPUT_CHANGED)
  AVERROR_OUTPUT_CHANGED     = -$636e6702;
///* HTTP & RTSP errors */
//#define AVERROR_HTTP_BAD_REQUEST   FFERRTAG(0xF8,'4','0','0')
  AVERROR_HTTP_BAD_REQUEST   = -($F8 or (Ord('4') shl 8) or (Ord('0') shl 16) or (Ord('0') shl 24));
//#define AVERROR_HTTP_UNAUTHORIZED  FFERRTAG(0xF8,'4','0','1')
  AVERROR_HTTP_UNAUTHORIZED  = -($F8 or (Ord('4') shl 8) or (Ord('0') shl 16) or (Ord('1') shl 24));
//#define AVERROR_HTTP_FORBIDDEN     FFERRTAG(0xF8,'4','0','3')
  AVERROR_HTTP_FORBIDDEN     = -($F8 or (Ord('4') shl 8) or (Ord('0') shl 16) or (Ord('3') shl 24));
//#define AVERROR_HTTP_NOT_FOUND     FFERRTAG(0xF8,'4','0','4')
  AVERROR_HTTP_NOT_FOUND     = -($F8 or (Ord('4') shl 8) or (Ord('0') shl 16) or (Ord('4') shl 24));
//#define AVERROR_HTTP_OTHER_4XX     FFERRTAG(0xF8,'4','X','X')
  AVERROR_HTTP_OTHER_4XX     = -($F8 or (Ord('4') shl 8) or (Ord('X') shl 16) or (Ord('X') shl 24));
//#define AVERROR_HTTP_SERVER_ERROR  FFERRTAG(0xF8,'5','X','X')
  AVERROR_HTTP_SERVER_ERROR  = -($F8 or (Ord('5') shl 8) or (Ord('X') shl 16) or (Ord('X') shl 24));

  AV_ERROR_MAX_STRING_SIZE    = 64;

  // TODO: check http://www.ioplex.com/~miallen/errcmp.html
  // strerror_r()
  AVERROR_EPERM           =   -1; ///< Operation not permitted
  AVERROR_ENOENT          =   -2; ///< No such file or directory
  AVERROR_ESRCH           =   -3; ///< No such process
  AVERROR_EINTR           =   -4; ///< Interrupted function call
  AVERROR_EIO             =   -5; ///< I/O error
  AVERROR_ENXIO           =   -6; ///< No such device or address
  AVERROR_E2BIG           =   -7; ///< Argument list too long
  AVERROR_ENOEXEC         =   -8; ///< Exec format error
  AVERROR_EBADF           =   -9; ///< Bad file number
  AVERROR_ECHILD          =  -10; ///< No child processes
{$IFDEF MSWINDOWS}
  AVERROR_EAGAIN          =  -11; ///< Resource temporarily unavailable / Try again
{$ENDIF}
{$IFDEF LINUX_OSX_ANDROID}
  AVERROR_EAGAIN          =  -35; ///< Resource temporarily unavailable / Try again
{$ENDIF}
  AVERROR_ENOMEM          =  -12; ///< Not enough space / Out of memory
  AVERROR_EACCES          =  -13; ///< Permission denied
  AVERROR_EFAULT          =  -14; ///< Bad address
  AVERROR_ENOTBLK         =  -15; ///< Block device required (WIN: Unknown error)
  AVERROR_EBUSY           =  -16; ///< Device or resource busy
  AVERROR_EEXIST          =  -17; ///< File exists
  AVERROR_EXDEV           =  -18; ///< Cross-device link
  AVERROR_ENODEV          =  -19; ///< No such device
  AVERROR_ENOTDIR         =  -20; ///< Not a directory
  AVERROR_EISDIR          =  -21; ///< Is a directory
  AVERROR_EINVAL          =  -22; ///< Invalid argument
  AVERROR_ENFILE          =  -23; ///< Too many open files in system / File table overflow
  AVERROR_EMFILE          =  -24; ///< Too many open files
  AVERROR_ENOTTY          =  -25; ///< Inappropriate I/O control operation / Not a typewriter
  AVERROR_ETXTBSY         =  -26; ///< Text file busy (WIN: Unknown error)
  AVERROR_EFBIG           =  -27; ///< File too large
  AVERROR_ENOSPC          =  -28; ///< No space left on device
  AVERROR_ESPIPE          =  -29; ///< Illegal seek
  AVERROR_EROFS           =  -30; ///< Read-only file system
  AVERROR_EMLINK          =  -31; ///< Too many links
  AVERROR_EPIPE           =  -32; ///< Broken pipe
  AVERROR_EDOM            =  -33; ///< Math argument out of domain of func
  AVERROR_ERANGE          =  -34; ///< Math result not representable
{$IFDEF MSWINDOWS}
  AVERROR_EDEADLK         =  -36; ///< Resource deadlock avoided
{$ENDIF}
{$IFDEF LINUX_OSX_ANDROID}
  AVERROR_EDEADLK         =  -11; ///< Resource deadlock avoided
{$ENDIF}
{$IFDEF MSWINDOWS}
  AVERROR_ENAMETOOLONG    =  -38; ///< File name too long
  AVERROR_ENOLCK          =  -39; ///< No locks available
  AVERROR_ENOSYS          =  -40; ///< Function not implemented
  AVERROR_ENOTEMPTY       =  -41; ///< Directory not empty
  AVERROR_ELOOP           = -114; ///< Too many symbolic links encountered
{$ENDIF}
{$IFDEF LINUX_OSX_ANDROID}
  AVERROR_ENAMETOOLONG    =  -63; ///< File name too long
  AVERROR_ENOLCK          =  -77; ///< No locks available
  AVERROR_ENOSYS          =  -78; ///< Function not implemented
  AVERROR_ENOTEMPTY       =  -66; ///< Directory not empty
  AVERROR_ELOOP           =  -62; ///< Too many symbolic links encountered
{$ENDIF}
  AVERROR_ENOMSG          =  -91; ///< No message of desired type (WIN: Unknown error)
  AVERROR_EIDRM           =  -90; ///< Identifier removed (WIN: Unknown error)
  AVERROR_ENOSTR          =  -99; ///< Device not a stream
  AVERROR_ENODATA         =  -96; ///< No data available
  AVERROR_ETIME           = -101; ///< Timer expired
  AVERROR_ENOSR           =  -98; ///< Out of streams resources
  AVERROR_EREMOTE         =  -71; ///< Too many levels of remote in path
  AVERROR_ENOLINK         =  -97; ///< Link has been severed
  AVERROR_EMULTIHOP       =  -95; ///< Multihop attempted
{
  AVERROR_EDOTDOT         =  -73; ///< RFS specific error
}
  AVERROR_EBADMSG         =  -94; ///< Not a data message
{$IFDEF MSWINDOWS}
  AVERROR_EPROTO          = -134; ///< Protocol error
  AVERROR_EOVERFLOW       = -132; ///< Value too large for defined data type
  AVERROR_EILSEQ          =  -42; ///< Illegal byte sequence
  AVERROR_EUSERS          =  -68; ///< Too many users
  AVERROR_ENOTSOCK        = -128; ///< Socket operation on non-socket
  AVERROR_EDESTADDRREQ    = -109; ///< Destination address required
  AVERROR_EMSGSIZE        = -115; ///< Message too long
  AVERROR_EPROTOTYPE      = -136; ///< Protocol wrong type for socket
  AVERROR_ENOPROTOOPT     = -123; ///< Protocol not available
  AVERROR_EPROTONOSUPPORT = -135; ///< Protocol not supported
  AVERROR_ESOCKTNOSUPPORT =  -44; ///< Socket type not supported
  AVERROR_EOPNOTSUPP      = -130; ///< Operation not supported on transport endpoint
  AVERROR_EPFNOSUPPORT    =  -46; ///< Protocol family not supported
{$ENDIF}
{$IFDEF LINUX_OSX_ANDROID}
  AVERROR_EPROTO          = -100; ///< Protocol error
  AVERROR_EOVERFLOW       =  -84; ///< Value too large for defined data type
  AVERROR_EILSEQ          =  -92; ///< Illegal byte sequence
  AVERROR_EUSERS          =  -68; ///< Too many users
  AVERROR_ENOTSOCK        =  -38; ///< Socket operation on non-socket
  AVERROR_EDESTADDRREQ    =  -39; ///< Destination address required
  AVERROR_EMSGSIZE        =  -40; ///< Message too long
  AVERROR_EPROTOTYPE      =  -41; ///< Protocol wrong type for socket
  AVERROR_ENOPROTOOPT     =  -42; ///< Protocol not available
  AVERROR_EPROTONOSUPPORT =  -43; ///< Protocol not supported
  AVERROR_ESOCKTNOSUPPORT =  -44; ///< Socket type not supported
  AVERROR_EOPNOTSUPP      =  -45; ///< Operation not supported on transport endpoint
  AVERROR_EPFNOSUPPORT    =  -46; ///< Protocol family not supported
{$ENDIF}
{$IFDEF MSWINDOWS}
  AVERROR_EAFNOSUPPORT    = -102; ///< Address family not supported by protocol
  AVERROR_EADDRINUSE      = -100; ///< Address already in use
  AVERROR_EADDRNOTAVAIL   = -101; ///< Cannot assign requested address
  AVERROR_ENETDOWN        = -116; ///< Network is down
  AVERROR_ENETUNREACH     = -118; ///< Network is unreachable
  AVERROR_ENETRESET       = -117; ///< Network dropped connection because of reset
  AVERROR_ECONNABORTED    = -106; ///< Software caused connection abort
  AVERROR_ECONNRESET      = -108; ///< Connection reset by peer
  AVERROR_ENOBUFS         = -119; ///< No buffer space available
  AVERROR_EISCONN         = -113; ///< Transport endpoint is already connected
  AVERROR_ENOTCONN        = -126; ///< Transport endpoint is not connected
  AVERROR_ESHUTDOWN       =  -58; ///< Cannot send after transport endpoint shutdown
  AVERROR_ETOOMANYREFS    =  -59; ///< Too many references: cannot splice
  AVERROR_ETIMEDOUT       = -138; ///< Connection timed out
  AVERROR_ECONNREFUSED    = -107; ///< Connection refused
  AVERROR_EHOSTDOWN       =  -64; ///< Host is down
  AVERROR_EHOSTUNREACH    = -110; ///< No route to host
  AVERROR_EALREADY        = -103; ///< Operation already in progress
  AVERROR_EINPROGRESS     = -112; ///< Operation now in progress
  AVERROR_ESTALE          =  -70; ///< Stale NFS file handle
  AVERROR_ECANCELED       = -105; ///< Operation Canceled
  AVERROR_EOWNERDEAD      = -133; ///< Owner died
  AVERROR_ENOTRECOVERABLE =  -44; ///< State not recoverable
{$ENDIF}
{$IFDEF LINUX_OSX_ANDROID}
  AVERROR_EAFNOSUPPORT    =  -47; ///< Address family not supported by protocol
  AVERROR_EADDRINUSE      =  -48; ///< Address already in use
  AVERROR_EADDRNOTAVAIL   =  -49; ///< Cannot assign requested address
  AVERROR_ENETDOWN        =  -50; ///< Network is down
  AVERROR_ENETUNREACH     =  -51; ///< Network is unreachable
  AVERROR_ENETRESET       =  -52; ///< Network dropped connection because of reset
  AVERROR_ECONNABORTED    =  -53; ///< Software caused connection abort
  AVERROR_ECONNRESET      =  -54; ///< Connection reset by peer
  AVERROR_ENOBUFS         =  -55; ///< No buffer space available
  AVERROR_EISCONN         =  -56; ///< Transport endpoint is already connected
  AVERROR_ENOTCONN        =  -57; ///< Transport endpoint is not connected
  AVERROR_ESHUTDOWN       =  -58; ///< Cannot send after transport endpoint shutdown
  AVERROR_ETOOMANYREFS    =  -59; ///< Too many references: cannot splice
  AVERROR_ETIMEDOUT       =  -60; ///< Connection timed out
  AVERROR_ECONNREFUSED    =  -61; ///< Connection refused
  AVERROR_EHOSTDOWN       =  -64; ///< Host is down
  AVERROR_EHOSTUNREACH    =  -65; ///< No route to host
  AVERROR_EALREADY        =  -37; ///< Operation already in progress
  AVERROR_EINPROGRESS     =  -36; ///< Operation now in progress
  AVERROR_ESTALE          =  -70; ///< Stale NFS file handle
  AVERROR_ECANCELED       =  -89; ///< Operation Canceled
  AVERROR_EOWNERDEAD      = -105; ///< Owner died
  AVERROR_ENOTRECOVERABLE = -104; ///< State not recoverable
{$ENDIF}
{
  AVERROR_ECHRNG          =  -37; ///< Channel number out of range
  AVERROR_EL2NSYNC        =  -38; ///< Level 2 not synchronized
  AVERROR_EL3HLT          =  -39; ///< Level 3 halted
  AVERROR_EL3RST          =  -40; ///< Level 3 reset
  AVERROR_ELNRNG          =  -41; ///< Link number out of range
  AVERROR_EUNATCH         =  -42; ///< Protocol driver not attached
  AVERROR_ENOCSI          =  -43; ///< No CSI structure available
  AVERROR_EL2HLT          =  -44; ///< Level 2 halted
  AVERROR_EBADE           =  -50; ///< Invalid exchange
  AVERROR_EBADR           =  -51; ///< Invalid request descriptor
  AVERROR_EXFULL          =  -52; ///< Exchange full
  AVERROR_ENOANO          =  -53; ///< No anode
  AVERROR_EBADRQC         =  -54; ///< Invalid request code
  AVERROR_EBADSLT         =  -55; ///< Invalid slot
  AVERROR_EDEADLOCK       =  -56; ///< File locking deadlock error
  AVERROR_EBFONT          =  -57; ///< Bad font file format
  AVERROR_ENONET          =  -64; ///< Machine is not on the network
  AVERROR_ENOPKG          =  -65; ///< Package not installed
  AVERROR_EADV            =  -68; ///< Advertise error
  AVERROR_ESRMNT          =  -69; ///< Srmount error
  AVERROR_ECOMM           =  -70; ///< Communication error on send
  AVERROR_ENOTUNIQ        =  -76; ///< Name not unique on network
  AVERROR_EBADFD          =  -77; ///< File descriptor in bad state
  AVERROR_EREMCHG         =  -78; ///< Remote address changed
  AVERROR_ELIBACC         =  -79; ///< Can not access a needed shared library
  AVERROR_ELIBBAD         =  -80; ///< Accessing a corrupted shared library
  AVERROR_ELIBSCN         =  -81; ///< .lib section in a.out corrupted
  AVERROR_ELIBMAX         =  -82; ///< Attempting to link in too many shared libraries
  AVERROR_ELIBEXEC        =  -83; ///< Cannot exec a shared library directly
  AVERROR_ERESTART        =  -85; ///< Interrupted system call should be restarted
  AVERROR_ESTRPIPE        =  -86; ///< Streams pipe error
  AVERROR_EUCLEAN         = -117; ///< Structure needs cleaning
  AVERROR_ENOTNAM         = -118; ///< Not a XENIX named type file
  AVERROR_ENAVAIL         = -119; ///< No XENIX semaphores available
  AVERROR_EISNAM          = -120; ///< Is a named type file
  AVERROR_EREMOTEIO       = -121; ///< Remote I/O error
  AVERROR_EDQUOT          = -122; ///< Quota exceeded
  AVERROR_ENOMEDIUM       = -123; ///< No medium found
  AVERROR_EMEDIUMTYPE     = -124; ///< Wrong medium type
  AVERROR_ENOKEY          = -126; ///< Required key not available
  AVERROR_EKEYEXPIRED     = -127; ///< Key has expired
  AVERROR_EKEYREVOKED     = -128; ///< Key has been revoked
  AVERROR_EKEYREJECTED    = -129; ///< Key was rejected by service
}

{$IFDEF MSWINDOWS}
  WSABASEERR                 = -10000;
  {$EXTERNALSYM WSABASEERR}
  WSAEINTR                   = WSABASEERR - 4;
  {$EXTERNALSYM WSAEINTR}
  WSAEBADF                   = WSABASEERR - 9;
  {$EXTERNALSYM WSAEBADF}
  WSAEACCES                  = WSABASEERR - 13;
  {$EXTERNALSYM WSAEACCES}
  WSAEFAULT                  = WSABASEERR - 14;
  {$EXTERNALSYM WSAEFAULT}
  WSAEINVAL                  = WSABASEERR - 22;
  {$EXTERNALSYM WSAEINVAL}
  WSAEMFILE                  = WSABASEERR - 24;
  {$EXTERNALSYM WSAEMFILE}
  WSAEWOULDBLOCK             = WSABASEERR - 35;
  {$EXTERNALSYM WSAEWOULDBLOCK}
  WSAEINPROGRESS             = WSABASEERR - 36; (* deprecated on WinSock2 *)
  {$EXTERNALSYM WSAEINPROGRESS}
  WSAEALREADY                = WSABASEERR - 37;
  {$EXTERNALSYM WSAEALREADY}
  WSAENOTSOCK                = WSABASEERR - 38;
  {$EXTERNALSYM WSAENOTSOCK}
  WSAEDESTADDRREQ            = WSABASEERR - 39;
  {$EXTERNALSYM WSAEDESTADDRREQ}
  WSAEMSGSIZE                = WSABASEERR - 40;
  {$EXTERNALSYM WSAEMSGSIZE}
  WSAEPROTOTYPE              = WSABASEERR - 41;
  {$EXTERNALSYM WSAEPROTOTYPE}
  WSAENOPROTOOPT             = WSABASEERR - 42;
  {$EXTERNALSYM WSAENOPROTOOPT}
  WSAEPROTONOSUPPORT         = WSABASEERR - 43;
  {$EXTERNALSYM WSAEPROTONOSUPPORT}
  WSAESOCKTNOSUPPORT         = WSABASEERR - 44;
  {$EXTERNALSYM WSAESOCKTNOSUPPORT}
  WSAEOPNOTSUPP              = WSABASEERR - 45;
  {$EXTERNALSYM WSAEOPNOTSUPP}
  WSAEPFNOSUPPORT            = WSABASEERR - 46;
  {$EXTERNALSYM WSAEPFNOSUPPORT}
  WSAEAFNOSUPPORT            = WSABASEERR - 47;
  {$EXTERNALSYM WSAEAFNOSUPPORT}
  WSAEADDRINUSE              = WSABASEERR - 48;
  {$EXTERNALSYM WSAEADDRINUSE}
  WSAEADDRNOTAVAIL           = WSABASEERR - 49;
  {$EXTERNALSYM WSAEADDRNOTAVAIL}
  WSAENETDOWN                = WSABASEERR - 50;
  {$EXTERNALSYM WSAENETDOWN}
  WSAENETUNREACH             = WSABASEERR - 51;
  {$EXTERNALSYM WSAENETUNREACH}
  WSAENETRESET               = WSABASEERR - 52;
  {$EXTERNALSYM WSAENETRESET}
  WSAECONNABORTED            = WSABASEERR - 53;
  {$EXTERNALSYM WSAECONNABORTED}
  WSAECONNRESET              = WSABASEERR - 54;
  {$EXTERNALSYM WSAECONNRESET}
  WSAENOBUFS                 = WSABASEERR - 55;
  {$EXTERNALSYM WSAENOBUFS}
  WSAEISCONN                 = WSABASEERR - 56;
  {$EXTERNALSYM WSAEISCONN}
  WSAENOTCONN                = WSABASEERR - 57;
  {$EXTERNALSYM WSAENOTCONN}
  WSAESHUTDOWN               = WSABASEERR - 58;
  {$EXTERNALSYM WSAESHUTDOWN}
  WSAETOOMANYREFS            = WSABASEERR - 59;
  {$EXTERNALSYM WSAETOOMANYREFS}
  WSAETIMEDOUT               = WSABASEERR - 60;
  {$EXTERNALSYM WSAETIMEDOUT}
  WSAECONNREFUSED            = WSABASEERR - 61;
  {$EXTERNALSYM WSAECONNREFUSED}
  WSAELOOP                   = WSABASEERR - 62;
  {$EXTERNALSYM WSAELOOP}
  WSAENAMETOOLONG            = WSABASEERR - 63;
  {$EXTERNALSYM WSAENAMETOOLONG}
  WSAEHOSTDOWN               = WSABASEERR - 64;
  {$EXTERNALSYM WSAEHOSTDOWN}
  WSAEHOSTUNREACH            = WSABASEERR - 65;
  {$EXTERNALSYM WSAEHOSTUNREACH}
  WSAENOTEMPTY               = WSABASEERR - 66;
  {$EXTERNALSYM WSAENOTEMPTY}
  WSAEPROCLIM                = WSABASEERR - 67;
  {$EXTERNALSYM WSAEPROCLIM}
  WSAEUSERS                  = WSABASEERR - 68;
  {$EXTERNALSYM WSAEUSERS}
  WSAEDQUOT                  = WSABASEERR - 69;
  {$EXTERNALSYM WSAEDQUOT}
  WSAESTALE                  = WSABASEERR - 70;
  {$EXTERNALSYM WSAESTALE}
  WSAEREMOTE                 = WSABASEERR - 71;
  {$EXTERNALSYM WSAEREMOTE}
  WSAEDISCON                 = WSABASEERR - 101;
  {$EXTERNALSYM WSAEDISCON}
  WSASYSNOTREADY             = WSABASEERR - 91;
  {$EXTERNALSYM WSASYSNOTREADY}
  WSAVERNOTSUPPORTED         = WSABASEERR - 92;
  {$EXTERNALSYM WSAVERNOTSUPPORTED}
  WSANOTINITIALISED          = WSABASEERR - 93;
  {$EXTERNALSYM WSANOTINITIALISED}
  WSAHOST_NOT_FOUND          = WSABASEERR - 1001;
  {$EXTERNALSYM WSAHOST_NOT_FOUND}
  WSATRY_AGAIN               = WSABASEERR - 1002;
  {$EXTERNALSYM WSATRY_AGAIN}
  WSANO_RECOVERY             = WSABASEERR - 1003;
  {$EXTERNALSYM WSANO_RECOVERY}
  WSANO_DATA                 = WSABASEERR - 1004;
  {$EXTERNALSYM WSANO_DATA}
  (* WinSock2 specific error codes *)
  WSAENOMORE                 = WSABASEERR - 102;
  {$EXTERNALSYM WSAENOMORE}
  WSAECANCELLED              = WSABASEERR - 103;
  {$EXTERNALSYM WSAECANCELLED}
  WSAEINVALIDPROCTABLE       = WSABASEERR - 104;
  {$EXTERNALSYM WSAEINVALIDPROCTABLE}
  WSAEINVALIDPROVIDER        = WSABASEERR - 105;
  {$EXTERNALSYM WSAEINVALIDPROVIDER}
  WSAEPROVIDERFAILEDINIT     = WSABASEERR - 106;
  {$EXTERNALSYM WSAEPROVIDERFAILEDINIT}
  WSASYSCALLFAILURE          = WSABASEERR - 107;
  {$EXTERNALSYM WSASYSCALLFAILURE}
  WSASERVICE_NOT_FOUND       = WSABASEERR - 108;
  {$EXTERNALSYM WSASERVICE_NOT_FOUND}
  WSATYPE_NOT_FOUND          = WSABASEERR - 109;
  {$EXTERNALSYM WSATYPE_NOT_FOUND}
  WSA_E_NO_MORE              = WSABASEERR - 110;
  {$EXTERNALSYM WSA_E_NO_MORE}
  WSA_E_CANCELLED            = WSABASEERR - 111;
  {$EXTERNALSYM WSA_E_CANCELLED}
  WSAEREFUSED                = WSABASEERR - 112;
  {$EXTERNALSYM WSAEREFUSED}
  (* WS QualityofService errors *)
  WSA_QOS_RECEIVERS          = WSABASEERR - 1005;
  {$EXTERNALSYM WSA_QOS_RECEIVERS}
  WSA_QOS_SENDERS            = WSABASEERR - 1006;
  {$EXTERNALSYM WSA_QOS_SENDERS}
  WSA_QOS_NO_SENDERS         = WSABASEERR - 1007;
  {$EXTERNALSYM WSA_QOS_NO_SENDERS}
  WSA_QOS_NO_RECEIVERS       = WSABASEERR - 1008;
  {$EXTERNALSYM WSA_QOS_NO_RECEIVERS}
  WSA_QOS_REQUEST_CONFIRMED  = WSABASEERR - 1009;
  {$EXTERNALSYM WSA_QOS_REQUEST_CONFIRMED}
  WSA_QOS_ADMISSION_FAILURE  = WSABASEERR - 1010;
  {$EXTERNALSYM WSA_QOS_ADMISSION_FAILURE}
  WSA_QOS_POLICY_FAILURE     = WSABASEERR - 1011;
  {$EXTERNALSYM WSA_QOS_POLICY_FAILURE}
  WSA_QOS_BAD_STYLE          = WSABASEERR - 1012;
  {$EXTERNALSYM WSA_QOS_BAD_STYLE}
  WSA_QOS_BAD_OBJECT         = WSABASEERR - 1013;
  {$EXTERNALSYM WSA_QOS_BAD_OBJECT}
  WSA_QOS_TRAFFIC_CTRL_ERROR = WSABASEERR - 1014;
  {$EXTERNALSYM WSA_QOS_TRAFFIC_CTRL_ERROR}
  WSA_QOS_GENERIC_ERROR      = WSABASEERR - 1015;
  {$EXTERNALSYM WSA_QOS_GENERIC_ERROR}
  WSA_QOS_ESERVICETYPE       = WSABASEERR - 1016;
  {$EXTERNALSYM WSA_QOS_ESERVICETYPE}
  WSA_QOS_EFLOWSPEC          = WSABASEERR - 1017;
  {$EXTERNALSYM WSA_QOS_EFLOWSPEC}
  WSA_QOS_EPROVSPECBUF       = WSABASEERR - 1018;
  {$EXTERNALSYM WSA_QOS_EPROVSPECBUF}
  WSA_QOS_EFILTERSTYLE       = WSABASEERR - 1019;
  {$EXTERNALSYM WSA_QOS_EFILTERSTYLE}
  WSA_QOS_EFILTERTYPE        = WSABASEERR - 1020;
  {$EXTERNALSYM WSA_QOS_EFILTERTYPE}
  WSA_QOS_EFILTERCOUNT       = WSABASEERR - 1021;
  {$EXTERNALSYM WSA_QOS_EFILTERCOUNT}
  WSA_QOS_EOBJLENGTH         = WSABASEERR - 1022;
  {$EXTERNALSYM WSA_QOS_EOBJLENGTH}
  WSA_QOS_EFLOWCOUNT         = WSABASEERR - 1023;
  {$EXTERNALSYM WSA_QOS_EFLOWCOUNT}
  WSA_QOS_EUNKOWNPSOBJ       = WSABASEERR - 1024;
  {$EXTERNALSYM WSA_QOS_EUNKOWNPSOBJ}
  WSA_QOS_EPOLICYOBJ         = WSABASEERR - 1025;
  {$EXTERNALSYM WSA_QOS_EPOLICYOBJ}
  WSA_QOS_EFLOWDESC          = WSABASEERR - 1026;
  {$EXTERNALSYM WSA_QOS_EFLOWDESC}
  WSA_QOS_EPSFLOWSPEC        = WSABASEERR - 1027;
  {$EXTERNALSYM WSA_QOS_EPSFLOWSPEC}
  WSA_QOS_EPSFILTERSPEC      = WSABASEERR - 1028;
  {$EXTERNALSYM WSA_QOS_EPSFILTERSPEC}
  WSA_QOS_ESDMODEOBJ         = WSABASEERR - 1029;
  {$EXTERNALSYM WSA_QOS_ESDMODEOBJ}
  WSA_QOS_ESHAPERATEOBJ      = WSABASEERR - 1030;
  {$EXTERNALSYM WSA_QOS_ESHAPERATEOBJ}
  WSA_QOS_RESERVED_PETYPE    = WSABASEERR - 1031;
  {$EXTERNALSYM WSA_QOS_RESERVED_PETYPE}
{$ENDIF}

(**
 * Put a description of the AVERROR code errnum in errbuf.
 * In case of failure the global variable errno is set to indicate the
 * error. Even in case of failure av_strerror() will print a generic
 * error message indicating the errnum provided to errbuf.
 *
 * @param errnum      error code to describe
 * @param errbuf      buffer to which description is written
 * @param errbuf_size the size in bytes of errbuf
 * @return 0 on success, a negative value if a description for errnum
 * cannot be found
 *)

{$IFDEF API_Dynamic}
var av_strerror : function(errnum: Integer; errbuf: PAnsiChar; errbuf_size: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function av_strerror(errnum: Integer; errbuf: PAnsiChar; errbuf_size: Cardinal): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strerror';
{$ENDIF API_Dynamic}


(**
 * Fill the provided buffer with a string containing an error string
 * corresponding to the AVERROR code errnum.
 *
 * @param errbuf         a buffer
 * @param errbuf_size    size in bytes of errbuf
 * @param errnum         error code to describe
 * @return the buffer in input, filled with the error description
 * @see av_strerror()
 *)
function av_make_error_string(errbuf: PAnsiChar; errbuf_size: Cardinal; errnum: Integer): PAnsiChar;  {$IFDEF USE_INLINE}inline;{$ENDIF}
{
    av_strerror(errnum, errbuf, errbuf_size);
    return errbuf;
}

(**
 * Convenience macro, the return value should be used only directly in
 * function arguments but never stand-alone.
 *)
//#define av_err2str(errnum) \
//    av_make_error_string((char[AV_ERROR_MAX_STRING_SIZE]){0}, AV_ERROR_MAX_STRING_SIZE, errnum)
function av_err2str(errnum: Integer): PAnsiChar;



(**
 * @}
 *)

type
  TErrorItem = record
    err: Integer;
    msg: string;
  end;
const
  CErrorList: array[0..111{$IFDEF MSWINDOWS}+62{$ENDIF}] of TErrorItem = (
{$IFDEF MSWINDOWS}
    (err: WSAEINTR;                   msg: 'Interrupted function call'),
    (err: WSAEBADF;                   msg: 'Bad file number'),
    (err: WSAEACCES;                  msg: 'Permission denied'),
    (err: WSAEFAULT;                  msg: 'Bad address'),
    (err: WSAEINVAL;                  msg: 'Invalid argument / Invalid data found when processing input'),
    (err: WSAEMFILE;                  msg: 'Too many open files'),
    (err: WSAENAMETOOLONG;            msg: 'File name too long'),
    (err: WSAENOTEMPTY;               msg: 'Directory not empty'),
    (err: WSAELOOP;                   msg: 'Too many symbolic links encountered'),
    (err: WSAEREMOTE;                 msg: 'Too many levels of remote in path'),
    (err: WSAEUSERS;                  msg: 'Too many users'),
    (err: WSAENOTSOCK;                msg: 'Socket operation on non-socket'),
    (err: WSAEDESTADDRREQ;            msg: 'Destination address required'),
    (err: WSAEMSGSIZE;                msg: 'Message too long'),
    (err: WSAEPROTOTYPE;              msg: 'Protocol wrong type for socket'),
    (err: WSAENOPROTOOPT;             msg: 'Protocol not available'),
    (err: WSAEPROTONOSUPPORT;         msg: 'Protocol not supported'),
    (err: WSAESOCKTNOSUPPORT;         msg: 'Socket type not supported'),
    (err: WSAEOPNOTSUPP;              msg: 'Operation not supported on transport endpoint'),
    (err: WSAEPFNOSUPPORT;            msg: 'Protocol family not supported'),
    (err: WSAEAFNOSUPPORT;            msg: 'Address family not supported by protocol'),
    (err: WSAEADDRINUSE;              msg: 'Address already in use'),
    (err: WSAEADDRNOTAVAIL;           msg: 'Cannot assign requested address'),
    (err: WSAENETDOWN;                msg: 'Network is down'),
    (err: WSAENETUNREACH;             msg: 'Network is unreachable'),
    (err: WSAENETRESET;               msg: 'Network dropped connection because of reset'),
    (err: WSAECONNABORTED;            msg: 'Software caused connection abort'),
    (err: WSAECONNRESET;              msg: 'Connection reset by peer'),
    (err: WSAENOBUFS;                 msg: 'No buffer space available'),
    (err: WSAEISCONN;                 msg: 'Transport endpoint is already connected'),
    (err: WSAENOTCONN;                msg: 'Transport endpoint is not connected'),
    (err: WSAESHUTDOWN;               msg: 'Cannot send after transport endpoint shutdown'),
    (err: WSAETOOMANYREFS;            msg: 'Too many references: cannot splice'),
    (err: WSAETIMEDOUT;               msg: 'Connection timed out'),
    (err: WSAECONNREFUSED;            msg: 'Connection refused'),
    (err: WSAEHOSTDOWN;               msg: 'Host is down'),
    (err: WSAEHOSTUNREACH;            msg: 'No route to host'),
    (err: WSAEALREADY;                msg: 'Operation already in progress'),
    (err: WSAEINPROGRESS;             msg: 'Operation now in progress'),
    (err: WSAESTALE;                  msg: 'Stale NFS file handle'),
    (err: WSAEDQUOT;                  msg: 'Quota exceeded'),
    (err: WSAEWOULDBLOCK;             msg: 'WSAEWOULDBLOCK'),
    (err: WSAEPROCLIM;                msg: 'WSAEPROCLIM'),
    (err: WSAEDISCON;                 msg: 'WSAEDISCON'),
    (err: WSASYSNOTREADY;             msg: 'WSASYSNOTREADY'),
    (err: WSAVERNOTSUPPORTED;         msg: 'WSAVERNOTSUPPORTED'),
    (err: WSANOTINITIALISED;          msg: 'WSANOTINITIALISED'),
    (err: WSAHOST_NOT_FOUND;          msg: 'WSAHOST_NOT_FOUND'),
    (err: WSATRY_AGAIN;               msg: 'WSATRY_AGAIN'),
    (err: WSANO_RECOVERY;             msg: 'WSANO_RECOVERY'),
    (err: WSANO_DATA;                 msg: 'WSANO_DATA'),
    (err: WSAENOMORE;                 msg: 'WSAENOMORE'),
    (err: WSAECANCELLED;              msg: 'WSAECANCELLED'),
    (err: WSAEINVALIDPROCTABLE;       msg: 'WSAEINVALIDPROCTABLE'),
    (err: WSAEINVALIDPROVIDER;        msg: 'WSAEINVALIDPROVIDER'),
    (err: WSAEPROVIDERFAILEDINIT;     msg: 'WSAEPROVIDERFAILEDINIT'),
    (err: WSASYSCALLFAILURE;          msg: 'WSASYSCALLFAILURE'),
    (err: WSASERVICE_NOT_FOUND;       msg: 'WSASERVICE_NOT_FOUND'),
    (err: WSATYPE_NOT_FOUND;          msg: 'WSATYPE_NOT_FOUND'),
    (err: WSA_E_NO_MORE;              msg: 'WSA_E_NO_MORE'),
    (err: WSA_E_CANCELLED;            msg: 'WSA_E_CANCELLED'),
    (err: WSAEREFUSED;                msg: 'WSAEREFUSED'),
{$ENDIF}
    // av_strerror()
    (err: AVERROR_BSF_NOT_FOUND;      msg: 'Bitstream filter not found'),
    (err: AVERROR_BUG;                msg: 'Internal bug, should not have happened'),
    (err: AVERROR_BUG2;               msg: 'Internal bug, should not have happened'),
    (err: AVERROR_BUFFER_TOO_SMALL;   msg: 'Buffer too small'),
    (err: AVERROR_DECODER_NOT_FOUND;  msg: 'Decoder not found'),
    (err: AVERROR_DEMUXER_NOT_FOUND;  msg: 'Demuxer not found'),
    (err: AVERROR_ENCODER_NOT_FOUND;  msg: 'Encoder not found'),
    (err: AVERROR_EOF;                msg: 'End of file'),
    (err: AVERROR_EXIT;               msg: 'Immediate exit requested'),
    (err: AVERROR_EXTERNAL;           msg: 'Generic error in an external library'),
    (err: AVERROR_FILTER_NOT_FOUND;   msg: 'Filter not found'),
    (err: AVERROR_INVALIDDATA;        msg: 'Invalid data found when processing input'),
    (err: AVERROR_MUXER_NOT_FOUND;    msg: 'Muxer not found'),
    (err: AVERROR_OPTION_NOT_FOUND;   msg: 'Option not found'),
    (err: AVERROR_PATCHWELCOME;       msg: 'Not yet implemented in FFmpeg, patches welcome'),
    (err: AVERROR_PROTOCOL_NOT_FOUND; msg: 'Protocol not found'),
    (err: AVERROR_STREAM_NOT_FOUND;   msg: 'Stream not found'),
    (err: AVERROR_UNKNOWN;            msg: 'Unknown error occurred'),
    (err: AVERROR_EXPERIMENTAL;       msg: 'Requested feature is flagged experimental. Set strict_std_compliance if you really want to use it.'),
    (err: AVERROR_INPUT_CHANGED;      msg: 'Input changed between calls. Reconfiguration is required. (can be OR-ed with AVERROR_OUTPUT_CHANGED)'),
    (err: AVERROR_OUTPUT_CHANGED;     msg: 'Output changed between calls. Reconfiguration is required. (can be OR-ed with AVERROR_INPUT_CHANGED)'),
    (err: AVERROR_HTTP_BAD_REQUEST;   msg: 'HTTP or RTSP error: bad request(400)'),
    (err: AVERROR_HTTP_UNAUTHORIZED;  msg: 'HTTP or RTSP error: unauthorized(401)'),
    (err: AVERROR_HTTP_FORBIDDEN;     msg: 'HTTP or RTSP error: forbidden(403)'),
    (err: AVERROR_HTTP_NOT_FOUND;     msg: 'HTTP or RTSP error: not found(404)'),
    (err: AVERROR_HTTP_OTHER_4XX;     msg: 'HTTP or RTSP error: other error(4xx)'),
    (err: AVERROR_HTTP_SERVER_ERROR;  msg: 'HTTP or RTSP error: server error(5xx)'),

    //(err: AVERROR_EPERM;              msg: 'Operation not permitted'),
    (err: AVERROR_ENOENT;             msg: 'No such file or directory'),
    (err: AVERROR_ESRCH;              msg: 'No such process'),
    (err: AVERROR_EINTR;              msg: 'Interrupted function call'),
    (err: AVERROR_EIO;                msg: 'I/O error'),
    (err: AVERROR_ENXIO;              msg: 'No such device or address'),
    (err: AVERROR_E2BIG;              msg: 'Argument list too long'),
    (err: AVERROR_ENOEXEC;            msg: 'Exec format error'),
    (err: AVERROR_EBADF;              msg: 'Bad file number'),
    (err: AVERROR_ECHILD;             msg: 'No child processes'),
    (err: AVERROR_EAGAIN;             msg: 'Resource temporarily unavailable / Try again'),
    (err: AVERROR_ENOMEM;             msg: 'Not enough space / Out of memory'),
    (err: AVERROR_EACCES;             msg: 'Permission denied'),
    (err: AVERROR_EFAULT;             msg: 'Bad address'),
{$IFDEF MSWINDOWS}
    (err: AVERROR_ENOTBLK;            msg: 'Unknown error'),
{$ELSE}
    (err: AVERROR_ENOTBLK;            msg: 'Block device required'),
{$ENDIF}
    (err: AVERROR_EBUSY;              msg: 'Device or resource busy'),
    (err: AVERROR_EEXIST;             msg: 'File exists'),
    (err: AVERROR_EXDEV;              msg: 'Cross-device link'),
    (err: AVERROR_ENODEV;             msg: 'No such device'),
    (err: AVERROR_ENOTDIR;            msg: 'Not a directory'),
    (err: AVERROR_EISDIR;             msg: 'Is a directory'),
    (err: AVERROR_EINVAL;             msg: 'Invalid argument / Invalid data found when processing input'),
    (err: AVERROR_ENFILE;             msg: 'Too many open files in system / File table overflow'),
    (err: AVERROR_EMFILE;             msg: 'Too many open files'),
    (err: AVERROR_ENOTTY;             msg: 'Inappropriate I/O control operation / Not a typewriter'),
{$IFDEF MSWINDOWS}
    (err: AVERROR_ETXTBSY;            msg: 'Unknown error'),
{$ELSE}
    (err: AVERROR_ETXTBSY;            msg: 'Text file busy'),
{$ENDIF}
    (err: AVERROR_EFBIG;              msg: 'File too large'),
    (err: AVERROR_ENOSPC;             msg: 'No space left on device'),
    (err: AVERROR_ESPIPE;             msg: 'Illegal seek'),
    (err: AVERROR_EROFS;              msg: 'Read-only file system'),
    (err: AVERROR_EMLINK;             msg: 'Too many links'),
    (err: AVERROR_EPIPE;              msg: 'Broken pipe'),
    (err: AVERROR_EDOM;               msg: 'Math argument out of domain of func'),
    (err: AVERROR_ERANGE;             msg: 'Math result not representable'),
    (err: AVERROR_EDEADLK;            msg: 'Resource deadlock avoided'),
    (err: AVERROR_ENAMETOOLONG;       msg: 'File name too long'),
    (err: AVERROR_ENOLCK;             msg: 'No locks available'),
    (err: AVERROR_ENOSYS;             msg: 'Function not implemented'),
    (err: AVERROR_ENOTEMPTY;          msg: 'Directory not empty'),
    (err: AVERROR_ELOOP;              msg: 'Too many symbolic links encountered'),
{$IFDEF MSWINDOWS}
    (err: AVERROR_ENOMSG;             msg: 'Unknown error'),
    (err: AVERROR_EIDRM;              msg: 'Unknown error'),
    (err: AVERROR_ENOSTR;             msg: 'Unknown error'),
    (err: AVERROR_ENODATA;            msg: 'Unknown error'),
    (err: AVERROR_ETIME;              msg: 'Unknown error'),
    (err: AVERROR_ENOSR;              msg: 'Unknown error'),
{$ELSE}
    (err: AVERROR_ENOMSG;             msg: 'No message of desired type'),
    (err: AVERROR_EIDRM;              msg: 'Identifier removed'),
    (err: AVERROR_ENOSTR;             msg: 'Device not a stream'),
    (err: AVERROR_ENODATA;            msg: 'No data available'),
    (err: AVERROR_ETIME;              msg: 'Timer expired'),
    (err: AVERROR_ENOSR;              msg: 'Out of streams resources'),
{$ENDIF}
{$IFDEF MSWINDOWS}
    (err: AVERROR_EREMOTE;            msg: 'Unknown error'),
    (err: AVERROR_ENOLINK;            msg: 'Unknown error'),
{$ELSE}
    (err: AVERROR_EREMOTE;            msg: 'Too many levels of remote in path'),
    (err: AVERROR_ENOLINK;            msg: 'Link has been severed'),
{$ENDIF}
    (err: AVERROR_EPROTO;             msg: 'Protocol error'),
{$IFDEF MSWINDOWS}
    (err: AVERROR_EMULTIHOP;          msg: 'Unknown error'),
    (err: AVERROR_EBADMSG;            msg: 'Unknown error'),
{$ELSE}
    (err: AVERROR_EMULTIHOP;          msg: 'Multihop attempted'),
    (err: AVERROR_EBADMSG;            msg: 'Not a data message'),
{$ENDIF}
    (err: AVERROR_EOVERFLOW;          msg: 'Value too large for defined data type'),
    (err: AVERROR_EILSEQ;             msg: 'Illegal byte sequence'),
{$IFDEF MSWINDOWS}
    (err: AVERROR_EUSERS;             msg: 'Unknown error'),
{$ELSE}
    (err: AVERROR_EUSERS;             msg: 'Too many users'),
{$ENDIF}
    (err: AVERROR_ENOTSOCK;           msg: 'Socket operation on non-socket'),
    (err: AVERROR_EDESTADDRREQ;       msg: 'Destination address required'),
    (err: AVERROR_EMSGSIZE;           msg: 'Message too long'),
    (err: AVERROR_EPROTOTYPE;         msg: 'Protocol wrong type for socket'),
    (err: AVERROR_ENOPROTOOPT;        msg: 'Protocol not available'),
    (err: AVERROR_EPROTONOSUPPORT;    msg: 'Protocol not supported'),
{$IFDEF MSWINDOWS}
    (err: AVERROR_ESOCKTNOSUPPORT;    msg: 'Unknown error'),
{$ELSE}
    (err: AVERROR_ESOCKTNOSUPPORT;    msg: 'Socket type not supported'),
{$ENDIF}
    (err: AVERROR_EOPNOTSUPP;         msg: 'Operation not supported on transport endpoint'),
{$IFDEF MSWINDOWS}
    (err: AVERROR_EPFNOSUPPORT;       msg: 'Unknown error'),
{$ELSE}
    (err: AVERROR_EPFNOSUPPORT;       msg: 'Protocol family not supported'),
{$ENDIF}
    (err: AVERROR_EAFNOSUPPORT;       msg: 'Address family not supported by protocol'),
    (err: AVERROR_EADDRINUSE;         msg: 'Address already in use'),
    (err: AVERROR_EADDRNOTAVAIL;      msg: 'Cannot assign requested address'),
    (err: AVERROR_ENETDOWN;           msg: 'Network is down'),
    (err: AVERROR_ENETUNREACH;        msg: 'Network is unreachable'),
    (err: AVERROR_ENETRESET;          msg: 'Network dropped connection because of reset'),
    (err: AVERROR_ECONNABORTED;       msg: 'Software caused connection abort'),
    (err: AVERROR_ECONNRESET;         msg: 'Connection reset by peer'),
    (err: AVERROR_ENOBUFS;            msg: 'No buffer space available'),
    (err: AVERROR_EISCONN;            msg: 'Transport endpoint is already connected'),
    (err: AVERROR_ENOTCONN;           msg: 'Transport endpoint is not connected'),
{$IFDEF MSWINDOWS}
    (err: AVERROR_ESHUTDOWN;          msg: 'Unknown error'),
    (err: AVERROR_ETOOMANYREFS;       msg: 'Unknown error'),
{$ELSE}
    (err: AVERROR_ESHUTDOWN;          msg: 'Cannot send after transport endpoint shutdown'),
    (err: AVERROR_ETOOMANYREFS;       msg: 'Too many references: cannot splice'),
{$ENDIF}
    (err: AVERROR_ETIMEDOUT;          msg: 'Connection timed out'),
    (err: AVERROR_ECONNREFUSED;       msg: 'Connection refused'),
{$IFDEF MSWINDOWS}
    (err: AVERROR_EHOSTDOWN;          msg: 'Unknown error'),
{$ELSE}
    (err: AVERROR_EHOSTDOWN;          msg: 'Host is down'),
{$ENDIF}
    (err: AVERROR_EHOSTUNREACH;       msg: 'No route to host'),
    (err: AVERROR_EALREADY;           msg: 'Operation already in progress'),
    (err: AVERROR_EINPROGRESS;        msg: 'Operation now in progress'),
{$IFDEF MSWINDOWS}
    (err: AVERROR_ESTALE;             msg: 'Unknown error'),
{$ELSE}
    (err: AVERROR_ESTALE;             msg: 'Stale NFS file handle'),
{$ENDIF}
    (err: AVERROR_ECANCELED;          msg: 'Operation Canceled'),
    (err: AVERROR_EOWNERDEAD;         msg: 'Owner died'),
    (err: AVERROR_ENOTRECOVERABLE;    msg: 'State not recoverable')
{
    (err: AVERROR_ECHRNG;             msg: 'Channel number out of range'),
    (err: AVERROR_EL2NSYNC;           msg: 'Level 2 not synchronized'),
    (err: AVERROR_EL3HLT;             msg: 'Level 3 halted'),
    (err: AVERROR_EL3RST;             msg: 'Level 3 reset'),
    (err: AVERROR_ELNRNG;             msg: 'Link number out of range'),
    (err: AVERROR_EUNATCH;            msg: 'Protocol driver not attached'),
    (err: AVERROR_ENOCSI;             msg: 'No CSI structure available'),
    (err: AVERROR_EL2HLT;             msg: 'Level 2 halted'),
    (err: AVERROR_EBADE;              msg: 'Invalid exchange'),
    (err: AVERROR_EBADR;              msg: 'Invalid request descriptor'),
    (err: AVERROR_EXFULL;             msg: 'Exchange full'),
    (err: AVERROR_ENOANO;             msg: 'No anode'),
    (err: AVERROR_EBADRQC;            msg: 'Invalid request code'),
    (err: AVERROR_EBADSLT;            msg: 'Invalid slot'),
    (err: AVERROR_EBFONT;             msg: 'Bad font file format'),
    (err: AVERROR_ENONET;             msg: 'Machine is not on the network'),
    (err: AVERROR_ENOPKG;             msg: 'Package not installed'),
    (err: AVERROR_EADV;               msg: 'Advertise error'),
    (err: AVERROR_ESRMNT;             msg: 'Srmount error'),
    (err: AVERROR_ECOMM;              msg: 'Communication error on send'),
    (err: AVERROR_EDOTDOT;            msg: 'RFS specific error'),
    (err: AVERROR_ENOTUNIQ;           msg: 'Name not unique on network'),
    (err: AVERROR_EBADFD;             msg: 'File descriptor in bad state'),
    (err: AVERROR_EREMCHG;            msg: 'Remote address changed'),
    (err: AVERROR_ELIBACC;            msg: 'Can not access a needed shared library'),
    (err: AVERROR_ELIBBAD;            msg: 'Accessing a corrupted shared library'),
    (err: AVERROR_ELIBSCN;            msg: '.lib section in a.out corrupted'),
    (err: AVERROR_ELIBMAX;            msg: 'Attempting to link in too many shared libraries'),
    (err: AVERROR_ELIBEXEC;           msg: 'Cannot exec a shared library directly'),
    (err: AVERROR_ERESTART;           msg: 'Interrupted system call should be restarted'),
    (err: AVERROR_ESTRPIPE;           msg: 'Streams pipe error'),
    (err: AVERROR_EUCLEAN;            msg: 'Structure needs cleaning'),
    (err: AVERROR_ENOTNAM;            msg: 'Not a XENIX named type file'),
    (err: AVERROR_ENAVAIL;            msg: 'No XENIX semaphores available'),
    (err: AVERROR_EISNAM;             msg: 'Is a named type file'),
    (err: AVERROR_EREMOTEIO;          msg: 'Remote I/O error'),
    (err: AVERROR_EDQUOT;             msg: 'Quota exceeded'),
    (err: AVERROR_ENOMEDIUM;          msg: 'No medium found'),
    (err: AVERROR_EMEDIUMTYPE;        msg: 'Wrong medium type'),
    (err: AVERROR_ENOKEY;             msg: 'Required key not available'),
    (err: AVERROR_EKEYEXPIRED;        msg: 'Key has expired'),
    (err: AVERROR_EKEYREVOKED;        msg: 'Key has been revoked'),
    (err: AVERROR_EKEYREJECTED;       msg: 'Key was rejected by service'),
}
  );


(* ****************************************************** *)
(* import libavutil_eval *)
(* ****************************************************** *)






type
  PPAVExpr = ^PAVExpr;
  PAVExpr = ^TAVExpr;
  TAVExpr = record
    // need {$ALIGN 8}
    // defined in libavutil/eval.c
  end;

(**
 * Parse and evaluate an expression.
 * Note, this is significantly slower than av_expr_eval().
 *
 * @param res a pointer to a double where is put the result value of
 * the expression, or NAN in case of error
 * @param s expression as a zero terminated string, for example "1+2^3+5*5+sin(2/3)"
 * @param const_names NULL terminated array of zero terminated strings of constant identifiers, for example {"PI", "E", 0}
 * @param const_values a zero terminated array of values for the identifiers from const_names
 * @param func1_names NULL terminated array of zero terminated strings of funcs1 identifiers
 * @param funcs1 NULL terminated array of function pointers for functions which take 1 argument
 * @param func2_names NULL terminated array of zero terminated strings of funcs2 identifiers
 * @param funcs2 NULL terminated array of function pointers for functions which take 2 arguments
 * @param opaque a pointer which will be passed to all functions from funcs1 and funcs2
 * @param log_ctx parent logging context
 * @return >= 0 in case of success, a negative value corresponding to an
 * AVERROR code otherwise
 *)
  Tfuncs1Call = function(p: Pointer; v: double): PDouble; cdecl;
  Tfuncs2Call = function(p: Pointer; v1, v2: Double): PDouble; cdecl;

{$IFDEF API_Dynamic}
var av_expr_parse_and_eval : function(res: Double; const s: PAnsiChar;
                           const const_names: PPAnsiChar; const const_values: PDouble;
                           const func1_names: PPAnsiChar; funcs1: Tfuncs1Call;
                           const func2_names: PPAnsiChar; funcs2: Tfuncs2Call;
                           opaque: Pointer; log_offset: Integer; log_ctx: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_expr_parse_and_eval(res: Double; const s: PAnsiChar;
                           const const_names: PPAnsiChar; const const_values: PDouble;
                           const func1_names: PPAnsiChar; funcs1: Tfuncs1Call;
                           const func2_names: PPAnsiChar; funcs2: Tfuncs2Call;
                           opaque: Pointer; log_offset: Integer; log_ctx: Pointer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_expr_parse_and_eval';
{$ENDIF API_Dynamic}


(**
 * Parse an expression.
 *
 * @param expr a pointer where is put an AVExpr containing the parsed
 * value in case of successful parsing, or NULL otherwise.
 * The pointed to AVExpr must be freed with av_expr_free() by the user
 * when it is not needed anymore.
 * @param s expression as a zero terminated string, for example "1+2^3+5*5+sin(2/3)"
 * @param const_names NULL terminated array of zero terminated strings of constant identifiers, for example {"PI", "E", 0}
 * @param func1_names NULL terminated array of zero terminated strings of funcs1 identifiers
 * @param funcs1 NULL terminated array of function pointers for functions which take 1 argument
 * @param func2_names NULL terminated array of zero terminated strings of funcs2 identifiers
 * @param funcs2 NULL terminated array of function pointers for functions which take 2 arguments
 * @param log_ctx parent logging context
 * @return >= 0 in case of success, a negative value corresponding to an
 * AVERROR code otherwise
 *)

{$IFDEF API_Dynamic}
var av_expr_parse : function(expr: PPAVExpr; const s: PAnsiChar;
                  const const_names: PPAnsiChar;
                  const func1_names: PPAnsiChar; funcs1: Tfuncs1Call;
                  const func2_names: PPAnsiChar; funcs2: Tfuncs2Call;
                  log_offset: Integer; log_ctx: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_expr_parse(expr: PPAVExpr; const s: PAnsiChar;
                  const const_names: PPAnsiChar;
                  const func1_names: PPAnsiChar; funcs1: Tfuncs1Call;
                  const func2_names: PPAnsiChar; funcs2: Tfuncs2Call;
                  log_offset: Integer; log_ctx: Pointer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_expr_parse';
{$ENDIF API_Dynamic}


(**
 * Evaluate a previously parsed expression.
 *
 * @param const_values a zero terminated array of values for the identifiers from av_expr_parse() const_names
 * @param opaque a pointer which will be passed to all functions from funcs1 and funcs2
 * @return the value of the expression
 *)

{$IFDEF API_Dynamic}
var av_expr_eval : function(e: PAVExpr; const const_values: PDouble; opaque: Pointer): Double; cdecl;
{$ELSE API_Dynamic}
function av_expr_eval(e: PAVExpr; const const_values: PDouble; opaque: Pointer): Double; cdecl; external AVUTIL_LIBNAME name _PU + 'av_expr_eval';
{$ENDIF API_Dynamic}


(**
 * Free a parsed expression previously created with av_expr_parse().
 *)

{$IFDEF API_Dynamic}
var av_expr_free : procedure(e: PAVExpr); cdecl;
{$ELSE API_Dynamic}
procedure av_expr_free(e: PAVExpr); cdecl; external AVUTIL_LIBNAME name _PU + 'av_expr_free';
{$ENDIF API_Dynamic}


(**
 * Parse the string in numstr and return its value as a double. If
 * the string is empty, contains only whitespaces, or does not contain
 * an initial substring that has the expected syntax for a
 * floating-point number, no conversion is performed. In this case,
 * returns a value of zero and the value returned in tail is the value
 * of numstr.
 *
 * @param numstr a string representing a number, may contain one of
 * the International System number postfixes, for example 'K', 'M',
 * 'G'. If 'i' is appended after the postfix, powers of 2 are used
 * instead of powers of 10. The 'B' postfix multiplies the value by
 * 8, and can be appended after another postfix or used alone. This
 * allows using for example 'KB', 'MiB', 'G' and 'B' as postfix.
 * @param tail if non-NULL puts here the pointer to the char next
 * after the last parsed character
 *)

{$IFDEF API_Dynamic}
var av_strtod : function(const numstr: PAnsiChar; tail: PPAnsiChar): Double; cdecl;
{$ELSE API_Dynamic}
function av_strtod(const numstr: PAnsiChar; tail: PPAnsiChar): Double; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strtod';
{$ENDIF API_Dynamic}



(* ****************************************************** *)
(* import libavutil_fifo *)
(* ****************************************************** *)






type
  PPAVFifoBuffer = ^PAVFifoBuffer;
  PAVFifoBuffer = ^TAVFifoBuffer;
  TAVFifoBuffer = record
    buffer: PByte;
    rptr, wptr, eend: PByte;
    rndx, wndx: Cardinal;
  end;

  TfifoCall = procedure(v1, v2: Pointer; i: Integer); cdecl;
  TwriteCall = function(p1, p2: Pointer; i: Integer): Integer; cdecl;

(**
 * Initialize an AVFifoBuffer.
 * @param size of FIFO
 * @return AVFifoBuffer or NULL in case of memory allocation failure
 *)

{$IFDEF API_Dynamic}
var av_fifo_alloc : function(size: Cardinal): PAVFifoBuffer; cdecl;
{$ELSE API_Dynamic}
function av_fifo_alloc(size: Cardinal): PAVFifoBuffer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_alloc';
{$ENDIF API_Dynamic}


(**
 * Initialize an AVFifoBuffer.
 * @param nmemb number of elements
 * @param size  size of the single element
 * @return AVFifoBuffer or NULL in case of memory allocation failure
 *)

{$IFDEF API_Dynamic}
var av_fifo_alloc_array : function(nmemb, size: Cardinal{size_t}): PAVFifoBuffer; cdecl;
{$ELSE API_Dynamic}
function av_fifo_alloc_array(nmemb, size: Cardinal{size_t}): PAVFifoBuffer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_alloc_array';
{$ENDIF API_Dynamic}


(**
 * Free an AVFifoBuffer.
 * @param f AVFifoBuffer to free
 *)

{$IFDEF API_Dynamic}
var av_fifo_free : procedure(f: PAVFifoBuffer); cdecl;
{$ELSE API_Dynamic}
procedure av_fifo_free(f: PAVFifoBuffer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_free';
{$ENDIF API_Dynamic}


(**
 * Free an AVFifoBuffer and reset pointer to NULL.
 * @param f AVFifoBuffer to free
 *)

{$IFDEF API_Dynamic}
var av_fifo_freep : procedure(f: PPAVFifoBuffer); cdecl;
{$ELSE API_Dynamic}
procedure av_fifo_freep(f: PPAVFifoBuffer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_freep';
{$ENDIF API_Dynamic}


(**
 * Reset the AVFifoBuffer to the state right after av_fifo_alloc, in particular it is emptied.
 * @param f AVFifoBuffer to reset
 *)

{$IFDEF API_Dynamic}
var av_fifo_reset : procedure(f: PAVFifoBuffer); cdecl;
{$ELSE API_Dynamic}
procedure av_fifo_reset(f: PAVFifoBuffer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_reset';
{$ENDIF API_Dynamic}


(**
 * Return the amount of data in bytes in the AVFifoBuffer, that is the
 * amount of data you can read from it.
 * @param f AVFifoBuffer to read from
 * @return size
 *)

{$IFDEF API_Dynamic}
var av_fifo_size : function(const f: PAVFifoBuffer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_fifo_size(const f: PAVFifoBuffer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_size';
{$ENDIF API_Dynamic}


(**
 * Return the amount of space in bytes in the AVFifoBuffer, that is the
 * amount of data you can write into it.
 * @param f AVFifoBuffer to write into
 * @return size
 *)

{$IFDEF API_Dynamic}
var av_fifo_space : function(const f: PAVFifoBuffer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_fifo_space(const f: PAVFifoBuffer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_space';
{$ENDIF API_Dynamic}


(**
 * Feed data at specific position from an AVFifoBuffer to a user-supplied callback.
 * Similar as av_fifo_gereric_read but without discarding data.
 * @param f AVFifoBuffer to read from
 * @param offset offset from current read position
 * @param buf_size number of bytes to read
 * @param func generic read function
 * @param dest data destination
 *)
type
  TfifopeekCall = procedure(a, b: Pointer; c: Integer); cdecl;

{$IFDEF API_Dynamic}
var av_fifo_generic_peek_at : function(f: PAVFifoBuffer; dest: Pointer; offset, buf_size: Integer; func: TfifopeekCall): Integer; cdecl;
{$ELSE API_Dynamic}
function av_fifo_generic_peek_at(f: PAVFifoBuffer; dest: Pointer; offset, buf_size: Integer; func: TfifopeekCall): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_generic_peek_at';
{$ENDIF API_Dynamic}


(**
 * Feed data from an AVFifoBuffer to a user-supplied callback.
 * Similar as av_fifo_gereric_read but without discarding data.
 * @param f AVFifoBuffer to read from
 * @param buf_size number of bytes to read
 * @param func generic read function
 * @param dest data destination
 *)

{$IFDEF API_Dynamic}
var av_fifo_generic_peek : function(f: PAVFifoBuffer; dest: Pointer; buf_size: Integer; func: TfifoCall): Integer; cdecl;
{$ELSE API_Dynamic}
function av_fifo_generic_peek(f: PAVFifoBuffer; dest: Pointer; buf_size: Integer; func: TfifoCall): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_generic_peek';
{$ENDIF API_Dynamic}


(**
 * Feed data from an AVFifoBuffer to a user-supplied callback.
 * @param f AVFifoBuffer to read from
 * @param buf_size number of bytes to read
 * @param func generic read function
 * @param dest data destination
 *)

{$IFDEF API_Dynamic}
var av_fifo_generic_read : function(f: PAVFifoBuffer; dest: Pointer; buf_size: Integer; func: TfifoCall): Integer; cdecl;
{$ELSE API_Dynamic}
function av_fifo_generic_read(f: PAVFifoBuffer; dest: Pointer; buf_size: Integer; func: TfifoCall): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_generic_read';
{$ENDIF API_Dynamic}


(**
 * Feed data from a user-supplied callback to an AVFifoBuffer.
 * @param f AVFifoBuffer to write to
 * @param src data source; non-const since it may be used as a
 * modifiable context by the function defined in func
 * @param size number of bytes to write
 * @param func generic write function; the first parameter is src,
 * the second is dest_buf, the third is dest_buf_size.
 * func must return the number of bytes written to dest_buf, or <= 0 to
 * indicate no more data available to write.
 * If func is NULL, src is interpreted as a simple byte array for source data.
 * @return the number of bytes written to the FIFO
 *)

{$IFDEF API_Dynamic}
var av_fifo_generic_write : function(f: PAVFifoBuffer; src: Pointer; size: Integer; func: TwriteCall): Integer; cdecl;
{$ELSE API_Dynamic}
function av_fifo_generic_write(f: PAVFifoBuffer; src: Pointer; size: Integer; func: TwriteCall): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_generic_write';
{$ENDIF API_Dynamic}


(**
 * Resize an AVFifoBuffer.
 * In case of reallocation failure, the old FIFO is kept unchanged.
 *
 * @param f AVFifoBuffer to resize
 * @param size new AVFifoBuffer size in bytes
 * @return <0 for failure, >=0 otherwise
 *)

{$IFDEF API_Dynamic}
var av_fifo_realloc2 : function(f: PAVFifoBuffer; size: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function av_fifo_realloc2(f: PAVFifoBuffer; size: Cardinal): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_realloc2';
{$ENDIF API_Dynamic}


(**
 * Enlarge an AVFifoBuffer.
 * In case of reallocation failure, the old FIFO is kept unchanged.
 * The new fifo size may be larger than the requested size.
 *
 * @param f AVFifoBuffer to resize
 * @param additional_space the amount of space in bytes to allocate in addition to av_fifo_size()
 * @return <0 for failure, >=0 otherwise
 *)

{$IFDEF API_Dynamic}
var av_fifo_grow : function(f: PAVFifoBuffer; additional_space: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function av_fifo_grow(f: PAVFifoBuffer; additional_space: Cardinal): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_grow';
{$ENDIF API_Dynamic}


(**
 * Read and discard the specified amount of data from an AVFifoBuffer.
 * @param f AVFifoBuffer to read from
 * @param size amount of data to read in bytes
 *)

{$IFDEF API_Dynamic}
var av_fifo_drain : procedure(f: PAVFifoBuffer; size: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_fifo_drain(f: PAVFifoBuffer; size: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_fifo_drain';
{$ENDIF API_Dynamic}


(**
 * Return a pointer to the data stored in a FIFO buffer at a certain offset.
 * The FIFO buffer is not modified.
 *
 * @param f    AVFifoBuffer to peek at, f must be non-NULL
 * @param offs an offset in bytes, its absolute value must be less
 *             than the used buffer size or the returned pointer will
 *             point outside to the buffer data.
 *             The used buffer size can be checked with av_fifo_size().
 *)
function av_fifo_peek2(const f: PAVFifoBuffer; offs: Integer): PByte;  {$IFDEF USE_INLINE}inline;{$ENDIF}


(* ****************************************************** *)
(* import libavutil_file *)
(* ****************************************************** *)






(**
 * Read the file with name filename, and put its content in a newly
 * allocated buffer or map it with mmap() when available.
 * In case of success set *bufptr to the read or mmapped buffer, and
 * *size to the size in bytes of the buffer in *bufptr.
 * The returned buffer must be released with av_file_unmap().
 *
 * @param log_offset loglevel offset used for logging
 * @param log_ctx context used for logging
 * @return a non negative number in case of success, a negative value
 * corresponding to an AVERROR error code in case of failure
 *)

{$IFDEF API_Dynamic}
var av_file_map : function(const filename: PAnsiChar; bufptr: PPByte; size: PCardinal;
                log_offset: Integer; log_ctx: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_file_map(const filename: PAnsiChar; bufptr: PPByte; size: PCardinal;
                log_offset: Integer; log_ctx: Pointer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_file_map';
{$ENDIF API_Dynamic}


(**
 * Unmap or free the buffer bufptr created by av_file_map().
 *
 * @param size size in bytes of bufptr, must be the same as returned
 * by av_file_map()
 *)

{$IFDEF API_Dynamic}
var av_file_unmap : procedure(bufptr: PByte; size: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_file_unmap(bufptr: PByte; size: Cardinal); cdecl; external AVUTIL_LIBNAME name _PU + 'av_file_unmap';
{$ENDIF API_Dynamic}


(**
 * Wrapper to work around the lack of mkstemp() on mingw.
 * Also, tries to create file in /tmp first, if possible.
 * *prefix can be a character constant; *filename will be allocated internally.
 * @return file descriptor of opened file (or negative value corresponding to an
 * AVERROR code on error)
 * and opened file name in **filename.
 * @note On very old libcs it is necessary to set a secure umask before
 *       calling this, av_tempfile() can't call umask itself as it is used in
 *       libraries and could interfere with the calling application.
 * @deprecated as fd numbers cannot be passed saftely between libs on some platforms
 *)

{$IFDEF API_Dynamic}
var av_tempfile : function(const prefix: PAnsiChar; filename: PPAnsiChar; log_offset: Integer; log_ctx: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_tempfile(const prefix: PAnsiChar; filename: PPAnsiChar; log_offset: Integer; log_ctx: Pointer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_tempfile';
{$ENDIF API_Dynamic}



(* ****************************************************** *)
(* import libavfilter_buffersrc *)
(* ****************************************************** *)






(**
 * @defgroup lavfi_buffersrc Buffer source API
 * @ingroup lavfi
 * @{
 *)

const

(**
 * Do not check for format changes.
 *)
  AV_BUFFERSRC_FLAG_NO_CHECK_FORMAT = 1;

(**
 * Immediately push the frame to the output.
 *)
  AV_BUFFERSRC_FLAG_PUSH = 4;

(**
 * Keep a reference to the frame.
 * If the frame if reference-counted, create a new reference; otherwise
 * copy the frame data.
 *)
  AV_BUFFERSRC_FLAG_KEEP_REF = 8;

(**
 * Get the number of failed requests.
 *
 * A failed request is when the request_frame method is called while no
 * frame is present in the buffer.
 * The number is reset when a frame is added.
 *)

{$IFDEF API_Dynamic}
var av_buffersrc_get_nb_failed_requests : function(buffer_src: PAVFilterContext): Cardinal; cdecl;
{$ELSE API_Dynamic}
function av_buffersrc_get_nb_failed_requests(buffer_src: PAVFilterContext): Cardinal; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersrc_get_nb_failed_requests';
{$ENDIF API_Dynamic}


(**
 * This structure contains the parameters describing the frames that will be
 * passed to this filter.
 *
 * It should be allocated with av_buffersrc_parameters_alloc() and freed with
 * av_free(). All the allocated fields in it remain owned by the caller.
 *)
type
  PAVBufferSrcParameters = ^TAVBufferSrcParameters;
  TAVBufferSrcParameters = record
    (**
     * video: the pixel format, value corresponds to enum AVPixelFormat
     * audio: the sample format, value corresponds to enum AVSampleFormat
     *)
    format: Integer;
    (**
     * The timebase to be used for the timestamps on the input frames.
     *)
    time_base: TAVRational;

    (**
     * Video only, the display dimensions of the input frames.
     *)
    width, height: Integer;

    (**
     * Video only, the sample (pixel) aspect ratio.
     *)
    sample_aspect_ratio: TAVRational;

    (**
     * Video only, the frame rate of the input video. This field must only be
     * set to a non-zero value if input stream has a known constant framerate
     * and should be left at its initial value if the framerate is variable or
     * unknown.
     *)
    frame_rate: TAVRational;

    (**
     * Video with a hwaccel pixel format only. This should be a reference to an
     * AVHWFramesContext instance describing the input frames.
     *)
    hw_frames_ctx: PAVBufferRef;

    (**
     * Audio only, the audio sampling rate in samples per secon.
     *)
    sample_rate: Integer;

    (**
     * Audio only, the audio channel layout
     *)
    channel_layout: Int64;
  end;

(**
 * Allocate a new AVBufferSrcParameters instance. It should be freed by the
 * caller with av_free().
 *)

{$IFDEF API_Dynamic}
var av_buffersrc_parameters_alloc : function(): PAVBufferSrcParameters; cdecl;
{$ELSE API_Dynamic}
function av_buffersrc_parameters_alloc(): PAVBufferSrcParameters; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersrc_parameters_alloc';
{$ENDIF API_Dynamic}


(**
 * Initialize the buffersrc or abuffersrc filter with the provided parameters.
 * This function may be called multiple times, the later calls override the
 * previous ones. Some of the parameters may also be set through AVOptions, then
 * whatever method is used last takes precedence.
 *
 * @param ctx an instance of the buffersrc or abuffersrc filter
 * @param param the stream parameters. The frames later passed to this filter
 *              must conform to those parameters. All the allocated fields in
 *              param remain owned by the caller, libavfilter will make internal
 *              copies or references when necessary.
 * @return 0 on success, a negative AVERROR code on failure.
 *)

{$IFDEF API_Dynamic}
var av_buffersrc_parameters_set : function(ctx: PAVFilterContext; param: PAVBufferSrcParameters): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersrc_parameters_set(ctx: PAVFilterContext; param: PAVBufferSrcParameters): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersrc_parameters_set';
{$ENDIF API_Dynamic}


(**
 * Add a frame to the buffer source.
 *
 * @param ctx   an instance of the buffersrc filter
 * @param frame frame to be added. If the frame is reference counted, this
 * function will make a new reference to it. Otherwise the frame data will be
 * copied.
 *
 * @return 0 on success, a negative AVERROR on error
 *
 * This function is equivalent to av_buffersrc_add_frame_flags() with the
 * AV_BUFFERSRC_FLAG_KEEP_REF flag.
 *)

{$IFDEF API_Dynamic}
var av_buffersrc_write_frame : function(ctx: PAVFilterContext; const frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersrc_write_frame(ctx: PAVFilterContext; const frame: PAVFrame): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersrc_write_frame';
{$ENDIF API_Dynamic}


(**
 * Add a frame to the buffer source.
 *
 * @param ctx   an instance of the buffersrc filter
 * @param frame frame to be added. If the frame is reference counted, this
 * function will take ownership of the reference(s) and reset the frame.
 * Otherwise the frame data will be copied. If this function returns an error,
 * the input frame is not touched.
 *
 * @return 0 on success, a negative AVERROR on error.
 *
 * @note the difference between this function and av_buffersrc_write_frame() is
 * that av_buffersrc_write_frame() creates a new reference to the input frame,
 * while this function takes ownership of the reference passed to it.
 *
 * This function is equivalent to av_buffersrc_add_frame_flags() without the
 * AV_BUFFERSRC_FLAG_KEEP_REF flag.
 *)

{$IFDEF API_Dynamic}
var av_buffersrc_add_frame : function(ctx: PAVFilterContext; frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersrc_add_frame(ctx: PAVFilterContext; frame: PAVFrame): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersrc_add_frame';
{$ENDIF API_Dynamic}


(**
 * Add a frame to the buffer source.
 *
 * By default, if the frame is reference-counted, this function will take
 * ownership of the reference(s) and reset the frame. This can be controlled
 * using the flags.
 *
 * If this function returns an error, the input frame is not touched.
 *
 * @param buffer_src  pointer to a buffer source context
 * @param frame       a frame, or NULL to mark EOF
 * @param flags       a combination of AV_BUFFERSRC_FLAG_*
 * @return            >= 0 in case of success, a negative AVERROR code
 *                    in case of failure
 *)

{$IFDEF API_Dynamic}
var av_buffersrc_add_frame_flags : function(buffer_src: PAVFilterContext;
                                  frame: PAVFrame; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersrc_add_frame_flags(buffer_src: PAVFilterContext;
                                  frame: PAVFrame; flags: Integer): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersrc_add_frame_flags';
{$ENDIF API_Dynamic}


(**
 * Close the buffer source after EOF.
 *
 * This is similar to passing NULL to av_buffersrc_add_frame_flags()
 * except it takes the timestamp of the EOF, i.e. the timestamp of the end
 * of the last frame.
 *)

{$IFDEF API_Dynamic}
var av_buffersrc_close : function(ctx: PAVFilterContext; pts: Int64; flags: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function av_buffersrc_close(ctx: PAVFilterContext; pts: Int64; flags: Cardinal): Integer; cdecl; external AVFILTER_LIBNAME name _PU + 'av_buffersrc_close';
{$ENDIF API_Dynamic}


(**
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_hwcontext *)
(* ****************************************************** *)






type
  TAVHWDeviceType = (
    AV_HWDEVICE_TYPE_VDPAU,
    AV_HWDEVICE_TYPE_CUDA,
    AV_HWDEVICE_TYPE_VAAPI,
    AV_HWDEVICE_TYPE_DXVA2,
    AV_HWDEVICE_TYPE_QSV,
    AV_HWDEVICE_TYPE_VIDEOTOOLBOX,
    AV_HWDEVICE_TYPE_NONE,
    AV_HWDEVICE_TYPE_D3D11VA,
    AV_HWDEVICE_TYPE_DRM
  );

  PAVHWDeviceInternal = ^TAVHWDeviceInternal;
  TAVHWDeviceInternal = record
    // need {$ALIGN 8}
    // defined in libutil/hwcontext_internal.h
  end;

(**
 * This struct aggregates all the (hardware/vendor-specific) "high-level" state,
 * i.e. state that is not tied to a concrete processing configuration.
 * E.g., in an API that supports hardware-accelerated encoding and decoding,
 * this struct will (if possible) wrap the state that is common to both encoding
 * and decoding and from which specific instances of encoders or decoders can be
 * derived.
 *
 * This struct is reference-counted with the AVBuffer mechanism. The
 * av_hwdevice_ctx_alloc() constructor yields a reference, whose data field
 * points to the actual AVHWDeviceContext. Further objects derived from
 * AVHWDeviceContext (such as AVHWFramesContext, describing a frame pool with
 * specific properties) will hold an internal reference to it. After all the
 * references are released, the AVHWDeviceContext itself will be freed,
 * optionally invoking a user-specified callback for uninitializing the hardware
 * state.
 *)
  PAVHWDeviceContext = ^TAVHWDeviceContext;
  TAVHWDeviceContext = record
    (**
     * A class for logging. Set by av_hwdevice_ctx_alloc().
     *)
    av_class: PAVClass;

    (**
     * Private data used internally by libavutil. Must not be accessed in any
     * way by the caller.
     *)
    internal: PAVHWDeviceInternal;

    (**
     * This field identifies the underlying API used for hardware access.
     *
     * This field is set when this struct is allocated and never changed
     * afterwards.
     *)
    type_: TAVHWDeviceType;

    (**
     * The format-specific data, allocated and freed by libavutil along with
     * this context.
     *
     * Should be cast by the user to the format-specific context defined in the
     * corresponding header (hwcontext_*.h) and filled as described in the
     * documentation before calling av_hwdevice_ctx_init().
     *
     * After calling av_hwdevice_ctx_init() this struct should not be modified
     * by the caller.
     *)
    hwctx: Pointer;

    (**
     * This field may be set by the caller before calling av_hwdevice_ctx_init().
     *
     * If non-NULL, this callback will be called when the last reference to
     * this context is unreferenced, immediately before it is freed.
     *
     * @note when other objects (e.g an AVHWFramesContext) are derived from this
     *       struct, this callback will be invoked after all such child objects
     *       are fully uninitialized and their respective destructors invoked.
     *)
    free: procedure(ctx: PAVHWDeviceContext); cdecl;

    (**
     * Arbitrary user data, to be used e.g. by the free() callback.
     *)
    user_opaque: Pointer;
  end;

  PAVHWFramesInternal = ^TAVHWFramesInternal;
  TAVHWFramesInternal = record
    // need {$ALIGN 8}
    // defined in libutil/hwcontext_internal.h
  end;

(**
 * This struct describes a set or pool of "hardware" frames (i.e. those with
 * data not located in normal system memory). All the frames in the pool are
 * assumed to be allocated in the same way and interchangeable.
 *
 * This struct is reference-counted with the AVBuffer mechanism and tied to a
 * given AVHWDeviceContext instance. The av_hwframe_ctx_alloc() constructor
 * yields a reference, whose data field points to the actual AVHWFramesContext
 * struct.
 *)
  PAVHWFramesContext = ^TAVHWFramesContext;
  TAVHWFramesContext = record
    (**
     * A class for logging.
     *)
    av_class: PAVClass;

    (**
     * Private data used internally by libavutil. Must not be accessed in any
     * way by the caller.
     *)
    internal: PAVHWFramesInternal;

    (**
     * A reference to the parent AVHWDeviceContext. This reference is owned and
     * managed by the enclosing AVHWFramesContext, but the caller may derive
     * additional references from it.
     *)
    device_ref: PAVBufferRef;

    (**
     * The parent AVHWDeviceContext. This is simply a pointer to
     * device_ref->data provided for convenience.
     *
     * Set by libavutil in av_hwframe_ctx_init().
     *)
    device_ctx: PAVHWDeviceContext;

    (**
     * The format-specific data, allocated and freed automatically along with
     * this context.
     *
     * Should be cast by the user to the format-specific context defined in the
     * corresponding header (hwframe_*.h) and filled as described in the
     * documentation before calling av_hwframe_ctx_init().
     *
     * After any frames using this context are created, the contents of this
     * struct should not be modified by the caller.
     *)
    hwctx: Pointer;

    (**
     * This field may be set by the caller before calling av_hwframe_ctx_init().
     *
     * If non-NULL, this callback will be called when the last reference to
     * this context is unreferenced, immediately before it is freed.
     *)
    free: procedure(ctx: PAVHWFramesContext); cdecl;

    (**
     * Arbitrary user data, to be used e.g. by the free() callback.
     *)
    user_opaque: Pointer;

    (**
     * A pool from which the frames are allocated by av_hwframe_get_buffer().
     * This field may be set by the caller before calling av_hwframe_ctx_init().
     * The buffers returned by calling av_buffer_pool_get() on this pool must
     * have the properties described in the documentation in the corresponding hw
     * type's header (hwcontext_*.h). The pool will be freed strictly before
     * this struct's free() callback is invoked.
     *
     * This field may be NULL, then libavutil will attempt to allocate a pool
     * internally. Note that certain device types enforce pools allocated at
     * fixed size (frame count), which cannot be extended dynamically. In such a
     * case, initial_pool_size must be set appropriately.
     *)
    pool: PAVBufferPool;

    (**
     * Initial size of the frame pool. If a device type does not support
     * dynamically resizing the pool, then this is also the maximum pool size.
     *
     * May be set by the caller before calling av_hwframe_ctx_init(). Must be
     * set if pool is NULL and the device type does not support dynamic pools.
     *)
    initial_pool_size: Integer;

    (**
     * The pixel format identifying the underlying HW surface type.
     *
     * Must be a hwaccel format, i.e. the corresponding descriptor must have the
     * AV_PIX_FMT_FLAG_HWACCEL flag set.
     *
     * Must be set by the user before calling av_hwframe_ctx_init().
     *)
    format: TAVPixelFormat;

    (**
     * The pixel format identifying the actual data layout of the hardware
     * frames.
     *
     * Must be set by the caller before calling av_hwframe_ctx_init().
     *
     * @note when the underlying API does not provide the exact data layout, but
     * only the colorspace/bit depth, this field should be set to the fully
     * planar version of that format (e.g. for 8-bit 420 YUV it should be
     * AV_PIX_FMT_YUV420P, not AV_PIX_FMT_NV12 or anything else).
     *)
    sw_format: TAVPixelFormat;

    (**
     * The allocated dimensions of the frames in this pool.
     *
     * Must be set by the user before calling av_hwframe_ctx_init().
     *)
    width, height: Integer;
  end;

(**
 * Look up an AVHWDeviceType by name.
 *
 * @param name String name of the device type (case-insensitive).
 * @return The type from enum AVHWDeviceType, or AV_HWDEVICE_TYPE_NONE if
 *         not found.
 *)

{$IFDEF API_Dynamic}
var av_hwdevice_find_type_by_name : function(const name: PAnsiChar): TAVHWDeviceType; cdecl;
{$ELSE API_Dynamic}
function av_hwdevice_find_type_by_name(const name: PAnsiChar): TAVHWDeviceType; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwdevice_find_type_by_name';
{$ENDIF API_Dynamic}


(** Get the string name of an AVHWDeviceType.
 *
 * @param type Type from enum AVHWDeviceType.
 * @return Pointer to a static string containing the name, or NULL if the type
 *         is not valid.
 *)

{$IFDEF API_Dynamic}
var av_hwdevice_get_type_name : function(type_: TAVHWDeviceType): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_hwdevice_get_type_name(type_: TAVHWDeviceType): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwdevice_get_type_name';
{$ENDIF API_Dynamic}


(**
 * Iterate over supported device types.
 *
 * @param type AV_HWDEVICE_TYPE_NONE initially, then the previous type
 *             returned by this function in subsequent iterations.
 * @return The next usable device type from enum AVHWDeviceType, or
 *         AV_HWDEVICE_TYPE_NONE if there are no more.
 *)

{$IFDEF API_Dynamic}
var av_hwdevice_iterate_types : function(prev: TAVHWDeviceType): TAVHWDeviceType; cdecl;
{$ELSE API_Dynamic}
function av_hwdevice_iterate_types(prev: TAVHWDeviceType): TAVHWDeviceType; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwdevice_iterate_types';
{$ENDIF API_Dynamic}


(**
 * Allocate an AVHWDeviceContext for a given hardware type.
 *
 * @param type the type of the hardware device to allocate.
 * @return a reference to the newly created AVHWDeviceContext on success or NULL
 *         on failure.
 *)

{$IFDEF API_Dynamic}
var av_hwdevice_ctx_alloc : function(type_: TAVHWDeviceType): PAVBufferRef; cdecl;
{$ELSE API_Dynamic}
function av_hwdevice_ctx_alloc(type_: TAVHWDeviceType): PAVBufferRef; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwdevice_ctx_alloc';
{$ENDIF API_Dynamic}


(**
 * Finalize the device context before use. This function must be called after
 * the context is filled with all the required information and before it is
 * used in any way.
 *
 * @param ref a reference to the AVHWDeviceContext
 * @return 0 on success, a negative AVERROR code on failure
 *)

{$IFDEF API_Dynamic}
var av_hwdevice_ctx_init : function(ref: PAVBufferRef): Integer; cdecl;
{$ELSE API_Dynamic}
function av_hwdevice_ctx_init(ref: PAVBufferRef): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwdevice_ctx_init';
{$ENDIF API_Dynamic}


(**
 * Open a device of the specified type and create an AVHWDeviceContext for it.
 *
 * This is a convenience function intended to cover the simple cases. Callers
 * who need to fine-tune device creation/management should open the device
 * manually and then wrap it in an AVHWDeviceContext using
 * av_hwdevice_ctx_alloc()/av_hwdevice_ctx_init().
 *
 * The returned context is already initialized and ready for use, the caller
 * should not call av_hwdevice_ctx_init() on it. The user_opaque/free fields of
 * the created AVHWDeviceContext are set by this function and should not be
 * touched by the caller.
 *
 * @param device_ctx On success, a reference to the newly-created device context
 *                   will be written here. The reference is owned by the caller
 *                   and must be released with av_buffer_unref() when no longer
 *                   needed. On failure, NULL will be written to this pointer.
 * @param type The type of the device to create.
 * @param device A type-specific string identifying the device to open.
 * @param opts A dictionary of additional (type-specific) options to use in
 *             opening the device. The dictionary remains owned by the caller.
 * @param flags currently unused
 *
 * @return 0 on success, a negative AVERROR code on failure.
 *)

{$IFDEF API_Dynamic}
var av_hwdevice_ctx_create : function(device_ctx: PPAVBufferRef; type_: TAVHWDeviceType;
                           const device: PAnsiChar; opts: PAVDictionary; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_hwdevice_ctx_create(device_ctx: PPAVBufferRef; type_: TAVHWDeviceType;
                           const device: PAnsiChar; opts: PAVDictionary; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwdevice_ctx_create';
{$ENDIF API_Dynamic}


(**
 * Create a new device of the specified type from an existing device.
 *
 * If the source device is a device of the target type or was originally
 * derived from such a device (possibly through one or more intermediate
 * devices of other types), then this will return a reference to the
 * existing device of the same type as is requested.
 *
 * Otherwise, it will attempt to derive a new device from the given source
 * device.  If direct derivation to the new type is not implemented, it will
 * attempt the same derivation from each ancestor of the source device in
 * turn looking for an implemented derivation method.
 *
 * @param dst_ctx On success, a reference to the newly-created
 *                AVHWDeviceContext.
 * @param type    The type of the new device to create.
 * @param src_ctx A reference to an existing AVHWDeviceContext which will be
 *                used to create the new device.
 * @param flags   Currently unused; should be set to zero.
 * @return        Zero on success, a negative AVERROR code on failure.
 *)

{$IFDEF API_Dynamic}
var av_hwdevice_ctx_create_derived : function(dst_ctx: PPAVBufferRef;
                                   type_: TAVHWDeviceType;
                                   src_ctx: PAVBufferRef; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_hwdevice_ctx_create_derived(dst_ctx: PPAVBufferRef;
                                   type_: TAVHWDeviceType;
                                   src_ctx: PAVBufferRef; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwdevice_ctx_create_derived';
{$ENDIF API_Dynamic}



(**
 * Allocate an AVHWFramesContext tied to a given device context.
 *
 * @param device_ctx a reference to a AVHWDeviceContext. This function will make
 *                   a new reference for internal use, the one passed to the
 *                   function remains owned by the caller.
 * @return a reference to the newly created AVHWFramesContext on success or NULL
 *         on failure.
 *)

{$IFDEF API_Dynamic}
var av_hwframe_ctx_alloc : function(device_ctx: PAVBufferRef): PAVBufferRef; cdecl;
{$ELSE API_Dynamic}
function av_hwframe_ctx_alloc(device_ctx: PAVBufferRef): PAVBufferRef; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwframe_ctx_alloc';
{$ENDIF API_Dynamic}


(**
 * Finalize the context before use. This function must be called after the
 * context is filled with all the required information and before it is attached
 * to any frames.
 *
 * @param ref a reference to the AVHWFramesContext
 * @return 0 on success, a negative AVERROR code on failure
 *)

{$IFDEF API_Dynamic}
var av_hwframe_ctx_init : function(ref: PAVBufferRef): Integer; cdecl;
{$ELSE API_Dynamic}
function av_hwframe_ctx_init(ref: PAVBufferRef): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwframe_ctx_init';
{$ENDIF API_Dynamic}


(**
 * Allocate a new frame attached to the given AVHWFramesContext.
 *
 * @param hwframe_ctx a reference to an AVHWFramesContext
 * @param frame an empty (freshly allocated or unreffed) frame to be filled with
 *              newly allocated buffers.
 * @param flags currently unused, should be set to zero
 * @return 0 on success, a negative AVERROR code on failure
 *)

{$IFDEF API_Dynamic}
var av_hwframe_get_buffer : function(hwframe_ctx: PAVBufferRef; frame: PAVFrame; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_hwframe_get_buffer(hwframe_ctx: PAVBufferRef; frame: PAVFrame; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwframe_get_buffer';
{$ENDIF API_Dynamic}


(**
 * Copy data to or from a hw surface. At least one of dst/src must have an
 * AVHWFramesContext attached.
 *
 * If src has an AVHWFramesContext attached, then the format of dst (if set)
 * must use one of the formats returned by av_hwframe_transfer_get_formats(src,
 * AV_HWFRAME_TRANSFER_DIRECTION_FROM).
 * If dst has an AVHWFramesContext attached, then the format of src must use one
 * of the formats returned by av_hwframe_transfer_get_formats(dst,
 * AV_HWFRAME_TRANSFER_DIRECTION_TO)
 *
 * dst may be "clean" (i.e. with data/buf pointers unset), in which case the
 * data buffers will be allocated by this function using av_frame_get_buffer().
 * If dst->format is set, then this format will be used, otherwise (when
 * dst->format is AV_PIX_FMT_NONE) the first acceptable format will be chosen.
 *
 * The two frames must have matching allocated dimensions (i.e. equal to
 * AVHWFramesContext.width/height), since not all device types support
 * transferring a sub-rectangle of the whole surface. The display dimensions
 * (i.e. AVFrame.width/height) may be smaller than the allocated dimensions, but
 * also have to be equal for both frames. When the display dimensions are
 * smaller than the allocated dimensions, the content of the padding in the
 * destination frame is unspecified.
 *
 * @param dst the destination frame. dst is not touched on failure.
 * @param src the source frame.
 * @param flags currently unused, should be set to zero
 * @return 0 on success, a negative AVERROR error code on failure.
 *)

{$IFDEF API_Dynamic}
var av_hwframe_transfer_data : function(dst: PAVFrame; const src: PAVFrame; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_hwframe_transfer_data(dst: PAVFrame; const src: PAVFrame; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwframe_transfer_data';
{$ENDIF API_Dynamic}


type
  TAVHWFrameTransferDirection = (
    (**
     * Transfer the data from the queried hw frame.
     *)
    AV_HWFRAME_TRANSFER_DIRECTION_FROM,

    (**
     * Transfer the data to the queried hw frame.
     *)
    AV_HWFRAME_TRANSFER_DIRECTION_TO
  );

(**
 * Get a list of possible source or target formats usable in
 * av_hwframe_transfer_data().
 *
 * @param hwframe_ctx the frame context to obtain the information for
 * @param dir the direction of the transfer
 * @param formats the pointer to the output format list will be written here.
 *                The list is terminated with AV_PIX_FMT_NONE and must be freed
 *                by the caller when no longer needed using av_free().
 *                If this function returns successfully, the format list will
 *                have at least one item (not counting the terminator).
 *                On failure, the contents of this pointer are unspecified.
 * @param flags currently unused, should be set to zero
 * @return 0 on success, a negative AVERROR code on failure.
 *)

{$IFDEF API_Dynamic}
var av_hwframe_transfer_get_formats : function(hwframe_ctx: PAVBufferRef;
                                    dir: TAVHWFrameTransferDirection;
                                    formats: PPAVPixelFormat; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_hwframe_transfer_get_formats(hwframe_ctx: PAVBufferRef;
                                    dir: TAVHWFrameTransferDirection;
                                    formats: PPAVPixelFormat; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwframe_transfer_get_formats';
{$ENDIF API_Dynamic}



type
(**
 * This struct describes the constraints on hardware frames attached to
 * a given device with a hardware-specific configuration.  This is returned
 * by av_hwdevice_get_hwframe_constraints() and must be freed by
 * av_hwframe_constraints_free() after use.
 *)
  PPAVHWFramesConstraints = ^PAVHWFramesConstraints;
  PAVHWFramesConstraints = ^TAVHWFramesConstraints;
  TAVHWFramesConstraints = record
    (**
     * A list of possible values for format in the hw_frames_ctx,
     * terminated by AV_PIX_FMT_NONE.  This member will always be filled.
     *)
    valid_hw_formats: PAVPixelFormat;

    (**
     * A list of possible values for sw_format in the hw_frames_ctx,
     * terminated by AV_PIX_FMT_NONE.  Can be NULL if this information is
     * not known.
     *)
    valid_sw_formats: PAVPixelFormat;

    (**
     * The minimum size of frames in this hw_frames_ctx.
     * (Zero if not known.)
     *)
    min_width: Integer;
    min_height: Integer;

    (**
     * The maximum size of frames in this hw_frames_ctx.
     * (INT_MAX if not known / no limit.)
     *)
    max_width: Integer;
    max_height: Integer;
  end;

(**
 * Allocate a HW-specific configuration structure for a given HW device.
 * After use, the user must free all members as required by the specific
 * hardware structure being used, then free the structure itself with
 * av_free().
 *
 * @param device_ctx a reference to the associated AVHWDeviceContext.
 * @return The newly created HW-specific configuration structure on
 *         success or NULL on failure.
 *)

{$IFDEF API_Dynamic}
var av_hwdevice_hwconfig_alloc : function(device_ctx: PAVBufferRef): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_hwdevice_hwconfig_alloc(device_ctx: PAVBufferRef): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwdevice_hwconfig_alloc';
{$ENDIF API_Dynamic}


(**
 * Get the constraints on HW frames given a device and the HW-specific
 * configuration to be used with that device.  If no HW-specific
 * configuration is provided, returns the maximum possible capabilities
 * of the device.
 *
 * @param ref a reference to the associated AVHWDeviceContext.
 * @param hwconfig a filled HW-specific configuration structure, or NULL
 *        to return the maximum possible capabilities of the device.
 * @return AVHWFramesConstraints structure describing the constraints
 *         on the device, or NULL if not available.
 *)

{$IFDEF API_Dynamic}
var av_hwdevice_get_hwframe_constraints : function(ref: PAVBufferRef;
                                                           const hwconfig: Pointer): PAVHWFramesConstraints; cdecl;
{$ELSE API_Dynamic}
function av_hwdevice_get_hwframe_constraints(ref: PAVBufferRef;
                                                           const hwconfig: Pointer): PAVHWFramesConstraints; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwdevice_get_hwframe_constraints';
{$ENDIF API_Dynamic}


(**
 * Free an AVHWFrameConstraints structure.
 *
 * @param constraints The (filled or unfilled) AVHWFrameConstraints structure.
 *)

{$IFDEF API_Dynamic}
var av_hwframe_constraints_free : procedure(constraints: PPAVHWFramesConstraints); cdecl;
{$ELSE API_Dynamic}
procedure av_hwframe_constraints_free(constraints: PPAVHWFramesConstraints); cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwframe_constraints_free';
{$ENDIF API_Dynamic}



type
(**
 * Flags to apply to frame mappings.
 *)
  TAVHWFrameMap = (
    (**
     * The mapping must be readable.
     *)
    AV_HWFRAME_MAP_READ      = (1 shl 0),
    (**
     * The mapping must be writeable.
     *)
    AV_HWFRAME_MAP_WRITE     = (1 shl 1),
    (**
     * The mapped frame will be overwritten completely in subsequent
     * operations, so the current frame data need not be loaded.  Any values
     * which are not overwritten are unspecified.
     *)
    AV_HWFRAME_MAP_OVERWRITE = (1 shl 2),
    (**
     * The mapping must be direct.  That is, there must not be any copying in
     * the map or unmap steps.  Note that performance of direct mappings may
     * be much lower than normal memory.
     *)
    AV_HWFRAME_MAP_DIRECT    = (1 shl 3)
  );

(**
 * Map a hardware frame.
 *
 * This has a number of different possible effects, depending on the format
 * and origin of the src and dst frames.  On input, src should be a usable
 * frame with valid buffers and dst should be blank (typically as just created
 * by av_frame_alloc()).  src should have an associated hwframe context, and
 * dst may optionally have a format and associated hwframe context.
 *
 * If src was created by mapping a frame from the hwframe context of dst,
 * then this function undoes the mapping - dst is replaced by a reference to
 * the frame that src was originally mapped from.
 *
 * If both src and dst have an associated hwframe context, then this function
 * attempts to map the src frame from its hardware context to that of dst and
 * then fill dst with appropriate data to be usable there.  This will only be
 * possible if the hwframe contexts and associated devices are compatible -
 * given compatible devices, av_hwframe_ctx_create_derived() can be used to
 * create a hwframe context for dst in which mapping should be possible.
 *
 * If src has a hwframe context but dst does not, then the src frame is
 * mapped to normal memory and should thereafter be usable as a normal frame.
 * If the format is set on dst, then the mapping will attempt to create dst
 * with that format and fail if it is not possible.  If format is unset (is
 * AV_PIX_FMT_NONE) then dst will be mapped with whatever the most appropriate
 * format to use is (probably the sw_format of the src hwframe context).
 *
 * A return value of AVERROR(ENOSYS) indicates that the mapping is not
 * possible with the given arguments and hwframe setup, while other return
 * values indicate that it failed somehow.
 *
 * @param dst Destination frame, to contain the mapping.
 * @param src Source frame, to be mapped.
 * @param flags Some combination of AV_HWFRAME_MAP_* flags.
 * @return Zero on success, negative AVERROR code on failure.
 *)

{$IFDEF API_Dynamic}
var av_hwframe_map : function(dst: PAVFrame; const src: PAVFrame; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_hwframe_map(dst: PAVFrame; const src: PAVFrame; flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwframe_map';
{$ENDIF API_Dynamic}



(**
 * Create and initialise an AVHWFramesContext as a mapping of another existing
 * AVHWFramesContext on a different device.
 *
 * av_hwframe_ctx_init() should not be called after this.
 *
 * @param derived_frame_ctx  On success, a reference to the newly created
 *                           AVHWFramesContext.
 * @param derived_device_ctx A reference to the device to create the new
 *                           AVHWFramesContext on.
 * @param source_frame_ctx   A reference to an existing AVHWFramesContext
 *                           which will be mapped to the derived context.
 * @param flags  Some combination of AV_HWFRAME_MAP_* flags, defining the
 *               mapping parameters to apply to frames which are allocated
 *               in the derived device.
 * @return       Zero on success, negative AVERROR code on failure.
 *)

{$IFDEF API_Dynamic}
var av_hwframe_ctx_create_derived : function(derived_frame_ctx: PPAVBufferRef;
                                  format: TAVPixelFormat;
                                  derived_device_ctx: PAVBufferRef;
                                  source_frame_ctx: PAVBufferRef;
                                  flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_hwframe_ctx_create_derived(derived_frame_ctx: PPAVBufferRef;
                                  format: TAVPixelFormat;
                                  derived_device_ctx: PAVBufferRef;
                                  source_frame_ctx: PAVBufferRef;
                                  flags: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_hwframe_ctx_create_derived';
{$ENDIF API_Dynamic}




(* ****************************************************** *)
(* import libavutil_pixdesc *)
(* ****************************************************** *)






type
  TAVComponentDescriptor = record
    (**
     * Which of the 4 planes contains the component.
     *)
    plane: Integer;

    (**
     * Number of elements between 2 horizontally consecutive pixels.
     * Elements are bits for bitstream formats, bytes otherwise.
     *)
    step: Integer;

    (**
     * Number of elements before the component of the first pixel plus 1.
     * Elements are bits for bitstream formats, bytes otherwise.
     *)
    offset: Integer;

    (**
     * Number of least significant bits that must be shifted away
     * to get the value.
     *)
    shift: Integer;

    (**
     * Number of bits in the component.
     *)
    depth: Integer;

{$IFDEF FF_API_PLUS1_MINUS1}
    (** deprecated, use step instead *)
    step_minus1: Integer;

    (** deprecated, use depth instead *)
    depth_minus1: Integer;

    (** deprecated, use offset instead *)
    offset_plus1: Integer;
{$ENDIF}
  end;

(**
 * Descriptor that unambiguously describes how the bits of a pixel are
 * stored in the up to 4 data planes of an image. It also stores the
 * subsampling factors and number of components.
 *
 * @note This is separate of the colorspace (RGB, YCbCr, YPbPr, JPEG-style YUV
 *       and all the YUV variants) AVPixFmtDescriptor just stores how values
 *       are stored not what these values represent.
 *)
  PAVPixFmtDescriptor = ^TAVPixFmtDescriptor;
  TAVPixFmtDescriptor = record
    name: PAnsiChar;
    nb_components: Byte;      ///< The number of components each pixel has, (1-4)

    (**
     * Amount to shift the luma width right to find the chroma width.
     * For YV12 this is 1 for example.
     * chroma_width = AV_CEIL_RSHIFT(luma_width, log2_chroma_w)
     * The note above is needed to ensure rounding up.
     * This value only refers to the chroma components.
     *)
    log2_chroma_w: Byte;

    (**
     * Amount to shift the luma height right to find the chroma height.
     * For YV12 this is 1 for example.
     * chroma_height= AV_CEIL_RSHIFT(luma_height, log2_chroma_h)
     * The note above is needed to ensure rounding up.
     * This value only refers to the chroma components.
     *)
    log2_chroma_h: Byte;

    (**
     * Combination of AV_PIX_FMT_FLAG_... flags.
     *)
    flags: Int64;

    (**
     * Parameters that describe how pixels are packed.
     * If the format has 1 or 2 components, then luma is 0.
     * If the format has 3 or 4 components:
     *   if the RGB flag is set then 0 is red, 1 is green and 2 is blue;
     *   otherwise 0 is luma, 1 is chroma-U and 2 is chroma-V.
     *
     * If present, the Alpha channel is always the last component.
     *)
    comp: array[0..3] of TAVComponentDescriptor;

    (**
     * Alternative comma-separated names.
     *)
    alias: PAnsiChar;
  end;

const
(**
 * Pixel format is big-endian.
 *)
  AV_PIX_FMT_FLAG_BE          = (1 shl 0);
(**
 * Pixel format has a palette in data[1], values are indexes in this palette.
 *)
  AV_PIX_FMT_FLAG_PAL         = (1 shl 1);
(**
 * All values of a component are bit-wise packed end to end.
 *)
  AV_PIX_FMT_FLAG_BITSTREAM   = (1 shl 2);
(**
 * Pixel format is an HW accelerated format.
 *)
  AV_PIX_FMT_FLAG_HWACCEL     = (1 shl 3);
(**
 * At least one pixel component is not in the first data plane.
 *)
  AV_PIX_FMT_FLAG_PLANAR      = (1 shl 4);
(**
 * The pixel format contains RGB-like data (as opposed to YUV/grayscale).
 *)
  AV_PIX_FMT_FLAG_RGB         = (1 shl 5);

(**
 * The pixel format is "pseudo-paletted". This means that it contains a
 * fixed palette in the 2nd plane but the palette is fixed/constant for each
 * PIX_FMT. This allows interpreting the data as if it was PAL8, which can
 * in some cases be simpler. Or the data can be interpreted purely based on
 * the pixel format without using the palette.
 * An example of a pseudo-paletted format is AV_PIX_FMT_GRAY8
 *)
  AV_PIX_FMT_FLAG_PSEUDOPAL   = (1 shl 6);

(**
 * The pixel format has an alpha channel. This is set on all formats that
 * support alpha in some way. The exception is AV_PIX_FMT_PAL8, which can
 * carry alpha as part of the palette. Details are explained in the
 * AVPixelFormat enum, and are also encoded in the corresponding
 * AVPixFmtDescriptor.
 *
 * The alpha is always straight, never pre-multiplied.
 *
 * If a codec or a filter does not support alpha, it should set all alpha to
 * opaque, or use the equivalent pixel formats without alpha component, e.g.
 * AV_PIX_FMT_RGB0 (or AV_PIX_FMT_RGB24 etc.) instead of AV_PIX_FMT_RGBA.
 *)
  AV_PIX_FMT_FLAG_ALPHA       = (1 shl 7);

(**
 * The pixel format is following a Bayer pattern
 *)
  AV_PIX_FMT_FLAG_BAYER       = (1 shl 8);

(**
 * The pixel format contains IEEE-754 floating point values. Precision (double,
 * single, or half) should be determined by the pixel size (64, 32, or 16 bits).
 *)
  AV_PIX_FMT_FLAG_FLOAT       = (1 shl 9);

(**
 * Return the number of bits per pixel used by the pixel format
 * described by pixdesc. Note that this is not the same as the number
 * of bits per sample.
 *
 * The returned number of bits refers to the number of bits actually
 * used for storing the pixel information, that is padding bits are
 * not counted.
 *)

{$IFDEF API_Dynamic}
var av_get_bits_per_pixel : function(const pixdesc: PAVPixFmtDescriptor): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_bits_per_pixel(const pixdesc: PAVPixFmtDescriptor): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_bits_per_pixel';
{$ENDIF API_Dynamic}


(**
 * Return the number of bits per pixel for the pixel format
 * described by pixdesc, including any padding or unused bits.
 *)

{$IFDEF API_Dynamic}
var av_get_padded_bits_per_pixel : function(const pixdesc: PAVPixFmtDescriptor): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_padded_bits_per_pixel(const pixdesc: PAVPixFmtDescriptor): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_padded_bits_per_pixel';
{$ENDIF API_Dynamic}


(**
 * @return a pixel format descriptor for provided pixel format or NULL if
 * this pixel format is unknown.
 *)

{$IFDEF API_Dynamic}
var av_pix_fmt_desc_get : function(pix_fmt: TAVPixelFormat): PAVPixFmtDescriptor; cdecl;
{$ELSE API_Dynamic}
function av_pix_fmt_desc_get(pix_fmt: TAVPixelFormat): PAVPixFmtDescriptor; cdecl; external AVUTIL_LIBNAME name _PU + 'av_pix_fmt_desc_get';
{$ENDIF API_Dynamic}


(**
 * Iterate over all pixel format descriptors known to libavutil.
 *
 * @param prev previous descriptor. NULL to get the first descriptor.
 *
 * @return next descriptor or NULL after the last descriptor
 *)

{$IFDEF API_Dynamic}
var av_pix_fmt_desc_next : function(const prev: PAVPixFmtDescriptor): PAVPixFmtDescriptor; cdecl;
{$ELSE API_Dynamic}
function av_pix_fmt_desc_next(const prev: PAVPixFmtDescriptor): PAVPixFmtDescriptor; cdecl; external AVUTIL_LIBNAME name _PU + 'av_pix_fmt_desc_next';
{$ENDIF API_Dynamic}


(**
 * @return an AVPixelFormat id described by desc, or AV_PIX_FMT_NONE if desc
 * is not a valid pointer to a pixel format descriptor.
 *)

{$IFDEF API_Dynamic}
var av_pix_fmt_desc_get_id : function(const desc: PAVPixFmtDescriptor): TAVPixelFormat; cdecl;
{$ELSE API_Dynamic}
function av_pix_fmt_desc_get_id(const desc: PAVPixFmtDescriptor): TAVPixelFormat; cdecl; external AVUTIL_LIBNAME name _PU + 'av_pix_fmt_desc_get_id';
{$ENDIF API_Dynamic}


(**
 * Utility function to access log2_chroma_w log2_chroma_h from
 * the pixel format AVPixFmtDescriptor.
 *
 * See av_get_chroma_sub_sample() for a function that asserts a
 * valid pixel format instead of returning an error code.
 * Its recommended that you use avcodec_get_chroma_sub_sample unless
 * you do check the return code!
 *
 * @param[in]  pix_fmt the pixel format
 * @param[out] h_shift store log2_chroma_w (horizontal/width shift)
 * @param[out] v_shift store log2_chroma_h (vertical/height shift)
 *
 * @return 0 on success, AVERROR(ENOSYS) on invalid or unknown pixel format
 *)

{$IFDEF API_Dynamic}
var av_pix_fmt_get_chroma_sub_sample : function(pix_fmt: TAVPixelFormat;
                                     h_shift, v_shift: PInteger): Integer; cdecl;
{$ELSE API_Dynamic}
function av_pix_fmt_get_chroma_sub_sample(pix_fmt: TAVPixelFormat;
                                     h_shift, v_shift: PInteger): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_pix_fmt_get_chroma_sub_sample';
{$ENDIF API_Dynamic}


(**
 * @return number of planes in pix_fmt, a negative AVERROR if pix_fmt is not a
 * valid pixel format.
 *)

{$IFDEF API_Dynamic}
var av_pix_fmt_count_planes : function(pix_fmt: TAVPixelFormat): Integer; cdecl;
{$ELSE API_Dynamic}
function av_pix_fmt_count_planes(pix_fmt: TAVPixelFormat): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_pix_fmt_count_planes';
{$ENDIF API_Dynamic}


(**
 * @return the name for provided color range or NULL if unknown.
 *)

{$IFDEF API_Dynamic}
var av_color_range_name : function(range: TAVColorRange): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_color_range_name(range: TAVColorRange): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_color_range_name';
{$ENDIF API_Dynamic}


(**
 * @return the AVColorRange value for name or an AVError if not found.
 *)

{$IFDEF API_Dynamic}
var av_color_range_from_name : function(const name: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_color_range_from_name(const name: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_color_range_from_name';
{$ENDIF API_Dynamic}


(**
 * @return the name for provided color primaries or NULL if unknown.
 *)

{$IFDEF API_Dynamic}
var av_color_primaries_name : function(primaries: TAVColorPrimaries): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_color_primaries_name(primaries: TAVColorPrimaries): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_color_primaries_name';
{$ENDIF API_Dynamic}


(**
 * @return the AVColorPrimaries value for name or an AVError if not found.
 *)

{$IFDEF API_Dynamic}
var av_color_primaries_from_name : function(const name: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_color_primaries_from_name(const name: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_color_primaries_from_name';
{$ENDIF API_Dynamic}


(**
 * @return the name for provided color transfer or NULL if unknown.
 *)

{$IFDEF API_Dynamic}
var av_color_transfer_name : function(transfer: TAVColorTransferCharacteristic): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_color_transfer_name(transfer: TAVColorTransferCharacteristic): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_color_transfer_name';
{$ENDIF API_Dynamic}


(**
 * @return the AVColorTransferCharacteristic value for name or an AVError if not found.
 *)

{$IFDEF API_Dynamic}
var av_color_transfer_from_name : function(const name: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_color_transfer_from_name(const name: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_color_transfer_from_name';
{$ENDIF API_Dynamic}


(**
 * @return the name for provided color space or NULL if unknown.
 *)

{$IFDEF API_Dynamic}
var av_color_space_name : function(space: TAVColorSpace): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_color_space_name(space: TAVColorSpace): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_color_space_name';
{$ENDIF API_Dynamic}


(**
 * @return the AVColorSpace value for name or an AVError if not found.
 *)

{$IFDEF API_Dynamic}
var av_color_space_from_name : function(const name: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_color_space_from_name(const name: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_color_space_from_name';
{$ENDIF API_Dynamic}


(**
 * @return the name for provided chroma location or NULL if unknown.
 *)

{$IFDEF API_Dynamic}
var av_chroma_location_name : function(location: TAVChromaLocation): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_chroma_location_name(location: TAVChromaLocation): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_chroma_location_name';
{$ENDIF API_Dynamic}


(**
 * @return the AVChromaLocation value for name or an AVError if not found.
 *)

{$IFDEF API_Dynamic}
var av_chroma_location_from_name : function(const name: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_chroma_location_from_name(const name: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_chroma_location_from_name';
{$ENDIF API_Dynamic}


(**
 * Return the pixel format corresponding to name.
 *
 * If there is no pixel format with name name, then looks for a
 * pixel format with the name corresponding to the native endian
 * format of name.
 * For example in a little-endian system, first looks for "gray16",
 * then for "gray16le".
 *
 * Finally if no pixel format has been found, returns AV_PIX_FMT_NONE.
 *)

{$IFDEF API_Dynamic}
var av_get_pix_fmt : function(const name: PAnsiChar): TAVPixelFormat; cdecl;
{$ELSE API_Dynamic}
function av_get_pix_fmt(const name: PAnsiChar): TAVPixelFormat; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_pix_fmt';
{$ENDIF API_Dynamic}


(**
 * Return the short name for a pixel format, NULL in case pix_fmt is
 * unknown.
 *
 * @see av_get_pix_fmt(), av_get_pix_fmt_string()
 *)

{$IFDEF API_Dynamic}
var av_get_pix_fmt_name : function(pix_fmt: TAVPixelFormat): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_pix_fmt_name(pix_fmt: TAVPixelFormat): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_pix_fmt_name';
{$ENDIF API_Dynamic}


(**
 * Print in buf the string corresponding to the pixel format with
 * number pix_fmt, or a header if pix_fmt is negative.
 *
 * @param buf the buffer where to write the string
 * @param buf_size the size of buf
 * @param pix_fmt the number of the pixel format to print the
 * corresponding info string, or a negative value to print the
 * corresponding header.
 *)

{$IFDEF API_Dynamic}
var av_get_pix_fmt_string : function(buf: PAnsiChar; buf_size: Integer;
                                        pix_fmt: TAVPixelFormat): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_pix_fmt_string(buf: PAnsiChar; buf_size: Integer;
                                        pix_fmt: TAVPixelFormat): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_pix_fmt_string';
{$ENDIF API_Dynamic}


(**
 * Read a line from an image, and write the values of the
 * pixel format component c to dst.
 *
 * @param data the array containing the pointers to the planes of the image
 * @param linesize the array containing the linesizes of the image
 * @param desc the pixel format descriptor for the image
 * @param x the horizontal coordinate of the first pixel to read
 * @param y the vertical coordinate of the first pixel to read
 * @param w the width of the line to read, that is the number of
 * values to write to dst
 * @param read_pal_component if not zero and the format is a paletted
 * format writes the values corresponding to the palette
 * component c in data[1] to dst, rather than the palette indexes in
 * data[0]. The behavior is undefined if the format is not paletted.
 *)
{ // TODO:
void av_read_image_line(uint16_t *dst, const uint8_t *data[4],
                        const int linesize[4], const AVPixFmtDescriptor *desc,
                        int x, int y, int c, int w, int read_pal_component);
}

(**
 * Write the values from src to the pixel format component c of an
 * image line.
 *
 * @param src array containing the values to write
 * @param data the array containing the pointers to the planes of the
 * image to write into. It is supposed to be zeroed.
 * @param linesize the array containing the linesizes of the image
 * @param desc the pixel format descriptor for the image
 * @param x the horizontal coordinate of the first pixel to write
 * @param y the vertical coordinate of the first pixel to write
 * @param w the width of the line to write, that is the number of
 * values to write to the image line
 *)
{ // TODO:
void av_write_image_line(const uint16_t *src, uint8_t *data[4],
                         const int linesize[4], const AVPixFmtDescriptor *desc,
                         int x, int y, int c, int w);
}

(**
 * Utility function to swap the endianness of a pixel format.
 *
 * @param[in]  pix_fmt the pixel format
 *
 * @return pixel format with swapped endianness if it exists,
 * otherwise AV_PIX_FMT_NONE
 *)

{$IFDEF API_Dynamic}
var av_pix_fmt_swap_endianness : function(pix_fmt: TAVPixelFormat): TAVPixelFormat; cdecl;
{$ELSE API_Dynamic}
function av_pix_fmt_swap_endianness(pix_fmt: TAVPixelFormat): TAVPixelFormat; cdecl; external AVUTIL_LIBNAME name _PU + 'av_pix_fmt_swap_endianness';
{$ENDIF API_Dynamic}


const
  FF_LOSS_RESOLUTION  = $0001; (**< loss due to resolution change *)
  FF_LOSS_DEPTH       = $0002; (**< loss due to color depth change *)
  FF_LOSS_COLORSPACE  = $0004; (**< loss due to color space conversion *)
  FF_LOSS_ALPHA       = $0008; (**< loss of alpha bits *)
  FF_LOSS_COLORQUANT  = $0010; (**< loss due to color quantization *)
  FF_LOSS_CHROMA      = $0020; (**< loss of chroma (e.g. RGB to gray conversion) *)

(**
 * Compute what kind of losses will occur when converting from one specific
 * pixel format to another.
 * When converting from one pixel format to another, information loss may occur.
 * For example, when converting from RGB24 to GRAY, the color information will
 * be lost. Similarly, other losses occur when converting from some formats to
 * other formats. These losses can involve loss of chroma, but also loss of
 * resolution, loss of color depth, loss due to the color space conversion, loss
 * of the alpha bits or loss due to color quantization.
 * av_get_fix_fmt_loss() informs you about the various types of losses
 * which will occur when converting from one pixel format to another.
 *
 * @param[in] dst_pix_fmt destination pixel format
 * @param[in] src_pix_fmt source pixel format
 * @param[in] has_alpha Whether the source pixel format alpha channel is used.
 * @return Combination of flags informing you what kind of losses will occur
 * (maximum loss for an invalid dst_pix_fmt).
 *)

{$IFDEF API_Dynamic}
var av_get_pix_fmt_loss : function(dst_pix_fmt, src_pix_fmt: TAVPixelFormat;
                        has_alpha: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_pix_fmt_loss(dst_pix_fmt, src_pix_fmt: TAVPixelFormat;
                        has_alpha: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_pix_fmt_loss';
{$ENDIF API_Dynamic}


(**
 * Compute what kind of losses will occur when converting from one specific
 * pixel format to another.
 * When converting from one pixel format to another, information loss may occur.
 * For example, when converting from RGB24 to GRAY, the color information will
 * be lost. Similarly, other losses occur when converting from some formats to
 * other formats. These losses can involve loss of chroma, but also loss of
 * resolution, loss of color depth, loss due to the color space conversion, loss
 * of the alpha bits or loss due to color quantization.
 * av_get_fix_fmt_loss() informs you about the various types of losses
 * which will occur when converting from one pixel format to another.
 *
 * @param[in] dst_pix_fmt destination pixel format
 * @param[in] src_pix_fmt source pixel format
 * @param[in] has_alpha Whether the source pixel format alpha channel is used.
 * @return Combination of flags informing you what kind of losses will occur
 * (maximum loss for an invalid dst_pix_fmt).
 *)

{$IFDEF API_Dynamic}
var av_find_best_pix_fmt_of_2 : function(dst_pix_fmt1, dst_pix_fmt2, src_pix_fmt: TAVPixelFormat;
                        has_alpha: Integer; loss_ptr: PInteger): TAVPixelFormat; cdecl;
{$ELSE API_Dynamic}
function av_find_best_pix_fmt_of_2(dst_pix_fmt1, dst_pix_fmt2, src_pix_fmt: TAVPixelFormat;
                        has_alpha: Integer; loss_ptr: PInteger): TAVPixelFormat; cdecl; external AVUTIL_LIBNAME name _PU + 'av_find_best_pix_fmt_of_2';
{$ENDIF API_Dynamic}



(* ****************************************************** *)
(* import libavutil_mathematics *)
(* ****************************************************** *)






const
  M_E            = 2.7182818284590452354;   (* e *)
  {$EXTERNALSYM M_E}
  M_LN2          = 0.69314718055994530942;  (* log_e 2 *)
  {$EXTERNALSYM M_LN2}
  M_LN10         = 2.30258509299404568402;  (* log_e 10 *)
  {$EXTERNALSYM M_LN10}
  M_LOG2_10      = 3.32192809488736234787;  (* log_2 10 *)
  {$EXTERNALSYM M_PHI}
  M_PHI          = 1.61803398874989484820;  (* phi / golden ratio *)
  {$EXTERNALSYM M_LOG2_10}
  M_PI           = 3.14159265358979323846;  (* pi *)
  {$EXTERNALSYM M_PI}
  M_PI_2         = 1.57079632679489661923;  (* pi/2 *)
  {$EXTERNALSYM M_PI_2}
  M_SQRT1_2      = 0.70710678118654752440;  (* 1/sqrt(2) *)
  {$EXTERNALSYM M_SQRT1_2}
  M_SQRT2        = 1.41421356237309504880;  (* sqrt(2) *)
  {$EXTERNALSYM M_SQRT2}
//#ifndef NAN
//#define NAN            av_int2float(0x7fc00000)
//#endif
//#ifndef INFINITY
//#define INFINITY       av_int2float(0x7f800000)
//#endif

(**
 * @addtogroup lavu_math
 *
 * @{
 *)

(**
 * Rounding methods.
 *)
type
  TAVRounding = (
    AV_ROUND_ZERO     = 0, ///< Round toward zero
    AV_ROUND_INF      = 1, ///< Round away from zero
    AV_ROUND_DOWN     = 2, ///< Round toward -infinity
    AV_ROUND_UP       = 3, ///< Round toward +infinity
    AV_ROUND_NEAR_INF = 5, ///< Round to nearest and halfway cases away from zero
    (**
     * Flag telling rescaling functions to pass `INT64_MIN`/`MAX` through
     * unchanged, avoiding special cases for #AV_NOPTS_VALUE.
     *
     * Unlike other values of the enumeration AVRounding, this value is a
     * bitmask that must be used in conjunction with another value of the
     * enumeration through a bitwise OR, in order to set behavior for normal
     * cases.
     *
     * @code{.c}
     * av_rescale_rnd(3, 1, 2, AV_ROUND_UP | AV_ROUND_PASS_MINMAX);
     * // Rescaling 3:
     * //     Calculating 3 * 1 / 2
     * //     3 / 2 is rounded up to 2
     * //     => 2
     *
     * av_rescale_rnd(AV_NOPTS_VALUE, 1, 2, AV_ROUND_UP | AV_ROUND_PASS_MINMAX);
     * // Rescaling AV_NOPTS_VALUE:
     * //     AV_NOPTS_VALUE == INT64_MIN
     * //     AV_NOPTS_VALUE is passed through
     * //     => AV_NOPTS_VALUE
     * @endcode
     *)
    AV_ROUND_PASS_MINMAX = 8192
  );

(**
 * Compute the greatest common divisor of two integer operands.
 *
 * @param a,b Operands
 * @return GCD of a and b up to sign; if a >= 0 and b >= 0, return value is >= 0;
 * if a == 0 and b == 0, returns 0.
 *)

{$IFDEF API_Dynamic}
var av_gcd : function(a, b: Int64): Int64; cdecl;
{$ELSE API_Dynamic}
function av_gcd(a, b: Int64): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_gcd';
{$ENDIF API_Dynamic}


(**
 * Rescale a 64-bit integer with rounding to nearest.
 *
 * The operation is mathematically equivalent to `a * b / c`, but writing that
 * directly can overflow.
 *
 * This function is equivalent to av_rescale_rnd() with #AV_ROUND_NEAR_INF.
 *
 * @see av_rescale_rnd(), av_rescale_q(), av_rescale_q_rnd()
 *)

{$IFDEF API_Dynamic}
var av_rescale : function(a, b, c: Int64): Int64; cdecl;
{$ELSE API_Dynamic}
function av_rescale(a, b, c: Int64): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_rescale';
{$ENDIF API_Dynamic}


(**
 * Rescale a 64-bit integer with specified rounding.
 *
 * The operation is mathematically equivalent to `a * b / c`, but writing that
 * directly can overflow, and does not support different rounding methods.
 *
 * @see av_rescale(), av_rescale_q(), av_rescale_q_rnd()
 *)

{$IFDEF API_Dynamic}
var av_rescale_rnd : function(a, b, c: Int64; rnd: TAVRounding): Int64; cdecl;
{$ELSE API_Dynamic}
function av_rescale_rnd(a, b, c: Int64; rnd: TAVRounding): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_rescale_rnd';
{$ENDIF API_Dynamic}


(**
 * Rescale a 64-bit integer by 2 rational numbers.
 *
 * The operation is mathematically equivalent to `a * bq / cq`.
 *
 * This function is equivalent to av_rescale_q_rnd() with #AV_ROUND_NEAR_INF.
 *
 * @see av_rescale(), av_rescale_rnd(), av_rescale_q_rnd()
 *)

{$IFDEF API_Dynamic}
var av_rescale_q : function(a: Int64; bq, cq: TAVRational): Int64; cdecl;
{$ELSE API_Dynamic}
function av_rescale_q(a: Int64; bq, cq: TAVRational): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_rescale_q';
{$ENDIF API_Dynamic}


(**
 * Rescale a 64-bit integer by 2 rational numbers with specified rounding.
 *
 * The operation is mathematically equivalent to `a * bq / cq`.
 *
 * @see av_rescale(), av_rescale_rnd(), av_rescale_q()
 *)

{$IFDEF API_Dynamic}
var av_rescale_q_rnd : function(a: Int64; bq, cq: TAVRational;
                            rnd: Integer{TAVRounding}): Int64; cdecl;
{$ELSE API_Dynamic}
function av_rescale_q_rnd(a: Int64; bq, cq: TAVRational;
                            rnd: Integer{TAVRounding}): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_rescale_q_rnd';
{$ENDIF API_Dynamic}


(**
 * Compare two timestamps each in its own time base.
 *
 * @return One of the following values:
 *         - -1 if `ts_a` is before `ts_b`
 *         - 1 if `ts_a` is after `ts_b`
 *         - 0 if they represent the same position
 *
 * @warning
 * The result of the function is undefined if one of the timestamps is outside
 * the `int64_t` range when represented in the other's timebase.
 *)

{$IFDEF API_Dynamic}
var av_compare_ts : function(ts_a: Int64; tb_a: TAVRational; ts_b: Int64; tb_b: TAVRational): Integer; cdecl;
{$ELSE API_Dynamic}
function av_compare_ts(ts_a: Int64; tb_a: TAVRational; ts_b: Int64; tb_b: TAVRational): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_compare_ts';
{$ENDIF API_Dynamic}


(**
 * Compare the remainders of two integer operands divided by a common divisor.
 *
 * In other words, compare the least significant `log2(mod)` bits of integers
 * `a` and `b`.
 *
 * @code{.c}
 * av_compare_mod(0x11, 0x02, 0x10) < 0 // since 0x11 % 0x10  (0x1) < 0x02 % 0x10  (0x2)
 * av_compare_mod(0x11, 0x02, 0x20) > 0 // since 0x11 % 0x20 (0x11) > 0x02 % 0x20 (0x02)
 * @endcode
 *
 * @param a,b Operands
 * @param mod Divisor; must be a power of 2
 * @return
 *         - a negative value if `a % mod < b % mod`
 *         - a positive value if `a % mod > b % mod`
 *         - zero             if `a % mod == b % mod`
 *)

{$IFDEF API_Dynamic}
var av_compare_mod : function(a, b, mod_: Int64): Int64; cdecl;
{$ELSE API_Dynamic}
function av_compare_mod(a, b, mod_: Int64): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_compare_mod';
{$ENDIF API_Dynamic}


(**
 * Rescale a timestamp while preserving known durations.
 *
 * This function is designed to be called per audio packet to scale the input
 * timestamp to a different time base. Compared to a simple av_rescale_q()
 * call, this function is robust against possible inconsistent frame durations.
 *
 * The `last` parameter is a state variable that must be preserved for all
 * subsequent calls for the same stream. For the first call, `*last` should be
 * initialized to #AV_NOPTS_VALUE.
 *
 * @param[in]     in_tb    Input time base
 * @param[in]     in_ts    Input timestamp
 * @param[in]     fs_tb    Duration time base; typically this is finer-grained
 *                         (greater) than `in_tb` and `out_tb`
 * @param[in]     duration Duration till the next call to this function (i.e.
 *                         duration of the current packet/frame)
 * @param[in,out] last     Pointer to a timestamp expressed in terms of
 *                         `fs_tb`, acting as a state variable
 * @param[in]     out_tb   Output timebase
 * @return        Timestamp expressed in terms of `out_tb`
 *
 * @note In the context of this function, "duration" is in term of samples, not
 *       seconds.
 *)

{$IFDEF API_Dynamic}
var av_rescale_delta : function(in_tb: TAVRational; in_ts: Int64; fs_tb: TAVRational; duration: Integer; last: PInt64; out_tb: TAVRational): Int64; cdecl;
{$ELSE API_Dynamic}
function av_rescale_delta(in_tb: TAVRational; in_ts: Int64; fs_tb: TAVRational; duration: Integer; last: PInt64; out_tb: TAVRational): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_rescale_delta';
{$ENDIF API_Dynamic}


(**
 * Add a value to a timestamp.
 *
 * This function guarantees that when the same value is repeatly added that
 * no accumulation of rounding errors occurs.
 *
 * @param[in] ts     Input timestamp
 * @param[in] ts_tb  Input timestamp time base
 * @param[in] inc    Value to be added
 * @param[in] inc_tb Time base of `inc`
 *)

{$IFDEF API_Dynamic}
var av_add_stable : function(ts_tb: TAVRational; ts: Int64; inc_tb: TAVRational; incr: TAVRational): Int64; cdecl;
{$ELSE API_Dynamic}
function av_add_stable(ts_tb: TAVRational; ts: Int64; inc_tb: TAVRational; incr: TAVRational): Int64; cdecl; external AVUTIL_LIBNAME name _PU + 'av_add_stable';
{$ENDIF API_Dynamic}



(**
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_md5 *)
(* ****************************************************** *)






(**
 * @defgroup lavu_md5 MD5
 * @ingroup lavu_hash
 * MD5 hash function implementation.
 *
 * @{
 *)

//extern const int av_md5_size;

type
  PAVMD5 = ^TAVMD5;
  TAVMD5 = record
    // need {$ALIGN 8}
    // defined in libavutil/md5.c
  end;

(**
 * Allocate an AVMD5 context.
 *)

{$IFDEF API_Dynamic}
var av_md5_alloc : function(): PAVMD5; cdecl;
{$ELSE API_Dynamic}
function av_md5_alloc(): PAVMD5; cdecl; external AVUTIL_LIBNAME name _PU + 'av_md5_alloc';
{$ENDIF API_Dynamic}


(**
 * Initialize MD5 hashing.
 *
 * @param ctx pointer to the function context (of size av_md5_size)
 *)

{$IFDEF API_Dynamic}
var av_md5_init : procedure(ctx: PAVMD5); cdecl;
{$ELSE API_Dynamic}
procedure av_md5_init(ctx: PAVMD5); cdecl; external AVUTIL_LIBNAME name _PU + 'av_md5_init';
{$ENDIF API_Dynamic}


(**
 * Update hash value.
 *
 * @param ctx hash function context
 * @param src input data to update hash with
 * @param len input data length
 *)
{$IFDEF FF_API_CRYPTO_SIZE_T}

{$IFDEF API_Dynamic}
var av_md5_update : procedure(ctx: PAVMD5; const src: PByte; len: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_md5_update(ctx: PAVMD5; const src: PByte; len: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_md5_update';
{$ENDIF API_Dynamic}

{$ELSE}

{$IFDEF API_Dynamic}
var av_md5_update : procedure(ctx: PAVMD5; const src: PByte; len: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_md5_update(ctx: PAVMD5; const src: PByte; len: Cardinal); cdecl; external AVUTIL_LIBNAME name _PU + 'av_md5_update';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * Finish hashing and output digest value.
 *
 * @param ctx hash function context
 * @param dst buffer where output digest value is stored
 *)

{$IFDEF API_Dynamic}
var av_md5_final : procedure(ctx: PAVMD5; dst: PByte); cdecl;
{$ELSE API_Dynamic}
procedure av_md5_final(ctx: PAVMD5; dst: PByte); cdecl; external AVUTIL_LIBNAME name _PU + 'av_md5_final';
{$ENDIF API_Dynamic}


(**
 * Hash an array of data.
 *
 * @param dst The output buffer to write the digest into
 * @param src The data to hash
 * @param len The length of the data, in bytes
 *)
{$IFDEF FF_API_CRYPTO_SIZE_T}

{$IFDEF API_Dynamic}
var av_md5_sum : procedure(dst: PByte; const src: PByte; const len: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_md5_sum(dst: PByte; const src: PByte; const len: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_md5_sum';
{$ENDIF API_Dynamic}

{$ELSE}

{$IFDEF API_Dynamic}
var av_md5_sum : procedure(dst: PByte; const src: PByte; len: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_md5_sum(dst: PByte; const src: PByte; len: Cardinal); cdecl; external AVUTIL_LIBNAME name _PU + 'av_md5_sum';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * @}
 *)


(* ****************************************************** *)
(* import libavutil_mem *)
(* ****************************************************** *)




{$IF Defined(BCB)}
{$IFEND}



(**
 * @addtogroup lavu_mem
 * Utilities for manipulating memory.
 *
 * FFmpeg has several applications of memory that are not required of a typical
 * program. For example, the computing-heavy components like video decoding and
 * encoding can be sped up significantly through the use of aligned memory.
 *
 * However, for each of FFmpeg's applications of memory, there might not be a
 * recognized or standardized API for that specific use. Memory alignment, for
 * instance, varies wildly depending on operating systems, architectures, and
 * compilers. Hence, this component of @ref libavutil is created to make
 * dealing with memory consistently possible on all platforms.
 *
 * @{
 *
 * @defgroup lavu_mem_macros Alignment Macros
 * Helper macros for declaring aligned variables.
 * @{
 *)

(**
 * @def DECLARE_ALIGNED(n,t,v)
 * Declare a variable that is aligned in memory.
 *
 * @code{.c}
 * DECLARE_ALIGNED(16, uint16_t, aligned_int) = 42;
 * DECLARE_ALIGNED(32, uint8_t, aligned_array)[128];
 *
 * // The default-alignment equivalent would be
 * uint16_t aligned_int = 42;
 * uint8_t aligned_array[128];
 * @endcode
 *
 * @param n Minimum alignment in bytes
 * @param t Type of the variable (or array element)
 * @param v Name of the variable
 *)

(**
 * @def DECLARE_ASM_CONST(n,t,v)
 * Declare a static constant aligned variable appropriate for use in inline
 * assembly code.
 *
 * @code{.c}
 * DECLARE_ASM_CONST(16, uint64_t, pw_08) = UINT64_C(0x0008000800080008);
 * @endcode
 *
 * @param n Minimum alignment in bytes
 * @param t Type of the variable (or array element)
 * @param v Name of the variable
 *)

(*
#if defined(__INTEL_COMPILER) && __INTEL_COMPILER < 1110 || defined(__SUNPRO_C)
    #define DECLARE_ALIGNED(n,t,v)      t __attribute__ ((aligned (n))) v
    #define DECLARE_ASM_CONST(n,t,v)    const t __attribute__ ((aligned (n))) v
#elif defined(__TI_COMPILER_VERSION__)
    #define DECLARE_ALIGNED(n,t,v)                      \
        AV_PRAGMA(DATA_ALIGN(v,n))                      \
        t __attribute__((aligned(n))) v
    #define DECLARE_ASM_CONST(n,t,v)                    \
        AV_PRAGMA(DATA_ALIGN(v,n))                      \
        static const t __attribute__((aligned(n))) v
#elif defined(__DJGPP__)
    #define DECLARE_ALIGNED(n,t,v)      t __attribute__ ((aligned (FFMIN(n, 16)))) v
    #define DECLARE_ASM_CONST(n,t,v)    static const t av_used __attribute__ ((aligned (FFMIN(n, 16)))) v
#elif defined(__GNUC__) || defined(__clang__)
    #define DECLARE_ALIGNED(n,t,v)      t __attribute__ ((aligned (n))) v
    #define DECLARE_ASM_CONST(n,t,v)    static const t av_used __attribute__ ((aligned (n))) v
#elif defined(_MSC_VER)
    #define DECLARE_ALIGNED(n,t,v)      __declspec(align(n)) t v
    #define DECLARE_ASM_CONST(n,t,v)    __declspec(align(n)) static const t v
#else
    #define DECLARE_ALIGNED(n,t,v)      t v
    #define DECLARE_ASM_CONST(n,t,v)    static const t v
#endif
*)

(**
 * @}
 *)

(**
 * @defgroup lavu_mem_attrs Function Attributes
 * Function attributes applicable to memory handling functions.
 *
 * These function attributes can help compilers emit more useful warnings, or
 * generate better code.
 * @{
 *)

(**
 * @def av_malloc_attrib
 * Function attribute denoting a malloc-like function.
 *
 * @see <a href="https://gcc.gnu.org/onlinedocs/gcc/Common-Function-Attributes.html#index-g_t_0040code_007bmalloc_007d-function-attribute-3251">Function attribute `malloc` in GCC's documentation</a>
 *)

(*
#if AV_GCC_VERSION_AT_LEAST(3,1)
    #define av_malloc_attrib __attribute__((__malloc__))
#else
    #define av_malloc_attrib
#endif
*)

(**
 * @def av_alloc_size(...)
 * Function attribute used on a function that allocates memory, whose size is
 * given by the specified parameter(s).
 *
 * @code{.c}
 * void *av_malloc(size_t size) av_alloc_size(1);
 * void *av_calloc(size_t nmemb, size_t size) av_alloc_size(1, 2);
 * @endcode
 *
 * @param ... One or two parameter indexes, separated by a comma
 *
 * @see <a href="https://gcc.gnu.org/onlinedocs/gcc/Common-Function-Attributes.html#index-g_t_0040code_007balloc_005fsize_007d-function-attribute-3220">Function attribute `alloc_size` in GCC's documentation</a>
 *)

(*
#if AV_GCC_VERSION_AT_LEAST(4,3)
    #define av_alloc_size(...) __attribute__((alloc_size(__VA_ARGS__)))
#else
    #define av_alloc_size(...)
#endif
*)

(**
 * @}
 *)

(**
 * @defgroup lavu_mem_funcs Heap Management
 * Functions responsible for allocating, freeing, and copying memory.
 *
 * All memory allocation functions have a built-in upper limit of `INT_MAX`
 * bytes. This may be changed with av_max_alloc(), although exercise extreme
 * caution when doing so.
 *
 * @{
 *)

(**
 * Allocate a memory block with alignment suitable for all memory accesses
 * (including vectors if available on the CPU).
 *
 * @param size Size in bytes for the memory block to be allocated
 * @return Pointer to the allocated block, or `NULL` if the block cannot
 *         be allocated
 * @see av_mallocz()
 *)

{$IFDEF API_Dynamic}
var av_malloc : function(size: Cardinal): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_malloc(size: Cardinal): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_malloc';
{$ENDIF API_Dynamic}


(**
 * Allocate a memory block with alignment suitable for all memory accesses
 * (including vectors if available on the CPU) and zero all the bytes of the
 * block.
 *
 * @param size Size in bytes for the memory block to be allocated
 * @return Pointer to the allocated block, or `NULL` if it cannot be allocated
 * @see av_malloc()
 *)

{$IFDEF API_Dynamic}
var av_mallocz : function(size: Cardinal): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_mallocz(size: Cardinal): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_mallocz';
{$ENDIF API_Dynamic}


(**
 * Allocate a memory block for an array with av_malloc().
 *
 * The allocated memory will have size `size * nmemb` bytes.
 *
 * @param nmemb Number of element
 * @param size  Size of a single element
 * @return Pointer to the allocated block, or `NULL` if the block cannot
 *         be allocated
 * @see av_malloc()
 *)
(*
av_alloc_size(1, 2) static inline void *av_malloc_array(size_t nmemb, size_t size)
{
    if (size <= 0 || nmemb >= INT_MAX / size)
        return NULL;
    return av_malloc(nmemb * size);
}
*)

(**
 * Allocate a memory block for an array with av_mallocz().
 *
 * The allocated memory will have size `size * nmemb` bytes.
 *
 * @param nmemb Number of elements
 * @param size  Size of the single element
 * @return Pointer to the allocated block, or `NULL` if the block cannot
 *         be allocated
 *
 * @see av_mallocz()
 * @see av_malloc_array()
 *)
(*
av_alloc_size(1, 2) static inline void *av_mallocz_array(size_t nmemb, size_t size)
{
    if (!size || nmemb >= INT_MAX / size)
        return NULL;
    return av_mallocz(nmemb * size);
}
*)

(**
 * Non-inlined equivalent of av_mallocz_array().
 *
 * Created for symmetry with the calloc() C function.
 *)

{$IFDEF API_Dynamic}
var av_calloc : function(nmemb, size: Cardinal): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_calloc(nmemb, size: Cardinal): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_calloc';
{$ENDIF API_Dynamic}


(**
 * Allocate, reallocate, or free a block of memory.
 *
 * If `ptr` is `NULL` and `size` > 0, allocate a new block. If `size` is
 * zero, free the memory block pointed to by `ptr`. Otherwise, expand or
 * shrink that block of memory according to `size`.
 *
 * @param ptr  Pointer to a memory block already allocated with
 *             av_realloc() or `NULL`
 * @param size Size in bytes of the memory block to be allocated or
 *             reallocated
 *
 * @return Pointer to a newly-reallocated block or `NULL` if the block
 *         cannot be reallocated or the function is used to free the memory block
 *
 * @warning Unlike av_malloc(), the returned pointer is not guaranteed to be
 *          correctly aligned.
 * @see av_fast_realloc()
 * @see av_reallocp()
 *)

{$IFDEF API_Dynamic}
var av_realloc : function(ptr: Pointer; size: Cardinal): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_realloc(ptr: Pointer; size: Cardinal): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_realloc';
{$ENDIF API_Dynamic}


(**
 * Allocate, reallocate, or free a block of memory through a pointer to a
 * pointer.
 *
 * If `*ptr` is `NULL` and `size` > 0, allocate a new block. If `size` is
 * zero, free the memory block pointed to by `*ptr`. Otherwise, expand or
 * shrink that block of memory according to `size`.
 *
 * @param[in,out] ptr  Pointer to a pointer to a memory block already allocated
 *                     with av_realloc(), or a pointer to `NULL`. The pointer
 *                     is updated on success, or freed on failure.
 * @param[in]     size Size in bytes for the memory block to be allocated or
 *                     reallocated
 *
 * @return Zero on success, an AVERROR error code on failure
 *
 * @warning Unlike av_malloc(), the allocated memory is not guaranteed to be
 *          correctly aligned.
 *)

{$IFDEF API_Dynamic}
var av_reallocp : function(ptr: Pointer; size: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function av_reallocp(ptr: Pointer; size: Cardinal): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_reallocp';
{$ENDIF API_Dynamic}


(**
 * Allocate, reallocate, or free a block of memory.
 *
 * This function does the same thing as av_realloc(), except:
 * - It takes two size arguments and allocates `nelem * elsize` bytes,
 *   after checking the result of the multiplication for integer overflow.
 * - It frees the input block in case of failure, thus avoiding the memory
 *   leak with the classic
 *   @code{.c}
 *   buf = realloc(buf);
 *   if (!buf)
 *       return -1;
 *   @endcode
 *   pattern.
 *)

{$IFDEF API_Dynamic}
var av_realloc_f : function(ptr: Pointer; nelem, elsize: Cardinal): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_realloc_f(ptr: Pointer; nelem, elsize: Cardinal): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_realloc_f';
{$ENDIF API_Dynamic}


(**
 * Allocate, reallocate, or free an array.
 *
 * If `ptr` is `NULL` and `nmemb` > 0, allocate a new block. If
 * `nmemb` is zero, free the memory block pointed to by `ptr`.
 *
 * @param ptr   Pointer to a memory block already allocated with
 *              av_realloc() or `NULL`
 * @param nmemb Number of elements in the array
 * @param size  Size of the single element of the array
 *
 * @return Pointer to a newly-reallocated block or NULL if the block
 *         cannot be reallocated or the function is used to free the memory block
 *
 * @warning Unlike av_malloc(), the allocated memory is not guaranteed to be
 *          correctly aligned.
 * @see av_reallocp_array()
 *)

{$IFDEF API_Dynamic}
var av_realloc_array : function(ptr: Pointer; nmemb, size: Cardinal): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_realloc_array(ptr: Pointer; nmemb, size: Cardinal): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_realloc_array';
{$ENDIF API_Dynamic}


(**
 * Allocate, reallocate, or free an array through a pointer to a pointer.
 *
 * If `*ptr` is `NULL` and `nmemb` > 0, allocate a new block. If `nmemb` is
 * zero, free the memory block pointed to by `*ptr`.
 *
 * @param[in,out] ptr   Pointer to a pointer to a memory block already
 *                      allocated with av_realloc(), or a pointer to `NULL`.
 *                      The pointer is updated on success, or freed on failure.
 * @param[in]     nmemb Number of elements
 * @param[in]     size  Size of the single element
 *
 * @return Zero on success, an AVERROR error code on failure
 *
 * @warning Unlike av_malloc(), the allocated memory is not guaranteed to be
 *          correctly aligned.
 *)

{$IFDEF API_Dynamic}
var av_reallocp_array : function(ptr: Pointer; nmemb, size: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function av_reallocp_array(ptr: Pointer; nmemb, size: Cardinal): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_reallocp_array';
{$ENDIF API_Dynamic}


(**
 * Reallocate the given buffer if it is not large enough, otherwise do nothing.
 *
 * If the given buffer is `NULL`, then a new uninitialized buffer is allocated.
 *
 * If the given buffer is not large enough, and reallocation fails, `NULL` is
 * returned and `*size` is set to 0, but the original buffer is not changed or
 * freed.
 *
 * A typical use pattern follows:
 *
 * @code{.c}
 * uint8_t *buf = ...;
 * uint8_t *new_buf = av_fast_realloc(buf, &current_size, size_needed);
 * if (!new_buf) {
 *     // Allocation failed; clean up original buffer
 *     av_freep(&buf);
 *     return AVERROR(ENOMEM);
 * }
 * @endcode
 *
 * @param[in,out] ptr      Already allocated buffer, or `NULL`
 * @param[in,out] size     Pointer to current size of buffer `ptr`. `*size` is
 *                         changed to `min_size` in case of success or 0 in
 *                         case of failure
 * @param[in]     min_size New size of buffer `ptr`
 * @return `ptr` if the buffer is large enough, a pointer to newly reallocated
 *         buffer if the buffer was not large enough, or `NULL` in case of
 *         error
 * @see av_realloc()
 * @see av_fast_malloc()
 *)

{$IFDEF API_Dynamic}
var av_fast_realloc : function(ptr: Pointer; size: PCardinal; min_size: Cardinal): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_fast_realloc(ptr: Pointer; size: PCardinal; min_size: Cardinal): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_fast_realloc';
{$ENDIF API_Dynamic}


(**
 * Allocate a buffer, reusing the given one if large enough.
 *
 * Contrary to av_fast_realloc(), the current buffer contents might not be
 * preserved and on error the old buffer is freed, thus no special handling to
 * avoid memleaks is necessary.
 *
 * `*ptr` is allowed to be `NULL`, in which case allocation always happens if
 * `size_needed` is greater than 0.
 *
 * @code{.c}
 * uint8_t *buf = ...;
 * av_fast_malloc(&buf, &current_size, size_needed);
 * if (!buf) {
 *     // Allocation failed; buf already freed
 *     return AVERROR(ENOMEM);
 * }
 * @endcode
 *
 * @param[in,out] ptr      Pointer to pointer to an already allocated buffer.
 *                         `*ptr` will be overwritten with pointer to new
 *                         buffer on success or `NULL` on failure
 * @param[in,out] size     Pointer to current size of buffer `*ptr`. `*size` is
 *                         changed to `min_size` in case of success or 0 in
 *                         case of failure
 * @param[in]     min_size New size of buffer `*ptr`
 * @see av_realloc()
 * @see av_fast_mallocz()
 *)

{$IFDEF API_Dynamic}
var av_fast_malloc : procedure(ptr: Pointer; size: PCardinal; min_size: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_fast_malloc(ptr: Pointer; size: PCardinal; min_size: Cardinal); cdecl; external AVUTIL_LIBNAME name _PU + 'av_fast_malloc';
{$ENDIF API_Dynamic}


(**
 * Allocate and clear a buffer, reusing the given one if large enough.
 *
 * Like av_fast_malloc(), but all newly allocated space is initially cleared.
 * Reused buffer is not cleared.
 *
 * `*ptr` is allowed to be `NULL`, in which case allocation always happens if
 * `size_needed` is greater than 0.
 *
 * @param[in,out] ptr      Pointer to pointer to an already allocated buffer.
 *                         `*ptr` will be overwritten with pointer to new
 *                         buffer on success or `NULL` on failure
 * @param[in,out] size     Pointer to current size of buffer `*ptr`. `*size` is
 *                         changed to `min_size` in case of success or 0 in
 *                         case of failure
 * @param[in]     min_size New size of buffer `*ptr`
 * @see av_fast_malloc()
 *)

{$IFDEF API_Dynamic}
var av_fast_mallocz : procedure(ptr: Pointer; size: PCardinal; min_size: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_fast_mallocz(ptr: Pointer; size: PCardinal; min_size: Cardinal); cdecl; external AVUTIL_LIBNAME name _PU + 'av_fast_mallocz';
{$ENDIF API_Dynamic}


(**
 * Free a memory block which has been allocated with a function of av_malloc()
 * or av_realloc() family.
 *
 * @param ptr Pointer to the memory block which should be freed.
 *
 * @note `ptr = NULL` is explicitly allowed.
 * @note It is recommended that you use av_freep() instead, to prevent leaving
 *       behind dangling pointers.
 * @see av_freep()
 *)

{$IFDEF API_Dynamic}
var av_free : procedure(ptr: Pointer); cdecl;
{$ELSE API_Dynamic}
procedure av_free(ptr: Pointer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_free';
{$ENDIF API_Dynamic}


(**
 * Free a memory block which has been allocated with a function of av_malloc()
 * or av_realloc() family, and set the pointer pointing to it to `NULL`.
 *
 * @code{.c}
 * uint8_t *buf = av_malloc(16);
 * av_free(buf);
 * // buf now contains a dangling pointer to freed memory, and accidental
 * // dereference of buf will result in a use-after-free, which may be a
 * // security risk.
 *
 * uint8_t *buf = av_malloc(16);
 * av_freep(&buf);
 * // buf is now NULL, and accidental dereference will only result in a
 * // NULL-pointer dereference.
 * @endcode
 *
 * @param ptr Pointer to the pointer to the memory block which should be freed
 * @note `*ptr = NULL` is safe and leads to no action.
 * @see av_free()
 *)

{$IFDEF API_Dynamic}
var av_freep : procedure(ptr: Pointer); cdecl;
{$ELSE API_Dynamic}
procedure av_freep(ptr: Pointer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_freep';
{$ENDIF API_Dynamic}


(**
 * Duplicate a string.
 *
 * @param s String to be duplicated
 * @return Pointer to a newly-allocated string containing a
 *         copy of `s` or `NULL` if the string cannot be allocated
 * @see av_strndup()
 *)

{$IFDEF API_Dynamic}
var av_strdup : function(const s: PAnsiChar): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_strdup(const s: PAnsiChar): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strdup';
{$ENDIF API_Dynamic}


(**
 * Duplicate a substring of a string.
 *
 * @param s   String to be duplicated
 * @param len Maximum length of the resulting string (not counting the
 *            terminating byte)
 * @return Pointer to a newly-allocated string containing a
 *         substring of `s` or `NULL` if the string cannot be allocated
 *)

{$IFDEF API_Dynamic}
var av_strndup : function(const s: PAnsiChar; len: Cardinal): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_strndup(const s: PAnsiChar; len: Cardinal): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_strndup';
{$ENDIF API_Dynamic}


(**
 * Duplicate a buffer with av_malloc().
 *
 * @param p    Buffer to be duplicated
 * @param size Size in bytes of the buffer copied
 * @return Pointer to a newly allocated buffer containing a
 *         copy of `p` or `NULL` if the buffer cannot be allocated
 *)

{$IFDEF API_Dynamic}
var av_memdup : function(const p: Pointer; size: Cardinal): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_memdup(const p: Pointer; size: Cardinal): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_memdup';
{$ENDIF API_Dynamic}


(**
 * Overlapping memcpy() implementation.
 *
 * @param dst  Destination buffer
 * @param back Number of bytes back to start copying (i.e. the initial size of
 *             the overlapping window); must be > 0
 * @param cnt  Number of bytes to copy; must be >= 0
 *
 * @note `cnt > back` is valid, this will copy the bytes we just copied,
 *       thus creating a repeating pattern with a period length of `back`.
 *)

{$IFDEF API_Dynamic}
var av_memcpy_backptr : procedure(dst: PByte; back, cnt: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_memcpy_backptr(dst: PByte; back, cnt: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_memcpy_backptr';
{$ENDIF API_Dynamic}


(**
 * @}
 *)

(**
 * @defgroup lavu_mem_dynarray Dynamic Array
 *
 * Utilities to make an array grow when needed.
 *
 * Sometimes, the programmer would want to have an array that can grow when
 * needed. The libavutil dynamic array utilities fill that need.
 *
 * libavutil supports two systems of appending elements onto a dynamically
 * allocated array, the first one storing the pointer to the value in the
 * array, and the second storing the value directly. In both systems, the
 * caller is responsible for maintaining a variable containing the length of
 * the array, as well as freeing of the array after use.
 *
 * The first system stores pointers to values in a block of dynamically
 * allocated memory. Since only pointers are stored, the function does not need
 * to know the size of the type. Both av_dynarray_add() and
 * av_dynarray_add_nofree() implement this system.
 *
 * @code
 * type **array = NULL; //< an array of pointers to values
 * int    nb    = 0;    //< a variable to keep track of the length of the array
 *
 * type to_be_added  = ...;
 * type to_be_added2 = ...;
 *
 * av_dynarray_add(&array, &nb, &to_be_added);
 * if (nb == 0)
 *     return AVERROR(ENOMEM);
 *
 * av_dynarray_add(&array, &nb, &to_be_added2);
 * if (nb == 0)
 *     return AVERROR(ENOMEM);
 *
 * // Now:
 * //  nb           == 2
 * // &to_be_added  == array[0]
 * // &to_be_added2 == array[1]
 *
 * av_freep(&array);
 * @endcode
 *
 * The second system stores the value directly in a block of memory. As a
 * result, the function has to know the size of the type. av_dynarray2_add()
 * implements this mechanism.
 *
 * @code
 * type *array = NULL; //< an array of values
 * int   nb    = 0;    //< a variable to keep track of the length of the array
 *
 * type to_be_added  = ...;
 * type to_be_added2 = ...;
 *
 * type *addr = av_dynarray2_add((void ** )&array, &nb, sizeof( *array), NULL);
 * if (!addr)
 *     return AVERROR(ENOMEM);
 * memcpy(addr, &to_be_added, sizeof(to_be_added));
 *
 * // Shortcut of the above.
 * type *addr = av_dynarray2_add((void ** )&array, &nb, sizeof( *array),
 *                               (const void * )&to_be_added2);
 * if (!addr)
 *     return AVERROR(ENOMEM);
 *
 * // Now:
 * //  nb           == 2
 * //  to_be_added  == array[0]
 * //  to_be_added2 == array[1]
 *
 * av_freep(&array);
 * @endcode
 *
 * @{
 *)

(**
 * Add the pointer to an element to a dynamic array.
 *
 * The array to grow is supposed to be an array of pointers to
 * structures, and the element to add must be a pointer to an already
 * allocated structure.
 *
 * The array is reallocated when its size reaches powers of 2.
 * Therefore, the amortized cost of adding an element is constant.
 *
 * In case of success, the pointer to the array is updated in order to
 * point to the new grown array, and the number pointed to by `nb_ptr`
 * is incremented.
 * In case of failure, the array is freed, `*tab_ptr` is set to `NULL` and
 * `*nb_ptr` is set to 0.
 *
 * @param[in,out] tab_ptr Pointer to the array to grow
 * @param[in,out] nb_ptr  Pointer to the number of elements in the array
 * @param[in]     elem    Element to add
 * @see av_dynarray_add_nofree(), av_dynarray2_add()
 *)

{$IFDEF API_Dynamic}
var av_dynarray_add : procedure(tab_ptr: Pointer; nb_ptr: PInteger; elem: Pointer); cdecl;
{$ELSE API_Dynamic}
procedure av_dynarray_add(tab_ptr: Pointer; nb_ptr: PInteger; elem: Pointer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_dynarray_add';
{$ENDIF API_Dynamic}


(**
 * Add an element to a dynamic array.
 *
 * Function has the same functionality as av_dynarray_add(),
 * but it doesn't free memory on fails. It returns error code
 * instead and leave current buffer untouched.
 *
 * @return >=0 on success, negative otherwise
 * @see av_dynarray_add(), av_dynarray2_add()
 *)

{$IFDEF API_Dynamic}
var av_dynarray_add_nofree : function(tab_ptr: Pointer; nb_ptr: PInteger; elem: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_dynarray_add_nofree(tab_ptr: Pointer; nb_ptr: PInteger; elem: Pointer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_dynarray_add_nofree';
{$ENDIF API_Dynamic}


(**
 * Add an element of size `elem_size` to a dynamic array.
 *
 * The array is reallocated when its number of elements reaches powers of 2.
 * Therefore, the amortized cost of adding an element is constant.
 *
 * In case of success, the pointer to the array is updated in order to
 * point to the new grown array, and the number pointed to by `nb_ptr`
 * is incremented.
 * In case of failure, the array is freed, `*tab_ptr` is set to `NULL` and
 * `*nb_ptr` is set to 0.
 *
 * @param[in,out] tab_ptr   Pointer to the array to grow
 * @param[in,out] nb_ptr    Pointer to the number of elements in the array
 * @param[in]     elem_size Size in bytes of an element in the array
 * @param[in]     elem_data Pointer to the data of the element to add. If
 *                          `NULL`, the space of the newly added element is
 *                          allocated but left uninitialized.
 *
 * @return Pointer to the data of the element to copy in the newly allocated
 *         space
 * @see av_dynarray_add(), av_dynarray_add_nofree()
 *)

{$IFDEF API_Dynamic}
var av_dynarray2_add : function(tab_ptr: PPointer; nb_ptr: PInteger; elem_size: Cardinal;
                       const elem_data: PByte): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_dynarray2_add(tab_ptr: PPointer; nb_ptr: PInteger; elem_size: Cardinal;
                       const elem_data: PByte): Pointer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_dynarray2_add';
{$ENDIF API_Dynamic}


(**
 * @}
 *)

(**
 * @defgroup lavu_mem_misc Miscellaneous Functions
 *
 * Other functions related to memory allocation.
 *
 * @{
 *)

(**
 * Multiply two `size_t` values checking for overflow.
 *
 * @param[in]  a,b Operands of multiplication
 * @param[out] r   Pointer to the result of the operation
 * @return 0 on success, AVERROR(EINVAL) on overflow
 *)
(*
static inline int av_size_mult(size_t a, size_t b, size_t *r)
{
    size_t t = a * b;
    /* Hack inspired from glibc: don't try the division if nelem and elsize
     * are both less than sqrt(SIZE_MAX). */
    if ((a | b) >= ((size_t)1 << (sizeof(size_t) * 4)) && a && t / a != b)
        return AVERROR(EINVAL);
    *r = t;
    return 0;
}
*)

(**
 * Set the maximum size that may be allocated in one block.
 *
 * The value specified with this function is effective for all libavutil's @ref
 * lavu_mem_funcs "heap management functions."
 *
 * By default, the max value is defined as `INT_MAX`.
 *
 * @param max Value to be set as the new maximum size
 *
 * @warning Exercise extreme caution when using this function. Don't touch
 *          this if you do not understand the full consequence of doing so.
 *)

{$IFDEF API_Dynamic}
var av_max_alloc : procedure(max: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_max_alloc(max: Cardinal); cdecl; external AVUTIL_LIBNAME name _PU + 'av_max_alloc';
{$ENDIF API_Dynamic}


(**
 * @}
 * @}
 *)

(**
 * Allocate a block of size * nmemb bytes with av_malloc().
 * @param nmemb Number of elements
 * @param size Size of the single element
 * @return Pointer to the allocated block, NULL if the block cannot
 * be allocated.
 * @see av_malloc()
 *)
function av_malloc_array(nmemb, size: Cardinal): Pointer;  {$IFDEF USE_INLINE}inline;{$ENDIF}

(**
 * Allocate a block of size * nmemb bytes with av_mallocz().
 * @param nmemb Number of elements
 * @param size Size of the single element
 * @return Pointer to the allocated block, NULL if the block cannot
 * be allocated.
 * @see av_mallocz()
 * @see av_malloc_array()
 *)
function av_mallocz_array(nmemb, size: Cardinal): Pointer;  {$IFDEF USE_INLINE}inline;{$ENDIF}


(* ****************************************************** *)
(* import libavutil_motion_vector *)
(* ****************************************************** *)






type
  PAVMotionVector = ^TAVMotionVector;
  TAVMotionVector = record
    (**
     * Where the current macroblock comes from; negative value when it comes
     * from the past, positive value when it comes from the future.
     * XXX: set exact relative ref frame reference instead of a +/- 1 "direction".
     *)
    source: LongInt;
    (**
     * Width and height of the block.
     *)
    w, h: Byte;
    (**
     * Absolute source position. Can be outside the frame area.
     *)
    src_x, src_y: SmallInt;
    (**
     * Absolute destination position. Can be outside the frame area.
     *)
    dst_x, dst_y: SmallInt;
    (**
     * Extra flag information.
     * Currently unused.
     *)
    flags: Int64;
    (**
     * Motion vector
     * src_x = dst_x + motion_x / motion_scale
     * src_y = dst_y + motion_y / motion_scale
     *)
    motion_x, motion_y: LongInt;
    motion_scale: SmallInt;
  end;


(* ****************************************************** *)
(* import libavfilter_avcodec *)
(* ****************************************************** *)






{$IFDEF FF_API_AVFILTERBUFFER}
(**
 * Create and return a picref reference from the data and properties
 * contained in frame.
 *
 * @param perms permissions to assign to the new buffer reference
 * @deprecated avfilter APIs work natively with AVFrame instead.
 *)

{$IFDEF API_Dynamic}
var avfilter_get_video_buffer_ref_from_frame : function(const frame: PAVFrame; perms: Integer): PAVFilterBufferRef; cdecl;
{$ELSE API_Dynamic}
function avfilter_get_video_buffer_ref_from_frame(const frame: PAVFrame; perms: Integer): PAVFilterBufferRef; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_get_video_buffer_ref_from_frame';
{$ENDIF API_Dynamic}


(**
 * Create and return a picref reference from the data and properties
 * contained in frame.
 *
 * @param perms permissions to assign to the new buffer reference
 * @deprecated avfilter APIs work natively with AVFrame instead.
 *)

{$IFDEF API_Dynamic}
var avfilter_get_audio_buffer_ref_from_frame : function(const frame: PAVFrame;
                                                           perms: Integer): PAVFilterBufferRef; cdecl;
{$ELSE API_Dynamic}
function avfilter_get_audio_buffer_ref_from_frame(const frame: PAVFrame;
                                                           perms: Integer): PAVFilterBufferRef; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_get_audio_buffer_ref_from_frame';
{$ENDIF API_Dynamic}


(**
 * Create and return a buffer reference from the data and properties
 * contained in frame.
 *
 * @param perms permissions to assign to the new buffer reference
 * @deprecated avfilter APIs work natively with AVFrame instead.
 *)

{$IFDEF API_Dynamic}
var avfilter_get_buffer_ref_from_frame : function(ttype: TAVMediaType;
                                                     const frame: PAVFrame;
                                                     perms: Integer): PAVFilterBufferRef; cdecl;
{$ELSE API_Dynamic}
function avfilter_get_buffer_ref_from_frame(ttype: TAVMediaType;
                                                     const frame: PAVFrame;
                                                     perms: Integer): PAVFilterBufferRef; cdecl; external AVFILTER_LIBNAME name _PU + 'avfilter_get_buffer_ref_from_frame';
{$ENDIF API_Dynamic}

{$ENDIF}


(* ****************************************************** *)
(* import libavutil_parseutils *)
(* ****************************************************** *)






(**
 * Parse str and store the parsed ratio in q.
 *
 * Note that a ratio with infinite (1/0) or negative value is
 * considered valid, so you should check on the returned value if you
 * want to exclude those values.
 *
 * The undefined value can be expressed using the "0:0" string.
 *
 * @param[in,out] q pointer to the AVRational which will contain the ratio
 * @param[in] str the string to parse: it has to be a string in the format
 * num:den, a float number or an expression
 * @param[in] max the maximum allowed numerator and denominator
 * @param[in] log_offset log level offset which is applied to the log
 * level of log_ctx
 * @param[in] log_ctx parent logging context
 * @return >= 0 on success, a negative error code otherwise
 *)

{$IFDEF API_Dynamic}
var av_parse_ratio : function(q: PAVRational; const str: PAnsiChar;
                          max, log_offset: Integer; log_ctx: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_parse_ratio(q: PAVRational; const str: PAnsiChar;
                          max, log_offset: Integer; log_ctx: Pointer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_parse_ratio';
{$ENDIF API_Dynamic}


//#define av_parse_ratio_quiet(rate, str, max) \
//    av_parse_ratio(rate, str, max, AV_LOG_MAX_OFFSET, NULL)

(**
 * Parse str and put in width_ptr and height_ptr the detected values.
 *
 * @param[in,out] width_ptr pointer to the variable which will contain the detected
 * width value
 * @param[in,out] height_ptr pointer to the variable which will contain the detected
 * height value
 * @param[in] str the string to parse: it has to be a string in the format
 * width x height or a valid video size abbreviation.
 * @return >= 0 on success, a negative error code otherwise
 *)

{$IFDEF API_Dynamic}
var av_parse_video_size : function(width_ptr, height_ptr: PInteger; const str: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_parse_video_size(width_ptr, height_ptr: PInteger; const str: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_parse_video_size';
{$ENDIF API_Dynamic}


(**
 * Parse str and store the detected values in *rate.
 *
 * @param[in,out] rate pointer to the AVRational which will contain the detected
 * frame rate
 * @param[in] str the string to parse: it has to be a string in the format
 * rate_num / rate_den, a float number or a valid video rate abbreviation
 * @return >= 0 on success, a negative error code otherwise
 *)

{$IFDEF API_Dynamic}
var av_parse_video_rate : function(rate: PAVRational; const str: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_parse_video_rate(rate: PAVRational; const str: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_parse_video_rate';
{$ENDIF API_Dynamic}


(**
 * Put the RGBA values that correspond to color_string in rgba_color.
 *
 * @param color_string a string specifying a color. It can be the name of
 * a color (case insensitive match) or a [0x|#]RRGGBB[AA] sequence,
 * possibly followed by "@" and a string representing the alpha
 * component.
 * The alpha component may be a string composed by "0x" followed by an
 * hexadecimal number or a decimal number between 0.0 and 1.0, which
 * represents the opacity value (0x00/0.0 means completely transparent,
 * 0xff/1.0 completely opaque).
 * If the alpha component is not specified then 0xff is assumed.
 * The string "random" will result in a random color.
 * @param slen length of the initial part of color_string containing the
 * color. It can be set to -1 if color_string is a null terminated string
 * containing nothing else than the color.
 * @return >= 0 in case of success, a negative value in case of
 * failure (for example if color_string cannot be parsed).
 *)

{$IFDEF API_Dynamic}
var av_parse_color : function(rgba_color: PByte; const color_string: PAnsiChar;
                                 slen: Integer; log_ctx: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_parse_color(rgba_color: PByte; const color_string: PAnsiChar;
                                 slen: Integer; log_ctx: Pointer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_parse_color';
{$ENDIF API_Dynamic}


(**
 * Get the name of a color from the internal table of hard-coded named
 * colors.
 *
 * This function is meant to enumerate the color names recognized by
 * av_parse_color().
 *
 * @param color_idx index of the requested color, starting from 0
 * @param rgbp      if not NULL, will point to a 3-elements array with the color value in RGB
 * @return the color name string or NULL if color_idx is not in the array
 *)

{$IFDEF API_Dynamic}
var av_get_known_color_name : function(color_idx: Integer; const rgb: PPByte): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_get_known_color_name(color_idx: Integer; const rgb: PPByte): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_get_known_color_name';
{$ENDIF API_Dynamic}


(**
 * Parse timestr and return in *time a corresponding number of
 * microseconds.
 *
 * @param timeval puts here the number of microseconds corresponding
 * to the string in timestr. If the string represents a duration, it
 * is the number of microseconds contained in the time interval.  If
 * the string is a date, is the number of microseconds since 1st of
 * January, 1970 up to the time of the parsed date.  If timestr cannot
 * be successfully parsed, set *time to INT64_MIN.

 * @param timestr a string representing a date or a duration.
 * - If a date the syntax is:
 * @code
 * [{YYYY-MM-DD|YYYYMMDD}[T|t| ]]{{HH:MM:SS[.m...]]]}|{HHMMSS[.m...]]]}}[Z]
 * now
 * @endcode
 * If the value is "now" it takes the current time.
 * Time is local time unless Z is appended, in which case it is
 * interpreted as UTC.
 * If the year-month-day part is not specified it takes the current
 * year-month-day.
 * - If a duration the syntax is:
 * @code
 * [-][HH:]MM:SS[.m...]
 * [-]S+[.m...]
 * @endcode
 * @param duration flag which tells how to interpret timestr, if not
 * zero timestr is interpreted as a duration, otherwise as a date
 * @return >= 0 in case of success, a negative value corresponding to an
 * AVERROR code otherwise
 *)

{$IFDEF API_Dynamic}
var av_parse_time : function(timeval: PInt64; const timestr: PAnsiChar; duration: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_parse_time(timeval: PInt64; const timestr: PAnsiChar; duration: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_parse_time';
{$ENDIF API_Dynamic}


(**
 * Attempt to find a specific tag in a URL.
 *
 * syntax: '?tag1=val1&tag2=val2...'. Little URL decoding is done.
 * Return 1 if found.
 *)

{$IFDEF API_Dynamic}
var av_find_info_tag : function(arg: PAnsiChar; arg_size: Integer; const tag1: PAnsiChar; const info: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function av_find_info_tag(arg: PAnsiChar; arg_size: Integer; const tag1: PAnsiChar; const info: PAnsiChar): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_find_info_tag';
{$ENDIF API_Dynamic}


(**
 * Simplified version of strptime
 *
 * Parse the input string p according to the format string fmt and
 * store its results in the structure dt.
 * This implementation supports only a subset of the formats supported
 * by the standard strptime().
 *
 * The supported input field descriptors are listed below.
 * - %H: the hour as a decimal number, using a 24-hour clock, in the
 *   range '00' through '23'
 * - %J: hours as a decimal number, in the range '0' through INT_MAX
 * - %M: the minute as a decimal number, using a 24-hour clock, in the
 *   range '00' through '59'
 * - %S: the second as a decimal number, using a 24-hour clock, in the
 *   range '00' through '59'
 * - %Y: the year as a decimal number, using the Gregorian calendar
 * - %m: the month as a decimal number, in the range '1' through '12'
 * - %d: the day of the month as a decimal number, in the range '1'
 *   through '31'
 * - %T: alias for '%H:%M:%S'
 * - %%: a literal '%'
 *
 * @return a pointer to the first character not processed in this function
 *         call. In case the input string contains more characters than
 *         required by the format string the return value points right after
 *         the last consumed input character. In case the whole input string
 *         is consumed the return value points to the null byte at the end of
 *         the string. On failure NULL is returned.
 *)

{$IFDEF API_Dynamic}
var av_small_strptime : function(const p, fmt: PAnsiChar; dt: Pointer{tm*}): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_small_strptime(const p, fmt: PAnsiChar; dt: Pointer{tm*}): PAnsiChar; cdecl; external AVUTIL_LIBNAME name _PU + 'av_small_strptime';
{$ENDIF API_Dynamic}


(**
 * Convert the decomposed UTC time in tm to a time_t value.
 *)
//time_t av_timegm(struct tm *tm);

{$IFDEF API_Dynamic}
var av_timegm : function(tm: Pointer): Longint; cdecl;
{$ELSE API_Dynamic}
function av_timegm(tm: Pointer): Longint; cdecl; external AVUTIL_LIBNAME name _PU + 'av_timegm';
{$ENDIF API_Dynamic}



(* ****************************************************** *)
(* import libavutil_imgutils *)
(* ****************************************************** *)






(**
 * @addtogroup lavu_picture
 * @{
 *)

(**
 * Compute the max pixel step for each plane of an image with a
 * format described by pixdesc.
 *
 * The pixel step is the distance in bytes between the first byte of
 * the group of bytes which describe a pixel component and the first
 * byte of the successive group in the same plane for the same
 * component.
 *
 * @param max_pixsteps an array which is filled with the max pixel step
 * for each plane. Since a plane may contain different pixel
 * components, the computed max_pixsteps[plane] is relative to the
 * component in the plane with the max pixel step.
 * @param max_pixstep_comps an array which is filled with the component
 * for each plane which has the max pixel step. May be NULL.
 *)

{$IFDEF API_Dynamic}
var av_image_fill_max_pixsteps : procedure(max_pixsteps, max_pixstep_comps: PInteger{array[0..3] of Integer};
                                              const pixdesc: PAVPixFmtDescriptor); cdecl;
{$ELSE API_Dynamic}
procedure av_image_fill_max_pixsteps(max_pixsteps, max_pixstep_comps: PInteger{array[0..3] of Integer};
                                              const pixdesc: PAVPixFmtDescriptor); cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_fill_max_pixsteps';
{$ENDIF API_Dynamic}


(**
 * Compute the size of an image line with format pix_fmt and width
 * width for the plane plane.
 *
 * @return the computed size in bytes
 *)

{$IFDEF API_Dynamic}
var av_image_get_linesize : function(pix_fmt: TAVPixelFormat; width, plane: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_image_get_linesize(pix_fmt: TAVPixelFormat; width, plane: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_get_linesize';
{$ENDIF API_Dynamic}


(**
 * Fill plane linesizes for an image with pixel format pix_fmt and
 * width width.
 *
 * @param linesizes array to be filled with the linesize for each plane
 * @return >= 0 in case of success, a negative error code otherwise
 *)

{$IFDEF API_Dynamic}
var av_image_fill_linesizes : function(linesizes: PInteger{array[0..3] of Integer}; pix_fmt: TAVPixelFormat; width: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_image_fill_linesizes(linesizes: PInteger{array[0..3] of Integer}; pix_fmt: TAVPixelFormat; width: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_fill_linesizes';
{$ENDIF API_Dynamic}


(**
 * Fill plane data pointers for an image with pixel format pix_fmt and
 * height height.
 *
 * @param data pointers array to be filled with the pointer for each image plane
 * @param ptr the pointer to a buffer which will contain the image
 * @param linesizes the array containing the linesize for each
 * plane, should be filled by av_image_fill_linesizes()
 * @return the size in bytes required for the image buffer, a negative
 * error code in case of failure
 *)

{$IFDEF API_Dynamic}
var av_image_fill_pointers : function(data: PPByte{array[0..3] of PByte}; pix_fmt: TAVPixelFormat; height: Integer;
                                         ptr: PByte; linesizes: PInteger{array[0..3] of Integer}): Integer; cdecl;
{$ELSE API_Dynamic}
function av_image_fill_pointers(data: PPByte{array[0..3] of PByte}; pix_fmt: TAVPixelFormat; height: Integer;
                                         ptr: PByte; linesizes: PInteger{array[0..3] of Integer}): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_fill_pointers';
{$ENDIF API_Dynamic}


(**
 * Allocate an image with size w and h and pixel format pix_fmt, and
 * fill pointers and linesizes accordingly.
 * The allocated image buffer has to be freed by using
 * av_freep(&pointers[0]).
 *
 * @param align the value to use for buffer size alignment
 * @return the size in bytes required for the image buffer, a negative
 * error code in case of failure
 *)

{$IFDEF API_Dynamic}
var av_image_alloc : function(pointers: PPByte{array[0..3] of PByte}; linesizes: PInteger{array[0..3] of Integer};
                   w, h: Integer; pix_fmt: TAVPixelFormat; align: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_image_alloc(pointers: PPByte{array[0..3] of PByte}; linesizes: PInteger{array[0..3] of Integer};
                   w, h: Integer; pix_fmt: TAVPixelFormat; align: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_alloc';
{$ENDIF API_Dynamic}


(**
 * Copy image plane from src to dst.
 * That is, copy "height" number of lines of "bytewidth" bytes each.
 * The first byte of each successive line is separated by *_linesize
 * bytes.
 *
 * bytewidth must be contained by both absolute values of dst_linesize
 * and src_linesize, otherwise the function behavior is undefined.
 *
 * @param dst_linesize linesize for the image plane in dst
 * @param src_linesize linesize for the image plane in src
 *)

{$IFDEF API_Dynamic}
var av_image_copy_plane : procedure(dst: PByte; dst_linesize: Integer;
                                       const src: PByte; src_linesize: Integer;
                                       bytewidth, height: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_image_copy_plane(dst: PByte; dst_linesize: Integer;
                                       const src: PByte; src_linesize: Integer;
                                       bytewidth, height: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_copy_plane';
{$ENDIF API_Dynamic}


(**
 * Copy image in src_data to dst_data.
 *
 * @param dst_linesizes linesizes for the image in dst_data
 * @param src_linesizes linesizes for the image in src_data
 *)

{$IFDEF API_Dynamic}
var av_image_copy : procedure(dst_data: PPByte{array[0..3] of PByte}; dst_linesizes: PInteger{array[0..3] of Integer};
                                 const src_data: PPByte{array[0..3] of PByte}; const src_linesizes: PInteger{array[0..3] of Integer};
                                 pix_fmt: TAVPixelFormat; width, height: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_image_copy(dst_data: PPByte{array[0..3] of PByte}; dst_linesizes: PInteger{array[0..3] of Integer};
                                 const src_data: PPByte{array[0..3] of PByte}; const src_linesizes: PInteger{array[0..3] of Integer};
                                 pix_fmt: TAVPixelFormat; width, height: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_copy';
{$ENDIF API_Dynamic}


(**
 * Copy image data located in uncacheable (e.g. GPU mapped) memory. Where
 * available, this function will use special functionality for reading from such
 * memory, which may result in greatly improved performance compared to plain
 * av_image_copy().
 *
 * The data pointers and the linesizes must be aligned to the maximum required
 * by the CPU architecture.
 *
 * @note The linesize parameters have the type ptrdiff_t here, while they are
 *       int for av_image_copy().
 * @note On x86, the linesizes currently need to be aligned to the cacheline
 *       size (i.e. 64) to get improved performance.
 *)

{$IFDEF API_Dynamic}
var av_image_copy_uc_from : procedure(dst_data: PPByte{array[0..3] of PByte}; const dst_linesizes: PInteger{array[0..3] of Integer};
                           const src_data: PPByte{array[0..3] of PByte}; const src_linesizes: PInteger{array[0..3] of Integer};
                           pix_fmt: TAVPixelFormat; width, height: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_image_copy_uc_from(dst_data: PPByte{array[0..3] of PByte}; const dst_linesizes: PInteger{array[0..3] of Integer};
                           const src_data: PPByte{array[0..3] of PByte}; const src_linesizes: PInteger{array[0..3] of Integer};
                           pix_fmt: TAVPixelFormat; width, height: Integer); cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_copy_uc_from';
{$ENDIF API_Dynamic}


(**
 * Setup the data pointers and linesizes based on the specified image
 * parameters and the provided array.
 *
 * The fields of the given image are filled in by using the src
 * address which points to the image data buffer. Depending on the
 * specified pixel format, one or multiple image data pointers and
 * line sizes will be set.  If a planar format is specified, several
 * pointers will be set pointing to the different picture planes and
 * the line sizes of the different planes will be stored in the
 * lines_sizes array. Call with src == NULL to get the required
 * size for the src buffer.
 *
 * To allocate the buffer and fill in the dst_data and dst_linesize in
 * one call, use av_image_alloc().
 *
 * @param dst_data      data pointers to be filled in
 * @param dst_linesize  linesizes for the image in dst_data to be filled in
 * @param src           buffer which will contain or contains the actual image data, can be NULL
 * @param pix_fmt       the pixel format of the image
 * @param width         the width of the image in pixels
 * @param height        the height of the image in pixels
 * @param align         the value used in src for linesize alignment
 * @return the size in bytes required for src, a negative error code
 * in case of failure
 *)

{$IFDEF API_Dynamic}
var av_image_fill_arrays : function(dst_data: PPByte{array[0..3] of PByte}; dst_linesize: PInteger{array[0..3] of Integer};
                                        const src: PByte; pix_fmt: TAVPixelFormat;
                                        width, height, align: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_image_fill_arrays(dst_data: PPByte{array[0..3] of PByte}; dst_linesize: PInteger{array[0..3] of Integer};
                                        const src: PByte; pix_fmt: TAVPixelFormat;
                                        width, height, align: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_fill_arrays';
{$ENDIF API_Dynamic}


(**
 * Return the size in bytes of the amount of data required to store an
 * image with the given parameters.
 *
 * @param pix_fmt  the pixel format of the image
 * @param width    the width of the image in pixels
 * @param height   the height of the image in pixels
 * @param align    the assumed linesize alignment
 * @return the buffer size in bytes, a negative error code in case of failure
 *)

{$IFDEF API_Dynamic}
var av_image_get_buffer_size : function(pix_fmt: TAVPixelFormat; width, height, align: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_image_get_buffer_size(pix_fmt: TAVPixelFormat; width, height, align: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_get_buffer_size';
{$ENDIF API_Dynamic}


(**
 * Copy image data from an image into a buffer.
 *
 * av_image_get_buffer_size() can be used to compute the required size
 * for the buffer to fill.
 *
 * @param dst           a buffer into which picture data will be copied
 * @param dst_size      the size in bytes of dst
 * @param src_data      pointers containing the source image data
 * @param src_linesize  linesizes for the image in src_data
 * @param pix_fmt       the pixel format of the source image
 * @param width         the width of the source image in pixels
 * @param height        the height of the source image in pixels
 * @param align         the assumed linesize alignment for dst
 * @return the number of bytes written to dst, or a negative value
 * (error code) on error
 *)

{$IFDEF API_Dynamic}
var av_image_copy_to_buffer : function(dst: PByte; dst_size: Integer;
                            const src_data: PPByte{array[0..3] of PByte}; const src_linesize: PInteger{array[0..3] of Integer};
                            pix_fmt: TAVPixelFormat; width, height, align: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_image_copy_to_buffer(dst: PByte; dst_size: Integer;
                            const src_data: PPByte{array[0..3] of PByte}; const src_linesize: PInteger{array[0..3] of Integer};
                            pix_fmt: TAVPixelFormat; width, height, align: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_copy_to_buffer';
{$ENDIF API_Dynamic}


(**
 * Check if the given dimension of an image is valid, meaning that all
 * bytes of a plane of an image with the specified pix_fmt can be addressed
 * with a signed int.
 *
 * @param w the width of the picture
 * @param h the height of the picture
 * @param log_offset the offset to sum to the log level for logging with log_ctx
 * @param log_ctx the parent logging context, it may be NULL
 * @return >= 0 if valid, a negative error code otherwise
 *)

{$IFDEF API_Dynamic}
var av_image_check_size : function(w, h: Cardinal; log_offset: Integer; log_ctx: Pointer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_image_check_size(w, h: Cardinal; log_offset: Integer; log_ctx: Pointer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_check_size';
{$ENDIF API_Dynamic}


(**
 * Check if the given sample aspect ratio of an image is valid.
 *
 * It is considered invalid if the denominator is 0 or if applying the ratio
 * to the image size would make the smaller dimension less than 1. If the
 * sar numerator is 0, it is considered unknown and will return as valid.
 *
 * @param w width of the image
 * @param h height of the image
 * @param sar sample aspect ratio of the image
 * @return 0 if valid, a negative AVERROR code otherwise
 *)

{$IFDEF API_Dynamic}
var av_image_check_sar : function(w, h: Cardinal; sar: TAVRational): Integer; cdecl;
{$ELSE API_Dynamic}
function av_image_check_sar(w, h: Cardinal; sar: TAVRational): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_check_sar';
{$ENDIF API_Dynamic}


(**
 * Overwrite the image data with black. This is suitable for filling a
 * sub-rectangle of an image, meaning the padding between the right most pixel
 * and the left most pixel on the next line will not be overwritten. For some
 * formats, the image size might be rounded up due to inherent alignment.
 *
 * If the pixel format has alpha, the alpha is cleared to opaque.
 *
 * This can return an error if the pixel format is not supported. Normally, all
 * non-hwaccel pixel formats should be supported.
 *
 * Passing NULL for dst_data is allowed. Then the function returns whether the
 * operation would have succeeded. (It can return an error if the pix_fmt is
 * not supported.)
 *
 * @param dst_data      data pointers to destination image
 * @param dst_linesize  linesizes for the destination image
 * @param pix_fmt       the pixel format of the image
 * @param range         the color range of the image (important for colorspaces such as YUV)
 * @param width         the width of the image in pixels
 * @param height        the height of the image in pixels
 * @return 0 if the image data was cleared, a negative AVERROR code otherwise
 *)

{$IFDEF API_Dynamic}
var av_image_fill_black : function(dst_data: PPByte{array[0..3] of PByte}; const dst_linesize: PInteger{array[0..3] of Integer};
                        pix_fmt: TAVPixelFormat; range: TAVColorRange;
                        width, height: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_image_fill_black(dst_data: PPByte{array[0..3] of PByte}; const dst_linesize: PInteger{array[0..3] of Integer};
                        pix_fmt: TAVPixelFormat; range: TAVColorRange;
                        width, height: Integer): Integer; cdecl; external AVUTIL_LIBNAME name _PU + 'av_image_fill_black';
{$ENDIF API_Dynamic}


(**
 * @}
 *)


(* ****************************************************** *)
(* import libavformat *)
(* ****************************************************** *)






(**
 * @defgroup libavf libavformat
 * I/O and Muxing/Demuxing Library
 *
 * Libavformat (lavf) is a library for dealing with various media container
 * formats. Its main two purposes are demuxing - i.e. splitting a media file
 * into component streams, and the reverse process of muxing - writing supplied
 * data in a specified container format. It also has an @ref lavf_io
 * "I/O module" which supports a number of protocols for accessing the data (e.g.
 * file, tcp, http and others). Before using lavf, you need to call
 * av_register_all() to register all compiled muxers, demuxers and protocols.
 * Unless you are absolutely sure you won't use libavformat's network
 * capabilities, you should also call avformat_network_init().
 *
 * A supported input format is described by an AVInputFormat struct, conversely
 * an output format is described by AVOutputFormat. You can iterate over all
 * registered input/output formats using the av_iformat_next() /
 * av_oformat_next() functions. The protocols layer is not part of the public
 * API, so you can only get the names of supported protocols with the
 * avio_enum_protocols() function.
 *
 * Main lavf structure used for both muxing and demuxing is AVFormatContext,
 * which exports all information about the file being read or written. As with
 * most Libavformat structures, its size is not part of public ABI, so it cannot be
 * allocated on stack or directly with av_malloc(). To create an
 * AVFormatContext, use avformat_alloc_context() (some functions, like
 * avformat_open_input() might do that for you).
 *
 * Most importantly an AVFormatContext contains:
 * @li the @ref AVFormatContext.iformat "input" or @ref AVFormatContext.oformat
 * "output" format. It is either autodetected or set by user for input;
 * always set by user for output.
 * @li an @ref AVFormatContext.streams "array" of AVStreams, which describe all
 * elementary streams stored in the file. AVStreams are typically referred to
 * using their index in this array.
 * @li an @ref AVFormatContext.pb "I/O context". It is either opened by lavf or
 * set by user for input, always set by user for output (unless you are dealing
 * with an AVFMT_NOFILE format).
 *
 * @section lavf_options Passing options to (de)muxers
 * It is possible to configure lavf muxers and demuxers using the @ref avoptions
 * mechanism. Generic (format-independent) libavformat options are provided by
 * AVFormatContext, they can be examined from a user program by calling
 * av_opt_next() / av_opt_find() on an allocated AVFormatContext (or its AVClass
 * from avformat_get_class()). Private (format-specific) options are provided by
 * AVFormatContext.priv_data if and only if AVInputFormat.priv_class /
 * AVOutputFormat.priv_class of the corresponding format struct is non-NULL.
 * Further options may be provided by the @ref AVFormatContext.pb "I/O context",
 * if its AVClass is non-NULL, and the protocols layer. See the discussion on
 * nesting in @ref avoptions documentation to learn how to access those.
 *
 * @section urls
 * URL strings in libavformat are made of a scheme/protocol, a ':', and a
 * scheme specific string. URLs without a scheme and ':' used for local files
 * are supported but deprecated. "file:" should be used for local files.
 *
 * It is important that the scheme string is not taken from untrusted
 * sources without checks.
 *
 * Note that some schemes/protocols are quite powerful, allowing access to
 * both local and remote files, parts of them, concatenations of them, local
 * audio and video devices and so on.
 *
 * @{
 *
 * @defgroup lavf_decoding Demuxing
 * @{
 * Demuxers read a media file and split it into chunks of data (@em packets). A
 * @ref AVPacket "packet" contains one or more encoded frames which belongs to a
 * single elementary stream. In the lavf API this process is represented by the
 * avformat_open_input() function for opening a file, av_read_frame() for
 * reading a single packet and finally avformat_close_input(), which does the
 * cleanup.
 *
 * @section lavf_decoding_open Opening a media file
 * The minimum information required to open a file is its URL, which
 * is passed to avformat_open_input(), as in the following code:
 * @code
 * const char    *url = "file:in.mp3";
 * AVFormatContext *s = NULL;
 * int ret = avformat_open_input(&s, url, NULL, NULL);
 * if (ret < 0)
 *     abort();
 * @endcode
 * The above code attempts to allocate an AVFormatContext, open the
 * specified file (autodetecting the format) and read the header, exporting the
 * information stored there into s. Some formats do not have a header or do not
 * store enough information there, so it is recommended that you call the
 * avformat_find_stream_info() function which tries to read and decode a few
 * frames to find missing information.
 *
 * In some cases you might want to preallocate an AVFormatContext yourself with
 * avformat_alloc_context() and do some tweaking on it before passing it to
 * avformat_open_input(). One such case is when you want to use custom functions
 * for reading input data instead of lavf internal I/O layer.
 * To do that, create your own AVIOContext with avio_alloc_context(), passing
 * your reading callbacks to it. Then set the @em pb field of your
 * AVFormatContext to newly created AVIOContext.
 *
 * Since the format of the opened file is in general not known until after
 * avformat_open_input() has returned, it is not possible to set demuxer private
 * options on a preallocated context. Instead, the options should be passed to
 * avformat_open_input() wrapped in an AVDictionary:
 * @code
 * AVDictionary *options = NULL;
 * av_dict_set(&options, "video_size", "640x480", 0);
 * av_dict_set(&options, "pixel_format", "rgb24", 0);
 *
 * if (avformat_open_input(&s, url, NULL, &options) < 0)
 *     abort();
 * av_dict_free(&options);
 * @endcode
 * This code passes the private options 'video_size' and 'pixel_format' to the
 * demuxer. They would be necessary for e.g. the rawvideo demuxer, since it
 * cannot know how to interpret raw video data otherwise. If the format turns
 * out to be something different than raw video, those options will not be
 * recognized by the demuxer and therefore will not be applied. Such unrecognized
 * options are then returned in the options dictionary (recognized options are
 * consumed). The calling program can handle such unrecognized options as it
 * wishes, e.g.
 * @code
 * AVDictionaryEntry *e;
 * if (e = av_dict_get(options, "", NULL, AV_DICT_IGNORE_SUFFIX)) {
 *     fprintf(stderr, "Option %s not recognized by the demuxer.\n", e->key);
 *     abort();
 * }
 * @endcode
 *
 * After you have finished reading the file, you must close it with
 * avformat_close_input(). It will free everything associated with the file.
 *
 * @section lavf_decoding_read Reading from an opened file
 * Reading data from an opened AVFormatContext is done by repeatedly calling
 * av_read_frame() on it. Each call, if successful, will return an AVPacket
 * containing encoded data for one AVStream, identified by
 * AVPacket.stream_index. This packet may be passed straight into the libavcodec
 * decoding functions avcodec_send_packet() or avcodec_decode_subtitle2() if the
 * caller wishes to decode the data.
 *
 * AVPacket.pts, AVPacket.dts and AVPacket.duration timing information will be
 * set if known. They may also be unset (i.e. AV_NOPTS_VALUE for
 * pts/dts, 0 for duration) if the stream does not provide them. The timing
 * information will be in AVStream.time_base units, i.e. it has to be
 * multiplied by the timebase to convert them to seconds.
 *
 * If AVPacket.buf is set on the returned packet, then the packet is
 * allocated dynamically and the user may keep it indefinitely.
 * Otherwise, if AVPacket.buf is NULL, the packet data is backed by a
 * static storage somewhere inside the demuxer and the packet is only valid
 * until the next av_read_frame() call or closing the file. If the caller
 * requires a longer lifetime, av_dup_packet() will make an av_malloc()ed copy
 * of it.
 * In both cases, the packet must be freed with av_packet_unref() when it is no
 * longer needed.
 *
 * @section lavf_decoding_seek Seeking
 * @}
 *
 * @defgroup lavf_encoding Muxing
 * @{
 * Muxers take encoded data in the form of @ref AVPacket "AVPackets" and write
 * it into files or other output bytestreams in the specified container format.
 *
 * The main API functions for muxing are avformat_write_header() for writing the
 * file header, av_write_frame() / av_interleaved_write_frame() for writing the
 * packets and av_write_trailer() for finalizing the file.
 *
 * At the beginning of the muxing process, the caller must first call
 * avformat_alloc_context() to create a muxing context. The caller then sets up
 * the muxer by filling the various fields in this context:
 *
 * - The @ref AVFormatContext.oformat "oformat" field must be set to select the
 *   muxer that will be used.
 * - Unless the format is of the AVFMT_NOFILE type, the @ref AVFormatContext.pb
 *   "pb" field must be set to an opened IO context, either returned from
 *   avio_open2() or a custom one.
 * - Unless the format is of the AVFMT_NOSTREAMS type, at least one stream must
 *   be created with the avformat_new_stream() function. The caller should fill
 *   the @ref AVStream.codecpar "stream codec parameters" information, such as the
 *   codec @ref AVCodecParameters.codec_type "type", @ref AVCodecParameters.codec_id
 *   "id" and other parameters (e.g. width / height, the pixel or sample format,
 *   etc.) as known. The @ref AVStream.time_base "stream timebase" should
 *   be set to the timebase that the caller desires to use for this stream (note
 *   that the timebase actually used by the muxer can be different, as will be
 *   described later).
 * - It is advised to manually initialize only the relevant fields in
 *   AVCodecParameters, rather than using @ref avcodec_parameters_copy() during
 *   remuxing: there is no guarantee that the codec context values remain valid
 *   for both input and output format contexts.
 * - The caller may fill in additional information, such as @ref
 *   AVFormatContext.metadata "global" or @ref AVStream.metadata "per-stream"
 *   metadata, @ref AVFormatContext.chapters "chapters", @ref
 *   AVFormatContext.programs "programs", etc. as described in the
 *   AVFormatContext documentation. Whether such information will actually be
 *   stored in the output depends on what the container format and the muxer
 *   support.
 *
 * When the muxing context is fully set up, the caller must call
 * avformat_write_header() to initialize the muxer internals and write the file
 * header. Whether anything actually is written to the IO context at this step
 * depends on the muxer, but this function must always be called. Any muxer
 * private options must be passed in the options parameter to this function.
 *
 * The data is then sent to the muxer by repeatedly calling av_write_frame() or
 * av_interleaved_write_frame() (consult those functions' documentation for
 * discussion on the difference between them; only one of them may be used with
 * a single muxing context, they should not be mixed). Do note that the timing
 * information on the packets sent to the muxer must be in the corresponding
 * AVStream's timebase. That timebase is set by the muxer (in the
 * avformat_write_header() step) and may be different from the timebase
 * requested by the caller.
 *
 * Once all the data has been written, the caller must call av_write_trailer()
 * to flush any buffered packets and finalize the output file, then close the IO
 * context (if any) and finally free the muxing context with
 * avformat_free_context().
 * @}
 *
 * @defgroup lavf_io I/O Read/Write
 * @{
 * @section lavf_io_dirlist Directory listing
 * The directory listing API makes it possible to list files on remote servers.
 *
 * Some of possible use cases:
 * - an "open file" dialog to choose files from a remote location,
 * - a recursive media finder providing a player with an ability to play all
 * files from a given directory.
 *
 * @subsection lavf_io_dirlist_open Opening a directory
 * At first, a directory needs to be opened by calling avio_open_dir()
 * supplied with a URL and, optionally, ::AVDictionary containing
 * protocol-specific parameters. The function returns zero or positive
 * integer and allocates AVIODirContext on success.
 *
 * @code
 * AVIODirContext *ctx = NULL;
 * if (avio_open_dir(&ctx, "smb://example.com/some_dir", NULL) < 0) {
 *     fprintf(stderr, "Cannot open directory.\n");
 *     abort();
 * }
 * @endcode
 *
 * This code tries to open a sample directory using smb protocol without
 * any additional parameters.
 *
 * @subsection lavf_io_dirlist_read Reading entries
 * Each directory's entry (i.e. file, another directory, anything else
 * within ::AVIODirEntryType) is represented by AVIODirEntry.
 * Reading consecutive entries from an opened AVIODirContext is done by
 * repeatedly calling avio_read_dir() on it. Each call returns zero or
 * positive integer if successful. Reading can be stopped right after the
 * NULL entry has been read -- it means there are no entries left to be
 * read. The following code reads all entries from a directory associated
 * with ctx and prints their names to standard output.
 * @code
 * AVIODirEntry *entry = NULL;
 * for (;;) {
 *     if (avio_read_dir(ctx, &entry) < 0) {
 *         fprintf(stderr, "Cannot list directory.\n");
 *         abort();
 *     }
 *     if (!entry)
 *         break;
 *     printf("%s\n", entry->name);
 *     avio_free_directory_entry(&entry);
 * }
 * @endcode
 * @}
 *
 * @defgroup lavf_codec Demuxers
 * @{
 * @defgroup lavf_codec_native Native Demuxers
 * @{
 * @}
 * @defgroup lavf_codec_wrappers External library wrappers
 * @{
 * @}
 * @}
 * @defgroup lavf_protos I/O Protocols
 * @{
 * @}
 * @defgroup lavf_internal Internal
 * @{
 * @}
 * @}
 *)

const
  AVSTREAM_EVENT_FLAG_METADATA_UPDATED = $0001; ///< The call resulted in updated metadata.
  MAX_REORDER_DELAY  = 16;    // defined in AVStream

// const for AVFormatContext.flags;
  AVFMT_FLAG_GENPTS       = $0001; ///< Generate missing pts even if it requires parsing future frames.
  AVFMT_FLAG_IGNIDX       = $0002; ///< Ignore index.
  AVFMT_FLAG_NONBLOCK     = $0004; ///< Do not block when reading packets from input.
  AVFMT_FLAG_IGNDTS       = $0008; ///< Ignore DTS on frames that contain both DTS & PTS
  AVFMT_FLAG_NOFILLIN     = $0010; ///< Do not infer any values from other values, just return what is stored in the container
  AVFMT_FLAG_NOPARSE      = $0020; ///< Do not use AVParsers, you also must set AVFMT_FLAG_NOFILLIN as the fillin code works on frames and no parsing -> no frames. Also seeking to frames can not work if parsing to find frame boundaries has been disabled
  AVFMT_FLAG_NOBUFFER     = $0040; ///< Do not buffer frames when possible
  AVFMT_FLAG_CUSTOM_IO    = $0080; ///< The caller has supplied a custom AVIOContext, don't avio_close() it.
  AVFMT_FLAG_DISCARD_CORRUPT = $0100; ///< Discard frames marked corrupted
  AVFMT_FLAG_FLUSH_PACKETS   = $0200; ///< Flush the AVIOContext every packet.
(**
 * When muxing, try to avoid writing any random/volatile data to the output.
 * This includes any random IDs, real-time timestamps/dates, muxer version, etc.
 *
 * This flag is mainly intended for testing.
 *)
  AVFMT_FLAG_BITEXACT     = $0400;
  AVFMT_FLAG_MP4A_LATM    = $8000; ///< Enable RTP MP4A-LATM payload
  AVFMT_FLAG_SORT_DTS     = $10000; ///< try to interleave outputted packets by dts (using this flag can slow demuxing down)
  AVFMT_FLAG_PRIV_OPT     = $20000; ///< Enable use of private options by delaying codec open (this could be made default once all code is converted)
{$IFDEF FF_API_LAVF_KEEPSIDE_FLAG}
  AVFMT_FLAG_KEEP_SIDE_DATA = $40000; ///< Don't merge side data but keep it separate. Deprecated, will be the default.
{$ENDIF}
  AVFMT_FLAG_FAST_SEEK    = $80000; ///< Enable fast, but inaccurate seeks for some formats
  AVFMT_FLAG_SHORTEST     = $100000; ///< Stop muxing when the shortest stream stops.
  AVFMT_FLAG_AUTO_BSF     = $200000; ///< Wait for packet data before writing a header, and add bitstream filters as requested by the muxer

  FF_FDEBUG_TS            = $0001;    // defined in AVFormatContext
  AVFMT_EVENT_FLAG_METADATA_UPDATED = $0001; ///< The call resulted in updated metadata.
  AVFMT_AVOID_NEG_TS_AUTO              = -1; ///< Enabled when required by target format
  AVFMT_AVOID_NEG_TS_MAKE_NON_NEGATIVE =  1; ///< Shift timestamps so they are non negative
  AVFMT_AVOID_NEG_TS_MAKE_ZERO         =  2; ///< Shift timestamps so that they start at 0
  RAW_PACKET_BUFFER_SIZE  = 2500000;  // defined in AVFormatContext

  AVINDEX_KEYFRAME     = $0001;
  AVINDEX_DISCARD_FRAME = $0002;

  AV_DISPOSITION_DEFAULT   = $0001;
  AV_DISPOSITION_DUB       = $0002;
  AV_DISPOSITION_ORIGINAL  = $0004;
  AV_DISPOSITION_COMMENT   = $0008;
  AV_DISPOSITION_LYRICS    = $0010;
  AV_DISPOSITION_KARAOKE   = $0020;
(**
 * Track should be used during playback by default.
 * Useful for subtitle track that should be displayed
 * even when user did not explicitly ask for subtitles.
 *)
  AV_DISPOSITION_FORCED    = $0040;
  AV_DISPOSITION_HEARING_IMPAIRED = $0080;  (**< stream for hearing impaired audiences *)
  AV_DISPOSITION_VISUAL_IMPAIRED  = $0100;  (**< stream for visual impaired audiences *)
  AV_DISPOSITION_CLEAN_EFFECTS    = $0200;  (**< stream without voice *)
(**
 * The stream is stored in the file as an attached picture/"cover art" (e.g.
 * APIC frame in ID3v2). The first (usually only) packet associated with it
 * will be returned among the first few packets read from the file unless
 * seeking takes place. It can also be accessed at any time in
 * AVStream.attached_pic.
 *)
  AV_DISPOSITION_ATTACHED_PIC     = $0400;
(**
 * The stream is sparse, and contains thumbnail images, often corresponding
 * to chapter markers. Only ever used with AV_DISPOSITION_ATTACHED_PIC.
 *)
  AV_DISPOSITION_TIMED_THUMBNAILS = $0800;

(**
 * To specify text track kind (different from subtitles default).
 *)
  AV_DISPOSITION_CAPTIONS     = $10000;
  AV_DISPOSITION_DESCRIPTIONS = $20000;
  AV_DISPOSITION_METADATA     = $40000;

(**
 * Options for behavior on timestamp wrap detection.
 *)
  AV_PTS_WRAP_IGNORE      = 0;   ///< ignore the wrap
  AV_PTS_WRAP_ADD_OFFSET  = 1;   ///< add the format specific offset on wrap detection
  AV_PTS_WRAP_SUB_OFFSET  = -1;  ///< subtract the format specific offset on wrap detection

  MAX_STD_TIMEBASES = (30 * 12 + 7 + 6);

  AV_PROGRAM_RUNNING = 1;

  AVFMTCTX_NOHEADER  = $0001; (**< signal that no header is present
                                   (streams are added dynamically) *)
(**
 * @defgroup metadata_api Public Metadata API
 * @{
 * @ingroup libavf
 * The metadata API allows libavformat to export metadata tags to a client
 * application when demuxing. Conversely it allows a client application to
 * set metadata when muxing.
 *
 * Metadata is exported or set as pairs of key/value strings in the 'metadata'
 * fields of the AVFormatContext, AVStream, AVChapter and AVProgram structs
 * using the @ref lavu_dict "AVDictionary" API. Like all strings in FFmpeg,
 * metadata is assumed to be UTF-8 encoded Unicode. Note that metadata
 * exported by demuxers isn't checked to be valid UTF-8 in most cases.
 *
 * Important concepts to keep in mind:
 * -  Keys are unique; there can never be 2 tags with the same key. This is
 *    also meant semantically, i.e., a demuxer should not knowingly produce
 *    several keys that are literally different but semantically identical.
 *    E.g., key=Author5, key=Author6. In this example, all authors must be
 *    placed in the same tag.
 * -  Metadata is flat, not hierarchical; there are no subtags. If you
 *    want to store, e.g., the email address of the child of producer Alice
 *    and actor Bob, that could have key=alice_and_bobs_childs_email_address.
 * -  Several modifiers can be applied to the tag name. This is done by
 *    appending a dash character ('-') and the modifier name in the order
 *    they appear in the list below -- e.g. foo-eng-sort, not foo-sort-eng.
 *    -  language -- a tag whose value is localized for a particular language
 *       is appended with the ISO 639-2/B 3-letter language code.
 *       For example: Author-ger=Michael, Author-eng=Mike
 *       The original/default language is in the unqualified "Author" tag.
 *       A demuxer should set a default if it sets any translated tag.
 *    -  sorting  -- a modified version of a tag that should be used for
 *       sorting will have '-sort' appended. E.g. artist="The Beatles",
 *       artist-sort="Beatles, The".
 * - Some protocols and demuxers support metadata updates. After a successful
 *   call to av_read_packet(), AVFormatContext.event_flags or AVStream.event_flags
 *   will be updated to indicate if metadata changed. In order to detect metadata
 *   changes on a stream, you need to loop through all streams in the AVFormatContext
 *   and check their individual event_flags.
 *
 * -  Demuxers attempt to export metadata in a generic format, however tags
 *    with no generic equivalents are left as they are stored in the container.
 *    Follows a list of generic tag names:
 *
 @verbatim
 album        -- name of the set this work belongs to
 album_artist -- main creator of the set/album, if different from artist.
                 e.g. "Various Artists" for compilation albums.
 artist       -- main creator of the work
 comment      -- any additional description of the file.
 composer     -- who composed the work, if different from artist.
 copyright    -- name of copyright holder.
 creation_time-- date when the file was created, preferably in ISO 8601.
 date         -- date when the work was created, preferably in ISO 8601.
 disc         -- number of a subset, e.g. disc in a multi-disc collection.
 encoder      -- name/settings of the software/hardware that produced the file.
 encoded_by   -- person/group who created the file.
 filename     -- original name of the file.
 genre        -- <self-evident>.
 language     -- main language in which the work is performed, preferably
                 in ISO 639-2 format. Multiple languages can be specified by
                 separating them with commas.
 performer    -- artist who performed the work, if different from artist.
                 E.g for "Also sprach Zarathustra", artist would be "Richard
                 Strauss" and performer "London Philharmonic Orchestra".
 publisher    -- name of the label/publisher.
 service_name     -- name of the service in broadcasting (channel name).
 service_provider -- name of the service provider in broadcasting.
 title        -- name of the work.
 track        -- number of this work in the set, can be in form current/total.
 variant_bitrate -- the total bitrate of the bitrate variant that the current stream is part of
 @endverbatim
 *
 * Look in the examples section for an application example how to use the Metadata API.
 *
 * @}
 *)

(* packet functions *)

(**
 * Allocate and read the payload of a packet and initialize its
 * fields with default values.
 *
 * @param s    associated IO context
 * @param pkt packet
 * @param size desired payload size
 * @return >0 (read size) if OK, AVERROR_xxx otherwise
 *)

{$IFDEF API_Dynamic}
var av_get_packet : function(s: PAVIOContext; pkt: PAVPacket; size: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_get_packet(s: PAVIOContext; pkt: PAVPacket; size: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_get_packet';
{$ENDIF API_Dynamic}



(**
 * Read data and append it to the current content of the AVPacket.
 * If pkt->size is 0 this is identical to av_get_packet.
 * Note that this uses av_grow_packet and thus involves a realloc
 * which is inefficient. Thus this function should only be used
 * when there is no reasonable way to know (an upper bound of)
 * the final size.
 *
 * @param s    associated IO context
 * @param pkt packet
 * @param size amount of data to read
 * @return >0 (read size) if OK, AVERROR_xxx otherwise, previous data
 *         will not be lost even if an error occurs.
 *)

{$IFDEF API_Dynamic}
var av_append_packet : function(s: PAVIOContext; pkt: PAVPacket; size: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_append_packet(s: PAVIOContext; pkt: PAVPacket; size: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_append_packet';
{$ENDIF API_Dynamic}


{$IFDEF FF_API_LAVF_FRAC}
(*************************************************)
(* fractional numbers for exact pts handling *)

(**
 * The exact value of the fractional number is: 'val + num / den'.
 * num is assumed to be 0 <= num < den.
*)
type
  PAVFrac = ^TAVFrac;
  TAVFrac = record
    val, num, den: Int64;
  end;
{$ENDIF}

(*************************************************)
(* input/output formats *)

  PPAVCodecTag = ^PAVCodecTag;
  PAVCodecTag = ^TAVCodecTag;
  TAVCodecTag = record
    // need {$ALIGN 8}
    // TODO: check from libavformat/internal.h
    id: TAVCodecID;
    tag: Cardinal;
  end;

(**
 * This structure contains the data a format has to probe a file.
 *)
  PAVProbeData = ^TAVProbeData;
  TAVProbeData = record
    filename: PAnsiChar;
    buf: PAnsiChar;      (**< Buffer must have AVPROBE_PADDING_SIZE of extra allocated bytes filled with zero. *)
    buf_size: Integer;   (**< Size of buf except extra allocated bytes *)
    mime_type: PAnsiChar;  (**< mime_type, when known. *)
  end;

const
  AVPROBE_SCORE_RETRY     = 25;     // (AVPROBE_SCORE_MAX/4);
  AVPROBE_SCORE_STREAM_RETRY = 24;  // (AVPROBE_SCORE_MAX/4-1);

  AVPROBE_SCORE_EXTENSION = 50;   ///< score for file extension
  AVPROBE_SCORE_MIME      = 75;   ///< score for file mime type
  AVPROBE_SCORE_MAX       = 100;  ///< maximum score

  AVPROBE_PADDING_SIZE = 32;      ///< extra allocated bytes at the end of the probe buffer

/// Demuxer will use avio_open, no opened file should be provided by the caller.
  AVFMT_NOFILE        = $0001;
  AVFMT_NEEDNUMBER    = $0002; (**< Needs '%d' in filename. *)
  AVFMT_SHOW_IDS      = $0008; (**< Show format stream IDs numbers. *)
{$IFDEF FF_API_LAVF_FMT_RAWPICTURE}
  AVFMT_RAWPICTURE    = $0020; (**< Format wants AVPicture structure for
                                      raw picture data. @deprecated Not used anymore *)
{$ENDIF}
  AVFMT_GLOBALHEADER  = $0040; (**< Format wants global header. *)
  AVFMT_NOTIMESTAMPS  = $0080; (**< Format does not need / have any timestamps. *)
  AVFMT_GENERIC_INDEX = $0100; (**< Use generic index building code. *)
  AVFMT_TS_DISCONT    = $0200; (**< Format allows timestamp discontinuities. Note, muxers always require valid (monotone) timestamps *)
  AVFMT_VARIABLE_FPS  = $0400; (**< Format allows variable fps. *)
  AVFMT_NODIMENSIONS  = $0800; (**< Format does not need width/height *)
  AVFMT_NOSTREAMS     = $1000; (**< Format does not require any streams *)
  AVFMT_NOBINSEARCH   = $2000; (**< Format does not allow to fall back on binary search via read_timestamp *)
  AVFMT_NOGENSEARCH   = $4000; (**< Format does not allow to fall back on generic search *)
  AVFMT_NO_BYTE_SEEK  = $8000; (**< Format does not allow seeking by bytes *)
  AVFMT_ALLOW_FLUSH   = $10000; (**< Format allows flushing. If not set, the muxer will not receive a NULL packet in the write_packet function. *)
  AVFMT_TS_NONSTRICT  = $20000; (**< Format does not require strictly
                                     increasing timestamps, but they must
                                     still be monotonic *)
  AVFMT_TS_NEGATIVE   = $40000; (**< Format allows muxing negative
                                     timestamps. If not set the timestamp
                                     will be shifted in av_write_frame and
                                     av_interleaved_write_frame so they
                                     start from 0.
                                     The user or muxer can override this through
                                     AVFormatContext.avoid_negative_ts
                                     *)

  AVFMT_SEEK_TO_PTS   = $4000000; (**< Seeking is based on PTS *)

{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
const
  AVSTREAM_PARSE_NONE        = 0;
  AVSTREAM_PARSE_FULL        = 1;
  AVSTREAM_PARSE_HEADERS     = 2;
  AVSTREAM_PARSE_TIMESTAMPS  = 3;
  AVSTREAM_PARSE_FULL_ONCE   = 4;
  AVSTREAM_PARSE_FULL_RAW    =(0 or (Ord('R') shl 8) or (Ord('A') shl 16) or (Ord('W') shl 24));
{$IFEND}

(**
 * @addtogroup lavf_encoding
 * @{
 *)
type
(**
 * List of devices.
 *)
  PPAVDeviceInfo = ^PAVDeviceInfo;
  PAVDeviceInfo = ^TAVDeviceInfo;
  TAVDeviceInfo = record
    device_name: PAnsiChar;                   (**< device name, format depends on device *)
    device_description: PAnsiChar;            (**< human friendly name *)
  end;


  PPAVDeviceInfoList = ^PAVDeviceInfoList;
  PAVDeviceInfoList = ^TAVDeviceInfoList;
  TAVDeviceInfoList = record
    devices: PPAVDeviceInfo;                  (**< list of autodetected devices *)
    nb_devices: Integer;                      (**< number of autodetected devices *)
    default_device: Integer;                  (**< index of default device or -1 if no default *)
  end;



(**
 * Following API allows user to probe device capabilities (supported codecs,
 * pixel formats, sample formats, resolutions, channel counts, etc).
 * It is build on top op AVOption API.
 * Queried capabilities make it possible to set up converters of video or audio
 * parameters that fit to the device.
 *
 * List of capabilities that can be queried:
 *  - Capabilities valid for both audio and video devices:
 *    - codec:          supported audio/video codecs.
 *                      type: AV_OPT_TYPE_INT (AVCodecID value)
 *  - Capabilities valid for audio devices:
 *    - sample_format:  supported sample formats.
 *                      type: AV_OPT_TYPE_INT (AVSampleFormat value)
 *    - sample_rate:    supported sample rates.
 *                      type: AV_OPT_TYPE_INT
 *    - channels:       supported number of channels.
 *                      type: AV_OPT_TYPE_INT
 *    - channel_layout: supported channel layouts.
 *                      type: AV_OPT_TYPE_INT64
 *  - Capabilities valid for video devices:
 *    - pixel_format:   supported pixel formats.
 *                      type: AV_OPT_TYPE_INT (AVPixelFormat value)
 *    - window_size:    supported window sizes (describes size of the window size presented to the user).
 *                      type: AV_OPT_TYPE_IMAGE_SIZE
 *    - frame_size:     supported frame sizes (describes size of provided video frames).
 *                      type: AV_OPT_TYPE_IMAGE_SIZE
 *    - fps:            supported fps values
 *                      type: AV_OPT_TYPE_RATIONAL
 *
 * Value of the capability may be set by user using av_opt_set() function
 * and AVDeviceCapabilitiesQuery object. Following queries will
 * limit results to the values matching already set capabilities.
 * For example, setting a codec may impact number of formats or fps values
 * returned during next query. Setting invalid value may limit results to zero.
 *
 * Example of the usage basing on opengl output device:
 *
 * @code
 *  AVFormatContext *oc = NULL;
 *  AVDeviceCapabilitiesQuery *caps = NULL;
 *  AVOptionRanges *ranges;
 *  int ret;
 *
 *  if ((ret = avformat_alloc_output_context2(&oc, NULL, "opengl", NULL)) < 0)
 *      goto fail;
 *  if (avdevice_capabilities_create(&caps, oc, NULL) < 0)
 *      goto fail;
 *
 *  //query codecs
 *  if (av_opt_query_ranges(&ranges, caps, "codec", AV_OPT_MULTI_COMPONENT_RANGE)) < 0)
 *      goto fail;
 *  //pick codec here and set it
 *  av_opt_set(caps, "codec", AV_CODEC_ID_RAWVIDEO, 0);
 *
 *  //query format
 *  if (av_opt_query_ranges(&ranges, caps, "pixel_format", AV_OPT_MULTI_COMPONENT_RANGE)) < 0)
 *      goto fail;
 *  //pick format here and set it
 *  av_opt_set(caps, "pixel_format", AV_PIX_FMT_YUV420P, 0);
 *
 *  //query and set more capabilities
 *
 * fail:
 *  //clean up code
 *  avdevice_capabilities_free(&query, oc);
 *  avformat_free_context(oc);
 * @endcode
 *)

(**
 * Structure describes device capabilities.
 *
 * It is used by devices in conjunction with av_device_capabilities AVOption table
 * to implement capabilities probing API based on AVOption API. Should not be used directly.
 *)
  PPAVDeviceCapabilitiesQuery = ^PAVDeviceCapabilitiesQuery;
  PAVDeviceCapabilitiesQuery = ^TAVDeviceCapabilitiesQuery;

  PPAVFormatContext = ^PAVFormatContext;
  PAVFormatContext = ^TAVFormatContext;

  TAVDeviceCapabilitiesQuery = record
    av_class: PAVClass;
    device_context: PAVFormatContext;
    codec: TAVCodecID;
    sample_format: TAVSampleFormat;
    pixel_format: TAVPixelFormat;
    sample_rate: Integer;
    channels: Integer;
    channel_layout: Int64;
    window_width: Integer;
    window_height: Integer;
    frame_width: Integer;
    frame_height: Integer;
    fps: TAVRational;
 end;

  PAVOutputFormat = ^TAVOutputFormat;
  TAVOutputFormat = record
    name: PAnsiChar;
    (**
     * Descriptive name for the format, meant to be more human-readable
     * than name. You should use the NULL_IF_CONFIG_SMALL() macro
     * to define it.
     *)
    long_name: PAnsiChar;
    mime_type: PAnsiChar;
    extensions: PAnsiChar; (**< comma-separated filename extensions *)
    (* output support *)
    audio_codec: TAVCodecID;    (**< default audio codec *)
    video_codec: TAVCodecID;    (**< default video codec *)
    subtitle_codec: TAVCodecID; (**< default subtitle codec *)
    (**
     * can use flags: AVFMT_NOFILE, AVFMT_NEEDNUMBER,
     * AVFMT_GLOBALHEADER, AVFMT_NOTIMESTAMPS, AVFMT_VARIABLE_FPS,
     * AVFMT_NODIMENSIONS, AVFMT_NOSTREAMS, AVFMT_ALLOW_FLUSH,
     * AVFMT_TS_NONSTRICT, AVFMT_TS_NEGATIVE
     *)
    flags: Integer;

    (**
     * List of supported codec_id-codec_tag pairs, ordered by "better
     * choice first". The arrays are all terminated by AV_CODEC_ID_NONE.
     *)
    //const struct AVCodecTag * const *codec_tag;
    codec_tag: PPAVCodecTag;


    priv_class: PAVClass; ///< AVClass for the private context

    (*****************************************************************
     * No fields below this line are part of the public API. They
     * may not be used outside of libavformat and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     *)
    next: PAVOutputFormat;
    (**
     * size of private data so that it can be allocated in the wrapper
     *)
    priv_data_size: Integer;

    write_header: function(s: PAVFormatContext): Integer; cdecl;
    (**
     * Write a packet. If AVFMT_ALLOW_FLUSH is set in flags,
     * pkt can be NULL in order to flush data buffered in the muxer.
     * When flushing, return 0 if there still is more data to flush,
     * or 1 if everything was flushed and there is no more buffered
     * data.
     *)
    write_packet: function(s: PAVFormatContext; pkt: PAVPacket): Integer; cdecl;
    write_trailer: function(s: PAVFormatContext): Integer; cdecl;
    (**
     * Currently only used to set pixel format if not YUV420P.
     *)
    interleave_packet: function(s: PAVFormatContext; pktout: PAVPacket;
                                pktin: PAVPacket; flush: Integer): Integer; cdecl;
    (**
     * Test if the given codec can be stored in this container.
     *
     * @return 1 if the codec is supported, 0 if it is not.
     *         A negative number if unknown.
     *         MKTAG('A', 'P', 'I', 'C') if the codec is only supported as AV_DISPOSITION_ATTACHED_PIC
     *)
    query_codec: function(id: TAVCodecID; std_compliance: Integer): Integer; cdecl;

    get_output_timestamp: procedure(s: PAVFormatContext; stream: Integer;
                                 dts, wall: PInt64); cdecl;
    (**
     * Allows sending messages from application to device.
     *)
    control_message: function(s: PAVFormatContext; ttype: Integer;
                           data: Pointer; data_size: Cardinal): Integer; cdecl;

    (**
     * Write an uncoded AVFrame.
     *
     * See av_write_uncoded_frame() for details.
     *
     * The library will free *frame afterwards, but the muxer can prevent it
     * by setting the pointer to NULL.
     *)
    write_uncoded_frame: function(s: PAVFormatContext; stream_index: Integer;
                               frame: PPAVFrame; flags: Cardinal): Integer; cdecl;
    (**
     * Returns device list with it properties.
     * @see avdevice_list_devices() for more details.
     *)
    get_device_list: function(s: PAVFormatContext; device_list: PAVDeviceInfoList): Integer; cdecl;
    (**
     * Initialize device capabilities submodule.
     * @see avdevice_capabilities_create() for more details.
     *)
    create_device_capabilities: function(s: PAVFormatContext; caps: PAVDeviceCapabilitiesQuery): Integer; cdecl;
    (**
     * Free device capabilities submodule.
     * @see avdevice_capabilities_free() for more details.
     *)
    free_device_capabilities: function(s: PAVFormatContext; caps: PAVDeviceCapabilitiesQuery): Integer; cdecl;
    data_codec: TAVCodecID; (**< default data codec *)
    (**
     * Initialize format. May allocate data here, and set any AVFormatContext or
     * AVStream parameters that need to be set before packets are sent.
     * This method must not write output.
     *
     * Return 0 if streams were fully configured, 1 if not, negative AVERROR on failure
     *
     * Any allocations made here must be freed in deinit().
     *)
    init: function(s: PAVFormatContext): Integer; cdecl;
    (**
     * Deinitialize format. If present, this is called whenever the muxer is being
     * destroyed, regardless of whether or not the header has been written.
     *
     * If a trailer is being written, this is called after write_trailer().
     *
     * This is called if init() fails as well.
     *)
    deinit: procedure(s: PAVFormatContext); cdecl;
    (**
     * Set up any necessary bitstream filtering and extract any extra data needed
     * for the global header.
     * Return 0 if more packets from this stream must be checked; 1 if not.
     *)
    check_bitstream: function(s: PAVFormatContext; const pkt: PAVPacket): Integer; cdecl;
  end;
(**
 * @}
 *)

(**
 * @addtogroup lavf_decoding
 * @{
 *)
  PPAVInputFormat = ^PAVInputFormat;
  PAVInputFormat = ^TAVInputFormat;
  TAVInputFormat = record
    (**
     * A comma separated list of short names for the format. New names
     * may be appended with a minor bump.
     *)
    name: PAnsiChar;

    (**
     * Descriptive name for the format, meant to be more human-readable
     * than name. You should use the NULL_IF_CONFIG_SMALL() macro
     * to define it.
     *)
    long_name: PAnsiChar;

    (**
     * Can use flags: AVFMT_NOFILE, AVFMT_NEEDNUMBER, AVFMT_SHOW_IDS,
     * AVFMT_GENERIC_INDEX, AVFMT_TS_DISCONT, AVFMT_NOBINSEARCH,
     * AVFMT_NOGENSEARCH, AVFMT_NO_BYTE_SEEK, AVFMT_SEEK_TO_PTS.
     *)
    flags: Integer;

    (**
     * If extensions are defined, then no probe is done. You should
     * usually not use extension format guessing because it is not
     * reliable enough
     *)
    extensions: PAnsiChar;

    codec_tag: PPAVCodecTag;

    priv_class: PAVClass; ///< AVClass for the private context

    (**
     * Comma-separated list of mime types.
     * It is used check for matching mime types while probing.
     * @see av_probe_input_format2
     *)
    mime_type: PAnsiChar;

    (*****************************************************************
     * No fields below this line are part of the public API. They
     * may not be used outside of libavformat and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     *)
    next: PAVInputFormat;

    (**
     * Raw demuxers store their codec ID here.
     *)
    raw_codec_id: Integer;

    (**
     * Size of private data so that it can be allocated in the wrapper.
     *)
    priv_data_size: Integer;

    (**
     * Tell if a given file has a chance of being parsed as this format.
     * The buffer provided is guaranteed to be AVPROBE_PADDING_SIZE bytes
     * big so you do not have to check for that unless you need more.
     *)
    read_probe: function(p: PAVProbeData): Integer; cdecl;

    (**
     * Read the format header and initialize the AVFormatContext
     * structure. Return 0 if OK. 'avformat_new_stream' should be
     * called to create new streams.
     *)
    read_header: function(s: PAVFormatContext): Integer; cdecl;

    (**
     * Read one packet and put it in 'pkt'. pts and flags are also
     * set. 'avformat_new_stream' can be called only if the flag
     * AVFMTCTX_NOHEADER is used and only in the calling thread (not in a
     * background thread).
     * @return 0 on success, < 0 on error.
     *         When returning an error, pkt must not have been allocated
     *         or must be freed before returning
     *)
    read_packet: function(s: PAVFormatContext; pkt: PAVPacket): Integer; cdecl;

    (**
     * Close the stream. The AVFormatContext and AVStreams are not
     * freed by this function
     *)
    read_close: function(s: PAVFormatContext): Integer; cdecl;

    (**
     * Seek to a given timestamp relative to the frames in
     * stream component stream_index.
     * @param stream_index Must not be -1.
     * @param flags Selects which direction should be preferred if no exact
     *              match is available.
     * @return >= 0 on success (but not necessarily the new offset)
     *)
    read_seek: function(s: PAVFormatContext;
                     stream_index: Integer; timestamp: Int64; flags: Integer): Integer; cdecl;

    (**
     * Get the next timestamp in stream[stream_index].time_base units.
     * @return the timestamp or AV_NOPTS_VALUE if an error occurred
     *)
    read_timestamp: function(s: PAVFormatContext; stream_index: Integer;
                              pos: PInt64; pos_limit: Int64): Int64; cdecl;

    (**
     * Start/resume playing - only meaningful if using a network-based format
     * (RTSP).
     *)
    read_play: function(s: PAVFormatContext): Integer; cdecl;

    (**
     * Pause playing - only meaningful if using a network-based format
     * (RTSP).
     *)
    read_pause: function(s: PAVFormatContext): Integer; cdecl;

    (**
     * Seek to timestamp ts.
     * Seeking will be done so that the point from which all active streams
     * can be presented successfully will be closest to ts and within min/max_ts.
     * Active streams are all streams that have AVStream.discard < AVDISCARD_ALL.
     *)
    read_seek2: function(s: PAVFormatContext; stream_index: Integer; min_ts, ts, max_ts: Int64; flags: Integer): Integer; cdecl;

    (**
     * Returns device list with it properties.
     * @see avdevice_list_devices() for more details.
     *)
    get_device_list: function(s: PAVFormatContext; device_list: PAVDeviceInfoList): Integer; cdecl;

    (**
     * Initialize device capabilities submodule.
     * @see avdevice_capabilities_create() for more details.
     *)
    create_device_capabilities: function(s: PAVFormatContext; caps: PAVDeviceCapabilitiesQuery): Integer; cdecl;

    (**
     * Free device capabilities submodule.
     * @see avdevice_capabilities_free() for more details.
     *)
    free_device_capabilities: function(s: PAVFormatContext; caps: PAVDeviceCapabilitiesQuery): Integer; cdecl;
  end;
(**
 * @}
 *)

{$IF Defined(BCB) and Defined(VER140)} // C++Builder 6
  TAVStreamParseType = Integer;
{$ELSE}
  TAVStreamParseType = (
    AVSTREAM_PARSE_NONE,
    AVSTREAM_PARSE_FULL,       (**< full parsing and repack *)
    AVSTREAM_PARSE_HEADERS,    (**< Only parse headers, don't repack. *)
    AVSTREAM_PARSE_TIMESTAMPS, (**< full parsing and interpolation of timestamps for frames not starting on a packet boundary *)
    AVSTREAM_PARSE_FULL_ONCE,  (**< full parsing and repack of the first frame only, only implemented for H.264 currently *)
    (**< full parsing and repack with timestamp and position generation by parser for raw
      this assumes that each packet in the file contains no demuxer level headers and
      just codec level data, otherwise position generation would fail *)
    AVSTREAM_PARSE_FULL_RAW=(0 or (Ord('R') shl 8) or (Ord('A') shl 16) or (Ord('W') shl 24))
  );
{$IFEND}

  PAVIndexEntry = ^TAVIndexEntry;
  TAVIndexEntry = record
    pos: Int64;
    timestamp: Int64;         (**<
                               * Timestamp in AVStream.time_base units, preferably the time from which on correctly decoded frames are available
                               * when seeking to this entry. That means preferable PTS on keyframe based formats.
                               * But demuxers can choose to store a different timestamp, if it is more convenient for the implementation or nothing better
                               * is known
                               *)
//#define AVINDEX_KEYFRAME 0x0001
//#define AVINDEX_DISCARD_FRAME  0x0002 (** Flag is used to indicate which frame should be discarded after decoding. *)
//    int flags:2;
//    int size:30; //Yeah, trying to keep the size of this small to reduce memory requirements (it is 24 vs. 32 bytes due to possible 8-byte alignment).
    flags_size: Integer;
    min_distance: Integer;         (**< Minimum distance between this and the previous keyframe, used to avoid unneeded searching. *)
  end;

  (**
   * Stream information used internally by av_find_stream_info()
   *)
  Pduration_error = ^Tduration_error;
  Tduration_error = array[0..1] of array[0..MAX_STD_TIMEBASES - 1] of Double;
  PInterStreamInfo = ^TInterStreamInfo;
  TInterStreamInfo = record
    last_dts: Int64;
    duration_gcd: Int64;
    duration_count: Integer;
    rfps_duration_sum: Int64;
    //double (*duration_error)[2][MAX_STD_TIMEBASES];
    duration_error: Pduration_error;
    codec_info_duration: Int64;
    codec_info_duration_fields: Int64;

    (**
     * 0  -> decoder has not been searched for yet.
     * >0 -> decoder found
     * <0 -> decoder with codec_id == -found_decoder has not been found
     *)
    found_decoder: Integer;

    last_duration: Int64;

    (**
     * Those are used for average framerate estimation.
     *)
    fps_first_dts: Int64;
    fps_first_dts_idx: Integer;
    fps_last_dts: Int64;
    fps_last_dts_idx: Integer;

  end;

  PAVPacketList = ^TAVPacketList;
  TAVPacketList = record
    pkt: TAVPacket;
    next: PAVPacketList;
  end;

  // TODO: check libavformat/internal.h
  Textract_extradata = record
    bsf: PAVBSFContext;
    pkt: PAVPacket;
    inited: Integer;
  end;
  PAVStreamInternal = ^TAVStreamInternal;
  TAVStreamInternal = record
    (**
     * Set to 1 if the codec allows reordering, so pts can be different
     * from dts.
     *)
    reorder: Integer;

    (**
     * bitstream filters to run on stream
     * - encoding: Set by muxer using ff_stream_add_bitstream_filter
     * - decoding: unused
     *)
    bsfcs: PPAVBSFContext;
    nb_bsfcs: Integer;

    (**
     * Whether or not check_bitstream should still be run on each packet
     *)
    bitstream_checked: Integer;

    (**
     * The codec context used by avformat_find_stream_info, the parser, etc.
     *)
    avctx: PAVCodecContext;
    (**
     * 1 if avctx has been initialized with the values from the codec parameters
     *)
    avctx_inited: Integer;

    orig_codec_id: TAVCodecID;

    (* the context for extracting extradata in find_stream_info()
     * inited=1/bsf=NULL signals that extracting is not possible (codec not
     * supported) *)
    extract_extradata: Textract_extradata;

    (**
     * Whether the internal avctx needs to be updated from codecpar (after a late change to codecpar)
     *)
    need_context_update: Integer;
  end;

(**
 * Stream structure.
 * New fields can be added to the end with minor version bumps.
 * Removal, reordering and changes to existing fields require a major
 * version bump.
 * sizeof(AVStream) must not be used outside libav*.
 *)
  PPAVStream = ^PAVStream;
  PAVStream = ^TAVStream;
  TAVStream = record
    index: Integer;    (**< stream index in AVFormatContext *)
    (**
     * Format-specific stream ID.
     * decoding: set by libavformat
     * encoding: set by the user, replaced by libavformat if left unset
     *)
    id: Integer;
{$IFDEF FF_API_LAVF_AVCTX}
    (**
     * @deprecated use the codecpar struct instead
     *)
    codec: PAVCodecContext;
{$ENDIF}
    priv_data: Pointer;

{$IFDEF FF_API_LAVF_FRAC}
    (**
     * @deprecated this field is unused
     *)
    pts: TAVFrac;
{$ENDIF}

    (**
     * This is the fundamental unit of time (in seconds) in terms
     * of which frame timestamps are represented.
     *
     * decoding: set by libavformat
     * encoding: May be set by the caller before avformat_write_header() to
     *           provide a hint to the muxer about the desired timebase. In
     *           avformat_write_header(), the muxer will overwrite this field
     *           with the timebase that will actually be used for the timestamps
     *           written into the file (which may or may not be related to the
     *           user-provided one, depending on the format).
     *)
    time_base: TAVRational;

    (**
     * Decoding: pts of the first frame of the stream in presentation order, in stream time base.
     * Only set this if you are absolutely 100% sure that the value you set
     * it to really is the pts of the first frame.
     * This may be undefined (AV_NOPTS_VALUE).
     * @note The ASF header does NOT contain a correct start_time the ASF
     * demuxer must NOT set this.
     *)
    start_time: Int64;

    (**
     * Decoding: duration of the stream, in stream time base.
     * If a source file does not specify a duration, but does specify
     * a bitrate, this value will be estimated from bitrate and file size.
     *
     * Encoding: May be set by the caller before avformat_write_header() to
     * provide a hint to the muxer about the estimated duration.
     *)
    duration: Int64;

    nb_frames: Int64;                 ///< number of frames in this stream if known or 0

    disposition: Integer; (**< AV_DISPOSITION_* bit field *)

    discard: TAVDiscard; ///< Selects which packets can be discarded at will and do not need to be demuxed.

    (**
     * sample aspect ratio (0 if unknown)
     * - encoding: Set by user.
     * - decoding: Set by libavformat.
     *)
    sample_aspect_ratio: TAVRational;

    metadata: PAVDictionary;

    (**
     * Average framerate
     *
     * - demuxing: May be set by libavformat when creating the stream or in
     *             avformat_find_stream_info().
     * - muxing: May be set by the caller before avformat_write_header().
     *)
    avg_frame_rate: TAVRational;

    (**
     * For streams with AV_DISPOSITION_ATTACHED_PIC disposition, this packet
     * will contain the attached picture.
     *
     * decoding: set by libavformat, must not be modified by the caller.
     * encoding: unused
     *)
    attached_pic: TAVPacket;

    (**
     * An array of side data that applies to the whole stream (i.e. the
     * container does not allow it to change between packets).
     *
     * There may be no overlap between the side data in this array and side data
     * in the packets. I.e. a given side data is either exported by the muxer
     * (demuxing) / set by the caller (muxing) in this array, then it never
     * appears in the packets, or the side data is exported / sent through
     * the packets (always in the first packet where the value becomes known or
     * changes), then it does not appear in this array.
     *
     * - demuxing: Set by libavformat when the stream is created.
     * - muxing: May be set by the caller before avformat_write_header().
     *
     * Freed by libavformat in avformat_free_context().
     *
     * @see av_format_inject_global_side_data()
     *)
    side_data: PAVPacketSideData;
    (**
     * The number of elements in the AVStream.side_data array.
     *)
    nb_side_data: Integer;

    (**
     * Flags for the user to detect events happening on the stream. Flags must
     * be cleared by the user once the event has been handled.
     * A combination of AVSTREAM_EVENT_FLAG_*.
     *)
    event_flags: Integer;
//#define AVSTREAM_EVENT_FLAG_METADATA_UPDATED 0x0001 ///< The call resulted in updated metadata.

    (*****************************************************************
     * All fields below this line are not part of the public API. They
     * may not be used outside of libavformat and can be changed and
     * removed at will.
     * Internal note: be aware that physically removing these fields
     * will break ABI. Replace removed fields with dummy fields, and
     * add new fields to AVStreamInternal.
     *****************************************************************
     *)

    (**
     * Stream information used internally by avformat_find_stream_info()
     *)
(*
#define MAX_STD_TIMEBASES (30*12+7+6)
    struct {
        int64_t last_dts;
        int64_t duration_gcd;
        int duration_count;
        int64_t rfps_duration_sum;
        double (*duration_error)[2][MAX_STD_TIMEBASES];
        int64_t codec_info_duration;
        int64_t codec_info_duration_fields;

        /**
         * 0  -> decoder has not been searched for yet.
         * >0 -> decoder found
         * <0 -> decoder with codec_id == -found_decoder has not been found
         */
        int found_decoder;

        int64_t last_duration;

        /**
         * Those are used for average framerate estimation.
         */
        int64_t fps_first_dts;
        int     fps_first_dts_idx;
        int64_t fps_last_dts;
        int     fps_last_dts_idx;

    } *info;
*)
    info: PInterStreamInfo;

    pts_wrap_bits: Integer; (**< number of bits in pts (used for wrapping control) *)

    // Timestamp generation support:
    (**
     * Timestamp corresponding to the last dts sync point.
     *
     * Initialized when AVCodecParserContext.dts_sync_point >= 0 and
     * a DTS is received from the underlying container. Otherwise set to
     * AV_NOPTS_VALUE by default.
     *)
    first_dts: Int64;
    cur_dts: Int64;
    last_IP_pts: Int64;
    last_IP_duration: Integer;

    (**
     * Number of packets to buffer for codec probing
     *)
    probe_packets: Integer;

    (**
     * Number of frames that have been demuxed during avformat_find_stream_info()
     *)
    codec_info_nb_frames: Integer;

    (* av_read_frame() support *)
    need_parsing: TAVStreamParseType;
    parser: PAVCodecParserContext;

    (**
     * last packet in packet_buffer for this stream when muxing.
     *)
    last_in_packet_buffer: PAVPacketList;
    probe_data: TAVProbeData;
//#define MAX_REORDER_DELAY 16
    pts_buffer: array[0..MAX_REORDER_DELAY] of Int64;

    index_entries: PAVIndexEntry; (**< Only used if the format does not
                                    support seeking natively. *)
    nb_index_entries: Integer;
    index_entries_allocated_size: Cardinal;

    (**
     * Real base framerate of the stream.
     * This is the lowest framerate with which all timestamps can be
     * represented accurately (it is the least common multiple of all
     * framerates in the stream). Note, this value is just a guess!
     * For example, if the time base is 1/90000 and all frames have either
     * approximately 3600 or 1800 timer ticks, then r_frame_rate will be 50/1.
     *
     * Code outside avformat should access this field using:
     * av_stream_get/set_r_frame_rate(stream)
     *)
    r_frame_rate: TAVRational;

    (**
     * Stream Identifier
     * This is the MPEG-TS stream identifier +1
     * 0 means unknown
     *)
    stream_identifier: Integer;

    interleaver_chunk_size: Int64;
    interleaver_chunk_duration: Int64;

    (**
     * stream probing state
     * -1   -> probing finished
     *  0   -> no probing requested
     * rest -> perform probing with request_probe being the minimum score to accept.
     * NOT PART OF PUBLIC API
     *)
    request_probe: Integer;
    (**
     * Indicates that everything up to the next keyframe
     * should be discarded.
     *)
    skip_to_keyframe: Integer;

    (**
     * Number of samples to skip at the start of the frame decoded from the next packet.
     *)
    skip_samples: Integer;

    (**
     * If not 0, the number of samples that should be skipped from the start of
     * the stream (the samples are removed from packets with pts==0, which also
     * assumes negative timestamps do not happen).
     * Intended for use with formats such as mp3 with ad-hoc gapless audio
     * support.
     *)
    start_skip_samples: Int64;

    (**
     * If not 0, the first audio sample that should be discarded from the stream.
     * This is broken by design (needs global sample count), but can't be
     * avoided for broken by design formats such as mp3 with ad-hoc gapless
     * audio support.
     *)
    first_discard_sample: Int64;

    (**
     * The sample after last sample that is intended to be discarded after
     * first_discard_sample. Works on frame boundaries only. Used to prevent
     * early EOF if the gapless info is broken (considered concatenated mp3s).
     *)
    last_discard_sample: Int64;

    (**
     * Number of internally decoded frames, used internally in libavformat, do not access
     * its lifetime differs from info which is why it is not in that structure.
     *)
    nb_decoded_frames: Integer;

    (**
     * Timestamp offset added to timestamps before muxing
     * NOT PART OF PUBLIC API
     *)
    mux_ts_offset: Int64;

    (**
     * Internal data to check for wrapping of the time stamp
     *)
    pts_wrap_reference: Int64;

    (**
     * Options for behavior, when a wrap is detected.
     *
     * Defined by AV_PTS_WRAP_ values.
     *
     * If correction is enabled, there are two possibilities:
     * If the first time stamp is near the wrap point, the wrap offset
     * will be subtracted, which will create negative time stamps.
     * Otherwise the offset will be added.
     *)
    pts_wrap_behavior: Integer;

    (**
     * Internal data to prevent doing update_initial_durations() twice
     *)
    update_initial_durations_done: Integer;

    (**
     * Internal data to generate dts from pts
     *)
    pts_reorder_error: array[0..MAX_REORDER_DELAY] of Int64;
    pts_reorder_error_count: array[0..MAX_REORDER_DELAY] of Byte;

    (**
     * Internal data to analyze DTS and detect faulty mpeg streams
     *)
    last_dts_for_order_check: Int64;
    dts_ordered: Byte;
    dts_misordered: Byte;

    (**
     * Internal data to inject global side data
     *)
    inject_global_side_data: Integer;

    (*****************************************************************
     * All fields above this line are not part of the public API.
     * Fields below are part of the public API and ABI again.
     *****************************************************************
     *)

    (**
     * String containing paris of key and values describing recommended encoder configuration.
     * Paris are separated by ','.
     * Keys are separated from values by '='.
     *)
    recommended_encoder_configuration: PAnsiChar;

    (**
     * display aspect ratio (0 if unknown)
     * - encoding: unused
     * - decoding: Set by libavformat to calculate sample_aspect_ratio internally
     *)
    display_aspect_ratio: TAVRational;

    priv_pts: Pointer; // PFFFrac;

    (**
     * An opaque field for libavformat internal usage.
     * Must not be accessed in any way by callers.
     *)
    internal: PAVStreamInternal;

    (*
     * Codec parameters associated with this stream. Allocated and freed by
     * libavformat in avformat_new_stream() and avformat_free_context()
     * respectively.
     *
     * - demuxing: filled by libavformat on stream creation or in
     *             avformat_find_stream_info()
     * - muxing: filled by the caller before avformat_write_header()
     *)
    codecpar: PAVCodecParameters;
  end;

(**
 * New fields can be added to the end with minor version bumps.
 * Removal, reordering and changes to existing fields require a major
 * version bump.
 * sizeof(AVProgram) must not be used outside libav*.
 *)
  PPAVProgram = ^PAVProgram;
  PAVProgram = ^TAVProgram;
  TAVProgram = record
    id: Integer;
    flags: Integer;
    discard: TAVDiscard;  ///< selects which program to discard and which to feed to the caller
    stream_index: PCardinal;
    nb_stream_indexes: Cardinal;
    metadata: PAVDictionary;

    program_num: Integer;
    pmt_pid: Integer;
    pcr_pid: Integer;

    (*****************************************************************
     * All fields below this line are not part of the public API. They
     * may not be used outside of libavformat and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     *)
    start_time: Int64;
    end_time: Int64;

    pts_wrap_reference: Int64;    ///< reference dts for wrap detection
    pts_wrap_behavior: Integer;   ///< behavior on wrap detection
  end;

  PPAVChapter = ^PAVChapter;
  PAVChapter = ^TAVChapter;
  TAVChapter = record
    id: Integer;            ///< unique ID to identify the chapter
    time_base: TAVRational; ///< time base in which the start/end timestamps are specified
    start, eend: Int64;     ///< chapter start/end time in time_base units
    metadata: PAVDictionary;
  end;


(**
 * Callback used by devices to communicate with application.
 *)
  Tav_format_control_messageCall = function(s: PAVFormatContext; ttype: Integer;
                                         data: Pointer; data_size: Cardinal): Integer; cdecl;

  TAVOpenCallback = function(s: PAVFormatContext; pb: PPAVIOContext; const url: PAnsiChar; flags: Integer;
                              const int_cb: PAVIOInterruptCB; options: PPAVDictionary): Integer; cdecl;

(**
 * The duration of a video can be estimated through various ways, and this enum can be used
 * to know how the duration was estimated.
 *)
  TAVDurationEstimationMethod = (
    AVFMT_DURATION_FROM_PTS,    ///< Duration accurately estimated from PTSes
    AVFMT_DURATION_FROM_STREAM, ///< Duration estimated from a stream with a known duration
    AVFMT_DURATION_FROM_BITRATE ///< Duration estimated from bitrate (less accurate)
  );

  PAVFormatInternal = ^TAVFormatInternal;
  TAVFormatInternal = record
    // need {$ALIGN 8}
    // defined in libavformat/internal.h
  end;

(**
 * Format I/O context.
 * New fields can be added to the end with minor version bumps.
 * Removal, reordering and changes to existing fields require a major
 * version bump.
 * sizeof(AVFormatContext) must not be used outside libav*, use
 * avformat_alloc_context() to create an AVFormatContext.
 *
 * Fields can be accessed through AVOptions (av_opt* ),
 * the name string used matches the associated command line parameter name and
 * can be found in libavformat/options_table.h.
 * The AVOption/command line parameter names differ in some cases from the C
 * structure field names for historic reasons or brevity.
 *)
  TAVFormatContext = record
    (**
     * A class for logging and @ref avoptions. Set by avformat_alloc_context().
     * Exports (de)muxer private options if they exist.
     *)
    av_class: PAVClass;

    (**
     * The input container format.
     *
     * Demuxing only, set by avformat_open_input().
     *)
    iformat: PAVInputFormat;

    (**
     * The output container format.
     *
     * Muxing only, must be set by the caller before avformat_write_header().
     *)
    oformat: PAVOutputFormat;

    (**
     * Format private data. This is an AVOptions-enabled struct
     * if and only if iformat/oformat.priv_class is not NULL.
     *
     * - muxing: set by avformat_write_header()
     * - demuxing: set by avformat_open_input()
     *)
    priv_data: Pointer;

    (**
     * I/O context.
     *
     * - demuxing: either set by the user before avformat_open_input() (then
     *             the user must close it manually) or set by avformat_open_input().
     * - muxing: set by the user before avformat_write_header(). The caller must
     *           take care of closing / freeing the IO context.
     *
     * Do NOT set this field if AVFMT_NOFILE flag is set in
     * iformat/oformat.flags. In such a case, the (de)muxer will handle
     * I/O in some other way and this field will be NULL.
     *)
    pb: PAVIOContext;

    (* stream info *)
    (**
     * Flags signalling stream properties. A combination of AVFMTCTX_*.
     * Set by libavformat.
     *)
    ctx_flags: Integer;

    (**
     * Number of elements in AVFormatContext.streams.
     *
     * Set by avformat_new_stream(), must not be modified by any other code.
     *)
    nb_streams: Cardinal;
    (**
     * A list of all streams in the file. New streams are created with
     * avformat_new_stream().
     *
     * - demuxing: streams are created by libavformat in avformat_open_input().
     *             If AVFMTCTX_NOHEADER is set in ctx_flags, then new streams may also
     *             appear in av_read_frame().
     * - muxing: streams are created by the user before avformat_write_header().
     *
     * Freed by libavformat in avformat_free_context().
     *)
    streams: PPAVStream;

    (**
     * input or output filename
     *
     * - demuxing: set by avformat_open_input()
     * - muxing: may be set by the caller before avformat_write_header()
     *)
    filename: array[0..1024-1] of AnsiChar;

    (**
     * Position of the first frame of the component, in
     * AV_TIME_BASE fractional seconds. NEVER set this value directly:
     * It is deduced from the AVStream values.
     *
     * Demuxing only, set by libavformat.
     *)
    start_time: Int64;

    (**
     * Duration of the stream, in AV_TIME_BASE fractional
     * seconds. Only set this value if you know none of the individual stream
     * durations and also do not set any of them. This is deduced from the
     * AVStream values if not set.
     *
     * Demuxing only, set by libavformat.
     *)
    duration: Int64;

    (**
     * Total stream bitrate in bit/s, 0 if not
     * available. Never set it directly if the file_size and the
     * duration are known as FFmpeg can compute it automatically.
     *)
    bit_rate: Int64;

    packet_size: Cardinal;
    max_delay: Integer;

    (**
     * Flags modifying the (de)muxer behaviour. A combination of AVFMT_FLAG_*.
     * Set by the user before avformat_open_input() / avformat_write_header().
     *)
    flags: Integer;
{
#define AVFMT_FLAG_GENPTS       0x0001 ///< Generate missing pts even if it requires parsing future frames.
#define AVFMT_FLAG_IGNIDX       0x0002 ///< Ignore index.
#define AVFMT_FLAG_NONBLOCK     0x0004 ///< Do not block when reading packets from input.
#define AVFMT_FLAG_IGNDTS       0x0008 ///< Ignore DTS on frames that contain both DTS & PTS
#define AVFMT_FLAG_NOFILLIN     0x0010 ///< Do not infer any values from other values, just return what is stored in the container
#define AVFMT_FLAG_NOPARSE      0x0020 ///< Do not use AVParsers, you also must set AVFMT_FLAG_NOFILLIN as the fillin code works on frames and no parsing -> no frames. Also seeking to frames can not work if parsing to find frame boundaries has been disabled
#define AVFMT_FLAG_NOBUFFER     0x0040 ///< Do not buffer frames when possible
#define AVFMT_FLAG_CUSTOM_IO    0x0080 ///< The caller has supplied a custom AVIOContext, don't avio_close() it.
#define AVFMT_FLAG_DISCARD_CORRUPT  0x0100 ///< Discard frames marked corrupted
#define AVFMT_FLAG_FLUSH_PACKETS    0x0200 ///< Flush the AVIOContext every packet.
/**
 * When muxing, try to avoid writing any random/volatile data to the output.
 * This includes any random IDs, real-time timestamps/dates, muxer version, etc.
 *
 * This flag is mainly intended for testing.
 */
#define AVFMT_FLAG_BITEXACT         0x0400
#define AVFMT_FLAG_MP4A_LATM    0x8000 ///< Enable RTP MP4A-LATM payload
#define AVFMT_FLAG_SORT_DTS    0x10000 ///< try to interleave outputted packets by dts (using this flag can slow demuxing down)
#define AVFMT_FLAG_PRIV_OPT    0x20000 ///< Enable use of private options by delaying codec open (this could be made default once all code is converted)
#if FF_API_LAVF_KEEPSIDE_FLAG
#define AVFMT_FLAG_KEEP_SIDE_DATA 0x40000 ///< Don't merge side data but keep it separate. Deprecated, will be the default.
#endif
#define AVFMT_FLAG_FAST_SEEK   0x80000 ///< Enable fast, but inaccurate seeks for some formats
#define AVFMT_FLAG_SHORTEST   0x100000 ///< Stop muxing when the shortest stream stops.
#define AVFMT_FLAG_AUTO_BSF   0x200000 ///< Wait for packet data before writing a header, and add bitstream filters as requested by the muxer
}

    (**
     * Maximum size of the data read from input for determining
     * the input container format.
     * Demuxing only, set by the caller before avformat_open_input().
     *)
    probesize: Int64;

    (**
     * Maximum duration (in AV_TIME_BASE units) of the data read
     * from input in avformat_find_stream_info().
     * Demuxing only, set by the caller before avformat_find_stream_info().
     * Can be set to 0 to let avformat choose using a heuristic.
     *)
    max_analyze_duration: Int64;

    key: PByte;
    keylen: Integer;

    nb_programs: Cardinal;
    programs: PPAVProgram;

    (**
     * Forced video codec_id.
     * Demuxing: Set by user.
     *)
    video_codec_id: TAVCodecID;

    (**
     * Forced audio codec_id.
     * Demuxing: Set by user.
     *)
    audio_codec_id: TAVCodecID;

    (**
     * Forced subtitle codec_id.
     * Demuxing: Set by user.
     *)
    subtitle_codec_id: TAVCodecID;

    (**
     * Maximum amount of memory in bytes to use for the index of each stream.
     * If the index exceeds this size, entries will be discarded as
     * needed to maintain a smaller size. This can lead to slower or less
     * accurate seeking (depends on demuxer).
     * Demuxers for which a full in-memory index is mandatory will ignore
     * this.
     * - muxing: unused
     * - demuxing: set by user
     *)
    max_index_size: Cardinal;

    (**
     * Maximum amount of memory in bytes to use for buffering frames
     * obtained from realtime capture devices.
     *)
    max_picture_buffer: Cardinal;

    (**
     * Number of chapters in AVChapter array.
     * When muxing, chapters are normally written in the file header,
     * so nb_chapters should normally be initialized before write_header
     * is called. Some muxers (e.g. mov and mkv) can also write chapters
     * in the trailer.  To write chapters in the trailer, nb_chapters
     * must be zero when write_header is called and non-zero when
     * write_trailer is called.
     * - muxing: set by user
     * - demuxing: set by libavformat
     *)
    nb_chapters: Cardinal;
    chapters: PPAVChapter;

    (**
     * Metadata that applies to the whole file.
     *
     * - demuxing: set by libavformat in avformat_open_input()
     * - muxing: may be set by the caller before avformat_write_header()
     *
     * Freed by libavformat in avformat_free_context().
     *)
    metadata: PAVDictionary;

    (**
     * Start time of the stream in real world time, in microseconds
     * since the Unix epoch (00:00 1st January 1970). That is, pts=0 in the
     * stream was captured at this real world time.
     * - muxing: Set by the caller before avformat_write_header(). If set to
     *           either 0 or AV_NOPTS_VALUE, then the current wall-time will
     *           be used.
     * - demuxing: Set by libavformat. AV_NOPTS_VALUE if unknown. Note that
     *             the value may become known after some number of frames
     *             have been received.
     *)
    start_time_realtime: Int64;


    (**
     * The number of frames used for determining the framerate in
     * avformat_find_stream_info().
     * Demuxing only, set by the caller before avformat_find_stream_info().
     *)
    fps_probe_size: Integer;

    (**
     * Error recognition; higher values will detect more errors but may
     * misdetect some more or less valid parts as errors.
     * Demuxing only, set by the caller before avformat_open_input().
     *)
    error_recognition: Integer;

    (**
     * Custom interrupt callbacks for the I/O layer.
     *
     * demuxing: set by the user before avformat_open_input().
     * muxing: set by the user before avformat_write_header()
     * (mainly useful for AVFMT_NOFILE formats). The callback
     * should also be passed to avio_open2() if it's used to
     * open the file.
     *)
    interrupt_callback: TAVIOInterruptCB;

    (**
     * Flags to enable debugging.
     *)
    debug: Integer;
//#define FF_FDEBUG_TS        0x0001

    (**
     * Maximum buffering duration for interleaving.
     *
     * To ensure all the streams are interleaved correctly,
     * av_interleaved_write_frame() will wait until it has at least one packet
     * for each stream before actually writing any packets to the output file.
     * When some streams are "sparse" (i.e. there are large gaps between
     * successive packets), this can result in excessive buffering.
     *
     * This field specifies the maximum difference between the timestamps of the
     * first and the last packet in the muxing queue, above which libavformat
     * will output a packet regardless of whether it has queued a packet for all
     * the streams.
     *
     * Muxing only, set by the caller before avformat_write_header().
     *)
    max_interleave_delta: Int64;

    (**
     * Allow non-standard and experimental extension
     * @see AVCodecContext.strict_std_compliance
     *)
    strict_std_compliance: Integer;

    (**
     * Flags for the user to detect events happening on the file. Flags must
     * be cleared by the user once the event has been handled.
     * A combination of AVFMT_EVENT_FLAG_*.
     *)
    event_flags: Integer;
//#define AVFMT_EVENT_FLAG_METADATA_UPDATED 0x0001 ///< The call resulted in updated metadata.

    (**
     * Maximum number of packets to read while waiting for the first timestamp.
     * Decoding only.
     *)
    max_ts_probe: Integer;

    (**
     * Avoid negative timestamps during muxing.
     * Any value of the AVFMT_AVOID_NEG_TS_* constants.
     * Note, this only works when using av_interleaved_write_frame. (interleave_packet_per_dts is in use)
     * - muxing: Set by user
     * - demuxing: unused
     *)
    avoid_negative_ts: Integer;
//#define AVFMT_AVOID_NEG_TS_AUTO             -1 ///< Enabled when required by target format
//#define AVFMT_AVOID_NEG_TS_MAKE_NON_NEGATIVE 1 ///< Shift timestamps so they are non negative
//#define AVFMT_AVOID_NEG_TS_MAKE_ZERO         2 ///< Shift timestamps so that they start at 0

    (**
     * Transport stream id.
     * This will be moved into demuxer private options. Thus no API/ABI compatibility
     *)
    ts_id: Integer;

    (**
     * Audio preload in microseconds.
     * Note, not all formats support this and unpredictable things may happen if it is used when not supported.
     * - encoding: Set by user
     * - decoding: unused
     *)
    audio_preload: Integer;

    (**
     * Max chunk time in microseconds.
     * Note, not all formats support this and unpredictable things may happen if it is used when not supported.
     * - encoding: Set by user
     * - decoding: unused
     *)
    max_chunk_duration: Integer;

    (**
     * Max chunk size in bytes
     * Note, not all formats support this and unpredictable things may happen if it is used when not supported.
     * - encoding: Set by user
     * - decoding: unused
     *)
    max_chunk_size: Integer;

    (**
     * forces the use of wallclock timestamps as pts/dts of packets
     * This has undefined results in the presence of B frames.
     * - encoding: unused
     * - decoding: Set by user
     *)
    use_wallclock_as_timestamps: Integer;

    (**
     * avio flags, used to force AVIO_FLAG_DIRECT.
     * - encoding: unused
     * - decoding: Set by user
     *)
    avio_flags: Integer;

    (**
     * The duration field can be estimated through various ways, and this field can be used
     * to know how the duration was estimated.
     * - encoding: unused
     * - decoding: Read by user
     *)
    duration_estimation_method: TAVDurationEstimationMethod;

    (**
     * Skip initial bytes when opening stream
     * - encoding: unused
     * - decoding: Set by user
     *)
    skip_initial_bytes: Int64;

    (**
     * Correct single timestamp overflows
     * - encoding: unused
     * - decoding: Set by user
     *)
    correct_ts_overflow: Cardinal;

    (**
     * Force seeking to any (also non key) frames.
     * - encoding: unused
     * - decoding: Set by user
     *)
    seek2any: Integer;

    (**
     * Flush the I/O context after each packet.
     * - encoding: Set by user
     * - decoding: unused
     *)
    flush_packets: Integer;

    (**
     * format probing score.
     * The maximal score is AVPROBE_SCORE_MAX, its set when the demuxer probes
     * the format.
     * - encoding: unused
     * - decoding: set by avformat, read by user
     *)
    probe_score: Integer;

    (**
     * number of bytes to read maximally to identify format.
     * - encoding: unused
     * - decoding: set by user
     *)
    format_probesize: Integer;

    (**
     * ',' separated list of allowed decoders.
     * If NULL then all are allowed
     * - encoding: unused
     * - decoding: set by user
     *)
    codec_whitelist: PAnsiChar;

    (**
     * ',' separated list of allowed demuxers.
     * If NULL then all are allowed
     * - encoding: unused
     * - decoding: set by user
     *)
    format_whitelist: PAnsiChar;

    (**
     * An opaque field for libavformat internal usage.
     * Must not be accessed in any way by callers.
     *)
    internal: PAVFormatInternal;

    (**
     * IO repositioned flag.
     * This is set by avformat when the underlaying IO context read pointer
     * is repositioned, for example when doing byte based seeking.
     * Demuxers can use the flag to detect such changes.
     *)
    io_repositioned: Integer;

    (**
     * Forced video codec.
     * This allows forcing a specific decoder, even when there are multiple with
     * the same codec_id.
     * Demuxing: Set by user
     *)
    video_codec: PAVCodec;

    (**
     * Forced audio codec.
     * This allows forcing a specific decoder, even when there are multiple with
     * the same codec_id.
     * Demuxing: Set by user
     *)
    audio_codec: PAVCodec;

    (**
     * Forced subtitle codec.
     * This allows forcing a specific decoder, even when there are multiple with
     * the same codec_id.
     * Demuxing: Set by user
     *)
    subtitle_codec: PAVCodec;

    (**
     * Forced data codec.
     * This allows forcing a specific decoder, even when there are multiple with
     * the same codec_id.
     * Demuxing: Set by user
     *)
    data_codec: PAVCodec;

    (**
     * Number of bytes to be written as padding in a metadata header.
     * Demuxing: Unused.
     * Muxing: Set by user via av_format_set_metadata_header_padding.
     *)
    metadata_header_padding: Integer;

    (**
     * User data.
     * This is a place for some private data of the user.
     *)
    opaque: Pointer;

    (**
     * Callback used by devices to communicate with application.
     *)
    control_message_cb: Tav_format_control_messageCall;

    (**
     * Output timestamp offset, in microseconds.
     * Muxing: set by user
     *)
    output_ts_offset: Int64;

    (**
     * dump format separator.
     * can be ", " or "\n      " or anything else
     * - muxing: Set by user.
     * - demuxing: Set by user.
     *)
    dump_separator: PAnsiChar;

    (**
     * Forced Data codec_id.
     * Demuxing: Set by user.
     *)
    data_codec_id: TAVCodecID;

{$IFDEF FF_API_OLD_OPEN_CALLBACKS}
    (**
     * Called to open further IO contexts when needed for demuxing.
     *
     * This can be set by the user application to perform security checks on
     * the URLs before opening them.
     * The function should behave like avio_open2(), AVFormatContext is provided
     * as contextual information and to reach AVFormatContext.opaque.
     *
     * If NULL then some simple checks are used together with avio_open2().
     *
     * Must not be accessed directly from outside avformat.
     * @See av_format_set_open_cb()
     *
     * Demuxing: Set by user.
     *
     * @deprecated Use io_open and io_close.
     *)
    open_cb: TAVOpenCallback;
{$ENDIF}

    (**
     * ',' separated list of allowed protocols.
     * - encoding: unused
     * - decoding: set by user
     *)
    protocol_whitelist: PAnsiChar;

    (*
     * A callback for opening new IO streams.
     *
     * Whenever a muxer or a demuxer needs to open an IO stream (typically from
     * avformat_open_input() for demuxers, but for certain formats can happen at
     * other times as well), it will call this callback to obtain an IO context.
     *
     * @param s the format context
     * @param pb on success, the newly opened IO context should be returned here
     * @param url the url to open
     * @param flags a combination of AVIO_FLAG_*
     * @param options a dictionary of additional options, with the same
     *                semantics as in avio_open2()
     * @return 0 on success, a negative AVERROR code on failure
     *
     * @note Certain muxers and demuxers do nesting, i.e. they open one or more
     * additional internal format contexts. Thus the AVFormatContext pointer
     * passed to this callback may be different from the one facing the caller.
     * It will, however, have the same 'opaque' field.
     *)
    io_open: function(s: PAVFormatContext; pb: PPAVIOContext; const url: PAnsiChar;
                   flags: Integer; options: PPAVDictionary): Integer; cdecl;

    (**
     * A callback for closing the streams opened with AVFormatContext.io_open().
     *)
    io_close: procedure(s: PAVFormatContext; pb: PAVIOContext); cdecl;

    (**
     * ',' separated list of disallowed protocols.
     * - encoding: unused
     * - decoding: set by user
     *)
    protocol_blacklist: PAnsiChar;

    (**
     * The maximum number of streams.
     * - encoding: unused
     * - decoding: set by user
     *)
    max_streams: Integer;
  end;


//TODO: API return record  function av_stream_get_r_frame_rate(const s: PAVStream): TAVRational; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_stream_get_r_frame_rate';

{$IFDEF API_Dynamic}
var av_stream_set_r_frame_rate : procedure(s: PAVStream; r: TAVRational); cdecl;
{$ELSE API_Dynamic}
procedure av_stream_set_r_frame_rate(s: PAVStream; r: TAVRational); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_stream_set_r_frame_rate';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_stream_get_parser : function(const s: PAVStream): PAVCodecParserContext; cdecl;
{$ELSE API_Dynamic}
function av_stream_get_parser(const s: PAVStream): PAVCodecParserContext; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_stream_get_parser';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_stream_get_recommended_encoder_configuration : function(const s: PAVStream): PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function av_stream_get_recommended_encoder_configuration(const s: PAVStream): PAnsiChar; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_stream_get_recommended_encoder_configuration';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_stream_set_recommended_encoder_configuration : procedure(s: PAVStream; configuration: PAnsiChar); cdecl;
{$ELSE API_Dynamic}
procedure av_stream_set_recommended_encoder_configuration(s: PAVStream; configuration: PAnsiChar); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_stream_set_recommended_encoder_configuration';
{$ENDIF API_Dynamic}


(**
 * Returns the pts of the last muxed packet + its duration
 *
 * the retuned value is undefined when used with a demuxer.
 *)

{$IFDEF API_Dynamic}
var av_stream_get_end_pts : function(const st: PAVStream): Int64; cdecl;
{$ELSE API_Dynamic}
function av_stream_get_end_pts(const st: PAVStream): Int64; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_stream_get_end_pts';
{$ENDIF API_Dynamic}


(**
 * Accessors for some AVFormatContext fields. These used to be provided for ABI
 * compatibility, and do not need to be used anymore.
 *)

{$IFDEF API_Dynamic}
var av_format_get_probe_score : function(const s: PAVFormatContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_format_get_probe_score(const s: PAVFormatContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_get_probe_score';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_get_video_codec : function(const s: PAVFormatContext): PAVCodec; cdecl;
{$ELSE API_Dynamic}
function av_format_get_video_codec(const s: PAVFormatContext): PAVCodec; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_get_video_codec';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_set_video_codec : procedure(s: PAVFormatContext; c: PAVCodec); cdecl;
{$ELSE API_Dynamic}
procedure av_format_set_video_codec(s: PAVFormatContext; c: PAVCodec); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_set_video_codec';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_get_audio_codec : function(const s: PAVFormatContext): PAVCodec; cdecl;
{$ELSE API_Dynamic}
function av_format_get_audio_codec(const s: PAVFormatContext): PAVCodec; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_get_audio_codec';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_set_audio_codec : procedure(s: PAVFormatContext; c: PAVCodec); cdecl;
{$ELSE API_Dynamic}
procedure av_format_set_audio_codec(s: PAVFormatContext; c: PAVCodec); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_set_audio_codec';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_get_subtitle_codec : function(const s: PAVFormatContext): PAVCodec; cdecl;
{$ELSE API_Dynamic}
function av_format_get_subtitle_codec(const s: PAVFormatContext): PAVCodec; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_get_subtitle_codec';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_set_subtitle_codec : procedure(s: PAVFormatContext; c: PAVCodec); cdecl;
{$ELSE API_Dynamic}
procedure av_format_set_subtitle_codec(s: PAVFormatContext; c: PAVCodec); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_set_subtitle_codec';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_get_data_codec : function(const s: PAVFormatContext): PAVCodec; cdecl;
{$ELSE API_Dynamic}
function av_format_get_data_codec(const s: PAVFormatContext): PAVCodec; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_get_data_codec';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_set_data_codec : procedure(s: PAVFormatContext; c: PAVCodec); cdecl;
{$ELSE API_Dynamic}
procedure av_format_set_data_codec(s: PAVFormatContext; c: PAVCodec); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_set_data_codec';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_get_metadata_header_padding : function(const s: PAVFormatContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_format_get_metadata_header_padding(const s: PAVFormatContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_get_metadata_header_padding';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_set_metadata_header_padding : procedure(s: PAVFormatContext; c: Integer); cdecl;
{$ELSE API_Dynamic}
procedure av_format_set_metadata_header_padding(s: PAVFormatContext; c: Integer); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_set_metadata_header_padding';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_get_opaque : function(const s: PAVFormatContext): Pointer; cdecl;
{$ELSE API_Dynamic}
function av_format_get_opaque(const s: PAVFormatContext): Pointer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_get_opaque';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_set_opaque : procedure(s: PAVFormatContext; opaque: Pointer); cdecl;
{$ELSE API_Dynamic}
procedure av_format_set_opaque(s: PAVFormatContext; opaque: Pointer); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_set_opaque';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_get_control_message_cb : function(const s: PAVFormatContext): Tav_format_control_messageCall; cdecl;
{$ELSE API_Dynamic}
function av_format_get_control_message_cb(const s: PAVFormatContext): Tav_format_control_messageCall; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_get_control_message_cb';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_set_control_message_cb : procedure(s: PAVFormatContext; callback: Tav_format_control_messageCall); cdecl;
{$ELSE API_Dynamic}
procedure av_format_set_control_message_cb(s: PAVFormatContext; callback: Tav_format_control_messageCall); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_set_control_message_cb';
{$ENDIF API_Dynamic}

{$IFDEF FF_API_OLD_OPEN_CALLBACKS}

{$IFDEF API_Dynamic}
var av_format_get_open_cb : function(const s: PAVFormatContext): TAVOpenCallback; cdecl;
{$ELSE API_Dynamic}
function av_format_get_open_cb(const s: PAVFormatContext): TAVOpenCallback; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_get_open_cb';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_format_set_open_cb : procedure(s: PAVFormatContext; callback: TAVOpenCallback); cdecl;
{$ELSE API_Dynamic}
procedure av_format_set_open_cb(s: PAVFormatContext; callback: TAVOpenCallback); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_set_open_cb';
{$ENDIF API_Dynamic}

{$ENDIF}

(**
 * This function will cause global side data to be injected in the next packet
 * of each stream as well as after any subsequent seek.
 *)

{$IFDEF API_Dynamic}
var av_format_inject_global_side_data : procedure(s: PAVFormatContext); cdecl;
{$ELSE API_Dynamic}
procedure av_format_inject_global_side_data(s: PAVFormatContext); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_format_inject_global_side_data';
{$ENDIF API_Dynamic}


(**
 * Returns the method used to set ctx->duration.
 *
 * @return AVFMT_DURATION_FROM_PTS, AVFMT_DURATION_FROM_STREAM, or AVFMT_DURATION_FROM_BITRATE.
 *)

{$IFDEF API_Dynamic}
var av_fmt_ctx_get_duration_estimation_method : function(const ctx: PAVFormatContext): TAVDurationEstimationMethod; cdecl;
{$ELSE API_Dynamic}
function av_fmt_ctx_get_duration_estimation_method(const ctx: PAVFormatContext): TAVDurationEstimationMethod; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_fmt_ctx_get_duration_estimation_method';
{$ENDIF API_Dynamic}



(**
 * @defgroup lavf_core Core functions
 * @ingroup libavf
 *
 * Functions for querying libavformat capabilities, allocating core structures,
 * etc.
 * @{
 *)

(**
 * Return the LIBAVFORMAT_VERSION_INT constant.
 *)

{$IFDEF API_Dynamic}
var avformat_version : function: Cardinal; cdecl;
{$ELSE API_Dynamic}
function avformat_version: Cardinal; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_version';
{$ENDIF API_Dynamic}


(**
 * Return the libavformat build-time configuration.
 *)

{$IFDEF API_Dynamic}
var avformat_configuration : function: PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avformat_configuration: PAnsiChar; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_configuration';
{$ENDIF API_Dynamic}


(**
 * Return the libavformat license.
 *)

{$IFDEF API_Dynamic}
var avformat_license : function: PAnsiChar; cdecl;
{$ELSE API_Dynamic}
function avformat_license: PAnsiChar; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_license';
{$ENDIF API_Dynamic}


(**
 * Initialize libavformat and register all the muxers, demuxers and
 * protocols. If you do not call this function, then you can select
 * exactly which formats you want to support.
 *
 * @see av_register_input_format()
 * @see av_register_output_format()
 *)

{$IFDEF API_Dynamic}
var av_register_all : procedure; cdecl;
{$ELSE API_Dynamic}
procedure av_register_all; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_register_all';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_register_input_format : procedure(format: PAVInputFormat); cdecl;
{$ELSE API_Dynamic}
procedure av_register_input_format(format: PAVInputFormat); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_register_input_format';
{$ENDIF API_Dynamic}


{$IFDEF API_Dynamic}
var av_register_output_format : procedure(format: PAVOutputFormat); cdecl;
{$ELSE API_Dynamic}
procedure av_register_output_format(format: PAVOutputFormat); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_register_output_format';
{$ENDIF API_Dynamic}


(**
 * Do global initialization of network components. This is optional,
 * but recommended, since it avoids the overhead of implicitly
 * doing the setup for each session.
 *
 * Calling this function will become mandatory if using network
 * protocols at some major version bump.
 *)

{$IFDEF API_Dynamic}
var avformat_network_init : function: Integer; cdecl;
{$ELSE API_Dynamic}
function avformat_network_init: Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_network_init';
{$ENDIF API_Dynamic}


(**
 * Undo the initialization done by avformat_network_init.
 *)

{$IFDEF API_Dynamic}
var avformat_network_deinit : function: Integer; cdecl;
{$ELSE API_Dynamic}
function avformat_network_deinit: Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_network_deinit';
{$ENDIF API_Dynamic}


(**
 * If f is NULL, returns the first registered input format,
 * if f is non-NULL, returns the next registered input format after f
 * or NULL if f is the last one.
 *)

{$IFDEF API_Dynamic}
var av_iformat_next : function(const f: PAVInputFormat): PAVInputFormat; cdecl;
{$ELSE API_Dynamic}
function av_iformat_next(const f: PAVInputFormat): PAVInputFormat; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_iformat_next';
{$ENDIF API_Dynamic}


(**
 * If f is NULL, returns the first registered output format,
 * if f is non-NULL, returns the next registered output format after f
 * or NULL if f is the last one.
 *)

{$IFDEF API_Dynamic}
var av_oformat_next : function(const f: PAVOutputFormat): PAVOutputFormat; cdecl;
{$ELSE API_Dynamic}
function av_oformat_next(const f: PAVOutputFormat): PAVOutputFormat; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_oformat_next';
{$ENDIF API_Dynamic}


(**
 * Allocate an AVFormatContext.
 * avformat_free_context() can be used to free the context and everything
 * allocated by the framework within it.
 *)

{$IFDEF API_Dynamic}
var avformat_alloc_context : function(): PAVFormatContext; cdecl;
{$ELSE API_Dynamic}
function avformat_alloc_context(): PAVFormatContext; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_alloc_context';
{$ENDIF API_Dynamic}


(**
 * Free an AVFormatContext and all its streams.
 * @param s context to free
 *)

{$IFDEF API_Dynamic}
var avformat_free_context : procedure(s: PAVFormatContext); cdecl;
{$ELSE API_Dynamic}
procedure avformat_free_context(s: PAVFormatContext); cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_free_context';
{$ENDIF API_Dynamic}


(**
 * Get the AVClass for AVFormatContext. It can be used in combination with
 * AV_OPT_SEARCH_FAKE_OBJ for examining options.
 *
 * @see av_opt_find().
 *)

{$IFDEF API_Dynamic}
var avformat_get_class : function: PAVClass; cdecl;
{$ELSE API_Dynamic}
function avformat_get_class: PAVClass; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_get_class';
{$ENDIF API_Dynamic}


(**
 * Add a new stream to a media file.
 *
 * When demuxing, it is called by the demuxer in read_header(). If the
 * flag AVFMTCTX_NOHEADER is set in s.ctx_flags, then it may also
 * be called in read_packet().
 *
 * When muxing, should be called by the user before avformat_write_header().
 *
 * User is required to call avcodec_close() and avformat_free_context() to
 * clean up the allocation by avformat_new_stream().
 *
 * @param s media file handle
 * @param c If non-NULL, the AVCodecContext corresponding to the new stream
 * will be initialized to use this codec. This is needed for e.g. codec-specific
 * defaults to be set, so codec should be provided if it is known.
 *
 * @return newly created stream or NULL on error.
 *)

{$IFDEF API_Dynamic}
var avformat_new_stream : function(s: PAVFormatContext; const c: PAVCodec): PAVStream; cdecl;
{$ELSE API_Dynamic}
function avformat_new_stream(s: PAVFormatContext; const c: PAVCodec): PAVStream; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_new_stream';
{$ENDIF API_Dynamic}


(**
 * Wrap an existing array as stream side data.
 *
 * @param st stream
 * @param type side information type
 * @param data the side data array. It must be allocated with the av_malloc()
 *             family of functions. The ownership of the data is transferred to
 *             st.
 * @param size side information size
 * @return zero on success, a negative AVERROR code on failure. On failure,
 *         the stream is unchanged and the data remains owned by the caller.
 *)

{$IFDEF API_Dynamic}
var av_stream_add_side_data : function(st: PAVStream; type_: TAVPacketSideDataType;
                            data: PByte; size: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function av_stream_add_side_data(st: PAVStream; type_: TAVPacketSideDataType;
                            data: PByte; size: Cardinal): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_stream_add_side_data';
{$ENDIF API_Dynamic}


(**
 * Allocate new information from stream.
 *
 * @param stream stream
 * @param type desired side information type
 * @param size side information size
 * @return pointer to fresh allocated data or NULL otherwise
 *)

{$IFDEF API_Dynamic}
var av_stream_new_side_data : function(stream: PAVStream;
                                 type_: TAVPacketSideDataType; size: Integer): PByte; cdecl;
{$ELSE API_Dynamic}
function av_stream_new_side_data(stream: PAVStream;
                                 type_: TAVPacketSideDataType; size: Integer): PByte; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_stream_new_side_data';
{$ENDIF API_Dynamic}

(**
 * Get side information from stream.
 *
 * @param stream stream
 * @param type desired side information type
 * @param size pointer for side information size to store (optional)
 * @return pointer to data if present or NULL otherwise
 *)
{$IFDEF FF_API_NOCONST_GET_SIDE_DATA}

{$IFDEF API_Dynamic}
var av_stream_get_side_data : function(stream: PAVStream;
                                 type_: TAVPacketSideDataType; size: PInteger): PByte; cdecl;
{$ELSE API_Dynamic}
function av_stream_get_side_data(stream: PAVStream;
                                 type_: TAVPacketSideDataType; size: PInteger): PByte; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_stream_get_side_data';
{$ENDIF API_Dynamic}

{$ELSE}

{$IFDEF API_Dynamic}
var av_stream_get_side_data : function(const stream: PAVStream;
                                 type_: TAVPacketSideDataType; size: PInteger): PByte; cdecl;
{$ELSE API_Dynamic}
function av_stream_get_side_data(const stream: PAVStream;
                                 type_: TAVPacketSideDataType; size: PInteger): PByte; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_stream_get_side_data';
{$ENDIF API_Dynamic}

{$ENDIF}


{$IFDEF API_Dynamic}
var av_new_program : function(s: PAVFormatContext; id: Integer): PAVProgram; cdecl;
{$ELSE API_Dynamic}
function av_new_program(s: PAVFormatContext; id: Integer): PAVProgram; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_new_program';
{$ENDIF API_Dynamic}


(**
 * @}
 *)


(**
 * Allocate an AVFormatContext for an output format.
 * avformat_free_context() can be used to free the context and
 * everything allocated by the framework within it.
 *
 * @param *ctx is set to the created format context, or to NULL in
 * case of failure
 * @param oformat format to use for allocating the context, if NULL
 * format_name and filename are used instead
 * @param format_name the name of output format to use for allocating the
 * context, if NULL filename is used instead
 * @param filename the name of the filename to use for allocating the
 * context, may be NULL
 * @return >= 0 in case of success, a negative AVERROR code in case of
 * failure
 *)

{$IFDEF API_Dynamic}
var avformat_alloc_output_context2 : function(ctx: PPAVFormatContext; oformat: PAVOutputFormat;
                                   const format_name, filename: PAnsiChar): Integer; cdecl;
{$ELSE API_Dynamic}
function avformat_alloc_output_context2(ctx: PPAVFormatContext; oformat: PAVOutputFormat;
                                   const format_name, filename: PAnsiChar): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_alloc_output_context2';
{$ENDIF API_Dynamic}


(**
 * @addtogroup lavf_decoding
 * @{
 *)

(**
 * Find AVInputFormat based on the short name of the input format.
 *)

{$IFDEF API_Dynamic}
var av_find_input_format : function(const short_name: PAnsiChar): PAVInputFormat; cdecl;
{$ELSE API_Dynamic}
function av_find_input_format(const short_name: PAnsiChar): PAVInputFormat; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_find_input_format';
{$ENDIF API_Dynamic}


(**
 * Guess the file format.
 *
 * @param pd        data to be probed
 * @param is_opened Whether the file is already opened; determines whether
 *                  demuxers with or without AVFMT_NOFILE are probed.
 *)

{$IFDEF API_Dynamic}
var av_probe_input_format : function(pd: PAVProbeData; is_opened: Integer): PAVInputFormat; cdecl;
{$ELSE API_Dynamic}
function av_probe_input_format(pd: PAVProbeData; is_opened: Integer): PAVInputFormat; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_probe_input_format';
{$ENDIF API_Dynamic}


(**
 * Guess the file format.
 *
 * @param pd        data to be probed
 * @param is_opened Whether the file is already opened; determines whether
 *                  demuxers with or without AVFMT_NOFILE are probed.
 * @param score_max A probe score larger that this is required to accept a
 *                  detection, the variable is set to the actual detection
 *                  score afterwards.
 *                  If the score is <= AVPROBE_SCORE_MAX / 4 it is recommended
 *                  to retry with a larger probe buffer.
 *)

{$IFDEF API_Dynamic}
var av_probe_input_format2 : function(pd: PAVProbeData; is_opened: Integer; score_max: PInteger): PAVInputFormat; cdecl;
{$ELSE API_Dynamic}
function av_probe_input_format2(pd: PAVProbeData; is_opened: Integer; score_max: PInteger): PAVInputFormat; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_probe_input_format2';
{$ENDIF API_Dynamic}


(**
 * Guess the file format.
 *
 * @param is_opened Whether the file is already opened; determines whether
 *                  demuxers with or without AVFMT_NOFILE are probed.
 * @param score_ret The score of the best detection.
 *)

{$IFDEF API_Dynamic}
var av_probe_input_format3 : function(pd: PAVProbeData; is_opened: Integer; score_ret: PInteger): PAVInputFormat; cdecl;
{$ELSE API_Dynamic}
function av_probe_input_format3(pd: PAVProbeData; is_opened: Integer; score_ret: PInteger): PAVInputFormat; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_probe_input_format3';
{$ENDIF API_Dynamic}


(**
 * Probe a bytestream to determine the input format. Each time a probe returns
 * with a score that is too low, the probe buffer size is increased and another
 * attempt is made. When the maximum probe size is reached, the input format
 * with the highest score is returned.
 *
 * @param pb the bytestream to probe
 * @param fmt the input format is put here
 * @param filename the filename of the stream
 * @param logctx the log context
 * @param offset the offset within the bytestream to probe from
 * @param max_probe_size the maximum probe buffer size (zero for default)
 * @return the score in case of success, a negative value corresponding to an
 *         the maximal score is AVPROBE_SCORE_MAX
 * AVERROR code otherwise
 *)

{$IFDEF API_Dynamic}
var av_probe_input_buffer2 : function(pb: PAVIOContext; fmt: PPAVInputFormat;
                           const filename: PAnsiChar; logctx: Pointer;
                           offset, max_probe_size: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function av_probe_input_buffer2(pb: PAVIOContext; fmt: PPAVInputFormat;
                           const filename: PAnsiChar; logctx: Pointer;
                           offset, max_probe_size: Cardinal): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_probe_input_buffer2';
{$ENDIF API_Dynamic}


(**
 * Like av_probe_input_buffer2() but returns 0 on success
 *)

{$IFDEF API_Dynamic}
var av_probe_input_buffer : function(pb: PAVIOContext; fmt: PPAVInputFormat;
                          const filename: PAnsiChar; logctx: Pointer;
                          offset, max_probe_size: Cardinal): Integer; cdecl;
{$ELSE API_Dynamic}
function av_probe_input_buffer(pb: PAVIOContext; fmt: PPAVInputFormat;
                          const filename: PAnsiChar; logctx: Pointer;
                          offset, max_probe_size: Cardinal): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_probe_input_buffer';
{$ENDIF API_Dynamic}


(**
 * Open an input stream and read the header. The codecs are not opened.
 * The stream must be closed with avformat_close_input().
 *
 * @param ps Pointer to user-supplied AVFormatContext (allocated by avformat_alloc_context).
 *           May be a pointer to NULL, in which case an AVFormatContext is allocated by this
 *           function and written into ps.
 *           Note that a user-supplied AVFormatContext will be freed on failure.
 * @param filename Name of the stream to open.
 * @param fmt If non-NULL, this parameter forces a specific input format.
 *            Otherwise the format is autodetected.
 * @param options  A dictionary filled with AVFormatContext and demuxer-private options.
 *                 On return this parameter will be destroyed and replaced with a dict containing
 *                 options that were not found. May be NULL.
 *
 * @return 0 on success, a negative AVERROR on failure.
 *
 * @note If you want to use custom IO, preallocate the format context and set its pb field.
 *)

{$IFDEF API_Dynamic}
var avformat_open_input : function(ps: PPAVFormatContext; const filename: PAnsiChar; fmt: PAVInputFormat; options: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function avformat_open_input(ps: PPAVFormatContext; const filename: PAnsiChar; fmt: PAVInputFormat; options: PPAVDictionary): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_open_input';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_demuxer_open : function(ic: PAVFormatContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_demuxer_open(ic: PAVFormatContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_demuxer_open';
{$ENDIF API_Dynamic}


(**
 * Read packets of a media file to get stream information. This
 * is useful for file formats with no headers such as MPEG. This
 * function also computes the real framerate in case of MPEG-2 repeat
 * frame mode.
 * The logical file position is not changed by this function;
 * examined packets may be buffered for later processing.
 *
 * @param ic media file handle
 * @param options  If non-NULL, an ic.nb_streams long array of pointers to
 *                 dictionaries, where i-th member contains options for
 *                 codec corresponding to i-th stream.
 *                 On return each dictionary will be filled with options that were not found.
 * @return >=0 if OK, AVERROR_xxx on error
 *
 * @note this function isn't guaranteed to open all the codecs, so
 *       options being non-empty at return is a perfectly normal behavior.
 *
 * @todo Let the user decide somehow what information is needed so that
 *       we do not waste time getting stuff the user does not need.
 *)

{$IFDEF API_Dynamic}
var avformat_find_stream_info : function(ic: PAVFormatContext; options: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function avformat_find_stream_info(ic: PAVFormatContext; options: PPAVDictionary): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_find_stream_info';
{$ENDIF API_Dynamic}


(**
 * Find the programs which belong to a given stream.
 *
 * @param ic    media file handle
 * @param last  the last found program, the search will start after this
 *              program, or from the beginning if it is NULL
 * @param s     stream index
 * @return the next program which belongs to s, NULL if no program is found or
 *         the last program is not among the programs of ic.
 *)

{$IFDEF API_Dynamic}
var av_find_program_from_stream : function(ic: PAVFormatContext; last: PAVProgram; s: Integer): PAVProgram; cdecl;
{$ELSE API_Dynamic}
function av_find_program_from_stream(ic: PAVFormatContext; last: PAVProgram; s: Integer): PAVProgram; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_find_program_from_stream';
{$ENDIF API_Dynamic}



{$IFDEF API_Dynamic}
var av_program_add_stream_index : procedure(ac: PAVFormatContext; progid: Integer; idx: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure av_program_add_stream_index(ac: PAVFormatContext; progid: Integer; idx: Cardinal); cdecl; external AVFORMAT_LIBNAME name _PU + 'av_program_add_stream_index';
{$ENDIF API_Dynamic}


(**
 * Find the "best" stream in the file.
 * The best stream is determined according to various heuristics as the most
 * likely to be what the user expects.
 * If the decoder parameter is non-NULL, av_find_best_stream will find the
 * default decoder for the stream's codec; streams for which no decoder can
 * be found are ignored.
 *
 * @param ic                media file handle
 * @param type              stream type: video, audio, subtitles, etc.
 * @param wanted_stream_nb  user-requested stream number,
 *                          or -1 for automatic selection
 * @param related_stream    try to find a stream related (eg. in the same
 *                          program) to this one, or -1 if none
 * @param decoder_ret       if non-NULL, returns the decoder for the
 *                          selected stream
 * @param flags             flags; none are currently defined
 * @return  the non-negative stream number in case of success,
 *          AVERROR_STREAM_NOT_FOUND if no stream with the requested type
 *          could be found,
 *          AVERROR_DECODER_NOT_FOUND if streams were found but no decoder
 * @note  If av_find_best_stream returns successfully and decoder_ret is not
 *        NULL, then *decoder_ret is guaranteed to be set to a valid AVCodec.
 *)

{$IFDEF API_Dynamic}
var av_find_best_stream : function(ic: PAVFormatContext;
                        type_: TAVMediaType;
                        wanted_stream_nb,
                        related_stream: Integer;
                        decoder_ret: PPAVCodec;
                        flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_find_best_stream(ic: PAVFormatContext;
                        type_: TAVMediaType;
                        wanted_stream_nb,
                        related_stream: Integer;
                        decoder_ret: PPAVCodec;
                        flags: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_find_best_stream';
{$ENDIF API_Dynamic}


(**
 * Return the next frame of a stream.
 * This function returns what is stored in the file, and does not validate
 * that what is there are valid frames for the decoder. It will split what is
 * stored in the file into frames and return one for each call. It will not
 * omit invalid data between valid frames so as to give the decoder the maximum
 * information possible for decoding.
 *
 * If pkt->buf is NULL, then the packet is valid until the next
 * av_read_frame() or until avformat_close_input(). Otherwise the packet
 * is valid indefinitely. In both cases the packet must be freed with
 * av_packet_unref when it is no longer needed. For video, the packet contains
 * exactly one frame. For audio, it contains an integer number of frames if each
 * frame has a known fixed size (e.g. PCM or ADPCM data). If the audio frames
 * have a variable size (e.g. MPEG audio), then it contains one frame.
 *
 * pkt->pts, pkt->dts and pkt->duration are always set to correct
 * values in AVStream.time_base units (and guessed if the format cannot
 * provide them). pkt->pts can be AV_NOPTS_VALUE if the video format
 * has B-frames, so it is better to rely on pkt->dts if you do not
 * decompress the payload.
 *
 * @return 0 if OK, < 0 on error or end of file
 *)

{$IFDEF API_Dynamic}
var av_read_frame : function(s: PAVFormatContext; pkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_read_frame(s: PAVFormatContext; pkt: PAVPacket): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_read_frame';
{$ENDIF API_Dynamic}


(**
 * Seek to the keyframe at timestamp.
 * 'timestamp' in 'stream_index'.
 *
 * @param s media file handle
 * @param stream_index If stream_index is (-1), a default
 * stream is selected, and timestamp is automatically converted
 * from AV_TIME_BASE units to the stream specific time_base.
 * @param timestamp Timestamp in AVStream.time_base units
 *        or, if no stream is specified, in AV_TIME_BASE units.
 * @param flags flags which select direction and seeking mode
 * @return >= 0 on success
 *)

{$IFDEF API_Dynamic}
var av_seek_frame : function(s: PAVFormatContext; stream_index: Integer; timestamp: Int64;
                                flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_seek_frame(s: PAVFormatContext; stream_index: Integer; timestamp: Int64;
                                flags: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_seek_frame';
{$ENDIF API_Dynamic}


(**
 * Seek to timestamp ts.
 * Seeking will be done so that the point from which all active streams
 * can be presented successfully will be closest to ts and within min/max_ts.
 * Active streams are all streams that have AVStream.discard < AVDISCARD_ALL.
 *
 * If flags contain AVSEEK_FLAG_BYTE, then all timestamps are in bytes and
 * are the file position (this may not be supported by all demuxers).
 * If flags contain AVSEEK_FLAG_FRAME, then all timestamps are in frames
 * in the stream with stream_index (this may not be supported by all demuxers).
 * Otherwise all timestamps are in units of the stream selected by stream_index
 * or if stream_index is -1, in AV_TIME_BASE units.
 * If flags contain AVSEEK_FLAG_ANY, then non-keyframes are treated as
 * keyframes (this may not be supported by all demuxers).
 * If flags contain AVSEEK_FLAG_BACKWARD, it is ignored.
 *
 * @param s media file handle
 * @param stream_index index of the stream which is used as time base reference
 * @param min_ts smallest acceptable timestamp
 * @param ts target timestamp
 * @param max_ts largest acceptable timestamp
 * @param flags flags
 * @return >=0 on success, error code otherwise
 *
 * @note This is part of the new seek API which is still under construction.
 *       Thus do not use this yet. It may change at any time, do not expect
 *       ABI compatibility yet!
 *)

{$IFDEF API_Dynamic}
var avformat_seek_file : function(s: PAVFormatContext; stream_index: Integer; min_ts, ts, max_ts: Int64; flags: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function avformat_seek_file(s: PAVFormatContext; stream_index: Integer; min_ts, ts, max_ts: Int64; flags: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_seek_file';
{$ENDIF API_Dynamic}


(**
 * Discard all internally buffered data. This can be useful when dealing with
 * discontinuities in the byte stream. Generally works only with formats that
 * can resync. This includes headerless formats like MPEG-TS/TS but should also
 * work with NUT, Ogg and in a limited way AVI for example.
 *
 * The set of streams, the detected duration, stream parameters and codecs do
 * not change when calling this function. If you want a complete reset, it's
 * better to open a new AVFormatContext.
 *
 * This does not flush the AVIOContext (s->pb). If necessary, call
 * avio_flush(s->pb) before calling this function.
 *
 * @param s media file handle
 * @return >=0 on success, error code otherwise
 *)

{$IFDEF API_Dynamic}
var avformat_flush : function(s: PAVFormatContext): Integer; cdecl;
{$ELSE API_Dynamic}
function avformat_flush(s: PAVFormatContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_flush';
{$ENDIF API_Dynamic}


(**
 * Start playing a network-based stream (e.g. RTSP stream) at the
 * current position.
 *)

{$IFDEF API_Dynamic}
var av_read_play : function(s: PAVFormatContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_read_play(s: PAVFormatContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_read_play';
{$ENDIF API_Dynamic}


(**
 * Pause a network-based stream (e.g. RTSP stream).
 *
 * Use av_read_play() to resume it.
 *)

{$IFDEF API_Dynamic}
var av_read_pause : function(s: PAVFormatContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_read_pause(s: PAVFormatContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_read_pause';
{$ENDIF API_Dynamic}


(**
 * Close an opened input AVFormatContext. Free it and all its contents
 * and set *s to NULL.
 *)

{$IFDEF API_Dynamic}
var avformat_close_input : procedure(s: PPAVFormatContext); cdecl;
{$ELSE API_Dynamic}
procedure avformat_close_input(s: PPAVFormatContext); cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_close_input';
{$ENDIF API_Dynamic}

(**
 * @}
 *)

// libavformat/internal.h
(**
 * Set the time base and wrapping info for a given stream. This will be used
 * to interpret the stream's timestamps. If the new time base is invalid
 * (numerator or denominator are non-positive), it leaves the stream
 * unchanged.
 *
 * @param s stream
 * @param pts_wrap_bits number of bits effectively used by the pts
 *        (used for wrap control)
 * @param pts_num time base numerator
 * @param pts_den time base denominator
 *)

{$IFDEF API_Dynamic}
var avpriv_set_pts_info : procedure(s: PAVStream; pts_wrap_bits: Integer;
                         pts_num, pts_den: Cardinal); cdecl;
{$ELSE API_Dynamic}
procedure avpriv_set_pts_info(s: PAVStream; pts_wrap_bits: Integer;
                         pts_num, pts_den: Cardinal); cdecl; external AVFORMAT_LIBNAME name _PU + 'avpriv_set_pts_info';
{$ENDIF API_Dynamic}


const
  AVSEEK_FLAG_BACKWARD = 1; ///< seek backward
  AVSEEK_FLAG_BYTE     = 2; ///< seeking based on position in bytes
  AVSEEK_FLAG_ANY      = 4; ///< seek to any frame, even non key-frames
  AVSEEK_FLAG_FRAME    = 8; ///< seeking based on frame number

(**
 * @addtogroup lavf_encoding
 * @{
 *)

  AVSTREAM_INIT_IN_WRITE_HEADER = 0; ///< stream parameters initialized in avformat_write_header
  AVSTREAM_INIT_IN_INIT_OUTPUT  = 1; ///< stream parameters initialized in avformat_init_output

(**
 * Allocate the stream private data and write the stream header to
 * an output media file.
 *
 * @param s Media file handle, must be allocated with avformat_alloc_context().
 *          Its oformat field must be set to the desired output format;
 *          Its pb field must be set to an already opened AVIOContext.
 * @param options  An AVDictionary filled with AVFormatContext and muxer-private options.
 *                 On return this parameter will be destroyed and replaced with a dict containing
 *                 options that were not found. May be NULL.
 *
 * @return AVSTREAM_INIT_IN_WRITE_HEADER on success if the codec had not already been fully initialized in avformat_init,
 *         AVSTREAM_INIT_IN_INIT_OUTPUT  on success if the codec had already been fully initialized in avformat_init,
 *         negative AVERROR on failure.
 *
 * @see av_opt_find, av_dict_set, avio_open, av_oformat_next, avformat_init_output.
 *)

{$IFDEF API_Dynamic}
var avformat_write_header : function(s: PAVFormatContext; options: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function avformat_write_header(s: PAVFormatContext; options: PPAVDictionary): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_write_header';
{$ENDIF API_Dynamic}


(**
 * Allocate the stream private data and initialize the codec, but do not write the header.
 * May optionally be used before avformat_write_header to initialize stream parameters
 * before actually writing the header.
 * If using this function, do not pass the same options to avformat_write_header.
 *
 * @param s Media file handle, must be allocated with avformat_alloc_context().
 *          Its oformat field must be set to the desired output format;
 *          Its pb field must be set to an already opened AVIOContext.
 * @param options  An AVDictionary filled with AVFormatContext and muxer-private options.
 *                 On return this parameter will be destroyed and replaced with a dict containing
 *                 options that were not found. May be NULL.
 *
 * @return AVSTREAM_INIT_IN_WRITE_HEADER on success if the codec requires avformat_write_header to fully initialize,
 *         AVSTREAM_INIT_IN_INIT_OUTPUT  on success if the codec has been fully initialized,
 *         negative AVERROR on failure.
 *
 * @see av_opt_find, av_dict_set, avio_open, av_oformat_next, avformat_write_header.
 *)

{$IFDEF API_Dynamic}
var avformat_init_output : function(s: PAVFormatContext; options: PPAVDictionary): Integer; cdecl;
{$ELSE API_Dynamic}
function avformat_init_output(s: PAVFormatContext; options: PPAVDictionary): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'avformat_init_output';
{$ENDIF API_Dynamic}


(**
 * Write a packet to an output media file.
 *
 * This function passes the packet directly to the muxer, without any buffering
 * or reordering. The caller is responsible for correctly interleaving the
 * packets if the format requires it. Callers that want libavformat to handle
 * the interleaving should call av_interleaved_write_frame() instead of this
 * function.
 *
 * @param s media file handle
 * @param pkt The packet containing the data to be written. Note that unlike
 *            av_interleaved_write_frame(), this function does not take
 *            ownership of the packet passed to it (though some muxers may make
 *            an internal reference to the input packet).
 *            <br>
 *            This parameter can be NULL (at any time, not just at the end), in
 *            order to immediately flush data buffered within the muxer, for
 *            muxers that buffer up data internally before writing it to the
 *            output.
 *            <br>
 *            Packet's @ref AVPacket.stream_index "stream_index" field must be
 *            set to the index of the corresponding stream in @ref
 *            AVFormatContext.streams "s->streams".
 *            <br>
 *            The timestamps (@ref AVPacket.pts "pts", @ref AVPacket.dts "dts")
 *            must be set to correct values in the stream's timebase (unless the
 *            output format is flagged with the AVFMT_NOTIMESTAMPS flag, then
 *            they can be set to AV_NOPTS_VALUE).
 *            The dts for subsequent packets passed to this function must be strictly
 *            increasing when compared in their respective timebases (unless the
 *            output format is flagged with the AVFMT_TS_NONSTRICT, then they
 *            merely have to be nondecreasing).  @ref AVPacket.duration
 *            "duration") should also be set if known.
 * @return < 0 on error, = 0 if OK, 1 if flushed and there is no more data to flush
 *
 * @see av_interleaved_write_frame()
 *)

{$IFDEF API_Dynamic}
var av_write_frame : function(s: PAVFormatContext; pkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_write_frame(s: PAVFormatContext; pkt: PAVPacket): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_write_frame';
{$ENDIF API_Dynamic}


(**
 * Write a packet to an output media file ensuring correct interleaving.
 *
 * This function will buffer the packets internally as needed to make sure the
 * packets in the output file are properly interleaved in the order of
 * increasing dts. Callers doing their own interleaving should call
 * av_write_frame() instead of this function.
 *
 * Using this function instead of av_write_frame() can give muxers advance
 * knowledge of future packets, improving e.g. the behaviour of the mp4
 * muxer for VFR content in fragmenting mode.
 *
 * @param s media file handle
 * @param pkt The packet containing the data to be written.
 *            <br>
 *            If the packet is reference-counted, this function will take
 *            ownership of this reference and unreference it later when it sees
 *            fit.
 *            The caller must not access the data through this reference after
 *            this function returns. If the packet is not reference-counted,
 *            libavformat will make a copy.
 *            <br>
 *            This parameter can be NULL (at any time, not just at the end), to
 *            flush the interleaving queues.
 *            <br>
 *            Packet's @ref AVPacket.stream_index "stream_index" field must be
 *            set to the index of the corresponding stream in @ref
 *            AVFormatContext.streams "s->streams".
 *            <br>
 *            The timestamps (@ref AVPacket.pts "pts", @ref AVPacket.dts "dts")
 *            must be set to correct values in the stream's timebase (unless the
 *            output format is flagged with the AVFMT_NOTIMESTAMPS flag, then
 *            they can be set to AV_NOPTS_VALUE).
 *            The dts for subsequent packets in one stream must be strictly
 *            increasing (unless the output format is flagged with the
 *            AVFMT_TS_NONSTRICT, then they merely have to be nondecreasing).
 *            @ref AVPacket.duration "duration") should also be set if known.
 *
 * @return 0 on success, a negative AVERROR on error. Libavformat will always
 *         take care of freeing the packet, even if this function fails.
 *
 * @see av_write_frame(), AVFormatContext.max_interleave_delta
 *)

{$IFDEF API_Dynamic}
var av_interleaved_write_frame : function(s: PAVFormatContext; pkt: PAVPacket): Integer; cdecl;
{$ELSE API_Dynamic}
function av_interleaved_write_frame(s: PAVFormatContext; pkt: PAVPacket): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_interleaved_write_frame';
{$ENDIF API_Dynamic}


(**
 * Write an uncoded frame to an output media file.
 *
 * The frame must be correctly interleaved according to the container
 * specification; if not, then av_interleaved_write_frame() must be used.
 *
 * See av_interleaved_write_frame() for details.
 *)

{$IFDEF API_Dynamic}
var av_write_uncoded_frame : function(s: PAVFormatContext; stream_index: Integer;
                           frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_write_uncoded_frame(s: PAVFormatContext; stream_index: Integer;
                           frame: PAVFrame): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_write_uncoded_frame';
{$ENDIF API_Dynamic}


(**
 * Write an uncoded frame to an output media file.
 *
 * If the muxer supports it, this function makes it possible to write an AVFrame
 * structure directly, without encoding it into a packet.
 * It is mostly useful for devices and similar special muxers that use raw
 * video or PCM data and will not serialize it into a byte stream.
 *
 * To test whether it is possible to use it with a given muxer and stream,
 * use av_write_uncoded_frame_query().
 *
 * The caller gives up ownership of the frame and must not access it
 * afterwards.
 *
 * @return  >=0 for success, a negative code on error
 *)

{$IFDEF API_Dynamic}
var av_interleaved_write_uncoded_frame : function(s: PAVFormatContext; stream_index: Integer;
                                       frame: PAVFrame): Integer; cdecl;
{$ELSE API_Dynamic}
function av_interleaved_write_uncoded_frame(s: PAVFormatContext; stream_index: Integer;
                                       frame: PAVFrame): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_interleaved_write_uncoded_frame';
{$ENDIF API_Dynamic}


(**
 * Test whether a muxer supports uncoded frame.
 *
 * @return  >=0 if an uncoded frame can be written to that muxer and stream,
 *          <0 if not
 *)

{$IFDEF API_Dynamic}
var av_write_uncoded_frame_query : function(s: PAVFormatContext; stream_index: Integer): Integer; cdecl;
{$ELSE API_Dynamic}
function av_write_uncoded_frame_query(s: PAVFormatContext; stream_index: Integer): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_write_uncoded_frame_query';
{$ENDIF API_Dynamic}


(**
 * Write the stream trailer to an output media file and free the
 * file private data.
 *
 * May only be called after a successful call to avformat_write_header.
 *
 * @param s media file handle
 * @return 0 if OK, AVERROR_xxx on error
 *)

{$IFDEF API_Dynamic}
var av_write_trailer : function(s: PAVFormatContext): Integer; cdecl;
{$ELSE API_Dynamic}
function av_write_trailer(s: PAVFormatContext): Integer; cdecl; external AVFORMAT_LIBNAME name _PU + 'av_write_trailer';
{$ENDIF API_Dynamic}


(**
 * Return the output format in the list of registered output formats
 * which best matches the provided parameters, or return NULL if
 * there is no match.
 *
 * @param short_name if non-NULL checks if short_name matches with the
 * names of the re