// This file is provided under The MIT License as part of Steamworks.NET.
// Copyright (c) 2013-2022 Riley Labrecque
// Please see the included LICENSE.txt for additional information.

// This file is automatically generated.
// Changes to this file will be reverted when you update Steamworks.NET

#if !(UNITY_STANDALONE_WIN || UNITY_STANDALONE_LINUX || UNITY_STANDALONE_OSX || STEAMWORKS_WIN || STEAMWORKS_LIN_OSX)
	#define DISABLESTEAMWORKS
#endif

#if !DISABLESTEAMWORKS

using System.Runtime.InteropServices;
using IntPtr = System.IntPtr;

namespace Steamworks {
	public static class SteamTimeline {
		/// <summary>
		/// <para> Sets a description for the current game state in the timeline. These help the user to find specific</para>
		/// <para> moments in the timeline when saving clips. Setting a new state description replaces any previous</para>
		/// <para> description.</para>
		/// <para> Examples could include:</para>
		/// <para>  * Where the user is in the world in a single player game</para>
		/// <para>  * Which round is happening in a multiplayer game</para>
		/// <para>  * The current score for a sports game</para>
		/// <para> Parameters:</para>
		/// <para> - pchDescription: provide a localized string in the language returned by SteamUtils()-&gt;GetSteamUILanguage()</para>
		/// <para> - flTimeDelta: The time offset in seconds to apply to this event. Negative times indicate an</para>
		/// <para>			event that happened in the past.</para>
		/// </summary>
		public static void SetTimelineStateDescription(string pchDescription, float flTimeDelta) {
			InteropHelp.TestIfAvailableClient();
			using (var pchDescription2 = new InteropHelp.UTF8StringHandle(pchDescription)) {
				NativeMethods.ISteamTimeline_SetTimelineStateDescription(CSteamAPIContext.GetSteamTimeline(), pchDescription2, flTimeDelta);
			}
		}

		public static void ClearTimelineStateDescription(float flTimeDelta) {
			InteropHelp.TestIfAvailableClient();
			NativeMethods.ISteamTimeline_ClearTimelineStateDescription(CSteamAPIContext.GetSteamTimeline(), flTimeDelta);
		}

		/// <summary>
		/// <para> Use this to mark an event on the Timeline. The event can be instantaneous or take some amount of time</para>
		/// <para> to complete, depending on the value passed in flDurationSeconds</para>
		/// <para> Examples could include:</para>
		/// <para>   * a boss battle</para>
		/// <para>   * a cut scene</para>
		/// <para>   * a large team fight</para>
		/// <para>   * picking up a new weapon or ammunition</para>
		/// <para>   * scoring a goal</para>
		/// <para> Parameters:</para>
		/// <para> - pchIcon: specify the name of the icon uploaded through the Steamworks Partner Site for your title</para>
		/// <para>   or one of the provided icons that start with steam_</para>
		/// <para> - pchTitle &amp; pchDescription: provide a localized string in the language returned by</para>
		/// <para>	 SteamUtils()-&gt;GetSteamUILanguage()</para>
		/// <para> - unPriority: specify how important this range is compared to other markers provided by the game.</para>
		/// <para>   Ranges with larger priority values will be displayed more prominently in the UI. This value</para>
		/// <para>   may be between 0 and k_unMaxTimelinePriority.</para>
		/// <para> - flStartOffsetSeconds: The time that this range started relative to now. Negative times</para>
		/// <para>   indicate an event that happened in the past.</para>
		/// <para> - flDurationSeconds: How long the time range should be in seconds. For instantaneous events, this</para>
		/// <para>   should be 0</para>
		/// <para> - ePossibleClip: By setting this parameter to Featured or Standard, the game indicates to Steam that it</para>
		/// <para>   would be appropriate to offer this range as a clip to the user. For instantaneous events, the</para>
		/// <para>   suggested clip will be for a short time before and after the event itself.</para>
		/// </summary>
		public static void AddTimelineEvent(string pchIcon, string pchTitle, string pchDescription, uint unPriority, float flStartOffsetSeconds, float flDurationSeconds, ETimelineEventClipPriority ePossibleClip) {
			InteropHelp.TestIfAvailableClient();
			using (var pchIcon2 = new InteropHelp.UTF8StringHandle(pchIcon))
			using (var pchTitle2 = new InteropHelp.UTF8StringHandle(pchTitle))
			using (var pchDescription2 = new InteropHelp.UTF8StringHandle(pchDescription)) {
				NativeMethods.ISteamTimeline_AddTimelineEvent(CSteamAPIContext.GetSteamTimeline(), pchIcon2, pchTitle2, pchDescription2, unPriority, flStartOffsetSeconds, flDurationSeconds, ePossibleClip);
			}
		}

		/// <summary>
		/// <para> Changes the color of the timeline bar. See ETimelineGameMode comments for how to use each value</para>
		/// </summary>
		public static void SetTimelineGameMode(ETimelineGameMode eMode) {
			InteropHelp.TestIfAvailableClient();
			NativeMethods.ISteamTimeline_SetTimelineGameMode(CSteamAPIContext.GetSteamTimeline(), eMode);
		}
	}
}

#endif // !DISABLESTEAMWORKS
