/*
 * Copyright (c) 2017-present Robert Jaros
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package test.io.kvision.form.check

import io.kvision.form.check.CheckStyle
import io.kvision.form.check.TriStateCheckBox
import io.kvision.panel.Root
import io.kvision.test.DomSpec
import kotlinx.browser.document
import org.w3c.dom.HTMLInputElement
import kotlin.test.Test
import kotlin.test.assertTrue

class TriStateCheckBoxSpec : DomSpec {

    @Test
    fun render() {
        run {
            val root = Root("test", containerType = io.kvision.panel.ContainerType.FIXED)
            val ci = TriStateCheckBox(value = null, label = "Label").apply {
                name = "name"
                style = CheckStyle.DANGER
                circled = true
                inline = true
            }
            root.add(ci)
            val element = document.getElementById("test")
            val id = ci.input.id
            assertEqualsHtml(
                "<div class=\"form-check form-check-inline\"><input class=\"form-check-input kv-check-danger kv-checkbox-circle\" id=\"$id\" type=\"checkbox\" name=\"name\"><label class=\"form-check-label\" for=\"$id\">Label<span></span></label></div>",
                element?.innerHTML,
                "Should render correct tri-state checkbox form control"
            )
            val input = element?.getElementsByTagName("input")?.item(0)?.unsafeCast<HTMLInputElement>()
            assertTrue(
                input!!.indeterminate,
                "Should render tri-state checkbox in indetermined state"
            )
        }
    }

}
