/*
 * Copyright (c) 2017-present Robert Jaros
 * Copyright (c) 2024 Maanrifa Bacar Ali <dev.manrif@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package io.kvision.material.dialog

import io.kvision.material.ExperimentalMaterialApi
import io.kvision.utils.SnOn
import io.kvision.utils.event
import org.w3c.dom.events.Event

/**
 * Dispatched when the dialog is opening before any animations.
 */
@ExperimentalMaterialApi
fun SnOn<MdDialog>.open(action: (Event) -> Unit) {
    event("open", action)
}

/**
 * Dispatched when the dialog has opened after any animations.
 */
@ExperimentalMaterialApi
fun SnOn<MdDialog>.opened(action: (Event) -> Unit) {
    event("opened", action)
}

/**
 * Dispatched when the dialog is closing before any animations.
 */
@ExperimentalMaterialApi
fun SnOn<MdDialog>.close(action: (Event) -> Unit) {
    event("close", action)
}

/**
 * Dispatched when the dialog has closed after any animations.
 */
@ExperimentalMaterialApi
fun SnOn<MdDialog>.closed(action: (Event) -> Unit) {
    event("closed", action)
}

/**
 * Dispatched when the dialog has been canceled by clicking on the scrim or pressing Escape.
 */
@ExperimentalMaterialApi
fun SnOn<MdDialog>.cancel(action: (Event) -> Unit) {
    event("cancel", action)
}
