# Module KVision

KVision - object oriented web framework for Kotlin/JS.

# Package io.kvision

KVision main Application class and some helper interfaces necessary to support Hot Module Replacement (HMR).

# Package io.kvision.annotations

Annotations for use with KVision compiler plugin.

# Package io.kvision.core

KVision core classes. This includes base interfaces for all components, CSS enums (for colors, borders,
backgrounds, fonts, text and position) and the main Widget class.

# Package io.kvision.chart

Full-featured chart component based on chart.js library.

# Package io.kvision.chart.js

Kotlin bindings for chart.js API.

# Package io.kvision.cordova

Kotlin bindings for core Apache Cordova API.

# Package io.kvision.data

Base component and container class with data binding support for observable data model.

# Package io.kvision.dropdown

Bootstrap dropdown component with support for navigation bars and context menus.

# Package io.kvision.electron

Globals for Electron API.

# Package io.kvision.electron.electron

Kotlin bindings for Electron API.

# Package io.kvision.electron.nodejs

Kotlin bindings for NodeJS API within Electron.

# Package io.kvision.event

Extension functions producing coroutines Flows for KVision event and data sources.

# Package io.kvision.form

Convenient forms implementation, with support for many different input components and easy to define
validation.

# Package io.kvision.form.check

Checkbox, radiobutton and radiobutton group components.

# Package io.kvision.form.number

Numeric input components including range selection and spinner.

# Package io.kvision.form.select

Contains a simple select component as well as full-featured components with support for remote data sources.

# Package io.kvision.form.text

Text input components, with password, text area, rich text area and typeahead support.

# Package io.kvision.form.time

Full-featured date and time input components.

# Package io.kvision.form.upload

Full-featured file upload component with drag & drop, preview and AJAX upload mode.

# Package io.kvision.html

Components supporting complete set of HTML tags, with dedicated classes for buttons, images, links, lists and iframe.
Support for Handlebars.js templates is included.

# Package io.kvision.i18n

Internationalization classes.

# Package io.kvision.maps

A maps component based on Leaflet library.

# Package io.kvision.modal

Classes supporting general purpose Bootstrap modals with convenient helpers for alert and confirm popup dialogs.

# Package io.kvision.moment

A set of tools for parsing, validating, manipulating, and formatting dates based on Moment Library.

# Package io.kvision.navbar

Bootstrap navbar components.

# Package io.kvision.offcanvas

Bootstrap offcanvas component.

# Package io.kvision.material.button

Material web button components (elevated, filled, filled tonal, outlined, text).

# Package io.kvision.material.checkbox

Material web checkbox component.

# Package io.kvision.material.chips

Material web chips components (chip set, chip).

# Package io.kvision.material.dialog

Material web dialog component.

# Package io.kvision.material.divider

Material web divider component.

# Package io.kvision.material.fab

Material web fab components (fab, branded fab).

# Package io.kvision.material.icon

Material web icon component.

# Package io.kvision.material.iconbutton

Material web icon button components (filled, filled tonal, outlined, standard).

# Package io.kvision.material.list

Material web list components (list, list item).

# Package io.kvision.material.menu

Material web menu components (menu, menu item, submenu).

# Package io.kvision.material.progress

Material web progress components (circular, linear).

# Package io.kvision.material.radio

Material web radio component.

# Package io.kvision.material.ripple

Material web ripple component.

# Package io.kvision.material.select

Material web select components (filled, outlined, select option).

# Package io.kvision.material.slider

Material web slider components (slider, range slider).

# Package io.kvision.material.switch

Material web switch component.

# Package io.kvision.material.tabs

Material web tabs components (tabs, primary tab, secondary tab).

# Package io.kvision.material.textfield

Material web text field component (filled, outlined).

# Package io.kvision.onsenui

Onsen UI helper utility functions.

# Package io.kvision.onsenui.carousel

Onsen UI carousel component.

# Package io.kvision.onsenui.control

Onsen UI control components (action button, speed dial, segment).

# Package io.kvision.onsenui.core

Onsen UI main structural components (page, navigator).

# Package io.kvision.onsenui.dialog

Onsen UI dialogs, toasts, popovers and notifications.

# Package io.kvision.onsenui.form

Onsen UI form components.

# Package io.kvision.onsenui.grid

Onsen UI grid layout components.

# Package io.kvision.onsenui.list

Onsen UI list component.

# Package io.kvision.onsenui.splitter

Onsen UI splitter component.

# Package io.kvision.onsenui.tabbar

Onsen UI tabbar component.

# Package io.kvision.onsenui.toolbar

Onsen UI toolbar component.

# Package io.kvision.onsenui.visual

Onsen UI visual components (card, icon, progress bars and ripple).

# Package io.kvision.pace

Automatic progress bar module.

# Package io.kvision.panel

Rich set of container classes, supporting both simple use cases and sophisticated layouts (including CSS flexbox,
CSS grid and Bootstrap responsive 12 columns gid).

# Package io.kvision.print

Printing support.

# Package io.kvision.progress

Bootstrap progress bar component.

# Package io.kvision.react

KVision bindings for embedded React components.

# Package io.kvision.redux

Predictable state container based on Redux library.

# Package io.kvision.remote

A set of components for creating multiplatform automatic JSON-RPC connectivity with a backend server.

# Package io.kvision.state

Classes supporting the observer pattern, including the implementation of the observable list.

# Package io.kvision.tabulator

Full-featured grid/table component based on the Tabulator library.

# Package io.kvision.tabulator.js

Kotlin bindings for Tabulator API.

# Package io.kvision.test

Helper functions for running unit tests.

# Package io.kvision.rest

RESTful API client with support for type-safe connectivity.

# Package io.kvision.routing

Simple and easy to use JavaScript router wrapper.

# Package io.kvision.snabbdom

Snabbdom virtual DOM bindings.

# Package io.kvision.table

Clasess supporting HTML tables.

# Package io.kvision.toast

The toast component.

# Package io.kvision.toolbar

Toolbar and button group components.

# Package io.kvision.types

Multiplatform type definitions.

# Package io.kvision.utils

Interfaces and helper functions for Snabbdom virtual dom implementation and a few useful extension functions.

# Package io.kvision.window

Floating, resizable window component.
