import React from "react";

export default function BuyMeACoffeeBrandLogo() {
  return (
    <svg
      width="121"
      height="25"
      viewBox="0 0 195 40"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_2397_300)">
        <path
          d="M24.7394 9.30505L24.7119 9.2889L24.6484 9.26953C24.674 9.2911 24.706 9.30359 24.7394 9.30505Z"
          fill="currentColor"
        />
        <path
          d="M24.7538 9.29959C24.7499 9.2991 24.7461 9.29818 24.7424 9.29688C24.7421 9.2994 24.7421 9.30195 24.7424 9.30449C24.7465 9.30394 24.7505 9.30225 24.7538 9.29959Z"
          fill="currentColor"
        />
        <path
          d="M25.1172 12.1621L25.1635 12.1357L25.1807 12.1261L25.1963 12.1094C25.167 12.122 25.1401 12.1399 25.1172 12.1621Z"
          fill="currentColor"
        />
        <path
          d="M24.8259 9.36442L24.7807 9.32137L24.75 9.30469C24.7665 9.33377 24.7937 9.35522 24.8259 9.36442Z"
          fill="currentColor"
        />
        <path
          d="M13.4514 37.0977C13.4153 37.1133 13.3836 37.1377 13.3594 37.1687L13.3879 37.1504C13.4073 37.1326 13.4347 37.1116 13.4514 37.0977Z"
          fill="currentColor"
        />
        <path
          d="M20.0549 35.8027C20.0549 35.7618 20.035 35.7693 20.0398 35.9146C20.0398 35.9028 20.0447 35.891 20.0468 35.8797C20.0495 35.8538 20.0517 35.8285 20.0549 35.8027Z"
          fill="currentColor"
        />
        <path
          d="M19.3734 37.0977C19.3372 37.1133 19.3055 37.1377 19.2812 37.1687L19.3098 37.1504C19.3291 37.1326 19.3567 37.1116 19.3734 37.0977Z"
          fill="currentColor"
        />
        <path
          d="M8.79999 37.4046C8.77258 37.3807 8.73902 37.3651 8.70312 37.3594C8.73219 37.3734 8.76124 37.3874 8.78061 37.3981L8.79999 37.4046Z"
          fill="currentColor"
        />
        <path
          d="M7.74915 36.4018C7.74486 36.3594 7.73185 36.3185 7.71094 36.2812C7.72575 36.3199 7.73815 36.3595 7.74807 36.3997L7.74915 36.4018Z"
          fill="currentColor"
        />
        <path
          d="M14.7801 18.4828C13.3434 19.0979 11.7129 19.7953 9.59965 19.7953C8.71562 19.7935 7.8359 19.6723 6.98438 19.4348L8.44591 34.4403C8.49765 35.0675 8.78336 35.6523 9.24633 36.0786C9.70929 36.5048 10.3156 36.7414 10.945 36.7413C10.945 36.7413 13.0173 36.8489 13.7087 36.8489C14.453 36.8489 16.6846 36.7413 16.6846 36.7413C17.3138 36.7413 17.92 36.5046 18.3828 36.0784C18.8457 35.6521 19.1313 35.0674 19.1831 34.4403L20.7485 17.8586C20.0489 17.6197 19.3429 17.4609 18.547 17.4609C17.1705 17.4604 16.0614 17.9345 14.7801 18.4828Z"
          fill="#FFDD00"
        />
        <path
          d="M2.46094 12.0781L2.48569 12.1013L2.50184 12.111C2.4894 12.0986 2.47569 12.0876 2.46094 12.0781Z"
          fill="currentColor"
        />
        <path
          d="M27.508 10.6911L27.2879 9.58098C27.0904 8.58492 26.6421 7.64375 25.6197 7.28374C25.292 7.16858 24.9201 7.11908 24.6688 6.88069C24.4175 6.6423 24.3433 6.27207 24.2852 5.92875C24.1775 5.29861 24.0764 4.66793 23.966 4.03887C23.8708 3.49806 23.7955 2.89052 23.5474 2.39437C23.2245 1.72817 22.5546 1.33857 21.8884 1.08081C21.547 0.953382 21.1986 0.845582 20.8449 0.757941C19.1805 0.318833 17.4306 0.157397 15.7183 0.0653782C13.663 -0.0480303 11.6023 -0.0138619 9.55192 0.167621C8.0258 0.306456 6.41843 0.474351 4.96819 1.00225C4.43814 1.19543 3.89195 1.42736 3.4889 1.83687C2.99436 2.34002 2.83293 3.11814 3.19401 3.74559C3.45069 4.19116 3.88549 4.50596 4.34666 4.71421C4.94736 4.98254 5.5747 5.18673 6.21825 5.32337C8.0102 5.71942 9.86618 5.87494 11.6969 5.94113C13.7259 6.02302 15.7583 5.95665 17.7776 5.74256C18.277 5.68767 18.7755 5.62184 19.2731 5.54507C19.8591 5.4552 20.2352 4.68892 20.0625 4.1551C19.8559 3.51689 19.3005 3.26935 18.6725 3.36568C18.58 3.38021 18.488 3.39366 18.3954 3.40711L18.3287 3.4168C18.1159 3.44371 17.9032 3.46882 17.6905 3.49214C17.251 3.53949 16.8105 3.57824 16.3688 3.60837C15.3798 3.67725 14.388 3.709 13.3968 3.71061C12.4228 3.71061 11.4483 3.68317 10.4764 3.61913C10.033 3.59007 9.59066 3.55312 9.1494 3.50828C8.94868 3.48729 8.7485 3.46523 8.54832 3.44048L8.35782 3.41626L8.31639 3.41034L8.1189 3.38182C7.71531 3.32101 7.31172 3.25106 6.91243 3.16657C6.87214 3.15763 6.8361 3.13522 6.81027 3.10303C6.78444 3.07084 6.77036 3.0308 6.77036 2.98953C6.77036 2.94826 6.78444 2.90822 6.81027 2.87603C6.8361 2.84384 6.87214 2.82143 6.91243 2.81249H6.91996C7.26598 2.73877 7.61468 2.67581 7.96446 2.62092C8.08105 2.60262 8.198 2.58468 8.31531 2.56711H8.31854C8.53756 2.55258 8.75765 2.51329 8.97559 2.48746C10.8717 2.29023 12.7792 2.22299 14.6845 2.28621C15.6096 2.31311 16.534 2.36746 17.4548 2.4611C17.6528 2.48154 17.8498 2.50307 18.0467 2.52729C18.122 2.53643 18.1979 2.54719 18.2738 2.55634L18.4266 2.57841C18.8722 2.64477 19.3154 2.72531 19.7563 2.82002C20.4096 2.96209 21.2485 3.00837 21.5391 3.72407C21.6317 3.95115 21.6736 4.20353 21.7248 4.44192L21.7899 4.74596C21.7916 4.75141 21.7928 4.75699 21.7936 4.76264C21.9476 5.48014 22.1016 6.19763 22.2559 6.91513C22.2672 6.96813 22.2675 7.0229 22.2567 7.07601C22.2459 7.12912 22.2243 7.17943 22.1932 7.22382C22.1621 7.2682 22.1221 7.3057 22.0759 7.33397C22.0297 7.36224 21.9781 7.38068 21.9244 7.38814H21.9201L21.8259 7.40105L21.7328 7.41343C21.438 7.45182 21.1427 7.48769 20.8471 7.52105C20.2648 7.58742 19.6817 7.64482 19.0977 7.69325C17.9371 7.78976 16.7742 7.85308 15.609 7.88321C15.0153 7.899 14.4217 7.90635 13.8284 7.90527C11.4666 7.90341 9.10678 7.76614 6.76068 7.49415C6.50668 7.46401 6.25269 7.43173 5.9987 7.3989C6.19565 7.42419 5.85556 7.37953 5.78668 7.36984C5.62524 7.34724 5.46381 7.32374 5.30237 7.29935C4.76048 7.21809 4.22182 7.118 3.68101 7.03029C3.02719 6.92266 2.40189 6.97648 1.8105 7.29935C1.32505 7.56499 0.932149 7.97235 0.684209 8.46707C0.429139 8.99443 0.353264 9.56861 0.239182 10.1353C0.125101 10.7019 -0.0524802 11.3116 0.014785 11.8933C0.15954 13.1487 1.03722 14.169 2.29965 14.3972C3.48729 14.6124 4.68138 14.7868 5.8787 14.9353C10.582 15.5113 15.3337 15.5802 20.0517 15.1409C20.436 15.105 20.8196 15.0659 21.2028 15.0235C21.3225 15.0104 21.4436 15.0242 21.5572 15.0639C21.6709 15.1036 21.7742 15.1682 21.8596 15.2531C21.9451 15.3379 22.0105 15.4407 22.051 15.5541C22.0915 15.6675 22.1062 15.7885 22.0939 15.9082L21.9745 17.0695C21.7337 19.4161 21.493 21.7624 21.2523 24.1087C21.0012 26.5725 20.7484 29.0362 20.4941 31.4998C20.4223 32.1936 20.3506 32.8872 20.2788 33.5807C20.21 34.2636 20.2003 34.968 20.0706 35.6428C19.8661 36.7039 19.1477 37.3556 18.0994 37.594C17.1391 37.8125 16.158 37.9273 15.1731 37.9362C14.0813 37.9422 12.99 37.8937 11.8981 37.8996C10.7326 37.9061 9.30492 37.7985 8.40518 36.931C7.61468 36.169 7.50544 34.976 7.39782 33.9444C7.25432 32.5787 7.11207 31.2131 6.97109 29.8477L6.18005 22.2554L5.66829 17.3429C5.65968 17.2616 5.65107 17.1814 5.643 17.0996C5.58166 16.5136 5.16676 15.94 4.51295 15.9696C3.9533 15.9943 3.31724 16.47 3.38289 17.0996L3.76227 20.7416L4.54685 28.2753C4.77035 30.4153 4.99331 32.5556 5.21573 34.6962C5.25878 35.1063 5.29914 35.5174 5.34434 35.9274C5.59026 38.1682 7.30149 39.3757 9.42061 39.7158C10.6583 39.9149 11.9261 39.9558 13.1821 39.9762C14.7921 40.0021 16.4183 40.064 18.002 39.7723C20.3488 39.3418 22.1095 37.7748 22.3608 35.3441C22.4326 34.6424 22.5043 33.9405 22.5761 33.2384C22.8146 30.9166 23.0529 28.5946 23.2907 26.2724L24.0688 18.6849L24.4256 15.2076C24.4434 15.0352 24.5162 14.873 24.6333 14.7452C24.7503 14.6174 24.9055 14.5306 25.0757 14.4978C25.7467 14.367 26.3881 14.1437 26.8654 13.633C27.6253 12.8199 27.7765 11.7598 27.508 10.6911ZM2.26521 11.4413C2.27543 11.4364 2.2566 11.5241 2.24853 11.565C2.24691 11.5032 2.25014 11.4483 2.26521 11.4413ZM2.33032 11.945C2.33571 11.9412 2.35185 11.9627 2.36853 11.9885C2.34324 11.9649 2.32763 11.9471 2.33032 11.945ZM2.39436 12.0294C2.42988 12.0935 2.4175 12.0687 2.39436 12.0294ZM2.52297 12.1338H2.5262C2.5262 12.1376 2.53212 12.1414 2.53427 12.1451C2.5307 12.141 2.52728 12.1372 2.52297 12.1338ZM25.0444 11.9778C24.8034 12.207 24.4401 12.3136 24.0812 12.3668C20.0561 12.9642 15.9722 13.2666 11.903 13.1331C8.99065 13.0336 6.10901 12.7102 3.22576 12.3028C2.94324 12.263 2.63705 12.2113 2.44279 12.0031C2.07687 11.6102 2.2566 10.8192 2.35185 10.3446C2.43902 9.90978 2.60584 9.33022 3.12298 9.26834C3.93016 9.17363 4.86757 9.51426 5.66614 9.63533C6.62758 9.78206 7.59262 9.89955 8.56123 9.9878C12.6951 10.3645 16.8984 10.3058 21.0139 9.7548C21.764 9.65399 22.5115 9.53686 23.2563 9.4034C23.9198 9.28448 24.6554 9.06116 25.0563 9.74834C25.3313 10.2165 25.3679 10.8429 25.3253 11.3719C25.3122 11.6023 25.2121 11.8191 25.0444 11.9778Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M49.4553 23.1575C49.2203 23.6061 48.897 23.9967 48.4858 24.3282C48.0746 24.66 47.5948 24.9301 47.0464 25.138C46.4981 25.3465 45.9462 25.4864 45.3914 25.5577C44.8363 25.6292 44.2976 25.623 43.7756 25.5381C43.2533 25.4537 42.8091 25.2814 42.4438 25.0209L42.8553 20.7474C43.2337 20.6174 43.71 20.484 44.2847 20.3473C44.8592 20.2109 45.45 20.1131 46.0573 20.0547C46.6645 19.996 47.2387 20.0029 47.7809 20.0742C48.3223 20.1458 48.7502 20.3181 49.0635 20.5914C49.2332 20.7474 49.377 20.9165 49.4946 21.0987C49.6118 21.2809 49.6836 21.4695 49.71 21.6646C49.7751 22.211 49.6904 22.7086 49.4553 23.1575ZM43.4817 14.0541C43.756 13.885 44.0857 13.7352 44.4708 13.605C44.856 13.4752 45.251 13.3839 45.6558 13.3319C46.0603 13.2802 46.4553 13.2732 46.8407 13.3123C47.2256 13.3515 47.5655 13.4587 47.8592 13.6342C48.1528 13.81 48.3715 14.0637 48.5151 14.3952C48.6587 14.7272 48.698 15.1468 48.6326 15.6541C48.5805 16.0574 48.4202 16.399 48.1528 16.6786C47.8852 16.9586 47.5585 17.1925 47.1736 17.3812C46.7885 17.5701 46.3805 17.7196 45.9497 17.8298C45.5186 17.9407 45.1039 18.0221 44.7059 18.0739C44.3076 18.1261 43.9617 18.1588 43.668 18.1714C43.3741 18.1845 43.1813 18.191 43.0901 18.191L43.4817 14.0541ZM51.5705 20.3961C51.3615 19.941 51.0808 19.541 50.7284 19.1958C50.3759 18.8512 49.9577 18.6009 49.4749 18.4447C49.6836 18.2756 49.8894 18.009 50.0919 17.6446C50.2941 17.2806 50.4671 16.8835 50.6107 16.4543C50.7543 16.0247 50.8524 15.5925 50.9046 15.1565C50.9565 14.7208 50.9369 14.3467 50.846 14.0343C50.6236 13.2539 50.2745 12.6424 49.7979 12.2C49.3211 11.7578 48.7666 11.4521 48.1332 11.2828C47.4999 11.1142 46.8014 11.078 46.0377 11.1756C45.2739 11.2731 44.4934 11.465 43.6974 11.7512C43.6974 11.6863 43.7038 11.618 43.717 11.5464C43.7297 11.4751 43.7364 11.4001 43.7364 11.3219C43.7364 11.1268 43.6385 10.9579 43.4427 10.8146C43.2469 10.6715 43.0215 10.5871 42.7671 10.5608C42.5124 10.5351 42.2642 10.5901 42.0227 10.7267C41.7809 10.8634 41.6145 11.1142 41.5233 11.4778C41.4187 12.6489 41.3143 13.8654 41.21 15.127C41.1054 16.3891 40.9945 17.6641 40.877 18.9522C40.7595 20.2401 40.642 21.5183 40.5244 22.7866C40.4069 24.0552 40.2894 25.2747 40.1719 26.4454C40.2111 26.7967 40.309 27.0701 40.4658 27.2651C40.6223 27.4605 40.8052 27.5776 41.0142 27.6164C41.2229 27.6556 41.4418 27.6194 41.6701 27.509C41.8985 27.3988 42.0977 27.2065 42.2677 26.9334C42.7897 27.2196 43.3773 27.405 44.0303 27.4897C44.683 27.5741 45.3454 27.5741 46.0183 27.4897C46.6904 27.405 47.353 27.2458 48.006 27.0114C48.6587 26.7774 49.2528 26.4846 49.7882 26.1335C50.3234 25.7822 50.7739 25.3819 51.1397 24.9333C51.5051 24.4842 51.7467 23.9997 51.8642 23.4796C51.9817 22.946 52.0143 22.4128 51.9621 21.8793C51.9099 21.346 51.7792 20.8518 51.5705 20.3961Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M70.6738 30.6962C70.602 31.1255 70.5006 31.5776 70.3702 32.0527C70.2395 32.5273 70.0862 32.96 69.91 33.3504C69.7339 33.7406 69.5378 34.0558 69.3227 34.2967C69.107 34.5373 68.8752 34.6383 68.6272 34.5994C68.4314 34.5729 68.3072 34.4494 68.2553 34.2286C68.2028 34.007 68.2028 33.7339 68.2553 33.4089C68.3072 33.0836 68.4083 32.7159 68.5586 32.3062C68.7087 31.8965 68.8916 31.4897 69.107 31.0867C69.3227 30.6831 69.5674 30.2964 69.8415 29.9256C70.1158 29.5549 70.4027 29.2457 70.7031 28.9987C70.7685 29.0766 70.7978 29.2717 70.7913 29.5842C70.7844 29.8963 70.7454 30.2672 70.6738 30.6962ZM77.3133 22.2271C77.1369 22.032 76.9215 21.9216 76.6668 21.8954C76.4124 21.8694 76.1542 22.0125 75.8933 22.3247C75.7234 22.6368 75.508 22.9362 75.2468 23.2224C74.9857 23.5088 74.7149 23.7687 74.4341 24.0029C74.1533 24.2369 73.8857 24.4389 73.6311 24.6078C73.3766 24.7771 73.1774 24.9006 73.0337 24.9786C72.9816 24.5624 72.952 24.1136 72.9458 23.6321C72.9388 23.1508 72.9488 22.6631 72.9751 22.1687C73.0141 21.4661 73.0956 20.7573 73.2198 20.0416C73.3438 19.3261 73.5235 18.6235 73.7585 17.9338C73.7585 17.5698 73.6733 17.2737 73.5038 17.046C73.3339 16.8185 73.1284 16.6751 72.8869 16.6167C72.6451 16.5583 72.3974 16.5907 72.1427 16.7142C71.8881 16.838 71.6694 17.0626 71.4865 17.3874C71.33 17.8169 71.1504 18.2982 70.9481 18.8314C70.7454 19.365 70.517 19.9081 70.2626 20.461C70.0079 21.0143 69.7239 21.5508 69.4106 22.0709C69.0971 22.5915 68.7544 23.0535 68.3822 23.4566C68.0103 23.8598 67.6053 24.1755 67.1682 24.403C66.7304 24.6308 66.2576 24.7315 65.7482 24.7055C65.5129 24.6404 65.3432 24.4649 65.2389 24.1785C65.1343 23.8925 65.0724 23.5345 65.053 23.1053C65.0334 22.676 65.053 22.2043 65.1117 21.6904C65.1705 21.1767 65.2488 20.6659 65.3467 20.1587C65.4446 19.6512 65.5524 19.1699 65.6697 18.7146C65.7872 18.2593 65.8981 17.8753 66.0027 17.5631C66.1594 17.1861 66.1594 16.8702 66.0027 16.6167C65.8461 16.3629 65.6307 16.1941 65.3566 16.1092C65.0823 16.0247 64.7949 16.0282 64.4947 16.1191C64.1943 16.2102 63.9789 16.4117 63.8485 16.7239C63.6263 17.2576 63.4238 17.8558 63.2412 18.5193C63.0583 19.1827 62.9115 19.8693 62.8007 20.5781C62.6894 21.2873 62.6273 21.9899 62.6143 22.6859C62.6136 22.7312 62.6158 22.7742 62.6156 22.8193C62.3308 23.5756 62.0595 24.1473 61.8019 24.5298C61.4689 25.0244 61.0932 25.2391 60.6756 25.1737C60.4924 25.0957 60.3722 24.9138 60.3135 24.6273C60.2542 24.3414 60.2348 23.9901 60.2542 23.5734C60.2743 23.1575 60.3232 22.6859 60.4012 22.1588C60.48 21.632 60.5774 21.0856 60.6949 20.5196C60.8127 19.9534 60.9367 19.3848 61.0671 18.8121C61.1976 18.2398 61.3151 17.6998 61.42 17.1923C61.4068 16.737 61.2729 16.3892 61.0182 16.1483C60.7638 15.9079 60.4077 15.8136 59.951 15.8653C59.6377 15.9955 59.4056 16.1649 59.2556 16.3728C59.1053 16.5808 58.9845 16.8477 58.8933 17.1727C58.8409 17.3421 58.7626 17.6802 58.6583 18.1878C58.5537 18.6948 58.42 19.2773 58.2567 19.9341C58.0935 20.5914 57.9009 21.2774 57.6791 21.9929C57.4569 22.7084 57.209 23.356 56.9349 23.9346C56.6606 24.5134 56.3602 24.9786 56.034 25.3299C55.7075 25.681 55.3549 25.8243 54.9762 25.7592C54.7673 25.7201 54.6336 25.5054 54.575 25.1153C54.5161 24.7249 54.5064 24.2438 54.5454 23.6712C54.5847 23.0988 54.6629 22.471 54.7805 21.7882C54.898 21.1051 55.0185 20.458 55.1427 19.8462C55.2667 19.235 55.381 18.6948 55.4856 18.2266C55.59 17.7582 55.6618 17.446 55.701 17.2901C55.701 16.9128 55.6158 16.6105 55.4463 16.3825C55.2764 16.1552 55.0709 16.0119 54.8294 15.9532C54.5876 15.8948 54.3397 15.9272 54.0852 16.0507C53.8306 16.1745 53.6119 16.3991 53.4291 16.7239C53.3637 17.0752 53.2787 17.4819 53.1744 17.9437C53.0698 18.4054 52.9689 18.8802 52.871 19.3682C52.7731 19.8561 52.6814 20.3342 52.5967 20.8026C52.5117 21.271 52.4498 21.6807 52.4106 22.032C52.3845 22.3051 52.3549 22.6403 52.3226 23.0369C52.2898 23.434 52.2734 23.8534 52.2734 24.2956C52.2734 24.7382 52.306 25.1772 52.3716 25.6129C52.4367 26.0489 52.5542 26.4489 52.7239 26.8129C52.8936 27.1773 53.1319 27.4763 53.439 27.7106C53.7456 27.9448 54.1342 28.0747 54.6043 28.101C55.0871 28.1267 55.5082 28.0913 55.8675 27.9935C56.2265 27.896 56.5528 27.743 56.8467 27.5348C57.1404 27.3271 57.408 27.0797 57.6497 26.7933C57.891 26.5074 58.1295 26.1952 58.3646 25.8567C58.5865 26.3514 58.8737 26.7349 59.2263 27.0082C59.5788 27.2813 59.951 27.4442 60.3426 27.4959C60.7342 27.5476 61.1327 27.4929 61.5375 27.33C61.942 27.1676 62.3075 26.8911 62.6342 26.5007C62.8491 26.2613 63.0519 25.9892 63.2422 25.6884C63.323 25.8293 63.4089 25.9652 63.5056 26.0907C63.8256 26.5074 64.2599 26.7933 64.8083 26.9495C65.3957 27.1057 65.9699 27.132 66.5316 27.0278C67.0929 26.9238 67.6284 26.7349 68.1375 26.4618C68.6468 26.1885 69.1199 25.8602 69.5575 25.4762C69.9948 25.0925 70.3767 24.6927 70.7031 24.276C70.69 24.5753 70.6835 24.8585 70.6835 25.1249C70.6835 25.3918 70.677 25.681 70.6641 25.9934C70.0109 26.4489 69.3942 26.9953 68.8133 27.6326C68.2321 28.2698 67.7228 28.9496 67.2855 29.6718C66.8482 30.3937 66.5053 31.1255 66.2576 31.867C66.0094 32.609 65.8884 33.3014 65.8951 33.9456C65.9015 34.5895 66.0548 35.152 66.3552 35.6333C66.6554 36.1148 67.1451 36.4594 67.8242 36.6676C68.5293 36.889 69.1492 36.8952 69.6849 36.6872C70.2201 36.479 70.6867 36.1341 71.085 35.6528C71.4833 35.1716 71.8096 34.5895 72.0645 33.9065C72.3189 33.2234 72.5214 32.5112 72.6715 31.7697C72.8216 31.0282 72.9162 30.2991 72.9555 29.5842C72.9947 28.8684 72.9947 28.2307 72.9555 27.6714C74.0783 27.2033 74.9986 26.6113 75.7169 25.8956C76.435 25.1806 77.0291 24.4258 77.4992 23.6321C77.6428 23.437 77.6917 23.2028 77.6463 22.9297C77.6003 22.6564 77.4895 22.4222 77.3133 22.2271Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M102.022 20.9834C102.061 20.6843 102.12 20.3687 102.198 20.0369C102.277 19.7052 102.375 19.3831 102.492 19.0709C102.61 18.7587 102.747 18.4889 102.903 18.2611C103.06 18.0336 103.227 17.8709 103.403 17.7731C103.579 17.6759 103.758 17.6855 103.942 17.8024C104.137 17.9197 104.258 18.1668 104.304 18.5438C104.349 18.9216 104.304 19.3247 104.167 19.754C104.03 20.1835 103.785 20.5865 103.432 20.9638C103.08 21.3414 102.603 21.5882 102.003 21.7053C101.976 21.5236 101.983 21.2827 102.022 20.9834ZM108.808 21.7833C108.593 21.7187 108.387 21.712 108.191 21.764C107.996 21.816 107.871 21.9526 107.819 22.174C107.715 22.5901 107.548 23.0162 107.32 23.4519C107.091 23.8879 106.811 24.3008 106.478 24.6913C106.145 25.0814 105.769 25.4263 105.352 25.7254C104.934 26.0247 104.496 26.2393 104.039 26.3693C103.582 26.5126 103.204 26.5287 102.903 26.4181C102.603 26.3079 102.365 26.119 102.189 25.8524C102.012 25.5857 101.885 25.2636 101.807 24.8863C101.728 24.509 101.683 24.1189 101.67 23.7153C102.414 23.7676 103.076 23.6344 103.658 23.3153C104.238 22.9969 104.731 22.5738 105.136 22.047C105.541 21.5201 105.848 20.9282 106.057 20.2711C106.265 19.6143 106.383 18.9605 106.409 18.3099C106.422 17.6984 106.331 17.1815 106.135 16.7586C105.939 16.336 105.675 16.007 105.342 15.773C105.009 15.5388 104.627 15.4022 104.196 15.3633C103.765 15.3242 103.328 15.3829 102.884 15.5388C102.348 15.721 101.895 16.0169 101.523 16.4269C101.151 16.8366 100.84 17.3117 100.593 17.8514C100.344 18.3913 100.148 18.9734 100.005 19.5977C99.861 20.2224 99.7567 20.8371 99.6916 21.4421C99.6327 21.9851 99.6014 22.5042 99.5902 23.0053C99.5624 23.0689 99.5353 23.1301 99.5055 23.1982C99.303 23.6604 99.0677 24.1124 98.8003 24.5546C98.5327 24.997 98.2356 25.3679 97.9093 25.6669C97.5828 25.9662 97.2434 26.0702 96.8909 25.9791C96.6819 25.9274 96.5679 25.6862 96.5482 25.2572C96.5286 24.8277 96.5512 24.2944 96.6166 23.6569C96.6819 23.0197 96.7569 22.3297 96.8419 21.5882C96.9266 20.8467 96.9691 20.1379 96.9691 19.4613C96.9691 18.8758 96.8581 18.3133 96.6362 17.7731C96.4141 17.2337 96.1104 16.7846 95.7256 16.4269C95.3402 16.0689 94.8932 15.8315 94.3841 15.7146C93.8747 15.5973 93.3264 15.6755 92.739 15.9486C92.1511 16.2219 91.6845 16.6056 91.3386 17.1C90.9923 17.5947 90.6757 18.1148 90.3888 18.6612C90.2839 18.2448 90.1309 17.8581 89.9284 17.5001C89.7259 17.1423 89.4781 16.8302 89.1842 16.5633C88.8903 16.2969 88.5603 16.0887 88.1953 15.9389C87.8296 15.7896 87.4442 15.7146 87.0394 15.7146C86.6479 15.7146 86.2856 15.7896 85.9527 15.9389C85.6197 16.0887 85.3161 16.2803 85.0418 16.5145C84.7677 16.749 84.5198 17.0121 84.2976 17.305C84.0757 17.5976 83.8795 17.8873 83.7102 18.1732C83.6837 17.835 83.6543 17.5392 83.622 17.2852C83.5892 17.0317 83.5304 16.817 83.4456 16.6415C83.3607 16.4657 83.2402 16.3325 83.0834 16.2414C82.9266 16.1506 82.7047 16.1048 82.4177 16.1048C82.2739 16.1048 82.13 16.134 81.9866 16.1924C81.8428 16.2511 81.7153 16.3325 81.6048 16.4365C81.4937 16.541 81.409 16.6675 81.3503 16.817C81.2912 16.9666 81.2753 17.1391 81.3011 17.3342C81.314 17.4776 81.3503 17.6496 81.409 17.8514C81.4676 18.0532 81.523 18.3168 81.5754 18.6416C81.6274 18.9669 81.6698 19.3606 81.7026 19.8223C81.7352 20.2843 81.7449 20.8502 81.732 21.5201C81.7188 22.1903 81.6698 22.9739 81.5851 23.8715C81.4999 24.7692 81.3662 25.81 81.1836 26.9937C81.1575 27.267 81.2619 27.4883 81.4972 27.6574C81.732 27.8262 81.9996 27.9238 82.3 27.95C82.6001 27.976 82.8843 27.9238 83.1519 27.794C83.4195 27.6636 83.5731 27.4361 83.6121 27.111C83.6514 26.4995 83.7264 25.8491 83.8375 25.1594C83.9483 24.4702 84.0854 23.7871 84.2487 23.1105C84.4119 22.4342 84.5978 21.7902 84.807 21.1785C85.0157 20.567 85.2475 20.0273 85.5022 19.5589C85.7569 19.0905 86.0212 18.7166 86.2953 18.4369C86.5696 18.1571 86.8566 18.0173 87.1572 18.0173C87.5227 18.0173 87.8065 18.1829 88.0092 18.5146C88.2112 18.8466 88.3548 19.2729 88.44 19.7928C88.5248 20.3135 88.5638 20.8829 88.5576 21.5006C88.5506 22.1185 88.5248 22.7137 88.4791 23.286C88.4333 23.8587 88.3812 24.3692 88.3223 24.818C88.2636 25.2669 88.2211 25.5761 88.1953 25.7449C88.1953 26.0442 88.3093 26.2814 88.5377 26.4572C88.766 26.6327 89.0207 26.7369 89.3017 26.7694C89.5825 26.802 89.8466 26.7498 90.0948 26.6131C90.3428 26.4765 90.4864 26.246 90.5257 25.9204C90.6561 24.9839 90.8357 24.0441 91.0641 23.1009C91.2924 22.1576 91.5538 21.3122 91.8478 20.564C92.1414 19.8159 92.4677 19.2044 92.827 18.7295C93.186 18.2549 93.5679 18.0173 93.9729 18.0173C94.1813 18.0173 94.3416 18.1606 94.4524 18.4465C94.5632 18.7327 94.6189 19.1229 94.6189 19.6173C94.6189 19.9817 94.5896 20.3558 94.5309 20.7395C94.472 21.1233 94.4037 21.5201 94.3252 21.9299C94.2469 22.3398 94.1784 22.7592 94.1195 23.1885C94.0608 23.618 94.0315 24.0666 94.0315 24.535C94.0315 24.8603 94.0641 25.2376 94.1294 25.6669C94.1945 26.096 94.3185 26.503 94.5014 26.8865C94.6842 27.2704 94.9354 27.5955 95.2557 27.8621C95.5755 28.1288 95.9832 28.2622 96.4794 28.2622C97.2238 28.2622 97.883 28.1028 98.4577 27.7841C99.0321 27.4655 99.5251 27.0494 99.9363 26.5354C99.9577 26.5084 99.9771 26.4797 99.9979 26.453C100.029 26.529 100.057 26.6094 100.093 26.6817C100.374 27.2541 100.755 27.6963 101.239 28.0087C101.722 28.3209 102.29 28.4932 102.943 28.5259C103.595 28.558 104.307 28.4377 105.078 28.1647C105.652 27.9565 106.151 27.6963 106.576 27.3841C107 27.0719 107.382 26.6914 107.721 26.2425C108.061 25.7937 108.371 25.2765 108.652 24.6913C108.933 24.1055 109.216 23.4358 109.503 22.681C109.556 22.4733 109.507 22.2878 109.357 22.1249C109.207 21.9625 109.024 21.8486 108.808 21.7833Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M119.448 19.606C119.383 19.9899 119.295 20.413 119.184 20.8745C119.072 21.3365 118.932 21.8145 118.763 22.3089C118.593 22.8033 118.384 23.249 118.136 23.6456C117.888 24.0427 117.604 24.3578 117.284 24.592C116.964 24.8262 116.595 24.9238 116.177 24.8847C115.968 24.8589 115.808 24.7158 115.698 24.4554C115.587 24.1954 115.528 23.8634 115.521 23.4601C115.515 23.0571 115.55 22.6147 115.629 22.1332C115.707 21.6521 115.828 21.1803 115.992 20.7183C116.154 20.2568 116.354 19.8305 116.589 19.4401C116.824 19.0499 117.094 18.7474 117.402 18.5327C117.708 18.3181 118.045 18.2176 118.41 18.2302C118.776 18.2433 119.167 18.4253 119.585 18.7766C119.559 18.9459 119.514 19.2225 119.448 19.606ZM126.41 21.0988C126.208 20.9948 125.999 20.9723 125.784 21.0307C125.569 21.0892 125.415 21.2877 125.324 21.6259C125.271 21.9903 125.154 22.4193 124.971 22.9137C124.788 23.4081 124.563 23.8768 124.295 24.3187C124.028 24.7611 123.721 25.1288 123.375 25.4214C123.029 25.7143 122.66 25.8477 122.269 25.8212C121.942 25.7955 121.713 25.6296 121.583 25.3238C121.452 25.0181 121.384 24.6346 121.377 24.1724C121.371 23.7109 121.417 23.1905 121.514 22.6115C121.612 22.0326 121.73 21.457 121.867 20.8842C122.004 20.312 122.144 19.7622 122.288 19.2353C122.431 18.7085 122.549 18.2629 122.641 17.8987C122.745 17.5734 122.712 17.2971 122.543 17.0691C122.373 16.8418 122.161 16.6789 121.906 16.5814C121.651 16.4839 121.393 16.4579 121.132 16.5034C120.871 16.549 120.702 16.6888 120.623 16.9228C119.853 16.2593 119.112 15.9016 118.4 15.8496C117.689 15.7976 117.032 15.9538 116.432 16.318C115.831 16.6822 115.299 17.209 114.836 17.8987C114.372 18.5884 113.997 19.3396 113.71 20.1526C113.422 20.9656 113.243 21.7952 113.171 22.6407C113.099 23.4864 113.155 24.2573 113.338 24.9532C113.521 25.6491 113.843 26.2186 114.307 26.6605C114.77 27.1029 115.4 27.3242 116.197 27.3242C116.55 27.3242 116.889 27.2527 117.215 27.1096C117.542 26.9662 117.842 26.7971 118.116 26.602C118.39 26.407 118.632 26.202 118.841 25.9873C119.05 25.7727 119.213 25.5939 119.331 25.4506C119.422 25.919 119.572 26.3161 119.781 26.6412C119.99 26.9662 120.228 27.2333 120.496 27.4411C120.763 27.649 121.044 27.802 121.338 27.8998C121.632 27.9974 121.916 28.0461 122.19 28.0461C122.804 28.0461 123.378 27.8379 123.914 27.4215C124.449 27.0056 124.929 26.4946 125.353 25.8898C125.777 25.2847 126.127 24.6475 126.401 23.9773C126.675 23.3074 126.858 22.7122 126.949 22.1916C127.041 21.9965 127.024 21.7918 126.9 21.5771C126.776 21.3625 126.613 21.2033 126.41 21.0988Z"
          fill="currentColor"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M161.672 31.8755C161.561 32.3177 161.388 32.692 161.153 32.9975C160.918 33.3032 160.624 33.4627 160.271 33.4758C160.049 33.4887 159.88 33.3716 159.762 33.1245C159.645 32.8772 159.563 32.5586 159.518 32.1684C159.472 31.778 159.452 31.342 159.459 30.8607C159.465 30.3794 159.485 29.9046 159.518 29.4362C159.55 28.968 159.589 28.5318 159.635 28.1288C159.681 27.7252 159.716 27.4136 159.743 27.1922C160.186 27.2442 160.556 27.4358 160.849 27.7678C161.143 28.0996 161.368 28.493 161.525 28.9485C161.682 29.4038 161.773 29.8949 161.799 30.4218C161.825 30.9486 161.783 31.4331 161.672 31.8755ZM154.582 31.8755C154.471 32.3177 154.298 32.692 154.063 32.9975C153.828 33.3032 153.534 33.4627 153.182 33.4758C152.96 33.4887 152.79 33.3716 152.673 33.1245C152.555 32.8772 152.473 32.5586 152.428 32.1684C152.382 31.778 152.362 31.342 152.369 30.8607C152.375 30.3794 152.395 29.9046 152.428 29.4362C152.46 28.968 152.499 28.5318 152.545 28.1288C152.591 27.7252 152.627 27.4136 152.653 27.1922C153.097 27.2442 153.466 27.4358 153.759 27.7678C154.053 28.0996 154.278 28.493 154.435 28.9485C154.592 29.4038 154.683 29.8949 154.709 30.4218C154.735 30.9486 154.693 31.4331 154.582 31.8755ZM147.306 20.7915C147.293 21.1035 147.264 21.38 147.218 21.6207C147.172 21.8618 147.11 22.0143 147.032 22.0794C146.888 22.0012 146.712 21.7999 146.503 21.4743C146.294 21.1493 146.131 20.7814 146.013 20.3717C145.896 19.9619 145.86 19.5589 145.906 19.1618C145.951 18.7652 146.157 18.4565 146.523 18.2349C146.666 18.1569 146.79 18.1861 146.895 18.3228C146.999 18.4594 147.084 18.6577 147.15 18.9179C147.215 19.1784 147.26 19.4774 147.287 19.8156C147.313 20.1541 147.319 20.4791 147.306 20.7915ZM145.573 24.6846C145.37 24.899 145.145 25.0844 144.897 25.2406C144.649 25.3968 144.394 25.5139 144.134 25.5919C143.872 25.6702 143.637 25.6895 143.428 25.6504C142.841 25.5335 142.39 25.2795 142.077 24.8893C141.764 24.4992 141.564 24.0407 141.48 23.5138C141.395 22.9868 141.404 22.424 141.509 21.8256C141.613 21.2273 141.789 20.6712 142.038 20.1573C142.286 19.6433 142.586 19.2009 142.939 18.8303C143.291 18.4594 143.676 18.2287 144.094 18.1373C143.937 18.8008 143.885 19.4873 143.937 20.1961C143.99 20.9052 144.16 21.5719 144.447 22.1963C144.629 22.5741 144.848 22.9184 145.103 23.2306C145.357 23.543 145.668 23.8097 146.033 24.0308C145.929 24.2521 145.775 24.4699 145.573 24.6846ZM167.244 20.9866C167.283 20.6876 167.341 20.3717 167.42 20.0399C167.498 19.7084 167.596 19.3863 167.714 19.0742C167.831 18.7617 167.968 18.4919 168.125 18.2643C168.282 18.0368 168.448 17.8739 168.624 17.7764C168.801 17.6788 168.98 17.6885 169.163 17.8056C169.359 17.9229 169.48 18.17 169.525 18.5471C169.571 18.9246 169.525 19.3277 169.388 19.7572C169.251 20.1865 169.006 20.5898 168.654 20.9668C168.302 21.3446 167.825 21.5914 167.224 21.7085C167.198 21.5266 167.205 21.2859 167.244 20.9866ZM175.137 20.9866C175.176 20.6876 175.234 20.3717 175.313 20.0399C175.391 19.7084 175.489 19.3863 175.607 19.0742C175.724 18.7617 175.861 18.4919 176.018 18.2643C176.175 18.0368 176.341 17.8739 176.517 17.7764C176.694 17.6788 176.873 17.6885 177.056 17.8056C177.252 17.9229 177.372 18.17 177.418 18.5471C177.464 18.9246 177.418 19.3277 177.281 19.7572C177.144 20.1865 176.899 20.5898 176.547 20.9668C176.194 21.3446 175.717 21.5914 175.117 21.7085C175.091 21.5266 175.097 21.2859 175.137 20.9866ZM182.471 22.1282C182.321 21.9658 182.138 21.8519 181.923 21.7865C181.708 21.7217 181.502 21.7152 181.306 21.7672C181.11 21.8192 180.986 21.9559 180.934 22.1769C180.829 22.5934 180.663 23.0194 180.434 23.4549C180.206 23.8911 179.925 24.3041 179.592 24.6942C179.259 25.0844 178.884 25.4295 178.466 25.7286C178.048 26.0279 177.611 26.2425 177.154 26.3723C176.697 26.5159 176.318 26.532 176.018 26.4213C175.717 26.3109 175.479 26.1222 175.303 25.8556C175.127 25.5887 175 25.2669 174.921 24.8893C174.843 24.5123 174.797 24.1221 174.784 23.7186C175.528 23.7708 176.191 23.6376 176.772 23.3185C177.353 22.9999 177.846 22.5768 178.251 22.0499C178.655 21.5234 178.962 20.9314 179.171 20.2744C179.38 19.6173 179.497 18.9637 179.524 18.3131C179.536 17.7016 179.445 17.1844 179.249 16.7616C179.054 16.339 178.789 16.0102 178.456 15.7763C178.123 15.5418 177.741 15.4054 177.31 15.3663C176.88 15.3272 176.442 15.3861 175.998 15.5418C175.463 15.7243 175.009 16.0201 174.637 16.4299C174.265 16.8398 173.955 17.3149 173.707 17.8544C173.459 18.3946 173.263 18.9764 173.119 19.601C172.975 20.2254 172.871 20.8403 172.806 21.4451C172.743 22.0321 172.708 22.5939 172.7 23.1316C172.651 23.2388 172.598 23.3465 172.541 23.4549C172.313 23.8911 172.032 24.3041 171.699 24.6942C171.367 25.0844 170.991 25.4295 170.573 25.7286C170.155 26.0279 169.718 26.2425 169.261 26.3723C168.804 26.5159 168.425 26.532 168.125 26.4213C167.825 26.3109 167.586 26.1222 167.41 25.8556C167.234 25.5887 167.107 25.2669 167.028 24.8893C166.95 24.5123 166.904 24.1221 166.891 23.7186C167.635 23.7708 168.298 23.6376 168.879 23.3185C169.46 22.9999 169.953 22.5768 170.358 22.0499C170.762 21.5234 171.069 20.9314 171.278 20.2744C171.487 19.6173 171.605 18.9637 171.631 18.3131C171.644 17.7016 171.552 17.1844 171.357 16.7616C171.161 16.339 170.896 16.0102 170.563 15.7763C170.23 15.5418 169.848 15.4054 169.418 15.3663C168.987 15.3272 168.549 15.3861 168.105 15.5418C167.57 15.7243 167.116 16.0201 166.744 16.4299C166.372 16.8398 166.062 17.3149 165.814 17.8544C165.566 18.3946 165.37 18.9764 165.227 19.601C165.083 20.2254 164.978 20.8403 164.913 21.4451C164.876 21.7863 164.851 22.117 164.833 22.4418C164.707 22.5488 164.584 22.6565 164.453 22.7622C164.003 23.1266 163.529 23.4549 163.033 23.7478C162.536 24.0407 162.021 24.2813 161.486 24.4699C160.95 24.6586 160.402 24.7725 159.841 24.8113L161.055 11.8538C161.133 11.5804 161.094 11.3401 160.938 11.1319C160.781 10.9236 160.578 10.7806 160.33 10.7026C160.082 10.6243 159.818 10.631 159.537 10.7219C159.256 10.8132 159.025 11.0214 158.842 11.3462C158.75 11.8409 158.656 12.5173 158.558 13.3758C158.46 14.2344 158.362 15.1712 158.264 16.186C158.166 17.2008 158.068 18.248 157.97 19.3277C157.872 20.4078 157.787 21.4159 157.716 22.3525C157.712 22.3941 157.71 22.4317 157.706 22.4728C157.592 22.5693 157.481 22.6666 157.363 22.7622C156.913 23.1266 156.439 23.4549 155.943 23.7478C155.447 24.0407 154.931 24.2813 154.396 24.4699C153.86 24.6586 153.312 24.7725 152.751 24.8113L153.965 11.8538C154.044 11.5804 154.004 11.3401 153.848 11.1319C153.691 10.9236 153.488 10.7806 153.24 10.7026C152.992 10.6243 152.728 10.631 152.447 10.7219C152.166 10.8132 151.935 11.0214 151.752 11.3462C151.661 11.8409 151.566 12.5173 151.468 13.3758C151.37 14.2344 151.272 15.1712 151.174 16.186C151.076 17.2008 150.979 18.248 150.88 19.3277C150.783 20.4078 150.697 21.4159 150.626 22.3525C150.624 22.3713 150.623 22.3884 150.622 22.4072C150.416 22.502 150.193 22.5852 149.95 22.655C149.702 22.7268 149.421 22.7691 149.108 22.782C149.16 22.5476 149.202 22.2874 149.235 22.0012C149.268 21.7152 149.294 21.4159 149.314 21.1035C149.333 20.7915 149.34 20.4791 149.333 20.1669C149.326 19.8545 149.31 19.5685 149.284 19.3081C149.219 18.7491 149.098 18.2188 148.922 17.7177C148.746 17.2171 148.508 16.7977 148.207 16.4591C147.907 16.1209 147.532 15.8931 147.081 15.7763C146.631 15.6592 146.105 15.698 145.505 15.8931C144.616 15.7763 143.817 15.8577 143.105 16.1372C142.394 16.4172 141.777 16.8235 141.254 17.3568C140.732 17.8905 140.305 18.5179 139.972 19.24C139.639 19.9619 139.417 20.7037 139.306 21.4644C139.259 21.787 139.236 22.1081 139.229 22.4285C139.027 22.8409 138.805 23.2014 138.561 23.5039C138.216 23.9332 137.857 24.2845 137.484 24.5576C137.112 24.8309 136.743 25.0391 136.378 25.1822C136.012 25.3255 135.686 25.4231 135.399 25.4748C135.059 25.5399 134.733 25.5466 134.419 25.4944C134.106 25.4426 133.818 25.2929 133.558 25.0455C133.349 24.8636 133.189 24.5707 133.078 24.1674C132.967 23.7641 132.902 23.3059 132.882 22.7917C132.862 22.2777 132.882 21.741 132.941 21.1817C133 20.6225 133.1 20.0922 133.244 19.5913C133.388 19.0905 133.57 18.6416 133.793 18.2445C134.014 17.8482 134.275 17.565 134.576 17.3959C134.745 17.4221 134.85 17.5226 134.889 17.6982C134.929 17.8739 134.938 18.0821 134.919 18.3228C134.899 18.5637 134.87 18.8107 134.831 19.0642C134.791 19.318 134.772 19.5297 134.772 19.6985C134.837 20.0498 134.964 20.3231 135.154 20.5182C135.343 20.7133 135.555 20.8274 135.79 20.8596C136.025 20.8923 136.257 20.8371 136.486 20.6938C136.714 20.5509 136.9 20.3231 137.044 20.0107C137.057 20.0238 137.076 20.0303 137.102 20.0303L137.377 17.5521C137.455 17.2137 137.403 16.9146 137.22 16.6544C137.037 16.3942 136.796 16.2444 136.495 16.2056C136.117 15.6592 135.604 15.3698 134.958 15.3371C134.312 15.3046 133.649 15.5161 132.97 15.9714C132.552 16.2709 132.183 16.6836 131.864 17.2104C131.543 17.7375 131.282 18.3228 131.08 18.9667C130.877 19.6106 130.734 20.2907 130.649 21.0062C130.564 21.7217 130.548 22.4178 130.6 23.0939C130.652 23.7708 130.773 24.4083 130.963 25.0064C131.152 25.6051 131.416 26.1059 131.756 26.5089C132.043 26.8602 132.369 27.1175 132.735 27.2801C133.1 27.4428 133.482 27.5433 133.881 27.5824C134.279 27.6213 134.674 27.6049 135.066 27.5336C135.457 27.4623 135.83 27.3616 136.182 27.2311C136.639 27.0623 137.109 26.8474 137.592 26.5872C138.075 26.3272 138.539 26.0148 138.983 25.6504C139.216 25.4587 139.441 25.2498 139.658 25.0257C139.757 25.2703 139.868 25.507 140.001 25.7286C140.354 26.3138 140.83 26.7889 141.431 27.1531C142.031 27.5173 142.769 27.6926 143.644 27.6799C144.584 27.6668 145.452 27.4296 146.249 26.9677C147.045 26.5062 147.698 25.8259 148.207 24.9284C148.97 24.9284 149.72 24.8032 150.458 24.5544C150.452 24.6331 150.446 24.716 150.44 24.792C150.388 25.4815 150.361 25.9497 150.361 26.197C150.349 26.6263 150.319 27.1563 150.273 27.7871C150.228 28.4182 150.198 29.0817 150.185 29.7776C150.172 30.4735 150.198 31.1761 150.264 31.8854C150.329 32.5942 150.466 33.2384 150.675 33.8175C150.884 34.396 151.181 34.8872 151.566 35.2907C151.951 35.6938 152.457 35.9347 153.084 36.0127C153.75 36.1035 154.324 35.9864 154.807 35.6614C155.29 35.336 155.682 34.8907 155.983 34.3247C156.283 33.7585 156.495 33.1049 156.619 32.3635C156.743 31.622 156.779 30.8771 156.727 30.1289C156.674 29.3807 156.537 28.6752 156.315 28.0119C156.093 27.3482 155.786 26.8018 155.395 26.3723C155.63 26.3077 155.911 26.1841 156.237 26.0017C156.563 25.8197 156.899 25.6147 157.246 25.3869C157.331 25.331 157.415 25.2721 157.499 25.2146C157.467 25.6756 157.451 26.0044 157.451 26.197C157.438 26.6263 157.409 27.1563 157.363 27.7871C157.318 28.4182 157.288 29.0817 157.275 29.7776C157.262 30.4735 157.288 31.1761 157.353 31.8854C157.419 32.5942 157.556 33.2384 157.765 33.8175C157.973 34.396 158.27 34.8872 158.656 35.2907C159.041 35.6938 159.547 35.9347 160.174 36.0127C160.839 36.1035 161.414 35.9864 161.897 35.6614C162.38 35.336 162.772 34.8907 163.072 34.3247C163.372 33.7585 163.584 33.1049 163.709 32.3635C163.833 31.622 163.868 30.8771 163.816 30.1289C163.764 29.3807 163.627 28.6752 163.405 28.0119C163.183 27.3482 162.876 26.8018 162.484 26.3723C162.72 26.3077 163 26.1841 163.327 26.0017C163.653 25.8197 163.989 25.6147 164.336 25.3869C164.515 25.2686 164.694 25.1466 164.872 25.021C164.94 25.6573 165.084 26.2153 165.314 26.6847C165.595 27.2573 165.977 27.6995 166.46 28.0119C166.943 28.3239 167.511 28.4964 168.164 28.5289C168.817 28.561 169.528 28.441 170.299 28.1677C170.873 27.9597 171.373 27.6995 171.797 27.3873C172.221 27.0749 172.603 26.6944 172.943 26.2458C172.963 26.2198 172.981 26.1915 173 26.1653C173.061 26.3475 173.128 26.5225 173.207 26.6847C173.488 27.2573 173.87 27.6995 174.353 28.0119C174.836 28.3239 175.404 28.4964 176.057 28.5289C176.71 28.561 177.421 28.441 178.192 28.1677C178.766 27.9597 179.266 27.6995 179.69 27.3873C180.114 27.0749 180.496 26.6944 180.836 26.2458C181.175 25.7967 181.485 25.2795 181.766 24.6942C182.047 24.1087 182.331 23.4391 182.618 22.6842C182.67 22.4763 182.621 22.2908 182.471 22.1282Z"
          fill="currentColor"
        />
        <g clipPath="url(#clip1_2397_300)">
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M189.451 9.22969C187.371 9.22969 185.685 10.9159 185.685 12.9959C185.685 15.0759 187.371 16.7621 189.451 16.7621C191.531 16.7621 193.217 15.0759 193.217 12.9959C193.217 10.9159 191.531 9.22969 189.451 9.22969ZM185 12.9959C185 10.5377 186.993 8.54492 189.451 8.54492C191.909 8.54492 193.902 10.5377 193.902 12.9959C193.902 15.4541 191.909 17.4469 189.451 17.4469C186.993 17.4469 185 15.4541 185 12.9959ZM188.082 11.2839C188.082 11.0948 188.235 10.9415 188.424 10.9415H189.794C190.157 10.9415 190.505 11.0858 190.762 11.3426C191.019 11.5994 191.163 11.9478 191.163 12.311C191.163 12.6742 191.019 13.0226 190.762 13.2794C190.66 13.3818 190.543 13.4663 190.416 13.5309L191.101 14.5125C191.209 14.6675 191.171 14.881 191.016 14.9892C190.861 15.0974 190.648 15.0594 190.54 14.9043L189.686 13.6805H188.766V14.7077C188.766 14.8968 188.613 15.0501 188.424 15.0501C188.235 15.0501 188.082 14.8968 188.082 14.7077V11.2839ZM189.864 12.9922C189.847 12.9921 189.831 12.9932 189.814 12.9955C189.807 12.9957 189.8 12.9958 189.794 12.9958H188.766V11.6262H189.794C189.975 11.6262 190.149 11.6984 190.278 11.8268C190.406 11.9552 190.478 12.1294 190.478 12.311C190.478 12.4926 190.406 12.6668 190.278 12.7952C190.166 12.907 190.019 12.9762 189.864 12.9922Z"
            fill="#currentColor"
          />
        </g>
      </g>
      <defs>
        <clipPath id="clip0_2397_300">
          <rect width="195" height="40" fill="white" />
        </clipPath>
        <clipPath id="clip1_2397_300">
          <rect
            width="9.82286"
            height="9.82286"
            fill="white"
            transform="translate(185 8)"
          />
        </clipPath>
      </defs>
    </svg>
  );
};