# Contributing to github-emoji-picker

We love your input! 🚀 We want to make contributing to this project as easy and transparent as possible, whether it's:

- [Reporting a bug](https://github.com/rickstaa/github-emoji-picker/issues).
- [Discussing the current state of the code](https://github.com/rickstaa/github-emoji-picker/discussions).
- [Submitting a fix](https://github.com/rickstaa/github-emoji-picker/pulls).
- [Proposing new features](https://github.com/rickstaa/github-emoji-picker/issues).
- Becoming a maintainer.
- [Providing translations](https://crowdin.com/project/github-emoji-picker/).

## We Develop with Github

We use github to host code, track issues and feature requests, and accept pull requests.

## We Use [Github Flow](https://guides.github.com/introduction/flow/index.html), So All Code Changes Happen Through Pull Requests

Pull requests are the best way to propose changes to the codebase (we use [Github Flow](https://docs.github.com/en/get-started/quickstart/github-flow)). We actively welcome your pull requests:

1. Fork the repo and create your branch from `main`.
2. Add tests if you've added code that should be tested.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Build the node package using the `npm run build` and `npm run package` commands.
7. Issue that pull request!

## Any contributions you make will be under the MIT Software License

In short, when you submit code changes, your submissions are understood to be under the same [MIT License](http://choosealicense.com/licenses/mit/) that covers the project. Feel free to contact the maintainers if that's a concern.

## Report bugs using Github's [issues](https://github.com/rickstaa/github-emoji-picker/issues)

We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/rickstaa/github-emoji-picker/issues/new/choose); it's that easy!

## Write bug reports with detail, background, and sample code

[This is an example](http://stackoverflow.com/q/12488905/180626) of a bug report, and I think it's a good model. Here's [another example from Craig Hockenberry](http://www.openradar.me/11905408), an app developer greatly respected in the community.

**Great Bug Reports** tend to have:

- A quick summary and/or background.
- Steps to reproduce:
  - Be specific!
  - Give sample code if you can. [This stackoverflow question](http://stackoverflow.com/q/12488905/180626) includes sample code that _anyone_ with a base R setup can run to reproduce the error.
- What you expected would happen
- What actually happens.
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work).

People _love_ thorough bug reports. I'm not even kidding.

## Use a Consistent Coding Style

We use the [prettier](https://prettier.io/) formatter to format our typescript code. The easiest way to use [prettier](https://prettier.io/) is through the [prettier-vscode](https://marketplace.visualstudio.com/items?itemName=esbenp.prettier-vscode) VS Code extensions. You are also advised to use [eslint](https://eslint.org/) to lint your code.

## Provide translations

The local App translations (i.e. header and footer) are provided through [Crowdin](https://crowdin.com/project/github-emoji-picker). Please check out <https://crowdin.com/project/github-emoji-picker> if you want to add a card translation. The Emoji-Picker translations are handled by the [Emoji Mart package](https://github.com/missive/emoji-mart). If you want to translate parts of the picker, please open an issue at <https://github.com/missive/emoji-mart/issues>.

## License

By contributing, you agree that your contributions will be licensed under its MIT License.

## References

This document was adapted from the open-source contribution guidelines for [Facebook's Draft](https://github.com/facebook/draft-js/blob/a9316a723f9e918afde44dea68b5f9f39b7d9b00/CONTRIBUTING.md).
