rule Linux_Trojan_AcidRain : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "ACIDRAIN"
        description         = "Yara rule that detects AcidRain trojan."

        tc_detection_type   = "Trojan"
        tc_detection_name   = "AcidRain"
        tc_detection_factor = 5

    strings:

        $destroy_files_using_ioctls = {
            55 89 E5 57 BF ?? ?? ?? ?? 56 53 81 EC ?? ?? ?? ?? 89 7C 24 ?? 8B 45 ?? 89 04 24 E8
            ?? ?? ?? ?? 85 C0 89 C3 78 ?? 8D 85 ?? ?? ?? ?? 89 44 24 ?? 89 1C 24 E8 ?? ?? ?? ??
            8B 85 ?? ?? ?? ?? 25 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 ?? 81 C4 ?? ?? ?? ?? 5B 5E 5F 5D
            C3 8D 45 ?? BE ?? ?? ?? ?? 89 44 24 ?? 89 74 24 ?? 89 1C 24 E8 ?? ?? ?? ?? 8B 4D ??
            8B 55 ?? C7 45 ?? ?? ?? ?? ?? 85 C9 89 55 ?? 74 ?? 8D 75 ?? 8D B6 ?? ?? ?? ?? 8D BF
            ?? ?? ?? ?? B8 ?? ?? ?? ?? 89 74 24 ?? 89 44 24 ?? 89 1C 24 E8 ?? ?? ?? ?? B8 ?? ??
            ?? ?? 89 74 24 ?? 89 44 24 ?? 89 1C 24 E8 ?? ?? ?? ?? 8B 45 ?? 8B 55 ?? 01 D0 39 45
            ?? 89 45 ?? 77 ?? 81 FA ?? ?? ?? ?? BF ?? ?? ?? ?? 0F 86 ?? ?? ?? ?? 8B 45 ?? C7 45
            ?? ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 75 ?? EB ?? 31 C9 89 4C 24 ?? 8B 45 ?? 89
            1C 24 89 44 24 ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 7C 24 ?? 89 1C 24 89 44 24 ?? E8
            ?? ?? ?? ?? 8B 55 ?? 8B 45 ?? 01 D0 39 45 ?? 89 45 ?? 76 ?? B8 ?? ?? ?? ?? 89 74 24
            ?? 89 44 24 ?? 89 1C 24 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 89 74 24 ?? 89 44 24 ?? 89 1C
            24 E8 ?? ?? ?? ?? 80 7D ?? ?? 75 ?? A1 ?? ?? ?? ?? 89 7D ?? 89 45 ?? 8B 45 ?? 89 45
            ?? 8D 45 ?? 89 44 24 ?? B8 ?? ?? ?? ?? 89 44 24 ?? 89 1C 24 E8 ?? ?? ?? ?? 8B 55 ??
            8B 45 ?? 01 D0 39 45 ?? 89 45 ?? 77 ?? 8D 74 26 ?? 8D BC 27 ?? ?? ?? ?? 31 FF 89 1C
            24 E8 ?? ?? ?? ?? 31 C0 89 44 24 ?? 89 7C 24 ?? 89 1C 24 E8 ?? ?? ?? ?? 8B 75 ?? C7
            45 ?? ?? ?? ?? ?? 85 F6 74 ?? 8D 75 ?? 8D 76 ?? B9 ?? ?? ?? ?? 89 74 24 ?? 89 4C 24
            ?? 89 1C 24 E8 ?? ?? ?? ?? 8B 55 ?? 8B 45 ?? 01 D0 39 45 ?? 89 45 ?? 77 ?? 89 1C 24
            E8 ?? ?? ?? ?? 89 1C 24 E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? 5B 5E 5F 5D C3
        }

        $destroy_files_using_overwrite = {
            55 89 E5 83 EC ?? 89 5D ?? 8B 5D ?? 8D 45 ?? 89 75 ?? 89 7D ?? C7 45 ?? ?? ?? ?? ??
            C7 45 ?? ?? ?? ?? ?? 89 44 24 ?? 89 1C 24 E8 ?? ?? ?? ?? 85 C0 75 ?? 8B 5D ?? 8B 75
            ?? 8B 7D ?? 89 EC 5D C3
        }

        $redundant_reboot_attempts = {
            C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ??
            ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F
            84 ?? ?? ?? ?? 8D B6 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? E8 ?? ?? ?? ?? 85 C0 0F
            84 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 8D 76 ?? 0F 84 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 04
            24 E8 ?? ?? ?? ?? 31 D2 83 C4 ?? 89 D0 59 5B 5E 5F 5D 8D 61 ?? C3
        }

    condition:
        uint32(0) == 0x464C457F and
        (
            $destroy_files_using_ioctls
        ) and
        (
            $destroy_files_using_overwrite
        ) and
        (
            $redundant_reboot_attempts
        )
}