rule Win64_Ransomware_Wintenzz : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "WINTENZZ"
        description         = "Yara rule that detects Wintenzz ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Wintenzz"
        tc_detection_factor = 5

    strings:

        $find_files = {
            48 8D 75 ?? 41 B8 ?? ?? ?? ?? 48 89 F1 31 D2 E8 ?? ?? ?? ?? 48 89 F9 48 89 F2 E8 ??
            ?? ?? ?? 48 83 F8 ?? 0F 84 ?? ?? ?? ?? 48 89 C6 48 8B 85 ?? ?? ?? ?? 48 89 85 ?? ??
            ?? ?? 0F 28 85 ?? ?? ?? ?? 0F 29 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ??
            ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 0F 28 05 ?? ?? ?? ?? 0F 11 00 0F 28 85 ?? ?? ??
            ?? 0F 11 40 ?? 48 8B 8D ?? ?? ?? ?? 48 89 48 ?? 49 89 77 ?? 49 89 47 ?? 41 C7 47 ??
            ?? ?? ?? ?? 49 8D 4F ?? 48 8D 55 ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 40 B6 ?? 31 C0
            49 89 07 48 85 DB 75 ?? EB ?? E8 ?? ?? ?? ?? 48 C1 E0 ?? 49 89 47 ?? 49 C7 47 ?? ??
            ?? ?? ?? B8 ?? ?? ?? ?? 31 F6 49 89 07 48 85 DB 74 ?? 48 01 DB 74 ?? 41 B8 ?? ?? ??
            ?? 48 89 F9 48 89 DA E8 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 85 D2 74 ?? 41 B8 ?? ??
            ?? ?? 4C 89 F1 E8 ?? ?? ?? ?? 40 84 F6 75 ?? 48 8B 8D ?? ?? ?? ?? 48 85 C9 74 ?? 48
            8B 95 ?? ?? ?? ?? 48 85 D2 74 ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 89 F8 48 81 C4
            ?? ?? ?? ?? 5B 5F 5E 41 5E 41 5F 5D C3 BA
        }

        $encrypt_files_p1 = {
            4C 89 75 ?? 48 8D 05 ?? ?? ?? ?? 48 89 45 ?? 48 8D 05 ?? ?? ?? ?? 48 89 45 ?? 48 8D
            05 ?? ?? ?? ?? 48 89 45 ?? 48 8D 05 ?? ?? ?? ?? 48 89 45 ?? 48 C7 45 ?? ?? ?? ?? ??
            48 C7 45 ?? ?? ?? ?? ?? 48 89 7D ?? 48 C7 45 ?? ?? ?? ?? ?? 48 8D 4D ?? 48 8D 55 ??
            E8 ?? ?? ?? ?? 0F 10 45 ?? 0F 29 45 ?? 48 8B 45 ?? 48 89 45 ?? 48 8D 4D ?? 48 8D 55
            ?? E8 ?? ?? ?? ?? 48 85 DB 74 ?? BA ?? ?? ?? ?? 48 89 D9 E8 ?? ?? ?? ?? 48 85 C0 75
            ?? BA ?? ?? ?? ?? 48 89 D9 E8
        }

        $encrypt_files_p2 = {
            86 97 ?? ?? ?? ?? C0 74 3C ?? ?? C1 E8 ?? 28 03 00 48 ?? C0 74 2F ?? ?? FA 03 75 ??
            48 8D 0D ?? ?? ?? ?? 48 39 C8 0F 84 ?? ?? ?? ?? 0F B7 08 81 F1 ?? ?? ?? ?? 0F B6 40
            ?? 83 F0 ?? 66 09 C8 0F 84 ?? ?? ?? ?? 48 8B 4D ?? 48 8B 55 ?? E8 ?? ?? ?? ?? 48 85
            C0 74 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 85 C0 74 ?? 48 83 FA ?? 75 ?? 48 8D 0D ?? ?? ??
            ?? 48 39 C8 0F 84 ?? ?? ?? ?? 81 38 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 48 8B 4D ?? 48 8B
            55 ?? E8 ?? ?? ?? ?? 48 85 C0 74 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 85 C0 74 ?? 48 83 FA
            ?? 75 ?? 48 8D 0D ?? ?? ?? ?? 48 39 C8 0F 84 ?? ?? ?? ?? 0F B7 08 81 F1 ?? ?? ?? ??
            0F B6 40 ?? 83 F0 ?? 66 09 C8 0F 84 ?? ?? ?? ?? 48 8B 4D ?? 48 8B 55 ?? E8 ?? ?? ??
            ?? 48 85 C0 74 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 85 C0 74 ?? 48 83 FA ?? 75 ?? 48 8D 0D
            ?? ?? ?? ?? 48 39 C8 0F 84 ?? ?? ?? ?? 0F B7 08 81 F1 ?? ?? ?? ?? 0F B6 40 ?? 83 F0
            ?? 66 09 C8 0F 84 ?? ?? ?? ?? 48 8B 4D
        }

        $drop_ransom_note = {
            8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 85 D2 74 ?? 48 8B 8D ?? ??
            ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 85 D2 74 ?? 48 8B 8D
            ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 85 D2 74 ?? 48
            8B 8D ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 85 D2 74
            ?? 48 8B 8D ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 85
            D2 74 ?? 48 8B 8D ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ??
            48 85 D2 74 ?? 48 8B 8D ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 95 ?? ??
            ?? ?? 48 85 D2 74 ?? 48 8B 8D ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 40 84 F6
            0F 85 ?? ?? ?? ?? 48 8B 55 ?? 48 85 D2 74 ?? 41 B8 ?? ?? ?? ?? 48 8B 8D ?? ?? ?? ??
            E8 ?? ?? ?? ?? 48 8B 55 ?? 48 85 D2 74 ?? 41 B8 ?? ?? ?? ?? 48 8B 8D ?? ?? ?? ?? E8
            ?? ?? ?? ?? 48 8B 55
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_*)
        ) and
        (
            $drop_ransom_note
        )
}