rule Win64_Ransomware_Rook : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "ROOK"
        description         = "Yara rule that detects Rook ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Rook"
        tc_detection_factor = 5

    strings:

        $find_files = {
            48 2B D6 48 8D 4C 24 ?? 48 FF C2 41 B8 ?? ?? ?? ?? F6 D8 4D 1B FF 4C 23 FA 33 D2 E8
            ?? ?? ?? ?? 45 33 C9 89 7C 24 ?? 4C 8D 44 24 ?? 48 89 7C 24 ?? 33 D2 48 8B CE FF 15
            ?? ?? ?? ?? 48 8B D8 48 83 F8 ?? 75 ?? 4D 8B CE 45 33 C0 33 D2 48 8B CE E8 ?? ?? ??
            ?? 8B F8 48 83 FB ?? 74 ?? 48 8B CB FF 15 ?? ?? ?? ?? 8B C7 48 8B 8C 24 ?? ?? ?? ??
            48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? 41 5F 41 5E 5F
            5E 5D C3 49 8B 6E ?? 49 2B 2E 48 C1 FD ?? 80 7C 24 ?? ?? 75 ?? 8A 44 24 ?? 84 C0 74
            ?? 3C ?? 75 ?? 40 38 7C 24 ?? 74 ?? 4D 8B CE 48 8D 4C 24 ?? 4D 8B C7 48 8B D6 E8 ??
            ?? ?? ?? 85 C0 75 ?? 48 8D 54 24 ?? 48 8B CB FF 15 ?? ?? ?? ?? 85 C0 75 ?? 49 8B 06
            49 8B 56 ?? 48 2B D0 48 C1 FA ?? 48 3B EA 0F 84 ?? ?? ?? ?? 48 2B D5 48 8D 0C E8 4C
            8D 0D ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9
        }

        $encrypt_files_p1 = {
            40 55 53 56 48 8D AC 24 ?? ?? ?? ?? 48 81 EC ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 0F
            B6 05 ?? ?? ?? ?? F2 0F 11 44 24 ?? 88 44 24 ?? E8 ?? ?? ?? ?? 33 D2 48 8D 0D ?? ??
            ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 CE ?? 48 8D 4C 24 ?? 89 35 ?? ?? ?? ??
            FF 15 ?? ?? ?? ?? 48 63 C8 4C 8D 4C 24 ?? 48 89 4C 24 ?? E8 ?? ?? ?? ?? 48 8D 4C 24
            ?? FF 15 ?? ?? ?? ?? 48 63 C8 4C 8D 4C 24 ?? 48 89 4C 24 ?? E8 ?? ?? ?? ?? 0F 57 C0
            0F 57 C9 F3 0F 7F 05 ?? ?? ?? ?? F3 0F 7F 0D ?? ?? ?? ?? F3 0F 7F 05 ?? ?? ?? ?? E8
            ?? ?? ?? ?? 48 85 C0 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 0F 44 0D ?? ?? ??
            ?? 48 89 0D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF C0 48 8D 15 ?? ??
            ?? ?? 4C 63 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 8D 15 ??
            ?? ?? ?? 48 89 05 ?? ?? ?? ?? 33 DB 48 8B 05 ?? ?? ?? ?? 45 33 C9 48 89 05 ?? ?? ??
            ?? 45 33 C0 48 8D 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 44 24 ?? 48 C7
        }

        $encrypt_files_p2 = {
            C1 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 44 24 ?? 48 89 5C 24 ?? C7 44 24 ?? ?? ??
            ?? ?? 89 5C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8B 8D ?? ?? ?? ?? 48
            8D 85 ?? ?? ?? ?? 4C 89 A4 24 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 44 24 ?? 4C 8D
            25 ?? ?? ?? ?? 4C 89 AC 24 ?? ?? ?? ?? 45 33 C9 45 33 C0 4C 89 64 24 ?? 4C 89 BC 24
            ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 4C 8D 2D ?? ?? ?? ?? 83
            F8 ?? 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 54 24 ?? 48 89 5C 24 ??
            E8 ?? ?? ?? ?? 85 C0 78 ?? 4C 63 C8 4C 8D 85 ?? ?? ?? ?? 48 8D 44 24 ?? 4D 2B C1 48
            89 44 24 ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 4C 89 64 24 ?? E8 ?? ?? ?? ??
            49 8B CD FF 15 ?? ?? ?? ?? 44 8B C0 89 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? 41 F7 E8 C1 FA
            ?? 8B CA C1 E9 ?? 03 D1 69 CA ?? ?? ?? ?? 44 3B C1 74 ?? FF C2 4C 8D 3D ?? ?? ?? ??
            85 D2 0F 8E ?? ?? ?? ?? 48 89 BC 24 ?? ?? ?? ?? 49 8B DD 4C 89 B4 24 ?? ?? ?? ?? 49
        }

        $encrypt_files_p3 = {
            8B FF 44 8B F2 0F 1F 00 48 8B 0D ?? ?? ?? ?? 8B 91 ?? ?? ?? ?? 85 D2 74 ?? 83 FA ??
            75 ?? 48 89 7C 24 ?? 4C 8D 05 ?? ?? ?? ?? 48 89 5C 24 ?? 48 8D 15 ?? ?? ?? ?? 48 C7
            44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? EB ?? 48 89 7C 24 ?? 4C 8D 05 ?? ?? ?? ?? 48 89
            5C 24 ?? 48 8D 15 ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 81 C7 ??
            ?? ?? ?? 48 81 C3 ?? ?? ?? ?? 49 83 EE ?? 75 ?? 4C 8B B4 24 ?? ?? ?? ?? 33 DB 48 8B
            BC 24 ?? ?? ?? ?? 66 0F 1F 44 00 ?? 48 FF C6 41 80 3C 34 ?? 75 ?? 48 8B 8D ?? ?? ??
            ?? 48 8D 15 ?? ?? ?? ?? 89 74 24 ?? 41 B9 ?? ?? ?? ?? 45 33 C0 4C 89 64 24 ?? FF 15
            ?? ?? ?? ?? 48 8B 8D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? C7 44 24 ??
            ?? ?? ?? ?? 45 33 C0 4C 89 7C 24 ?? FF 15 ?? ?? ?? ?? EB ?? 48 8B 8D ?? ?? ?? ?? 48
            8D 85 ?? ?? ?? ?? 48 89 44 24 ?? 4C 8D 3D ?? ?? ?? ?? 45 33 C9 4C 89 7C 24 ?? 45 33
            C0 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 49 8B CC FF
            15 ?? ?? ?? ?? 49 8B D4 48 8D 0D ?? ?? ?? ?? FF C0 4C 63 C0 E8 ?? ?? ?? ?? 48 8B 05
            ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 05 ?? ??
            ?? ?? 4C 8B BC 24 ?? ?? ?? ?? 4C 8B A4 24 ?? ?? ?? ?? 48 85 C0 74 ?? 48 8B 0D ?? ??
            ?? ?? FF 50 ?? 48 8B 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 33 D2 44 8D 42 ?? FF D0 48
            8B 8D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 48 63 85 ?? ?? ?? ?? 48 3D ??
            ?? ?? ?? 73 ?? 0F 1F 00 48 63 85 ?? ?? ?? ?? 42 C6 04 28 ?? FF 85 ?? ?? ?? ?? 48 63
            85 ?? ?? ?? ?? 48 3D ?? ?? ?? ?? 72 ?? 4C 8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ??
            5E 5B 5D C3
        }

        $enum_procs = {
            40 56 48 81 EC ?? ?? ?? ?? 33 D2 8D 4A ?? FF 15 ?? ?? ?? ?? 48 8D 54 24 ?? C7 44 24
            ?? ?? ?? ?? ?? 48 8B C8 48 8B F0 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 48 89 9C
            24 ?? ?? ?? ?? 48 89 AC 24 ?? ?? ?? ?? 48 8D 2D ?? ?? ?? ?? 48 89 BC 24 ?? ?? ?? ??
            0F 1F 40 ?? 0F 1F 84 00 ?? ?? ?? ?? 33 DB 48 8B FD 66 66 66 0F 1F 84 00 ?? ?? 00 00
            48 8B 0F 48 8D 54 24 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? FF C3 48 83 C7 ?? 83 FB ?? 72
            ?? EB ?? 44 8B 44 24 ?? 33 D2 8D 4A ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 ?? BA
            ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B CB FF 15 ?? ?? ?? ?? 48 8D 54 24 ?? 48
            8B CE FF 15 ?? ?? ?? ?? 85 C0 75 ?? 48 8B BC 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ?? ??
            48 8B 9C 24 ?? ?? ?? ?? 48 8B CE FF 15 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? 5E C3
        }

        $enum_shares = {
            48 83 EC ?? 33 D2 C7 44 24 ?? ?? ?? ?? ?? 48 8D 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 4C
            8B C9 48 89 44 24 ?? 8D 4A ?? 44 8D 42 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ??
            48 89 5C 24 ?? 8B 5C 24 ?? 48 89 7C 24 ?? 66 66 0F 1F 84 00 ?? ?? 00 00 48 8B 0D ??
            ?? ?? ?? 4C 8D 43 ?? BA ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 ?? 48 8B
            4C 24 ?? 4C 8D 4C 24 ?? 4C 8B C0 48 8D 54 24 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 66 0F
            1F 44 00 ?? 33 DB 39 5C 24 ?? 76 ?? 0F 1F 84 00 ?? ?? ?? ?? 48 8D 0C 5B 48 C1 E1 ??
            48 03 CF F6 41 ?? ?? 74 ?? E8 ?? ?? ?? ?? EB ?? 48 8B 49 ?? E8 ?? ?? ?? ?? FF C3 3B
            5C 24 ?? 72 ?? 48 8B 4C 24 ?? 4C 8D 4C 24 ?? 4C 8B C7 48 8D 54 24 ?? FF 15 ?? ?? ??
            ?? 85 C0 74 ?? 48 8B 0D ?? ?? ?? ?? 4C 8B C7 33 D2 FF 15 ?? ?? ?? ?? 48 8B 4C 24 ??
            FF 15 ?? ?? ?? ?? 48 8B 7C 24 ?? 48 8B 5C 24 ?? 48 83 C4 ?? C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $enum_shares
        ) and
        (
            $enum_procs
        ) and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        )
}