rule Win64_Ransomware_Cactus : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "CACTUS"
        description         = "Yara rule that detects Cactus ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Cactus"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            55 41 57 41 56 41 55 41 54 56 53 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 29 C4 48 8D AC 24
            ?? ?? ?? ?? 48 89 8D ?? ?? ?? ?? 48 89 95 ?? ?? ?? ?? 4C 89 85 ?? ?? ?? ?? C7 85 ??
            ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8
            ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 48 C7 85 ?? ?? ?? ??
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 C1 E8 ??
            ?? ?? ?? 48 98 48 89 C1 E8 ?? ?? ?? ?? 48 89 45 ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48
            89 85 ?? ?? ?? ?? 48 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C1 4C 8D 4D
            ?? 4C 8D 45 ?? 48 8B 85 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48
            89 54 24 ?? 48 8B 95 ?? ?? ?? ?? 48 89 54 24 ?? 48 89 CA 48 89 C1 E8 ?? ?? ?? ?? 48
            8D 45 ?? 48 8B 95 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45
            ?? 48 8B 95 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48
            89 C1 E8 ?? ?? ?? ?? 48 89 C3 48 8B 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 DA
            48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA
            ?? ?? ?? ?? 89 C1 E8 ?? ?? ?? ?? 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 C2
            48 8D 85 ?? ?? ?? ?? 41 89 D8 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 41 B8 ??
            ?? ?? ?? BA ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 8B 45 ?? 4C 63 C0 48 8B 45 ?? 48 8D
        }

        $encrypt_files_p2 = {
            95 ?? ?? ?? ?? 48 8D 4A ?? 48 89 C2 E8 ?? ?? ?? ?? 4C 8B 85 ?? ?? ?? ?? 48 8B 85 ??
            ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 4A ?? 48 89 C2 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ??
            ?? 48 83 C0 ?? BA ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 8D 95
            ?? ?? ?? ?? 48 8D 4A ?? 41 B8 ?? ?? ?? ?? 48 89 C2 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ??
            ?? 41 B8 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ??
            ?? ?? 48 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 85 ??
            ?? ?? ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 29
            C2 48 89 95 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 48 98 48 39 85 ?? ?? ?? ?? 0F 8D ?? ?? ??
            ?? 48 89 E0 48 89 C6 48 8B 85 ?? ?? ?? ?? 48 8D 50 ?? 48 85 C0 48 0F 48 C2 48 C1 F8
            ?? 48 C1 E0 ?? 48 89 85 ?? ?? ?? ?? 48 8B 9D ?? ?? ?? ?? 48 8D 43 ?? 48 89 85 ?? ??
            ?? ?? 48 89 D8 49 89 C4 41 BD ?? ?? ?? ?? 48 89 D8 49 89 C6 41 BF ?? ?? ?? ?? 48 89
            D8 48 83 C0 ?? 48 C1 E8 ?? 48 C1 E0 ?? E8 ?? ?? ?? ?? 48 29 C4 48 8D 44 24 ?? 48 83
            C0 ?? 48 89 85 ?? ?? ?? ?? 48 8B 8D ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 8D 85 ?? ??
            ?? ?? 49 89 C8 48 89 C1 E8 ?? ?? ?? ?? 41 89 D9 4C 8B 85 ?? ?? ?? ?? 48 89 E9 48 8D
            55 ?? 48 8B 85 ?? ?? ?? ?? 44 89 4C 24 ?? 4D 89 C1 49 89 C8 48 89 C1 E8 ?? ?? ?? ??
            48 8B 85 ?? ?? ?? ?? F7 D8 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 48 63 D0 48 8D 85 ??
            ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 8B 45 ?? 4C 63 C0 48 8D 45 ?? 48
            8D 95 ?? ?? ?? ?? 48 8D 4A ?? 48 89 C2 E8 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 2B 85
            ?? ?? ?? ?? 48 89 C2 48 8D 85 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 89 C1 E8
        }

        $encrypt_files_p3 = {
            48 89 DA 48 8B 85 ?? ?? ?? ?? 48 01 D0 48 89 85 ?? ?? ?? ?? 90 48 89 F4 E9 ?? ?? ??
            ?? 8B 85 ?? ?? ?? ?? 48 63 C8 48 8D 95 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 49 89 C8 48
            89 C1 E8 ?? ?? ?? ?? 4C 8D 85 ?? ?? ?? ?? 48 89 E9 48 8D 55 ?? 48 8B 85 ?? ?? ?? ??
            C7 44 24 ?? ?? ?? ?? ?? 4D 89 C1 49 89 C8 48 89 C1 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ??
            F7 D8 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 48 63 D0 48 8D 85 ?? ?? ?? ?? 41 B8 ?? ??
            ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 8B 45 ?? 4C 63 C0 48 8D 45 ?? 48 8D 95 ?? ?? ?? ?? 48
            8D 4A ?? 48 89 C2 E8 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 05 ?? ?? ?? ?? 48 89 85 ??
            ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 05 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 83 F0 ?? 84
            C0 0F 85 ?? ?? ?? ?? 8B 45 ?? 48 98 48 8D 55 ?? 48 01 C2 48 89 E9 48 8B 85 ?? ?? ??
            ?? 49 89 C8 48 89 C1 E8 ?? ?? ?? ?? 8B 45 ?? 4C 63 C0 48 8D 45 ?? 48 8D 95 ?? ?? ??
            ?? 48 8D 4A ?? 48 89 C2 E8 ?? ?? ?? ?? 8B 45 ?? 4C 63 C0 48 8B 45 ?? 48 8D 95 ?? ??
            ?? ?? 48 8D 4A ?? 48 89 C2 E8 ?? ?? ?? ?? 4C 8B 85 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ??
            48 8D 95 ?? ?? ?? ?? 48 8D 4A ?? 48 89 C2 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 83
            C0 ?? BA ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 8D 95 ?? ?? ??
            ?? 48 8D 4A ?? 41 B8 ?? ?? ?? ?? 48 89 C2 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89
         }

        $encrypt_files_p4 = {
            C1 E8 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1
            E8 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 41 B8
            ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 89
            C3 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 84 DB 74 ?? 48 8D 45 ?? 48 89 C1 E8
            ?? ?? ?? ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ??
            48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 DA 48 89 C1 48 8B 05 ?? ?? ?? ??
            FF D0 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D
            85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 F4 48 89 C3 EB ?? 48 89 C3 48 8D
            85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ??
            ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 85 ??
            ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 D8 48 89 C1 E8 ?? ?? ?? ?? 90 48 8D A5 ?? ??
            ?? ?? 5B 5E 41 5C 41 5D 41 5E 41 5F 5D C3
        }

        $find_files_p1 = {
            55 56 53 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 29 C4 48 8D AC 24 ?? ?? ?? ?? 48 89 8D ??
            ?? ?? ?? 48 8D 45 ?? BB ?? ?? ?? ?? 48 89 C6 EB ?? 48 89 F1 E8 ?? ?? ?? ?? 48 83 EB
            ?? 48 83 C6 ?? 48 85 DB 79 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8
            ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 85 C0
            0F 95 C0 84 C0 74 ?? 48 8B 95 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ??
            ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ??
            ?? ?? ?? E9 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 8E ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ??
            84 C0 74 ?? 48 8D 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85
            ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 49 89 D0 48 8D 15 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ??
            ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ??
            ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ??
            E9 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 84 C0 74 ?? 48 8D 45 ?? 8B 95 ?? ?? ?? ?? 48 63
            D2 48 C1 E2 ?? 48 01 C2 48 8D 85 ?? ?? ?? ?? 49 89 D0 48 8D 15 ?? ?? ?? ?? 48 89 C1
            E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48
        }

        $find_files_p2 = {
            89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 8B 95 ?? ?? ?? ?? 48 63 D2 48 C1 E2 ?? 48 01 C2 48
            8D 85 ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D
            85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ??
            83 85 ?? ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 3B 85 ?? ?? ?? ?? 0F 8C ?? ?? ?? ?? C6 05 ??
            ?? ?? ?? ?? 48 8D 5D ?? 48 81 C3 ?? ?? ?? ?? 48 8D 45 ?? 48 39 C3 74 ?? 48 83 EB ??
            48 89 D9 E8 ?? ?? ?? ?? EB ?? 90 E9 ?? ?? ?? ?? 48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89
            C1 E8 ?? ?? ?? ?? 48 89 DE EB ?? 48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ??
            ?? EB ?? 48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 DE EB ?? 48 89
            C3 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 DE EB ?? 48 89 C3 48 8D 85 ??
            ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 DE EB ?? 48 89 C6 48 8D 5D ?? 48 81 C3 ?? ??
            ?? ?? 48 8D 45 ?? 48 39 C3 74 ?? 48 83 EB ?? 48 89 D9 E8 ?? ?? ?? ?? EB ?? 90 48 89
            F0 48 89 C1 E8 ?? ?? ?? ?? 90 48 81 C4 ?? ?? ?? ?? 5B 5E 5D C3
        }

        $check_processes = {
            55 53 48 83 EC ?? 48 8D 6C 24 ?? 48 89 4D ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ??
            ?? EB ?? 8B 45 ?? 48 98 48 8D 14 C5 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8B 1C 02 48
            8B 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 DA 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 48 85
            C0 0F 95 C0 84 C0 74 ?? B8 ?? ?? ?? ?? EB ?? 83 45 ?? ?? 8B 45 ?? 3B 45 ?? 7C ?? B8
            ?? ?? ?? ?? 48 83 C4 ?? 5B 5D C3
        }

        $kill_file_processes_p1 = {
            55 56 53 48 81 EC ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 48 89 8D ?? ?? ?? ?? C6 85 ??
            ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 66 0F EF C0
            0F 11 45 ?? F3 0F 6F 4D ?? 0F 11 8D ?? ?? ?? ?? F3 0F 6F 55 ?? 0F 11 95 ?? ?? ?? ??
            F3 0F 6F 5D ?? 0F 11 9D ?? ?? ?? ?? F3 0F 6F 65 ?? 0F 11 A5 ?? ?? ?? ?? 0F B7 45 ??
            66 89 85 ?? ?? 00 00 48 8D 95 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 49 89 D0 BA ?? ?? ??
            ?? 48 89 C1 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 84 C0 0F 84 ?? ?? ?? ?? 8B 85 ?? ?? ?? ??
            48 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? 41 B9
            ?? ?? ?? ?? 4C 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? 89 C1 E8 ?? ?? ?? ?? 85 C0 0F 94 C0
            84 C0 0F 84 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ??
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 4C
            8D 85 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? 48 89 4C 24 ?? 41 B9 ??
            ?? ?? ?? 89 C1 E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 81 BD ?? ?? ?? ?? ?? ?? ?? ?? 75 ??
            8B 85 ?? ?? ?? ?? 85 C0 75 ?? 8B 85 ?? ?? ?? ?? 89 C1 E8 ?? ?? ?? ?? BB ?? ?? ?? ??
            E9 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 C0 48 69 F0 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? FF
            D0 49 89 F0 BA ?? ?? ?? ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 48 89 85 ?? ?? ?? ??
            48 83 BD ?? ?? ?? ?? ?? 75 ?? 8B 85 ?? ?? ?? ?? 89 C1 E8 ?? ?? ?? ?? BB ?? ?? ?? ??
            E9 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 4C 8B 8D ?? ??
            ?? ?? 4C 8D 85 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? 48 89 4C 24
        }

        $kill_file_processes_p2 = {
            89 C1 E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 75 ?? 8B 85 ?? ?? ?? ??
            85 C0 75 ?? 48 8B 05 ?? ?? ?? ?? FF D0 48 8B 95 ?? ?? ?? ?? 49 89 D0 BA ?? ?? ?? ??
            48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 8B 85 ?? ?? ?? ?? 89 C1 E8 ?? ?? ?? ?? BB ?? ??
            ?? ?? E9 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? FF D0 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0
            89 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 48
            98 48 69 D0 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 01 D0 8B 00 39 85 ?? ?? ?? ?? 75 ??
            48 8B 05 ?? ?? ?? ?? FF D0 48 8B 95 ?? ?? ?? ?? 49 89 D0 BA ?? ?? ?? ?? 48 89 C1 48
            8B 05 ?? ?? ?? ?? FF D0 8B 85 ?? ?? ?? ?? 89 C1 E8 ?? ?? ?? ?? BB ?? ?? ?? ?? E9 ??
            ?? ?? ?? 8B 85 ?? ?? ?? ?? 48 98 48 69 D0 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 01 D0
            8B 00 41 89 C0 BA ?? ?? ?? ?? B9 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? FF D0 48 89 85 ??
            ?? ?? ?? 48 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 48 8D 55 ?? 48 8B 85 ?? ?? ?? ??
            41 B8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 C1 48 8B 05 ??
            ?? ?? ?? FF D0 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? 48
            8D 55 ?? 48 8D 45 ?? 49 89 C8 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1
            E8 ?? ?? ?? ?? 48 8D 45 ?? 49 C7 C0 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 C1 E8 ??
            ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 83 C0 ?? 48 63 C8 48 8D 45 ?? 48 8D 55
            ?? 49 C7 C1 ?? ?? ?? ?? 49 89 C8 48 89 C1 E8 ?? ?? ?? ?? 48 8D 55 ?? 48 8D 85 ?? ??
            ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $check_processes
        ) and
        (
            all of ($kill_file_processes_p*)
        )
}