rule Win64_Ransomware_AntiWar : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "ANTIWAR"
        description         = "Yara rule that detects AntiWar ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "AntiWar"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            49 8B D7 49 8B CD FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 49 8B CD FF 15 ?? ?? ?? ??
            48 8D 95 ?? ?? ?? ?? 49 8B CD FF 15 ?? ?? ?? ?? 4C 8B F0 48 89 44 24 ?? 48 83 F8 ??
            0F 84 ?? ?? ?? ?? 48 8D 35 ?? ?? ?? ?? 41 8B DC 48 8D 3D ?? ?? ?? ?? 66 90 48 8B 0F
            E8 ?? ?? ?? ?? 48 8B D0 48 8D 8D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ??
            ?? FF C3 48 83 C7 ?? 83 FB ?? 72 ?? 49 8B D7 49 8B CD FF 15 ?? ?? ?? ?? 48 8D 15 ??
            ?? ?? ?? 49 8B CD FF 15 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 49 8B CD FF 15 ?? ?? ?? ??
            F6 85 ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 66 0F 6F 35 ?? ?? 03 00 66 0F 6F 3D ?? ?? 03
            00 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 66 C7 85 ?? ?? 00 00 ?? ?? 8B 05 ?? ?? ?? ?? 4C 8D
            3C C5 ?? ?? ?? ?? 41 BC ?? ?? ?? ?? 65 48 8B 04 25 ?? ?? ?? ?? 4A 8B 0C 38 41 8B 04
            0C 39 05 ?? ?? ?? ?? 7E ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ??
            75 ?? C6 05 ?? ?? ?? ?? ?? 0F 11 35 ?? ?? ?? ?? 0F 11 3D ?? ?? ?? ?? 8B 85 ?? ?? ??
            ?? 89 05 ?? ?? ?? ?? 0F B7 85 ?? ?? ?? ?? 66 89 05 ?? ?? 04 00 48 8D 0D ?? ?? ?? ??
            E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? ?? 74 ?? 45 33
            C9 41 BA ?? ?? ?? ?? 4C 8D 35 ?? ?? ?? ?? 4D 2B D6 49 BB ?? ?? ?? ?? ?? ?? ?? ?? 66
            66 0F 1F 84 00 ?? ?? 00 00 4B 8D 14 31 41 0F B6 C9 80 E1 ?? C0 E1 ?? 49 8B C3 48 D3
        }

        $find_files_p2 = {
            E8 30 02 4C 8D 42 ?? 41 8D 0C 12 80 E1 ?? C0 E1 ?? 49 8B D3 48 D3 EA 41 30 10 49 83
            C1 ?? 49 83 F9 ?? 72 ?? 4C 8B 74 24 ?? C6 05 ?? ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8
            ?? ?? ?? ?? 48 8B D0 48 8D 8D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ??
            48 8D 8D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 E8 ?? 48 63 C8 78 ?? 0F 1F 40 ?? 66 83 BC
            4D ?? ?? 00 00 ?? 74 ?? FF C8 48 83 E9 ?? 79 ?? EB ?? B3 ?? 48 98 4C 8D B5 ?? ?? ??
            ?? 4D 8D 34 46 48 8D 3D ?? ?? ?? ?? BE ?? ?? ?? ?? 45 33 ED 48 8B 0F E8 ?? ?? ?? ??
            48 8B D0 49 8B CE FF 15 ?? ?? ?? ?? 0F B6 DB 85 C0 41 0F 44 DD 48 8D 7F ?? 48 83 EE
            ?? 75 ?? 4C 8B 6C 24 ?? 4C 8B 74 24 ?? 84 DB 0F 84 ?? ?? ?? ?? 48 8D 35 ?? ?? ?? ??
            45 33 C0 49 8B D5 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 33 FF
            90 89 BD ?? ?? ?? ?? 4C 8D 85 ?? ?? ?? ?? 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ??
            48 8B D8 48 85 C0 0F 84 ?? ?? ?? ?? 66 0F 1F 84 00 ?? ?? 00 00 83 3D ?? ?? ?? ?? ??
            0F 84 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 85 C9 0F 84 ?? ?? ?? ?? 83 79 ?? ?? 0F 8C
            ?? ?? ?? ?? 66 0F 6F 35 ?? ?? 03 00 66 0F 6F 3D ?? ?? 03 00 66 C7 85 ?? ?? 00 00 ??
            ?? 65 48 8B 04 25 ?? ?? ?? ?? 4A 8B 0C 38 41 8B 04 0C 39 05 ?? ?? ?? ?? 7E ?? 48 8D
            0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 75 ?? C6 05 ?? ?? ?? ?? ?? 0F 11
            35 ?? ?? ?? ?? 0F 11 3D ?? ?? ?? ?? 0F B7 85 ?? ?? ?? ?? 66 89 05 ?? ?? 04 00 48 8D
        }

        $find_files_p3 = {
            0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ??
            ?? 74 ?? 48 8B C7 41 BA ?? ?? ?? ?? 4C 8D 35 ?? ?? ?? ?? 4D 2B D6 49 BB ?? ?? ?? ??
            ?? ?? ?? ?? 90 4E 8D 0C 30 0F B6 C8 80 E1 ?? C0 E1 ?? 4D 8B C3 49 D3 E8 45 30 01 43
            8D 0C 11 80 E1 ?? C0 E1 ?? 49 8B D3 48 D3 EA 41 30 51 ?? 48 83 C0 ?? 48 83 F8 ?? 72
            ?? 4C 8B 74 24 ?? C6 05 ?? ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 44 24 ?? C7 44 24
            ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 44 24 ?? 48 89 7D ?? 48 C7 45 ?? ?? ?? ?? ?? BA
            ?? ?? ?? ?? 48 8D 4D ?? E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 45 ?? 48 8D 05 ??
            ?? ?? ?? 48 89 85 ?? ?? ?? ?? 89 BD ?? ?? ?? ?? 48 89 BD ?? ?? ?? ?? 48 C7 85 ?? ??
            ?? ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 48 89 BD ?? ?? ?? ?? 48 C7 85 ?? ?? ?? ?? ??
            ?? ?? ?? 66 89 BD ?? ?? 00 00 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 90 48 8D 15 ?? ?? ?? ??
            48 8D 4D ?? E8 ?? ?? ?? ?? 48 8B D6 48 85 DB 48 0F 45 D3 48 8D 4D ?? E8 ?? ?? ?? ??
            48 8B 3D ?? ?? ?? ?? 48 8B 5F ?? 48 3B 5F ?? 74 ?? 0F 1F 84 00 ?? ?? ?? ?? 48 8B 0B
        }

        $find_files_p4 = {
            48 8B 01 48 8D 54 24 ?? FF 50 ?? 48 83 C3 ?? 48 3B 5F ?? 75 ?? 48 8D 05 ?? ?? ?? ??
            48 89 44 24 ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 83 FA ??
            72 ?? 48 FF C2 48 8B 8D ?? ?? ?? ?? 48 8B C1 48 81 FA ?? ?? ?? ?? 72 ?? 48 83 C2 ??
            48 8B 49 ?? 48 2B C1 48 83 C0 ?? 48 83 F8 ?? 0F 87 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF
            48 89 BD ?? ?? ?? ?? 48 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 40 88 BD ?? ?? ?? ?? 48 8D 4D
            ?? E8 ?? ?? ?? ?? EB ?? 48 8B CB E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 4C 8D 85 ??
            ?? ?? ?? 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 85 ?? ?? ??
            ?? 45 33 C0 49 8B D5 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 45
            33 E4 4C 8B 7C 24 ?? 48 8D 95 ?? ?? ?? ?? 49 8B CE FF 15 ?? ?? ?? ?? 85 C0
        }

        $enum_shares = {
            48 83 EC ?? 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 ?? 33 D2 C7 44 24 ?? ?? ?? ??
            ?? 48 8D 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 4C 8B C9 48 89 44 24 ?? 8D 4A ?? 44 8D 42
            ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 4C 24 ?? 48 89 7C 24 ?? E8 ?? ?? ?? ??
            48 8B F8 48 85 C0 0F 84 ?? ?? ?? ?? 48 8B 4C 24 ?? 4C 8D 4C 24 ?? 4C 8B C0 48 8D 54
            24 ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 48 89 5C 24 ?? 33 DB 39 5C 24 ?? 76 ?? 0F 1F 84 00
            ?? ?? ?? ?? 48 8D 0C 5B 48 C1 E1 ?? 48 03 CF F6 41 ?? ?? 74 ?? E8 ?? ?? ?? ?? EB ??
            48 8B 49 ?? E8 ?? ?? ?? ?? FF C3 3B 5C 24 ?? 72 ?? 48 8B 4C 24 ?? 4C 8D 4C 24 ?? 4C
            8B C7 48 8D 54 24 ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 48 8B 5C 24 ?? 48 8B CF E8 ?? ?? ??
            ?? 48 8B 4C 24 ?? E8 ?? ?? ?? ?? 48 8B 7C 24 ?? 48 8B 4C 24 ?? 48 33 CC E8 ?? ?? ??
            ?? 48 83 C4 ?? C3
        }

        $encrypt_files_p1 = {
            48 89 74 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 45 33 C9 45 33 C0 BA
            ?? ?? ?? ?? 48 8B 8D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 4C 8B F0 48 8B 8D ?? ?? ?? ?? E8
            ?? ?? ?? ?? 49 83 FE ?? 0F 84 ?? ?? ?? ?? 41 BD ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 49
            8B CE FF 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8B F8 48 85 C0 0F 84 ?? ??
            ?? ?? 4C 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 80
            A5 ?? ?? ?? ?? ?? 0F B6 8D ?? ?? ?? ?? 80 E1 ?? 80 C9 ?? 88 8D ?? ?? ?? ?? 4C 8D 85
            ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8D 05 ?? ??
            ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8D 85 ?? ?? ?? ??
            BA ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? 45 8B C1 48 8D
            95 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 8D ??
            ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 85 ??
            ?? ?? ?? 33 D2 44 8D 42 ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 D2 44 8D 42 ?? 48
            8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 D2 44 8D 42 ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ??
            ?? 48 8B DE 45 33 C9 45 33 C0 48 8B D6 49 8B CE FF 15 ?? ?? ?? ?? 48 8B 8D ?? ?? ??
            ?? 48 81 F9 ?? ?? ?? ?? 0F 8E ?? ?? ?? ?? 48 B8 ?? ?? ?? ?? ?? ?? ?? ?? 48 F7 E9 48
        }

        $encrypt_files_p2 = {
            8B FA 48 C1 FF ?? 48 8B C7 48 C1 E8 ?? 48 03 F8 48 85 FF 0F 8E ?? ?? ?? ?? 48 89 74
            24 ?? 4C 8D 8D ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 49 8B D7 49 8B CE FF 15 ?? ?? ?? ?? 8B
            85 ?? ?? ?? ?? 89 44 24 ?? 4D 8B CF 4D 8B C7 48 8D 95 ?? ?? ?? ?? 33 C9 E8 ?? ?? ??
            ?? 45 33 C9 45 33 C0 48 8B D3 49 8B CE FF 15 ?? ?? ?? ?? 48 89 74 24 ?? 4C 8D 8D ??
            ?? ?? ?? 41 B8 ?? ?? ?? ?? 49 8B D7 49 8B CE FF 15 ?? ?? ?? ?? 48 81 C3 ?? ?? ?? ??
            45 33 C9 45 33 C0 48 8B D3 49 8B CE FF 15 ?? ?? ?? ?? 48 83 EF ?? 0F 85 ?? ?? ?? ??
            E9 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 83 78 ?? ?? 0F 8C ??
            ?? ?? ?? 41 8B C6 48 8D 1C C5 ?? ?? ?? ?? 65 48 8B 04 25 ?? ?? ?? ?? 48 8B 0C 18 8B
            04 0F 39 05 ?? ?? ?? ?? 7E ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ??
            ?? 75 ?? 66 C7 05 ?? ?? 05 00 ?? ?? C6 05 ?? ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ??
            ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? ?? 74 ?? 80 35 ?? ??
            ?? ?? ?? 80 35 ?? ?? ?? ?? ?? C6 05 ?? ?? ?? ?? ?? 65 48 8B 04 25 ?? ?? ?? ?? 48 8B
            0C 18 8B 04 0F 39 05 ?? ?? ?? ?? 7E ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 3D ??
            ?? ?? ?? ?? 75 ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ??
            48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 3D
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            (
                all of ($find_files_p*)
            ) and
            (
                all of ($encrypt_files_p*)
            ) and
            (
                $enum_shares
            )
        )
}