rule Win32_Ransomware_ZeroCrypt : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "ZEROCRYPT"
        description         = "Yara rule that detects ZeroCrypt ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "ZeroCrypt"
        tc_detection_factor = 5

    strings:

        $encrypt_file_1 = {
            55 8B EC 83 E4 ?? 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 81 EC ?? ?? ?? ?? A1 ?? 
            ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 53 56 57 A1 ?? ?? ?? ?? 33 C4 50 8D 84 24 ?? ?? 
            ?? ?? 64 A3 ?? ?? ?? ?? 8B F2 8B F9 68 ?? ?? ?? ?? 8B D7 8D 4C 24 ?? E8 ?? ?? ?? ?? 
            83 C4 ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 8B D0 56 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 83 C4 ?? C6 84 24 ?? ?? ?? ?? ?? 83 7C 24 ?? ?? 72 ?? FF 74 24 ?? E8 ?? ?? ?? ?? 
            83 C4 ?? 33 C0 C7 44 24 ?? ?? ?? ?? ?? 83 7E ?? ?? C7 44 24 ?? ?? ?? ?? ?? 66 89 44 
            24 ?? 72 ?? 8B 16 EB ?? 8B D6 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 84 24 ?? ?? ?? 
            ?? ?? 33 C0 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 
            24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 66 89 84 24 ?? ?? ?? ?? 
            C6 84 24 ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? 50 E8 ?? 
            ?? ?? ?? 83 C4 ?? 8B D6 8D 4C 24 ?? E8 ?? ?? ?? ?? 8B F0 C6 84 24 ?? ?? ?? ?? ?? 8B 
            D7 68 ?? ?? ?? ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 84 24 ?? ?? ?? ?? ?? 8B D0 
            56 8D 4C 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 84 24 ?? ?? ?? ?? ?? 8B D0 68 ?? ?? ?? ?? 
            8D 4C 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B F0 C6 84 24 ?? ?? ?? ?? ?? 8D 84 24 ?? ?? ?? 
            ?? 3B C6 74 ?? 83 BC 24 ?? ?? ?? ?? ?? 72 ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 
            C4 ?? 33 C0 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 56 8D 8C 24 ?? ?? ?? ?? C7 84 24 ?? ?? 
            ?? ?? ?? ?? ?? ?? 66 89 84 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? 83 
            7C 24 ?? ?? 72 ?? FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 C7 44 24 ?? ?? ?? ?? ?? 
            C7 44 24 ?? ?? ?? ?? ?? 66 89 44 24 ?? C6 84 24 ?? ?? ?? ?? ?? 83 7C 24 ?? ?? 72 ?? 
            FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? 
            ?? ?? 66 89 44 24 ?? C6 84 24 ?? ?? ?? ?? ?? 83 7C 24 ?? ?? 72 ?? FF 74 24 ?? E8 ?? 
            ?? ?? ?? 83 C4 ?? 33 C0 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 66 89 44 24
        }

        $encrypt_file_2 = {
            C6 84 24 ?? ?? ?? ?? ?? 83 7C 24 ?? ?? 72 ?? FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 
            33 C0 C7 44 24 ?? ?? ?? ?? ?? 83 BC 24 ?? ?? ?? ?? ?? 8D BC 24 ?? ?? ?? ?? 66 89 44 
            24 ?? 8D B4 24 ?? ?? ?? ?? 0F 43 BC 24 ?? ?? ?? ?? 8D 44 24 ?? 83 BC 24 ?? ?? ?? ?? 
            ?? 50 0F 43 B4 24 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 57 56 8B 00 FF D0 85 C0 68 ?? ?? ?? ?? 0F 95 C3 E8 ?? ?? ?? ?? 83 C4 ?? 85 
            C0 74 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 84 DB 0F 84 ?? ?? ?? ?? 83 BC 24 ?? ?? ?? ?? ?? 
            8D 44 24 ?? 8D B4 24 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 0F 43 B4 24 ?? ?? ?? ?? 50 
            E8 ?? ?? ?? ?? 56 8B 00 FF D0 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 6A 
            ?? 50 E8 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 
            84 24 ?? ?? ?? ?? ?? 8D 4C 24 ?? 6A ?? 83 EC ?? E8 ?? ?? ?? ?? 8D 44 24 ?? 50 8D 4C 
            24 ?? E8 ?? ?? ?? ?? 6A ?? 83 EC ?? 8D 8C 24 ?? ?? ?? ?? 8B 58 ?? 03 18 E8 ?? ?? ?? 
            ?? 6A ?? 8D 84 24 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? C7 44 24 ?? ?? ?? ?? 
            ?? 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 33 C9 8B 00 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 
            24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? 
            ?? ?? ?? 66 89 8C 24 ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 89 84 
            24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 84 24 ?? ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 51 8B F8 8D 4C 24 ?? 57 BE ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B 4C 24 ?? 8B 41 ?? F6 84 04 ?? ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? BA ?? ?? ?? ?? 
            03 C8 8B F3 33 C0 39 41 ?? 0F 44 C2 83 E0 ?? 89 41 ?? 85 41 ?? 74 ?? 6A ?? E8 ?? ?? 
            ?? ?? 56 57 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 83 EC ?? 8D 8C 24 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 6A ?? 56 57 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? F3 0F 6F 00 F3 0F 7F 07 E8 ?? ?? ?? ?? F3 0F 6F
        }

        $encrypt_file_3 = { 
            00 F3 0F 7F 47 ?? F3 0F 6F 40 ?? F3 0F 7F 47 ?? F3 0F 6F 40 ?? 8D 84 24 ?? ?? ?? ?? 
            50 51 F3 0F 7F 47 ?? 57 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 83 C4 
            ?? 85 F6 74 ?? 6A ?? 83 EC ?? 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? FF B4 24 ?? 
            ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            85 C0 75 ?? 8B 44 24 ?? 8D 4C 24 ?? 8B 40 ?? 03 C8 8B 41 ?? 83 C8 ?? 83 79 ?? ?? 75 
            ?? 83 C8 ?? 83 E0 ?? 89 41 ?? 85 41 ?? 74 ?? 6A ?? E8 ?? ?? ?? ?? 85 F6 74 ?? 56 E8 
            ?? ?? ?? ?? 83 C4 ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? B3 ?? C6 84 24 ?? ?? ?? ?? ?? 8D 8C 
            24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 84 24 ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 89 44 24 ?? C6 84 24 ?? 
            ?? ?? ?? ?? 50 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? EB ?? 32 DB 
            C6 84 24 ?? ?? ?? ?? ?? 83 BC 24 ?? ?? ?? ?? ?? 72 ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 83 C4 ?? 33 C0 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? 
            ?? 66 89 84 24 ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? 83 BC 24 ?? ?? ?? ?? ?? 72 ?? FF 
            B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 
            84 24 ?? ?? ?? ?? ?? ?? ?? ?? 66 89 84 24 ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? 
            ?? 83 BC 24 ?? ?? ?? ?? ?? 72 ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 
            C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 66 89 84 24 ?? ?? ?? ?? 8A C3 C7 84 24 ?? ?? ?? ?? 
            ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B 8C 24 ?? ?? ?? 
            ?? 33 CC E8 ?? ?? ?? ?? 8B E5 5D C3 
        }
        
    condition:
        uint16(0) == 0x5A4D and $encrypt_file_1 and $encrypt_file_2 and $encrypt_file_3
}