rule Win32_Ransomware_NB65 : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "NB65"
        description         = "Yara rule that detects NB65 ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "NB65"
        tc_detection_factor = 5

    strings:

        $encrypt_files = {
            E8 ?? ?? ?? ?? 89 45 ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ??
            C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ??
            C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ??
            C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ??
            C6 45 ?? ?? C6 45 ?? ?? C6 45 ?? ?? 8A 45 ?? 80 7D ?? ?? 75 ?? 33 C9 90 8A 44 0D ??
            0F B6 C0 83 E8 ?? 6B C0 ?? 99 F7 FB 8D 42 ?? 99 F7 FB 88 54 0D ?? 41 83 F9 ?? 72 ??
            8D 45 ?? 89 45 ?? A1 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 8D 50
            ?? 33 C9 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 81 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D0
            85 C0 75 ?? 33 F6 66 90 A1 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? 85 C0 75 ?? 68 ?? ?? ?? ??
            8D 50 ?? 33 C9 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 81 ?? ?? ?? ?? FF B4 B5 ?? ?? ??
            ?? 57 FF D0 85 C0 75 ?? 46 83 FE ?? 7C ?? 5F 5E B8 ?? ?? ?? ?? 5B 8B E5 5D C3
        }

        $find_files = {
            57 57 57 50 57 53 FF 15 ?? ?? ?? ?? 8B F0 8B 85 ?? ?? ?? ?? 83 FE ?? 75 ?? 50 57 57
            53 E8 ?? ?? ?? ?? 83 C4 ?? 8B F8 83 FE ?? 74 ?? 56 FF 15 ?? ?? ?? ?? 8B C7 8B 4D ??
            5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 8B 48 ?? 2B 08 C1 F9 ?? 89 8D ?? ?? ?? ??
            80 BD ?? ?? ?? ?? ?? 75 ?? 8A 8D ?? ?? ?? ?? 84 C9 74 ?? 80 F9 ?? 75 ?? 80 BD ?? ??
            ?? ?? ?? 74 ?? 50 FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 53 50 E8 ?? ?? ?? ?? 83 C4 ??
            85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 8B 85 ?? ?? ?? ?? 75 ??
            8B 10 8B 40 ?? 8B 8D ?? ?? ?? ?? 2B C2 C1 F8 ?? 3B C8 0F 84 ?? ?? ?? ?? 68 ?? ?? ??
            ?? 2B C1 6A ?? 50 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 ?? E9
        }

        $enum_procs = {
            33 C9 66 90 8A 84 0D ?? ?? ?? ?? 0F B6 C0 83 E8 ?? 8D 04 C0 99 F7 BD ?? ?? ?? ?? 8D
            42 ?? 99 F7 BD ?? ?? ?? ?? 88 94 0D ?? ?? ?? ?? 41 83 F9 ?? 72 ?? A1 ?? ?? ?? ?? 8B
            40 ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 33 D2 33 C9 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 41
            ?? 8D 8D ?? ?? ?? ?? 51 8D 8D ?? ?? ?? ?? 51 FF D0 85 C0 75 ?? 6A ?? E8 ?? ?? ?? ??
            83 C4 ?? 85 C0 74 ?? C7 00 ?? ?? ?? ?? 8D 50 ?? 8B 8D ?? ?? ?? ?? 89 08 C7 02 ?? ??
            ?? ?? 8B 4E ?? 89 48 ?? 8B 4E ?? 89 01 89 56 ?? 8D 85 ?? ?? ?? ?? 50 57 FF D3 85 C0
            0F 85 ?? ?? ?? ?? 5B A1 ?? ?? ?? ?? 8B 40 ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 33 D2 33 C9
            E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 41 ?? 57 FF D0 8B 4D ?? 5F 33 CD 5E E8 ?? ?? ??
            ?? 8B E5 5D C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            $enum_procs
        ) and
        (
            $encrypt_files
        )
}