rule Win32_Ransomware_MedusaLocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "MEDUSALOCKER"
        description         = "Yara rule that detects MedusaLocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "MedusaLocker"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 
            33 C5 89 45 ?? 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 89 8D ?? ?? ?? ?? 83 7D ?? ?? 74 ?? 83 
            7D ?? ?? 75 ?? 32 C0 E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 8B 45 ?? 50 8B 8D ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 81 BD ?? ?? ?? ?? ?? ?? ?? ?? 73 ?? 32 C0 E9 ?? 
            ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 33 C9 89 4D ?? 8D 55 ?? 52 8B 45 ?? 50 FF 15 ?? ?? ?? 
            ?? 85 C0 75 ?? 32 C0 E9 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 6A ?? 
            8B 8D ?? ?? ?? ?? 51 8D 4D ?? E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? 33 D2 89 55 ?? C7 45 ?? ?? ?? ?? ?? 33 C0 89 45 ?? 0F 57 
            C0 66 0F 13 85 ?? ?? ?? ?? EB ?? 8B 8D ?? ?? ?? ?? 81 C1 ?? ?? ?? ?? 8B 95 ?? ?? ?? 
            ?? 83 D2 ?? 89 8D ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 3B 45 ?? 0F 8F ?? 
            ?? ?? ?? 7C ?? 8B 8D ?? ?? ?? ?? 3B 4D ?? 0F 83 ?? ?? ?? ?? 0F 57 C0 66 0F 13 45 ?? 
            6A ?? 8D 55 ?? 52 8B 45 ?? 50 8B 4D ?? 51 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 
            C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8A 45 ?? E9 ?? ?? ?? ?? 
            6A ?? 8D 45 ?? 50 68 ?? ?? ?? ?? 6A ?? 8D 4D ?? E8 ?? ?? ?? ?? 50 8B 4D ?? 51 FF 15 
            ?? ?? ?? ?? 85 C0 75 ?? C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8
        }

        $encrypt_files_p2 = { 
            8A 45 ?? E9 ?? ?? ?? ?? 6A ?? 8D 55 ?? 52 8B 45 ?? 50 8B 4D ?? 51 8B 55 ?? 52 FF 15 
            ?? ?? ?? ?? 85 C0 75 ?? C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 
            8A 45 ?? E9 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? EB ?? 8B 85 ?? ?? ?? ?? 05 ?? 
            ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 3B 4D ?? 0F 83 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 8D 4D ?? E8 ?? ?? ?? ?? 03 85 ?? ?? ?? ?? 50 6A ?? 8D 4D ?? E8 ?? ?? ?? ?? 50 E8 
            ?? ?? ?? ?? 83 C4 ?? 8B 95 ?? ?? ?? ?? 52 68 ?? ?? ?? ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 
            83 C4 ?? 50 6A ?? 8B 4D ?? 51 8B 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 ?? 
            C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8A 45 ?? E9 ?? ?? ?? ?? 
            6A ?? 8D 45 ?? 50 8B 8D ?? ?? ?? ?? 51 8D 4D ?? E8 ?? ?? ?? ?? 50 8B 55 ?? 52 FF 15 
            ?? ?? ?? ?? 85 C0 75 ?? C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 
            8A 45 ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? 83 7D ?? ?? 75 ?? EB ?? E9 ?? ?? ?? ?? C7 85 
            ?? ?? ?? ?? ?? ?? ?? ?? 33 C0 89 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 89 4D ?? 8B 95 ?? 
            ?? ?? ?? 89 55 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 33 C0 89 85 ?? ?? ?? ?? 8B 8D ?? ?? 
            ?? ?? 89 4D ?? 8B 95 ?? ?? ?? ?? 89 55 ?? 6A ?? 8D 45 ?? 50 8B 4D ?? 51 8B 55 ?? 52
        }

        $encrypt_files_p3 = {  
            8B 45 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 8D 4D ?? 51 8B 8D ?? ?? 
            ?? ?? 83 C1 ?? E8 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 83 C1 ?? E8 ?? ?? ?? ?? 50 8B 55 
            ?? 52 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 83 C1 ?? E8 ?? ?? 
            ?? ?? 39 45 ?? 0F 85 ?? ?? ?? ?? 0F 57 C0 66 0F 13 45 ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? 89 45 ?? 8B 4D ?? 
            89 4D ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 89 45 ?? 8B 55 ?? 52 8B 
            8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 8B 8D ?? ?? ?? ?? 83 C1 ?? E8 ?? ?? ?? ?? 89 
            45 ?? 8B 45 ?? 89 45 ?? 6A ?? 8D 4D ?? 51 6A ?? 8D 55 ?? 52 8B 45 ?? 50 FF 15 ?? ?? 
            ?? ?? 85 C0 74 ?? 83 7D ?? ?? 75 ?? C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 
            ?? ?? ?? ?? 8A 45 ?? EB ?? C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? 
            ?? 8A 45 ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D 
            C2
        }

        $search_files_1 = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 4D ?? 8B 45 ?? 53 8B 5D 
            ?? 56 89 8D ?? ?? ?? ?? 8B 4D ?? 57 89 8D ?? ?? ?? ?? 8D 4D ?? 50 E8 ?? ?? ?? ?? 83 
            7D ?? ?? 74 ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 83 7D ?? ?? 8D 45 ?? 72 ?? 8B 
            45 ?? 33 F6 8D 8D ?? ?? ?? ?? 56 56 56 51 56 50 FF 15 ?? ?? ?? ?? 8B F8 8B 85 ?? ?? 
            ?? ?? 83 FF ?? 75 ?? C7 00 ?? ?? ?? ?? 33 C0 66 89 03 EB ?? 6A ?? 89 30 58 66 39 85 
            ?? ?? ?? ?? 75 ?? 66 39 B5 ?? ?? ?? ?? 74 ?? 66 39 85 ?? ?? ?? ?? 75 ?? 66 39 B5 ?? 
            ?? ?? ?? 75 ?? 8B 8D ?? ?? ?? ?? 51 57 53 E8 ?? ?? ?? ?? 83 C4 ?? 66 39 33 75 ?? 57 
            FF 15 ?? ?? ?? ?? EB ?? 8D 85 ?? ?? ?? ?? 50 53 E8 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 83 C4 ?? 89 01 8B F7 8D 4D ?? E8 ?? ?? ?? ?? 8B 4D ?? 
            8B C6 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 
        }

        $search_files_2 = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 53 8B 5D ?? 8D 85 ?? ?? ?? 
            ?? 56 8B 75 ?? 57 8B 7D ?? 50 57 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? 58 66 39 85 ?? 
            ?? ?? ?? 75 ?? 66 83 BD ?? ?? ?? ?? ?? 74 ?? 66 39 85 ?? ?? ?? ?? 75 ?? 66 83 BD ?? 
            ?? ?? ?? ?? 75 ?? 8D 85 ?? ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 6A ?? 85 C0 58 75 ?? 68 
            ?? ?? ?? ?? 56 C7 03 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 8B 4D ?? 5F 5E 33 CD 5B E8 ?? 
            ?? ?? ?? C9 C3 FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 03 8D 85 ?? ?? ?? ?? 50 56 E8 ?? 
            ?? ?? ?? 83 C4 ?? EB
        }

        $enum_resources = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 83 EC ?? A1 ?? ?? ?? ?? 33 C5 89 
            45 ?? 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 89 4D ?? 33 C0 89 45 ?? 66 89 45 ?? B9 ?? ?? ?? 
            ?? 6B D1 ?? 66 8B 45 ?? 66 89 44 15 ?? B9 ?? ?? ?? ?? C1 E1 ?? BA ?? ?? ?? ?? 66 89 
            54 0D ?? C7 45 ?? ?? ?? ?? ?? 6A ?? 8B 45 ?? 50 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? 51 
            6A ?? 8D 4D ?? E8 ?? ?? ?? ?? 50 8D 55 ?? 52 FF 15 ?? ?? ?? ?? 33 C0 66 89 45 ?? 8D 
            4D ?? 51 8D 55 ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8B 00 89 45 ?? 8D 4D ?? 51 8D 55 ?? 52 
            8D 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 08 51 8D 55 ?? 52 8D 45 ?? 50 E8 ?? ?? ?? ?? 
            83 C4 ?? 8B 08 51 8D 55 ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8B 00 89 45 ?? 8B 4D ?? 51 8B 
            55 ?? 52 8D 45 ?? 50 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 50 
            8B 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8B 45 ?? 8B 4D ?? 64 89 0D ?? ?? ?? 
            ?? 59 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2
        }

        $kill_processes = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 
            33 C5 89 45 ?? 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 89 8D ?? ?? ?? ?? 33 C0 88 85 ?? ?? ?? 
            ?? 8B 4D ?? E8 ?? ?? ?? ?? 0F B6 C8 85 C9 0F 85 ?? ?? ?? ?? 6A ?? 6A ?? FF 15 ?? ?? 
            ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 
            8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 85 ?? 
            ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 95 ?? 
            ?? ?? ?? 52 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8B 4D ?? 51 8D 4D 
            ?? E8 ?? ?? ?? ?? 88 85 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B6 95 ?? ?? 
            ?? ?? 85 D2 74 ?? 8B 85 ?? ?? ?? ?? 50 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? 
            ?? 83 BD ?? ?? ?? ?? ?? 74 ?? 6A ?? 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B 95 ?? 
            ?? ?? ?? 52 FF 15 ?? ?? ?? ?? B0 ?? EB ?? 8D 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 
            FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 32 
            C0 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2
        }

        $kill_processes_call = {
            68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 
            8B 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB ?? 8B 8D ?? ?? ?? ?? 83 C1 ?? 
            89 8D ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 3B 95 ?? ?? ?? ?? 74 ?? 8B 85 ?? ?? ?? ?? 50 8D 
            8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 50 8D 4D 
            ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB
        }

        $enum_resources_call = {
            68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 8D 4D 
            ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 4D ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 8D 4D 
            ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 8D 4D ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 4D 
            ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 8D 4D ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 8D 4D ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 
            4D ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 6A ?? 
            8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 6A ?? 8D 4D 
            ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B C8 E8 ?? ?? ?? ?? 6A ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? 51 8D 4D ?? E8 ?? 
            ?? ?? ?? 8D 55 ?? 89 95 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 85 ?? ?? ?? 
            ?? 8B 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB
        }

    condition:
        uint16(0) == 0x5A4D and 
        (
            $kill_processes_call 
        ) and 
        (
            $kill_processes
        ) and 
        (
            $enum_resources
        ) and 
        (
            all of ($search_files_*)
        ) and 
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $enum_resources_call 
        )
}