rule Win32_Ransomware_Makop : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "MAKOP"
        description         = "Yara rule that detects Makop ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Makop"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            8D 54 24 ?? 52 56 FF 15 ?? ?? ?? ?? 56 8B F8 6A ?? 89 7C 24 ?? FF 15 ?? ?? ?? ?? 50 
            FF 15 ?? ?? ?? ?? 83 FF ?? 75 ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 
            C4 ?? 5F 5E 5B 8B E5 5D C3 33 F6 89 74 24 ?? EB ?? 8D A4 24 ?? ?? ?? ?? 8D 64 24 ?? 
            66 8B 44 24 ?? 66 85 C0 0F 84 ?? ?? ?? ?? 66 3D ?? ?? 75 ?? 66 8B 44 24 ?? 66 85 C0 
            0F 84 ?? ?? ?? ?? 66 3D ?? ?? 75 ?? 66 83 7C 24 ?? ?? 0F 84 ?? ?? ?? ?? 8D 44 24 ?? 
            EB ?? 8D 9B ?? ?? ?? ?? 66 8B 08 83 C0 ?? 66 85 C9 75 ?? 8D 54 24 ?? 2B C2 D1 F8 83 
            E8 ?? 85 F6 8B F8 89 7C 24 ?? 75 ?? 8B 45 ?? 05 ?? ?? ?? ?? 03 C0 0F 84 ?? ?? ?? ?? 
            50 56 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 89 44 24 ?? 8B F0 0F 84 ?? ?? ?? 
            ?? F6 44 24 ?? ?? 0F 84 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 38 85 FF 74 ?? 8B 1F 8D 54 24 
            ?? 8B CA 2B D9 8D 49 ?? 0F B7 04 13 66 3D ?? ?? 72 ?? 66 3D ?? ?? 77 ?? 83 C0 ?? 0F 
            B7 C8 0F B7 02 66 3D ?? ?? 72 ?? 66 3D ?? ?? 77 ?? 83 C0 ?? 83 C2 ?? 66 85 C9 0F B7 
            C0 74 ?? 66 3B C8 74 ?? 0F B7 D0 0F B7 C1 2B C2 0F 84 ?? ?? ?? ?? 8B 7F ?? 85 FF 75 
            ?? 8B 7D ?? 8B 55 ?? 81 C7 ?? ?? ?? ?? 8B DE E8 ?? ?? ?? ?? 8B 4D ?? 8D 5C 4E ?? BA 
            ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 ?? 8D 1C 56 8D 54 24 ?? BF ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 8B 4D ?? 8D 54 08 ?? 8B 45 ?? 52 56 50 E8
        }

        $find_files_p2 = {
            83 C4 ?? E9 ?? ?? ?? ?? 8D 5C 24 ?? E8 ?? ?? ?? ?? 84 C0 0F 84 ?? ?? ?? ?? 8B 4D ?? 
            80 79 ?? ?? 0F 85 ?? ?? ?? ?? 8B 55 ?? 03 FA 81 FF ?? ?? ?? ?? 0F 82 ?? ?? ?? ?? 8B 
            15 ?? ?? ?? ?? C6 44 24 ?? ?? 8B 7D ?? 81 C7 ?? ?? ?? ?? 8B DE E8 ?? ?? ?? ?? 8A 44 
            24 ?? 84 C0 75 ?? 8B 55 ?? 83 C7 ?? 8D 5E ?? E8 ?? ?? ?? ?? 8A 44 24 ?? 8A C8 8B 54 
            24 ?? F6 D9 1B C9 83 E1 ?? F6 D8 8B F1 8D BE ?? ?? ?? ?? 1B C0 83 E0 ?? 83 C0 ?? 03 
            45 ?? 8D 04 42 89 44 24 ?? 8D 58 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5C 24 ?? 8D BE 
            ?? ?? ?? ?? 8D 44 24 ?? E8 ?? ?? ?? ?? 8B 54 24 ?? 85 D2 8B 74 24 ?? 8B 45 ?? 77 ?? 
            3B 70 ?? 77 ?? B1 ?? EB ?? 8B 55 ?? C6 44 24 ?? ?? E9 ?? ?? ?? ?? 32 C9 88 48 ?? 8B 
            4C 24 ?? F6 C1 ?? 74 ?? C6 40 ?? ?? 89 48 ?? EB ?? C6 40 ?? ?? 50 89 50 ?? 89 70 ?? 
            8B 44 24 ?? 50 E8 ?? ?? ?? ?? 8B 74 24 ?? 83 C4 ?? A1 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? 
            50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 54 24 ?? 8D 4C 24 ?? 51 52 FF 15 ?? ?? ?? ?? 85 
            C0 0F 85 ?? ?? ?? ?? EB ?? C7 44 24 ?? ?? ?? ?? ?? 8B 74 24 ?? EB ?? 56 6A ?? FF 15 
            ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 44 24 ?? 50 FF 15 ?? ?? ?? ?? 56 6A ?? FF 15 ?? 
            ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 
        }

        $encrypt_files = {
            8B 50 ?? 8B 00 83 EC ?? 55 8B 2D ?? ?? ?? ?? 56 57 6A ?? 8B F9 8D 4C 24 ?? 51 52 50 
            53 FF D5 85 C0 0F 84 ?? ?? ?? ?? 8B 57 ?? 8B 47 ?? 33 F6 56 8D 4C 24 ?? 51 52 50 53 
            FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 44 24 ?? 85 C0 75 ?? B0 ?? 5F 5E 5D 83 
            C4 ?? C3 3B 47 ?? 73 ?? 8B C8 83 E1 ?? 74 ?? BE ?? ?? ?? ?? 2B F1 8B 4F ?? 56 03 C8 
            6A ?? 51 E8 ?? ?? ?? ?? 8B 44 24 ?? 83 C4 ?? 8B 4F ?? 03 C6 50 8D 54 24 ?? 52 51 6A 
            ?? 6A ?? 89 44 24 ?? 8B 44 24 ?? 6A ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 
            8B 4C 24 ?? 8B 54 24 ?? 6A ?? 6A ?? 51 52 53 FF D5 85 C0 74 ?? 8B 4C 24 ?? 8B 57 ?? 
            8B 3D ?? ?? ?? ?? 6A ?? 8D 44 24 ?? 50 03 CE 51 52 53 FF D7 85 C0 74 ?? 8B 44 24 ?? 
            8D 0C 30 8B 44 24 ?? 3B C1 72 ?? 01 44 24 ?? 8B 44 24 ?? 8B 50 ?? 8B 00 83 54 24 ?? 
            ?? 6A ?? 6A ?? 52 50 53 FF D5 85 C0 74 ?? 6A ?? 8D 4C 24 ?? 51 6A ?? 8D 54 24 ?? 52 
            53 FF D7 85 C0 74 ?? 83 7C 24 ?? ?? 0F 83 ?? ?? ?? ?? 5F 5E 32 C0 5D 83 C4 ?? C3 
        }

        $enum_network_resources = {
            55 8B EC 83 E4 ?? 83 EC ?? 53 56 57 68 ?? ?? ?? ?? 6A ?? C7 44 24 ?? ?? ?? ?? ?? C7 
            44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 
            8B F0 85 F6 89 74 24 ?? 0F 84 ?? ?? ?? ?? 8B 4D ?? 8B 7D ?? 8D 44 24 ?? 50 51 6A ?? 
            6A ?? 57 E8 ?? ?? ?? ?? 85 C0 74 ?? 57 50 E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 8B 
            7D ?? 68 ?? ?? ?? ?? 6A ?? 56 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8B 4C 24 ?? 83 C4 ?? 8D 54 24 ?? 52 56 8D 44 24 ?? 50 51 E8 ?? ?? ?? ?? 85 
            C0 0F 85 ?? ?? ?? ?? 8B 45 ?? 85 C0 75 ?? 8B 54 24 ?? 8B 45 ?? 52 50 EB ?? 8B 4C 24 
            ?? 8B 50 ?? 51 52 E8 ?? ?? ?? ?? 33 DB 83 C4 ?? 39 5C 24 ?? 76 ?? 83 C6 ?? 8D 49 ?? 
            8B 46 ?? 85 C0 8B C8 75 ?? B9 ?? ?? ?? ?? 8B 46 ?? 85 C0 75 ?? B8 ?? ?? ?? ?? 51 8B 
            0E 51 50 E8 ?? ?? ?? ?? 8B 46 ?? 83 C4 ?? A8 ?? 74 ?? 8B 56 ?? 85 D2 74 ?? 85 FF 7E 
            ?? 8B 45 ?? 85 C0 74 ?? 8B 40 ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 8B 55 ?? 8B 4D ?? 52 83 
            EF ?? 57 8D 46 ?? 50 51 E8 ?? ?? ?? ?? 83 C4 ?? EB ?? F6 06 ?? 74 ?? 50 E8 ?? ?? ?? 
            ?? 8B 56 ?? 8B 45 ?? 83 C4 ?? 52 50 E8 ?? ?? ?? ?? 83 C3 ?? 83 C6 ?? 3B 5C 24 ?? 0F 
            82 ?? ?? ?? ?? 8B 74 24 ?? E9 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 ?? 50 E8 ?? ?? ?? ?? 83 
            C4 ?? 8B 44 24 ?? 85 C0 74 ?? 50 E8 ?? ?? ?? ?? 56 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15 
            ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $enum_network_resources
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            $encrypt_files
        )
}