rule Win32_Ransomware_KawaiiLocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "KAWAIILOCKER"
        description         = "Yara rule that detects KawaiiLocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "KawaiiLocker"
        tc_detection_factor = 5

    strings:

        $search_files = {
            55 8B EC 51 B9 ?? ?? ?? ?? 6A ?? 6A ?? 49 75 ?? 51 87 4D ?? 53 56 57 88 4D ?? 89 55 
            ?? 89 45 ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 15 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 ?? E8 ?? 
            ?? ?? ?? 8B 55 ?? 80 7C 02 ?? ?? 75 ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B D0 4A 8D 45 ?? E8 
            ?? ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ?? FF 75 ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 
            85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B D0 83 CA ?? 3B D0 75 ?? 80 7D ?? ?? 0F 85 ?? ?? 
            ?? ?? 8B 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B 85 ?? ?? 
            ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ?? FF B5 
            ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8A 4D 
            ?? 8B 55 ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? BE ?? ?? ?? ?? BB ?? ?? ?? ?? FF 75 ?? 68 
            ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 
            ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 13 E8 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? FF 75 ?? 68 ?? 
            ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? 
            ?? ?? ?? 8D 95 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8D 
            95 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 85 C0 75 ?? FF 75 ?? 68 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 ?? 
            FF 75 ?? 68 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B 95 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 08 FF 51 ?? 83 C3 ?? 4E 0F 85 ?? ?? ?? ?? 
            E9 ?? ?? ?? ?? 8B BD ?? ?? ?? ?? 8B C7 83 C8 ?? 3B C7 75 ?? 80 7D ?? ?? 0F 85 ?? ?? 
            ?? ?? 8B 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B 85 ?? ?? 
            ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ?? FF B5 
            ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8A 4D 
            ?? 8B 55 ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? BE ?? ?? ?? ?? BB ?? ?? ?? ?? FF 75 ?? 68 
            ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 
            ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 13 E8 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? FF 75 ?? 68 ?? 
            ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? 
            ?? ?? ?? 8D 95 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8D 
            95 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 85 C0 75 ?? FF 75 ?? 68 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 ?? 
            FF 75 ?? 68 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B 95 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 08 FF 51 ?? 83 C3 ?? 4E 0F 85 ?? ?? ?? ?? 
            8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 ?? BA ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? C3 
        }

        $remote_connection = {
            55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? B2 
            ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 8D 55 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 
            45 ?? 50 8D 55 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 ?? 8D 45 ?? 59 E8 ?? ?? ?? ?? 
            8D 4D ?? BA ?? ?? ?? ?? 33 C0 E8 ?? ?? ?? ?? FF 75 ?? 8D 45 ?? E8 ?? ?? ?? ?? FF 75 
            ?? 8D 4D ?? BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 ?? FF 75 ?? 8D 45 ?? 
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D ?? BA ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 45 
            ?? 8B 50 ?? 8B 45 ?? 8B 08 FF 51 ?? 8D 55 ?? 8B 45 ?? 8B 08 FF 51 ?? 8B 45 ?? 8D 55 
            ?? E8 ?? ?? ?? ?? 8B 55 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? E8 ?? ?? 
            ?? ?? 8D 45 ?? E8 ?? ?? ?? ?? 8D 45 ?? E8 ?? ?? ?? ?? 8B C3 8B 55 ?? E8 ?? ?? ?? ?? 
            33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 
        }

        $encrypt_files = {
            55 8B EC 6A ?? 6A ?? 6A ?? 53 56 57 BB ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 
            64 89 20 B2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? B2 ?? A1 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 10 FF 52 
            ?? 8B F0 8B C3 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 
            ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 
            43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? 
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 
            ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? 
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 
            ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? 
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 
            ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? 
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 
            ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? 
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 
            ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? 
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 
            ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? 
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 
            ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? 
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 
            ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 83 ?? ?? ?? ?? BA ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8B DE 4B 85 DB 7C ?? 43 33 F6 8D 55 ?? 33 C0 E8 ?? ?? ?? ?? 8B 45 
            ?? 8D 55 ?? E8 ?? ?? ?? ?? 8D 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 ?? A1 ?? ?? 
            ?? ?? 8B 08 FF 51 ?? 8D 4D ?? 8B D6 A1 ?? ?? ?? ?? 8B 38 FF 57 ?? 8B 45 ?? B1 ?? BA 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 46 4B 75 ?? E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 6A ?? E8 ?? ?? ?? ?? 6A ?? E8
        }


    condition:
        uint16(0) == 0x5A4D and $search_files and $encrypt_files and $remote_connection
}