rule Win32_Ransomware_Kangaroo : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "KANGAROO"
        description         = "Yara rule that detects Kangaroo ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Kangaroo"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            83 EC ?? 53 55 8B 6C 24 ?? 56 57 33 FF 57 57 6A ?? 57 6A ?? 68 ?? ?? ?? ?? 33 DB 55 
            89 5C 24 ?? 89 7C 24 ?? 89 7C 24 ?? FF 15 ?? ?? ?? ?? 8B F0 83 FE ?? 0F 84 ?? ?? ?? 
            ?? 8D 44 24 ?? 50 8D 4C 24 ?? 51 8D 54 24 ?? 52 56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            6A ?? 68 ?? ?? ?? ?? 57 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 
            8B 54 24 ?? 8D 4C 24 ?? 51 57 57 68 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 85 
            ?? ?? ?? ?? 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 03 C0 50 8B 44 24 ?? 68 ?? ?? ?? ?? 
            50 FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 8B 54 24 ?? 8B 44 24 ?? 8D 4C 24 ?? 
            51 6A ?? 52 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 57 56 FF 
            15 ?? ?? ?? ?? 8B 54 24 ?? 57 8D 4C 24 ?? 51 57 57 6A ?? 57 52 89 44 24 ?? FF 15 ?? 
            ?? ?? ?? 8B 44 24 ?? 6A ?? 68 ?? ?? ?? ?? 50 57 8B 3D ?? ?? ?? ?? FF D7 8B 54 24
        }

        $encrypt_files_p2 = {
            6A ?? 8D 4C 24 ?? 51 52 8B D8 53 56 FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 8B 
            44 24 ?? 8B 54 24 ?? 50 8D 4C 24 ?? 51 53 6A ?? 6A ?? 6A ?? 52 FF 15 ?? ?? ?? ?? 83 
            F8 ?? 0F 85 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 
            8B 4C 24 ?? 6A ?? 8D 44 24 ?? 50 51 53 56 FF 15 ?? ?? ?? ?? 83 F8 ?? 75 ?? 8D 54 24 
            ?? 52 8D 44 24 ?? 50 8D 4C 24 ?? 51 56 FF 15 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 6A ?? 
            68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF D7 68 ?? ?? ?? ?? 55 8B F8 68 ?? ?? ?? ?? 57 
            FF 15 ?? ?? ?? ?? 83 C4 ?? 57 55 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 57 FF 15 ?? 
            ?? ?? ?? 8B C5 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 53 FF 15 
            ?? ?? ?? ?? 8B 54 24 ?? 52 FF 15 ?? ?? ?? ?? 8B 5C 24 ?? 33 FF 8B 44 24 ?? 50 FF 15 
            ?? ?? ?? ?? 89 7C 24 ?? 8B 4C 24 ?? 57 51 FF 15 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 5F 
            5E 5D 8B C3 5B 83 C4 ?? C3
        }

        $find_files = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 53 56 8B 75 ?? 57 56 FF 15 ?? ?? ?? ?? 8B 3D ?? 
            ?? ?? ?? 33 C9 83 F8 ?? 0F 94 C1 56 8D 94 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 89 4C 24 
            ?? FF D7 83 C4 ?? 8D 44 24 ?? 50 8D 8C 24 ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 44 24 
            ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? EB ?? EB ?? 8D A4 24 ?? ?? ?? ?? 90 
            8B 3D ?? ?? ?? ?? 83 7C 24 ?? ?? 75 ?? 8D 54 24 ?? 52 56 68 ?? ?? ?? ?? 8D 84 24 ?? 
            ?? ?? ?? 50 EB ?? 8D 4C 24 ?? 51 56 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 52 FF D7 83 
            C4 ?? F6 44 24 ?? ?? 74 ?? 8B 3D ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D7 85 
            C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4C 24 ?? 51 FF D7 85 C0 0F 84 ?? ?? ?? ?? 8D 
            94 24 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 33 FF 33 F6 EB ?? 8D 9B 
            ?? ?? ?? ?? 8B 86 ?? ?? ?? ?? 50 8D 8C 24 ?? ?? ?? ?? 51 FF D3 85 C0 74 ?? BF ?? ?? 
            ?? ?? 83 C6 ?? 83 FE ?? 72 ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 52 FF D3 85 C0 75 
            ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 FF D3 85 C0 74 ?? BF ?? ?? ?? ?? 8B 44 24 
            ?? A8 ?? 75 ?? A9 ?? ?? ?? ?? 75 ?? 85 FF 75 ?? 3D ?? ?? ?? ?? 74 ?? 68 ?? ?? ?? ?? 
            8D 8C 24 ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 
            C4 ?? 85 C0 75 ?? 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8D 8C 
            24 ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B 75 ?? 8B 44 24 ?? 8D 54 24 ?? 52 50 FF 15 ?? 
            ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 4C 24 ?? 51 FF 15 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D 
            C3
        }

        $enum_resources = {
            55 8B EC 83 E4 ?? 83 EC ?? 8B 4D ?? 53 56 57 8D 44 24 ?? 50 51 6A ?? 6A ?? 6A ?? C7 
            44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 33 C0 5F 5E 
            5B 8B E5 5D C2 ?? ?? 8B 54 24 ?? 52 6A ?? FF 15 ?? ?? ?? ?? 8B D8 85 DB 74 ?? 8B 4C 
            24 ?? 8B C3 85 C9 74 ?? 8D 64 24 ?? C6 00 ?? 40 83 E9 ?? 75 ?? 8B 54 24 ?? 8D 44 24 
            ?? 50 53 8D 4C 24 ?? 51 52 E8 ?? ?? ?? ?? 85 C0 75 ?? 33 FF 39 7C 24 ?? 76 ?? 8D 73 
            ?? 8D 49 ?? 83 7E ?? ?? 75 ?? 8B 06 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 4E ?? 83 E1 ?? 80 
            F9 ?? 75 ?? 8D 56 ?? 52 E8 ?? ?? ?? ?? 47 83 C6 ?? 3B 7C 24 ?? 72 ?? EB ?? 3D ?? ?? 
            ?? ?? 75 ?? 53 FF 15 ?? ?? ?? ?? 8B 44 24 ?? 50 E8 ?? ?? ?? ?? 5F 5E B8 ?? ?? ?? ?? 
            5B 8B E5 5D C2
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $enum_resources
        )
}