rule Win32_Ransomware_District : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "DISTRICT"
        description         = "Yara rule that detects District ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "District"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 53 56 57 83 EC ?? C7 44 24 ?? ?? ?? ?? ?? 8D 44 
            24 ?? 8B F1 8D 4D ?? 50 E8 ?? ?? ?? ?? 40 C7 44 24 ?? ?? ?? ?? ?? 6A ?? 33 C9 C7 44 
            24 ?? ?? ?? ?? ?? 50 8D 45 ?? 66 89 4C 24 ?? 50 8D 4C 24 ?? E8 ?? ?? ?? ?? 83 EC ?? 
            C7 44 24 ?? ?? ?? ?? ?? 8D 44 24 ?? 8D 4D ?? 50 E8 ?? ?? ?? ?? 40 C7 84 24 ?? ?? ?? 
            ?? ?? ?? ?? ?? 33 C9 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 50 51 8D 45 ?? 66 89 8C 24 ?? 
            ?? ?? ?? 50 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 EC ?? C7 44 24 ?? ?? ?? ?? ?? 8D 
            44 24 ?? 8D 4C 24 ?? 50 E8 ?? ?? ?? ?? 40 C7 44 24 ?? ?? ?? ?? ?? 6A ?? 33 C9 C7 44 
            24 ?? ?? ?? ?? ?? 50 8D 44 24 ?? 66 89 4C 24 ?? 50 8D 4C 24 ?? E8 ?? ?? ?? ?? 83 EC 
            ?? C7 44 24 ?? ?? ?? ?? ?? 8D 44 24 ?? 8D 4C 24 ?? 50 E8 ?? ?? ?? ?? 33 C9 C7 44 24 
            ?? ?? ?? ?? ?? 50 51 8D 44 24 ?? 66 89 4C 24 ?? 50 8D 4C 24 ?? C7 44 24 ?? ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 33 C0 C7 44 24 ?? ?? ?? ?? ?? 6A ?? 50 66 89 44 24 ?? 8D 4C 24 ?? 
            8D 45 ?? C7 44 24 ?? ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A ?? 6A ?? 56 8D 4C 24 ?? E8 ?? 
            ?? ?? ?? 83 7D ?? ?? 8D 45 ?? 6A ?? 0F 43 45 ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 
            ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF ?? 0F 84 ?? ?? ?? ?? 6A ?? 57 FF 15 ?? 
            ?? ?? ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 66 0F 6E C0 F3 0F E6 C0 C1 E8 ?? F2 0F 58 04 C5 
            ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 56 8B D8
        }
       
        $encrypt_files_p2 = {
            E8 ?? ?? ?? ?? 83 C4 ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 0F 1F 40 ?? 0F 1F 84 00 
            ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 6A ?? A3 ?? ?? ?? ?? 8D 44 24 ?? 50 56 
            53 57 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 
            FF 15 ?? ?? ?? ?? 56 FF 74 24 ?? 8B D3 E8 ?? ?? ?? ?? 8B 44 24 ?? 83 C4 ?? F7 D8 6A 
            ?? 6A ?? 50 57 FF 15 ?? ?? ?? ?? 6A ?? 8D 44 24 ?? 50 56 FF 74 24 ?? 57 FF 15 ?? ?? 
            ?? ?? 83 6C 24 ?? ?? 75 ?? 53 E8 ?? ?? ?? ?? FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 57 
            FF 15 ?? ?? ?? ?? 83 7C 24 ?? ?? 8D 4C 24 ?? 8D 45 ?? 0F 43 4C 24 ?? 83 7D ?? ?? 51 
            0F 43 45 ?? 50 FF 15 ?? ?? ?? ?? 8B 44 24 ?? 83 F8 ?? 72 ?? 40 8D 4C 24 ?? 50 FF 74 
            24 ?? E8 ?? ?? ?? ?? 33 C0 C7 44 24 ?? ?? ?? ?? ?? 66 89 44 24 ?? 8B 44 24 ?? C7 44 
            24 ?? ?? ?? ?? ?? 83 F8 ?? 72 ?? 40 8D 4C 24 ?? 50 FF 74 24 ?? E8 ?? ?? ?? ?? 33 C0 
            C7 44 24 ?? ?? ?? ?? ?? 66 89 44 24 ?? 8B 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 83 F8 ?? 
            72 ?? 40 8D 4C 24 ?? 50 FF 74 24 ?? E8 ?? ?? ?? ?? 33 C0 C7 44 24 ?? ?? ?? ?? ?? 66 
            89 44 24 ?? 8B 84 24 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 83 F8 ?? 72 ?? 40 8D 4C 24 
            ?? 50 FF 74 24 ?? E8 ?? ?? ?? ?? 33 C0 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 66 89 44 24 
            ?? 8B 44 24 ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 83 F8 ?? 72 ?? 40 8D 4C 24 ?? 50 FF 
            74 24 ?? E8 ?? ?? ?? ?? 33 C0 C7 44 24 ?? ?? ?? ?? ?? 66 89 44 24 ?? 89 44 24 ?? 8B 
            45 ?? 83 F8 ?? 72 ?? 8B 4D ?? 40 3D ?? ?? ?? ?? 77 ?? 03 C0 3D ?? ?? ?? ?? 72 ?? F6 
            C1 ?? 75 ?? 8B 41 ?? 3B C1 73 ?? 2B C8 83 F9 ?? 72 ?? 83 F9 ?? 77 ?? 8B C8 51 E8 ?? 
            ?? ?? ?? 83 C4 ?? 5F 5E 5B 8B E5 5D C2 
        }

        $find_files = {
            53 55 56 57 6A ?? 8B F1 E8 ?? ?? ?? ?? 83 C4 ?? 8D 9E ?? ?? ?? ?? 8B E8 53 68 ?? ?? 
            ?? ?? FF 15 ?? ?? ?? ?? 53 50 89 45 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8D BE ?? ?? ?? 
            ?? 0F 1F 80 ?? ?? ?? ?? F6 03 ?? 57 74 ?? 8B CE E8 ?? ?? ?? ?? 84 C0 75 ?? 57 E8 ?? 
            ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 50 8B CE E8 ?? ?? ?? ?? EB ?? E8 ?? ?? ?? ?? 84 C0 74 
            ?? 8B CE E8 ?? ?? ?? ?? 53 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 80 7C 24 ?? ?? 75 
            ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 55 E8 ?? ?? ?? ?? 83 C4 ?? 5F 5E 5D 
            5B C2 
        }

        $enum_resources_1_p1 = {
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 55 56 57 33 C0 C7 44 24 ?? ?? ?? ?? ?? 66 89 44 24 
            ?? 8B DA 8D 44 24 ?? 89 5C 24 ?? 50 51 6A ?? 6A ?? 6A ?? C7 44 24 ?? ?? ?? ?? ?? FF 
            15 ?? ?? ?? ?? 85 C0 74 ?? 3D ?? ?? ?? ?? 75 ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 
            50 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? BE ?? ?? 
            ?? ?? E9 ?? ?? ?? ?? 8D 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 50 8D 84 24 ?? ?? ?? ?? C7 
            44 24 ?? ?? ?? ?? ?? 50 8D 44 24 ?? 50 FF 74 24 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 3D 
            ?? ?? ?? ?? 75 ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8D 84 24 ?? 
            ?? ?? ?? 50 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? BE ?? ?? ?? ?? E9 ?? ?? ?? ?? 33 ED 89 
            6C 24 ?? 39 6C 24 ?? 0F 86 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 85 DB 0F 8E ?? ?? ?? ?? C1 
            E5 ?? 8B F3 89 6C 24 ?? 89 5C 24 ?? 0F 1F 84 00 ?? ?? ?? ?? 83 BC 2C ?? ?? ?? ?? ?? 
            0F 85 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 74 ?? 8B 84 2C ?? ?? ?? ?? 66 83 78 ?? ?? 8D 
            50 ?? 74 ?? 8D B4 24 ?? ?? ?? ?? 8D 48 ?? 8A 01 8D 52 ?? 88 06 8D 76 ?? 66 83 3A 
        }

        $enum_resources_1_p2 = {
            8D 49 ?? 75 ?? 8B 74 24 ?? 8D 84 24 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8D 44 24 ?? 50 
            6A ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF B4 2C ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 
            E8 ?? ?? ?? ?? 83 C4 ?? 8D 44 24 ?? 50 6A ?? 8D 84 24 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? 
            ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 44 24 ?? FF 70 ?? 8B 40 ?? 83 E0 ?? 50 8D 84 24 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 74 24 ?? 83 C4 ?? C6 44 24 ?? ?? 8B 56 ?? 
            F6 C2 ?? 74 ?? 8D 4C 24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 66 
            A1 ?? ?? ?? ?? 66 89 41 ?? F6 C2 ?? 74 ?? 8D 4C 24 ?? 49 0F 1F 44 00 ?? 8A 41 ?? 8D 
            49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 66 A1 ?? ?? ?? ?? 66 89 41 ?? A0 ?? ?? ?? ?? 
            88 41 ?? F6 C2 ?? 74 ?? 8D 4C 24 ?? 49 0F 1F 00 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? 
            ?? ?? ?? 89 01 A1 ?? ?? ?? ?? 89 41 ?? 66 A1 ?? ?? ?? ?? 66 89 41 ?? A0 ?? ?? ?? ?? 
            88 41 ?? F6 C2 ?? 74 ?? 8D 4C 24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 
            89 01 66 A1 ?? ?? ?? ?? 66 89 41 ?? F6 C2 ?? 74 ?? 8D 4C 24 ?? 49 66 0F 1F 44 00 ?? 
            8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 66 A1 ?? ?? ?? ?? 66 89 41 ?? F6
        }

        $enum_resources_1_p3 = {
            C2 ?? 74 ?? 8D 4C 24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 A1 ?? 
            ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? A0 ?? ?? ?? ?? 88 41 ?? F6 C2 ?? 74 ?? 8D 
            4C 24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 66 A1 ?? ?? ?? ?? 66 
            89 41 ?? 84 D2 79 ?? 8D 4C 24 ?? 49 0F 1F 40 ?? 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? 
            ?? ?? ?? 89 01 A1 ?? ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? 66 A1 ?? ?? ?? ?? 66 
            89 41 ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? 
            ?? ?? ?? 89 01 A1 ?? ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 
            ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 66 90 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? 
            ?? ?? ?? 89 01 A1 ?? ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? 66 A1 ?? ?? ?? ?? 66 
            89 41 ?? A0 ?? ?? ?? ?? 88 41 ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 8A 41 ?? 8D 
            49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 A1 ?? ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 
            ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 66 90 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? 
            ?? ?? ?? 89 01 A1 ?? ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? F7 C2 ?? ?? ?? ?? 74 
        }

        $enum_resources_2_p1 = { 
            8D 4C 24 ?? 49 66 90 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 A1 ?? ?? ??
            ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? 66 A1 ?? ?? ?? ?? 66 89 41 ?? F7 C2 ?? ?? ?? ??
            74 ?? 8D 4C 24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 A1 ?? ?? ??
            ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 8A 41 ??
            8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 66 A1 ?? ?? ?? ?? 66 89 41 ?? F7 C2 ?? ??
            ?? ?? 74 ?? 8D 4C 24 ?? 49 66 90 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01
            66 A1 ?? ?? ?? ?? 66 89 41 ?? A0 ?? ?? ?? ?? 88 41 ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 4C
            24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 66 A1 ?? ?? ?? ?? 66 89
            41 ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ??
            ?? ?? 89 01 66 A1 ?? ?? ?? ?? 66 89 41 ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 8A
            41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 66 A1 ?? ?? ?? ?? 66 89 41 ?? F7 C2
            ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01
            A1 ?? ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? A0 ?? ?? ?? ?? 88 41 ?? F7 C2 ?? ??
            ?? ?? 74 ?? 8D 4C 24 ?? 49 66 90 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 
        }
        
        $enum_resources_2_p2 = { 
            01 A1 ?? ?? ?? ?? 89 41 ?? 66 A1 ?? ?? ?? ?? 66 89 41 ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 
            4C 24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 66 A1 ?? ?? ?? ?? 66 
            89 41 ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? 
            ?? ?? ?? 89 01 66 A1 ?? ?? ?? ?? 66 89 41 ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 
            8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 01 66 A1 ?? ?? ?? ?? 66 89 41 ?? F7 
            C2 ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 
            01 A1 ?? ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? 85 D2 79 
            ?? 8D 4C 24 ?? 49 66 0F 1F 44 00 ?? 8A 41 ?? 8D 49 ?? 84 C0 75 ?? A1 ?? ?? ?? ?? 89 
            01 A1 ?? ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? A1 ?? ?? ?? ?? 89 41 ?? A0 ?? ?? 
            ?? ?? 88 41 ?? F7 C2 ?? ?? ?? ?? 74 ?? 8D 4C 24 ?? 49 66 90 8A 41 ?? 8D 49 ?? 84 C0 
            75 ?? A1 ?? ?? ?? ?? 89 01 66 A1 ?? ?? ?? ?? 66 89 41 ?? 8D 4C 24 ?? 8D 51 ?? 8A 01 
            41 84 C0 75 ?? 2B CA 56 88 44 0C ?? FF D7 8D 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 50 8D
        }

        $enum_resources_2_p3 = {
            84 24 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF 74 24 ?? FF D7 8B BC 2C ?? ?? ?? ?? 33 D2 
            8B CF 8D 71 ?? 8A 01 41 84 C0 75 ?? 2B CE 8D 43 ?? 03 C1 74 ?? 8B 6C 24 ?? 8B DF 8B 
            CB 42 8D 71 ?? 0F 1F 00 8A 01 41 84 C0 75 ?? 2B CE 8D 45 ?? 03 C1 3B D0 72 ?? 8B 6C 
            24 ?? 8B 5C 24 ?? 8B CF 33 D2 8D 71 ?? 8A 01 41 84 C0 75 ?? 2B CE 8D 43 ?? 03 C1 74 
            ?? 8B 9C 2C ?? ?? ?? ?? 8B 6C 24 ?? 0F 1F 40 ?? 8B CB 42 8D 71 ?? 8A 01 41 84 C0 75 
            ?? 2B CE 8D 45 ?? 03 C1 3B D0 72 ?? 8B 6C 24 ?? 8B 5C 24 ?? 33 D2 8D 4F ?? 8A 07 47 
            84 C0 75 ?? 2B F9 8D 43 ?? 03 C7 74 ?? 8B BC 2C ?? ?? ?? ?? 0F 1F 40 ?? 8B C7 42 8D 
            70 ?? 8A 08 40 84 C9 75 ?? 2B C6 40 03 C3 3B D0 72 ?? 8B 3D ?? ?? ?? ?? 8B 74 24 ?? 
            83 EE ?? 89 74 24 ?? 0F 85 ?? ?? ?? ?? 8B 6C 24 ?? 8B F5 C1 E6 ?? 8B 84 34 ?? ?? ?? 
            ?? 83 F8 ?? 0F 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 94 34 ?? ?? ?? ?? 66 83 3A ?? 75 ?? 33 C9 EB ?? 8B CA 
        }

        $enum_resources_2_p4 = {
            8D 79 ?? 66 8B 01 83 C1 ?? 66 85 C0 75 ?? 2B CF D1 F9 51 52 8D 4C 24 ?? E8 ?? ?? ?? 
            ?? 8D 44 24 ?? B9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 94 34 ?? ?? ?? ?? 
            66 83 3A ?? 75 ?? 33 C9 EB ?? 8B CA 8D 79 ?? 0F 1F 44 00 ?? 66 8B 01 83 C1 ?? 66 85 
            C0 75 ?? EB ?? 8B 94 34 ?? ?? ?? ?? 66 83 3A ?? 75 ?? 33 C9 EB ?? 8B CA 8D 79 ?? 66 
            8B 01 83 C1 ?? 66 85 C0 75 ?? EB ?? 68 ?? ?? ?? ?? EB ?? 68 ?? ?? ?? ?? EB ?? 68 ?? 
            ?? ?? ?? EB ?? 68 ?? ?? ?? ?? EB ?? 8B 94 34 ?? ?? ?? ?? 66 83 3A ?? 75 ?? 33 C9 E9 
            ?? ?? ?? ?? 8B CA 8D 79 ?? 66 8B 01 83 C1 ?? 66 85 C0 75 ?? E9 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? EB ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? F6 84 34 ?? ?? ?? ?? ?? 74 ?? 8D 
            8C 24 ?? ?? ?? ?? 8D 53 ?? 03 CE E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 45 89 6C 24 ?? 3B 
            6C 24 ?? 0F 82 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? 33 F6 8B 44 24 ?? 83 F8 ?? 
            72 ?? 8B 4C 24 ?? 40 3D ?? ?? ?? ?? 77 ?? 03 C0 3D ?? ?? ?? ?? 72 ?? F6 C1 ?? 75 ?? 
            8B 41 ?? 3B C1 73 ?? 2B C8 83 F9 ?? 72 ?? 83 F9 ?? 77 ?? 8B C8 51 E8 ?? ?? ?? ?? 83 
            C4 ?? 5F 8B C6 5E 5D 5B 81 C4 ?? ?? ?? ?? C3 
        }

    condition:
        uint16(0) == 0x5A4D and 
        (
            all of ($encrypt_files_p*)
        ) and 
        (
            $find_files
        ) and 
        (
            all of ($enum_resources_1_p*) 
        ) and
        (
            all of ($enum_resources_2_p*)
        )
}