rule Win32_Ransomware_Clop : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "CLOP"
        description         = "Yara rule that detects Clop ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Clop"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            8B 95 ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50 6A ?? 8B 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 
            83 C4 ?? 83 BD ?? ?? ?? ?? ?? 74 ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 83 BD ?? 
            ?? ?? ?? ?? 74 ?? 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? 
            ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? 
            ?? ?? FF 15 ?? ?? ?? ?? 6A ?? 8D 95 ?? ?? ?? ?? 52 6A ?? 68 ?? ?? ?? ?? 8B 85 ?? ?? 
            ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8B 8D ?? ?? ?? 
            ?? 51 FF 15 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 6A ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 8B 85 ?? ?? ?? 
            ?? 8B 88 ?? ?? ?? ?? 51 8B 95 ?? ?? ?? ?? 8B 82 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 8B 
            91 ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 8B 95 ?? ?? ?? ?? 52 E8 
            ?? ?? ?? ?? 83 C4 ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 8B 95 ?? ?? ?? 
            ?? 52 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 83 BD ?? ?? ?? ?? ?? 74 ?? 
            68 ?? ?? ?? ?? 6A ?? 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 74 
            ?? 68 ?? ?? ?? ?? 6A ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 
            74 ?? 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 8D 95 ?? ?? 
            ?? ?? 52 FF 15
        }

        $encrypt_files_p2 = {
            55 8B EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 45 ?? 50 8D 
            4D ?? 51 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 FF 
            15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 8D 95 ?? 
            ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 6A ?? 6A ?? 8D 85 
            ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 6A ?? 6A ?? 8D 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? 
            ?? 85 C0 75 ?? 33 C0 E9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 6A ?? 
            68 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 8D 85 ?? ?? ?? ?? 50 6A ?? 6A ?? FF 15 ?? ?? ?? 
            ?? 85 C0 75 ?? 33 C0 E9 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 
            ?? 6A ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 33 C0 E9 ?? ?? ?? 
            ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50 6A ?? 8B 
            8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 33 C0 E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            FF 15 ?? ?? ?? ?? BA ?? ?? ?? ?? 85 D2 0F 84 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 8B 8D 
            ?? ?? ?? ?? 51 8B 95 ?? ?? ?? ?? 52 6A ?? 6A ?? E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 50 
            68 ?? ?? ?? ?? 8D 4D ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            8B 95 ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 6A ?? 6A ?? E8 ?? ?? 
            ?? ?? 50 8B 15 ?? ?? ?? ?? 52 68 ?? ?? ?? ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 68 
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? 33 C0 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B 
            E5 5D C2
        }

        $encrypt_files_p3 = {
            55 8B EC 83 EC ?? 6A ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? 89 45 ?? 8B 
            4D ?? 51 8D 55 ?? 52 6A ?? 6A ?? 6A ?? 6A ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 
            ?? FF 15 ?? ?? ?? ?? 33 C0 EB ?? 8B 4D ?? 51 6A ?? 8B 55 ?? 52 E8 ?? ?? ?? ?? 83 C4 
            ?? 8B 45 ?? 50 8B 4D ?? 51 8B 55 ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8B 45 ?? 50 8D 4D ?? 
            51 8B 55 ?? 52 6A ?? 6A ?? 6A ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? 
            ?? ?? ?? 33 C0 EB ?? 8B 4D ?? 8B 55 ?? 89 11 33 C0 8B E5 5D C3 
        }

        $find_files = {
            8D 95 ?? ?? ?? ?? 52 6A ?? 6A ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 
            68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 83 C4 ?? 8D 95 ?? ?? ?? ?? 52 
            8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 74 ?? 
            8D 8D ?? ?? ?? ?? 51 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD 
            ?? ?? ?? ?? ?? 75 ?? EB ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 
            C0 76 ?? 8D 8D ?? ?? ?? ?? 51 8D 95 ?? ?? ?? ?? 52 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 
            50 FF 15 ?? ?? ?? ?? 83 C4 ?? EB ?? 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 6A ?? 68 
            ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 
            89 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? 
            ?? 6A ?? 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 
            51 6A ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 6A ?? 8D 95 ?? ?? ?? ?? 52 8B 85 ?? ?? 
            ?? ?? 50 8B 8D ?? ?? ?? ?? 51 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? C7 85 ?? ?? ?? 
            ?? ?? ?? ?? ?? C6 45 ?? ?? 6A ?? 6A ?? 8D 45 ?? 50 E8
        }

        $uninstall_eset_av = {
            8D 45 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 86 ?? ?? ?? ?? 8D 4D ?? 51 68 ?? ?? ?? ?? 8D 
            95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 68 ?? 
            ?? ?? ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? EB ?? 8B 8D ?? 
            ?? ?? ?? 83 C1 ?? 89 8D ?? ?? ?? ?? 81 BD ?? ?? ?? ?? ?? ?? ?? ?? 7D ?? 68 ?? ?? ?? 
            ?? 6A ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 6A ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? 
            ?? ?? 6A ?? 6A ?? 6A ?? 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 
            FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 6A ?? 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 6A 
            ?? 6A ?? 6A ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 6A ?? FF 15 ?? ?? ?? ?? E9 ?? 
            ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? 
            ?? ?? 8B 85 ?? ?? ?? ?? 50 FF 15
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $uninstall_eset_av
        )
}