rule Win32_Ransomware_Cicada3301 : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "CICADA3301"
        description         = "Yara rule that detects Cicada3301 ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Cicada3301"
        tc_detection_factor = 5

    strings:

        $get_valid_drives = {
            55 89 E5 53 57 56 83 EC ?? A1 ?? ?? ?? ?? 0F B6 00 6A ?? 6A ?? E8 ?? ?? ?? ?? 83 C4
            ?? 85 C0 0F 84 ?? ?? ?? ?? 0F 28 05 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 28 15 ?? ??
            ?? ?? 89 C6 0F 11 00 0F 11 48 ?? 0F 28 0D ?? ?? ?? ?? 0F 11 50 ?? 0F 28 15 ?? ?? ??
            ?? 0F 11 48 ?? 0F 28 0D ?? ?? ?? ?? 0F 11 50 ?? 0F 11 48 ?? C7 40 ?? ?? ?? ?? ?? C7
            40 ?? ?? ?? ?? ?? 83 C0 ?? 8D 4D ?? 50 56 51 E8 ?? ?? ?? ?? 83 C4 ?? 80 7D ?? ?? 0F
            84 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D ?? 89 45 ?? 83 FF ?? 0F 82 ?? ?? ?? ?? 8B 5D ??
            8D 04 7F 89 75 ?? 89 7D ?? 8D 74 83 ?? 66 2E 0F 1F 84 00 ?? ?? ?? ?? 90 57 6A ?? 8D
            45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? 8D 4F ?? 39 D1 0F 83 ?? ?? ?? ?? 39 D0 0F
            83 ?? ?? ?? ?? 8B 56 ?? 8D 04 40 89 CF 89 55 ?? F2 0F 10 06 F2 0F 11 45 ?? 8B 54 83
            ?? F2 0F 10 04 83 F2 0F 11 06 89 56 ?? 83 C6 ?? 83 F9 ?? 8B 55 ?? 89 54 83 ?? F2 0F
            10 45 ?? F2 0F 11 04 83 77 ?? 8B 45 ?? 8B 75 ?? FF 08 75 ?? FF 48 ?? 75 ?? 6A ?? 68
            ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 7D ?? 8B 45 ?? F2 0F 10 45 ?? 89 47 ?? F2
            0F 11 07 6A ?? 6A ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 89 F8 83 C4 ?? 5E 5F 5B 5D C3
        }

        $collect_files_recursively_p1 = {
            55 89 E5 53 57 56 83 E4 ?? 81 EC ?? ?? ?? ?? 8B 4D ?? 8B 7D ?? 8B 75 ?? 8B 45 ?? 89
            4C 24 ?? 89 44 24 ?? 57 56 E8 ?? ?? ?? ?? 83 C4 ?? 8B 4D ?? 84 C0 0F 84 ?? ?? ?? ??
            8D 9C 24 ?? ?? ?? ?? 57 56 53 E8 ?? ?? ?? ?? 83 C4 ?? 83 BC 24 ?? ?? ?? ?? ?? 75 ??
            8B 84 24 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 89 8C 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ??
            C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D B4 24 ?? ?? ?? ?? 68 ?? ?? ?? ??
            53 56 E8 ?? ?? ?? ?? 83 C4 ?? 83 BC 24 ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B 7D ?? 8B
            5D ?? 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 04 FB C7
            84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 89 84 24 ?? ?? ?? ??
            8D 8C 24 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 BC 24 ?? ?? ?? ?? ?? 0F
            84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 8D B4 24 ?? ?? ?? ?? 56 E8 ??
            ?? ?? ?? 83 C4 ?? 56 8D 74 24 ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 56 E8 ?? ?? ?? ?? 83 C4
            ?? 52 50 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B BC 24 ?? ?? ?? ?? 8B 9C
            24 ?? ?? ?? ?? 85 FF 89 FA 0F 44 D3 8D 8C 24 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ??
            68 ?? ?? ?? ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 FF 74 ?? 85 DB 74 ??
            6A ?? 53 57 E8 ?? ?? ?? ?? 83 C4 ?? 8B 84 24 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 8B 7D
            ?? 89 44 24 ?? 89 0C 24 EB ?? 66 90 83 C7 ?? 80 7C 24 ?? ?? 0F 85 ?? ?? ?? ?? 3B BC
        }

        $collect_files_recursively_p2 = {
            24 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? FF 77 ?? FF 37 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4
            ?? FF 34 24 FF 74 24 ?? 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 74 24 ?? FF 74 24
            ?? 56 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 80 BC 24 ?? ?? ?? ?? ?? 0F 84
            ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? F2 0F 10 84 24 ?? ?? ?? ?? F2 0F 10 94 24 ?? ?? ??
            ?? F2 0F 10 8C 24 ?? ?? ?? ?? 8B 5C 24 ?? 89 84 24 ?? ?? ?? ?? F2 0F 11 84 24 ?? ??
            ?? ?? F2 0F 11 8C 24 ?? ?? ?? ?? F2 0F 11 94 24 ?? ?? ?? ?? FF 74 24 ?? 53 8D 84 24
            ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 88 44 24 ?? 8B 44 24 ?? 85 C0 74 ?? 6A ?? 50
            53 E8 ?? ?? ?? ?? 83 C4 ?? 8B 44 24 ?? 85 C0 74 ?? 6A ?? 50 56 E8 ?? ?? ?? ?? 83 C4
            ?? 8B 84 24 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? 50 FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83
            C4 ?? 8B B4 24 ?? ?? ?? ?? 85 F6 74 ?? 8B 9C 24 ?? ?? ?? ?? 83 C3 ?? EB ?? 66 2E 0F
            1F 84 00 ?? ?? ?? ?? 90 83 C3 ?? 4E 74 ?? 83 7B ?? ?? 72 ?? 8B 03 85 C0 74 ?? C1 E0
            ?? 6A ?? 50 FF 73 ?? E8 ?? ?? ?? ?? 83 C4 ?? EB ?? 66 2E 0F 1F 84 00 ?? ?? ?? ?? 90
            8B 84 24 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? C1 E0 ?? 6A ?? 50 FF B4 24 ?? ?? ?? ??
            E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 0F 1F 80 ?? ?? ?? ?? 8D 44 24 ?? 50 E8 ?? ??
            ?? ?? 83 C4 ?? 52 50 E8 ?? ?? ?? ?? 83 C4 ?? 84 C0 74 ?? 8D 44 24 ?? 50 E8 ?? ?? ??
            ?? 83 C4 ?? 8B 5C 24 ?? 89 44 24 ?? 89 54 24 ?? 85 DB 0F 84 ?? ?? ?? ?? 83 FB ?? 0F
            85 ?? ?? ?? ?? 8B 74 24 ?? F0 FF 86 ?? ?? ?? ?? 0F 8F ?? ?? ?? ?? E9 ?? ?? ?? ?? 0F
            1F 44 00 ?? 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 52 50 8D 84 24 ?? ?? ?? ?? 50 E8
            ?? ?? ?? ?? 83 C4 ?? 8B 84 24 ?? ?? ?? ?? 83 F0 ?? 0B 84 24 ?? ?? ?? ?? 75 ?? 8B 84
            24 ?? ?? ?? ?? 8B 8C 24 ?? ?? ?? ?? 89 8C 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? EB
        }

        $collect_files_recursively_p3 = {
            8D 94 24 ?? ?? ?? ?? 8D 9C 24 ?? ?? ?? ?? B9 ?? ?? ?? ?? 89 D7 89 DE F3 A5 8B 84 24
            ?? ?? ?? ?? 83 F0 ?? 0B 84 24 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 80 BC 24 ?? ?? ?? ?? ??
            0F 85 ?? ?? ?? ?? 8B BC 24 ?? ?? ?? ?? 8B 77 ?? 8B 1F 8B 06 53 FF D0 83 C4 ?? 8B 46
            ?? 85 C0 74 ?? FF 76 ?? 50 53 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 57 E8 ?? ?? ?? ??
            83 C4 ?? EB ?? 8B 74 24 ?? F0 FF 86 ?? ?? ?? ?? 7F ?? E9 ?? ?? ?? ?? 8B 74 24 ?? F0
            FF 06 0F 8E ?? ?? ?? ?? 89 5C 24 ?? 89 74 24 ?? FF 75 ?? 8D BC 24 ?? ?? ?? ?? 57 E8
            ?? ?? ?? ?? 83 C4 ?? 57 56 53 FF 75 ?? FF 75 ?? FF 74 24 ?? FF 74 24 ?? 8D 84 24 ??
            ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 84 24 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B
            84 24 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? 50 FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ??
            8B 44 24 ?? 85 C0 74 ?? 6A ?? 50 FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B 84 24 ?? ??
            ?? ?? F0 FF 08 0F 85 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? E9
            ?? ?? ?? ?? B9 ?? ?? ?? ?? 89 DF 89 D6 F3 A5 53 E8 ?? ?? ?? ?? 83 C4 ?? 09 D0 0F 84
            ?? ?? ?? ?? 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 52 50 E8 ?? ?? ?? ?? 83 C4 ?? 85
            C0 74 ?? 52 50 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 31 DB 83 7C 24 ?? ?? 75 ?? 8B
            5C 24 ?? 8B 7C 24 ?? EB ?? 8B BC 24 ?? ?? ?? ?? 31 DB 85 DB B8 ?? ?? ?? ?? 89 BC 24
            ?? ?? ?? ?? 0F 44 FB 0F 44 D8 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 52 50 E8 ?? ??
            ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ?? ?? ?? 52 50 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ??
            83 7C 24 ?? ?? 8B 4C 24 ?? 0F 85 ?? ?? ?? ?? 8B 74 24 ?? 89 C8 83 F8 ?? 0F 82 ?? ??
            ?? ?? 89 4C 24 ?? 8B 0E BA ?? ?? ?? ?? 31 D1 0F B6 56 ?? 83 F2 ?? 09 CA 0F 85 ?? ??
            ?? ?? 83 C0 ?? 8D 4E ?? 50 51 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 80 7C 24
        }

        $collect_files_recursively_p4 = {
            0F 85 ?? ?? ?? ?? 8B 44 24 ?? 89 84 24 ?? ?? ?? ?? 50 6A ?? 68 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 89 C1 85 C0 74 ?? C7 44 24 ?? ?? ?? ?? ?? 8D 44 24 ?? 50 51 89 4C 24 ?? E8 ??
            ?? ?? ?? 8B 0C 24 89 44 24 ?? 51 E8 ?? ?? ?? ?? 83 7C 24 ?? ?? 74 ?? 81 7C 24 ?? ??
            ?? ?? ?? 0F 84 ?? ?? ?? ?? 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 52 50 8D 44 24 ??
            50 E8 ?? ?? ?? ?? 83 C4 ?? 83 7C 24 ?? ?? 8B 4C 24 ?? 8B 54 24 ?? B8 ?? ?? ?? ?? C7
            44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 0F 45 C8 B8 ??
            ?? ?? ?? 0F 45 D0 8D 84 24 ?? ?? ?? ?? 89 0C 24 89 44 24 ?? 8D 44 24 ?? 89 54 24 ??
            C7 44 24 ?? ?? ?? ?? ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 8D 44 24 ?? 50 8D 44 24
            ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 44 24 ?? 8B 0C 24 8B 54 24 ?? 89 44 24 ?? 8B 44 24
            ?? 89 54 24 ?? 89 84 24 ?? ?? ?? ?? 89 C8 29 D0 BA ?? ?? ?? ?? 72 ?? 03 44 24 ?? FF
            74 24 ?? 50 FF 74 24 ?? E8 ?? ?? ?? ?? 8B 4C 24 ?? 83 C4 ?? 8B 54 24 ?? 85 C0 B8 ??
            ?? ?? ?? 0F 45 D0 8B 84 24 ?? ?? ?? ?? 89 54 24 ?? 85 C0 74 ?? 6A ?? 50 FF 74 24 ??
            E8 ?? ?? ?? ?? 8B 54 24 ?? 8B 4C 24 ?? 83 C4 ?? 89 C8 29 D0 89 44 24 ?? 50 8B 44 24
            ?? 50 51 50 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 0F B6 84 24 ?? ?? ?? ??
            3C ?? 0F 85 ?? ?? ?? ?? 8B 44 24 ?? 8B 7C 24 ?? BE ?? ?? ?? ?? 39 04 24 74 ?? 85 FF
            0F 88 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F B6 00 6A ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 89 C6 85
            C0 0F 84 ?? ?? ?? ?? 57 FF 74 24 ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 89 74 24 ?? 89 7C 24
            ?? 89 7C 24 ?? 8D 44 24 ?? 50 8D 44 24 ?? 50 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4
        }

        $collect_files_recursively_p5 = {
            8B 7C 24 ?? 85 FF 0F 84 ?? ?? ?? ?? 8B 5C 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ??
            ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 8D 74 24 ?? 56 E8
            ?? ?? ?? ?? 83 C4 ?? 56 6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 84 C0 0F 85 ??
            ?? ?? ?? 8B 44 24 ?? 8B 4C 24 ?? 8B 74 24 ?? 85 DB 89 44 24 ?? 89 0C 24 74 ?? 6A ??
            53 57 E8 ?? ?? ?? ?? 83 C4 ?? 85 F6 0F 84 ?? ?? ?? ?? E9 ?? ?? ?? ?? BE ?? ?? ?? ??
            C7 44 24 ?? ?? ?? ?? ?? EB ?? 31 C0 BE ?? ?? ?? ?? 83 F8 ?? 0F 83 ?? ?? ?? ?? 89 44
            24 ?? 8D 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ??
            ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 89 44 24 ?? C7 44 24 ?? ?? ??
            ?? ?? 8D 44 24 ?? 50 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? F2 0F 10 44 24 ?? 8B 44
            24 ?? F2 0F 11 44 24 ?? 39 C7 89 44 24 ?? 8B 4C 24 ?? 89 0C 24 75 ?? 57 FF 74 24 ??
            53 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? 83 7C 24 ?? ?? 75 ?? 8B 06 8B 76 ?? B9 ?? ??
            ?? ?? BA ?? ?? ?? ?? 31 C8 31 D6 09 C6 74 ?? 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ??
            52 50 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 7C 24 ?? ?? 0F 85 ?? ?? ?? ?? 8B 5C
            24 ?? 8B 7C 24 ?? 85 FF 0F 84 ?? ?? ?? ?? 0F 88 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F B6 00
            6A ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 89 C6 85 C0 0F 85 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 44
        }

        $collect_files_recursively_p6 = { 
            24 ?? 85 C0 74 ?? 6A ?? 50 FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 66 2E 0F 1F 84 00 ??
            ?? ?? ?? 0F 1F 44 00 ?? 8B 84 24 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? 50 FF 74 24 ?? E8 ??
            ?? ?? ?? 83 C4 ?? 8B 44 24 ?? 85 C0 74 ?? 6A ?? 50 FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4
            ?? 8B 84 24 ?? ?? ?? ?? F0 FF 08 0F 85 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ??
            ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 31 FF BB ?? ?? ?? ?? 85 FF 0F 85 ?? ?? ?? ?? BE ?? ??
            ?? ?? 57 89 5C 24 ?? 53 56 E8 ?? ?? ?? ?? 83 C4 ?? 89 74 24 ?? 89 7C 24 ?? 89 7C 24
            ?? 6A ?? 57 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 44 24 ?? 8B 74 24 ?? 66 C7 44
            30 ?? ?? ?? C7 04 30 ?? ?? ?? ?? 8B 45 ?? 83 C6 ?? F2 0F 10 44 24 ?? 89 74 24 ?? 8B
            08 8B 58 ?? F2 0F 11 44 24 ?? 8B 44 24 ?? 89 4C 24 ?? 29 F0 39 D8 73 ?? 53 56 8D 44
            24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 74 24 ?? 8B 44 24 ?? 01 F0 53 FF 74 24 ?? 50 E8
            ?? ?? ?? ?? 83 C4 ?? F2 0F 10 44 24 ?? 01 DE 89 B4 24 ?? ?? ?? ?? F2 0F 11 84 24 ??
            ?? ?? ?? 8B 9C 24 ?? ?? ?? ?? 56 53 57 FF 74 24 ?? 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ??
            ?? ?? 83 C4 ?? 0F B6 84 24 ?? ?? ?? ?? 3C ?? 88 44 24 ?? 0F 85 ?? ?? ?? ?? 8D 84 24
            ?? ?? ?? ?? 50 8D 44 24 ?? 50 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 7C 24 ?? 85
            FF 0F 84 ?? ?? ?? ?? 8B 74 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7
            44 24 ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 8D 5C 24 ?? 53 E8 ?? ?? ?? ?? 83
            C4 ?? 53 6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 84 C0 0F 85 ?? ?? ?? ?? 8B 44
            24 ?? 8B 4C 24 ?? 8B 5C 24 ?? 85 F6 89 44 24 ?? 89 4C 24 ?? 74 ?? 6A ?? 56 57 E8 ??
            ?? ?? ?? 83 C4 ?? 85 DB 74 ?? E9 ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 85 C0 74 ?? 6A ??
            50 53 E8 ?? ?? ?? ?? 83 C4 ?? 8B 44 24 ?? 85 C0 74 ?? 6A ?? 50 FF 74 24
        }

        $encrypt_files_full_v1_p1 = {
            55 89 E5 53 57 56 83 E4 ?? 81 EC ?? ?? ?? ?? 89 54 24 ?? 89 4C 24 ?? 6A ?? 68 ?? ??
            ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 89 C7 89 44 24 ??
            0F 85 ?? ?? ?? ?? 83 7D ?? ?? 0F 85 ?? ?? ?? ?? 8D 47 ?? 89 44 24 ?? EB ?? 66 2E 0F
            1F 84 00 ?? ?? ?? ?? 0F 1F 44 00 ?? 8B 06 01 F8 53 FF 74 24 ?? 50 E8 ?? ?? ?? ?? 83
            C4 ?? 01 DF 89 7E ?? 8B 7C 24 ?? 68 ?? ?? ?? ?? 57 FF 74 24 ?? 8D 44 24 ?? 50 E8 ??
            ?? ?? ?? 83 C4 ?? 0F B6 44 24 ?? 3C ?? 0F 85 ?? ?? ?? ?? 8B 74 24 ?? 85 F6 0F 84 ??
            ?? ?? ?? 8B 45 ?? 8D 4C 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44
            24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 55 ?? F2 0F 10 40 ?? F3 0F 7E 48 ?? F2
            0F 11 41 ?? F2 0F 10 40 ?? 66 0F D6 49 ?? F2 0F 11 41 ?? F2 0F 10 00 8B 42 ?? F2 0F
            11 01 F3 0F 7E 02 89 44 24 ?? A1 ?? ?? ?? ?? 66 0F D6 44 24 ?? 0F B6 00 3C ?? 75 ??
            E8 ?? ?? ?? ?? F2 0F 10 44 24 ?? F3 0F 7E 4C 24 ?? 8B 44 24 ?? 0F B6 5C 24 ?? 0F B7
            54 24 ?? 81 FE ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? F2 0F 11 84 24 ?? ?? ?? ?? F2 0F 10
            44 24 ?? 66 0F D6 8C 24 ?? ?? ?? ?? F2 0F 11 84 24 ?? ?? ?? ?? F2 0F 10 44 24 ?? F2
            0F 11 84 24 ?? ?? ?? ?? F2 0F 10 44 24 ?? F2 0F 11 84 24 ?? ?? ?? ?? F2 0F 10 44 24
            ?? F2 0F 11 44 24 ?? F3 0F 7E 44 24 ?? 89 41 ?? 66 0F D6 41 ?? C7 41 ?? ?? ?? ?? ??
            C7 01 ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7
            41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7
            41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7
            41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? 88 59 ?? 66 89 51 ?? C7
            84 24 ?? ?? ?? ?? ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? 0F 83 ?? ?? ?? ?? 89 F0 89 7C
        }

        $encrypt_files_full_v1_p2 = {
            24 ?? 89 7C 24 ?? C1 E8 ?? 89 44 24 ?? 8D 44 24 ?? 50 8D 44 24 ?? 50 E8 ?? ?? ?? ??
            83 C4 ?? 89 F3 83 E3 ?? 0F 84 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F B6 00 3C ?? 75 ?? 8D 4C
            24 ?? 8D 94 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 0F 1F 44 00 ?? F3 0F 6F 64
            24 ?? F3 0F 6F 94 24 ?? ?? ?? ?? F3 0F 6F 84 24 ?? ?? ?? ?? F3 0F 6F BC 24 ?? ?? ??
            ?? B8 ?? ?? ?? ?? 66 0F 6F F4 66 0F 6F DA 66 0F 6F E8 66 0F 7F 7C 24 ?? 0F 1F 84 00
            ?? ?? ?? ?? 66 0F FE F3 48 66 0F EF EE 66 0F 6F CD 66 0F 72 F5 ?? 66 0F 72 D1 ?? 66
            0F EB E9 66 0F FE FD 66 0F EF DF 66 0F 6F CB 66 0F 72 F3 ?? 66 0F 72 D1 ?? 66 0F EB
            D9 66 0F FE F3 66 0F EF EE 66 0F 70 F6 ?? 66 0F 6F CD 66 0F 72 F5 ?? 66 0F 72 D1 ??
            66 0F EB E9 66 0F FE FD 66 0F 70 ED ?? 66 0F EF DF 66 0F 70 FF ?? 66 0F 6F CB 66 0F
            72 F3 ?? 66 0F 72 D1 ?? 66 0F EB D9 66 0F FE F3 66 0F EF EE 66 0F 6F CD 66 0F 72 F5
            ?? 66 0F 72 D1 ?? 66 0F EB E9 66 0F FE FD 66 0F EF DF 66 0F 6F CB 66 0F 72 F3 ?? 66
            0F 72 D1 ?? 66 0F EB D9 66 0F FE F3 66 0F EF EE 66 0F 70 F6 ?? 66 0F 6F CD 66 0F 72
            F5 ?? 66 0F 72 D1 ?? 66 0F EB E9 66 0F FE FD 66 0F 70 ED ?? 66 0F EF DF 66 0F 70 FF
            ?? 66 0F 6F CB 66 0F 72 F3 ?? 66 0F 72 D1 ?? 66 0F EB D9 0F 85 ?? ?? ?? ?? 66 0F FE
            7C 24 ?? 66 0F 7E C0 66 0F FE F4 66 0F FE DA 66 0F FE E8 40 F3 0F 7F B4 24 ?? ?? ??
            ?? F3 0F 7F 9C 24 ?? ?? ?? ?? F3 0F 7F BC 24 ?? ?? ?? ?? F3 0F 7F AC 24 ?? ?? ?? ??
            89 84 24 ?? ?? ?? ?? 89 F2 31 C9 83 E2 ?? 83 FB ?? 8D 04 17 0F 82 ?? ?? ?? ?? 31 C9
        }

        $encrypt_files_full_v1_p3 = {
            83 FB ?? 72 ?? 03 54 24 ?? 89 F7 89 D9 83 E7 ?? 89 7C 24 ?? 29 F9 31 FF 66 2E 0F 1F
            84 00 ?? ?? ?? ?? 66 90 F3 0F 6F 44 3A ?? F3 0F 6F 94 3C ?? ?? ?? ?? F3 0F 6F 0C 3A
            F3 0F 6F 9C 3C ?? ?? ?? ?? 66 0F EF D0 66 0F EF D9 F3 0F 7F 54 3A ?? F3 0F 7F 1C 3A
            83 C7 ?? 39 F9 75 ?? 8B 54 24 ?? 85 D2 74 ?? 83 FA ?? 72 ?? 89 F2 89 CF 89 D9 83 E2
            ?? 29 D1 90 F3 0F 7E 04 38 F3 0F 7E 8C 3C ?? ?? ?? ?? 66 0F EF C8 66 0F D6 0C 38 83
            C7 ?? 39 F9 75 ?? 85 D2 74 ?? 66 2E 0F 1F 84 00 ?? ?? ?? ?? 0F 1F 40 ?? 0F B6 94 0C
            ?? ?? ?? ?? 30 14 08 41 39 CB 75 ?? 88 9C 24 ?? ?? ?? ?? 89 F3 8B 74 24 ?? 8B 46 ??
            8B 7E ?? 29 F8 39 D8 0F 87 ?? ?? ?? ?? 53 8B 7C 24 ?? 57 56 8D 44 24 ?? 50 E8 ?? ??
            ?? ?? 83 C4 ?? 0F B6 44 24 ?? 3C ?? 0F 84 ?? ?? ?? ?? 8B 54 24 ?? 8B 4C 24 ?? 89 54
            24 ?? 89 4C 24 ?? 88 44 24 ?? A1 ?? ?? ?? ?? 0F B6 00 6A ?? 6A ?? E8 ?? ?? ?? ?? 83
            C4 ?? 85 C0 0F 84 ?? ?? ?? ?? F2 0F 10 44 24 ?? 89 C7 BB ?? ?? ?? ?? F2 0F 11 00 EB
            ?? 8D 44 24 ?? 68 ?? ?? ?? ?? 57 FF 74 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 0F B6 44 24
            ?? 3C ?? 75 ?? 83 7C 24 ?? ?? 74 ?? BB ?? ?? ?? ?? BF ?? ?? ?? ?? EB ?? 3C ?? 75 ??
            8B 5C 24 ?? 8B 73 ?? 8B 3B 8B 06 57 FF D0 83 C4 ?? 8B 46 ?? 85 C0 74 ?? FF 76 ?? 50
            57 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 53 E8 ?? ?? ?? ?? 83 C4 ?? 31 FF 6A ?? 68 ??
            ?? ?? ?? FF 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 F8 89 DA 8D 65 ?? 5E 5F 5B 5D C3
        }

        $encrypt_files_full_v2_p1 = {
            55 89 E5 53 57 56 83 E4 ?? 81 EC ?? ?? ?? ?? 89 D7 89 4C 24 ?? 6A ?? 68 ?? ?? ?? ??
            E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 89 C3 89 44 24 ?? 0F 85
            ?? ?? ?? ?? 83 7D ?? ?? 0F 85 ?? ?? ?? ?? 8D 43 ?? 89 7C 24 ?? 89 44 24 ?? EB ?? 66
            2E 0F 1F 84 00 ?? ?? ?? ?? 0F 1F 00 8B 06 01 F8 53 FF 74 24 ?? 50 E8 ?? ?? ?? ?? 83
            C4 ?? 01 DF 8B 5C 24 ?? 89 7E ?? 89 F7 68 ?? ?? ?? ?? 53 FF 74 24 ?? 8D 44 24 ?? 50
            E8 ?? ?? ?? ?? 83 C4 ?? 0F B6 44 24 ?? 3C ?? 0F 85 ?? ?? ?? ?? 8B 74 24 ?? 85 F6 0F
            84 ?? ?? ?? ?? 8B 45 ?? 8D 4C 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ??
            C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 55 ?? F2 0F 10 40 ?? F3 0F 7E 48
            ?? F2 0F 11 41 ?? F2 0F 10 40 ?? 66 0F D6 49 ?? F2 0F 11 41 ?? F2 0F 10 00 8B 42 ??
            F2 0F 11 01 F3 0F 7E 02 89 44 24 ?? A1 ?? ?? ?? ?? 66 0F D6 44 24 ?? 0F B6 00 3C ??
            75 ?? E8 ?? ?? ?? ?? F2 0F 10 44 24 ?? F3 0F 7E 4C 24 ?? 8B 44 24 ?? 8D 8C 24 ?? ??
            ?? ?? 0F B7 54 24 ?? 81 FE ?? ?? ?? ?? F2 0F 11 84 24 ?? ?? ?? ?? F2 0F 10 44 24 ??
            66 0F D6 8C 24 ?? ?? ?? ?? F2 0F 11 84 24 ?? ?? ?? ?? F2 0F 10 44 24 ?? F2 0F 11 84
            24 ?? ?? ?? ?? F2 0F 10 44 24 ?? F2 0F 11 84 24 ?? ?? ?? ?? F2 0F 10 44 24 ?? F2 0F
            11 44 24 ?? 89 41 ?? F3 0F 7E 44 24 ?? 0F B6 44 24 ?? 66 0F D6 41 ?? C7 41 ?? ?? ??
            ?? ?? C7 01 ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ??
            ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ??
            ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ??
            ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? 88 41 ?? 66 89 51
            ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? 0F 83 ?? ?? ?? ?? 89 F0
        }

        $encrypt_files_full_v2_p2 = {
            89 5C 24 ?? 89 5C 24 ?? C1 E8 ?? 89 44 24 ?? 8D 44 24 ?? 50 8D 44 24 ?? 50 E8 ?? ??
            ?? ?? 83 C4 ?? 89 F3 83 E3 ?? 0F 84 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F B6 00 3C ?? 75 ??
            8D 4C 24 ?? 8D 94 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 0F 1F 00 F3 0F 6F 64
            24 ?? F3 0F 6F 94 24 ?? ?? ?? ?? F3 0F 6F 84 24 ?? ?? ?? ?? F3 0F 6F BC 24 ?? ?? ??
            ?? B8 ?? ?? ?? ?? 66 0F 6F F4 66 0F 6F DA 66 0F 6F E8 66 0F 7F 7C 24 ?? 0F 1F 84 00
            ?? ?? ?? ?? 66 0F FE F3 48 66 0F EF EE 66 0F 6F CD 66 0F 72 F5 ?? 66 0F 72 D1 ?? 66
            0F EB E9 66 0F FE FD 66 0F EF DF 66 0F 6F CB 66 0F 72 F3 ?? 66 0F 72 D1 ?? 66 0F EB
            D9 66 0F FE F3 66 0F EF EE 66 0F 70 F6 ?? 66 0F 6F CD 66 0F 72 F5 ?? 66 0F 72 D1 ??
            66 0F EB E9 66 0F FE FD 66 0F 70 ED ?? 66 0F EF DF 66 0F 70 FF ?? 66 0F 6F CB 66 0F
            72 F3 ?? 66 0F 72 D1 ?? 66 0F EB D9 66 0F FE F3 66 0F EF EE 66 0F 6F CD 66 0F 72 F5
            ?? 66 0F 72 D1 ?? 66 0F EB E9 66 0F FE FD 66 0F EF DF 66 0F 6F CB 66 0F 72 F3 ?? 66
            0F 72 D1 ?? 66 0F EB D9 66 0F FE F3 66 0F EF EE 66 0F 70 F6 ?? 66 0F 6F CD 66 0F 72
            F5 ?? 66 0F 72 D1 ?? 66 0F EB E9 66 0F FE FD 66 0F 70 ED ?? 66 0F EF DF 66 0F 70 FF
            ?? 66 0F 6F CB 66 0F 72 F3 ?? 66 0F 72 D1 ?? 66 0F EB D9 0F 85 ?? ?? ?? ?? 66 0F FE
            7C 24 ?? 66 0F 7E C0 66 0F FE F4 66 0F FE DA 66 0F FE E8 40 F3 0F 7F B4 24 ?? ?? ??
            ?? F3 0F 7F 9C 24 ?? ?? ?? ?? F3 0F 7F BC 24 ?? ?? ?? ?? F3 0F 7F AC 24 ?? ?? ?? ??
            89 84 24 ?? ?? ?? ?? 8B 44 24 ?? 89 F2 31 C9 83 E2 ?? 83 FB ?? 8D 04 10 0F 82 ?? ??
            ?? ?? 31 C9 83 FB ?? 72 ?? 03 54 24 ?? 89 F7 89 D9 83 E7 ?? 89 7C 24 ?? 29 F9 31 FF
        }

        $encrypt_files_full_v2_p3 = {
            0F 1F 84 00 ?? ?? ?? ?? F3 0F 6F 44 3A ?? F3 0F 6F 94 3C ?? ?? ?? ?? F3 0F 6F 0C 3A
            F3 0F 6F 9C 3C ?? ?? ?? ?? 66 0F EF D0 66 0F EF D9 F3 0F 7F 54 3A ?? F3 0F 7F 1C 3A
            83 C7 ?? 39 F9 75 ?? 8B 54 24 ?? 8B 7C 24 ?? 85 D2 74 ?? 83 FA ?? 72 ?? 89 F2 89 CF
            89 D9 83 E2 ?? 29 D1 66 2E 0F 1F 84 00 ?? ?? ?? ?? 0F 1F 00 F3 0F 7E 04 38 F3 0F 7E
            8C 3C ?? ?? ?? ?? 66 0F EF C8 66 0F D6 0C 38 83 C7 ?? 39 F9 75 ?? 8B 7C 24 ?? 85 D2
            74 ?? 66 2E 0F 1F 84 00 ?? ?? ?? ?? 0F B6 94 0C ?? ?? ?? ?? 30 14 08 41 39 CB 75 ??
            88 9C 24 ?? ?? ?? ?? 89 F3 8B 47 ?? 89 FE 8B 7F ?? 29 F8 39 D8 0F 87 ?? ?? ?? ?? 53
            8B 5C 24 ?? 53 56 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 0F B6 44 24 ?? 89 F7 3C ??
            0F 84 ?? ?? ?? ?? 8B 54 24 ?? 8B 4C 24 ?? 89 54 24 ?? 89 4C 24 ?? 88 44 24 ?? A1 ??
            ?? ?? ?? 0F B6 00 6A ?? 6A ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ?? ?? ?? F2 0F
            10 44 24 ?? 89 C7 BB ?? ?? ?? ?? F2 0F 11 00 EB ?? 8D 44 24 ?? 68 ?? ?? ?? ?? 53 FF
            74 24 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 0F B6 44 24 ?? 3C ?? 75 ?? 83 7C 24 ?? ?? 74 ??
            BB ?? ?? ?? ?? BF ?? ?? ?? ?? EB ?? 3C ?? 75 ?? 8B 5C 24 ?? 8B 73 ?? 8B 3B 8B 06 57
            FF D0 83 C4 ?? 8B 46 ?? 85 C0 74 ?? FF 76 ?? 50 57 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A
            ?? 53 E8 ?? ?? ?? ?? 83 C4 ?? 31 FF 6A ?? 68 ?? ?? ?? ?? FF 74 24 ?? E8 ?? ?? ?? ??
            83 C4 ?? 89 F8 89 DA 8D 65 ?? 5E 5F 5B 5D C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($collect_files_recursively_p*)
        ) and
        (
            $get_valid_drives
        ) and
        (
            (
                (
                    all of ($encrypt_files_full_v1_p*)
                )
            )
             or
            (
                (
                    all of ($encrypt_files_full_v2_p*)
                )
            )
        )
}