rule Win32_Ransomware_BlackBasta : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "BLACKBASTA"
        description         = "Yara rule that detects BlackBasta ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "BlackBasta"
        tc_detection_factor = 5

    strings:

        $find_files = {
            53 50 FF 15 ?? ?? ?? ?? 8B F0 83 FE ?? 75 ?? FF B5 ?? ?? ?? ?? 53 53 57 E8 ?? ?? ??
            ?? 83 C4 ?? 8B F0 38 9D ?? ?? ?? ?? 74 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B C6
            E9 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 41 ?? 2B 01 C1 F8 ?? 89 85 ?? ?? ?? ?? 89 9D ??
            ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 88
            9D ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 8D 85 ??
            ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? F7 D8 1B C0 F7 D0 23 85 ?? ?? ?? ?? 80 38 ?? 75
            ?? 8A 48 ?? 84 C9 74 ?? 80 F9 ?? 75 ?? 38 58 ?? 74 ?? FF B5 ?? ?? ?? ?? FF B5 ?? ??
            ?? ?? 57 50 E8 ?? ?? ?? ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 85 C0 75 ?? 38 9D ?? ?? ?? ??
            74 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 85 ?? ?? ?? ?? 50 56 FF 15
        }

        $encrypt_files_v1 = {
            6A ?? E8 ?? ?? ?? ?? 8B F8 89 BD ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 8B F0 89 B5 ?? ??
            ?? ?? 6A ?? E8 ?? ?? ?? ?? 8B D8 57 E8 ?? ?? ?? ?? 6A ?? 57 56 E8 ?? ?? ?? ?? 8D 4F
            ?? 6A ?? 51 53 E8 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 6A
            ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 8B F8 FF B5 ?? ?? ?? ?? 57 53 56 83 EC ?? 8B F4 89 A5
            ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 50 6A ?? 56 8D 4D ?? E8 ??
            ?? ?? ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 50 C6 45 ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B 85
            ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A
            ?? FF B5 ?? ?? ?? ?? 57 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 6A ?? 8D 85 ?? ?? ??
            ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ??
            ?? ?? E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF B5 ?? ??
            ?? ?? E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8
            ?? ?? ?? ?? 83 C4 ?? C6 45 ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45
            ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 80 BD ?? ?? ?? ?? ??
            74 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4
        }

        $cmd_prompt = {
            8B FF 55 8B EC 83 EC ?? A1 ?? ?? ?? ?? ?? ?? ?? ?? FC 53 56 8B 75 ?? 8D 45 ?? 33 DB
            68 ?? ?? ?? ?? 53 50 89 5D ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? 83 F8 ?? 0F 84 ??
            ?? ?? ?? 85 F6 75 ?? 53 39 5D ?? 75 ?? E8 ?? ?? ?? ?? 59 33 C0 E9 ?? ?? ?? ?? FF 75
            ?? E8 ?? ?? ?? ?? FF 75 ?? 8B F0 E8 ?? ?? ?? ?? 33 C0 83 C4 ?? 85 F6 0F 94 C0 E9 ??
            ?? ?? ?? 8B 45 ?? 89 45 ?? C7 45 ?? ?? ?? ?? ?? 89 75 ?? 89 5D ?? 57 85 C0 74 ?? E8
            ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 53 89 18 8D 45 ?? 50 FF 75 ?? 53 E8 ?? ?? ?? ?? 83
            C4 ?? 8B F0 E8 ?? ?? ?? ?? 83 FE ?? 74 ?? 89 38 EB ?? 83 38 ?? 74 ?? E8 ?? ?? ?? ??
            83 38 ?? 74 ?? 83 CE ?? FF 75 ?? E8 ?? ?? ?? ?? 59 EB ?? E8 ?? ?? ?? ?? 89 38 53 8D
            45 ?? B9 ?? ?? ?? ?? 50 51 53 89 4D ?? E8 ?? ?? ?? ?? FF 75 ?? 8B F0 E8 ?? ?? ?? ??
            83 C4 ?? 8B C6 5F 8B 4D ?? 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 53
        }

        $ldap_connect = {
            C6 45 ?? ?? 8D 45 ?? 83 7D ?? ?? 0F 43 45 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ??
            ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B D8 89 5D ?? C7 45 ?? ?? ?? ?? ?? 8D 45 ??
            50 6A ?? 53 8B 35 ?? ?? ?? ?? FF D6 C7 45 ?? ?? ?? ?? ?? 8D 45 ?? 50 6A ?? 53 FF D6
            6A ?? 53 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 53 FF 15 ?? ?? ?? ?? 83 C4 ??
            85 C0 74 ?? 6A ?? 6A ?? 53 FF 15 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ??
            6A ?? 8D 45 ?? 50 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 83 C4 ??
            8B F0 89 75 ?? 8D 45 ?? 50 8D 45 ?? 50 6A ?? 6A ?? 56 53 FF 15 ?? ?? ?? ?? 83 C4 ??
            85 C0 0F 85 ?? ?? ?? ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? 8B F8 83 C4 ?? 85 FF 0F 84 ??
            ?? ?? ?? FF 75 ?? 57 53 FF 15 ?? ?? ?? ?? 83 C4 ?? 8B F0 85 F6 0F 84 ?? ?? ?? ?? 8B
            06 85 C0 0F 84 ?? ?? ?? ?? 50 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 45 ?? 50 8B 4D
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 36 68 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 83 C4 ?? 8B C8 89 4D ?? 8B 01 8B 40 ?? C6 45 ?? ?? 8B 44 08 ?? 8B 58 ?? 89 5D
            ?? 8B 03 8B CB FF 50 ?? 83 4D ?? ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 10 6A ??
            8B C8 FF 52 ?? 0F B7 C0 89 45 ?? 83 65 ?? ?? C6 45 ?? ?? 85 DB 74 ?? 8B 03 8B CB FF
            50 ?? 8B C8 85 C9 74 ?? 8B 01 6A ?? FF 10 8B 45 ?? 50 8B 4D ?? E8 ?? ?? ?? ?? 8B 4D
            ?? E8 ?? ?? ?? ?? 8B 5D ?? 56 FF 15
        }

        $encrypt_files_v2 = {
            8D 45 ?? 50 6A ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 8B F8 6A ?? 57 53 FF 75 ?? 83 EC ?? 8B
            F4 89 A5 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 50 6A ?? 56 8D 4D
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 50 C6 45 ?? ?? E8 ?? ?? ?? ?? 83 C4
            ?? 8B 45 ?? 89 45 ?? 6A ?? 6A ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? FF 75
            ?? 57 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 6A ?? 8D 45 ?? 50 8D 8D ?? ?? ?? ?? E8
            ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 E8
            ?? ?? ?? ?? FF 75 ?? E8 ?? ?? ?? ?? FF 75 ?? E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8D 85
            ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4
        }

        $encrypt_files_v3 = {
            6A ?? E8 ?? ?? ?? ?? 8B F8 89 BD ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 8B F0 89 B5 ?? ??
            ?? ?? 6A ?? E8 ?? ?? ?? ?? 8B D8 57 E8 ?? ?? ?? ?? 6A ?? 57 56 E8 ?? ?? ?? ?? 8D 4F
            ?? 6A ?? 51 53 E8 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 6A
            ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 8B F8 6A ?? 57 53 56 83 EC ?? 8B F4 89 A5 ?? ?? ?? ??
            6A ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 50 6A ?? 56 8D 4D ?? E8 ?? ?? ?? ?? C6
            45 ?? ?? 8D 85 ?? ?? ?? ?? 50 C6 45 ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B 85 ?? ?? ?? ??
            89 85 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? FF B5 ??
            ?? ?? ?? 57 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 8D 8D
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ??
            ?? ?? ?? 57 E8 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? E8 ??
            ?? ?? ?? 53 E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ??
            83 C4 ?? C6 45 ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? C6 45
            ?? ?? 8D 8D ?? ?? ?? ?? E8
        }

        $encrypt_files_v4 = {
            8D 45 ?? 50 E8 ?? ?? ?? ?? 0F 10 45 ?? 0F 11 45 ?? 0F 10 45 ?? 0F 11 45 ?? 8B 45 ??
            8B 4D ?? 89 45 ?? 89 4D ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 6A ??
            8D 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B F8 56 57 8D 45 ?? 50 8D 45 ?? 50 83 EC ?? 8B
            F4 89 A5 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 50 6A ?? 56 8D 4D
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 50 C6 45 ?? ?? E8 ?? ?? ?? ?? 83 C4
            ?? 8B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 ?? ??
            ?? ?? 6A ?? FF B5 ?? ?? ?? ?? 57 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 6A ?? 8D 85
            ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D
            8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 57 E8 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? EB ?? 8D 85
            ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? C6 45 ?? ?? C6 45 ?? ??
            8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ??
            ?? ?? C6 45 ?? ?? 8B 8D ?? ?? ?? ?? 83 F9 ?? 72 ?? 8D 0C 4D ?? ?? ?? ?? 89 8D ?? ??
            ?? ?? 8B 95 ?? ?? ?? ?? 8B C2 81 F9 ?? ?? ?? ?? 72 ?? 83 C1 ?? 89 8D ?? ?? ?? ?? 8B
            50 ?? 2B C2 83 C0 ?? 83 F8 ?? 0F 87 ?? ?? ?? ?? 51 52 E8 ?? ?? ?? ?? 83 C4 ?? C7 85
            ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 33 C0 66 89 85 ?? ?? FF FF C6
            45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8
        }

        $drop_ransom_note_v1 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 00 A1 ?? ?? ?? ??
            33 C5 89 45 ?? 53 56 57 50 8D 45 ?? 64 A3 ?? ?? ?? ?? ?? ?? ?? ?? 45 FC 00 00 00 00
            6A ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 6A ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ??
            ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 50 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ??
            ?? ?? ?? 83 C4 ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 83
            BD ?? ?? ?? ?? ?? 0F 43 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A
            ?? 6A ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 83
            BD ?? ?? ?? ?? ?? 74 ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ??
            8D 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 43 85 ?? ?? ?? ?? 6A ?? FF B5 ?? ?? ?? ??
            50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ??
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ??
            ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 ?? ?? ??
            ?? ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5
            5D C3
        }

        $exclude_from_encryption_v1 = {
            83 FE ?? 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 4D
            ?? 6A ?? 50 E8 ?? ?? ?? ?? 8B F0 C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 83 FE ?? 0F 85
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 4D ?? 6A ?? 50 E8
            ?? ?? ?? ?? 8B F0 C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 83 FE ?? 0F 85 ?? ?? ?? ?? 68
            ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 4D ?? 6A ?? 50 E8 ?? ?? ?? ?? 8B
            F0 C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 83 FE ?? 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D
            4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 4D ?? 6A ?? 50 E8 ?? ?? ?? ?? 8B F0 C6 45 ?? ??
            8D 4D ?? E8 ?? ?? ?? ?? 83 FE ?? 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ??
            ?? ?? C6 45 ?? ?? 8D 4D ?? 6A ?? 50 E8 ?? ?? ?? ?? 8B F0 C6 45 ?? ?? 8D 4D ?? E8 ??
            ?? ?? ?? 83 FE ?? 75 ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 4D
        }

        $exclude_from_encryption_v2_p1 = {
            50 C6 45 ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50
            E8 ?? ?? ?? ?? 83 C4 ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ??
            ?? ?? 84 C0 0F 84 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 05 ?? ?? ?? ?? 50 8D 4D ?? E8 ?? ??
            ?? ?? C6 45 ?? ?? 8D 45 ?? 50 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 68 ?? ?? ?? ?? 8D
            8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 6A ?? 50 8D 4D ?? E8 ?? ?? ?? ?? 8B F0 C6
            45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 FE ?? 74 ?? C6 45 ?? ?? 8D 4D ?? E8 ??
            ?? ?? ?? C6 45 ?? ?? E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ??
            C6 45 ?? ?? 6A ?? 50 8D 4D ?? E8 ?? ?? ?? ?? 8B F0 C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8
            ?? ?? ?? ?? 83 FE ?? 74 ?? C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? E9 ?? ??
            ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 6A ?? 50 8D 4D ??
            E8 ?? ?? ?? ?? 8B F0 C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 FE ?? 74 ?? C6
        }

        $exclude_from_encryption_v2_p2 = {
            45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ??
            ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 6A ?? 50 8D 4D ?? E8 ?? ?? ?? ?? 8B F0 C6 45 ??
            ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 FE ?? 74 ?? C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ??
            ?? C6 45 ?? ?? E9 ?? ?? ?? ?? 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4
            ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? 51 8B C8 E8 ?? ?? ?? ?? C6 45 ?? ?? 6A ?? 50 8D 4D
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? C6 45 ??
            ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D ?? ?? 74 ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ??
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? C6 45 ?? ?? FF B5 ?? ?? ?? ?? 8D 45 ?? 50 E8 ?? ?? ??
            ?? 83 C4 ?? B9 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 84 C0 0F 44 CA 8D 45 ?? 50 E8 ?? ?? ??
            ?? C7 45 ?? ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 80 BD ?? ?? ??
            ?? ?? 74 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 45 ?? ?? C6 45 ?? ?? 8D 4D
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 4D ?? E8
        }

        $encrypt_files_v5_p1 = {
            50 F2 0F 11 45 ?? FF 15 ?? ?? ?? ?? 8B F0 83 FE ?? 74 ?? 8D 45 ?? 50 56 FF 15 ?? ??
            ?? ?? 85 C0 75 ?? 56 FF 15 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ??
            C6 45 ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 45 ?? ??
            8B 8D ?? ?? ?? ?? 85 C9 74 ?? 8B 01 6A ?? FF 10 C7 45 ?? ?? ?? ?? ?? 8D 4B ?? E8 ??
            ?? ?? ?? 8B 4D ?? 5F 64 89 0D ?? ?? ?? ?? 5E 8B E5 5D 8B E3 5B C2 ?? ?? 8B 7D ?? 83
            C1 ?? 8B 35 ?? ?? ?? ?? 8B 45 ?? E9 ?? ?? ?? ?? 8B 45 ?? 8D 8D ?? ?? ?? ?? 8B 7D ??
            6A ?? 89 45 ?? E8 ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 85 ?? ?? ??
            ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 45 ??
            ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 89 45 ?? 8D 8D ?? ??
            ?? ?? 8D 85 ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 89 45 ?? 83 E0 ?? 03 C1 C7 85 ?? ?? ??
            ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 89 85 ?? ?? ?? ??
            C6 45 ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C6 45 ?? ?? C7 85 ?? ?? ?? ??
            ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ??
            ?? ?? ?? ?? ?? ?? C6 45 ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ??
            ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 45 ?? ?? 6A ??
            E8 ?? ?? ?? ?? 6A ?? 89 45 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ??
            ?? 89 45 ?? C6 45 ?? ?? 6A ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ??
            ?? 83 C4 ?? 89 45 ?? C6 45 ?? ?? B9 ?? ?? ?? ?? 6A ?? FF 75 ?? E8 ?? ?? ?? ?? 6A ??
            FF 75 ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? FF 75 ?? 6A ?? FF 75 ?? 8D 8D ?? ?? ??
            ?? E8 ?? ?? ?? ?? 6A ?? FF 75 ?? FF 75 ?? E8 ?? ?? ?? ?? 8B 45 ?? 6A ?? FF 75 ?? 83
        }

        $encrypt_files_v5_p2 = {
            C0 ?? 50 E8 ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? 85 C0 0F 8F ?? ?? ?? ?? 7C ?? 81 FF ?? ??
            ?? ?? 0F 83 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 45 ?? 0F 57 C0 66 0F 13 45
            ?? 8B 4D ?? 8B 55 ?? 89 4D ?? 8B CF 89 55 ?? 2B 4D ?? 6A ?? 6A ?? 1B C2 50 51 E8 ??
            ?? ?? ?? F2 0F 10 45 ?? 8B CA F2 0F 59 05 ?? ?? ?? ?? 89 4D ?? 8B C8 89 45 ?? F2 0F
            11 45 ?? E8 ?? ?? ?? ?? F2 0F 59 45 ?? E8 ?? ?? ?? ?? 8B C8 0B CA 0F 85 ?? ?? ?? ??
            39 4D ?? 0F 8C ?? ?? ?? ?? 7F ?? 85 FF 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 45 ??
            8D 8D ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C6 45 ?? ?? E9 ?? ?? ?? ?? 85
            C0 0F 8C ?? ?? ?? ?? 7F ?? 81 FF ?? ?? ?? ?? 0F 86 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ??
            ?? 8D 85 ?? ?? ?? ?? 89 45 ?? 8D 8D ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? F2 0F 11 45 ?? 50
            E8 ?? ?? ?? ?? C6 45 ?? ?? 50 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 56 C6 45 ?? ?? 8B 4D
            ?? E8 ?? ?? ?? ?? 8B 45 ?? 33 D2 C7 45 ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 52 50 FF 75 ??
            FF 75 ?? E8 ?? ?? ?? ?? 8B C8 89 45 ?? 0B CA 89 55 ?? 75 ?? 8D 85 ?? ?? ?? ?? 89 45
            ?? 8D 8D ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C6 45 ?? ?? 50 FF 75 ?? 57
            6A ?? 6A ?? 56 C6 45 ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 83 7D ?? ?? 0F 57
            C0 66 0F 13 45 ?? 0F 8C ?? ?? ?? ?? 7F ?? 83 7D ?? ?? 0F 86 ?? ?? ?? ?? 8B 45 ?? 8B
            7D ?? 89 45 ?? 66 66 0F 1F 84 00 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 45 ?? 8D 8D ?? ??
            ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C6 45 ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ??
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ??
            ?? ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 50 8B 45 ?? 8B CF 0F A4 C8 ?? 6A ?? C1 E1 ?? 03
            4D ?? 6A ?? 13 45 ?? 50 51 56 C6 45 ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 03 7D ?? 8B 45 ??
            13 45 ?? 89 45 ?? 3B 45 ?? 0F 8C ?? ?? ?? ?? 7F ?? 3B 7D ?? 0F 82
        }

        $encrypt_files_v6_p1 = {
            E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? 6A ?? 6A ?? C7 85 ?? ?? ?? ?? ?? ?? ??
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 85 F6 0F 8F ?? ?? ?? ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 8D
            8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 6A
            ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85
            ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ??
            8B 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 03 48 ?? 8B 01 FF 50 ?? 83 7B ?? ?? 8D 43 ??
            F2 0F 10 05 ?? ?? ?? ?? 0F 43 43 ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ??
            ?? ?? 50 F2 0F 11 45 ?? FF 15 ?? ?? ?? ?? 8B F8 83 FF ?? 74 ?? 8D 45 ?? 50 57 FF 15
            ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ??
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ??
            ?? ?? C6 45 ?? ?? 8B 8D ?? ?? ?? ?? 85 C9 74 ?? 8B 01 6A ?? FF 10 C6 45 ?? ?? C7 85
            ?? ?? ?? ?? ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 ?? ?? ??
            ?? ?? 8D 4B ?? E8 ?? ?? ?? ?? 8B 4D ?? 5F 64 89 0D ?? ?? ?? ?? 5E 8B E5 5D 8B E3 5B
            C2 ?? ?? 85 F6 0F 84 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 8B CF 76 ?? 8B FE 2B 7D ?? 66
            8B 04 0F 66 3B 01 75 ?? 83 C1 ?? 83 EA ?? 75 ?? 2B 75 ?? D1 FE E9 ?? ?? ?? ?? 8B 7D
            ?? 83 C6 ?? 8B 15 ?? ?? ?? ?? 8B 45 ?? E9 ?? ?? ?? ?? 8B 45 ?? 8D 8D ?? ?? ?? ?? 8B
            75 ?? 6A ?? 89 45 ?? E8 ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 85 ??
            ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6
        }

        $encrypt_files_v6_p2 = {
            45 ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 89 45 ?? 8D 8D
            ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 89 45 ?? 83 E0 ?? 03 C1 C7 85 ??
            ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 89 85 ?? ??
            ?? ?? C6 45 ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C6 45 ?? ?? C7 85 ?? ??
            ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85
            ?? ?? ?? ?? ?? ?? ?? ?? C6 45 ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ??
            ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 45 ?? ??
            6A ?? E8 ?? ?? ?? ?? 6A ?? 89 45 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ??
            ?? ?? ?? 89 45 ?? C6 45 ?? ?? 6A ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ??
            ?? ?? ?? 83 C4 ?? 89 45 ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? 6A ?? FF 75 ?? E8 ?? ?? ??
            ?? 6A ?? FF 75 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? FF 75 ?? 6A ?? FF 75 ?? 8D
            8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? FF 75 ?? FF 75 ?? E8 ?? ?? ?? ?? 8B 45 ?? 6A ??
            FF 75 ?? 83 C0 ?? 50 E8 ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? 85 C0 0F 8F ?? ?? ?? ?? 7C
        }

        $encrypt_files_v6_p3 = {
            81 FE ?? ?? ?? ?? 0F 83 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 45 ?? 0F 57 C0
            66 0F 13 45 ?? 8B 4D ?? 8B 55 ?? 89 4D ?? 8B CE 89 55 ?? 2B 4D ?? 6A ?? 6A ?? 1B C2
            50 51 E8 ?? ?? ?? ?? F2 0F 10 45 ?? 8B CA F2 0F 59 05 ?? ?? ?? ?? 89 4D ?? 8B C8 89
            45 ?? F2 0F 11 45 ?? E8 ?? ?? ?? ?? F2 0F 59 45 ?? E8 ?? ?? ?? ?? 8B C8 0B CA 0F 85
            ?? ?? ?? ?? 39 4D ?? 0F 8C ?? ?? ?? ?? 7F ?? 85 F6 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ??
            ?? 89 45 ?? 8D 8D ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C6 45 ?? ?? E9 ??
            ?? ?? ?? 85 C0 0F 8C ?? ?? ?? ?? 7F ?? 81 FE ?? ?? ?? ?? 0F 86 ?? ?? ?? ?? F2 0F 10
            05 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 89 45 ?? 8D 8D ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? F2 0F
            11 45 ?? 50 E8 ?? ?? ?? ?? C6 45 ?? ?? 50 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 57 C6 45
            ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 8B 45 ?? 33 D2 C7 45 ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 52
            50 FF 75 ?? FF 75 ?? E8 ?? ?? ?? ?? 8B C8 89 45 ?? 0B CA 89 55 ?? 75 ?? 8D 85 ?? ??
            ?? ?? 89 45 ?? 8D 8D ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C6 45 ?? ?? 50
            FF 75 ?? 56 6A ?? 6A ?? 57 C6 45 ?? ?? 8B 4D
        }

        $set_default_icon_p1 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC ?? C7
            45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 33 C0 C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ??
            ?? C7 45 ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66
            89 45 ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D 4D ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ??
            ?? B0 ?? C7 45 ?? ?? ?? ?? ?? 33 C9 C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66 98
            66 31 44 4D ?? 41 83 F9 ?? 73 ?? 8A 45 ?? EB ?? 33 C0 56 66 89 45 ?? C6 45 ?? ?? 8D
            45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 4D ?? 50 8D 45 ?? 50 E8 ?? ?? ?? ?? 8B F0 C7 45
            ?? ?? ?? ?? ?? 6A ?? 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 56 50 C7 45 ?? ?? ?? ?? ?? E8 ??
            ?? ?? ?? 33 C0 C7 46 ?? ?? ?? ?? ?? 83 C4 ?? C7 46 ?? ?? ?? ?? ?? 66 89 06 C7 45 ??
            ?? ?? ?? ?? C6 45 ?? ?? 8B 4D ?? 83 F9 ?? 72 ?? 8B 55 ?? 8D 0C 4D ?? ?? ?? ?? 8B C2
        }

        $set_default_icon_p2 = {
            81 F9 ?? ?? ?? ?? 72 ?? 8B 50 ?? 83 C1 ?? 2B C2 83 C0 ?? 83 F8 ?? 0F 87 ?? ?? ?? ??
            51 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 4D ?? C7 45 ?? ?? ?? ?? ?? 51 8D 4D ?? C7 45 ?? ??
            ?? ?? ?? 51 6A ?? 68 ?? ?? ?? ?? 33 C0 83 7D ?? ?? 6A ?? 66 89 45 ?? 8D 45 ?? 0F 43
            45 ?? 6A ?? 6A ?? 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 83 7D ?? ?? 8D 4D
            ?? 8B 45 ?? 0F 43 4D ?? 03 C0 50 51 6A ?? 6A ?? 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 FF
            75 ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? FF D6 6A
            ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D6 B8 ?? ?? ?? ?? 89 45 ?? 83 E0 ?? 89 45
            ?? C6 45 ?? ?? 8B 4D ?? 5E 83 F9 ?? 72 ?? 8B 55 ?? 8D 0C 4D ?? ?? ?? ?? 8B C2 81 F9
            ?? ?? ?? ?? 72 ?? 8B 50 ?? 83 C1 ?? 2B C2 83 C0 ?? 83 F8 ?? 77 ?? 51 52 E8 ?? ?? ??
            ?? 83 C4 ?? 33 C0 C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66 89 45 ?? C7 45 ?? ??
            ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 8B E5 5D C3
        }

        $find_system_volumes = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 81 EC ?? ??
            ?? ?? 53 56 57 C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 75 ?? C7 06 ?? ?? ?? ??
            C7 46 ?? ?? ?? ?? ?? C7 46 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68
            ?? ?? ?? ?? 50 C7 45 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8B F8 66 90
            8D 45 ?? 50 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ??
            ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 6A ?? 8D 45 ?? 50 6A ?? 6A ?? 6A ?? 6A ?? 8D 85 ??
            ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? F7 45 ?? ?? ?? ?? ?? 0F 85 ??
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 D2 C7 45 ?? ?? ?? ?? ?? 66 89 55 ??
            83 C4 ?? 8D 95 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 0C 00 C7 45 ?? ?? ?? ?? ?? 8D 85
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 03 C1 C7 45 ?? ?? ?? ?? ?? 3B D0 74 ?? D1 F9 8B C2
            51 50 8D 4D ?? E8 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 4D ?? 8B 46 ?? 3B 46 ?? 74 ??
            6A ?? 51 50 C7 00 ?? ?? ?? ?? C7 40 ?? ?? ?? ?? ?? C7 40 ?? ?? ?? ?? ?? E8 ?? ?? ??
            ?? 33 C0 C7 45 ?? ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? 83 46 ?? ?? 66 89 45 ??
            EB ?? 51 50 8B CE E8 ?? ?? ?? ?? C6 45 ?? ?? 8B 4D ?? 83 F9 ?? 72 ?? 8B 55 ?? 8D 0C
            4D ?? ?? ?? ?? 8B C2 81 F9 ?? ?? ?? ?? 72 ?? 8B 50 ?? 83 C1 ?? 2B C2 83 C0 ?? 83 F8
            ?? 77 ?? 51 52 E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ??
            ?? 66 89 45 ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 57 FF D3 85 C0 0F 85 ?? ?? ?? ??
            57 FF 15 ?? ?? ?? ?? 8B 4D ?? 8B C6 5F 5E 5B 64 89 0D ?? ?? ?? ?? 8B E5 5D C3
        }

        $drop_ransom_note_v2_p1 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC ?? 53
            56 57 C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 7D ?? 68 ?? ?? ?? ?? E8 ?? ?? ??
            ?? B9 ?? ?? ?? ?? 8B D8 2B CF 83 C4 ?? 3B CB 0F 82 ?? ?? ?? ?? 83 7D ?? ?? 8D 45 ??
            8D 0C 3B C7 45 ?? ?? ?? ?? ?? 0F 43 45 ?? BE ?? ?? ?? ?? 89 45 ?? 8D 45 ?? C7 45 ??
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 89 4D ?? 89 45 ?? 3B CE 76 ?? 8B F1 83 CE ?? 81 FE
            ?? ?? ?? ?? 76 ?? BE ?? ?? ?? ?? EB ?? B8 ?? ?? ?? ?? 3B F0 0F 42 F0 8D 46 ?? 50 8D
            4D ?? E8 ?? ?? ?? ?? 89 45 ?? 8D 0C 3B 89 45 ?? 89 75 ?? 8D 34 3F 56 FF 75 ?? 89 4D
            ?? 50 E8 ?? ?? ?? ?? 8B 7D ?? 8D 04 1B 50 68 ?? ?? ?? ?? 8D 0C 3E 51 E8 ?? ?? ?? ??
            8B 45 ?? 33 C9 83 C4 ?? C7 45 ?? ?? ?? ?? ?? 66 89 0C 47 C6 45 ?? ?? B8 ?? ?? ?? ??
            83 3D ?? ?? ?? ?? ?? 8D 4D ?? FF 35 ?? ?? ?? ?? 0F 43 05 ?? ?? ?? ?? 50 E8 ?? ?? ??
            ?? 8B F0 C7 45 ?? ?? ?? ?? ?? 6A ?? 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 56 50 C7 45 ?? ??
            ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 C7 46 ?? ?? ?? ?? ?? C7 46 ?? ?? ?? ?? ?? 83 C4 ?? 66
        }

        $drop_ransom_note_v2_p2 = {
            89 06 BE ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 89 75 ?? 83 E6 ?? 89 75 ?? C6 45 ?? ?? 8B
            4D ?? 83 F9 ?? 72 ?? 8B 55 ?? 8D 0C 4D ?? ?? ?? ?? 8B C2 81 F9 ?? ?? ?? ?? 72 ?? 8B
            50 ?? 83 C1 ?? 2B C2 83 C0 ?? 83 F8 ?? 0F 87 ?? ?? ?? ?? 51 52 E8 ?? ?? ?? ?? 83 C4
            ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 33 C0 C7 45 ?? ?? ?? ?? ?? 83 7D ?? ?? 6A ?? 66 89 45
            ?? 8D 45 ?? 0F 43 45 ?? 6A ?? 68 ?? ?? ?? ?? 50 C7 45 ?? ?? ?? ?? ?? FF 15 ?? ?? ??
            ?? 8B F8 83 FF ?? 74 ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ??
            ?? 57 FF 15 ?? ?? ?? ?? 83 E6 ?? 89 75 ?? C6 45 ?? ?? 8B 4D ?? 5F 5E 5B 83 F9 ?? 72
            ?? 8B 55 ?? 8D 0C 4D ?? ?? ?? ?? 8B C2 81 F9 ?? ?? ?? ?? 72 ?? 8B 50 ?? 83 C1 ?? 2B
            C2 83 C0 ?? 83 F8 ?? 77 ?? 51 52 E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 C7 45 ?? ?? ?? ?? ??
            C7 45 ?? ?? ?? ?? ?? 66 89 45 ?? C7 45 ?? ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8B 4D
            ?? 64 89 0D ?? ?? ?? ?? 8B E5 5D C3
        }

        $encrypt_files_v5 = {
            50 FF 15 ?? ?? ?? ?? 8B D8 C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 C3 ?? 74
            ?? C6 45 ?? ?? 80 7D ?? ?? 0F 84 ?? ?? ?? ?? FF 75 ?? E8 ?? ?? ?? ?? 83 C4 ?? E9 ??
            ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 4D ?? E8 ?? ?? ?? ?? C6 45
            ?? ?? 8D 8D ?? ?? ?? ?? 51 8B C8 E8 ?? ?? ?? ?? C6 45 ?? ?? 50 8D 4D ?? E8 ?? ?? ??
            ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? C6 45 ?? ?? 8D 8D ?? ??
            ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D
            ?? ?? ?? ?? 51 8B C8 E8 ?? ?? ?? ?? C6 45 ?? ?? 50 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ??
            ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ??
            ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 8D
            45 ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 6A ?? 6A ?? 8D 8D ?? ?? ?? ??
            E8 ?? ?? ?? ?? 8B F8 83 FF ?? 75 ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9
            ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 43 8D ?? ?? ?? ?? 8B 85 ?? ??
            ?? ?? 8D 0C 41 89 4D ?? 8D 85 ?? ?? ?? ?? 0F 43 85 ?? ?? ?? ?? 89 45 ?? 89 45 ?? 8D
            04 78 89 45 ?? 51 50 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ??
            ?? ?? 8D 45
        }

        $find_system_volumes_v2_p1 = {
            C7 45 ?? ?? ?? ?? ?? 89 7D ?? FF 15 ?? ?? ?? ?? 8B D8 8D 45 ?? 50 68 ?? ?? ?? ?? 8D
            85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 6A
            ?? 6A ?? 8D 45 ?? 50 6A ?? 6A ?? 6A ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ??
            85 C0 0F 84 ?? ?? ?? ?? F7 45 ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50
            E8 ?? ?? ?? ?? 83 C4 ?? 8D 4D ?? 51 8D 8D ?? ?? ?? ?? 8D 04 41 50 8B C1 8D 4D ?? 50
            E8 ?? ?? ?? ?? 8B F0 C6 45 ?? ?? 8B 4D ?? 3B 4D ?? 74 ?? 6A ?? 56 51 C7 01 ?? ?? ??
            ?? C7 41 ?? ?? ?? ?? ?? C7 41 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? C7 46 ?? ?? ??
            ?? ?? C7 46 ?? ?? ?? ?? ?? C6 06 ?? 83 45 ?? ?? EB ?? 56 51 8D 4D ?? E8 ?? ?? ?? ??
            C6 45 ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 53 FF 15 ??
            ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8B 75 ?? 33 C9 89 4D ?? B8 ??
            ?? ?? ?? 8B 4D ?? 2B CE F7 E9 C1 FA ?? 8B C2 C1 E8 ?? 03 C2 0F 84 ?? ?? ?? ?? 33 DB
            8D 4D ?? 8D 04 33 89 4D ?? C6 45 ?? ?? 8D 4D ?? 51 50 8D 45 ?? 50 E8 ?? ?? ?? ?? 83
            C4 ?? 8D 4D ?? 83 CF ?? 89 7D ?? C7 45 ?? ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? C6 45 ??
            ?? 83 E7 ?? 89 7D ?? C6 45 ?? ?? 8D 45 ?? 8B 35 ?? ?? ?? ?? 3B 35 ?? ?? ?? ?? 74 ??
            6A ?? 50 56 89 75 ?? C7 06 ?? ?? ?? ?? C7 46 ?? ?? ?? ?? ?? C7 46 ?? ?? ?? ?? ?? E8
            ?? ?? ?? ?? 33 C0 C7 45 ?? ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? 66 89 45 ?? C6
        }

        $find_system_volumes_v2_p2 = {
            45 ?? ?? 8B 45 ?? 89 46 ?? C6 45 ?? ?? 83 05 ?? ?? ?? ?? ?? EB ?? 50 56 B9 ?? ?? ??
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8B 4D ?? 83 F9 ?? 72 ?? 8B 55 ?? 8D 0C 4D ?? ?? ?? ??
            8B C2 81 F9 ?? ?? ?? ?? 72 ?? 8B 50 ?? 83 C1 ?? 2B C2 83 C0 ?? 83 F8 ?? 0F 87 ?? ??
            ?? ?? 51 52 E8 ?? ?? ?? ?? 83 C4 ?? 8B 4D ?? 33 C0 8B 75 ?? 83 C3 ?? FF 45 ?? 2B CE
            66 89 45 ?? B8 ?? ?? ?? ?? F7 E9 C7 45 ?? ?? ?? ?? ?? C1 FA ?? 8B C2 C7 45 ?? ?? ??
            ?? ?? C1 E8 ?? 03 C2 39 45 ?? 0F 82 ?? ?? ?? ?? 83 E7 ?? 89 7D ?? C7 45 ?? ?? ?? ??
            ?? 8D 4D ?? E8 ?? ?? ?? ?? 5F 5B EB ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 ?? 68 ??
            ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? 8D 4D ?? 6A ?? C7 45 ?? ??
            ?? ?? ?? E8 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 45 ?? 50 B9 ?? ?? ?? ?? E8 ?? ?? ??
            ?? C7 45 ?? ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? F3
            0F 7E 05 ?? ?? ?? ?? 8B F0 2B 75 ?? 66 0F D6 45 ?? 90 8B 55 ?? 8B 4D ?? E8 ?? ?? ??
            ?? 83 3D ?? ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C1 F2 0F 59 C1 F2 0F 59 C1
            F2 0F 11 45 ?? 74 ?? E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 3B C8 74 ?? 6A ?? 51 FF 35 ??
            ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 0F 57 C0 66 0F 13 05 ?? ?? ?? ?? FF 35
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? F2 0F 10 45 ?? 83 EC ?? F2 0F 11 44 24 ?? 66 0F 6E C6
            F3 0F E6 C0 C1 EE
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            (
                (
                    $find_files
                ) and
                (
                    $encrypt_files_v1
                ) and
                (
                    $cmd_prompt
                ) and
                (
                    $exclude_from_encryption_v1
                )
            ) or
            (
                (
                    $find_files
                ) and
                (
                    $cmd_prompt
                ) and
                (
                    $ldap_connect
                ) and
                (
                    $encrypt_files_v2
                ) and
                (
                    $exclude_from_encryption_v1
                )
            ) or
            (
                (
                    $find_files
                ) and
                (
                    $cmd_prompt
                ) and
                (
                    $ldap_connect
                ) and
                (
                    $encrypt_files_v3
                ) and
                (
                    $exclude_from_encryption_v1
                )
            ) or
            (
                (
                    $find_files
                ) and
                (
                    $encrypt_files_v4
                ) and
                (
                    $drop_ransom_note_v1
                ) and
                (
                    all of ($exclude_from_encryption_v2_p*)
                )
            ) or
            (
                (
                    $find_files
                ) and
                (
                    $exclude_from_encryption_v1
                ) and
                (
                    any of ($encrypt_files_v5)
                ) and
                (
                    all of ($find_system_volumes_v2_p*)
                )
            ) or
            (
                (
                    all of ($encrypt_files_v5_p*)
                ) and
                (
                    all of ($set_default_icon_p*)
                ) and
                (
                    $find_system_volumes
                ) and
                (
                    all of ($drop_ransom_note_v2_p*)
                ) and
                (
                    $find_files
                )
            ) or
            (
                (
                    all of ($encrypt_files_v6_p*)
                ) and
                (
                    all of ($set_default_icon_p*)
                ) and
                (
                    all of ($drop_ransom_note_v2_p*)
                ) and
                (
                    $find_files
                )
            )
        )
}