rule Win32_Ransomware_Bam2021 : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "BAM2021"
        description         = "Yara rule that detects Bam2021 ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Bam2021"
        tc_detection_factor = 5

    strings:

        $enum_shares = {
            83 EC ?? 53 55 8B 2D ?? ?? ?? ?? 56 57 68 ?? ?? ?? ?? FF D5 8B 74 24 ?? 6A ?? 56 C7
            44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 8B 4C 24
            ?? 8D 44 24 ?? 50 51 6A ?? 6A ?? 6A ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 89 06 33 C0 5F 5E
            5D 5B 83 C4 ?? C2 ?? ?? 8B 54 24 ?? 52 6A ?? FF 15 ?? ?? ?? ?? 8B F8 89 7C 24 ?? 85
            FF 75 ?? 89 06 8B 44 24 ?? 50 6A ?? 57 E8 ?? ?? ?? ?? 8B 44 24 ?? 83 C4 ?? 8D 4C 24
            ?? 51 57 8D 54 24 ?? 52 50 E8 ?? ?? ?? ?? 8B F0 85 F6 0F 85 ?? ?? ?? ?? 33 DB 39 5C
            24 ?? 76 ?? 8D 77 ?? 90 33 C0 89 44 24 ?? 89 44 24 ?? 89 44 24 ?? 89 44 24 ?? 89 44
            24 ?? 89 44 24 ?? 89 44 24 ?? 89 44 24 ?? 8B 06 50 C7 44 24 ?? ?? ?? ?? ?? 89 44 24
            ?? FF D5 6A ?? 6A ?? 6A ?? 8D 4C 24 ?? 51 E8 ?? ?? ?? ?? 85 C0 75 ?? 8B 3E E8 ?? ??
            ?? ?? 8B 7C 24 ?? 8B 54 24 ?? 6A ?? 6A ?? 52 E8 ?? ?? ?? ?? 8B 46 ?? 83 E0 ?? 3C ??
            75 ?? 8B 4C 24 ?? 8B 44 24 ?? 51 8D 56 ?? 52 50 E8 ?? ?? ?? ?? 43 83 C6 ?? 3B 5C 24
            ?? 0F 82 ?? ?? ?? ?? E9 ?? ?? ?? ?? 81 FE ?? ?? ?? ?? 74 ?? 56 68 ?? ?? ?? ?? E8 ??
            ?? ?? ?? 8B 4C 24 ?? 83 C4 ?? 89 31 57 FF 15 ?? ?? ?? ?? 8B 54 24 ?? 52 E8 ?? ?? ??
            ?? 8B F0 85 F6 74 ?? 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 83 C4 ?? 89 30 33
            C0 5F 5E 5D 5B 83 C4 ?? C2
        }

        $find_files_p1 = {
            8D 94 24 ?? ?? ?? ?? 52 8D 84 24 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 44 24 ?? 83 F8
            ?? 0F 84 ?? ?? ?? ?? 8B 7C 24 ?? EB ?? 8D A4 24 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8D 84 24
            ?? ?? ?? ?? 8D 64 24 ?? 66 8B 10 66 3B 11 75 ?? 66 3B D5 74 ?? 66 8B 50 ?? 66 3B 51
            ?? 75 ?? 83 C0 ?? 83 C1 ?? 66 3B D5 75 ?? 33 C0 EB ?? 1B C0 83 D8 ?? 3B C5 0F 84 ??
            ?? ?? ?? B9 ?? ?? ?? ?? 8D 84 24 ?? ?? ?? ?? 90 66 8B 10 66 3B 11 75 ?? 66 3B D5 74
            ?? 66 8B 50 ?? 66 3B 51 ?? 75 ?? 83 C0 ?? 83 C1 ?? 66 3B D5 75 ?? 33 C0 EB ?? 1B C0
            83 D8 ?? 3B C5 0F 84 ?? ?? ?? ?? F6 84 24 ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8D 8C 24
            ?? ?? ?? ?? 51 BB ?? ?? ?? ?? 8D 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 50 8D 9C 24 ?? ??
            ?? ?? 8D 74 24 ?? C6 84 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 55 8D 8C 24
            ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7C 24 ?? ?? 72 ?? 8B 54 24 ??
            52 E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 C6 84 24 ?? ?? ?? ?? ?? 83 BC 24 ?? ?? ?? ?? ?? C7
            44 24 ?? ?? ?? ?? ?? 89 6C 24 ?? 66 89 44 24 ?? 72 ?? 8B 4C 24 ?? 51 E8 ?? ?? ?? ??
            83 C4 ?? 8B 54 24 ?? 8B 44 24 ?? 42 3B C2 77 ?? 8D 5C 24 ?? E8 ?? ?? ?? ?? 8B 44 24
            ?? 8B 4C 24 ?? 8B 54 24 ?? 8D 34 0A 3B C6 77 ?? 2B F0 8B 44 24 ?? 39 2C B0 75 ?? 6A
            ?? E8 ?? ?? ?? ?? 8B 4C 24 ?? 83 C4 ?? 89 04 B1 8B 54 24 ?? 8B 0C B2 89 4C 24 ?? 89
        }

        $find_files_p2 = {
            4C 24 ?? C6 84 24 ?? ?? ?? ?? ?? 3B CD 74 ?? 33 C0 C7 41 ?? ?? ?? ?? ?? 89 69 ?? 6A
            ?? 66 89 41 ?? 55 8D 84 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 84 24 ?? ?? ?? ?? ?? FF 44
            24 ?? E9 ?? ?? ?? ?? 83 BC 24 ?? ?? ?? ?? ?? 8B 84 24 ?? ?? ?? ?? 73 ?? 8D 84 24 ??
            ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 51 50 68 ?? ?? ?? ?? 6A ?? 8D 94 24 ?? ?? ?? ?? 68 ??
            ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 8D 47 ?? 50 8D 8C 24 ?? ?? ?? ?? 51 FF 15 ?? ??
            ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? BE ?? ?? ?? ?? 8B 16 52 8D 84 24 ??
            ?? ?? ?? 50 FF D3 85 C0 75 ?? 83 C6 ?? 81 FE ?? ?? ?? ?? 7C ?? E9 ?? ?? ?? ?? 57 8D
            8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 83 C0 ?? 8D 94 24 ?? ?? ?? ?? 2B D0 0F
            B7 08 66 89 0C 02 83 C0 ?? 66 3B CD 75 ?? 33 C0 EB ?? 8D A4 24 ?? ?? ?? ?? 8D 49 ??
            0F B7 8C 04 ?? ?? ?? ?? 66 89 8C 04 ?? ?? ?? ?? 83 C0 ?? 66 3B CD 75 ?? 33 C0 8D 9B
            ?? ?? ?? ?? 0F B7 88 ?? ?? ?? ?? 66 89 8C 04 ?? ?? ?? ?? 83 C0 ?? 66 3B CD 75 ?? 8B
            5C 24 ?? 6A ?? B9 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 54 24 ?? 8D 8C
            24 ?? ?? ?? ?? 51 52 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 44 24 ?? 50 FF 15
        }

        $encrypt_files_p1 = {
            55 8B EC 83 E4 ?? 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 81 EC ?? ?? ?? ?? A1 ??
            ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 53 56 57 A1 ?? ?? ?? ?? 33 C4 50 8D 84 24 ?? ??
            ?? ?? 64 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 DB 3B C3 75 ?? 6A ?? E8 ?? ?? ?? ?? 8B F0
            83 C4 ?? 3B F3 74 ?? 68 ?? ?? ?? ?? 8D 46 ?? 6A ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B C6
            EB ?? 33 C0 A3 ?? ?? ?? ?? 8D 4C 24 ?? 51 8B F8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84
            24 ?? ?? ?? ?? 33 D2 53 89 9C 24 ?? ?? ?? ?? 50 66 89 94 24 ?? ?? ?? ?? E8 ?? ?? ??
            ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 33 C9 53 52 66 89 8C 24 ?? ?? ?? ??
            E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 8C 24 ?? ?? ?? ?? 33 C0 53 51 66 89 84 24
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 33 D2 53 50 66 89 54
            24 ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 33 C9 53 52 66 89
            8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 47 ?? 83 C4 ?? 50 89 5C 24 ?? 89 44 24 ?? E8 ??
            ?? ?? ?? 53 53 8D 84 24 ?? ?? ?? ?? 50 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 83 EC ?? 8B
        }

        $encrypt_files_p2 = {
            F4 33 C9 8D 84 24 ?? ?? ?? ?? C7 46 ?? ?? ?? ?? ?? 89 5E ?? 89 64 24 ?? 66 89 4E ??
            8D 50 ?? 90 66 8B 08 83 C0 ?? 66 3B CB 75 ?? 2B C2 D1 F8 50 8D 84 24 ?? ?? ?? ?? E8
            ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 53 6A ?? 8D 94 24 ?? ?? ?? ?? 52 53 FF 15 ?? ?? ?? ??
            85 C0 74 ?? 83 EC ?? 8B F4 33 C0 C7 46 ?? ?? ?? ?? ?? 89 5E ?? 66 89 46 ?? 8D 84 24
            ?? ?? ?? ?? 89 64 24 ?? 8D 50 ?? EB ?? 8D 49 ?? 66 8B 08 83 C0 ?? 66 3B CB 75 ?? 2B
            C2 D1 F8 50 8D 84 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 53 6A ?? 8D 8C 24
            ?? ?? ?? ?? 51 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 83 EC ?? 8B F4 33 D2 C7 46 ?? ?? ??
            ?? ?? 89 5E ?? 8D 84 24 ?? ?? ?? ?? 66 89 56 ?? 89 64 24 ?? 8D 50 ?? EB ?? 8D 49 ??
            66 8B 08 83 C0 ?? 66 3B CB 75 ?? 2B C2 D1 F8 50 8D 84 24 ?? ?? ?? ?? E8 ?? ?? ?? ??
            57 E8 ?? ?? ?? ?? 53 6A ?? 8D 44 24 ?? 50 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 68 ?? ??
            ?? ?? 8D 4C 24 ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 EC ?? 8B F4 33 D2 C7 46 ?? ??
            ?? ?? ?? 89 5E ?? 8D 44 24 ?? 66 89 56 ?? 89 64 24 ?? 8D 50 ?? 8D A4 24 ?? ?? ?? ??
            66 8B 08 83 C0 ?? 66 3B CB 75 ?? 2B C2 D1 F8 50 8D 44 24 ?? E8 ?? ?? ?? ?? 57 E8 ??
            ?? ?? ?? 53 6A ?? 8D 84 24 ?? ?? ?? ?? 50 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 68 ?? ??
            ?? ?? 8D 8C 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 EC ?? 8B F4 33 D2 C7
        }

        $encrypt_files_p3 = {
            46 ?? ?? ?? ?? ?? 89 5E ?? 8D 84 24 ?? ?? ?? ?? 66 89 56 ?? 89 64 24 ?? 8D 50 ?? 90
            66 8B 08 83 C0 ?? 66 3B CB 75 ?? 2B C2 D1 F8 50 8D 84 24 ?? ?? ?? ?? E8 ?? ?? ?? ??
            57 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 8D 44 24 ?? 50 53 6A ?? 53 53 53 68 ?? ?? ?? ??
            68 ?? ?? ?? ?? 89 5C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 8B 4C 24 ?? 51 FF 15 ?? ??
            ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8B F8 53
            57 E8 ?? ?? ?? ?? 8B 74 24 ?? 83 C4 ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 8D 54
            24 ?? 52 57 8B CE E8 ?? ?? ?? ?? 8B 74 24 ?? E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4
            ?? 8D 74 24 ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 50 E8 ??
            ?? ?? ?? 83 C4 ?? 8B 8C 24 ?? ?? ?? ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B 8C 24 ??
            ?? ?? ?? 33 CC E8 ?? ?? ?? ?? 8B E5 5D C3
        }

        $generate_key = {
            50 C7 44 24 ?? ?? ?? ?? ?? F3 A5 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 5F 5E 5D B8 ?? ?? ??
            ?? 5B 8B 4C 24 ?? 33 CC E8 ?? ?? ?? ?? 83 C4 ?? C2 ?? ?? 8B 44 24 ?? 8D 4C 24 ?? 51
            6A ?? 6A ?? 6A ?? 8D 54 24 ?? 52 50 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 5F 5E 5D B8 ?? ??
            ?? ?? 5B 8B 4C 24 ?? 33 CC E8 ?? ?? ?? ?? 83 C4 ?? C2 ?? ?? 8B 54 24 ?? 6A ?? 8D 4C
            24 ?? 51 6A ?? 52 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 5F 5E 5D B8 ?? ?? ?? ?? 5B 8B 4C 24
            ?? 33 CC E8 ?? ?? ?? ?? 83 C4 ?? C2 ?? ?? 8B 54 24 ?? 6A ?? 8D 44 24 ?? 50 8D 4C 24
            ?? 51 6A ?? 52 C7 44 24 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 5F 5E 5D B8 ??
            ?? ?? ?? 5B 8B 4C 24 ?? 33 CC E8 ?? ?? ?? ?? 83 C4 ?? C2 ?? ?? 8B 44 24 ?? C1 E8 ??
            89 44 24 ?? 03 C3 50 E8 ?? ?? ?? ?? 8B F0 83 C4 ?? 85 F6 75 ?? 5F 5E 5D B8 ?? ?? ??
            ?? 5B 8B 4C 24 ?? 33 CC E8 ?? ?? ?? ?? 83 C4 ?? C2 ?? ?? 53 55 56 E8 ?? ?? ?? ?? 8B
            4C 24 ?? 83 C4 ?? 89 5C 24 ?? 83 C3 ?? 53 8D 44 24 ?? 50 56 6A ?? 6A ?? 6A ?? 51 FF
            15 ?? ?? ?? ?? 85 C0 75 ?? 5F 5E 5D B8 ?? ?? ?? ?? 5B 8B 4C 24 ?? 33 CC E8 ?? ?? ??
            ?? 83 C4 ?? C2 ?? ?? 8B 7C 24 ?? 8B 54 24 ?? 57 56 52 E8 ?? ?? ?? ?? 8B 44 24 ?? 56
            89 38 E8 ?? ?? ?? ?? 8B 4C 24 ?? 83 C4 ?? 5F 5E 5D 5B 33 CC 33 C0 E8 ?? ?? ?? ?? 83
            C4 ?? C2
        }

        $remote_connection = {
            81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? 57 8D 44 24 ?? 50 68 ??
            ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 50 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 89 46 ?? 83
            F8 ?? 74 ?? 8B 46 ?? 8D 7E ?? 83 E8 ?? 83 78 ?? ?? 7E ?? 8B 48 ?? 51 8B CF E8 ?? ??
            ?? ?? 8B 3F 57 FF 15 ?? ?? ?? ?? 6A ?? 6A ?? 8D 54 24 ?? 52 89 44 24 ?? FF 15 ?? ??
            ?? ?? 85 C0 75 ?? 8B 46 ?? 50 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C0 5F 8B 8C 24
            ?? ?? ?? ?? 33 CC E8 ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 8B 48 ?? 8B 11 8B 02 0F B7 56
            ?? B9 ?? ?? ?? ?? 52 89 44 24 ?? 66 89 4C 24 ?? FF 15 ?? ?? ?? ?? 8B 4E ?? 66 89 44
            24 ?? 6A ?? 8D 44 24 ?? 50 51 FF 15 ?? ?? ?? ?? 83 F8 ?? 75 ?? FF 15 ?? ?? ?? ?? 8B
            56 ?? 52 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C0 5F 8B 8C 24 ?? ?? ?? ?? 33 CC E8
            ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? C3 8B 8C 24 ?? ?? ?? ?? 5F 33 CC B8 ?? ?? ?? ?? E8 ??
            ?? ?? ?? 81 C4 ?? ?? ?? ?? C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $enum_shares
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            $generate_key
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $remote_connection
        )
}