rule Win32_Ransomware_BadBlock : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "BADBLOCK"
        description         = "Yara rule that detects BadBlock ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "BadBlock"
        tc_detection_factor = 5

    strings:

        $encrypt_files = {
            55 8B EC 83 C4 ?? 53 56 57 33 DB 89 5D ?? 89 5D ?? 89 5D ?? 89 4D ?? 89 55 ?? 8B D8 
            8B 45 ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 ?? 8B 45 ?? 
            8B 40 ?? E8 ?? ?? ?? ?? 8B 55 ?? 8B C3 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 55 
            ?? 8B 45 ?? 8B 40 ?? E8 ?? ?? ?? ?? 8D 45 ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 
            ?? B2 ?? E8 ?? ?? ?? ?? 84 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8D 
            45 ?? 50 E8 ?? ?? ?? ?? 8D 45 ?? 50 6A ?? 6A ?? 68 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? 
            ?? ?? 8D 45 ?? E8 ?? ?? ?? ?? 8B D0 8B 45 ?? 85 C0 74 ?? 83 E8 ?? 8B 00 6A ?? 50 52 
            8B 45 ?? 50 E8 ?? ?? ?? ?? 8D 45 ?? 50 6A ?? 8B 45 ?? 50 68 ?? ?? ?? ?? 8B 45 ?? 50 
            E8 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 
            6A ?? 6A ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? 8B 10 FF 12 89 45 ?? 89 55 ?? E9 ?? ?? 
            ?? ?? 83 7D ?? ?? 75 ?? 81 7D ?? ?? ?? ?? ?? 73 ?? EB ?? 7D ?? 8B 45 ?? 89 45 ?? 8B 
            45 ?? 89 45 ?? EB ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? 8B D8 8B C3 
            E8 ?? ?? ?? ?? 8B F0 8B D6 8B CB 8B 45 ?? 8B 38 FF 57 ?? 89 45 ?? 8B 45 ?? 8B 10 FF 
            12 52 50 8B 45 ?? E8 ?? ?? ?? ?? 3B 54 24 ?? 75 ?? 3B 04 24 5A 58 72 ?? EB ?? 5A 58 
            7C ?? 8B 45 ?? 50 8D 45 ?? 50 56 6A ?? 6A ?? 6A ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? EB ?? 
            8B 45 ?? 50 8D 45 ?? 50 56 6A ?? 6A ?? 6A ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 8B 45 ?? E8 
            ?? ?? ?? ?? 52 50 8B C3 99 29 04 24 19 54 24 ?? 58 5A 52 50 8B 45 ?? E8 ?? ?? ?? ?? 
            8B D6 8B 4D ?? 8B 45 ?? 8B 38 FF 57 ?? 8B C3 99 29 45 ?? 19 55 ?? 8B D3 8B C6 E8 ?? 
            ?? ?? ?? 83 7D ?? ?? 75 ?? 83 7D ?? ?? 0F 87 ?? ?? ?? ?? EB ?? 0F 8F ?? ?? ?? ?? A1 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 B9 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? 8B 
            48 ?? 8D 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D ?? A1 ?? ?? ?? ?? 8B 00 8B 80 ?? 
            ?? ?? ?? 8B 80 ?? ?? ?? ?? BA ?? ?? ?? ?? 8B 18 FF 53 ?? 8B 45 ?? E8 ?? ?? ?? ?? 33 
            C0 5A 59 59 64 89 10 EB ?? E9 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 
            ?? E8 ?? ?? ?? ?? EB ?? 8B 45 ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? 
            ?? 8D 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? 
            EB ?? 5F 5E 5B 8B E5 5D C3 
        }

        $search_files = {
            55 8B EC 81 C4 ?? ?? ?? ?? 53 56 57 33 C9 89 8D ?? ?? ?? ?? 89 8D ?? ?? ?? ?? 89 8D 
            ?? ?? ?? ?? 89 8D ?? ?? ?? ?? 89 55 ?? 89 85 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 
            89 20 B2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8D 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B 
            55 ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 85 C0 0F 94 C3 E9 ?? ?? ?? ?? F6 85 ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B 85 ?? ?? 
            ?? ?? 66 83 38 ?? 0F 84 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? A1 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? A1 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 85 C0 75 ?? B9 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 85 C0 75 ?? B9 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            85 C0 75 ?? 8B 95 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 8D 85 ?? 
            ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8B 0D ?? ?? ?? 
            ?? 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 85 ?? ?? ?? ?? ?? 74 ?? 8B 85 ?? ?? ?? ?? 66 
            83 38 ?? 74 ?? B9 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 
            75 ?? 8D 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 
            8B C6 8B 08 FF 51 ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 94 C3 84 DB 0F 85 ?? 
            ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 8B 10 FF 52 ?? 8B D8 4B 85 DB 7C ?? 
            43 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8B C6 8B 38 FF 
            57 ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8B 85 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? FF 85 ?? ?? ?? ?? 4B 75 ?? 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 
            64 89 10 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? 
            ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 ?? E8 ?? ?? ?? ?? C3 
        }

        $remote_connection = {
            A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? B2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 
            8D 4D ?? 8B 45 ?? 8B 90 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 4D ?? 8D 45 ?? BA ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 ?? 8D 45 ?? E8 ?? ?? ?? ?? 8B 55 ?? 8B 45 ?? 8B 08 FF 
            51 ?? 8B 45 ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 
            05 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 
            89 20 6A ?? 8D 45 ?? 50 8D 4D ?? 8B 15 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 55 ?? 
            8D 45 ?? E8 ?? ?? ?? ?? 8D 45 ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 ?? 8B 4D ?? 
            8B 45 ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B 55 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 
            74 ?? C7 45 ?? ?? ?? ?? ?? 8B 5D ?? 85 DB 74 ?? 83 EB ?? 8B 1B 68 ?? ?? ?? ?? 8B CB 
            BA ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? B9 ?? ?? ?? ?? 
            8B 55 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 8B 45 ?? 8B 90 ?? ?? ?? ?? 8D 45 
            ?? 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? B2 ?? E8 ?? ?? ?? ?? 84 C0 75 ?? 8B 45 
            ?? 8B 90 ?? ?? ?? ?? 8D 45 ?? 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? 
            ?? 8B 75 ?? 85 F6 74 ?? 83 EE ?? 8B 36 68 ?? ?? ?? ?? 8B CE BA ?? ?? ?? ?? 8B 45 ?? 
            E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? B2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 
            59 64 89 10 68 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? C3 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $search_files and
            $encrypt_files and
            $remote_connection
        )
}